/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm;

import java.io.IOException;
import java.io.InputStream;
import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.ClassWriter;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.Label;

public class ClassReader {
    protected final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    private int header;
    static /* synthetic */ Class class$org$logicalcobwebs$asm$ClassReader;

    public ClassReader(byte[] b) {
        this(b, 0, b.length);
    }

    public ClassReader(byte[] b, int off, int len) {
        this.b = b;
        this.items = new int[this.readUnsignedShort(off + 8)];
        this.strings = new String[this.items.length];
        int max = 0;
        int index = off + 10;
        for (int i = 1; i < this.items.length; ++i) {
            int size;
            this.items[i] = index + 1;
            byte tag = b[index];
            switch (tag) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index + 1);
                    max = size > max ? size : max;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index += size;
        }
        this.maxStringLength = max;
        this.header = index;
    }

    public ClassReader(InputStream is) throws IOException {
        this(ClassReader.readClass(is));
    }

    public ClassReader(String name) throws IOException {
        ClassLoader classLoader = (class$org$logicalcobwebs$asm$ClassReader == null ? (class$org$logicalcobwebs$asm$ClassReader = ClassReader.class$("org.logicalcobwebs.asm.ClassReader")) : class$org$logicalcobwebs$asm$ClassReader).getClassLoader() == null ? ClassLoader.getSystemClassLoader() : (class$org$logicalcobwebs$asm$ClassReader == null ? (class$org$logicalcobwebs$asm$ClassReader = ClassReader.class$("org.logicalcobwebs.asm.ClassReader")) : class$org$logicalcobwebs$asm$ClassReader).getClassLoader();
        this(ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    public void accept(ClassVisitor classVisitor, boolean skipDebug) {
        Attribute attr;
        int j;
        int i;
        byte[] b = this.b;
        char[] c = new char[this.maxStringLength];
        int u = this.header;
        int access = this.readUnsignedShort(u);
        String className = this.readClass(u + 2, c);
        int v = this.items[this.readUnsignedShort(u + 4)];
        String superClassName = v == 0 ? null : this.readUTF8(v, c);
        String[] implementedItfs = new String[this.readUnsignedShort(u + 6)];
        String sourceFile = null;
        Attribute clattrs = null;
        int w = 0;
        u += 8;
        for (i = 0; i < implementedItfs.length; ++i) {
            implementedItfs[i] = this.readClass(u, c);
            u += 2;
        }
        v = u;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            String attrName = this.readUTF8(v, c);
            if (attrName.equals("SourceFile")) {
                sourceFile = this.readUTF8(v + 6, c);
            } else if (attrName.equals("Deprecated")) {
                access |= 0x20000;
            } else if (attrName.equals("InnerClasses")) {
                w = v + 6;
            } else {
                attr = this.readAttribute(attrName, v + 6, this.readInt(v + 2), c);
                attr.next = clattrs;
                clattrs = attr;
            }
            v += 6 + this.readInt(v + 2);
            --i;
        }
        classVisitor.visit(access, className, superClassName, implementedItfs, sourceFile);
        if (w != 0) {
            i = this.readUnsignedShort(w);
            w += 2;
            while (i > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(w) == 0 ? null : this.readClass(w, c), this.readUnsignedShort(w + 2) == 0 ? null : this.readClass(w + 2, c), this.readUnsignedShort(w + 4) == 0 ? null : this.readUTF8(w + 4, c), this.readUnsignedShort(w + 6));
                w += 8;
                --i;
            }
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            access = this.readUnsignedShort(u);
            String fieldName = this.readUTF8(u + 2, c);
            String fieldDesc = this.readUTF8(u + 4, c);
            Attribute fattrs = null;
            int fieldValueItem = 0;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                String attrName = this.readUTF8(u, c);
                if (attrName.equals("ConstantValue")) {
                    fieldValueItem = this.readUnsignedShort(u + 6);
                } else if (attrName.equals("Synthetic")) {
                    access |= 0x10000;
                } else if (attrName.equals("Deprecated")) {
                    access |= 0x20000;
                } else {
                    attr = this.readAttribute(attrName, u + 6, this.readInt(u + 2), c);
                    attr.next = fattrs;
                    fattrs = attr;
                }
                u += 6 + this.readInt(u + 2);
                --j;
            }
            Object value = fieldValueItem == 0 ? null : this.readConst(fieldValueItem, c);
            classVisitor.visitField(access, fieldName, fieldDesc, value, fattrs);
            --i;
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            String[] exceptions;
            access = this.readUnsignedShort(u);
            String methName = this.readUTF8(u + 2, c);
            String methDesc = this.readUTF8(u + 4, c);
            Attribute mattrs = null;
            v = 0;
            w = 0;
            j = this.readUnsignedShort(u + 6);
            u += 8;
            while (j > 0) {
                String attrName = this.readUTF8(u, c);
                int attrSize = this.readInt(u += 2);
                u += 4;
                if (attrName.equals("Code")) {
                    v = u;
                } else if (attrName.equals("Exceptions")) {
                    w = u;
                } else if (attrName.equals("Synthetic")) {
                    access |= 0x10000;
                } else if (attrName.equals("Deprecated")) {
                    access |= 0x20000;
                } else {
                    attr = this.readAttribute(attrName, u, attrSize, c);
                    attr.next = mattrs;
                    mattrs = attr;
                }
                u += attrSize;
                --j;
            }
            if (w == 0) {
                exceptions = null;
            } else {
                exceptions = new String[this.readUnsignedShort(w)];
                w += 2;
                for (j = 0; j < exceptions.length; ++j) {
                    exceptions[j] = this.readClass(w, c);
                    w += 2;
                }
            }
            CodeVisitor cv = classVisitor.visitMethod(access, methName, methDesc, exceptions, mattrs);
            if (cv != null && v != 0) {
                int k;
                int label;
                int maxStack = this.readUnsignedShort(v);
                int maxLocals = this.readUnsignedShort(v + 2);
                int codeLength = this.readInt(v + 4);
                Attribute cattrs = null;
                int codeStart = v += 8;
                int codeEnd = v + codeLength;
                Label[] labels = new Label[codeLength + 1];
                block40: while (v < codeEnd) {
                    int opcode = b[v] & 0xFF;
                    switch (ClassWriter.TYPE[opcode]) {
                        case 0: 
                        case 4: {
                            ++v;
                            continue block40;
                        }
                        case 8: {
                            label = v - codeStart + this.readShort(v + 1);
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            v += 3;
                            continue block40;
                        }
                        case 9: {
                            label = v - codeStart + this.readInt(v + 1);
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            v += 5;
                            continue block40;
                        }
                        case 16: {
                            opcode = b[v + 1] & 0xFF;
                            if (opcode == 132) {
                                v += 6;
                                continue block40;
                            }
                            v += 4;
                            continue block40;
                        }
                        case 13: {
                            w = v - codeStart;
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            v += 4;
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            j = this.readInt(v);
                            v += 4;
                            for (j = this.readInt(v += 4) - j + 1; j > 0; --j) {
                                label = w + this.readInt(v);
                                v += 4;
                                if (labels[label] != null) continue;
                                labels[label] = new Label();
                            }
                            continue block40;
                        }
                        case 14: {
                            w = v - codeStart;
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            v += 4;
                            if (labels[label] == null) {
                                labels[label] = new Label();
                            }
                            j = this.readInt(v);
                            v += 4;
                            while (j > 0) {
                                label = w + this.readInt(v += 4);
                                v += 4;
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                --j;
                            }
                            continue block40;
                        }
                        case 1: 
                        case 3: 
                        case 10: {
                            v += 2;
                            continue block40;
                        }
                        case 2: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 12: {
                            v += 3;
                            continue block40;
                        }
                        case 7: {
                            v += 5;
                            continue block40;
                        }
                    }
                    v += 4;
                }
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    label = this.readUnsignedShort(v);
                    if (labels[label] == null) {
                        labels[label] = new Label();
                    }
                    if (labels[label = this.readUnsignedShort(v + 2)] == null) {
                        labels[label] = new Label();
                    }
                    if (labels[label = this.readUnsignedShort(v + 4)] == null) {
                        labels[label] = new Label();
                    }
                    v += 8;
                    --j;
                }
                if (!skipDebug) {
                    j = this.readUnsignedShort(v);
                    v += 2;
                    while (j > 0) {
                        String attrName = this.readUTF8(v, c);
                        if (attrName.equals("LocalVariableTable")) {
                            w = v + 8;
                            for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                label = this.readUnsignedShort(w);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                if (labels[label += this.readUnsignedShort(w + 2)] == null) {
                                    labels[label] = new Label();
                                }
                                w += 10;
                            }
                        } else if (attrName.equals("LineNumberTable")) {
                            w = v + 8;
                            for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                label = this.readUnsignedShort(w);
                                if (labels[label] == null) {
                                    labels[label] = new Label();
                                }
                                w += 4;
                            }
                        } else {
                            attr = this.readAttribute(attrName, v + 6, this.readInt(v + 2), c);
                            attr.next = cattrs;
                            cattrs = attr;
                        }
                        v += 6 + this.readInt(v + 2);
                        --j;
                    }
                }
                v = codeStart;
                block47: while (v < codeEnd) {
                    w = v - codeStart;
                    Label l = labels[w];
                    if (l != null) {
                        cv.visitLabel(l);
                    }
                    int opcode = b[v] & 0xFF;
                    switch (ClassWriter.TYPE[opcode]) {
                        case 0: {
                            cv.visitInsn(opcode);
                            ++v;
                            continue block47;
                        }
                        case 4: {
                            if (opcode > 54) {
                                cv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                            } else {
                                cv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                            }
                            ++v;
                            continue block47;
                        }
                        case 8: {
                            cv.visitJumpInsn(opcode, labels[w + this.readShort(v + 1)]);
                            v += 3;
                            continue block47;
                        }
                        case 9: {
                            cv.visitJumpInsn(opcode, labels[w + this.readInt(v + 1)]);
                            v += 5;
                            continue block47;
                        }
                        case 16: {
                            opcode = b[v + 1] & 0xFF;
                            if (opcode == 132) {
                                cv.visitIincInsn(this.readUnsignedShort(v + 2), this.readShort(v + 4));
                                v += 6;
                                continue block47;
                            }
                            cv.visitVarInsn(opcode, this.readUnsignedShort(v + 2));
                            v += 4;
                            continue block47;
                        }
                        case 13: {
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            int min = this.readInt(v += 4);
                            int max = this.readInt(v += 4);
                            v += 4;
                            Label[] table = new Label[max - min + 1];
                            for (j = 0; j < table.length; ++j) {
                                table[j] = labels[w + this.readInt(v)];
                                v += 4;
                            }
                            cv.visitTableSwitchInsn(min, max, labels[label], table);
                            continue block47;
                        }
                        case 14: {
                            v = v + 4 - (w & 3);
                            label = w + this.readInt(v);
                            j = this.readInt(v += 4);
                            v += 4;
                            int[] keys = new int[j];
                            Label[] values = new Label[j];
                            for (j = 0; j < keys.length; ++j) {
                                keys[j] = this.readInt(v);
                                values[j] = labels[w + this.readInt(v += 4)];
                                v += 4;
                            }
                            cv.visitLookupSwitchInsn(labels[label], keys, values);
                            continue block47;
                        }
                        case 3: {
                            cv.visitVarInsn(opcode, b[v + 1] & 0xFF);
                            v += 2;
                            continue block47;
                        }
                        case 1: {
                            cv.visitIntInsn(opcode, b[v + 1]);
                            v += 2;
                            continue block47;
                        }
                        case 2: {
                            cv.visitIntInsn(opcode, this.readShort(v + 1));
                            v += 3;
                            continue block47;
                        }
                        case 10: {
                            cv.visitLdcInsn(this.readConst(b[v + 1] & 0xFF, c));
                            v += 2;
                            continue block47;
                        }
                        case 11: {
                            cv.visitLdcInsn(this.readConst(this.readUnsignedShort(v + 1), c));
                            v += 3;
                            continue block47;
                        }
                        case 6: 
                        case 7: {
                            int cpIndex = this.items[this.readUnsignedShort(v + 1)];
                            String iowner = this.readClass(cpIndex, c);
                            cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                            String iname = this.readUTF8(cpIndex, c);
                            String idesc = this.readUTF8(cpIndex + 2, c);
                            if (opcode < 182) {
                                cv.visitFieldInsn(opcode, iowner, iname, idesc);
                            } else {
                                cv.visitMethodInsn(opcode, iowner, iname, idesc);
                            }
                            if (opcode == 185) {
                                v += 5;
                                continue block47;
                            }
                            v += 3;
                            continue block47;
                        }
                        case 5: {
                            cv.visitTypeInsn(opcode, this.readClass(v + 1, c));
                            v += 3;
                            continue block47;
                        }
                        case 12: {
                            cv.visitIincInsn(b[v + 1] & 0xFF, b[v + 2]);
                            v += 3;
                            continue block47;
                        }
                    }
                    cv.visitMultiANewArrayInsn(this.readClass(v + 1, c), b[v + 3] & 0xFF);
                    v += 4;
                }
                Label l = labels[codeEnd - codeStart];
                if (l != null) {
                    cv.visitLabel(l);
                }
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    Label start = labels[this.readUnsignedShort(v)];
                    Label end = labels[this.readUnsignedShort(v + 2)];
                    Label handler = labels[this.readUnsignedShort(v + 4)];
                    int type = this.readUnsignedShort(v + 6);
                    if (type == 0) {
                        cv.visitTryCatchBlock(start, end, handler, null);
                    } else {
                        cv.visitTryCatchBlock(start, end, handler, this.readUTF8(this.items[type], c));
                    }
                    v += 8;
                    --j;
                }
                if (!skipDebug) {
                    j = this.readUnsignedShort(v);
                    v += 2;
                    while (j > 0) {
                        String attrName = this.readUTF8(v, c);
                        if (attrName.equals("LocalVariableTable")) {
                            w = v + 8;
                            for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                label = this.readUnsignedShort(w);
                                Label start = labels[label];
                                Label end = labels[label += this.readUnsignedShort(w + 2)];
                                cv.visitLocalVariable(this.readUTF8(w + 4, c), this.readUTF8(w + 6, c), start, end, this.readUnsignedShort(w + 8));
                                w += 10;
                            }
                        } else if (attrName.equals("LineNumberTable")) {
                            w = v + 8;
                            for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                                cv.visitLineNumber(this.readUnsignedShort(w + 2), labels[this.readUnsignedShort(w)]);
                                w += 4;
                            }
                        }
                        v += 6 + this.readInt(v + 2);
                        --j;
                    }
                }
                while (cattrs != null) {
                    cv.visitAttribute(cattrs);
                    cattrs = cattrs.next;
                }
                cv.visitMaxs(maxStack, maxLocals);
            }
            --i;
        }
        while (clattrs != null) {
            classVisitor.visitAttribute(clattrs);
            clattrs = clattrs.next;
        }
        classVisitor.visitEnd();
    }

    protected int readUnsignedShort(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    protected short readShort(int index) {
        byte[] b = this.b;
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    protected int readInt(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    protected long readLong(int index) {
        long l1 = this.readInt(index);
        long l0 = (long)this.readInt(index + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    protected String readUTF8(int index, char[] buf) {
        int item = this.readUnsignedShort(index);
        String s = this.strings[item];
        if (s != null) {
            return s;
        }
        index = this.items[item];
        int utfLen = this.readUnsignedShort(index);
        int endIndex = (index += 2) + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        block4: while (index < endIndex) {
            byte d;
            int c = b[index++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buf[strLen++] = (char)c;
                    continue block4;
                }
                case 12: 
                case 13: {
                    d = b[index++];
                    buf[strLen++] = (char)((c & 0x1F) << 6 | d & 0x3F);
                    continue block4;
                }
            }
            d = b[index++];
            byte e = b[index++];
            buf[strLen++] = (char)((c & 0xF) << 12 | (d & 0x3F) << 6 | e & 0x3F);
        }
        this.strings[item] = s = new String(buf, 0, strLen);
        return s;
    }

    protected String readClass(int index, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index)], buf);
    }

    protected Object readConst(int item, char[] buf) {
        int index = this.items[item];
        switch (this.b[index - 1]) {
            case 3: {
                return new Integer(this.readInt(index));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(index)));
            }
            case 5: {
                return new Long(this.readLong(index));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(index)));
            }
        }
        return this.readUTF8(index, buf);
    }

    protected Attribute readAttribute(String type, int off, int len, char[] buf) {
        return new Attribute(type, this.b, off, len);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

