/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.util.ReversibleOrderedSet;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.OwnableReentrantLock;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.concurrent.locks.containers.OwnableReentrantPerEntryLockContainer;
import org.infinispan.util.concurrent.locks.containers.OwnableReentrantStripedLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantStripedLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;

@MBean(objectName="LockManager", description="Manager that handles MVCC locks for entries")
public class LockManagerImpl
implements LockManager {
    protected Configuration configuration;
    protected LockContainer lockContainer;
    private TransactionManager transactionManager;
    private InvocationContextContainer invocationContextContainer;
    private static final Log log = LogFactory.getLog(LockManagerImpl.class);
    protected static final boolean trace = log.isTraceEnabled();
    private static final String ANOTHER_THREAD = "(another thread)";

    @Inject
    public void injectDependencies(Configuration configuration, TransactionManager transactionManager, InvocationContextContainer invocationContextContainer) {
        this.configuration = configuration;
        this.transactionManager = transactionManager;
        this.invocationContextContainer = invocationContextContainer;
    }

    @Start
    public void startLockManager() {
        this.lockContainer = this.configuration.isUseLockStriping() ? (this.transactionManager == null ? new ReentrantStripedLockContainer(this.configuration.getConcurrencyLevel()) : new OwnableReentrantStripedLockContainer(this.configuration.getConcurrencyLevel(), this.invocationContextContainer)) : (this.transactionManager == null ? new ReentrantPerEntryLockContainer(this.configuration.getConcurrencyLevel()) : new OwnableReentrantPerEntryLockContainer(this.configuration.getConcurrencyLevel(), this.invocationContextContainer));
    }

    @Override
    public boolean lockAndRecord(Object key, InvocationContext ctx) throws InterruptedException {
        long lockTimeout = this.getLockAcquisitionTimeout(ctx);
        if (trace) {
            log.trace((Object)"Attempting to lock {0} with acquisition timeout of {1} millis", key, lockTimeout);
        }
        if (this.lockContainer.acquireLock(key, lockTimeout, TimeUnit.MILLISECONDS) != null) {
            TxInvocationContext tctx;
            if (ctx instanceof TxInvocationContext && !(tctx = (TxInvocationContext)ctx).isRunningTransactionValid()) {
                Transaction tx = tctx.getRunningTransaction();
                log.debug((Object)"Successfully acquired lock, but the transaction {0} is no longer valid!  Releasing lock.", tx);
                this.lockContainer.releaseLock(key);
                throw new IllegalStateException("Transaction " + tx + " appears to no longer be valid!");
            }
            if (trace) {
                log.trace("Successfully acquired lock!");
            }
            return true;
        }
        return false;
    }

    protected long getLockAcquisitionTimeout(InvocationContext ctx) {
        return ctx.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.configuration.getLockAcquisitionTimeout();
    }

    @Override
    public void unlock(Object key) {
        if (trace) {
            log.trace("Attempting to unlock " + key);
        }
        this.lockContainer.releaseLock(key);
    }

    @Override
    public void unlock(InvocationContext ctx) {
        ReversibleOrderedSet<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
        if (!entries.isEmpty()) {
            Iterator<Map.Entry<Object, CacheEntry>> it = entries.reverseIterator();
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                if (!this.possiblyLocked(entry)) continue;
                Object k = e.getKey();
                if (trace) {
                    log.trace("Attempting to unlock " + k);
                }
                this.lockContainer.releaseLock(k);
            }
        }
    }

    @Override
    public boolean ownsLock(Object key, Object owner) {
        return this.lockContainer.ownsLock(key, owner);
    }

    @Override
    public boolean isLocked(Object key) {
        return this.lockContainer.isLocked(key);
    }

    @Override
    public Object getOwner(Object key) {
        if (this.lockContainer.isLocked(key)) {
            Lock l = this.lockContainer.getLock(key);
            if (l instanceof OwnableReentrantLock) {
                return ((OwnableReentrantLock)l).getOwner();
            }
            return ANOTHER_THREAD;
        }
        return null;
    }

    @Override
    public String printLockInfo() {
        return this.lockContainer.toString();
    }

    @Override
    public final boolean possiblyLocked(CacheEntry entry) {
        return entry == null || entry.isChanged() || entry.isNull() || entry.isLockPlaceholder();
    }

    @Override
    public void releaseLocks(InvocationContext ctx) {
        Object owner = ctx.getLockOwner();
        ReversibleOrderedSet<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
        Iterator<Map.Entry<Object, CacheEntry>> it = entries.reverseIterator();
        if (trace) {
            log.trace((Object)"Number of entries in context: {0}", entries.size());
        }
        while (it.hasNext()) {
            Map.Entry<Object, CacheEntry> e = it.next();
            CacheEntry entry = e.getValue();
            Object key = e.getKey();
            boolean needToUnlock = this.possiblyLocked(entry);
            if (entry != null && entry.isChanged()) {
                entry.rollback();
            } else if (trace) {
                log.trace((Object)"Entry for key {0} is null, not calling rollbackUpdate", key);
            }
            if (!needToUnlock) continue;
            if (trace) {
                log.trace("Releasing lock on [" + key + "] for owner " + owner);
            }
            this.unlock(key);
        }
    }

    @ManagedAttribute(description="The concurrency level that the MVCC Lock Manager has been configured with.")
    @Metric(displayName="Concurrency level", dataType=DataType.TRAIT)
    public int getConcurrencyLevel() {
        return this.configuration.getConcurrencyLevel();
    }

    @Override
    @ManagedAttribute(description="The number of exclusive locks that are held.")
    @Metric(displayName="Number of locks held")
    public int getNumberOfLocksHeld() {
        return this.lockContainer.getNumLocksHeld();
    }

    @ManagedAttribute(description="The number of exclusive locks that are available.")
    @Metric(displayName="Number of locks available")
    public int getNumberOfLocksAvailable() {
        return this.lockContainer.size() - this.lockContainer.getNumLocksHeld();
    }
}

