/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.swarmcache.CacheNotification;
import net.sf.swarmcache.Communicator;
import net.sf.swarmcache.JavaGroupsCommunicator;
import net.sf.swarmcache.MultiCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiCacheManager {
    protected static Map instances = new HashMap();
    Log log = LogFactory.getLog(this.getClass());
    public static final String CLEAR_ALL = "(ALL)";
    private HashMap caches = new HashMap();
    private Communicator comm;

    public static synchronized MultiCacheManager getManager(String channelProperties) {
        MultiCacheManager manager = (MultiCacheManager)instances.get(channelProperties);
        if (manager == null) {
            JavaGroupsCommunicator communicator = new JavaGroupsCommunicator(channelProperties);
            manager = new MultiCacheManager(communicator);
            communicator.setManager(manager);
            instances.put(channelProperties, manager);
        }
        return manager;
    }

    public static synchronized void shutDown() {
        if (!instances.isEmpty()) {
            Set keys = instances.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                MultiCacheManager manager = (MultiCacheManager)instances.get(key);
                manager.close();
            }
        }
    }

    public void close() {
        this.comm.shutDown();
    }

    public MultiCacheManager(Communicator comm) {
        this.comm = comm;
    }

    public void addCache(MultiCache cache) {
        this.caches.put(cache.getType(), cache);
    }

    public boolean containsCache(String type) {
        return this.caches.containsKey(type);
    }

    public void sendClear(String type, Serializable key) {
        CacheNotification notification = new CacheNotification(type, key);
        this.log.debug((Object)("Sending a clear to all cache managers: (" + type + ", " + key + ")."));
        this.comm.send(notification);
    }

    public void receiveNotification(CacheNotification notification) {
        MultiCache cache = (MultiCache)this.caches.get(notification.getType());
        if (cache != null) {
            if (notification.getKey() == CLEAR_ALL) {
                this.log.debug((Object)("Received a clear-all: (" + notification.getType() + "."));
                cache.doClearAll();
            } else {
                this.log.debug((Object)("Received a clear: (" + notification.getType() + ", " + notification.getKey() + ")."));
                cache.doClear(notification.getKey());
            }
        } else {
            this.log.debug((Object)("Received info about an object that we do not cache here: " + notification.getType() + "."));
        }
    }
}

