# hledger shell completions

This code generates shell completion scripts for hledger's command line interface.
Context-sensitive completions are usually triggered by pressing the tab key once or twice after typing the command `hledger ` (or `hledger-ui` or `hledger-web`).

## bash completions

An old demo:

[![asciicast](https://asciinema.org/a/227935.svg)](https://asciinema.org/a/227935)

To use hledger's bash shell completions, these must be installed on your system:
- bash
- the [bash-completion](https://salsa.debian.org/debian/bash-completion) package
- hledger's bash completion script
- hledger, hledger-ui, and/or hledger-web

For latest user setup instructions and feature list, please see [Install > Shell completions](https://hledger.org/install.html#shell-completions).

### Generating the bash completions

In the main hledger repo,
first build and install an up-to-date version of hledger in PATH,
then run make to detect its commands and options and generate the `hledger-completion.bash` script.
GNU make and GNU m4 are required.

    stack install hledger
    cd hledger/shell-completion
    make

This is normally done at release time.
The makefile runs `hledger`, `hledger -h`, and `hledger CMD -h` for each command,
to detect (built-in) command names, flag names and flag values,
and it combines these with a stub script to form the final completion script.
You can add `-jNUMPROCS` to make it run faster.

Data from the journal (account names, payee names etc.) is not gathered here;
the script detects those dynamically at completion time.

### Installing the bash completions

(If you want a released version of the completion script, use the Install page link above instead.)

To install the dev completion script, also regenerating it if needed:

    make install

This will copy `hledger-completion.bash` to `$XDG_DATA_HOME/bash-completion/completions/hledger`.
(See bash-completion's docs for other places you can install the script if needed.)
bash will use it when completing command lines beginning with "hledger" or "hledger-ui" or "hledger-web".

You can also just source the script it in your shell startup; this will load completions eagerly, adding a delay to your shell start up time.
Or you can source it in your current bash session for testing.

### Packaging the bash completions

The `hledger-completion.bash` script is available in the `hledger` package tarball on Hackage,
and on Github in the release bindists or at
`https://github.com/simonmichael/hledger/blob/TAG/hledger/shell-completion/hledger-completion.bash`.
(Eg: https://github.com/simonmichael/hledger/blob/1.43/hledger/shell-completion/hledger-completion.bash)

After it has been loaded, this script will provide completions for hledger, hledger-ui and hledger-web.
Note if it is installed only as `hledger`, bash-completion will not load it until the user types `hledger<SPACE><TAB>`.
Consider also symbolic-linking it as `hledger-ui` and `hledger-web`, so that `hledger-ui<SPACE><TAB>` and `hledger-web<SPACE><TAB>` will also load it.

hledger bash completions packaging status as of 1.40:

- Homebrew: includes slightly stale completions, installed as `hledger` only
- Arch Linux AUR: packaging in progress
- Others: unknown

## zsh completions

hledger completions are shipped with zsh: <https://github.com/zsh-users/zsh-completions/blob/master/src/_hledger>.
They may be out of date, please help by updating them.

## fish completions

hledger completions are shipped with fish: <https://github.com/fish-shell/fish-shell/blob/master/share/completions/hledger.fish>
They may be out of date, please help by updating them.

## Creating/updating completion scripts

A rough guide:

1. Create an m4 template for your completion script, eg `hledger-completion.SHELL.m4` where SHELL is the name of the shell.

2. Add a rule in `Makefile` to transform this to `hledger-completion.SHELL`.

3. The current hledger commands, options and command options are listed in
   `commands.txt`, `generic-options.txt`, and `options-*.txt`, generated by the Makefile.
   Use m4 to include these options and commands into `hledger-completion.SHELL.m4`.
   See `hledger-completion.bash.m4` as an example.

4. Use `make` and then `make hledger-completion.SHELL` to generate and test the completion script.

5. Then: add the generated script `hledger-completion.SHELL` to the upstream shell repo, so that it will be easily available to users.
   If that's not possible, add it here for now.
   And if you can, please help to keep it up to date with new hledger releases.
