/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.internal;

import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.internal.Configuration;

public abstract class AbstractConfiguration<S extends AbstractConfiguration<S>>
implements Configuration<S> {
    private PrintWriter out = new PrintWriter(System.out, true);
    private PrintWriter err = new PrintWriter(System.err, true);
    private boolean failOnError;
    private final Set<String> gavs = new TreeSet<String>();
    private final Set<Path> files = new TreeSet<Path>();
    private final Set<URL> urls = new LinkedHashSet<URL>();
    private final Set<String> classpaths = new TreeSet<String>();
    private final Set<Path> directories = new TreeSet<Path>();
    private Path cacheDirectory;
    private Path reportPath;
    private final Set<Format> reportFormats = new TreeSet<Format>();
    private Format outputFormat;

    protected S self() {
        return (S)this;
    }

    @Override
    public PrintWriter getOut() {
        return this.out;
    }

    @Override
    public S withOut(PrintWriter out) {
        this.out = out;
        return this.self();
    }

    @Override
    public PrintWriter getErr() {
        return this.err;
    }

    @Override
    public S withErr(PrintWriter err) {
        this.err = err;
        return this.self();
    }

    @Override
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Override
    public S withFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this.self();
    }

    @Override
    public Set<String> getGavs() {
        return this.gavs;
    }

    @Override
    public S withGav(String gav) {
        this.gavs.add(gav.trim());
        return this.self();
    }

    @Override
    public S withGavs(Set<String> gavs) {
        this.gavs.addAll(gavs);
        return this.self();
    }

    @Override
    public Set<Path> getFiles() {
        return this.files;
    }

    @Override
    public S withFile(Path file) {
        this.files.add(file);
        return this.self();
    }

    @Override
    public S withFiles(Set<Path> files) {
        this.files.addAll(files);
        return this.self();
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    @Override
    public S withUrl(URL url) {
        this.urls.add(url);
        return this.self();
    }

    @Override
    public S withUrls(Set<URL> urls) {
        this.urls.addAll(urls);
        return this.self();
    }

    @Override
    public Set<String> getClasspaths() {
        return this.classpaths;
    }

    @Override
    public S withClasspath(String classpath) {
        this.classpaths.add(classpath);
        return this.self();
    }

    @Override
    public S withClasspaths(Set<String> classpath) {
        this.classpaths.addAll(classpath);
        return this.self();
    }

    @Override
    public Set<Path> getDirectories() {
        return this.directories;
    }

    @Override
    public S withDirectories(Path directory) {
        this.directories.add(directory);
        return this.self();
    }

    @Override
    public S withDirectories(Set<Path> directories) {
        this.directories.addAll(directories);
        return this.self();
    }

    @Override
    public Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    @Override
    public S withCacheDirectory(Path cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
        return this.self();
    }

    @Override
    public Path getReportPath() {
        return this.reportPath;
    }

    @Override
    public S withReportPath(Path reportPath) {
        this.reportPath = reportPath;
        return this.self();
    }

    @Override
    public Set<Format> getReportFormats() {
        return this.reportFormats;
    }

    @Override
    public S withReportFormat(Format reportFormat) {
        this.reportFormats.add(reportFormat);
        return this.self();
    }

    @Override
    public S withReportFormats(Set<Format> reportFormats) {
        this.reportFormats.addAll(reportFormats);
        return this.self();
    }

    @Override
    public Format getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public S withOutputFormat(Format outputFormat) {
        this.outputFormat = outputFormat;
        return this.self();
    }
}

