%define nightly %{nil}
%define release 1
%define _sysconfdir %{_prefix}/etc

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

Name: lalapps
Version: 10.0.1
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LVK Algorithm Library Applications
License: GPLv2+
Source0: https://software.igwn.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRequires: bc
BuildRequires: cfitsio-devel
BuildRequires: fftw-devel
BuildRequires: libframel-devel >= 8.39.2
BuildRequires: gcc
BuildRequires: gsl-devel
BuildRequires: help2man >= 1.37
BuildRequires: less
BuildRequires: liblal-devel >= 7.6.0
BuildRequires: liblalburst-devel >= 2.0.0
BuildRequires: liblalframe-devel >= 3.0.0
BuildRequires: liblalinference-devel >= 4.1.0
BuildRequires: liblalinspiral-devel >= 5.0.0
BuildRequires: liblalmetaio-devel >= 4.0.0
BuildRequires: liblalpulsar-devel >= 7.0.0
BuildRequires: liblalsimulation-devel >= 6.0.0
BuildRequires: libmetaio-devel >= 8.4.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0
BuildRequires: python%{python3_pkgversion}-lal >= 7.6.0
BuildRequires: python%{python3_pkgversion}-lalframe >= 3.0.0
BuildRequires: python%{python3_pkgversion}-lalmetaio >= 4.0.0
BuildRequires: python%{python3_pkgversion}-lalpulsar >= 7.0.0
BuildRequires: python%{python3_pkgversion}-lalsimulation >= 6.0.0
BuildRequires: python%{python3_pkgversion}-lalburst >= 2.0.0
BuildRequires: python%{python3_pkgversion}-lalinspiral >= 5.0.0
BuildRequires: python%{python3_pkgversion}-lalinference >= 4.1.0
BuildRequires: python3-rpm-macros
Requires: lal >= 7.6.0
Requires: lalburst >= 2.0.0
Requires: lalframe >= 3.0.0
Requires: lalinference >= 4.1.0
Requires: lalinspiral >= 5.0.0
Requires: lalmetaio >= 4.0.0
Requires: lalpulsar >= 7.0.0
Requires: lalsimulation >= 6.0.0
Requires: less
Requires: libframel >= 8.39.2
Requires: libmetaio >= 8.4.0
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-h5py
Requires: python%{python3_pkgversion}-lal >= 7.6.0
Requires: python%{python3_pkgversion}-lalframe >= 3.0.0
Requires: python%{python3_pkgversion}-lalmetaio >= 4.0.0
Requires: python%{python3_pkgversion}-lalpulsar >= 7.0.0
Requires: python%{python3_pkgversion}-lalsimulation >= 6.0.0
Requires: python%{python3_pkgversion}-lalburst >= 2.0.0
Requires: python%{python3_pkgversion}-lalinspiral >= 5.0.0
Requires: python%{python3_pkgversion}-lalinference >= 4.1.0
Requires: python%{python3_pkgversion}-ligo-lw >= 1.7.0
Requires: python%{python3_pkgversion}-ligo-segments
Requires: python%{python3_pkgversion}-matplotlib
Requires: python%{python3_pkgversion}-numpy
Requires: python%{python3_pkgversion}-scipy
Requires: python%{python3_pkgversion}-tqdm
Obsoletes: lalxml < 1.2.5-1
Obsoletes: lalxml-debuginfo < 1.2.5-1
Obsoletes: lalxml-devel < 1.2.5-1
Obsoletes: lalxml-python < 1.2.5-1
Obsoletes: lalxml-python3 < 1.2.5-1
Obsoletes: lalxml-octave < 1.2.5-1
Obsoletes: laldetchar < 0.3.6-1
Obsoletes: laldetchar-debuginfo < 0.3.6-1
Obsoletes: laldetchar-devel < 0.3.6-1
Obsoletes: laldetchar-python < 0.3.6-1
Obsoletes: laldetchar-octave < 0.3.6-1
Obsoletes: lalstochastic < 1.1.21-1
Obsoletes: lalstochastic-debuginfo < 1.1.21-1
Obsoletes: lalstochastic-devel < 1.1.21-1
Obsoletes: lalstochastic-python < 1.1.21-1
Obsoletes: lalstochastic-python3 < 1.1.21-1
Obsoletes: lalstochastic-octave < 1.1.21-1
Provides: lalxml = 1.2.5-1
Provides: lalxml-debuginfo = 1.2.5-1
Provides: lalxml-devel = 1.2.5-1
Provides: lalxml-python = 1.2.5-1
Provides: lalxml-python3 = 1.2.5-1
Provides: lalxml-octave = 1.2.5-1
Provides: laldetchar = 0.3.6-1
Provides: laldetchar-debuginfo = 0.3.6-1
Provides: laldetchar-devel = 0.3.6-1
Provides: laldetchar-python = 0.3.6-1
Provides: laldetchar-octave = 0.3.6-1
Provides: lalstochastic = 1.1.21-1
Provides: lalstochastic-debuginfo = 1.1.21-1
Provides: lalstochastic-devel = 1.1.21-1
Provides: lalstochastic-python = 1.1.21-1
Provides: lalstochastic-python3 = 1.1.21-1
Provides: lalstochastic-octave = 1.1.21-1

Prefix: %{_prefix}

%description
The LVK Algorithm Library Applications for gravitational wave data analysis.
This package contains applications that are built on tools in the LVK
Algorithm Library.

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure --disable-gcc-flags --enable-cfitsio PYTHON=%{__python3}
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check
# check python import
env PYTHONPATH="%{buildroot}%{python3_sitearch}" \
%{__python3} -c "import %{name}"

%install
%make_install

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

%files
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_bindir}/*
%{_datadir}/lalapps/*
%{_mandir}/man1/*
%{_sysconfdir}/lalapps-user-env.*
%{python3_sitearch}

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Aug 05 2024 Adam Mercer <adam.mercer@ligo.org> 10.0.1-1
- Update for 10.0.1

* Mon Mar 11 2024 Duncan Macleod <duncan.macleod@ligo.org> 10.0.0-1
- Update for 10.0.0

* Fri Oct 06 2023 Adam Mercer <adam.mercer@ligo.org> 9.2.2-1
- Update for 9.2.2

* Thu Apr 06 2023 Adam Mercer <adam.mercer@ligo.org> 9.2.1-1
- Update for 9.2.1

* Mon Feb 06 2023 Adam Mercer <adam.mercer@ligo.org> 9.2.0-1
- Update for 9.2.0

* Thu Nov 03 2022 Adam Mercer <adam.mercer@ligo.org> 9.1.0-1
- Update for 9.1.0

* Mon Sep 05 2022 Adam Mercer <adam.mercer@ligo.org> 9.0.2-1
- Update for 9.0.2

* Thu Aug 18 2022 Adam Mercer <adam.mercer@ligo.org> 9.0.1-1
- Update for 9.0.1

* Tue Aug 02 2022 Adam Mercer <adam.mercer@ligo.org> 9.0.0-1
- Update fro 9.0.0

* Mon Apr 11 2022 Adam Mercer <adam.mercer@ligo.org> 8.1.1-1
- Update for 8.1.1

* Thu Mar 03 2022 Adam Mercer <adam.mercer@ligo.org> 8.1.0-1
- Update for 8.1.0

* Mon Jan 10 2022 Adam Mercer <adam.mercer@ligo.org> 8.0.0-1
- Update for 8.0.0

* Fri Dec 03 2021 Adam Mercer <adam.mercer@ligo.org> 7.4.0-1
- Update for 7.4.0

* Tue May 25 2021 Adam Mercer <adam.mercer@ligo.org> 7.3.0-1
- Update for 7.3.0

* Fri Feb 05 2021 Adam Mercer <adam.mercer@ligo.org> 7.2.0-1
- Update for 7.2.0

* Mon Jan 11 2021 Adam Mercer <adam.mercer@ligo.org> 7.1.0-1
- Update for 7.1.0

* Wed Oct 28 2020 Adam Mercer <adam.mercer@ligo.org> 7.0.0-1
- Update for 7.0.0

* Wed Aug 19 2020 Adam Mercer <adam.mercer@ligo.org> 6.26.1-1
- Update for 6.26.1

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 6.26.0-1
- Update for 6.26.0

* Mon Jan 13 2020 Adam Mercer <adam.mercer@ligo.org> 6.25.1-1
- MakeSFTs.c: fix incorrect XLAL error checks

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 6.25.0-2
- Packaging updates

* Wed Nov 27 2019 Adam Mercer <adam.mercer@ligo.org> 6.25.0-1
- O3b release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 6.24.0-1
- O3 Release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 6.23.0-1
- ER14 release

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 6.22.0-1
- Pre O3 release

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 6.21.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 6.20.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 6.19.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 6.18.0-1
- Pre O2 packaging test release
