/*
 * LALAppsVCSInfo.h - LALApps VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALAPPSVCSINFOHEADER_H
#define _LALAPPSVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <LALAppsVCSInfo.h>
#include <config.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALAPPS_NAME "LALApps"
#define LALAPPS_VCS_ID "9f5fd96c43ffd65f3f232aad6b317be0c5604e86"
#define LALAPPS_VCS_DATE "2014-11-18 22:15:02 +0000"
#define LALAPPS_VCS_BRANCH "None"
#define LALAPPS_VCS_TAG "lalapps-v6.15.2"
#define LALAPPS_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALAPPS_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALAPPS_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALAPPS_VCS_IDENT_ID "$" "LALAppsId: 9f5fd96c43ffd65f3f232aad6b317be0c5604e86 " "$"
#define LALAPPS_VCS_IDENT_DATE "$" "LALAppsDate: 2014-11-18 22:15:02 +0000 " "$"
#define LALAPPS_VCS_IDENT_BRANCH "$" "LALAppsBranch: None " "$"
#define LALAPPS_VCS_IDENT_TAG "$" "LALAppsTag: lalapps-v6.15.2 " "$"
#define LALAPPS_VCS_IDENT_AUTHOR "$" "LALAppsAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALAPPS_VCS_IDENT_COMMITTER "$" "LALAppsCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALAPPS_VCS_IDENT_STATUS "$" "LALAppsStatus: CLEAN: All modifications committed " "$"

/* header vcs information structure */
static const struct tagLALVCSInfo lalAppsVCSInfoHeader = { \
  LALAPPS_NAME, \
  LALAPPS_VERSION, \
  LALAPPS_VCS_ID, \
  LALAPPS_VCS_DATE, \
  LALAPPS_VCS_BRANCH, \
  LALAPPS_VCS_TAG, \
  LALAPPS_VCS_AUTHOR, \
  LALAPPS_VCS_COMMITTER, \
  LALAPPS_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALAPPSVCSINFOHEADER_H */

/*
 * vim: tw=0 ts=2 et
 */
