%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc
%define _pkgpythondir %{_prefix}/lib64/python2.6/site-packages/lalapps
%define _pkgpyexecdir %{_libdir}/python2.6/site-packages/lalapps

Name: lalapps
Version: 6.17.2
Release: 1
Summary: LSC Algorithm Library Applications
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Duncan Brown <dbrown@ligo.caltech.edu>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: gsl-devel, fftw-devel, libframe-devel, libmetaio-devel
BuildRequires: lal-devel >= 6.15.0
BuildRequires: lal-python >= 6.15.0
BuildRequires: lalframe-devel >= 1.3.0
BuildRequires: lalframe-python >= 1.3.0
BuildRequires: lalmetaio-devel >= 1.2.0
BuildRequires: lalmetaio-python >= 1.2.0
BuildRequires: lalxml-devel >= 1.2.0
BuildRequires: lalxml-python >= 1.2.0
BuildRequires: lalsimulation-devel >= 1.4.0
BuildRequires: lalsimulation-python >= 1.4.0
BuildRequires: lalburst-devel >= 1.4.0
BuildRequires: lalburst-python >= 1.4.0
BuildRequires: lalinspiral-devel >= 1.7.3
BuildRequires: lalinspiral-python >= 1.7.3
BuildRequires: lalstochastic-devel >= 1.1.0
BuildRequires: lalstochastic-python >= 1.1.0
BuildRequires: lalpulsar-devel >= 1.12.0
BuildRequires: lalpulsar-python >= 1.12.0
BuildRequires: lalinference-devel >= 1.5.0
BuildRequires: lalinference-python >= 1.5.0
Requires: healpy, gsl, fftw, libframe, libmetaio, python
Requires: lal >= 6.15.0
Requires: lal-python >= 6.15.0
Requires: lalframe >= 1.3.0
Requires: lalframe-python >= 1.3.0
Requires: lalmetaio >= 1.2.0
Requires: lalmetaio-python >= 1.2.0
Requires: lalxml >= 1.2.0
Requires: lalxml-python >= 1.2.0
Requires: lalsimulation  >= 1.4.0
Requires: lalsimulation-python >= 1.4.0
Requires: lalburst >= 1.4.0
Requires: lalburst-python >= 1.4.0
Requires: lalinspiral >= 1.7.3
Requires: lalinspiral-python >= 1.7.3
Requires: lalstochastic >= 1.1.0
Requires: lalstochastic-python >= 1.1.0
Requires: lalpulsar >= 1.12.0
Requires: lalpulsar-python >= 1.12.0
Requires: lalinference >= 1.5.0
Requires: lalinference-python >= 1.5.0
Prefix: %{_prefix}

%description
The LSC Algorithm Library Applications for gravitational wave data analysis.
This package contains applications that are built on tools in the LSC
Algorithm Library.

%prep
%setup -q

%build
nightly_version=
%configure --enable-nightly=${nightly_version:-no} --disable-gcc-flags --disable-debug
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_bindir}/*
%{_pkgpythondir}/*
%{_mandir}/man1/*
%{_datadir}/lalapps/*
%{_sysconfdir}/lalapps-user-env.*
