%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalinference
Version: 1.5.1
Release: 1
Summary: LSC Algorithm Inference Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: swig, python-devel, octave-devel, chealpix-devel, gsl-devel
BuildRequires: libmetaio-devel, libxml2-devel, numpy, scipy
BuildRequires: lal-devel >= 6.15.0
BuildRequires: lal-python >= 6.15.0
BuildRequires: lal-octave >= 6.15.0
BuildRequires: lalmetaio-devel >= 1.2.0
BuildRequires: lalmetaio-python >= 1.2.0
BuildRequires: lalmetaio-octave >= 1.2.0
BuildRequires: lalxml-devel >= 1.2.0
BuildRequires: lalxml-python >= 1.2.0
BuildRequires: lalxml-octave >= 1.2.0
BuildRequires: lalsimulation-devel >= 1.4.0
BuildRequires: lalsimulation-python >= 1.4.0
BuildRequires: lalsimulation-octave >= 1.4.0
BuildRequires: lalinspiral-devel >= 1.7.0
BuildRequires: lalinspiral-python >= 1.7.0
BuildRequires: lalinspiral-octave >= 1.7.0
BuildRequires: lalpulsar-devel >= 1.12.0
BuildRequires: lalpulsar-python >= 1.12.0
BuildRequires: lalpulsar-octave >= 1.12.0
Requires: chealpix, healpy, gsl >= 1.15, libmetaio, libxml2
Requires: lal >= 6.15.0
Requires: lalmetaio >= 1.2.0
Requires: lalxml >= 1.2.0
Requires: lalsimulation >= 1.4.0
Requires: lalinspiral >= 1.7.0
Requires: lalpulsar >= 1.12.0
Prefix: %{_prefix}

%description
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inference library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inference
Group: LAL
Requires: %{name} = %{version}
Requires: chealpix-devel, gsl-devel >= 1.15, libmetaio-devel, libxml2-devel
Requires: lal-devel >= 6.15.0
Requires: lalmetaio-devel >= 1.2.0
Requires: lalxml-devel >= 1.2.0
Requires: lalsimulation-devel >= 1.4.0
Requires: lalinspiral-devel >= 1.7.0
Requires: lalpulsar-devel >= 1.12.0
%description devel
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inference
library.

%package python
Summary: Python Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: python, numpy, scipy
Requires: lal-python >= 6.15.0
Requires: lalmetaio-python >= 1.2.0
Requires: lalxml-python >= 1.2.0
Requires: lalsimulation-python >= 1.4.0
Requires: lalinspiral-python >= 1.7.0
Requires: lalpulsar-python >= 1.12.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALInference.

%package octave
Summary: Octave Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.15.0
Requires: lalmetaio-octave >= 1.2.0
Requires: lalxml-octave >= 1.2.0
Requires: lalsimulation-octave >= 1.4.0
Requires: lalinspiral-octave >= 1.7.0
Requires: lalpulsar-octave >= 1.12.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALInference.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig --enable-openmp
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_bindir}/bayestar_*
%{_bindir}/rapidpe_*
%{_libdir}/python*/site-packages/lalinference/*.py
%{_libdir}/python*/site-packages/lalinference/*.pyc
%{_libdir}/python*/site-packages/lalinference/bayestar/*.py
%{_libdir}/python*/site-packages/lalinference/bayestar/*.pyc
%{_libdir}/python*/site-packages/lalinference/bayestar/sky_map.so*
%{_libdir}/python*/site-packages/lalinference/cylon.csv
%{_libdir}/python*/site-packages/lalinference/ne_simplified_coastline.json
%{_libdir}/python*/site-packages/lalinference/rapid_pe/*.py
%{_libdir}/python*/site-packages/lalinference/rapid_pe/*.pyc
%{_libdir}/python*/site-packages/lalinference/_lalinference.so*
%exclude %{_libdir}/python*/site-packages/lalinference/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinference/bayestar/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinference/bayestar/*.la
%exclude %{_libdir}/python*/site-packages/lalinference/rapid_pe/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalinference.oct*
