%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalinference
Version: 1.7.0
Release: 1%{?dist}
Summary: LSC Algorithm Inference Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: chealpix-devel
BuildRequires: gsl-devel
BuildRequires: hdf5-devel
BuildRequires: healpy >= 1.8.5
BuildRequires: libmetaio-devel
BuildRequires: libxml2-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: scipy
BuildRequires: swig
BuildRequires: glue >= 1.49.1
BuildRequires: glue-common >= 1.49.1
BuildRequires: glue-segments >= 1.49.1
BuildRequires: lal-devel >= 6.16.1
BuildRequires: lal-python >= 6.16.1
BuildRequires: lal-octave >= 6.16.1
BuildRequires: lalmetaio-devel >= 1.2.8
BuildRequires: lalmetaio-python >= 1.2.8
BuildRequires: lalmetaio-octave >= 1.2.8
BuildRequires: lalxml-devel >= 1.2.2
BuildRequires: lalxml-python >= 1.2.2
BuildRequires: lalxml-octave >= 1.2.2
BuildRequires: lalsimulation-devel >= 1.6.0
BuildRequires: lalsimulation-python >= 1.6.0
BuildRequires: lalsimulation-octave >= 1.6.0
BuildRequires: lalburst-devel >= 1.4.2
BuildRequires: lalburst-python >= 1.4.2
BuildRequires: lalburst-octave >= 1.4.2
BuildRequires: lalinspiral-devel >= 1.7.5
BuildRequires: lalinspiral-python >= 1.7.5
BuildRequires: lalinspiral-octave >= 1.7.5
BuildRequires: lalpulsar-devel >= 1.14.0
BuildRequires: lalpulsar-python >= 1.14.0
BuildRequires: lalpulsar-octave >= 1.14.0
Requires: chealpix
Requires: gsl >= 1.15
Requires: hdf5
Requires: libmetaio
Requires: libxml2
Requires: lal >= 6.16.1
Requires: lalmetaio >= 1.2.8
Requires: lalxml >= 1.2.2
Requires: lalsimulation >= 1.6.0
Requires: lalburst >= 1.4.2
Requires: lalinspiral >= 1.7.5
Requires: lalpulsar >= 1.14.0
Prefix: %{_prefix}

%description
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inference library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inference
Group: LAL
Requires: %{name} = %{version}
Requires: chealpix-devel
Requires: gsl-devel >= 1.15
Requires: libmetaio-devel
Requires: libxml2-devel
Requires: lal-devel >= 6.16.1
Requires: lalmetaio-devel >= 1.2.8
Requires: lalxml-devel >= 1.2.2
Requires: lalsimulation-devel >= 1.6.0
Requires: lalburst-devel >= 1.4.2
Requires: lalinspiral-devel >= 1.7.5
Requires: lalpulsar-devel >= 1.14.0
%description devel
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inference
library.

%package python
Summary: Python Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: healpy
Requires: numpy
Requires: python
Requires: scipy
Requires: python-six
Requires: glue >= 1.49.1
Requires: glue-common >= 1.49.1
Requires: glue-segments >= 1.49.1
Requires: lal-python >= 6.16.1
Requires: lalmetaio-python >= 1.2.8
Requires: lalxml-python >= 1.2.2
Requires: lalsimulation-python >= 1.6.0
Requires: lalburst-python >= 1.4.2
Requires: lalinspiral-python >= 1.7.5
Requires: lalpulsar-python >= 1.14.0
%description python
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python bindings for LALInference.

%package octave
Summary: Octave Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.16.1
Requires: lalmetaio-octave >= 1.2.8
Requires: lalxml-octave >= 1.2.2
Requires: lalsimulation-octave >= 1.6.0
Requires: lalburst-octave >= 1.4.2
Requires: lalinspiral-octave >= 1.7.5
Requires: lalpulsar-octave >= 1.14.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALInference.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig --enable-openmp
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*
%{_datarootdir}/lalinference/*.csv
%{_bindir}/lalinference_*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_bindir}/bayestar_*
%{_bindir}/rapidpe_*
%{_libdir}/python*/site-packages/lalinference/*.py
%{_libdir}/python*/site-packages/lalinference/*.pyc
%{_libdir}/python*/site-packages/lalinference/bayestar/*.py
%{_libdir}/python*/site-packages/lalinference/bayestar/*.pyc
%{_libdir}/python*/site-packages/lalinference/bayestar/sky_map.so*
%{_libdir}/python*/site-packages/lalinference/cylon.csv
%{_libdir}/python*/site-packages/lalinference/imrtgr/*.py
%{_libdir}/python*/site-packages/lalinference/imrtgr/*.pyc
%{_libdir}/python*/site-packages/lalinference/ne_simplified_coastline.json
%{_libdir}/python*/site-packages/lalinference/rapid_pe/*.py
%{_libdir}/python*/site-packages/lalinference/rapid_pe/*.pyc
%{_libdir}/python*/site-packages/lalinference/_lalinference.so*
%exclude %{_libdir}/python*/site-packages/lalinference/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinference/bayestar/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinference/bayestar/*.la
%exclude %{_libdir}/python*/site-packages/lalinference/imrtgr/*.pyo
%exclude %{_libdir}/python*/site-packages/lalinference/rapid_pe/*.pyo

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalinference.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- Pre O2 packaging test release
