%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts --enable-openmp --enable-mpi MPICC=/usr/lib64/openmpi/bin/mpicc

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalinference
Version: 2.0.3
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Inference Library
License: GPLv2+
Group: LAL
Source0: http://software.ligo.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: help2man
BuildRequires: lal-devel >= 7.0.0
BuildRequires: lalframe-devel >= 1.5.0
BuildRequires: lalmetaio-devel >= 1.6.0
BuildRequires: lalsimulation-devel >= 2.1.0
BuildRequires: lalburst-devel >= 1.5.3
BuildRequires: lalinspiral-devel >= 1.10.0
BuildRequires: lalpulsar-devel >= 2.0.0
BuildRequires: make
BuildRequires: openmpi-devel
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.9

# python2
BuildRequires: python2-rpm-macros
BuildRequires: python
BuildRequires: python-devel
BuildRequires: python2-astropy >= 1.1.1
BuildRequires: python2-glue >= 1.54.1
BuildRequires: python2-gwdatafind
BuildRequires: python2-gwpy
BuildRequires: healpy >= 1.9.1
BuildRequires: python2-h5py
BuildRequires: python2-lal >= 7.0.0
BuildRequires: python2-lalmetaio >= 1.6.0
BuildRequires: python2-lalsimulation >= 2.1.0
BuildRequires: python2-lalburst >= 1.5.3
BuildRequires: python2-lalinspiral >= 1.10.0
BuildRequires: python2-lalpulsar >= 2.0.0
BuildRequires: python2-matplotlib >= 1.2.0
BuildRequires: python2-mock
BuildRequires: python2-numpy >= 1.7
BuildRequires: python-pathlib
BuildRequires: pytest
BuildRequires: python2-scipy >= 0.9.0

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-astropy >= 1.1.1
BuildRequires: python%{python3_pkgversion}-gwdatafind
BuildRequires: python%{python3_pkgversion}-gwpy
BuildRequires: python%{python3_pkgversion}-glue >= 1.54.1
BuildRequires: python%{python3_pkgversion}-healpy >= 1.9.1
BuildRequires: python%{python3_pkgversion}-h5py
BuildRequires: python%{python3_pkgversion}-lal >= 7.0.0
BuildRequires: python%{python3_pkgversion}-lalmetaio >= 1.6.0
BuildRequires: python%{python3_pkgversion}-lalsimulation >= 2.1.0
BuildRequires: python%{python3_pkgversion}-lalburst >= 1.5.3
BuildRequires: python%{python3_pkgversion}-lalinspiral >= 1.10.0
BuildRequires: python%{python3_pkgversion}-lalpulsar >= 2.0.0
BuildRequires: python%{python3_pkgversion}-matplotlib >= 1.2.0
BuildRequires: python%{python3_pkgversion}-numpy >= 1.7
BuildRequires: python%{python3_pkgversion}-pytest
BuildRequires: python%{python3_pkgversion}-scipy >= 0.9.0

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.0.0
BuildRequires: lalframe-octave >= 1.5.0
BuildRequires: lalmetaio-octave >= 1.6.0
BuildRequires: lalsimulation-octave >= 2.1.0
BuildRequires: lalburst-octave >= 1.5.3
BuildRequires: lalinspiral-octave >= 1.10.0
BuildRequires: lalpulsar-octave >= 2.0.0

# -- packages ---------------

# lalinference
Requires: gsl >= 1.15
Requires: openmpi
Requires: openssh-clients
Requires: lal >= 7.0.0
Requires: lalframe >= 1.5.0
Requires: lalmetaio >= 1.6.0
Requires: lalsimulation >= 2.1.0
Requires: lalburst >= 1.5.3
Requires: lalinspiral >= 1.10.0
Requires: lalpulsar >= 2.0.0

%description
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Inference library.

# lalinference-devel
%package devel
Summary: Files and documentation needed for compiling programs that use LAL Inference
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel >= 1.15
Requires: lal-devel >= 7.0.0
Requires: lalframe-devel >= 1.5.0
Requires: lalmetaio-devel >= 1.6.0
Requires: lalsimulation-devel >= 2.1.0
Requires: lalburst-devel >= 1.5.3
Requires: lalinspiral-devel >= 1.10.0
Requires: lalpulsar-devel >= 2.0.0
%description devel
The LSC Algorithm Inference Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Inference
library.

# python2-lalinference
%package -n python2-%{name}
Summary: Python %{python2_version} Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: healpy >= 1.9.1
Requires: python
Requires: python2-astropy >= 1.1.1
Requires: python2-glue >= 1.54.1
Requires: python2-gwdatafind
Requires: python2-gwpy
Requires: python2-h5py
Requires: python2-lal >= 7.0.0
Requires: python2-lalmetaio >= 1.6.0
Requires: python2-lalsimulation >= 2.1.0
Requires: python2-lalburst >= 1.5.3
Requires: python2-lalinspiral >= 1.10.0
Requires: python2-lalpulsar >= 2.0.0
Requires: python2-ligo-gracedb
Requires: python2-matplotlib >= 1.2.0
Requires: python2-numpy >= 1.7
Requires: python2-scipy >= 0.8
Requires: python2-six
Provides: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-python < %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}}
%description -n python2-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python2_version} bindings for LALInference.

# python3x-lalinference
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version_version} Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-astropy >= 1.1.1
Requires: python%{python3_pkgversion}-glue >= 1.54.1
Requires: python%{python3_pkgversion}-gwdatafind
Requires: python%{python3_pkgversion}-gwpy
Requires: python%{python3_pkgversion}-healpy >= 1.9.1
Requires: python%{python3_pkgversion}-h5py
Requires: python%{python3_pkgversion}-lal >= 7.0.0
Requires: python%{python3_pkgversion}-lalmetaio >= 1.6.0
Requires: python%{python3_pkgversion}-lalsimulation >= 2.1.0
Requires: python%{python3_pkgversion}-lalburst >= 1.5.3
Requires: python%{python3_pkgversion}-lalinspiral >= 1.10.0
Requires: python%{python3_pkgversion}-lalpulsar >= 2.0.0
Requires: python%{python3_pkgversion}-ligo-gracedb
Requires: python%{python3_pkgversion}-matplotlib >= 1.2.0
Requires: python%{python3_pkgversion}-numpy >= 1.7
Requires: python%{python3_pkgversion}-scipy >= 0.8
Requires: python%{python3_pkgversion}-six
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Python %{python3_version} bindings for LALInference.

# lalinference-octave
%package octave
Summary: Octave Bindings for LALInference
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 7.0.0
Requires: lalframe-octave >= 1.5.0
Requires: lalmetaio-octave >= 1.6.0
Requires: lalsimulation-octave >= 2.1.0
Requires: lalburst-octave >= 1.5.3
Requires: lalinspiral-octave >= 1.10.0
Requires: lalpulsar-octave >= 2.0.0
%description octave
The LSC Algorithm Library for gravitational wave data analysis.
This package provides the Octave bindings for LALInference.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
# build C library with python2
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python2}
%{__make} %{?_smp_mflags} V=1

# build python3 library (copy things so we don't have to rebuild them)
rm -rf %py3dir
cp -r . %py3dir
pushd %py3dir
rm -rfv python/%{name}/*.{la,lo,o} python/%{name}/.libs
%configure %{configure_opts} --disable-doxygen --disable-gcc-flags --disable-swig-octave --enable-swig-python PYTHON=%{__python3}
%{__make} V=1 -C swig
%{__make} V=1 -C python/%{name}
popd

%check
# C + python2 + octave
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check
# python3
[ -d %py3dir/test/python ] && %{__make} %{?_smp_mflags} V=1 VERBOSE=1 -C %py3dir -C test/python check

%install
# C + python2 + octave
%make_install
# python3
%{__make} -C %py3dir -C swig install-exec-am DESTDIR=%{?buildroot}
%{__make} -C %py3dir -C python/%{name} install DESTDIR=%{?buildroot}
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lalinference_bench
%{_bindir}/lalinference_burst
%{_bindir}/lalinference_datadump
%{_bindir}/lalinference_injectedlike
%{_bindir}/lalinference_kombine
%{_bindir}/lalinference_mcmc
%{_bindir}/lalinference_nest
%{_bindir}/lalinference_version
%{_bindir}/lalinference_mpi_wrapper
%{_datarootdir}/lalinference/*
%{_libdir}/*.so.*
%{_mandir}/man1/lalinference_bench.1*
%{_mandir}/man1/lalinference_burst.1*
%{_mandir}/man1/lalinference_datadump.1*
%{_mandir}/man1/lalinference_injectedlike.1*
%{_mandir}/man1/lalinference_kombine.1*
%{_mandir}/man1/lalinference_mcmc.1*
%{_mandir}/man1/lalinference_nest.1*
%{_mandir}/man1/lalinference_version.1*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{_bindir}/cbcBayes*
%{_bindir}/imrtgr_*
%{_bindir}/lalinference_burst_pp_pipe
%{_bindir}/lalinference_coherence_test
%{_bindir}/lalinference_compute_roq_weights
%{_bindir}/lalinference_cpnest
%{_bindir}/lalinference_evolve_spins_and_append_samples
%{_bindir}/lalinference_merge_posteriors
%{_bindir}/lalinference_multi_pipe
%{_bindir}/lalinference_nest2pos
%{_bindir}/lalinference_pipe
%{_bindir}/lalinference_pp_pipe
%{_bindir}/lalinference_review_test
%{_mandir}/man1/cbcBayes*.1*
%{_mandir}/man1/imrtgr_*.1*
%{_mandir}/man1/lalinference_burst_pp_pipe.1*
%{_mandir}/man1/lalinference_coherence_test.1*
%{_mandir}/man1/lalinference_compute_roq_weights.1*
%{_mandir}/man1/lalinference_cpnest.1*
%{_mandir}/man1/lalinference_evolve_spins_and_append_samples.1*
%{_mandir}/man1/lalinference_merge_posteriors.1*
%{_mandir}/man1/lalinference_multi_pipe.1*
%{_mandir}/man1/lalinference_nest2pos.1*
%{_mandir}/man1/lalinference_pipe.1*
%{_mandir}/man1/lalinference_pp_pipe.1*
%{_mandir}/man1/lalinference_review_test.1*
%{python2_sitearch}/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalinference.oct*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Wed Aug 05 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.3-1
- Update for 2.0.3

* Wed Jul 08 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.2-1
- Update for 2.0.2

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 2.0.1-1
- Update for 2.0.1

* Wed Mar 25 2020 Duncan Macleod <duncan.macleod@ligo.org> 2.0.0-1
- Update for 2.0.0

* Fri Feb 21 2020 Adam Mercer <adam.mercer@ligo.org> 1.11.7-1
- O3b point release

* Thu Feb 13 2020 Adam Mercer <adam.mercer@ligo.org> 1.11.6-2
- O3b point release

* Tue Dec 17 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.5-1
- O3b point release

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.4-2
- Packaging updates

* Wed Nov 27 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.4-1
- O3b release

* Thu Jul 18 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.3-1
- O3 point release

* Thu Jul 11 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.2-1
- O3 point release

* Fri Jun 21 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.1-1
- O3 point release

* Tue May 21 2019 Adam Mercer <adam.mercer@ligo.org> 1.11.0-1
- O3 point release

* Wed May 01 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.3-1
- O3 point release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.2-1
- ER14 release

* Tue Jan 22 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.1-1
- Fix spin2 prior

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.10.0-1
- Pre O3 release

* Thu Jul 27 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.4-1
- bayestar_plot_volume: work around broken fonts in SL7

* Wed Jul 26 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.3-1
- BAYESTAR and sky map post-processing updates

* Thu Mar 16 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.2-1
- lalinference.io.fits: remove some redundant keys on reading
- lalinference.io.fits: fix writing single-column sky maps

* Sat Feb 18 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.1-1
- Do not use $(..._la_LIBADD) to link against external libraries
- Track version info API change
- Fix to weights calculation so that posterior samples are now drawn correctly
- Fix incorrect axes limits for Mollweide sky maps
- Drop code for reading past EOF of named pipe
- Fix incorrect reordering of IDL-compatible sky maps
- Tune default max distance for volume rendering plots

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.9.0-1
- O2 release

* Thu Dec 15 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.2-1
- Be more emphatic about switching matplotlib backend
- Prevent trying to build python3 packages when unsupported

* Fri Dec 09 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.1-1
- Explicitly set no-op Matplotlib backend
- Set matplotlib backend to no-op

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.8.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.7.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- Pre O2 packaging test release
