/*
 * LALSimulationVCSInfo.c - LALSimulation VCS Information
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014, 2016 Karl Wette
 */

#include <stdlib.h>
#include <config.h>

#include <lal/LALVCSInfoType.h>
#include <lal/XLALError.h>

#if defined(HAVE_LIBLAL)
#include <lal/LALVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALFRAME)
#include <lal/LALFrameVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALMETAIO)
#include <lal/LALMetaIOVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALXML)
#include <lal/LALXMLVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALSIMULATION)
#include <lal/LALSimulationVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALBURST)
#include <lal/LALBurstVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALDETCHAR)
#include <lal/LALDetCharVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALINSPIRAL)
#include <lal/LALInspiralVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALPULSAR)
#include <lal/LALPulsarVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALINFERENCE)
#include <lal/LALInferenceVCSInfoHeader.h>
#endif
#if defined(HAVE_LIBLALSTOCHASTIC)
#include <lal/LALStochasticVCSInfoHeader.h>
#endif

#include "LALSimulationVCSInfoHeader.h"

/* global variables for vcs information */
const char *const lalSimulationVCSVersion = LALSIMULATION_VERSION;
const char *const lalSimulationVCSId = LALSIMULATION_VCS_ID;
const char *const lalSimulationVCSDate = LALSIMULATION_VCS_DATE;
const char *const lalSimulationVCSBranch = LALSIMULATION_VCS_BRANCH;
const char *const lalSimulationVCSTag = LALSIMULATION_VCS_TAG;
const char *const lalSimulationVCSAuthor = LALSIMULATION_VCS_AUTHOR;
const char *const lalSimulationVCSCommitter = LALSIMULATION_VCS_COMMITTER;
const char *const lalSimulationVCSStatus = LALSIMULATION_VCS_STATUS;

/* global variables for vcs information - identable */
const char *const lalSimulationVCSIdentId = LALSIMULATION_VCS_IDENT_ID;
const char *const lalSimulationVCSIdentDate = LALSIMULATION_VCS_IDENT_DATE;
const char *const lalSimulationVCSIdentBranch = LALSIMULATION_VCS_IDENT_BRANCH;
const char *const lalSimulationVCSIdentTag = LALSIMULATION_VCS_IDENT_TAG;
const char *const lalSimulationVCSIdentAuthor = LALSIMULATION_VCS_IDENT_AUTHOR;
const char *const lalSimulationVCSIdentCommitter = LALSIMULATION_VCS_IDENT_COMMITTER;
const char *const lalSimulationVCSIdentStatus = LALSIMULATION_VCS_IDENT_STATUS;

/* library vcs information structure */
const struct tagLALVCSInfo lalSimulationVCSInfo = { \
  LALSIMULATION_NAME, \
  LALSIMULATION_VERSION, \
  LALSIMULATION_VCS_ID, \
  LALSIMULATION_VCS_DATE, \
  LALSIMULATION_VCS_BRANCH, \
  LALSIMULATION_VCS_TAG, \
  LALSIMULATION_VCS_AUTHOR, \
  LALSIMULATION_VCS_COMMITTER, \
  LALSIMULATION_VCS_STATUS \
};

const LALVCSInfo *const lalSimulationVCSInfoList[32] = {
#if defined(HAVE_LIBLAL)
  &lalVCSInfo,
#endif
#if defined(HAVE_LIBLALFRAME)
  &lalFrameVCSInfo,
#endif
#if defined(HAVE_LIBLALMETAIO)
  &lalMetaIOVCSInfo,
#endif
#if defined(HAVE_LIBLALXML)
  &lalXMLVCSInfo,
#endif
#if defined(HAVE_LIBLALSIMULATION)
  &lalSimulationVCSInfo,
#endif
#if defined(HAVE_LIBLALBURST)
  &lalBurstVCSInfo,
#endif
#if defined(HAVE_LIBLALDETCHAR)
  &lalDetCharVCSInfo,
#endif
#if defined(HAVE_LIBLALINSPIRAL)
  &lalInspiralVCSInfo,
#endif
#if defined(HAVE_LIBLALPULSAR)
  &lalPulsarVCSInfo,
#endif
#if defined(HAVE_LIBLALINFERENCE)
  &lalInferenceVCSInfo,
#endif
#if defined(HAVE_LIBLALSTOCHASTIC)
  &lalStochasticVCSInfo,
#endif
  &lalSimulationVCSInfo,
  NULL
};

int XLALSimulationVCSInfoCheck(void)
{
#define VCS_INFO_CHECK(vcsinfo) \
  do { \
    if (XLALVCSInfoCompare(&vcsinfo##Header, &vcsinfo) != 0) { \
      XLALPrintError("%s: FATAL: version mismatch between compile-time (%s) and run-time (%s) %s library\n", \
                     __func__, vcsinfo##Header.vcsId, vcsinfo.vcsId, vcsinfo.name); \
      XLALPrintError("This indicates a potential compilation problem: ensure your setup is consistent and recompile.\n"); \
      XLAL_ERROR(XLAL_EERR); \
    } \
  } while (0)

#if defined(HAVE_LIBLAL) && (LAL_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalVCSInfo);
#endif
#if defined(HAVE_LIBLALFRAME) && (LALFRAME_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalFrameVCSInfo);
#endif
#if defined(HAVE_LIBLALMETAIO) && (LALMETAIO_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalMetaIOVCSInfo);
#endif
#if defined(HAVE_LIBLALXML) && (LALXML_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalXMLVCSInfo);
#endif
#if defined(HAVE_LIBLALSIMULATION) && (LALSIMULATION_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalSimulationVCSInfo);
#endif
#if defined(HAVE_LIBLALBURST) && (LALBURST_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalBurstVCSInfo);
#endif
#if defined(HAVE_LIBLALDETCHAR) && (LALDETCHAR_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalDetCharVCSInfo);
#endif
#if defined(HAVE_LIBLALINSPIRAL) && (LALINSPIRAL_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalInspiralVCSInfo);
#endif
#if defined(HAVE_LIBLALPULSAR) && (LALPULSAR_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalPulsarVCSInfo);
#endif
#if defined(HAVE_LIBLALINFERENCE) && (LALINFERENCE_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalInferenceVCSInfo);
#endif
#if defined(HAVE_LIBLALSTOCHASTIC) && (LALSTOCHASTIC_VERSION_DEVEL != 0 || LALSimulation_VERSION_DEVEL != 0)
  VCS_INFO_CHECK(lalStochasticVCSInfo);
#endif
  VCS_INFO_CHECK(lalSimulationVCSInfo);

#undef VCS_INFO_CHECK

  return XLAL_SUCCESS;
}

/*
 * vim: tw=0 ts=2 et
 */
