%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts --enable-openmp GSL_LIBS="-lgsl"

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalsimulation
Version: 2.2.0
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
Summary: LSC Algorithm Simulation Library
License: GPLv2+
Group: LAL
Source0: http://software.ligo.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: help2man
BuildRequires: lal-devel >= 7.0.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.9

# python2
BuildRequires: python2-rpm-macros
BuildRequires: python-devel
BuildRequires: python2-lal >= 7.0.0
BuildRequires: python2-mock
BuildRequires: python2-numpy
BuildRequires: python-pathlib
BuildRequires: pytest

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-lal >= 7.0.0
BuildRequires: python%{python3_pkgversion}-numpy
BuildRequires: python%{python3_pkgversion}-pytest

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.0.0

# -- packages ---------------

# lalsimulation
Requires: gsl
Requires: lal >= 7.0.0

%description
The LSC Algorithm Simulation Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Simulation library.

# lalsimulation-devel
%package devel
Summary: Files and documentation needed for compiling programs that use LAL Simulation
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel
Requires: lal-devel >= 7.0.0
%description devel
The LSC Algorithm Simulation Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Simulation
library.

# python2-lalsimulation
%package -n python2-%{name}
Summary: Python %{python2_version} bindings for LALSimulation
Group: LAL
Requires: %{name} = %{version}
Requires: python
Requires: python2-lal >= 7.0.0
Requires: python2-numpy
Provides: %{name}-python = %{version}-%{release}
Obsoletes: %{name}-python < %{version}-%{release}
%{?python_provide:%python_provide python2-%{name}}
%description -n python2-%{name}
This package provides the Python %{python2_version} Bindings for LALSimulation.

# python3x-lalsimulation
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} bindings for LALSimulation
Group: LAL
Requires: %{name} = %{version}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-lal >= 7.0.0
Requires: python%{python3_pkgversion}-numpy
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
This package provides the Python %{python3_version} Bindings for LALSimulation.

# lalsimulation-octave
%package octave
Summary: Octave bindings for LALSimulation
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 7.0.0
%description octave
This package provides the Octave Bindings for LALSimulation.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
# build C library with python2
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python2}
%{__make} %{?_smp_mflags} V=1

# build python3 library (copy things so we don't have to rebuild them)
rm -rf %py3dir
cp -r . %py3dir
pushd %py3dir
rm -rfv python/%{name}/*.{la,lo,o} python/%{name}/.libs
%configure %{configure_opts} --disable-doxygen --disable-gcc-flags --disable-swig-octave --enable-swig-python PYTHON=%{__python3}
%{__make} V=1 -C swig
%{__make} V=1 -C python/%{name}
popd

%check
# C + python2 + octave
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check
# python3
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 -C %py3dir -C test/python check

%install
# C + python2 + octave
%make_install
# python3
%{__make} -C %py3dir -C swig install-exec-am DESTDIR=%{?buildroot}
%{__make} -C %py3dir -C python/%{name} install DESTDIR=%{?buildroot}
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files
%defattr(-,root,root)
%license COPYING
%{_bindir}/lalsim-*
%{_bindir}/lalsimulation_version
%{_datarootdir}/lalsimulation/LALSimNeutronStarEOS_*
%{_datarootdir}/lalsimulation/LIGO-P1200087*
%{_datarootdir}/lalsimulation/LIGO-P1600143*
%{_datarootdir}/lalsimulation/LIGO-T0900288*
%{_datarootdir}/lalsimulation/LIGO-T1600593*
%{_datarootdir}/lalsimulation/LIGO-T1800042*
%{_datarootdir}/lalsimulation/LIGO-T1800044*
%{_datarootdir}/lalsimulation/LIGO-T1800545*
%{_libdir}/*.so.*
%{_mandir}/man1/*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python2-%{name}
%defattr(-,root,root)
%license COPYING
%{python2_sitearch}/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalsimulation.oct*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jul 20 2020 Adam Mercer <adam.mercer@ligo.org> 2.2.0-2
- Update for 2.2.0

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 2.1.0-1
- Update for 2.1.0

* Wed Mar 25 2020 Duncan Macleod <duncan.macleod@ligo.org> 2.0.0-1
- Update for 2.0.0

* Wed Jan 15 2020 Adam Mercer <adam.mercer@ligo.org> 1.10.1-1
- Add a fix to aligned-spin limit
- NRHybSur3dq8: Use XLAL_EDOM for extrapolation errors
- Fix Bh1-Bh2 swap bug in NRSur7dq4 when m1 < m2

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.0-2
- Packaging updates

* Fri Nov 22 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.0-1
- O3b release

* Wed Jul 10 2019 Adam Mercer <adam.mercer@ligo.org> 1.9.1-1
- O3 point release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.9.0-1
- O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.8.2-1
- ER14 release

* Wed Jan 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.8.1-1
- added noise PSD files from LIGO-T1800545

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.8.0-1
- Pre O3 release

* Thu Mar 16 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.3-1
- fix Ldot equation in SpinTaylor

* Wed Mar 01 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.2-1
- fix bug in SpinTaylor, spin precession vector had incorrect sign

* Sat Feb 25 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.1-1
- fix memory leak in SpinTaylor code
- https://bugs.ligo.org/redmine/issues/5182

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.1-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.5.0-1
- Pre O2 packaging test release
