%define nightly %{nil}
%define _sysconfdir %{_prefix}/etc
%define release 1
%define configure_opts --enable-openmp

%if "%{?nightly:%{nightly}}%{!?nightly:0}" == "%{nil}"
%undefine nightly
%endif

# -- metadata ---------------

Name: lalsimulation
Version: 6.0.0
Release: %{?nightly:0.%{nightly}}%{!?nightly:%{release}}%{?dist}
License: GPLv2+
Source0: https://software.igwn.org/lscsoft/source/lalsuite/%{name}-%{version}%{?nightly:-%{nightly}}.tar.xz
URL: https://wiki.ligo.org/Computing/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
Prefix: %{_prefix}

# -- build requirements -----

# C
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: gsl-devel
BuildRequires: help2man >= 1.37
BuildRequires: liblal-devel >= 7.6.0
BuildRequires: make
BuildRequires: pkgconfig >= 0.18.0

# swig
BuildRequires: swig >= 3.0.11

# python3x
BuildRequires: python-srpm-macros
BuildRequires: python3-rpm-macros
BuildRequires: epel-rpm-macros
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-lal >= 7.6.0
BuildRequires: python%{python3_pkgversion}-numpy >= 1.7
BuildRequires: python%{python3_pkgversion}-pytest

# octave
BuildRequires: octave-devel
BuildRequires: lal-octave >= 7.6.0

# -- packages ---------------

# lalsimulation
Summary: LVK Algorithm Simulation Library - runtime tools
Requires: lib%{name} = %{version}-%{release}
Requires: %{name}-data
Requires: python%{python3_pkgversion}-%{name} = %{version}-%{release}
Obsoletes: python2-%{name} <= 2.5.1-1
%description
The LVK Algorithm Simulation Library for gravitational wave data analysis.
This package provides the runtime tools.

# lalsimulation-data
%package data
BuildArch: noarch
Summary: Data files for LALSimulation
%description data
The LVK Algorithm Simulation Library for gravitational wave data analysis.
This package contains the data files needed to run various applications and
rountines that use the LAL Simulation Library.

# liblalsimulation
%package -n lib%{name}
Summary: LVK Algorithm Simulation Library - library package
Requires: liblal >= 7.6.0
Requires: %{name}-data
Conflicts: %{name} <= 2.3.0-1
%description -n lib%{name}
The LVK Algorithm Simulation Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Simulation library.

# liblalsimulation-devel
%package -n lib%{name}-devel
Summary: Files and documentation needed for compiling programs that use LAL Simulation
Requires: gsl-devel
Requires: liblal-devel >= 7.6.0
Requires: lib%{name} = %{version}-%{release}
Provides: %{name}-devel = %{version}-%{release}
Obsoletes: %{name}-devel < 2.5.0-1
%description -n lib%{name}-devel
The LVK Algorithm Simulation Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL
Simulation library.

# python3x-lalsimulation
%package -n python%{python3_pkgversion}-%{name}
Summary: Python %{python3_version} bindings for LALSimulation
Requires: lib%{name} = %{version}-%{release}
Requires: python%{python3_pkgversion}
Requires: python%{python3_pkgversion}-lal >= 7.6.0
Requires: python%{python3_pkgversion}-numpy >= 1.7
Obsoletes: python2-%{name} < 3.0.0-1
%{?python_provide:%python_provide python%{python3_pkgversion}-%{name}}
%description -n python%{python3_pkgversion}-%{name}
This package provides the Python %{python3_version} Bindings for LALSimulation.

# lalsimulation-octave
%package octave
Summary: Octave bindings for LALSimulation
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 7.6.0
%description octave
This package provides the Octave Bindings for LALSimulation.

# -- build stages -----------

%prep
%setup -q -n %{name}-%{version}%{?nightly:-%{nightly}}

%build
%configure %{configure_opts} --disable-gcc-flags --enable-swig PYTHON=%{__python3}
%{__make} %{?_smp_mflags} V=1

%check
%{__make} %{?_smp_mflags} V=1 VERBOSE=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post -n lib%{name} -p /sbin/ldconfig

%postun -n lib%{name} -p /sbin/ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}%{?nightly:-%{nightly}}

# -- files ------------------

%files data
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_datarootdir}/%{name}/*

%files -n lib%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_libdir}/*.so.*

%files -n lib%{name}-devel
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files -n python%{python3_pkgversion}-%{name}
%defattr(-,root,root)
%doc README.md
%license COPYING
%{python3_sitearch}/*

%files octave
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_prefix}/lib*/octave/*/site/oct/*/lalsimulation.oct*

%files
%defattr(-,root,root)
%doc README.md
%license COPYING
%{_bindir}/*
%{_mandir}/man1/*
%{_sysconfdir}/*

# -- changelog --------------

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Mon Jul 29 2024 Adam Mercer <adam.mercer@ligo.org> 6.0.0-1
- Update for 6.0.0

* Mon Mar 11 2024 Duncan Macleod <duncan.macleod@ligo.org> 5.4.0-1
- Update for 5.4.0

* Mon Oct 23 2023 Adam Mercer <adam.mercer@ligo.org> 5.3.1-1
- Update got 5.3.1

* Fri Oct 06 2023 Adam Mercer <adam.mercer@ligo.org> 5.3.0-1
- Update for 5.3.0

* Mon Jul 10 2023 Adam Mercer <adam.mercer@ligo.org> 5.2.1-1
- Update for 5.2.1

* Mon Apr 24 2023 Adam Mercer <adam.mercer@ligo.org> 5.2.0-1
- Update for 5.2.0

* Thu Apr 06 2023 Adam Mercer <adam.mercer@ligo.org> 5.1.0-1
- Update for 5.1.0

* Mon Feb 06 2023 Adam Mercer <adam.mercer@ligo.org> 5.0.0-1
- Update for 5.0.0

* Mon Sep 05 2022 Adam Mercer <adam.mercer@ligo.org> 4.0.2-1
- Update for 4.0.2

* Thu Aug 18 2022 Adam Mercer <adam.mercer@ligo.org> 4.0.1-1
- Update for 4.0.1

* Tue Aug 02 2022 Adam Mercer <adam.mercer@ligo.org> 4.0.0-1
- Update for 4.0.0

* Thu Mar 03 2022 Adam Mercer <adam.mercer@ligo.org> 3.1.2-1
- Update for 3.1.2

* Mon Jan 10 2022 Adam Mercer <adam.mercer@ligolorg> 3.1.1-1
- Update for 3.1.1

* Fri Dec 03 2021 Adam Mercer <adam.mercer@ligo.org> 3.1.0-1
- Update for 3.1.0

* Mon May 17 2021 Adam Mercer <adam.mercer@ligo.org> 3.0.0-1
- Update for 3.0.0

* Fri Feb 05 2021 Adam Mercer <adam.mercer@ligo.org> 2.5.1-1
- Update for 2.5.1

* Mon Jan 11 2021 Adam Mercer <adam.mercer@ligo.org> 2.5.0-1
- Update for 2.5.0

* Fri Dec 18 2020 Duncan Macleod <duncan.macleod@ligo.org> 2.4.0-1
- Update for 2.4.0

* Wed Oct 28 2020 Adam Mercer <adam.mercer@ligo.org> 2.3.0-1
- Update for 2.3.0

* Thu Oct 15 2020 Adam Mercer <adam.mercer@ligo.org> 2.2.1-1
- Update for 2.2.1

* Mon Jul 20 2020 Adam Mercer <adam.mercer@ligo.org> 2.2.0-2
- Update for 2.2.0

* Mon Jun 08 2020 Adam Mercer <adam.mercer@ligo.org> 2.1.0-1
- Update for 2.1.0

* Wed Mar 25 2020 Duncan Macleod <duncan.macleod@ligo.org> 2.0.0-1
- Update for 2.0.0

* Wed Jan 15 2020 Adam Mercer <adam.mercer@ligo.org> 1.10.1-1
- Add a fix to aligned-spin limit
- NRHybSur3dq8: Use XLAL_EDOM for extrapolation errors
- Fix Bh1-Bh2 swap bug in NRSur7dq4 when m1 < m2

* Mon Dec 09 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.0-2
- Packaging updates

* Fri Nov 22 2019 Adam Mercer <adam.mercer@ligo.org> 1.10.0-1
- O3b release

* Wed Jul 10 2019 Adam Mercer <adam.mercer@ligo.org> 1.9.1-1
- O3 point release

* Thu May 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.9.0-1
- O3 release

* Mon Feb 25 2019 Adam Mercer <adam.mercer@ligo.org> 1.8.2-1
- ER14 release

* Wed Jan 23 2019 Adam Mercer <adam.mercer@ligo.org> 1.8.1-1
- added noise PSD files from LIGO-T1800545

* Thu Sep 13 2018 Adam Mercer <adam.mercer@ligo.org> 1.8.0-1
- Pre O3 release

* Thu Mar 16 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.3-1
- fix Ldot equation in SpinTaylor

* Wed Mar 01 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.2-1
- fix bug in SpinTaylor, spin precession vector had incorrect sign

* Sat Feb 25 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.1-1
- fix memory leak in SpinTaylor code
- https://bugs.ligo.org/redmine/issues/5182

* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.7.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.1-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.5.0-1
- Pre O2 packaging test release
