/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_tcb_h
#define __libnd_tcb_h

#include <libnd.h>

#include <netinet/ip.h>
#include <netinet/tcp.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Transmission Control Buffers for TCP connections */

typedef struct nd_tcb LND_TCB;
typedef struct nd_tcb_conn LND_TCBConn;

LND_TCB         *libnd_tcb_new(void);
void            libnd_tcb_free(LND_TCB *tcb);

LND_TCBConn     *libnd_tcb_lookup(LND_TCB *tcb,
				 const LND_Packet *packet,
				 gboolean *is_reverse);

void            libnd_tcb_update(LND_TCB *tcb,
				 const LND_Packet *packet,
				 int index);


gboolean        libnd_tcb_is_match(const LND_TCBConn *conn,
				   const LND_Packet *packet);

gboolean        libnd_tcb_conn_reverse(const LND_TCBConn *conn);

/* Returns TRUE when the cb knows the receiver,
 * FALSE otherwise.
 */
gboolean        libnd_tcb_conn_recv_known(LND_TCBConn *tcbc);

/* Returns the starting and ending sequence numbers of the given
   packet through SEQ_START and SEQ_ELND, trying to calculate relative
   numbers to the given TCB. If this was possible, TRUE is returned,
   FALSE otherwise. */
gboolean        libnd_tcb_conn_get_rel_seq(const LND_TCBConn *tcbc,
					   const struct ip *iphdr, const struct tcphdr *tcphdr,
					   guint32 *seq_start, guint32 *seq_end);

/* Returns the ack sequence number of the given packet through ACK,
   trying to calculate relative numbers to the given TCB. If this
   was possible, TRUE is returned, FALSE otherwise. */
gboolean        libnd_tcb_conn_get_rel_ack(const LND_TCBConn *tcbc,
					   const struct ip *iphdr, const struct tcphdr *tcphdr,
					   gboolean force_rel, guint32 *ack);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
     
