/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libnd_vlan.h>

static LND_Protocol *vlan;

static gboolean
vlan_header_complete(const LND_Packet *packet, guchar *data)
{
  if (!data)
    return FALSE;

  return (data + LND_VLAN_LEN <= libnd_packet_get_end(packet));
}


/* Plugin hook implementations: ---------------------------------------- */

const char *
name(void)
{
  return ("VLAN Plugin");
}


const char *
description(void)
{
  return ("A small plugin providing support for VLAN-tagged Ethernet.");
}


const char *
author(void)
{
  return ("Christian Kreibich, <christian@whoop.org>");
}


const char *
version(void)
{
  return VERSION;
}


LND_Protocol *
init(void)
{
  vlan = libnd_proto_new("VLAN", LND_PROTO_LAYER_NET, LND_PROTO_VLAN);
			     		
  vlan->init_packet     = libnd_vlan_init_packet;
  vlan->header_complete = libnd_vlan_header_complete;

  return vlan;
}


/* Protocol method implementations: ------------------------------------ */

guchar *
libnd_vlan_init_packet(LND_Packet *packet, guchar *data, guchar *data_end)
{
  LND_Protocol *payload_proto = NULL;
  struct lnd_vlan_header *vh;
  guchar *used_data_end = NULL;

  D_ENTER;

  if (!vlan_header_complete(packet, data))
    {
      libnd_raw_proto_get()->init_packet(packet, data, data_end);
      D_RETURN_(data_end);
    }

  libnd_packet_add_proto_data(packet, vlan, data, data_end);  
  vh = (struct lnd_vlan_header *) data;
  
  if (! (payload_proto = libnd_proto_registry_find(LND_PROTO_LAYER_NET, ntohs(vh->vlan_proto))))
    payload_proto = libnd_raw_proto_get();
  
  used_data_end = payload_proto->init_packet(packet, data + LND_VLAN_LEN, data_end);	    

  D_RETURN_(used_data_end);
}


gboolean
libnd_vlan_header_complete(const LND_Packet *packet, guint nesting)
{
  guchar      *data;

  if (!packet)
    return FALSE;

  data = libnd_packet_get_data(packet, vlan, nesting);

  return vlan_header_complete(packet, data);
}


LND_Protocol *
libnd_vlan_get(void)
{
  return vlan;
}

