/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>

#include <libnd_globals.h>
#include <libnd_prefs.h>
#include <libnd_misc.h>

#ifdef USE_LIBMAGIC
#include <magic.h>

static magic_t mcookie;

void
libnd_magic_init(void)
{
  char *mdict;
  
  if (! libnd_prefs_get_str_item(LND_DOM_NETDUDE, "magic_dict", &mdict))
    mdict = NULL;
  
  mcookie = magic_open(MAGIC_NONE);
  magic_load(mcookie, mdict);
}

const char*
libnd_magic_buffer(const guchar *buffer, int buflen)
{
  const char *result = magic_buffer(mcookie, buffer, buflen);  
  return result ? result : "";
}

#else

void
libnd_magic_init(void)
{
}

const char*
libnd_magic_buffer(const guchar *buffer, int buflen)
{
  return "";
}

#endif
