/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __libnd_ip_h
#define __libnd_ip_h

#include <libnd.h>

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef IPTOS_LOWCOST
#define IPTOS_LOWCOST 0x02
#endif

#define LND_IP_PAYLOAD_LENGTH(iphdr) (ntohs(iphdr->ip_len) - (iphdr->ip_hl << 2))
#define LND_IP_PAYLOAD(iphdr) (((guchar *) iphdr) + (iphdr->ip_hl << 2))
#define LND_IP_FRAG_OFFSET(iphdr) ((ntohs(iphdr->ip_off) & IP_OFFMASK) << 3)

/* These are the implementations for IPv4 of LND_Protocol's callbacks: */
guchar    *libnd_ip_init_packet(LND_Packet *packet, u_char *data, u_char *data_end);
gboolean   libnd_ip_header_complete(const LND_Packet *packet, guint nesting);
gboolean   libnd_ip_fix_packet(LND_Packet *packet);
gboolean   libnd_ip_can_fix_proceed(LND_Packet *packet, LND_ProtoData *pd);
gboolean   libnd_ip_adjust_len(LND_Packet *packet, int delta);

/* Generic accessor function for the IPv4 Protocol implementation: */
inline LND_Protocol *libnd_ip_get(void);

/* Helper function that reports whether a packet's checksum is okay
   or not, given its current content. The correct checksum is passed
   through the correct_sum pointer as a result, if the pointer is
   provided. */
guint16    libnd_ip_checksum(const struct ip *iphdr);
gboolean   libnd_ip_csum_correct(const struct ip *iphdr, guint16 *correct_sum);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
