/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __libnd_sll_h
#define __libnd_sll_h

#include <libnd.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

struct sll_header
{
  guint16   sll_pkttype;
  guint16   sll_hatype;
  guint16   sll_halen;
  guint8    sll_addr[8];
  guint16   sll_protocol;
};

#define SLL_HEADER_LEN 16

#ifndef DLT_LINUX_SLL
#define DLT_LINUX_SLL 113
#endif


/* These are the implementations of LND_Protocol's callbacks: */
guchar      *libnd_sll_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
gboolean     libnd_sll_header_complete(const LND_Packet *packet, guint nesting);

/* Generic accessor function for the protocol implementation: */
LND_Protocol *libnd_sll_get(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
