/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libnd_macros.h>
#include <libnd_debug.h>
#include <libnd_protocol_inst.h>
#include <libnd_raw_protocol.h>

/* These are the implementations of LND_Protocol's callbacks: */
static guchar    *raw_init_packet(LND_Packet *packet, guchar *data, guchar *data_end);
static gboolean   raw_header_complete(const LND_Packet *packet, guint nesting);


static LND_Protocol *raw = NULL;


void         
libnd_raw_proto_init(void)
{
  if (!raw)
    {
      raw = libnd_proto_new("raw data", 0, 0);
	
      raw->init_packet     = raw_init_packet;
      raw->header_complete = raw_header_complete;
    }
}


LND_Protocol *
libnd_raw_proto_get(void)
{
  return raw;
}


/* Protocol method implementations: ------------------------------------ */

static guchar*
raw_init_packet(LND_Packet *packet, guchar *data, guchar *data_end)
{
  D_ENTER;

  if (!packet || !data)
    {
      D(("Invalid input\n"));
      D_RETURN_(data_end);
    }

  if (data_end - data <= 0)
    {
      D(("Invalid offset\n"));
      D_RETURN_(data_end);
    }
  
  libnd_packet_add_proto_data(packet, raw, data, data_end);  
  D_RETURN_(data_end);
}


static gboolean
raw_header_complete(const LND_Packet *packet, guint nesting)
{
  /* For raw data there's no header, thus this is
     always complete and thus TRUE.
  */

  return TRUE;
  TOUCH(packet);
  TOUCH(nesting);
}
