INCLUDE("${CMAKE_CURRENT_SOURCE_DIR}/ExternalProjectBZ2.cmake")

MACRO(CHECK_PROJECT_PLATFORM)
  IF(NOT DEVEL_PLATFORM)
    MESSAGE(FATAL_ERROR 
      "--------------------------------------------
       DEVEL PLATFORM NOT SET
       RUN CMAKE WITH -DDEVEL_PLATFORM=[platform]
       --------------------------------------------"
       )
   ENDIF()
 ENDMACRO()

 MACRO(SETUP_LIBRARY_PATH_VARS)
   IF(LIBRARY_INSTALL_PREFIX)
     SET(LIBRARY_CACHE_DIR "${LIBRARY_INSTALL_PREFIX}/")
   ELSE()
     SET(LIBRARY_CACHE_DIR "${CMAKE_SOURCE_DIR}/library-cache")
   ENDIF()
   SET(LIBRARY_PROJECT_PREFIX_DIR "usr_${DEVEL_PLATFORM}")

   SET(PREFIX_DIR "${LIBRARY_CACHE_DIR}/${LIBRARY_PROJECT_PREFIX_DIR}")
   SET(BUILD_PREFIX_DIR "${LIBRARY_CACHE_DIR}/library_build/${LIBRARY_PROJECT_PREFIX_DIR}/${LIBRARY_PROJECT_NAME}/${LIBRARY_PROJECT_VERSION}")
   SET(LIBRARY_PROJECT_CPPFLAGS "CPPFLAGS=-I${PREFIX_DIR}/include")
   SET(LIBRARY_PROJECT_LDFLAGS "LDFLAGS=-L${PREFIX_DIR}/lib")
 ENDMACRO()

 MACRO(BUILD_BOOST_EXTERNAL)
   SETUP_LIBRARY_PATH_VARS()
   SET(BOOST_BUILD_COMMAND "${BUILD_PREFIX_DIR}/src/bjam" "--with-thread" "--with-system" "--with-filesystem" "--with-program_options" "--with-python" "--with-date_time" "--with-test" "-j2" "--prefix=${PREFIX_DIR}")
   ExternalProject_Add(
     ${LIBRARY_PROJECT_NAME}
     DEPENDS ${LIBRARY_PROJECT_DEPENDS}
     PREFIX ${PREFIX_DIR}
     URL ${LIBRARY_PROJECT_DOWNLOAD_URL}
     DOWNLOAD_DIR "${BUILD_PREFIX_DIR}/download"
     SOURCE_DIR "${BUILD_PREFIX_DIR}/src"
     BINARY_DIR "${BUILD_PREFIX_DIR}/build"
     STAMP_DIR "${BUILD_PREFIX_DIR}/stamp"
     TMP_DIR "${BUILD_PREFIX_DIR}/tmp"
     CONFIGURE_COMMAND "cd" "${BUILD_PREFIX_DIR}/src" "&&" "${BUILD_PREFIX_DIR}/src/bootstrap.sh"
     BUILD_COMMAND "cd" "${BUILD_PREFIX_DIR}/src" "&&" "${BOOST_BUILD_COMMAND}"
     INSTALL_COMMAND "cd" "${BUILD_PREFIX_DIR}/src" "&&" "${BOOST_BUILD_COMMAND}" "install"
     )
 ENDMACRO()

 MACRO(BUILD_CMAKE_EXTERNAL)
   SETUP_LIBRARY_PATH_VARS()
   ExternalProject_Add(
     ${LIBRARY_PROJECT_NAME}
     DEPENDS ${LIBRARY_PROJECT_DEPENDS}
     PREFIX ${PREFIX_DIR}
     URL ${LIBRARY_PROJECT_DOWNLOAD_URL}
     DOWNLOAD_DIR "${BUILD_PREFIX_DIR}/download"
     SOURCE_DIR "${BUILD_PREFIX_DIR}/src"
     BINARY_DIR "${BUILD_PREFIX_DIR}/build"
     STAMP_DIR "${BUILD_PREFIX_DIR}/stamp"
     TMP_DIR "${BUILD_PREFIX_DIR}/tmp"
     CMAKE_ARGS "-DCMAKE_INSTALL_PREFIX=${PREFIX_DIR}"
     INSTALL_DIR "${PREFIX_DIR}"
     )
 ENDMACRO()

 MACRO(BUILD_AUTOTOOLS_EXTERNAL)
   SETUP_LIBRARY_PATH_VARS()
   ExternalProject_Add(
     ${LIBRARY_PROJECT_NAME}
     DEPENDS ${LIBRARY_PROJECT_DEPENDS}
     PREFIX ${PREFIX_DIR}
     URL ${LIBRARY_PROJECT_DOWNLOAD_URL}
     DOWNLOAD_DIR "${BUILD_PREFIX_DIR}/download"
     SOURCE_DIR "${BUILD_PREFIX_DIR}/src"
     BINARY_DIR "${BUILD_PREFIX_DIR}/build"
     STAMP_DIR "${BUILD_PREFIX_DIR}/stamp"
     TMP_DIR "${BUILD_PREFIX_DIR}/tmp"
     CONFIGURE_COMMAND "${BUILD_PREFIX_DIR}/src/configure" "--prefix=${PREFIX_DIR}" "${LIBRARY_PROJECT_CONFIGURE_OPTIONS}" "${LIBRARY_PROJECT_CPPFLAGS}" "${LIBRARY_PROJECT_LDFLAGS}"
     )
 ENDMACRO()

