; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- -mcpu=corei7 | FileCheck %s --check-prefix=ALL --check-prefix=X86
; RUN: llc < %s -mtriple=i686-- -mcpu=corei7-avx | FileCheck %s --check-prefix=ALL --check-prefix=SHLD
; RUN: llc < %s -mtriple=i686-- -mcpu=core-avx2 | FileCheck %s --check-prefix=ALL --check-prefix=BMI2

define i32 @foo(i32 %x, i32 %y, i32 %z) nounwind readnone {
; ALL-LABEL: foo:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movb {{[0-9]+}}(%esp), %cl
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; ALL-NEXT:    roll %cl, %eax
; ALL-NEXT:    retl
entry:
	%0 = shl i32 %x, %z
	%1 = sub i32 32, %z
	%2 = lshr i32 %x, %1
	%3 = or i32 %2, %0
	ret i32 %3
}

define i32 @bar(i32 %x, i32 %y, i32 %z) nounwind readnone {
; ALL-LABEL: bar:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movb {{[0-9]+}}(%esp), %cl
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %edx
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; ALL-NEXT:    shldl %cl, %edx, %eax
; ALL-NEXT:    retl
entry:
	%0 = shl i32 %y, %z
	%1 = sub i32 32, %z
	%2 = lshr i32 %x, %1
	%3 = or i32 %2, %0
	ret i32 %3
}

define i32 @un(i32 %x, i32 %y, i32 %z) nounwind readnone {
; ALL-LABEL: un:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movb {{[0-9]+}}(%esp), %cl
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; ALL-NEXT:    rorl %cl, %eax
; ALL-NEXT:    retl
entry:
	%0 = lshr i32 %x, %z
	%1 = sub i32 32, %z
	%2 = shl i32 %x, %1
	%3 = or i32 %2, %0
	ret i32 %3
}

define i32 @bu(i32 %x, i32 %y, i32 %z) nounwind readnone {
; ALL-LABEL: bu:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movb {{[0-9]+}}(%esp), %cl
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %edx
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; ALL-NEXT:    shrdl %cl, %edx, %eax
; ALL-NEXT:    retl
entry:
	%0 = lshr i32 %y, %z
	%1 = sub i32 32, %z
	%2 = shl i32 %x, %1
	%3 = or i32 %2, %0
	ret i32 %3
}

define i32 @xfoo(i32 %x, i32 %y, i32 %z) nounwind readnone {
; X86-LABEL: xfoo:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    roll $7, %eax
; X86-NEXT:    retl
;
; SHLD-LABEL: xfoo:
; SHLD:       # %bb.0: # %entry
; SHLD-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SHLD-NEXT:    shldl $7, %eax, %eax
; SHLD-NEXT:    retl
;
; BMI2-LABEL: xfoo:
; BMI2:       # %bb.0: # %entry
; BMI2-NEXT:    rorxl $25, {{[0-9]+}}(%esp), %eax
; BMI2-NEXT:    retl
entry:
	%0 = lshr i32 %x, 25
	%1 = shl i32 %x, 7
	%2 = or i32 %0, %1
	ret i32 %2
}

define i32 @xfoop(i32* %p) nounwind readnone {
; X86-LABEL: xfoop:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %eax
; X86-NEXT:    roll $7, %eax
; X86-NEXT:    retl
;
; SHLD-LABEL: xfoop:
; SHLD:       # %bb.0: # %entry
; SHLD-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SHLD-NEXT:    movl (%eax), %eax
; SHLD-NEXT:    shldl $7, %eax, %eax
; SHLD-NEXT:    retl
;
; BMI2-LABEL: xfoop:
; BMI2:       # %bb.0: # %entry
; BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; BMI2-NEXT:    rorxl $25, (%eax), %eax
; BMI2-NEXT:    retl
entry:
	%x = load i32, i32* %p
	%a = lshr i32 %x, 25
	%b = shl i32 %x, 7
	%c = or i32 %a, %b
	ret i32 %c
}

define i32 @xbar(i32 %x, i32 %y, i32 %z) nounwind readnone {
; ALL-LABEL: xbar:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; ALL-NEXT:    shldl $7, %ecx, %eax
; ALL-NEXT:    retl
entry:
	%0 = shl i32 %y, 7
	%1 = lshr i32 %x, 25
	%2 = or i32 %0, %1
	ret i32 %2
}

define i32 @xun(i32 %x, i32 %y, i32 %z) nounwind readnone {
; X86-LABEL: xun:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    roll $25, %eax
; X86-NEXT:    retl
;
; SHLD-LABEL: xun:
; SHLD:       # %bb.0: # %entry
; SHLD-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SHLD-NEXT:    shldl $25, %eax, %eax
; SHLD-NEXT:    retl
;
; BMI2-LABEL: xun:
; BMI2:       # %bb.0: # %entry
; BMI2-NEXT:    rorxl $7, {{[0-9]+}}(%esp), %eax
; BMI2-NEXT:    retl
entry:
	%0 = lshr i32 %x, 7
	%1 = shl i32 %x, 25
	%2 = or i32 %0, %1
	ret i32 %2
}

define i32 @xunp(i32* %p) nounwind readnone {
; X86-LABEL: xunp:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl (%eax), %eax
; X86-NEXT:    roll $25, %eax
; X86-NEXT:    retl
;
; SHLD-LABEL: xunp:
; SHLD:       # %bb.0: # %entry
; SHLD-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SHLD-NEXT:    movl (%eax), %eax
; SHLD-NEXT:    shldl $25, %eax, %eax
; SHLD-NEXT:    retl
;
; BMI2-LABEL: xunp:
; BMI2:       # %bb.0: # %entry
; BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; BMI2-NEXT:    rorxl $7, (%eax), %eax
; BMI2-NEXT:    retl
entry:
; shld-label: xunp:
; shld: shldl $25
	%x = load i32, i32* %p
	%a = lshr i32 %x, 7
	%b = shl i32 %x, 25
	%c = or i32 %a, %b
	ret i32 %c
}

define i32 @xbu(i32 %x, i32 %y, i32 %z) nounwind readnone {
; ALL-LABEL: xbu:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; ALL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; ALL-NEXT:    shldl $25, %ecx, %eax
; ALL-NEXT:    retl
entry:
	%0 = lshr i32 %y, 7
	%1 = shl i32 %x, 25
	%2 = or i32 %0, %1
	ret i32 %2
}
