//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// This test ensures that we produce a diagnostic when we use a private header
// from user code.

// REQUIRES: modules-build

/*
BEGIN-SCRIPT

for header in private_headers:
  # Skip headers that are not private yet in the modulemap
  if header in private_headers_still_public_in_modules:
    continue

  # Skip private headers that start with __support -- those are not in the modulemap yet
  if header.startswith('__support'):
    continue

  print("{ifdef}#{indent}include <{header}> // {expected_error}@*:* {{{{use of private header from outside its module: '{header}'}}}}{endif}".format(
    ifdef='#if ' + header_restrictions[header] + '\n' if header in header_restrictions else '',
    indent='   ' if header in header_restrictions else '',
    header=header,
    expected_error='expected-error',
    endif='\n#endif' if header in header_restrictions else ''
  ))

END-SCRIPT
*/

// DO NOT MANUALLY EDIT ANYTHING BETWEEN THE MARKERS BELOW
// GENERATED-MARKER
#include <__algorithm/adjacent_find.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/adjacent_find.h'}}
#include <__algorithm/algorithm_family.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/algorithm_family.h'}}
#include <__algorithm/all_of.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/all_of.h'}}
#include <__algorithm/any_of.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/any_of.h'}}
#include <__algorithm/binary_search.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/binary_search.h'}}
#include <__algorithm/clamp.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/clamp.h'}}
#include <__algorithm/comp.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/comp.h'}}
#include <__algorithm/comp_ref_type.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/comp_ref_type.h'}}
#include <__algorithm/copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/copy.h'}}
#include <__algorithm/copy_backward.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/copy_backward.h'}}
#include <__algorithm/copy_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/copy_if.h'}}
#include <__algorithm/copy_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/copy_n.h'}}
#include <__algorithm/count.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/count.h'}}
#include <__algorithm/count_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/count_if.h'}}
#include <__algorithm/equal.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/equal.h'}}
#include <__algorithm/equal_range.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/equal_range.h'}}
#include <__algorithm/fill.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/fill.h'}}
#include <__algorithm/fill_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/fill_n.h'}}
#include <__algorithm/find.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/find.h'}}
#include <__algorithm/find_end.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/find_end.h'}}
#include <__algorithm/find_first_of.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/find_first_of.h'}}
#include <__algorithm/find_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/find_if.h'}}
#include <__algorithm/find_if_not.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/find_if_not.h'}}
#include <__algorithm/for_each.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/for_each.h'}}
#include <__algorithm/for_each_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/for_each_n.h'}}
#include <__algorithm/generate.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/generate.h'}}
#include <__algorithm/generate_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/generate_n.h'}}
#include <__algorithm/half_positive.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/half_positive.h'}}
#include <__algorithm/in_found_result.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/in_found_result.h'}}
#include <__algorithm/in_fun_result.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/in_fun_result.h'}}
#include <__algorithm/in_in_out_result.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/in_in_out_result.h'}}
#include <__algorithm/in_in_result.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/in_in_result.h'}}
#include <__algorithm/in_out_out_result.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/in_out_out_result.h'}}
#include <__algorithm/in_out_result.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/in_out_result.h'}}
#include <__algorithm/includes.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/includes.h'}}
#include <__algorithm/inplace_merge.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/inplace_merge.h'}}
#include <__algorithm/is_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/is_heap.h'}}
#include <__algorithm/is_heap_until.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/is_heap_until.h'}}
#include <__algorithm/is_partitioned.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/is_partitioned.h'}}
#include <__algorithm/is_permutation.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/is_permutation.h'}}
#include <__algorithm/is_sorted.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/is_sorted.h'}}
#include <__algorithm/is_sorted_until.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/is_sorted_until.h'}}
#include <__algorithm/iter_swap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/iter_swap.h'}}
#include <__algorithm/iterator_operations.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/iterator_operations.h'}}
#include <__algorithm/lexicographical_compare.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/lexicographical_compare.h'}}
#include <__algorithm/lower_bound.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/lower_bound.h'}}
#include <__algorithm/make_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/make_heap.h'}}
#include <__algorithm/make_projected.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/make_projected.h'}}
#include <__algorithm/max.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/max.h'}}
#include <__algorithm/max_element.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/max_element.h'}}
#include <__algorithm/merge.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/merge.h'}}
#include <__algorithm/min.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/min.h'}}
#include <__algorithm/min_element.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/min_element.h'}}
#include <__algorithm/min_max_result.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/min_max_result.h'}}
#include <__algorithm/minmax.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/minmax.h'}}
#include <__algorithm/minmax_element.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/minmax_element.h'}}
#include <__algorithm/mismatch.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/mismatch.h'}}
#include <__algorithm/move.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/move.h'}}
#include <__algorithm/move_backward.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/move_backward.h'}}
#include <__algorithm/next_permutation.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/next_permutation.h'}}
#include <__algorithm/none_of.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/none_of.h'}}
#include <__algorithm/nth_element.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/nth_element.h'}}
#include <__algorithm/partial_sort.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/partial_sort.h'}}
#include <__algorithm/partial_sort_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/partial_sort_copy.h'}}
#include <__algorithm/partition.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/partition.h'}}
#include <__algorithm/partition_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/partition_copy.h'}}
#include <__algorithm/partition_point.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/partition_point.h'}}
#include <__algorithm/pop_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/pop_heap.h'}}
#include <__algorithm/prev_permutation.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/prev_permutation.h'}}
#include <__algorithm/push_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/push_heap.h'}}
#include <__algorithm/ranges_adjacent_find.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_adjacent_find.h'}}
#include <__algorithm/ranges_all_of.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_all_of.h'}}
#include <__algorithm/ranges_any_of.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_any_of.h'}}
#include <__algorithm/ranges_binary_search.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_binary_search.h'}}
#include <__algorithm/ranges_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_copy.h'}}
#include <__algorithm/ranges_copy_backward.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_copy_backward.h'}}
#include <__algorithm/ranges_copy_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_copy_if.h'}}
#include <__algorithm/ranges_copy_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_copy_n.h'}}
#include <__algorithm/ranges_count.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_count.h'}}
#include <__algorithm/ranges_count_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_count_if.h'}}
#include <__algorithm/ranges_equal.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_equal.h'}}
#include <__algorithm/ranges_equal_range.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_equal_range.h'}}
#include <__algorithm/ranges_fill.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_fill.h'}}
#include <__algorithm/ranges_fill_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_fill_n.h'}}
#include <__algorithm/ranges_find.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_find.h'}}
#include <__algorithm/ranges_find_end.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_find_end.h'}}
#include <__algorithm/ranges_find_first_of.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_find_first_of.h'}}
#include <__algorithm/ranges_find_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_find_if.h'}}
#include <__algorithm/ranges_find_if_not.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_find_if_not.h'}}
#include <__algorithm/ranges_for_each.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_for_each.h'}}
#include <__algorithm/ranges_for_each_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_for_each_n.h'}}
#include <__algorithm/ranges_generate.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_generate.h'}}
#include <__algorithm/ranges_generate_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_generate_n.h'}}
#include <__algorithm/ranges_includes.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_includes.h'}}
#include <__algorithm/ranges_inplace_merge.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_inplace_merge.h'}}
#include <__algorithm/ranges_is_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_is_heap.h'}}
#include <__algorithm/ranges_is_heap_until.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_is_heap_until.h'}}
#include <__algorithm/ranges_is_partitioned.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_is_partitioned.h'}}
#include <__algorithm/ranges_is_sorted.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_is_sorted.h'}}
#include <__algorithm/ranges_is_sorted_until.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_is_sorted_until.h'}}
#include <__algorithm/ranges_iterator_concept.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_iterator_concept.h'}}
#include <__algorithm/ranges_lexicographical_compare.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_lexicographical_compare.h'}}
#include <__algorithm/ranges_lower_bound.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_lower_bound.h'}}
#include <__algorithm/ranges_make_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_make_heap.h'}}
#include <__algorithm/ranges_max.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_max.h'}}
#include <__algorithm/ranges_max_element.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_max_element.h'}}
#include <__algorithm/ranges_merge.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_merge.h'}}
#include <__algorithm/ranges_min.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_min.h'}}
#include <__algorithm/ranges_min_element.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_min_element.h'}}
#include <__algorithm/ranges_minmax.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_minmax.h'}}
#include <__algorithm/ranges_minmax_element.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_minmax_element.h'}}
#include <__algorithm/ranges_mismatch.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_mismatch.h'}}
#include <__algorithm/ranges_move.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_move.h'}}
#include <__algorithm/ranges_move_backward.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_move_backward.h'}}
#include <__algorithm/ranges_none_of.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_none_of.h'}}
#include <__algorithm/ranges_nth_element.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_nth_element.h'}}
#include <__algorithm/ranges_partial_sort.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_partial_sort.h'}}
#include <__algorithm/ranges_partial_sort_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_partial_sort_copy.h'}}
#include <__algorithm/ranges_partition.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_partition.h'}}
#include <__algorithm/ranges_partition_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_partition_copy.h'}}
#include <__algorithm/ranges_partition_point.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_partition_point.h'}}
#include <__algorithm/ranges_pop_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_pop_heap.h'}}
#include <__algorithm/ranges_push_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_push_heap.h'}}
#include <__algorithm/ranges_remove.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_remove.h'}}
#include <__algorithm/ranges_remove_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_remove_copy.h'}}
#include <__algorithm/ranges_remove_copy_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_remove_copy_if.h'}}
#include <__algorithm/ranges_remove_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_remove_if.h'}}
#include <__algorithm/ranges_replace.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_replace.h'}}
#include <__algorithm/ranges_replace_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_replace_copy.h'}}
#include <__algorithm/ranges_replace_copy_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_replace_copy_if.h'}}
#include <__algorithm/ranges_replace_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_replace_if.h'}}
#include <__algorithm/ranges_reverse.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_reverse.h'}}
#include <__algorithm/ranges_reverse_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_reverse_copy.h'}}
#include <__algorithm/ranges_rotate_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_rotate_copy.h'}}
#include <__algorithm/ranges_search.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_search.h'}}
#include <__algorithm/ranges_search_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_search_n.h'}}
#include <__algorithm/ranges_set_difference.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_set_difference.h'}}
#include <__algorithm/ranges_set_intersection.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_set_intersection.h'}}
#include <__algorithm/ranges_set_symmetric_difference.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_set_symmetric_difference.h'}}
#include <__algorithm/ranges_set_union.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_set_union.h'}}
#include <__algorithm/ranges_shuffle.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_shuffle.h'}}
#include <__algorithm/ranges_sort.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_sort.h'}}
#include <__algorithm/ranges_sort_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_sort_heap.h'}}
#include <__algorithm/ranges_stable_partition.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_stable_partition.h'}}
#include <__algorithm/ranges_stable_sort.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_stable_sort.h'}}
#include <__algorithm/ranges_swap_ranges.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_swap_ranges.h'}}
#include <__algorithm/ranges_transform.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_transform.h'}}
#include <__algorithm/ranges_unique.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_unique.h'}}
#include <__algorithm/ranges_unique_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_unique_copy.h'}}
#include <__algorithm/ranges_upper_bound.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/ranges_upper_bound.h'}}
#include <__algorithm/remove.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/remove.h'}}
#include <__algorithm/remove_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/remove_copy.h'}}
#include <__algorithm/remove_copy_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/remove_copy_if.h'}}
#include <__algorithm/remove_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/remove_if.h'}}
#include <__algorithm/replace.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/replace.h'}}
#include <__algorithm/replace_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/replace_copy.h'}}
#include <__algorithm/replace_copy_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/replace_copy_if.h'}}
#include <__algorithm/replace_if.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/replace_if.h'}}
#include <__algorithm/reverse.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/reverse.h'}}
#include <__algorithm/reverse_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/reverse_copy.h'}}
#include <__algorithm/rotate.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/rotate.h'}}
#include <__algorithm/rotate_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/rotate_copy.h'}}
#include <__algorithm/sample.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/sample.h'}}
#include <__algorithm/search.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/search.h'}}
#include <__algorithm/search_n.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/search_n.h'}}
#include <__algorithm/set_difference.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/set_difference.h'}}
#include <__algorithm/set_intersection.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/set_intersection.h'}}
#include <__algorithm/set_symmetric_difference.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/set_symmetric_difference.h'}}
#include <__algorithm/set_union.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/set_union.h'}}
#include <__algorithm/shift_left.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/shift_left.h'}}
#include <__algorithm/shift_right.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/shift_right.h'}}
#include <__algorithm/shuffle.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/shuffle.h'}}
#include <__algorithm/sift_down.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/sift_down.h'}}
#include <__algorithm/sort.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/sort.h'}}
#include <__algorithm/sort_heap.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/sort_heap.h'}}
#include <__algorithm/stable_partition.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/stable_partition.h'}}
#include <__algorithm/stable_sort.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/stable_sort.h'}}
#include <__algorithm/swap_ranges.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/swap_ranges.h'}}
#include <__algorithm/transform.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/transform.h'}}
#include <__algorithm/unique.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/unique.h'}}
#include <__algorithm/unique_copy.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/unique_copy.h'}}
#include <__algorithm/unwrap_iter.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/unwrap_iter.h'}}
#include <__algorithm/unwrap_range.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/unwrap_range.h'}}
#include <__algorithm/upper_bound.h> // expected-error@*:* {{use of private header from outside its module: '__algorithm/upper_bound.h'}}
#include <__availability> // expected-error@*:* {{use of private header from outside its module: '__availability'}}
#include <__bit/bit_cast.h> // expected-error@*:* {{use of private header from outside its module: '__bit/bit_cast.h'}}
#include <__bit/byteswap.h> // expected-error@*:* {{use of private header from outside its module: '__bit/byteswap.h'}}
#include <__bit_reference> // expected-error@*:* {{use of private header from outside its module: '__bit_reference'}}
#include <__bits> // expected-error@*:* {{use of private header from outside its module: '__bits'}}
#include <__charconv/chars_format.h> // expected-error@*:* {{use of private header from outside its module: '__charconv/chars_format.h'}}
#include <__charconv/from_chars_result.h> // expected-error@*:* {{use of private header from outside its module: '__charconv/from_chars_result.h'}}
#include <__charconv/tables.h> // expected-error@*:* {{use of private header from outside its module: '__charconv/tables.h'}}
#include <__charconv/to_chars_base_10.h> // expected-error@*:* {{use of private header from outside its module: '__charconv/to_chars_base_10.h'}}
#include <__charconv/to_chars_result.h> // expected-error@*:* {{use of private header from outside its module: '__charconv/to_chars_result.h'}}
#include <__chrono/calendar.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/calendar.h'}}
#include <__chrono/convert_to_timespec.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/convert_to_timespec.h'}}
#include <__chrono/day.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/day.h'}}
#include <__chrono/duration.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/duration.h'}}
#include <__chrono/file_clock.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/file_clock.h'}}
#include <__chrono/hh_mm_ss.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/hh_mm_ss.h'}}
#include <__chrono/high_resolution_clock.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/high_resolution_clock.h'}}
#include <__chrono/literals.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/literals.h'}}
#include <__chrono/month.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/month.h'}}
#include <__chrono/month_weekday.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/month_weekday.h'}}
#include <__chrono/monthday.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/monthday.h'}}
#include <__chrono/steady_clock.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/steady_clock.h'}}
#include <__chrono/system_clock.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/system_clock.h'}}
#include <__chrono/time_point.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/time_point.h'}}
#include <__chrono/weekday.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/weekday.h'}}
#include <__chrono/year.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/year.h'}}
#include <__chrono/year_month.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/year_month.h'}}
#include <__chrono/year_month_day.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/year_month_day.h'}}
#include <__chrono/year_month_weekday.h> // expected-error@*:* {{use of private header from outside its module: '__chrono/year_month_weekday.h'}}
#include <__compare/common_comparison_category.h> // expected-error@*:* {{use of private header from outside its module: '__compare/common_comparison_category.h'}}
#include <__compare/compare_partial_order_fallback.h> // expected-error@*:* {{use of private header from outside its module: '__compare/compare_partial_order_fallback.h'}}
#include <__compare/compare_strong_order_fallback.h> // expected-error@*:* {{use of private header from outside its module: '__compare/compare_strong_order_fallback.h'}}
#include <__compare/compare_three_way.h> // expected-error@*:* {{use of private header from outside its module: '__compare/compare_three_way.h'}}
#include <__compare/compare_three_way_result.h> // expected-error@*:* {{use of private header from outside its module: '__compare/compare_three_way_result.h'}}
#include <__compare/compare_weak_order_fallback.h> // expected-error@*:* {{use of private header from outside its module: '__compare/compare_weak_order_fallback.h'}}
#include <__compare/is_eq.h> // expected-error@*:* {{use of private header from outside its module: '__compare/is_eq.h'}}
#include <__compare/ordering.h> // expected-error@*:* {{use of private header from outside its module: '__compare/ordering.h'}}
#include <__compare/partial_order.h> // expected-error@*:* {{use of private header from outside its module: '__compare/partial_order.h'}}
#include <__compare/strong_order.h> // expected-error@*:* {{use of private header from outside its module: '__compare/strong_order.h'}}
#include <__compare/synth_three_way.h> // expected-error@*:* {{use of private header from outside its module: '__compare/synth_three_way.h'}}
#include <__compare/three_way_comparable.h> // expected-error@*:* {{use of private header from outside its module: '__compare/three_way_comparable.h'}}
#include <__compare/weak_order.h> // expected-error@*:* {{use of private header from outside its module: '__compare/weak_order.h'}}
#include <__concepts/arithmetic.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/arithmetic.h'}}
#include <__concepts/assignable.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/assignable.h'}}
#include <__concepts/boolean_testable.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/boolean_testable.h'}}
#include <__concepts/class_or_enum.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/class_or_enum.h'}}
#include <__concepts/common_reference_with.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/common_reference_with.h'}}
#include <__concepts/common_with.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/common_with.h'}}
#include <__concepts/constructible.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/constructible.h'}}
#include <__concepts/convertible_to.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/convertible_to.h'}}
#include <__concepts/copyable.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/copyable.h'}}
#include <__concepts/derived_from.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/derived_from.h'}}
#include <__concepts/destructible.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/destructible.h'}}
#include <__concepts/different_from.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/different_from.h'}}
#include <__concepts/equality_comparable.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/equality_comparable.h'}}
#include <__concepts/invocable.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/invocable.h'}}
#include <__concepts/movable.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/movable.h'}}
#include <__concepts/predicate.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/predicate.h'}}
#include <__concepts/regular.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/regular.h'}}
#include <__concepts/relation.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/relation.h'}}
#include <__concepts/same_as.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/same_as.h'}}
#include <__concepts/semiregular.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/semiregular.h'}}
#include <__concepts/swappable.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/swappable.h'}}
#include <__concepts/totally_ordered.h> // expected-error@*:* {{use of private header from outside its module: '__concepts/totally_ordered.h'}}
#include <__coroutine/coroutine_handle.h> // expected-error@*:* {{use of private header from outside its module: '__coroutine/coroutine_handle.h'}}
#include <__coroutine/coroutine_traits.h> // expected-error@*:* {{use of private header from outside its module: '__coroutine/coroutine_traits.h'}}
#include <__coroutine/noop_coroutine_handle.h> // expected-error@*:* {{use of private header from outside its module: '__coroutine/noop_coroutine_handle.h'}}
#include <__coroutine/trivial_awaitables.h> // expected-error@*:* {{use of private header from outside its module: '__coroutine/trivial_awaitables.h'}}
#include <__debug_utils/randomize_range.h> // expected-error@*:* {{use of private header from outside its module: '__debug_utils/randomize_range.h'}}
#include <__errc> // expected-error@*:* {{use of private header from outside its module: '__errc'}}
#include <__filesystem/copy_options.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/copy_options.h'}}
#include <__filesystem/directory_entry.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/directory_entry.h'}}
#include <__filesystem/directory_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/directory_iterator.h'}}
#include <__filesystem/directory_options.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/directory_options.h'}}
#include <__filesystem/file_status.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/file_status.h'}}
#include <__filesystem/file_time_type.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/file_time_type.h'}}
#include <__filesystem/file_type.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/file_type.h'}}
#include <__filesystem/filesystem_error.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/filesystem_error.h'}}
#include <__filesystem/operations.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/operations.h'}}
#include <__filesystem/path.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/path.h'}}
#include <__filesystem/path_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/path_iterator.h'}}
#include <__filesystem/perm_options.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/perm_options.h'}}
#include <__filesystem/perms.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/perms.h'}}
#include <__filesystem/recursive_directory_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/recursive_directory_iterator.h'}}
#include <__filesystem/space_info.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/space_info.h'}}
#include <__filesystem/u8path.h> // expected-error@*:* {{use of private header from outside its module: '__filesystem/u8path.h'}}
#include <__format/buffer.h> // expected-error@*:* {{use of private header from outside its module: '__format/buffer.h'}}
#include <__format/concepts.h> // expected-error@*:* {{use of private header from outside its module: '__format/concepts.h'}}
#include <__format/enable_insertable.h> // expected-error@*:* {{use of private header from outside its module: '__format/enable_insertable.h'}}
#include <__format/extended_grapheme_cluster_table.h> // expected-error@*:* {{use of private header from outside its module: '__format/extended_grapheme_cluster_table.h'}}
#include <__format/format_arg.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_arg.h'}}
#include <__format/format_arg_store.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_arg_store.h'}}
#include <__format/format_args.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_args.h'}}
#include <__format/format_context.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_context.h'}}
#include <__format/format_error.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_error.h'}}
#include <__format/format_fwd.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_fwd.h'}}
#include <__format/format_parse_context.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_parse_context.h'}}
#include <__format/format_string.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_string.h'}}
#include <__format/format_to_n_result.h> // expected-error@*:* {{use of private header from outside its module: '__format/format_to_n_result.h'}}
#include <__format/formatter.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter.h'}}
#include <__format/formatter_bool.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter_bool.h'}}
#include <__format/formatter_char.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter_char.h'}}
#include <__format/formatter_floating_point.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter_floating_point.h'}}
#include <__format/formatter_integer.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter_integer.h'}}
#include <__format/formatter_integral.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter_integral.h'}}
#include <__format/formatter_output.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter_output.h'}}
#include <__format/formatter_pointer.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter_pointer.h'}}
#include <__format/formatter_string.h> // expected-error@*:* {{use of private header from outside its module: '__format/formatter_string.h'}}
#include <__format/parser_std_format_spec.h> // expected-error@*:* {{use of private header from outside its module: '__format/parser_std_format_spec.h'}}
#include <__format/unicode.h> // expected-error@*:* {{use of private header from outside its module: '__format/unicode.h'}}
#include <__functional/binary_function.h> // expected-error@*:* {{use of private header from outside its module: '__functional/binary_function.h'}}
#include <__functional/binary_negate.h> // expected-error@*:* {{use of private header from outside its module: '__functional/binary_negate.h'}}
#include <__functional/bind.h> // expected-error@*:* {{use of private header from outside its module: '__functional/bind.h'}}
#include <__functional/bind_back.h> // expected-error@*:* {{use of private header from outside its module: '__functional/bind_back.h'}}
#include <__functional/bind_front.h> // expected-error@*:* {{use of private header from outside its module: '__functional/bind_front.h'}}
#include <__functional/binder1st.h> // expected-error@*:* {{use of private header from outside its module: '__functional/binder1st.h'}}
#include <__functional/binder2nd.h> // expected-error@*:* {{use of private header from outside its module: '__functional/binder2nd.h'}}
#include <__functional/boyer_moore_searcher.h> // expected-error@*:* {{use of private header from outside its module: '__functional/boyer_moore_searcher.h'}}
#include <__functional/compose.h> // expected-error@*:* {{use of private header from outside its module: '__functional/compose.h'}}
#include <__functional/default_searcher.h> // expected-error@*:* {{use of private header from outside its module: '__functional/default_searcher.h'}}
#include <__functional/function.h> // expected-error@*:* {{use of private header from outside its module: '__functional/function.h'}}
#include <__functional/hash.h> // expected-error@*:* {{use of private header from outside its module: '__functional/hash.h'}}
#include <__functional/identity.h> // expected-error@*:* {{use of private header from outside its module: '__functional/identity.h'}}
#include <__functional/invoke.h> // expected-error@*:* {{use of private header from outside its module: '__functional/invoke.h'}}
#include <__functional/is_transparent.h> // expected-error@*:* {{use of private header from outside its module: '__functional/is_transparent.h'}}
#include <__functional/mem_fn.h> // expected-error@*:* {{use of private header from outside its module: '__functional/mem_fn.h'}}
#include <__functional/mem_fun_ref.h> // expected-error@*:* {{use of private header from outside its module: '__functional/mem_fun_ref.h'}}
#include <__functional/not_fn.h> // expected-error@*:* {{use of private header from outside its module: '__functional/not_fn.h'}}
#include <__functional/operations.h> // expected-error@*:* {{use of private header from outside its module: '__functional/operations.h'}}
#include <__functional/perfect_forward.h> // expected-error@*:* {{use of private header from outside its module: '__functional/perfect_forward.h'}}
#include <__functional/pointer_to_binary_function.h> // expected-error@*:* {{use of private header from outside its module: '__functional/pointer_to_binary_function.h'}}
#include <__functional/pointer_to_unary_function.h> // expected-error@*:* {{use of private header from outside its module: '__functional/pointer_to_unary_function.h'}}
#include <__functional/ranges_operations.h> // expected-error@*:* {{use of private header from outside its module: '__functional/ranges_operations.h'}}
#include <__functional/reference_wrapper.h> // expected-error@*:* {{use of private header from outside its module: '__functional/reference_wrapper.h'}}
#include <__functional/unary_function.h> // expected-error@*:* {{use of private header from outside its module: '__functional/unary_function.h'}}
#include <__functional/unary_negate.h> // expected-error@*:* {{use of private header from outside its module: '__functional/unary_negate.h'}}
#include <__functional/unwrap_ref.h> // expected-error@*:* {{use of private header from outside its module: '__functional/unwrap_ref.h'}}
#include <__functional/weak_result_type.h> // expected-error@*:* {{use of private header from outside its module: '__functional/weak_result_type.h'}}
#include <__fwd/span.h> // expected-error@*:* {{use of private header from outside its module: '__fwd/span.h'}}
#include <__fwd/string_view.h> // expected-error@*:* {{use of private header from outside its module: '__fwd/string_view.h'}}
#include <__ios/fpos.h> // expected-error@*:* {{use of private header from outside its module: '__ios/fpos.h'}}
#include <__iterator/access.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/access.h'}}
#include <__iterator/advance.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/advance.h'}}
#include <__iterator/back_insert_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/back_insert_iterator.h'}}
#include <__iterator/bounded_iter.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/bounded_iter.h'}}
#include <__iterator/common_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/common_iterator.h'}}
#include <__iterator/concepts.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/concepts.h'}}
#include <__iterator/counted_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/counted_iterator.h'}}
#include <__iterator/data.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/data.h'}}
#include <__iterator/default_sentinel.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/default_sentinel.h'}}
#include <__iterator/distance.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/distance.h'}}
#include <__iterator/empty.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/empty.h'}}
#include <__iterator/erase_if_container.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/erase_if_container.h'}}
#include <__iterator/front_insert_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/front_insert_iterator.h'}}
#include <__iterator/incrementable_traits.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/incrementable_traits.h'}}
#include <__iterator/indirectly_comparable.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/indirectly_comparable.h'}}
#include <__iterator/insert_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/insert_iterator.h'}}
#include <__iterator/istream_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/istream_iterator.h'}}
#include <__iterator/istreambuf_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/istreambuf_iterator.h'}}
#include <__iterator/iter_move.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/iter_move.h'}}
#include <__iterator/iter_swap.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/iter_swap.h'}}
#include <__iterator/iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/iterator.h'}}
#include <__iterator/iterator_traits.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/iterator_traits.h'}}
#include <__iterator/mergeable.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/mergeable.h'}}
#include <__iterator/move_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/move_iterator.h'}}
#include <__iterator/move_sentinel.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/move_sentinel.h'}}
#include <__iterator/next.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/next.h'}}
#include <__iterator/ostream_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/ostream_iterator.h'}}
#include <__iterator/ostreambuf_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/ostreambuf_iterator.h'}}
#include <__iterator/permutable.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/permutable.h'}}
#include <__iterator/prev.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/prev.h'}}
#include <__iterator/projected.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/projected.h'}}
#include <__iterator/readable_traits.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/readable_traits.h'}}
#include <__iterator/reverse_access.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/reverse_access.h'}}
#include <__iterator/reverse_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/reverse_iterator.h'}}
#include <__iterator/size.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/size.h'}}
#include <__iterator/sortable.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/sortable.h'}}
#include <__iterator/unreachable_sentinel.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/unreachable_sentinel.h'}}
#include <__iterator/wrap_iter.h> // expected-error@*:* {{use of private header from outside its module: '__iterator/wrap_iter.h'}}
#include <__locale> // expected-error@*:* {{use of private header from outside its module: '__locale'}}
#include <__mbstate_t.h> // expected-error@*:* {{use of private header from outside its module: '__mbstate_t.h'}}
#include <__memory/addressof.h> // expected-error@*:* {{use of private header from outside its module: '__memory/addressof.h'}}
#include <__memory/allocate_at_least.h> // expected-error@*:* {{use of private header from outside its module: '__memory/allocate_at_least.h'}}
#include <__memory/allocation_guard.h> // expected-error@*:* {{use of private header from outside its module: '__memory/allocation_guard.h'}}
#include <__memory/allocator.h> // expected-error@*:* {{use of private header from outside its module: '__memory/allocator.h'}}
#include <__memory/allocator_arg_t.h> // expected-error@*:* {{use of private header from outside its module: '__memory/allocator_arg_t.h'}}
#include <__memory/allocator_traits.h> // expected-error@*:* {{use of private header from outside its module: '__memory/allocator_traits.h'}}
#include <__memory/assume_aligned.h> // expected-error@*:* {{use of private header from outside its module: '__memory/assume_aligned.h'}}
#include <__memory/auto_ptr.h> // expected-error@*:* {{use of private header from outside its module: '__memory/auto_ptr.h'}}
#include <__memory/compressed_pair.h> // expected-error@*:* {{use of private header from outside its module: '__memory/compressed_pair.h'}}
#include <__memory/concepts.h> // expected-error@*:* {{use of private header from outside its module: '__memory/concepts.h'}}
#include <__memory/construct_at.h> // expected-error@*:* {{use of private header from outside its module: '__memory/construct_at.h'}}
#include <__memory/pointer_traits.h> // expected-error@*:* {{use of private header from outside its module: '__memory/pointer_traits.h'}}
#include <__memory/ranges_construct_at.h> // expected-error@*:* {{use of private header from outside its module: '__memory/ranges_construct_at.h'}}
#include <__memory/ranges_uninitialized_algorithms.h> // expected-error@*:* {{use of private header from outside its module: '__memory/ranges_uninitialized_algorithms.h'}}
#include <__memory/raw_storage_iterator.h> // expected-error@*:* {{use of private header from outside its module: '__memory/raw_storage_iterator.h'}}
#include <__memory/shared_ptr.h> // expected-error@*:* {{use of private header from outside its module: '__memory/shared_ptr.h'}}
#include <__memory/swap_allocator.h> // expected-error@*:* {{use of private header from outside its module: '__memory/swap_allocator.h'}}
#include <__memory/temporary_buffer.h> // expected-error@*:* {{use of private header from outside its module: '__memory/temporary_buffer.h'}}
#include <__memory/uninitialized_algorithms.h> // expected-error@*:* {{use of private header from outside its module: '__memory/uninitialized_algorithms.h'}}
#include <__memory/unique_ptr.h> // expected-error@*:* {{use of private header from outside its module: '__memory/unique_ptr.h'}}
#include <__memory/uses_allocator.h> // expected-error@*:* {{use of private header from outside its module: '__memory/uses_allocator.h'}}
#include <__memory/voidify.h> // expected-error@*:* {{use of private header from outside its module: '__memory/voidify.h'}}
#include <__mutex_base> // expected-error@*:* {{use of private header from outside its module: '__mutex_base'}}
#include <__node_handle> // expected-error@*:* {{use of private header from outside its module: '__node_handle'}}
#include <__numeric/accumulate.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/accumulate.h'}}
#include <__numeric/adjacent_difference.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/adjacent_difference.h'}}
#include <__numeric/exclusive_scan.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/exclusive_scan.h'}}
#include <__numeric/gcd_lcm.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/gcd_lcm.h'}}
#include <__numeric/inclusive_scan.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/inclusive_scan.h'}}
#include <__numeric/inner_product.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/inner_product.h'}}
#include <__numeric/iota.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/iota.h'}}
#include <__numeric/midpoint.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/midpoint.h'}}
#include <__numeric/partial_sum.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/partial_sum.h'}}
#include <__numeric/reduce.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/reduce.h'}}
#include <__numeric/transform_exclusive_scan.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/transform_exclusive_scan.h'}}
#include <__numeric/transform_inclusive_scan.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/transform_inclusive_scan.h'}}
#include <__numeric/transform_reduce.h> // expected-error@*:* {{use of private header from outside its module: '__numeric/transform_reduce.h'}}
#include <__random/bernoulli_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/bernoulli_distribution.h'}}
#include <__random/binomial_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/binomial_distribution.h'}}
#include <__random/cauchy_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/cauchy_distribution.h'}}
#include <__random/chi_squared_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/chi_squared_distribution.h'}}
#include <__random/clamp_to_integral.h> // expected-error@*:* {{use of private header from outside its module: '__random/clamp_to_integral.h'}}
#include <__random/default_random_engine.h> // expected-error@*:* {{use of private header from outside its module: '__random/default_random_engine.h'}}
#include <__random/discard_block_engine.h> // expected-error@*:* {{use of private header from outside its module: '__random/discard_block_engine.h'}}
#include <__random/discrete_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/discrete_distribution.h'}}
#include <__random/exponential_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/exponential_distribution.h'}}
#include <__random/extreme_value_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/extreme_value_distribution.h'}}
#include <__random/fisher_f_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/fisher_f_distribution.h'}}
#include <__random/gamma_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/gamma_distribution.h'}}
#include <__random/generate_canonical.h> // expected-error@*:* {{use of private header from outside its module: '__random/generate_canonical.h'}}
#include <__random/geometric_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/geometric_distribution.h'}}
#include <__random/independent_bits_engine.h> // expected-error@*:* {{use of private header from outside its module: '__random/independent_bits_engine.h'}}
#include <__random/is_seed_sequence.h> // expected-error@*:* {{use of private header from outside its module: '__random/is_seed_sequence.h'}}
#include <__random/is_valid.h> // expected-error@*:* {{use of private header from outside its module: '__random/is_valid.h'}}
#include <__random/knuth_b.h> // expected-error@*:* {{use of private header from outside its module: '__random/knuth_b.h'}}
#include <__random/linear_congruential_engine.h> // expected-error@*:* {{use of private header from outside its module: '__random/linear_congruential_engine.h'}}
#include <__random/log2.h> // expected-error@*:* {{use of private header from outside its module: '__random/log2.h'}}
#include <__random/lognormal_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/lognormal_distribution.h'}}
#include <__random/mersenne_twister_engine.h> // expected-error@*:* {{use of private header from outside its module: '__random/mersenne_twister_engine.h'}}
#include <__random/negative_binomial_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/negative_binomial_distribution.h'}}
#include <__random/normal_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/normal_distribution.h'}}
#include <__random/piecewise_constant_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/piecewise_constant_distribution.h'}}
#include <__random/piecewise_linear_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/piecewise_linear_distribution.h'}}
#include <__random/poisson_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/poisson_distribution.h'}}
#include <__random/random_device.h> // expected-error@*:* {{use of private header from outside its module: '__random/random_device.h'}}
#include <__random/ranlux.h> // expected-error@*:* {{use of private header from outside its module: '__random/ranlux.h'}}
#include <__random/seed_seq.h> // expected-error@*:* {{use of private header from outside its module: '__random/seed_seq.h'}}
#include <__random/shuffle_order_engine.h> // expected-error@*:* {{use of private header from outside its module: '__random/shuffle_order_engine.h'}}
#include <__random/student_t_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/student_t_distribution.h'}}
#include <__random/subtract_with_carry_engine.h> // expected-error@*:* {{use of private header from outside its module: '__random/subtract_with_carry_engine.h'}}
#include <__random/uniform_int_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/uniform_int_distribution.h'}}
#include <__random/uniform_random_bit_generator.h> // expected-error@*:* {{use of private header from outside its module: '__random/uniform_random_bit_generator.h'}}
#include <__random/uniform_real_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/uniform_real_distribution.h'}}
#include <__random/weibull_distribution.h> // expected-error@*:* {{use of private header from outside its module: '__random/weibull_distribution.h'}}
#include <__ranges/access.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/access.h'}}
#include <__ranges/all.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/all.h'}}
#include <__ranges/common_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/common_view.h'}}
#include <__ranges/concepts.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/concepts.h'}}
#include <__ranges/copyable_box.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/copyable_box.h'}}
#include <__ranges/counted.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/counted.h'}}
#include <__ranges/dangling.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/dangling.h'}}
#include <__ranges/data.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/data.h'}}
#include <__ranges/drop_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/drop_view.h'}}
#include <__ranges/empty.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/empty.h'}}
#include <__ranges/empty_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/empty_view.h'}}
#include <__ranges/enable_borrowed_range.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/enable_borrowed_range.h'}}
#include <__ranges/enable_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/enable_view.h'}}
#include <__ranges/filter_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/filter_view.h'}}
#include <__ranges/iota_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/iota_view.h'}}
#include <__ranges/join_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/join_view.h'}}
#include <__ranges/lazy_split_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/lazy_split_view.h'}}
#include <__ranges/non_propagating_cache.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/non_propagating_cache.h'}}
#include <__ranges/owning_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/owning_view.h'}}
#include <__ranges/range_adaptor.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/range_adaptor.h'}}
#include <__ranges/rbegin.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/rbegin.h'}}
#include <__ranges/ref_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/ref_view.h'}}
#include <__ranges/rend.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/rend.h'}}
#include <__ranges/reverse_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/reverse_view.h'}}
#include <__ranges/single_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/single_view.h'}}
#include <__ranges/size.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/size.h'}}
#include <__ranges/subrange.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/subrange.h'}}
#include <__ranges/take_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/take_view.h'}}
#include <__ranges/transform_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/transform_view.h'}}
#include <__ranges/view_interface.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/view_interface.h'}}
#include <__ranges/views.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/views.h'}}
#include <__ranges/zip_view.h> // expected-error@*:* {{use of private header from outside its module: '__ranges/zip_view.h'}}
#include <__split_buffer> // expected-error@*:* {{use of private header from outside its module: '__split_buffer'}}
#include <__std_stream> // expected-error@*:* {{use of private header from outside its module: '__std_stream'}}
#include <__string/char_traits.h> // expected-error@*:* {{use of private header from outside its module: '__string/char_traits.h'}}
#include <__string/extern_template_lists.h> // expected-error@*:* {{use of private header from outside its module: '__string/extern_template_lists.h'}}
#include <__thread/poll_with_backoff.h> // expected-error@*:* {{use of private header from outside its module: '__thread/poll_with_backoff.h'}}
#include <__thread/timed_backoff_policy.h> // expected-error@*:* {{use of private header from outside its module: '__thread/timed_backoff_policy.h'}}
#include <__tuple> // expected-error@*:* {{use of private header from outside its module: '__tuple'}}
#include <__type_traits/add_const.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/add_const.h'}}
#include <__type_traits/add_cv.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/add_cv.h'}}
#include <__type_traits/add_lvalue_reference.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/add_lvalue_reference.h'}}
#include <__type_traits/add_pointer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/add_pointer.h'}}
#include <__type_traits/add_rvalue_reference.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/add_rvalue_reference.h'}}
#include <__type_traits/add_volatile.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/add_volatile.h'}}
#include <__type_traits/aligned_storage.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/aligned_storage.h'}}
#include <__type_traits/aligned_union.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/aligned_union.h'}}
#include <__type_traits/alignment_of.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/alignment_of.h'}}
#include <__type_traits/apply_cv.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/apply_cv.h'}}
#include <__type_traits/common_reference.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/common_reference.h'}}
#include <__type_traits/common_type.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/common_type.h'}}
#include <__type_traits/conditional.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/conditional.h'}}
#include <__type_traits/conjunction.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/conjunction.h'}}
#include <__type_traits/copy_cv.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/copy_cv.h'}}
#include <__type_traits/copy_cvref.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/copy_cvref.h'}}
#include <__type_traits/decay.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/decay.h'}}
#include <__type_traits/disjunction.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/disjunction.h'}}
#include <__type_traits/enable_if.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/enable_if.h'}}
#include <__type_traits/extent.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/extent.h'}}
#include <__type_traits/has_unique_object_representation.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/has_unique_object_representation.h'}}
#include <__type_traits/has_virtual_destructor.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/has_virtual_destructor.h'}}
#include <__type_traits/integral_constant.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/integral_constant.h'}}
#include <__type_traits/is_abstract.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_abstract.h'}}
#include <__type_traits/is_aggregate.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_aggregate.h'}}
#include <__type_traits/is_arithmetic.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_arithmetic.h'}}
#include <__type_traits/is_array.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_array.h'}}
#include <__type_traits/is_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_assignable.h'}}
#include <__type_traits/is_base_of.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_base_of.h'}}
#include <__type_traits/is_bounded_array.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_bounded_array.h'}}
#include <__type_traits/is_callable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_callable.h'}}
#include <__type_traits/is_class.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_class.h'}}
#include <__type_traits/is_compound.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_compound.h'}}
#include <__type_traits/is_const.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_const.h'}}
#include <__type_traits/is_constant_evaluated.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_constant_evaluated.h'}}
#include <__type_traits/is_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_constructible.h'}}
#include <__type_traits/is_convertible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_convertible.h'}}
#include <__type_traits/is_copy_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_copy_assignable.h'}}
#include <__type_traits/is_copy_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_copy_constructible.h'}}
#include <__type_traits/is_core_convertible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_core_convertible.h'}}
#include <__type_traits/is_default_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_default_constructible.h'}}
#include <__type_traits/is_destructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_destructible.h'}}
#include <__type_traits/is_empty.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_empty.h'}}
#include <__type_traits/is_enum.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_enum.h'}}
#include <__type_traits/is_final.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_final.h'}}
#include <__type_traits/is_floating_point.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_floating_point.h'}}
#include <__type_traits/is_function.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_function.h'}}
#include <__type_traits/is_fundamental.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_fundamental.h'}}
#include <__type_traits/is_integral.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_integral.h'}}
#include <__type_traits/is_literal_type.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_literal_type.h'}}
#include <__type_traits/is_member_function_pointer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_member_function_pointer.h'}}
#include <__type_traits/is_member_object_pointer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_member_object_pointer.h'}}
#include <__type_traits/is_member_pointer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_member_pointer.h'}}
#include <__type_traits/is_move_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_move_assignable.h'}}
#include <__type_traits/is_move_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_move_constructible.h'}}
#include <__type_traits/is_nothrow_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_assignable.h'}}
#include <__type_traits/is_nothrow_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_constructible.h'}}
#include <__type_traits/is_nothrow_convertible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_convertible.h'}}
#include <__type_traits/is_nothrow_copy_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_copy_assignable.h'}}
#include <__type_traits/is_nothrow_copy_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_copy_constructible.h'}}
#include <__type_traits/is_nothrow_default_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_default_constructible.h'}}
#include <__type_traits/is_nothrow_destructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_destructible.h'}}
#include <__type_traits/is_nothrow_move_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_move_assignable.h'}}
#include <__type_traits/is_nothrow_move_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_nothrow_move_constructible.h'}}
#include <__type_traits/is_null_pointer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_null_pointer.h'}}
#include <__type_traits/is_object.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_object.h'}}
#include <__type_traits/is_pod.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_pod.h'}}
#include <__type_traits/is_pointer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_pointer.h'}}
#include <__type_traits/is_polymorphic.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_polymorphic.h'}}
#include <__type_traits/is_primary_template.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_primary_template.h'}}
#include <__type_traits/is_reference.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_reference.h'}}
#include <__type_traits/is_reference_wrapper.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_reference_wrapper.h'}}
#include <__type_traits/is_referenceable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_referenceable.h'}}
#include <__type_traits/is_same.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_same.h'}}
#include <__type_traits/is_scalar.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_scalar.h'}}
#include <__type_traits/is_scoped_enum.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_scoped_enum.h'}}
#include <__type_traits/is_signed.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_signed.h'}}
#include <__type_traits/is_signed_integer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_signed_integer.h'}}
#include <__type_traits/is_standard_layout.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_standard_layout.h'}}
#include <__type_traits/is_trivial.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivial.h'}}
#include <__type_traits/is_trivially_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_assignable.h'}}
#include <__type_traits/is_trivially_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_constructible.h'}}
#include <__type_traits/is_trivially_copy_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_copy_assignable.h'}}
#include <__type_traits/is_trivially_copy_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_copy_constructible.h'}}
#include <__type_traits/is_trivially_copyable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_copyable.h'}}
#include <__type_traits/is_trivially_default_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_default_constructible.h'}}
#include <__type_traits/is_trivially_destructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_destructible.h'}}
#include <__type_traits/is_trivially_move_assignable.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_move_assignable.h'}}
#include <__type_traits/is_trivially_move_constructible.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_trivially_move_constructible.h'}}
#include <__type_traits/is_unbounded_array.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_unbounded_array.h'}}
#include <__type_traits/is_union.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_union.h'}}
#include <__type_traits/is_unsigned.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_unsigned.h'}}
#include <__type_traits/is_unsigned_integer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_unsigned_integer.h'}}
#include <__type_traits/is_valid_expansion.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_valid_expansion.h'}}
#include <__type_traits/is_void.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_void.h'}}
#include <__type_traits/is_volatile.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/is_volatile.h'}}
#include <__type_traits/lazy.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/lazy.h'}}
#include <__type_traits/make_32_64_or_128_bit.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/make_32_64_or_128_bit.h'}}
#include <__type_traits/make_signed.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/make_signed.h'}}
#include <__type_traits/make_unsigned.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/make_unsigned.h'}}
#include <__type_traits/nat.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/nat.h'}}
#include <__type_traits/negation.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/negation.h'}}
#include <__type_traits/promote.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/promote.h'}}
#include <__type_traits/rank.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/rank.h'}}
#include <__type_traits/remove_all_extents.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/remove_all_extents.h'}}
#include <__type_traits/remove_const.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/remove_const.h'}}
#include <__type_traits/remove_cv.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/remove_cv.h'}}
#include <__type_traits/remove_cvref.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/remove_cvref.h'}}
#include <__type_traits/remove_extent.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/remove_extent.h'}}
#include <__type_traits/remove_pointer.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/remove_pointer.h'}}
#include <__type_traits/remove_reference.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/remove_reference.h'}}
#include <__type_traits/remove_volatile.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/remove_volatile.h'}}
#include <__type_traits/type_identity.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/type_identity.h'}}
#include <__type_traits/type_list.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/type_list.h'}}
#include <__type_traits/underlying_type.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/underlying_type.h'}}
#include <__type_traits/void_t.h> // expected-error@*:* {{use of private header from outside its module: '__type_traits/void_t.h'}}
#include <__utility/as_const.h> // expected-error@*:* {{use of private header from outside its module: '__utility/as_const.h'}}
#include <__utility/auto_cast.h> // expected-error@*:* {{use of private header from outside its module: '__utility/auto_cast.h'}}
#include <__utility/cmp.h> // expected-error@*:* {{use of private header from outside its module: '__utility/cmp.h'}}
#include <__utility/declval.h> // expected-error@*:* {{use of private header from outside its module: '__utility/declval.h'}}
#include <__utility/exchange.h> // expected-error@*:* {{use of private header from outside its module: '__utility/exchange.h'}}
#include <__utility/forward.h> // expected-error@*:* {{use of private header from outside its module: '__utility/forward.h'}}
#include <__utility/in_place.h> // expected-error@*:* {{use of private header from outside its module: '__utility/in_place.h'}}
#include <__utility/integer_sequence.h> // expected-error@*:* {{use of private header from outside its module: '__utility/integer_sequence.h'}}
#include <__utility/move.h> // expected-error@*:* {{use of private header from outside its module: '__utility/move.h'}}
#include <__utility/pair.h> // expected-error@*:* {{use of private header from outside its module: '__utility/pair.h'}}
#include <__utility/piecewise_construct.h> // expected-error@*:* {{use of private header from outside its module: '__utility/piecewise_construct.h'}}
#include <__utility/priority_tag.h> // expected-error@*:* {{use of private header from outside its module: '__utility/priority_tag.h'}}
#include <__utility/rel_ops.h> // expected-error@*:* {{use of private header from outside its module: '__utility/rel_ops.h'}}
#include <__utility/swap.h> // expected-error@*:* {{use of private header from outside its module: '__utility/swap.h'}}
#include <__utility/to_underlying.h> // expected-error@*:* {{use of private header from outside its module: '__utility/to_underlying.h'}}
#include <__utility/transaction.h> // expected-error@*:* {{use of private header from outside its module: '__utility/transaction.h'}}
#include <__utility/unreachable.h> // expected-error@*:* {{use of private header from outside its module: '__utility/unreachable.h'}}
#include <__variant/monostate.h> // expected-error@*:* {{use of private header from outside its module: '__variant/monostate.h'}}
// GENERATED-MARKER
