; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=bonaire -verify-machineinstrs -mattr=+load-store-opt < %s | FileCheck -enable-var-scope --check-prefix=CI %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx900 -verify-machineinstrs -mattr=+load-store-opt,-unaligned-access-mode < %s | FileCheck -enable-var-scope -check-prefixes=GFX9,GFX9-ALIGNED %s
; RUN: llc -mtriple=amdgcn--amdpal -mcpu=gfx900 -verify-machineinstrs -mattr=+load-store-opt,+unaligned-access-mode < %s | FileCheck -enable-var-scope -check-prefixes=GFX9,GFX9-UNALIGNED %s

; FIXME: We don't get cases where the address was an SGPR because we
; get a copy to the address register for each one.

@lds = addrspace(3) global [512 x float] undef, align 4
@lds.f64 = addrspace(3) global [512 x double] undef, align 8

define amdgpu_kernel void @simple_read2_f32(float addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f32:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b32 v[1:2], v0 offset1:8
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX9-NEXT:    ds_read2_b32 v[0:1], v2 offset1:8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %x.i
  %val0 = load float, float addrspace(3)* %arrayidx0, align 4
  %add.x = add nsw i32 %x.i, 8
  %arrayidx1 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %add.x
  %val1 = load float, float addrspace(3)* %arrayidx1, align 4
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @simple_read2_f32_max_offset(float addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f32_max_offset:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b32 v[1:2], v0 offset1:255
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f32_max_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX9-NEXT:    ds_read2_b32 v[0:1], v2 offset1:255
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %x.i
  %val0 = load float, float addrspace(3)* %arrayidx0, align 4
  %add.x = add nsw i32 %x.i, 255
  %arrayidx1 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %add.x
  %val1 = load float, float addrspace(3)* %arrayidx1, align 4
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @simple_read2_f32_too_far(float addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f32_too_far:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b32 v1, v0
; CI-NEXT:    ds_read_b32 v2, v0 offset:1028
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f32_too_far:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    ds_read_b32 v1, v0
; GFX9-NEXT:    ds_read_b32 v2, v0 offset:1028
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %x.i
  %val0 = load float, float addrspace(3)* %arrayidx0, align 4
  %add.x = add nsw i32 %x.i, 257
  %arrayidx1 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %add.x
  %val1 = load float, float addrspace(3)* %arrayidx1, align 4
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @simple_read2_f32_x2(float addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f32_x2:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b32 v[1:2], v0 offset1:8
; CI-NEXT:    ds_read2_b32 v[3:4], v0 offset0:11 offset1:27
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v1, v1, v2
; CI-NEXT:    v_add_f32_e32 v2, v3, v4
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f32_x2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX9-NEXT:    ds_read2_b32 v[0:1], v4 offset1:8
; GFX9-NEXT:    ds_read2_b32 v[2:3], v4 offset0:11 offset1:27
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_f32_e32 v1, v2, v3
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v4, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
  %tid.x = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %idx.0 = add nsw i32 %tid.x, 0
  %arrayidx0 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.0
  %val0 = load float, float addrspace(3)* %arrayidx0, align 4

  %idx.1 = add nsw i32 %tid.x, 8
  %arrayidx1 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.1
  %val1 = load float, float addrspace(3)* %arrayidx1, align 4
  %sum.0 = fadd float %val0, %val1

  %idx.2 = add nsw i32 %tid.x, 11
  %arrayidx2 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.2
  %val2 = load float, float addrspace(3)* %arrayidx2, align 4

  %idx.3 = add nsw i32 %tid.x, 27
  %arrayidx3 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.3
  %val3 = load float, float addrspace(3)* %arrayidx3, align 4
  %sum.1 = fadd float %val2, %val3

  %sum = fadd float %sum.0, %sum.1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %idx.0
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

; Make sure there is an instruction between the two sets of reads.
define amdgpu_kernel void @simple_read2_f32_x2_barrier(float addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f32_x2_barrier:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b32 v[1:2], v0 offset1:8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_barrier
; CI-NEXT:    ds_read2_b32 v[3:4], v0 offset0:11 offset1:27
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    v_add_f32_e32 v1, v1, v2
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v3, v4
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f32_x2_barrier:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX9-NEXT:    ds_read2_b32 v[0:1], v4 offset1:8
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_barrier
; GFX9-NEXT:    ds_read2_b32 v[2:3], v4 offset0:11 offset1:27
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v1, v2, v3
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v4, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
  %tid.x = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %idx.0 = add nsw i32 %tid.x, 0
  %arrayidx0 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.0
  %val0 = load float, float addrspace(3)* %arrayidx0, align 4

  %idx.1 = add nsw i32 %tid.x, 8
  %arrayidx1 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.1
  %val1 = load float, float addrspace(3)* %arrayidx1, align 4
  %sum.0 = fadd float %val0, %val1

  call void @llvm.amdgcn.s.barrier() #2

  %idx.2 = add nsw i32 %tid.x, 11
  %arrayidx2 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.2
  %val2 = load float, float addrspace(3)* %arrayidx2, align 4

  %idx.3 = add nsw i32 %tid.x, 27
  %arrayidx3 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.3
  %val3 = load float, float addrspace(3)* %arrayidx3, align 4
  %sum.1 = fadd float %val2, %val3

  %sum = fadd float %sum.0, %sum.1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %idx.0
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

; For some reason adding something to the base address for the first
; element results in only folding the inner pair.
define amdgpu_kernel void @simple_read2_f32_x2_nonzero_base(float addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f32_x2_nonzero_base:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b32 v[1:2], v0 offset0:2 offset1:8
; CI-NEXT:    ds_read2_b32 v[3:4], v0 offset0:11 offset1:27
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v1, v1, v2
; CI-NEXT:    v_add_f32_e32 v2, v3, v4
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64 offset:8
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f32_x2_nonzero_base:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 2, v0
; GFX9-NEXT:    ds_read2_b32 v[0:1], v4 offset0:2 offset1:8
; GFX9-NEXT:    ds_read2_b32 v[2:3], v4 offset0:11 offset1:27
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_f32_e32 v1, v2, v3
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v4, v0, s[0:1] offset:8
; GFX9-NEXT:    s_endpgm
  %tid.x = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %idx.0 = add nsw i32 %tid.x, 2
  %arrayidx0 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.0
  %val0 = load float, float addrspace(3)* %arrayidx0, align 4

  %idx.1 = add nsw i32 %tid.x, 8
  %arrayidx1 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.1
  %val1 = load float, float addrspace(3)* %arrayidx1, align 4
  %sum.0 = fadd float %val0, %val1

  %idx.2 = add nsw i32 %tid.x, 11
  %arrayidx2 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.2
  %val2 = load float, float addrspace(3)* %arrayidx2, align 4

  %idx.3 = add nsw i32 %tid.x, 27
  %arrayidx3 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %idx.3
  %val3 = load float, float addrspace(3)* %arrayidx3, align 4
  %sum.1 = fadd float %val2, %val3

  %sum = fadd float %sum.0, %sum.1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %idx.0
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

; Be careful of vectors of pointers. We don't know if the 2 pointers
; in the vectors are really the same base, so this is not safe to
; merge.
; Base pointers come from different subregister of same super
; register. We can't safely merge this.
define amdgpu_kernel void @read2_ptr_is_subreg_arg_f32(float addrspace(1)* %out, <2 x float addrspace(3)*> %lds.ptr) #0 {
; CI-LABEL: read2_ptr_is_subreg_arg_f32:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s2
; CI-NEXT:    v_mov_b32_e32 v2, s3
; CI-NEXT:    ds_read_b32 v1, v1 offset:32
; CI-NEXT:    ds_read_b32 v2, v2
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: read2_ptr_is_subreg_arg_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    ds_read_b32 v1, v1 offset:32
; GFX9-NEXT:    ds_read_b32 v2, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %index.0 = insertelement <2 x i32> undef, i32 %x.i, i32 0
  %index.1 = insertelement <2 x i32> %index.0, i32 8, i32 0
  %gep = getelementptr inbounds float, <2 x float addrspace(3)*> %lds.ptr, <2 x i32> %index.1
  %gep.0 = extractelement <2 x float addrspace(3)*> %gep, i32 0
  %gep.1 = extractelement <2 x float addrspace(3)*> %gep, i32 1
  %val0 = load float, float addrspace(3)* %gep.0, align 4
  %val1 = load float, float addrspace(3)* %gep.1, align 4
  %add.x = add nsw i32 %x.i, 8
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

; Apply a constant scalar offset after the pointer vector extract.  We
; are rejecting merges that have the same, constant 0 offset, so make
; sure we are really rejecting it because of the different
; subregisters.
define amdgpu_kernel void @read2_ptr_is_subreg_arg_offset_f32(float addrspace(1)* %out, <2 x float addrspace(3)*> %lds.ptr) #0 {
; CI-LABEL: read2_ptr_is_subreg_arg_offset_f32:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s2
; CI-NEXT:    v_mov_b32_e32 v2, s3
; CI-NEXT:    ds_read_b32 v1, v1 offset:32
; CI-NEXT:    ds_read_b32 v2, v2 offset:32
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: read2_ptr_is_subreg_arg_offset_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    ds_read_b32 v1, v1 offset:32
; GFX9-NEXT:    ds_read_b32 v2, v2 offset:32
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %index.0 = insertelement <2 x i32> undef, i32 %x.i, i32 0
  %index.1 = insertelement <2 x i32> %index.0, i32 8, i32 0
  %gep = getelementptr inbounds float, <2 x float addrspace(3)*> %lds.ptr, <2 x i32> %index.1
  %gep.0 = extractelement <2 x float addrspace(3)*> %gep, i32 0
  %gep.1 = extractelement <2 x float addrspace(3)*> %gep, i32 1

  ; Apply an additional offset after the vector that will be more obviously folded.
  %gep.1.offset = getelementptr float, float addrspace(3)* %gep.1, i32 8

  %val0 = load float, float addrspace(3)* %gep.0, align 4
  %val1 = load float, float addrspace(3)* %gep.1.offset, align 4
  %add.x = add nsw i32 %x.i, 8
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @read2_ptr_is_subreg_f32(float addrspace(1)* %out) #0 {
; CI-LABEL: read2_ptr_is_subreg_f32:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b32 v[1:2], v0 offset1:8
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: read2_ptr_is_subreg_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX9-NEXT:    ds_read2_b32 v[0:1], v2 offset1:8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %ptr.0 = insertelement <2 x [512 x float] addrspace(3)*> undef, [512 x float] addrspace(3)* @lds, i32 0
  %ptr.1 = insertelement <2 x [512 x float] addrspace(3)*> %ptr.0, [512 x float] addrspace(3)* @lds, i32 1
  %x.i.v.0 = insertelement <2 x i32> undef, i32 %x.i, i32 0
  %x.i.v.1 = insertelement <2 x i32> %x.i.v.0, i32 %x.i, i32 1
  %idx = add <2 x i32> %x.i.v.1, <i32 0, i32 8>
  %gep = getelementptr inbounds [512 x float], <2 x [512 x float] addrspace(3)*> %ptr.1, <2 x i32> <i32 0, i32 0>, <2 x i32> %idx
  %gep.0 = extractelement <2 x float addrspace(3)*> %gep, i32 0
  %gep.1 = extractelement <2 x float addrspace(3)*> %gep, i32 1
  %val0 = load float, float addrspace(3)* %gep.0, align 4
  %val1 = load float, float addrspace(3)* %gep.1, align 4
  %add.x = add nsw i32 %x.i, 8
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @simple_read2_f32_volatile_0(float addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f32_volatile_0:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b32 v1, v0
; CI-NEXT:    ds_read_b32 v2, v0 offset:32
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f32_volatile_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    ds_read_b32 v1, v0
; GFX9-NEXT:    ds_read_b32 v2, v0 offset:32
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %x.i
  %val0 = load volatile float, float addrspace(3)* %arrayidx0, align 4
  %add.x = add nsw i32 %x.i, 8
  %arrayidx1 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %add.x
  %val1 = load float, float addrspace(3)* %arrayidx1, align 4
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @simple_read2_f32_volatile_1(float addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f32_volatile_1:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b32 v1, v0
; CI-NEXT:    ds_read_b32 v2, v0 offset:32
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v2, v1, v2
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f32_volatile_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    ds_read_b32 v1, v0
; GFX9-NEXT:    ds_read_b32 v2, v0 offset:32
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %x.i
  %val0 = load float, float addrspace(3)* %arrayidx0, align 4
  %add.x = add nsw i32 %x.i, 8
  %arrayidx1 = getelementptr inbounds [512 x float], [512 x float] addrspace(3)* @lds, i32 0, i32 %add.x
  %val1 = load volatile float, float addrspace(3)* %arrayidx1, align 4
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

; Can't fold since not correctly aligned.
define amdgpu_kernel void @unaligned_read2_f32(float addrspace(1)* %out, float addrspace(3)* %lds) #0 {
; CI-LABEL: unaligned_read2_f32:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[0:1], 0x2
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v1, vcc, s2, v0
; CI-NEXT:    ds_read_u8 v2, v1 offset:34
; CI-NEXT:    ds_read_u8 v3, v1 offset:32
; CI-NEXT:    ds_read_u8 v4, v1 offset:3
; CI-NEXT:    ds_read_u8 v5, v1 offset:2
; CI-NEXT:    ds_read_u8 v6, v1 offset:1
; CI-NEXT:    ds_read_u8 v7, v1
; CI-NEXT:    ds_read_u8 v8, v1 offset:33
; CI-NEXT:    ds_read_u8 v1, v1 offset:35
; CI-NEXT:    s_waitcnt lgkmcnt(5)
; CI-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; CI-NEXT:    s_waitcnt lgkmcnt(3)
; CI-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; CI-NEXT:    v_or_b32_e32 v4, v4, v5
; CI-NEXT:    s_waitcnt lgkmcnt(1)
; CI-NEXT:    v_lshlrev_b32_e32 v5, 8, v8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; CI-NEXT:    v_or_b32_e32 v1, v1, v2
; CI-NEXT:    v_or_b32_e32 v6, v6, v7
; CI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; CI-NEXT:    v_or_b32_e32 v3, v5, v3
; CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; CI-NEXT:    v_or_b32_e32 v4, v4, v6
; CI-NEXT:    v_or_b32_e32 v1, v1, v3
; CI-NEXT:    v_add_f32_e32 v2, v4, v1
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-ALIGNED-LABEL: unaligned_read2_f32:
; GFX9-ALIGNED:       ; %bb.0:
; GFX9-ALIGNED-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX9-ALIGNED-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX9-ALIGNED-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ALIGNED-NEXT:    v_add_u32_e32 v1, s4, v0
; GFX9-ALIGNED-NEXT:    ds_read_u8 v2, v1
; GFX9-ALIGNED-NEXT:    ds_read_u8 v3, v1 offset:1
; GFX9-ALIGNED-NEXT:    ds_read_u8 v4, v1 offset:2
; GFX9-ALIGNED-NEXT:    ds_read_u8 v5, v1 offset:3
; GFX9-ALIGNED-NEXT:    ds_read_u8 v6, v1 offset:32
; GFX9-ALIGNED-NEXT:    ds_read_u8 v7, v1 offset:33
; GFX9-ALIGNED-NEXT:    ds_read_u8 v8, v1 offset:34
; GFX9-ALIGNED-NEXT:    ds_read_u8 v1, v1 offset:35
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(6)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v2, v3, 8, v2
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(4)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v3, v5, 8, v4
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v2, v3, 16, v2
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(2)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v3, v7, 8, v6
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v1, v1, 8, v8
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v1, v1, 16, v3
; GFX9-ALIGNED-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX9-ALIGNED-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-ALIGNED-NEXT:    s_endpgm
;
; GFX9-UNALIGNED-LABEL: unaligned_read2_f32:
; GFX9-UNALIGNED:       ; %bb.0:
; GFX9-UNALIGNED-NEXT:    s_load_dword s2, s[0:1], 0x8
; GFX9-UNALIGNED-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX9-UNALIGNED-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-UNALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-UNALIGNED-NEXT:    v_add_u32_e32 v0, s2, v2
; GFX9-UNALIGNED-NEXT:    ds_read2_b32 v[0:1], v0 offset1:8
; GFX9-UNALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-UNALIGNED-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-UNALIGNED-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX9-UNALIGNED-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds float, float addrspace(3)* %lds, i32 %x.i
  %val0 = load float, float addrspace(3)* %arrayidx0, align 1
  %add.x = add nsw i32 %x.i, 8
  %arrayidx1 = getelementptr inbounds float, float addrspace(3)* %lds, i32 %add.x
  %val1 = load float, float addrspace(3)* %arrayidx1, align 1
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @unaligned_offset_read2_f32(float addrspace(1)* %out, float addrspace(3)* %lds) #0 {
; CI-LABEL: unaligned_offset_read2_f32:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[0:1], 0x2
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v1, vcc, s2, v0
; CI-NEXT:    ds_read_u8 v2, v1 offset:11
; CI-NEXT:    ds_read_u8 v3, v1 offset:9
; CI-NEXT:    ds_read_u8 v4, v1 offset:8
; CI-NEXT:    ds_read_u8 v5, v1 offset:7
; CI-NEXT:    ds_read_u8 v6, v1 offset:6
; CI-NEXT:    ds_read_u8 v7, v1 offset:5
; CI-NEXT:    ds_read_u8 v8, v1 offset:10
; CI-NEXT:    ds_read_u8 v1, v1 offset:12
; CI-NEXT:    s_waitcnt lgkmcnt(5)
; CI-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; CI-NEXT:    s_waitcnt lgkmcnt(3)
; CI-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; CI-NEXT:    v_or_b32_e32 v4, v4, v5
; CI-NEXT:    s_waitcnt lgkmcnt(1)
; CI-NEXT:    v_lshlrev_b32_e32 v5, 8, v8
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; CI-NEXT:    v_or_b32_e32 v1, v1, v2
; CI-NEXT:    v_or_b32_e32 v6, v6, v7
; CI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; CI-NEXT:    v_or_b32_e32 v3, v5, v3
; CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; CI-NEXT:    v_or_b32_e32 v4, v4, v6
; CI-NEXT:    v_or_b32_e32 v1, v1, v3
; CI-NEXT:    v_add_f32_e32 v2, v4, v1
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-ALIGNED-LABEL: unaligned_offset_read2_f32:
; GFX9-ALIGNED:       ; %bb.0:
; GFX9-ALIGNED-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX9-ALIGNED-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX9-ALIGNED-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ALIGNED-NEXT:    v_add_u32_e32 v1, s4, v0
; GFX9-ALIGNED-NEXT:    ds_read_u8 v2, v1 offset:5
; GFX9-ALIGNED-NEXT:    ds_read_u8 v3, v1 offset:6
; GFX9-ALIGNED-NEXT:    ds_read_u8 v4, v1 offset:7
; GFX9-ALIGNED-NEXT:    ds_read_u8 v5, v1 offset:8
; GFX9-ALIGNED-NEXT:    ds_read_u8 v6, v1 offset:9
; GFX9-ALIGNED-NEXT:    ds_read_u8 v7, v1 offset:10
; GFX9-ALIGNED-NEXT:    ds_read_u8 v8, v1 offset:11
; GFX9-ALIGNED-NEXT:    ds_read_u8 v1, v1 offset:12
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(6)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v2, v3, 8, v2
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(4)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v3, v5, 8, v4
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v2, v3, 16, v2
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(2)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v3, v7, 8, v6
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v1, v1, 8, v8
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v1, v1, 16, v3
; GFX9-ALIGNED-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX9-ALIGNED-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-ALIGNED-NEXT:    s_endpgm
;
; GFX9-UNALIGNED-LABEL: unaligned_offset_read2_f32:
; GFX9-UNALIGNED:       ; %bb.0:
; GFX9-UNALIGNED-NEXT:    s_load_dword s2, s[0:1], 0x8
; GFX9-UNALIGNED-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX9-UNALIGNED-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-UNALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-UNALIGNED-NEXT:    v_add_u32_e32 v0, s2, v2
; GFX9-UNALIGNED-NEXT:    ds_read_b64 v[0:1], v0 offset:5
; GFX9-UNALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-UNALIGNED-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-UNALIGNED-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX9-UNALIGNED-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %base = getelementptr inbounds float, float addrspace(3)* %lds, i32 %x.i
  %base.i8 = bitcast float addrspace(3)* %base to i8 addrspace(3)*
  %addr0.i8 = getelementptr inbounds i8, i8 addrspace(3)* %base.i8, i32 5
  %addr0 = bitcast i8 addrspace(3)* %addr0.i8 to float addrspace(3)*
  %val0 = load float, float addrspace(3)* %addr0, align 1
  %addr1.i8 = getelementptr inbounds i8, i8 addrspace(3)* %base.i8, i32 9
  %addr1 = bitcast i8 addrspace(3)* %addr1.i8 to float addrspace(3)*
  %val1 = load float, float addrspace(3)* %addr1, align 1
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @misaligned_2_simple_read2_f32(float addrspace(1)* %out, float addrspace(3)* %lds) #0 {
; CI-LABEL: misaligned_2_simple_read2_f32:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[0:1], 0x2
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v1, vcc, s2, v0
; CI-NEXT:    ds_read_u16 v2, v1 offset:32
; CI-NEXT:    ds_read_u16 v3, v1 offset:2
; CI-NEXT:    ds_read_u16 v4, v1
; CI-NEXT:    ds_read_u16 v1, v1 offset:34
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(2)
; CI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; CI-NEXT:    s_waitcnt lgkmcnt(1)
; CI-NEXT:    v_or_b32_e32 v3, v3, v4
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; CI-NEXT:    v_or_b32_e32 v1, v1, v2
; CI-NEXT:    v_add_f32_e32 v2, v3, v1
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-ALIGNED-LABEL: misaligned_2_simple_read2_f32:
; GFX9-ALIGNED:       ; %bb.0:
; GFX9-ALIGNED-NEXT:    s_load_dword s2, s[0:1], 0x8
; GFX9-ALIGNED-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-ALIGNED-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ALIGNED-NEXT:    v_add_u32_e32 v1, s2, v0
; GFX9-ALIGNED-NEXT:    ds_read_u16 v2, v1
; GFX9-ALIGNED-NEXT:    ds_read_u16 v3, v1 offset:2
; GFX9-ALIGNED-NEXT:    ds_read_u16 v4, v1 offset:32
; GFX9-ALIGNED-NEXT:    ds_read_u16 v1, v1 offset:34
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(2)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v2, v3, 16, v2
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ALIGNED-NEXT:    v_lshl_or_b32 v1, v1, 16, v4
; GFX9-ALIGNED-NEXT:    v_add_f32_e32 v1, v2, v1
; GFX9-ALIGNED-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-ALIGNED-NEXT:    s_endpgm
;
; GFX9-UNALIGNED-LABEL: misaligned_2_simple_read2_f32:
; GFX9-UNALIGNED:       ; %bb.0:
; GFX9-UNALIGNED-NEXT:    s_load_dword s2, s[0:1], 0x8
; GFX9-UNALIGNED-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX9-UNALIGNED-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-UNALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-UNALIGNED-NEXT:    v_add_u32_e32 v0, s2, v2
; GFX9-UNALIGNED-NEXT:    ds_read2_b32 v[0:1], v0 offset1:8
; GFX9-UNALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-UNALIGNED-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-UNALIGNED-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX9-UNALIGNED-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds float, float addrspace(3)* %lds, i32 %x.i
  %val0 = load float, float addrspace(3)* %arrayidx0, align 2
  %add.x = add nsw i32 %x.i, 8
  %arrayidx1 = getelementptr inbounds float, float addrspace(3)* %lds, i32 %add.x
  %val1 = load float, float addrspace(3)* %arrayidx1, align 2
  %sum = fadd float %val0, %val1
  %out.gep = getelementptr inbounds float, float addrspace(1)* %out, i32 %x.i
  store float %sum, float addrspace(1)* %out.gep, align 4
  ret void
}

define amdgpu_kernel void @simple_read2_f64(double addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f64:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b64 v[0:3], v4 offset1:8
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    v_mov_b32_e32 v5, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; CI-NEXT:    buffer_store_dwordx2 v[0:1], v[4:5], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NEXT:    ds_read2_b64 v[0:3], v4 offset1:8
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds [512 x double], [512 x double] addrspace(3)* @lds.f64, i32 0, i32 %x.i
  %val0 = load double, double addrspace(3)* %arrayidx0, align 8
  %add.x = add nsw i32 %x.i, 8
  %arrayidx1 = getelementptr inbounds [512 x double], [512 x double] addrspace(3)* @lds.f64, i32 0, i32 %add.x
  %val1 = load double, double addrspace(3)* %arrayidx1, align 8
  %sum = fadd double %val0, %val1
  %out.gep = getelementptr inbounds double, double addrspace(1)* %out, i32 %x.i
  store double %sum, double addrspace(1)* %out.gep, align 8
  ret void
}

define amdgpu_kernel void @simple_read2_f64_max_offset(double addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f64_max_offset:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b64 v[0:3], v4 offset1:255
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    v_mov_b32_e32 v5, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; CI-NEXT:    buffer_store_dwordx2 v[0:1], v[4:5], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f64_max_offset:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NEXT:    ds_read2_b64 v[0:3], v4 offset1:255
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds [512 x double], [512 x double] addrspace(3)* @lds.f64, i32 0, i32 %x.i
  %val0 = load double, double addrspace(3)* %arrayidx0, align 8
  %add.x = add nsw i32 %x.i, 255
  %arrayidx1 = getelementptr inbounds [512 x double], [512 x double] addrspace(3)* @lds.f64, i32 0, i32 %add.x
  %val1 = load double, double addrspace(3)* %arrayidx1, align 8
  %sum = fadd double %val0, %val1
  %out.gep = getelementptr inbounds double, double addrspace(1)* %out, i32 %x.i
  store double %sum, double addrspace(1)* %out.gep, align 8
  ret void
}

define amdgpu_kernel void @simple_read2_f64_too_far(double addrspace(1)* %out) #0 {
; CI-LABEL: simple_read2_f64_too_far:
; CI:       ; %bb.0:
; CI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b64 v[1:2], v0
; CI-NEXT:    ds_read_b64 v[3:4], v0 offset:2056
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f64 v[2:3], v[1:2], v[3:4]
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: simple_read2_f64_too_far:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NEXT:    ds_read_b64 v[0:1], v4
; GFX9-NEXT:    ds_read_b64 v[2:3], v4 offset:2056
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds [512 x double], [512 x double] addrspace(3)* @lds.f64, i32 0, i32 %x.i
  %val0 = load double, double addrspace(3)* %arrayidx0, align 8
  %add.x = add nsw i32 %x.i, 257
  %arrayidx1 = getelementptr inbounds [512 x double], [512 x double] addrspace(3)* @lds.f64, i32 0, i32 %add.x
  %val1 = load double, double addrspace(3)* %arrayidx1, align 8
  %sum = fadd double %val0, %val1
  %out.gep = getelementptr inbounds double, double addrspace(1)* %out, i32 %x.i
  store double %sum, double addrspace(1)* %out.gep, align 8
  ret void
}

; Alignment only 4
define amdgpu_kernel void @misaligned_read2_f64(double addrspace(1)* %out, double addrspace(3)* %lds) #0 {
; CI-LABEL: misaligned_read2_f64:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[0:1], 0x2
; CI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v3, vcc, s2, v0
; CI-NEXT:    ds_read2_b32 v[1:2], v3 offset1:1
; CI-NEXT:    ds_read2_b32 v[3:4], v3 offset0:14 offset1:15
; CI-NEXT:    s_mov_b32 s2, 0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f64 v[2:3], v[1:2], v[3:4]
; CI-NEXT:    v_mov_b32_e32 v1, 0
; CI-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: misaligned_read2_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[0:1], 0x8
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v2, s2, v4
; GFX9-NEXT:    ds_read2_b32 v[0:1], v2 offset1:1
; GFX9-NEXT:    ds_read2_b32 v[2:3], v2 offset0:14 offset1:15
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workitem.id.x() #1
  %arrayidx0 = getelementptr inbounds double, double addrspace(3)* %lds, i32 %x.i
  %val0 = load double, double addrspace(3)* %arrayidx0, align 4
  %add.x = add nsw i32 %x.i, 7
  %arrayidx1 = getelementptr inbounds double, double addrspace(3)* %lds, i32 %add.x
  %val1 = load double, double addrspace(3)* %arrayidx1, align 4
  %sum = fadd double %val0, %val1
  %out.gep = getelementptr inbounds double, double addrspace(1)* %out, i32 %x.i
  store double %sum, double addrspace(1)* %out.gep, align 4
  ret void
}

@foo = addrspace(3) global [4 x i32] undef, align 4

define amdgpu_kernel void @load_constant_adjacent_offsets(i32 addrspace(1)* %out) {
; CI-LABEL: load_constant_adjacent_offsets:
; CI:       ; %bb.0:
; CI-NEXT:    v_mov_b32_e32 v0, 0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b64 v[0:1], v0
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; CI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: load_constant_adjacent_offsets:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    ds_read_b64 v[0:1], v2
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
  %val0 = load i32, i32 addrspace(3)* getelementptr inbounds ([4 x i32], [4 x i32] addrspace(3)* @foo, i32 0, i32 0), align 4
  %val1 = load i32, i32 addrspace(3)* getelementptr inbounds ([4 x i32], [4 x i32] addrspace(3)* @foo, i32 0, i32 1), align 4
  %sum = add i32 %val0, %val1
  store i32 %sum, i32 addrspace(1)* %out, align 4
  ret void
}

define amdgpu_kernel void @load_constant_disjoint_offsets(i32 addrspace(1)* %out) {
; CI-LABEL: load_constant_disjoint_offsets:
; CI:       ; %bb.0:
; CI-NEXT:    v_mov_b32_e32 v0, 0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b32 v[0:1], v0 offset1:2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; CI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: load_constant_disjoint_offsets:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    ds_read2_b32 v[0:1], v2 offset1:2
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
  %val0 = load i32, i32 addrspace(3)* getelementptr inbounds ([4 x i32], [4 x i32] addrspace(3)* @foo, i32 0, i32 0), align 4
  %val1 = load i32, i32 addrspace(3)* getelementptr inbounds ([4 x i32], [4 x i32] addrspace(3)* @foo, i32 0, i32 2), align 4
  %sum = add i32 %val0, %val1
  store i32 %sum, i32 addrspace(1)* %out, align 4
  ret void
}

@bar = addrspace(3) global [4 x i64] undef, align 4

define amdgpu_kernel void @load_misaligned64_constant_offsets(i64 addrspace(1)* %out) {
; CI-LABEL: load_misaligned64_constant_offsets:
; CI:       ; %bb.0:
; CI-NEXT:    v_mov_b32_e32 v0, 0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b128 v[0:3], v0
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: load_misaligned64_constant_offsets:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    ds_read_b128 v[0:3], v4
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
  %val0 = load i64, i64 addrspace(3)* getelementptr inbounds ([4 x i64], [4 x i64] addrspace(3)* @bar, i32 0, i32 0), align 4
  %val1 = load i64, i64 addrspace(3)* getelementptr inbounds ([4 x i64], [4 x i64] addrspace(3)* @bar, i32 0, i32 1), align 4
  %sum = add i64 %val0, %val1
  store i64 %sum, i64 addrspace(1)* %out, align 8
  ret void
}

@bar.large = addrspace(3) global [4096 x i64] undef, align 4

define amdgpu_kernel void @load_misaligned64_constant_large_offsets(i64 addrspace(1)* %out) {
; CI-LABEL: load_misaligned64_constant_large_offsets:
; CI:       ; %bb.0:
; CI-NEXT:    v_mov_b32_e32 v2, 0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b64 v[0:1], v2 offset:16384
; CI-NEXT:    ds_read_b64 v[2:3], v2 offset:32760
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: load_misaligned64_constant_large_offsets:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v4, 0
; GFX9-NEXT:    ds_read_b64 v[0:1], v4 offset:16384
; GFX9-NEXT:    ds_read_b64 v[2:3], v4 offset:32760
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
  %val0 = load i64, i64 addrspace(3)* getelementptr inbounds ([4096 x i64], [4096 x i64] addrspace(3)* @bar.large, i32 0, i32 2048), align 4
  %val1 = load i64, i64 addrspace(3)* getelementptr inbounds ([4096 x i64], [4096 x i64] addrspace(3)* @bar.large, i32 0, i32 4095), align 4
  %sum = add i64 %val0, %val1
  store i64 %sum, i64 addrspace(1)* %out, align 8
  ret void
}

@sgemm.lA = internal unnamed_addr addrspace(3) global [264 x float] undef, align 4
@sgemm.lB = internal unnamed_addr addrspace(3) global [776 x float] undef, align 4

define amdgpu_kernel void @sgemm_inner_loop_read2_sequence(float addrspace(1)* %C, i32 %lda, i32 %ldb) #0 {
; CI-LABEL: sgemm_inner_loop_read2_sequence:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; CI-NEXT:    s_lshl_b32 s0, s2, 2
; CI-NEXT:    s_add_i32 s1, s0, 0xc20
; CI-NEXT:    s_addk_i32 s0, 0xc60
; CI-NEXT:    v_mov_b32_e32 v0, s1
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    v_lshlrev_b32_e32 v8, 2, v1
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read2_b32 v[0:1], v0 offset1:1
; CI-NEXT:    ds_read2_b32 v[2:3], v2 offset1:1
; CI-NEXT:    ds_read2_b32 v[4:5], v8 offset1:1
; CI-NEXT:    ds_read2_b32 v[6:7], v8 offset0:32 offset1:33
; CI-NEXT:    ds_read2_b32 v[8:9], v8 offset0:64 offset1:65
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v0, v0, v1
; CI-NEXT:    v_add_f32_e32 v0, v0, v2
; CI-NEXT:    v_add_f32_e32 v0, v0, v3
; CI-NEXT:    v_add_f32_e32 v0, v0, v4
; CI-NEXT:    v_add_f32_e32 v0, v0, v5
; CI-NEXT:    v_add_f32_e32 v0, v0, v6
; CI-NEXT:    v_add_f32_e32 v0, v0, v7
; CI-NEXT:    v_add_f32_e32 v0, v0, v8
; CI-NEXT:    s_mov_b32 s7, 0xf000
; CI-NEXT:    s_mov_b32 s6, -1
; CI-NEXT:    v_add_f32_e32 v0, v0, v9
; CI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: sgemm_inner_loop_read2_sequence:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshl_b32 s2, s2, 2
; GFX9-NEXT:    s_add_i32 s3, s2, 0xc20
; GFX9-NEXT:    s_addk_i32 s2, 0xc60
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v2, s2
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 2, v1
; GFX9-NEXT:    ds_read2_b32 v[0:1], v0 offset1:1
; GFX9-NEXT:    ds_read2_b32 v[2:3], v2 offset1:1
; GFX9-NEXT:    ds_read2_b32 v[4:5], v8 offset1:1
; GFX9-NEXT:    ds_read2_b32 v[6:7], v8 offset0:32 offset1:33
; GFX9-NEXT:    ds_read2_b32 v[8:9], v8 offset0:64 offset1:65
; GFX9-NEXT:    s_waitcnt lgkmcnt(4)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    s_waitcnt lgkmcnt(3)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v3
; GFX9-NEXT:    s_waitcnt lgkmcnt(2)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v4
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v6
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v7
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v8
; GFX9-NEXT:    v_mov_b32_e32 v10, 0
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v9
; GFX9-NEXT:    global_store_dword v10, v0, s[0:1]
; GFX9-NEXT:    s_endpgm
  %x.i = tail call i32 @llvm.amdgcn.workgroup.id.x() #1
  %y.i = tail call i32 @llvm.amdgcn.workitem.id.y() #1
  %arrayidx44 = getelementptr inbounds [264 x float], [264 x float] addrspace(3)* @sgemm.lA, i32 0, i32 %x.i
  %tmp16 = load float, float addrspace(3)* %arrayidx44, align 4
  %add47 = add nsw i32 %x.i, 1
  %arrayidx48 = getelementptr inbounds [264 x float], [264 x float] addrspace(3)* @sgemm.lA, i32 0, i32 %add47
  %tmp17 = load float, float addrspace(3)* %arrayidx48, align 4
  %add51 = add nsw i32 %x.i, 16
  %arrayidx52 = getelementptr inbounds [264 x float], [264 x float] addrspace(3)* @sgemm.lA, i32 0, i32 %add51
  %tmp18 = load float, float addrspace(3)* %arrayidx52, align 4
  %add55 = add nsw i32 %x.i, 17
  %arrayidx56 = getelementptr inbounds [264 x float], [264 x float] addrspace(3)* @sgemm.lA, i32 0, i32 %add55
  %tmp19 = load float, float addrspace(3)* %arrayidx56, align 4
  %arrayidx60 = getelementptr inbounds [776 x float], [776 x float] addrspace(3)* @sgemm.lB, i32 0, i32 %y.i
  %tmp20 = load float, float addrspace(3)* %arrayidx60, align 4
  %add63 = add nsw i32 %y.i, 1
  %arrayidx64 = getelementptr inbounds [776 x float], [776 x float] addrspace(3)* @sgemm.lB, i32 0, i32 %add63
  %tmp21 = load float, float addrspace(3)* %arrayidx64, align 4
  %add67 = add nsw i32 %y.i, 32
  %arrayidx68 = getelementptr inbounds [776 x float], [776 x float] addrspace(3)* @sgemm.lB, i32 0, i32 %add67
  %tmp22 = load float, float addrspace(3)* %arrayidx68, align 4
  %add71 = add nsw i32 %y.i, 33
  %arrayidx72 = getelementptr inbounds [776 x float], [776 x float] addrspace(3)* @sgemm.lB, i32 0, i32 %add71
  %tmp23 = load float, float addrspace(3)* %arrayidx72, align 4
  %add75 = add nsw i32 %y.i, 64
  %arrayidx76 = getelementptr inbounds [776 x float], [776 x float] addrspace(3)* @sgemm.lB, i32 0, i32 %add75
  %tmp24 = load float, float addrspace(3)* %arrayidx76, align 4
  %add79 = add nsw i32 %y.i, 65
  %arrayidx80 = getelementptr inbounds [776 x float], [776 x float] addrspace(3)* @sgemm.lB, i32 0, i32 %add79
  %tmp25 = load float, float addrspace(3)* %arrayidx80, align 4
  %sum.0 = fadd float %tmp16, %tmp17
  %sum.1 = fadd float %sum.0, %tmp18
  %sum.2 = fadd float %sum.1, %tmp19
  %sum.3 = fadd float %sum.2, %tmp20
  %sum.4 = fadd float %sum.3, %tmp21
  %sum.5 = fadd float %sum.4, %tmp22
  %sum.6 = fadd float %sum.5, %tmp23
  %sum.7 = fadd float %sum.6, %tmp24
  %sum.8 = fadd float %sum.7, %tmp25
  store float %sum.8, float addrspace(1)* %C, align 4
  ret void
}

define amdgpu_kernel void @misaligned_read2_v2i32(<2 x i32> addrspace(1)* %out, <2 x i32> addrspace(3)* %in) #0 {
; CI-LABEL: misaligned_read2_v2i32:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[0:1], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    ds_read2_b32 v[0:1], v0 offset1:1
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: misaligned_read2_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    ds_read2_b32 v[0:1], v0 offset1:1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
  %load = load <2 x i32>, <2 x i32> addrspace(3)* %in, align 4
  store <2 x i32> %load, <2 x i32> addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @misaligned_read2_i64(i64 addrspace(1)* %out, i64 addrspace(3)* %in) #0 {
; CI-LABEL: misaligned_read2_i64:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dword s2, s[0:1], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s2
; CI-NEXT:    ds_read2_b32 v[0:1], v0 offset1:1
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: misaligned_read2_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    ds_read2_b32 v[0:1], v0 offset1:1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[2:3]
; GFX9-NEXT:    s_endpgm
  %load = load i64, i64 addrspace(3)* %in, align 4
  store i64 %load, i64 addrspace(1)* %out, align 8
  ret void
}

define amdgpu_kernel void @ds_read_diff_base_interleaving(
; CI-LABEL: ds_read_diff_base_interleaving:
; CI:       ; %bb.0: ; %bb
; CI-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; CI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v2, vcc, s4, v1
; CI-NEXT:    v_add_i32_e32 v3, vcc, s5, v0
; CI-NEXT:    v_add_i32_e32 v4, vcc, s6, v1
; CI-NEXT:    v_add_i32_e32 v6, vcc, s7, v0
; CI-NEXT:    ds_read2_b32 v[0:1], v2 offset1:1
; CI-NEXT:    ds_read2_b32 v[2:3], v3 offset1:4
; CI-NEXT:    ds_read2_b32 v[4:5], v4 offset1:1
; CI-NEXT:    ds_read2_b32 v[6:7], v6 offset1:4
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    s_waitcnt lgkmcnt(2)
; CI-NEXT:    v_mul_f32_e32 v0, v0, v2
; CI-NEXT:    v_add_f32_e32 v0, 2.0, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mul_f32_e32 v2, v4, v6
; CI-NEXT:    v_sub_f32_e32 v0, v0, v2
; CI-NEXT:    v_mul_f32_e32 v1, v1, v3
; CI-NEXT:    v_sub_f32_e32 v0, v0, v1
; CI-NEXT:    v_mul_f32_e32 v1, v5, v7
; CI-NEXT:    v_sub_f32_e32 v0, v0, v1
; CI-NEXT:    buffer_store_dword v0, off, s[0:3], 0 offset:40
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: ds_read_diff_base_interleaving:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x8
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v2, s4, v1
; GFX9-NEXT:    v_add_u32_e32 v3, s5, v0
; GFX9-NEXT:    v_add_u32_e32 v4, s6, v1
; GFX9-NEXT:    v_add_u32_e32 v6, s7, v0
; GFX9-NEXT:    ds_read2_b32 v[0:1], v2 offset1:1
; GFX9-NEXT:    ds_read2_b32 v[2:3], v3 offset1:4
; GFX9-NEXT:    ds_read2_b32 v[4:5], v4 offset1:1
; GFX9-NEXT:    ds_read2_b32 v[6:7], v6 offset1:4
; GFX9-NEXT:    s_waitcnt lgkmcnt(2)
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_add_f32_e32 v0, 2.0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mul_f32_e32 v2, v4, v6
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_f32_e32 v1, v1, v3
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f32_e32 v1, v5, v7
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX9-NEXT:    global_store_dword v8, v0, s[0:1] offset:40
; GFX9-NEXT:    s_endpgm
  float addrspace(1)* nocapture %arg,
  [4 x [4 x float]] addrspace(3)* %arg1,
  [4 x [4 x float]] addrspace(3)* %arg2,
  [4 x [4 x float]] addrspace(3)* %arg3,
  [4 x [4 x float]] addrspace(3)* %arg4) #1 {
bb:
  %tmp = getelementptr float, float addrspace(1)* %arg, i64 10
  %tmp5 = tail call i32 @llvm.amdgcn.workitem.id.x() #2
  %tmp6 = tail call i32 @llvm.amdgcn.workitem.id.y() #2
  %tmp7 = getelementptr [4 x [4 x float]], [4 x [4 x float]] addrspace(3)* %arg1, i32 0, i32 %tmp6, i32 0
  %tmp8 = getelementptr [4 x [4 x float]], [4 x [4 x float]] addrspace(3)* %arg2, i32 0, i32 0, i32 %tmp5
  %tmp9 = getelementptr [4 x [4 x float]], [4 x [4 x float]] addrspace(3)* %arg3, i32 0, i32 %tmp6, i32 0
  %tmp10 = getelementptr [4 x [4 x float]], [4 x [4 x float]] addrspace(3)* %arg4, i32 0, i32 0, i32 %tmp5
  %tmp11 = getelementptr [4 x [4 x float]], [4 x [4 x float]] addrspace(3)* %arg1, i32 0, i32 %tmp6, i32 1
  %tmp12 = getelementptr [4 x [4 x float]], [4 x [4 x float]] addrspace(3)* %arg2, i32 0, i32 1, i32 %tmp5
  %tmp13 = getelementptr [4 x [4 x float]], [4 x [4 x float]] addrspace(3)* %arg3, i32 0, i32 %tmp6, i32 1
  %tmp14 = getelementptr [4 x [4 x float]], [4 x [4 x float]] addrspace(3)* %arg4, i32 0, i32 1, i32 %tmp5
  %tmp15 = load float, float addrspace(3)* %tmp7
  %tmp16 = load float, float addrspace(3)* %tmp8
  %tmp17 = fmul float %tmp15, %tmp16
  %tmp18 = fadd float 2.000000e+00, %tmp17
  %tmp19 = load float, float addrspace(3)* %tmp9
  %tmp20 = load float, float addrspace(3)* %tmp10
  %tmp21 = fmul float %tmp19, %tmp20
  %tmp22 = fsub float %tmp18, %tmp21
  %tmp23 = load float, float addrspace(3)* %tmp11
  %tmp24 = load float, float addrspace(3)* %tmp12
  %tmp25 = fmul float %tmp23, %tmp24
  %tmp26 = fsub float %tmp22, %tmp25
  %tmp27 = load float, float addrspace(3)* %tmp13
  %tmp28 = load float, float addrspace(3)* %tmp14
  %tmp29 = fmul float %tmp27, %tmp28
  %tmp30 = fsub float %tmp26, %tmp29
  store float %tmp30, float addrspace(1)* %tmp
  ret void
}

define amdgpu_kernel void @ds_read_call_read(i32 addrspace(1)* %out, i32 addrspace(3)* %arg) {
; CI-LABEL: ds_read_call_read:
; CI:       ; %bb.0:
; CI-NEXT:    s_getpc_b64 s[40:41]
; CI-NEXT:    s_mov_b32 s40, s0
; CI-NEXT:    s_load_dwordx4 s[40:43], s[40:41], 0x0
; CI-NEXT:    s_mov_b32 s14, s10
; CI-NEXT:    s_mov_b32 s12, s8
; CI-NEXT:    s_mov_b32 s13, s9
; CI-NEXT:    v_lshlrev_b32_e32 v3, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_add_u32 s40, s40, s11
; CI-NEXT:    s_mov_b64 s[10:11], s[6:7]
; CI-NEXT:    s_load_dwordx2 s[36:37], s[4:5], 0x0
; CI-NEXT:    s_load_dword s6, s[4:5], 0x2
; CI-NEXT:    s_addc_u32 s41, s41, 0
; CI-NEXT:    s_add_u32 s8, s4, 12
; CI-NEXT:    s_addc_u32 s9, s5, 0
; CI-NEXT:    s_getpc_b64 s[4:5]
; CI-NEXT:    s_add_u32 s4, s4, void_func_void@gotpcrel32@lo+4
; CI-NEXT:    s_addc_u32 s5, s5, void_func_void@gotpcrel32@hi+12
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v40, vcc, s6, v3
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; CI-NEXT:    ds_read_b32 v41, v40
; CI-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; CI-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; CI-NEXT:    v_or_b32_e32 v0, v0, v1
; CI-NEXT:    s_mov_b64 s[4:5], s[0:1]
; CI-NEXT:    s_mov_b64 s[6:7], s[2:3]
; CI-NEXT:    s_mov_b64 s[0:1], s[40:41]
; CI-NEXT:    v_or_b32_e32 v31, v0, v2
; CI-NEXT:    s_mov_b64 s[2:3], s[42:43]
; CI-NEXT:    s_mov_b32 s32, 0
; CI-NEXT:    s_mov_b32 s39, 0xf000
; CI-NEXT:    s_mov_b32 s38, -1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; CI-NEXT:    ds_read_b32 v0, v40 offset:4
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_i32_e32 v0, vcc, v41, v0
; CI-NEXT:    buffer_store_dword v0, off, s[36:39], 0
; CI-NEXT:    s_endpgm
;
; GFX9-LABEL: ds_read_call_read:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_getpc_b64 s[36:37]
; GFX9-NEXT:    s_mov_b32 s36, s0
; GFX9-NEXT:    s_load_dwordx4 s[36:39], s[36:37], 0x0
; GFX9-NEXT:    s_mov_b32 s14, s10
; GFX9-NEXT:    s_mov_b32 s12, s8
; GFX9-NEXT:    s_mov_b32 s13, s9
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_add_u32 s36, s36, s11
; GFX9-NEXT:    s_addc_u32 s37, s37, 0
; GFX9-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x8
; GFX9-NEXT:    s_load_dwordx2 s[34:35], s[4:5], 0x0
; GFX9-NEXT:    s_add_u32 s8, s4, 12
; GFX9-NEXT:    s_addc_u32 s9, s5, 0
; GFX9-NEXT:    s_getpc_b64 s[4:5]
; GFX9-NEXT:    s_add_u32 s4, s4, void_func_void@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s5, s5, void_func_void@gotpcrel32@hi+12
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_lshl_add_u32 v41, v0, 2, s6
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-NEXT:    ds_read_b32 v42, v41
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-NEXT:    s_mov_b64 s[0:1], s[36:37]
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_mov_b64 s[2:3], s[38:39]
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    v_mov_b32_e32 v40, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    ds_read_b32 v0, v41 offset:4
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, v42, v0
; GFX9-NEXT:    global_store_dword v40, v0, s[34:35]
; GFX9-NEXT:    s_endpgm
  %x = call i32 @llvm.amdgcn.workitem.id.x()
  %arrayidx0 = getelementptr i32, i32 addrspace(3)* %arg, i32 %x
  %arrayidx1 = getelementptr i32, i32 addrspace(3)* %arrayidx0, i32 1
  %v0 = load i32, i32 addrspace(3)* %arrayidx0, align 4
  call void @void_func_void()
  %v1 = load i32, i32 addrspace(3)* %arrayidx1, align 4
  %r = add i32 %v0, %v1
  store i32 %r, i32 addrspace(1)* %out, align 4
  ret void
}

define amdgpu_ps <2 x float> @ds_read_interp_read(i32 inreg %prims, float addrspace(3)* %inptr) {
; CI-LABEL: ds_read_interp_read:
; CI:       ; %bb.0:
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b32 v2, v0
; CI-NEXT:    s_mov_b32 m0, s0
; CI-NEXT:    v_interp_mov_f32 v1, p10, attr0.x
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_b32 v0, v0 offset:16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_add_f32_e32 v1, v0, v1
; CI-NEXT:    v_mov_b32_e32 v0, v2
; CI-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: ds_read_interp_read:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    ds_read2_b32 v[0:1], v0 offset1:4
; GFX9-NEXT:    s_mov_b32 m0, s0
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_interp_mov_f32_e32 v2, p10, attr0.x
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX9-NEXT:    ; return to shader part epilog
  %v0 = load float, float addrspace(3)* %inptr, align 4
  %intrp = call float @llvm.amdgcn.interp.mov(i32 0, i32 0, i32 0, i32 %prims)
  %ptr1 = getelementptr float, float addrspace(3)* %inptr, i32 4
  %v1 = load float, float addrspace(3)* %ptr1, align 4
  %v1b = fadd float %v1, %intrp
  %r0 = insertelement <2 x float> undef, float %v0, i32 0
  %r1 = insertelement <2 x float> %r0, float %v1b, i32 1
  ret <2 x float> %r1
}

@v2i32_align1 = internal addrspace(3) global [100 x <2 x i32>] undef, align 1

define amdgpu_kernel void @read2_v2i32_align1_odd_offset(<2 x i32> addrspace(1)* %out) {
; CI-LABEL: read2_v2i32_align1_odd_offset:
; CI:       ; %bb.0: ; %entry
; CI-NEXT:    v_mov_b32_e32 v0, 0
; CI-NEXT:    s_mov_b32 m0, -1
; CI-NEXT:    ds_read_u8 v1, v0 offset:70
; CI-NEXT:    ds_read_u8 v2, v0 offset:72
; CI-NEXT:    ds_read_u8 v3, v0 offset:71
; CI-NEXT:    ds_read_u8 v4, v0 offset:69
; CI-NEXT:    ds_read_u8 v5, v0 offset:68
; CI-NEXT:    s_waitcnt lgkmcnt(4)
; CI-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; CI-NEXT:    s_waitcnt lgkmcnt(3)
; CI-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; CI-NEXT:    s_waitcnt lgkmcnt(2)
; CI-NEXT:    v_or_b32_e32 v2, v2, v3
; CI-NEXT:    s_waitcnt lgkmcnt(1)
; CI-NEXT:    v_or_b32_e32 v1, v1, v4
; CI-NEXT:    ds_read_u8 v4, v0 offset:67
; CI-NEXT:    ds_read_u8 v6, v0 offset:66
; CI-NEXT:    ds_read_u8 v0, v0 offset:65
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; CI-NEXT:    v_or_b32_e32 v1, v2, v1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v2, 8, v6
; CI-NEXT:    v_or_b32_e32 v0, v2, v0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 8, v5
; CI-NEXT:    v_or_b32_e32 v2, v2, v4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; CI-NEXT:    s_mov_b32 s3, 0xf000
; CI-NEXT:    s_mov_b32 s2, -1
; CI-NEXT:    v_or_b32_e32 v0, v2, v0
; CI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; CI-NEXT:    s_endpgm
;
; GFX9-ALIGNED-LABEL: read2_v2i32_align1_odd_offset:
; GFX9-ALIGNED:       ; %bb.0: ; %entry
; GFX9-ALIGNED-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-ALIGNED-NEXT:    ds_read_u8 v0, v2 offset:70
; GFX9-ALIGNED-NEXT:    ds_read_u8 v3, v2 offset:65
; GFX9-ALIGNED-NEXT:    ds_read_u8 v4, v2 offset:66
; GFX9-ALIGNED-NEXT:    ds_read_u8 v5, v2 offset:67
; GFX9-ALIGNED-NEXT:    ds_read_u8 v6, v2 offset:68
; GFX9-ALIGNED-NEXT:    ds_read_u8 v1, v2 offset:69
; GFX9-ALIGNED-NEXT:    ds_read_u8 v7, v2 offset:72
; GFX9-ALIGNED-NEXT:    ds_read_u8 v8, v2 offset:71
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(7)
; GFX9-ALIGNED-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX9-ALIGNED-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-ALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ALIGNED-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-ALIGNED-NEXT:    v_lshlrev_b32_e32 v1, 8, v7
; GFX9-ALIGNED-NEXT:    v_or_b32_sdwa v1, v1, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-ALIGNED-NEXT:    v_or_b32_e32 v1, v1, v0
; GFX9-ALIGNED-NEXT:    v_lshlrev_b32_e32 v0, 8, v4
; GFX9-ALIGNED-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX9-ALIGNED-NEXT:    v_lshlrev_b32_e32 v3, 8, v6
; GFX9-ALIGNED-NEXT:    v_or_b32_sdwa v3, v3, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-ALIGNED-NEXT:    v_or_b32_e32 v0, v3, v0
; GFX9-ALIGNED-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-ALIGNED-NEXT:    s_endpgm
;
; GFX9-UNALIGNED-LABEL: read2_v2i32_align1_odd_offset:
; GFX9-UNALIGNED:       ; %bb.0: ; %entry
; GFX9-UNALIGNED-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-UNALIGNED-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-UNALIGNED-NEXT:    ds_read_b64 v[0:1], v2 offset:65
; GFX9-UNALIGNED-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-UNALIGNED-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-UNALIGNED-NEXT:    s_endpgm
entry:
  %load = load <2 x i32>, <2 x i32> addrspace(3)* bitcast (i8 addrspace(3)* getelementptr (i8, i8 addrspace(3)* bitcast ([100 x <2 x i32>] addrspace(3)* @v2i32_align1 to i8 addrspace(3)*), i32 65) to <2 x i32> addrspace(3)*), align 1
  store <2 x i32> %load, <2 x i32> addrspace(1)* %out
  ret void
}

declare void @void_func_void() #3

declare i32 @llvm.amdgcn.workgroup.id.x() #1
declare i32 @llvm.amdgcn.workgroup.id.y() #1
declare i32 @llvm.amdgcn.workitem.id.x() #1
declare i32 @llvm.amdgcn.workitem.id.y() #1

declare float @llvm.amdgcn.interp.mov(i32, i32, i32, i32) nounwind readnone

declare void @llvm.amdgcn.s.barrier() #2

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone speculatable }
attributes #2 = { convergent nounwind }
attributes #3 = { nounwind noinline }
