// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: aarch64-registered-target
// RUN: %clang_cc1 -fclang-abi-compat=latest -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x2 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE2
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x3 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE3
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x4 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE4
// RUN: %clang_cc1 -fclang-abi-compat=latest -triple aarch64 -target-feature +sme -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x2 -triple aarch64 -target-feature +sme -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE2
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x3 -triple aarch64 -target-feature +sme -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE3
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x4 -triple aarch64 -target-feature +sme -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE4
// RUN: %clang_cc1 -fclang-abi-compat=latest -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x2 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE2
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x3 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE3
// RUN: %clang_cc1 -fclang-abi-compat=latest -DTUPLE=x4 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE4
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -DTUPLE=x2 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE2
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -DTUPLE=x3 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE3
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -DTUPLE=x4 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=TUPLE4
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-CHECK
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -DTUPLE=x2 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE2
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -DTUPLE=x3 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE3
// RUN: %clang_cc1 -fclang-abi-compat=latest -DSVE_OVERLOADED_FORMS -DTUPLE=x4 -triple aarch64 -target-feature +sve -target-feature +bf16 -disable-O0-optnone -Werror -Wall -emit-llvm -o - -x c++ %s | opt -S -passes=mem2reg,tailcallelim | FileCheck %s -check-prefix=CPP-TUPLE4

// RUN: %clang_cc1 -fclang-abi-compat=latest -triple aarch64 -target-feature +sve -target-feature +bf16 -S -disable-O0-optnone -Werror -Wall -o /dev/null %s
// RUN: %clang_cc1 -fclang-abi-compat=latest -triple aarch64 -target-feature +sme -S -disable-O0-optnone -Werror -Wall -o /dev/null %s

#include <arm_sve.h>

#if defined __ARM_FEATURE_SME
#define MODE_ATTR __arm_streaming
#else
#define MODE_ATTR
#endif

#ifdef TUPLE
#define TYPE_1(base,tuple) base ## tuple ## _t
#define TYPE_0(base,tuple) TYPE_1(base,tuple)
#define TYPE(base) TYPE_0(base,TUPLE)
#else
#define TYPE(base) base ## _t
#endif

#ifdef SVE_OVERLOADED_FORMS
#define SVE_ACLE_FUNC(A1,A2_UNUSED) A1
#else
#ifdef TUPLE
#define SVE_ACLE_FUNC_1(A1,A2,T) A1##A2##_##T
#define SVE_ACLE_FUNC_0(A1,A2,T) SVE_ACLE_FUNC_1(A1,A2,T)
#define SVE_ACLE_FUNC(A1,A2) SVE_ACLE_FUNC_0(A1,A2,TUPLE)
#else
#define SVE_ACLE_FUNC(A1,A2) A1##A2
#endif
#endif

// CHECK-LABEL: @test_svreinterpret_s8_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s8_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s8_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s8_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_s8_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_s8_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_s8_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_s8_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svint8) test_svreinterpret_s8_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_s8, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s16_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s16_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s16_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s16_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_s16_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_s16_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_s16_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_s16_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svint16) test_svreinterpret_s16_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_s16, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_s32_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s32_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s32_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s32_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_s32_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_s32_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_s32_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_s32_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svint32) test_svreinterpret_s32_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_s32, _bf16)(op);
}
// CHECK-LABEL: @test_svreinterpret_s64_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_s64_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_s64_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_s64_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_s64_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_s64_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_s64_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_s64_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svint64) test_svreinterpret_s64_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_s64, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u8_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 16 x i8>
// CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u8_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 32 x i8>
// TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u8_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 48 x i8>
// TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u8_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 64 x i8>
// TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_u8_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 16 x i8>
// CPP-CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_u8_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 32 x i8>
// CPP-TUPLE2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_u8_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 48 x i8>
// CPP-TUPLE3-NEXT:    ret <vscale x 48 x i8> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_u8_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 64 x i8>
// CPP-TUPLE4-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
TYPE(svuint8) test_svreinterpret_u8_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_u8, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u16_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 8 x i16>
// CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u16_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 16 x i16>
// TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u16_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 24 x i16>
// TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u16_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 32 x i16>
// TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_u16_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 8 x i16>
// CPP-CHECK-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_u16_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 16 x i16>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_u16_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 24 x i16>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x i16> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_u16_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 32 x i16>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
TYPE(svuint16) test_svreinterpret_u16_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_u16, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u32_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 4 x i32>
// CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u32_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 8 x i32>
// TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u32_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 12 x i32>
// TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u32_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 16 x i32>
// TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_u32_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 4 x i32>
// CPP-CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_u32_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 8 x i32>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_u32_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 12 x i32>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x i32> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_u32_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 16 x i32>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
TYPE(svuint32) test_svreinterpret_u32_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_u32, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_u64_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 2 x i64>
// CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_u64_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 4 x i64>
// TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_u64_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 6 x i64>
// TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_u64_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 8 x i64>
// TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_u64_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 2 x i64>
// CPP-CHECK-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_u64_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 4 x i64>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_u64_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 6 x i64>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x i64> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_u64_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 8 x i64>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
TYPE(svuint64) test_svreinterpret_u64_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_u64, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_s8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_s8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_s8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_bf16_s8u10__SVInt8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_bf16_s810svint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_bf16_s810svint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_bf16_s810svint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_s8(TYPE(svint8) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _s8)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_s16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_s16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_s16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_s16u11__SVInt16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_s1611svint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_s1611svint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_s1611svint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_s16(TYPE(svint16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _s16)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_s32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_s32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_s32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_s32u11__SVInt32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_s3211svint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_s3211svint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_s3211svint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_s32(TYPE(svint32) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _s32)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_s64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_s64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_s64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_s64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_s64u11__SVInt64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_s6411svint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_s6411svint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_s6411svint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_s64(TYPE(svint64) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _s64)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_u8(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_u8(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_u8(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z26test_svreinterpret_bf16_u8u11__SVUint8_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i8> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z26test_svreinterpret_bf16_u811svuint8x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i8> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z26test_svreinterpret_bf16_u811svuint8x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 48 x i8> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z26test_svreinterpret_bf16_u811svuint8x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 64 x i8> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_u8(TYPE(svuint8) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _u8)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_u16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_u16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_u16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_u16u12__SVUint16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i16> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_u1612svuint16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i16> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_u1612svuint16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x i16> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_u1612svuint16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x i16> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_u16(TYPE(svuint16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _u16)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_u32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_u32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_u32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_u32u12__SVUint32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i32> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_u3212svuint32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i32> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_u3212svuint32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x i32> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_u3212svuint32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x i32> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_u32(TYPE(svuint32) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _u32)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_u64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_u64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_u64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_u64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_u64u12__SVUint64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x i64> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_u6412svuint64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x i64> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_u6412svuint64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x i64> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_u6412svuint64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x i64> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_u64(TYPE(svuint64) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _u64)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[OP:%.*]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[OP:%.*]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[OP:%.*]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[OP:%.*]]
//
// CPP-CHECK-LABEL: @_Z28test_svreinterpret_bf16_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[OP:%.*]]
//
// CPP-TUPLE2-LABEL: @_Z28test_svreinterpret_bf16_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[OP:%.*]]
//
// CPP-TUPLE3-LABEL: @_Z28test_svreinterpret_bf16_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[OP:%.*]]
//
// CPP-TUPLE4-LABEL: @_Z28test_svreinterpret_bf16_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[OP:%.*]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_f16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_f16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_f16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_f16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_f16u13__SVFloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x half> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_f1613svfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x half> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_f1613svfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x half> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_f1613svfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x half> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_f16(TYPE(svfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _f16)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_f32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_f32(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_f32(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_f32(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_f32u13__SVFloat32_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x float> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_f3213svfloat32x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x float> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_f3213svfloat32x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 12 x float> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_f3213svfloat32x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x float> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_f32(TYPE(svfloat32) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _f32)(op);
}

// CHECK-LABEL: @test_svreinterpret_bf16_f64(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 8 x bfloat>
// CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_bf16_f64(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 16 x bfloat>
// TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_bf16_f64(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 24 x bfloat>
// TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_bf16_f64(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 32 x bfloat>
// TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_bf16_f64u13__SVFloat64_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 2 x double> [[OP:%.*]] to <vscale x 8 x bfloat>
// CPP-CHECK-NEXT:    ret <vscale x 8 x bfloat> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_bf16_f6413svfloat64x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 4 x double> [[OP:%.*]] to <vscale x 16 x bfloat>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x bfloat> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_bf16_f6413svfloat64x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 6 x double> [[OP:%.*]] to <vscale x 24 x bfloat>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x bfloat> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_bf16_f6413svfloat64x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x double> [[OP:%.*]] to <vscale x 32 x bfloat>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x bfloat> [[TMP0]]
//
TYPE(svbfloat16) test_svreinterpret_bf16_f64(TYPE(svfloat64) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_bf16, _f64)(op);
}

// CHECK-LABEL: @test_svreinterpret_f32_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 4 x float>
// CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f32_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 8 x float>
// TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f32_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 12 x float>
// TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f32_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 16 x float>
// TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_f32_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 4 x float>
// CPP-CHECK-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_f32_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 8 x float>
// CPP-TUPLE2-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_f32_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 12 x float>
// CPP-TUPLE3-NEXT:    ret <vscale x 12 x float> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_f32_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 16 x float>
// CPP-TUPLE4-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
TYPE(svfloat32) test_svreinterpret_f32_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_f32, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f16_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 8 x half>
// CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f16_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 16 x half>
// TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f16_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 24 x half>
// TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f16_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 32 x half>
// TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_f16_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 8 x half>
// CPP-CHECK-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_f16_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 16 x half>
// CPP-TUPLE2-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_f16_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 24 x half>
// CPP-TUPLE3-NEXT:    ret <vscale x 24 x half> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_f16_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 32 x half>
// CPP-TUPLE4-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
TYPE(svfloat16) test_svreinterpret_f16_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_f16, _bf16)(op);
}

// CHECK-LABEL: @test_svreinterpret_f64_bf16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 2 x double>
// CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// TUPLE2-LABEL: @test_svreinterpret_f64_bf16(
// TUPLE2-NEXT:  entry:
// TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 4 x double>
// TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// TUPLE3-LABEL: @test_svreinterpret_f64_bf16(
// TUPLE3-NEXT:  entry:
// TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 6 x double>
// TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// TUPLE4-LABEL: @test_svreinterpret_f64_bf16(
// TUPLE4-NEXT:  entry:
// TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 8 x double>
// TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
// CPP-CHECK-LABEL: @_Z27test_svreinterpret_f64_bf16u14__SVBfloat16_t(
// CPP-CHECK-NEXT:  entry:
// CPP-CHECK-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 8 x bfloat> [[OP:%.*]] to <vscale x 2 x double>
// CPP-CHECK-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
// CPP-TUPLE2-LABEL: @_Z27test_svreinterpret_f64_bf1614svbfloat16x2_t(
// CPP-TUPLE2-NEXT:  entry:
// CPP-TUPLE2-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 16 x bfloat> [[OP:%.*]] to <vscale x 4 x double>
// CPP-TUPLE2-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
// CPP-TUPLE3-LABEL: @_Z27test_svreinterpret_f64_bf1614svbfloat16x3_t(
// CPP-TUPLE3-NEXT:  entry:
// CPP-TUPLE3-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 24 x bfloat> [[OP:%.*]] to <vscale x 6 x double>
// CPP-TUPLE3-NEXT:    ret <vscale x 6 x double> [[TMP0]]
//
// CPP-TUPLE4-LABEL: @_Z27test_svreinterpret_f64_bf1614svbfloat16x4_t(
// CPP-TUPLE4-NEXT:  entry:
// CPP-TUPLE4-NEXT:    [[TMP0:%.*]] = bitcast <vscale x 32 x bfloat> [[OP:%.*]] to <vscale x 8 x double>
// CPP-TUPLE4-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
TYPE(svfloat64) test_svreinterpret_f64_bf16(TYPE(svbfloat16) op) MODE_ATTR {
  return SVE_ACLE_FUNC(svreinterpret_f64, _bf16)(op);
}
