// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// Test host codegen.
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK1
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK1
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK3
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK3

// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"

// Test target codegen - host bc file has to be created first.
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK11
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK11

// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"

// Test host codegen.
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK17
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK17
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK19
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK19

// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"

// Test target codegen - host bc file has to be created first.
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK11
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck -allow-deprecated-dag-overlap  %s --check-prefix=CHECK11

// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"

// expected-no-diagnostics
#ifndef HEADER
#define HEADER




// We have 8 target regions, but only 7 that actually will generate offloading
// code, only 6 will have mapped arguments, and only 4 have all-constant map
// sizes.



// Check target registration is registered as a Ctor.


template<typename tx, typename ty>
struct TT{
  tx X;
  ty Y;
};

long long get_val() { return 0; }

int foo(int n) {
  int a = 0;
  short aa = 0;
  float b[10];
  float bn[n];
  double c[5][10];
  double cn[5][n];
  TT<long long, char> d;

  #pragma omp target parallel for
  for (int i = 3; i < 32; i += 5) {
#pragma omp cancel for
#pragma omp cancellation point for
  }

  long long k = get_val();
  #pragma omp target parallel for if(target: 0) linear(k : 3) schedule(dynamic)
  for (int i = 10; i > 1; i--) {
    a += 1;
  }

  // CEHCK-32:    [[FPSIZEGEP]] = getelementptr inbounds [[KMP_PRIVATES_T]], [[KMP_PRIVATES_T]]* [[KMP_PRIVATES]], i32 0, i32 0
  // CEHCK-32:    [[FPSIZEADDR:%.+]] = bitcast [3 x i64]* [[FPSIZEGEP]] to i8*
  // CEHCK-32:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[FPSIZEADDR]], i8* align 8 bitcast ([3 x i64]* [[SIZET2]] to i8*), i64 24, i1 false)
  // CEHCK-32:    [[FPBPGEP:%.+]] = getelementptr inbounds [[KMP_PRIVATES_T]], [[KMP_PRIVATES_T]]* [[KMP_PRIVATES]], i32 0, i32 1
  // CEHCK-32:    [[FPBPADDR:%.+]] = bitcast [3 x i8*]* [[FPBPGEP]] to i8*
  // CEHCK-32:    [[BPCAST:%.+]] = bitcast i8** [[BPGEP]] to i8*
  // CEHCK-32:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[FPBPADDR]], i8* align 8 [[BPCAST]], i64 24, i1 false)
  // CEHCK-32:    [[FPPGEP:%.+]] = getelementptr inbounds [[KMP_PRIVATES_T]], [[KMP_PRIVATES_T]]* [[KMP_PRIVATES]], i32 0, i32 2
  // CEHCK-32:    [[FPPADDR:%.+]] = bitcast [3 x i8*]* [[FPPGEP]] to i8*
  // CEHCK-32:    [[PCAST:%.+]] = bitcast i8** [[PGEP]] to i8*
  // CEHCK-32:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[FPPADDR]], i8* align 8 [[BCAST]], i64 24, i1 false)
  // CEHCK-64:    [[FPBPGEP:%.+]] = getelementptr inbounds [[KMP_PRIVATES_T]], [[KMP_PRIVATES_T]]* [[KMP_PRIVATES]], i32 0, i32 0
  // CEHCK-64:    [[FPBPADDR:%.+]] = bitcast [3 x i8*]* [[FPBPGEP]] to i8*
  // CEHCK-64:    [[BPCAST:%.+]] = bitcast i8** [[BPGEP]] to i8*
  // CEHCK-64:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[FPBPADDR]], i8* align 8 [[BPCAST]], i64 24, i1 false)
  // CEHCK-64:    [[FPPGEP:%.+]] = getelementptr inbounds [[KMP_PRIVATES_T]], [[KMP_PRIVATES_T]]* [[KMP_PRIVATES]], i32 0, i32 1
  // CEHCK-64:    [[FPPADDR:%.+]] = bitcast [3 x i8*]* [[FPPGEP]] to i8*
  // CEHCK-64:    [[PCAST:%.+]] = bitcast i8** [[PGEP]] to i8*
  // CEHCK-64:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[FPPADDR]], i8* align 8 [[BCAST]], i64 24, i1 false)
  // CEHCK-64:    [[FPSIZEGEP]] = getelementptr inbounds [[KMP_PRIVATES_T]], [[KMP_PRIVATES_T]]* [[KMP_PRIVATES]], i32 0, i32 2
  // CEHCK-64:    [[FPSIZEADDR:%.+]] = bitcast [3 x i64]* [[FPSIZEGEP]] to i8*
  // CEHCK-64:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[FPSIZEADDR]], i8* align 8 bitcast ([3 x i64]* [[SIZET2]] to i8*), i64 24, i1 false)
  int lin = 12;
  #pragma omp target parallel for if(target: 1) linear(lin, a : get_val()) nowait
  for (unsigned long long it = 2000; it >= 600; it-=400) {
    aa += 1;
  }




  #pragma omp target parallel for if(target: n>10)
  for (short it = 6; it <= 20; it-=-4) {
    a += 1;
    aa += 1;
  }

  // We capture 3 VLA sizes in this target region





  // The names below are not necessarily consistent with the names used for the
  // addresses above as some are repeated.










  #pragma omp target parallel for if(target: n>20) schedule(static, a)
  for (unsigned char it = 'z'; it >= 'a'; it+=-1) {
    a += 1;
    b[2] += 1.0;
    bn[3] += 1.0;
    c[1][2] += 1.0;
    cn[1][3] += 1.0;
    d.X += 1;
    d.Y += 1;
  }

  return a;
}

// Check that the offloading functions are emitted and that the arguments are
// correct and loaded correctly for the target regions in foo().


// Create stack storage and store argument in there.

// Create stack storage and store argument in there.


// Create stack storage and store argument in there.

// Create local storage for each capture.



// To reduce complexity, we're only going as far as validating the signature of the outlined parallel function.

template<typename tx>
tx ftemplate(int n) {
  tx a = 0;
  short aa = 0;
  tx b[10];

  #pragma omp target parallel for if(target: n>40)
  for (long long i = -10; i < 10; i += 3) {
    a += 1;
    aa += 1;
    b[2] += 1;
  }

  return a;
}

static
int fstatic(int n) {
  int a = 0;
  short aa = 0;
  char aaa = 0;
  int b[10];

  #pragma omp target parallel for if(target: n>50)
  for (unsigned i=100; i<10; i+=10) {
    a += 1;
    aa += 1;
    aaa += 1;
    b[2] += 1;
  }

  return a;
}

struct S1 {
  double a;

  int r1(int n){
    int b = n+1;
    short int c[2][n];

    #pragma omp target parallel for if(target: n>60)
    for (unsigned long long it = 2000; it >= 600; it -= 400) {
      this->a = (double)b + 1.5;
      c[1][1] = ++a;
    }

    return c[1][1] + (int)b;
  }
};

int bar(int n){
  int a = 0;

  a += foo(n);

  S1 S;
  a += S.r1(n);

  a += fstatic(n);

  a += ftemplate<int>(n);

  return a;
}



// We capture 2 VLA sizes in this target region


// The names below are not necessarily consistent with the names used for the
// addresses above as some are repeated.


















// Check that the offloading functions are emitted and that the arguments are
// correct and loaded correctly for the target regions of the callees of bar().

// Create local storage for each capture.
// Store captures in the context.


// To reduce complexity, we're only going as far as validating the signature of the outlined parallel function.


// Create local storage for each capture.
// Store captures in the context.




// To reduce complexity, we're only going as far as validating the signature of the outlined parallel function.

// Create local storage for each capture.
// Store captures in the context.



// To reduce complexity, we're only going as far as validating the signature of the outlined parallel function.


#endif
// CHECK1-LABEL: define {{[^@]+}}@_Z7get_valv
// CHECK1-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    ret i64 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK1-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK1-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK1-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 8
// CHECK1-NEXT:    [[K:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[K_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LIN:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LIN_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED4:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 4
// CHECK1-NEXT:    [[A_CASTED6:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED8:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS10:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS11:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS12:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A_CASTED15:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS20:%.*]] = alloca [10 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS21:%.*]] = alloca [10 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS22:%.*]] = alloca [10 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [10 x i64], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK1-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK1-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK1-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP2]], align 4
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP4]] to i64
// CHECK1-NEXT:    [[TMP6:%.*]] = mul nuw i64 5, [[TMP5]]
// CHECK1-NEXT:    [[VLA1:%.*]] = alloca double, i64 [[TMP6]], align 8
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[__VLA_EXPR1]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103.region_id, i32 0, i8** null, i8** null, i64* null, i64* null, i8** null, i8** null, i32 1, i32 0)
// CHECK1-NEXT:    [[TMP8:%.*]] = icmp ne i32 [[TMP7]], 0
// CHECK1-NEXT:    br i1 [[TMP8]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103() #[[ATTR4:[0-9]+]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv()
// CHECK1-NEXT:    store i64 [[CALL]], i64* [[K]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP9]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, i64* [[K]], align 8
// CHECK1-NEXT:    store i64 [[TMP11]], i64* [[K_CASTED]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i64, i64* [[K_CASTED]], align 8
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l110(i64 [[TMP10]], i64 [[TMP12]]) #[[ATTR4]]
// CHECK1-NEXT:    store i32 12, i32* [[LIN]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP13]], i16* [[CONV2]], align 2
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[LIN]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[LIN_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP15]], i32* [[CONV3]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i64, i64* [[LIN_CASTED]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED4]] to i32*
// CHECK1-NEXT:    store i32 [[TMP17]], i32* [[CONV5]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i64, i64* [[A_CASTED4]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK1-NEXT:    store i64 [[TMP14]], i64* [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i64*
// CHECK1-NEXT:    store i64 [[TMP14]], i64* [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i64*
// CHECK1-NEXT:    store i64 [[TMP16]], i64* [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK1-NEXT:    store i64 [[TMP16]], i64* [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i64*
// CHECK1-NEXT:    store i64 [[TMP18]], i64* [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i64*
// CHECK1-NEXT:    store i64 [[TMP18]], i64* [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP37:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    store i16 [[TMP37]], i16* [[TMP36]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, i32* [[LIN]], align 4
// CHECK1-NEXT:    store i32 [[TMP39]], i32* [[TMP38]], align 4
// CHECK1-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP41:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    store i32 [[TMP41]], i32* [[TMP40]], align 4
// CHECK1-NEXT:    [[TMP42:%.*]] = call i8* @__kmpc_omp_target_task_alloc(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 1, i64 120, i64 12, i32 (i32, i8*)* bitcast (i32 (i32, %struct.kmp_task_t_with_privates*)* @.omp_task_entry. to i32 (i32, i8*)*), i64 -1)
// CHECK1-NEXT:    [[TMP43:%.*]] = bitcast i8* [[TMP42]] to %struct.kmp_task_t_with_privates*
// CHECK1-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP43]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP44]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP46:%.*]] = load i8*, i8** [[TMP45]], align 8
// CHECK1-NEXT:    [[TMP47:%.*]] = bitcast %struct.anon* [[AGG_CAPTURED]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP46]], i8* align 4 [[TMP47]], i64 12, i1 false)
// CHECK1-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP43]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP49:%.*]] = bitcast i8* [[TMP46]] to %struct.anon*
// CHECK1-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP48]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP51:%.*]] = bitcast [3 x i8*]* [[TMP50]] to i8*
// CHECK1-NEXT:    [[TMP52:%.*]] = bitcast i8** [[TMP34]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP51]], i8* align 8 [[TMP52]], i64 24, i1 false)
// CHECK1-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP48]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP54:%.*]] = bitcast [3 x i8*]* [[TMP53]] to i8*
// CHECK1-NEXT:    [[TMP55:%.*]] = bitcast i8** [[TMP35]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP54]], i8* align 8 [[TMP55]], i64 24, i1 false)
// CHECK1-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP48]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP57:%.*]] = bitcast [3 x i64]* [[TMP56]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP57]], i8* align 8 bitcast ([3 x i64]* @.offload_sizes to i8*), i64 24, i1 false)
// CHECK1-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP48]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP59:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    store i16 [[TMP59]], i16* [[TMP58]], align 8
// CHECK1-NEXT:    [[TMP60:%.*]] = call i32 @__kmpc_omp_task(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i8* [[TMP42]])
// CHECK1-NEXT:    [[TMP61:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV7:%.*]] = bitcast i64* [[A_CASTED6]] to i32*
// CHECK1-NEXT:    store i32 [[TMP61]], i32* [[CONV7]], align 4
// CHECK1-NEXT:    [[TMP62:%.*]] = load i64, i64* [[A_CASTED6]], align 8
// CHECK1-NEXT:    [[TMP63:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV9:%.*]] = bitcast i64* [[AA_CASTED8]] to i16*
// CHECK1-NEXT:    store i16 [[TMP63]], i16* [[CONV9]], align 2
// CHECK1-NEXT:    [[TMP64:%.*]] = load i64, i64* [[AA_CASTED8]], align 8
// CHECK1-NEXT:    [[TMP65:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP65]], 10
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP67:%.*]] = bitcast i8** [[TMP66]] to i64*
// CHECK1-NEXT:    store i64 [[TMP62]], i64* [[TMP67]], align 8
// CHECK1-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS11]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP69:%.*]] = bitcast i8** [[TMP68]] to i64*
// CHECK1-NEXT:    store i64 [[TMP62]], i64* [[TMP69]], align 8
// CHECK1-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP70]], align 8
// CHECK1-NEXT:    [[TMP71:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP72:%.*]] = bitcast i8** [[TMP71]] to i64*
// CHECK1-NEXT:    store i64 [[TMP64]], i64* [[TMP72]], align 8
// CHECK1-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS11]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP74:%.*]] = bitcast i8** [[TMP73]] to i64*
// CHECK1-NEXT:    store i64 [[TMP64]], i64* [[TMP74]], align 8
// CHECK1-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP75]], align 8
// CHECK1-NEXT:    [[TMP76:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS11]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP78:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146.region_id, i32 2, i8** [[TMP76]], i8** [[TMP77]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK1-NEXT:    [[TMP79:%.*]] = icmp ne i32 [[TMP78]], 0
// CHECK1-NEXT:    br i1 [[TMP79]], label [[OMP_OFFLOAD_FAILED13:%.*]], label [[OMP_OFFLOAD_CONT14:%.*]]
// CHECK1:       omp_offload.failed13:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146(i64 [[TMP62]], i64 [[TMP64]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT14]]
// CHECK1:       omp_offload.cont14:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146(i64 [[TMP62]], i64 [[TMP64]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP80:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    store i32 [[TMP80]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP81:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV16:%.*]] = bitcast i64* [[A_CASTED15]] to i32*
// CHECK1-NEXT:    store i32 [[TMP81]], i32* [[CONV16]], align 4
// CHECK1-NEXT:    [[TMP82:%.*]] = load i64, i64* [[A_CASTED15]], align 8
// CHECK1-NEXT:    [[TMP83:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CONV17:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP83]], i32* [[CONV17]], align 4
// CHECK1-NEXT:    [[TMP84:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK1-NEXT:    [[TMP85:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP18:%.*]] = icmp sgt i32 [[TMP85]], 20
// CHECK1-NEXT:    br i1 [[CMP18]], label [[OMP_IF_THEN19:%.*]], label [[OMP_IF_ELSE25:%.*]]
// CHECK1:       omp_if.then19:
// CHECK1-NEXT:    [[TMP86:%.*]] = mul nuw i64 [[TMP2]], 4
// CHECK1-NEXT:    [[TMP87:%.*]] = mul nuw i64 5, [[TMP5]]
// CHECK1-NEXT:    [[TMP88:%.*]] = mul nuw i64 [[TMP87]], 8
// CHECK1-NEXT:    [[TMP89:%.*]] = bitcast [10 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP89]], i8* align 8 bitcast ([10 x i64]* @.offload_sizes.8 to i8*), i64 80, i1 false)
// CHECK1-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to i64*
// CHECK1-NEXT:    store i64 [[TMP82]], i64* [[TMP91]], align 8
// CHECK1-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP93:%.*]] = bitcast i8** [[TMP92]] to i64*
// CHECK1-NEXT:    store i64 [[TMP82]], i64* [[TMP93]], align 8
// CHECK1-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP94]], align 8
// CHECK1-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP96:%.*]] = bitcast i8** [[TMP95]] to [10 x float]**
// CHECK1-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP96]], align 8
// CHECK1-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP98:%.*]] = bitcast i8** [[TMP97]] to [10 x float]**
// CHECK1-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP98]], align 8
// CHECK1-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP99]], align 8
// CHECK1-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP101:%.*]] = bitcast i8** [[TMP100]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP101]], align 8
// CHECK1-NEXT:    [[TMP102:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP103:%.*]] = bitcast i8** [[TMP102]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP103]], align 8
// CHECK1-NEXT:    [[TMP104:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP104]], align 8
// CHECK1-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP106:%.*]] = bitcast i8** [[TMP105]] to float**
// CHECK1-NEXT:    store float* [[VLA]], float** [[TMP106]], align 8
// CHECK1-NEXT:    [[TMP107:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP108:%.*]] = bitcast i8** [[TMP107]] to float**
// CHECK1-NEXT:    store float* [[VLA]], float** [[TMP108]], align 8
// CHECK1-NEXT:    [[TMP109:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP86]], i64* [[TMP109]], align 8
// CHECK1-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP110]], align 8
// CHECK1-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to [5 x [10 x double]]**
// CHECK1-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP112]], align 8
// CHECK1-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to [5 x [10 x double]]**
// CHECK1-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP114]], align 8
// CHECK1-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 4
// CHECK1-NEXT:    store i8* null, i8** [[TMP115]], align 8
// CHECK1-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 5
// CHECK1-NEXT:    [[TMP117:%.*]] = bitcast i8** [[TMP116]] to i64*
// CHECK1-NEXT:    store i64 5, i64* [[TMP117]], align 8
// CHECK1-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 5
// CHECK1-NEXT:    [[TMP119:%.*]] = bitcast i8** [[TMP118]] to i64*
// CHECK1-NEXT:    store i64 5, i64* [[TMP119]], align 8
// CHECK1-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 5
// CHECK1-NEXT:    store i8* null, i8** [[TMP120]], align 8
// CHECK1-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP122:%.*]] = bitcast i8** [[TMP121]] to i64*
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[TMP122]], align 8
// CHECK1-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP124:%.*]] = bitcast i8** [[TMP123]] to i64*
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[TMP124]], align 8
// CHECK1-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 6
// CHECK1-NEXT:    store i8* null, i8** [[TMP125]], align 8
// CHECK1-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 7
// CHECK1-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to double**
// CHECK1-NEXT:    store double* [[VLA1]], double** [[TMP127]], align 8
// CHECK1-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 7
// CHECK1-NEXT:    [[TMP129:%.*]] = bitcast i8** [[TMP128]] to double**
// CHECK1-NEXT:    store double* [[VLA1]], double** [[TMP129]], align 8
// CHECK1-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK1-NEXT:    store i64 [[TMP88]], i64* [[TMP130]], align 8
// CHECK1-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 7
// CHECK1-NEXT:    store i8* null, i8** [[TMP131]], align 8
// CHECK1-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to %struct.TT**
// CHECK1-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP133]], align 8
// CHECK1-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP135:%.*]] = bitcast i8** [[TMP134]] to %struct.TT**
// CHECK1-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP135]], align 8
// CHECK1-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 8
// CHECK1-NEXT:    store i8* null, i8** [[TMP136]], align 8
// CHECK1-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 9
// CHECK1-NEXT:    [[TMP138:%.*]] = bitcast i8** [[TMP137]] to i64*
// CHECK1-NEXT:    store i64 [[TMP84]], i64* [[TMP138]], align 8
// CHECK1-NEXT:    [[TMP139:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 9
// CHECK1-NEXT:    [[TMP140:%.*]] = bitcast i8** [[TMP139]] to i64*
// CHECK1-NEXT:    store i64 [[TMP84]], i64* [[TMP140]], align 8
// CHECK1-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 9
// CHECK1-NEXT:    store i8* null, i8** [[TMP141]], align 8
// CHECK1-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP145:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170.region_id, i32 10, i8** [[TMP142]], i8** [[TMP143]], i64* [[TMP144]], i64* getelementptr inbounds ([10 x i64], [10 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK1-NEXT:    [[TMP146:%.*]] = icmp ne i32 [[TMP145]], 0
// CHECK1-NEXT:    br i1 [[TMP146]], label [[OMP_OFFLOAD_FAILED23:%.*]], label [[OMP_OFFLOAD_CONT24:%.*]]
// CHECK1:       omp_offload.failed23:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170(i64 [[TMP82]], [10 x float]* [[B]], i64 [[TMP2]], float* [[VLA]], [5 x [10 x double]]* [[C]], i64 5, i64 [[TMP5]], double* [[VLA1]], %struct.TT* [[D]], i64 [[TMP84]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT24]]
// CHECK1:       omp_offload.cont24:
// CHECK1-NEXT:    br label [[OMP_IF_END26:%.*]]
// CHECK1:       omp_if.else25:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170(i64 [[TMP82]], [10 x float]* [[B]], i64 [[TMP2]], float* [[VLA]], [5 x [10 x double]]* [[C]], i64 5, i64 [[TMP5]], double* [[VLA1]], %struct.TT* [[D]], i64 [[TMP84]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END26]]
// CHECK1:       omp_if.end26:
// CHECK1-NEXT:    [[TMP147:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP148:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK1-NEXT:    call void @llvm.stackrestore(i8* [[TMP148]])
// CHECK1-NEXT:    ret i32 [[TMP147]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103
// CHECK1-SAME: () #[[ATTR2:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 0, void (i32*, i32*, ...)* bitcast (void (i32*, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*))
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 5, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 5
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 5, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 5
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 3, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_cancel(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK1-NEXT:    [[TMP9:%.*]] = icmp ne i32 [[TMP8]], 0
// CHECK1-NEXT:    br i1 [[TMP9]], label [[DOTCANCEL_EXIT:%.*]], label [[DOTCANCEL_CONTINUE:%.*]]
// CHECK1:       .cancel.exit:
// CHECK1-NEXT:    br label [[CANCEL_EXIT:%.*]]
// CHECK1:       .cancel.continue:
// CHECK1-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_cancellationpoint(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK1-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK1-NEXT:    br i1 [[TMP11]], label [[DOTCANCEL_EXIT2:%.*]], label [[DOTCANCEL_CONTINUE3:%.*]]
// CHECK1:       .cancel.exit2:
// CHECK1-NEXT:    br label [[CANCEL_EXIT]]
// CHECK1:       .cancel.continue3:
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK1-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    br label [[CANCEL_CONT:%.*]]
// CHECK1:       cancel.cont:
// CHECK1-NEXT:    ret void
// CHECK1:       cancel.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    br label [[CANCEL_CONT]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l110
// CHECK1-SAME: (i64 noundef [[A:%.*]], i64 noundef [[K:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[K_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[K_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[K]], i64* [[K_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[K_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[K_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[K_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[K:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[K_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[K1:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[K]], i64* [[K_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load i64, i64* [[K_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[TMP0]], i64* [[DOTLINEAR_START]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 8, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP2]])
// CHECK1-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]], i32 35, i32 0, i32 8, i32 1, i32 1)
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK1:       omp.dispatch.cond:
// CHECK1-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP3]], 0
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK1:       omp.dispatch.body:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 10, [[MUL]]
// CHECK1-NEXT:    store i32 [[SUB]], i32* [[I]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTLINEAR_START]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[MUL2:%.*]] = mul nsw i32 [[TMP9]], 3
// CHECK1-NEXT:    [[CONV3:%.*]] = sext i32 [[MUL2]] to i64
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP8]], [[CONV3]]
// CHECK1-NEXT:    store i64 [[ADD]], i64* [[K1]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK1-NEXT:    store i32 [[ADD4]], i32* [[CONV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK1-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK1:       omp.dispatch.inc:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK1:       omp.dispatch.end:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK1-NEXT:    br i1 [[TMP13]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK1:       .omp.linear.pu:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, i64* [[K1]], align 8
// CHECK1-NEXT:    store i64 [[TMP14]], i64* [[K_ADDR]], align 8
// CHECK1-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK1:       .omp.linear.pu.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138
// CHECK1-SAME: (i64 noundef [[AA:%.*]], i64 noundef [[LIN:%.*]], i64 noundef [[A:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LIN_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LIN_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[LIN]], i64* [[LIN_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[LIN_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP0]], i16* [[CONV3]], align 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[CONV4:%.*]] = bitcast i64* [[LIN_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP2]], i32* [[CONV4]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[LIN_CASTED]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV2]], align 4
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[CONV5]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[LIN:%.*]], i64 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LIN_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_START3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTLINEAR_STEP:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LIN4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A5:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[LIN]], i64* [[LIN_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[LIN_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[DOTLINEAR_START]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV2]], align 4
// CHECK1-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START3]], align 4
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv()
// CHECK1-NEXT:    store i64 [[CALL]], i64* [[DOTLINEAR_STEP]], align 8
// CHECK1-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK1-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK1-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3]], i32 [[TMP3]])
// CHECK1-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP4]], 3
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp ule i64 [[TMP7]], [[TMP8]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[MUL:%.*]] = mul i64 [[TMP9]], 400
// CHECK1-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK1-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK1-NEXT:    [[CONV7:%.*]] = sext i32 [[TMP10]] to i64
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK1-NEXT:    [[MUL8:%.*]] = mul i64 [[TMP11]], [[TMP12]]
// CHECK1-NEXT:    [[ADD:%.*]] = add i64 [[CONV7]], [[MUL8]]
// CHECK1-NEXT:    [[CONV9:%.*]] = trunc i64 [[ADD]] to i32
// CHECK1-NEXT:    store i32 [[CONV9]], i32* [[LIN4]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTLINEAR_START3]], align 4
// CHECK1-NEXT:    [[CONV10:%.*]] = sext i32 [[TMP13]] to i64
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK1-NEXT:    [[MUL11:%.*]] = mul i64 [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    [[ADD12:%.*]] = add i64 [[CONV10]], [[MUL11]]
// CHECK1-NEXT:    [[CONV13:%.*]] = trunc i64 [[ADD12]] to i32
// CHECK1-NEXT:    store i32 [[CONV13]], i32* [[A5]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK1-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP16]] to i32
// CHECK1-NEXT:    [[ADD15:%.*]] = add nsw i32 [[CONV14]], 1
// CHECK1-NEXT:    [[CONV16:%.*]] = trunc i32 [[ADD15]] to i16
// CHECK1-NEXT:    store i16 [[CONV16]], i16* [[CONV]], align 2
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[ADD17:%.*]] = add i64 [[TMP17]], 1
// CHECK1-NEXT:    store i64 [[ADD17]], i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = icmp ne i32 [[TMP18]], 0
// CHECK1-NEXT:    br i1 [[TMP19]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK1:       .omp.linear.pu:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[LIN4]], align 4
// CHECK1-NEXT:    store i32 [[TMP20]], i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A5]], align 4
// CHECK1-NEXT:    store i32 [[TMP21]], i32* [[CONV2]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK1:       .omp.linear.pu.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK1-SAME: (%struct..kmp_privates.t* noalias noundef [[TMP0:%.*]], i16** noalias noundef [[TMP1:%.*]], [3 x i8*]** noalias noundef [[TMP2:%.*]], [3 x i8*]** noalias noundef [[TMP3:%.*]], [3 x i64]** noalias noundef [[TMP4:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca %struct..kmp_privates.t*, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca i16**, align 8
// CHECK1-NEXT:    [[DOTADDR2:%.*]] = alloca [3 x i8*]**, align 8
// CHECK1-NEXT:    [[DOTADDR3:%.*]] = alloca [3 x i8*]**, align 8
// CHECK1-NEXT:    [[DOTADDR4:%.*]] = alloca [3 x i64]**, align 8
// CHECK1-NEXT:    store %struct..kmp_privates.t* [[TMP0]], %struct..kmp_privates.t** [[DOTADDR]], align 8
// CHECK1-NEXT:    store i16** [[TMP1]], i16*** [[DOTADDR1]], align 8
// CHECK1-NEXT:    store [3 x i8*]** [[TMP2]], [3 x i8*]*** [[DOTADDR2]], align 8
// CHECK1-NEXT:    store [3 x i8*]** [[TMP3]], [3 x i8*]*** [[DOTADDR3]], align 8
// CHECK1-NEXT:    store [3 x i64]** [[TMP4]], [3 x i64]*** [[DOTADDR4]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load %struct..kmp_privates.t*, %struct..kmp_privates.t** [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR2]], align 8
// CHECK1-NEXT:    store [3 x i8*]* [[TMP6]], [3 x i8*]** [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP9:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR3]], align 8
// CHECK1-NEXT:    store [3 x i8*]* [[TMP8]], [3 x i8*]** [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP11:%.*]] = load [3 x i64]**, [3 x i64]*** [[DOTADDR4]], align 8
// CHECK1-NEXT:    store [3 x i64]* [[TMP10]], [3 x i64]** [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP13:%.*]] = load i16**, i16*** [[DOTADDR1]], align 8
// CHECK1-NEXT:    store i16* [[TMP12]], i16** [[TMP13]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK1-SAME: (i32 noundef signext [[TMP0:%.*]], %struct.kmp_task_t_with_privates* noalias noundef [[TMP1:%.*]]) #[[ATTR7:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca void (i8*, ...)*, align 8
// CHECK1-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca %struct.anon*, align 8
// CHECK1-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca i16*, align 8
// CHECK1-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca [3 x i8*]*, align 8
// CHECK1-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca [3 x i8*]*, align 8
// CHECK1-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca [3 x i64]*, align 8
// CHECK1-NEXT:    [[AA_CASTED_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LIN_CASTED_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca %struct.kmp_task_t_with_privates*, align 8
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[DOTADDR]], align 4
// CHECK1-NEXT:    store %struct.kmp_task_t_with_privates* [[TMP1]], %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTADDR]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load %struct.kmp_task_t_with_privates*, %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load i8*, i8** [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = bitcast i8* [[TMP7]] to %struct.anon*
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast %struct..kmp_privates.t* [[TMP9]] to i8*
// CHECK1-NEXT:    [[TMP11:%.*]] = bitcast %struct.kmp_task_t_with_privates* [[TMP3]] to i8*
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META15:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META18:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META20:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META22:![0-9]+]])
// CHECK1-NEXT:    store i32 [[TMP2]], i32* [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !24
// CHECK1-NEXT:    store i32* [[TMP5]], i32** [[DOTPART_ID__ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    store i8* [[TMP10]], i8** [[DOTPRIVATES__ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    store void (i8*, ...)* bitcast (void (%struct..kmp_privates.t*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)* @.omp_task_privates_map. to void (i8*, ...)*), void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    store i8* [[TMP11]], i8** [[DOTTASK_T__ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    store %struct.anon* [[TMP8]], %struct.anon** [[__CONTEXT_ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP12:%.*]] = load %struct.anon*, %struct.anon** [[__CONTEXT_ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP13:%.*]] = load void (i8*, ...)*, void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[DOTPRIVATES__ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast void (i8*, ...)* [[TMP13]] to void (i8*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)*
// CHECK1-NEXT:    call void [[TMP15]](i8* [[TMP14]], i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK1-NEXT:    [[TMP16:%.*]] = load i16*, i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP17:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP18:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP19:%.*]] = load [3 x i64]*, [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP17]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP18]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[TMP19]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], %struct.anon* [[TMP12]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[TMP12]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP25:%.*]] = call i32 @__tgt_target_teams_nowait_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* [[TMP22]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0, i32 0, i8* null, i32 0, i8* null) #[[ATTR4]]
// CHECK1-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK1-NEXT:    br i1 [[TMP26]], label [[OMP_OFFLOAD_FAILED_I:%.*]], label [[DOTOMP_OUTLINED__3_EXIT:%.*]]
// CHECK1:       omp_offload.failed.i:
// CHECK1-NEXT:    [[TMP27:%.*]] = load i16, i16* [[TMP16]], align 2
// CHECK1-NEXT:    [[CONV_I:%.*]] = bitcast i64* [[AA_CASTED_I]] to i16*
// CHECK1-NEXT:    store i16 [[TMP27]], i16* [[CONV_I]], align 2, !noalias !24
// CHECK1-NEXT:    [[TMP28:%.*]] = load i64, i64* [[AA_CASTED_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK1-NEXT:    [[CONV4_I:%.*]] = bitcast i64* [[LIN_CASTED_I]] to i32*
// CHECK1-NEXT:    store i32 [[TMP29]], i32* [[CONV4_I]], align 4, !noalias !24
// CHECK1-NEXT:    [[TMP30:%.*]] = load i64, i64* [[LIN_CASTED_I]], align 8, !noalias !24
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK1-NEXT:    [[CONV5_I:%.*]] = bitcast i64* [[A_CASTED_I]] to i32*
// CHECK1-NEXT:    store i32 [[TMP31]], i32* [[CONV5_I]], align 4, !noalias !24
// CHECK1-NEXT:    [[TMP32:%.*]] = load i64, i64* [[A_CASTED_I]], align 8, !noalias !24
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138(i64 [[TMP28]], i64 [[TMP30]], i64 [[TMP32]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[DOTOMP_OUTLINED__3_EXIT]]
// CHECK1:       .omp_outlined..3.exit:
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146
// CHECK1-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[CONV2]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP2]], i16* [[CONV3]], align 2
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[IT:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 3, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 3
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 6, [[MUL]]
// CHECK1-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV3]], i16* [[IT]], align 2
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK1-NEXT:    store i32 [[ADD4]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[CONV5:%.*]] = sext i16 [[TMP9]] to i32
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[CONV5]], 1
// CHECK1-NEXT:    [[CONV7:%.*]] = trunc i32 [[ADD6]] to i16
// CHECK1-NEXT:    store i16 [[CONV7]], i16* [[CONV1]], align 2
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK1-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170
// CHECK1-SAME: (i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK1-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK1-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK1-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK1-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK1-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV6:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[CONV6]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV5]], align 4
// CHECK1-NEXT:    [[CONV7:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP10]], i32* [[CONV7]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 10, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, [10 x float]*, i64, float*, [5 x [10 x double]]*, i64, i64, double*, %struct.TT*, i64)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i64 [[TMP9]], [10 x float]* [[TMP0]], i64 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i64 [[TMP4]], i64 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]], i64 [[TMP11]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK1-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK1-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[IT:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK1-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK1-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK1-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 25, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV5]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP8]])
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK1:       omp.dispatch.cond:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 25
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 25, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK1:       omp.dispatch.body:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// CHECK1-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 122, [[MUL]]
// CHECK1-NEXT:    [[CONV8:%.*]] = trunc i32 [[SUB]] to i8
// CHECK1-NEXT:    store i8 [[CONV8]], i8* [[IT]], align 1
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK1-NEXT:    [[CONV9:%.*]] = fpext float [[TMP20]] to double
// CHECK1-NEXT:    [[ADD10:%.*]] = fadd double [[CONV9]], 1.000000e+00
// CHECK1-NEXT:    [[CONV11:%.*]] = fptrunc double [[ADD10]] to float
// CHECK1-NEXT:    store float [[CONV11]], float* [[ARRAYIDX]], align 4
// CHECK1-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds float, float* [[TMP2]], i64 3
// CHECK1-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX12]], align 4
// CHECK1-NEXT:    [[CONV13:%.*]] = fpext float [[TMP21]] to double
// CHECK1-NEXT:    [[ADD14:%.*]] = fadd double [[CONV13]], 1.000000e+00
// CHECK1-NEXT:    [[CONV15:%.*]] = fptrunc double [[ADD14]] to float
// CHECK1-NEXT:    store float [[CONV15]], float* [[ARRAYIDX12]], align 4
// CHECK1-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i64 0, i64 1
// CHECK1-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX16]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX17]], align 8
// CHECK1-NEXT:    [[ADD18:%.*]] = fadd double [[TMP22]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD18]], double* [[ARRAYIDX17]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = mul nsw i64 1, [[TMP5]]
// CHECK1-NEXT:    [[ARRAYIDX19:%.*]] = getelementptr inbounds double, double* [[TMP6]], i64 [[TMP23]]
// CHECK1-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX19]], i64 3
// CHECK1-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX20]], align 8
// CHECK1-NEXT:    [[ADD21:%.*]] = fadd double [[TMP24]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD21]], double* [[ARRAYIDX20]], align 8
// CHECK1-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP25:%.*]] = load i64, i64* [[X]], align 8
// CHECK1-NEXT:    [[ADD22:%.*]] = add nsw i64 [[TMP25]], 1
// CHECK1-NEXT:    store i64 [[ADD22]], i64* [[X]], align 8
// CHECK1-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP26:%.*]] = load i8, i8* [[Y]], align 8
// CHECK1-NEXT:    [[CONV23:%.*]] = sext i8 [[TMP26]] to i32
// CHECK1-NEXT:    [[ADD24:%.*]] = add nsw i32 [[CONV23]], 1
// CHECK1-NEXT:    [[CONV25:%.*]] = trunc i32 [[ADD24]] to i8
// CHECK1-NEXT:    store i8 [[CONV25]], i8* [[Y]], align 8
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP27]], 1
// CHECK1-NEXT:    store i32 [[ADD26]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK1:       omp.dispatch.inc:
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD27:%.*]] = add nsw i32 [[TMP28]], [[TMP29]]
// CHECK1-NEXT:    store i32 [[ADD27]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD28:%.*]] = add nsw i32 [[TMP30]], [[TMP31]]
// CHECK1-NEXT:    store i32 [[ADD28]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK1:       omp.dispatch.end:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z3bari
// CHECK1-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 8
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z3fooi(i32 noundef signext [[TMP0]])
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CALL1:%.*]] = call noundef signext i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 8 dereferenceable(8) [[S]], i32 noundef signext [[TMP2]])
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK1-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CALL3:%.*]] = call noundef signext i32 @_ZL7fstatici(i32 noundef signext [[TMP4]])
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK1-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CALL5:%.*]] = call noundef signext i32 @_Z9ftemplateIiET_i(i32 noundef signext [[TMP6]])
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK1-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK1-SAME: (%struct.S1* noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [5 x i64], align 8
// CHECK1-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK1-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK1-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK1-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP4]], align 2
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 60
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP8:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK1-NEXT:    [[TMP9:%.*]] = mul nuw i64 [[TMP8]], 2
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast [5 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP10]], i8* align 8 bitcast ([5 x i64]* @.offload_sizes.11 to i8*), i64 40, i1 false)
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to %struct.S1**
// CHECK1-NEXT:    store %struct.S1* [[THIS1]], %struct.S1** [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to double**
// CHECK1-NEXT:    store double* [[A]], double** [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i64*
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[TMP19]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i64*
// CHECK1-NEXT:    store i64 2, i64* [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i64*
// CHECK1-NEXT:    store i64 2, i64* [[TMP24]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i16**
// CHECK1-NEXT:    store i16* [[VLA]], i16** [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i16**
// CHECK1-NEXT:    store i16* [[VLA]], i16** [[TMP34]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP9]], i64* [[TMP35]], align 8
// CHECK1-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK1-NEXT:    store i8* null, i8** [[TMP36]], align 8
// CHECK1-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP40:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242.region_id, i32 5, i8** [[TMP37]], i8** [[TMP38]], i64* [[TMP39]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK1-NEXT:    [[TMP41:%.*]] = icmp ne i32 [[TMP40]], 0
// CHECK1-NEXT:    br i1 [[TMP41]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242(%struct.S1* [[THIS1]], i64 [[TMP6]], i64 2, i64 [[TMP2]], i16* [[VLA]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242(%struct.S1* [[THIS1]], i64 [[TMP6]], i64 2, i64 [[TMP2]], i16* [[VLA]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP42:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP42]]
// CHECK1-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK1-NEXT:    [[TMP43:%.*]] = load i16, i16* [[ARRAYIDX2]], align 2
// CHECK1-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP43]] to i32
// CHECK1-NEXT:    [[TMP44:%.*]] = load i32, i32* [[B]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], [[TMP44]]
// CHECK1-NEXT:    [[TMP45:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK1-NEXT:    call void @llvm.stackrestore(i8* [[TMP45]])
// CHECK1-NEXT:    ret i32 [[ADD4]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK1-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK1-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i8, i8* [[AAA]], align 1
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK1-NEXT:    store i8 [[TMP4]], i8* [[CONV2]], align 1
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 50
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i64*
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP21]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to [10 x i32]**
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to [10 x i32]**
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP26]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP29:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224.region_id, i32 4, i8** [[TMP27]], i8** [[TMP28]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.14, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.15, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK1-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK1-NEXT:    br i1 [[TMP30]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    ret i32 [[TMP31]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK1-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 40
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [10 x i32]**
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [10 x i32]**
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.17, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.18, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK1-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK1-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242
// CHECK1-SAME: (%struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[CONV3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i64, i64, i64, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i64 [[TMP5]], i64 [[TMP1]], i64 [[TMP2]], i16* [[TMP3]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK1-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP6]], 3
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK1-NEXT:    store i64 [[TMP8]], i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[CMP3:%.*]] = icmp ule i64 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[MUL:%.*]] = mul i64 [[TMP11]], 400
// CHECK1-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK1-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV4:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK1-NEXT:    [[ADD:%.*]] = fadd double [[CONV4]], 1.500000e+00
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK1-NEXT:    store double [[ADD]], double* [[A]], align 8
// CHECK1-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP13:%.*]] = load double, double* [[A5]], align 8
// CHECK1-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK1-NEXT:    store double [[INC]], double* [[A5]], align 8
// CHECK1-NEXT:    [[CONV6:%.*]] = fptosi double [[INC]] to i16
// CHECK1-NEXT:    [[TMP14:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP14]]
// CHECK1-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK1-NEXT:    store i16 [[CONV6]], i16* [[ARRAYIDX7]], align 2
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[ADD8:%.*]] = add i64 [[TMP15]], 1
// CHECK1-NEXT:    store i64 [[ADD8]], i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224
// CHECK1-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP1]], i32* [[CONV3]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[CONV4:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP3]], i16* [[CONV4]], align 2
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i8, i8* [[CONV2]], align 1
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK1-NEXT:    store i8 [[TMP5]], i8* [[CONV5]], align 1
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, [10 x i32]*)* @.omp_outlined..13 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], [10 x i32]* [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..13
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207
// CHECK1-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP1]], i32* [[CONV2]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..16 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..16
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK1-NEXT:    store i64 6, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_8(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[TMP3]], 6
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i64 [ 6, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK1-NEXT:    [[CMP2:%.*]] = icmp sle i64 [[TMP6]], [[TMP7]]
// CHECK1-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i64 [[TMP8]], 3
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i64 -10, [[MUL]]
// CHECK1-NEXT:    store i64 [[ADD]], i64* [[I]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK1-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP10]] to i32
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK1-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK1-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK1-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i64 [[TMP12]], 1
// CHECK1-NEXT:    store i64 [[ADD8]], i64* [[DOTOMP_IV]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR6]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z7get_valv
// CHECK3-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    ret i64 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK3-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK3-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK3-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 4
// CHECK3-NEXT:    [[K:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LIN:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LIN_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 4
// CHECK3-NEXT:    [[A_CASTED3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS6:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS7:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS8:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED11:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS14:%.*]] = alloca [10 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS15:%.*]] = alloca [10 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS16:%.*]] = alloca [10 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [10 x i64], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK3-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK3-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK3-NEXT:    [[VLA:%.*]] = alloca float, i32 [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = mul nuw i32 5, [[TMP3]]
// CHECK3-NEXT:    [[VLA1:%.*]] = alloca double, i32 [[TMP4]], align 8
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[__VLA_EXPR1]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103.region_id, i32 0, i8** null, i8** null, i64* null, i64* null, i8** null, i8** null, i32 1, i32 0)
// CHECK3-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK3-NEXT:    br i1 [[TMP6]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103() #[[ATTR4:[0-9]+]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv()
// CHECK3-NEXT:    store i64 [[CALL]], i64* [[K]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l110(i32 [[TMP8]], i64* [[K]]) #[[ATTR4]]
// CHECK3-NEXT:    store i32 12, i32* [[LIN]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP9]], i16* [[CONV]], align 2
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[LIN]], align 4
// CHECK3-NEXT:    store i32 [[TMP11]], i32* [[LIN_CASTED]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[LIN_CASTED]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP13]], i32* [[A_CASTED2]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[A_CASTED2]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32*
// CHECK3-NEXT:    store i32 [[TMP10]], i32* [[TMP16]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32*
// CHECK3-NEXT:    store i32 [[TMP10]], i32* [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK3-NEXT:    store i32 [[TMP12]], i32* [[TMP21]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32*
// CHECK3-NEXT:    store i32 [[TMP12]], i32* [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP26:%.*]] = bitcast i8** [[TMP25]] to i32*
// CHECK3-NEXT:    store i32 [[TMP14]], i32* [[TMP26]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to i32*
// CHECK3-NEXT:    store i32 [[TMP14]], i32* [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP33:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    store i16 [[TMP33]], i16* [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP35:%.*]] = load i32, i32* [[LIN]], align 4
// CHECK3-NEXT:    store i32 [[TMP35]], i32* [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP37:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP37]], i32* [[TMP36]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = call i8* @__kmpc_omp_target_task_alloc(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 1, i32 72, i32 12, i32 (i32, i8*)* bitcast (i32 (i32, %struct.kmp_task_t_with_privates*)* @.omp_task_entry. to i32 (i32, i8*)*), i64 -1)
// CHECK3-NEXT:    [[TMP39:%.*]] = bitcast i8* [[TMP38]] to %struct.kmp_task_t_with_privates*
// CHECK3-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP39]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP40]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[TMP41]], align 4
// CHECK3-NEXT:    [[TMP43:%.*]] = bitcast %struct.anon* [[AGG_CAPTURED]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP42]], i8* align 4 [[TMP43]], i32 12, i1 false)
// CHECK3-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP39]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP45:%.*]] = bitcast i8* [[TMP42]] to %struct.anon*
// CHECK3-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP47:%.*]] = bitcast [3 x i64]* [[TMP46]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP47]], i8* align 4 bitcast ([3 x i64]* @.offload_sizes to i8*), i32 24, i1 false)
// CHECK3-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP49:%.*]] = bitcast [3 x i8*]* [[TMP48]] to i8*
// CHECK3-NEXT:    [[TMP50:%.*]] = bitcast i8** [[TMP30]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP49]], i8* align 4 [[TMP50]], i32 12, i1 false)
// CHECK3-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP52:%.*]] = bitcast [3 x i8*]* [[TMP51]] to i8*
// CHECK3-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP31]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP52]], i8* align 4 [[TMP53]], i32 12, i1 false)
// CHECK3-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP55:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    store i16 [[TMP55]], i16* [[TMP54]], align 4
// CHECK3-NEXT:    [[TMP56:%.*]] = call i32 @__kmpc_omp_task(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i8* [[TMP38]])
// CHECK3-NEXT:    [[TMP57:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP57]], i32* [[A_CASTED3]], align 4
// CHECK3-NEXT:    [[TMP58:%.*]] = load i32, i32* [[A_CASTED3]], align 4
// CHECK3-NEXT:    [[TMP59:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV5:%.*]] = bitcast i32* [[AA_CASTED4]] to i16*
// CHECK3-NEXT:    store i16 [[TMP59]], i16* [[CONV5]], align 2
// CHECK3-NEXT:    [[TMP60:%.*]] = load i32, i32* [[AA_CASTED4]], align 4
// CHECK3-NEXT:    [[TMP61:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP61]], 10
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP63:%.*]] = bitcast i8** [[TMP62]] to i32*
// CHECK3-NEXT:    store i32 [[TMP58]], i32* [[TMP63]], align 4
// CHECK3-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i32*
// CHECK3-NEXT:    store i32 [[TMP58]], i32* [[TMP65]], align 4
// CHECK3-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS8]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP66]], align 4
// CHECK3-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP68:%.*]] = bitcast i8** [[TMP67]] to i32*
// CHECK3-NEXT:    store i32 [[TMP60]], i32* [[TMP68]], align 4
// CHECK3-NEXT:    [[TMP69:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP70:%.*]] = bitcast i8** [[TMP69]] to i32*
// CHECK3-NEXT:    store i32 [[TMP60]], i32* [[TMP70]], align 4
// CHECK3-NEXT:    [[TMP71:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS8]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP71]], align 4
// CHECK3-NEXT:    [[TMP72:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP74:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146.region_id, i32 2, i8** [[TMP72]], i8** [[TMP73]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK3-NEXT:    [[TMP75:%.*]] = icmp ne i32 [[TMP74]], 0
// CHECK3-NEXT:    br i1 [[TMP75]], label [[OMP_OFFLOAD_FAILED9:%.*]], label [[OMP_OFFLOAD_CONT10:%.*]]
// CHECK3:       omp_offload.failed9:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146(i32 [[TMP58]], i32 [[TMP60]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT10]]
// CHECK3:       omp_offload.cont10:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146(i32 [[TMP58]], i32 [[TMP60]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP76:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP76]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP77:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP77]], i32* [[A_CASTED11]], align 4
// CHECK3-NEXT:    [[TMP78:%.*]] = load i32, i32* [[A_CASTED11]], align 4
// CHECK3-NEXT:    [[TMP79:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    store i32 [[TMP79]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    [[TMP80:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    [[TMP81:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP12:%.*]] = icmp sgt i32 [[TMP81]], 20
// CHECK3-NEXT:    br i1 [[CMP12]], label [[OMP_IF_THEN13:%.*]], label [[OMP_IF_ELSE19:%.*]]
// CHECK3:       omp_if.then13:
// CHECK3-NEXT:    [[TMP82:%.*]] = mul nuw i32 [[TMP1]], 4
// CHECK3-NEXT:    [[TMP83:%.*]] = sext i32 [[TMP82]] to i64
// CHECK3-NEXT:    [[TMP84:%.*]] = mul nuw i32 5, [[TMP3]]
// CHECK3-NEXT:    [[TMP85:%.*]] = mul nuw i32 [[TMP84]], 8
// CHECK3-NEXT:    [[TMP86:%.*]] = sext i32 [[TMP85]] to i64
// CHECK3-NEXT:    [[TMP87:%.*]] = bitcast [10 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP87]], i8* align 4 bitcast ([10 x i64]* @.offload_sizes.8 to i8*), i32 80, i1 false)
// CHECK3-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP89:%.*]] = bitcast i8** [[TMP88]] to i32*
// CHECK3-NEXT:    store i32 [[TMP78]], i32* [[TMP89]], align 4
// CHECK3-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to i32*
// CHECK3-NEXT:    store i32 [[TMP78]], i32* [[TMP91]], align 4
// CHECK3-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP92]], align 4
// CHECK3-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP94:%.*]] = bitcast i8** [[TMP93]] to [10 x float]**
// CHECK3-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP94]], align 4
// CHECK3-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP96:%.*]] = bitcast i8** [[TMP95]] to [10 x float]**
// CHECK3-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP96]], align 4
// CHECK3-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP97]], align 4
// CHECK3-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP99:%.*]] = bitcast i8** [[TMP98]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP99]], align 4
// CHECK3-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP101:%.*]] = bitcast i8** [[TMP100]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP101]], align 4
// CHECK3-NEXT:    [[TMP102:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP102]], align 4
// CHECK3-NEXT:    [[TMP103:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP104:%.*]] = bitcast i8** [[TMP103]] to float**
// CHECK3-NEXT:    store float* [[VLA]], float** [[TMP104]], align 4
// CHECK3-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP106:%.*]] = bitcast i8** [[TMP105]] to float**
// CHECK3-NEXT:    store float* [[VLA]], float** [[TMP106]], align 4
// CHECK3-NEXT:    [[TMP107:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK3-NEXT:    store i64 [[TMP83]], i64* [[TMP107]], align 4
// CHECK3-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP108]], align 4
// CHECK3-NEXT:    [[TMP109:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP110:%.*]] = bitcast i8** [[TMP109]] to [5 x [10 x double]]**
// CHECK3-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP110]], align 4
// CHECK3-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to [5 x [10 x double]]**
// CHECK3-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP112]], align 4
// CHECK3-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 4
// CHECK3-NEXT:    store i8* null, i8** [[TMP113]], align 4
// CHECK3-NEXT:    [[TMP114:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 5
// CHECK3-NEXT:    [[TMP115:%.*]] = bitcast i8** [[TMP114]] to i32*
// CHECK3-NEXT:    store i32 5, i32* [[TMP115]], align 4
// CHECK3-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 5
// CHECK3-NEXT:    [[TMP117:%.*]] = bitcast i8** [[TMP116]] to i32*
// CHECK3-NEXT:    store i32 5, i32* [[TMP117]], align 4
// CHECK3-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 5
// CHECK3-NEXT:    store i8* null, i8** [[TMP118]], align 4
// CHECK3-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP120:%.*]] = bitcast i8** [[TMP119]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP120]], align 4
// CHECK3-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP122:%.*]] = bitcast i8** [[TMP121]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP122]], align 4
// CHECK3-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 6
// CHECK3-NEXT:    store i8* null, i8** [[TMP123]], align 4
// CHECK3-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 7
// CHECK3-NEXT:    [[TMP125:%.*]] = bitcast i8** [[TMP124]] to double**
// CHECK3-NEXT:    store double* [[VLA1]], double** [[TMP125]], align 4
// CHECK3-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 7
// CHECK3-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to double**
// CHECK3-NEXT:    store double* [[VLA1]], double** [[TMP127]], align 4
// CHECK3-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK3-NEXT:    store i64 [[TMP86]], i64* [[TMP128]], align 4
// CHECK3-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 7
// CHECK3-NEXT:    store i8* null, i8** [[TMP129]], align 4
// CHECK3-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP131:%.*]] = bitcast i8** [[TMP130]] to %struct.TT**
// CHECK3-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP131]], align 4
// CHECK3-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to %struct.TT**
// CHECK3-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP133]], align 4
// CHECK3-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 8
// CHECK3-NEXT:    store i8* null, i8** [[TMP134]], align 4
// CHECK3-NEXT:    [[TMP135:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 9
// CHECK3-NEXT:    [[TMP136:%.*]] = bitcast i8** [[TMP135]] to i32*
// CHECK3-NEXT:    store i32 [[TMP80]], i32* [[TMP136]], align 4
// CHECK3-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 9
// CHECK3-NEXT:    [[TMP138:%.*]] = bitcast i8** [[TMP137]] to i32*
// CHECK3-NEXT:    store i32 [[TMP80]], i32* [[TMP138]], align 4
// CHECK3-NEXT:    [[TMP139:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 9
// CHECK3-NEXT:    store i8* null, i8** [[TMP139]], align 4
// CHECK3-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP143:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170.region_id, i32 10, i8** [[TMP140]], i8** [[TMP141]], i64* [[TMP142]], i64* getelementptr inbounds ([10 x i64], [10 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK3-NEXT:    [[TMP144:%.*]] = icmp ne i32 [[TMP143]], 0
// CHECK3-NEXT:    br i1 [[TMP144]], label [[OMP_OFFLOAD_FAILED17:%.*]], label [[OMP_OFFLOAD_CONT18:%.*]]
// CHECK3:       omp_offload.failed17:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170(i32 [[TMP78]], [10 x float]* [[B]], i32 [[TMP1]], float* [[VLA]], [5 x [10 x double]]* [[C]], i32 5, i32 [[TMP3]], double* [[VLA1]], %struct.TT* [[D]], i32 [[TMP80]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT18]]
// CHECK3:       omp_offload.cont18:
// CHECK3-NEXT:    br label [[OMP_IF_END20:%.*]]
// CHECK3:       omp_if.else19:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170(i32 [[TMP78]], [10 x float]* [[B]], i32 [[TMP1]], float* [[VLA]], [5 x [10 x double]]* [[C]], i32 5, i32 [[TMP3]], double* [[VLA1]], %struct.TT* [[D]], i32 [[TMP80]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END20]]
// CHECK3:       omp_if.end20:
// CHECK3-NEXT:    [[TMP145:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP146:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK3-NEXT:    call void @llvm.stackrestore(i8* [[TMP146]])
// CHECK3-NEXT:    ret i32 [[TMP145]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103
// CHECK3-SAME: () #[[ATTR2:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 0, void (i32*, i32*, ...)* bitcast (void (i32*, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*))
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 5, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 5
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 5, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 5
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 3, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_cancel(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK3-NEXT:    [[TMP9:%.*]] = icmp ne i32 [[TMP8]], 0
// CHECK3-NEXT:    br i1 [[TMP9]], label [[DOTCANCEL_EXIT:%.*]], label [[DOTCANCEL_CONTINUE:%.*]]
// CHECK3:       .cancel.exit:
// CHECK3-NEXT:    br label [[CANCEL_EXIT:%.*]]
// CHECK3:       .cancel.continue:
// CHECK3-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_cancellationpoint(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK3-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK3-NEXT:    br i1 [[TMP11]], label [[DOTCANCEL_EXIT2:%.*]], label [[DOTCANCEL_CONTINUE3:%.*]]
// CHECK3:       .cancel.exit2:
// CHECK3-NEXT:    br label [[CANCEL_EXIT]]
// CHECK3:       .cancel.continue3:
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK3-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    br label [[CANCEL_CONT:%.*]]
// CHECK3:       cancel.cont:
// CHECK3-NEXT:    ret void
// CHECK3:       cancel.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    br label [[CANCEL_CONT]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l110
// CHECK3-SAME: (i32 noundef [[A:%.*]], i64* noundef nonnull align 4 dereferenceable(8) [[K:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[K_ADDR:%.*]] = alloca i64*, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i64* [[K]], i64** [[K_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i64*, i64** [[K_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i64*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP2]], i64* [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i64* noundef nonnull align 4 dereferenceable(8) [[K:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[K_ADDR:%.*]] = alloca i64*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[K1:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i64* [[K]], i64** [[K_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i64*, i64** [[K_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TMP0]], align 8
// CHECK3-NEXT:    store i64 [[TMP1]], i64* [[DOTLINEAR_START]], align 8
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 8, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP3]])
// CHECK3-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP3]], i32 35, i32 0, i32 8, i32 1, i32 1)
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK3:       omp.dispatch.cond:
// CHECK3-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP3]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK3-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK3-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK3:       omp.dispatch.body:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 10, [[MUL]]
// CHECK3-NEXT:    store i32 [[SUB]], i32* [[I]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTLINEAR_START]], align 8, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[MUL2:%.*]] = mul nsw i32 [[TMP10]], 3
// CHECK3-NEXT:    [[CONV:%.*]] = sext i32 [[MUL2]] to i64
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP9]], [[CONV]]
// CHECK3-NEXT:    store i64 [[ADD]], i64* [[K1]], align 8, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK3-NEXT:    store i32 [[ADD3]], i32* [[A_ADDR]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK3-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK3:       omp.dispatch.inc:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK3:       omp.dispatch.end:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK3-NEXT:    br i1 [[TMP14]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK3:       .omp.linear.pu:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i64, i64* [[K1]], align 8
// CHECK3-NEXT:    store i64 [[TMP15]], i64* [[TMP0]], align 8
// CHECK3-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK3:       .omp.linear.pu.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138
// CHECK3-SAME: (i32 noundef [[AA:%.*]], i32 noundef [[LIN:%.*]], i32 noundef [[A:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LIN_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LIN_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[LIN]], i32* [[LIN_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[LIN_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[LIN_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[LIN_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[LIN:%.*]], i32 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LIN_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_START1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTLINEAR_STEP:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[LIN2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[LIN]], i32* [[LIN_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[LIN_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START1]], align 4
// CHECK3-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv()
// CHECK3-NEXT:    store i64 [[CALL]], i64* [[DOTLINEAR_STEP]], align 8
// CHECK3-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK3-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK3-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3]], i32 [[TMP3]])
// CHECK3-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK3-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP4]], 3
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK3-NEXT:    store i64 [[TMP6]], i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp ule i64 [[TMP7]], [[TMP8]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[MUL:%.*]] = mul i64 [[TMP9]], 400
// CHECK3-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK3-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK3-NEXT:    [[CONV5:%.*]] = sext i32 [[TMP10]] to i64
// CHECK3-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK3-NEXT:    [[MUL6:%.*]] = mul i64 [[TMP11]], [[TMP12]]
// CHECK3-NEXT:    [[ADD:%.*]] = add i64 [[CONV5]], [[MUL6]]
// CHECK3-NEXT:    [[CONV7:%.*]] = trunc i64 [[ADD]] to i32
// CHECK3-NEXT:    store i32 [[CONV7]], i32* [[LIN2]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTLINEAR_START1]], align 4
// CHECK3-NEXT:    [[CONV8:%.*]] = sext i32 [[TMP13]] to i64
// CHECK3-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK3-NEXT:    [[MUL9:%.*]] = mul i64 [[TMP14]], [[TMP15]]
// CHECK3-NEXT:    [[ADD10:%.*]] = add i64 [[CONV8]], [[MUL9]]
// CHECK3-NEXT:    [[CONV11:%.*]] = trunc i64 [[ADD10]] to i32
// CHECK3-NEXT:    store i32 [[CONV11]], i32* [[A3]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP16]] to i32
// CHECK3-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK3-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i16
// CHECK3-NEXT:    store i16 [[CONV14]], i16* [[CONV]], align 2
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[ADD15:%.*]] = add i64 [[TMP17]], 1
// CHECK3-NEXT:    store i64 [[ADD15]], i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = icmp ne i32 [[TMP18]], 0
// CHECK3-NEXT:    br i1 [[TMP19]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK3:       .omp.linear.pu:
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[LIN2]], align 4
// CHECK3-NEXT:    store i32 [[TMP20]], i32* [[LIN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A3]], align 4
// CHECK3-NEXT:    store i32 [[TMP21]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK3:       .omp.linear.pu.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK3-SAME: (%struct..kmp_privates.t* noalias noundef [[TMP0:%.*]], i16** noalias noundef [[TMP1:%.*]], [3 x i8*]** noalias noundef [[TMP2:%.*]], [3 x i8*]** noalias noundef [[TMP3:%.*]], [3 x i64]** noalias noundef [[TMP4:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca %struct..kmp_privates.t*, align 4
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca i16**, align 4
// CHECK3-NEXT:    [[DOTADDR2:%.*]] = alloca [3 x i8*]**, align 4
// CHECK3-NEXT:    [[DOTADDR3:%.*]] = alloca [3 x i8*]**, align 4
// CHECK3-NEXT:    [[DOTADDR4:%.*]] = alloca [3 x i64]**, align 4
// CHECK3-NEXT:    store %struct..kmp_privates.t* [[TMP0]], %struct..kmp_privates.t** [[DOTADDR]], align 4
// CHECK3-NEXT:    store i16** [[TMP1]], i16*** [[DOTADDR1]], align 4
// CHECK3-NEXT:    store [3 x i8*]** [[TMP2]], [3 x i8*]*** [[DOTADDR2]], align 4
// CHECK3-NEXT:    store [3 x i8*]** [[TMP3]], [3 x i8*]*** [[DOTADDR3]], align 4
// CHECK3-NEXT:    store [3 x i64]** [[TMP4]], [3 x i64]*** [[DOTADDR4]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load %struct..kmp_privates.t*, %struct..kmp_privates.t** [[DOTADDR]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load [3 x i64]**, [3 x i64]*** [[DOTADDR4]], align 4
// CHECK3-NEXT:    store [3 x i64]* [[TMP6]], [3 x i64]** [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP9:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR2]], align 4
// CHECK3-NEXT:    store [3 x i8*]* [[TMP8]], [3 x i8*]** [[TMP9]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP11:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR3]], align 4
// CHECK3-NEXT:    store [3 x i8*]* [[TMP10]], [3 x i8*]** [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP13:%.*]] = load i16**, i16*** [[DOTADDR1]], align 4
// CHECK3-NEXT:    store i16* [[TMP12]], i16** [[TMP13]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK3-SAME: (i32 noundef [[TMP0:%.*]], %struct.kmp_task_t_with_privates* noalias noundef [[TMP1:%.*]]) #[[ATTR7:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca void (i8*, ...)*, align 4
// CHECK3-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca %struct.anon*, align 4
// CHECK3-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca i16*, align 4
// CHECK3-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca [3 x i8*]*, align 4
// CHECK3-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca [3 x i8*]*, align 4
// CHECK3-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca [3 x i64]*, align 4
// CHECK3-NEXT:    [[AA_CASTED_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LIN_CASTED_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca %struct.kmp_task_t_with_privates*, align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[DOTADDR]], align 4
// CHECK3-NEXT:    store %struct.kmp_task_t_with_privates* [[TMP1]], %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load %struct.kmp_task_t_with_privates*, %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load i8*, i8** [[TMP6]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = bitcast i8* [[TMP7]] to %struct.anon*
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast %struct..kmp_privates.t* [[TMP9]] to i8*
// CHECK3-NEXT:    [[TMP11:%.*]] = bitcast %struct.kmp_task_t_with_privates* [[TMP3]] to i8*
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META16:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META19:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META21:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META23:![0-9]+]])
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    store i32* [[TMP5]], i32** [[DOTPART_ID__ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    store i8* [[TMP10]], i8** [[DOTPRIVATES__ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    store void (i8*, ...)* bitcast (void (%struct..kmp_privates.t*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)* @.omp_task_privates_map. to void (i8*, ...)*), void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    store i8* [[TMP11]], i8** [[DOTTASK_T__ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    store %struct.anon* [[TMP8]], %struct.anon** [[__CONTEXT_ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP12:%.*]] = load %struct.anon*, %struct.anon** [[__CONTEXT_ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP13:%.*]] = load void (i8*, ...)*, void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[DOTPRIVATES__ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast void (i8*, ...)* [[TMP13]] to void (i8*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)*
// CHECK3-NEXT:    call void [[TMP15]](i8* [[TMP14]], i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK3-NEXT:    [[TMP16:%.*]] = load i16*, i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP17:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP18:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP19:%.*]] = load [3 x i64]*, [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP17]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP18]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[TMP19]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], %struct.anon* [[TMP12]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[TMP12]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP25:%.*]] = call i32 @__tgt_target_teams_nowait_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* [[TMP22]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0, i32 0, i8* null, i32 0, i8* null) #[[ATTR4]]
// CHECK3-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK3-NEXT:    br i1 [[TMP26]], label [[OMP_OFFLOAD_FAILED_I:%.*]], label [[DOTOMP_OUTLINED__3_EXIT:%.*]]
// CHECK3:       omp_offload.failed.i:
// CHECK3-NEXT:    [[TMP27:%.*]] = load i16, i16* [[TMP16]], align 2
// CHECK3-NEXT:    [[CONV_I:%.*]] = bitcast i32* [[AA_CASTED_I]] to i16*
// CHECK3-NEXT:    store i16 [[TMP27]], i16* [[CONV_I]], align 2, !noalias !25
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32, i32* [[AA_CASTED_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK3-NEXT:    store i32 [[TMP29]], i32* [[LIN_CASTED_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[LIN_CASTED_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK3-NEXT:    store i32 [[TMP31]], i32* [[A_CASTED_I]], align 4, !noalias !25
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32, i32* [[A_CASTED_I]], align 4, !noalias !25
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138(i32 [[TMP28]], i32 [[TMP30]], i32 [[TMP32]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[DOTOMP_OUTLINED__3_EXIT]]
// CHECK3:       .omp_outlined..3.exit:
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146
// CHECK3-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[IT:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 3, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 3
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 6, [[MUL]]
// CHECK3-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV2]], i16* [[IT]], align 2
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK3-NEXT:    store i32 [[ADD3]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP9]] to i32
// CHECK3-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK3-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK3-NEXT:    store i16 [[CONV6]], i16* [[CONV]], align 2
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK3-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170
// CHECK3-SAME: (i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK3-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK3-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK3-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK3-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK3-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP10]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 10, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, [10 x float]*, i32, float*, [5 x [10 x double]]*, i32, i32, double*, %struct.TT*, i32)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i32 [[TMP9]], [10 x float]* [[TMP0]], i32 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i32 [[TMP4]], i32 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]], i32 [[TMP11]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK3-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK3-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[IT:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK3-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK3-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK3-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 25, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP8]])
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK3:       omp.dispatch.cond:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 25
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 25, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK3:       omp.dispatch.body:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// CHECK3-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 122, [[MUL]]
// CHECK3-NEXT:    [[CONV:%.*]] = trunc i32 [[SUB]] to i8
// CHECK3-NEXT:    store i8 [[CONV]], i8* [[IT]], align 1
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[CONV7:%.*]] = fpext float [[TMP20]] to double
// CHECK3-NEXT:    [[ADD8:%.*]] = fadd double [[CONV7]], 1.000000e+00
// CHECK3-NEXT:    [[CONV9:%.*]] = fptrunc double [[ADD8]] to float
// CHECK3-NEXT:    store float [[CONV9]], float* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP2]], i32 3
// CHECK3-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX10]], align 4
// CHECK3-NEXT:    [[CONV11:%.*]] = fpext float [[TMP21]] to double
// CHECK3-NEXT:    [[ADD12:%.*]] = fadd double [[CONV11]], 1.000000e+00
// CHECK3-NEXT:    [[CONV13:%.*]] = fptrunc double [[ADD12]] to float
// CHECK3-NEXT:    store float [[CONV13]], float* [[ARRAYIDX10]], align 4
// CHECK3-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i32 0, i32 1
// CHECK3-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX14]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX15]], align 8
// CHECK3-NEXT:    [[ADD16:%.*]] = fadd double [[TMP22]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD16]], double* [[ARRAYIDX15]], align 8
// CHECK3-NEXT:    [[TMP23:%.*]] = mul nsw i32 1, [[TMP5]]
// CHECK3-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[TMP6]], i32 [[TMP23]]
// CHECK3-NEXT:    [[ARRAYIDX18:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX17]], i32 3
// CHECK3-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX18]], align 8
// CHECK3-NEXT:    [[ADD19:%.*]] = fadd double [[TMP24]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD19]], double* [[ARRAYIDX18]], align 8
// CHECK3-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP25:%.*]] = load i64, i64* [[X]], align 4
// CHECK3-NEXT:    [[ADD20:%.*]] = add nsw i64 [[TMP25]], 1
// CHECK3-NEXT:    store i64 [[ADD20]], i64* [[X]], align 4
// CHECK3-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP26:%.*]] = load i8, i8* [[Y]], align 4
// CHECK3-NEXT:    [[CONV21:%.*]] = sext i8 [[TMP26]] to i32
// CHECK3-NEXT:    [[ADD22:%.*]] = add nsw i32 [[CONV21]], 1
// CHECK3-NEXT:    [[CONV23:%.*]] = trunc i32 [[ADD22]] to i8
// CHECK3-NEXT:    store i8 [[CONV23]], i8* [[Y]], align 4
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP27]], 1
// CHECK3-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK3:       omp.dispatch.inc:
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD25:%.*]] = add nsw i32 [[TMP28]], [[TMP29]]
// CHECK3-NEXT:    store i32 [[ADD25]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP30]], [[TMP31]]
// CHECK3-NEXT:    store i32 [[ADD26]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK3:       omp.dispatch.end:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z3bari
// CHECK3-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP0]])
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CALL1:%.*]] = call noundef i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 4 dereferenceable(8) [[S]], i32 noundef [[TMP2]])
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK3-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CALL3:%.*]] = call noundef i32 @_ZL7fstatici(i32 noundef [[TMP4]])
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK3-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CALL5:%.*]] = call noundef i32 @_Z9ftemplateIiET_i(i32 noundef [[TMP6]])
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK3-SAME: (%struct.S1* noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [5 x i64], align 4
// CHECK3-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK3-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK3-NEXT:    [[VLA:%.*]] = alloca i16, i32 [[TMP3]], align 2
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 60
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK3-NEXT:    [[TMP8:%.*]] = mul nuw i32 [[TMP7]], 2
// CHECK3-NEXT:    [[TMP9:%.*]] = sext i32 [[TMP8]] to i64
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast [5 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP10]], i8* align 4 bitcast ([5 x i64]* @.offload_sizes.11 to i8*), i32 40, i1 false)
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to %struct.S1**
// CHECK3-NEXT:    store %struct.S1* [[THIS1]], %struct.S1** [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to double**
// CHECK3-NEXT:    store double* [[A]], double** [[TMP14]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32*
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32*
// CHECK3-NEXT:    store i32 2, i32* [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32*
// CHECK3-NEXT:    store i32 2, i32* [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP27]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i16**
// CHECK3-NEXT:    store i16* [[VLA]], i16** [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i16**
// CHECK3-NEXT:    store i16* [[VLA]], i16** [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK3-NEXT:    store i64 [[TMP9]], i64* [[TMP35]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK3-NEXT:    store i8* null, i8** [[TMP36]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP40:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242.region_id, i32 5, i8** [[TMP37]], i8** [[TMP38]], i64* [[TMP39]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK3-NEXT:    [[TMP41:%.*]] = icmp ne i32 [[TMP40]], 0
// CHECK3-NEXT:    br i1 [[TMP41]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242(%struct.S1* [[THIS1]], i32 [[TMP5]], i32 2, i32 [[TMP1]], i16* [[VLA]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242(%struct.S1* [[THIS1]], i32 [[TMP5]], i32 2, i32 [[TMP1]], i16* [[VLA]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP42:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP42]]
// CHECK3-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK3-NEXT:    [[TMP43:%.*]] = load i16, i16* [[ARRAYIDX2]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP43]] to i32
// CHECK3-NEXT:    [[TMP44:%.*]] = load i32, i32* [[B]], align 4
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV]], [[TMP44]]
// CHECK3-NEXT:    [[TMP45:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK3-NEXT:    call void @llvm.stackrestore(i8* [[TMP45]])
// CHECK3-NEXT:    ret i32 [[ADD3]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK3-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK3-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK3-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP2]], i16* [[CONV]], align 2
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i8, i8* [[AAA]], align 1
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK3-NEXT:    store i8 [[TMP4]], i8* [[CONV1]], align 1
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 50
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP16]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32*
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i32*
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP21]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to [10 x i32]**
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to [10 x i32]**
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP26]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP29:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224.region_id, i32 4, i8** [[TMP27]], i8** [[TMP28]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.14, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.15, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK3-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK3-NEXT:    br i1 [[TMP30]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224(i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224(i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    ret i32 [[TMP31]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK3-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK3-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP2]], i16* [[CONV]], align 2
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 40
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP6]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP9]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [10 x i32]**
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP16]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [10 x i32]**
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.17, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.18, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK3-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK3-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242
// CHECK3-SAME: (%struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK3-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i32, i32, i32, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i32 [[TMP5]], i32 [[TMP1]], i32 [[TMP2]], i16* [[TMP3]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK3-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK3-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK3-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP6]], 3
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK3-NEXT:    store i64 [[TMP8]], i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[CMP3:%.*]] = icmp ule i64 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[MUL:%.*]] = mul i64 [[TMP11]], 400
// CHECK3-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK3-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK3-NEXT:    [[ADD:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK3-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK3-NEXT:    store double [[ADD]], double* [[A]], align 4
// CHECK3-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP13:%.*]] = load double, double* [[A4]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK3-NEXT:    store double [[INC]], double* [[A4]], align 4
// CHECK3-NEXT:    [[CONV5:%.*]] = fptosi double [[INC]] to i16
// CHECK3-NEXT:    [[TMP14:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP14]]
// CHECK3-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK3-NEXT:    store i16 [[CONV5]], i16* [[ARRAYIDX6]], align 2
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[ADD7:%.*]] = add i64 [[TMP15]], 1
// CHECK3-NEXT:    store i64 [[ADD7]], i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224
// CHECK3-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV2:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP3]], i16* [[CONV2]], align 2
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i8, i8* [[CONV1]], align 1
// CHECK3-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK3-NEXT:    store i8 [[TMP5]], i8* [[CONV3]], align 1
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32, [10 x i32]*)* @.omp_outlined..13 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], [10 x i32]* [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..13
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207
// CHECK3-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP3]], i16* [[CONV1]], align 2
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..16 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..16
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK3-NEXT:    store i64 6, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_8(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK3-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[TMP3]], 6
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i64 [ 6, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK3-NEXT:    store i64 [[TMP5]], i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i64 [[TMP6]], [[TMP7]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i64 [[TMP8]], 3
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i64 -10, [[MUL]]
// CHECK3-NEXT:    store i64 [[ADD]], i64* [[I]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK3-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP10]] to i32
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK3-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK3-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i64 [[TMP12]], 1
// CHECK3-NEXT:    store i64 [[ADD7]], i64* [[DOTOMP_IV]], align 8
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR6]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103
// CHECK9-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 0, void (i32*, i32*, ...)* bitcast (void (i32*, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*))
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 5, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 5
// CHECK9-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ 5, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 5
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 3, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_cancel(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK9-NEXT:    [[TMP9:%.*]] = icmp ne i32 [[TMP8]], 0
// CHECK9-NEXT:    br i1 [[TMP9]], label [[DOTCANCEL_EXIT:%.*]], label [[DOTCANCEL_CONTINUE:%.*]]
// CHECK9:       .cancel.exit:
// CHECK9-NEXT:    br label [[CANCEL_EXIT:%.*]]
// CHECK9:       .cancel.continue:
// CHECK9-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_cancellationpoint(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK9-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK9-NEXT:    br i1 [[TMP11]], label [[DOTCANCEL_EXIT2:%.*]], label [[DOTCANCEL_CONTINUE3:%.*]]
// CHECK9:       .cancel.exit2:
// CHECK9-NEXT:    br label [[CANCEL_EXIT]]
// CHECK9:       .cancel.continue3:
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK9-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK9-NEXT:    br label [[CANCEL_CONT:%.*]]
// CHECK9:       cancel.cont:
// CHECK9-NEXT:    ret void
// CHECK9:       cancel.exit:
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK9-NEXT:    br label [[CANCEL_CONT]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138
// CHECK9-SAME: (i64 noundef [[AA:%.*]], i64 noundef [[LIN:%.*]], i64 noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[LIN_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[LIN_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[LIN]], i64* [[LIN_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[LIN_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK9-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK9-NEXT:    store i16 [[TMP0]], i16* [[CONV3]], align 2
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK9-NEXT:    [[CONV4:%.*]] = bitcast i64* [[LIN_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP2]], i32* [[CONV4]], align 4
// CHECK9-NEXT:    [[TMP3:%.*]] = load i64, i64* [[LIN_CASTED]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV2]], align 4
// CHECK9-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[CONV5]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[LIN:%.*]], i64 noundef [[A:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[LIN_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTLINEAR_START3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTLINEAR_STEP:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[LIN4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[A5:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[LIN]], i64* [[LIN_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[LIN_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[DOTLINEAR_START]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV2]], align 4
// CHECK9-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START3]], align 4
// CHECK9-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv() #[[ATTR5:[0-9]+]]
// CHECK9-NEXT:    store i64 [[CALL]], i64* [[DOTLINEAR_STEP]], align 8
// CHECK9-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK9-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK9-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP3]])
// CHECK9-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK9-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP4]], 3
// CHECK9-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK9-NEXT:    store i64 [[TMP6]], i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp ule i64 [[TMP7]], [[TMP8]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[MUL:%.*]] = mul i64 [[TMP9]], 400
// CHECK9-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK9-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK9-NEXT:    [[CONV7:%.*]] = sext i32 [[TMP10]] to i64
// CHECK9-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK9-NEXT:    [[MUL8:%.*]] = mul i64 [[TMP11]], [[TMP12]]
// CHECK9-NEXT:    [[ADD:%.*]] = add i64 [[CONV7]], [[MUL8]]
// CHECK9-NEXT:    [[CONV9:%.*]] = trunc i64 [[ADD]] to i32
// CHECK9-NEXT:    store i32 [[CONV9]], i32* [[LIN4]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTLINEAR_START3]], align 4
// CHECK9-NEXT:    [[CONV10:%.*]] = sext i32 [[TMP13]] to i64
// CHECK9-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK9-NEXT:    [[MUL11:%.*]] = mul i64 [[TMP14]], [[TMP15]]
// CHECK9-NEXT:    [[ADD12:%.*]] = add i64 [[CONV10]], [[MUL11]]
// CHECK9-NEXT:    [[CONV13:%.*]] = trunc i64 [[ADD12]] to i32
// CHECK9-NEXT:    store i32 [[CONV13]], i32* [[A5]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK9-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP16]] to i32
// CHECK9-NEXT:    [[ADD15:%.*]] = add nsw i32 [[CONV14]], 1
// CHECK9-NEXT:    [[CONV16:%.*]] = trunc i32 [[ADD15]] to i16
// CHECK9-NEXT:    store i16 [[CONV16]], i16* [[CONV]], align 2
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[ADD17:%.*]] = add i64 [[TMP17]], 1
// CHECK9-NEXT:    store i64 [[ADD17]], i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP19:%.*]] = icmp ne i32 [[TMP18]], 0
// CHECK9-NEXT:    br i1 [[TMP19]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK9:       .omp.linear.pu:
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[LIN4]], align 4
// CHECK9-NEXT:    store i32 [[TMP20]], i32* [[CONV1]], align 4
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A5]], align 4
// CHECK9-NEXT:    store i32 [[TMP21]], i32* [[CONV2]], align 4
// CHECK9-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK9:       .omp.linear.pu.done:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z7get_valv
// CHECK9-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    ret i64 0
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146
// CHECK9-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[CONV2]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK9-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK9-NEXT:    store i16 [[TMP2]], i16* [[CONV3]], align 2
// CHECK9-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i16, align 2
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[IT:%.*]] = alloca i16, align 2
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 3, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 3
// CHECK9-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 6, [[MUL]]
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD]] to i16
// CHECK9-NEXT:    store i16 [[CONV3]], i16* [[IT]], align 2
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK9-NEXT:    store i32 [[ADD4]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK9-NEXT:    [[CONV5:%.*]] = sext i16 [[TMP9]] to i32
// CHECK9-NEXT:    [[ADD6:%.*]] = add nsw i32 [[CONV5]], 1
// CHECK9-NEXT:    [[CONV7:%.*]] = trunc i32 [[ADD6]] to i16
// CHECK9-NEXT:    store i16 [[CONV7]], i16* [[CONV1]], align 2
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK9-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170
// CHECK9-SAME: (i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK9-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK9-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK9-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK9-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK9-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK9-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK9-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK9-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[CONV6:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP8]], i32* [[CONV6]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV5]], align 4
// CHECK9-NEXT:    [[CONV7:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP10]], i32* [[CONV7]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 10, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, [10 x float]*, i64, float*, [5 x [10 x double]]*, i64, i64, double*, %struct.TT*, i64)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP9]], [10 x float]* [[TMP0]], i64 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i64 [[TMP4]], i64 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]], i64 [[TMP11]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK9-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[IT:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK9-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK9-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK9-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK9-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK9-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK9-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK9-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 25, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV5]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP8]])
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK9:       omp.dispatch.cond:
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 25
// CHECK9-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ 25, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK9:       omp.dispatch.body:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// CHECK9-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 122, [[MUL]]
// CHECK9-NEXT:    [[CONV8:%.*]] = trunc i32 [[SUB]] to i8
// CHECK9-NEXT:    store i8 [[CONV8]], i8* [[IT]], align 1
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 2
// CHECK9-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[CONV9:%.*]] = fpext float [[TMP20]] to double
// CHECK9-NEXT:    [[ADD10:%.*]] = fadd double [[CONV9]], 1.000000e+00
// CHECK9-NEXT:    [[CONV11:%.*]] = fptrunc double [[ADD10]] to float
// CHECK9-NEXT:    store float [[CONV11]], float* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds float, float* [[TMP2]], i64 3
// CHECK9-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX12]], align 4
// CHECK9-NEXT:    [[CONV13:%.*]] = fpext float [[TMP21]] to double
// CHECK9-NEXT:    [[ADD14:%.*]] = fadd double [[CONV13]], 1.000000e+00
// CHECK9-NEXT:    [[CONV15:%.*]] = fptrunc double [[ADD14]] to float
// CHECK9-NEXT:    store float [[CONV15]], float* [[ARRAYIDX12]], align 4
// CHECK9-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i64 0, i64 1
// CHECK9-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX16]], i64 0, i64 2
// CHECK9-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX17]], align 8
// CHECK9-NEXT:    [[ADD18:%.*]] = fadd double [[TMP22]], 1.000000e+00
// CHECK9-NEXT:    store double [[ADD18]], double* [[ARRAYIDX17]], align 8
// CHECK9-NEXT:    [[TMP23:%.*]] = mul nsw i64 1, [[TMP5]]
// CHECK9-NEXT:    [[ARRAYIDX19:%.*]] = getelementptr inbounds double, double* [[TMP6]], i64 [[TMP23]]
// CHECK9-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX19]], i64 3
// CHECK9-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX20]], align 8
// CHECK9-NEXT:    [[ADD21:%.*]] = fadd double [[TMP24]], 1.000000e+00
// CHECK9-NEXT:    store double [[ADD21]], double* [[ARRAYIDX20]], align 8
// CHECK9-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP25:%.*]] = load i64, i64* [[X]], align 8
// CHECK9-NEXT:    [[ADD22:%.*]] = add nsw i64 [[TMP25]], 1
// CHECK9-NEXT:    store i64 [[ADD22]], i64* [[X]], align 8
// CHECK9-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP26:%.*]] = load i8, i8* [[Y]], align 8
// CHECK9-NEXT:    [[CONV23:%.*]] = sext i8 [[TMP26]] to i32
// CHECK9-NEXT:    [[ADD24:%.*]] = add nsw i32 [[CONV23]], 1
// CHECK9-NEXT:    [[CONV25:%.*]] = trunc i32 [[ADD24]] to i8
// CHECK9-NEXT:    store i8 [[CONV25]], i8* [[Y]], align 8
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP27]], 1
// CHECK9-NEXT:    store i32 [[ADD26]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK9:       omp.dispatch.inc:
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD27:%.*]] = add nsw i32 [[TMP28]], [[TMP29]]
// CHECK9-NEXT:    store i32 [[ADD27]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD28:%.*]] = add nsw i32 [[TMP30]], [[TMP31]]
// CHECK9-NEXT:    store i32 [[ADD28]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK9:       omp.dispatch.end:
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224
// CHECK9-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK9-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK9-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK9-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK9-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[CONV3:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP1]], i32* [[CONV3]], align 4
// CHECK9-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK9-NEXT:    [[CONV4:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK9-NEXT:    store i16 [[TMP3]], i16* [[CONV4]], align 2
// CHECK9-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i8, i8* [[CONV2]], align 1
// CHECK9-NEXT:    [[CONV5:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK9-NEXT:    store i8 [[TMP5]], i8* [[CONV5]], align 1
// CHECK9-NEXT:    [[TMP6:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, [10 x i32]*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], [10 x i32]* [[TMP0]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK9-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK9-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK9-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242
// CHECK9-SAME: (%struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK9-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK9-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[CONV3:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[CONV3]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i64, i64, i64, i16*)* @.omp_outlined..5 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i64 [[TMP5]], i64 [[TMP1]], i64 [[TMP2]], i16* [[TMP3]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..5
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK9-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK9-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK9-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK9-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP6]], 3
// CHECK9-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK9-NEXT:    store i64 [[TMP8]], i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[CMP3:%.*]] = icmp ule i64 [[TMP9]], [[TMP10]]
// CHECK9-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[MUL:%.*]] = mul i64 [[TMP11]], 400
// CHECK9-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK9-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[CONV4:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK9-NEXT:    [[ADD:%.*]] = fadd double [[CONV4]], 1.500000e+00
// CHECK9-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK9-NEXT:    store double [[ADD]], double* [[A]], align 8
// CHECK9-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP13:%.*]] = load double, double* [[A5]], align 8
// CHECK9-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK9-NEXT:    store double [[INC]], double* [[A5]], align 8
// CHECK9-NEXT:    [[CONV6:%.*]] = fptosi double [[INC]] to i16
// CHECK9-NEXT:    [[TMP14:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP14]]
// CHECK9-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK9-NEXT:    store i16 [[CONV6]], i16* [[ARRAYIDX7]], align 2
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[ADD8:%.*]] = add i64 [[TMP15]], 1
// CHECK9-NEXT:    store i64 [[ADD8]], i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207
// CHECK9-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK9-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK9-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK9-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP1]], i32* [[CONV2]], align 4
// CHECK9-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK9-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK9-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK9-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK9-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK9-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK9-NEXT:    store i64 6, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_8(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK9-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[TMP3]], 6
// CHECK9-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i64 [ 6, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK9-NEXT:    store i64 [[TMP5]], i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK9-NEXT:    [[CMP2:%.*]] = icmp sle i64 [[TMP6]], [[TMP7]]
// CHECK9-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i64 [[TMP8]], 3
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i64 -10, [[MUL]]
// CHECK9-NEXT:    store i64 [[ADD]], i64* [[I]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK9-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK9-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP10]] to i32
// CHECK9-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK9-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK9-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK9-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    [[ADD8:%.*]] = add nsw i64 [[TMP12]], 1
// CHECK9-NEXT:    store i64 [[ADD8]], i64* [[DOTOMP_IV]], align 8
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK9-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103
// CHECK11-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 0, void (i32*, i32*, ...)* bitcast (void (i32*, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*))
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 5, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 5
// CHECK11-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ 5, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 5
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 3, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_cancel(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK11-NEXT:    [[TMP9:%.*]] = icmp ne i32 [[TMP8]], 0
// CHECK11-NEXT:    br i1 [[TMP9]], label [[DOTCANCEL_EXIT:%.*]], label [[DOTCANCEL_CONTINUE:%.*]]
// CHECK11:       .cancel.exit:
// CHECK11-NEXT:    br label [[CANCEL_EXIT:%.*]]
// CHECK11:       .cancel.continue:
// CHECK11-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_cancellationpoint(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK11-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK11-NEXT:    br i1 [[TMP11]], label [[DOTCANCEL_EXIT2:%.*]], label [[DOTCANCEL_CONTINUE3:%.*]]
// CHECK11:       .cancel.exit2:
// CHECK11-NEXT:    br label [[CANCEL_EXIT]]
// CHECK11:       .cancel.continue3:
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK11-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK11-NEXT:    br label [[CANCEL_CONT:%.*]]
// CHECK11:       cancel.cont:
// CHECK11-NEXT:    ret void
// CHECK11:       cancel.exit:
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK11-NEXT:    br label [[CANCEL_CONT]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138
// CHECK11-SAME: (i32 noundef [[AA:%.*]], i32 noundef [[LIN:%.*]], i32 noundef [[A:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[LIN_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[LIN_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[LIN]], i32* [[LIN_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK11-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK11-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK11-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[LIN_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP2]], i32* [[LIN_CASTED]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[LIN_CASTED]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[LIN:%.*]], i32 noundef [[A:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[LIN_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK11-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTLINEAR_START1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTLINEAR_STEP:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[LIN2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[LIN]], i32* [[LIN_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[LIN_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[DOTLINEAR_START]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START1]], align 4
// CHECK11-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv() #[[ATTR5:[0-9]+]]
// CHECK11-NEXT:    store i64 [[CALL]], i64* [[DOTLINEAR_STEP]], align 8
// CHECK11-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK11-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK11-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP3]])
// CHECK11-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK11-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP4]], 3
// CHECK11-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK11-NEXT:    store i64 [[TMP6]], i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp ule i64 [[TMP7]], [[TMP8]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[MUL:%.*]] = mul i64 [[TMP9]], 400
// CHECK11-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK11-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK11-NEXT:    [[CONV5:%.*]] = sext i32 [[TMP10]] to i64
// CHECK11-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK11-NEXT:    [[MUL6:%.*]] = mul i64 [[TMP11]], [[TMP12]]
// CHECK11-NEXT:    [[ADD:%.*]] = add i64 [[CONV5]], [[MUL6]]
// CHECK11-NEXT:    [[CONV7:%.*]] = trunc i64 [[ADD]] to i32
// CHECK11-NEXT:    store i32 [[CONV7]], i32* [[LIN2]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTLINEAR_START1]], align 4
// CHECK11-NEXT:    [[CONV8:%.*]] = sext i32 [[TMP13]] to i64
// CHECK11-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK11-NEXT:    [[MUL9:%.*]] = mul i64 [[TMP14]], [[TMP15]]
// CHECK11-NEXT:    [[ADD10:%.*]] = add i64 [[CONV8]], [[MUL9]]
// CHECK11-NEXT:    [[CONV11:%.*]] = trunc i64 [[ADD10]] to i32
// CHECK11-NEXT:    store i32 [[CONV11]], i32* [[A3]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK11-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP16]] to i32
// CHECK11-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK11-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i16
// CHECK11-NEXT:    store i16 [[CONV14]], i16* [[CONV]], align 2
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[ADD15:%.*]] = add i64 [[TMP17]], 1
// CHECK11-NEXT:    store i64 [[ADD15]], i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = icmp ne i32 [[TMP18]], 0
// CHECK11-NEXT:    br i1 [[TMP19]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK11:       .omp.linear.pu:
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[LIN2]], align 4
// CHECK11-NEXT:    store i32 [[TMP20]], i32* [[LIN_ADDR]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A3]], align 4
// CHECK11-NEXT:    store i32 [[TMP21]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK11:       .omp.linear.pu.done:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z7get_valv
// CHECK11-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    ret i64 0
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146
// CHECK11-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK11-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK11-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i16, align 2
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[IT:%.*]] = alloca i16, align 2
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 3, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 3
// CHECK11-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 6, [[MUL]]
// CHECK11-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD]] to i16
// CHECK11-NEXT:    store i16 [[CONV2]], i16* [[IT]], align 2
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK11-NEXT:    store i32 [[ADD3]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK11-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP9]] to i32
// CHECK11-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK11-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK11-NEXT:    store i16 [[CONV6]], i16* [[CONV]], align 2
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170
// CHECK11-SAME: (i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK11-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK11-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK11-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK11-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK11-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP10]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 10, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, [10 x float]*, i32, float*, [5 x [10 x double]]*, i32, i32, double*, %struct.TT*, i32)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP9]], [10 x float]* [[TMP0]], i32 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i32 [[TMP4]], i32 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]], i32 [[TMP11]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK11-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[IT:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK11-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK11-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK11-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK11-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 25, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP8]])
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK11:       omp.dispatch.cond:
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 25
// CHECK11-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ 25, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK11:       omp.dispatch.body:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 122, [[MUL]]
// CHECK11-NEXT:    [[CONV:%.*]] = trunc i32 [[SUB]] to i8
// CHECK11-NEXT:    store i8 [[CONV]], i8* [[IT]], align 1
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[CONV7:%.*]] = fpext float [[TMP20]] to double
// CHECK11-NEXT:    [[ADD8:%.*]] = fadd double [[CONV7]], 1.000000e+00
// CHECK11-NEXT:    [[CONV9:%.*]] = fptrunc double [[ADD8]] to float
// CHECK11-NEXT:    store float [[CONV9]], float* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP2]], i32 3
// CHECK11-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX10]], align 4
// CHECK11-NEXT:    [[CONV11:%.*]] = fpext float [[TMP21]] to double
// CHECK11-NEXT:    [[ADD12:%.*]] = fadd double [[CONV11]], 1.000000e+00
// CHECK11-NEXT:    [[CONV13:%.*]] = fptrunc double [[ADD12]] to float
// CHECK11-NEXT:    store float [[CONV13]], float* [[ARRAYIDX10]], align 4
// CHECK11-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i32 0, i32 1
// CHECK11-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX14]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX15]], align 8
// CHECK11-NEXT:    [[ADD16:%.*]] = fadd double [[TMP22]], 1.000000e+00
// CHECK11-NEXT:    store double [[ADD16]], double* [[ARRAYIDX15]], align 8
// CHECK11-NEXT:    [[TMP23:%.*]] = mul nsw i32 1, [[TMP5]]
// CHECK11-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[TMP6]], i32 [[TMP23]]
// CHECK11-NEXT:    [[ARRAYIDX18:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX17]], i32 3
// CHECK11-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX18]], align 8
// CHECK11-NEXT:    [[ADD19:%.*]] = fadd double [[TMP24]], 1.000000e+00
// CHECK11-NEXT:    store double [[ADD19]], double* [[ARRAYIDX18]], align 8
// CHECK11-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP25:%.*]] = load i64, i64* [[X]], align 4
// CHECK11-NEXT:    [[ADD20:%.*]] = add nsw i64 [[TMP25]], 1
// CHECK11-NEXT:    store i64 [[ADD20]], i64* [[X]], align 4
// CHECK11-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP26:%.*]] = load i8, i8* [[Y]], align 4
// CHECK11-NEXT:    [[CONV21:%.*]] = sext i8 [[TMP26]] to i32
// CHECK11-NEXT:    [[ADD22:%.*]] = add nsw i32 [[CONV21]], 1
// CHECK11-NEXT:    [[CONV23:%.*]] = trunc i32 [[ADD22]] to i8
// CHECK11-NEXT:    store i8 [[CONV23]], i8* [[Y]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP27]], 1
// CHECK11-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK11:       omp.dispatch.inc:
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD25:%.*]] = add nsw i32 [[TMP28]], [[TMP29]]
// CHECK11-NEXT:    store i32 [[ADD25]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP30]], [[TMP31]]
// CHECK11-NEXT:    store i32 [[ADD26]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK11:       omp.dispatch.end:
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224
// CHECK11-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK11-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK11-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK11-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK11-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK11-NEXT:    [[CONV2:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK11-NEXT:    store i16 [[TMP3]], i16* [[CONV2]], align 2
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i8, i8* [[CONV1]], align 1
// CHECK11-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK11-NEXT:    store i8 [[TMP5]], i8* [[CONV3]], align 1
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32, [10 x i32]*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], [10 x i32]* [[TMP0]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK11-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK11-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK11-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242
// CHECK11-SAME: (%struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK11-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK11-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i32, i32, i32, i16*)* @.omp_outlined..5 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i32 [[TMP5]], i32 [[TMP1]], i32 [[TMP2]], i16* [[TMP3]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..5
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK11-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK11-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK11-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK11-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP6]], 3
// CHECK11-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK11-NEXT:    store i64 [[TMP8]], i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[CMP3:%.*]] = icmp ule i64 [[TMP9]], [[TMP10]]
// CHECK11-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[MUL:%.*]] = mul i64 [[TMP11]], 400
// CHECK11-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK11-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK11-NEXT:    [[ADD:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK11-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK11-NEXT:    store double [[ADD]], double* [[A]], align 4
// CHECK11-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP13:%.*]] = load double, double* [[A4]], align 4
// CHECK11-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK11-NEXT:    store double [[INC]], double* [[A4]], align 4
// CHECK11-NEXT:    [[CONV5:%.*]] = fptosi double [[INC]] to i16
// CHECK11-NEXT:    [[TMP14:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP14]]
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK11-NEXT:    store i16 [[CONV5]], i16* [[ARRAYIDX6]], align 2
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[ADD7:%.*]] = add i64 [[TMP15]], 1
// CHECK11-NEXT:    store i64 [[ADD7]], i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207
// CHECK11-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK11-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK11-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK11-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK11-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK11-NEXT:    store i16 [[TMP3]], i16* [[CONV1]], align 2
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i64, align 8
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK11-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK11-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK11-NEXT:    store i64 6, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_8(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK11-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[TMP3]], 6
// CHECK11-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i64 [ 6, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK11-NEXT:    store i64 [[TMP5]], i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK11-NEXT:    [[CMP1:%.*]] = icmp sle i64 [[TMP6]], [[TMP7]]
// CHECK11-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i64 [[TMP8]], 3
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i64 -10, [[MUL]]
// CHECK11-NEXT:    store i64 [[ADD]], i64* [[I]], align 8
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK11-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK11-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP10]] to i32
// CHECK11-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK11-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK11-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK11-NEXT:    store i32 [[ADD6]], i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i64 [[TMP12]], 1
// CHECK11-NEXT:    store i64 [[ADD7]], i64* [[DOTOMP_IV]], align 8
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK11-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@_Z7get_valv
// CHECK17-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    ret i64 0
//
//
// CHECK17-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK17-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK17-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK17-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK17-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK17-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 8
// CHECK17-NEXT:    [[K:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[K_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[LIN:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[LIN_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_CASTED4:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 4
// CHECK17-NEXT:    [[A_CASTED6:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED8:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS10:%.*]] = alloca [2 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS11:%.*]] = alloca [2 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS12:%.*]] = alloca [2 x i8*], align 8
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[A_CASTED15:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS20:%.*]] = alloca [10 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS21:%.*]] = alloca [10 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS22:%.*]] = alloca [10 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [10 x i64], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK17-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK17-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK17-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK17-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK17-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP2]], align 4
// CHECK17-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP4]] to i64
// CHECK17-NEXT:    [[TMP6:%.*]] = mul nuw i64 5, [[TMP5]]
// CHECK17-NEXT:    [[VLA1:%.*]] = alloca double, i64 [[TMP6]], align 8
// CHECK17-NEXT:    store i64 [[TMP5]], i64* [[__VLA_EXPR1]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103.region_id, i32 0, i8** null, i8** null, i64* null, i64* null, i8** null, i8** null, i32 1, i32 0)
// CHECK17-NEXT:    [[TMP8:%.*]] = icmp ne i32 [[TMP7]], 0
// CHECK17-NEXT:    br i1 [[TMP8]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK17:       omp_offload.failed:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103() #[[ATTR4:[0-9]+]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK17:       omp_offload.cont:
// CHECK17-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv()
// CHECK17-NEXT:    store i64 [[CALL]], i64* [[K]], align 8
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP9]], i32* [[CONV]], align 4
// CHECK17-NEXT:    [[TMP10:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP11:%.*]] = load i64, i64* [[K]], align 8
// CHECK17-NEXT:    store i64 [[TMP11]], i64* [[K_CASTED]], align 8
// CHECK17-NEXT:    [[TMP12:%.*]] = load i64, i64* [[K_CASTED]], align 8
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l110(i64 [[TMP10]], i64 [[TMP12]]) #[[ATTR4]]
// CHECK17-NEXT:    store i32 12, i32* [[LIN]], align 4
// CHECK17-NEXT:    [[TMP13:%.*]] = load i16, i16* [[AA]], align 2
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP13]], i16* [[CONV2]], align 2
// CHECK17-NEXT:    [[TMP14:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[LIN]], align 4
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[LIN_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP15]], i32* [[CONV3]], align 4
// CHECK17-NEXT:    [[TMP16:%.*]] = load i64, i64* [[LIN_CASTED]], align 8
// CHECK17-NEXT:    [[TMP17:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED4]] to i32*
// CHECK17-NEXT:    store i32 [[TMP17]], i32* [[CONV5]], align 4
// CHECK17-NEXT:    [[TMP18:%.*]] = load i64, i64* [[A_CASTED4]], align 8
// CHECK17-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK17-NEXT:    store i64 [[TMP14]], i64* [[TMP20]], align 8
// CHECK17-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i64*
// CHECK17-NEXT:    store i64 [[TMP14]], i64* [[TMP22]], align 8
// CHECK17-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK17-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK17-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i64*
// CHECK17-NEXT:    store i64 [[TMP16]], i64* [[TMP25]], align 8
// CHECK17-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK17-NEXT:    store i64 [[TMP16]], i64* [[TMP27]], align 8
// CHECK17-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK17-NEXT:    store i8* null, i8** [[TMP28]], align 8
// CHECK17-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i64*
// CHECK17-NEXT:    store i64 [[TMP18]], i64* [[TMP30]], align 8
// CHECK17-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i64*
// CHECK17-NEXT:    store i64 [[TMP18]], i64* [[TMP32]], align 8
// CHECK17-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK17-NEXT:    store i8* null, i8** [[TMP33]], align 8
// CHECK17-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP37:%.*]] = load i16, i16* [[AA]], align 2
// CHECK17-NEXT:    store i16 [[TMP37]], i16* [[TMP36]], align 4
// CHECK17-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP39:%.*]] = load i32, i32* [[LIN]], align 4
// CHECK17-NEXT:    store i32 [[TMP39]], i32* [[TMP38]], align 4
// CHECK17-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP41:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    store i32 [[TMP41]], i32* [[TMP40]], align 4
// CHECK17-NEXT:    [[TMP42:%.*]] = call i8* @__kmpc_omp_target_task_alloc(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 1, i64 120, i64 12, i32 (i32, i8*)* bitcast (i32 (i32, %struct.kmp_task_t_with_privates*)* @.omp_task_entry. to i32 (i32, i8*)*), i64 -1)
// CHECK17-NEXT:    [[TMP43:%.*]] = bitcast i8* [[TMP42]] to %struct.kmp_task_t_with_privates*
// CHECK17-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP43]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP44]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP46:%.*]] = load i8*, i8** [[TMP45]], align 8
// CHECK17-NEXT:    [[TMP47:%.*]] = bitcast %struct.anon* [[AGG_CAPTURED]] to i8*
// CHECK17-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP46]], i8* align 4 [[TMP47]], i64 12, i1 false)
// CHECK17-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP43]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP49:%.*]] = bitcast i8* [[TMP46]] to %struct.anon*
// CHECK17-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP48]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP51:%.*]] = bitcast [3 x i8*]* [[TMP50]] to i8*
// CHECK17-NEXT:    [[TMP52:%.*]] = bitcast i8** [[TMP34]] to i8*
// CHECK17-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP51]], i8* align 8 [[TMP52]], i64 24, i1 false)
// CHECK17-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP48]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP54:%.*]] = bitcast [3 x i8*]* [[TMP53]] to i8*
// CHECK17-NEXT:    [[TMP55:%.*]] = bitcast i8** [[TMP35]] to i8*
// CHECK17-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP54]], i8* align 8 [[TMP55]], i64 24, i1 false)
// CHECK17-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP48]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP57:%.*]] = bitcast [3 x i64]* [[TMP56]] to i8*
// CHECK17-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP57]], i8* align 8 bitcast ([3 x i64]* @.offload_sizes to i8*), i64 24, i1 false)
// CHECK17-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP48]], i32 0, i32 3
// CHECK17-NEXT:    [[TMP59:%.*]] = load i16, i16* [[AA]], align 2
// CHECK17-NEXT:    store i16 [[TMP59]], i16* [[TMP58]], align 8
// CHECK17-NEXT:    [[TMP60:%.*]] = call i32 @__kmpc_omp_task(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i8* [[TMP42]])
// CHECK17-NEXT:    [[TMP61:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[CONV7:%.*]] = bitcast i64* [[A_CASTED6]] to i32*
// CHECK17-NEXT:    store i32 [[TMP61]], i32* [[CONV7]], align 4
// CHECK17-NEXT:    [[TMP62:%.*]] = load i64, i64* [[A_CASTED6]], align 8
// CHECK17-NEXT:    [[TMP63:%.*]] = load i16, i16* [[AA]], align 2
// CHECK17-NEXT:    [[CONV9:%.*]] = bitcast i64* [[AA_CASTED8]] to i16*
// CHECK17-NEXT:    store i16 [[TMP63]], i16* [[CONV9]], align 2
// CHECK17-NEXT:    [[TMP64:%.*]] = load i64, i64* [[AA_CASTED8]], align 8
// CHECK17-NEXT:    [[TMP65:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP65]], 10
// CHECK17-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK17:       omp_if.then:
// CHECK17-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP67:%.*]] = bitcast i8** [[TMP66]] to i64*
// CHECK17-NEXT:    store i64 [[TMP62]], i64* [[TMP67]], align 8
// CHECK17-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS11]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP69:%.*]] = bitcast i8** [[TMP68]] to i64*
// CHECK17-NEXT:    store i64 [[TMP62]], i64* [[TMP69]], align 8
// CHECK17-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 0
// CHECK17-NEXT:    store i8* null, i8** [[TMP70]], align 8
// CHECK17-NEXT:    [[TMP71:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP72:%.*]] = bitcast i8** [[TMP71]] to i64*
// CHECK17-NEXT:    store i64 [[TMP64]], i64* [[TMP72]], align 8
// CHECK17-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS11]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP74:%.*]] = bitcast i8** [[TMP73]] to i64*
// CHECK17-NEXT:    store i64 [[TMP64]], i64* [[TMP74]], align 8
// CHECK17-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS12]], i64 0, i64 1
// CHECK17-NEXT:    store i8* null, i8** [[TMP75]], align 8
// CHECK17-NEXT:    [[TMP76:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS10]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS11]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP78:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146.region_id, i32 2, i8** [[TMP76]], i8** [[TMP77]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK17-NEXT:    [[TMP79:%.*]] = icmp ne i32 [[TMP78]], 0
// CHECK17-NEXT:    br i1 [[TMP79]], label [[OMP_OFFLOAD_FAILED13:%.*]], label [[OMP_OFFLOAD_CONT14:%.*]]
// CHECK17:       omp_offload.failed13:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146(i64 [[TMP62]], i64 [[TMP64]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT14]]
// CHECK17:       omp_offload.cont14:
// CHECK17-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK17:       omp_if.else:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146(i64 [[TMP62]], i64 [[TMP64]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_IF_END]]
// CHECK17:       omp_if.end:
// CHECK17-NEXT:    [[TMP80:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    store i32 [[TMP80]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK17-NEXT:    [[TMP81:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[CONV16:%.*]] = bitcast i64* [[A_CASTED15]] to i32*
// CHECK17-NEXT:    store i32 [[TMP81]], i32* [[CONV16]], align 4
// CHECK17-NEXT:    [[TMP82:%.*]] = load i64, i64* [[A_CASTED15]], align 8
// CHECK17-NEXT:    [[TMP83:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK17-NEXT:    [[CONV17:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP83]], i32* [[CONV17]], align 4
// CHECK17-NEXT:    [[TMP84:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK17-NEXT:    [[TMP85:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CMP18:%.*]] = icmp sgt i32 [[TMP85]], 20
// CHECK17-NEXT:    br i1 [[CMP18]], label [[OMP_IF_THEN19:%.*]], label [[OMP_IF_ELSE25:%.*]]
// CHECK17:       omp_if.then19:
// CHECK17-NEXT:    [[TMP86:%.*]] = mul nuw i64 [[TMP2]], 4
// CHECK17-NEXT:    [[TMP87:%.*]] = mul nuw i64 5, [[TMP5]]
// CHECK17-NEXT:    [[TMP88:%.*]] = mul nuw i64 [[TMP87]], 8
// CHECK17-NEXT:    [[TMP89:%.*]] = bitcast [10 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK17-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP89]], i8* align 8 bitcast ([10 x i64]* @.offload_sizes.8 to i8*), i64 80, i1 false)
// CHECK17-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to i64*
// CHECK17-NEXT:    store i64 [[TMP82]], i64* [[TMP91]], align 8
// CHECK17-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP93:%.*]] = bitcast i8** [[TMP92]] to i64*
// CHECK17-NEXT:    store i64 [[TMP82]], i64* [[TMP93]], align 8
// CHECK17-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 0
// CHECK17-NEXT:    store i8* null, i8** [[TMP94]], align 8
// CHECK17-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP96:%.*]] = bitcast i8** [[TMP95]] to [10 x float]**
// CHECK17-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP96]], align 8
// CHECK17-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP98:%.*]] = bitcast i8** [[TMP97]] to [10 x float]**
// CHECK17-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP98]], align 8
// CHECK17-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 1
// CHECK17-NEXT:    store i8* null, i8** [[TMP99]], align 8
// CHECK17-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP101:%.*]] = bitcast i8** [[TMP100]] to i64*
// CHECK17-NEXT:    store i64 [[TMP2]], i64* [[TMP101]], align 8
// CHECK17-NEXT:    [[TMP102:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP103:%.*]] = bitcast i8** [[TMP102]] to i64*
// CHECK17-NEXT:    store i64 [[TMP2]], i64* [[TMP103]], align 8
// CHECK17-NEXT:    [[TMP104:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 2
// CHECK17-NEXT:    store i8* null, i8** [[TMP104]], align 8
// CHECK17-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 3
// CHECK17-NEXT:    [[TMP106:%.*]] = bitcast i8** [[TMP105]] to float**
// CHECK17-NEXT:    store float* [[VLA]], float** [[TMP106]], align 8
// CHECK17-NEXT:    [[TMP107:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 3
// CHECK17-NEXT:    [[TMP108:%.*]] = bitcast i8** [[TMP107]] to float**
// CHECK17-NEXT:    store float* [[VLA]], float** [[TMP108]], align 8
// CHECK17-NEXT:    [[TMP109:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK17-NEXT:    store i64 [[TMP86]], i64* [[TMP109]], align 8
// CHECK17-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 3
// CHECK17-NEXT:    store i8* null, i8** [[TMP110]], align 8
// CHECK17-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 4
// CHECK17-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to [5 x [10 x double]]**
// CHECK17-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP112]], align 8
// CHECK17-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 4
// CHECK17-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to [5 x [10 x double]]**
// CHECK17-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP114]], align 8
// CHECK17-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 4
// CHECK17-NEXT:    store i8* null, i8** [[TMP115]], align 8
// CHECK17-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 5
// CHECK17-NEXT:    [[TMP117:%.*]] = bitcast i8** [[TMP116]] to i64*
// CHECK17-NEXT:    store i64 5, i64* [[TMP117]], align 8
// CHECK17-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 5
// CHECK17-NEXT:    [[TMP119:%.*]] = bitcast i8** [[TMP118]] to i64*
// CHECK17-NEXT:    store i64 5, i64* [[TMP119]], align 8
// CHECK17-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 5
// CHECK17-NEXT:    store i8* null, i8** [[TMP120]], align 8
// CHECK17-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 6
// CHECK17-NEXT:    [[TMP122:%.*]] = bitcast i8** [[TMP121]] to i64*
// CHECK17-NEXT:    store i64 [[TMP5]], i64* [[TMP122]], align 8
// CHECK17-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 6
// CHECK17-NEXT:    [[TMP124:%.*]] = bitcast i8** [[TMP123]] to i64*
// CHECK17-NEXT:    store i64 [[TMP5]], i64* [[TMP124]], align 8
// CHECK17-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 6
// CHECK17-NEXT:    store i8* null, i8** [[TMP125]], align 8
// CHECK17-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 7
// CHECK17-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to double**
// CHECK17-NEXT:    store double* [[VLA1]], double** [[TMP127]], align 8
// CHECK17-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 7
// CHECK17-NEXT:    [[TMP129:%.*]] = bitcast i8** [[TMP128]] to double**
// CHECK17-NEXT:    store double* [[VLA1]], double** [[TMP129]], align 8
// CHECK17-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK17-NEXT:    store i64 [[TMP88]], i64* [[TMP130]], align 8
// CHECK17-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 7
// CHECK17-NEXT:    store i8* null, i8** [[TMP131]], align 8
// CHECK17-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 8
// CHECK17-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to %struct.TT**
// CHECK17-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP133]], align 8
// CHECK17-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 8
// CHECK17-NEXT:    [[TMP135:%.*]] = bitcast i8** [[TMP134]] to %struct.TT**
// CHECK17-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP135]], align 8
// CHECK17-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 8
// CHECK17-NEXT:    store i8* null, i8** [[TMP136]], align 8
// CHECK17-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 9
// CHECK17-NEXT:    [[TMP138:%.*]] = bitcast i8** [[TMP137]] to i64*
// CHECK17-NEXT:    store i64 [[TMP84]], i64* [[TMP138]], align 8
// CHECK17-NEXT:    [[TMP139:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 9
// CHECK17-NEXT:    [[TMP140:%.*]] = bitcast i8** [[TMP139]] to i64*
// CHECK17-NEXT:    store i64 [[TMP84]], i64* [[TMP140]], align 8
// CHECK17-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 9
// CHECK17-NEXT:    store i8* null, i8** [[TMP141]], align 8
// CHECK17-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP145:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170.region_id, i32 10, i8** [[TMP142]], i8** [[TMP143]], i64* [[TMP144]], i64* getelementptr inbounds ([10 x i64], [10 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK17-NEXT:    [[TMP146:%.*]] = icmp ne i32 [[TMP145]], 0
// CHECK17-NEXT:    br i1 [[TMP146]], label [[OMP_OFFLOAD_FAILED23:%.*]], label [[OMP_OFFLOAD_CONT24:%.*]]
// CHECK17:       omp_offload.failed23:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170(i64 [[TMP82]], [10 x float]* [[B]], i64 [[TMP2]], float* [[VLA]], [5 x [10 x double]]* [[C]], i64 5, i64 [[TMP5]], double* [[VLA1]], %struct.TT* [[D]], i64 [[TMP84]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT24]]
// CHECK17:       omp_offload.cont24:
// CHECK17-NEXT:    br label [[OMP_IF_END26:%.*]]
// CHECK17:       omp_if.else25:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170(i64 [[TMP82]], [10 x float]* [[B]], i64 [[TMP2]], float* [[VLA]], [5 x [10 x double]]* [[C]], i64 5, i64 [[TMP5]], double* [[VLA1]], %struct.TT* [[D]], i64 [[TMP84]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_IF_END26]]
// CHECK17:       omp_if.end26:
// CHECK17-NEXT:    [[TMP147:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[TMP148:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK17-NEXT:    call void @llvm.stackrestore(i8* [[TMP148]])
// CHECK17-NEXT:    ret i32 [[TMP147]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103
// CHECK17-SAME: () #[[ATTR2:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 0, void (i32*, i32*, ...)* bitcast (void (i32*, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*))
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 5, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 5
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 5, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK17-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 5
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 3, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_cancel(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK17-NEXT:    [[TMP9:%.*]] = icmp ne i32 [[TMP8]], 0
// CHECK17-NEXT:    br i1 [[TMP9]], label [[DOTCANCEL_EXIT:%.*]], label [[DOTCANCEL_CONTINUE:%.*]]
// CHECK17:       .cancel.exit:
// CHECK17-NEXT:    br label [[CANCEL_EXIT:%.*]]
// CHECK17:       .cancel.continue:
// CHECK17-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_cancellationpoint(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK17-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK17-NEXT:    br i1 [[TMP11]], label [[DOTCANCEL_EXIT2:%.*]], label [[DOTCANCEL_CONTINUE3:%.*]]
// CHECK17:       .cancel.exit2:
// CHECK17-NEXT:    br label [[CANCEL_EXIT]]
// CHECK17:       .cancel.continue3:
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK17-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK17-NEXT:    br label [[CANCEL_CONT:%.*]]
// CHECK17:       cancel.cont:
// CHECK17-NEXT:    ret void
// CHECK17:       cancel.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK17-NEXT:    br label [[CANCEL_CONT]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l110
// CHECK17-SAME: (i64 noundef [[A:%.*]], i64 noundef [[K:%.*]]) #[[ATTR3]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[K_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[K_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[K]], i64* [[K_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP0]], i32* [[CONV1]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[K_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[TMP2]], i64* [[K_CASTED]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i64, i64* [[K_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[K:%.*]]) #[[ATTR3]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[K_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[K1:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[K]], i64* [[K_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP0:%.*]] = load i64, i64* [[K_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[TMP0]], i64* [[DOTLINEAR_START]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 8, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK17-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP2]])
// CHECK17-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]], i32 1073741859, i32 0, i32 8, i32 1, i32 1)
// CHECK17-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK17:       omp.dispatch.cond:
// CHECK17-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP2]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK17-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP3]], 0
// CHECK17-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK17:       omp.dispatch.body:
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK17-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK17-NEXT:    [[SUB:%.*]] = sub nsw i32 10, [[MUL]]
// CHECK17-NEXT:    store i32 [[SUB]], i32* [[I]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTLINEAR_START]], align 8, !llvm.access.group !12
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    [[MUL2:%.*]] = mul nsw i32 [[TMP9]], 3
// CHECK17-NEXT:    [[CONV3:%.*]] = sext i32 [[MUL2]] to i64
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP8]], [[CONV3]]
// CHECK17-NEXT:    store i64 [[ADD]], i64* [[K1]], align 8, !llvm.access.group !12
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK17-NEXT:    store i32 [[ADD4]], i32* [[CONV]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK17-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK17:       omp.dispatch.inc:
// CHECK17-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK17:       omp.dispatch.end:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP13:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK17-NEXT:    br i1 [[TMP13]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK17:       .omp.linear.pu:
// CHECK17-NEXT:    [[TMP14:%.*]] = load i64, i64* [[K1]], align 8
// CHECK17-NEXT:    store i64 [[TMP14]], i64* [[K_ADDR]], align 8
// CHECK17-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK17:       .omp.linear.pu.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138
// CHECK17-SAME: (i64 noundef [[AA:%.*]], i64 noundef [[LIN:%.*]], i64 noundef [[A:%.*]]) #[[ATTR2]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[LIN_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[LIN_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[LIN]], i64* [[LIN_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[LIN_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP0]], i16* [[CONV3]], align 2
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK17-NEXT:    [[CONV4:%.*]] = bitcast i64* [[LIN_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP2]], i32* [[CONV4]], align 4
// CHECK17-NEXT:    [[TMP3:%.*]] = load i64, i64* [[LIN_CASTED]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV2]], align 4
// CHECK17-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[CONV5]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[LIN:%.*]], i64 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[LIN_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTLINEAR_START3:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTLINEAR_STEP:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[LIN4:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[A5:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[LIN]], i64* [[LIN_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[LIN_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK17-NEXT:    store i32 [[TMP0]], i32* [[DOTLINEAR_START]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV2]], align 4
// CHECK17-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START3]], align 4
// CHECK17-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv()
// CHECK17-NEXT:    store i64 [[CALL]], i64* [[DOTLINEAR_STEP]], align 8
// CHECK17-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK17-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK17-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3]], i32 [[TMP3]])
// CHECK17-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP4]], 3
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK17-NEXT:    store i64 [[TMP6]], i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[CMP6:%.*]] = icmp ule i64 [[TMP7]], [[TMP8]]
// CHECK17-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[MUL:%.*]] = mul i64 [[TMP9]], 400
// CHECK17-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK17-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK17-NEXT:    [[CONV7:%.*]] = sext i32 [[TMP10]] to i64
// CHECK17-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK17-NEXT:    [[MUL8:%.*]] = mul i64 [[TMP11]], [[TMP12]]
// CHECK17-NEXT:    [[ADD:%.*]] = add i64 [[CONV7]], [[MUL8]]
// CHECK17-NEXT:    [[CONV9:%.*]] = trunc i64 [[ADD]] to i32
// CHECK17-NEXT:    store i32 [[CONV9]], i32* [[LIN4]], align 4
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTLINEAR_START3]], align 4
// CHECK17-NEXT:    [[CONV10:%.*]] = sext i32 [[TMP13]] to i64
// CHECK17-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK17-NEXT:    [[MUL11:%.*]] = mul i64 [[TMP14]], [[TMP15]]
// CHECK17-NEXT:    [[ADD12:%.*]] = add i64 [[CONV10]], [[MUL11]]
// CHECK17-NEXT:    [[CONV13:%.*]] = trunc i64 [[ADD12]] to i32
// CHECK17-NEXT:    store i32 [[CONV13]], i32* [[A5]], align 4
// CHECK17-NEXT:    [[TMP16:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK17-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP16]] to i32
// CHECK17-NEXT:    [[ADD15:%.*]] = add nsw i32 [[CONV14]], 1
// CHECK17-NEXT:    [[CONV16:%.*]] = trunc i32 [[ADD15]] to i16
// CHECK17-NEXT:    store i16 [[CONV16]], i16* [[CONV]], align 2
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP17:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[ADD17:%.*]] = add i64 [[TMP17]], 1
// CHECK17-NEXT:    store i64 [[ADD17]], i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK17-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP19:%.*]] = icmp ne i32 [[TMP18]], 0
// CHECK17-NEXT:    br i1 [[TMP19]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK17:       .omp.linear.pu:
// CHECK17-NEXT:    [[TMP20:%.*]] = load i32, i32* [[LIN4]], align 4
// CHECK17-NEXT:    store i32 [[TMP20]], i32* [[CONV1]], align 4
// CHECK17-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A5]], align 4
// CHECK17-NEXT:    store i32 [[TMP21]], i32* [[CONV2]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK17:       .omp.linear.pu.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK17-SAME: (%struct..kmp_privates.t* noalias noundef [[TMP0:%.*]], i16** noalias noundef [[TMP1:%.*]], [3 x i8*]** noalias noundef [[TMP2:%.*]], [3 x i8*]** noalias noundef [[TMP3:%.*]], [3 x i64]** noalias noundef [[TMP4:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTADDR:%.*]] = alloca %struct..kmp_privates.t*, align 8
// CHECK17-NEXT:    [[DOTADDR1:%.*]] = alloca i16**, align 8
// CHECK17-NEXT:    [[DOTADDR2:%.*]] = alloca [3 x i8*]**, align 8
// CHECK17-NEXT:    [[DOTADDR3:%.*]] = alloca [3 x i8*]**, align 8
// CHECK17-NEXT:    [[DOTADDR4:%.*]] = alloca [3 x i64]**, align 8
// CHECK17-NEXT:    store %struct..kmp_privates.t* [[TMP0]], %struct..kmp_privates.t** [[DOTADDR]], align 8
// CHECK17-NEXT:    store i16** [[TMP1]], i16*** [[DOTADDR1]], align 8
// CHECK17-NEXT:    store [3 x i8*]** [[TMP2]], [3 x i8*]*** [[DOTADDR2]], align 8
// CHECK17-NEXT:    store [3 x i8*]** [[TMP3]], [3 x i8*]*** [[DOTADDR3]], align 8
// CHECK17-NEXT:    store [3 x i64]** [[TMP4]], [3 x i64]*** [[DOTADDR4]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load %struct..kmp_privates.t*, %struct..kmp_privates.t** [[DOTADDR]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP7:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR2]], align 8
// CHECK17-NEXT:    store [3 x i8*]* [[TMP6]], [3 x i8*]** [[TMP7]], align 8
// CHECK17-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP9:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR3]], align 8
// CHECK17-NEXT:    store [3 x i8*]* [[TMP8]], [3 x i8*]** [[TMP9]], align 8
// CHECK17-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP11:%.*]] = load [3 x i64]**, [3 x i64]*** [[DOTADDR4]], align 8
// CHECK17-NEXT:    store [3 x i64]* [[TMP10]], [3 x i64]** [[TMP11]], align 8
// CHECK17-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 3
// CHECK17-NEXT:    [[TMP13:%.*]] = load i16**, i16*** [[DOTADDR1]], align 8
// CHECK17-NEXT:    store i16* [[TMP12]], i16** [[TMP13]], align 8
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK17-SAME: (i32 noundef signext [[TMP0:%.*]], %struct.kmp_task_t_with_privates* noalias noundef [[TMP1:%.*]]) #[[ATTR7:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca i8*, align 8
// CHECK17-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca void (i8*, ...)*, align 8
// CHECK17-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca i8*, align 8
// CHECK17-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca %struct.anon*, align 8
// CHECK17-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca i16*, align 8
// CHECK17-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca [3 x i8*]*, align 8
// CHECK17-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca [3 x i8*]*, align 8
// CHECK17-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca [3 x i64]*, align 8
// CHECK17-NEXT:    [[AA_CASTED_I:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[LIN_CASTED_I:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_CASTED_I:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTADDR1:%.*]] = alloca %struct.kmp_task_t_with_privates*, align 8
// CHECK17-NEXT:    store i32 [[TMP0]], i32* [[DOTADDR]], align 4
// CHECK17-NEXT:    store %struct.kmp_task_t_with_privates* [[TMP1]], %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTADDR]], align 4
// CHECK17-NEXT:    [[TMP3:%.*]] = load %struct.kmp_task_t_with_privates*, %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP7:%.*]] = load i8*, i8** [[TMP6]], align 8
// CHECK17-NEXT:    [[TMP8:%.*]] = bitcast i8* [[TMP7]] to %struct.anon*
// CHECK17-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP10:%.*]] = bitcast %struct..kmp_privates.t* [[TMP9]] to i8*
// CHECK17-NEXT:    [[TMP11:%.*]] = bitcast %struct.kmp_task_t_with_privates* [[TMP3]] to i8*
// CHECK17-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META15:![0-9]+]])
// CHECK17-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META18:![0-9]+]])
// CHECK17-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META20:![0-9]+]])
// CHECK17-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META22:![0-9]+]])
// CHECK17-NEXT:    store i32 [[TMP2]], i32* [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !24
// CHECK17-NEXT:    store i32* [[TMP5]], i32** [[DOTPART_ID__ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    store i8* [[TMP10]], i8** [[DOTPRIVATES__ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    store void (i8*, ...)* bitcast (void (%struct..kmp_privates.t*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)* @.omp_task_privates_map. to void (i8*, ...)*), void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    store i8* [[TMP11]], i8** [[DOTTASK_T__ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    store %struct.anon* [[TMP8]], %struct.anon** [[__CONTEXT_ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP12:%.*]] = load %struct.anon*, %struct.anon** [[__CONTEXT_ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP13:%.*]] = load void (i8*, ...)*, void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[DOTPRIVATES__ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP15:%.*]] = bitcast void (i8*, ...)* [[TMP13]] to void (i8*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)*
// CHECK17-NEXT:    call void [[TMP15]](i8* [[TMP14]], i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK17-NEXT:    [[TMP16:%.*]] = load i16*, i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP17:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP18:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP19:%.*]] = load [3 x i64]*, [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP17]], i64 0, i64 0
// CHECK17-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP18]], i64 0, i64 0
// CHECK17-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[TMP19]], i64 0, i64 0
// CHECK17-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], %struct.anon* [[TMP12]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[TMP12]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP25:%.*]] = call i32 @__tgt_target_teams_nowait_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* [[TMP22]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0, i32 0, i8* null, i32 0, i8* null) #[[ATTR4]]
// CHECK17-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK17-NEXT:    br i1 [[TMP26]], label [[OMP_OFFLOAD_FAILED_I:%.*]], label [[DOTOMP_OUTLINED__3_EXIT:%.*]]
// CHECK17:       omp_offload.failed.i:
// CHECK17-NEXT:    [[TMP27:%.*]] = load i16, i16* [[TMP16]], align 2
// CHECK17-NEXT:    [[CONV_I:%.*]] = bitcast i64* [[AA_CASTED_I]] to i16*
// CHECK17-NEXT:    store i16 [[TMP27]], i16* [[CONV_I]], align 2, !noalias !24
// CHECK17-NEXT:    [[TMP28:%.*]] = load i64, i64* [[AA_CASTED_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK17-NEXT:    [[CONV4_I:%.*]] = bitcast i64* [[LIN_CASTED_I]] to i32*
// CHECK17-NEXT:    store i32 [[TMP29]], i32* [[CONV4_I]], align 4, !noalias !24
// CHECK17-NEXT:    [[TMP30:%.*]] = load i64, i64* [[LIN_CASTED_I]], align 8, !noalias !24
// CHECK17-NEXT:    [[TMP31:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK17-NEXT:    [[CONV5_I:%.*]] = bitcast i64* [[A_CASTED_I]] to i32*
// CHECK17-NEXT:    store i32 [[TMP31]], i32* [[CONV5_I]], align 4, !noalias !24
// CHECK17-NEXT:    [[TMP32:%.*]] = load i64, i64* [[A_CASTED_I]], align 8, !noalias !24
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138(i64 [[TMP28]], i64 [[TMP30]], i64 [[TMP32]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[DOTOMP_OUTLINED__3_EXIT]]
// CHECK17:       .omp_outlined..3.exit:
// CHECK17-NEXT:    ret i32 0
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146
// CHECK17-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP0]], i32* [[CONV2]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP2]], i16* [[CONV3]], align 2
// CHECK17-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i16, align 2
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[IT:%.*]] = alloca i16, align 2
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 3, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 3
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK17-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 4
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 6, [[MUL]]
// CHECK17-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD]] to i16
// CHECK17-NEXT:    store i16 [[CONV3]], i16* [[IT]], align 2
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK17-NEXT:    store i32 [[ADD4]], i32* [[CONV]], align 4
// CHECK17-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[CONV5:%.*]] = sext i16 [[TMP9]] to i32
// CHECK17-NEXT:    [[ADD6:%.*]] = add nsw i32 [[CONV5]], 1
// CHECK17-NEXT:    [[CONV7:%.*]] = trunc i32 [[ADD6]] to i16
// CHECK17-NEXT:    store i16 [[CONV7]], i16* [[CONV1]], align 2
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK17-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170
// CHECK17-SAME: (i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK17-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK17-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK17-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK17-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK17-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV6:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP8]], i32* [[CONV6]], align 4
// CHECK17-NEXT:    [[TMP9:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV5]], align 4
// CHECK17-NEXT:    [[CONV7:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP10]], i32* [[CONV7]], align 4
// CHECK17-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 10, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, [10 x float]*, i64, float*, [5 x [10 x double]]*, i64, i64, double*, %struct.TT*, i64)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i64 [[TMP9]], [10 x float]* [[TMP0]], i64 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i64 [[TMP4]], i64 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]], i64 [[TMP11]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR3]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK17-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK17-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[IT:%.*]] = alloca i8, align 1
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK17-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK17-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK17-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 25, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV5]], align 4
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP8]])
// CHECK17-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK17:       omp.dispatch.cond:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 25
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 25, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK17-NEXT:    br i1 [[CMP6]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK17:       omp.dispatch.body:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// CHECK17-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK17-NEXT:    [[SUB:%.*]] = sub nsw i32 122, [[MUL]]
// CHECK17-NEXT:    [[CONV8:%.*]] = trunc i32 [[SUB]] to i8
// CHECK17-NEXT:    store i8 [[CONV8]], i8* [[IT]], align 1
// CHECK17-NEXT:    [[TMP19:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[CONV]], align 4
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 2
// CHECK17-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK17-NEXT:    [[CONV9:%.*]] = fpext float [[TMP20]] to double
// CHECK17-NEXT:    [[ADD10:%.*]] = fadd double [[CONV9]], 1.000000e+00
// CHECK17-NEXT:    [[CONV11:%.*]] = fptrunc double [[ADD10]] to float
// CHECK17-NEXT:    store float [[CONV11]], float* [[ARRAYIDX]], align 4
// CHECK17-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds float, float* [[TMP2]], i64 3
// CHECK17-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX12]], align 4
// CHECK17-NEXT:    [[CONV13:%.*]] = fpext float [[TMP21]] to double
// CHECK17-NEXT:    [[ADD14:%.*]] = fadd double [[CONV13]], 1.000000e+00
// CHECK17-NEXT:    [[CONV15:%.*]] = fptrunc double [[ADD14]] to float
// CHECK17-NEXT:    store float [[CONV15]], float* [[ARRAYIDX12]], align 4
// CHECK17-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i64 0, i64 1
// CHECK17-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX16]], i64 0, i64 2
// CHECK17-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX17]], align 8
// CHECK17-NEXT:    [[ADD18:%.*]] = fadd double [[TMP22]], 1.000000e+00
// CHECK17-NEXT:    store double [[ADD18]], double* [[ARRAYIDX17]], align 8
// CHECK17-NEXT:    [[TMP23:%.*]] = mul nsw i64 1, [[TMP5]]
// CHECK17-NEXT:    [[ARRAYIDX19:%.*]] = getelementptr inbounds double, double* [[TMP6]], i64 [[TMP23]]
// CHECK17-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX19]], i64 3
// CHECK17-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX20]], align 8
// CHECK17-NEXT:    [[ADD21:%.*]] = fadd double [[TMP24]], 1.000000e+00
// CHECK17-NEXT:    store double [[ADD21]], double* [[ARRAYIDX20]], align 8
// CHECK17-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP25:%.*]] = load i64, i64* [[X]], align 8
// CHECK17-NEXT:    [[ADD22:%.*]] = add nsw i64 [[TMP25]], 1
// CHECK17-NEXT:    store i64 [[ADD22]], i64* [[X]], align 8
// CHECK17-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP26:%.*]] = load i8, i8* [[Y]], align 8
// CHECK17-NEXT:    [[CONV23:%.*]] = sext i8 [[TMP26]] to i32
// CHECK17-NEXT:    [[ADD24:%.*]] = add nsw i32 [[CONV23]], 1
// CHECK17-NEXT:    [[CONV25:%.*]] = trunc i32 [[ADD24]] to i8
// CHECK17-NEXT:    store i8 [[CONV25]], i8* [[Y]], align 8
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP27]], 1
// CHECK17-NEXT:    store i32 [[ADD26]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK17:       omp.dispatch.inc:
// CHECK17-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    [[ADD27:%.*]] = add nsw i32 [[TMP28]], [[TMP29]]
// CHECK17-NEXT:    store i32 [[ADD27]], i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    [[ADD28:%.*]] = add nsw i32 [[TMP30]], [[TMP31]]
// CHECK17-NEXT:    store i32 [[ADD28]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK17:       omp.dispatch.end:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@_Z3bari
// CHECK17-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 8
// CHECK17-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z3fooi(i32 noundef signext [[TMP0]])
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CALL1:%.*]] = call noundef signext i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 8 dereferenceable(8) [[S]], i32 noundef signext [[TMP2]])
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK17-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CALL3:%.*]] = call noundef signext i32 @_ZL7fstatici(i32 noundef signext [[TMP4]])
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK17-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CALL5:%.*]] = call noundef signext i32 @_Z9ftemplateIiET_i(i32 noundef signext [[TMP6]])
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK17-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK17-SAME: (%struct.S1* noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK17-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK17-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [5 x i64], align 8
// CHECK17-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK17-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK17-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK17-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP4]], align 2
// CHECK17-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B]], align 4
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP5]], i32* [[CONV]], align 4
// CHECK17-NEXT:    [[TMP6:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 60
// CHECK17-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK17:       omp_if.then:
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP8:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK17-NEXT:    [[TMP9:%.*]] = mul nuw i64 [[TMP8]], 2
// CHECK17-NEXT:    [[TMP10:%.*]] = bitcast [5 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK17-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP10]], i8* align 8 bitcast ([5 x i64]* @.offload_sizes.11 to i8*), i64 40, i1 false)
// CHECK17-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to %struct.S1**
// CHECK17-NEXT:    store %struct.S1* [[THIS1]], %struct.S1** [[TMP12]], align 8
// CHECK17-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to double**
// CHECK17-NEXT:    store double* [[A]], double** [[TMP14]], align 8
// CHECK17-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK17-NEXT:    store i8* null, i8** [[TMP15]], align 8
// CHECK17-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK17-NEXT:    store i64 [[TMP6]], i64* [[TMP17]], align 8
// CHECK17-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i64*
// CHECK17-NEXT:    store i64 [[TMP6]], i64* [[TMP19]], align 8
// CHECK17-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK17-NEXT:    store i8* null, i8** [[TMP20]], align 8
// CHECK17-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i64*
// CHECK17-NEXT:    store i64 2, i64* [[TMP22]], align 8
// CHECK17-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i64*
// CHECK17-NEXT:    store i64 2, i64* [[TMP24]], align 8
// CHECK17-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK17-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK17-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK17-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK17-NEXT:    store i64 [[TMP2]], i64* [[TMP27]], align 8
// CHECK17-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK17-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i64*
// CHECK17-NEXT:    store i64 [[TMP2]], i64* [[TMP29]], align 8
// CHECK17-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK17-NEXT:    store i8* null, i8** [[TMP30]], align 8
// CHECK17-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK17-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i16**
// CHECK17-NEXT:    store i16* [[VLA]], i16** [[TMP32]], align 8
// CHECK17-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK17-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i16**
// CHECK17-NEXT:    store i16* [[VLA]], i16** [[TMP34]], align 8
// CHECK17-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK17-NEXT:    store i64 [[TMP9]], i64* [[TMP35]], align 8
// CHECK17-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK17-NEXT:    store i8* null, i8** [[TMP36]], align 8
// CHECK17-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP40:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242.region_id, i32 5, i8** [[TMP37]], i8** [[TMP38]], i64* [[TMP39]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK17-NEXT:    [[TMP41:%.*]] = icmp ne i32 [[TMP40]], 0
// CHECK17-NEXT:    br i1 [[TMP41]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK17:       omp_offload.failed:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242(%struct.S1* [[THIS1]], i64 [[TMP6]], i64 2, i64 [[TMP2]], i16* [[VLA]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK17:       omp_offload.cont:
// CHECK17-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK17:       omp_if.else:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242(%struct.S1* [[THIS1]], i64 [[TMP6]], i64 2, i64 [[TMP2]], i16* [[VLA]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_IF_END]]
// CHECK17:       omp_if.end:
// CHECK17-NEXT:    [[TMP42:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP42]]
// CHECK17-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK17-NEXT:    [[TMP43:%.*]] = load i16, i16* [[ARRAYIDX2]], align 2
// CHECK17-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP43]] to i32
// CHECK17-NEXT:    [[TMP44:%.*]] = load i32, i32* [[B]], align 4
// CHECK17-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], [[TMP44]]
// CHECK17-NEXT:    [[TMP45:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK17-NEXT:    call void @llvm.stackrestore(i8* [[TMP45]])
// CHECK17-NEXT:    ret i32 [[ADD4]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK17-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK17-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK17-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK17-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK17-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK17-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i8, i8* [[AAA]], align 1
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK17-NEXT:    store i8 [[TMP4]], i8* [[CONV2]], align 1
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 50
// CHECK17-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK17:       omp_if.then:
// CHECK17-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK17-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK17-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK17-NEXT:    store i64 [[TMP1]], i64* [[TMP10]], align 8
// CHECK17-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK17-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK17-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK17-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK17-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK17-NEXT:    store i64 [[TMP3]], i64* [[TMP15]], align 8
// CHECK17-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK17-NEXT:    store i8* null, i8** [[TMP16]], align 8
// CHECK17-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i64*
// CHECK17-NEXT:    store i64 [[TMP5]], i64* [[TMP18]], align 8
// CHECK17-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK17-NEXT:    store i64 [[TMP5]], i64* [[TMP20]], align 8
// CHECK17-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK17-NEXT:    store i8* null, i8** [[TMP21]], align 8
// CHECK17-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK17-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to [10 x i32]**
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP23]], align 8
// CHECK17-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK17-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to [10 x i32]**
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP25]], align 8
// CHECK17-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK17-NEXT:    store i8* null, i8** [[TMP26]], align 8
// CHECK17-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP29:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224.region_id, i32 4, i8** [[TMP27]], i8** [[TMP28]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.14, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.15, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK17-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK17-NEXT:    br i1 [[TMP30]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK17:       omp_offload.failed:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK17:       omp_offload.cont:
// CHECK17-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK17:       omp_if.else:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_IF_END]]
// CHECK17:       omp_if.end:
// CHECK17-NEXT:    [[TMP31:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    ret i32 [[TMP31]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK17-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK17-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK17-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 40
// CHECK17-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK17:       omp_if.then:
// CHECK17-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i64*
// CHECK17-NEXT:    store i64 [[TMP1]], i64* [[TMP6]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK17-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK17-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK17-NEXT:    store i8* null, i8** [[TMP9]], align 8
// CHECK17-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK17-NEXT:    store i64 [[TMP3]], i64* [[TMP11]], align 8
// CHECK17-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK17-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK17-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK17-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK17-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [10 x i32]**
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP16]], align 8
// CHECK17-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [10 x i32]**
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP18]], align 8
// CHECK17-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK17-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK17-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.17, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.18, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK17-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK17-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK17:       omp_offload.failed:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK17:       omp_offload.cont:
// CHECK17-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK17:       omp_if.else:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK17-NEXT:    br label [[OMP_IF_END]]
// CHECK17:       omp_if.end:
// CHECK17-NEXT:    [[TMP24:%.*]] = load i32, i32* [[A]], align 4
// CHECK17-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242
// CHECK17-SAME: (%struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR2]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK17-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[CONV3]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i64, i64, i64, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i64 [[TMP5]], i64 [[TMP1]], i64 [[TMP2]], i16* [[TMP3]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR3]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK17-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK17-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK17-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP6]], 3
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK17-NEXT:    store i64 [[TMP8]], i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[CMP3:%.*]] = icmp ule i64 [[TMP9]], [[TMP10]]
// CHECK17-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[MUL:%.*]] = mul i64 [[TMP11]], 400
// CHECK17-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK17-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV4:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK17-NEXT:    [[ADD:%.*]] = fadd double [[CONV4]], 1.500000e+00
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK17-NEXT:    store double [[ADD]], double* [[A]], align 8
// CHECK17-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP13:%.*]] = load double, double* [[A5]], align 8
// CHECK17-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK17-NEXT:    store double [[INC]], double* [[A5]], align 8
// CHECK17-NEXT:    [[CONV6:%.*]] = fptosi double [[INC]] to i16
// CHECK17-NEXT:    [[TMP14:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP14]]
// CHECK17-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK17-NEXT:    store i16 [[CONV6]], i16* [[ARRAYIDX7]], align 2
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[ADD8:%.*]] = add i64 [[TMP15]], 1
// CHECK17-NEXT:    store i64 [[ADD8]], i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224
// CHECK17-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP1]], i32* [[CONV3]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[CONV4:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP3]], i16* [[CONV4]], align 2
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i8, i8* [[CONV2]], align 1
// CHECK17-NEXT:    [[CONV5:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK17-NEXT:    store i8 [[TMP5]], i8* [[CONV5]], align 1
// CHECK17-NEXT:    [[TMP6:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, [10 x i32]*)* @.omp_outlined..13 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], [10 x i32]* [[TMP0]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..13
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207
// CHECK17-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP1]], i32* [[CONV2]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..16 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..16
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK17-NEXT:    store i64 6, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_8(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK17-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[TMP3]], 6
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i64 [ 6, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK17-NEXT:    store i64 [[TMP5]], i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK17-NEXT:    [[CMP2:%.*]] = icmp sle i64 [[TMP6]], [[TMP7]]
// CHECK17-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i64 [[TMP8]], 3
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i64 -10, [[MUL]]
// CHECK17-NEXT:    store i64 [[ADD]], i64* [[I]], align 8
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK17-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4
// CHECK17-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP10]] to i32
// CHECK17-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK17-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK17-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK17-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK17-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX]], align 4
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    [[ADD8:%.*]] = add nsw i64 [[TMP12]], 1
// CHECK17-NEXT:    store i64 [[ADD8]], i64* [[DOTOMP_IV]], align 8
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK17-SAME: () #[[ATTR6]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK17-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@_Z7get_valv
// CHECK19-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    ret i64 0
//
//
// CHECK19-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK19-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK19-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK19-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK19-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK19-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 4
// CHECK19-NEXT:    [[K:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[LIN:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[LIN_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_CASTED2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 4
// CHECK19-NEXT:    [[A_CASTED3:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED4:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS6:%.*]] = alloca [2 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS7:%.*]] = alloca [2 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS8:%.*]] = alloca [2 x i8*], align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_CASTED11:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS14:%.*]] = alloca [10 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS15:%.*]] = alloca [10 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS16:%.*]] = alloca [10 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [10 x i64], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK19-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK19-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK19-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK19-NEXT:    [[VLA:%.*]] = alloca float, i32 [[TMP1]], align 4
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = mul nuw i32 5, [[TMP3]]
// CHECK19-NEXT:    [[VLA1:%.*]] = alloca double, i32 [[TMP4]], align 8
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[__VLA_EXPR1]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103.region_id, i32 0, i8** null, i8** null, i64* null, i64* null, i8** null, i8** null, i32 1, i32 0)
// CHECK19-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK19-NEXT:    br i1 [[TMP6]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK19:       omp_offload.failed:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103() #[[ATTR4:[0-9]+]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK19:       omp_offload.cont:
// CHECK19-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv()
// CHECK19-NEXT:    store i64 [[CALL]], i64* [[K]], align 8
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    store i32 [[TMP7]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l110(i32 [[TMP8]], i64* [[K]]) #[[ATTR4]]
// CHECK19-NEXT:    store i32 12, i32* [[LIN]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i16, i16* [[AA]], align 2
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP9]], i16* [[CONV]], align 2
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[LIN]], align 4
// CHECK19-NEXT:    store i32 [[TMP11]], i32* [[LIN_CASTED]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[LIN_CASTED]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    store i32 [[TMP13]], i32* [[A_CASTED2]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = load i32, i32* [[A_CASTED2]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32*
// CHECK19-NEXT:    store i32 [[TMP10]], i32* [[TMP16]], align 4
// CHECK19-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32*
// CHECK19-NEXT:    store i32 [[TMP10]], i32* [[TMP18]], align 4
// CHECK19-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK19-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK19-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK19-NEXT:    store i32 [[TMP12]], i32* [[TMP21]], align 4
// CHECK19-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32*
// CHECK19-NEXT:    store i32 [[TMP12]], i32* [[TMP23]], align 4
// CHECK19-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK19-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK19-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP26:%.*]] = bitcast i8** [[TMP25]] to i32*
// CHECK19-NEXT:    store i32 [[TMP14]], i32* [[TMP26]], align 4
// CHECK19-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to i32*
// CHECK19-NEXT:    store i32 [[TMP14]], i32* [[TMP28]], align 4
// CHECK19-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK19-NEXT:    store i8* null, i8** [[TMP29]], align 4
// CHECK19-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP33:%.*]] = load i16, i16* [[AA]], align 2
// CHECK19-NEXT:    store i16 [[TMP33]], i16* [[TMP32]], align 4
// CHECK19-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP35:%.*]] = load i32, i32* [[LIN]], align 4
// CHECK19-NEXT:    store i32 [[TMP35]], i32* [[TMP34]], align 4
// CHECK19-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP37:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    store i32 [[TMP37]], i32* [[TMP36]], align 4
// CHECK19-NEXT:    [[TMP38:%.*]] = call i8* @__kmpc_omp_target_task_alloc(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 1, i32 72, i32 12, i32 (i32, i8*)* bitcast (i32 (i32, %struct.kmp_task_t_with_privates*)* @.omp_task_entry. to i32 (i32, i8*)*), i64 -1)
// CHECK19-NEXT:    [[TMP39:%.*]] = bitcast i8* [[TMP38]] to %struct.kmp_task_t_with_privates*
// CHECK19-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP39]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP40]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[TMP41]], align 4
// CHECK19-NEXT:    [[TMP43:%.*]] = bitcast %struct.anon* [[AGG_CAPTURED]] to i8*
// CHECK19-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP42]], i8* align 4 [[TMP43]], i32 12, i1 false)
// CHECK19-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP39]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP45:%.*]] = bitcast i8* [[TMP42]] to %struct.anon*
// CHECK19-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP47:%.*]] = bitcast [3 x i64]* [[TMP46]] to i8*
// CHECK19-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP47]], i8* align 4 bitcast ([3 x i64]* @.offload_sizes to i8*), i32 24, i1 false)
// CHECK19-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP49:%.*]] = bitcast [3 x i8*]* [[TMP48]] to i8*
// CHECK19-NEXT:    [[TMP50:%.*]] = bitcast i8** [[TMP30]] to i8*
// CHECK19-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP49]], i8* align 4 [[TMP50]], i32 12, i1 false)
// CHECK19-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP52:%.*]] = bitcast [3 x i8*]* [[TMP51]] to i8*
// CHECK19-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP31]] to i8*
// CHECK19-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP52]], i8* align 4 [[TMP53]], i32 12, i1 false)
// CHECK19-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 3
// CHECK19-NEXT:    [[TMP55:%.*]] = load i16, i16* [[AA]], align 2
// CHECK19-NEXT:    store i16 [[TMP55]], i16* [[TMP54]], align 4
// CHECK19-NEXT:    [[TMP56:%.*]] = call i32 @__kmpc_omp_task(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i8* [[TMP38]])
// CHECK19-NEXT:    [[TMP57:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    store i32 [[TMP57]], i32* [[A_CASTED3]], align 4
// CHECK19-NEXT:    [[TMP58:%.*]] = load i32, i32* [[A_CASTED3]], align 4
// CHECK19-NEXT:    [[TMP59:%.*]] = load i16, i16* [[AA]], align 2
// CHECK19-NEXT:    [[CONV5:%.*]] = bitcast i32* [[AA_CASTED4]] to i16*
// CHECK19-NEXT:    store i16 [[TMP59]], i16* [[CONV5]], align 2
// CHECK19-NEXT:    [[TMP60:%.*]] = load i32, i32* [[AA_CASTED4]], align 4
// CHECK19-NEXT:    [[TMP61:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP61]], 10
// CHECK19-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK19:       omp_if.then:
// CHECK19-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP63:%.*]] = bitcast i8** [[TMP62]] to i32*
// CHECK19-NEXT:    store i32 [[TMP58]], i32* [[TMP63]], align 4
// CHECK19-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i32*
// CHECK19-NEXT:    store i32 [[TMP58]], i32* [[TMP65]], align 4
// CHECK19-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS8]], i32 0, i32 0
// CHECK19-NEXT:    store i8* null, i8** [[TMP66]], align 4
// CHECK19-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP68:%.*]] = bitcast i8** [[TMP67]] to i32*
// CHECK19-NEXT:    store i32 [[TMP60]], i32* [[TMP68]], align 4
// CHECK19-NEXT:    [[TMP69:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP70:%.*]] = bitcast i8** [[TMP69]] to i32*
// CHECK19-NEXT:    store i32 [[TMP60]], i32* [[TMP70]], align 4
// CHECK19-NEXT:    [[TMP71:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS8]], i32 0, i32 1
// CHECK19-NEXT:    store i8* null, i8** [[TMP71]], align 4
// CHECK19-NEXT:    [[TMP72:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP74:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146.region_id, i32 2, i8** [[TMP72]], i8** [[TMP73]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.5, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.6, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK19-NEXT:    [[TMP75:%.*]] = icmp ne i32 [[TMP74]], 0
// CHECK19-NEXT:    br i1 [[TMP75]], label [[OMP_OFFLOAD_FAILED9:%.*]], label [[OMP_OFFLOAD_CONT10:%.*]]
// CHECK19:       omp_offload.failed9:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146(i32 [[TMP58]], i32 [[TMP60]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT10]]
// CHECK19:       omp_offload.cont10:
// CHECK19-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK19:       omp_if.else:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146(i32 [[TMP58]], i32 [[TMP60]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_IF_END]]
// CHECK19:       omp_if.end:
// CHECK19-NEXT:    [[TMP76:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    store i32 [[TMP76]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK19-NEXT:    [[TMP77:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    store i32 [[TMP77]], i32* [[A_CASTED11]], align 4
// CHECK19-NEXT:    [[TMP78:%.*]] = load i32, i32* [[A_CASTED11]], align 4
// CHECK19-NEXT:    [[TMP79:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK19-NEXT:    store i32 [[TMP79]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK19-NEXT:    [[TMP80:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK19-NEXT:    [[TMP81:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CMP12:%.*]] = icmp sgt i32 [[TMP81]], 20
// CHECK19-NEXT:    br i1 [[CMP12]], label [[OMP_IF_THEN13:%.*]], label [[OMP_IF_ELSE19:%.*]]
// CHECK19:       omp_if.then13:
// CHECK19-NEXT:    [[TMP82:%.*]] = mul nuw i32 [[TMP1]], 4
// CHECK19-NEXT:    [[TMP83:%.*]] = sext i32 [[TMP82]] to i64
// CHECK19-NEXT:    [[TMP84:%.*]] = mul nuw i32 5, [[TMP3]]
// CHECK19-NEXT:    [[TMP85:%.*]] = mul nuw i32 [[TMP84]], 8
// CHECK19-NEXT:    [[TMP86:%.*]] = sext i32 [[TMP85]] to i64
// CHECK19-NEXT:    [[TMP87:%.*]] = bitcast [10 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK19-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP87]], i8* align 4 bitcast ([10 x i64]* @.offload_sizes.8 to i8*), i32 80, i1 false)
// CHECK19-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP89:%.*]] = bitcast i8** [[TMP88]] to i32*
// CHECK19-NEXT:    store i32 [[TMP78]], i32* [[TMP89]], align 4
// CHECK19-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to i32*
// CHECK19-NEXT:    store i32 [[TMP78]], i32* [[TMP91]], align 4
// CHECK19-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 0
// CHECK19-NEXT:    store i8* null, i8** [[TMP92]], align 4
// CHECK19-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP94:%.*]] = bitcast i8** [[TMP93]] to [10 x float]**
// CHECK19-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP94]], align 4
// CHECK19-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP96:%.*]] = bitcast i8** [[TMP95]] to [10 x float]**
// CHECK19-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP96]], align 4
// CHECK19-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 1
// CHECK19-NEXT:    store i8* null, i8** [[TMP97]], align 4
// CHECK19-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP99:%.*]] = bitcast i8** [[TMP98]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP99]], align 4
// CHECK19-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP101:%.*]] = bitcast i8** [[TMP100]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP101]], align 4
// CHECK19-NEXT:    [[TMP102:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 2
// CHECK19-NEXT:    store i8* null, i8** [[TMP102]], align 4
// CHECK19-NEXT:    [[TMP103:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 3
// CHECK19-NEXT:    [[TMP104:%.*]] = bitcast i8** [[TMP103]] to float**
// CHECK19-NEXT:    store float* [[VLA]], float** [[TMP104]], align 4
// CHECK19-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 3
// CHECK19-NEXT:    [[TMP106:%.*]] = bitcast i8** [[TMP105]] to float**
// CHECK19-NEXT:    store float* [[VLA]], float** [[TMP106]], align 4
// CHECK19-NEXT:    [[TMP107:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK19-NEXT:    store i64 [[TMP83]], i64* [[TMP107]], align 4
// CHECK19-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 3
// CHECK19-NEXT:    store i8* null, i8** [[TMP108]], align 4
// CHECK19-NEXT:    [[TMP109:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 4
// CHECK19-NEXT:    [[TMP110:%.*]] = bitcast i8** [[TMP109]] to [5 x [10 x double]]**
// CHECK19-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP110]], align 4
// CHECK19-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 4
// CHECK19-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to [5 x [10 x double]]**
// CHECK19-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP112]], align 4
// CHECK19-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 4
// CHECK19-NEXT:    store i8* null, i8** [[TMP113]], align 4
// CHECK19-NEXT:    [[TMP114:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 5
// CHECK19-NEXT:    [[TMP115:%.*]] = bitcast i8** [[TMP114]] to i32*
// CHECK19-NEXT:    store i32 5, i32* [[TMP115]], align 4
// CHECK19-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 5
// CHECK19-NEXT:    [[TMP117:%.*]] = bitcast i8** [[TMP116]] to i32*
// CHECK19-NEXT:    store i32 5, i32* [[TMP117]], align 4
// CHECK19-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 5
// CHECK19-NEXT:    store i8* null, i8** [[TMP118]], align 4
// CHECK19-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 6
// CHECK19-NEXT:    [[TMP120:%.*]] = bitcast i8** [[TMP119]] to i32*
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[TMP120]], align 4
// CHECK19-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 6
// CHECK19-NEXT:    [[TMP122:%.*]] = bitcast i8** [[TMP121]] to i32*
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[TMP122]], align 4
// CHECK19-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 6
// CHECK19-NEXT:    store i8* null, i8** [[TMP123]], align 4
// CHECK19-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 7
// CHECK19-NEXT:    [[TMP125:%.*]] = bitcast i8** [[TMP124]] to double**
// CHECK19-NEXT:    store double* [[VLA1]], double** [[TMP125]], align 4
// CHECK19-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 7
// CHECK19-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to double**
// CHECK19-NEXT:    store double* [[VLA1]], double** [[TMP127]], align 4
// CHECK19-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK19-NEXT:    store i64 [[TMP86]], i64* [[TMP128]], align 4
// CHECK19-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 7
// CHECK19-NEXT:    store i8* null, i8** [[TMP129]], align 4
// CHECK19-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 8
// CHECK19-NEXT:    [[TMP131:%.*]] = bitcast i8** [[TMP130]] to %struct.TT**
// CHECK19-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP131]], align 4
// CHECK19-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 8
// CHECK19-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to %struct.TT**
// CHECK19-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP133]], align 4
// CHECK19-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 8
// CHECK19-NEXT:    store i8* null, i8** [[TMP134]], align 4
// CHECK19-NEXT:    [[TMP135:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 9
// CHECK19-NEXT:    [[TMP136:%.*]] = bitcast i8** [[TMP135]] to i32*
// CHECK19-NEXT:    store i32 [[TMP80]], i32* [[TMP136]], align 4
// CHECK19-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 9
// CHECK19-NEXT:    [[TMP138:%.*]] = bitcast i8** [[TMP137]] to i32*
// CHECK19-NEXT:    store i32 [[TMP80]], i32* [[TMP138]], align 4
// CHECK19-NEXT:    [[TMP139:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_MAPPERS16]], i32 0, i32 9
// CHECK19-NEXT:    store i8* null, i8** [[TMP139]], align 4
// CHECK19-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_BASEPTRS14]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [10 x i8*], [10 x i8*]* [[DOTOFFLOAD_PTRS15]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [10 x i64], [10 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP143:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170.region_id, i32 10, i8** [[TMP140]], i8** [[TMP141]], i64* [[TMP142]], i64* getelementptr inbounds ([10 x i64], [10 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK19-NEXT:    [[TMP144:%.*]] = icmp ne i32 [[TMP143]], 0
// CHECK19-NEXT:    br i1 [[TMP144]], label [[OMP_OFFLOAD_FAILED17:%.*]], label [[OMP_OFFLOAD_CONT18:%.*]]
// CHECK19:       omp_offload.failed17:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170(i32 [[TMP78]], [10 x float]* [[B]], i32 [[TMP1]], float* [[VLA]], [5 x [10 x double]]* [[C]], i32 5, i32 [[TMP3]], double* [[VLA1]], %struct.TT* [[D]], i32 [[TMP80]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT18]]
// CHECK19:       omp_offload.cont18:
// CHECK19-NEXT:    br label [[OMP_IF_END20:%.*]]
// CHECK19:       omp_if.else19:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170(i32 [[TMP78]], [10 x float]* [[B]], i32 [[TMP1]], float* [[VLA]], [5 x [10 x double]]* [[C]], i32 5, i32 [[TMP3]], double* [[VLA1]], %struct.TT* [[D]], i32 [[TMP80]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_IF_END20]]
// CHECK19:       omp_if.end20:
// CHECK19-NEXT:    [[TMP145:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    [[TMP146:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK19-NEXT:    call void @llvm.stackrestore(i8* [[TMP146]])
// CHECK19-NEXT:    ret i32 [[TMP145]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l103
// CHECK19-SAME: () #[[ATTR2:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 0, void (i32*, i32*, ...)* bitcast (void (i32*, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*))
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 5, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 5
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 5, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 5
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 3, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_cancel(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK19-NEXT:    [[TMP9:%.*]] = icmp ne i32 [[TMP8]], 0
// CHECK19-NEXT:    br i1 [[TMP9]], label [[DOTCANCEL_EXIT:%.*]], label [[DOTCANCEL_CONTINUE:%.*]]
// CHECK19:       .cancel.exit:
// CHECK19-NEXT:    br label [[CANCEL_EXIT:%.*]]
// CHECK19:       .cancel.continue:
// CHECK19-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_cancellationpoint(%struct.ident_t* @[[GLOB2]], i32 [[TMP1]], i32 2)
// CHECK19-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK19-NEXT:    br i1 [[TMP11]], label [[DOTCANCEL_EXIT2:%.*]], label [[DOTCANCEL_CONTINUE3:%.*]]
// CHECK19:       .cancel.exit2:
// CHECK19-NEXT:    br label [[CANCEL_EXIT]]
// CHECK19:       .cancel.continue3:
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK19-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK19-NEXT:    br label [[CANCEL_CONT:%.*]]
// CHECK19:       cancel.cont:
// CHECK19-NEXT:    ret void
// CHECK19:       cancel.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK19-NEXT:    br label [[CANCEL_CONT]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l110
// CHECK19-SAME: (i32 noundef [[A:%.*]], i64* noundef nonnull align 4 dereferenceable(8) [[K:%.*]]) #[[ATTR3]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[K_ADDR:%.*]] = alloca i64*, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i64* [[K]], i64** [[K_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i64*, i64** [[K_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i64*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP2]], i64* [[TMP0]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i64* noundef nonnull align 4 dereferenceable(8) [[K:%.*]]) #[[ATTR3]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[K_ADDR:%.*]] = alloca i64*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[K1:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i64* [[K]], i64** [[K_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i64*, i64** [[K_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TMP0]], align 8
// CHECK19-NEXT:    store i64 [[TMP1]], i64* [[DOTLINEAR_START]], align 8
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 8, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK19-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 [[TMP3]])
// CHECK19-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP3]], i32 1073741859, i32 0, i32 8, i32 1, i32 1)
// CHECK19-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK19:       omp.dispatch.cond:
// CHECK19-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP3]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK19-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK19-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK19:       omp.dispatch.body:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK19-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK19-NEXT:    [[SUB:%.*]] = sub nsw i32 10, [[MUL]]
// CHECK19-NEXT:    store i32 [[SUB]], i32* [[I]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTLINEAR_START]], align 8, !llvm.access.group !13
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    [[MUL2:%.*]] = mul nsw i32 [[TMP10]], 3
// CHECK19-NEXT:    [[CONV:%.*]] = sext i32 [[MUL2]] to i64
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i64 [[TMP9]], [[CONV]]
// CHECK19-NEXT:    store i64 [[ADD]], i64* [[K1]], align 8, !llvm.access.group !13
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK19-NEXT:    store i32 [[ADD3]], i32* [[A_ADDR]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK19-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK19:       omp.dispatch.inc:
// CHECK19-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK19:       omp.dispatch.end:
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK19-NEXT:    br i1 [[TMP14]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK19:       .omp.linear.pu:
// CHECK19-NEXT:    [[TMP15:%.*]] = load i64, i64* [[K1]], align 8
// CHECK19-NEXT:    store i64 [[TMP15]], i64* [[TMP0]], align 8
// CHECK19-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK19:       .omp.linear.pu.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138
// CHECK19-SAME: (i32 noundef [[AA:%.*]], i32 noundef [[LIN:%.*]], i32 noundef [[A:%.*]]) #[[ATTR2]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[LIN_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[LIN_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[LIN]], i32* [[LIN_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[LIN_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP2]], i32* [[LIN_CASTED]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[LIN_CASTED]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[LIN:%.*]], i32 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[LIN_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK19-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTLINEAR_START1:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTLINEAR_STEP:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[LIN2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A3:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[LIN]], i32* [[LIN_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, i32* [[LIN_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP0]], i32* [[DOTLINEAR_START]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[DOTLINEAR_START1]], align 4
// CHECK19-NEXT:    [[CALL:%.*]] = call noundef i64 @_Z7get_valv()
// CHECK19-NEXT:    store i64 [[CALL]], i64* [[DOTLINEAR_STEP]], align 8
// CHECK19-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK19-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP2]], align 4
// CHECK19-NEXT:    call void @__kmpc_barrier(%struct.ident_t* @[[GLOB3]], i32 [[TMP3]])
// CHECK19-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK19-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP4]], 3
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK19-NEXT:    store i64 [[TMP6]], i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[CMP4:%.*]] = icmp ule i64 [[TMP7]], [[TMP8]]
// CHECK19-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[MUL:%.*]] = mul i64 [[TMP9]], 400
// CHECK19-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK19-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTLINEAR_START]], align 4
// CHECK19-NEXT:    [[CONV5:%.*]] = sext i32 [[TMP10]] to i64
// CHECK19-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK19-NEXT:    [[MUL6:%.*]] = mul i64 [[TMP11]], [[TMP12]]
// CHECK19-NEXT:    [[ADD:%.*]] = add i64 [[CONV5]], [[MUL6]]
// CHECK19-NEXT:    [[CONV7:%.*]] = trunc i64 [[ADD]] to i32
// CHECK19-NEXT:    store i32 [[CONV7]], i32* [[LIN2]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTLINEAR_START1]], align 4
// CHECK19-NEXT:    [[CONV8:%.*]] = sext i32 [[TMP13]] to i64
// CHECK19-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTLINEAR_STEP]], align 8
// CHECK19-NEXT:    [[MUL9:%.*]] = mul i64 [[TMP14]], [[TMP15]]
// CHECK19-NEXT:    [[ADD10:%.*]] = add i64 [[CONV8]], [[MUL9]]
// CHECK19-NEXT:    [[CONV11:%.*]] = trunc i64 [[ADD10]] to i32
// CHECK19-NEXT:    store i32 [[CONV11]], i32* [[A3]], align 4
// CHECK19-NEXT:    [[TMP16:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP16]] to i32
// CHECK19-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK19-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i16
// CHECK19-NEXT:    store i16 [[CONV14]], i16* [[CONV]], align 2
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP17:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[ADD15:%.*]] = add i64 [[TMP17]], 1
// CHECK19-NEXT:    store i64 [[ADD15]], i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP3]])
// CHECK19-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP19:%.*]] = icmp ne i32 [[TMP18]], 0
// CHECK19-NEXT:    br i1 [[TMP19]], label [[DOTOMP_LINEAR_PU:%.*]], label [[DOTOMP_LINEAR_PU_DONE:%.*]]
// CHECK19:       .omp.linear.pu:
// CHECK19-NEXT:    [[TMP20:%.*]] = load i32, i32* [[LIN2]], align 4
// CHECK19-NEXT:    store i32 [[TMP20]], i32* [[LIN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A3]], align 4
// CHECK19-NEXT:    store i32 [[TMP21]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_LINEAR_PU_DONE]]
// CHECK19:       .omp.linear.pu.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK19-SAME: (%struct..kmp_privates.t* noalias noundef [[TMP0:%.*]], i16** noalias noundef [[TMP1:%.*]], [3 x i8*]** noalias noundef [[TMP2:%.*]], [3 x i8*]** noalias noundef [[TMP3:%.*]], [3 x i64]** noalias noundef [[TMP4:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTADDR:%.*]] = alloca %struct..kmp_privates.t*, align 4
// CHECK19-NEXT:    [[DOTADDR1:%.*]] = alloca i16**, align 4
// CHECK19-NEXT:    [[DOTADDR2:%.*]] = alloca [3 x i8*]**, align 4
// CHECK19-NEXT:    [[DOTADDR3:%.*]] = alloca [3 x i8*]**, align 4
// CHECK19-NEXT:    [[DOTADDR4:%.*]] = alloca [3 x i64]**, align 4
// CHECK19-NEXT:    store %struct..kmp_privates.t* [[TMP0]], %struct..kmp_privates.t** [[DOTADDR]], align 4
// CHECK19-NEXT:    store i16** [[TMP1]], i16*** [[DOTADDR1]], align 4
// CHECK19-NEXT:    store [3 x i8*]** [[TMP2]], [3 x i8*]*** [[DOTADDR2]], align 4
// CHECK19-NEXT:    store [3 x i8*]** [[TMP3]], [3 x i8*]*** [[DOTADDR3]], align 4
// CHECK19-NEXT:    store [3 x i64]** [[TMP4]], [3 x i64]*** [[DOTADDR4]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load %struct..kmp_privates.t*, %struct..kmp_privates.t** [[DOTADDR]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP7:%.*]] = load [3 x i64]**, [3 x i64]*** [[DOTADDR4]], align 4
// CHECK19-NEXT:    store [3 x i64]* [[TMP6]], [3 x i64]** [[TMP7]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP9:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR2]], align 4
// CHECK19-NEXT:    store [3 x i8*]* [[TMP8]], [3 x i8*]** [[TMP9]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP11:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR3]], align 4
// CHECK19-NEXT:    store [3 x i8*]* [[TMP10]], [3 x i8*]** [[TMP11]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 3
// CHECK19-NEXT:    [[TMP13:%.*]] = load i16**, i16*** [[DOTADDR1]], align 4
// CHECK19-NEXT:    store i16* [[TMP12]], i16** [[TMP13]], align 4
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK19-SAME: (i32 noundef [[TMP0:%.*]], %struct.kmp_task_t_with_privates* noalias noundef [[TMP1:%.*]]) #[[ATTR7:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca i8*, align 4
// CHECK19-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca void (i8*, ...)*, align 4
// CHECK19-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca i8*, align 4
// CHECK19-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca %struct.anon*, align 4
// CHECK19-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca i16*, align 4
// CHECK19-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca [3 x i8*]*, align 4
// CHECK19-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca [3 x i8*]*, align 4
// CHECK19-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca [3 x i64]*, align 4
// CHECK19-NEXT:    [[AA_CASTED_I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[LIN_CASTED_I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_CASTED_I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTADDR1:%.*]] = alloca %struct.kmp_task_t_with_privates*, align 4
// CHECK19-NEXT:    store i32 [[TMP0]], i32* [[DOTADDR]], align 4
// CHECK19-NEXT:    store %struct.kmp_task_t_with_privates* [[TMP1]], %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load %struct.kmp_task_t_with_privates*, %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP7:%.*]] = load i8*, i8** [[TMP6]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = bitcast i8* [[TMP7]] to %struct.anon*
// CHECK19-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP10:%.*]] = bitcast %struct..kmp_privates.t* [[TMP9]] to i8*
// CHECK19-NEXT:    [[TMP11:%.*]] = bitcast %struct.kmp_task_t_with_privates* [[TMP3]] to i8*
// CHECK19-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META16:![0-9]+]])
// CHECK19-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META19:![0-9]+]])
// CHECK19-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META21:![0-9]+]])
// CHECK19-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META23:![0-9]+]])
// CHECK19-NEXT:    store i32 [[TMP2]], i32* [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    store i32* [[TMP5]], i32** [[DOTPART_ID__ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    store i8* [[TMP10]], i8** [[DOTPRIVATES__ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    store void (i8*, ...)* bitcast (void (%struct..kmp_privates.t*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)* @.omp_task_privates_map. to void (i8*, ...)*), void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    store i8* [[TMP11]], i8** [[DOTTASK_T__ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    store %struct.anon* [[TMP8]], %struct.anon** [[__CONTEXT_ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP12:%.*]] = load %struct.anon*, %struct.anon** [[__CONTEXT_ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP13:%.*]] = load void (i8*, ...)*, void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[DOTPRIVATES__ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP15:%.*]] = bitcast void (i8*, ...)* [[TMP13]] to void (i8*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)*
// CHECK19-NEXT:    call void [[TMP15]](i8* [[TMP14]], i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK19-NEXT:    [[TMP16:%.*]] = load i16*, i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP17:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP18:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP19:%.*]] = load [3 x i64]*, [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP17]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP18]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[TMP19]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], %struct.anon* [[TMP12]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[TMP12]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP25:%.*]] = call i32 @__tgt_target_teams_nowait_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* [[TMP22]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0, i32 0, i8* null, i32 0, i8* null) #[[ATTR4]]
// CHECK19-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK19-NEXT:    br i1 [[TMP26]], label [[OMP_OFFLOAD_FAILED_I:%.*]], label [[DOTOMP_OUTLINED__3_EXIT:%.*]]
// CHECK19:       omp_offload.failed.i:
// CHECK19-NEXT:    [[TMP27:%.*]] = load i16, i16* [[TMP16]], align 2
// CHECK19-NEXT:    [[CONV_I:%.*]] = bitcast i32* [[AA_CASTED_I]] to i16*
// CHECK19-NEXT:    store i16 [[TMP27]], i16* [[CONV_I]], align 2, !noalias !25
// CHECK19-NEXT:    [[TMP28:%.*]] = load i32, i32* [[AA_CASTED_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP29:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK19-NEXT:    store i32 [[TMP29]], i32* [[LIN_CASTED_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP30:%.*]] = load i32, i32* [[LIN_CASTED_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP31:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK19-NEXT:    store i32 [[TMP31]], i32* [[A_CASTED_I]], align 4, !noalias !25
// CHECK19-NEXT:    [[TMP32:%.*]] = load i32, i32* [[A_CASTED_I]], align 4, !noalias !25
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l138(i32 [[TMP28]], i32 [[TMP30]], i32 [[TMP32]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[DOTOMP_OUTLINED__3_EXIT]]
// CHECK19:       .omp_outlined..3.exit:
// CHECK19-NEXT:    ret i32 0
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l146
// CHECK19-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i16, align 2
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[IT:%.*]] = alloca i16, align 2
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 3, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 3
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 3, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 4
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 6, [[MUL]]
// CHECK19-NEXT:    [[CONV2:%.*]] = trunc i32 [[ADD]] to i16
// CHECK19-NEXT:    store i16 [[CONV2]], i16* [[IT]], align 2
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK19-NEXT:    store i32 [[ADD3]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP9]] to i32
// CHECK19-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK19-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK19-NEXT:    store i16 [[CONV6]], i16* [[CONV]], align 2
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK19-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l170
// CHECK19-SAME: (i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK19-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK19-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK19-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK19-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK19-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP8]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP10]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 10, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, [10 x float]*, i32, float*, [5 x [10 x double]]*, i32, i32, double*, %struct.TT*, i32)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i32 [[TMP9]], [10 x float]* [[TMP0]], i32 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i32 [[TMP4]], i32 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]], i32 [[TMP11]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR3]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK19-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK19-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i8, align 1
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[IT:%.*]] = alloca i8, align 1
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK19-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK19-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK19-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 25, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP8]])
// CHECK19-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK19:       omp.dispatch.cond:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP11]], 25
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 25, [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK19-NEXT:    br i1 [[CMP5]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK19:       omp.dispatch.body:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// CHECK19-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP18]], 1
// CHECK19-NEXT:    [[SUB:%.*]] = sub nsw i32 122, [[MUL]]
// CHECK19-NEXT:    [[CONV:%.*]] = trunc i32 [[SUB]] to i8
// CHECK19-NEXT:    store i8 [[CONV]], i8* [[IT]], align 1
// CHECK19-NEXT:    [[TMP19:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP20:%.*]] = load float, float* [[ARRAYIDX]], align 4
// CHECK19-NEXT:    [[CONV7:%.*]] = fpext float [[TMP20]] to double
// CHECK19-NEXT:    [[ADD8:%.*]] = fadd double [[CONV7]], 1.000000e+00
// CHECK19-NEXT:    [[CONV9:%.*]] = fptrunc double [[ADD8]] to float
// CHECK19-NEXT:    store float [[CONV9]], float* [[ARRAYIDX]], align 4
// CHECK19-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP2]], i32 3
// CHECK19-NEXT:    [[TMP21:%.*]] = load float, float* [[ARRAYIDX10]], align 4
// CHECK19-NEXT:    [[CONV11:%.*]] = fpext float [[TMP21]] to double
// CHECK19-NEXT:    [[ADD12:%.*]] = fadd double [[CONV11]], 1.000000e+00
// CHECK19-NEXT:    [[CONV13:%.*]] = fptrunc double [[ADD12]] to float
// CHECK19-NEXT:    store float [[CONV13]], float* [[ARRAYIDX10]], align 4
// CHECK19-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i32 0, i32 1
// CHECK19-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX14]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX15]], align 8
// CHECK19-NEXT:    [[ADD16:%.*]] = fadd double [[TMP22]], 1.000000e+00
// CHECK19-NEXT:    store double [[ADD16]], double* [[ARRAYIDX15]], align 8
// CHECK19-NEXT:    [[TMP23:%.*]] = mul nsw i32 1, [[TMP5]]
// CHECK19-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[TMP6]], i32 [[TMP23]]
// CHECK19-NEXT:    [[ARRAYIDX18:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX17]], i32 3
// CHECK19-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX18]], align 8
// CHECK19-NEXT:    [[ADD19:%.*]] = fadd double [[TMP24]], 1.000000e+00
// CHECK19-NEXT:    store double [[ADD19]], double* [[ARRAYIDX18]], align 8
// CHECK19-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP25:%.*]] = load i64, i64* [[X]], align 4
// CHECK19-NEXT:    [[ADD20:%.*]] = add nsw i64 [[TMP25]], 1
// CHECK19-NEXT:    store i64 [[ADD20]], i64* [[X]], align 4
// CHECK19-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP26:%.*]] = load i8, i8* [[Y]], align 4
// CHECK19-NEXT:    [[CONV21:%.*]] = sext i8 [[TMP26]] to i32
// CHECK19-NEXT:    [[ADD22:%.*]] = add nsw i32 [[CONV21]], 1
// CHECK19-NEXT:    [[CONV23:%.*]] = trunc i32 [[ADD22]] to i8
// CHECK19-NEXT:    store i8 [[CONV23]], i8* [[Y]], align 4
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP27]], 1
// CHECK19-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK19:       omp.dispatch.inc:
// CHECK19-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    [[ADD25:%.*]] = add nsw i32 [[TMP28]], [[TMP29]]
// CHECK19-NEXT:    store i32 [[ADD25]], i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP30]], [[TMP31]]
// CHECK19-NEXT:    store i32 [[ADD26]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK19:       omp.dispatch.end:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@_Z3bari
// CHECK19-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 4
// CHECK19-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP0]])
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CALL1:%.*]] = call noundef i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 4 dereferenceable(8) [[S]], i32 noundef [[TMP2]])
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK19-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CALL3:%.*]] = call noundef i32 @_ZL7fstatici(i32 noundef [[TMP4]])
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK19-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CALL5:%.*]] = call noundef i32 @_Z9ftemplateIiET_i(i32 noundef [[TMP6]])
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK19-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK19-SAME: (%struct.S1* noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK19-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK19-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [5 x i64], align 4
// CHECK19-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK19-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK19-NEXT:    [[VLA:%.*]] = alloca i16, i32 [[TMP3]], align 2
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 60
// CHECK19-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK19:       omp_if.then:
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP7:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK19-NEXT:    [[TMP8:%.*]] = mul nuw i32 [[TMP7]], 2
// CHECK19-NEXT:    [[TMP9:%.*]] = sext i32 [[TMP8]] to i64
// CHECK19-NEXT:    [[TMP10:%.*]] = bitcast [5 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK19-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP10]], i8* align 4 bitcast ([5 x i64]* @.offload_sizes.11 to i8*), i32 40, i1 false)
// CHECK19-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to %struct.S1**
// CHECK19-NEXT:    store %struct.S1* [[THIS1]], %struct.S1** [[TMP12]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to double**
// CHECK19-NEXT:    store double* [[A]], double** [[TMP14]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK19-NEXT:    store i8* null, i8** [[TMP15]], align 4
// CHECK19-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK19-NEXT:    store i32 [[TMP5]], i32* [[TMP17]], align 4
// CHECK19-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32*
// CHECK19-NEXT:    store i32 [[TMP5]], i32* [[TMP19]], align 4
// CHECK19-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK19-NEXT:    store i8* null, i8** [[TMP20]], align 4
// CHECK19-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32*
// CHECK19-NEXT:    store i32 2, i32* [[TMP22]], align 4
// CHECK19-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32*
// CHECK19-NEXT:    store i32 2, i32* [[TMP24]], align 4
// CHECK19-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK19-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK19-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK19-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP27]], align 4
// CHECK19-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK19-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP29]], align 4
// CHECK19-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK19-NEXT:    store i8* null, i8** [[TMP30]], align 4
// CHECK19-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK19-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i16**
// CHECK19-NEXT:    store i16* [[VLA]], i16** [[TMP32]], align 4
// CHECK19-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK19-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i16**
// CHECK19-NEXT:    store i16* [[VLA]], i16** [[TMP34]], align 4
// CHECK19-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK19-NEXT:    store i64 [[TMP9]], i64* [[TMP35]], align 4
// CHECK19-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK19-NEXT:    store i8* null, i8** [[TMP36]], align 4
// CHECK19-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP40:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242.region_id, i32 5, i8** [[TMP37]], i8** [[TMP38]], i64* [[TMP39]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.12, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK19-NEXT:    [[TMP41:%.*]] = icmp ne i32 [[TMP40]], 0
// CHECK19-NEXT:    br i1 [[TMP41]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK19:       omp_offload.failed:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242(%struct.S1* [[THIS1]], i32 [[TMP5]], i32 2, i32 [[TMP1]], i16* [[VLA]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK19:       omp_offload.cont:
// CHECK19-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK19:       omp_if.else:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242(%struct.S1* [[THIS1]], i32 [[TMP5]], i32 2, i32 [[TMP1]], i16* [[VLA]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_IF_END]]
// CHECK19:       omp_if.end:
// CHECK19-NEXT:    [[TMP42:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP42]]
// CHECK19-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK19-NEXT:    [[TMP43:%.*]] = load i16, i16* [[ARRAYIDX2]], align 2
// CHECK19-NEXT:    [[CONV:%.*]] = sext i16 [[TMP43]] to i32
// CHECK19-NEXT:    [[TMP44:%.*]] = load i32, i32* [[B]], align 4
// CHECK19-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV]], [[TMP44]]
// CHECK19-NEXT:    [[TMP45:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK19-NEXT:    call void @llvm.stackrestore(i8* [[TMP45]])
// CHECK19-NEXT:    ret i32 [[ADD3]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK19-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK19-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK19-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK19-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK19-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK19-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP2]], i16* [[CONV]], align 2
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i8, i8* [[AAA]], align 1
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK19-NEXT:    store i8 [[TMP4]], i8* [[CONV1]], align 1
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 50
// CHECK19-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK19:       omp_if.then:
// CHECK19-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP10]], align 4
// CHECK19-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK19-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[TMP15]], align 4
// CHECK19-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK19-NEXT:    store i8* null, i8** [[TMP16]], align 4
// CHECK19-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32*
// CHECK19-NEXT:    store i32 [[TMP5]], i32* [[TMP18]], align 4
// CHECK19-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i32*
// CHECK19-NEXT:    store i32 [[TMP5]], i32* [[TMP20]], align 4
// CHECK19-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK19-NEXT:    store i8* null, i8** [[TMP21]], align 4
// CHECK19-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK19-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to [10 x i32]**
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP23]], align 4
// CHECK19-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK19-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to [10 x i32]**
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP25]], align 4
// CHECK19-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK19-NEXT:    store i8* null, i8** [[TMP26]], align 4
// CHECK19-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP29:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224.region_id, i32 4, i8** [[TMP27]], i8** [[TMP28]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.14, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.15, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK19-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK19-NEXT:    br i1 [[TMP30]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK19:       omp_offload.failed:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224(i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK19:       omp_offload.cont:
// CHECK19-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK19:       omp_if.else:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224(i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_IF_END]]
// CHECK19:       omp_if.end:
// CHECK19-NEXT:    [[TMP31:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    ret i32 [[TMP31]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK19-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK19-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK19-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP2]], i16* [[CONV]], align 2
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 40
// CHECK19-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK19:       omp_if.then:
// CHECK19-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP6]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK19-NEXT:    store i8* null, i8** [[TMP9]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[TMP11]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK19-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [10 x i32]**
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP16]], align 4
// CHECK19-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [10 x i32]**
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP18]], align 4
// CHECK19-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK19-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK19-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.17, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.18, i32 0, i32 0), i8** null, i8** null, i32 1, i32 0)
// CHECK19-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK19-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK19:       omp_offload.failed:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK19:       omp_offload.cont:
// CHECK19-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK19:       omp_if.else:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK19-NEXT:    br label [[OMP_IF_END]]
// CHECK19:       omp_if.end:
// CHECK19-NEXT:    [[TMP24:%.*]] = load i32, i32* [[A]], align 4
// CHECK19-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l242
// CHECK19-SAME: (%struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR2]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK19-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i32, i32, i32, i16*)* @.omp_outlined..10 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i32 [[TMP5]], i32 [[TMP1]], i32 [[TMP2]], i16* [[TMP3]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR3]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[IT:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK19-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK19-NEXT:    store i64 3, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_8u(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK19-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[CMP:%.*]] = icmp ugt i64 [[TMP6]], 3
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i64 [ 3, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK19-NEXT:    store i64 [[TMP8]], i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[TMP10:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[CMP3:%.*]] = icmp ule i64 [[TMP9]], [[TMP10]]
// CHECK19-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[MUL:%.*]] = mul i64 [[TMP11]], 400
// CHECK19-NEXT:    [[SUB:%.*]] = sub i64 2000, [[MUL]]
// CHECK19-NEXT:    store i64 [[SUB]], i64* [[IT]], align 8
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK19-NEXT:    [[ADD:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK19-NEXT:    store double [[ADD]], double* [[A]], align 4
// CHECK19-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP13:%.*]] = load double, double* [[A4]], align 4
// CHECK19-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK19-NEXT:    store double [[INC]], double* [[A4]], align 4
// CHECK19-NEXT:    [[CONV5:%.*]] = fptosi double [[INC]] to i16
// CHECK19-NEXT:    [[TMP14:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP14]]
// CHECK19-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK19-NEXT:    store i16 [[CONV5]], i16* [[ARRAYIDX6]], align 2
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[ADD7:%.*]] = add i64 [[TMP15]], 1
// CHECK19-NEXT:    store i64 [[ADD7]], i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l224
// CHECK19-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV2:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP3]], i16* [[CONV2]], align 2
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i8, i8* [[CONV1]], align 1
// CHECK19-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK19-NEXT:    store i8 [[TMP5]], i8* [[CONV3]], align 1
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32, [10 x i32]*)* @.omp_outlined..13 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], [10 x i32]* [[TMP0]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..13
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l207
// CHECK19-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP3]], i16* [[CONV1]], align 2
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..16 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..16
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i64, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i64, align 8
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    store i64 0, i64* [[DOTOMP_LB]], align 8
// CHECK19-NEXT:    store i64 6, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    store i64 1, i64* [[DOTOMP_STRIDE]], align 8
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_8(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 34, i32* [[DOTOMP_IS_LAST]], i64* [[DOTOMP_LB]], i64* [[DOTOMP_UB]], i64* [[DOTOMP_STRIDE]], i64 1, i64 1)
// CHECK19-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i64 [[TMP3]], 6
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i64 [ 6, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i64 [[COND]], i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[TMP5:%.*]] = load i64, i64* [[DOTOMP_LB]], align 8
// CHECK19-NEXT:    store i64 [[TMP5]], i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP6:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTOMP_UB]], align 8
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i64 [[TMP6]], [[TMP7]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i64 [[TMP8]], 3
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i64 -10, [[MUL]]
// CHECK19-NEXT:    store i64 [[ADD]], i64* [[I]], align 8
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK19-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP10]] to i32
// CHECK19-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK19-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK19-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK19-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK19-NEXT:    store i32 [[ADD6]], i32* [[ARRAYIDX]], align 4
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    [[ADD7:%.*]] = add nsw i64 [[TMP12]], 1
// CHECK19-NEXT:    store i64 [[ADD7]], i64* [[DOTOMP_IV]], align 8
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK19-SAME: () #[[ATTR6]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK19-NEXT:    ret void
//
