// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// Test host codegen.
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck  %s --check-prefix=CHECK1
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK1
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck  %s --check-prefix=CHECK3
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK3
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck  %s --check-prefix=CHECK5
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK5
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck  %s --check-prefix=CHECK7
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK7

// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck  %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck  %s --check-prefix=CHECK11
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK11
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck  %s --check-prefix=CHECK13
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK13
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck  %s --check-prefix=CHECK15
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK15

// Test target codegen - host bc file has to be created first.
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck  %s --check-prefix=CHECK17
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK17
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck  %s --check-prefix=CHECK19
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK19
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck  %s --check-prefix=CHECK21
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK21
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck  %s --check-prefix=CHECK23
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK23

// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck  %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck  %s --check-prefix=CHECK11
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=45 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK11
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck  %s --check-prefix=CHECK13
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK13
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -no-opaque-pointers -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck  %s --check-prefix=CHECK15
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck  %s --check-prefix=CHECK15
// expected-no-diagnostics

#ifndef HEADER
#define HEADER




// We have 8 target regions, but only 7 that actually will generate offloading
// code, only 6 will have mapped arguments, and only 4 have all-constant map
// sizes.



// Check target registration is registered as a Ctor.


template<typename tx, typename ty>
struct TT{
  tx X;
  ty Y;
};

int global;

int foo(int n) {
  int a = 0;
  short aa = 0;
  float b[10];
  float bn[n];
  double c[5][10];
  double cn[5][n];
  TT<long long, char> d;

  #pragma omp target teams distribute simd num_teams(a) thread_limit(a) firstprivate(aa) simdlen(16) nowait
  for (int i = 0; i < 10; ++i) {
  }

#ifdef OMP5
  #pragma omp target teams distribute simd if(target: 0) safelen(32) linear(a) if(simd: 1) nontemporal(a)
#else
  #pragma omp target teams distribute simd if(target: 0) safelen(32) linear(a)
#endif // OMP5
  for (a = 0; a < 10; ++a) {
    a += 1;
  }


  #pragma omp target teams distribute simd if(target: 1)
  for (int i = 0; i < 10; ++i) {
    aa += 1;
  }



  #pragma omp target teams distribute simd if(target: n>10)
  for (int i = 0; i < 10; ++i) {
    a += 1;
    aa += 1;
  }

  // We capture 3 VLA sizes in this target region





  // The names below are not necessarily consistent with the names used for the
  // addresses above as some are repeated.










  #pragma omp target teams distribute simd if(target: n>20) aligned(b)
  for (int i = 0; i < 10; ++i) {
    a += 1;
    b[2] += 1.0;
    bn[3] += 1.0;
    c[1][2] += 1.0;
    cn[1][3] += 1.0;
    d.X += 1;
    d.Y += 1;
  }

  return a;
}

// Check that the offloading functions are emitted and that the arguments are
// correct and loaded correctly for the target regions in foo().




// Create stack storage and store argument in there.

// Create stack storage and store argument in there.

// Create stack storage and store argument in there.

// Create local storage for each capture.



// To reduce complexity, we're only going as far as validating the signature of the outlined parallel function.

template<typename tx>
tx ftemplate(int n) {
  tx a = 0;
  short aa = 0;
  tx b[10];

  #pragma omp target teams distribute simd if(target: n>40)
  for (int i = 0; i < 10; ++i) {
    a += 1;
    aa += 1;
    b[2] += 1;
  }

  return a;
}

static
int fstatic(int n) {
  int a = 0;
  short aa = 0;
  char aaa = 0;
  int b[10];

  #pragma omp target teams distribute simd if(target: n>50)
  for (int i = a; i < n; ++i) {
    a += 1;
    aa += 1;
    aaa += 1;
    b[2] += 1;
  }

  return a;
}

struct S1 {
  double a;

  int r1(int n){
    int b = n+1;
    short int c[2][n];

    #pragma omp target teams distribute simd if(n>60)
    for (int i = 0; i < 10; ++i) {
      this->a = (double)b + 1.5;
      c[1][1] = ++a;
    }

    return c[1][1] + (int)b;
  }
};

int bar(int n){
  int a = 0;

  a += foo(n);

  S1 S;
  a += S.r1(n);

  a += fstatic(n);

  a += ftemplate<int>(n);

  return a;
}



// We capture 2 VLA sizes in this target region


// The names below are not necessarily consistent with the names used for the
// addresses above as some are repeated.






















// Check that the offloading functions are emitted and that the arguments are
// correct and loaded correctly for the target regions of the callees of bar().

// Create local storage for each capture.
// Store captures in the context.


// To reduce complexity, we're only going as far as validating the signature of the outlined parallel function.


// Create local storage for each capture.
// Store captures in the context.




// To reduce complexity, we're only going as far as validating the signature of the outlined parallel function.

// Create local storage for each capture.
// Store captures in the context.



// To reduce complexity, we're only going as far as validating the signature of the outlined parallel function.


#endif
// CHECK1-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK1-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK1-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK1-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED4:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 4
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED7:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS9:%.*]] = alloca [1 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS10:%.*]] = alloca [1 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS11:%.*]] = alloca [1 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A_CASTED12:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED14:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS16:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS17:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS18:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[_TMP19:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A_CASTED22:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS26:%.*]] = alloca [9 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS27:%.*]] = alloca [9 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS28:%.*]] = alloca [9 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [9 x i64], align 8
// CHECK1-NEXT:    [[_TMP29:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK1-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK1-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK1-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP2]], align 4
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP4]] to i64
// CHECK1-NEXT:    [[TMP6:%.*]] = mul nuw i64 5, [[TMP5]]
// CHECK1-NEXT:    [[VLA1:%.*]] = alloca double, i64 [[TMP6]], align 8
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[__VLA_EXPR1]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP9]], i16* [[CONV]], align 2
// CHECK1-NEXT:    [[TMP10:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP11]], i32* [[CONV3]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED4]] to i32*
// CHECK1-NEXT:    store i32 [[TMP13]], i32* [[CONV5]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED4]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i64*
// CHECK1-NEXT:    store i64 [[TMP10]], i64* [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i64*
// CHECK1-NEXT:    store i64 [[TMP10]], i64* [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i64*
// CHECK1-NEXT:    store i64 [[TMP12]], i64* [[TMP21]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i64*
// CHECK1-NEXT:    store i64 [[TMP12]], i64* [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP26:%.*]] = bitcast i8** [[TMP25]] to i64*
// CHECK1-NEXT:    store i64 [[TMP14]], i64* [[TMP26]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to i64*
// CHECK1-NEXT:    store i64 [[TMP14]], i64* [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP33:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    store i16 [[TMP33]], i16* [[TMP32]], align 4
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    store i32 [[TMP35]], i32* [[TMP34]], align 4
// CHECK1-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 [[TMP37]], i32* [[TMP36]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = call i8* @__kmpc_omp_target_task_alloc(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 1, i64 120, i64 12, i32 (i32, i8*)* bitcast (i32 (i32, %struct.kmp_task_t_with_privates*)* @.omp_task_entry. to i32 (i32, i8*)*), i64 -1)
// CHECK1-NEXT:    [[TMP39:%.*]] = bitcast i8* [[TMP38]] to %struct.kmp_task_t_with_privates*
// CHECK1-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP39]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP40]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[TMP41]], align 8
// CHECK1-NEXT:    [[TMP43:%.*]] = bitcast %struct.anon* [[AGG_CAPTURED]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP42]], i8* align 4 [[TMP43]], i64 12, i1 false)
// CHECK1-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP39]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP45:%.*]] = bitcast i8* [[TMP42]] to %struct.anon*
// CHECK1-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP47:%.*]] = bitcast [3 x i8*]* [[TMP46]] to i8*
// CHECK1-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP30]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP47]], i8* align 8 [[TMP48]], i64 24, i1 false)
// CHECK1-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP50:%.*]] = bitcast [3 x i8*]* [[TMP49]] to i8*
// CHECK1-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP31]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP50]], i8* align 8 [[TMP51]], i64 24, i1 false)
// CHECK1-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP53:%.*]] = bitcast [3 x i64]* [[TMP52]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP53]], i8* align 8 bitcast ([3 x i64]* @.offload_sizes to i8*), i64 24, i1 false)
// CHECK1-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP55:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    store i16 [[TMP55]], i16* [[TMP54]], align 8
// CHECK1-NEXT:    [[TMP56:%.*]] = call i32 @__kmpc_omp_task(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i8* [[TMP38]])
// CHECK1-NEXT:    [[TMP57:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV6:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP57]], i32* [[CONV6]], align 4
// CHECK1-NEXT:    [[TMP58:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l104(i64 [[TMP58]]) #[[ATTR4:[0-9]+]]
// CHECK1-NEXT:    [[TMP59:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV8:%.*]] = bitcast i64* [[AA_CASTED7]] to i16*
// CHECK1-NEXT:    store i16 [[TMP59]], i16* [[CONV8]], align 2
// CHECK1-NEXT:    [[TMP60:%.*]] = load i64, i64* [[AA_CASTED7]], align 8
// CHECK1-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to i64*
// CHECK1-NEXT:    store i64 [[TMP60]], i64* [[TMP62]], align 8
// CHECK1-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP64:%.*]] = bitcast i8** [[TMP63]] to i64*
// CHECK1-NEXT:    store i64 [[TMP60]], i64* [[TMP64]], align 8
// CHECK1-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP65]], align 8
// CHECK1-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK1-NEXT:    [[TMP68:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111.region_id, i32 1, i8** [[TMP66]], i8** [[TMP67]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP69:%.*]] = icmp ne i32 [[TMP68]], 0
// CHECK1-NEXT:    br i1 [[TMP69]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111(i64 [[TMP60]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    [[TMP70:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV13:%.*]] = bitcast i64* [[A_CASTED12]] to i32*
// CHECK1-NEXT:    store i32 [[TMP70]], i32* [[CONV13]], align 4
// CHECK1-NEXT:    [[TMP71:%.*]] = load i64, i64* [[A_CASTED12]], align 8
// CHECK1-NEXT:    [[TMP72:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV15:%.*]] = bitcast i64* [[AA_CASTED14]] to i16*
// CHECK1-NEXT:    store i16 [[TMP72]], i16* [[CONV15]], align 2
// CHECK1-NEXT:    [[TMP73:%.*]] = load i64, i64* [[AA_CASTED14]], align 8
// CHECK1-NEXT:    [[TMP74:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP74]], 10
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS16]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP76:%.*]] = bitcast i8** [[TMP75]] to i64*
// CHECK1-NEXT:    store i64 [[TMP71]], i64* [[TMP76]], align 8
// CHECK1-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS17]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP78:%.*]] = bitcast i8** [[TMP77]] to i64*
// CHECK1-NEXT:    store i64 [[TMP71]], i64* [[TMP78]], align 8
// CHECK1-NEXT:    [[TMP79:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS18]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP79]], align 8
// CHECK1-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS16]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP81:%.*]] = bitcast i8** [[TMP80]] to i64*
// CHECK1-NEXT:    store i64 [[TMP73]], i64* [[TMP81]], align 8
// CHECK1-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS17]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP83:%.*]] = bitcast i8** [[TMP82]] to i64*
// CHECK1-NEXT:    store i64 [[TMP73]], i64* [[TMP83]], align 8
// CHECK1-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS18]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP84]], align 8
// CHECK1-NEXT:    [[TMP85:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS16]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP86:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS17]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK1-NEXT:    [[TMP87:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118.region_id, i32 2, i8** [[TMP85]], i8** [[TMP86]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.7, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.8, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP88:%.*]] = icmp ne i32 [[TMP87]], 0
// CHECK1-NEXT:    br i1 [[TMP88]], label [[OMP_OFFLOAD_FAILED20:%.*]], label [[OMP_OFFLOAD_CONT21:%.*]]
// CHECK1:       omp_offload.failed20:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118(i64 [[TMP71]], i64 [[TMP73]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT21]]
// CHECK1:       omp_offload.cont21:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118(i64 [[TMP71]], i64 [[TMP73]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP89:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV23:%.*]] = bitcast i64* [[A_CASTED22]] to i32*
// CHECK1-NEXT:    store i32 [[TMP89]], i32* [[CONV23]], align 4
// CHECK1-NEXT:    [[TMP90:%.*]] = load i64, i64* [[A_CASTED22]], align 8
// CHECK1-NEXT:    [[TMP91:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP24:%.*]] = icmp sgt i32 [[TMP91]], 20
// CHECK1-NEXT:    br i1 [[CMP24]], label [[OMP_IF_THEN25:%.*]], label [[OMP_IF_ELSE32:%.*]]
// CHECK1:       omp_if.then25:
// CHECK1-NEXT:    [[TMP92:%.*]] = mul nuw i64 [[TMP2]], 4
// CHECK1-NEXT:    [[TMP93:%.*]] = mul nuw i64 5, [[TMP5]]
// CHECK1-NEXT:    [[TMP94:%.*]] = mul nuw i64 [[TMP93]], 8
// CHECK1-NEXT:    [[TMP95:%.*]] = bitcast [9 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP95]], i8* align 8 bitcast ([9 x i64]* @.offload_sizes.10 to i8*), i64 72, i1 false)
// CHECK1-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP97:%.*]] = bitcast i8** [[TMP96]] to i64*
// CHECK1-NEXT:    store i64 [[TMP90]], i64* [[TMP97]], align 8
// CHECK1-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP99:%.*]] = bitcast i8** [[TMP98]] to i64*
// CHECK1-NEXT:    store i64 [[TMP90]], i64* [[TMP99]], align 8
// CHECK1-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP100]], align 8
// CHECK1-NEXT:    [[TMP101:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP102:%.*]] = bitcast i8** [[TMP101]] to [10 x float]**
// CHECK1-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP102]], align 8
// CHECK1-NEXT:    [[TMP103:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP104:%.*]] = bitcast i8** [[TMP103]] to [10 x float]**
// CHECK1-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP104]], align 8
// CHECK1-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP105]], align 8
// CHECK1-NEXT:    [[TMP106:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP107:%.*]] = bitcast i8** [[TMP106]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP107]], align 8
// CHECK1-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP109:%.*]] = bitcast i8** [[TMP108]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP109]], align 8
// CHECK1-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP110]], align 8
// CHECK1-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to float**
// CHECK1-NEXT:    store float* [[VLA]], float** [[TMP112]], align 8
// CHECK1-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to float**
// CHECK1-NEXT:    store float* [[VLA]], float** [[TMP114]], align 8
// CHECK1-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP92]], i64* [[TMP115]], align 8
// CHECK1-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP116]], align 8
// CHECK1-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP118:%.*]] = bitcast i8** [[TMP117]] to [5 x [10 x double]]**
// CHECK1-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP118]], align 8
// CHECK1-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP120:%.*]] = bitcast i8** [[TMP119]] to [5 x [10 x double]]**
// CHECK1-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP120]], align 8
// CHECK1-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 4
// CHECK1-NEXT:    store i8* null, i8** [[TMP121]], align 8
// CHECK1-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 5
// CHECK1-NEXT:    [[TMP123:%.*]] = bitcast i8** [[TMP122]] to i64*
// CHECK1-NEXT:    store i64 5, i64* [[TMP123]], align 8
// CHECK1-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 5
// CHECK1-NEXT:    [[TMP125:%.*]] = bitcast i8** [[TMP124]] to i64*
// CHECK1-NEXT:    store i64 5, i64* [[TMP125]], align 8
// CHECK1-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 5
// CHECK1-NEXT:    store i8* null, i8** [[TMP126]], align 8
// CHECK1-NEXT:    [[TMP127:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP128:%.*]] = bitcast i8** [[TMP127]] to i64*
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[TMP128]], align 8
// CHECK1-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP130:%.*]] = bitcast i8** [[TMP129]] to i64*
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[TMP130]], align 8
// CHECK1-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 6
// CHECK1-NEXT:    store i8* null, i8** [[TMP131]], align 8
// CHECK1-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 7
// CHECK1-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to double**
// CHECK1-NEXT:    store double* [[VLA1]], double** [[TMP133]], align 8
// CHECK1-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 7
// CHECK1-NEXT:    [[TMP135:%.*]] = bitcast i8** [[TMP134]] to double**
// CHECK1-NEXT:    store double* [[VLA1]], double** [[TMP135]], align 8
// CHECK1-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK1-NEXT:    store i64 [[TMP94]], i64* [[TMP136]], align 8
// CHECK1-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 7
// CHECK1-NEXT:    store i8* null, i8** [[TMP137]], align 8
// CHECK1-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP139:%.*]] = bitcast i8** [[TMP138]] to %struct.TT**
// CHECK1-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP139]], align 8
// CHECK1-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP141:%.*]] = bitcast i8** [[TMP140]] to %struct.TT**
// CHECK1-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP141]], align 8
// CHECK1-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 8
// CHECK1-NEXT:    store i8* null, i8** [[TMP142]], align 8
// CHECK1-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP145:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK1-NEXT:    [[TMP146:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142.region_id, i32 9, i8** [[TMP143]], i8** [[TMP144]], i64* [[TMP145]], i64* getelementptr inbounds ([9 x i64], [9 x i64]* @.offload_maptypes.11, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP147:%.*]] = icmp ne i32 [[TMP146]], 0
// CHECK1-NEXT:    br i1 [[TMP147]], label [[OMP_OFFLOAD_FAILED30:%.*]], label [[OMP_OFFLOAD_CONT31:%.*]]
// CHECK1:       omp_offload.failed30:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142(i64 [[TMP90]], [10 x float]* [[B]], i64 [[TMP2]], float* [[VLA]], [5 x [10 x double]]* [[C]], i64 5, i64 [[TMP5]], double* [[VLA1]], %struct.TT* [[D]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT31]]
// CHECK1:       omp_offload.cont31:
// CHECK1-NEXT:    br label [[OMP_IF_END33:%.*]]
// CHECK1:       omp_if.else32:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142(i64 [[TMP90]], [10 x float]* [[B]], i64 [[TMP2]], float* [[VLA]], [5 x [10 x double]]* [[C]], i64 5, i64 [[TMP5]], double* [[VLA1]], %struct.TT* [[D]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END33]]
// CHECK1:       omp_if.end33:
// CHECK1-NEXT:    [[TMP148:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP149:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK1-NEXT:    call void @llvm.stackrestore(i8* [[TMP149]])
// CHECK1-NEXT:    ret i32 [[TMP148]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97
// CHECK1-SAME: (i64 noundef [[AA:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_1]], i64* [[DOTCAPTURE_EXPR__ADDR2]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK1-NEXT:    [[CONV4:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR2]] to i32*
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV3]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV4]], align 4
// CHECK1-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP3]], i16* [[CONV5]], align 2
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), i64 [[TMP4]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK1-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK1-NEXT:    br i1 [[TMP10]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK1-SAME: (%struct..kmp_privates.t* noalias noundef [[TMP0:%.*]], i16** noalias noundef [[TMP1:%.*]], [3 x i8*]** noalias noundef [[TMP2:%.*]], [3 x i8*]** noalias noundef [[TMP3:%.*]], [3 x i64]** noalias noundef [[TMP4:%.*]]) #[[ATTR5:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca %struct..kmp_privates.t*, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca i16**, align 8
// CHECK1-NEXT:    [[DOTADDR2:%.*]] = alloca [3 x i8*]**, align 8
// CHECK1-NEXT:    [[DOTADDR3:%.*]] = alloca [3 x i8*]**, align 8
// CHECK1-NEXT:    [[DOTADDR4:%.*]] = alloca [3 x i64]**, align 8
// CHECK1-NEXT:    store %struct..kmp_privates.t* [[TMP0]], %struct..kmp_privates.t** [[DOTADDR]], align 8
// CHECK1-NEXT:    store i16** [[TMP1]], i16*** [[DOTADDR1]], align 8
// CHECK1-NEXT:    store [3 x i8*]** [[TMP2]], [3 x i8*]*** [[DOTADDR2]], align 8
// CHECK1-NEXT:    store [3 x i8*]** [[TMP3]], [3 x i8*]*** [[DOTADDR3]], align 8
// CHECK1-NEXT:    store [3 x i64]** [[TMP4]], [3 x i64]*** [[DOTADDR4]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load %struct..kmp_privates.t*, %struct..kmp_privates.t** [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR2]], align 8
// CHECK1-NEXT:    store [3 x i8*]* [[TMP6]], [3 x i8*]** [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP9:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR3]], align 8
// CHECK1-NEXT:    store [3 x i8*]* [[TMP8]], [3 x i8*]** [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP11:%.*]] = load [3 x i64]**, [3 x i64]*** [[DOTADDR4]], align 8
// CHECK1-NEXT:    store [3 x i64]* [[TMP10]], [3 x i64]** [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP13:%.*]] = load i16**, i16*** [[DOTADDR1]], align 8
// CHECK1-NEXT:    store i16* [[TMP12]], i16** [[TMP13]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK1-SAME: (i32 noundef signext [[TMP0:%.*]], %struct.kmp_task_t_with_privates* noalias noundef [[TMP1:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca void (i8*, ...)*, align 8
// CHECK1-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca %struct.anon*, align 8
// CHECK1-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca i16*, align 8
// CHECK1-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca [3 x i8*]*, align 8
// CHECK1-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca [3 x i8*]*, align 8
// CHECK1-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca [3 x i64]*, align 8
// CHECK1-NEXT:    [[AA_CASTED_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED5_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca %struct.kmp_task_t_with_privates*, align 8
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[DOTADDR]], align 4
// CHECK1-NEXT:    store %struct.kmp_task_t_with_privates* [[TMP1]], %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTADDR]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load %struct.kmp_task_t_with_privates*, %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load i8*, i8** [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = bitcast i8* [[TMP7]] to %struct.anon*
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast %struct..kmp_privates.t* [[TMP9]] to i8*
// CHECK1-NEXT:    [[TMP11:%.*]] = bitcast %struct.kmp_task_t_with_privates* [[TMP3]] to i8*
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META17:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META20:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META22:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META24:![0-9]+]])
// CHECK1-NEXT:    store i32 [[TMP2]], i32* [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !26
// CHECK1-NEXT:    store i32* [[TMP5]], i32** [[DOTPART_ID__ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    store i8* [[TMP10]], i8** [[DOTPRIVATES__ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    store void (i8*, ...)* bitcast (void (%struct..kmp_privates.t*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)* @.omp_task_privates_map. to void (i8*, ...)*), void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    store i8* [[TMP11]], i8** [[DOTTASK_T__ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    store %struct.anon* [[TMP8]], %struct.anon** [[__CONTEXT_ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP12:%.*]] = load %struct.anon*, %struct.anon** [[__CONTEXT_ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP13:%.*]] = load void (i8*, ...)*, void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[DOTPRIVATES__ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast void (i8*, ...)* [[TMP13]] to void (i8*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)*
// CHECK1-NEXT:    call void [[TMP15]](i8* [[TMP14]], i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK1-NEXT:    [[TMP16:%.*]] = load i16*, i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP17:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP18:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP19:%.*]] = load [3 x i64]*, [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP17]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP18]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[TMP19]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], %struct.anon* [[TMP12]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[TMP12]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10) #[[ATTR4]]
// CHECK1-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_nowait_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* [[TMP22]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP25]], i32 1, i32 0, i8* null, i32 0, i8* null) #[[ATTR4]]
// CHECK1-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK1-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED_I:%.*]], label [[DOTOMP_OUTLINED__1_EXIT:%.*]]
// CHECK1:       omp_offload.failed.i:
// CHECK1-NEXT:    [[TMP28:%.*]] = load i16, i16* [[TMP16]], align 2
// CHECK1-NEXT:    [[CONV_I:%.*]] = bitcast i64* [[AA_CASTED_I]] to i16*
// CHECK1-NEXT:    store i16 [[TMP28]], i16* [[CONV_I]], align 2, !noalias !26
// CHECK1-NEXT:    [[TMP29:%.*]] = load i64, i64* [[AA_CASTED_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK1-NEXT:    [[CONV4_I:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED_I]] to i32*
// CHECK1-NEXT:    store i32 [[TMP30]], i32* [[CONV4_I]], align 4, !noalias !26
// CHECK1-NEXT:    [[TMP31:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED_I]], align 8, !noalias !26
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK1-NEXT:    [[CONV6_I:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED5_I]] to i32*
// CHECK1-NEXT:    store i32 [[TMP32]], i32* [[CONV6_I]], align 4, !noalias !26
// CHECK1-NEXT:    [[TMP33:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED5_I]], align 8, !noalias !26
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97(i64 [[TMP29]], i64 [[TMP31]], i64 [[TMP33]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[DOTOMP_OUTLINED__1_EXIT]]
// CHECK1:       .omp_outlined..1.exit:
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l104
// CHECK1-SAME: (i64 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i64 [[TMP1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[A1]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A1]], align 4
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK1-NEXT:    store i32 [[ADD3]], i32* [[A1]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK1-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP27:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK1-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 10, i32* [[CONV]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111
// CHECK1-SAME: (i64 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !29
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !29
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !29
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !29
// CHECK1-NEXT:    [[TMP8:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !29
// CHECK1-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP8]] to i32
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV2]], 1
// CHECK1-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD3]] to i16
// CHECK1-NEXT:    store i16 [[CONV4]], i16* [[CONV]], align 2, !llvm.access.group !29
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !29
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK1-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !29
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP30:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK1-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118
// CHECK1-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[CONV2]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP2]], i16* [[CONV3]], align 2
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !32
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !32
// CHECK1-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !32
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !32
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !32
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK1-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4, !llvm.access.group !32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV1]], align 2, !llvm.access.group !32
// CHECK1-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP9]] to i32
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK1-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK1-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2, !llvm.access.group !32
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !32
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK1-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !32
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP33:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK1-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142
// CHECK1-SAME: (i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK1-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK1-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK1-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK1-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK1-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[CONV5]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 9, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, [10 x float]*, i64, float*, [5 x [10 x double]]*, i64, i64, double*, %struct.TT*)* @.omp_outlined..9 to void (i32*, i32*, ...)*), i64 [[TMP9]], [10 x float]* [[TMP0]], i64 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i64 [[TMP4]], i64 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..9
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK1-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK1-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK1-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK1-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK1-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 0
// CHECK1-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i64 16) ]
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 9
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK1-NEXT:    store i32 [[ADD6]], i32* [[CONV]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[CONV7:%.*]] = fpext float [[TMP17]] to double
// CHECK1-NEXT:    [[ADD8:%.*]] = fadd double [[CONV7]], 1.000000e+00
// CHECK1-NEXT:    [[CONV9:%.*]] = fptrunc double [[ADD8]] to float
// CHECK1-NEXT:    store float [[CONV9]], float* [[ARRAYIDX]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP2]], i64 3
// CHECK1-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX10]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[CONV11:%.*]] = fpext float [[TMP18]] to double
// CHECK1-NEXT:    [[ADD12:%.*]] = fadd double [[CONV11]], 1.000000e+00
// CHECK1-NEXT:    [[CONV13:%.*]] = fptrunc double [[ADD12]] to float
// CHECK1-NEXT:    store float [[CONV13]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i64 0, i64 1
// CHECK1-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX14]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP19:%.*]] = load double, double* [[ARRAYIDX15]], align 8, !llvm.access.group !35
// CHECK1-NEXT:    [[ADD16:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD16]], double* [[ARRAYIDX15]], align 8, !llvm.access.group !35
// CHECK1-NEXT:    [[TMP20:%.*]] = mul nsw i64 1, [[TMP5]]
// CHECK1-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[TMP6]], i64 [[TMP20]]
// CHECK1-NEXT:    [[ARRAYIDX18:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX17]], i64 3
// CHECK1-NEXT:    [[TMP21:%.*]] = load double, double* [[ARRAYIDX18]], align 8, !llvm.access.group !35
// CHECK1-NEXT:    [[ADD19:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD19]], double* [[ARRAYIDX18]], align 8, !llvm.access.group !35
// CHECK1-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP22:%.*]] = load i64, i64* [[X]], align 8, !llvm.access.group !35
// CHECK1-NEXT:    [[ADD20:%.*]] = add nsw i64 [[TMP22]], 1
// CHECK1-NEXT:    store i64 [[ADD20]], i64* [[X]], align 8, !llvm.access.group !35
// CHECK1-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP23:%.*]] = load i8, i8* [[Y]], align 8, !llvm.access.group !35
// CHECK1-NEXT:    [[CONV21:%.*]] = sext i8 [[TMP23]] to i32
// CHECK1-NEXT:    [[ADD22:%.*]] = add nsw i32 [[CONV21]], 1
// CHECK1-NEXT:    [[CONV23:%.*]] = trunc i32 [[ADD22]] to i8
// CHECK1-NEXT:    store i8 [[CONV23]], i8* [[Y]], align 8, !llvm.access.group !35
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK1-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !35
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP36:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]])
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK1-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z3bari
// CHECK1-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 8
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z3fooi(i32 noundef signext [[TMP0]])
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CALL1:%.*]] = call noundef signext i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 8 dereferenceable(8) [[S]], i32 noundef signext [[TMP2]])
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK1-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CALL3:%.*]] = call noundef signext i32 @_ZL7fstatici(i32 noundef signext [[TMP4]])
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK1-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CALL5:%.*]] = call noundef signext i32 @_Z9ftemplateIiET_i(i32 noundef signext [[TMP6]])
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK1-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK1-SAME: (%struct.S1* noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK1-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [5 x i64], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK1-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK1-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK1-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP4]], align 2
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 60
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP8:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK1-NEXT:    [[TMP9:%.*]] = mul nuw i64 [[TMP8]], 2
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast [5 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK1-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP10]], i8* align 8 bitcast ([5 x i64]* @.offload_sizes.13 to i8*), i64 40, i1 false)
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to %struct.S1**
// CHECK1-NEXT:    store %struct.S1* [[THIS1]], %struct.S1** [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to double**
// CHECK1-NEXT:    store double* [[A]], double** [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i64*
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[TMP19]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i64*
// CHECK1-NEXT:    store i64 2, i64* [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i64*
// CHECK1-NEXT:    store i64 2, i64* [[TMP24]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i16**
// CHECK1-NEXT:    store i16* [[VLA]], i16** [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i16**
// CHECK1-NEXT:    store i16* [[VLA]], i16** [[TMP34]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP9]], i64* [[TMP35]], align 8
// CHECK1-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK1-NEXT:    store i8* null, i8** [[TMP36]], align 8
// CHECK1-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK1-NEXT:    [[TMP40:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215.region_id, i32 5, i8** [[TMP37]], i8** [[TMP38]], i64* [[TMP39]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.14, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP41:%.*]] = icmp ne i32 [[TMP40]], 0
// CHECK1-NEXT:    br i1 [[TMP41]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215(%struct.S1* [[THIS1]], i64 [[TMP6]], i64 2, i64 [[TMP2]], i16* [[VLA]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215(%struct.S1* [[THIS1]], i64 [[TMP6]], i64 2, i64 [[TMP2]], i16* [[VLA]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP42:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP42]]
// CHECK1-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK1-NEXT:    [[TMP43:%.*]] = load i16, i16* [[ARRAYIDX2]], align 2
// CHECK1-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP43]] to i32
// CHECK1-NEXT:    [[TMP44:%.*]] = load i32, i32* [[B]], align 4
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], [[TMP44]]
// CHECK1-NEXT:    [[TMP45:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK1-NEXT:    call void @llvm.stackrestore(i8* [[TMP45]])
// CHECK1-NEXT:    ret i32 [[ADD4]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK1-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK1-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP2]], i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP4]], i16* [[CONV2]], align 2
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load i8, i8* [[AAA]], align 1
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK1-NEXT:    store i8 [[TMP6]], i8* [[CONV3]], align 1
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 50
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i64*
// CHECK1-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i64*
// CHECK1-NEXT:    store i64 [[TMP7]], i64* [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK1-NEXT:    store i64 [[TMP7]], i64* [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to [10 x i32]**
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to [10 x i32]**
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK1-NEXT:    store i8* null, i8** [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    store i32 [[TMP36]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP37]], i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub i32 [[TMP38]], [[TMP39]]
// CHECK1-NEXT:    [[SUB6:%.*]] = sub i32 [[SUB]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB6]], 1
// CHECK1-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK1-NEXT:    [[SUB7:%.*]] = sub i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB7]], i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK1-NEXT:    [[TMP40:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK1-NEXT:    [[ADD8:%.*]] = add i32 [[TMP40]], 1
// CHECK1-NEXT:    [[TMP41:%.*]] = zext i32 [[ADD8]] to i64
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP41]])
// CHECK1-NEXT:    [[TMP42:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197.region_id, i32 5, i8** [[TMP34]], i8** [[TMP35]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.16, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.17, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP43:%.*]] = icmp ne i32 [[TMP42]], 0
// CHECK1-NEXT:    br i1 [[TMP43]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], i64 [[TMP7]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], i64 [[TMP7]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP44:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    ret i32 [[TMP44]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK1-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK1-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 40
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK1-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK1-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [10 x i32]**
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [10 x i32]**
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK1-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.19, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.20, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK1-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[A]], align 4
// CHECK1-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215
// CHECK1-SAME: (%struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[CONV3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i64, i64, i64, i16*)* @.omp_outlined..12 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i64 [[TMP5]], i64 [[TMP1]], i64 [[TMP2]], i16* [[TMP3]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..12
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 9
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !38
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !38
// CHECK1-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !38
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !38
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !38
// CHECK1-NEXT:    [[CONV4:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK1-NEXT:    [[ADD5:%.*]] = fadd double [[CONV4]], 1.500000e+00
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK1-NEXT:    store double [[ADD5]], double* [[A]], align 8, !llvm.access.group !38
// CHECK1-NEXT:    [[A6:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP13:%.*]] = load double, double* [[A6]], align 8, !llvm.access.group !38
// CHECK1-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK1-NEXT:    store double [[INC]], double* [[A6]], align 8, !llvm.access.group !38
// CHECK1-NEXT:    [[CONV7:%.*]] = fptosi double [[INC]] to i16
// CHECK1-NEXT:    [[TMP14:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP14]]
// CHECK1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK1-NEXT:    store i16 [[CONV7]], i16* [[ARRAYIDX8]], align 2, !llvm.access.group !38
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !38
// CHECK1-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK1-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !38
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP39:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK1-NEXT:    br i1 [[TMP17]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197
// CHECK1-SAME: (i64 noundef [[A:%.*]], i64 noundef [[N:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV4:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP1]], i32* [[CONV4]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP3]], i32* [[CONV5]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i16, i16* [[CONV2]], align 2
// CHECK1-NEXT:    [[CONV6:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP5]], i16* [[CONV6]], align 2
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i8, i8* [[CONV3]], align 1
// CHECK1-NEXT:    [[CONV7:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK1-NEXT:    store i8 [[TMP7]], i8* [[CONV7]], align 1
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, i64, [10 x i32]*)* @.omp_outlined..15 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP8]], [10 x i32]* [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..15
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[N:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I8:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK1-NEXT:    [[SUB6:%.*]] = sub i32 [[SUB]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB6]], 1
// CHECK1-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK1-NEXT:    [[SUB7:%.*]] = sub i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB7]], i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK1-NEXT:    [[CMP9:%.*]] = icmp ugt i32 [[TMP11]], [[TMP12]]
// CHECK1-NEXT:    br i1 [[CMP9]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[ADD10:%.*]] = add i32 [[TMP17]], 1
// CHECK1-NEXT:    [[CMP11:%.*]] = icmp ult i32 [[TMP16]], [[ADD10]]
// CHECK1-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[MUL:%.*]] = mul i32 [[TMP19]], 1
// CHECK1-NEXT:    [[ADD12:%.*]] = add i32 [[TMP18]], [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD12]], i32* [[I8]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK1-NEXT:    store i32 [[ADD13]], i32* [[CONV]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[TMP21:%.*]] = load i16, i16* [[CONV2]], align 2, !llvm.access.group !41
// CHECK1-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP21]] to i32
// CHECK1-NEXT:    [[ADD15:%.*]] = add nsw i32 [[CONV14]], 1
// CHECK1-NEXT:    [[CONV16:%.*]] = trunc i32 [[ADD15]] to i16
// CHECK1-NEXT:    store i16 [[CONV16]], i16* [[CONV2]], align 2, !llvm.access.group !41
// CHECK1-NEXT:    [[TMP22:%.*]] = load i8, i8* [[CONV3]], align 1, !llvm.access.group !41
// CHECK1-NEXT:    [[CONV17:%.*]] = sext i8 [[TMP22]] to i32
// CHECK1-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV17]], 1
// CHECK1-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK1-NEXT:    store i8 [[CONV19]], i8* [[CONV3]], align 1, !llvm.access.group !41
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[ADD20:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK1-NEXT:    store i32 [[ADD20]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    [[ADD21:%.*]] = add i32 [[TMP24]], 1
// CHECK1-NEXT:    store i32 [[ADD21]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !41
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP42:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK1-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB22:%.*]] = sub i32 [[TMP30]], [[TMP31]]
// CHECK1-NEXT:    [[SUB23:%.*]] = sub i32 [[SUB22]], 1
// CHECK1-NEXT:    [[ADD24:%.*]] = add i32 [[SUB23]], 1
// CHECK1-NEXT:    [[DIV25:%.*]] = udiv i32 [[ADD24]], 1
// CHECK1-NEXT:    [[MUL26:%.*]] = mul i32 [[DIV25]], 1
// CHECK1-NEXT:    [[ADD27:%.*]] = add i32 [[TMP29]], [[MUL26]]
// CHECK1-NEXT:    store i32 [[ADD27]], i32* [[I8]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180
// CHECK1-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP1]], i32* [[CONV2]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK1-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..18 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..18
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK1-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK1-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK1-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV1]], align 2, !llvm.access.group !44
// CHECK1-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP10]] to i32
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK1-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK1-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2, !llvm.access.group !44
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK1-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK1-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !44
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP45:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK1-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR5]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK3-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK3-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK3-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS6:%.*]] = alloca [1 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS7:%.*]] = alloca [1 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS8:%.*]] = alloca [1 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED9:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED10:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS12:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS13:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS14:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[_TMP15:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED18:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS21:%.*]] = alloca [9 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS22:%.*]] = alloca [9 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS23:%.*]] = alloca [9 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [9 x i64], align 4
// CHECK3-NEXT:    [[_TMP24:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK3-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK3-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK3-NEXT:    [[VLA:%.*]] = alloca float, i32 [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = mul nuw i32 5, [[TMP3]]
// CHECK3-NEXT:    [[VLA1:%.*]] = alloca double, i32 [[TMP4]], align 8
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[__VLA_EXPR1]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP7]], i16* [[CONV]], align 2
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 [[TMP11]], i32* [[DOTCAPTURE_EXPR__CASTED3]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED3]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to i32*
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[TMP14]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32*
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[TMP16]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32*
// CHECK3-NEXT:    store i32 [[TMP10]], i32* [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK3-NEXT:    store i32 [[TMP10]], i32* [[TMP21]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32*
// CHECK3-NEXT:    store i32 [[TMP12]], i32* [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP26:%.*]] = bitcast i8** [[TMP25]] to i32*
// CHECK3-NEXT:    store i32 [[TMP12]], i32* [[TMP26]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP27]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP31:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    store i16 [[TMP31]], i16* [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    store i32 [[TMP33]], i32* [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 [[TMP35]], i32* [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = call i8* @__kmpc_omp_target_task_alloc(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 1, i32 72, i32 12, i32 (i32, i8*)* bitcast (i32 (i32, %struct.kmp_task_t_with_privates*)* @.omp_task_entry. to i32 (i32, i8*)*), i64 -1)
// CHECK3-NEXT:    [[TMP37:%.*]] = bitcast i8* [[TMP36]] to %struct.kmp_task_t_with_privates*
// CHECK3-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP37]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP38]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP40:%.*]] = load i8*, i8** [[TMP39]], align 4
// CHECK3-NEXT:    [[TMP41:%.*]] = bitcast %struct.anon* [[AGG_CAPTURED]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP40]], i8* align 4 [[TMP41]], i32 12, i1 false)
// CHECK3-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP37]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP43:%.*]] = bitcast i8* [[TMP40]] to %struct.anon*
// CHECK3-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP42]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP45:%.*]] = bitcast [3 x i64]* [[TMP44]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP45]], i8* align 4 bitcast ([3 x i64]* @.offload_sizes to i8*), i32 24, i1 false)
// CHECK3-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP42]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP47:%.*]] = bitcast [3 x i8*]* [[TMP46]] to i8*
// CHECK3-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP28]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP47]], i8* align 4 [[TMP48]], i32 12, i1 false)
// CHECK3-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP42]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP50:%.*]] = bitcast [3 x i8*]* [[TMP49]] to i8*
// CHECK3-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP29]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP50]], i8* align 4 [[TMP51]], i32 12, i1 false)
// CHECK3-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP42]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP53:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    store i16 [[TMP53]], i16* [[TMP52]], align 4
// CHECK3-NEXT:    [[TMP54:%.*]] = call i32 @__kmpc_omp_task(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i8* [[TMP36]])
// CHECK3-NEXT:    [[TMP55:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP55]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP56:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l104(i32 [[TMP56]]) #[[ATTR4:[0-9]+]]
// CHECK3-NEXT:    [[TMP57:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV5:%.*]] = bitcast i32* [[AA_CASTED4]] to i16*
// CHECK3-NEXT:    store i16 [[TMP57]], i16* [[CONV5]], align 2
// CHECK3-NEXT:    [[TMP58:%.*]] = load i32, i32* [[AA_CASTED4]], align 4
// CHECK3-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP60:%.*]] = bitcast i8** [[TMP59]] to i32*
// CHECK3-NEXT:    store i32 [[TMP58]], i32* [[TMP60]], align 4
// CHECK3-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to i32*
// CHECK3-NEXT:    store i32 [[TMP58]], i32* [[TMP62]], align 4
// CHECK3-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS8]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP63]], align 4
// CHECK3-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK3-NEXT:    [[TMP66:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111.region_id, i32 1, i8** [[TMP64]], i8** [[TMP65]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP67:%.*]] = icmp ne i32 [[TMP66]], 0
// CHECK3-NEXT:    br i1 [[TMP67]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111(i32 [[TMP58]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    [[TMP68:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP68]], i32* [[A_CASTED9]], align 4
// CHECK3-NEXT:    [[TMP69:%.*]] = load i32, i32* [[A_CASTED9]], align 4
// CHECK3-NEXT:    [[TMP70:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV11:%.*]] = bitcast i32* [[AA_CASTED10]] to i16*
// CHECK3-NEXT:    store i16 [[TMP70]], i16* [[CONV11]], align 2
// CHECK3-NEXT:    [[TMP71:%.*]] = load i32, i32* [[AA_CASTED10]], align 4
// CHECK3-NEXT:    [[TMP72:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP72]], 10
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP74:%.*]] = bitcast i8** [[TMP73]] to i32*
// CHECK3-NEXT:    store i32 [[TMP69]], i32* [[TMP74]], align 4
// CHECK3-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS13]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP76:%.*]] = bitcast i8** [[TMP75]] to i32*
// CHECK3-NEXT:    store i32 [[TMP69]], i32* [[TMP76]], align 4
// CHECK3-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS14]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP77]], align 4
// CHECK3-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP79:%.*]] = bitcast i8** [[TMP78]] to i32*
// CHECK3-NEXT:    store i32 [[TMP71]], i32* [[TMP79]], align 4
// CHECK3-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS13]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP81:%.*]] = bitcast i8** [[TMP80]] to i32*
// CHECK3-NEXT:    store i32 [[TMP71]], i32* [[TMP81]], align 4
// CHECK3-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS14]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP82]], align 4
// CHECK3-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS13]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK3-NEXT:    [[TMP85:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118.region_id, i32 2, i8** [[TMP83]], i8** [[TMP84]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.7, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.8, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP86:%.*]] = icmp ne i32 [[TMP85]], 0
// CHECK3-NEXT:    br i1 [[TMP86]], label [[OMP_OFFLOAD_FAILED16:%.*]], label [[OMP_OFFLOAD_CONT17:%.*]]
// CHECK3:       omp_offload.failed16:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118(i32 [[TMP69]], i32 [[TMP71]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT17]]
// CHECK3:       omp_offload.cont17:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118(i32 [[TMP69]], i32 [[TMP71]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP87:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP87]], i32* [[A_CASTED18]], align 4
// CHECK3-NEXT:    [[TMP88:%.*]] = load i32, i32* [[A_CASTED18]], align 4
// CHECK3-NEXT:    [[TMP89:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP19:%.*]] = icmp sgt i32 [[TMP89]], 20
// CHECK3-NEXT:    br i1 [[CMP19]], label [[OMP_IF_THEN20:%.*]], label [[OMP_IF_ELSE27:%.*]]
// CHECK3:       omp_if.then20:
// CHECK3-NEXT:    [[TMP90:%.*]] = mul nuw i32 [[TMP1]], 4
// CHECK3-NEXT:    [[TMP91:%.*]] = sext i32 [[TMP90]] to i64
// CHECK3-NEXT:    [[TMP92:%.*]] = mul nuw i32 5, [[TMP3]]
// CHECK3-NEXT:    [[TMP93:%.*]] = mul nuw i32 [[TMP92]], 8
// CHECK3-NEXT:    [[TMP94:%.*]] = sext i32 [[TMP93]] to i64
// CHECK3-NEXT:    [[TMP95:%.*]] = bitcast [9 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP95]], i8* align 4 bitcast ([9 x i64]* @.offload_sizes.10 to i8*), i32 72, i1 false)
// CHECK3-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP97:%.*]] = bitcast i8** [[TMP96]] to i32*
// CHECK3-NEXT:    store i32 [[TMP88]], i32* [[TMP97]], align 4
// CHECK3-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP99:%.*]] = bitcast i8** [[TMP98]] to i32*
// CHECK3-NEXT:    store i32 [[TMP88]], i32* [[TMP99]], align 4
// CHECK3-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP100]], align 4
// CHECK3-NEXT:    [[TMP101:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP102:%.*]] = bitcast i8** [[TMP101]] to [10 x float]**
// CHECK3-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP102]], align 4
// CHECK3-NEXT:    [[TMP103:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP104:%.*]] = bitcast i8** [[TMP103]] to [10 x float]**
// CHECK3-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP104]], align 4
// CHECK3-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP105]], align 4
// CHECK3-NEXT:    [[TMP106:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP107:%.*]] = bitcast i8** [[TMP106]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP107]], align 4
// CHECK3-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP109:%.*]] = bitcast i8** [[TMP108]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP109]], align 4
// CHECK3-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP110]], align 4
// CHECK3-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to float**
// CHECK3-NEXT:    store float* [[VLA]], float** [[TMP112]], align 4
// CHECK3-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to float**
// CHECK3-NEXT:    store float* [[VLA]], float** [[TMP114]], align 4
// CHECK3-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK3-NEXT:    store i64 [[TMP91]], i64* [[TMP115]], align 4
// CHECK3-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP116]], align 4
// CHECK3-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP118:%.*]] = bitcast i8** [[TMP117]] to [5 x [10 x double]]**
// CHECK3-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP118]], align 4
// CHECK3-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP120:%.*]] = bitcast i8** [[TMP119]] to [5 x [10 x double]]**
// CHECK3-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP120]], align 4
// CHECK3-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 4
// CHECK3-NEXT:    store i8* null, i8** [[TMP121]], align 4
// CHECK3-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 5
// CHECK3-NEXT:    [[TMP123:%.*]] = bitcast i8** [[TMP122]] to i32*
// CHECK3-NEXT:    store i32 5, i32* [[TMP123]], align 4
// CHECK3-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 5
// CHECK3-NEXT:    [[TMP125:%.*]] = bitcast i8** [[TMP124]] to i32*
// CHECK3-NEXT:    store i32 5, i32* [[TMP125]], align 4
// CHECK3-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 5
// CHECK3-NEXT:    store i8* null, i8** [[TMP126]], align 4
// CHECK3-NEXT:    [[TMP127:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP128:%.*]] = bitcast i8** [[TMP127]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP128]], align 4
// CHECK3-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP130:%.*]] = bitcast i8** [[TMP129]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP130]], align 4
// CHECK3-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 6
// CHECK3-NEXT:    store i8* null, i8** [[TMP131]], align 4
// CHECK3-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 7
// CHECK3-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to double**
// CHECK3-NEXT:    store double* [[VLA1]], double** [[TMP133]], align 4
// CHECK3-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 7
// CHECK3-NEXT:    [[TMP135:%.*]] = bitcast i8** [[TMP134]] to double**
// CHECK3-NEXT:    store double* [[VLA1]], double** [[TMP135]], align 4
// CHECK3-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK3-NEXT:    store i64 [[TMP94]], i64* [[TMP136]], align 4
// CHECK3-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 7
// CHECK3-NEXT:    store i8* null, i8** [[TMP137]], align 4
// CHECK3-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP139:%.*]] = bitcast i8** [[TMP138]] to %struct.TT**
// CHECK3-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP139]], align 4
// CHECK3-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP141:%.*]] = bitcast i8** [[TMP140]] to %struct.TT**
// CHECK3-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP141]], align 4
// CHECK3-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 8
// CHECK3-NEXT:    store i8* null, i8** [[TMP142]], align 4
// CHECK3-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP145:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK3-NEXT:    [[TMP146:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142.region_id, i32 9, i8** [[TMP143]], i8** [[TMP144]], i64* [[TMP145]], i64* getelementptr inbounds ([9 x i64], [9 x i64]* @.offload_maptypes.11, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP147:%.*]] = icmp ne i32 [[TMP146]], 0
// CHECK3-NEXT:    br i1 [[TMP147]], label [[OMP_OFFLOAD_FAILED25:%.*]], label [[OMP_OFFLOAD_CONT26:%.*]]
// CHECK3:       omp_offload.failed25:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142(i32 [[TMP88]], [10 x float]* [[B]], i32 [[TMP1]], float* [[VLA]], [5 x [10 x double]]* [[C]], i32 5, i32 [[TMP3]], double* [[VLA1]], %struct.TT* [[D]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT26]]
// CHECK3:       omp_offload.cont26:
// CHECK3-NEXT:    br label [[OMP_IF_END28:%.*]]
// CHECK3:       omp_if.else27:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142(i32 [[TMP88]], [10 x float]* [[B]], i32 [[TMP1]], float* [[VLA]], [5 x [10 x double]]* [[C]], i32 5, i32 [[TMP3]], double* [[VLA1]], %struct.TT* [[D]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END28]]
// CHECK3:       omp_if.end28:
// CHECK3-NEXT:    [[TMP148:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP149:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK3-NEXT:    call void @llvm.stackrestore(i8* [[TMP149]])
// CHECK3-NEXT:    ret i32 [[TMP148]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97
// CHECK3-SAME: (i32 noundef [[AA:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]], i32 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTCAPTURE_EXPR_1]], i32* [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK3-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), i32 [[TMP4]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !11
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !11
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK3-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK3-NEXT:    br i1 [[TMP10]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK3-SAME: (%struct..kmp_privates.t* noalias noundef [[TMP0:%.*]], i16** noalias noundef [[TMP1:%.*]], [3 x i8*]** noalias noundef [[TMP2:%.*]], [3 x i8*]** noalias noundef [[TMP3:%.*]], [3 x i64]** noalias noundef [[TMP4:%.*]]) #[[ATTR5:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca %struct..kmp_privates.t*, align 4
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca i16**, align 4
// CHECK3-NEXT:    [[DOTADDR2:%.*]] = alloca [3 x i8*]**, align 4
// CHECK3-NEXT:    [[DOTADDR3:%.*]] = alloca [3 x i8*]**, align 4
// CHECK3-NEXT:    [[DOTADDR4:%.*]] = alloca [3 x i64]**, align 4
// CHECK3-NEXT:    store %struct..kmp_privates.t* [[TMP0]], %struct..kmp_privates.t** [[DOTADDR]], align 4
// CHECK3-NEXT:    store i16** [[TMP1]], i16*** [[DOTADDR1]], align 4
// CHECK3-NEXT:    store [3 x i8*]** [[TMP2]], [3 x i8*]*** [[DOTADDR2]], align 4
// CHECK3-NEXT:    store [3 x i8*]** [[TMP3]], [3 x i8*]*** [[DOTADDR3]], align 4
// CHECK3-NEXT:    store [3 x i64]** [[TMP4]], [3 x i64]*** [[DOTADDR4]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load %struct..kmp_privates.t*, %struct..kmp_privates.t** [[DOTADDR]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load [3 x i64]**, [3 x i64]*** [[DOTADDR4]], align 4
// CHECK3-NEXT:    store [3 x i64]* [[TMP6]], [3 x i64]** [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP9:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR2]], align 4
// CHECK3-NEXT:    store [3 x i8*]* [[TMP8]], [3 x i8*]** [[TMP9]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP11:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR3]], align 4
// CHECK3-NEXT:    store [3 x i8*]* [[TMP10]], [3 x i8*]** [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP13:%.*]] = load i16**, i16*** [[DOTADDR1]], align 4
// CHECK3-NEXT:    store i16* [[TMP12]], i16** [[TMP13]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK3-SAME: (i32 noundef [[TMP0:%.*]], %struct.kmp_task_t_with_privates* noalias noundef [[TMP1:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca void (i8*, ...)*, align 4
// CHECK3-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca %struct.anon*, align 4
// CHECK3-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca i16*, align 4
// CHECK3-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca [3 x i8*]*, align 4
// CHECK3-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca [3 x i8*]*, align 4
// CHECK3-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca [3 x i64]*, align 4
// CHECK3-NEXT:    [[AA_CASTED_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED4_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca %struct.kmp_task_t_with_privates*, align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[DOTADDR]], align 4
// CHECK3-NEXT:    store %struct.kmp_task_t_with_privates* [[TMP1]], %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load %struct.kmp_task_t_with_privates*, %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load i8*, i8** [[TMP6]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = bitcast i8* [[TMP7]] to %struct.anon*
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast %struct..kmp_privates.t* [[TMP9]] to i8*
// CHECK3-NEXT:    [[TMP11:%.*]] = bitcast %struct.kmp_task_t_with_privates* [[TMP3]] to i8*
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META18:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META21:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META23:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META25:![0-9]+]])
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    store i32* [[TMP5]], i32** [[DOTPART_ID__ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    store i8* [[TMP10]], i8** [[DOTPRIVATES__ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    store void (i8*, ...)* bitcast (void (%struct..kmp_privates.t*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)* @.omp_task_privates_map. to void (i8*, ...)*), void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    store i8* [[TMP11]], i8** [[DOTTASK_T__ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    store %struct.anon* [[TMP8]], %struct.anon** [[__CONTEXT_ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP12:%.*]] = load %struct.anon*, %struct.anon** [[__CONTEXT_ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP13:%.*]] = load void (i8*, ...)*, void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[DOTPRIVATES__ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast void (i8*, ...)* [[TMP13]] to void (i8*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)*
// CHECK3-NEXT:    call void [[TMP15]](i8* [[TMP14]], i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK3-NEXT:    [[TMP16:%.*]] = load i16*, i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP17:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP18:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP19:%.*]] = load [3 x i64]*, [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP17]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP18]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[TMP19]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], %struct.anon* [[TMP12]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[TMP12]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10) #[[ATTR4]]
// CHECK3-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_nowait_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* [[TMP22]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP25]], i32 1, i32 0, i8* null, i32 0, i8* null) #[[ATTR4]]
// CHECK3-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK3-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED_I:%.*]], label [[DOTOMP_OUTLINED__1_EXIT:%.*]]
// CHECK3:       omp_offload.failed.i:
// CHECK3-NEXT:    [[TMP28:%.*]] = load i16, i16* [[TMP16]], align 2
// CHECK3-NEXT:    [[CONV_I:%.*]] = bitcast i32* [[AA_CASTED_I]] to i16*
// CHECK3-NEXT:    store i16 [[TMP28]], i16* [[CONV_I]], align 2, !noalias !27
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[AA_CASTED_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK3-NEXT:    store i32 [[TMP30]], i32* [[DOTCAPTURE_EXPR__CASTED_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK3-NEXT:    store i32 [[TMP32]], i32* [[DOTCAPTURE_EXPR__CASTED4_I]], align 4, !noalias !27
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED4_I]], align 4, !noalias !27
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97(i32 [[TMP29]], i32 [[TMP31]], i32 [[TMP33]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[DOTOMP_OUTLINED__1_EXIT]]
// CHECK3:       .omp_outlined..1.exit:
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l104
// CHECK3-SAME: (i32 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32 [[TMP1]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[A1]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A1]], align 4
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK3-NEXT:    store i32 [[ADD3]], i32* [[A1]], align 4
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK3-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK3-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 10, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111
// CHECK3-SAME: (i32 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP1]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !30
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !30
// CHECK3-NEXT:    [[TMP8:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !30
// CHECK3-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP8]] to i32
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV2]], 1
// CHECK3-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD3]] to i16
// CHECK3-NEXT:    store i16 [[CONV4]], i16* [[CONV]], align 2, !llvm.access.group !30
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK3-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK3-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP31:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK3-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118
// CHECK3-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !33
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !33
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !33
// CHECK3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK3-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4, !llvm.access.group !33
// CHECK3-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !33
// CHECK3-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP9]] to i32
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK3-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK3-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2, !llvm.access.group !33
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP34:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK3-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142
// CHECK3-SAME: (i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK3-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK3-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK3-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK3-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK3-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 9, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, [10 x float]*, i32, float*, [5 x [10 x double]]*, i32, i32, double*, %struct.TT*)* @.omp_outlined..9 to void (i32*, i32*, ...)*), i32 [[TMP9]], [10 x float]* [[TMP0]], i32 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i32 [[TMP4]], i32 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..9
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK3-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK3-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK3-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK3-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK3-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK3-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 0
// CHECK3-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i32 16) ]
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 9
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[A_ADDR]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[CONV:%.*]] = fpext float [[TMP17]] to double
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[CONV]], 1.000000e+00
// CHECK3-NEXT:    [[CONV8:%.*]] = fptrunc double [[ADD7]] to float
// CHECK3-NEXT:    store float [[CONV8]], float* [[ARRAYIDX]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP2]], i32 3
// CHECK3-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX9]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[CONV10:%.*]] = fpext float [[TMP18]] to double
// CHECK3-NEXT:    [[ADD11:%.*]] = fadd double [[CONV10]], 1.000000e+00
// CHECK3-NEXT:    [[CONV12:%.*]] = fptrunc double [[ADD11]] to float
// CHECK3-NEXT:    store float [[CONV12]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i32 0, i32 1
// CHECK3-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX13]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP19:%.*]] = load double, double* [[ARRAYIDX14]], align 8, !llvm.access.group !36
// CHECK3-NEXT:    [[ADD15:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD15]], double* [[ARRAYIDX14]], align 8, !llvm.access.group !36
// CHECK3-NEXT:    [[TMP20:%.*]] = mul nsw i32 1, [[TMP5]]
// CHECK3-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds double, double* [[TMP6]], i32 [[TMP20]]
// CHECK3-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX16]], i32 3
// CHECK3-NEXT:    [[TMP21:%.*]] = load double, double* [[ARRAYIDX17]], align 8, !llvm.access.group !36
// CHECK3-NEXT:    [[ADD18:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD18]], double* [[ARRAYIDX17]], align 8, !llvm.access.group !36
// CHECK3-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP22:%.*]] = load i64, i64* [[X]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[ADD19:%.*]] = add nsw i64 [[TMP22]], 1
// CHECK3-NEXT:    store i64 [[ADD19]], i64* [[X]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP23:%.*]] = load i8, i8* [[Y]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[CONV20:%.*]] = sext i8 [[TMP23]] to i32
// CHECK3-NEXT:    [[ADD21:%.*]] = add nsw i32 [[CONV20]], 1
// CHECK3-NEXT:    [[CONV22:%.*]] = trunc i32 [[ADD21]] to i8
// CHECK3-NEXT:    store i8 [[CONV22]], i8* [[Y]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    [[ADD23:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK3-NEXT:    store i32 [[ADD23]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP37:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]])
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK3-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z3bari
// CHECK3-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP0]])
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CALL1:%.*]] = call noundef i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 4 dereferenceable(8) [[S]], i32 noundef [[TMP2]])
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK3-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CALL3:%.*]] = call noundef i32 @_ZL7fstatici(i32 noundef [[TMP4]])
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK3-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CALL5:%.*]] = call noundef i32 @_Z9ftemplateIiET_i(i32 noundef [[TMP6]])
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK3-SAME: (%struct.S1* noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK3-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [5 x i64], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK3-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK3-NEXT:    [[VLA:%.*]] = alloca i16, i32 [[TMP3]], align 2
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 60
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK3-NEXT:    [[TMP8:%.*]] = mul nuw i32 [[TMP7]], 2
// CHECK3-NEXT:    [[TMP9:%.*]] = sext i32 [[TMP8]] to i64
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast [5 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK3-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP10]], i8* align 4 bitcast ([5 x i64]* @.offload_sizes.13 to i8*), i32 40, i1 false)
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to %struct.S1**
// CHECK3-NEXT:    store %struct.S1* [[THIS1]], %struct.S1** [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to double**
// CHECK3-NEXT:    store double* [[A]], double** [[TMP14]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32*
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32*
// CHECK3-NEXT:    store i32 2, i32* [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32*
// CHECK3-NEXT:    store i32 2, i32* [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP27]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i16**
// CHECK3-NEXT:    store i16* [[VLA]], i16** [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i16**
// CHECK3-NEXT:    store i16* [[VLA]], i16** [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK3-NEXT:    store i64 [[TMP9]], i64* [[TMP35]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK3-NEXT:    store i8* null, i8** [[TMP36]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [5 x i64], [5 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK3-NEXT:    [[TMP40:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215.region_id, i32 5, i8** [[TMP37]], i8** [[TMP38]], i64* [[TMP39]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.14, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP41:%.*]] = icmp ne i32 [[TMP40]], 0
// CHECK3-NEXT:    br i1 [[TMP41]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215(%struct.S1* [[THIS1]], i32 [[TMP5]], i32 2, i32 [[TMP1]], i16* [[VLA]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215(%struct.S1* [[THIS1]], i32 [[TMP5]], i32 2, i32 [[TMP1]], i16* [[VLA]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP42:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP42]]
// CHECK3-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK3-NEXT:    [[TMP43:%.*]] = load i16, i16* [[ARRAYIDX2]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP43]] to i32
// CHECK3-NEXT:    [[TMP44:%.*]] = load i32, i32* [[B]], align 4
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV]], [[TMP44]]
// CHECK3-NEXT:    [[TMP45:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK3-NEXT:    call void @llvm.stackrestore(i8* [[TMP45]])
// CHECK3-NEXT:    ret i32 [[ADD3]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK3-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK3-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK3-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[N_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP4]], i16* [[CONV]], align 2
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i8, i8* [[AAA]], align 1
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK3-NEXT:    store i8 [[TMP6]], i8* [[CONV1]], align 1
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 50
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i32*
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32*
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i32*
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[TMP27]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to [10 x i32]**
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to [10 x i32]**
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK3-NEXT:    store i8* null, i8** [[TMP33]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP36:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP36]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP37]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub i32 [[TMP38]], [[TMP39]]
// CHECK3-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK3-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK3-NEXT:    [[SUB5:%.*]] = sub i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK3-NEXT:    [[TMP40:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK3-NEXT:    [[ADD6:%.*]] = add i32 [[TMP40]], 1
// CHECK3-NEXT:    [[TMP41:%.*]] = zext i32 [[ADD6]] to i64
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP41]])
// CHECK3-NEXT:    [[TMP42:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197.region_id, i32 5, i8** [[TMP34]], i8** [[TMP35]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.16, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.17, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP43:%.*]] = icmp ne i32 [[TMP42]], 0
// CHECK3-NEXT:    br i1 [[TMP43]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197(i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]], i32 [[TMP7]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197(i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]], i32 [[TMP7]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP44:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    ret i32 [[TMP44]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK3-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK3-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP2]], i16* [[CONV]], align 2
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 40
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP6]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP9]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [10 x i32]**
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP16]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [10 x i32]**
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK3-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.19, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.20, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK3-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[A]], align 4
// CHECK3-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215
// CHECK3-SAME: (%struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK3-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i32, i32, i32, i16*)* @.omp_outlined..12 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i32 [[TMP5]], i32 [[TMP1]], i32 [[TMP2]], i16* [[TMP3]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..12
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 9
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[B_ADDR]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK3-NEXT:    [[ADD4:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK3-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK3-NEXT:    store double [[ADD4]], double* [[A]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP13:%.*]] = load double, double* [[A5]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK3-NEXT:    store double [[INC]], double* [[A5]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[CONV6:%.*]] = fptosi double [[INC]] to i16
// CHECK3-NEXT:    [[TMP14:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP14]]
// CHECK3-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK3-NEXT:    store i16 [[CONV6]], i16* [[ARRAYIDX7]], align 2, !llvm.access.group !39
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK3-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !39
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP40:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK3-NEXT:    br i1 [[TMP17]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197
// CHECK3-SAME: (i32 noundef [[A:%.*]], i32 noundef [[N:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[N_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV2:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP5]], i16* [[CONV2]], align 2
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i8, i8* [[CONV1]], align 1
// CHECK3-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK3-NEXT:    store i8 [[TMP7]], i8* [[CONV3]], align 1
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32, i32, [10 x i32]*)* @.omp_outlined..15 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], i32 [[TMP8]], [10 x i32]* [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..15
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[N:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK3-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK3-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK3-NEXT:    [[SUB5:%.*]] = sub i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK3-NEXT:    [[CMP7:%.*]] = icmp ugt i32 [[TMP11]], [[TMP12]]
// CHECK3-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[ADD8:%.*]] = add i32 [[TMP17]], 1
// CHECK3-NEXT:    [[CMP9:%.*]] = icmp ult i32 [[TMP16]], [[ADD8]]
// CHECK3-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[MUL:%.*]] = mul i32 [[TMP19]], 1
// CHECK3-NEXT:    [[ADD10:%.*]] = add i32 [[TMP18]], [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD10]], i32* [[I6]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK3-NEXT:    store i32 [[ADD11]], i32* [[A_ADDR]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[TMP21:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !42
// CHECK3-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP21]] to i32
// CHECK3-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK3-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i16
// CHECK3-NEXT:    store i16 [[CONV14]], i16* [[CONV]], align 2, !llvm.access.group !42
// CHECK3-NEXT:    [[TMP22:%.*]] = load i8, i8* [[CONV1]], align 1, !llvm.access.group !42
// CHECK3-NEXT:    [[CONV15:%.*]] = sext i8 [[TMP22]] to i32
// CHECK3-NEXT:    [[ADD16:%.*]] = add nsw i32 [[CONV15]], 1
// CHECK3-NEXT:    [[CONV17:%.*]] = trunc i32 [[ADD16]] to i8
// CHECK3-NEXT:    store i8 [[CONV17]], i8* [[CONV1]], align 1, !llvm.access.group !42
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK3-NEXT:    store i32 [[ADD18]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    [[ADD19:%.*]] = add i32 [[TMP24]], 1
// CHECK3-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !42
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP43:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK3-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB20:%.*]] = sub i32 [[TMP30]], [[TMP31]]
// CHECK3-NEXT:    [[SUB21:%.*]] = sub i32 [[SUB20]], 1
// CHECK3-NEXT:    [[ADD22:%.*]] = add i32 [[SUB21]], 1
// CHECK3-NEXT:    [[DIV23:%.*]] = udiv i32 [[ADD22]], 1
// CHECK3-NEXT:    [[MUL24:%.*]] = mul i32 [[DIV23]], 1
// CHECK3-NEXT:    [[ADD25:%.*]] = add i32 [[TMP29]], [[MUL24]]
// CHECK3-NEXT:    store i32 [[ADD25]], i32* [[I6]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180
// CHECK3-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK3-NEXT:    store i16 [[TMP3]], i16* [[CONV1]], align 2
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..18 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..18
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK3-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK3-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK3-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK3-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !45
// CHECK3-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP10]] to i32
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK3-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK3-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2, !llvm.access.group !45
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK3-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !45
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP46:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK3-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR5]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK5-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK5-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK5-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK5-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK5-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__CASTED4:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK5-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 4
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED7:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS9:%.*]] = alloca [1 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS10:%.*]] = alloca [1 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS11:%.*]] = alloca [1 x i8*], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A_CASTED12:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED14:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS16:%.*]] = alloca [2 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS17:%.*]] = alloca [2 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS18:%.*]] = alloca [2 x i8*], align 8
// CHECK5-NEXT:    [[_TMP19:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A_CASTED22:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS26:%.*]] = alloca [9 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS27:%.*]] = alloca [9 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS28:%.*]] = alloca [9 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [9 x i64], align 8
// CHECK5-NEXT:    [[_TMP29:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK5-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK5-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK5-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK5-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK5-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP2]], align 4
// CHECK5-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[TMP5:%.*]] = zext i32 [[TMP4]] to i64
// CHECK5-NEXT:    [[TMP6:%.*]] = mul nuw i64 5, [[TMP5]]
// CHECK5-NEXT:    [[VLA1:%.*]] = alloca double, i64 [[TMP6]], align 8
// CHECK5-NEXT:    store i64 [[TMP5]], i64* [[__VLA_EXPR1]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    store i32 [[TMP7]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    store i32 [[TMP8]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK5-NEXT:    [[TMP9:%.*]] = load i16, i16* [[AA]], align 2
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP9]], i16* [[CONV]], align 2
// CHECK5-NEXT:    [[TMP10:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP11]], i32* [[CONV3]], align 4
// CHECK5-NEXT:    [[TMP12:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK5-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED4]] to i32*
// CHECK5-NEXT:    store i32 [[TMP13]], i32* [[CONV5]], align 4
// CHECK5-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED4]], align 8
// CHECK5-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i64*
// CHECK5-NEXT:    store i64 [[TMP10]], i64* [[TMP16]], align 8
// CHECK5-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i64*
// CHECK5-NEXT:    store i64 [[TMP10]], i64* [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK5-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i64*
// CHECK5-NEXT:    store i64 [[TMP12]], i64* [[TMP21]], align 8
// CHECK5-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i64*
// CHECK5-NEXT:    store i64 [[TMP12]], i64* [[TMP23]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK5-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP26:%.*]] = bitcast i8** [[TMP25]] to i64*
// CHECK5-NEXT:    store i64 [[TMP14]], i64* [[TMP26]], align 8
// CHECK5-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to i64*
// CHECK5-NEXT:    store i64 [[TMP14]], i64* [[TMP28]], align 8
// CHECK5-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP29]], align 8
// CHECK5-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP33:%.*]] = load i16, i16* [[AA]], align 2
// CHECK5-NEXT:    store i16 [[TMP33]], i16* [[TMP32]], align 4
// CHECK5-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    store i32 [[TMP35]], i32* [[TMP34]], align 4
// CHECK5-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK5-NEXT:    store i32 [[TMP37]], i32* [[TMP36]], align 4
// CHECK5-NEXT:    [[TMP38:%.*]] = call i8* @__kmpc_omp_target_task_alloc(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 1, i64 120, i64 12, i32 (i32, i8*)* bitcast (i32 (i32, %struct.kmp_task_t_with_privates*)* @.omp_task_entry. to i32 (i32, i8*)*), i64 -1)
// CHECK5-NEXT:    [[TMP39:%.*]] = bitcast i8* [[TMP38]] to %struct.kmp_task_t_with_privates*
// CHECK5-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP39]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP40]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[TMP41]], align 8
// CHECK5-NEXT:    [[TMP43:%.*]] = bitcast %struct.anon* [[AGG_CAPTURED]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP42]], i8* align 4 [[TMP43]], i64 12, i1 false)
// CHECK5-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP39]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP45:%.*]] = bitcast i8* [[TMP42]] to %struct.anon*
// CHECK5-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP47:%.*]] = bitcast [3 x i8*]* [[TMP46]] to i8*
// CHECK5-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP30]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP47]], i8* align 8 [[TMP48]], i64 24, i1 false)
// CHECK5-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP50:%.*]] = bitcast [3 x i8*]* [[TMP49]] to i8*
// CHECK5-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP31]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP50]], i8* align 8 [[TMP51]], i64 24, i1 false)
// CHECK5-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP53:%.*]] = bitcast [3 x i64]* [[TMP52]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP53]], i8* align 8 bitcast ([3 x i64]* @.offload_sizes to i8*), i64 24, i1 false)
// CHECK5-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP44]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP55:%.*]] = load i16, i16* [[AA]], align 2
// CHECK5-NEXT:    store i16 [[TMP55]], i16* [[TMP54]], align 8
// CHECK5-NEXT:    [[TMP56:%.*]] = call i32 @__kmpc_omp_task(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i8* [[TMP38]])
// CHECK5-NEXT:    [[TMP57:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[CONV6:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP57]], i32* [[CONV6]], align 4
// CHECK5-NEXT:    [[TMP58:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l102(i64 [[TMP58]]) #[[ATTR4:[0-9]+]]
// CHECK5-NEXT:    [[TMP59:%.*]] = load i16, i16* [[AA]], align 2
// CHECK5-NEXT:    [[CONV8:%.*]] = bitcast i64* [[AA_CASTED7]] to i16*
// CHECK5-NEXT:    store i16 [[TMP59]], i16* [[CONV8]], align 2
// CHECK5-NEXT:    [[TMP60:%.*]] = load i64, i64* [[AA_CASTED7]], align 8
// CHECK5-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to i64*
// CHECK5-NEXT:    store i64 [[TMP60]], i64* [[TMP62]], align 8
// CHECK5-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP64:%.*]] = bitcast i8** [[TMP63]] to i64*
// CHECK5-NEXT:    store i64 [[TMP60]], i64* [[TMP64]], align 8
// CHECK5-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP65]], align 8
// CHECK5-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK5-NEXT:    [[TMP68:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111.region_id, i32 1, i8** [[TMP66]], i8** [[TMP67]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP69:%.*]] = icmp ne i32 [[TMP68]], 0
// CHECK5-NEXT:    br i1 [[TMP69]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111(i64 [[TMP60]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    [[TMP70:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[CONV13:%.*]] = bitcast i64* [[A_CASTED12]] to i32*
// CHECK5-NEXT:    store i32 [[TMP70]], i32* [[CONV13]], align 4
// CHECK5-NEXT:    [[TMP71:%.*]] = load i64, i64* [[A_CASTED12]], align 8
// CHECK5-NEXT:    [[TMP72:%.*]] = load i16, i16* [[AA]], align 2
// CHECK5-NEXT:    [[CONV15:%.*]] = bitcast i64* [[AA_CASTED14]] to i16*
// CHECK5-NEXT:    store i16 [[TMP72]], i16* [[CONV15]], align 2
// CHECK5-NEXT:    [[TMP73:%.*]] = load i64, i64* [[AA_CASTED14]], align 8
// CHECK5-NEXT:    [[TMP74:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP74]], 10
// CHECK5-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS16]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP76:%.*]] = bitcast i8** [[TMP75]] to i64*
// CHECK5-NEXT:    store i64 [[TMP71]], i64* [[TMP76]], align 8
// CHECK5-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS17]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP78:%.*]] = bitcast i8** [[TMP77]] to i64*
// CHECK5-NEXT:    store i64 [[TMP71]], i64* [[TMP78]], align 8
// CHECK5-NEXT:    [[TMP79:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS18]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP79]], align 8
// CHECK5-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS16]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP81:%.*]] = bitcast i8** [[TMP80]] to i64*
// CHECK5-NEXT:    store i64 [[TMP73]], i64* [[TMP81]], align 8
// CHECK5-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS17]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP83:%.*]] = bitcast i8** [[TMP82]] to i64*
// CHECK5-NEXT:    store i64 [[TMP73]], i64* [[TMP83]], align 8
// CHECK5-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS18]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP84]], align 8
// CHECK5-NEXT:    [[TMP85:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS16]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP86:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS17]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK5-NEXT:    [[TMP87:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118.region_id, i32 2, i8** [[TMP85]], i8** [[TMP86]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.7, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.8, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP88:%.*]] = icmp ne i32 [[TMP87]], 0
// CHECK5-NEXT:    br i1 [[TMP88]], label [[OMP_OFFLOAD_FAILED20:%.*]], label [[OMP_OFFLOAD_CONT21:%.*]]
// CHECK5:       omp_offload.failed20:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118(i64 [[TMP71]], i64 [[TMP73]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT21]]
// CHECK5:       omp_offload.cont21:
// CHECK5-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK5:       omp_if.else:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118(i64 [[TMP71]], i64 [[TMP73]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_IF_END]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP89:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[CONV23:%.*]] = bitcast i64* [[A_CASTED22]] to i32*
// CHECK5-NEXT:    store i32 [[TMP89]], i32* [[CONV23]], align 4
// CHECK5-NEXT:    [[TMP90:%.*]] = load i64, i64* [[A_CASTED22]], align 8
// CHECK5-NEXT:    [[TMP91:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CMP24:%.*]] = icmp sgt i32 [[TMP91]], 20
// CHECK5-NEXT:    br i1 [[CMP24]], label [[OMP_IF_THEN25:%.*]], label [[OMP_IF_ELSE32:%.*]]
// CHECK5:       omp_if.then25:
// CHECK5-NEXT:    [[TMP92:%.*]] = mul nuw i64 [[TMP2]], 4
// CHECK5-NEXT:    [[TMP93:%.*]] = mul nuw i64 5, [[TMP5]]
// CHECK5-NEXT:    [[TMP94:%.*]] = mul nuw i64 [[TMP93]], 8
// CHECK5-NEXT:    [[TMP95:%.*]] = bitcast [9 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP95]], i8* align 8 bitcast ([9 x i64]* @.offload_sizes.10 to i8*), i64 72, i1 false)
// CHECK5-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP97:%.*]] = bitcast i8** [[TMP96]] to i64*
// CHECK5-NEXT:    store i64 [[TMP90]], i64* [[TMP97]], align 8
// CHECK5-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP99:%.*]] = bitcast i8** [[TMP98]] to i64*
// CHECK5-NEXT:    store i64 [[TMP90]], i64* [[TMP99]], align 8
// CHECK5-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP100]], align 8
// CHECK5-NEXT:    [[TMP101:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP102:%.*]] = bitcast i8** [[TMP101]] to [10 x float]**
// CHECK5-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP102]], align 8
// CHECK5-NEXT:    [[TMP103:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP104:%.*]] = bitcast i8** [[TMP103]] to [10 x float]**
// CHECK5-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP104]], align 8
// CHECK5-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP105]], align 8
// CHECK5-NEXT:    [[TMP106:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP107:%.*]] = bitcast i8** [[TMP106]] to i64*
// CHECK5-NEXT:    store i64 [[TMP2]], i64* [[TMP107]], align 8
// CHECK5-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP109:%.*]] = bitcast i8** [[TMP108]] to i64*
// CHECK5-NEXT:    store i64 [[TMP2]], i64* [[TMP109]], align 8
// CHECK5-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP110]], align 8
// CHECK5-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to float**
// CHECK5-NEXT:    store float* [[VLA]], float** [[TMP112]], align 8
// CHECK5-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to float**
// CHECK5-NEXT:    store float* [[VLA]], float** [[TMP114]], align 8
// CHECK5-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK5-NEXT:    store i64 [[TMP92]], i64* [[TMP115]], align 8
// CHECK5-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 3
// CHECK5-NEXT:    store i8* null, i8** [[TMP116]], align 8
// CHECK5-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 4
// CHECK5-NEXT:    [[TMP118:%.*]] = bitcast i8** [[TMP117]] to [5 x [10 x double]]**
// CHECK5-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP118]], align 8
// CHECK5-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 4
// CHECK5-NEXT:    [[TMP120:%.*]] = bitcast i8** [[TMP119]] to [5 x [10 x double]]**
// CHECK5-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP120]], align 8
// CHECK5-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 4
// CHECK5-NEXT:    store i8* null, i8** [[TMP121]], align 8
// CHECK5-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 5
// CHECK5-NEXT:    [[TMP123:%.*]] = bitcast i8** [[TMP122]] to i64*
// CHECK5-NEXT:    store i64 5, i64* [[TMP123]], align 8
// CHECK5-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 5
// CHECK5-NEXT:    [[TMP125:%.*]] = bitcast i8** [[TMP124]] to i64*
// CHECK5-NEXT:    store i64 5, i64* [[TMP125]], align 8
// CHECK5-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 5
// CHECK5-NEXT:    store i8* null, i8** [[TMP126]], align 8
// CHECK5-NEXT:    [[TMP127:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 6
// CHECK5-NEXT:    [[TMP128:%.*]] = bitcast i8** [[TMP127]] to i64*
// CHECK5-NEXT:    store i64 [[TMP5]], i64* [[TMP128]], align 8
// CHECK5-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 6
// CHECK5-NEXT:    [[TMP130:%.*]] = bitcast i8** [[TMP129]] to i64*
// CHECK5-NEXT:    store i64 [[TMP5]], i64* [[TMP130]], align 8
// CHECK5-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 6
// CHECK5-NEXT:    store i8* null, i8** [[TMP131]], align 8
// CHECK5-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 7
// CHECK5-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to double**
// CHECK5-NEXT:    store double* [[VLA1]], double** [[TMP133]], align 8
// CHECK5-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 7
// CHECK5-NEXT:    [[TMP135:%.*]] = bitcast i8** [[TMP134]] to double**
// CHECK5-NEXT:    store double* [[VLA1]], double** [[TMP135]], align 8
// CHECK5-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK5-NEXT:    store i64 [[TMP94]], i64* [[TMP136]], align 8
// CHECK5-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 7
// CHECK5-NEXT:    store i8* null, i8** [[TMP137]], align 8
// CHECK5-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 8
// CHECK5-NEXT:    [[TMP139:%.*]] = bitcast i8** [[TMP138]] to %struct.TT**
// CHECK5-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP139]], align 8
// CHECK5-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 8
// CHECK5-NEXT:    [[TMP141:%.*]] = bitcast i8** [[TMP140]] to %struct.TT**
// CHECK5-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP141]], align 8
// CHECK5-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS28]], i64 0, i64 8
// CHECK5-NEXT:    store i8* null, i8** [[TMP142]], align 8
// CHECK5-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS26]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS27]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP145:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK5-NEXT:    [[TMP146:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142.region_id, i32 9, i8** [[TMP143]], i8** [[TMP144]], i64* [[TMP145]], i64* getelementptr inbounds ([9 x i64], [9 x i64]* @.offload_maptypes.11, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP147:%.*]] = icmp ne i32 [[TMP146]], 0
// CHECK5-NEXT:    br i1 [[TMP147]], label [[OMP_OFFLOAD_FAILED30:%.*]], label [[OMP_OFFLOAD_CONT31:%.*]]
// CHECK5:       omp_offload.failed30:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142(i64 [[TMP90]], [10 x float]* [[B]], i64 [[TMP2]], float* [[VLA]], [5 x [10 x double]]* [[C]], i64 5, i64 [[TMP5]], double* [[VLA1]], %struct.TT* [[D]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT31]]
// CHECK5:       omp_offload.cont31:
// CHECK5-NEXT:    br label [[OMP_IF_END33:%.*]]
// CHECK5:       omp_if.else32:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142(i64 [[TMP90]], [10 x float]* [[B]], i64 [[TMP2]], float* [[VLA]], [5 x [10 x double]]* [[C]], i64 5, i64 [[TMP5]], double* [[VLA1]], %struct.TT* [[D]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_IF_END33]]
// CHECK5:       omp_if.end33:
// CHECK5-NEXT:    [[TMP148:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[TMP149:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK5-NEXT:    call void @llvm.stackrestore(i8* [[TMP149]])
// CHECK5-NEXT:    ret i32 [[TMP148]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97
// CHECK5-SAME: (i64 noundef [[AA:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[DOTCAPTURE_EXPR_1]], i64* [[DOTCAPTURE_EXPR__ADDR2]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK5-NEXT:    [[CONV4:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR2]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV3]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV4]], align 4
// CHECK5-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK5-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK5-NEXT:    [[CONV5:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP3]], i16* [[CONV5]], align 2
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), i64 [[TMP4]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK5-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK5-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK5-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK5-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK5-NEXT:    br i1 [[TMP10]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK5-SAME: (%struct..kmp_privates.t* noalias noundef [[TMP0:%.*]], i16** noalias noundef [[TMP1:%.*]], [3 x i8*]** noalias noundef [[TMP2:%.*]], [3 x i8*]** noalias noundef [[TMP3:%.*]], [3 x i64]** noalias noundef [[TMP4:%.*]]) #[[ATTR5:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca %struct..kmp_privates.t*, align 8
// CHECK5-NEXT:    [[DOTADDR1:%.*]] = alloca i16**, align 8
// CHECK5-NEXT:    [[DOTADDR2:%.*]] = alloca [3 x i8*]**, align 8
// CHECK5-NEXT:    [[DOTADDR3:%.*]] = alloca [3 x i8*]**, align 8
// CHECK5-NEXT:    [[DOTADDR4:%.*]] = alloca [3 x i64]**, align 8
// CHECK5-NEXT:    store %struct..kmp_privates.t* [[TMP0]], %struct..kmp_privates.t** [[DOTADDR]], align 8
// CHECK5-NEXT:    store i16** [[TMP1]], i16*** [[DOTADDR1]], align 8
// CHECK5-NEXT:    store [3 x i8*]** [[TMP2]], [3 x i8*]*** [[DOTADDR2]], align 8
// CHECK5-NEXT:    store [3 x i8*]** [[TMP3]], [3 x i8*]*** [[DOTADDR3]], align 8
// CHECK5-NEXT:    store [3 x i64]** [[TMP4]], [3 x i64]*** [[DOTADDR4]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load %struct..kmp_privates.t*, %struct..kmp_privates.t** [[DOTADDR]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP7:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR2]], align 8
// CHECK5-NEXT:    store [3 x i8*]* [[TMP6]], [3 x i8*]** [[TMP7]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP9:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR3]], align 8
// CHECK5-NEXT:    store [3 x i8*]* [[TMP8]], [3 x i8*]** [[TMP9]], align 8
// CHECK5-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP11:%.*]] = load [3 x i64]**, [3 x i64]*** [[DOTADDR4]], align 8
// CHECK5-NEXT:    store [3 x i64]* [[TMP10]], [3 x i64]** [[TMP11]], align 8
// CHECK5-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP13:%.*]] = load i16**, i16*** [[DOTADDR1]], align 8
// CHECK5-NEXT:    store i16* [[TMP12]], i16** [[TMP13]], align 8
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK5-SAME: (i32 noundef signext [[TMP0:%.*]], %struct.kmp_task_t_with_privates* noalias noundef [[TMP1:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca i8*, align 8
// CHECK5-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca void (i8*, ...)*, align 8
// CHECK5-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca i8*, align 8
// CHECK5-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca %struct.anon*, align 8
// CHECK5-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca i16*, align 8
// CHECK5-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca [3 x i8*]*, align 8
// CHECK5-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca [3 x i8*]*, align 8
// CHECK5-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca [3 x i64]*, align 8
// CHECK5-NEXT:    [[AA_CASTED_I:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__CASTED_I:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__CASTED5_I:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTADDR1:%.*]] = alloca %struct.kmp_task_t_with_privates*, align 8
// CHECK5-NEXT:    store i32 [[TMP0]], i32* [[DOTADDR]], align 4
// CHECK5-NEXT:    store %struct.kmp_task_t_with_privates* [[TMP1]], %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTADDR]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load %struct.kmp_task_t_with_privates*, %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP7:%.*]] = load i8*, i8** [[TMP6]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = bitcast i8* [[TMP7]] to %struct.anon*
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP10:%.*]] = bitcast %struct..kmp_privates.t* [[TMP9]] to i8*
// CHECK5-NEXT:    [[TMP11:%.*]] = bitcast %struct.kmp_task_t_with_privates* [[TMP3]] to i8*
// CHECK5-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META17:![0-9]+]])
// CHECK5-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META20:![0-9]+]])
// CHECK5-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META22:![0-9]+]])
// CHECK5-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META24:![0-9]+]])
// CHECK5-NEXT:    store i32 [[TMP2]], i32* [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !26
// CHECK5-NEXT:    store i32* [[TMP5]], i32** [[DOTPART_ID__ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    store i8* [[TMP10]], i8** [[DOTPRIVATES__ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    store void (i8*, ...)* bitcast (void (%struct..kmp_privates.t*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)* @.omp_task_privates_map. to void (i8*, ...)*), void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    store i8* [[TMP11]], i8** [[DOTTASK_T__ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    store %struct.anon* [[TMP8]], %struct.anon** [[__CONTEXT_ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP12:%.*]] = load %struct.anon*, %struct.anon** [[__CONTEXT_ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP13:%.*]] = load void (i8*, ...)*, void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[DOTPRIVATES__ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP15:%.*]] = bitcast void (i8*, ...)* [[TMP13]] to void (i8*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)*
// CHECK5-NEXT:    call void [[TMP15]](i8* [[TMP14]], i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK5-NEXT:    [[TMP16:%.*]] = load i16*, i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP17:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP18:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP19:%.*]] = load [3 x i64]*, [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP17]], i64 0, i64 0
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP18]], i64 0, i64 0
// CHECK5-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[TMP19]], i64 0, i64 0
// CHECK5-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], %struct.anon* [[TMP12]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[TMP12]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10) #[[ATTR4]]
// CHECK5-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_nowait_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* [[TMP22]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP25]], i32 1, i32 0, i8* null, i32 0, i8* null) #[[ATTR4]]
// CHECK5-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK5-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED_I:%.*]], label [[DOTOMP_OUTLINED__1_EXIT:%.*]]
// CHECK5:       omp_offload.failed.i:
// CHECK5-NEXT:    [[TMP28:%.*]] = load i16, i16* [[TMP16]], align 2
// CHECK5-NEXT:    [[CONV_I:%.*]] = bitcast i64* [[AA_CASTED_I]] to i16*
// CHECK5-NEXT:    store i16 [[TMP28]], i16* [[CONV_I]], align 2, !noalias !26
// CHECK5-NEXT:    [[TMP29:%.*]] = load i64, i64* [[AA_CASTED_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK5-NEXT:    [[CONV4_I:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED_I]] to i32*
// CHECK5-NEXT:    store i32 [[TMP30]], i32* [[CONV4_I]], align 4, !noalias !26
// CHECK5-NEXT:    [[TMP31:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED_I]], align 8, !noalias !26
// CHECK5-NEXT:    [[TMP32:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK5-NEXT:    [[CONV6_I:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED5_I]] to i32*
// CHECK5-NEXT:    store i32 [[TMP32]], i32* [[CONV6_I]], align 4, !noalias !26
// CHECK5-NEXT:    [[TMP33:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED5_I]], align 8, !noalias !26
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97(i64 [[TMP29]], i64 [[TMP31]], i64 [[TMP33]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[DOTOMP_OUTLINED__1_EXIT]]
// CHECK5:       .omp_outlined..1.exit:
// CHECK5-NEXT:    ret i32 0
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l102
// CHECK5-SAME: (i64 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP0]], i32* [[CONV1]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i64 [[TMP1]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A1:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK5-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[A1]], align 4, !nontemporal !27
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A1]], align 4, !nontemporal !27
// CHECK5-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK5-NEXT:    store i32 [[ADD3]], i32* [[A1]], align 4, !nontemporal !27
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK5-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK5-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 10, i32* [[CONV]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111
// CHECK5-SAME: (i64 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP1]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !30
// CHECK5-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK5-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !30
// CHECK5-NEXT:    [[TMP8:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !30
// CHECK5-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP8]] to i32
// CHECK5-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV2]], 1
// CHECK5-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD3]] to i16
// CHECK5-NEXT:    store i16 [[CONV4]], i16* [[CONV]], align 2, !llvm.access.group !30
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK5-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK5-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP31:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK5-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118
// CHECK5-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP0]], i32* [[CONV2]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP2]], i16* [[CONV3]], align 2
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !33
// CHECK5-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK5-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !33
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !33
// CHECK5-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK5-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4, !llvm.access.group !33
// CHECK5-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV1]], align 2, !llvm.access.group !33
// CHECK5-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP9]] to i32
// CHECK5-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK5-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK5-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2, !llvm.access.group !33
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK5-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK5-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP34:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK5-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142
// CHECK5-SAME: (i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]]) #[[ATTR2]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK5-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK5-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK5-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK5-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK5-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK5-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK5-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP8]], i32* [[CONV5]], align 4
// CHECK5-NEXT:    [[TMP9:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 9, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, [10 x float]*, i64, float*, [5 x [10 x double]]*, i64, i64, double*, %struct.TT*)* @.omp_outlined..9 to void (i32*, i32*, ...)*), i64 [[TMP9]], [10 x float]* [[TMP0]], i64 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i64 [[TMP4]], i64 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..9
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK5-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK5-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK5-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK5-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK5-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK5-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK5-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK5-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 0
// CHECK5-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i64 16) ]
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 9
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK5-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[TMP16:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK5-NEXT:    store i32 [[ADD6]], i32* [[CONV]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 2
// CHECK5-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[CONV7:%.*]] = fpext float [[TMP17]] to double
// CHECK5-NEXT:    [[ADD8:%.*]] = fadd double [[CONV7]], 1.000000e+00
// CHECK5-NEXT:    [[CONV9:%.*]] = fptrunc double [[ADD8]] to float
// CHECK5-NEXT:    store float [[CONV9]], float* [[ARRAYIDX]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP2]], i64 3
// CHECK5-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX10]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[CONV11:%.*]] = fpext float [[TMP18]] to double
// CHECK5-NEXT:    [[ADD12:%.*]] = fadd double [[CONV11]], 1.000000e+00
// CHECK5-NEXT:    [[CONV13:%.*]] = fptrunc double [[ADD12]] to float
// CHECK5-NEXT:    store float [[CONV13]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i64 0, i64 1
// CHECK5-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX14]], i64 0, i64 2
// CHECK5-NEXT:    [[TMP19:%.*]] = load double, double* [[ARRAYIDX15]], align 8, !llvm.access.group !36
// CHECK5-NEXT:    [[ADD16:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK5-NEXT:    store double [[ADD16]], double* [[ARRAYIDX15]], align 8, !llvm.access.group !36
// CHECK5-NEXT:    [[TMP20:%.*]] = mul nsw i64 1, [[TMP5]]
// CHECK5-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[TMP6]], i64 [[TMP20]]
// CHECK5-NEXT:    [[ARRAYIDX18:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX17]], i64 3
// CHECK5-NEXT:    [[TMP21:%.*]] = load double, double* [[ARRAYIDX18]], align 8, !llvm.access.group !36
// CHECK5-NEXT:    [[ADD19:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK5-NEXT:    store double [[ADD19]], double* [[ARRAYIDX18]], align 8, !llvm.access.group !36
// CHECK5-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP22:%.*]] = load i64, i64* [[X]], align 8, !llvm.access.group !36
// CHECK5-NEXT:    [[ADD20:%.*]] = add nsw i64 [[TMP22]], 1
// CHECK5-NEXT:    store i64 [[ADD20]], i64* [[X]], align 8, !llvm.access.group !36
// CHECK5-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP23:%.*]] = load i8, i8* [[Y]], align 8, !llvm.access.group !36
// CHECK5-NEXT:    [[CONV21:%.*]] = sext i8 [[TMP23]] to i32
// CHECK5-NEXT:    [[ADD22:%.*]] = add nsw i32 [[CONV21]], 1
// CHECK5-NEXT:    [[CONV23:%.*]] = trunc i32 [[ADD22]] to i8
// CHECK5-NEXT:    store i8 [[CONV23]], i8* [[Y]], align 8, !llvm.access.group !36
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK5-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP37:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]])
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK5-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z3bari
// CHECK5-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 8
// CHECK5-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z3fooi(i32 noundef signext [[TMP0]])
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CALL1:%.*]] = call noundef signext i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 8 dereferenceable(8) [[S]], i32 noundef signext [[TMP2]])
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK5-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CALL3:%.*]] = call noundef signext i32 @_ZL7fstatici(i32 noundef signext [[TMP4]])
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK5-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CALL5:%.*]] = call noundef signext i32 @_Z9ftemplateIiET_i(i32 noundef signext [[TMP6]])
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK5-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK5-SAME: (%struct.S1* noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK5-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [6 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [6 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [6 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [6 x i64], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK5-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK5-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK5-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP4]], align 2
// CHECK5-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 60
// CHECK5-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[CMP]] to i8
// CHECK5-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[B]], align 4
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP6]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP7:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP8]] to i1
// CHECK5-NEXT:    [[CONV2:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK5-NEXT:    [[FROMBOOL3:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK5-NEXT:    store i8 [[FROMBOOL3]], i8* [[CONV2]], align 1
// CHECK5-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK5-NEXT:    [[TMP10:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    [[TOBOOL4:%.*]] = trunc i8 [[TMP10]] to i1
// CHECK5-NEXT:    br i1 [[TOBOOL4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP11:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK5-NEXT:    [[TMP12:%.*]] = mul nuw i64 [[TMP11]], 2
// CHECK5-NEXT:    [[TMP13:%.*]] = bitcast [6 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 [[TMP13]], i8* align 8 bitcast ([6 x i64]* @.offload_sizes.13 to i8*), i64 48, i1 false)
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to %struct.S1**
// CHECK5-NEXT:    store %struct.S1* [[THIS1]], %struct.S1** [[TMP15]], align 8
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to double**
// CHECK5-NEXT:    store double* [[A]], double** [[TMP17]], align 8
// CHECK5-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK5-NEXT:    store i64 [[TMP7]], i64* [[TMP20]], align 8
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i64*
// CHECK5-NEXT:    store i64 [[TMP7]], i64* [[TMP22]], align 8
// CHECK5-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i64*
// CHECK5-NEXT:    store i64 2, i64* [[TMP25]], align 8
// CHECK5-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK5-NEXT:    store i64 2, i64* [[TMP27]], align 8
// CHECK5-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP28]], align 8
// CHECK5-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i64*
// CHECK5-NEXT:    store i64 [[TMP2]], i64* [[TMP30]], align 8
// CHECK5-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i64*
// CHECK5-NEXT:    store i64 [[TMP2]], i64* [[TMP32]], align 8
// CHECK5-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK5-NEXT:    store i8* null, i8** [[TMP33]], align 8
// CHECK5-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK5-NEXT:    [[TMP35:%.*]] = bitcast i8** [[TMP34]] to i16**
// CHECK5-NEXT:    store i16* [[VLA]], i16** [[TMP35]], align 8
// CHECK5-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK5-NEXT:    [[TMP37:%.*]] = bitcast i8** [[TMP36]] to i16**
// CHECK5-NEXT:    store i16* [[VLA]], i16** [[TMP37]], align 8
// CHECK5-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [6 x i64], [6 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK5-NEXT:    store i64 [[TMP12]], i64* [[TMP38]], align 8
// CHECK5-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK5-NEXT:    store i8* null, i8** [[TMP39]], align 8
// CHECK5-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK5-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to i64*
// CHECK5-NEXT:    store i64 [[TMP9]], i64* [[TMP41]], align 8
// CHECK5-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK5-NEXT:    [[TMP43:%.*]] = bitcast i8** [[TMP42]] to i64*
// CHECK5-NEXT:    store i64 [[TMP9]], i64* [[TMP43]], align 8
// CHECK5-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK5-NEXT:    store i8* null, i8** [[TMP44]], align 8
// CHECK5-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [6 x i64], [6 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK5-NEXT:    [[TMP48:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215.region_id, i32 6, i8** [[TMP45]], i8** [[TMP46]], i64* [[TMP47]], i64* getelementptr inbounds ([6 x i64], [6 x i64]* @.offload_maptypes.14, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP49:%.*]] = icmp ne i32 [[TMP48]], 0
// CHECK5-NEXT:    br i1 [[TMP49]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215(%struct.S1* [[THIS1]], i64 [[TMP7]], i64 2, i64 [[TMP2]], i16* [[VLA]], i64 [[TMP9]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK5:       omp_if.else:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215(%struct.S1* [[THIS1]], i64 [[TMP7]], i64 2, i64 [[TMP2]], i16* [[VLA]], i64 [[TMP9]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_IF_END]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP50:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP50]]
// CHECK5-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK5-NEXT:    [[TMP51:%.*]] = load i16, i16* [[ARRAYIDX5]], align 2
// CHECK5-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP51]] to i32
// CHECK5-NEXT:    [[TMP52:%.*]] = load i32, i32* [[B]], align 4
// CHECK5-NEXT:    [[ADD7:%.*]] = add nsw i32 [[CONV6]], [[TMP52]]
// CHECK5-NEXT:    [[TMP53:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK5-NEXT:    call void @llvm.stackrestore(i8* [[TMP53]])
// CHECK5-NEXT:    ret i32 [[ADD7]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK5-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK5-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK5-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK5-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP2]], i32* [[CONV1]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load i16, i16* [[AA]], align 2
// CHECK5-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP4]], i16* [[CONV2]], align 2
// CHECK5-NEXT:    [[TMP5:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = load i8, i8* [[AAA]], align 1
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK5-NEXT:    store i8 [[TMP6]], i8* [[CONV3]], align 1
// CHECK5-NEXT:    [[TMP7:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 50
// CHECK5-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK5-NEXT:    store i64 [[TMP1]], i64* [[TMP10]], align 8
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK5-NEXT:    store i64 [[TMP1]], i64* [[TMP12]], align 8
// CHECK5-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP15]], align 8
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP17]], align 8
// CHECK5-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i64*
// CHECK5-NEXT:    store i64 [[TMP5]], i64* [[TMP20]], align 8
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i64*
// CHECK5-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 8
// CHECK5-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i64*
// CHECK5-NEXT:    store i64 [[TMP7]], i64* [[TMP25]], align 8
// CHECK5-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK5-NEXT:    store i64 [[TMP7]], i64* [[TMP27]], align 8
// CHECK5-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK5-NEXT:    store i8* null, i8** [[TMP28]], align 8
// CHECK5-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK5-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to [10 x i32]**
// CHECK5-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP30]], align 8
// CHECK5-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK5-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to [10 x i32]**
// CHECK5-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP32]], align 8
// CHECK5-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK5-NEXT:    store i8* null, i8** [[TMP33]], align 8
// CHECK5-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP36:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    store i32 [[TMP36]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[TMP37:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP37]], i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK5-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK5-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[SUB:%.*]] = sub i32 [[TMP38]], [[TMP39]]
// CHECK5-NEXT:    [[SUB6:%.*]] = sub i32 [[SUB]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add i32 [[SUB6]], 1
// CHECK5-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK5-NEXT:    [[SUB7:%.*]] = sub i32 [[DIV]], 1
// CHECK5-NEXT:    store i32 [[SUB7]], i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK5-NEXT:    [[TMP40:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK5-NEXT:    [[ADD8:%.*]] = add i32 [[TMP40]], 1
// CHECK5-NEXT:    [[TMP41:%.*]] = zext i32 [[ADD8]] to i64
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP41]])
// CHECK5-NEXT:    [[TMP42:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197.region_id, i32 5, i8** [[TMP34]], i8** [[TMP35]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.16, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.17, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP43:%.*]] = icmp ne i32 [[TMP42]], 0
// CHECK5-NEXT:    br i1 [[TMP43]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], i64 [[TMP7]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK5:       omp_if.else:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], i64 [[TMP7]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_IF_END]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP44:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    ret i32 [[TMP44]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK5-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK5-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK5-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 40
// CHECK5-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i64*
// CHECK5-NEXT:    store i64 [[TMP1]], i64* [[TMP6]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK5-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP9]], align 8
// CHECK5-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP11]], align 8
// CHECK5-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK5-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [10 x i32]**
// CHECK5-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP16]], align 8
// CHECK5-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [10 x i32]**
// CHECK5-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK5-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK5-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.19, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.20, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK5-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK5-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK5:       omp_if.else:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_IF_END]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[A]], align 4
// CHECK5-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215
// CHECK5-SAME: (%struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK5-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV4:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP4]], i32* [[CONV4]], align 4
// CHECK5-NEXT:    [[TMP5:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = load i8, i8* [[CONV3]], align 1
// CHECK5-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK5-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK5-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK5-NEXT:    store i8 [[FROMBOOL]], i8* [[CONV5]], align 1
// CHECK5-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i64, i64, i64, i16*, i64)* @.omp_outlined..12 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i64 [[TMP5]], i64 [[TMP1]], i64 [[TMP2]], i16* [[TMP3]], i64 [[TMP7]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..12
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK5-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 9
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP9:%.*]] = load i8, i8* [[CONV3]], align 1
// CHECK5-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK5-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !39
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !39
// CHECK5-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK5-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !39
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !39
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !39
// CHECK5-NEXT:    [[CONV5:%.*]] = sitofp i32 [[TMP13]] to double
// CHECK5-NEXT:    [[ADD6:%.*]] = fadd double [[CONV5]], 1.500000e+00
// CHECK5-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK5-NEXT:    store double [[ADD6]], double* [[A]], align 8, !llvm.access.group !39
// CHECK5-NEXT:    [[A7:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP14:%.*]] = load double, double* [[A7]], align 8, !llvm.access.group !39
// CHECK5-NEXT:    [[INC:%.*]] = fadd double [[TMP14]], 1.000000e+00
// CHECK5-NEXT:    store double [[INC]], double* [[A7]], align 8, !llvm.access.group !39
// CHECK5-NEXT:    [[CONV8:%.*]] = fptosi double [[INC]] to i16
// CHECK5-NEXT:    [[TMP15:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP15]]
// CHECK5-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK5-NEXT:    store i16 [[CONV8]], i16* [[ARRAYIDX9]], align 2, !llvm.access.group !39
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !39
// CHECK5-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK5-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !39
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP40:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK5:       omp_if.else:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND11:%.*]]
// CHECK5:       omp.inner.for.cond11:
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK5-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY13:%.*]], label [[OMP_INNER_FOR_END27:%.*]]
// CHECK5:       omp.inner.for.body13:
// CHECK5-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[MUL14:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK5-NEXT:    [[ADD15:%.*]] = add nsw i32 0, [[MUL14]]
// CHECK5-NEXT:    store i32 [[ADD15]], i32* [[I]], align 4
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV16:%.*]] = sitofp i32 [[TMP20]] to double
// CHECK5-NEXT:    [[ADD17:%.*]] = fadd double [[CONV16]], 1.500000e+00
// CHECK5-NEXT:    [[A18:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK5-NEXT:    store double [[ADD17]], double* [[A18]], align 8
// CHECK5-NEXT:    [[A19:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP21:%.*]] = load double, double* [[A19]], align 8
// CHECK5-NEXT:    [[INC20:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK5-NEXT:    store double [[INC20]], double* [[A19]], align 8
// CHECK5-NEXT:    [[CONV21:%.*]] = fptosi double [[INC20]] to i16
// CHECK5-NEXT:    [[TMP22:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK5-NEXT:    [[ARRAYIDX22:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP22]]
// CHECK5-NEXT:    [[ARRAYIDX23:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX22]], i64 1
// CHECK5-NEXT:    store i16 [[CONV21]], i16* [[ARRAYIDX23]], align 2
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE24:%.*]]
// CHECK5:       omp.body.continue24:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC25:%.*]]
// CHECK5:       omp.inner.for.inc25:
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK5-NEXT:    store i32 [[ADD26]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND11]], !llvm.loop [[LOOP42:![0-9]+]]
// CHECK5:       omp.inner.for.end27:
// CHECK5-NEXT:    br label [[OMP_IF_END]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK5-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197
// CHECK5-SAME: (i64 noundef [[A:%.*]], i64 noundef [[N:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK5-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK5-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK5-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV4:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP1]], i32* [[CONV4]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK5-NEXT:    [[CONV5:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP3]], i32* [[CONV5]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i16, i16* [[CONV2]], align 2
// CHECK5-NEXT:    [[CONV6:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP5]], i16* [[CONV6]], align 2
// CHECK5-NEXT:    [[TMP6:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = load i8, i8* [[CONV3]], align 1
// CHECK5-NEXT:    [[CONV7:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK5-NEXT:    store i8 [[TMP7]], i8* [[CONV7]], align 1
// CHECK5-NEXT:    [[TMP8:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, i64, [10 x i32]*)* @.omp_outlined..15 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP8]], [10 x i32]* [[TMP0]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..15
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[N:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I8:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK5-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK5-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK5-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK5-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK5-NEXT:    [[SUB6:%.*]] = sub i32 [[SUB]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add i32 [[SUB6]], 1
// CHECK5-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK5-NEXT:    [[SUB7:%.*]] = sub i32 [[DIV]], 1
// CHECK5-NEXT:    store i32 [[SUB7]], i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK5-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK5:       omp.precond.then:
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK5-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK5-NEXT:    [[CMP9:%.*]] = icmp ugt i32 [[TMP11]], [[TMP12]]
// CHECK5-NEXT:    br i1 [[CMP9]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[ADD10:%.*]] = add i32 [[TMP17]], 1
// CHECK5-NEXT:    [[CMP11:%.*]] = icmp ult i32 [[TMP16]], [[ADD10]]
// CHECK5-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[MUL:%.*]] = mul i32 [[TMP19]], 1
// CHECK5-NEXT:    [[ADD12:%.*]] = add i32 [[TMP18]], [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD12]], i32* [[I8]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK5-NEXT:    store i32 [[ADD13]], i32* [[CONV]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[TMP21:%.*]] = load i16, i16* [[CONV2]], align 2, !llvm.access.group !44
// CHECK5-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP21]] to i32
// CHECK5-NEXT:    [[ADD15:%.*]] = add nsw i32 [[CONV14]], 1
// CHECK5-NEXT:    [[CONV16:%.*]] = trunc i32 [[ADD15]] to i16
// CHECK5-NEXT:    store i16 [[CONV16]], i16* [[CONV2]], align 2, !llvm.access.group !44
// CHECK5-NEXT:    [[TMP22:%.*]] = load i8, i8* [[CONV3]], align 1, !llvm.access.group !44
// CHECK5-NEXT:    [[CONV17:%.*]] = sext i8 [[TMP22]] to i32
// CHECK5-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV17]], 1
// CHECK5-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK5-NEXT:    store i8 [[CONV19]], i8* [[CONV3]], align 1, !llvm.access.group !44
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[ADD20:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK5-NEXT:    store i32 [[ADD20]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    [[ADD21:%.*]] = add i32 [[TMP24]], 1
// CHECK5-NEXT:    store i32 [[ADD21]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !44
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP45:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK5-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK5-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK5-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[SUB22:%.*]] = sub i32 [[TMP30]], [[TMP31]]
// CHECK5-NEXT:    [[SUB23:%.*]] = sub i32 [[SUB22]], 1
// CHECK5-NEXT:    [[ADD24:%.*]] = add i32 [[SUB23]], 1
// CHECK5-NEXT:    [[DIV25:%.*]] = udiv i32 [[ADD24]], 1
// CHECK5-NEXT:    [[MUL26:%.*]] = mul i32 [[DIV25]], 1
// CHECK5-NEXT:    [[ADD27:%.*]] = add i32 [[TMP29]], [[MUL26]]
// CHECK5-NEXT:    store i32 [[ADD27]], i32* [[I8]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK5:       omp.precond.end:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180
// CHECK5-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP1]], i32* [[CONV2]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK5-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..18 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..18
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK5-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK5-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK5-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK5-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV1]], align 2, !llvm.access.group !47
// CHECK5-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP10]] to i32
// CHECK5-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK5-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK5-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2, !llvm.access.group !47
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK5-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK5-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !47
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP48:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK5-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK5-SAME: () #[[ATTR5]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK5-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK7-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK7-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK7-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK7-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK7-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__CASTED3:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK7-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED4:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS6:%.*]] = alloca [1 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS7:%.*]] = alloca [1 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS8:%.*]] = alloca [1 x i8*], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A_CASTED9:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED10:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS12:%.*]] = alloca [2 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS13:%.*]] = alloca [2 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS14:%.*]] = alloca [2 x i8*], align 4
// CHECK7-NEXT:    [[_TMP15:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A_CASTED18:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS21:%.*]] = alloca [9 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS22:%.*]] = alloca [9 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS23:%.*]] = alloca [9 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [9 x i64], align 4
// CHECK7-NEXT:    [[_TMP24:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK7-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK7-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK7-NEXT:    [[VLA:%.*]] = alloca float, i32 [[TMP1]], align 4
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = mul nuw i32 5, [[TMP3]]
// CHECK7-NEXT:    [[VLA1:%.*]] = alloca double, i32 [[TMP4]], align 8
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[__VLA_EXPR1]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i16, i16* [[AA]], align 2
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP7]], i16* [[CONV]], align 2
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    store i32 [[TMP9]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    store i32 [[TMP11]], i32* [[DOTCAPTURE_EXPR__CASTED3]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED3]], align 4
// CHECK7-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to i32*
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[TMP14]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32*
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[TMP16]], align 4
// CHECK7-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP17]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32*
// CHECK7-NEXT:    store i32 [[TMP10]], i32* [[TMP19]], align 4
// CHECK7-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK7-NEXT:    store i32 [[TMP10]], i32* [[TMP21]], align 4
// CHECK7-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP22]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32*
// CHECK7-NEXT:    store i32 [[TMP12]], i32* [[TMP24]], align 4
// CHECK7-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP26:%.*]] = bitcast i8** [[TMP25]] to i32*
// CHECK7-NEXT:    store i32 [[TMP12]], i32* [[TMP26]], align 4
// CHECK7-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP27]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP31:%.*]] = load i16, i16* [[AA]], align 2
// CHECK7-NEXT:    store i16 [[TMP31]], i16* [[TMP30]], align 4
// CHECK7-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    store i32 [[TMP33]], i32* [[TMP32]], align 4
// CHECK7-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[AGG_CAPTURED]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    store i32 [[TMP35]], i32* [[TMP34]], align 4
// CHECK7-NEXT:    [[TMP36:%.*]] = call i8* @__kmpc_omp_target_task_alloc(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 1, i32 72, i32 12, i32 (i32, i8*)* bitcast (i32 (i32, %struct.kmp_task_t_with_privates*)* @.omp_task_entry. to i32 (i32, i8*)*), i64 -1)
// CHECK7-NEXT:    [[TMP37:%.*]] = bitcast i8* [[TMP36]] to %struct.kmp_task_t_with_privates*
// CHECK7-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP37]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP38]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP40:%.*]] = load i8*, i8** [[TMP39]], align 4
// CHECK7-NEXT:    [[TMP41:%.*]] = bitcast %struct.anon* [[AGG_CAPTURED]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP40]], i8* align 4 [[TMP41]], i32 12, i1 false)
// CHECK7-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP37]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP43:%.*]] = bitcast i8* [[TMP40]] to %struct.anon*
// CHECK7-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP42]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP45:%.*]] = bitcast [3 x i64]* [[TMP44]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP45]], i8* align 4 bitcast ([3 x i64]* @.offload_sizes to i8*), i32 24, i1 false)
// CHECK7-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP42]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP47:%.*]] = bitcast [3 x i8*]* [[TMP46]] to i8*
// CHECK7-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP28]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP47]], i8* align 4 [[TMP48]], i32 12, i1 false)
// CHECK7-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP42]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP50:%.*]] = bitcast [3 x i8*]* [[TMP49]] to i8*
// CHECK7-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP29]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP50]], i8* align 4 [[TMP51]], i32 12, i1 false)
// CHECK7-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP42]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP53:%.*]] = load i16, i16* [[AA]], align 2
// CHECK7-NEXT:    store i16 [[TMP53]], i16* [[TMP52]], align 4
// CHECK7-NEXT:    [[TMP54:%.*]] = call i32 @__kmpc_omp_task(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i8* [[TMP36]])
// CHECK7-NEXT:    [[TMP55:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    store i32 [[TMP55]], i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP56:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l102(i32 [[TMP56]]) #[[ATTR4:[0-9]+]]
// CHECK7-NEXT:    [[TMP57:%.*]] = load i16, i16* [[AA]], align 2
// CHECK7-NEXT:    [[CONV5:%.*]] = bitcast i32* [[AA_CASTED4]] to i16*
// CHECK7-NEXT:    store i16 [[TMP57]], i16* [[CONV5]], align 2
// CHECK7-NEXT:    [[TMP58:%.*]] = load i32, i32* [[AA_CASTED4]], align 4
// CHECK7-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP60:%.*]] = bitcast i8** [[TMP59]] to i32*
// CHECK7-NEXT:    store i32 [[TMP58]], i32* [[TMP60]], align 4
// CHECK7-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP62:%.*]] = bitcast i8** [[TMP61]] to i32*
// CHECK7-NEXT:    store i32 [[TMP58]], i32* [[TMP62]], align 4
// CHECK7-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS8]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP63]], align 4
// CHECK7-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS6]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS7]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK7-NEXT:    [[TMP66:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111.region_id, i32 1, i8** [[TMP64]], i8** [[TMP65]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP67:%.*]] = icmp ne i32 [[TMP66]], 0
// CHECK7-NEXT:    br i1 [[TMP67]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111(i32 [[TMP58]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    [[TMP68:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    store i32 [[TMP68]], i32* [[A_CASTED9]], align 4
// CHECK7-NEXT:    [[TMP69:%.*]] = load i32, i32* [[A_CASTED9]], align 4
// CHECK7-NEXT:    [[TMP70:%.*]] = load i16, i16* [[AA]], align 2
// CHECK7-NEXT:    [[CONV11:%.*]] = bitcast i32* [[AA_CASTED10]] to i16*
// CHECK7-NEXT:    store i16 [[TMP70]], i16* [[CONV11]], align 2
// CHECK7-NEXT:    [[TMP71:%.*]] = load i32, i32* [[AA_CASTED10]], align 4
// CHECK7-NEXT:    [[TMP72:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP72]], 10
// CHECK7-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK7:       omp_if.then:
// CHECK7-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP74:%.*]] = bitcast i8** [[TMP73]] to i32*
// CHECK7-NEXT:    store i32 [[TMP69]], i32* [[TMP74]], align 4
// CHECK7-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS13]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP76:%.*]] = bitcast i8** [[TMP75]] to i32*
// CHECK7-NEXT:    store i32 [[TMP69]], i32* [[TMP76]], align 4
// CHECK7-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS14]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP77]], align 4
// CHECK7-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP79:%.*]] = bitcast i8** [[TMP78]] to i32*
// CHECK7-NEXT:    store i32 [[TMP71]], i32* [[TMP79]], align 4
// CHECK7-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS13]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP81:%.*]] = bitcast i8** [[TMP80]] to i32*
// CHECK7-NEXT:    store i32 [[TMP71]], i32* [[TMP81]], align 4
// CHECK7-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS14]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP82]], align 4
// CHECK7-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS12]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS13]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK7-NEXT:    [[TMP85:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118.region_id, i32 2, i8** [[TMP83]], i8** [[TMP84]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.7, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.8, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP86:%.*]] = icmp ne i32 [[TMP85]], 0
// CHECK7-NEXT:    br i1 [[TMP86]], label [[OMP_OFFLOAD_FAILED16:%.*]], label [[OMP_OFFLOAD_CONT17:%.*]]
// CHECK7:       omp_offload.failed16:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118(i32 [[TMP69]], i32 [[TMP71]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT17]]
// CHECK7:       omp_offload.cont17:
// CHECK7-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK7:       omp_if.else:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118(i32 [[TMP69]], i32 [[TMP71]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_IF_END]]
// CHECK7:       omp_if.end:
// CHECK7-NEXT:    [[TMP87:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    store i32 [[TMP87]], i32* [[A_CASTED18]], align 4
// CHECK7-NEXT:    [[TMP88:%.*]] = load i32, i32* [[A_CASTED18]], align 4
// CHECK7-NEXT:    [[TMP89:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CMP19:%.*]] = icmp sgt i32 [[TMP89]], 20
// CHECK7-NEXT:    br i1 [[CMP19]], label [[OMP_IF_THEN20:%.*]], label [[OMP_IF_ELSE27:%.*]]
// CHECK7:       omp_if.then20:
// CHECK7-NEXT:    [[TMP90:%.*]] = mul nuw i32 [[TMP1]], 4
// CHECK7-NEXT:    [[TMP91:%.*]] = sext i32 [[TMP90]] to i64
// CHECK7-NEXT:    [[TMP92:%.*]] = mul nuw i32 5, [[TMP3]]
// CHECK7-NEXT:    [[TMP93:%.*]] = mul nuw i32 [[TMP92]], 8
// CHECK7-NEXT:    [[TMP94:%.*]] = sext i32 [[TMP93]] to i64
// CHECK7-NEXT:    [[TMP95:%.*]] = bitcast [9 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP95]], i8* align 4 bitcast ([9 x i64]* @.offload_sizes.10 to i8*), i32 72, i1 false)
// CHECK7-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP97:%.*]] = bitcast i8** [[TMP96]] to i32*
// CHECK7-NEXT:    store i32 [[TMP88]], i32* [[TMP97]], align 4
// CHECK7-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP99:%.*]] = bitcast i8** [[TMP98]] to i32*
// CHECK7-NEXT:    store i32 [[TMP88]], i32* [[TMP99]], align 4
// CHECK7-NEXT:    [[TMP100:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP100]], align 4
// CHECK7-NEXT:    [[TMP101:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP102:%.*]] = bitcast i8** [[TMP101]] to [10 x float]**
// CHECK7-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP102]], align 4
// CHECK7-NEXT:    [[TMP103:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP104:%.*]] = bitcast i8** [[TMP103]] to [10 x float]**
// CHECK7-NEXT:    store [10 x float]* [[B]], [10 x float]** [[TMP104]], align 4
// CHECK7-NEXT:    [[TMP105:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP105]], align 4
// CHECK7-NEXT:    [[TMP106:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP107:%.*]] = bitcast i8** [[TMP106]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP107]], align 4
// CHECK7-NEXT:    [[TMP108:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP109:%.*]] = bitcast i8** [[TMP108]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP109]], align 4
// CHECK7-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP110]], align 4
// CHECK7-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to float**
// CHECK7-NEXT:    store float* [[VLA]], float** [[TMP112]], align 4
// CHECK7-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to float**
// CHECK7-NEXT:    store float* [[VLA]], float** [[TMP114]], align 4
// CHECK7-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK7-NEXT:    store i64 [[TMP91]], i64* [[TMP115]], align 4
// CHECK7-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 3
// CHECK7-NEXT:    store i8* null, i8** [[TMP116]], align 4
// CHECK7-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 4
// CHECK7-NEXT:    [[TMP118:%.*]] = bitcast i8** [[TMP117]] to [5 x [10 x double]]**
// CHECK7-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP118]], align 4
// CHECK7-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 4
// CHECK7-NEXT:    [[TMP120:%.*]] = bitcast i8** [[TMP119]] to [5 x [10 x double]]**
// CHECK7-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[TMP120]], align 4
// CHECK7-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 4
// CHECK7-NEXT:    store i8* null, i8** [[TMP121]], align 4
// CHECK7-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 5
// CHECK7-NEXT:    [[TMP123:%.*]] = bitcast i8** [[TMP122]] to i32*
// CHECK7-NEXT:    store i32 5, i32* [[TMP123]], align 4
// CHECK7-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 5
// CHECK7-NEXT:    [[TMP125:%.*]] = bitcast i8** [[TMP124]] to i32*
// CHECK7-NEXT:    store i32 5, i32* [[TMP125]], align 4
// CHECK7-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 5
// CHECK7-NEXT:    store i8* null, i8** [[TMP126]], align 4
// CHECK7-NEXT:    [[TMP127:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 6
// CHECK7-NEXT:    [[TMP128:%.*]] = bitcast i8** [[TMP127]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP128]], align 4
// CHECK7-NEXT:    [[TMP129:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 6
// CHECK7-NEXT:    [[TMP130:%.*]] = bitcast i8** [[TMP129]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP130]], align 4
// CHECK7-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 6
// CHECK7-NEXT:    store i8* null, i8** [[TMP131]], align 4
// CHECK7-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 7
// CHECK7-NEXT:    [[TMP133:%.*]] = bitcast i8** [[TMP132]] to double**
// CHECK7-NEXT:    store double* [[VLA1]], double** [[TMP133]], align 4
// CHECK7-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 7
// CHECK7-NEXT:    [[TMP135:%.*]] = bitcast i8** [[TMP134]] to double**
// CHECK7-NEXT:    store double* [[VLA1]], double** [[TMP135]], align 4
// CHECK7-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 7
// CHECK7-NEXT:    store i64 [[TMP94]], i64* [[TMP136]], align 4
// CHECK7-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 7
// CHECK7-NEXT:    store i8* null, i8** [[TMP137]], align 4
// CHECK7-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 8
// CHECK7-NEXT:    [[TMP139:%.*]] = bitcast i8** [[TMP138]] to %struct.TT**
// CHECK7-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP139]], align 4
// CHECK7-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 8
// CHECK7-NEXT:    [[TMP141:%.*]] = bitcast i8** [[TMP140]] to %struct.TT**
// CHECK7-NEXT:    store %struct.TT* [[D]], %struct.TT** [[TMP141]], align 4
// CHECK7-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_MAPPERS23]], i32 0, i32 8
// CHECK7-NEXT:    store i8* null, i8** [[TMP142]], align 4
// CHECK7-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_BASEPTRS21]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [9 x i8*], [9 x i8*]* [[DOTOFFLOAD_PTRS22]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP145:%.*]] = getelementptr inbounds [9 x i64], [9 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK7-NEXT:    [[TMP146:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142.region_id, i32 9, i8** [[TMP143]], i8** [[TMP144]], i64* [[TMP145]], i64* getelementptr inbounds ([9 x i64], [9 x i64]* @.offload_maptypes.11, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP147:%.*]] = icmp ne i32 [[TMP146]], 0
// CHECK7-NEXT:    br i1 [[TMP147]], label [[OMP_OFFLOAD_FAILED25:%.*]], label [[OMP_OFFLOAD_CONT26:%.*]]
// CHECK7:       omp_offload.failed25:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142(i32 [[TMP88]], [10 x float]* [[B]], i32 [[TMP1]], float* [[VLA]], [5 x [10 x double]]* [[C]], i32 5, i32 [[TMP3]], double* [[VLA1]], %struct.TT* [[D]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT26]]
// CHECK7:       omp_offload.cont26:
// CHECK7-NEXT:    br label [[OMP_IF_END28:%.*]]
// CHECK7:       omp_if.else27:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142(i32 [[TMP88]], [10 x float]* [[B]], i32 [[TMP1]], float* [[VLA]], [5 x [10 x double]]* [[C]], i32 5, i32 [[TMP3]], double* [[VLA1]], %struct.TT* [[D]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_IF_END28]]
// CHECK7:       omp_if.end28:
// CHECK7-NEXT:    [[TMP148:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    [[TMP149:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK7-NEXT:    call void @llvm.stackrestore(i8* [[TMP149]])
// CHECK7-NEXT:    ret i32 [[TMP148]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97
// CHECK7-SAME: (i32 noundef [[AA:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]], i32 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[DOTCAPTURE_EXPR_1]], i32* [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK7-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK7-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK7-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), i32 [[TMP4]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !11
// CHECK7-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK7-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !11
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK7-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK7-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK7-NEXT:    br i1 [[TMP10]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK7-SAME: (%struct..kmp_privates.t* noalias noundef [[TMP0:%.*]], i16** noalias noundef [[TMP1:%.*]], [3 x i8*]** noalias noundef [[TMP2:%.*]], [3 x i8*]** noalias noundef [[TMP3:%.*]], [3 x i64]** noalias noundef [[TMP4:%.*]]) #[[ATTR5:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTADDR:%.*]] = alloca %struct..kmp_privates.t*, align 4
// CHECK7-NEXT:    [[DOTADDR1:%.*]] = alloca i16**, align 4
// CHECK7-NEXT:    [[DOTADDR2:%.*]] = alloca [3 x i8*]**, align 4
// CHECK7-NEXT:    [[DOTADDR3:%.*]] = alloca [3 x i8*]**, align 4
// CHECK7-NEXT:    [[DOTADDR4:%.*]] = alloca [3 x i64]**, align 4
// CHECK7-NEXT:    store %struct..kmp_privates.t* [[TMP0]], %struct..kmp_privates.t** [[DOTADDR]], align 4
// CHECK7-NEXT:    store i16** [[TMP1]], i16*** [[DOTADDR1]], align 4
// CHECK7-NEXT:    store [3 x i8*]** [[TMP2]], [3 x i8*]*** [[DOTADDR2]], align 4
// CHECK7-NEXT:    store [3 x i8*]** [[TMP3]], [3 x i8*]*** [[DOTADDR3]], align 4
// CHECK7-NEXT:    store [3 x i64]** [[TMP4]], [3 x i64]*** [[DOTADDR4]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load %struct..kmp_privates.t*, %struct..kmp_privates.t** [[DOTADDR]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP7:%.*]] = load [3 x i64]**, [3 x i64]*** [[DOTADDR4]], align 4
// CHECK7-NEXT:    store [3 x i64]* [[TMP6]], [3 x i64]** [[TMP7]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP9:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR2]], align 4
// CHECK7-NEXT:    store [3 x i8*]* [[TMP8]], [3 x i8*]** [[TMP9]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP11:%.*]] = load [3 x i8*]**, [3 x i8*]*** [[DOTADDR3]], align 4
// CHECK7-NEXT:    store [3 x i8*]* [[TMP10]], [3 x i8*]** [[TMP11]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T]], %struct..kmp_privates.t* [[TMP5]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP13:%.*]] = load i16**, i16*** [[DOTADDR1]], align 4
// CHECK7-NEXT:    store i16* [[TMP12]], i16** [[TMP13]], align 4
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK7-SAME: (i32 noundef [[TMP0:%.*]], %struct.kmp_task_t_with_privates* noalias noundef [[TMP1:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca i8*, align 4
// CHECK7-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca void (i8*, ...)*, align 4
// CHECK7-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca i8*, align 4
// CHECK7-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca %struct.anon*, align 4
// CHECK7-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR_I:%.*]] = alloca i16*, align 4
// CHECK7-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR1_I:%.*]] = alloca [3 x i8*]*, align 4
// CHECK7-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR2_I:%.*]] = alloca [3 x i8*]*, align 4
// CHECK7-NEXT:    [[DOTFIRSTPRIV_PTR_ADDR3_I:%.*]] = alloca [3 x i64]*, align 4
// CHECK7-NEXT:    [[AA_CASTED_I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__CASTED_I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__CASTED4_I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTADDR1:%.*]] = alloca %struct.kmp_task_t_with_privates*, align 4
// CHECK7-NEXT:    store i32 [[TMP0]], i32* [[DOTADDR]], align 4
// CHECK7-NEXT:    store %struct.kmp_task_t_with_privates* [[TMP1]], %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load %struct.kmp_task_t_with_privates*, %struct.kmp_task_t_with_privates** [[DOTADDR1]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], %struct.kmp_task_t* [[TMP4]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP7:%.*]] = load i8*, i8** [[TMP6]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = bitcast i8* [[TMP7]] to %struct.anon*
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES]], %struct.kmp_task_t_with_privates* [[TMP3]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP10:%.*]] = bitcast %struct..kmp_privates.t* [[TMP9]] to i8*
// CHECK7-NEXT:    [[TMP11:%.*]] = bitcast %struct.kmp_task_t_with_privates* [[TMP3]] to i8*
// CHECK7-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META18:![0-9]+]])
// CHECK7-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META21:![0-9]+]])
// CHECK7-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META23:![0-9]+]])
// CHECK7-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META25:![0-9]+]])
// CHECK7-NEXT:    store i32 [[TMP2]], i32* [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    store i32* [[TMP5]], i32** [[DOTPART_ID__ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    store i8* [[TMP10]], i8** [[DOTPRIVATES__ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    store void (i8*, ...)* bitcast (void (%struct..kmp_privates.t*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)* @.omp_task_privates_map. to void (i8*, ...)*), void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    store i8* [[TMP11]], i8** [[DOTTASK_T__ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    store %struct.anon* [[TMP8]], %struct.anon** [[__CONTEXT_ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP12:%.*]] = load %struct.anon*, %struct.anon** [[__CONTEXT_ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP13:%.*]] = load void (i8*, ...)*, void (i8*, ...)** [[DOTCOPY_FN__ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[DOTPRIVATES__ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP15:%.*]] = bitcast void (i8*, ...)* [[TMP13]] to void (i8*, i16**, [3 x i8*]**, [3 x i8*]**, [3 x i64]**)*
// CHECK7-NEXT:    call void [[TMP15]](i8* [[TMP14]], i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]]) #[[ATTR4]]
// CHECK7-NEXT:    [[TMP16:%.*]] = load i16*, i16** [[DOTFIRSTPRIV_PTR_ADDR_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP17:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR1_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP18:%.*]] = load [3 x i8*]*, [3 x i8*]** [[DOTFIRSTPRIV_PTR_ADDR2_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP19:%.*]] = load [3 x i64]*, [3 x i64]** [[DOTFIRSTPRIV_PTR_ADDR3_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP17]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[TMP18]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[TMP19]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_ANON:%.*]], %struct.anon* [[TMP12]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON]], %struct.anon* [[TMP12]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10) #[[ATTR4]]
// CHECK7-NEXT:    [[TMP26:%.*]] = call i32 @__tgt_target_teams_nowait_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* [[TMP22]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP25]], i32 1, i32 0, i8* null, i32 0, i8* null) #[[ATTR4]]
// CHECK7-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK7-NEXT:    br i1 [[TMP27]], label [[OMP_OFFLOAD_FAILED_I:%.*]], label [[DOTOMP_OUTLINED__1_EXIT:%.*]]
// CHECK7:       omp_offload.failed.i:
// CHECK7-NEXT:    [[TMP28:%.*]] = load i16, i16* [[TMP16]], align 2
// CHECK7-NEXT:    [[CONV_I:%.*]] = bitcast i32* [[AA_CASTED_I]] to i16*
// CHECK7-NEXT:    store i16 [[TMP28]], i16* [[CONV_I]], align 2, !noalias !27
// CHECK7-NEXT:    [[TMP29:%.*]] = load i32, i32* [[AA_CASTED_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK7-NEXT:    store i32 [[TMP30]], i32* [[DOTCAPTURE_EXPR__CASTED_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP32:%.*]] = load i32, i32* [[TMP24]], align 4
// CHECK7-NEXT:    store i32 [[TMP32]], i32* [[DOTCAPTURE_EXPR__CASTED4_I]], align 4, !noalias !27
// CHECK7-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED4_I]], align 4, !noalias !27
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97(i32 [[TMP29]], i32 [[TMP31]], i32 [[TMP33]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[DOTOMP_OUTLINED__1_EXIT]]
// CHECK7:       .omp_outlined..1.exit:
// CHECK7-NEXT:    ret i32 0
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l102
// CHECK7-SAME: (i32 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32 [[TMP1]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK7-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[A1]], align 4, !nontemporal !28
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A1]], align 4, !nontemporal !28
// CHECK7-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK7-NEXT:    store i32 [[ADD3]], i32* [[A1]], align 4, !nontemporal !28
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK7-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP29:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK7-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 10, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111
// CHECK7-SAME: (i32 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK7-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP1]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !31
// CHECK7-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK7-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !31
// CHECK7-NEXT:    [[TMP8:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !31
// CHECK7-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP8]] to i32
// CHECK7-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV2]], 1
// CHECK7-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD3]] to i16
// CHECK7-NEXT:    store i16 [[CONV4]], i16* [[CONV]], align 2, !llvm.access.group !31
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK7-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK7-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP32:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK7-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118
// CHECK7-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR2]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK7-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !34
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !34
// CHECK7-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK7-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !34
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !34
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !34
// CHECK7-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK7-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4, !llvm.access.group !34
// CHECK7-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !34
// CHECK7-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP9]] to i32
// CHECK7-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK7-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK7-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2, !llvm.access.group !34
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !34
// CHECK7-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK7-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !34
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP35:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK7-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142
// CHECK7-SAME: (i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]]) #[[ATTR2]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK7-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK7-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK7-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK7-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK7-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK7-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK7-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 9, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, [10 x float]*, i32, float*, [5 x [10 x double]]*, i32, i32, double*, %struct.TT*)* @.omp_outlined..9 to void (i32*, i32*, ...)*), i32 [[TMP9]], [10 x float]* [[TMP0]], i32 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i32 [[TMP4]], i32 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..9
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK7-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK7-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK7-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK7-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK7-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK7-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK7-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK7-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK7-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 0
// CHECK7-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i32 16) ]
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 9
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK7-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK7-NEXT:    store i32 [[ADD6]], i32* [[A_ADDR]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[CONV:%.*]] = fpext float [[TMP17]] to double
// CHECK7-NEXT:    [[ADD7:%.*]] = fadd double [[CONV]], 1.000000e+00
// CHECK7-NEXT:    [[CONV8:%.*]] = fptrunc double [[ADD7]] to float
// CHECK7-NEXT:    store float [[CONV8]], float* [[ARRAYIDX]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP2]], i32 3
// CHECK7-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX9]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[CONV10:%.*]] = fpext float [[TMP18]] to double
// CHECK7-NEXT:    [[ADD11:%.*]] = fadd double [[CONV10]], 1.000000e+00
// CHECK7-NEXT:    [[CONV12:%.*]] = fptrunc double [[ADD11]] to float
// CHECK7-NEXT:    store float [[CONV12]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i32 0, i32 1
// CHECK7-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX13]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP19:%.*]] = load double, double* [[ARRAYIDX14]], align 8, !llvm.access.group !37
// CHECK7-NEXT:    [[ADD15:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK7-NEXT:    store double [[ADD15]], double* [[ARRAYIDX14]], align 8, !llvm.access.group !37
// CHECK7-NEXT:    [[TMP20:%.*]] = mul nsw i32 1, [[TMP5]]
// CHECK7-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds double, double* [[TMP6]], i32 [[TMP20]]
// CHECK7-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX16]], i32 3
// CHECK7-NEXT:    [[TMP21:%.*]] = load double, double* [[ARRAYIDX17]], align 8, !llvm.access.group !37
// CHECK7-NEXT:    [[ADD18:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK7-NEXT:    store double [[ADD18]], double* [[ARRAYIDX17]], align 8, !llvm.access.group !37
// CHECK7-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP22:%.*]] = load i64, i64* [[X]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[ADD19:%.*]] = add nsw i64 [[TMP22]], 1
// CHECK7-NEXT:    store i64 [[ADD19]], i64* [[X]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP23:%.*]] = load i8, i8* [[Y]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[CONV20:%.*]] = sext i8 [[TMP23]] to i32
// CHECK7-NEXT:    [[ADD21:%.*]] = add nsw i32 [[CONV20]], 1
// CHECK7-NEXT:    [[CONV22:%.*]] = trunc i32 [[ADD21]] to i8
// CHECK7-NEXT:    store i8 [[CONV22]], i8* [[Y]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    [[ADD23:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK7-NEXT:    store i32 [[ADD23]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !37
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP38:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]])
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK7-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z3bari
// CHECK7-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 4
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP0]])
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CALL1:%.*]] = call noundef i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 4 dereferenceable(8) [[S]], i32 noundef [[TMP2]])
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK7-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CALL3:%.*]] = call noundef i32 @_ZL7fstatici(i32 noundef [[TMP4]])
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK7-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CALL5:%.*]] = call noundef i32 @_Z9ftemplateIiET_i(i32 noundef [[TMP6]])
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK7-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK7-SAME: (%struct.S1* noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK7-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [6 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [6 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [6 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [6 x i64], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK7-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK7-NEXT:    [[VLA:%.*]] = alloca i16, i32 [[TMP3]], align 2
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 60
// CHECK7-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[CMP]] to i8
// CHECK7-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B]], align 4
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[B_CASTED]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP7]] to i1
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK7-NEXT:    [[FROMBOOL2:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK7-NEXT:    store i8 [[FROMBOOL2]], i8* [[CONV]], align 1
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    [[TOBOOL3:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK7-NEXT:    br i1 [[TOBOOL3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK7:       omp_if.then:
// CHECK7-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP10:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK7-NEXT:    [[TMP11:%.*]] = mul nuw i32 [[TMP10]], 2
// CHECK7-NEXT:    [[TMP12:%.*]] = sext i32 [[TMP11]] to i64
// CHECK7-NEXT:    [[TMP13:%.*]] = bitcast [6 x i64]* [[DOTOFFLOAD_SIZES]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP13]], i8* align 4 bitcast ([6 x i64]* @.offload_sizes.13 to i8*), i32 48, i1 false)
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to %struct.S1**
// CHECK7-NEXT:    store %struct.S1* [[THIS1]], %struct.S1** [[TMP15]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to double**
// CHECK7-NEXT:    store double* [[A]], double** [[TMP17]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i32*
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[TMP20]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32*
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[TMP22]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i32*
// CHECK7-NEXT:    store i32 2, i32* [[TMP25]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK7-NEXT:    store i32 2, i32* [[TMP27]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP28]], align 4
// CHECK7-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP30]], align 4
// CHECK7-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP32]], align 4
// CHECK7-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK7-NEXT:    store i8* null, i8** [[TMP33]], align 4
// CHECK7-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK7-NEXT:    [[TMP35:%.*]] = bitcast i8** [[TMP34]] to i16**
// CHECK7-NEXT:    store i16* [[VLA]], i16** [[TMP35]], align 4
// CHECK7-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK7-NEXT:    [[TMP37:%.*]] = bitcast i8** [[TMP36]] to i16**
// CHECK7-NEXT:    store i16* [[VLA]], i16** [[TMP37]], align 4
// CHECK7-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [6 x i64], [6 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK7-NEXT:    store i64 [[TMP12]], i64* [[TMP38]], align 4
// CHECK7-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK7-NEXT:    store i8* null, i8** [[TMP39]], align 4
// CHECK7-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK7-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to i32*
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[TMP41]], align 4
// CHECK7-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK7-NEXT:    [[TMP43:%.*]] = bitcast i8** [[TMP42]] to i32*
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[TMP43]], align 4
// CHECK7-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 5
// CHECK7-NEXT:    store i8* null, i8** [[TMP44]], align 4
// CHECK7-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [6 x i8*], [6 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [6 x i64], [6 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK7-NEXT:    [[TMP48:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215.region_id, i32 6, i8** [[TMP45]], i8** [[TMP46]], i64* [[TMP47]], i64* getelementptr inbounds ([6 x i64], [6 x i64]* @.offload_maptypes.14, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP49:%.*]] = icmp ne i32 [[TMP48]], 0
// CHECK7-NEXT:    br i1 [[TMP49]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215(%struct.S1* [[THIS1]], i32 [[TMP6]], i32 2, i32 [[TMP1]], i16* [[VLA]], i32 [[TMP8]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK7:       omp_if.else:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215(%struct.S1* [[THIS1]], i32 [[TMP6]], i32 2, i32 [[TMP1]], i16* [[VLA]], i32 [[TMP8]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_IF_END]]
// CHECK7:       omp_if.end:
// CHECK7-NEXT:    [[TMP50:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP50]]
// CHECK7-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK7-NEXT:    [[TMP51:%.*]] = load i16, i16* [[ARRAYIDX4]], align 2
// CHECK7-NEXT:    [[CONV5:%.*]] = sext i16 [[TMP51]] to i32
// CHECK7-NEXT:    [[TMP52:%.*]] = load i32, i32* [[B]], align 4
// CHECK7-NEXT:    [[ADD6:%.*]] = add nsw i32 [[CONV5]], [[TMP52]]
// CHECK7-NEXT:    [[TMP53:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK7-NEXT:    call void @llvm.stackrestore(i8* [[TMP53]])
// CHECK7-NEXT:    ret i32 [[ADD6]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK7-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK7-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK7-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK7-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP2]], i32* [[N_CASTED]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i16, i16* [[AA]], align 2
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP4]], i16* [[CONV]], align 2
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i8, i8* [[AAA]], align 1
// CHECK7-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK7-NEXT:    store i8 [[TMP6]], i8* [[CONV1]], align 1
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 50
// CHECK7-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK7:       omp_if.then:
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP10]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP12]], align 4
// CHECK7-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP15]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP17]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to i32*
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[TMP20]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32*
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[TMP22]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i32*
// CHECK7-NEXT:    store i32 [[TMP7]], i32* [[TMP25]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK7-NEXT:    store i32 [[TMP7]], i32* [[TMP27]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK7-NEXT:    store i8* null, i8** [[TMP28]], align 4
// CHECK7-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK7-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to [10 x i32]**
// CHECK7-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP30]], align 4
// CHECK7-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK7-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to [10 x i32]**
// CHECK7-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP32]], align 4
// CHECK7-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK7-NEXT:    store i8* null, i8** [[TMP33]], align 4
// CHECK7-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP36:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    store i32 [[TMP36]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[TMP37:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP37]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[SUB:%.*]] = sub i32 [[TMP38]], [[TMP39]]
// CHECK7-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK7-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK7-NEXT:    [[SUB5:%.*]] = sub i32 [[DIV]], 1
// CHECK7-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    [[TMP40:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    [[ADD6:%.*]] = add i32 [[TMP40]], 1
// CHECK7-NEXT:    [[TMP41:%.*]] = zext i32 [[ADD6]] to i64
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP41]])
// CHECK7-NEXT:    [[TMP42:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197.region_id, i32 5, i8** [[TMP34]], i8** [[TMP35]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.16, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.17, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP43:%.*]] = icmp ne i32 [[TMP42]], 0
// CHECK7-NEXT:    br i1 [[TMP43]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197(i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]], i32 [[TMP7]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK7:       omp_if.else:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197(i32 [[TMP1]], i32 [[TMP3]], i32 [[TMP5]], i32 [[TMP7]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_IF_END]]
// CHECK7:       omp_if.end:
// CHECK7-NEXT:    [[TMP44:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    ret i32 [[TMP44]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK7-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK7-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK7-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i16, i16* [[AA]], align 2
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP2]], i16* [[CONV]], align 2
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 40
// CHECK7-NEXT:    br i1 [[CMP]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK7:       omp_if.then:
// CHECK7-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP6]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP9]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP11]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [10 x i32]**
// CHECK7-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP16]], align 4
// CHECK7-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [10 x i32]**
// CHECK7-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[TMP18]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK7-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK7-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180.region_id, i32 3, i8** [[TMP20]], i8** [[TMP21]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes.19, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.20, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK7-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK7-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK7:       omp_if.else:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[B]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_IF_END]]
// CHECK7:       omp_if.end:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[A]], align 4
// CHECK7-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215
// CHECK7-SAME: (%struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK7-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK7-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK7-NEXT:    [[CONV3:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK7-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK7-NEXT:    store i8 [[FROMBOOL]], i8* [[CONV3]], align 1
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i32, i32, i32, i16*, i32)* @.omp_outlined..12 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i32 [[TMP5]], i32 [[TMP1]], i32 [[TMP2]], i16* [[TMP3]], i32 [[TMP7]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..12
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK7-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 9
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK7-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK7-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK7:       omp_if.then:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK7-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[B_ADDR]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[CONV4:%.*]] = sitofp i32 [[TMP13]] to double
// CHECK7-NEXT:    [[ADD5:%.*]] = fadd double [[CONV4]], 1.500000e+00
// CHECK7-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK7-NEXT:    store double [[ADD5]], double* [[A]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[A6:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP14:%.*]] = load double, double* [[A6]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[INC:%.*]] = fadd double [[TMP14]], 1.000000e+00
// CHECK7-NEXT:    store double [[INC]], double* [[A6]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[CONV7:%.*]] = fptosi double [[INC]] to i16
// CHECK7-NEXT:    [[TMP15:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP15]]
// CHECK7-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK7-NEXT:    store i16 [[CONV7]], i16* [[ARRAYIDX8]], align 2, !llvm.access.group !40
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK7-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !40
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP41:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK7:       omp_if.else:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK7:       omp.inner.for.cond10:
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK7-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY12:%.*]], label [[OMP_INNER_FOR_END26:%.*]]
// CHECK7:       omp.inner.for.body12:
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK7-NEXT:    [[ADD14:%.*]] = add nsw i32 0, [[MUL13]]
// CHECK7-NEXT:    store i32 [[ADD14]], i32* [[I]], align 4
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK7-NEXT:    [[CONV15:%.*]] = sitofp i32 [[TMP20]] to double
// CHECK7-NEXT:    [[ADD16:%.*]] = fadd double [[CONV15]], 1.500000e+00
// CHECK7-NEXT:    [[A17:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK7-NEXT:    store double [[ADD16]], double* [[A17]], align 4
// CHECK7-NEXT:    [[A18:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP21:%.*]] = load double, double* [[A18]], align 4
// CHECK7-NEXT:    [[INC19:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK7-NEXT:    store double [[INC19]], double* [[A18]], align 4
// CHECK7-NEXT:    [[CONV20:%.*]] = fptosi double [[INC19]] to i16
// CHECK7-NEXT:    [[TMP22:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK7-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP22]]
// CHECK7-NEXT:    [[ARRAYIDX22:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX21]], i32 1
// CHECK7-NEXT:    store i16 [[CONV20]], i16* [[ARRAYIDX22]], align 2
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE23:%.*]]
// CHECK7:       omp.body.continue23:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC24:%.*]]
// CHECK7:       omp.inner.for.inc24:
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[ADD25:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK7-NEXT:    store i32 [[ADD25]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP43:![0-9]+]]
// CHECK7:       omp.inner.for.end26:
// CHECK7-NEXT:    br label [[OMP_IF_END]]
// CHECK7:       omp_if.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK7-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197
// CHECK7-SAME: (i32 noundef [[A:%.*]], i32 noundef [[N:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK7-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK7-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[N_CASTED]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK7-NEXT:    [[CONV2:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP5]], i16* [[CONV2]], align 2
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i8, i8* [[CONV1]], align 1
// CHECK7-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK7-NEXT:    store i8 [[TMP7]], i8* [[CONV3]], align 1
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32, i32, [10 x i32]*)* @.omp_outlined..15 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], i32 [[TMP8]], [10 x i32]* [[TMP0]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..15
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[N:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK7-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK7-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK7-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK7-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK7-NEXT:    [[SUB5:%.*]] = sub i32 [[DIV]], 1
// CHECK7-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK7-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK7:       omp.precond.then:
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    [[CMP7:%.*]] = icmp ugt i32 [[TMP11]], [[TMP12]]
// CHECK7-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[ADD8:%.*]] = add i32 [[TMP17]], 1
// CHECK7-NEXT:    [[CMP9:%.*]] = icmp ult i32 [[TMP16]], [[ADD8]]
// CHECK7-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[MUL:%.*]] = mul i32 [[TMP19]], 1
// CHECK7-NEXT:    [[ADD10:%.*]] = add i32 [[TMP18]], [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD10]], i32* [[I6]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK7-NEXT:    store i32 [[ADD11]], i32* [[A_ADDR]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[TMP21:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !45
// CHECK7-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP21]] to i32
// CHECK7-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK7-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i16
// CHECK7-NEXT:    store i16 [[CONV14]], i16* [[CONV]], align 2, !llvm.access.group !45
// CHECK7-NEXT:    [[TMP22:%.*]] = load i8, i8* [[CONV1]], align 1, !llvm.access.group !45
// CHECK7-NEXT:    [[CONV15:%.*]] = sext i8 [[TMP22]] to i32
// CHECK7-NEXT:    [[ADD16:%.*]] = add nsw i32 [[CONV15]], 1
// CHECK7-NEXT:    [[CONV17:%.*]] = trunc i32 [[ADD16]] to i8
// CHECK7-NEXT:    store i8 [[CONV17]], i8* [[CONV1]], align 1, !llvm.access.group !45
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK7-NEXT:    store i32 [[ADD18]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    [[ADD19:%.*]] = add i32 [[TMP24]], 1
// CHECK7-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !45
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP46:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK7-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK7-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK7-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[SUB20:%.*]] = sub i32 [[TMP30]], [[TMP31]]
// CHECK7-NEXT:    [[SUB21:%.*]] = sub i32 [[SUB20]], 1
// CHECK7-NEXT:    [[ADD22:%.*]] = add i32 [[SUB21]], 1
// CHECK7-NEXT:    [[DIV23:%.*]] = udiv i32 [[ADD22]], 1
// CHECK7-NEXT:    [[MUL24:%.*]] = mul i32 [[DIV23]], 1
// CHECK7-NEXT:    [[ADD25:%.*]] = add i32 [[TMP29]], [[MUL24]]
// CHECK7-NEXT:    store i32 [[ADD25]], i32* [[I6]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK7:       omp.precond.end:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180
// CHECK7-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR2]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK7-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK7-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK7-NEXT:    store i16 [[TMP3]], i16* [[CONV1]], align 2
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..18 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..18
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK7-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK7-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK7-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK7-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !48
// CHECK7-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP10]] to i32
// CHECK7-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK7-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK7-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2, !llvm.access.group !48
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK7-NEXT:    store i32 [[ADD6]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK7-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !48
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP49:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK7-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK7-SAME: () #[[ATTR5]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK7-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK9-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK9-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK9-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK9-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK9-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB5:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB6:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV7:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[A8:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[A9:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[_TMP20:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB21:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB22:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV23:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I24:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[_TMP36:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB37:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB38:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV39:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I40:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[_TMP54:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB55:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB56:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV57:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I58:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK9-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK9-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK9-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK9-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP1]], align 4
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = zext i32 [[TMP3]] to i64
// CHECK9-NEXT:    [[TMP5:%.*]] = mul nuw i64 5, [[TMP4]]
// CHECK9-NEXT:    [[VLA1:%.*]] = alloca double, i64 [[TMP5]], align 8
// CHECK9-NEXT:    store i64 [[TMP4]], i64* [[__VLA_EXPR1]], align 8
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK9-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB5]], align 4
// CHECK9-NEXT:    store i32 9, i32* [[DOTOMP_UB6]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB5]], align 4
// CHECK9-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV7]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTLINEAR_START]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK9:       omp.inner.for.cond10:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB6]], align 4
// CHECK9-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY12:%.*]], label [[OMP_INNER_FOR_END19:%.*]]
// CHECK9:       omp.inner.for.body12:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK9-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK9-NEXT:    [[ADD14:%.*]] = add nsw i32 0, [[MUL13]]
// CHECK9-NEXT:    store i32 [[ADD14]], i32* [[A8]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[A8]], align 4
// CHECK9-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK9-NEXT:    store i32 [[ADD15]], i32* [[A8]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE16:%.*]]
// CHECK9:       omp.body.continue16:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC17:%.*]]
// CHECK9:       omp.inner.for.inc17:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK9-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    store i32 [[ADD18]], i32* [[DOTOMP_IV7]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK9:       omp.inner.for.end19:
// CHECK9-NEXT:    store i32 10, i32* [[A]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB21]], align 4
// CHECK9-NEXT:    store i32 9, i32* [[DOTOMP_UB22]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_LB21]], align 4
// CHECK9-NEXT:    store i32 [[TMP20]], i32* [[DOTOMP_IV23]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND25:%.*]]
// CHECK9:       omp.inner.for.cond25:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_UB22]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[CMP26:%.*]] = icmp sle i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    br i1 [[CMP26]], label [[OMP_INNER_FOR_BODY27:%.*]], label [[OMP_INNER_FOR_END35:%.*]]
// CHECK9:       omp.inner.for.body27:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[MUL28:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK9-NEXT:    [[ADD29:%.*]] = add nsw i32 0, [[MUL28]]
// CHECK9-NEXT:    store i32 [[ADD29]], i32* [[I24]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[TMP24:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !9
// CHECK9-NEXT:    [[CONV:%.*]] = sext i16 [[TMP24]] to i32
// CHECK9-NEXT:    [[ADD30:%.*]] = add nsw i32 [[CONV]], 1
// CHECK9-NEXT:    [[CONV31:%.*]] = trunc i32 [[ADD30]] to i16
// CHECK9-NEXT:    store i16 [[CONV31]], i16* [[AA]], align 2, !llvm.access.group !9
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE32:%.*]]
// CHECK9:       omp.body.continue32:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC33:%.*]]
// CHECK9:       omp.inner.for.inc33:
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    [[ADD34:%.*]] = add nsw i32 [[TMP25]], 1
// CHECK9-NEXT:    store i32 [[ADD34]], i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !9
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND25]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK9:       omp.inner.for.end35:
// CHECK9-NEXT:    store i32 10, i32* [[I24]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB37]], align 4
// CHECK9-NEXT:    store i32 9, i32* [[DOTOMP_UB38]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB37]], align 4
// CHECK9-NEXT:    store i32 [[TMP26]], i32* [[DOTOMP_IV39]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND41:%.*]]
// CHECK9:       omp.inner.for.cond41:
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB38]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[CMP42:%.*]] = icmp sle i32 [[TMP27]], [[TMP28]]
// CHECK9-NEXT:    br i1 [[CMP42]], label [[OMP_INNER_FOR_BODY43:%.*]], label [[OMP_INNER_FOR_END53:%.*]]
// CHECK9:       omp.inner.for.body43:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[MUL44:%.*]] = mul nsw i32 [[TMP29]], 1
// CHECK9-NEXT:    [[ADD45:%.*]] = add nsw i32 0, [[MUL44]]
// CHECK9-NEXT:    store i32 [[ADD45]], i32* [[I40]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[ADD46:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK9-NEXT:    store i32 [[ADD46]], i32* [[A]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[TMP31:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !12
// CHECK9-NEXT:    [[CONV47:%.*]] = sext i16 [[TMP31]] to i32
// CHECK9-NEXT:    [[ADD48:%.*]] = add nsw i32 [[CONV47]], 1
// CHECK9-NEXT:    [[CONV49:%.*]] = trunc i32 [[ADD48]] to i16
// CHECK9-NEXT:    store i16 [[CONV49]], i16* [[AA]], align 2, !llvm.access.group !12
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE50:%.*]]
// CHECK9:       omp.body.continue50:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC51:%.*]]
// CHECK9:       omp.inner.for.inc51:
// CHECK9-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    [[ADD52:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK9-NEXT:    store i32 [[ADD52]], i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !12
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND41]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK9:       omp.inner.for.end53:
// CHECK9-NEXT:    store i32 10, i32* [[I40]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB55]], align 4
// CHECK9-NEXT:    store i32 9, i32* [[DOTOMP_UB56]], align 4
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_LB55]], align 4
// CHECK9-NEXT:    store i32 [[TMP33]], i32* [[DOTOMP_IV57]], align 4
// CHECK9-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[B]], i64 0, i64 0
// CHECK9-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i64 16) ]
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND59:%.*]]
// CHECK9:       omp.inner.for.cond59:
// CHECK9-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTOMP_UB56]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[CMP60:%.*]] = icmp sle i32 [[TMP34]], [[TMP35]]
// CHECK9-NEXT:    br i1 [[CMP60]], label [[OMP_INNER_FOR_BODY61:%.*]], label [[OMP_INNER_FOR_END85:%.*]]
// CHECK9:       omp.inner.for.body61:
// CHECK9-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[MUL62:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK9-NEXT:    [[ADD63:%.*]] = add nsw i32 0, [[MUL62]]
// CHECK9-NEXT:    store i32 [[ADD63]], i32* [[I58]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[TMP37:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[ADD64:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK9-NEXT:    store i32 [[ADD64]], i32* [[A]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[B]], i64 0, i64 2
// CHECK9-NEXT:    [[TMP38:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[CONV65:%.*]] = fpext float [[TMP38]] to double
// CHECK9-NEXT:    [[ADD66:%.*]] = fadd double [[CONV65]], 1.000000e+00
// CHECK9-NEXT:    [[CONV67:%.*]] = fptrunc double [[ADD66]] to float
// CHECK9-NEXT:    store float [[CONV67]], float* [[ARRAYIDX]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[ARRAYIDX68:%.*]] = getelementptr inbounds float, float* [[VLA]], i64 3
// CHECK9-NEXT:    [[TMP39:%.*]] = load float, float* [[ARRAYIDX68]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[CONV69:%.*]] = fpext float [[TMP39]] to double
// CHECK9-NEXT:    [[ADD70:%.*]] = fadd double [[CONV69]], 1.000000e+00
// CHECK9-NEXT:    [[CONV71:%.*]] = fptrunc double [[ADD70]] to float
// CHECK9-NEXT:    store float [[CONV71]], float* [[ARRAYIDX68]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[ARRAYIDX72:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[C]], i64 0, i64 1
// CHECK9-NEXT:    [[ARRAYIDX73:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX72]], i64 0, i64 2
// CHECK9-NEXT:    [[TMP40:%.*]] = load double, double* [[ARRAYIDX73]], align 8, !llvm.access.group !15
// CHECK9-NEXT:    [[ADD74:%.*]] = fadd double [[TMP40]], 1.000000e+00
// CHECK9-NEXT:    store double [[ADD74]], double* [[ARRAYIDX73]], align 8, !llvm.access.group !15
// CHECK9-NEXT:    [[TMP41:%.*]] = mul nsw i64 1, [[TMP4]]
// CHECK9-NEXT:    [[ARRAYIDX75:%.*]] = getelementptr inbounds double, double* [[VLA1]], i64 [[TMP41]]
// CHECK9-NEXT:    [[ARRAYIDX76:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX75]], i64 3
// CHECK9-NEXT:    [[TMP42:%.*]] = load double, double* [[ARRAYIDX76]], align 8, !llvm.access.group !15
// CHECK9-NEXT:    [[ADD77:%.*]] = fadd double [[TMP42]], 1.000000e+00
// CHECK9-NEXT:    store double [[ADD77]], double* [[ARRAYIDX76]], align 8, !llvm.access.group !15
// CHECK9-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[D]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP43:%.*]] = load i64, i64* [[X]], align 8, !llvm.access.group !15
// CHECK9-NEXT:    [[ADD78:%.*]] = add nsw i64 [[TMP43]], 1
// CHECK9-NEXT:    store i64 [[ADD78]], i64* [[X]], align 8, !llvm.access.group !15
// CHECK9-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[D]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP44:%.*]] = load i8, i8* [[Y]], align 8, !llvm.access.group !15
// CHECK9-NEXT:    [[CONV79:%.*]] = sext i8 [[TMP44]] to i32
// CHECK9-NEXT:    [[ADD80:%.*]] = add nsw i32 [[CONV79]], 1
// CHECK9-NEXT:    [[CONV81:%.*]] = trunc i32 [[ADD80]] to i8
// CHECK9-NEXT:    store i8 [[CONV81]], i8* [[Y]], align 8, !llvm.access.group !15
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE82:%.*]]
// CHECK9:       omp.body.continue82:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC83:%.*]]
// CHECK9:       omp.inner.for.inc83:
// CHECK9-NEXT:    [[TMP45:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    [[ADD84:%.*]] = add nsw i32 [[TMP45]], 1
// CHECK9-NEXT:    store i32 [[ADD84]], i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !15
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND59]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK9:       omp.inner.for.end85:
// CHECK9-NEXT:    store i32 10, i32* [[I58]], align 4
// CHECK9-NEXT:    [[TMP46:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    [[TMP47:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK9-NEXT:    call void @llvm.stackrestore(i8* [[TMP47]])
// CHECK9-NEXT:    ret i32 [[TMP46]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z3bari
// CHECK9-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 8
// CHECK9-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z3fooi(i32 noundef signext [[TMP0]])
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[CALL1:%.*]] = call noundef signext i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 8 dereferenceable(8) [[S]], i32 noundef signext [[TMP2]])
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK9-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[CALL3:%.*]] = call noundef signext i32 @_ZL7fstatici(i32 noundef signext [[TMP4]])
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK9-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[CALL5:%.*]] = call noundef signext i32 @_Z9ftemplateIiET_i(i32 noundef signext [[TMP6]])
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK9-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK9-SAME: (%struct.S1* noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK9-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK9-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK9-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK9-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK9-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP4]], align 2
// CHECK9-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK9-NEXT:    [[ADD2:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD2]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[B]], align 4, !llvm.access.group !18
// CHECK9-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP9]] to double
// CHECK9-NEXT:    [[ADD3:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK9-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK9-NEXT:    store double [[ADD3]], double* [[A]], align 8, !llvm.access.group !18
// CHECK9-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP10:%.*]] = load double, double* [[A4]], align 8, !llvm.access.group !18
// CHECK9-NEXT:    [[INC:%.*]] = fadd double [[TMP10]], 1.000000e+00
// CHECK9-NEXT:    store double [[INC]], double* [[A4]], align 8, !llvm.access.group !18
// CHECK9-NEXT:    [[CONV5:%.*]] = fptosi double [[INC]] to i16
// CHECK9-NEXT:    [[TMP11:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP11]]
// CHECK9-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK9-NEXT:    store i16 [[CONV5]], i16* [[ARRAYIDX6]], align 2, !llvm.access.group !18
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK9-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK9-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP13]]
// CHECK9-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX8]], i64 1
// CHECK9-NEXT:    [[TMP14:%.*]] = load i16, i16* [[ARRAYIDX9]], align 2
// CHECK9-NEXT:    [[CONV10:%.*]] = sext i16 [[TMP14]] to i32
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[B]], align 4
// CHECK9-NEXT:    [[ADD11:%.*]] = add nsw i32 [[CONV10]], [[TMP15]]
// CHECK9-NEXT:    [[TMP16:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK9-NEXT:    call void @llvm.stackrestore(i8* [[TMP16]])
// CHECK9-NEXT:    ret i32 [[ADD11]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK9-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK9-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK9-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK9-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK9-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub i32 [[TMP2]], [[TMP3]]
// CHECK9-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], 1
// CHECK9-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK9-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB4]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK9:       simd.if.then:
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[ADD6:%.*]] = add i32 [[TMP10]], 1
// CHECK9-NEXT:    [[CMP7:%.*]] = icmp ult i32 [[TMP9]], [[ADD6]]
// CHECK9-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[MUL:%.*]] = mul i32 [[TMP12]], 1
// CHECK9-NEXT:    [[ADD8:%.*]] = add i32 [[TMP11]], [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD8]], i32* [[I5]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[A]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[TMP14:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !21
// CHECK9-NEXT:    [[CONV:%.*]] = sext i16 [[TMP14]] to i32
// CHECK9-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV]], 1
// CHECK9-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i16
// CHECK9-NEXT:    store i16 [[CONV11]], i16* [[AA]], align 2, !llvm.access.group !21
// CHECK9-NEXT:    [[TMP15:%.*]] = load i8, i8* [[AAA]], align 1, !llvm.access.group !21
// CHECK9-NEXT:    [[CONV12:%.*]] = sext i8 [[TMP15]] to i32
// CHECK9-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK9-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i8
// CHECK9-NEXT:    store i8 [[CONV14]], i8* [[AAA]], align 1, !llvm.access.group !21
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[B]], i64 0, i64 2
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK9-NEXT:    store i32 [[ADD15]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    [[ADD16:%.*]] = add i32 [[TMP17]], 1
// CHECK9-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB17:%.*]] = sub i32 [[TMP19]], [[TMP20]]
// CHECK9-NEXT:    [[SUB18:%.*]] = sub i32 [[SUB17]], 1
// CHECK9-NEXT:    [[ADD19:%.*]] = add i32 [[SUB18]], 1
// CHECK9-NEXT:    [[DIV20:%.*]] = udiv i32 [[ADD19]], 1
// CHECK9-NEXT:    [[MUL21:%.*]] = mul i32 [[DIV20]], 1
// CHECK9-NEXT:    [[ADD22:%.*]] = add i32 [[TMP18]], [[MUL21]]
// CHECK9-NEXT:    store i32 [[ADD22]], i32* [[I5]], align 4
// CHECK9-NEXT:    br label [[SIMD_IF_END]]
// CHECK9:       simd.if.end:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    ret i32 [[TMP21]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK9-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK9-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK9-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK9-NEXT:    store i32 [[ADD1]], i32* [[A]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    [[TMP5:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !24
// CHECK9-NEXT:    [[CONV:%.*]] = sext i16 [[TMP5]] to i32
// CHECK9-NEXT:    [[ADD2:%.*]] = add nsw i32 [[CONV]], 1
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD2]] to i16
// CHECK9-NEXT:    store i16 [[CONV3]], i16* [[AA]], align 2, !llvm.access.group !24
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[B]], i64 0, i64 2
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK9-NEXT:    store i32 [[ADD4]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK9-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK9-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK11-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK11-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK11-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK11-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK11-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB5:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB6:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV7:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A8:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A9:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[_TMP20:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB21:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB22:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV23:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I24:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[_TMP36:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB37:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB38:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV39:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I40:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[_TMP54:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB55:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB56:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV57:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I58:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK11-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK11-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK11-NEXT:    [[VLA:%.*]] = alloca float, i32 [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = mul nuw i32 5, [[TMP2]]
// CHECK11-NEXT:    [[VLA1:%.*]] = alloca double, i32 [[TMP3]], align 8
// CHECK11-NEXT:    store i32 [[TMP2]], i32* [[__VLA_EXPR1]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK11-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB5]], align 4
// CHECK11-NEXT:    store i32 9, i32* [[DOTOMP_UB6]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_LB5]], align 4
// CHECK11-NEXT:    store i32 [[TMP11]], i32* [[DOTOMP_IV7]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    store i32 [[TMP12]], i32* [[DOTLINEAR_START]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK11:       omp.inner.for.cond10:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB6]], align 4
// CHECK11-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK11-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY12:%.*]], label [[OMP_INNER_FOR_END19:%.*]]
// CHECK11:       omp.inner.for.body12:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK11-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK11-NEXT:    [[ADD14:%.*]] = add nsw i32 0, [[MUL13]]
// CHECK11-NEXT:    store i32 [[ADD14]], i32* [[A8]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[A8]], align 4
// CHECK11-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK11-NEXT:    store i32 [[ADD15]], i32* [[A8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE16:%.*]]
// CHECK11:       omp.body.continue16:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC17:%.*]]
// CHECK11:       omp.inner.for.inc17:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK11-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK11-NEXT:    store i32 [[ADD18]], i32* [[DOTOMP_IV7]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK11:       omp.inner.for.end19:
// CHECK11-NEXT:    store i32 10, i32* [[A]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB21]], align 4
// CHECK11-NEXT:    store i32 9, i32* [[DOTOMP_UB22]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB21]], align 4
// CHECK11-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV23]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND25:%.*]]
// CHECK11:       omp.inner.for.cond25:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB22]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[CMP26:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    br i1 [[CMP26]], label [[OMP_INNER_FOR_BODY27:%.*]], label [[OMP_INNER_FOR_END35:%.*]]
// CHECK11:       omp.inner.for.body27:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[MUL28:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK11-NEXT:    [[ADD29:%.*]] = add nsw i32 0, [[MUL28]]
// CHECK11-NEXT:    store i32 [[ADD29]], i32* [[I24]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[TMP22:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !10
// CHECK11-NEXT:    [[CONV:%.*]] = sext i16 [[TMP22]] to i32
// CHECK11-NEXT:    [[ADD30:%.*]] = add nsw i32 [[CONV]], 1
// CHECK11-NEXT:    [[CONV31:%.*]] = trunc i32 [[ADD30]] to i16
// CHECK11-NEXT:    store i16 [[CONV31]], i16* [[AA]], align 2, !llvm.access.group !10
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE32:%.*]]
// CHECK11:       omp.body.continue32:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC33:%.*]]
// CHECK11:       omp.inner.for.inc33:
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    [[ADD34:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK11-NEXT:    store i32 [[ADD34]], i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !10
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND25]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK11:       omp.inner.for.end35:
// CHECK11-NEXT:    store i32 10, i32* [[I24]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB37]], align 4
// CHECK11-NEXT:    store i32 9, i32* [[DOTOMP_UB38]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_LB37]], align 4
// CHECK11-NEXT:    store i32 [[TMP24]], i32* [[DOTOMP_IV39]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND41:%.*]]
// CHECK11:       omp.inner.for.cond41:
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_UB38]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[CMP42:%.*]] = icmp sle i32 [[TMP25]], [[TMP26]]
// CHECK11-NEXT:    br i1 [[CMP42]], label [[OMP_INNER_FOR_BODY43:%.*]], label [[OMP_INNER_FOR_END53:%.*]]
// CHECK11:       omp.inner.for.body43:
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[MUL44:%.*]] = mul nsw i32 [[TMP27]], 1
// CHECK11-NEXT:    [[ADD45:%.*]] = add nsw i32 0, [[MUL44]]
// CHECK11-NEXT:    store i32 [[ADD45]], i32* [[I40]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[ADD46:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK11-NEXT:    store i32 [[ADD46]], i32* [[A]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[TMP29:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !13
// CHECK11-NEXT:    [[CONV47:%.*]] = sext i16 [[TMP29]] to i32
// CHECK11-NEXT:    [[ADD48:%.*]] = add nsw i32 [[CONV47]], 1
// CHECK11-NEXT:    [[CONV49:%.*]] = trunc i32 [[ADD48]] to i16
// CHECK11-NEXT:    store i16 [[CONV49]], i16* [[AA]], align 2, !llvm.access.group !13
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE50:%.*]]
// CHECK11:       omp.body.continue50:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC51:%.*]]
// CHECK11:       omp.inner.for.inc51:
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    [[ADD52:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK11-NEXT:    store i32 [[ADD52]], i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !13
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND41]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK11:       omp.inner.for.end53:
// CHECK11-NEXT:    store i32 10, i32* [[I40]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB55]], align 4
// CHECK11-NEXT:    store i32 9, i32* [[DOTOMP_UB56]], align 4
// CHECK11-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_LB55]], align 4
// CHECK11-NEXT:    store i32 [[TMP31]], i32* [[DOTOMP_IV57]], align 4
// CHECK11-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[B]], i32 0, i32 0
// CHECK11-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i32 16) ]
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND59:%.*]]
// CHECK11:       omp.inner.for.cond59:
// CHECK11-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_UB56]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[CMP60:%.*]] = icmp sle i32 [[TMP32]], [[TMP33]]
// CHECK11-NEXT:    br i1 [[CMP60]], label [[OMP_INNER_FOR_BODY61:%.*]], label [[OMP_INNER_FOR_END85:%.*]]
// CHECK11:       omp.inner.for.body61:
// CHECK11-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[MUL62:%.*]] = mul nsw i32 [[TMP34]], 1
// CHECK11-NEXT:    [[ADD63:%.*]] = add nsw i32 0, [[MUL62]]
// CHECK11-NEXT:    store i32 [[ADD63]], i32* [[I58]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[TMP35:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[ADD64:%.*]] = add nsw i32 [[TMP35]], 1
// CHECK11-NEXT:    store i32 [[ADD64]], i32* [[A]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[B]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP36:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[CONV65:%.*]] = fpext float [[TMP36]] to double
// CHECK11-NEXT:    [[ADD66:%.*]] = fadd double [[CONV65]], 1.000000e+00
// CHECK11-NEXT:    [[CONV67:%.*]] = fptrunc double [[ADD66]] to float
// CHECK11-NEXT:    store float [[CONV67]], float* [[ARRAYIDX]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[ARRAYIDX68:%.*]] = getelementptr inbounds float, float* [[VLA]], i32 3
// CHECK11-NEXT:    [[TMP37:%.*]] = load float, float* [[ARRAYIDX68]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[CONV69:%.*]] = fpext float [[TMP37]] to double
// CHECK11-NEXT:    [[ADD70:%.*]] = fadd double [[CONV69]], 1.000000e+00
// CHECK11-NEXT:    [[CONV71:%.*]] = fptrunc double [[ADD70]] to float
// CHECK11-NEXT:    store float [[CONV71]], float* [[ARRAYIDX68]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[ARRAYIDX72:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[C]], i32 0, i32 1
// CHECK11-NEXT:    [[ARRAYIDX73:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX72]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP38:%.*]] = load double, double* [[ARRAYIDX73]], align 8, !llvm.access.group !16
// CHECK11-NEXT:    [[ADD74:%.*]] = fadd double [[TMP38]], 1.000000e+00
// CHECK11-NEXT:    store double [[ADD74]], double* [[ARRAYIDX73]], align 8, !llvm.access.group !16
// CHECK11-NEXT:    [[TMP39:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK11-NEXT:    [[ARRAYIDX75:%.*]] = getelementptr inbounds double, double* [[VLA1]], i32 [[TMP39]]
// CHECK11-NEXT:    [[ARRAYIDX76:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX75]], i32 3
// CHECK11-NEXT:    [[TMP40:%.*]] = load double, double* [[ARRAYIDX76]], align 8, !llvm.access.group !16
// CHECK11-NEXT:    [[ADD77:%.*]] = fadd double [[TMP40]], 1.000000e+00
// CHECK11-NEXT:    store double [[ADD77]], double* [[ARRAYIDX76]], align 8, !llvm.access.group !16
// CHECK11-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[D]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP41:%.*]] = load i64, i64* [[X]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[ADD78:%.*]] = add nsw i64 [[TMP41]], 1
// CHECK11-NEXT:    store i64 [[ADD78]], i64* [[X]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[D]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP42:%.*]] = load i8, i8* [[Y]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[CONV79:%.*]] = sext i8 [[TMP42]] to i32
// CHECK11-NEXT:    [[ADD80:%.*]] = add nsw i32 [[CONV79]], 1
// CHECK11-NEXT:    [[CONV81:%.*]] = trunc i32 [[ADD80]] to i8
// CHECK11-NEXT:    store i8 [[CONV81]], i8* [[Y]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE82:%.*]]
// CHECK11:       omp.body.continue82:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC83:%.*]]
// CHECK11:       omp.inner.for.inc83:
// CHECK11-NEXT:    [[TMP43:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    [[ADD84:%.*]] = add nsw i32 [[TMP43]], 1
// CHECK11-NEXT:    store i32 [[ADD84]], i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !16
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND59]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK11:       omp.inner.for.end85:
// CHECK11-NEXT:    store i32 10, i32* [[I58]], align 4
// CHECK11-NEXT:    [[TMP44:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    [[TMP45:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK11-NEXT:    call void @llvm.stackrestore(i8* [[TMP45]])
// CHECK11-NEXT:    ret i32 [[TMP44]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z3bari
// CHECK11-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP0]])
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[CALL1:%.*]] = call noundef i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 4 dereferenceable(8) [[S]], i32 noundef [[TMP2]])
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK11-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[CALL3:%.*]] = call noundef i32 @_ZL7fstatici(i32 noundef [[TMP4]])
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK11-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[CALL5:%.*]] = call noundef i32 @_Z9ftemplateIiET_i(i32 noundef [[TMP6]])
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK11-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK11-SAME: (%struct.S1* noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK11-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK11-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK11-NEXT:    [[VLA:%.*]] = alloca i16, i32 [[TMP3]], align 2
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK11-NEXT:    [[ADD2:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD2]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[B]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP8]] to double
// CHECK11-NEXT:    [[ADD3:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK11-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK11-NEXT:    store double [[ADD3]], double* [[A]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[A4:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP9:%.*]] = load double, double* [[A4]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[INC:%.*]] = fadd double [[TMP9]], 1.000000e+00
// CHECK11-NEXT:    store double [[INC]], double* [[A4]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[CONV5:%.*]] = fptosi double [[INC]] to i16
// CHECK11-NEXT:    [[TMP10:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP10]]
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK11-NEXT:    store i16 [[CONV5]], i16* [[ARRAYIDX6]], align 2, !llvm.access.group !19
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP12]]
// CHECK11-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX8]], i32 1
// CHECK11-NEXT:    [[TMP13:%.*]] = load i16, i16* [[ARRAYIDX9]], align 2
// CHECK11-NEXT:    [[CONV10:%.*]] = sext i16 [[TMP13]] to i32
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[B]], align 4
// CHECK11-NEXT:    [[ADD11:%.*]] = add nsw i32 [[CONV10]], [[TMP14]]
// CHECK11-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK11-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK11-NEXT:    ret i32 [[ADD11]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK11-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK11-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK11-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK11-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK11-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub i32 [[TMP2]], [[TMP3]]
// CHECK11-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], 1
// CHECK11-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK11-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB4]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK11:       simd.if.then:
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[ADD6:%.*]] = add i32 [[TMP10]], 1
// CHECK11-NEXT:    [[CMP7:%.*]] = icmp ult i32 [[TMP9]], [[ADD6]]
// CHECK11-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[MUL:%.*]] = mul i32 [[TMP12]], 1
// CHECK11-NEXT:    [[ADD8:%.*]] = add i32 [[TMP11]], [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD8]], i32* [[I5]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[A]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[TMP14:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !22
// CHECK11-NEXT:    [[CONV:%.*]] = sext i16 [[TMP14]] to i32
// CHECK11-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV]], 1
// CHECK11-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i16
// CHECK11-NEXT:    store i16 [[CONV11]], i16* [[AA]], align 2, !llvm.access.group !22
// CHECK11-NEXT:    [[TMP15:%.*]] = load i8, i8* [[AAA]], align 1, !llvm.access.group !22
// CHECK11-NEXT:    [[CONV12:%.*]] = sext i8 [[TMP15]] to i32
// CHECK11-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK11-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i8
// CHECK11-NEXT:    store i8 [[CONV14]], i8* [[AAA]], align 1, !llvm.access.group !22
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[B]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK11-NEXT:    store i32 [[ADD15]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    [[ADD16:%.*]] = add i32 [[TMP17]], 1
// CHECK11-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB17:%.*]] = sub i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    [[SUB18:%.*]] = sub i32 [[SUB17]], 1
// CHECK11-NEXT:    [[ADD19:%.*]] = add i32 [[SUB18]], 1
// CHECK11-NEXT:    [[DIV20:%.*]] = udiv i32 [[ADD19]], 1
// CHECK11-NEXT:    [[MUL21:%.*]] = mul i32 [[DIV20]], 1
// CHECK11-NEXT:    [[ADD22:%.*]] = add i32 [[TMP18]], [[MUL21]]
// CHECK11-NEXT:    store i32 [[ADD22]], i32* [[I5]], align 4
// CHECK11-NEXT:    br label [[SIMD_IF_END]]
// CHECK11:       simd.if.end:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    ret i32 [[TMP21]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK11-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK11-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK11-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK11-NEXT:    store i32 [[ADD1]], i32* [[A]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    [[TMP5:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !25
// CHECK11-NEXT:    [[CONV:%.*]] = sext i16 [[TMP5]] to i32
// CHECK11-NEXT:    [[ADD2:%.*]] = add nsw i32 [[CONV]], 1
// CHECK11-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD2]] to i16
// CHECK11-NEXT:    store i16 [[CONV3]], i16* [[AA]], align 2, !llvm.access.group !25
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[B]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK11-NEXT:    store i32 [[ADD4]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK11-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP26:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK11-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK13-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK13-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK13-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK13-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK13-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK13-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i64, align 8
// CHECK13-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 8
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB5:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB6:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV7:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[A8:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[A9:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[_TMP20:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB21:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB22:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV23:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I24:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[_TMP36:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB37:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB38:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV39:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I40:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[_TMP54:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB55:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB56:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV57:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I58:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK13-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK13-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK13-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK13-NEXT:    [[VLA:%.*]] = alloca float, i64 [[TMP1]], align 4
// CHECK13-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[TMP4:%.*]] = zext i32 [[TMP3]] to i64
// CHECK13-NEXT:    [[TMP5:%.*]] = mul nuw i64 5, [[TMP4]]
// CHECK13-NEXT:    [[VLA1:%.*]] = alloca double, i64 [[TMP5]], align 8
// CHECK13-NEXT:    store i64 [[TMP4]], i64* [[__VLA_EXPR1]], align 8
// CHECK13-NEXT:    [[TMP6:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    store i32 [[TMP7]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK13-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB5]], align 4
// CHECK13-NEXT:    store i32 9, i32* [[DOTOMP_UB6]], align 4
// CHECK13-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB5]], align 4
// CHECK13-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV7]], align 4
// CHECK13-NEXT:    [[TMP14:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    store i32 [[TMP14]], i32* [[DOTLINEAR_START]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK13:       omp.inner.for.cond10:
// CHECK13-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK13-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB6]], align 4
// CHECK13-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK13-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY12:%.*]], label [[OMP_INNER_FOR_END19:%.*]]
// CHECK13:       omp.inner.for.body12:
// CHECK13-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK13-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK13-NEXT:    [[ADD14:%.*]] = add nsw i32 0, [[MUL13]]
// CHECK13-NEXT:    store i32 [[ADD14]], i32* [[A8]], align 4, !nontemporal !7
// CHECK13-NEXT:    [[TMP18:%.*]] = load i32, i32* [[A8]], align 4, !nontemporal !7
// CHECK13-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK13-NEXT:    store i32 [[ADD15]], i32* [[A8]], align 4, !nontemporal !7
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE16:%.*]]
// CHECK13:       omp.body.continue16:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC17:%.*]]
// CHECK13:       omp.inner.for.inc17:
// CHECK13-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK13-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK13-NEXT:    store i32 [[ADD18]], i32* [[DOTOMP_IV7]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK13:       omp.inner.for.end19:
// CHECK13-NEXT:    store i32 10, i32* [[A]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB21]], align 4
// CHECK13-NEXT:    store i32 9, i32* [[DOTOMP_UB22]], align 4
// CHECK13-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_LB21]], align 4
// CHECK13-NEXT:    store i32 [[TMP20]], i32* [[DOTOMP_IV23]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND25:%.*]]
// CHECK13:       omp.inner.for.cond25:
// CHECK13-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_UB22]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[CMP26:%.*]] = icmp sle i32 [[TMP21]], [[TMP22]]
// CHECK13-NEXT:    br i1 [[CMP26]], label [[OMP_INNER_FOR_BODY27:%.*]], label [[OMP_INNER_FOR_END35:%.*]]
// CHECK13:       omp.inner.for.body27:
// CHECK13-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[MUL28:%.*]] = mul nsw i32 [[TMP23]], 1
// CHECK13-NEXT:    [[ADD29:%.*]] = add nsw i32 0, [[MUL28]]
// CHECK13-NEXT:    store i32 [[ADD29]], i32* [[I24]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[TMP24:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !10
// CHECK13-NEXT:    [[CONV:%.*]] = sext i16 [[TMP24]] to i32
// CHECK13-NEXT:    [[ADD30:%.*]] = add nsw i32 [[CONV]], 1
// CHECK13-NEXT:    [[CONV31:%.*]] = trunc i32 [[ADD30]] to i16
// CHECK13-NEXT:    store i16 [[CONV31]], i16* [[AA]], align 2, !llvm.access.group !10
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE32:%.*]]
// CHECK13:       omp.body.continue32:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC33:%.*]]
// CHECK13:       omp.inner.for.inc33:
// CHECK13-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    [[ADD34:%.*]] = add nsw i32 [[TMP25]], 1
// CHECK13-NEXT:    store i32 [[ADD34]], i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !10
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND25]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK13:       omp.inner.for.end35:
// CHECK13-NEXT:    store i32 10, i32* [[I24]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB37]], align 4
// CHECK13-NEXT:    store i32 9, i32* [[DOTOMP_UB38]], align 4
// CHECK13-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_LB37]], align 4
// CHECK13-NEXT:    store i32 [[TMP26]], i32* [[DOTOMP_IV39]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND41:%.*]]
// CHECK13:       omp.inner.for.cond41:
// CHECK13-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_UB38]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[CMP42:%.*]] = icmp sle i32 [[TMP27]], [[TMP28]]
// CHECK13-NEXT:    br i1 [[CMP42]], label [[OMP_INNER_FOR_BODY43:%.*]], label [[OMP_INNER_FOR_END53:%.*]]
// CHECK13:       omp.inner.for.body43:
// CHECK13-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[MUL44:%.*]] = mul nsw i32 [[TMP29]], 1
// CHECK13-NEXT:    [[ADD45:%.*]] = add nsw i32 0, [[MUL44]]
// CHECK13-NEXT:    store i32 [[ADD45]], i32* [[I40]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[TMP30:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[ADD46:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK13-NEXT:    store i32 [[ADD46]], i32* [[A]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[TMP31:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !13
// CHECK13-NEXT:    [[CONV47:%.*]] = sext i16 [[TMP31]] to i32
// CHECK13-NEXT:    [[ADD48:%.*]] = add nsw i32 [[CONV47]], 1
// CHECK13-NEXT:    [[CONV49:%.*]] = trunc i32 [[ADD48]] to i16
// CHECK13-NEXT:    store i16 [[CONV49]], i16* [[AA]], align 2, !llvm.access.group !13
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE50:%.*]]
// CHECK13:       omp.body.continue50:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC51:%.*]]
// CHECK13:       omp.inner.for.inc51:
// CHECK13-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    [[ADD52:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK13-NEXT:    store i32 [[ADD52]], i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !13
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND41]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK13:       omp.inner.for.end53:
// CHECK13-NEXT:    store i32 10, i32* [[I40]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB55]], align 4
// CHECK13-NEXT:    store i32 9, i32* [[DOTOMP_UB56]], align 4
// CHECK13-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_LB55]], align 4
// CHECK13-NEXT:    store i32 [[TMP33]], i32* [[DOTOMP_IV57]], align 4
// CHECK13-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[B]], i64 0, i64 0
// CHECK13-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i64 16) ]
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND59:%.*]]
// CHECK13:       omp.inner.for.cond59:
// CHECK13-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTOMP_UB56]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[CMP60:%.*]] = icmp sle i32 [[TMP34]], [[TMP35]]
// CHECK13-NEXT:    br i1 [[CMP60]], label [[OMP_INNER_FOR_BODY61:%.*]], label [[OMP_INNER_FOR_END85:%.*]]
// CHECK13:       omp.inner.for.body61:
// CHECK13-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[MUL62:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK13-NEXT:    [[ADD63:%.*]] = add nsw i32 0, [[MUL62]]
// CHECK13-NEXT:    store i32 [[ADD63]], i32* [[I58]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[TMP37:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[ADD64:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK13-NEXT:    store i32 [[ADD64]], i32* [[A]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[B]], i64 0, i64 2
// CHECK13-NEXT:    [[TMP38:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[CONV65:%.*]] = fpext float [[TMP38]] to double
// CHECK13-NEXT:    [[ADD66:%.*]] = fadd double [[CONV65]], 1.000000e+00
// CHECK13-NEXT:    [[CONV67:%.*]] = fptrunc double [[ADD66]] to float
// CHECK13-NEXT:    store float [[CONV67]], float* [[ARRAYIDX]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[ARRAYIDX68:%.*]] = getelementptr inbounds float, float* [[VLA]], i64 3
// CHECK13-NEXT:    [[TMP39:%.*]] = load float, float* [[ARRAYIDX68]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[CONV69:%.*]] = fpext float [[TMP39]] to double
// CHECK13-NEXT:    [[ADD70:%.*]] = fadd double [[CONV69]], 1.000000e+00
// CHECK13-NEXT:    [[CONV71:%.*]] = fptrunc double [[ADD70]] to float
// CHECK13-NEXT:    store float [[CONV71]], float* [[ARRAYIDX68]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[ARRAYIDX72:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[C]], i64 0, i64 1
// CHECK13-NEXT:    [[ARRAYIDX73:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX72]], i64 0, i64 2
// CHECK13-NEXT:    [[TMP40:%.*]] = load double, double* [[ARRAYIDX73]], align 8, !llvm.access.group !16
// CHECK13-NEXT:    [[ADD74:%.*]] = fadd double [[TMP40]], 1.000000e+00
// CHECK13-NEXT:    store double [[ADD74]], double* [[ARRAYIDX73]], align 8, !llvm.access.group !16
// CHECK13-NEXT:    [[TMP41:%.*]] = mul nsw i64 1, [[TMP4]]
// CHECK13-NEXT:    [[ARRAYIDX75:%.*]] = getelementptr inbounds double, double* [[VLA1]], i64 [[TMP41]]
// CHECK13-NEXT:    [[ARRAYIDX76:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX75]], i64 3
// CHECK13-NEXT:    [[TMP42:%.*]] = load double, double* [[ARRAYIDX76]], align 8, !llvm.access.group !16
// CHECK13-NEXT:    [[ADD77:%.*]] = fadd double [[TMP42]], 1.000000e+00
// CHECK13-NEXT:    store double [[ADD77]], double* [[ARRAYIDX76]], align 8, !llvm.access.group !16
// CHECK13-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[D]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP43:%.*]] = load i64, i64* [[X]], align 8, !llvm.access.group !16
// CHECK13-NEXT:    [[ADD78:%.*]] = add nsw i64 [[TMP43]], 1
// CHECK13-NEXT:    store i64 [[ADD78]], i64* [[X]], align 8, !llvm.access.group !16
// CHECK13-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[D]], i32 0, i32 1
// CHECK13-NEXT:    [[TMP44:%.*]] = load i8, i8* [[Y]], align 8, !llvm.access.group !16
// CHECK13-NEXT:    [[CONV79:%.*]] = sext i8 [[TMP44]] to i32
// CHECK13-NEXT:    [[ADD80:%.*]] = add nsw i32 [[CONV79]], 1
// CHECK13-NEXT:    [[CONV81:%.*]] = trunc i32 [[ADD80]] to i8
// CHECK13-NEXT:    store i8 [[CONV81]], i8* [[Y]], align 8, !llvm.access.group !16
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE82:%.*]]
// CHECK13:       omp.body.continue82:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC83:%.*]]
// CHECK13:       omp.inner.for.inc83:
// CHECK13-NEXT:    [[TMP45:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    [[ADD84:%.*]] = add nsw i32 [[TMP45]], 1
// CHECK13-NEXT:    store i32 [[ADD84]], i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !16
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND59]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK13:       omp.inner.for.end85:
// CHECK13-NEXT:    store i32 10, i32* [[I58]], align 4
// CHECK13-NEXT:    [[TMP46:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    [[TMP47:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK13-NEXT:    call void @llvm.stackrestore(i8* [[TMP47]])
// CHECK13-NEXT:    ret i32 [[TMP46]]
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z3bari
// CHECK13-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 8
// CHECK13-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z3fooi(i32 noundef signext [[TMP0]])
// CHECK13-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK13-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[CALL1:%.*]] = call noundef signext i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 8 dereferenceable(8) [[S]], i32 noundef signext [[TMP2]])
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK13-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK13-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[CALL3:%.*]] = call noundef signext i32 @_ZL7fstatici(i32 noundef signext [[TMP4]])
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK13-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK13-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[CALL5:%.*]] = call noundef signext i32 @_Z9ftemplateIiET_i(i32 noundef signext [[TMP6]])
// CHECK13-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK13-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK13-SAME: (%struct.S1* noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]], i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK13-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK13-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK13-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK13-NEXT:    [[TMP3:%.*]] = call i8* @llvm.stacksave()
// CHECK13-NEXT:    store i8* [[TMP3]], i8** [[SAVED_STACK]], align 8
// CHECK13-NEXT:    [[TMP4:%.*]] = mul nuw i64 2, [[TMP2]]
// CHECK13-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP4]], align 2
// CHECK13-NEXT:    store i64 [[TMP2]], i64* [[__VLA_EXPR0]], align 8
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 60
// CHECK13-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[CMP]] to i8
// CHECK13-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[TMP7:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK13-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP7]] to i1
// CHECK13-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK13:       omp_if.then:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK13-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK13-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK13-NEXT:    [[ADD3:%.*]] = add nsw i32 0, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD3]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[B]], align 4, !llvm.access.group !19
// CHECK13-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP11]] to double
// CHECK13-NEXT:    [[ADD4:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK13-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK13-NEXT:    store double [[ADD4]], double* [[A]], align 8, !llvm.access.group !19
// CHECK13-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP12:%.*]] = load double, double* [[A5]], align 8, !llvm.access.group !19
// CHECK13-NEXT:    [[INC:%.*]] = fadd double [[TMP12]], 1.000000e+00
// CHECK13-NEXT:    store double [[INC]], double* [[A5]], align 8, !llvm.access.group !19
// CHECK13-NEXT:    [[CONV6:%.*]] = fptosi double [[INC]] to i16
// CHECK13-NEXT:    [[TMP13:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP13]]
// CHECK13-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK13-NEXT:    store i16 [[CONV6]], i16* [[ARRAYIDX7]], align 2, !llvm.access.group !19
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK13-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK13-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK13:       omp_if.else:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND9:%.*]]
// CHECK13:       omp.inner.for.cond9:
// CHECK13-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK13-NEXT:    br i1 [[CMP10]], label [[OMP_INNER_FOR_BODY11:%.*]], label [[OMP_INNER_FOR_END25:%.*]]
// CHECK13:       omp.inner.for.body11:
// CHECK13-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK13-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK13-NEXT:    store i32 [[ADD13]], i32* [[I]], align 4
// CHECK13-NEXT:    [[TMP18:%.*]] = load i32, i32* [[B]], align 4
// CHECK13-NEXT:    [[CONV14:%.*]] = sitofp i32 [[TMP18]] to double
// CHECK13-NEXT:    [[ADD15:%.*]] = fadd double [[CONV14]], 1.500000e+00
// CHECK13-NEXT:    [[A16:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK13-NEXT:    store double [[ADD15]], double* [[A16]], align 8
// CHECK13-NEXT:    [[A17:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP19:%.*]] = load double, double* [[A17]], align 8
// CHECK13-NEXT:    [[INC18:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK13-NEXT:    store double [[INC18]], double* [[A17]], align 8
// CHECK13-NEXT:    [[CONV19:%.*]] = fptosi double [[INC18]] to i16
// CHECK13-NEXT:    [[TMP20:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK13-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP20]]
// CHECK13-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX20]], i64 1
// CHECK13-NEXT:    store i16 [[CONV19]], i16* [[ARRAYIDX21]], align 2
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE22:%.*]]
// CHECK13:       omp.body.continue22:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC23:%.*]]
// CHECK13:       omp.inner.for.inc23:
// CHECK13-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP21]], 1
// CHECK13-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND9]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK13:       omp.inner.for.end25:
// CHECK13-NEXT:    br label [[OMP_IF_END]]
// CHECK13:       omp_if.end:
// CHECK13-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK13-NEXT:    [[TMP22:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK13-NEXT:    [[ARRAYIDX26:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i64 [[TMP22]]
// CHECK13-NEXT:    [[ARRAYIDX27:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX26]], i64 1
// CHECK13-NEXT:    [[TMP23:%.*]] = load i16, i16* [[ARRAYIDX27]], align 2
// CHECK13-NEXT:    [[CONV28:%.*]] = sext i16 [[TMP23]] to i32
// CHECK13-NEXT:    [[TMP24:%.*]] = load i32, i32* [[B]], align 4
// CHECK13-NEXT:    [[ADD29:%.*]] = add nsw i32 [[CONV28]], [[TMP24]]
// CHECK13-NEXT:    [[TMP25:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK13-NEXT:    call void @llvm.stackrestore(i8* [[TMP25]])
// CHECK13-NEXT:    ret i32 [[ADD29]]
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK13-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK13-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK13-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK13-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK13-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    store i32 [[TMP0]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[SUB:%.*]] = sub i32 [[TMP2]], [[TMP3]]
// CHECK13-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], 1
// CHECK13-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK13-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK13-NEXT:    store i32 [[SUB4]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK13-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK13-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK13:       simd.if.then:
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[ADD6:%.*]] = add i32 [[TMP10]], 1
// CHECK13-NEXT:    [[CMP7:%.*]] = icmp ult i32 [[TMP9]], [[ADD6]]
// CHECK13-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[MUL:%.*]] = mul i32 [[TMP12]], 1
// CHECK13-NEXT:    [[ADD8:%.*]] = add i32 [[TMP11]], [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD8]], i32* [[I5]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[TMP13:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK13-NEXT:    store i32 [[ADD9]], i32* [[A]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[TMP14:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !24
// CHECK13-NEXT:    [[CONV:%.*]] = sext i16 [[TMP14]] to i32
// CHECK13-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV]], 1
// CHECK13-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i16
// CHECK13-NEXT:    store i16 [[CONV11]], i16* [[AA]], align 2, !llvm.access.group !24
// CHECK13-NEXT:    [[TMP15:%.*]] = load i8, i8* [[AAA]], align 1, !llvm.access.group !24
// CHECK13-NEXT:    [[CONV12:%.*]] = sext i8 [[TMP15]] to i32
// CHECK13-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK13-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i8
// CHECK13-NEXT:    store i8 [[CONV14]], i8* [[AAA]], align 1, !llvm.access.group !24
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[B]], i64 0, i64 2
// CHECK13-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK13-NEXT:    store i32 [[ADD15]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    [[ADD16:%.*]] = add i32 [[TMP17]], 1
// CHECK13-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[SUB17:%.*]] = sub i32 [[TMP19]], [[TMP20]]
// CHECK13-NEXT:    [[SUB18:%.*]] = sub i32 [[SUB17]], 1
// CHECK13-NEXT:    [[ADD19:%.*]] = add i32 [[SUB18]], 1
// CHECK13-NEXT:    [[DIV20:%.*]] = udiv i32 [[ADD19]], 1
// CHECK13-NEXT:    [[MUL21:%.*]] = mul i32 [[DIV20]], 1
// CHECK13-NEXT:    [[ADD22:%.*]] = add i32 [[TMP18]], [[MUL21]]
// CHECK13-NEXT:    store i32 [[ADD22]], i32* [[I5]], align 4
// CHECK13-NEXT:    br label [[SIMD_IF_END]]
// CHECK13:       simd.if.end:
// CHECK13-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    ret i32 [[TMP21]]
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK13-SAME: (i32 noundef signext [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK13-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK13-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK13-NEXT:    store i32 [[ADD1]], i32* [[A]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    [[TMP5:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !27
// CHECK13-NEXT:    [[CONV:%.*]] = sext i16 [[TMP5]] to i32
// CHECK13-NEXT:    [[ADD2:%.*]] = add nsw i32 [[CONV]], 1
// CHECK13-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD2]] to i16
// CHECK13-NEXT:    store i16 [[CONV3]], i16* [[AA]], align 2, !llvm.access.group !27
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[B]], i64 0, i64 2
// CHECK13-NEXT:    [[TMP6:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK13-NEXT:    store i32 [[ADD4]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK13-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK13-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z3fooi
// CHECK15-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK15-NEXT:    [[B:%.*]] = alloca [10 x float], align 4
// CHECK15-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK15-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[C:%.*]] = alloca [5 x [10 x double]], align 8
// CHECK15-NEXT:    [[__VLA_EXPR1:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[D:%.*]] = alloca [[STRUCT_TT:%.*]], align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB5:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB6:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV7:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[A8:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[A9:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[_TMP20:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB21:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB22:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV23:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I24:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[_TMP36:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB37:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB38:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV39:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I40:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[_TMP54:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB55:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB56:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV57:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I58:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK15-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK15-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK15-NEXT:    [[VLA:%.*]] = alloca float, i32 [[TMP0]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[TMP3:%.*]] = mul nuw i32 5, [[TMP2]]
// CHECK15-NEXT:    [[VLA1:%.*]] = alloca double, i32 [[TMP3]], align 8
// CHECK15-NEXT:    store i32 [[TMP2]], i32* [[__VLA_EXPR1]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK15-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB5]], align 4
// CHECK15-NEXT:    store i32 9, i32* [[DOTOMP_UB6]], align 4
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_LB5]], align 4
// CHECK15-NEXT:    store i32 [[TMP11]], i32* [[DOTOMP_IV7]], align 4
// CHECK15-NEXT:    [[TMP12:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    store i32 [[TMP12]], i32* [[DOTLINEAR_START]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK15:       omp.inner.for.cond10:
// CHECK15-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK15-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB6]], align 4
// CHECK15-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK15-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY12:%.*]], label [[OMP_INNER_FOR_END19:%.*]]
// CHECK15:       omp.inner.for.body12:
// CHECK15-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK15-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK15-NEXT:    [[ADD14:%.*]] = add nsw i32 0, [[MUL13]]
// CHECK15-NEXT:    store i32 [[ADD14]], i32* [[A8]], align 4, !nontemporal !8
// CHECK15-NEXT:    [[TMP16:%.*]] = load i32, i32* [[A8]], align 4, !nontemporal !8
// CHECK15-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK15-NEXT:    store i32 [[ADD15]], i32* [[A8]], align 4, !nontemporal !8
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE16:%.*]]
// CHECK15:       omp.body.continue16:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC17:%.*]]
// CHECK15:       omp.inner.for.inc17:
// CHECK15-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV7]], align 4
// CHECK15-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK15-NEXT:    store i32 [[ADD18]], i32* [[DOTOMP_IV7]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK15:       omp.inner.for.end19:
// CHECK15-NEXT:    store i32 10, i32* [[A]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB21]], align 4
// CHECK15-NEXT:    store i32 9, i32* [[DOTOMP_UB22]], align 4
// CHECK15-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB21]], align 4
// CHECK15-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV23]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND25:%.*]]
// CHECK15:       omp.inner.for.cond25:
// CHECK15-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB22]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[CMP26:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK15-NEXT:    br i1 [[CMP26]], label [[OMP_INNER_FOR_BODY27:%.*]], label [[OMP_INNER_FOR_END35:%.*]]
// CHECK15:       omp.inner.for.body27:
// CHECK15-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[MUL28:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK15-NEXT:    [[ADD29:%.*]] = add nsw i32 0, [[MUL28]]
// CHECK15-NEXT:    store i32 [[ADD29]], i32* [[I24]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[TMP22:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !11
// CHECK15-NEXT:    [[CONV:%.*]] = sext i16 [[TMP22]] to i32
// CHECK15-NEXT:    [[ADD30:%.*]] = add nsw i32 [[CONV]], 1
// CHECK15-NEXT:    [[CONV31:%.*]] = trunc i32 [[ADD30]] to i16
// CHECK15-NEXT:    store i16 [[CONV31]], i16* [[AA]], align 2, !llvm.access.group !11
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE32:%.*]]
// CHECK15:       omp.body.continue32:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC33:%.*]]
// CHECK15:       omp.inner.for.inc33:
// CHECK15-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    [[ADD34:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK15-NEXT:    store i32 [[ADD34]], i32* [[DOTOMP_IV23]], align 4, !llvm.access.group !11
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND25]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK15:       omp.inner.for.end35:
// CHECK15-NEXT:    store i32 10, i32* [[I24]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB37]], align 4
// CHECK15-NEXT:    store i32 9, i32* [[DOTOMP_UB38]], align 4
// CHECK15-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_LB37]], align 4
// CHECK15-NEXT:    store i32 [[TMP24]], i32* [[DOTOMP_IV39]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND41:%.*]]
// CHECK15:       omp.inner.for.cond41:
// CHECK15-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_UB38]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[CMP42:%.*]] = icmp sle i32 [[TMP25]], [[TMP26]]
// CHECK15-NEXT:    br i1 [[CMP42]], label [[OMP_INNER_FOR_BODY43:%.*]], label [[OMP_INNER_FOR_END53:%.*]]
// CHECK15:       omp.inner.for.body43:
// CHECK15-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[MUL44:%.*]] = mul nsw i32 [[TMP27]], 1
// CHECK15-NEXT:    [[ADD45:%.*]] = add nsw i32 0, [[MUL44]]
// CHECK15-NEXT:    store i32 [[ADD45]], i32* [[I40]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[TMP28:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[ADD46:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK15-NEXT:    store i32 [[ADD46]], i32* [[A]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[TMP29:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !14
// CHECK15-NEXT:    [[CONV47:%.*]] = sext i16 [[TMP29]] to i32
// CHECK15-NEXT:    [[ADD48:%.*]] = add nsw i32 [[CONV47]], 1
// CHECK15-NEXT:    [[CONV49:%.*]] = trunc i32 [[ADD48]] to i16
// CHECK15-NEXT:    store i16 [[CONV49]], i16* [[AA]], align 2, !llvm.access.group !14
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE50:%.*]]
// CHECK15:       omp.body.continue50:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC51:%.*]]
// CHECK15:       omp.inner.for.inc51:
// CHECK15-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    [[ADD52:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK15-NEXT:    store i32 [[ADD52]], i32* [[DOTOMP_IV39]], align 4, !llvm.access.group !14
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND41]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK15:       omp.inner.for.end53:
// CHECK15-NEXT:    store i32 10, i32* [[I40]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB55]], align 4
// CHECK15-NEXT:    store i32 9, i32* [[DOTOMP_UB56]], align 4
// CHECK15-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_LB55]], align 4
// CHECK15-NEXT:    store i32 [[TMP31]], i32* [[DOTOMP_IV57]], align 4
// CHECK15-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[B]], i32 0, i32 0
// CHECK15-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i32 16) ]
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND59:%.*]]
// CHECK15:       omp.inner.for.cond59:
// CHECK15-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_UB56]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[CMP60:%.*]] = icmp sle i32 [[TMP32]], [[TMP33]]
// CHECK15-NEXT:    br i1 [[CMP60]], label [[OMP_INNER_FOR_BODY61:%.*]], label [[OMP_INNER_FOR_END85:%.*]]
// CHECK15:       omp.inner.for.body61:
// CHECK15-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[MUL62:%.*]] = mul nsw i32 [[TMP34]], 1
// CHECK15-NEXT:    [[ADD63:%.*]] = add nsw i32 0, [[MUL62]]
// CHECK15-NEXT:    store i32 [[ADD63]], i32* [[I58]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[TMP35:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[ADD64:%.*]] = add nsw i32 [[TMP35]], 1
// CHECK15-NEXT:    store i32 [[ADD64]], i32* [[A]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[B]], i32 0, i32 2
// CHECK15-NEXT:    [[TMP36:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[CONV65:%.*]] = fpext float [[TMP36]] to double
// CHECK15-NEXT:    [[ADD66:%.*]] = fadd double [[CONV65]], 1.000000e+00
// CHECK15-NEXT:    [[CONV67:%.*]] = fptrunc double [[ADD66]] to float
// CHECK15-NEXT:    store float [[CONV67]], float* [[ARRAYIDX]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[ARRAYIDX68:%.*]] = getelementptr inbounds float, float* [[VLA]], i32 3
// CHECK15-NEXT:    [[TMP37:%.*]] = load float, float* [[ARRAYIDX68]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[CONV69:%.*]] = fpext float [[TMP37]] to double
// CHECK15-NEXT:    [[ADD70:%.*]] = fadd double [[CONV69]], 1.000000e+00
// CHECK15-NEXT:    [[CONV71:%.*]] = fptrunc double [[ADD70]] to float
// CHECK15-NEXT:    store float [[CONV71]], float* [[ARRAYIDX68]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[ARRAYIDX72:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[C]], i32 0, i32 1
// CHECK15-NEXT:    [[ARRAYIDX73:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX72]], i32 0, i32 2
// CHECK15-NEXT:    [[TMP38:%.*]] = load double, double* [[ARRAYIDX73]], align 8, !llvm.access.group !17
// CHECK15-NEXT:    [[ADD74:%.*]] = fadd double [[TMP38]], 1.000000e+00
// CHECK15-NEXT:    store double [[ADD74]], double* [[ARRAYIDX73]], align 8, !llvm.access.group !17
// CHECK15-NEXT:    [[TMP39:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK15-NEXT:    [[ARRAYIDX75:%.*]] = getelementptr inbounds double, double* [[VLA1]], i32 [[TMP39]]
// CHECK15-NEXT:    [[ARRAYIDX76:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX75]], i32 3
// CHECK15-NEXT:    [[TMP40:%.*]] = load double, double* [[ARRAYIDX76]], align 8, !llvm.access.group !17
// CHECK15-NEXT:    [[ADD77:%.*]] = fadd double [[TMP40]], 1.000000e+00
// CHECK15-NEXT:    store double [[ADD77]], double* [[ARRAYIDX76]], align 8, !llvm.access.group !17
// CHECK15-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[D]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP41:%.*]] = load i64, i64* [[X]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[ADD78:%.*]] = add nsw i64 [[TMP41]], 1
// CHECK15-NEXT:    store i64 [[ADD78]], i64* [[X]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[D]], i32 0, i32 1
// CHECK15-NEXT:    [[TMP42:%.*]] = load i8, i8* [[Y]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[CONV79:%.*]] = sext i8 [[TMP42]] to i32
// CHECK15-NEXT:    [[ADD80:%.*]] = add nsw i32 [[CONV79]], 1
// CHECK15-NEXT:    [[CONV81:%.*]] = trunc i32 [[ADD80]] to i8
// CHECK15-NEXT:    store i8 [[CONV81]], i8* [[Y]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE82:%.*]]
// CHECK15:       omp.body.continue82:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC83:%.*]]
// CHECK15:       omp.inner.for.inc83:
// CHECK15-NEXT:    [[TMP43:%.*]] = load i32, i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    [[ADD84:%.*]] = add nsw i32 [[TMP43]], 1
// CHECK15-NEXT:    store i32 [[ADD84]], i32* [[DOTOMP_IV57]], align 4, !llvm.access.group !17
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND59]], !llvm.loop [[LOOP18:![0-9]+]]
// CHECK15:       omp.inner.for.end85:
// CHECK15-NEXT:    store i32 10, i32* [[I58]], align 4
// CHECK15-NEXT:    [[TMP44:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    [[TMP45:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK15-NEXT:    call void @llvm.stackrestore(i8* [[TMP45]])
// CHECK15-NEXT:    ret i32 [[TMP44]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z3bari
// CHECK15-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[S:%.*]] = alloca [[STRUCT_S1:%.*]], align 4
// CHECK15-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z3fooi(i32 noundef [[TMP0]])
// CHECK15-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[CALL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[A]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[CALL1:%.*]] = call noundef i32 @_ZN2S12r1Ei(%struct.S1* noundef nonnull align 4 dereferenceable(8) [[S]], i32 noundef [[TMP2]])
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP3]], [[CALL1]]
// CHECK15-NEXT:    store i32 [[ADD2]], i32* [[A]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[CALL3:%.*]] = call noundef i32 @_ZL7fstatici(i32 noundef [[TMP4]])
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP5]], [[CALL3]]
// CHECK15-NEXT:    store i32 [[ADD4]], i32* [[A]], align 4
// CHECK15-NEXT:    [[TMP6:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[CALL5:%.*]] = call noundef i32 @_Z9ftemplateIiET_i(i32 noundef [[TMP6]])
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP7]], [[CALL5]]
// CHECK15-NEXT:    store i32 [[ADD6]], i32* [[A]], align 4
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN2S12r1Ei
// CHECK15-SAME: (%struct.S1* noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]], i32 noundef [[N:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK15-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[B:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK15-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], 1
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[B]], align 4
// CHECK15-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK15-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 4
// CHECK15-NEXT:    [[TMP3:%.*]] = mul nuw i32 2, [[TMP1]]
// CHECK15-NEXT:    [[VLA:%.*]] = alloca i16, i32 [[TMP3]], align 2
// CHECK15-NEXT:    store i32 [[TMP1]], i32* [[__VLA_EXPR0]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 60
// CHECK15-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[CMP]] to i8
// CHECK15-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[TMP6:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK15-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK15-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK15:       omp_if.then:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK15-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK15-NEXT:    [[ADD3:%.*]] = add nsw i32 0, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD3]], i32* [[I]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[TMP10:%.*]] = load i32, i32* [[B]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP10]] to double
// CHECK15-NEXT:    [[ADD4:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK15-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK15-NEXT:    store double [[ADD4]], double* [[A]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP11:%.*]] = load double, double* [[A5]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[INC:%.*]] = fadd double [[TMP11]], 1.000000e+00
// CHECK15-NEXT:    store double [[INC]], double* [[A5]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[CONV6:%.*]] = fptosi double [[INC]] to i16
// CHECK15-NEXT:    [[TMP12:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP12]]
// CHECK15-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK15-NEXT:    store i16 [[CONV6]], i16* [[ARRAYIDX7]], align 2, !llvm.access.group !20
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK15-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP21:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK15:       omp_if.else:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND9:%.*]]
// CHECK15:       omp.inner.for.cond9:
// CHECK15-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK15-NEXT:    br i1 [[CMP10]], label [[OMP_INNER_FOR_BODY11:%.*]], label [[OMP_INNER_FOR_END25:%.*]]
// CHECK15:       omp.inner.for.body11:
// CHECK15-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[MUL12:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK15-NEXT:    [[ADD13:%.*]] = add nsw i32 0, [[MUL12]]
// CHECK15-NEXT:    store i32 [[ADD13]], i32* [[I]], align 4
// CHECK15-NEXT:    [[TMP17:%.*]] = load i32, i32* [[B]], align 4
// CHECK15-NEXT:    [[CONV14:%.*]] = sitofp i32 [[TMP17]] to double
// CHECK15-NEXT:    [[ADD15:%.*]] = fadd double [[CONV14]], 1.500000e+00
// CHECK15-NEXT:    [[A16:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK15-NEXT:    store double [[ADD15]], double* [[A16]], align 4
// CHECK15-NEXT:    [[A17:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[THIS1]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP18:%.*]] = load double, double* [[A17]], align 4
// CHECK15-NEXT:    [[INC18:%.*]] = fadd double [[TMP18]], 1.000000e+00
// CHECK15-NEXT:    store double [[INC18]], double* [[A17]], align 4
// CHECK15-NEXT:    [[CONV19:%.*]] = fptosi double [[INC18]] to i16
// CHECK15-NEXT:    [[TMP19:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK15-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP19]]
// CHECK15-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX20]], i32 1
// CHECK15-NEXT:    store i16 [[CONV19]], i16* [[ARRAYIDX21]], align 2
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE22:%.*]]
// CHECK15:       omp.body.continue22:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC23:%.*]]
// CHECK15:       omp.inner.for.inc23:
// CHECK15-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK15-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND9]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK15:       omp.inner.for.end25:
// CHECK15-NEXT:    br label [[OMP_IF_END]]
// CHECK15:       omp_if.end:
// CHECK15-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK15-NEXT:    [[TMP21:%.*]] = mul nsw i32 1, [[TMP1]]
// CHECK15-NEXT:    [[ARRAYIDX26:%.*]] = getelementptr inbounds i16, i16* [[VLA]], i32 [[TMP21]]
// CHECK15-NEXT:    [[ARRAYIDX27:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX26]], i32 1
// CHECK15-NEXT:    [[TMP22:%.*]] = load i16, i16* [[ARRAYIDX27]], align 2
// CHECK15-NEXT:    [[CONV28:%.*]] = sext i16 [[TMP22]] to i32
// CHECK15-NEXT:    [[TMP23:%.*]] = load i32, i32* [[B]], align 4
// CHECK15-NEXT:    [[ADD29:%.*]] = add nsw i32 [[CONV28]], [[TMP23]]
// CHECK15-NEXT:    [[TMP24:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK15-NEXT:    call void @llvm.stackrestore(i8* [[TMP24]])
// CHECK15-NEXT:    ret i32 [[ADD29]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZL7fstatici
// CHECK15-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK15-NEXT:    [[AAA:%.*]] = alloca i8, align 1
// CHECK15-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK15-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK15-NEXT:    store i8 0, i8* [[AAA]], align 1
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[SUB:%.*]] = sub i32 [[TMP2]], [[TMP3]]
// CHECK15-NEXT:    [[SUB3:%.*]] = sub i32 [[SUB]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add i32 [[SUB3]], 1
// CHECK15-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK15-NEXT:    [[SUB4:%.*]] = sub i32 [[DIV]], 1
// CHECK15-NEXT:    store i32 [[SUB4]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK15-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK15-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK15:       simd.if.then:
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[ADD6:%.*]] = add i32 [[TMP10]], 1
// CHECK15-NEXT:    [[CMP7:%.*]] = icmp ult i32 [[TMP9]], [[ADD6]]
// CHECK15-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[MUL:%.*]] = mul i32 [[TMP12]], 1
// CHECK15-NEXT:    [[ADD8:%.*]] = add i32 [[TMP11]], [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD8]], i32* [[I5]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[TMP13:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK15-NEXT:    store i32 [[ADD9]], i32* [[A]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[TMP14:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !25
// CHECK15-NEXT:    [[CONV:%.*]] = sext i16 [[TMP14]] to i32
// CHECK15-NEXT:    [[ADD10:%.*]] = add nsw i32 [[CONV]], 1
// CHECK15-NEXT:    [[CONV11:%.*]] = trunc i32 [[ADD10]] to i16
// CHECK15-NEXT:    store i16 [[CONV11]], i16* [[AA]], align 2, !llvm.access.group !25
// CHECK15-NEXT:    [[TMP15:%.*]] = load i8, i8* [[AAA]], align 1, !llvm.access.group !25
// CHECK15-NEXT:    [[CONV12:%.*]] = sext i8 [[TMP15]] to i32
// CHECK15-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK15-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i8
// CHECK15-NEXT:    store i8 [[CONV14]], i8* [[AAA]], align 1, !llvm.access.group !25
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[B]], i32 0, i32 2
// CHECK15-NEXT:    [[TMP16:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK15-NEXT:    store i32 [[ADD15]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    [[ADD16:%.*]] = add i32 [[TMP17]], 1
// CHECK15-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP26:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[SUB17:%.*]] = sub i32 [[TMP19]], [[TMP20]]
// CHECK15-NEXT:    [[SUB18:%.*]] = sub i32 [[SUB17]], 1
// CHECK15-NEXT:    [[ADD19:%.*]] = add i32 [[SUB18]], 1
// CHECK15-NEXT:    [[DIV20:%.*]] = udiv i32 [[ADD19]], 1
// CHECK15-NEXT:    [[MUL21:%.*]] = mul i32 [[DIV20]], 1
// CHECK15-NEXT:    [[ADD22:%.*]] = add i32 [[TMP18]], [[MUL21]]
// CHECK15-NEXT:    store i32 [[ADD22]], i32* [[I5]], align 4
// CHECK15-NEXT:    br label [[SIMD_IF_END]]
// CHECK15:       simd.if.end:
// CHECK15-NEXT:    [[TMP21:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    ret i32 [[TMP21]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z9ftemplateIiET_i
// CHECK15-SAME: (i32 noundef [[N:%.*]]) #[[ATTR0]] comdat {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[AA:%.*]] = alloca i16, align 2
// CHECK15-NEXT:    [[B:%.*]] = alloca [10 x i32], align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[A]], align 4
// CHECK15-NEXT:    store i16 0, i16* [[AA]], align 2
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[A]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK15-NEXT:    store i32 [[ADD1]], i32* [[A]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    [[TMP5:%.*]] = load i16, i16* [[AA]], align 2, !llvm.access.group !28
// CHECK15-NEXT:    [[CONV:%.*]] = sext i16 [[TMP5]] to i32
// CHECK15-NEXT:    [[ADD2:%.*]] = add nsw i32 [[CONV]], 1
// CHECK15-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD2]] to i16
// CHECK15-NEXT:    store i16 [[CONV3]], i16* [[AA]], align 2, !llvm.access.group !28
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[B]], i32 0, i32 2
// CHECK15-NEXT:    [[TMP6:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK15-NEXT:    store i32 [[ADD4]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK15-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP29:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A]], align 4
// CHECK15-NEXT:    ret i32 [[TMP8]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97
// CHECK17-SAME: (i64 noundef [[AA:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[DOTCAPTURE_EXPR_1]], i64* [[DOTCAPTURE_EXPR__ADDR2]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK17-NEXT:    [[CONV4:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR2]] to i32*
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV3]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV4]], align 4
// CHECK17-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK17-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK17-NEXT:    [[CONV5:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP3]], i16* [[CONV5]], align 2
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), i64 [[TMP4]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !11
// CHECK17-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK17-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !11
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK17-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK17-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK17-NEXT:    br i1 [[TMP10]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111
// CHECK17-SAME: (i64 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP1]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK17-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[TMP8:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !18
// CHECK17-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP8]] to i32
// CHECK17-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV2]], 1
// CHECK17-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD3]] to i16
// CHECK17-NEXT:    store i16 [[CONV4]], i16* [[CONV]], align 2, !llvm.access.group !18
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK17-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK17-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118
// CHECK17-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP0]], i32* [[CONV2]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP2]], i16* [[CONV3]], align 2
// CHECK17-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK17-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK17-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV1]], align 2, !llvm.access.group !21
// CHECK17-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP9]] to i32
// CHECK17-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK17-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK17-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2, !llvm.access.group !21
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK17-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK17-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142
// CHECK17-SAME: (i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK17-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK17-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK17-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK17-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK17-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP8]], i32* [[CONV5]], align 4
// CHECK17-NEXT:    [[TMP9:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 9, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, [10 x float]*, i64, float*, [5 x [10 x double]]*, i64, i64, double*, %struct.TT*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP9]], [10 x float]* [[TMP0]], i64 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i64 [[TMP4]], i64 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK17-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK17-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK17-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK17-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK17-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK17-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK17-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 0
// CHECK17-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i64 16) ]
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 9
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK17-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[TMP16:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK17-NEXT:    store i32 [[ADD6]], i32* [[CONV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 2
// CHECK17-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[CONV7:%.*]] = fpext float [[TMP17]] to double
// CHECK17-NEXT:    [[ADD8:%.*]] = fadd double [[CONV7]], 1.000000e+00
// CHECK17-NEXT:    [[CONV9:%.*]] = fptrunc double [[ADD8]] to float
// CHECK17-NEXT:    store float [[CONV9]], float* [[ARRAYIDX]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP2]], i64 3
// CHECK17-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX10]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[CONV11:%.*]] = fpext float [[TMP18]] to double
// CHECK17-NEXT:    [[ADD12:%.*]] = fadd double [[CONV11]], 1.000000e+00
// CHECK17-NEXT:    [[CONV13:%.*]] = fptrunc double [[ADD12]] to float
// CHECK17-NEXT:    store float [[CONV13]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i64 0, i64 1
// CHECK17-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX14]], i64 0, i64 2
// CHECK17-NEXT:    [[TMP19:%.*]] = load double, double* [[ARRAYIDX15]], align 8, !llvm.access.group !24
// CHECK17-NEXT:    [[ADD16:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK17-NEXT:    store double [[ADD16]], double* [[ARRAYIDX15]], align 8, !llvm.access.group !24
// CHECK17-NEXT:    [[TMP20:%.*]] = mul nsw i64 1, [[TMP5]]
// CHECK17-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[TMP6]], i64 [[TMP20]]
// CHECK17-NEXT:    [[ARRAYIDX18:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX17]], i64 3
// CHECK17-NEXT:    [[TMP21:%.*]] = load double, double* [[ARRAYIDX18]], align 8, !llvm.access.group !24
// CHECK17-NEXT:    [[ADD19:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK17-NEXT:    store double [[ADD19]], double* [[ARRAYIDX18]], align 8, !llvm.access.group !24
// CHECK17-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP22:%.*]] = load i64, i64* [[X]], align 8, !llvm.access.group !24
// CHECK17-NEXT:    [[ADD20:%.*]] = add nsw i64 [[TMP22]], 1
// CHECK17-NEXT:    store i64 [[ADD20]], i64* [[X]], align 8, !llvm.access.group !24
// CHECK17-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP23:%.*]] = load i8, i8* [[Y]], align 8, !llvm.access.group !24
// CHECK17-NEXT:    [[CONV21:%.*]] = sext i8 [[TMP23]] to i32
// CHECK17-NEXT:    [[ADD22:%.*]] = add nsw i32 [[CONV21]], 1
// CHECK17-NEXT:    [[CONV23:%.*]] = trunc i32 [[ADD22]] to i8
// CHECK17-NEXT:    store i8 [[CONV23]], i8* [[Y]], align 8, !llvm.access.group !24
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK17-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]])
// CHECK17-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK17-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197
// CHECK17-SAME: (i64 noundef [[A:%.*]], i64 noundef [[N:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV4:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP1]], i32* [[CONV4]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK17-NEXT:    [[CONV5:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP3]], i32* [[CONV5]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i16, i16* [[CONV2]], align 2
// CHECK17-NEXT:    [[CONV6:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP5]], i16* [[CONV6]], align 2
// CHECK17-NEXT:    [[TMP6:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = load i8, i8* [[CONV3]], align 1
// CHECK17-NEXT:    [[CONV7:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK17-NEXT:    store i8 [[TMP7]], i8* [[CONV7]], align 1
// CHECK17-NEXT:    [[TMP8:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, i64, [10 x i32]*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP8]], [10 x i32]* [[TMP0]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[N:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I8:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK17-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK17-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK17-NEXT:    [[SUB6:%.*]] = sub i32 [[SUB]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add i32 [[SUB6]], 1
// CHECK17-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK17-NEXT:    [[SUB7:%.*]] = sub i32 [[DIV]], 1
// CHECK17-NEXT:    store i32 [[SUB7]], i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK17-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK17-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK17:       omp.precond.then:
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK17-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK17-NEXT:    [[CMP9:%.*]] = icmp ugt i32 [[TMP11]], [[TMP12]]
// CHECK17-NEXT:    br i1 [[CMP9]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[ADD10:%.*]] = add i32 [[TMP17]], 1
// CHECK17-NEXT:    [[CMP11:%.*]] = icmp ult i32 [[TMP16]], [[ADD10]]
// CHECK17-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[MUL:%.*]] = mul i32 [[TMP19]], 1
// CHECK17-NEXT:    [[ADD12:%.*]] = add i32 [[TMP18]], [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD12]], i32* [[I8]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[TMP20:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK17-NEXT:    store i32 [[ADD13]], i32* [[CONV]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[TMP21:%.*]] = load i16, i16* [[CONV2]], align 2, !llvm.access.group !27
// CHECK17-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP21]] to i32
// CHECK17-NEXT:    [[ADD15:%.*]] = add nsw i32 [[CONV14]], 1
// CHECK17-NEXT:    [[CONV16:%.*]] = trunc i32 [[ADD15]] to i16
// CHECK17-NEXT:    store i16 [[CONV16]], i16* [[CONV2]], align 2, !llvm.access.group !27
// CHECK17-NEXT:    [[TMP22:%.*]] = load i8, i8* [[CONV3]], align 1, !llvm.access.group !27
// CHECK17-NEXT:    [[CONV17:%.*]] = sext i8 [[TMP22]] to i32
// CHECK17-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV17]], 1
// CHECK17-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK17-NEXT:    store i8 [[CONV19]], i8* [[CONV3]], align 1, !llvm.access.group !27
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK17-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[ADD20:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK17-NEXT:    store i32 [[ADD20]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    [[ADD21:%.*]] = add i32 [[TMP24]], 1
// CHECK17-NEXT:    store i32 [[ADD21]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK17-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK17-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK17-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK17-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK17-NEXT:    [[SUB22:%.*]] = sub i32 [[TMP30]], [[TMP31]]
// CHECK17-NEXT:    [[SUB23:%.*]] = sub i32 [[SUB22]], 1
// CHECK17-NEXT:    [[ADD24:%.*]] = add i32 [[SUB23]], 1
// CHECK17-NEXT:    [[DIV25:%.*]] = udiv i32 [[ADD24]], 1
// CHECK17-NEXT:    [[MUL26:%.*]] = mul i32 [[DIV25]], 1
// CHECK17-NEXT:    [[ADD27:%.*]] = add i32 [[TMP29]], [[MUL26]]
// CHECK17-NEXT:    store i32 [[ADD27]], i32* [[I8]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK17:       omp.precond.end:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215
// CHECK17-SAME: (%struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK17-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP4]], i32* [[CONV3]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i64, i64, i64, i16*)* @.omp_outlined..5 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i64 [[TMP5]], i64 [[TMP1]], i64 [[TMP2]], i16* [[TMP3]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..5
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 9
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !30
// CHECK17-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK17-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !30
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !30
// CHECK17-NEXT:    [[CONV4:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK17-NEXT:    [[ADD5:%.*]] = fadd double [[CONV4]], 1.500000e+00
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK17-NEXT:    store double [[ADD5]], double* [[A]], align 8, !llvm.access.group !30
// CHECK17-NEXT:    [[A6:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP13:%.*]] = load double, double* [[A6]], align 8, !llvm.access.group !30
// CHECK17-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK17-NEXT:    store double [[INC]], double* [[A6]], align 8, !llvm.access.group !30
// CHECK17-NEXT:    [[CONV7:%.*]] = fptosi double [[INC]] to i16
// CHECK17-NEXT:    [[TMP14:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP14]]
// CHECK17-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK17-NEXT:    store i16 [[CONV7]], i16* [[ARRAYIDX8]], align 2, !llvm.access.group !30
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK17-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK17-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP31:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK17-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP17:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK17-NEXT:    br i1 [[TMP17]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180
// CHECK17-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK17-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK17-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK17-NEXT:    store i32 [[TMP1]], i32* [[CONV2]], align 4
// CHECK17-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK17-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK17-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK17-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK17-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK17-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK17-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK17-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK17-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    [[TMP9:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK17-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV1]], align 2, !llvm.access.group !33
// CHECK17-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP10]] to i32
// CHECK17-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK17-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK17-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2, !llvm.access.group !33
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK17-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK17-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !33
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP34:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK17-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK17-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97
// CHECK19-SAME: (i32 noundef [[AA:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]], i32 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[DOTCAPTURE_EXPR_1]], i32* [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK19-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK19-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), i32 [[TMP4]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !12
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK19-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK19-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK19-NEXT:    br i1 [[TMP10]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111
// CHECK19-SAME: (i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP1]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[TMP8:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !19
// CHECK19-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP8]] to i32
// CHECK19-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV2]], 1
// CHECK19-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD3]] to i16
// CHECK19-NEXT:    store i16 [[CONV4]], i16* [[CONV]], align 2, !llvm.access.group !19
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK19-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK19-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118
// CHECK19-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK19-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !22
// CHECK19-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP9]] to i32
// CHECK19-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK19-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK19-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2, !llvm.access.group !22
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK19-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK19-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142
// CHECK19-SAME: (i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK19-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK19-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK19-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK19-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK19-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP8]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 9, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, [10 x float]*, i32, float*, [5 x [10 x double]]*, i32, i32, double*, %struct.TT*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP9]], [10 x float]* [[TMP0]], i32 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i32 [[TMP4]], i32 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK19-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK19-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK19-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK19-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK19-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK19-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK19-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 0
// CHECK19-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i32 16) ]
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 9
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK19-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[TMP16:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK19-NEXT:    store i32 [[ADD6]], i32* [[A_ADDR]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[CONV:%.*]] = fpext float [[TMP17]] to double
// CHECK19-NEXT:    [[ADD7:%.*]] = fadd double [[CONV]], 1.000000e+00
// CHECK19-NEXT:    [[CONV8:%.*]] = fptrunc double [[ADD7]] to float
// CHECK19-NEXT:    store float [[CONV8]], float* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP2]], i32 3
// CHECK19-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX9]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[CONV10:%.*]] = fpext float [[TMP18]] to double
// CHECK19-NEXT:    [[ADD11:%.*]] = fadd double [[CONV10]], 1.000000e+00
// CHECK19-NEXT:    [[CONV12:%.*]] = fptrunc double [[ADD11]] to float
// CHECK19-NEXT:    store float [[CONV12]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i32 0, i32 1
// CHECK19-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX13]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP19:%.*]] = load double, double* [[ARRAYIDX14]], align 8, !llvm.access.group !25
// CHECK19-NEXT:    [[ADD15:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK19-NEXT:    store double [[ADD15]], double* [[ARRAYIDX14]], align 8, !llvm.access.group !25
// CHECK19-NEXT:    [[TMP20:%.*]] = mul nsw i32 1, [[TMP5]]
// CHECK19-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds double, double* [[TMP6]], i32 [[TMP20]]
// CHECK19-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX16]], i32 3
// CHECK19-NEXT:    [[TMP21:%.*]] = load double, double* [[ARRAYIDX17]], align 8, !llvm.access.group !25
// CHECK19-NEXT:    [[ADD18:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK19-NEXT:    store double [[ADD18]], double* [[ARRAYIDX17]], align 8, !llvm.access.group !25
// CHECK19-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP22:%.*]] = load i64, i64* [[X]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[ADD19:%.*]] = add nsw i64 [[TMP22]], 1
// CHECK19-NEXT:    store i64 [[ADD19]], i64* [[X]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP23:%.*]] = load i8, i8* [[Y]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[CONV20:%.*]] = sext i8 [[TMP23]] to i32
// CHECK19-NEXT:    [[ADD21:%.*]] = add nsw i32 [[CONV20]], 1
// CHECK19-NEXT:    [[CONV22:%.*]] = trunc i32 [[ADD21]] to i8
// CHECK19-NEXT:    store i8 [[CONV22]], i8* [[Y]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    [[ADD23:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK19-NEXT:    store i32 [[ADD23]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP26:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]])
// CHECK19-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK19-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197
// CHECK19-SAME: (i32 noundef [[A:%.*]], i32 noundef [[N:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP3]], i32* [[N_CASTED]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV2:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP5]], i16* [[CONV2]], align 2
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = load i8, i8* [[CONV1]], align 1
// CHECK19-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK19-NEXT:    store i8 [[TMP7]], i8* [[CONV3]], align 1
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32, i32, [10 x i32]*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], i32 [[TMP8]], [10 x i32]* [[TMP0]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[N:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK19-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK19-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK19-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK19-NEXT:    [[SUB5:%.*]] = sub i32 [[DIV]], 1
// CHECK19-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK19-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK19-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK19:       omp.precond.then:
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK19-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK19-NEXT:    [[CMP7:%.*]] = icmp ugt i32 [[TMP11]], [[TMP12]]
// CHECK19-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[ADD8:%.*]] = add i32 [[TMP17]], 1
// CHECK19-NEXT:    [[CMP9:%.*]] = icmp ult i32 [[TMP16]], [[ADD8]]
// CHECK19-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[MUL:%.*]] = mul i32 [[TMP19]], 1
// CHECK19-NEXT:    [[ADD10:%.*]] = add i32 [[TMP18]], [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD10]], i32* [[I6]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[TMP20:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK19-NEXT:    store i32 [[ADD11]], i32* [[A_ADDR]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[TMP21:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !28
// CHECK19-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP21]] to i32
// CHECK19-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK19-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i16
// CHECK19-NEXT:    store i16 [[CONV14]], i16* [[CONV]], align 2, !llvm.access.group !28
// CHECK19-NEXT:    [[TMP22:%.*]] = load i8, i8* [[CONV1]], align 1, !llvm.access.group !28
// CHECK19-NEXT:    [[CONV15:%.*]] = sext i8 [[TMP22]] to i32
// CHECK19-NEXT:    [[ADD16:%.*]] = add nsw i32 [[CONV15]], 1
// CHECK19-NEXT:    [[CONV17:%.*]] = trunc i32 [[ADD16]] to i8
// CHECK19-NEXT:    store i8 [[CONV17]], i8* [[CONV1]], align 1, !llvm.access.group !28
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK19-NEXT:    store i32 [[ADD18]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    [[ADD19:%.*]] = add i32 [[TMP24]], 1
// CHECK19-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP29:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK19-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK19-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK19-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK19-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK19-NEXT:    [[SUB20:%.*]] = sub i32 [[TMP30]], [[TMP31]]
// CHECK19-NEXT:    [[SUB21:%.*]] = sub i32 [[SUB20]], 1
// CHECK19-NEXT:    [[ADD22:%.*]] = add i32 [[SUB21]], 1
// CHECK19-NEXT:    [[DIV23:%.*]] = udiv i32 [[ADD22]], 1
// CHECK19-NEXT:    [[MUL24:%.*]] = mul i32 [[DIV23]], 1
// CHECK19-NEXT:    [[ADD25:%.*]] = add i32 [[TMP29]], [[MUL24]]
// CHECK19-NEXT:    store i32 [[ADD25]], i32* [[I6]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK19:       omp.precond.end:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215
// CHECK19-SAME: (%struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK19-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i32, i32, i32, i16*)* @.omp_outlined..5 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i32 [[TMP5]], i32 [[TMP1]], i32 [[TMP2]], i16* [[TMP3]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..5
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 9
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK19-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[B_ADDR]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP12]] to double
// CHECK19-NEXT:    [[ADD4:%.*]] = fadd double [[CONV]], 1.500000e+00
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK19-NEXT:    store double [[ADD4]], double* [[A]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[A5:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP13:%.*]] = load double, double* [[A5]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[INC:%.*]] = fadd double [[TMP13]], 1.000000e+00
// CHECK19-NEXT:    store double [[INC]], double* [[A5]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[CONV6:%.*]] = fptosi double [[INC]] to i16
// CHECK19-NEXT:    [[TMP14:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP14]]
// CHECK19-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK19-NEXT:    store i16 [[CONV6]], i16* [[ARRAYIDX7]], align 2, !llvm.access.group !31
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP15]], 1
// CHECK19-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP32:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK19-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP17:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK19-NEXT:    br i1 [[TMP17]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180
// CHECK19-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK19-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK19-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK19-NEXT:    store i16 [[TMP3]], i16* [[CONV1]], align 2
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK19-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK19-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK19-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK19-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !34
// CHECK19-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP10]] to i32
// CHECK19-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK19-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK19-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2, !llvm.access.group !34
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK19-NEXT:    store i32 [[ADD6]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK19-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !34
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP35:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK19-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK19-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97
// CHECK21-SAME: (i64 noundef [[AA:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK21-NEXT:    store i64 [[DOTCAPTURE_EXPR_1]], i64* [[DOTCAPTURE_EXPR__ADDR2]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK21-NEXT:    [[CONV4:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR2]] to i32*
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV3]], align 4
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV4]], align 4
// CHECK21-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK21-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK21-NEXT:    [[CONV5:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK21-NEXT:    store i16 [[TMP3]], i16* [[CONV5]], align 2
// CHECK21-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), i64 [[TMP4]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK21-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !11
// CHECK21-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK21-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !11
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK21-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK21-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK21-NEXT:    br i1 [[TMP10]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111
// CHECK21-SAME: (i64 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK21-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK21-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK21-NEXT:    [[TMP1:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP1]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK21-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK21-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK21-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK21-NEXT:    [[TMP8:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !18
// CHECK21-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP8]] to i32
// CHECK21-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV2]], 1
// CHECK21-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD3]] to i16
// CHECK21-NEXT:    store i16 [[CONV4]], i16* [[CONV]], align 2, !llvm.access.group !18
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK21-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK21-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK21-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118
// CHECK21-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK21-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    [[TMP0:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK21-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK21-NEXT:    store i32 [[TMP0]], i32* [[CONV2]], align 4
// CHECK21-NEXT:    [[TMP1:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK21-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK21-NEXT:    store i16 [[TMP2]], i16* [[CONV3]], align 2
// CHECK21-NEXT:    [[TMP3:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i64 [[TMP1]], i64 [[TMP3]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK21-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK21-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !21
// CHECK21-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK21-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !21
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !21
// CHECK21-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK21-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4, !llvm.access.group !21
// CHECK21-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV1]], align 2, !llvm.access.group !21
// CHECK21-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP9]] to i32
// CHECK21-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK21-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK21-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2, !llvm.access.group !21
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK21-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK21-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !21
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP22:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK21-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142
// CHECK21-SAME: (i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK21-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK21-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK21-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK21-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK21-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK21-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK21-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK21-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK21-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK21-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK21-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK21-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK21-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK21-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK21-NEXT:    [[CONV5:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK21-NEXT:    store i32 [[TMP8]], i32* [[CONV5]], align 4
// CHECK21-NEXT:    [[TMP9:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 9, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, [10 x float]*, i64, float*, [5 x [10 x double]]*, i64, i64, double*, %struct.TT*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP9]], [10 x float]* [[TMP0]], i64 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i64 [[TMP4]], i64 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK21-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i64 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 8 dereferenceable(400) [[C:%.*]], i64 noundef [[VLA1:%.*]], i64 noundef [[VLA3:%.*]], double* noundef nonnull align 8 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 8 dereferenceable(16) [[D:%.*]]) #[[ATTR1]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 8
// CHECK21-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 8
// CHECK21-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[VLA_ADDR4:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 8
// CHECK21-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK21-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 8
// CHECK21-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK21-NEXT:    store i64 [[VLA3]], i64* [[VLA_ADDR4]], align 8
// CHECK21-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 8
// CHECK21-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK21-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 8
// CHECK21-NEXT:    [[TMP4:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK21-NEXT:    [[TMP5:%.*]] = load i64, i64* [[VLA_ADDR4]], align 8
// CHECK21-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 8
// CHECK21-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 8
// CHECK21-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 0
// CHECK21-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i64 16) ]
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 9
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK21-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[TMP16:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK21-NEXT:    store i32 [[ADD6]], i32* [[CONV]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i64 0, i64 2
// CHECK21-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[CONV7:%.*]] = fpext float [[TMP17]] to double
// CHECK21-NEXT:    [[ADD8:%.*]] = fadd double [[CONV7]], 1.000000e+00
// CHECK21-NEXT:    [[CONV9:%.*]] = fptrunc double [[ADD8]] to float
// CHECK21-NEXT:    store float [[CONV9]], float* [[ARRAYIDX]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, float* [[TMP2]], i64 3
// CHECK21-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX10]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[CONV11:%.*]] = fpext float [[TMP18]] to double
// CHECK21-NEXT:    [[ADD12:%.*]] = fadd double [[CONV11]], 1.000000e+00
// CHECK21-NEXT:    [[CONV13:%.*]] = fptrunc double [[ADD12]] to float
// CHECK21-NEXT:    store float [[CONV13]], float* [[ARRAYIDX10]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i64 0, i64 1
// CHECK21-NEXT:    [[ARRAYIDX15:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX14]], i64 0, i64 2
// CHECK21-NEXT:    [[TMP19:%.*]] = load double, double* [[ARRAYIDX15]], align 8, !llvm.access.group !24
// CHECK21-NEXT:    [[ADD16:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK21-NEXT:    store double [[ADD16]], double* [[ARRAYIDX15]], align 8, !llvm.access.group !24
// CHECK21-NEXT:    [[TMP20:%.*]] = mul nsw i64 1, [[TMP5]]
// CHECK21-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[TMP6]], i64 [[TMP20]]
// CHECK21-NEXT:    [[ARRAYIDX18:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX17]], i64 3
// CHECK21-NEXT:    [[TMP21:%.*]] = load double, double* [[ARRAYIDX18]], align 8, !llvm.access.group !24
// CHECK21-NEXT:    [[ADD19:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK21-NEXT:    store double [[ADD19]], double* [[ARRAYIDX18]], align 8, !llvm.access.group !24
// CHECK21-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP22:%.*]] = load i64, i64* [[X]], align 8, !llvm.access.group !24
// CHECK21-NEXT:    [[ADD20:%.*]] = add nsw i64 [[TMP22]], 1
// CHECK21-NEXT:    store i64 [[ADD20]], i64* [[X]], align 8, !llvm.access.group !24
// CHECK21-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK21-NEXT:    [[TMP23:%.*]] = load i8, i8* [[Y]], align 8, !llvm.access.group !24
// CHECK21-NEXT:    [[CONV21:%.*]] = sext i8 [[TMP23]] to i32
// CHECK21-NEXT:    [[ADD22:%.*]] = add nsw i32 [[CONV21]], 1
// CHECK21-NEXT:    [[CONV23:%.*]] = trunc i32 [[ADD22]] to i8
// CHECK21-NEXT:    store i8 [[CONV23]], i8* [[Y]], align 8, !llvm.access.group !24
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    [[ADD24:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK21-NEXT:    store i32 [[ADD24]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !24
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]])
// CHECK21-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK21-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197
// CHECK21-SAME: (i64 noundef [[A:%.*]], i64 noundef [[N:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK21-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AAA_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK21-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK21-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK21-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK21-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK21-NEXT:    [[CONV4:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK21-NEXT:    store i32 [[TMP1]], i32* [[CONV4]], align 4
// CHECK21-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK21-NEXT:    [[CONV5:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK21-NEXT:    store i32 [[TMP3]], i32* [[CONV5]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK21-NEXT:    [[TMP5:%.*]] = load i16, i16* [[CONV2]], align 2
// CHECK21-NEXT:    [[CONV6:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK21-NEXT:    store i16 [[TMP5]], i16* [[CONV6]], align 2
// CHECK21-NEXT:    [[TMP6:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK21-NEXT:    [[TMP7:%.*]] = load i8, i8* [[CONV3]], align 1
// CHECK21-NEXT:    [[CONV7:%.*]] = bitcast i64* [[AAA_CASTED]] to i8*
// CHECK21-NEXT:    store i8 [[TMP7]], i8* [[CONV7]], align 1
// CHECK21-NEXT:    [[TMP8:%.*]] = load i64, i64* [[AAA_CASTED]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, i64, [10 x i32]*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP8]], [10 x i32]* [[TMP0]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK21-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[N:%.*]], i64 noundef [[AA:%.*]], i64 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AAA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I8:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AAA]], i64* [[AAA_ADDR]], align 8
// CHECK21-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK21-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK21-NEXT:    [[CONV2:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AAA_ADDR]] to i8*
// CHECK21-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK21-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK21-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK21-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK21-NEXT:    [[SUB6:%.*]] = sub i32 [[SUB]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add i32 [[SUB6]], 1
// CHECK21-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK21-NEXT:    [[SUB7:%.*]] = sub i32 [[DIV]], 1
// CHECK21-NEXT:    store i32 [[SUB7]], i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK21-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK21-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK21:       omp.precond.then:
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK21-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK21-NEXT:    [[CMP9:%.*]] = icmp ugt i32 [[TMP11]], [[TMP12]]
// CHECK21-NEXT:    br i1 [[CMP9]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_5]], align 4
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[ADD10:%.*]] = add i32 [[TMP17]], 1
// CHECK21-NEXT:    [[CMP11:%.*]] = icmp ult i32 [[TMP16]], [[ADD10]]
// CHECK21-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[MUL:%.*]] = mul i32 [[TMP19]], 1
// CHECK21-NEXT:    [[ADD12:%.*]] = add i32 [[TMP18]], [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD12]], i32* [[I8]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[TMP20:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK21-NEXT:    store i32 [[ADD13]], i32* [[CONV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[TMP21:%.*]] = load i16, i16* [[CONV2]], align 2, !llvm.access.group !27
// CHECK21-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP21]] to i32
// CHECK21-NEXT:    [[ADD15:%.*]] = add nsw i32 [[CONV14]], 1
// CHECK21-NEXT:    [[CONV16:%.*]] = trunc i32 [[ADD15]] to i16
// CHECK21-NEXT:    store i16 [[CONV16]], i16* [[CONV2]], align 2, !llvm.access.group !27
// CHECK21-NEXT:    [[TMP22:%.*]] = load i8, i8* [[CONV3]], align 1, !llvm.access.group !27
// CHECK21-NEXT:    [[CONV17:%.*]] = sext i8 [[TMP22]] to i32
// CHECK21-NEXT:    [[ADD18:%.*]] = add nsw i32 [[CONV17]], 1
// CHECK21-NEXT:    [[CONV19:%.*]] = trunc i32 [[ADD18]] to i8
// CHECK21-NEXT:    store i8 [[CONV19]], i8* [[CONV3]], align 1, !llvm.access.group !27
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK21-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[ADD20:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK21-NEXT:    store i32 [[ADD20]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    [[ADD21:%.*]] = add i32 [[TMP24]], 1
// CHECK21-NEXT:    store i32 [[ADD21]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !27
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK21-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK21-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK21-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK21-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK21-NEXT:    [[SUB22:%.*]] = sub i32 [[TMP30]], [[TMP31]]
// CHECK21-NEXT:    [[SUB23:%.*]] = sub i32 [[SUB22]], 1
// CHECK21-NEXT:    [[ADD24:%.*]] = add i32 [[SUB23]], 1
// CHECK21-NEXT:    [[DIV25:%.*]] = udiv i32 [[ADD24]], 1
// CHECK21-NEXT:    [[MUL26:%.*]] = mul i32 [[DIV25]], 1
// CHECK21-NEXT:    [[ADD27:%.*]] = add i32 [[TMP29]], [[MUL26]]
// CHECK21-NEXT:    store i32 [[ADD27]], i32* [[I8]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK21:       omp.precond.end:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215
// CHECK21-SAME: (%struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK21-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK21-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK21-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK21-NEXT:    [[CONV4:%.*]] = bitcast i64* [[B_CASTED]] to i32*
// CHECK21-NEXT:    store i32 [[TMP4]], i32* [[CONV4]], align 4
// CHECK21-NEXT:    [[TMP5:%.*]] = load i64, i64* [[B_CASTED]], align 8
// CHECK21-NEXT:    [[TMP6:%.*]] = load i8, i8* [[CONV3]], align 1
// CHECK21-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK21-NEXT:    [[CONV5:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK21-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK21-NEXT:    store i8 [[FROMBOOL]], i8* [[CONV5]], align 1
// CHECK21-NEXT:    [[TMP7:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i64, i64, i64, i16*, i64)* @.omp_outlined..5 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i64 [[TMP5]], i64 [[TMP1]], i64 [[TMP2]], i16* [[TMP3]], i64 [[TMP7]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..5
// CHECK21-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i64 noundef [[B:%.*]], i64 noundef [[VLA:%.*]], i64 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[VLA_ADDR2:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 8
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[B]], i64* [[B_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[VLA1]], i64* [[VLA_ADDR2]], align 8
// CHECK21-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[B_ADDR]] to i32*
// CHECK21-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load i64, i64* [[VLA_ADDR2]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 8
// CHECK21-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 9
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP9:%.*]] = load i8, i8* [[CONV3]], align 1
// CHECK21-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK21-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK21:       omp_if.then:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !30
// CHECK21-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK21-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !30
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !30
// CHECK21-NEXT:    [[CONV5:%.*]] = sitofp i32 [[TMP13]] to double
// CHECK21-NEXT:    [[ADD6:%.*]] = fadd double [[CONV5]], 1.500000e+00
// CHECK21-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK21-NEXT:    store double [[ADD6]], double* [[A]], align 8, !llvm.access.group !30
// CHECK21-NEXT:    [[A7:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP14:%.*]] = load double, double* [[A7]], align 8, !llvm.access.group !30
// CHECK21-NEXT:    [[INC:%.*]] = fadd double [[TMP14]], 1.000000e+00
// CHECK21-NEXT:    store double [[INC]], double* [[A7]], align 8, !llvm.access.group !30
// CHECK21-NEXT:    [[CONV8:%.*]] = fptosi double [[INC]] to i16
// CHECK21-NEXT:    [[TMP15:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP15]]
// CHECK21-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i64 1
// CHECK21-NEXT:    store i16 [[CONV8]], i16* [[ARRAYIDX9]], align 2, !llvm.access.group !30
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK21-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK21-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !30
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP31:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK21:       omp_if.else:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND11:%.*]]
// CHECK21:       omp.inner.for.cond11:
// CHECK21-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK21-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY13:%.*]], label [[OMP_INNER_FOR_END27:%.*]]
// CHECK21:       omp.inner.for.body13:
// CHECK21-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[MUL14:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK21-NEXT:    [[ADD15:%.*]] = add nsw i32 0, [[MUL14]]
// CHECK21-NEXT:    store i32 [[ADD15]], i32* [[I]], align 4
// CHECK21-NEXT:    [[TMP20:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK21-NEXT:    [[CONV16:%.*]] = sitofp i32 [[TMP20]] to double
// CHECK21-NEXT:    [[ADD17:%.*]] = fadd double [[CONV16]], 1.500000e+00
// CHECK21-NEXT:    [[A18:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK21-NEXT:    store double [[ADD17]], double* [[A18]], align 8
// CHECK21-NEXT:    [[A19:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP21:%.*]] = load double, double* [[A19]], align 8
// CHECK21-NEXT:    [[INC20:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK21-NEXT:    store double [[INC20]], double* [[A19]], align 8
// CHECK21-NEXT:    [[CONV21:%.*]] = fptosi double [[INC20]] to i16
// CHECK21-NEXT:    [[TMP22:%.*]] = mul nsw i64 1, [[TMP2]]
// CHECK21-NEXT:    [[ARRAYIDX22:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i64 [[TMP22]]
// CHECK21-NEXT:    [[ARRAYIDX23:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX22]], i64 1
// CHECK21-NEXT:    store i16 [[CONV21]], i16* [[ARRAYIDX23]], align 2
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE24:%.*]]
// CHECK21:       omp.body.continue24:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC25:%.*]]
// CHECK21:       omp.inner.for.inc25:
// CHECK21-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK21-NEXT:    store i32 [[ADD26]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND11]], !llvm.loop [[LOOP33:![0-9]+]]
// CHECK21:       omp.inner.for.end27:
// CHECK21-NEXT:    br label [[OMP_IF_END]]
// CHECK21:       omp_if.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK21-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK21-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180
// CHECK21-SAME: (i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK21-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK21-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK21-NEXT:    [[CONV2:%.*]] = bitcast i64* [[A_CASTED]] to i32*
// CHECK21-NEXT:    store i32 [[TMP1]], i32* [[CONV2]], align 4
// CHECK21-NEXT:    [[TMP2:%.*]] = load i64, i64* [[A_CASTED]], align 8
// CHECK21-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV1]], align 2
// CHECK21-NEXT:    [[CONV3:%.*]] = bitcast i64* [[AA_CASTED]] to i16*
// CHECK21-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK21-NEXT:    [[TMP4:%.*]] = load i64, i64* [[AA_CASTED]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [10 x i32]*)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK21-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[A:%.*]], i64 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[AA_ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store i64 [[A]], i64* [[A_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[AA]], i64* [[AA_ADDR]], align 8
// CHECK21-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[A_ADDR]] to i32*
// CHECK21-NEXT:    [[CONV1:%.*]] = bitcast i64* [[AA_ADDR]] to i16*
// CHECK21-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 8
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    [[CMP2:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK21-NEXT:    br i1 [[CMP2]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[CONV]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK21-NEXT:    store i32 [[ADD3]], i32* [[CONV]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV1]], align 2, !llvm.access.group !35
// CHECK21-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP10]] to i32
// CHECK21-NEXT:    [[ADD5:%.*]] = add nsw i32 [[CONV4]], 1
// CHECK21-NEXT:    [[CONV6:%.*]] = trunc i32 [[ADD5]] to i16
// CHECK21-NEXT:    store i16 [[CONV6]], i16* [[CONV1]], align 2, !llvm.access.group !35
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 2
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK21-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK21-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !35
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP36:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK21-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l97
// CHECK23-SAME: (i32 noundef [[AA:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]], i32 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2:[0-9]+]])
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK23-NEXT:    store i32 [[DOTCAPTURE_EXPR_1]], i32* [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK23-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK23-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK23-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK23-NEXT:    store i16 [[TMP3]], i16* [[CONV3]], align 2
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), i32 [[TMP4]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK23-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !12
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK23-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK23-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP10:%.*]] = icmp ne i32 [[TMP9]], 0
// CHECK23-NEXT:    br i1 [[TMP10]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l111
// CHECK23-SAME: (i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    [[TMP0:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK23-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK23-NEXT:    store i16 [[TMP0]], i16* [[CONV1]], align 2
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP1]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK23-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !19
// CHECK23-NEXT:    [[TMP8:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !19
// CHECK23-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP8]] to i32
// CHECK23-NEXT:    [[ADD3:%.*]] = add nsw i32 [[CONV2]], 1
// CHECK23-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD3]] to i16
// CHECK23-NEXT:    store i16 [[CONV4]], i16* [[CONV]], align 2, !llvm.access.group !19
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK23-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK23-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP11:%.*]] = icmp ne i32 [[TMP10]], 0
// CHECK23-NEXT:    br i1 [[TMP11]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l118
// CHECK23-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[TMP0]], i32* [[A_CASTED]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK23-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK23-NEXT:    store i16 [[TMP2]], i16* [[CONV1]], align 2
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32 [[TMP1]], i32 [[TMP3]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK23-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]]) #[[ATTR1]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP2]], 9
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP3]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !22
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !22
// CHECK23-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK23-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4, !llvm.access.group !22
// CHECK23-NEXT:    [[TMP9:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !22
// CHECK23-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP9]] to i32
// CHECK23-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK23-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK23-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2, !llvm.access.group !22
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK23-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK23-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP1]])
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK23-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3fooi_l142
// CHECK23-SAME: (i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK23-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK23-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK23-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK23-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK23-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK23-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK23-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK23-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK23-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK23-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK23-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[TMP8]], i32* [[A_CASTED]], align 4
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 9, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, [10 x float]*, i32, float*, [5 x [10 x double]]*, i32, i32, double*, %struct.TT*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP9]], [10 x float]* [[TMP0]], i32 [[TMP1]], float* [[TMP2]], [5 x [10 x double]]* [[TMP3]], i32 [[TMP4]], i32 [[TMP5]], double* [[TMP6]], %struct.TT* [[TMP7]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK23-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], [10 x float]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]], i32 noundef [[VLA:%.*]], float* noundef nonnull align 4 dereferenceable(4) [[BN:%.*]], [5 x [10 x double]]* noundef nonnull align 4 dereferenceable(400) [[C:%.*]], i32 noundef [[VLA1:%.*]], i32 noundef [[VLA3:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[CN:%.*]], %struct.TT* noundef nonnull align 4 dereferenceable(12) [[D:%.*]]) #[[ATTR1]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca [10 x float]*, align 4
// CHECK23-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[BN_ADDR:%.*]] = alloca float*, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca [5 x [10 x double]]*, align 4
// CHECK23-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[VLA_ADDR4:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[CN_ADDR:%.*]] = alloca double*, align 4
// CHECK23-NEXT:    [[D_ADDR:%.*]] = alloca %struct.TT*, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store [10 x float]* [[B]], [10 x float]** [[B_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK23-NEXT:    store float* [[BN]], float** [[BN_ADDR]], align 4
// CHECK23-NEXT:    store [5 x [10 x double]]* [[C]], [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK23-NEXT:    store i32 [[VLA3]], i32* [[VLA_ADDR4]], align 4
// CHECK23-NEXT:    store double* [[CN]], double** [[CN_ADDR]], align 4
// CHECK23-NEXT:    store %struct.TT* [[D]], %struct.TT** [[D_ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load [10 x float]*, [10 x float]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load float*, float** [[BN_ADDR]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load [5 x [10 x double]]*, [5 x [10 x double]]** [[C_ADDR]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[VLA_ADDR4]], align 4
// CHECK23-NEXT:    [[TMP6:%.*]] = load double*, double** [[CN_ADDR]], align 4
// CHECK23-NEXT:    [[TMP7:%.*]] = load %struct.TT*, %struct.TT** [[D_ADDR]], align 4
// CHECK23-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 0
// CHECK23-NEXT:    call void @llvm.assume(i1 true) [ "align"(float* [[ARRAYDECAY]], i32 16) ]
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 9
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK23-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[TMP16:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK23-NEXT:    store i32 [[ADD6]], i32* [[A_ADDR]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x float], [10 x float]* [[TMP0]], i32 0, i32 2
// CHECK23-NEXT:    [[TMP17:%.*]] = load float, float* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[CONV:%.*]] = fpext float [[TMP17]] to double
// CHECK23-NEXT:    [[ADD7:%.*]] = fadd double [[CONV]], 1.000000e+00
// CHECK23-NEXT:    [[CONV8:%.*]] = fptrunc double [[ADD7]] to float
// CHECK23-NEXT:    store float [[CONV8]], float* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds float, float* [[TMP2]], i32 3
// CHECK23-NEXT:    [[TMP18:%.*]] = load float, float* [[ARRAYIDX9]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[CONV10:%.*]] = fpext float [[TMP18]] to double
// CHECK23-NEXT:    [[ADD11:%.*]] = fadd double [[CONV10]], 1.000000e+00
// CHECK23-NEXT:    [[CONV12:%.*]] = fptrunc double [[ADD11]] to float
// CHECK23-NEXT:    store float [[CONV12]], float* [[ARRAYIDX9]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [5 x [10 x double]], [5 x [10 x double]]* [[TMP3]], i32 0, i32 1
// CHECK23-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [10 x double], [10 x double]* [[ARRAYIDX13]], i32 0, i32 2
// CHECK23-NEXT:    [[TMP19:%.*]] = load double, double* [[ARRAYIDX14]], align 8, !llvm.access.group !25
// CHECK23-NEXT:    [[ADD15:%.*]] = fadd double [[TMP19]], 1.000000e+00
// CHECK23-NEXT:    store double [[ADD15]], double* [[ARRAYIDX14]], align 8, !llvm.access.group !25
// CHECK23-NEXT:    [[TMP20:%.*]] = mul nsw i32 1, [[TMP5]]
// CHECK23-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds double, double* [[TMP6]], i32 [[TMP20]]
// CHECK23-NEXT:    [[ARRAYIDX17:%.*]] = getelementptr inbounds double, double* [[ARRAYIDX16]], i32 3
// CHECK23-NEXT:    [[TMP21:%.*]] = load double, double* [[ARRAYIDX17]], align 8, !llvm.access.group !25
// CHECK23-NEXT:    [[ADD18:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK23-NEXT:    store double [[ADD18]], double* [[ARRAYIDX17]], align 8, !llvm.access.group !25
// CHECK23-NEXT:    [[X:%.*]] = getelementptr inbounds [[STRUCT_TT:%.*]], %struct.TT* [[TMP7]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP22:%.*]] = load i64, i64* [[X]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[ADD19:%.*]] = add nsw i64 [[TMP22]], 1
// CHECK23-NEXT:    store i64 [[ADD19]], i64* [[X]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[Y:%.*]] = getelementptr inbounds [[STRUCT_TT]], %struct.TT* [[TMP7]], i32 0, i32 1
// CHECK23-NEXT:    [[TMP23:%.*]] = load i8, i8* [[Y]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[CONV20:%.*]] = sext i8 [[TMP23]] to i32
// CHECK23-NEXT:    [[ADD21:%.*]] = add nsw i32 [[CONV20]], 1
// CHECK23-NEXT:    [[CONV22:%.*]] = trunc i32 [[ADD21]] to i8
// CHECK23-NEXT:    store i8 [[CONV22]], i8* [[Y]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    [[ADD23:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK23-NEXT:    store i32 [[ADD23]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP26:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]])
// CHECK23-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK23-NEXT:    br i1 [[TMP26]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZL7fstatici_l197
// CHECK23-SAME: (i32 noundef [[A:%.*]], i32 noundef [[N:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK23-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AAA_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK23-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK23-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[TMP3]], i32* [[N_CASTED]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK23-NEXT:    [[CONV2:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK23-NEXT:    store i16 [[TMP5]], i16* [[CONV2]], align 2
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK23-NEXT:    [[TMP7:%.*]] = load i8, i8* [[CONV1]], align 1
// CHECK23-NEXT:    [[CONV3:%.*]] = bitcast i32* [[AAA_CASTED]] to i8*
// CHECK23-NEXT:    store i8 [[TMP7]], i8* [[CONV3]], align 1
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[AAA_CASTED]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32, i32, [10 x i32]*)* @.omp_outlined..4 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], i32 [[TMP8]], [10 x i32]* [[TMP0]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK23-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[N:%.*]], i32 noundef [[AA:%.*]], i32 noundef [[AAA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AAA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AAA]], i32* [[AAA_ADDR]], align 4
// CHECK23-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AAA_ADDR]] to i8*
// CHECK23-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK23-NEXT:    [[SUB:%.*]] = sub i32 [[TMP3]], [[TMP4]]
// CHECK23-NEXT:    [[SUB4:%.*]] = sub i32 [[SUB]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add i32 [[SUB4]], 1
// CHECK23-NEXT:    [[DIV:%.*]] = udiv i32 [[ADD]], 1
// CHECK23-NEXT:    [[SUB5:%.*]] = sub i32 [[DIV]], 1
// CHECK23-NEXT:    store i32 [[SUB5]], i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK23-NEXT:    store i32 [[TMP5]], i32* [[I]], align 4
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP6]], [[TMP7]]
// CHECK23-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK23:       omp.precond.then:
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK23-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[TMP9]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4u(%struct.ident_t* @[[GLOB1]], i32 [[TMP10]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK23-NEXT:    [[CMP7:%.*]] = icmp ugt i32 [[TMP11]], [[TMP12]]
// CHECK23-NEXT:    br i1 [[CMP7]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_3]], align 4
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP13]], [[COND_TRUE]] ], [ [[TMP14]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[ADD8:%.*]] = add i32 [[TMP17]], 1
// CHECK23-NEXT:    [[CMP9:%.*]] = icmp ult i32 [[TMP16]], [[ADD8]]
// CHECK23-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[MUL:%.*]] = mul i32 [[TMP19]], 1
// CHECK23-NEXT:    [[ADD10:%.*]] = add i32 [[TMP18]], [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD10]], i32* [[I6]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[TMP20:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK23-NEXT:    store i32 [[ADD11]], i32* [[A_ADDR]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[TMP21:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !28
// CHECK23-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP21]] to i32
// CHECK23-NEXT:    [[ADD13:%.*]] = add nsw i32 [[CONV12]], 1
// CHECK23-NEXT:    [[CONV14:%.*]] = trunc i32 [[ADD13]] to i16
// CHECK23-NEXT:    store i16 [[CONV14]], i16* [[CONV]], align 2, !llvm.access.group !28
// CHECK23-NEXT:    [[TMP22:%.*]] = load i8, i8* [[CONV1]], align 1, !llvm.access.group !28
// CHECK23-NEXT:    [[CONV15:%.*]] = sext i8 [[TMP22]] to i32
// CHECK23-NEXT:    [[ADD16:%.*]] = add nsw i32 [[CONV15]], 1
// CHECK23-NEXT:    [[CONV17:%.*]] = trunc i32 [[ADD16]] to i8
// CHECK23-NEXT:    store i8 [[CONV17]], i8* [[CONV1]], align 1, !llvm.access.group !28
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK23-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK23-NEXT:    store i32 [[ADD18]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    [[ADD19:%.*]] = add i32 [[TMP24]], 1
// CHECK23-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP29:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK23-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK23-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK23-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK23-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK23-NEXT:    [[SUB20:%.*]] = sub i32 [[TMP30]], [[TMP31]]
// CHECK23-NEXT:    [[SUB21:%.*]] = sub i32 [[SUB20]], 1
// CHECK23-NEXT:    [[ADD22:%.*]] = add i32 [[SUB21]], 1
// CHECK23-NEXT:    [[DIV23:%.*]] = udiv i32 [[ADD22]], 1
// CHECK23-NEXT:    [[MUL24:%.*]] = mul i32 [[DIV23]], 1
// CHECK23-NEXT:    [[ADD25:%.*]] = add i32 [[TMP29]], [[MUL24]]
// CHECK23-NEXT:    store i32 [[ADD25]], i32* [[I6]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK23:       omp.precond.end:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2S12r1Ei_l215
// CHECK23-SAME: (%struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK23-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[TMP4]], i32* [[B_CASTED]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[B_CASTED]], align 4
// CHECK23-NEXT:    [[TMP6:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK23-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK23-NEXT:    [[CONV3:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK23-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK23-NEXT:    store i8 [[FROMBOOL]], i8* [[CONV3]], align 1
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.S1*, i32, i32, i32, i16*, i32)* @.omp_outlined..5 to void (i32*, i32*, ...)*), %struct.S1* [[TMP0]], i32 [[TMP5]], i32 [[TMP1]], i32 [[TMP2]], i16* [[TMP3]], i32 [[TMP7]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..5
// CHECK23-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], %struct.S1* noundef [[THIS:%.*]], i32 noundef [[B:%.*]], i32 noundef [[VLA:%.*]], i32 noundef [[VLA1:%.*]], i16* noundef nonnull align 2 dereferenceable(2) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S1*, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[VLA_ADDR2:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[C_ADDR:%.*]] = alloca i16*, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store %struct.S1* [[THIS]], %struct.S1** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[B]], i32* [[B_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[VLA1]], i32* [[VLA_ADDR2]], align 4
// CHECK23-NEXT:    store i16* [[C]], i16** [[C_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load %struct.S1*, %struct.S1** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[VLA_ADDR2]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load i16*, i16** [[C_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 9
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP9:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK23-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK23-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK23:       omp_if.then:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK23-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[B_ADDR]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[CONV4:%.*]] = sitofp i32 [[TMP13]] to double
// CHECK23-NEXT:    [[ADD5:%.*]] = fadd double [[CONV4]], 1.500000e+00
// CHECK23-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_S1:%.*]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK23-NEXT:    store double [[ADD5]], double* [[A]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[A6:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP14:%.*]] = load double, double* [[A6]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[INC:%.*]] = fadd double [[TMP14]], 1.000000e+00
// CHECK23-NEXT:    store double [[INC]], double* [[A6]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[CONV7:%.*]] = fptosi double [[INC]] to i16
// CHECK23-NEXT:    [[TMP15:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP15]]
// CHECK23-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX]], i32 1
// CHECK23-NEXT:    store i16 [[CONV7]], i16* [[ARRAYIDX8]], align 2, !llvm.access.group !31
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK23-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !31
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP32:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK23:       omp_if.else:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK23:       omp.inner.for.cond10:
// CHECK23-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK23-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY12:%.*]], label [[OMP_INNER_FOR_END26:%.*]]
// CHECK23:       omp.inner.for.body12:
// CHECK23-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[MUL13:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK23-NEXT:    [[ADD14:%.*]] = add nsw i32 0, [[MUL13]]
// CHECK23-NEXT:    store i32 [[ADD14]], i32* [[I]], align 4
// CHECK23-NEXT:    [[TMP20:%.*]] = load i32, i32* [[B_ADDR]], align 4
// CHECK23-NEXT:    [[CONV15:%.*]] = sitofp i32 [[TMP20]] to double
// CHECK23-NEXT:    [[ADD16:%.*]] = fadd double [[CONV15]], 1.500000e+00
// CHECK23-NEXT:    [[A17:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK23-NEXT:    store double [[ADD16]], double* [[A17]], align 4
// CHECK23-NEXT:    [[A18:%.*]] = getelementptr inbounds [[STRUCT_S1]], %struct.S1* [[TMP0]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP21:%.*]] = load double, double* [[A18]], align 4
// CHECK23-NEXT:    [[INC19:%.*]] = fadd double [[TMP21]], 1.000000e+00
// CHECK23-NEXT:    store double [[INC19]], double* [[A18]], align 4
// CHECK23-NEXT:    [[CONV20:%.*]] = fptosi double [[INC19]] to i16
// CHECK23-NEXT:    [[TMP22:%.*]] = mul nsw i32 1, [[TMP2]]
// CHECK23-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds i16, i16* [[TMP3]], i32 [[TMP22]]
// CHECK23-NEXT:    [[ARRAYIDX22:%.*]] = getelementptr inbounds i16, i16* [[ARRAYIDX21]], i32 1
// CHECK23-NEXT:    store i16 [[CONV20]], i16* [[ARRAYIDX22]], align 2
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE23:%.*]]
// CHECK23:       omp.body.continue23:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC24:%.*]]
// CHECK23:       omp.inner.for.inc24:
// CHECK23-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[ADD25:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK23-NEXT:    store i32 [[ADD25]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP34:![0-9]+]]
// CHECK23:       omp.inner.for.end26:
// CHECK23-NEXT:    br label [[OMP_IF_END]]
// CHECK23:       omp_if.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]])
// CHECK23-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK23-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z9ftemplateIiET_i_l180
// CHECK23-SAME: (i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR0]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK23-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[TMP1]], i32* [[A_CASTED]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[A_CASTED]], align 4
// CHECK23-NEXT:    [[TMP3:%.*]] = load i16, i16* [[CONV]], align 2
// CHECK23-NEXT:    [[CONV1:%.*]] = bitcast i32* [[AA_CASTED]] to i16*
// CHECK23-NEXT:    store i16 [[TMP3]], i16* [[CONV1]], align 2
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[AA_CASTED]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [10 x i32]*)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32 [[TMP2]], i32 [[TMP4]], [10 x i32]* [[TMP0]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK23-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[A:%.*]], i32 noundef [[AA:%.*]], [10 x i32]* noundef nonnull align 4 dereferenceable(40) [[B:%.*]]) #[[ATTR1]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[AA_ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[B_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[AA]], i32* [[AA_ADDR]], align 4
// CHECK23-NEXT:    store [10 x i32]* [[B]], [10 x i32]** [[B_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[AA_ADDR]] to i16*
// CHECK23-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[B_ADDR]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[A_ADDR]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP9]], 1
// CHECK23-NEXT:    store i32 [[ADD2]], i32* [[A_ADDR]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    [[TMP10:%.*]] = load i16, i16* [[CONV]], align 2, !llvm.access.group !36
// CHECK23-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP10]] to i32
// CHECK23-NEXT:    [[ADD4:%.*]] = add nsw i32 [[CONV3]], 1
// CHECK23-NEXT:    [[CONV5:%.*]] = trunc i32 [[ADD4]] to i16
// CHECK23-NEXT:    store i16 [[CONV5]], i16* [[CONV]], align 2, !llvm.access.group !36
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 2
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK23-NEXT:    store i32 [[ADD6]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK23-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !36
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP37:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP14:%.*]] = icmp ne i32 [[TMP13]], 0
// CHECK23-NEXT:    br i1 [[TMP14]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
