// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// Test host code gen
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -verify -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -verify -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK3

// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -verify -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -verify -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"

// RUN: %clang_cc1 -no-opaque-pointers  -verify -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers  -verify -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK11
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK11

// RUN: %clang_cc1 -no-opaque-pointers  -verify -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp-simd -fopenmp-version=45 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers  -verify -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp-simd -fopenmp-version=45 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// expected-no-diagnostics
#ifndef HEADER
#define HEADER


template <typename T>
T tmain() {
  T *a, *b, *c;
  int n = 10000;
  int ch = 100;

  // no schedule clauses
  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for
  for (int i = 0; i < n; ++i) {
    #pragma omp cancel for
    a[i] = b[i] + c[i];
  }

  // dist_schedule: static no chunk
  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for dist_schedule(static)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
  }

  // dist_schedule: static chunk
  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for dist_schedule(static, ch)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
  }

  // schedule: static no chunk
  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for schedule(static)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
  }

  // schedule: static chunk
  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for schedule(static, ch)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
  }

  // schedule: dynamic no chunk
  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for schedule(dynamic)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
  }

  // schedule: dynamic chunk
  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for schedule(dynamic, ch)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
  }

  return T();
}

int main() {
  double *a, *b, *c;
  int n = 10000;
  int ch = 100;

#ifdef LAMBDA
  [&]() {








    // no schedule clauses
    #pragma omp target
    #pragma omp teams

    #pragma omp distribute parallel for
    for (int i = 0; i < n; ++i) {
      a[i] = b[i] + c[i];


      // check EUB for distribute

      // initialize omp.iv

      // check exit condition

      // check that PrevLB and PrevUB are passed to the 'for'
      // check that distlb and distub are properly passed to fork_call

      // increment by stride (distInc - 'parallel for' executes the whole chunk) and latch


      // implementation of 'parallel for'


      // initialize lb and ub to PrevLB and PrevUB

      // PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
      // In this case we use EUB

      // initialize omp.iv

      // check exit condition

      // check that PrevLB and PrevUB are passed to the 'for'

      // check stride 1 for 'for' in 'distribute parallel for'


      [&]() {
	a[i] = b[i] + c[i];
      }();
    }

    // dist_schedule: static no chunk (same sa default - no dist_schedule)
    #pragma omp target
    #pragma omp teams

    #pragma omp distribute parallel for dist_schedule(static)
    for (int i = 0; i < n; ++i) {
      a[i] = b[i] + c[i];


      // check EUB for distribute

      // initialize omp.iv

      // check exit condition

      // check that PrevLB and PrevUB are passed to the 'for'
      // check that distlb and distub are properly passed to fork_call

      // increment by stride (distInc - 'parallel for' executes the whole chunk) and latch


      // implementation of 'parallel for'


      // initialize lb and ub to PrevLB and PrevUB

      // PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
      // In this case we use EUB

      // initialize omp.iv

      // check exit condition

      // check that PrevLB and PrevUB are passed to the 'for'

      // check stride 1 for 'for' in 'distribute parallel for'

      [&]() {
	a[i] = b[i] + c[i];
      }();
    }

    // dist_schedule: static chunk
    #pragma omp target
    #pragma omp teams

    #pragma omp distribute parallel for dist_schedule(static, ch)
    for (int i = 0; i < n; ++i) {
      a[i] = b[i] + c[i];


      // check EUB for distribute

      // initialize omp.iv

      // check exit condition

      // check that PrevLB and PrevUB are passed to the 'for'
      // check that distlb and distub are properly passed to fork_call

      // check DistInc

      // Update UB

      // Store LB in IV


      // loop exit

      // skip implementation of 'parallel for': using default scheduling and was tested above
      [&]() {
	a[i] = b[i] + c[i];
      }();
    }

    // schedule: static no chunk
    #pragma omp target
    #pragma omp teams

    #pragma omp distribute parallel for schedule(static)
    for (int i = 0; i < n; ++i) {
      a[i] = b[i] + c[i];

      // skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

      // 'parallel for' implementation is the same as the case without schedule clase (static no chunk is the default)


      // initialize lb and ub to PrevLB and PrevUB

      // PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
      // In this case we use EUB

      // initialize omp.iv

      // check exit condition

      // check that PrevLB and PrevUB are passed to the 'for'

      // check stride 1 for 'for' in 'distribute parallel for'


      [&]() {
	a[i] = b[i] + c[i];
      }();
    }

    // schedule: static chunk
    #pragma omp target
    #pragma omp teams

    #pragma omp distribute parallel for schedule(static, ch)
    for (int i = 0; i < n; ++i) {
      a[i] = b[i] + c[i];
      // skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

      // 'parallel for' implementation using outer and inner loops and PrevEUB

      // initialize lb and ub to PrevLB and PrevUB

      // check PrevEUB (using PrevUB instead of NumIt as upper bound)

      // initialize omp.iv (IV = LB)

      // outer loop: while (IV < UB) {



      // skip body branch

      // IV = IV + 1 and inner loop latch

      // check NextLB and NextUB


      [&]() {
	a[i] = b[i] + c[i];
      }();
    }

    // schedule: dynamic no chunk
    #pragma omp target
    #pragma omp teams

    #pragma omp distribute parallel for schedule(dynamic)
    for (int i = 0; i < n; ++i) {
      a[i] = b[i] + c[i];
      // skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

      // 'parallel for' implementation using outer and inner loops and PrevEUB

      // initialize lb and ub to PrevLB and PrevUB


      // initialize omp.iv (IV = LB)


      // skip body branch

      // IV = IV + 1 and inner loop latch

      // check NextLB and NextUB


      [&]() {
	a[i] = b[i] + c[i];
      }();
    }

    // schedule: dynamic chunk
    #pragma omp target
    #pragma omp teams

    #pragma omp distribute parallel for schedule(dynamic, ch)
    for (int i = 0; i < n; ++i) {
      a[i] = b[i] + c[i];
      // skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

      // 'parallel for' implementation using outer and inner loops and PrevEUB

      // initialize lb and ub to PrevLB and PrevUB


      // initialize omp.iv (IV = LB)


      // skip body branch

      // IV = IV + 1 and inner loop latch

      // check NextLB and NextUB


      [&]() {
	a[i] = b[i] + c[i];
      }();
    }
  }();
  return 0;
#else









  // no schedule clauses
  #pragma omp target
  #pragma omp teams

  #pragma omp distribute parallel for
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];


    // check EUB for distribute

    // initialize omp.iv

    // check exit condition

    // check that PrevLB and PrevUB are passed to the 'for'
    // check that distlb and distub are properly passed to fork_call

    // increment by stride (distInc - 'parallel for' executes the whole chunk) and latch


    // implementation of 'parallel for'


    // initialize lb and ub to PrevLB and PrevUB

    // PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
    // In this case we use EUB

    // initialize omp.iv

    // check exit condition

    // check that PrevLB and PrevUB are passed to the 'for'

    // check stride 1 for 'for' in 'distribute parallel for'

  }

  // dist_schedule: static no chunk
  #pragma omp target
  #pragma omp teams

  #pragma omp distribute parallel for dist_schedule(static)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];


    // check EUB for distribute

    // initialize omp.iv

    // check exit condition

    // check that PrevLB and PrevUB are passed to the 'for'
    // check that distlb and distub are properly passed to fork_call

    // increment by stride (distInc - 'parallel for' executes the whole chunk) and latch


    // implementation of 'parallel for'


    // initialize lb and ub to PrevLB and PrevUB

    // PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
    // In this case we use EUB

    // initialize omp.iv

    // check exit condition

    // check that PrevLB and PrevUB are passed to the 'for'

    // check stride 1 for 'for' in 'distribute parallel for'

  }

  // dist_schedule: static chunk
  #pragma omp target
  #pragma omp teams

  #pragma omp distribute parallel for dist_schedule(static, ch)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];

    // unlike the previous tests, in this one we have a outer and inner loop for 'distribute'

    // check EUB for distribute

    // initialize omp.iv

    // check exit condition

    // check that PrevLB and PrevUB are passed to the 'for'
    // check that distlb and distub are properly passed to fork_call

    // check DistInc

    // Update UB

    // Store LB in IV


    // loop exit

    // skip implementation of 'parallel for': using default scheduling and was tested above
  }

  // schedule: static no chunk
  #pragma omp target
  #pragma omp teams

  #pragma omp distribute parallel for schedule(static)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];

    // skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

    // 'parallel for' implementation is the same as the case without schedule clase (static no chunk is the default)


    // initialize lb and ub to PrevLB and PrevUB

    // PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
    // In this case we use EUB

    // initialize omp.iv

    // check exit condition

    // check that PrevLB and PrevUB are passed to the 'for'

    // check stride 1 for 'for' in 'distribute parallel for'

  }

  // schedule: static chunk
  #pragma omp target
  #pragma omp teams

  #pragma omp distribute parallel for schedule(static, ch)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
    // skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

    // 'parallel for' implementation using outer and inner loops and PrevEUB

    // initialize lb and ub to PrevLB and PrevUB

    // check PrevEUB (using PrevUB instead of NumIt as upper bound)

    // initialize omp.iv (IV = LB)

    // outer loop: while (IV < UB) {



    // skip body branch

    // IV = IV + 1 and inner loop latch

    // check NextLB and NextUB


  }

  // schedule: dynamic no chunk
  #pragma omp target
  #pragma omp teams

  #pragma omp distribute parallel for schedule(dynamic)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
    // skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

    // 'parallel for' implementation using outer and inner loops and PrevEUB

    // initialize lb and ub to PrevLB and PrevUB


    // initialize omp.iv (IV = LB)


    // skip body branch

    // IV = IV + 1 and inner loop latch

    // check NextLB and NextUB


  }

  // schedule: dynamic chunk
  #pragma omp target
  #pragma omp teams

  #pragma omp distribute parallel for schedule(dynamic, ch)
  for (int i = 0; i < n; ++i) {
    a[i] = b[i] + c[i];
    // skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

    // 'parallel for' implementation using outer and inner loops and PrevEUB

    // initialize lb and ub to PrevLB and PrevUB


    // initialize omp.iv (IV = LB)


    // skip body branch

    // IV = IV + 1 and inner loop latch

    // check NextLB and NextUB


  }

  return tmain<int>();
#endif
}

// check code











// check EUB for distribute

// initialize omp.iv

// check exit condition

// check that PrevLB and PrevUB are passed to the 'for'
// check that distlb and distub are properly passed to fork_call

// increment by stride (distInc - 'parallel for' executes the whole chunk) and latch


// implementation of 'parallel for'


// initialize lb and ub to PrevLB and PrevUB

// PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
// In this case we use EUB

// initialize omp.iv

// check exit condition

// check that PrevLB and PrevUB are passed to the 'for'

// check stride 1 for 'for' in 'distribute parallel for'





// check EUB for distribute

// initialize omp.iv

// check exit condition

// check that PrevLB and PrevUB are passed to the 'for'
// check that distlb and distub are properly passed to fork_call

// increment by stride (distInc - 'parallel for' executes the whole chunk) and latch


// implementation of 'parallel for'


// initialize lb and ub to PrevLB and PrevUB

// PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
// In this case we use EUB

// initialize omp.iv

// check exit condition

// check that PrevLB and PrevUB are passed to the 'for'

// check stride 1 for 'for' in 'distribute parallel for'




// unlike the previous tests, in this one we have a outer and inner loop for 'distribute'

// check EUB for distribute

// initialize omp.iv

// check exit condition

// check that PrevLB and PrevUB are passed to the 'for'
// check that distlb and distub are properly passed to fork_call

// check DistInc

// Update UB

// Store LB in IV


// loop exit

// skip implementation of 'parallel for': using default scheduling and was tested above



// skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

// 'parallel for' implementation is the same as the case without schedule clase (static no chunk is the default)


// initialize lb and ub to PrevLB and PrevUB

// PrevEUB is only used when 'for' has a chunked schedule, otherwise EUB is used
// In this case we use EUB

// initialize omp.iv

// check exit condition

// check that PrevLB and PrevUB are passed to the 'for'

// check stride 1 for 'for' in 'distribute parallel for'



// skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

// 'parallel for' implementation using outer and inner loops and PrevEUB

// initialize lb and ub to PrevLB and PrevUB

// check PrevEUB (using PrevUB instead of NumIt as upper bound)

// initialize omp.iv (IV = LB)

// outer loop: while (IV < UB) {



// skip body branch

// IV = IV + 1 and inner loop latch

// check NextLB and NextUB




// skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

// 'parallel for' implementation using outer and inner loops and PrevEUB

// initialize lb and ub to PrevLB and PrevUB


// initialize omp.iv (IV = LB)


// skip body branch

// IV = IV + 1 and inner loop latch

// check NextLB and NextUB




// skip rest of implementation of 'distribute' as it is tested above for default dist_schedule case

// 'parallel for' implementation using outer and inner loops and PrevEUB

// initialize lb and ub to PrevLB and PrevUB


// initialize omp.iv (IV = LB)


// skip body branch

// IV = IV + 1 and inner loop latch

// check NextLB and NextUB


#endif
// CHECK1-LABEL: define {{[^@]+}}@main
// CHECK1-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[B:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[C:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[CH:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK1-NEXT:    store i32 10000, i32* [[N]], align 4
// CHECK1-NEXT:    store i32 100, i32* [[CH]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store i32* [[N]], i32** [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    store double** [[A]], double*** [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store double** [[B]], double*** [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store double** [[C]], double*** [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 4
// CHECK1-NEXT:    store i32* [[CH]], i32** [[TMP4]], align 8
// CHECK1-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 8 dereferenceable(40) [[REF_TMP]])
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l117
// CHECK1-SAME: (i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM7]]
// CHECK1-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX8]], align 8
// CHECK1-NEXT:    [[ADD9:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK1-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK1-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM10]]
// CHECK1-NEXT:    store double [[ADD9]], double* [[ARRAYIDX11]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double** [[TMP1]], double*** [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    store i32* [[I4]], i32** [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store double** [[TMP2]], double*** [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store double** [[TMP3]], double*** [[TMP31]], align 8
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(%class.anon.0* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK1-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l160
// CHECK1-SAME: (i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32* [[CONV]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_1:%.*]], align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM7]]
// CHECK1-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX8]], align 8
// CHECK1-NEXT:    [[ADD9:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK1-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK1-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM10]]
// CHECK1-NEXT:    store double [[ADD9]], double* [[ARRAYIDX11]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double** [[TMP1]], double*** [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    store i32* [[I4]], i32** [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store double** [[TMP2]], double*** [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store double** [[TMP3]], double*** [[TMP31]], align 8
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE0_clEv"(%class.anon.1* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK1-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l202
// CHECK1-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP7]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP9]])
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK1-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp slt i32 [[TMP17]], [[ADD]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK1-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK1-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP27]], [[TMP28]]
// CHECK1-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP9:%.*]] = icmp sgt i32 [[TMP29]], [[TMP30]]
// CHECK1-NEXT:    br i1 [[CMP9]], label [[COND_TRUE10:%.*]], label [[COND_FALSE11:%.*]]
// CHECK1:       cond.true10:
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END12:%.*]]
// CHECK1:       cond.false11:
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END12]]
// CHECK1:       cond.end12:
// CHECK1-NEXT:    [[COND13:%.*]] = phi i32 [ [[TMP31]], [[COND_TRUE10]] ], [ [[TMP32]], [[COND_FALSE11]] ]
// CHECK1-NEXT:    store i32 [[COND13]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP33]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32, i32* [[TMP34]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP35]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_2:%.*]], align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM7]]
// CHECK1-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX8]], align 8
// CHECK1-NEXT:    [[ADD9:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK1-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK1-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM10]]
// CHECK1-NEXT:    store double [[ADD9]], double* [[ARRAYIDX11]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_2]], %class.anon.2* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double** [[TMP1]], double*** [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_2]], %class.anon.2* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    store i32* [[I4]], i32** [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_2]], %class.anon.2* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store double** [[TMP2]], double*** [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_2]], %class.anon.2* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store double** [[TMP3]], double*** [[TMP31]], align 8
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE1_clEv"(%class.anon.2* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK1-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l235
// CHECK1-SAME: (i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i32* [[CONV]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..11 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..11
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_3:%.*]], align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM7]]
// CHECK1-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX8]], align 8
// CHECK1-NEXT:    [[ADD9:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK1-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK1-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK1-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM10]]
// CHECK1-NEXT:    store double [[ADD9]], double* [[ARRAYIDX11]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_3]], %class.anon.3* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double** [[TMP1]], double*** [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_3]], %class.anon.3* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    store i32* [[I4]], i32** [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_3]], %class.anon.3* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store double** [[TMP2]], double*** [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_3]], %class.anon.3* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store double** [[TMP3]], double*** [[TMP31]], align 8
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE2_clEv"(%class.anon.3* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK1-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l267
// CHECK1-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..14 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..14
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP23]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**, i64)* @.omp_outlined..15 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]], i64 [[TMP24]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP28]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..15
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_4:%.*]], align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK1-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV5]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP10]])
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK1:       omp.dispatch.cond:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV7:%.*]] = trunc i64 [[TMP14]] to i32
// CHECK1-NEXT:    [[CMP8:%.*]] = icmp sgt i32 [[TMP13]], [[CONV7]]
// CHECK1-NEXT:    br i1 [[CMP8]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV9:%.*]] = trunc i64 [[TMP15]] to i32
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[CONV9]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK1-NEXT:    br i1 [[CMP10]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK1:       omp.dispatch.body:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK1-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I6]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I6]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP24]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I6]], align 4
// CHECK1-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP27]] to i64
// CHECK1-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM12]]
// CHECK1-NEXT:    [[TMP28:%.*]] = load double, double* [[ARRAYIDX13]], align 8
// CHECK1-NEXT:    [[ADD14:%.*]] = fadd double [[TMP25]], [[TMP28]]
// CHECK1-NEXT:    [[TMP29:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, i32* [[I6]], align 4
// CHECK1-NEXT:    [[IDXPROM15:%.*]] = sext i32 [[TMP30]] to i64
// CHECK1-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds double, double* [[TMP29]], i64 [[IDXPROM15]]
// CHECK1-NEXT:    store double [[ADD14]], double* [[ARRAYIDX16]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_4]], %class.anon.4* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double** [[TMP1]], double*** [[TMP31]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[CLASS_ANON_4]], %class.anon.4* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    store i32* [[I6]], i32** [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[CLASS_ANON_4]], %class.anon.4* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store double** [[TMP2]], double*** [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[CLASS_ANON_4]], %class.anon.4* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store double** [[TMP3]], double*** [[TMP34]], align 8
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE3_clEv"(%class.anon.4* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP35]], 1
// CHECK1-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK1:       omp.dispatch.inc:
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP36]], [[TMP37]]
// CHECK1-NEXT:    store i32 [[ADD18]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP38]], [[TMP39]]
// CHECK1-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK1:       omp.dispatch.end:
// CHECK1-NEXT:    [[TMP40:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP41:%.*]] = load i32, i32* [[TMP40]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP41]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l300
// CHECK1-SAME: (i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..18 to void (i32*, i32*, ...)*), i32* [[CONV]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..18
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..19 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..19
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_5:%.*]], align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK1-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP13]], i32 35, i32 [[TMP10]], i32 [[TMP11]], i32 1, i32 1)
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK1:       omp.dispatch.cond:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP14]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP15]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK1:       omp.dispatch.body:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP21:%.*]] = load double*, double** [[TMP2]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP22]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP21]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP23:%.*]] = load double, double* [[ARRAYIDX]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP24:%.*]] = load double*, double** [[TMP3]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP25]] to i64
// CHECK1-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds double, double* [[TMP24]], i64 [[IDXPROM6]]
// CHECK1-NEXT:    [[TMP26:%.*]] = load double, double* [[ARRAYIDX7]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[ADD8:%.*]] = fadd double [[TMP23]], [[TMP26]]
// CHECK1-NEXT:    [[TMP27:%.*]] = load double*, double** [[TMP1]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP28]] to i64
// CHECK1-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds double, double* [[TMP27]], i64 [[IDXPROM9]]
// CHECK1-NEXT:    store double [[ADD8]], double* [[ARRAYIDX10]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_5]], %class.anon.5* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double** [[TMP1]], double*** [[TMP29]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_5]], %class.anon.5* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    store i32* [[I4]], i32** [[TMP30]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_5]], %class.anon.5* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store double** [[TMP2]], double*** [[TMP31]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[CLASS_ANON_5]], %class.anon.5* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store double** [[TMP3]], double*** [[TMP32]], align 8, !llvm.access.group !12
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE4_clEv"(%class.anon.5* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]]), !llvm.access.group !12
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP33]], 1
// CHECK1-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK1:       omp.dispatch.inc:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK1:       omp.dispatch.end:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l329
// CHECK1-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..22 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..22
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP23]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**, i64)* @.omp_outlined..23 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]], i64 [[TMP24]])
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP28]])
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..23
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_6:%.*]], align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK1-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV5]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK1-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP14]], i32 35, i32 [[TMP11]], i32 [[TMP12]], i32 1, i32 [[TMP10]])
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK1:       omp.dispatch.cond:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[TMP15]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP16]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK1:       omp.dispatch.body:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK1-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I6]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP22:%.*]] = load double*, double** [[TMP2]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP22]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP25:%.*]] = load double*, double** [[TMP3]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP26]] to i64
// CHECK1-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds double, double* [[TMP25]], i64 [[IDXPROM8]]
// CHECK1-NEXT:    [[TMP27:%.*]] = load double, double* [[ARRAYIDX9]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[ADD10:%.*]] = fadd double [[TMP24]], [[TMP27]]
// CHECK1-NEXT:    [[TMP28:%.*]] = load double*, double** [[TMP1]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    [[IDXPROM11:%.*]] = sext i32 [[TMP29]] to i64
// CHECK1-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds double, double* [[TMP28]], i64 [[IDXPROM11]]
// CHECK1-NEXT:    store double [[ADD10]], double* [[ARRAYIDX12]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_6]], %class.anon.6* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double** [[TMP1]], double*** [[TMP30]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_6]], %class.anon.6* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    store i32* [[I6]], i32** [[TMP31]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[CLASS_ANON_6]], %class.anon.6* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store double** [[TMP2]], double*** [[TMP32]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[CLASS_ANON_6]], %class.anon.6* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store double** [[TMP3]], double*** [[TMP33]], align 8, !llvm.access.group !15
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE5_clEv"(%class.anon.6* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]]), !llvm.access.group !15
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP34]], 1
// CHECK1-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK1:       omp.dispatch.inc:
// CHECK1-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK1:       omp.dispatch.end:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@main
// CHECK3-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[B:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[C:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[CH:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK3-NEXT:    store i32 10000, i32* [[N]], align 4
// CHECK3-NEXT:    store i32 100, i32* [[CH]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store i32* [[N]], i32** [[TMP0]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    store double** [[A]], double*** [[TMP1]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store double** [[B]], double*** [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store double** [[C]], double*** [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 4
// CHECK3-NEXT:    store i32* [[CH]], i32** [[TMP4]], align 4
// CHECK3-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 4 dereferenceable(20) [[REF_TMP]])
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l117
// CHECK3-SAME: (i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i32 [[TMP21]]
// CHECK3-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK3-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX6]], align 4
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK3-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK3-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double** [[TMP1]], double*** [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    store i32* [[I3]], i32** [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store double** [[TMP2]], double*** [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store double** [[TMP3]], double*** [[TMP31]], align 4
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(%class.anon.0* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]])
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK3-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l160
// CHECK3-SAME: (i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_1:%.*]], align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i32 [[TMP21]]
// CHECK3-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK3-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX6]], align 4
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK3-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK3-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double** [[TMP1]], double*** [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    store i32* [[I3]], i32** [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store double** [[TMP2]], double*** [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], %class.anon.1* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store double** [[TMP3]], double*** [[TMP31]], align 4
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE0_clEv"(%class.anon.1* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]])
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK3-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l202
// CHECK3-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP7]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP9]])
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp slt i32 [[TMP17]], [[ADD]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK3-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK3-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP9:%.*]] = icmp sgt i32 [[TMP27]], [[TMP28]]
// CHECK3-NEXT:    br i1 [[CMP9]], label [[COND_TRUE10:%.*]], label [[COND_FALSE11:%.*]]
// CHECK3:       cond.true10:
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END12:%.*]]
// CHECK3:       cond.false11:
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END12]]
// CHECK3:       cond.end12:
// CHECK3-NEXT:    [[COND13:%.*]] = phi i32 [ [[TMP29]], [[COND_TRUE10]] ], [ [[TMP30]], [[COND_FALSE11]] ]
// CHECK3-NEXT:    store i32 [[COND13]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP31]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32, i32* [[TMP32]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP33]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_2:%.*]], align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i32 [[TMP21]]
// CHECK3-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK3-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX6]], align 4
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK3-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK3-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_2]], %class.anon.2* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double** [[TMP1]], double*** [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_2]], %class.anon.2* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    store i32* [[I3]], i32** [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_2]], %class.anon.2* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store double** [[TMP2]], double*** [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_2]], %class.anon.2* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store double** [[TMP3]], double*** [[TMP31]], align 4
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE1_clEv"(%class.anon.2* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]])
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK3-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l235
// CHECK3-SAME: (i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..11 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..11
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_3:%.*]], align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i32 [[TMP21]]
// CHECK3-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK3-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX6]], align 4
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK3-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK3-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[CLASS_ANON_3]], %class.anon.3* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double** [[TMP1]], double*** [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_3]], %class.anon.3* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    store i32* [[I3]], i32** [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_3]], %class.anon.3* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store double** [[TMP2]], double*** [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_3]], %class.anon.3* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store double** [[TMP3]], double*** [[TMP31]], align 4
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE2_clEv"(%class.anon.3* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]])
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK3-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l267
// CHECK3-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..14 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..14
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    store i32 [[TMP21]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**, i32)* @.omp_outlined..15 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]], i32 [[TMP22]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..15
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_4:%.*]], align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP10]])
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK3:       omp.dispatch.cond:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP13]], [[TMP14]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP15]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK3-NEXT:    br i1 [[CMP6]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK3:       omp.dispatch.body:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK3-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK3-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK3-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK3-NEXT:    [[TMP28:%.*]] = load double, double* [[ARRAYIDX8]], align 4
// CHECK3-NEXT:    [[ADD9:%.*]] = fadd double [[TMP25]], [[TMP28]]
// CHECK3-NEXT:    [[TMP29:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = load i32, i32* [[I4]], align 4
// CHECK3-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds double, double* [[TMP29]], i32 [[TMP30]]
// CHECK3-NEXT:    store double [[ADD9]], double* [[ARRAYIDX10]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_4]], %class.anon.4* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double** [[TMP1]], double*** [[TMP31]], align 4
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[CLASS_ANON_4]], %class.anon.4* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    store i32* [[I4]], i32** [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[CLASS_ANON_4]], %class.anon.4* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store double** [[TMP2]], double*** [[TMP33]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[CLASS_ANON_4]], %class.anon.4* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store double** [[TMP3]], double*** [[TMP34]], align 4
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE3_clEv"(%class.anon.4* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]])
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP35]], 1
// CHECK3-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK3:       omp.dispatch.inc:
// CHECK3-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP36]], [[TMP37]]
// CHECK3-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP38]], [[TMP39]]
// CHECK3-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK3:       omp.dispatch.end:
// CHECK3-NEXT:    [[TMP40:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP41:%.*]] = load i32, i32* [[TMP40]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP41]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l300
// CHECK3-SAME: (i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..18 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..18
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..19 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..19
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_5:%.*]], align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK3-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP13]], i32 35, i32 [[TMP10]], i32 [[TMP11]], i32 1, i32 1)
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK3:       omp.dispatch.cond:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP14]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP15]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK3-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK3-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK3:       omp.dispatch.body:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP21:%.*]] = load double*, double** [[TMP2]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP21]], i32 [[TMP22]]
// CHECK3-NEXT:    [[TMP23:%.*]] = load double, double* [[ARRAYIDX]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP24:%.*]] = load double*, double** [[TMP3]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds double, double* [[TMP24]], i32 [[TMP25]]
// CHECK3-NEXT:    [[TMP26:%.*]] = load double, double* [[ARRAYIDX5]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[ADD6:%.*]] = fadd double [[TMP23]], [[TMP26]]
// CHECK3-NEXT:    [[TMP27:%.*]] = load double*, double** [[TMP1]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds double, double* [[TMP27]], i32 [[TMP28]]
// CHECK3-NEXT:    store double [[ADD6]], double* [[ARRAYIDX7]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[CLASS_ANON_5]], %class.anon.5* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double** [[TMP1]], double*** [[TMP29]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_5]], %class.anon.5* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    store i32* [[I3]], i32** [[TMP30]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_5]], %class.anon.5* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store double** [[TMP2]], double*** [[TMP31]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[CLASS_ANON_5]], %class.anon.5* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store double** [[TMP3]], double*** [[TMP32]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE4_clEv"(%class.anon.5* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]]), !llvm.access.group !13
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP33]], 1
// CHECK3-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK3:       omp.dispatch.inc:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK3:       omp.dispatch.end:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l329
// CHECK3-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..22 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..22
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    store i32 [[TMP21]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**, i32)* @.omp_outlined..23 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]], i32 [[TMP22]])
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..23
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_6:%.*]], align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK3-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP14]], i32 35, i32 [[TMP11]], i32 [[TMP12]], i32 1, i32 [[TMP10]])
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK3:       omp.dispatch.cond:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP16]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK3-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK3-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK3:       omp.dispatch.body:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP22:%.*]] = load double*, double** [[TMP2]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP22]], i32 [[TMP23]]
// CHECK3-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP25:%.*]] = load double*, double** [[TMP3]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP25]], i32 [[TMP26]]
// CHECK3-NEXT:    [[TMP27:%.*]] = load double, double* [[ARRAYIDX6]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[TMP24]], [[TMP27]]
// CHECK3-NEXT:    [[TMP28:%.*]] = load double*, double** [[TMP1]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP28]], i32 [[TMP29]]
// CHECK3-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[CLASS_ANON_6]], %class.anon.6* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double** [[TMP1]], double*** [[TMP30]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[CLASS_ANON_6]], %class.anon.6* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    store i32* [[I4]], i32** [[TMP31]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[CLASS_ANON_6]], %class.anon.6* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store double** [[TMP2]], double*** [[TMP32]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[CLASS_ANON_6]], %class.anon.6* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store double** [[TMP3]], double*** [[TMP33]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE5_clEv"(%class.anon.6* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]]), !llvm.access.group !16
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP34]], 1
// CHECK3-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !16
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK3:       omp.dispatch.inc:
// CHECK3-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK3:       omp.dispatch.end:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@main
// CHECK9-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[A:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[B:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[C:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[CH:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[N_CASTED3:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[_TMP8:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[CH_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_CASTED18:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS20:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS21:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS22:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[_TMP23:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_24:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_25:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[N_CASTED32:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS34:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS35:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS36:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[_TMP37:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_38:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_39:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[CH_CASTED46:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_CASTED48:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS50:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS51:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS52:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[_TMP53:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_54:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_55:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[N_CASTED62:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS64:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS65:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS66:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[_TMP67:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_68:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_69:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[CH_CASTED76:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_CASTED78:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS80:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS81:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS82:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[_TMP83:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_84:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_85:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK9-NEXT:    store i32 10000, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 100, i32* [[CH]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double*, double** [[A]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double*, double** [[B]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load double*, double** [[C]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i64*
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[TMP6]], align 8
// CHECK9-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP9]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to double**
// CHECK9-NEXT:    store double* [[TMP2]], double** [[TMP11]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to double**
// CHECK9-NEXT:    store double* [[TMP2]], double** [[TMP13]], align 8
// CHECK9-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK9-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to double**
// CHECK9-NEXT:    store double* [[TMP3]], double** [[TMP16]], align 8
// CHECK9-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to double**
// CHECK9-NEXT:    store double* [[TMP3]], double** [[TMP18]], align 8
// CHECK9-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK9-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to double**
// CHECK9-NEXT:    store double* [[TMP4]], double** [[TMP21]], align 8
// CHECK9-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to double**
// CHECK9-NEXT:    store double* [[TMP4]], double** [[TMP23]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK9-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK9-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK9-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l369.region_id, i32 4, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK9-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK9:       omp_offload.failed:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l369(i64 [[TMP1]], double* [[TMP2]], double* [[TMP3]], double* [[TMP4]]) #[[ATTR2:[0-9]+]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK9:       omp_offload.cont:
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV4:%.*]] = bitcast i64* [[N_CASTED3]] to i32*
// CHECK9-NEXT:    store i32 [[TMP33]], i32* [[CONV4]], align 4
// CHECK9-NEXT:    [[TMP34:%.*]] = load i64, i64* [[N_CASTED3]], align 8
// CHECK9-NEXT:    [[TMP35:%.*]] = load double*, double** [[A]], align 8
// CHECK9-NEXT:    [[TMP36:%.*]] = load double*, double** [[B]], align 8
// CHECK9-NEXT:    [[TMP37:%.*]] = load double*, double** [[C]], align 8
// CHECK9-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP39:%.*]] = bitcast i8** [[TMP38]] to i64*
// CHECK9-NEXT:    store i64 [[TMP34]], i64* [[TMP39]], align 8
// CHECK9-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to i64*
// CHECK9-NEXT:    store i64 [[TMP34]], i64* [[TMP41]], align 8
// CHECK9-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP42]], align 8
// CHECK9-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP44:%.*]] = bitcast i8** [[TMP43]] to double**
// CHECK9-NEXT:    store double* [[TMP35]], double** [[TMP44]], align 8
// CHECK9-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to double**
// CHECK9-NEXT:    store double* [[TMP35]], double** [[TMP46]], align 8
// CHECK9-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP47]], align 8
// CHECK9-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP49:%.*]] = bitcast i8** [[TMP48]] to double**
// CHECK9-NEXT:    store double* [[TMP36]], double** [[TMP49]], align 8
// CHECK9-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to double**
// CHECK9-NEXT:    store double* [[TMP36]], double** [[TMP51]], align 8
// CHECK9-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP52]], align 8
// CHECK9-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP54:%.*]] = bitcast i8** [[TMP53]] to double**
// CHECK9-NEXT:    store double* [[TMP37]], double** [[TMP54]], align 8
// CHECK9-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP56:%.*]] = bitcast i8** [[TMP55]] to double**
// CHECK9-NEXT:    store double* [[TMP37]], double** [[TMP56]], align 8
// CHECK9-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP57]], align 8
// CHECK9-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP60:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP60]], i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK9-NEXT:    [[TMP61:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK9-NEXT:    [[SUB11:%.*]] = sub nsw i32 [[TMP61]], 0
// CHECK9-NEXT:    [[DIV12:%.*]] = sdiv i32 [[SUB11]], 1
// CHECK9-NEXT:    [[SUB13:%.*]] = sub nsw i32 [[DIV12]], 1
// CHECK9-NEXT:    store i32 [[SUB13]], i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK9-NEXT:    [[TMP62:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK9-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP62]], 1
// CHECK9-NEXT:    [[TMP63:%.*]] = zext i32 [[ADD14]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP63]])
// CHECK9-NEXT:    [[TMP64:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l408.region_id, i32 4, i8** [[TMP58]], i8** [[TMP59]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP65:%.*]] = icmp ne i32 [[TMP64]], 0
// CHECK9-NEXT:    br i1 [[TMP65]], label [[OMP_OFFLOAD_FAILED15:%.*]], label [[OMP_OFFLOAD_CONT16:%.*]]
// CHECK9:       omp_offload.failed15:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l408(i64 [[TMP34]], double* [[TMP35]], double* [[TMP36]], double* [[TMP37]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT16]]
// CHECK9:       omp_offload.cont16:
// CHECK9-NEXT:    [[TMP66:%.*]] = load i32, i32* [[CH]], align 4
// CHECK9-NEXT:    [[CONV17:%.*]] = bitcast i64* [[CH_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP66]], i32* [[CONV17]], align 4
// CHECK9-NEXT:    [[TMP67:%.*]] = load i64, i64* [[CH_CASTED]], align 8
// CHECK9-NEXT:    [[TMP68:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV19:%.*]] = bitcast i64* [[N_CASTED18]] to i32*
// CHECK9-NEXT:    store i32 [[TMP68]], i32* [[CONV19]], align 4
// CHECK9-NEXT:    [[TMP69:%.*]] = load i64, i64* [[N_CASTED18]], align 8
// CHECK9-NEXT:    [[TMP70:%.*]] = load double*, double** [[A]], align 8
// CHECK9-NEXT:    [[TMP71:%.*]] = load double*, double** [[B]], align 8
// CHECK9-NEXT:    [[TMP72:%.*]] = load double*, double** [[C]], align 8
// CHECK9-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP74:%.*]] = bitcast i8** [[TMP73]] to i64*
// CHECK9-NEXT:    store i64 [[TMP67]], i64* [[TMP74]], align 8
// CHECK9-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP76:%.*]] = bitcast i8** [[TMP75]] to i64*
// CHECK9-NEXT:    store i64 [[TMP67]], i64* [[TMP76]], align 8
// CHECK9-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP77]], align 8
// CHECK9-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP79:%.*]] = bitcast i8** [[TMP78]] to i64*
// CHECK9-NEXT:    store i64 [[TMP69]], i64* [[TMP79]], align 8
// CHECK9-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP81:%.*]] = bitcast i8** [[TMP80]] to i64*
// CHECK9-NEXT:    store i64 [[TMP69]], i64* [[TMP81]], align 8
// CHECK9-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP82]], align 8
// CHECK9-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP84:%.*]] = bitcast i8** [[TMP83]] to double**
// CHECK9-NEXT:    store double* [[TMP70]], double** [[TMP84]], align 8
// CHECK9-NEXT:    [[TMP85:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP86:%.*]] = bitcast i8** [[TMP85]] to double**
// CHECK9-NEXT:    store double* [[TMP70]], double** [[TMP86]], align 8
// CHECK9-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP87]], align 8
// CHECK9-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP89:%.*]] = bitcast i8** [[TMP88]] to double**
// CHECK9-NEXT:    store double* [[TMP71]], double** [[TMP89]], align 8
// CHECK9-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to double**
// CHECK9-NEXT:    store double* [[TMP71]], double** [[TMP91]], align 8
// CHECK9-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP92]], align 8
// CHECK9-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP94:%.*]] = bitcast i8** [[TMP93]] to double**
// CHECK9-NEXT:    store double* [[TMP72]], double** [[TMP94]], align 8
// CHECK9-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP96:%.*]] = bitcast i8** [[TMP95]] to double**
// CHECK9-NEXT:    store double* [[TMP72]], double** [[TMP96]], align 8
// CHECK9-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 4
// CHECK9-NEXT:    store i8* null, i8** [[TMP97]], align 8
// CHECK9-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP100:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP100]], i32* [[DOTCAPTURE_EXPR_24]], align 4
// CHECK9-NEXT:    [[TMP101:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_24]], align 4
// CHECK9-NEXT:    [[SUB26:%.*]] = sub nsw i32 [[TMP101]], 0
// CHECK9-NEXT:    [[DIV27:%.*]] = sdiv i32 [[SUB26]], 1
// CHECK9-NEXT:    [[SUB28:%.*]] = sub nsw i32 [[DIV27]], 1
// CHECK9-NEXT:    store i32 [[SUB28]], i32* [[DOTCAPTURE_EXPR_25]], align 4
// CHECK9-NEXT:    [[TMP102:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_25]], align 4
// CHECK9-NEXT:    [[ADD29:%.*]] = add nsw i32 [[TMP102]], 1
// CHECK9-NEXT:    [[TMP103:%.*]] = zext i32 [[ADD29]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP103]])
// CHECK9-NEXT:    [[TMP104:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l447.region_id, i32 5, i8** [[TMP98]], i8** [[TMP99]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP105:%.*]] = icmp ne i32 [[TMP104]], 0
// CHECK9-NEXT:    br i1 [[TMP105]], label [[OMP_OFFLOAD_FAILED30:%.*]], label [[OMP_OFFLOAD_CONT31:%.*]]
// CHECK9:       omp_offload.failed30:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l447(i64 [[TMP67]], i64 [[TMP69]], double* [[TMP70]], double* [[TMP71]], double* [[TMP72]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT31]]
// CHECK9:       omp_offload.cont31:
// CHECK9-NEXT:    [[TMP106:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV33:%.*]] = bitcast i64* [[N_CASTED32]] to i32*
// CHECK9-NEXT:    store i32 [[TMP106]], i32* [[CONV33]], align 4
// CHECK9-NEXT:    [[TMP107:%.*]] = load i64, i64* [[N_CASTED32]], align 8
// CHECK9-NEXT:    [[TMP108:%.*]] = load double*, double** [[A]], align 8
// CHECK9-NEXT:    [[TMP109:%.*]] = load double*, double** [[B]], align 8
// CHECK9-NEXT:    [[TMP110:%.*]] = load double*, double** [[C]], align 8
// CHECK9-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to i64*
// CHECK9-NEXT:    store i64 [[TMP107]], i64* [[TMP112]], align 8
// CHECK9-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to i64*
// CHECK9-NEXT:    store i64 [[TMP107]], i64* [[TMP114]], align 8
// CHECK9-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS36]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP115]], align 8
// CHECK9-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP117:%.*]] = bitcast i8** [[TMP116]] to double**
// CHECK9-NEXT:    store double* [[TMP108]], double** [[TMP117]], align 8
// CHECK9-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP119:%.*]] = bitcast i8** [[TMP118]] to double**
// CHECK9-NEXT:    store double* [[TMP108]], double** [[TMP119]], align 8
// CHECK9-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS36]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP120]], align 8
// CHECK9-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP122:%.*]] = bitcast i8** [[TMP121]] to double**
// CHECK9-NEXT:    store double* [[TMP109]], double** [[TMP122]], align 8
// CHECK9-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP124:%.*]] = bitcast i8** [[TMP123]] to double**
// CHECK9-NEXT:    store double* [[TMP109]], double** [[TMP124]], align 8
// CHECK9-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS36]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP125]], align 8
// CHECK9-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to double**
// CHECK9-NEXT:    store double* [[TMP110]], double** [[TMP127]], align 8
// CHECK9-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP129:%.*]] = bitcast i8** [[TMP128]] to double**
// CHECK9-NEXT:    store double* [[TMP110]], double** [[TMP129]], align 8
// CHECK9-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS36]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP130]], align 8
// CHECK9-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP133:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP133]], i32* [[DOTCAPTURE_EXPR_38]], align 4
// CHECK9-NEXT:    [[TMP134:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_38]], align 4
// CHECK9-NEXT:    [[SUB40:%.*]] = sub nsw i32 [[TMP134]], 0
// CHECK9-NEXT:    [[DIV41:%.*]] = sdiv i32 [[SUB40]], 1
// CHECK9-NEXT:    [[SUB42:%.*]] = sub nsw i32 [[DIV41]], 1
// CHECK9-NEXT:    store i32 [[SUB42]], i32* [[DOTCAPTURE_EXPR_39]], align 4
// CHECK9-NEXT:    [[TMP135:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_39]], align 4
// CHECK9-NEXT:    [[ADD43:%.*]] = add nsw i32 [[TMP135]], 1
// CHECK9-NEXT:    [[TMP136:%.*]] = zext i32 [[ADD43]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP136]])
// CHECK9-NEXT:    [[TMP137:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l478.region_id, i32 4, i8** [[TMP131]], i8** [[TMP132]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.12, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.13, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP138:%.*]] = icmp ne i32 [[TMP137]], 0
// CHECK9-NEXT:    br i1 [[TMP138]], label [[OMP_OFFLOAD_FAILED44:%.*]], label [[OMP_OFFLOAD_CONT45:%.*]]
// CHECK9:       omp_offload.failed44:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l478(i64 [[TMP107]], double* [[TMP108]], double* [[TMP109]], double* [[TMP110]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT45]]
// CHECK9:       omp_offload.cont45:
// CHECK9-NEXT:    [[TMP139:%.*]] = load i32, i32* [[CH]], align 4
// CHECK9-NEXT:    [[CONV47:%.*]] = bitcast i64* [[CH_CASTED46]] to i32*
// CHECK9-NEXT:    store i32 [[TMP139]], i32* [[CONV47]], align 4
// CHECK9-NEXT:    [[TMP140:%.*]] = load i64, i64* [[CH_CASTED46]], align 8
// CHECK9-NEXT:    [[TMP141:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV49:%.*]] = bitcast i64* [[N_CASTED48]] to i32*
// CHECK9-NEXT:    store i32 [[TMP141]], i32* [[CONV49]], align 4
// CHECK9-NEXT:    [[TMP142:%.*]] = load i64, i64* [[N_CASTED48]], align 8
// CHECK9-NEXT:    [[TMP143:%.*]] = load double*, double** [[A]], align 8
// CHECK9-NEXT:    [[TMP144:%.*]] = load double*, double** [[B]], align 8
// CHECK9-NEXT:    [[TMP145:%.*]] = load double*, double** [[C]], align 8
// CHECK9-NEXT:    [[TMP146:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP147:%.*]] = bitcast i8** [[TMP146]] to i64*
// CHECK9-NEXT:    store i64 [[TMP140]], i64* [[TMP147]], align 8
// CHECK9-NEXT:    [[TMP148:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP149:%.*]] = bitcast i8** [[TMP148]] to i64*
// CHECK9-NEXT:    store i64 [[TMP140]], i64* [[TMP149]], align 8
// CHECK9-NEXT:    [[TMP150:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP150]], align 8
// CHECK9-NEXT:    [[TMP151:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP152:%.*]] = bitcast i8** [[TMP151]] to i64*
// CHECK9-NEXT:    store i64 [[TMP142]], i64* [[TMP152]], align 8
// CHECK9-NEXT:    [[TMP153:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP154:%.*]] = bitcast i8** [[TMP153]] to i64*
// CHECK9-NEXT:    store i64 [[TMP142]], i64* [[TMP154]], align 8
// CHECK9-NEXT:    [[TMP155:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP155]], align 8
// CHECK9-NEXT:    [[TMP156:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP157:%.*]] = bitcast i8** [[TMP156]] to double**
// CHECK9-NEXT:    store double* [[TMP143]], double** [[TMP157]], align 8
// CHECK9-NEXT:    [[TMP158:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP159:%.*]] = bitcast i8** [[TMP158]] to double**
// CHECK9-NEXT:    store double* [[TMP143]], double** [[TMP159]], align 8
// CHECK9-NEXT:    [[TMP160:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP160]], align 8
// CHECK9-NEXT:    [[TMP161:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP162:%.*]] = bitcast i8** [[TMP161]] to double**
// CHECK9-NEXT:    store double* [[TMP144]], double** [[TMP162]], align 8
// CHECK9-NEXT:    [[TMP163:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP164:%.*]] = bitcast i8** [[TMP163]] to double**
// CHECK9-NEXT:    store double* [[TMP144]], double** [[TMP164]], align 8
// CHECK9-NEXT:    [[TMP165:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP165]], align 8
// CHECK9-NEXT:    [[TMP166:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP167:%.*]] = bitcast i8** [[TMP166]] to double**
// CHECK9-NEXT:    store double* [[TMP145]], double** [[TMP167]], align 8
// CHECK9-NEXT:    [[TMP168:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP169:%.*]] = bitcast i8** [[TMP168]] to double**
// CHECK9-NEXT:    store double* [[TMP145]], double** [[TMP169]], align 8
// CHECK9-NEXT:    [[TMP170:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 4
// CHECK9-NEXT:    store i8* null, i8** [[TMP170]], align 8
// CHECK9-NEXT:    [[TMP171:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP172:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP173:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP173]], i32* [[DOTCAPTURE_EXPR_54]], align 4
// CHECK9-NEXT:    [[TMP174:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_54]], align 4
// CHECK9-NEXT:    [[SUB56:%.*]] = sub nsw i32 [[TMP174]], 0
// CHECK9-NEXT:    [[DIV57:%.*]] = sdiv i32 [[SUB56]], 1
// CHECK9-NEXT:    [[SUB58:%.*]] = sub nsw i32 [[DIV57]], 1
// CHECK9-NEXT:    store i32 [[SUB58]], i32* [[DOTCAPTURE_EXPR_55]], align 4
// CHECK9-NEXT:    [[TMP175:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_55]], align 4
// CHECK9-NEXT:    [[ADD59:%.*]] = add nsw i32 [[TMP175]], 1
// CHECK9-NEXT:    [[TMP176:%.*]] = zext i32 [[ADD59]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP176]])
// CHECK9-NEXT:    [[TMP177:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l506.region_id, i32 5, i8** [[TMP171]], i8** [[TMP172]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.16, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.17, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP178:%.*]] = icmp ne i32 [[TMP177]], 0
// CHECK9-NEXT:    br i1 [[TMP178]], label [[OMP_OFFLOAD_FAILED60:%.*]], label [[OMP_OFFLOAD_CONT61:%.*]]
// CHECK9:       omp_offload.failed60:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l506(i64 [[TMP140]], i64 [[TMP142]], double* [[TMP143]], double* [[TMP144]], double* [[TMP145]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT61]]
// CHECK9:       omp_offload.cont61:
// CHECK9-NEXT:    [[TMP179:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV63:%.*]] = bitcast i64* [[N_CASTED62]] to i32*
// CHECK9-NEXT:    store i32 [[TMP179]], i32* [[CONV63]], align 4
// CHECK9-NEXT:    [[TMP180:%.*]] = load i64, i64* [[N_CASTED62]], align 8
// CHECK9-NEXT:    [[TMP181:%.*]] = load double*, double** [[A]], align 8
// CHECK9-NEXT:    [[TMP182:%.*]] = load double*, double** [[B]], align 8
// CHECK9-NEXT:    [[TMP183:%.*]] = load double*, double** [[C]], align 8
// CHECK9-NEXT:    [[TMP184:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP185:%.*]] = bitcast i8** [[TMP184]] to i64*
// CHECK9-NEXT:    store i64 [[TMP180]], i64* [[TMP185]], align 8
// CHECK9-NEXT:    [[TMP186:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP187:%.*]] = bitcast i8** [[TMP186]] to i64*
// CHECK9-NEXT:    store i64 [[TMP180]], i64* [[TMP187]], align 8
// CHECK9-NEXT:    [[TMP188:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS66]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP188]], align 8
// CHECK9-NEXT:    [[TMP189:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP190:%.*]] = bitcast i8** [[TMP189]] to double**
// CHECK9-NEXT:    store double* [[TMP181]], double** [[TMP190]], align 8
// CHECK9-NEXT:    [[TMP191:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP192:%.*]] = bitcast i8** [[TMP191]] to double**
// CHECK9-NEXT:    store double* [[TMP181]], double** [[TMP192]], align 8
// CHECK9-NEXT:    [[TMP193:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS66]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP193]], align 8
// CHECK9-NEXT:    [[TMP194:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP195:%.*]] = bitcast i8** [[TMP194]] to double**
// CHECK9-NEXT:    store double* [[TMP182]], double** [[TMP195]], align 8
// CHECK9-NEXT:    [[TMP196:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP197:%.*]] = bitcast i8** [[TMP196]] to double**
// CHECK9-NEXT:    store double* [[TMP182]], double** [[TMP197]], align 8
// CHECK9-NEXT:    [[TMP198:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS66]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP198]], align 8
// CHECK9-NEXT:    [[TMP199:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP200:%.*]] = bitcast i8** [[TMP199]] to double**
// CHECK9-NEXT:    store double* [[TMP183]], double** [[TMP200]], align 8
// CHECK9-NEXT:    [[TMP201:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP202:%.*]] = bitcast i8** [[TMP201]] to double**
// CHECK9-NEXT:    store double* [[TMP183]], double** [[TMP202]], align 8
// CHECK9-NEXT:    [[TMP203:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS66]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP203]], align 8
// CHECK9-NEXT:    [[TMP204:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP205:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP206:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP206]], i32* [[DOTCAPTURE_EXPR_68]], align 4
// CHECK9-NEXT:    [[TMP207:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_68]], align 4
// CHECK9-NEXT:    [[SUB70:%.*]] = sub nsw i32 [[TMP207]], 0
// CHECK9-NEXT:    [[DIV71:%.*]] = sdiv i32 [[SUB70]], 1
// CHECK9-NEXT:    [[SUB72:%.*]] = sub nsw i32 [[DIV71]], 1
// CHECK9-NEXT:    store i32 [[SUB72]], i32* [[DOTCAPTURE_EXPR_69]], align 4
// CHECK9-NEXT:    [[TMP208:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_69]], align 4
// CHECK9-NEXT:    [[ADD73:%.*]] = add nsw i32 [[TMP208]], 1
// CHECK9-NEXT:    [[TMP209:%.*]] = zext i32 [[ADD73]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP209]])
// CHECK9-NEXT:    [[TMP210:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l536.region_id, i32 4, i8** [[TMP204]], i8** [[TMP205]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.20, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.21, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP211:%.*]] = icmp ne i32 [[TMP210]], 0
// CHECK9-NEXT:    br i1 [[TMP211]], label [[OMP_OFFLOAD_FAILED74:%.*]], label [[OMP_OFFLOAD_CONT75:%.*]]
// CHECK9:       omp_offload.failed74:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l536(i64 [[TMP180]], double* [[TMP181]], double* [[TMP182]], double* [[TMP183]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT75]]
// CHECK9:       omp_offload.cont75:
// CHECK9-NEXT:    [[TMP212:%.*]] = load i32, i32* [[CH]], align 4
// CHECK9-NEXT:    [[CONV77:%.*]] = bitcast i64* [[CH_CASTED76]] to i32*
// CHECK9-NEXT:    store i32 [[TMP212]], i32* [[CONV77]], align 4
// CHECK9-NEXT:    [[TMP213:%.*]] = load i64, i64* [[CH_CASTED76]], align 8
// CHECK9-NEXT:    [[TMP214:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV79:%.*]] = bitcast i64* [[N_CASTED78]] to i32*
// CHECK9-NEXT:    store i32 [[TMP214]], i32* [[CONV79]], align 4
// CHECK9-NEXT:    [[TMP215:%.*]] = load i64, i64* [[N_CASTED78]], align 8
// CHECK9-NEXT:    [[TMP216:%.*]] = load double*, double** [[A]], align 8
// CHECK9-NEXT:    [[TMP217:%.*]] = load double*, double** [[B]], align 8
// CHECK9-NEXT:    [[TMP218:%.*]] = load double*, double** [[C]], align 8
// CHECK9-NEXT:    [[TMP219:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP220:%.*]] = bitcast i8** [[TMP219]] to i64*
// CHECK9-NEXT:    store i64 [[TMP213]], i64* [[TMP220]], align 8
// CHECK9-NEXT:    [[TMP221:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP222:%.*]] = bitcast i8** [[TMP221]] to i64*
// CHECK9-NEXT:    store i64 [[TMP213]], i64* [[TMP222]], align 8
// CHECK9-NEXT:    [[TMP223:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP223]], align 8
// CHECK9-NEXT:    [[TMP224:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP225:%.*]] = bitcast i8** [[TMP224]] to i64*
// CHECK9-NEXT:    store i64 [[TMP215]], i64* [[TMP225]], align 8
// CHECK9-NEXT:    [[TMP226:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP227:%.*]] = bitcast i8** [[TMP226]] to i64*
// CHECK9-NEXT:    store i64 [[TMP215]], i64* [[TMP227]], align 8
// CHECK9-NEXT:    [[TMP228:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP228]], align 8
// CHECK9-NEXT:    [[TMP229:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP230:%.*]] = bitcast i8** [[TMP229]] to double**
// CHECK9-NEXT:    store double* [[TMP216]], double** [[TMP230]], align 8
// CHECK9-NEXT:    [[TMP231:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP232:%.*]] = bitcast i8** [[TMP231]] to double**
// CHECK9-NEXT:    store double* [[TMP216]], double** [[TMP232]], align 8
// CHECK9-NEXT:    [[TMP233:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP233]], align 8
// CHECK9-NEXT:    [[TMP234:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP235:%.*]] = bitcast i8** [[TMP234]] to double**
// CHECK9-NEXT:    store double* [[TMP217]], double** [[TMP235]], align 8
// CHECK9-NEXT:    [[TMP236:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP237:%.*]] = bitcast i8** [[TMP236]] to double**
// CHECK9-NEXT:    store double* [[TMP217]], double** [[TMP237]], align 8
// CHECK9-NEXT:    [[TMP238:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP238]], align 8
// CHECK9-NEXT:    [[TMP239:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP240:%.*]] = bitcast i8** [[TMP239]] to double**
// CHECK9-NEXT:    store double* [[TMP218]], double** [[TMP240]], align 8
// CHECK9-NEXT:    [[TMP241:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP242:%.*]] = bitcast i8** [[TMP241]] to double**
// CHECK9-NEXT:    store double* [[TMP218]], double** [[TMP242]], align 8
// CHECK9-NEXT:    [[TMP243:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 4
// CHECK9-NEXT:    store i8* null, i8** [[TMP243]], align 8
// CHECK9-NEXT:    [[TMP244:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP245:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP246:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP246]], i32* [[DOTCAPTURE_EXPR_84]], align 4
// CHECK9-NEXT:    [[TMP247:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_84]], align 4
// CHECK9-NEXT:    [[SUB86:%.*]] = sub nsw i32 [[TMP247]], 0
// CHECK9-NEXT:    [[DIV87:%.*]] = sdiv i32 [[SUB86]], 1
// CHECK9-NEXT:    [[SUB88:%.*]] = sub nsw i32 [[DIV87]], 1
// CHECK9-NEXT:    store i32 [[SUB88]], i32* [[DOTCAPTURE_EXPR_85]], align 4
// CHECK9-NEXT:    [[TMP248:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_85]], align 4
// CHECK9-NEXT:    [[ADD89:%.*]] = add nsw i32 [[TMP248]], 1
// CHECK9-NEXT:    [[TMP249:%.*]] = zext i32 [[ADD89]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP249]])
// CHECK9-NEXT:    [[TMP250:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l562.region_id, i32 5, i8** [[TMP244]], i8** [[TMP245]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.24, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.25, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP251:%.*]] = icmp ne i32 [[TMP250]], 0
// CHECK9-NEXT:    br i1 [[TMP251]], label [[OMP_OFFLOAD_FAILED90:%.*]], label [[OMP_OFFLOAD_CONT91:%.*]]
// CHECK9:       omp_offload.failed90:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l562(i64 [[TMP213]], i64 [[TMP215]], double* [[TMP216]], double* [[TMP217]], double* [[TMP218]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT91]]
// CHECK9:       omp_offload.cont91:
// CHECK9-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z5tmainIiET_v()
// CHECK9-NEXT:    ret i32 [[CALL]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l369
// CHECK9-SAME: (i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK9-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX8]], align 8
// CHECK9-NEXT:    [[ADD9:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM10]]
// CHECK9-NEXT:    store double [[ADD9]], double* [[ARRAYIDX11]], align 8
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l408
// CHECK9-SAME: (i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32* [[CONV]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK9-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX8]], align 8
// CHECK9-NEXT:    [[ADD9:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM10]]
// CHECK9-NEXT:    store double [[ADD9]], double* [[ARRAYIDX11]], align 8
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l447
// CHECK9-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP7]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP9]])
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp slt i32 [[TMP17]], [[ADD]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK9-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK9-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP27]], [[TMP28]]
// CHECK9-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP9:%.*]] = icmp sgt i32 [[TMP29]], [[TMP30]]
// CHECK9-NEXT:    br i1 [[CMP9]], label [[COND_TRUE10:%.*]], label [[COND_FALSE11:%.*]]
// CHECK9:       cond.true10:
// CHECK9-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END12:%.*]]
// CHECK9:       cond.false11:
// CHECK9-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END12]]
// CHECK9:       cond.end12:
// CHECK9-NEXT:    [[COND13:%.*]] = phi i32 [ [[TMP31]], [[COND_TRUE10]] ], [ [[TMP32]], [[COND_FALSE11]] ]
// CHECK9-NEXT:    store i32 [[COND13]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP33]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP34:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP35:%.*]] = load i32, i32* [[TMP34]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP35]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK9-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX8]], align 8
// CHECK9-NEXT:    [[ADD9:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM10]]
// CHECK9-NEXT:    store double [[ADD9]], double* [[ARRAYIDX11]], align 8
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l478
// CHECK9-SAME: (i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i32* [[CONV]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..11 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..11
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK9-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX8]], align 8
// CHECK9-NEXT:    [[ADD9:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM10]]
// CHECK9-NEXT:    store double [[ADD9]], double* [[ARRAYIDX11]], align 8
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l506
// CHECK9-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..14 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..14
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP23]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP24:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**, i64)* @.omp_outlined..15 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]], i64 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP28]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..15
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV5]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP10]])
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK9:       omp.dispatch.cond:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV7:%.*]] = trunc i64 [[TMP14]] to i32
// CHECK9-NEXT:    [[CMP8:%.*]] = icmp sgt i32 [[TMP13]], [[CONV7]]
// CHECK9-NEXT:    br i1 [[CMP8]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV9:%.*]] = trunc i64 [[TMP15]] to i32
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[CONV9]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK9-NEXT:    br i1 [[CMP10]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK9:       omp.dispatch.body:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK9-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I6]], align 4
// CHECK9-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I6]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP23]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX]], align 8
// CHECK9-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I6]], align 4
// CHECK9-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds double, double* [[TMP26]], i64 [[IDXPROM12]]
// CHECK9-NEXT:    [[TMP28:%.*]] = load double, double* [[ARRAYIDX13]], align 8
// CHECK9-NEXT:    [[ADD14:%.*]] = fadd double [[TMP25]], [[TMP28]]
// CHECK9-NEXT:    [[TMP29:%.*]] = load double*, double** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[I6]], align 4
// CHECK9-NEXT:    [[IDXPROM15:%.*]] = sext i32 [[TMP30]] to i64
// CHECK9-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds double, double* [[TMP29]], i64 [[IDXPROM15]]
// CHECK9-NEXT:    store double [[ADD14]], double* [[ARRAYIDX16]], align 8
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP31]], 1
// CHECK9-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK9:       omp.dispatch.inc:
// CHECK9-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP32]], [[TMP33]]
// CHECK9-NEXT:    store i32 [[ADD18]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP34]], [[TMP35]]
// CHECK9-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK9:       omp.dispatch.end:
// CHECK9-NEXT:    [[TMP36:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP37:%.*]] = load i32, i32* [[TMP36]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP37]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l536
// CHECK9-SAME: (i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..18 to void (i32*, i32*, ...)*), i32* [[CONV]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..18
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**)* @.omp_outlined..19 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..19
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK9-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP13]], i32 35, i32 [[TMP10]], i32 [[TMP11]], i32 1, i32 1)
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK9:       omp.dispatch.cond:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP14]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP15]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK9-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK9-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK9:       omp.dispatch.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    [[TMP21:%.*]] = load double*, double** [[TMP2]], align 8, !llvm.access.group !19
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP22]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP21]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP23:%.*]] = load double, double* [[ARRAYIDX]], align 8, !llvm.access.group !19
// CHECK9-NEXT:    [[TMP24:%.*]] = load double*, double** [[TMP3]], align 8, !llvm.access.group !19
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP25]] to i64
// CHECK9-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds double, double* [[TMP24]], i64 [[IDXPROM6]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load double, double* [[ARRAYIDX7]], align 8, !llvm.access.group !19
// CHECK9-NEXT:    [[ADD8:%.*]] = fadd double [[TMP23]], [[TMP26]]
// CHECK9-NEXT:    [[TMP27:%.*]] = load double*, double** [[TMP1]], align 8, !llvm.access.group !19
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP28]] to i64
// CHECK9-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds double, double* [[TMP27]], i64 [[IDXPROM9]]
// CHECK9-NEXT:    store double [[ADD8]], double* [[ARRAYIDX10]], align 8, !llvm.access.group !19
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK9-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !19
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP20:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK9:       omp.dispatch.inc:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK9:       omp.dispatch.end:
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l562
// CHECK9-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store double* [[A]], double** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double* [[B]], double** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double* [[C]], double** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..22 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..22
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP23]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP24:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, double**, double**, double**, i64)* @.omp_outlined..23 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]], i64 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP28]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..23
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], double** noundef nonnull align 8 dereferenceable(8) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV5]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK9-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP14]], i32 35, i32 [[TMP11]], i32 [[TMP12]], i32 1, i32 [[TMP10]])
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK9:       omp.dispatch.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[TMP15]], align 4
// CHECK9-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP16]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK9-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK9-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK9:       omp.dispatch.body:
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK9-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I6]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    [[TMP22:%.*]] = load double*, double** [[TMP2]], align 8, !llvm.access.group !22
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP22]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX]], align 8, !llvm.access.group !22
// CHECK9-NEXT:    [[TMP25:%.*]] = load double*, double** [[TMP3]], align 8, !llvm.access.group !22
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP26]] to i64
// CHECK9-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds double, double* [[TMP25]], i64 [[IDXPROM8]]
// CHECK9-NEXT:    [[TMP27:%.*]] = load double, double* [[ARRAYIDX9]], align 8, !llvm.access.group !22
// CHECK9-NEXT:    [[ADD10:%.*]] = fadd double [[TMP24]], [[TMP27]]
// CHECK9-NEXT:    [[TMP28:%.*]] = load double*, double** [[TMP1]], align 8, !llvm.access.group !22
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    [[IDXPROM11:%.*]] = sext i32 [[TMP29]] to i64
// CHECK9-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds double, double* [[TMP28]], i64 [[IDXPROM11]]
// CHECK9-NEXT:    store double [[ADD10]], double* [[ARRAYIDX12]], align 8, !llvm.access.group !22
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK9-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !22
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP23:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK9:       omp.dispatch.inc:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK9:       omp.dispatch.end:
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK9-SAME: () #[[ATTR3:[0-9]+]] comdat {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[A:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[B:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[C:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[CH:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[N_CASTED3:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[_TMP8:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[CH_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_CASTED18:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS20:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS21:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS22:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[_TMP23:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_24:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_25:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[N_CASTED32:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS34:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS35:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS36:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[_TMP37:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_38:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_39:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[CH_CASTED46:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_CASTED48:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS50:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS51:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS52:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[_TMP53:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_54:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_55:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[N_CASTED62:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS64:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS65:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS66:%.*]] = alloca [4 x i8*], align 8
// CHECK9-NEXT:    [[_TMP67:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_68:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_69:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[CH_CASTED76:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_CASTED78:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS80:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS81:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS82:%.*]] = alloca [5 x i8*], align 8
// CHECK9-NEXT:    [[_TMP83:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_84:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_85:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32 10000, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 100, i32* [[CH]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[B]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[C]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i64*
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[TMP6]], align 8
// CHECK9-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i64*
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[TMP8]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP9]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32**
// CHECK9-NEXT:    store i32* [[TMP2]], i32** [[TMP11]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32**
// CHECK9-NEXT:    store i32* [[TMP2]], i32** [[TMP13]], align 8
// CHECK9-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK9-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32**
// CHECK9-NEXT:    store i32* [[TMP3]], i32** [[TMP16]], align 8
// CHECK9-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32**
// CHECK9-NEXT:    store i32* [[TMP3]], i32** [[TMP18]], align 8
// CHECK9-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK9-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK9-NEXT:    store i32* [[TMP4]], i32** [[TMP21]], align 8
// CHECK9-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32**
// CHECK9-NEXT:    store i32* [[TMP4]], i32** [[TMP23]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK9-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK9-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP30]])
// CHECK9-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l42.region_id, i32 4, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.28, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.29, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK9-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK9:       omp_offload.failed:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l42(i64 [[TMP1]], i32* [[TMP2]], i32* [[TMP3]], i32* [[TMP4]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK9:       omp_offload.cont:
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV4:%.*]] = bitcast i64* [[N_CASTED3]] to i32*
// CHECK9-NEXT:    store i32 [[TMP33]], i32* [[CONV4]], align 4
// CHECK9-NEXT:    [[TMP34:%.*]] = load i64, i64* [[N_CASTED3]], align 8
// CHECK9-NEXT:    [[TMP35:%.*]] = load i32*, i32** [[A]], align 8
// CHECK9-NEXT:    [[TMP36:%.*]] = load i32*, i32** [[B]], align 8
// CHECK9-NEXT:    [[TMP37:%.*]] = load i32*, i32** [[C]], align 8
// CHECK9-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP39:%.*]] = bitcast i8** [[TMP38]] to i64*
// CHECK9-NEXT:    store i64 [[TMP34]], i64* [[TMP39]], align 8
// CHECK9-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to i64*
// CHECK9-NEXT:    store i64 [[TMP34]], i64* [[TMP41]], align 8
// CHECK9-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP42]], align 8
// CHECK9-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP44:%.*]] = bitcast i8** [[TMP43]] to i32**
// CHECK9-NEXT:    store i32* [[TMP35]], i32** [[TMP44]], align 8
// CHECK9-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i32**
// CHECK9-NEXT:    store i32* [[TMP35]], i32** [[TMP46]], align 8
// CHECK9-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP47]], align 8
// CHECK9-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP49:%.*]] = bitcast i8** [[TMP48]] to i32**
// CHECK9-NEXT:    store i32* [[TMP36]], i32** [[TMP49]], align 8
// CHECK9-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to i32**
// CHECK9-NEXT:    store i32* [[TMP36]], i32** [[TMP51]], align 8
// CHECK9-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP52]], align 8
// CHECK9-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP54:%.*]] = bitcast i8** [[TMP53]] to i32**
// CHECK9-NEXT:    store i32* [[TMP37]], i32** [[TMP54]], align 8
// CHECK9-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP56:%.*]] = bitcast i8** [[TMP55]] to i32**
// CHECK9-NEXT:    store i32* [[TMP37]], i32** [[TMP56]], align 8
// CHECK9-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP57]], align 8
// CHECK9-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP60:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP60]], i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK9-NEXT:    [[TMP61:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK9-NEXT:    [[SUB11:%.*]] = sub nsw i32 [[TMP61]], 0
// CHECK9-NEXT:    [[DIV12:%.*]] = sdiv i32 [[SUB11]], 1
// CHECK9-NEXT:    [[SUB13:%.*]] = sub nsw i32 [[DIV12]], 1
// CHECK9-NEXT:    store i32 [[SUB13]], i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK9-NEXT:    [[TMP62:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK9-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP62]], 1
// CHECK9-NEXT:    [[TMP63:%.*]] = zext i32 [[ADD14]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP63]])
// CHECK9-NEXT:    [[TMP64:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l51.region_id, i32 4, i8** [[TMP58]], i8** [[TMP59]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.32, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.33, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP65:%.*]] = icmp ne i32 [[TMP64]], 0
// CHECK9-NEXT:    br i1 [[TMP65]], label [[OMP_OFFLOAD_FAILED15:%.*]], label [[OMP_OFFLOAD_CONT16:%.*]]
// CHECK9:       omp_offload.failed15:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l51(i64 [[TMP34]], i32* [[TMP35]], i32* [[TMP36]], i32* [[TMP37]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT16]]
// CHECK9:       omp_offload.cont16:
// CHECK9-NEXT:    [[TMP66:%.*]] = load i32, i32* [[CH]], align 4
// CHECK9-NEXT:    [[CONV17:%.*]] = bitcast i64* [[CH_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP66]], i32* [[CONV17]], align 4
// CHECK9-NEXT:    [[TMP67:%.*]] = load i64, i64* [[CH_CASTED]], align 8
// CHECK9-NEXT:    [[TMP68:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV19:%.*]] = bitcast i64* [[N_CASTED18]] to i32*
// CHECK9-NEXT:    store i32 [[TMP68]], i32* [[CONV19]], align 4
// CHECK9-NEXT:    [[TMP69:%.*]] = load i64, i64* [[N_CASTED18]], align 8
// CHECK9-NEXT:    [[TMP70:%.*]] = load i32*, i32** [[A]], align 8
// CHECK9-NEXT:    [[TMP71:%.*]] = load i32*, i32** [[B]], align 8
// CHECK9-NEXT:    [[TMP72:%.*]] = load i32*, i32** [[C]], align 8
// CHECK9-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP74:%.*]] = bitcast i8** [[TMP73]] to i64*
// CHECK9-NEXT:    store i64 [[TMP67]], i64* [[TMP74]], align 8
// CHECK9-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP76:%.*]] = bitcast i8** [[TMP75]] to i64*
// CHECK9-NEXT:    store i64 [[TMP67]], i64* [[TMP76]], align 8
// CHECK9-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP77]], align 8
// CHECK9-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP79:%.*]] = bitcast i8** [[TMP78]] to i64*
// CHECK9-NEXT:    store i64 [[TMP69]], i64* [[TMP79]], align 8
// CHECK9-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP81:%.*]] = bitcast i8** [[TMP80]] to i64*
// CHECK9-NEXT:    store i64 [[TMP69]], i64* [[TMP81]], align 8
// CHECK9-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP82]], align 8
// CHECK9-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP84:%.*]] = bitcast i8** [[TMP83]] to i32**
// CHECK9-NEXT:    store i32* [[TMP70]], i32** [[TMP84]], align 8
// CHECK9-NEXT:    [[TMP85:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP86:%.*]] = bitcast i8** [[TMP85]] to i32**
// CHECK9-NEXT:    store i32* [[TMP70]], i32** [[TMP86]], align 8
// CHECK9-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP87]], align 8
// CHECK9-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP89:%.*]] = bitcast i8** [[TMP88]] to i32**
// CHECK9-NEXT:    store i32* [[TMP71]], i32** [[TMP89]], align 8
// CHECK9-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to i32**
// CHECK9-NEXT:    store i32* [[TMP71]], i32** [[TMP91]], align 8
// CHECK9-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP92]], align 8
// CHECK9-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP94:%.*]] = bitcast i8** [[TMP93]] to i32**
// CHECK9-NEXT:    store i32* [[TMP72]], i32** [[TMP94]], align 8
// CHECK9-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP96:%.*]] = bitcast i8** [[TMP95]] to i32**
// CHECK9-NEXT:    store i32* [[TMP72]], i32** [[TMP96]], align 8
// CHECK9-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS22]], i64 0, i64 4
// CHECK9-NEXT:    store i8* null, i8** [[TMP97]], align 8
// CHECK9-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS20]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS21]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP100:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP100]], i32* [[DOTCAPTURE_EXPR_24]], align 4
// CHECK9-NEXT:    [[TMP101:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_24]], align 4
// CHECK9-NEXT:    [[SUB26:%.*]] = sub nsw i32 [[TMP101]], 0
// CHECK9-NEXT:    [[DIV27:%.*]] = sdiv i32 [[SUB26]], 1
// CHECK9-NEXT:    [[SUB28:%.*]] = sub nsw i32 [[DIV27]], 1
// CHECK9-NEXT:    store i32 [[SUB28]], i32* [[DOTCAPTURE_EXPR_25]], align 4
// CHECK9-NEXT:    [[TMP102:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_25]], align 4
// CHECK9-NEXT:    [[ADD29:%.*]] = add nsw i32 [[TMP102]], 1
// CHECK9-NEXT:    [[TMP103:%.*]] = zext i32 [[ADD29]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP103]])
// CHECK9-NEXT:    [[TMP104:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l59.region_id, i32 5, i8** [[TMP98]], i8** [[TMP99]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.36, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.37, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP105:%.*]] = icmp ne i32 [[TMP104]], 0
// CHECK9-NEXT:    br i1 [[TMP105]], label [[OMP_OFFLOAD_FAILED30:%.*]], label [[OMP_OFFLOAD_CONT31:%.*]]
// CHECK9:       omp_offload.failed30:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l59(i64 [[TMP67]], i64 [[TMP69]], i32* [[TMP70]], i32* [[TMP71]], i32* [[TMP72]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT31]]
// CHECK9:       omp_offload.cont31:
// CHECK9-NEXT:    [[TMP106:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV33:%.*]] = bitcast i64* [[N_CASTED32]] to i32*
// CHECK9-NEXT:    store i32 [[TMP106]], i32* [[CONV33]], align 4
// CHECK9-NEXT:    [[TMP107:%.*]] = load i64, i64* [[N_CASTED32]], align 8
// CHECK9-NEXT:    [[TMP108:%.*]] = load i32*, i32** [[A]], align 8
// CHECK9-NEXT:    [[TMP109:%.*]] = load i32*, i32** [[B]], align 8
// CHECK9-NEXT:    [[TMP110:%.*]] = load i32*, i32** [[C]], align 8
// CHECK9-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to i64*
// CHECK9-NEXT:    store i64 [[TMP107]], i64* [[TMP112]], align 8
// CHECK9-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to i64*
// CHECK9-NEXT:    store i64 [[TMP107]], i64* [[TMP114]], align 8
// CHECK9-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS36]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP115]], align 8
// CHECK9-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP117:%.*]] = bitcast i8** [[TMP116]] to i32**
// CHECK9-NEXT:    store i32* [[TMP108]], i32** [[TMP117]], align 8
// CHECK9-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP119:%.*]] = bitcast i8** [[TMP118]] to i32**
// CHECK9-NEXT:    store i32* [[TMP108]], i32** [[TMP119]], align 8
// CHECK9-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS36]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP120]], align 8
// CHECK9-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP122:%.*]] = bitcast i8** [[TMP121]] to i32**
// CHECK9-NEXT:    store i32* [[TMP109]], i32** [[TMP122]], align 8
// CHECK9-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP124:%.*]] = bitcast i8** [[TMP123]] to i32**
// CHECK9-NEXT:    store i32* [[TMP109]], i32** [[TMP124]], align 8
// CHECK9-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS36]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP125]], align 8
// CHECK9-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to i32**
// CHECK9-NEXT:    store i32* [[TMP110]], i32** [[TMP127]], align 8
// CHECK9-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP129:%.*]] = bitcast i8** [[TMP128]] to i32**
// CHECK9-NEXT:    store i32* [[TMP110]], i32** [[TMP129]], align 8
// CHECK9-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS36]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP130]], align 8
// CHECK9-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS34]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS35]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP133:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP133]], i32* [[DOTCAPTURE_EXPR_38]], align 4
// CHECK9-NEXT:    [[TMP134:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_38]], align 4
// CHECK9-NEXT:    [[SUB40:%.*]] = sub nsw i32 [[TMP134]], 0
// CHECK9-NEXT:    [[DIV41:%.*]] = sdiv i32 [[SUB40]], 1
// CHECK9-NEXT:    [[SUB42:%.*]] = sub nsw i32 [[DIV41]], 1
// CHECK9-NEXT:    store i32 [[SUB42]], i32* [[DOTCAPTURE_EXPR_39]], align 4
// CHECK9-NEXT:    [[TMP135:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_39]], align 4
// CHECK9-NEXT:    [[ADD43:%.*]] = add nsw i32 [[TMP135]], 1
// CHECK9-NEXT:    [[TMP136:%.*]] = zext i32 [[ADD43]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP136]])
// CHECK9-NEXT:    [[TMP137:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l67.region_id, i32 4, i8** [[TMP131]], i8** [[TMP132]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.40, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.41, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP138:%.*]] = icmp ne i32 [[TMP137]], 0
// CHECK9-NEXT:    br i1 [[TMP138]], label [[OMP_OFFLOAD_FAILED44:%.*]], label [[OMP_OFFLOAD_CONT45:%.*]]
// CHECK9:       omp_offload.failed44:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l67(i64 [[TMP107]], i32* [[TMP108]], i32* [[TMP109]], i32* [[TMP110]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT45]]
// CHECK9:       omp_offload.cont45:
// CHECK9-NEXT:    [[TMP139:%.*]] = load i32, i32* [[CH]], align 4
// CHECK9-NEXT:    [[CONV47:%.*]] = bitcast i64* [[CH_CASTED46]] to i32*
// CHECK9-NEXT:    store i32 [[TMP139]], i32* [[CONV47]], align 4
// CHECK9-NEXT:    [[TMP140:%.*]] = load i64, i64* [[CH_CASTED46]], align 8
// CHECK9-NEXT:    [[TMP141:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV49:%.*]] = bitcast i64* [[N_CASTED48]] to i32*
// CHECK9-NEXT:    store i32 [[TMP141]], i32* [[CONV49]], align 4
// CHECK9-NEXT:    [[TMP142:%.*]] = load i64, i64* [[N_CASTED48]], align 8
// CHECK9-NEXT:    [[TMP143:%.*]] = load i32*, i32** [[A]], align 8
// CHECK9-NEXT:    [[TMP144:%.*]] = load i32*, i32** [[B]], align 8
// CHECK9-NEXT:    [[TMP145:%.*]] = load i32*, i32** [[C]], align 8
// CHECK9-NEXT:    [[TMP146:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP147:%.*]] = bitcast i8** [[TMP146]] to i64*
// CHECK9-NEXT:    store i64 [[TMP140]], i64* [[TMP147]], align 8
// CHECK9-NEXT:    [[TMP148:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP149:%.*]] = bitcast i8** [[TMP148]] to i64*
// CHECK9-NEXT:    store i64 [[TMP140]], i64* [[TMP149]], align 8
// CHECK9-NEXT:    [[TMP150:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP150]], align 8
// CHECK9-NEXT:    [[TMP151:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP152:%.*]] = bitcast i8** [[TMP151]] to i64*
// CHECK9-NEXT:    store i64 [[TMP142]], i64* [[TMP152]], align 8
// CHECK9-NEXT:    [[TMP153:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP154:%.*]] = bitcast i8** [[TMP153]] to i64*
// CHECK9-NEXT:    store i64 [[TMP142]], i64* [[TMP154]], align 8
// CHECK9-NEXT:    [[TMP155:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP155]], align 8
// CHECK9-NEXT:    [[TMP156:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP157:%.*]] = bitcast i8** [[TMP156]] to i32**
// CHECK9-NEXT:    store i32* [[TMP143]], i32** [[TMP157]], align 8
// CHECK9-NEXT:    [[TMP158:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP159:%.*]] = bitcast i8** [[TMP158]] to i32**
// CHECK9-NEXT:    store i32* [[TMP143]], i32** [[TMP159]], align 8
// CHECK9-NEXT:    [[TMP160:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP160]], align 8
// CHECK9-NEXT:    [[TMP161:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP162:%.*]] = bitcast i8** [[TMP161]] to i32**
// CHECK9-NEXT:    store i32* [[TMP144]], i32** [[TMP162]], align 8
// CHECK9-NEXT:    [[TMP163:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP164:%.*]] = bitcast i8** [[TMP163]] to i32**
// CHECK9-NEXT:    store i32* [[TMP144]], i32** [[TMP164]], align 8
// CHECK9-NEXT:    [[TMP165:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP165]], align 8
// CHECK9-NEXT:    [[TMP166:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP167:%.*]] = bitcast i8** [[TMP166]] to i32**
// CHECK9-NEXT:    store i32* [[TMP145]], i32** [[TMP167]], align 8
// CHECK9-NEXT:    [[TMP168:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP169:%.*]] = bitcast i8** [[TMP168]] to i32**
// CHECK9-NEXT:    store i32* [[TMP145]], i32** [[TMP169]], align 8
// CHECK9-NEXT:    [[TMP170:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS52]], i64 0, i64 4
// CHECK9-NEXT:    store i8* null, i8** [[TMP170]], align 8
// CHECK9-NEXT:    [[TMP171:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS50]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP172:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS51]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP173:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP173]], i32* [[DOTCAPTURE_EXPR_54]], align 4
// CHECK9-NEXT:    [[TMP174:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_54]], align 4
// CHECK9-NEXT:    [[SUB56:%.*]] = sub nsw i32 [[TMP174]], 0
// CHECK9-NEXT:    [[DIV57:%.*]] = sdiv i32 [[SUB56]], 1
// CHECK9-NEXT:    [[SUB58:%.*]] = sub nsw i32 [[DIV57]], 1
// CHECK9-NEXT:    store i32 [[SUB58]], i32* [[DOTCAPTURE_EXPR_55]], align 4
// CHECK9-NEXT:    [[TMP175:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_55]], align 4
// CHECK9-NEXT:    [[ADD59:%.*]] = add nsw i32 [[TMP175]], 1
// CHECK9-NEXT:    [[TMP176:%.*]] = zext i32 [[ADD59]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP176]])
// CHECK9-NEXT:    [[TMP177:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l75.region_id, i32 5, i8** [[TMP171]], i8** [[TMP172]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.44, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.45, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP178:%.*]] = icmp ne i32 [[TMP177]], 0
// CHECK9-NEXT:    br i1 [[TMP178]], label [[OMP_OFFLOAD_FAILED60:%.*]], label [[OMP_OFFLOAD_CONT61:%.*]]
// CHECK9:       omp_offload.failed60:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l75(i64 [[TMP140]], i64 [[TMP142]], i32* [[TMP143]], i32* [[TMP144]], i32* [[TMP145]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT61]]
// CHECK9:       omp_offload.cont61:
// CHECK9-NEXT:    [[TMP179:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV63:%.*]] = bitcast i64* [[N_CASTED62]] to i32*
// CHECK9-NEXT:    store i32 [[TMP179]], i32* [[CONV63]], align 4
// CHECK9-NEXT:    [[TMP180:%.*]] = load i64, i64* [[N_CASTED62]], align 8
// CHECK9-NEXT:    [[TMP181:%.*]] = load i32*, i32** [[A]], align 8
// CHECK9-NEXT:    [[TMP182:%.*]] = load i32*, i32** [[B]], align 8
// CHECK9-NEXT:    [[TMP183:%.*]] = load i32*, i32** [[C]], align 8
// CHECK9-NEXT:    [[TMP184:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP185:%.*]] = bitcast i8** [[TMP184]] to i64*
// CHECK9-NEXT:    store i64 [[TMP180]], i64* [[TMP185]], align 8
// CHECK9-NEXT:    [[TMP186:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP187:%.*]] = bitcast i8** [[TMP186]] to i64*
// CHECK9-NEXT:    store i64 [[TMP180]], i64* [[TMP187]], align 8
// CHECK9-NEXT:    [[TMP188:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS66]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP188]], align 8
// CHECK9-NEXT:    [[TMP189:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP190:%.*]] = bitcast i8** [[TMP189]] to i32**
// CHECK9-NEXT:    store i32* [[TMP181]], i32** [[TMP190]], align 8
// CHECK9-NEXT:    [[TMP191:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP192:%.*]] = bitcast i8** [[TMP191]] to i32**
// CHECK9-NEXT:    store i32* [[TMP181]], i32** [[TMP192]], align 8
// CHECK9-NEXT:    [[TMP193:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS66]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP193]], align 8
// CHECK9-NEXT:    [[TMP194:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP195:%.*]] = bitcast i8** [[TMP194]] to i32**
// CHECK9-NEXT:    store i32* [[TMP182]], i32** [[TMP195]], align 8
// CHECK9-NEXT:    [[TMP196:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP197:%.*]] = bitcast i8** [[TMP196]] to i32**
// CHECK9-NEXT:    store i32* [[TMP182]], i32** [[TMP197]], align 8
// CHECK9-NEXT:    [[TMP198:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS66]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP198]], align 8
// CHECK9-NEXT:    [[TMP199:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP200:%.*]] = bitcast i8** [[TMP199]] to i32**
// CHECK9-NEXT:    store i32* [[TMP183]], i32** [[TMP200]], align 8
// CHECK9-NEXT:    [[TMP201:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP202:%.*]] = bitcast i8** [[TMP201]] to i32**
// CHECK9-NEXT:    store i32* [[TMP183]], i32** [[TMP202]], align 8
// CHECK9-NEXT:    [[TMP203:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS66]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP203]], align 8
// CHECK9-NEXT:    [[TMP204:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS64]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP205:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS65]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP206:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP206]], i32* [[DOTCAPTURE_EXPR_68]], align 4
// CHECK9-NEXT:    [[TMP207:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_68]], align 4
// CHECK9-NEXT:    [[SUB70:%.*]] = sub nsw i32 [[TMP207]], 0
// CHECK9-NEXT:    [[DIV71:%.*]] = sdiv i32 [[SUB70]], 1
// CHECK9-NEXT:    [[SUB72:%.*]] = sub nsw i32 [[DIV71]], 1
// CHECK9-NEXT:    store i32 [[SUB72]], i32* [[DOTCAPTURE_EXPR_69]], align 4
// CHECK9-NEXT:    [[TMP208:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_69]], align 4
// CHECK9-NEXT:    [[ADD73:%.*]] = add nsw i32 [[TMP208]], 1
// CHECK9-NEXT:    [[TMP209:%.*]] = zext i32 [[ADD73]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP209]])
// CHECK9-NEXT:    [[TMP210:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l83.region_id, i32 4, i8** [[TMP204]], i8** [[TMP205]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.48, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.49, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP211:%.*]] = icmp ne i32 [[TMP210]], 0
// CHECK9-NEXT:    br i1 [[TMP211]], label [[OMP_OFFLOAD_FAILED74:%.*]], label [[OMP_OFFLOAD_CONT75:%.*]]
// CHECK9:       omp_offload.failed74:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l83(i64 [[TMP180]], i32* [[TMP181]], i32* [[TMP182]], i32* [[TMP183]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT75]]
// CHECK9:       omp_offload.cont75:
// CHECK9-NEXT:    [[TMP212:%.*]] = load i32, i32* [[CH]], align 4
// CHECK9-NEXT:    [[CONV77:%.*]] = bitcast i64* [[CH_CASTED76]] to i32*
// CHECK9-NEXT:    store i32 [[TMP212]], i32* [[CONV77]], align 4
// CHECK9-NEXT:    [[TMP213:%.*]] = load i64, i64* [[CH_CASTED76]], align 8
// CHECK9-NEXT:    [[TMP214:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV79:%.*]] = bitcast i64* [[N_CASTED78]] to i32*
// CHECK9-NEXT:    store i32 [[TMP214]], i32* [[CONV79]], align 4
// CHECK9-NEXT:    [[TMP215:%.*]] = load i64, i64* [[N_CASTED78]], align 8
// CHECK9-NEXT:    [[TMP216:%.*]] = load i32*, i32** [[A]], align 8
// CHECK9-NEXT:    [[TMP217:%.*]] = load i32*, i32** [[B]], align 8
// CHECK9-NEXT:    [[TMP218:%.*]] = load i32*, i32** [[C]], align 8
// CHECK9-NEXT:    [[TMP219:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP220:%.*]] = bitcast i8** [[TMP219]] to i64*
// CHECK9-NEXT:    store i64 [[TMP213]], i64* [[TMP220]], align 8
// CHECK9-NEXT:    [[TMP221:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP222:%.*]] = bitcast i8** [[TMP221]] to i64*
// CHECK9-NEXT:    store i64 [[TMP213]], i64* [[TMP222]], align 8
// CHECK9-NEXT:    [[TMP223:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP223]], align 8
// CHECK9-NEXT:    [[TMP224:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP225:%.*]] = bitcast i8** [[TMP224]] to i64*
// CHECK9-NEXT:    store i64 [[TMP215]], i64* [[TMP225]], align 8
// CHECK9-NEXT:    [[TMP226:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP227:%.*]] = bitcast i8** [[TMP226]] to i64*
// CHECK9-NEXT:    store i64 [[TMP215]], i64* [[TMP227]], align 8
// CHECK9-NEXT:    [[TMP228:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP228]], align 8
// CHECK9-NEXT:    [[TMP229:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP230:%.*]] = bitcast i8** [[TMP229]] to i32**
// CHECK9-NEXT:    store i32* [[TMP216]], i32** [[TMP230]], align 8
// CHECK9-NEXT:    [[TMP231:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP232:%.*]] = bitcast i8** [[TMP231]] to i32**
// CHECK9-NEXT:    store i32* [[TMP216]], i32** [[TMP232]], align 8
// CHECK9-NEXT:    [[TMP233:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP233]], align 8
// CHECK9-NEXT:    [[TMP234:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP235:%.*]] = bitcast i8** [[TMP234]] to i32**
// CHECK9-NEXT:    store i32* [[TMP217]], i32** [[TMP235]], align 8
// CHECK9-NEXT:    [[TMP236:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 3
// CHECK9-NEXT:    [[TMP237:%.*]] = bitcast i8** [[TMP236]] to i32**
// CHECK9-NEXT:    store i32* [[TMP217]], i32** [[TMP237]], align 8
// CHECK9-NEXT:    [[TMP238:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 3
// CHECK9-NEXT:    store i8* null, i8** [[TMP238]], align 8
// CHECK9-NEXT:    [[TMP239:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP240:%.*]] = bitcast i8** [[TMP239]] to i32**
// CHECK9-NEXT:    store i32* [[TMP218]], i32** [[TMP240]], align 8
// CHECK9-NEXT:    [[TMP241:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 4
// CHECK9-NEXT:    [[TMP242:%.*]] = bitcast i8** [[TMP241]] to i32**
// CHECK9-NEXT:    store i32* [[TMP218]], i32** [[TMP242]], align 8
// CHECK9-NEXT:    [[TMP243:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS82]], i64 0, i64 4
// CHECK9-NEXT:    store i8* null, i8** [[TMP243]], align 8
// CHECK9-NEXT:    [[TMP244:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS80]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP245:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS81]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP246:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP246]], i32* [[DOTCAPTURE_EXPR_84]], align 4
// CHECK9-NEXT:    [[TMP247:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_84]], align 4
// CHECK9-NEXT:    [[SUB86:%.*]] = sub nsw i32 [[TMP247]], 0
// CHECK9-NEXT:    [[DIV87:%.*]] = sdiv i32 [[SUB86]], 1
// CHECK9-NEXT:    [[SUB88:%.*]] = sub nsw i32 [[DIV87]], 1
// CHECK9-NEXT:    store i32 [[SUB88]], i32* [[DOTCAPTURE_EXPR_85]], align 4
// CHECK9-NEXT:    [[TMP248:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_85]], align 4
// CHECK9-NEXT:    [[ADD89:%.*]] = add nsw i32 [[TMP248]], 1
// CHECK9-NEXT:    [[TMP249:%.*]] = zext i32 [[ADD89]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP249]])
// CHECK9-NEXT:    [[TMP250:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l91.region_id, i32 5, i8** [[TMP244]], i8** [[TMP245]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.52, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.53, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK9-NEXT:    [[TMP251:%.*]] = icmp ne i32 [[TMP250]], 0
// CHECK9-NEXT:    br i1 [[TMP251]], label [[OMP_OFFLOAD_FAILED90:%.*]], label [[OMP_OFFLOAD_CONT91:%.*]]
// CHECK9:       omp_offload.failed90:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l91(i64 [[TMP213]], i64 [[TMP215]], i32* [[TMP216]], i32* [[TMP217]], i32* [[TMP218]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT91]]
// CHECK9:       omp_offload.cont91:
// CHECK9-NEXT:    ret i32 0
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l42
// CHECK9-SAME: (i64 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..26 to void (i32*, i32*, ...)*), i32* [[CONV]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..26
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32**, i32**, i32**)* @.omp_outlined..27 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], i32** [[TMP1]], i32** [[TMP2]], i32** [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..27
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_cancel(%struct.ident_t* @[[GLOB3]], i32 [[TMP21]], i32 2)
// CHECK9-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK9-NEXT:    br i1 [[TMP23]], label [[DOTCANCEL_EXIT:%.*]], label [[DOTCANCEL_CONTINUE:%.*]]
// CHECK9:       .cancel.exit:
// CHECK9-NEXT:    br label [[CANCEL_EXIT:%.*]]
// CHECK9:       .cancel.continue:
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP24]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP28]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP27]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[ARRAYIDX8]], align 4
// CHECK9-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP26]], [[TMP29]]
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32*, i32** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP31:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP31]] to i64
// CHECK9-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, i32* [[TMP30]], i64 [[IDXPROM10]]
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[ARRAYIDX11]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       cancel.exit:
// CHECK9-NEXT:    [[TMP35:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP36:%.*]] = load i32, i32* [[TMP35]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP36]])
// CHECK9-NEXT:    br label [[CANCEL_CONT:%.*]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    br label [[CANCEL_CONT]]
// CHECK9:       cancel.cont:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l51
// CHECK9-SAME: (i64 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..30 to void (i32*, i32*, ...)*), i32* [[CONV]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..30
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32**, i32**, i32**)* @.omp_outlined..31 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], i32** [[TMP1]], i32** [[TMP2]], i32** [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..31
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP20]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP23]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[ARRAYIDX8]], align 4
// CHECK9-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP22]], [[TMP25]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, i32* [[TMP26]], i64 [[IDXPROM10]]
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[ARRAYIDX11]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l59
// CHECK9-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..34 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..34
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP7]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP9]])
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp slt i32 [[TMP17]], [[ADD]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32**, i32**, i32**)* @.omp_outlined..35 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], i32** [[TMP2]], i32** [[TMP3]], i32** [[TMP4]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK9-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK9-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP27]], [[TMP28]]
// CHECK9-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP9:%.*]] = icmp sgt i32 [[TMP29]], [[TMP30]]
// CHECK9-NEXT:    br i1 [[CMP9]], label [[COND_TRUE10:%.*]], label [[COND_FALSE11:%.*]]
// CHECK9:       cond.true10:
// CHECK9-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END12:%.*]]
// CHECK9:       cond.false11:
// CHECK9-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END12]]
// CHECK9:       cond.end12:
// CHECK9-NEXT:    [[COND13:%.*]] = phi i32 [ [[TMP31]], [[COND_TRUE10]] ], [ [[TMP32]], [[COND_FALSE11]] ]
// CHECK9-NEXT:    store i32 [[COND13]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP33]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP34:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP35:%.*]] = load i32, i32* [[TMP34]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP35]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..35
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP20]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP23]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[ARRAYIDX8]], align 4
// CHECK9-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP22]], [[TMP25]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, i32* [[TMP26]], i64 [[IDXPROM10]]
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[ARRAYIDX11]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l67
// CHECK9-SAME: (i64 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..38 to void (i32*, i32*, ...)*), i32* [[CONV]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..38
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32**, i32**, i32**)* @.omp_outlined..39 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], i32** [[TMP1]], i32** [[TMP2]], i32** [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..39
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP20]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP23]], i64 [[IDXPROM7]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[ARRAYIDX8]], align 4
// CHECK9-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP22]], [[TMP25]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK9-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, i32* [[TMP26]], i64 [[IDXPROM10]]
// CHECK9-NEXT:    store i32 [[ADD9]], i32* [[ARRAYIDX11]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK9-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l75
// CHECK9-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..42 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..42
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP23]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP24:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32**, i32**, i32**, i64)* @.omp_outlined..43 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], i32** [[TMP2]], i32** [[TMP3]], i32** [[TMP4]], i64 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP28]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..43
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV5]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP10]])
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK9:       omp.dispatch.cond:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV7:%.*]] = trunc i64 [[TMP14]] to i32
// CHECK9-NEXT:    [[CMP8:%.*]] = icmp sgt i32 [[TMP13]], [[CONV7]]
// CHECK9-NEXT:    br i1 [[CMP8]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV9:%.*]] = trunc i64 [[TMP15]] to i32
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[CONV9]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK9-NEXT:    br i1 [[CMP10]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK9:       omp.dispatch.body:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK9-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I6]], align 4
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I6]], align 4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP24]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP23]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I6]], align 4
// CHECK9-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP27]] to i64
// CHECK9-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds i32, i32* [[TMP26]], i64 [[IDXPROM12]]
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[ARRAYIDX13]], align 4
// CHECK9-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP25]], [[TMP28]]
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[TMP1]], align 8
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[I6]], align 4
// CHECK9-NEXT:    [[IDXPROM15:%.*]] = sext i32 [[TMP30]] to i64
// CHECK9-NEXT:    [[ARRAYIDX16:%.*]] = getelementptr inbounds i32, i32* [[TMP29]], i64 [[IDXPROM15]]
// CHECK9-NEXT:    store i32 [[ADD14]], i32* [[ARRAYIDX16]], align 4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP31]], 1
// CHECK9-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK9:       omp.dispatch.inc:
// CHECK9-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP32]], [[TMP33]]
// CHECK9-NEXT:    store i32 [[ADD18]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD19:%.*]] = add nsw i32 [[TMP34]], [[TMP35]]
// CHECK9-NEXT:    store i32 [[ADD19]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK9:       omp.dispatch.end:
// CHECK9-NEXT:    [[TMP36:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP37:%.*]] = load i32, i32* [[TMP36]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP37]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l83
// CHECK9-SAME: (i64 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..46 to void (i32*, i32*, ...)*), i32* [[CONV]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..46
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32**, i32**, i32**)* @.omp_outlined..47 to void (i32*, i32*, ...)*), i64 [[TMP18]], i64 [[TMP20]], i32* [[TMP0]], i32** [[TMP1]], i32** [[TMP2]], i32** [[TMP3]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[TMP23]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..47
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK9-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP13]], i32 35, i32 [[TMP10]], i32 [[TMP11]], i32 1, i32 1)
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK9:       omp.dispatch.cond:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP14]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP15]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK9-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK9-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK9:       omp.dispatch.body:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[TMP2]], align 8, !llvm.access.group !25
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP22]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP21]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[TMP3]], align 8, !llvm.access.group !25
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP25]] to i64
// CHECK9-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i32, i32* [[TMP24]], i64 [[IDXPROM6]]
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[ARRAYIDX7]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP23]], [[TMP26]]
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[TMP1]], align 8, !llvm.access.group !25
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP28]] to i64
// CHECK9-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, i32* [[TMP27]], i64 [[IDXPROM9]]
// CHECK9-NEXT:    store i32 [[ADD8]], i32* [[ARRAYIDX10]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK9-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !25
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP26:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK9:       omp.dispatch.inc:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK9:       omp.dispatch.end:
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l91
// CHECK9-SAME: (i64 noundef [[CH:%.*]], i64 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    store i64 [[CH]], i64* [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[CH_ADDR]] to i32*
// CHECK9-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..50 to void (i32*, i32*, ...)*), i32* [[CONV]], i32* [[CONV1]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..50
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK9-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK9-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP23]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP24:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i32*, i32**, i32**, i32**, i64)* @.omp_outlined..51 to void (i32*, i32*, ...)*), i64 [[TMP20]], i64 [[TMP22]], i32* [[TMP1]], i32** [[TMP2]], i32** [[TMP3]], i32** [[TMP4]], i64 [[TMP24]])
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[TMP27]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP28]])
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..51
// CHECK9-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[A:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[B:%.*]], i32** noundef nonnull align 8 dereferenceable(8) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 8
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i32*
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK9-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP8:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP8]] to i32
// CHECK9-NEXT:    [[TMP9:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK9-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP9]] to i32
// CHECK9-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[CONV5]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK9-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP14]], i32 35, i32 [[TMP11]], i32 [[TMP12]], i32 1, i32 [[TMP10]])
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK9:       omp.dispatch.cond:
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[TMP15]], align 4
// CHECK9-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP16]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK9-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK9-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK9:       omp.dispatch.body:
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK9-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I6]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[TMP22:%.*]] = load i32*, i32** [[TMP2]], align 8, !llvm.access.group !28
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP23]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP22]], i64 [[IDXPROM]]
// CHECK9-NEXT:    [[TMP24:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[TMP3]], align 8, !llvm.access.group !28
// CHECK9-NEXT:    [[TMP26:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[IDXPROM8:%.*]] = sext i32 [[TMP26]] to i64
// CHECK9-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds i32, i32* [[TMP25]], i64 [[IDXPROM8]]
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[ARRAYIDX9]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP24]], [[TMP27]]
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32*, i32** [[TMP1]], align 8, !llvm.access.group !28
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[I6]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[IDXPROM11:%.*]] = sext i32 [[TMP29]] to i64
// CHECK9-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds i32, i32* [[TMP28]], i64 [[IDXPROM11]]
// CHECK9-NEXT:    store i32 [[ADD10]], i32* [[ARRAYIDX12]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK9-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !28
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP29:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK9:       omp.dispatch.inc:
// CHECK9-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK9:       omp.dispatch.end:
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK9-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK9-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@main
// CHECK11-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[B:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[C:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CH:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS4:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS5:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS6:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[_TMP7:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_8:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CH_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED16:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS17:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS18:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS19:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[_TMP20:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_21:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_22:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED29:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS30:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS31:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS32:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[_TMP33:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_34:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_35:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CH_CASTED42:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED43:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS44:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS45:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS46:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[_TMP47:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_48:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_49:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED56:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS57:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS58:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS59:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[_TMP60:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_61:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_62:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CH_CASTED69:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED70:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS71:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS72:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS73:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[_TMP74:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_75:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_76:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK11-NEXT:    store i32 10000, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 100, i32* [[CH]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[N_CASTED]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double*, double** [[A]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double*, double** [[B]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load double*, double** [[C]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i32*
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[TMP6]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP9]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to double**
// CHECK11-NEXT:    store double* [[TMP2]], double** [[TMP11]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to double**
// CHECK11-NEXT:    store double* [[TMP2]], double** [[TMP13]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK11-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to double**
// CHECK11-NEXT:    store double* [[TMP3]], double** [[TMP16]], align 4
// CHECK11-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to double**
// CHECK11-NEXT:    store double* [[TMP3]], double** [[TMP18]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to double**
// CHECK11-NEXT:    store double* [[TMP4]], double** [[TMP21]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to double**
// CHECK11-NEXT:    store double* [[TMP4]], double** [[TMP23]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK11-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK11-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK11-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l369.region_id, i32 4, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK11-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK11:       omp_offload.failed:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l369(i32 [[TMP1]], double* [[TMP2]], double* [[TMP3]], double* [[TMP4]]) #[[ATTR2:[0-9]+]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK11:       omp_offload.cont:
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP33]], i32* [[N_CASTED3]], align 4
// CHECK11-NEXT:    [[TMP34:%.*]] = load i32, i32* [[N_CASTED3]], align 4
// CHECK11-NEXT:    [[TMP35:%.*]] = load double*, double** [[A]], align 4
// CHECK11-NEXT:    [[TMP36:%.*]] = load double*, double** [[B]], align 4
// CHECK11-NEXT:    [[TMP37:%.*]] = load double*, double** [[C]], align 4
// CHECK11-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP39:%.*]] = bitcast i8** [[TMP38]] to i32*
// CHECK11-NEXT:    store i32 [[TMP34]], i32* [[TMP39]], align 4
// CHECK11-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to i32*
// CHECK11-NEXT:    store i32 [[TMP34]], i32* [[TMP41]], align 4
// CHECK11-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP42]], align 4
// CHECK11-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP44:%.*]] = bitcast i8** [[TMP43]] to double**
// CHECK11-NEXT:    store double* [[TMP35]], double** [[TMP44]], align 4
// CHECK11-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to double**
// CHECK11-NEXT:    store double* [[TMP35]], double** [[TMP46]], align 4
// CHECK11-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP47]], align 4
// CHECK11-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP49:%.*]] = bitcast i8** [[TMP48]] to double**
// CHECK11-NEXT:    store double* [[TMP36]], double** [[TMP49]], align 4
// CHECK11-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to double**
// CHECK11-NEXT:    store double* [[TMP36]], double** [[TMP51]], align 4
// CHECK11-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP52]], align 4
// CHECK11-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP54:%.*]] = bitcast i8** [[TMP53]] to double**
// CHECK11-NEXT:    store double* [[TMP37]], double** [[TMP54]], align 4
// CHECK11-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP56:%.*]] = bitcast i8** [[TMP55]] to double**
// CHECK11-NEXT:    store double* [[TMP37]], double** [[TMP56]], align 4
// CHECK11-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP57]], align 4
// CHECK11-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP60:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP60]], i32* [[DOTCAPTURE_EXPR_8]], align 4
// CHECK11-NEXT:    [[TMP61:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_8]], align 4
// CHECK11-NEXT:    [[SUB10:%.*]] = sub nsw i32 [[TMP61]], 0
// CHECK11-NEXT:    [[DIV11:%.*]] = sdiv i32 [[SUB10]], 1
// CHECK11-NEXT:    [[SUB12:%.*]] = sub nsw i32 [[DIV11]], 1
// CHECK11-NEXT:    store i32 [[SUB12]], i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK11-NEXT:    [[TMP62:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK11-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP62]], 1
// CHECK11-NEXT:    [[TMP63:%.*]] = zext i32 [[ADD13]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP63]])
// CHECK11-NEXT:    [[TMP64:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l408.region_id, i32 4, i8** [[TMP58]], i8** [[TMP59]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP65:%.*]] = icmp ne i32 [[TMP64]], 0
// CHECK11-NEXT:    br i1 [[TMP65]], label [[OMP_OFFLOAD_FAILED14:%.*]], label [[OMP_OFFLOAD_CONT15:%.*]]
// CHECK11:       omp_offload.failed14:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l408(i32 [[TMP34]], double* [[TMP35]], double* [[TMP36]], double* [[TMP37]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT15]]
// CHECK11:       omp_offload.cont15:
// CHECK11-NEXT:    [[TMP66:%.*]] = load i32, i32* [[CH]], align 4
// CHECK11-NEXT:    store i32 [[TMP66]], i32* [[CH_CASTED]], align 4
// CHECK11-NEXT:    [[TMP67:%.*]] = load i32, i32* [[CH_CASTED]], align 4
// CHECK11-NEXT:    [[TMP68:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP68]], i32* [[N_CASTED16]], align 4
// CHECK11-NEXT:    [[TMP69:%.*]] = load i32, i32* [[N_CASTED16]], align 4
// CHECK11-NEXT:    [[TMP70:%.*]] = load double*, double** [[A]], align 4
// CHECK11-NEXT:    [[TMP71:%.*]] = load double*, double** [[B]], align 4
// CHECK11-NEXT:    [[TMP72:%.*]] = load double*, double** [[C]], align 4
// CHECK11-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP74:%.*]] = bitcast i8** [[TMP73]] to i32*
// CHECK11-NEXT:    store i32 [[TMP67]], i32* [[TMP74]], align 4
// CHECK11-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP76:%.*]] = bitcast i8** [[TMP75]] to i32*
// CHECK11-NEXT:    store i32 [[TMP67]], i32* [[TMP76]], align 4
// CHECK11-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP77]], align 4
// CHECK11-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP79:%.*]] = bitcast i8** [[TMP78]] to i32*
// CHECK11-NEXT:    store i32 [[TMP69]], i32* [[TMP79]], align 4
// CHECK11-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP81:%.*]] = bitcast i8** [[TMP80]] to i32*
// CHECK11-NEXT:    store i32 [[TMP69]], i32* [[TMP81]], align 4
// CHECK11-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP82]], align 4
// CHECK11-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP84:%.*]] = bitcast i8** [[TMP83]] to double**
// CHECK11-NEXT:    store double* [[TMP70]], double** [[TMP84]], align 4
// CHECK11-NEXT:    [[TMP85:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP86:%.*]] = bitcast i8** [[TMP85]] to double**
// CHECK11-NEXT:    store double* [[TMP70]], double** [[TMP86]], align 4
// CHECK11-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP87]], align 4
// CHECK11-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP89:%.*]] = bitcast i8** [[TMP88]] to double**
// CHECK11-NEXT:    store double* [[TMP71]], double** [[TMP89]], align 4
// CHECK11-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to double**
// CHECK11-NEXT:    store double* [[TMP71]], double** [[TMP91]], align 4
// CHECK11-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP92]], align 4
// CHECK11-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP94:%.*]] = bitcast i8** [[TMP93]] to double**
// CHECK11-NEXT:    store double* [[TMP72]], double** [[TMP94]], align 4
// CHECK11-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP96:%.*]] = bitcast i8** [[TMP95]] to double**
// CHECK11-NEXT:    store double* [[TMP72]], double** [[TMP96]], align 4
// CHECK11-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 4
// CHECK11-NEXT:    store i8* null, i8** [[TMP97]], align 4
// CHECK11-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP100:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP100]], i32* [[DOTCAPTURE_EXPR_21]], align 4
// CHECK11-NEXT:    [[TMP101:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_21]], align 4
// CHECK11-NEXT:    [[SUB23:%.*]] = sub nsw i32 [[TMP101]], 0
// CHECK11-NEXT:    [[DIV24:%.*]] = sdiv i32 [[SUB23]], 1
// CHECK11-NEXT:    [[SUB25:%.*]] = sub nsw i32 [[DIV24]], 1
// CHECK11-NEXT:    store i32 [[SUB25]], i32* [[DOTCAPTURE_EXPR_22]], align 4
// CHECK11-NEXT:    [[TMP102:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_22]], align 4
// CHECK11-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP102]], 1
// CHECK11-NEXT:    [[TMP103:%.*]] = zext i32 [[ADD26]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP103]])
// CHECK11-NEXT:    [[TMP104:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l447.region_id, i32 5, i8** [[TMP98]], i8** [[TMP99]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.8, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.9, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP105:%.*]] = icmp ne i32 [[TMP104]], 0
// CHECK11-NEXT:    br i1 [[TMP105]], label [[OMP_OFFLOAD_FAILED27:%.*]], label [[OMP_OFFLOAD_CONT28:%.*]]
// CHECK11:       omp_offload.failed27:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l447(i32 [[TMP67]], i32 [[TMP69]], double* [[TMP70]], double* [[TMP71]], double* [[TMP72]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT28]]
// CHECK11:       omp_offload.cont28:
// CHECK11-NEXT:    [[TMP106:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP106]], i32* [[N_CASTED29]], align 4
// CHECK11-NEXT:    [[TMP107:%.*]] = load i32, i32* [[N_CASTED29]], align 4
// CHECK11-NEXT:    [[TMP108:%.*]] = load double*, double** [[A]], align 4
// CHECK11-NEXT:    [[TMP109:%.*]] = load double*, double** [[B]], align 4
// CHECK11-NEXT:    [[TMP110:%.*]] = load double*, double** [[C]], align 4
// CHECK11-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to i32*
// CHECK11-NEXT:    store i32 [[TMP107]], i32* [[TMP112]], align 4
// CHECK11-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to i32*
// CHECK11-NEXT:    store i32 [[TMP107]], i32* [[TMP114]], align 4
// CHECK11-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS32]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP115]], align 4
// CHECK11-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP117:%.*]] = bitcast i8** [[TMP116]] to double**
// CHECK11-NEXT:    store double* [[TMP108]], double** [[TMP117]], align 4
// CHECK11-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP119:%.*]] = bitcast i8** [[TMP118]] to double**
// CHECK11-NEXT:    store double* [[TMP108]], double** [[TMP119]], align 4
// CHECK11-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS32]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP120]], align 4
// CHECK11-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP122:%.*]] = bitcast i8** [[TMP121]] to double**
// CHECK11-NEXT:    store double* [[TMP109]], double** [[TMP122]], align 4
// CHECK11-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP124:%.*]] = bitcast i8** [[TMP123]] to double**
// CHECK11-NEXT:    store double* [[TMP109]], double** [[TMP124]], align 4
// CHECK11-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS32]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP125]], align 4
// CHECK11-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to double**
// CHECK11-NEXT:    store double* [[TMP110]], double** [[TMP127]], align 4
// CHECK11-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP129:%.*]] = bitcast i8** [[TMP128]] to double**
// CHECK11-NEXT:    store double* [[TMP110]], double** [[TMP129]], align 4
// CHECK11-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS32]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP130]], align 4
// CHECK11-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP133:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP133]], i32* [[DOTCAPTURE_EXPR_34]], align 4
// CHECK11-NEXT:    [[TMP134:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_34]], align 4
// CHECK11-NEXT:    [[SUB36:%.*]] = sub nsw i32 [[TMP134]], 0
// CHECK11-NEXT:    [[DIV37:%.*]] = sdiv i32 [[SUB36]], 1
// CHECK11-NEXT:    [[SUB38:%.*]] = sub nsw i32 [[DIV37]], 1
// CHECK11-NEXT:    store i32 [[SUB38]], i32* [[DOTCAPTURE_EXPR_35]], align 4
// CHECK11-NEXT:    [[TMP135:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_35]], align 4
// CHECK11-NEXT:    [[ADD39:%.*]] = add nsw i32 [[TMP135]], 1
// CHECK11-NEXT:    [[TMP136:%.*]] = zext i32 [[ADD39]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP136]])
// CHECK11-NEXT:    [[TMP137:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l478.region_id, i32 4, i8** [[TMP131]], i8** [[TMP132]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.12, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.13, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP138:%.*]] = icmp ne i32 [[TMP137]], 0
// CHECK11-NEXT:    br i1 [[TMP138]], label [[OMP_OFFLOAD_FAILED40:%.*]], label [[OMP_OFFLOAD_CONT41:%.*]]
// CHECK11:       omp_offload.failed40:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l478(i32 [[TMP107]], double* [[TMP108]], double* [[TMP109]], double* [[TMP110]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT41]]
// CHECK11:       omp_offload.cont41:
// CHECK11-NEXT:    [[TMP139:%.*]] = load i32, i32* [[CH]], align 4
// CHECK11-NEXT:    store i32 [[TMP139]], i32* [[CH_CASTED42]], align 4
// CHECK11-NEXT:    [[TMP140:%.*]] = load i32, i32* [[CH_CASTED42]], align 4
// CHECK11-NEXT:    [[TMP141:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP141]], i32* [[N_CASTED43]], align 4
// CHECK11-NEXT:    [[TMP142:%.*]] = load i32, i32* [[N_CASTED43]], align 4
// CHECK11-NEXT:    [[TMP143:%.*]] = load double*, double** [[A]], align 4
// CHECK11-NEXT:    [[TMP144:%.*]] = load double*, double** [[B]], align 4
// CHECK11-NEXT:    [[TMP145:%.*]] = load double*, double** [[C]], align 4
// CHECK11-NEXT:    [[TMP146:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP147:%.*]] = bitcast i8** [[TMP146]] to i32*
// CHECK11-NEXT:    store i32 [[TMP140]], i32* [[TMP147]], align 4
// CHECK11-NEXT:    [[TMP148:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP149:%.*]] = bitcast i8** [[TMP148]] to i32*
// CHECK11-NEXT:    store i32 [[TMP140]], i32* [[TMP149]], align 4
// CHECK11-NEXT:    [[TMP150:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP150]], align 4
// CHECK11-NEXT:    [[TMP151:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP152:%.*]] = bitcast i8** [[TMP151]] to i32*
// CHECK11-NEXT:    store i32 [[TMP142]], i32* [[TMP152]], align 4
// CHECK11-NEXT:    [[TMP153:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP154:%.*]] = bitcast i8** [[TMP153]] to i32*
// CHECK11-NEXT:    store i32 [[TMP142]], i32* [[TMP154]], align 4
// CHECK11-NEXT:    [[TMP155:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP155]], align 4
// CHECK11-NEXT:    [[TMP156:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP157:%.*]] = bitcast i8** [[TMP156]] to double**
// CHECK11-NEXT:    store double* [[TMP143]], double** [[TMP157]], align 4
// CHECK11-NEXT:    [[TMP158:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP159:%.*]] = bitcast i8** [[TMP158]] to double**
// CHECK11-NEXT:    store double* [[TMP143]], double** [[TMP159]], align 4
// CHECK11-NEXT:    [[TMP160:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP160]], align 4
// CHECK11-NEXT:    [[TMP161:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP162:%.*]] = bitcast i8** [[TMP161]] to double**
// CHECK11-NEXT:    store double* [[TMP144]], double** [[TMP162]], align 4
// CHECK11-NEXT:    [[TMP163:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP164:%.*]] = bitcast i8** [[TMP163]] to double**
// CHECK11-NEXT:    store double* [[TMP144]], double** [[TMP164]], align 4
// CHECK11-NEXT:    [[TMP165:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP165]], align 4
// CHECK11-NEXT:    [[TMP166:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP167:%.*]] = bitcast i8** [[TMP166]] to double**
// CHECK11-NEXT:    store double* [[TMP145]], double** [[TMP167]], align 4
// CHECK11-NEXT:    [[TMP168:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP169:%.*]] = bitcast i8** [[TMP168]] to double**
// CHECK11-NEXT:    store double* [[TMP145]], double** [[TMP169]], align 4
// CHECK11-NEXT:    [[TMP170:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 4
// CHECK11-NEXT:    store i8* null, i8** [[TMP170]], align 4
// CHECK11-NEXT:    [[TMP171:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP172:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP173:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP173]], i32* [[DOTCAPTURE_EXPR_48]], align 4
// CHECK11-NEXT:    [[TMP174:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_48]], align 4
// CHECK11-NEXT:    [[SUB50:%.*]] = sub nsw i32 [[TMP174]], 0
// CHECK11-NEXT:    [[DIV51:%.*]] = sdiv i32 [[SUB50]], 1
// CHECK11-NEXT:    [[SUB52:%.*]] = sub nsw i32 [[DIV51]], 1
// CHECK11-NEXT:    store i32 [[SUB52]], i32* [[DOTCAPTURE_EXPR_49]], align 4
// CHECK11-NEXT:    [[TMP175:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_49]], align 4
// CHECK11-NEXT:    [[ADD53:%.*]] = add nsw i32 [[TMP175]], 1
// CHECK11-NEXT:    [[TMP176:%.*]] = zext i32 [[ADD53]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP176]])
// CHECK11-NEXT:    [[TMP177:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l506.region_id, i32 5, i8** [[TMP171]], i8** [[TMP172]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.16, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.17, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP178:%.*]] = icmp ne i32 [[TMP177]], 0
// CHECK11-NEXT:    br i1 [[TMP178]], label [[OMP_OFFLOAD_FAILED54:%.*]], label [[OMP_OFFLOAD_CONT55:%.*]]
// CHECK11:       omp_offload.failed54:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l506(i32 [[TMP140]], i32 [[TMP142]], double* [[TMP143]], double* [[TMP144]], double* [[TMP145]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT55]]
// CHECK11:       omp_offload.cont55:
// CHECK11-NEXT:    [[TMP179:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP179]], i32* [[N_CASTED56]], align 4
// CHECK11-NEXT:    [[TMP180:%.*]] = load i32, i32* [[N_CASTED56]], align 4
// CHECK11-NEXT:    [[TMP181:%.*]] = load double*, double** [[A]], align 4
// CHECK11-NEXT:    [[TMP182:%.*]] = load double*, double** [[B]], align 4
// CHECK11-NEXT:    [[TMP183:%.*]] = load double*, double** [[C]], align 4
// CHECK11-NEXT:    [[TMP184:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP185:%.*]] = bitcast i8** [[TMP184]] to i32*
// CHECK11-NEXT:    store i32 [[TMP180]], i32* [[TMP185]], align 4
// CHECK11-NEXT:    [[TMP186:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP187:%.*]] = bitcast i8** [[TMP186]] to i32*
// CHECK11-NEXT:    store i32 [[TMP180]], i32* [[TMP187]], align 4
// CHECK11-NEXT:    [[TMP188:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS59]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP188]], align 4
// CHECK11-NEXT:    [[TMP189:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP190:%.*]] = bitcast i8** [[TMP189]] to double**
// CHECK11-NEXT:    store double* [[TMP181]], double** [[TMP190]], align 4
// CHECK11-NEXT:    [[TMP191:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP192:%.*]] = bitcast i8** [[TMP191]] to double**
// CHECK11-NEXT:    store double* [[TMP181]], double** [[TMP192]], align 4
// CHECK11-NEXT:    [[TMP193:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS59]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP193]], align 4
// CHECK11-NEXT:    [[TMP194:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP195:%.*]] = bitcast i8** [[TMP194]] to double**
// CHECK11-NEXT:    store double* [[TMP182]], double** [[TMP195]], align 4
// CHECK11-NEXT:    [[TMP196:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP197:%.*]] = bitcast i8** [[TMP196]] to double**
// CHECK11-NEXT:    store double* [[TMP182]], double** [[TMP197]], align 4
// CHECK11-NEXT:    [[TMP198:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS59]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP198]], align 4
// CHECK11-NEXT:    [[TMP199:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP200:%.*]] = bitcast i8** [[TMP199]] to double**
// CHECK11-NEXT:    store double* [[TMP183]], double** [[TMP200]], align 4
// CHECK11-NEXT:    [[TMP201:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP202:%.*]] = bitcast i8** [[TMP201]] to double**
// CHECK11-NEXT:    store double* [[TMP183]], double** [[TMP202]], align 4
// CHECK11-NEXT:    [[TMP203:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS59]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP203]], align 4
// CHECK11-NEXT:    [[TMP204:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP205:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP206:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP206]], i32* [[DOTCAPTURE_EXPR_61]], align 4
// CHECK11-NEXT:    [[TMP207:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_61]], align 4
// CHECK11-NEXT:    [[SUB63:%.*]] = sub nsw i32 [[TMP207]], 0
// CHECK11-NEXT:    [[DIV64:%.*]] = sdiv i32 [[SUB63]], 1
// CHECK11-NEXT:    [[SUB65:%.*]] = sub nsw i32 [[DIV64]], 1
// CHECK11-NEXT:    store i32 [[SUB65]], i32* [[DOTCAPTURE_EXPR_62]], align 4
// CHECK11-NEXT:    [[TMP208:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_62]], align 4
// CHECK11-NEXT:    [[ADD66:%.*]] = add nsw i32 [[TMP208]], 1
// CHECK11-NEXT:    [[TMP209:%.*]] = zext i32 [[ADD66]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP209]])
// CHECK11-NEXT:    [[TMP210:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l536.region_id, i32 4, i8** [[TMP204]], i8** [[TMP205]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.20, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.21, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP211:%.*]] = icmp ne i32 [[TMP210]], 0
// CHECK11-NEXT:    br i1 [[TMP211]], label [[OMP_OFFLOAD_FAILED67:%.*]], label [[OMP_OFFLOAD_CONT68:%.*]]
// CHECK11:       omp_offload.failed67:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l536(i32 [[TMP180]], double* [[TMP181]], double* [[TMP182]], double* [[TMP183]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT68]]
// CHECK11:       omp_offload.cont68:
// CHECK11-NEXT:    [[TMP212:%.*]] = load i32, i32* [[CH]], align 4
// CHECK11-NEXT:    store i32 [[TMP212]], i32* [[CH_CASTED69]], align 4
// CHECK11-NEXT:    [[TMP213:%.*]] = load i32, i32* [[CH_CASTED69]], align 4
// CHECK11-NEXT:    [[TMP214:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP214]], i32* [[N_CASTED70]], align 4
// CHECK11-NEXT:    [[TMP215:%.*]] = load i32, i32* [[N_CASTED70]], align 4
// CHECK11-NEXT:    [[TMP216:%.*]] = load double*, double** [[A]], align 4
// CHECK11-NEXT:    [[TMP217:%.*]] = load double*, double** [[B]], align 4
// CHECK11-NEXT:    [[TMP218:%.*]] = load double*, double** [[C]], align 4
// CHECK11-NEXT:    [[TMP219:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP220:%.*]] = bitcast i8** [[TMP219]] to i32*
// CHECK11-NEXT:    store i32 [[TMP213]], i32* [[TMP220]], align 4
// CHECK11-NEXT:    [[TMP221:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP222:%.*]] = bitcast i8** [[TMP221]] to i32*
// CHECK11-NEXT:    store i32 [[TMP213]], i32* [[TMP222]], align 4
// CHECK11-NEXT:    [[TMP223:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP223]], align 4
// CHECK11-NEXT:    [[TMP224:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP225:%.*]] = bitcast i8** [[TMP224]] to i32*
// CHECK11-NEXT:    store i32 [[TMP215]], i32* [[TMP225]], align 4
// CHECK11-NEXT:    [[TMP226:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP227:%.*]] = bitcast i8** [[TMP226]] to i32*
// CHECK11-NEXT:    store i32 [[TMP215]], i32* [[TMP227]], align 4
// CHECK11-NEXT:    [[TMP228:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP228]], align 4
// CHECK11-NEXT:    [[TMP229:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP230:%.*]] = bitcast i8** [[TMP229]] to double**
// CHECK11-NEXT:    store double* [[TMP216]], double** [[TMP230]], align 4
// CHECK11-NEXT:    [[TMP231:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP232:%.*]] = bitcast i8** [[TMP231]] to double**
// CHECK11-NEXT:    store double* [[TMP216]], double** [[TMP232]], align 4
// CHECK11-NEXT:    [[TMP233:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP233]], align 4
// CHECK11-NEXT:    [[TMP234:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP235:%.*]] = bitcast i8** [[TMP234]] to double**
// CHECK11-NEXT:    store double* [[TMP217]], double** [[TMP235]], align 4
// CHECK11-NEXT:    [[TMP236:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP237:%.*]] = bitcast i8** [[TMP236]] to double**
// CHECK11-NEXT:    store double* [[TMP217]], double** [[TMP237]], align 4
// CHECK11-NEXT:    [[TMP238:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP238]], align 4
// CHECK11-NEXT:    [[TMP239:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP240:%.*]] = bitcast i8** [[TMP239]] to double**
// CHECK11-NEXT:    store double* [[TMP218]], double** [[TMP240]], align 4
// CHECK11-NEXT:    [[TMP241:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP242:%.*]] = bitcast i8** [[TMP241]] to double**
// CHECK11-NEXT:    store double* [[TMP218]], double** [[TMP242]], align 4
// CHECK11-NEXT:    [[TMP243:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 4
// CHECK11-NEXT:    store i8* null, i8** [[TMP243]], align 4
// CHECK11-NEXT:    [[TMP244:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP245:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP246:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP246]], i32* [[DOTCAPTURE_EXPR_75]], align 4
// CHECK11-NEXT:    [[TMP247:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_75]], align 4
// CHECK11-NEXT:    [[SUB77:%.*]] = sub nsw i32 [[TMP247]], 0
// CHECK11-NEXT:    [[DIV78:%.*]] = sdiv i32 [[SUB77]], 1
// CHECK11-NEXT:    [[SUB79:%.*]] = sub nsw i32 [[DIV78]], 1
// CHECK11-NEXT:    store i32 [[SUB79]], i32* [[DOTCAPTURE_EXPR_76]], align 4
// CHECK11-NEXT:    [[TMP248:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_76]], align 4
// CHECK11-NEXT:    [[ADD80:%.*]] = add nsw i32 [[TMP248]], 1
// CHECK11-NEXT:    [[TMP249:%.*]] = zext i32 [[ADD80]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP249]])
// CHECK11-NEXT:    [[TMP250:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l562.region_id, i32 5, i8** [[TMP244]], i8** [[TMP245]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.24, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.25, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP251:%.*]] = icmp ne i32 [[TMP250]], 0
// CHECK11-NEXT:    br i1 [[TMP251]], label [[OMP_OFFLOAD_FAILED81:%.*]], label [[OMP_OFFLOAD_CONT82:%.*]]
// CHECK11:       omp_offload.failed81:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l562(i32 [[TMP213]], i32 [[TMP215]], double* [[TMP216]], double* [[TMP217]], double* [[TMP218]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT82]]
// CHECK11:       omp_offload.cont82:
// CHECK11-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK11-NEXT:    ret i32 [[CALL]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l369
// CHECK11-SAME: (i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i32 [[TMP21]]
// CHECK11-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX6]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l408
// CHECK11-SAME: (i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..2 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i32 [[TMP21]]
// CHECK11-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX6]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l447
// CHECK11-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..6 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP7]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP9]])
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp slt i32 [[TMP17]], [[ADD]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..7 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK11-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK11-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP9:%.*]] = icmp sgt i32 [[TMP27]], [[TMP28]]
// CHECK11-NEXT:    br i1 [[CMP9]], label [[COND_TRUE10:%.*]], label [[COND_FALSE11:%.*]]
// CHECK11:       cond.true10:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END12:%.*]]
// CHECK11:       cond.false11:
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END12]]
// CHECK11:       cond.end12:
// CHECK11-NEXT:    [[COND13:%.*]] = phi i32 [ [[TMP29]], [[COND_TRUE10]] ], [ [[TMP30]], [[COND_FALSE11]] ]
// CHECK11-NEXT:    store i32 [[COND13]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP31]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP32:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, i32* [[TMP32]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP33]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i32 [[TMP21]]
// CHECK11-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX6]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l478
// CHECK11-SAME: (i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..10 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..11 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..11
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP20]], i32 [[TMP21]]
// CHECK11-NEXT:    [[TMP22:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX6]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = fadd double [[TMP22]], [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l506
// CHECK11-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..14 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..14
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    store i32 [[TMP21]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**, i32)* @.omp_outlined..15 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..15
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP10]])
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK11:       omp.dispatch.cond:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP13]], [[TMP14]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP15]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK11:       omp.dispatch.body:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK11-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load double*, double** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load double, double* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load double*, double** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    [[TMP28:%.*]] = load double, double* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = fadd double [[TMP25]], [[TMP28]]
// CHECK11-NEXT:    [[TMP29:%.*]] = load double*, double** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[I4]], align 4
// CHECK11-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds double, double* [[TMP29]], i32 [[TMP30]]
// CHECK11-NEXT:    store double [[ADD9]], double* [[ARRAYIDX10]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP31]], 1
// CHECK11-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK11:       omp.dispatch.inc:
// CHECK11-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP32]], [[TMP33]]
// CHECK11-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP34]], [[TMP35]]
// CHECK11-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK11:       omp.dispatch.end:
// CHECK11-NEXT:    [[TMP36:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP37:%.*]] = load i32, i32* [[TMP36]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP37]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l536
// CHECK11-SAME: (i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..18 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..18
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**)* @.omp_outlined..19 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], double** [[TMP1]], double** [[TMP2]], double** [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..19
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK11-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP13]], i32 35, i32 [[TMP10]], i32 [[TMP11]], i32 1, i32 1)
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK11:       omp.dispatch.cond:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP14]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP15]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK11-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK11-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK11:       omp.dispatch.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[TMP21:%.*]] = load double*, double** [[TMP2]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP21]], i32 [[TMP22]]
// CHECK11-NEXT:    [[TMP23:%.*]] = load double, double* [[ARRAYIDX]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[TMP24:%.*]] = load double*, double** [[TMP3]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds double, double* [[TMP24]], i32 [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load double, double* [[ARRAYIDX5]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[ADD6:%.*]] = fadd double [[TMP23]], [[TMP26]]
// CHECK11-NEXT:    [[TMP27:%.*]] = load double*, double** [[TMP1]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds double, double* [[TMP27]], i32 [[TMP28]]
// CHECK11-NEXT:    store double [[ADD6]], double* [[ARRAYIDX7]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK11-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !20
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP21:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK11:       omp.dispatch.inc:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK11:       omp.dispatch.end:
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l562
// CHECK11-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], double* noundef [[A:%.*]], double* noundef [[B:%.*]], double* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store double* [[A]], double** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double* [[B]], double** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double* [[C]], double** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, double**, double**, double**)* @.omp_outlined..22 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], double** [[A_ADDR]], double** [[B_ADDR]], double** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..22
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    store i32 [[TMP21]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, double**, double**, double**, i32)* @.omp_outlined..23 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], double** [[TMP2]], double** [[TMP3]], double** [[TMP4]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..23
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], double** noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca double**, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store double** [[A]], double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store double** [[B]], double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store double** [[C]], double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load double**, double*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load double**, double*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load double**, double*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK11-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP14]], i32 35, i32 [[TMP11]], i32 [[TMP12]], i32 1, i32 [[TMP10]])
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK11:       omp.dispatch.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[TMP15]], align 4
// CHECK11-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP16]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK11-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK11-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK11:       omp.dispatch.body:
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[TMP22:%.*]] = load double*, double** [[TMP2]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, double* [[TMP22]], i32 [[TMP23]]
// CHECK11-NEXT:    [[TMP24:%.*]] = load double, double* [[ARRAYIDX]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[TMP25:%.*]] = load double*, double** [[TMP3]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds double, double* [[TMP25]], i32 [[TMP26]]
// CHECK11-NEXT:    [[TMP27:%.*]] = load double, double* [[ARRAYIDX6]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[ADD7:%.*]] = fadd double [[TMP24]], [[TMP27]]
// CHECK11-NEXT:    [[TMP28:%.*]] = load double*, double** [[TMP1]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, double* [[TMP28]], i32 [[TMP29]]
// CHECK11-NEXT:    store double [[ADD7]], double* [[ARRAYIDX8]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !23
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP24:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK11:       omp.dispatch.inc:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK11:       omp.dispatch.end:
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK11-SAME: () #[[ATTR3:[0-9]+]] comdat {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[A:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[B:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[C:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CH:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS4:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS5:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS6:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[_TMP7:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_8:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CH_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED16:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS17:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS18:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS19:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[_TMP20:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_21:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_22:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED29:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS30:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS31:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS32:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[_TMP33:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_34:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_35:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CH_CASTED42:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED43:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS44:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS45:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS46:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[_TMP47:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_48:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_49:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED56:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS57:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS58:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS59:%.*]] = alloca [4 x i8*], align 4
// CHECK11-NEXT:    [[_TMP60:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_61:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_62:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[CH_CASTED69:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED70:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS71:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS72:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS73:%.*]] = alloca [5 x i8*], align 4
// CHECK11-NEXT:    [[_TMP74:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_75:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_76:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 10000, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 100, i32* [[CH]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[N_CASTED]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[B]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[C]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to i32*
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[TMP6]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to i32*
// CHECK11-NEXT:    store i32 [[TMP1]], i32* [[TMP8]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP9]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32**
// CHECK11-NEXT:    store i32* [[TMP2]], i32** [[TMP11]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32**
// CHECK11-NEXT:    store i32* [[TMP2]], i32** [[TMP13]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK11-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32**
// CHECK11-NEXT:    store i32* [[TMP3]], i32** [[TMP16]], align 4
// CHECK11-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32**
// CHECK11-NEXT:    store i32* [[TMP3]], i32** [[TMP18]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK11-NEXT:    store i32* [[TMP4]], i32** [[TMP21]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32**
// CHECK11-NEXT:    store i32* [[TMP4]], i32** [[TMP23]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK11-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK11-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP30]])
// CHECK11-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l42.region_id, i32 4, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.28, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.29, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK11-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK11:       omp_offload.failed:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l42(i32 [[TMP1]], i32* [[TMP2]], i32* [[TMP3]], i32* [[TMP4]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK11:       omp_offload.cont:
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP33]], i32* [[N_CASTED3]], align 4
// CHECK11-NEXT:    [[TMP34:%.*]] = load i32, i32* [[N_CASTED3]], align 4
// CHECK11-NEXT:    [[TMP35:%.*]] = load i32*, i32** [[A]], align 4
// CHECK11-NEXT:    [[TMP36:%.*]] = load i32*, i32** [[B]], align 4
// CHECK11-NEXT:    [[TMP37:%.*]] = load i32*, i32** [[C]], align 4
// CHECK11-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP39:%.*]] = bitcast i8** [[TMP38]] to i32*
// CHECK11-NEXT:    store i32 [[TMP34]], i32* [[TMP39]], align 4
// CHECK11-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP41:%.*]] = bitcast i8** [[TMP40]] to i32*
// CHECK11-NEXT:    store i32 [[TMP34]], i32* [[TMP41]], align 4
// CHECK11-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP42]], align 4
// CHECK11-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP44:%.*]] = bitcast i8** [[TMP43]] to i32**
// CHECK11-NEXT:    store i32* [[TMP35]], i32** [[TMP44]], align 4
// CHECK11-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i32**
// CHECK11-NEXT:    store i32* [[TMP35]], i32** [[TMP46]], align 4
// CHECK11-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP47]], align 4
// CHECK11-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP49:%.*]] = bitcast i8** [[TMP48]] to i32**
// CHECK11-NEXT:    store i32* [[TMP36]], i32** [[TMP49]], align 4
// CHECK11-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to i32**
// CHECK11-NEXT:    store i32* [[TMP36]], i32** [[TMP51]], align 4
// CHECK11-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP52]], align 4
// CHECK11-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP54:%.*]] = bitcast i8** [[TMP53]] to i32**
// CHECK11-NEXT:    store i32* [[TMP37]], i32** [[TMP54]], align 4
// CHECK11-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP56:%.*]] = bitcast i8** [[TMP55]] to i32**
// CHECK11-NEXT:    store i32* [[TMP37]], i32** [[TMP56]], align 4
// CHECK11-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP57]], align 4
// CHECK11-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS5]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP60:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP60]], i32* [[DOTCAPTURE_EXPR_8]], align 4
// CHECK11-NEXT:    [[TMP61:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_8]], align 4
// CHECK11-NEXT:    [[SUB10:%.*]] = sub nsw i32 [[TMP61]], 0
// CHECK11-NEXT:    [[DIV11:%.*]] = sdiv i32 [[SUB10]], 1
// CHECK11-NEXT:    [[SUB12:%.*]] = sub nsw i32 [[DIV11]], 1
// CHECK11-NEXT:    store i32 [[SUB12]], i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK11-NEXT:    [[TMP62:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK11-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP62]], 1
// CHECK11-NEXT:    [[TMP63:%.*]] = zext i32 [[ADD13]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP63]])
// CHECK11-NEXT:    [[TMP64:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l51.region_id, i32 4, i8** [[TMP58]], i8** [[TMP59]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.32, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.33, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP65:%.*]] = icmp ne i32 [[TMP64]], 0
// CHECK11-NEXT:    br i1 [[TMP65]], label [[OMP_OFFLOAD_FAILED14:%.*]], label [[OMP_OFFLOAD_CONT15:%.*]]
// CHECK11:       omp_offload.failed14:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l51(i32 [[TMP34]], i32* [[TMP35]], i32* [[TMP36]], i32* [[TMP37]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT15]]
// CHECK11:       omp_offload.cont15:
// CHECK11-NEXT:    [[TMP66:%.*]] = load i32, i32* [[CH]], align 4
// CHECK11-NEXT:    store i32 [[TMP66]], i32* [[CH_CASTED]], align 4
// CHECK11-NEXT:    [[TMP67:%.*]] = load i32, i32* [[CH_CASTED]], align 4
// CHECK11-NEXT:    [[TMP68:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP68]], i32* [[N_CASTED16]], align 4
// CHECK11-NEXT:    [[TMP69:%.*]] = load i32, i32* [[N_CASTED16]], align 4
// CHECK11-NEXT:    [[TMP70:%.*]] = load i32*, i32** [[A]], align 4
// CHECK11-NEXT:    [[TMP71:%.*]] = load i32*, i32** [[B]], align 4
// CHECK11-NEXT:    [[TMP72:%.*]] = load i32*, i32** [[C]], align 4
// CHECK11-NEXT:    [[TMP73:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP74:%.*]] = bitcast i8** [[TMP73]] to i32*
// CHECK11-NEXT:    store i32 [[TMP67]], i32* [[TMP74]], align 4
// CHECK11-NEXT:    [[TMP75:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP76:%.*]] = bitcast i8** [[TMP75]] to i32*
// CHECK11-NEXT:    store i32 [[TMP67]], i32* [[TMP76]], align 4
// CHECK11-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP77]], align 4
// CHECK11-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP79:%.*]] = bitcast i8** [[TMP78]] to i32*
// CHECK11-NEXT:    store i32 [[TMP69]], i32* [[TMP79]], align 4
// CHECK11-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP81:%.*]] = bitcast i8** [[TMP80]] to i32*
// CHECK11-NEXT:    store i32 [[TMP69]], i32* [[TMP81]], align 4
// CHECK11-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP82]], align 4
// CHECK11-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP84:%.*]] = bitcast i8** [[TMP83]] to i32**
// CHECK11-NEXT:    store i32* [[TMP70]], i32** [[TMP84]], align 4
// CHECK11-NEXT:    [[TMP85:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP86:%.*]] = bitcast i8** [[TMP85]] to i32**
// CHECK11-NEXT:    store i32* [[TMP70]], i32** [[TMP86]], align 4
// CHECK11-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP87]], align 4
// CHECK11-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP89:%.*]] = bitcast i8** [[TMP88]] to i32**
// CHECK11-NEXT:    store i32* [[TMP71]], i32** [[TMP89]], align 4
// CHECK11-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP91:%.*]] = bitcast i8** [[TMP90]] to i32**
// CHECK11-NEXT:    store i32* [[TMP71]], i32** [[TMP91]], align 4
// CHECK11-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP92]], align 4
// CHECK11-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP94:%.*]] = bitcast i8** [[TMP93]] to i32**
// CHECK11-NEXT:    store i32* [[TMP72]], i32** [[TMP94]], align 4
// CHECK11-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP96:%.*]] = bitcast i8** [[TMP95]] to i32**
// CHECK11-NEXT:    store i32* [[TMP72]], i32** [[TMP96]], align 4
// CHECK11-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 4
// CHECK11-NEXT:    store i8* null, i8** [[TMP97]], align 4
// CHECK11-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS18]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP100:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP100]], i32* [[DOTCAPTURE_EXPR_21]], align 4
// CHECK11-NEXT:    [[TMP101:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_21]], align 4
// CHECK11-NEXT:    [[SUB23:%.*]] = sub nsw i32 [[TMP101]], 0
// CHECK11-NEXT:    [[DIV24:%.*]] = sdiv i32 [[SUB23]], 1
// CHECK11-NEXT:    [[SUB25:%.*]] = sub nsw i32 [[DIV24]], 1
// CHECK11-NEXT:    store i32 [[SUB25]], i32* [[DOTCAPTURE_EXPR_22]], align 4
// CHECK11-NEXT:    [[TMP102:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_22]], align 4
// CHECK11-NEXT:    [[ADD26:%.*]] = add nsw i32 [[TMP102]], 1
// CHECK11-NEXT:    [[TMP103:%.*]] = zext i32 [[ADD26]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP103]])
// CHECK11-NEXT:    [[TMP104:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l59.region_id, i32 5, i8** [[TMP98]], i8** [[TMP99]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.36, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.37, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP105:%.*]] = icmp ne i32 [[TMP104]], 0
// CHECK11-NEXT:    br i1 [[TMP105]], label [[OMP_OFFLOAD_FAILED27:%.*]], label [[OMP_OFFLOAD_CONT28:%.*]]
// CHECK11:       omp_offload.failed27:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l59(i32 [[TMP67]], i32 [[TMP69]], i32* [[TMP70]], i32* [[TMP71]], i32* [[TMP72]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT28]]
// CHECK11:       omp_offload.cont28:
// CHECK11-NEXT:    [[TMP106:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP106]], i32* [[N_CASTED29]], align 4
// CHECK11-NEXT:    [[TMP107:%.*]] = load i32, i32* [[N_CASTED29]], align 4
// CHECK11-NEXT:    [[TMP108:%.*]] = load i32*, i32** [[A]], align 4
// CHECK11-NEXT:    [[TMP109:%.*]] = load i32*, i32** [[B]], align 4
// CHECK11-NEXT:    [[TMP110:%.*]] = load i32*, i32** [[C]], align 4
// CHECK11-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP112:%.*]] = bitcast i8** [[TMP111]] to i32*
// CHECK11-NEXT:    store i32 [[TMP107]], i32* [[TMP112]], align 4
// CHECK11-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP114:%.*]] = bitcast i8** [[TMP113]] to i32*
// CHECK11-NEXT:    store i32 [[TMP107]], i32* [[TMP114]], align 4
// CHECK11-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS32]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP115]], align 4
// CHECK11-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP117:%.*]] = bitcast i8** [[TMP116]] to i32**
// CHECK11-NEXT:    store i32* [[TMP108]], i32** [[TMP117]], align 4
// CHECK11-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP119:%.*]] = bitcast i8** [[TMP118]] to i32**
// CHECK11-NEXT:    store i32* [[TMP108]], i32** [[TMP119]], align 4
// CHECK11-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS32]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP120]], align 4
// CHECK11-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP122:%.*]] = bitcast i8** [[TMP121]] to i32**
// CHECK11-NEXT:    store i32* [[TMP109]], i32** [[TMP122]], align 4
// CHECK11-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP124:%.*]] = bitcast i8** [[TMP123]] to i32**
// CHECK11-NEXT:    store i32* [[TMP109]], i32** [[TMP124]], align 4
// CHECK11-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS32]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP125]], align 4
// CHECK11-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP127:%.*]] = bitcast i8** [[TMP126]] to i32**
// CHECK11-NEXT:    store i32* [[TMP110]], i32** [[TMP127]], align 4
// CHECK11-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP129:%.*]] = bitcast i8** [[TMP128]] to i32**
// CHECK11-NEXT:    store i32* [[TMP110]], i32** [[TMP129]], align 4
// CHECK11-NEXT:    [[TMP130:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS32]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP130]], align 4
// CHECK11-NEXT:    [[TMP131:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS30]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP132:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS31]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP133:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP133]], i32* [[DOTCAPTURE_EXPR_34]], align 4
// CHECK11-NEXT:    [[TMP134:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_34]], align 4
// CHECK11-NEXT:    [[SUB36:%.*]] = sub nsw i32 [[TMP134]], 0
// CHECK11-NEXT:    [[DIV37:%.*]] = sdiv i32 [[SUB36]], 1
// CHECK11-NEXT:    [[SUB38:%.*]] = sub nsw i32 [[DIV37]], 1
// CHECK11-NEXT:    store i32 [[SUB38]], i32* [[DOTCAPTURE_EXPR_35]], align 4
// CHECK11-NEXT:    [[TMP135:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_35]], align 4
// CHECK11-NEXT:    [[ADD39:%.*]] = add nsw i32 [[TMP135]], 1
// CHECK11-NEXT:    [[TMP136:%.*]] = zext i32 [[ADD39]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP136]])
// CHECK11-NEXT:    [[TMP137:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l67.region_id, i32 4, i8** [[TMP131]], i8** [[TMP132]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.40, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.41, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP138:%.*]] = icmp ne i32 [[TMP137]], 0
// CHECK11-NEXT:    br i1 [[TMP138]], label [[OMP_OFFLOAD_FAILED40:%.*]], label [[OMP_OFFLOAD_CONT41:%.*]]
// CHECK11:       omp_offload.failed40:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l67(i32 [[TMP107]], i32* [[TMP108]], i32* [[TMP109]], i32* [[TMP110]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT41]]
// CHECK11:       omp_offload.cont41:
// CHECK11-NEXT:    [[TMP139:%.*]] = load i32, i32* [[CH]], align 4
// CHECK11-NEXT:    store i32 [[TMP139]], i32* [[CH_CASTED42]], align 4
// CHECK11-NEXT:    [[TMP140:%.*]] = load i32, i32* [[CH_CASTED42]], align 4
// CHECK11-NEXT:    [[TMP141:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP141]], i32* [[N_CASTED43]], align 4
// CHECK11-NEXT:    [[TMP142:%.*]] = load i32, i32* [[N_CASTED43]], align 4
// CHECK11-NEXT:    [[TMP143:%.*]] = load i32*, i32** [[A]], align 4
// CHECK11-NEXT:    [[TMP144:%.*]] = load i32*, i32** [[B]], align 4
// CHECK11-NEXT:    [[TMP145:%.*]] = load i32*, i32** [[C]], align 4
// CHECK11-NEXT:    [[TMP146:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP147:%.*]] = bitcast i8** [[TMP146]] to i32*
// CHECK11-NEXT:    store i32 [[TMP140]], i32* [[TMP147]], align 4
// CHECK11-NEXT:    [[TMP148:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP149:%.*]] = bitcast i8** [[TMP148]] to i32*
// CHECK11-NEXT:    store i32 [[TMP140]], i32* [[TMP149]], align 4
// CHECK11-NEXT:    [[TMP150:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP150]], align 4
// CHECK11-NEXT:    [[TMP151:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP152:%.*]] = bitcast i8** [[TMP151]] to i32*
// CHECK11-NEXT:    store i32 [[TMP142]], i32* [[TMP152]], align 4
// CHECK11-NEXT:    [[TMP153:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP154:%.*]] = bitcast i8** [[TMP153]] to i32*
// CHECK11-NEXT:    store i32 [[TMP142]], i32* [[TMP154]], align 4
// CHECK11-NEXT:    [[TMP155:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP155]], align 4
// CHECK11-NEXT:    [[TMP156:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP157:%.*]] = bitcast i8** [[TMP156]] to i32**
// CHECK11-NEXT:    store i32* [[TMP143]], i32** [[TMP157]], align 4
// CHECK11-NEXT:    [[TMP158:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP159:%.*]] = bitcast i8** [[TMP158]] to i32**
// CHECK11-NEXT:    store i32* [[TMP143]], i32** [[TMP159]], align 4
// CHECK11-NEXT:    [[TMP160:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP160]], align 4
// CHECK11-NEXT:    [[TMP161:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP162:%.*]] = bitcast i8** [[TMP161]] to i32**
// CHECK11-NEXT:    store i32* [[TMP144]], i32** [[TMP162]], align 4
// CHECK11-NEXT:    [[TMP163:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP164:%.*]] = bitcast i8** [[TMP163]] to i32**
// CHECK11-NEXT:    store i32* [[TMP144]], i32** [[TMP164]], align 4
// CHECK11-NEXT:    [[TMP165:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP165]], align 4
// CHECK11-NEXT:    [[TMP166:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP167:%.*]] = bitcast i8** [[TMP166]] to i32**
// CHECK11-NEXT:    store i32* [[TMP145]], i32** [[TMP167]], align 4
// CHECK11-NEXT:    [[TMP168:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP169:%.*]] = bitcast i8** [[TMP168]] to i32**
// CHECK11-NEXT:    store i32* [[TMP145]], i32** [[TMP169]], align 4
// CHECK11-NEXT:    [[TMP170:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS46]], i32 0, i32 4
// CHECK11-NEXT:    store i8* null, i8** [[TMP170]], align 4
// CHECK11-NEXT:    [[TMP171:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS44]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP172:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS45]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP173:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP173]], i32* [[DOTCAPTURE_EXPR_48]], align 4
// CHECK11-NEXT:    [[TMP174:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_48]], align 4
// CHECK11-NEXT:    [[SUB50:%.*]] = sub nsw i32 [[TMP174]], 0
// CHECK11-NEXT:    [[DIV51:%.*]] = sdiv i32 [[SUB50]], 1
// CHECK11-NEXT:    [[SUB52:%.*]] = sub nsw i32 [[DIV51]], 1
// CHECK11-NEXT:    store i32 [[SUB52]], i32* [[DOTCAPTURE_EXPR_49]], align 4
// CHECK11-NEXT:    [[TMP175:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_49]], align 4
// CHECK11-NEXT:    [[ADD53:%.*]] = add nsw i32 [[TMP175]], 1
// CHECK11-NEXT:    [[TMP176:%.*]] = zext i32 [[ADD53]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP176]])
// CHECK11-NEXT:    [[TMP177:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l75.region_id, i32 5, i8** [[TMP171]], i8** [[TMP172]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.44, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.45, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP178:%.*]] = icmp ne i32 [[TMP177]], 0
// CHECK11-NEXT:    br i1 [[TMP178]], label [[OMP_OFFLOAD_FAILED54:%.*]], label [[OMP_OFFLOAD_CONT55:%.*]]
// CHECK11:       omp_offload.failed54:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l75(i32 [[TMP140]], i32 [[TMP142]], i32* [[TMP143]], i32* [[TMP144]], i32* [[TMP145]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT55]]
// CHECK11:       omp_offload.cont55:
// CHECK11-NEXT:    [[TMP179:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP179]], i32* [[N_CASTED56]], align 4
// CHECK11-NEXT:    [[TMP180:%.*]] = load i32, i32* [[N_CASTED56]], align 4
// CHECK11-NEXT:    [[TMP181:%.*]] = load i32*, i32** [[A]], align 4
// CHECK11-NEXT:    [[TMP182:%.*]] = load i32*, i32** [[B]], align 4
// CHECK11-NEXT:    [[TMP183:%.*]] = load i32*, i32** [[C]], align 4
// CHECK11-NEXT:    [[TMP184:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP185:%.*]] = bitcast i8** [[TMP184]] to i32*
// CHECK11-NEXT:    store i32 [[TMP180]], i32* [[TMP185]], align 4
// CHECK11-NEXT:    [[TMP186:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP187:%.*]] = bitcast i8** [[TMP186]] to i32*
// CHECK11-NEXT:    store i32 [[TMP180]], i32* [[TMP187]], align 4
// CHECK11-NEXT:    [[TMP188:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS59]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP188]], align 4
// CHECK11-NEXT:    [[TMP189:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP190:%.*]] = bitcast i8** [[TMP189]] to i32**
// CHECK11-NEXT:    store i32* [[TMP181]], i32** [[TMP190]], align 4
// CHECK11-NEXT:    [[TMP191:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP192:%.*]] = bitcast i8** [[TMP191]] to i32**
// CHECK11-NEXT:    store i32* [[TMP181]], i32** [[TMP192]], align 4
// CHECK11-NEXT:    [[TMP193:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS59]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP193]], align 4
// CHECK11-NEXT:    [[TMP194:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP195:%.*]] = bitcast i8** [[TMP194]] to i32**
// CHECK11-NEXT:    store i32* [[TMP182]], i32** [[TMP195]], align 4
// CHECK11-NEXT:    [[TMP196:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP197:%.*]] = bitcast i8** [[TMP196]] to i32**
// CHECK11-NEXT:    store i32* [[TMP182]], i32** [[TMP197]], align 4
// CHECK11-NEXT:    [[TMP198:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS59]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP198]], align 4
// CHECK11-NEXT:    [[TMP199:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP200:%.*]] = bitcast i8** [[TMP199]] to i32**
// CHECK11-NEXT:    store i32* [[TMP183]], i32** [[TMP200]], align 4
// CHECK11-NEXT:    [[TMP201:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP202:%.*]] = bitcast i8** [[TMP201]] to i32**
// CHECK11-NEXT:    store i32* [[TMP183]], i32** [[TMP202]], align 4
// CHECK11-NEXT:    [[TMP203:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS59]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP203]], align 4
// CHECK11-NEXT:    [[TMP204:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS57]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP205:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS58]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP206:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP206]], i32* [[DOTCAPTURE_EXPR_61]], align 4
// CHECK11-NEXT:    [[TMP207:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_61]], align 4
// CHECK11-NEXT:    [[SUB63:%.*]] = sub nsw i32 [[TMP207]], 0
// CHECK11-NEXT:    [[DIV64:%.*]] = sdiv i32 [[SUB63]], 1
// CHECK11-NEXT:    [[SUB65:%.*]] = sub nsw i32 [[DIV64]], 1
// CHECK11-NEXT:    store i32 [[SUB65]], i32* [[DOTCAPTURE_EXPR_62]], align 4
// CHECK11-NEXT:    [[TMP208:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_62]], align 4
// CHECK11-NEXT:    [[ADD66:%.*]] = add nsw i32 [[TMP208]], 1
// CHECK11-NEXT:    [[TMP209:%.*]] = zext i32 [[ADD66]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP209]])
// CHECK11-NEXT:    [[TMP210:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l83.region_id, i32 4, i8** [[TMP204]], i8** [[TMP205]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.48, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.49, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP211:%.*]] = icmp ne i32 [[TMP210]], 0
// CHECK11-NEXT:    br i1 [[TMP211]], label [[OMP_OFFLOAD_FAILED67:%.*]], label [[OMP_OFFLOAD_CONT68:%.*]]
// CHECK11:       omp_offload.failed67:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l83(i32 [[TMP180]], i32* [[TMP181]], i32* [[TMP182]], i32* [[TMP183]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT68]]
// CHECK11:       omp_offload.cont68:
// CHECK11-NEXT:    [[TMP212:%.*]] = load i32, i32* [[CH]], align 4
// CHECK11-NEXT:    store i32 [[TMP212]], i32* [[CH_CASTED69]], align 4
// CHECK11-NEXT:    [[TMP213:%.*]] = load i32, i32* [[CH_CASTED69]], align 4
// CHECK11-NEXT:    [[TMP214:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP214]], i32* [[N_CASTED70]], align 4
// CHECK11-NEXT:    [[TMP215:%.*]] = load i32, i32* [[N_CASTED70]], align 4
// CHECK11-NEXT:    [[TMP216:%.*]] = load i32*, i32** [[A]], align 4
// CHECK11-NEXT:    [[TMP217:%.*]] = load i32*, i32** [[B]], align 4
// CHECK11-NEXT:    [[TMP218:%.*]] = load i32*, i32** [[C]], align 4
// CHECK11-NEXT:    [[TMP219:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP220:%.*]] = bitcast i8** [[TMP219]] to i32*
// CHECK11-NEXT:    store i32 [[TMP213]], i32* [[TMP220]], align 4
// CHECK11-NEXT:    [[TMP221:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP222:%.*]] = bitcast i8** [[TMP221]] to i32*
// CHECK11-NEXT:    store i32 [[TMP213]], i32* [[TMP222]], align 4
// CHECK11-NEXT:    [[TMP223:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP223]], align 4
// CHECK11-NEXT:    [[TMP224:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP225:%.*]] = bitcast i8** [[TMP224]] to i32*
// CHECK11-NEXT:    store i32 [[TMP215]], i32* [[TMP225]], align 4
// CHECK11-NEXT:    [[TMP226:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP227:%.*]] = bitcast i8** [[TMP226]] to i32*
// CHECK11-NEXT:    store i32 [[TMP215]], i32* [[TMP227]], align 4
// CHECK11-NEXT:    [[TMP228:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP228]], align 4
// CHECK11-NEXT:    [[TMP229:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP230:%.*]] = bitcast i8** [[TMP229]] to i32**
// CHECK11-NEXT:    store i32* [[TMP216]], i32** [[TMP230]], align 4
// CHECK11-NEXT:    [[TMP231:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP232:%.*]] = bitcast i8** [[TMP231]] to i32**
// CHECK11-NEXT:    store i32* [[TMP216]], i32** [[TMP232]], align 4
// CHECK11-NEXT:    [[TMP233:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP233]], align 4
// CHECK11-NEXT:    [[TMP234:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP235:%.*]] = bitcast i8** [[TMP234]] to i32**
// CHECK11-NEXT:    store i32* [[TMP217]], i32** [[TMP235]], align 4
// CHECK11-NEXT:    [[TMP236:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 3
// CHECK11-NEXT:    [[TMP237:%.*]] = bitcast i8** [[TMP236]] to i32**
// CHECK11-NEXT:    store i32* [[TMP217]], i32** [[TMP237]], align 4
// CHECK11-NEXT:    [[TMP238:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 3
// CHECK11-NEXT:    store i8* null, i8** [[TMP238]], align 4
// CHECK11-NEXT:    [[TMP239:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP240:%.*]] = bitcast i8** [[TMP239]] to i32**
// CHECK11-NEXT:    store i32* [[TMP218]], i32** [[TMP240]], align 4
// CHECK11-NEXT:    [[TMP241:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 4
// CHECK11-NEXT:    [[TMP242:%.*]] = bitcast i8** [[TMP241]] to i32**
// CHECK11-NEXT:    store i32* [[TMP218]], i32** [[TMP242]], align 4
// CHECK11-NEXT:    [[TMP243:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS73]], i32 0, i32 4
// CHECK11-NEXT:    store i8* null, i8** [[TMP243]], align 4
// CHECK11-NEXT:    [[TMP244:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS71]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP245:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS72]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP246:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP246]], i32* [[DOTCAPTURE_EXPR_75]], align 4
// CHECK11-NEXT:    [[TMP247:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_75]], align 4
// CHECK11-NEXT:    [[SUB77:%.*]] = sub nsw i32 [[TMP247]], 0
// CHECK11-NEXT:    [[DIV78:%.*]] = sdiv i32 [[SUB77]], 1
// CHECK11-NEXT:    [[SUB79:%.*]] = sub nsw i32 [[DIV78]], 1
// CHECK11-NEXT:    store i32 [[SUB79]], i32* [[DOTCAPTURE_EXPR_76]], align 4
// CHECK11-NEXT:    [[TMP248:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_76]], align 4
// CHECK11-NEXT:    [[ADD80:%.*]] = add nsw i32 [[TMP248]], 1
// CHECK11-NEXT:    [[TMP249:%.*]] = zext i32 [[ADD80]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 [[TMP249]])
// CHECK11-NEXT:    [[TMP250:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l91.region_id, i32 5, i8** [[TMP244]], i8** [[TMP245]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes.52, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes.53, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK11-NEXT:    [[TMP251:%.*]] = icmp ne i32 [[TMP250]], 0
// CHECK11-NEXT:    br i1 [[TMP251]], label [[OMP_OFFLOAD_FAILED81:%.*]], label [[OMP_OFFLOAD_CONT82:%.*]]
// CHECK11:       omp_offload.failed81:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l91(i32 [[TMP213]], i32 [[TMP215]], i32* [[TMP216]], i32* [[TMP217]], i32* [[TMP218]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT82]]
// CHECK11:       omp_offload.cont82:
// CHECK11-NEXT:    ret i32 0
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l42
// CHECK11-SAME: (i32 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..26 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..26
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32**, i32**, i32**)* @.omp_outlined..27 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], i32** [[TMP1]], i32** [[TMP2]], i32** [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..27
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_cancel(%struct.ident_t* @[[GLOB3]], i32 [[TMP21]], i32 2)
// CHECK11-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK11-NEXT:    br i1 [[TMP23]], label [[DOTCANCEL_EXIT:%.*]], label [[DOTCANCEL_CONTINUE:%.*]]
// CHECK11:       .cancel.exit:
// CHECK11-NEXT:    br label [[CANCEL_EXIT:%.*]]
// CHECK11:       .cancel.continue:
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP24]], i32 [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, i32* [[TMP27]], i32 [[TMP28]]
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[ARRAYIDX6]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP26]], [[TMP29]]
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32*, i32** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP31:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP30]], i32 [[TMP31]]
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP32]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP34:%.*]] = load i32, i32* [[TMP33]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP34]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       cancel.exit:
// CHECK11-NEXT:    [[TMP35:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP36:%.*]] = load i32, i32* [[TMP35]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP36]])
// CHECK11-NEXT:    br label [[CANCEL_CONT:%.*]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    br label [[CANCEL_CONT]]
// CHECK11:       cancel.cont:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l51
// CHECK11-SAME: (i32 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..30 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..30
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32**, i32**, i32**)* @.omp_outlined..31 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], i32** [[TMP1]], i32** [[TMP2]], i32** [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..31
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP20]], i32 [[TMP21]]
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, i32* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[ARRAYIDX6]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP22]], [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l59
// CHECK11-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..34 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..34
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP6]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP7]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 91, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP9]])
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp slt i32 [[TMP17]], [[ADD]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32**, i32**, i32**)* @.omp_outlined..35 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], i32** [[TMP2]], i32** [[TMP3]], i32** [[TMP4]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK11-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP25]], [[TMP26]]
// CHECK11-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP9:%.*]] = icmp sgt i32 [[TMP27]], [[TMP28]]
// CHECK11-NEXT:    br i1 [[CMP9]], label [[COND_TRUE10:%.*]], label [[COND_FALSE11:%.*]]
// CHECK11:       cond.true10:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END12:%.*]]
// CHECK11:       cond.false11:
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END12]]
// CHECK11:       cond.end12:
// CHECK11-NEXT:    [[COND13:%.*]] = phi i32 [ [[TMP29]], [[COND_TRUE10]] ], [ [[TMP30]], [[COND_FALSE11]] ]
// CHECK11-NEXT:    store i32 [[COND13]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP31]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP32:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, i32* [[TMP32]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP33]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..35
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP20]], i32 [[TMP21]]
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, i32* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[ARRAYIDX6]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP22]], [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l67
// CHECK11-SAME: (i32 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..38 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..38
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32**, i32**, i32**)* @.omp_outlined..39 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], i32** [[TMP1]], i32** [[TMP2]], i32** [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..39
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP11]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP19]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP20]], i32 [[TMP21]]
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, i32* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[ARRAYIDX6]], align 4
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP22]], [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I3]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP28]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[TMP29]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP30]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l75
// CHECK11-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..42 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..42
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    store i32 [[TMP21]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32**, i32**, i32**, i32)* @.omp_outlined..43 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], i32** [[TMP2]], i32** [[TMP3]], i32** [[TMP4]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..43
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[TMP11]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP12]], i32 33, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 [[TMP10]])
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK11:       omp.dispatch.cond:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP13]], [[TMP14]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP15]], [[COND_TRUE]] ], [ [[TMP16]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK11:       omp.dispatch.body:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK11-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32*, i32** [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[I4]], align 4
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP23]], i32 [[TMP24]]
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32*, i32** [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[I4]], align 4
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP26]], i32 [[TMP27]]
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[ARRAYIDX8]], align 4
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP25]], [[TMP28]]
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32*, i32** [[TMP1]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[I4]], align 4
// CHECK11-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, i32* [[TMP29]], i32 [[TMP30]]
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[ARRAYIDX10]], align 4
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP31:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP31]], 1
// CHECK11-NEXT:    store i32 [[ADD11]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK11:       omp.dispatch.inc:
// CHECK11-NEXT:    [[TMP32:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP32]], [[TMP33]]
// CHECK11-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP34:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP35:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP34]], [[TMP35]]
// CHECK11-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK11:       omp.dispatch.end:
// CHECK11-NEXT:    [[TMP36:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP37:%.*]] = load i32, i32* [[TMP36]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP37]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l83
// CHECK11-SAME: (i32 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..46 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..46
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[TMP8]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP9]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP10]], [[TMP11]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP12]], [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP14]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32**, i32**, i32**)* @.omp_outlined..47 to void (i32*, i32*, ...)*), i32 [[TMP17]], i32 [[TMP18]], i32* [[TMP0]], i32** [[TMP1]], i32** [[TMP2]], i32** [[TMP3]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..47
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[TMP12]], align 4
// CHECK11-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP13]], i32 35, i32 [[TMP10]], i32 [[TMP11]], i32 1, i32 1)
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK11:       omp.dispatch.cond:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[TMP14]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP15]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK11-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP16]], 0
// CHECK11-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK11:       omp.dispatch.body:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[TMP2]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP21]], i32 [[TMP22]]
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32*, i32** [[TMP3]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds i32, i32* [[TMP24]], i32 [[TMP25]]
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[ARRAYIDX5]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP23]], [[TMP26]]
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32*, i32** [[TMP1]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i32, i32* [[TMP27]], i32 [[TMP28]]
// CHECK11-NEXT:    store i32 [[ADD6]], i32* [[ARRAYIDX7]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK11-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !26
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP27:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK11:       omp.dispatch.inc:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK11:       omp.dispatch.end:
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l91
// CHECK11-SAME: (i32 noundef [[CH:%.*]], i32 noundef [[N:%.*]], i32* noundef [[A:%.*]], i32* noundef [[B:%.*]], i32* noundef [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    store i32 [[CH]], i32* [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[B]], i32** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[C]], i32** [[C_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, i32**, i32**, i32**)* @.omp_outlined..50 to void (i32*, i32*, ...)*), i32* [[CH_ADDR]], i32* [[N_ADDR]], i32** [[A_ADDR]], i32** [[B_ADDR]], i32** [[C_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..50
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[CH:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[CH_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[CH]], i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[CH_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP5]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK11-NEXT:    store i32 [[TMP6]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP7]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP8]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[TMP10]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP11]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP12]], [[TMP13]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP14]], [[COND_TRUE]] ], [ [[TMP15]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP16]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP17]], [[TMP18]]
// CHECK11-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    store i32 [[TMP21]], i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, i32*, i32**, i32**, i32**, i32)* @.omp_outlined..51 to void (i32*, i32*, ...)*), i32 [[TMP19]], i32 [[TMP20]], i32* [[TMP1]], i32** [[TMP2]], i32** [[TMP3]], i32** [[TMP4]], i32 [[TMP22]])
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP23]], [[TMP24]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..51
// CHECK11-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], i32* noundef nonnull align 4 dereferenceable(4) [[N:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[A:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[B:%.*]], i32** noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i32 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[B_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[C_ADDR:%.*]] = alloca i32**, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[A]], i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[B]], i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    store i32** [[C]], i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32**, i32*** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32**, i32*** [[B_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32**, i32*** [[C_ADDR]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK11-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK11-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[TMP13]], align 4
// CHECK11-NEXT:    call void @__kmpc_dispatch_init_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP14]], i32 35, i32 [[TMP11]], i32 [[TMP12]], i32 1, i32 [[TMP10]])
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND:%.*]]
// CHECK11:       omp.dispatch.cond:
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[TMP15]], align 4
// CHECK11-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_dispatch_next_4(%struct.ident_t* @[[GLOB3]], i32 [[TMP16]], i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]])
// CHECK11-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK11-NEXT:    br i1 [[TOBOOL]], label [[OMP_DISPATCH_BODY:%.*]], label [[OMP_DISPATCH_END:%.*]]
// CHECK11:       omp.dispatch.body:
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP18]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP19]], [[TMP20]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP21]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[TMP22:%.*]] = load i32*, i32** [[TMP2]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP22]], i32 [[TMP23]]
// CHECK11-NEXT:    [[TMP24:%.*]] = load i32, i32* [[ARRAYIDX]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[TMP3]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[TMP26:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds i32, i32* [[TMP25]], i32 [[TMP26]]
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[ARRAYIDX6]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP24]], [[TMP27]]
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32*, i32** [[TMP1]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, i32* [[TMP28]], i32 [[TMP29]]
// CHECK11-NEXT:    store i32 [[ADD7]], i32* [[ARRAYIDX8]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP30:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP30]], 1
// CHECK11-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !29
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP30:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_INC:%.*]]
// CHECK11:       omp.dispatch.inc:
// CHECK11-NEXT:    br label [[OMP_DISPATCH_COND]]
// CHECK11:       omp.dispatch.end:
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK11-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK11-NEXT:    ret void
//
