; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -verify-machineinstrs -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names \
; RUN:		-mtriple=powerpc64le-unknown-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,P9LE
; RUN: llc -mcpu=pwr9 -verify-machineinstrs -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names \
; RUN:    -mtriple=powerpc64-unknown-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,P9BE
; RUN: llc -mcpu=pwr8 -verify-machineinstrs -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names \
; RUN:    -mtriple=powerpc64le-unknown-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,P8LE
; RUN: llc -mcpu=pwr8 -verify-machineinstrs -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names \
; RUN:    -mtriple=powerpc64-unknown-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,P8BE

define <4 x i16> @fold_srem_vec_1(<4 x i16> %x) {
; P9LE-LABEL: fold_srem_vec_1:
; P9LE:       # %bb.0:
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    lis r4, -21386
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    ori r4, r4, 37253
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    add r4, r4, r3
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 6
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 95
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    lis r4, 31710
; P9LE-NEXT:    mtvsrd v3, r3
; P9LE-NEXT:    li r3, 2
; P9LE-NEXT:    ori r4, r4, 63421
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    sub r4, r4, r3
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 6
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, -124
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    lis r4, 21399
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 4
; P9LE-NEXT:    ori r4, r4, 33437
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    vmrghh v3, v4, v3
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 5
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 98
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    lis r4, -16728
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 6
; P9LE-NEXT:    ori r4, r4, 63249
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 8
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, -1003
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mtvsrd v2, r3
; P9LE-NEXT:    vmrghh v2, v2, v4
; P9LE-NEXT:    vmrglw v2, v2, v3
; P9LE-NEXT:    blr
;
; P9BE-LABEL: fold_srem_vec_1:
; P9BE:       # %bb.0:
; P9BE-NEXT:    li r3, 2
; P9BE-NEXT:    lis r4, 31710
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    ori r4, r4, 63421
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    sub r4, r4, r3
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 6
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, -124
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    lis r4, -21386
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    ori r4, r4, 37253
; P9BE-NEXT:    mtvsrd v3, r3
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    add r4, r4, r3
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 6
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 95
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    lis r4, -16728
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    ori r4, r4, 63249
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 6
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    vmrghh v3, v4, v3
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 8
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, -1003
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    lis r4, 21399
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    ori r4, r4, 33437
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 4
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 5
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 98
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v2, r3
; P9BE-NEXT:    vmrghh v2, v2, v4
; P9BE-NEXT:    vmrghw v2, v3, v2
; P9BE-NEXT:    blr
;
; P8LE-LABEL: fold_srem_vec_1:
; P8LE:       # %bb.0:
; P8LE-NEXT:    xxswapd vs0, v2
; P8LE-NEXT:    lis r3, 21399
; P8LE-NEXT:    lis r8, -16728
; P8LE-NEXT:    lis r9, -21386
; P8LE-NEXT:    lis r10, 31710
; P8LE-NEXT:    ori r3, r3, 33437
; P8LE-NEXT:    ori r8, r8, 63249
; P8LE-NEXT:    ori r9, r9, 37253
; P8LE-NEXT:    ori r10, r10, 63421
; P8LE-NEXT:    mffprd r4, f0
; P8LE-NEXT:    rldicl r5, r4, 32, 48
; P8LE-NEXT:    rldicl r6, r4, 16, 48
; P8LE-NEXT:    clrldi r7, r4, 48
; P8LE-NEXT:    extsh r5, r5
; P8LE-NEXT:    extsh r6, r6
; P8LE-NEXT:    rldicl r4, r4, 48, 48
; P8LE-NEXT:    extsh r7, r7
; P8LE-NEXT:    mulhw r3, r5, r3
; P8LE-NEXT:    extsh r4, r4
; P8LE-NEXT:    mulhw r8, r6, r8
; P8LE-NEXT:    mulhw r9, r7, r9
; P8LE-NEXT:    mulhw r10, r4, r10
; P8LE-NEXT:    srwi r11, r3, 31
; P8LE-NEXT:    srawi r3, r3, 5
; P8LE-NEXT:    add r3, r3, r11
; P8LE-NEXT:    srwi r11, r8, 31
; P8LE-NEXT:    add r9, r9, r7
; P8LE-NEXT:    srawi r8, r8, 8
; P8LE-NEXT:    sub r10, r10, r4
; P8LE-NEXT:    add r8, r8, r11
; P8LE-NEXT:    srwi r11, r9, 31
; P8LE-NEXT:    srawi r9, r9, 6
; P8LE-NEXT:    mulli r3, r3, 98
; P8LE-NEXT:    add r9, r9, r11
; P8LE-NEXT:    srwi r11, r10, 31
; P8LE-NEXT:    srawi r10, r10, 6
; P8LE-NEXT:    mulli r8, r8, -1003
; P8LE-NEXT:    add r10, r10, r11
; P8LE-NEXT:    mulli r9, r9, 95
; P8LE-NEXT:    mulli r10, r10, -124
; P8LE-NEXT:    sub r3, r5, r3
; P8LE-NEXT:    mtvsrd v2, r3
; P8LE-NEXT:    sub r5, r6, r8
; P8LE-NEXT:    sub r3, r7, r9
; P8LE-NEXT:    mtvsrd v3, r5
; P8LE-NEXT:    sub r4, r4, r10
; P8LE-NEXT:    mtvsrd v4, r3
; P8LE-NEXT:    mtvsrd v5, r4
; P8LE-NEXT:    vmrghh v2, v3, v2
; P8LE-NEXT:    vmrghh v3, v5, v4
; P8LE-NEXT:    vmrglw v2, v2, v3
; P8LE-NEXT:    blr
;
; P8BE-LABEL: fold_srem_vec_1:
; P8BE:       # %bb.0:
; P8BE-NEXT:    mfvsrd r4, v2
; P8BE-NEXT:    lis r3, -16728
; P8BE-NEXT:    lis r8, 21399
; P8BE-NEXT:    lis r9, 31710
; P8BE-NEXT:    lis r10, -21386
; P8BE-NEXT:    ori r3, r3, 63249
; P8BE-NEXT:    ori r8, r8, 33437
; P8BE-NEXT:    ori r9, r9, 63421
; P8BE-NEXT:    ori r10, r10, 37253
; P8BE-NEXT:    clrldi r5, r4, 48
; P8BE-NEXT:    rldicl r6, r4, 48, 48
; P8BE-NEXT:    rldicl r7, r4, 32, 48
; P8BE-NEXT:    extsh r5, r5
; P8BE-NEXT:    extsh r6, r6
; P8BE-NEXT:    rldicl r4, r4, 16, 48
; P8BE-NEXT:    extsh r7, r7
; P8BE-NEXT:    mulhw r3, r5, r3
; P8BE-NEXT:    extsh r4, r4
; P8BE-NEXT:    mulhw r8, r6, r8
; P8BE-NEXT:    mulhw r9, r7, r9
; P8BE-NEXT:    mulhw r10, r4, r10
; P8BE-NEXT:    srwi r11, r3, 31
; P8BE-NEXT:    srawi r3, r3, 8
; P8BE-NEXT:    add r3, r3, r11
; P8BE-NEXT:    srwi r11, r8, 31
; P8BE-NEXT:    sub r9, r9, r7
; P8BE-NEXT:    srawi r8, r8, 5
; P8BE-NEXT:    add r10, r10, r4
; P8BE-NEXT:    add r8, r8, r11
; P8BE-NEXT:    srwi r11, r9, 31
; P8BE-NEXT:    srawi r9, r9, 6
; P8BE-NEXT:    mulli r3, r3, -1003
; P8BE-NEXT:    add r9, r9, r11
; P8BE-NEXT:    srwi r11, r10, 31
; P8BE-NEXT:    srawi r10, r10, 6
; P8BE-NEXT:    mulli r8, r8, 98
; P8BE-NEXT:    add r10, r10, r11
; P8BE-NEXT:    mulli r9, r9, -124
; P8BE-NEXT:    mulli r10, r10, 95
; P8BE-NEXT:    sub r3, r5, r3
; P8BE-NEXT:    sldi r3, r3, 48
; P8BE-NEXT:    sub r5, r6, r8
; P8BE-NEXT:    mtvsrd v2, r3
; P8BE-NEXT:    sub r6, r7, r9
; P8BE-NEXT:    sldi r3, r5, 48
; P8BE-NEXT:    sub r4, r4, r10
; P8BE-NEXT:    mtvsrd v3, r3
; P8BE-NEXT:    sldi r3, r6, 48
; P8BE-NEXT:    sldi r4, r4, 48
; P8BE-NEXT:    mtvsrd v4, r3
; P8BE-NEXT:    mtvsrd v5, r4
; P8BE-NEXT:    vmrghh v2, v3, v2
; P8BE-NEXT:    vmrghh v3, v5, v4
; P8BE-NEXT:    vmrghw v2, v3, v2
; P8BE-NEXT:    blr
  %1 = srem <4 x i16> %x, <i16 95, i16 -124, i16 98, i16 -1003>
  ret <4 x i16> %1
}

define <4 x i16> @fold_srem_vec_2(<4 x i16> %x) {
; P9LE-LABEL: fold_srem_vec_2:
; P9LE:       # %bb.0:
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    lis r4, -21386
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    ori r4, r4, 37253
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r5, r3, r4
; P9LE-NEXT:    add r5, r5, r3
; P9LE-NEXT:    srwi r6, r5, 31
; P9LE-NEXT:    srawi r5, r5, 6
; P9LE-NEXT:    add r5, r5, r6
; P9LE-NEXT:    mulli r5, r5, 95
; P9LE-NEXT:    sub r3, r3, r5
; P9LE-NEXT:    mtvsrd v3, r3
; P9LE-NEXT:    li r3, 2
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r5, r3, r4
; P9LE-NEXT:    add r5, r5, r3
; P9LE-NEXT:    srwi r6, r5, 31
; P9LE-NEXT:    srawi r5, r5, 6
; P9LE-NEXT:    add r5, r5, r6
; P9LE-NEXT:    mulli r5, r5, 95
; P9LE-NEXT:    sub r3, r3, r5
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 4
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    vmrghh v3, v4, v3
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r5, r3, r4
; P9LE-NEXT:    add r5, r5, r3
; P9LE-NEXT:    srwi r6, r5, 31
; P9LE-NEXT:    srawi r5, r5, 6
; P9LE-NEXT:    add r5, r5, r6
; P9LE-NEXT:    mulli r5, r5, 95
; P9LE-NEXT:    sub r3, r3, r5
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 6
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    add r4, r4, r3
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 6
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 95
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mtvsrd v2, r3
; P9LE-NEXT:    vmrghh v2, v2, v4
; P9LE-NEXT:    vmrglw v2, v2, v3
; P9LE-NEXT:    blr
;
; P9BE-LABEL: fold_srem_vec_2:
; P9BE:       # %bb.0:
; P9BE-NEXT:    li r3, 6
; P9BE-NEXT:    lis r4, -21386
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    ori r4, r4, 37253
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r5, r3, r4
; P9BE-NEXT:    add r5, r5, r3
; P9BE-NEXT:    srwi r6, r5, 31
; P9BE-NEXT:    srawi r5, r5, 6
; P9BE-NEXT:    add r5, r5, r6
; P9BE-NEXT:    mulli r5, r5, 95
; P9BE-NEXT:    sub r3, r3, r5
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v3, r3
; P9BE-NEXT:    li r3, 4
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r5, r3, r4
; P9BE-NEXT:    add r5, r5, r3
; P9BE-NEXT:    srwi r6, r5, 31
; P9BE-NEXT:    srawi r5, r5, 6
; P9BE-NEXT:    add r5, r5, r6
; P9BE-NEXT:    mulli r5, r5, 95
; P9BE-NEXT:    sub r3, r3, r5
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 2
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    vmrghh v3, v4, v3
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r5, r3, r4
; P9BE-NEXT:    add r5, r5, r3
; P9BE-NEXT:    srwi r6, r5, 31
; P9BE-NEXT:    srawi r5, r5, 6
; P9BE-NEXT:    add r5, r5, r6
; P9BE-NEXT:    mulli r5, r5, 95
; P9BE-NEXT:    sub r3, r3, r5
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    add r4, r4, r3
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 6
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 95
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v2, r3
; P9BE-NEXT:    vmrghh v2, v2, v4
; P9BE-NEXT:    vmrghw v2, v2, v3
; P9BE-NEXT:    blr
;
; P8LE-LABEL: fold_srem_vec_2:
; P8LE:       # %bb.0:
; P8LE-NEXT:    xxswapd vs0, v2
; P8LE-NEXT:    lis r3, -21386
; P8LE-NEXT:    ori r3, r3, 37253
; P8LE-NEXT:    mffprd r4, f0
; P8LE-NEXT:    clrldi r5, r4, 48
; P8LE-NEXT:    rldicl r6, r4, 48, 48
; P8LE-NEXT:    extsh r5, r5
; P8LE-NEXT:    rldicl r7, r4, 32, 48
; P8LE-NEXT:    extsh r6, r6
; P8LE-NEXT:    mulhw r8, r5, r3
; P8LE-NEXT:    rldicl r4, r4, 16, 48
; P8LE-NEXT:    extsh r7, r7
; P8LE-NEXT:    mulhw r9, r6, r3
; P8LE-NEXT:    extsh r4, r4
; P8LE-NEXT:    mulhw r10, r7, r3
; P8LE-NEXT:    mulhw r3, r4, r3
; P8LE-NEXT:    add r8, r8, r5
; P8LE-NEXT:    add r9, r9, r6
; P8LE-NEXT:    srwi r11, r8, 31
; P8LE-NEXT:    srawi r8, r8, 6
; P8LE-NEXT:    add r10, r10, r7
; P8LE-NEXT:    add r3, r3, r4
; P8LE-NEXT:    add r8, r8, r11
; P8LE-NEXT:    srwi r11, r9, 31
; P8LE-NEXT:    srawi r9, r9, 6
; P8LE-NEXT:    mulli r8, r8, 95
; P8LE-NEXT:    add r9, r9, r11
; P8LE-NEXT:    srwi r11, r10, 31
; P8LE-NEXT:    srawi r10, r10, 6
; P8LE-NEXT:    mulli r9, r9, 95
; P8LE-NEXT:    add r10, r10, r11
; P8LE-NEXT:    srwi r11, r3, 31
; P8LE-NEXT:    srawi r3, r3, 6
; P8LE-NEXT:    mulli r10, r10, 95
; P8LE-NEXT:    sub r5, r5, r8
; P8LE-NEXT:    add r3, r3, r11
; P8LE-NEXT:    mtvsrd v2, r5
; P8LE-NEXT:    mulli r3, r3, 95
; P8LE-NEXT:    sub r6, r6, r9
; P8LE-NEXT:    mtvsrd v3, r6
; P8LE-NEXT:    sub r5, r7, r10
; P8LE-NEXT:    mtvsrd v4, r5
; P8LE-NEXT:    sub r3, r4, r3
; P8LE-NEXT:    vmrghh v2, v3, v2
; P8LE-NEXT:    mtvsrd v5, r3
; P8LE-NEXT:    vmrghh v3, v5, v4
; P8LE-NEXT:    vmrglw v2, v3, v2
; P8LE-NEXT:    blr
;
; P8BE-LABEL: fold_srem_vec_2:
; P8BE:       # %bb.0:
; P8BE-NEXT:    mfvsrd r4, v2
; P8BE-NEXT:    lis r3, -21386
; P8BE-NEXT:    ori r3, r3, 37253
; P8BE-NEXT:    clrldi r5, r4, 48
; P8BE-NEXT:    rldicl r6, r4, 48, 48
; P8BE-NEXT:    extsh r5, r5
; P8BE-NEXT:    rldicl r7, r4, 32, 48
; P8BE-NEXT:    extsh r6, r6
; P8BE-NEXT:    mulhw r8, r5, r3
; P8BE-NEXT:    rldicl r4, r4, 16, 48
; P8BE-NEXT:    extsh r7, r7
; P8BE-NEXT:    mulhw r9, r6, r3
; P8BE-NEXT:    extsh r4, r4
; P8BE-NEXT:    mulhw r10, r7, r3
; P8BE-NEXT:    mulhw r3, r4, r3
; P8BE-NEXT:    add r8, r8, r5
; P8BE-NEXT:    add r9, r9, r6
; P8BE-NEXT:    srwi r11, r8, 31
; P8BE-NEXT:    srawi r8, r8, 6
; P8BE-NEXT:    add r10, r10, r7
; P8BE-NEXT:    add r3, r3, r4
; P8BE-NEXT:    add r8, r8, r11
; P8BE-NEXT:    srwi r11, r9, 31
; P8BE-NEXT:    srawi r9, r9, 6
; P8BE-NEXT:    mulli r8, r8, 95
; P8BE-NEXT:    add r9, r9, r11
; P8BE-NEXT:    srwi r11, r10, 31
; P8BE-NEXT:    srawi r10, r10, 6
; P8BE-NEXT:    mulli r9, r9, 95
; P8BE-NEXT:    add r10, r10, r11
; P8BE-NEXT:    srwi r11, r3, 31
; P8BE-NEXT:    srawi r3, r3, 6
; P8BE-NEXT:    mulli r10, r10, 95
; P8BE-NEXT:    sub r5, r5, r8
; P8BE-NEXT:    add r3, r3, r11
; P8BE-NEXT:    sldi r5, r5, 48
; P8BE-NEXT:    mulli r3, r3, 95
; P8BE-NEXT:    sub r6, r6, r9
; P8BE-NEXT:    mtvsrd v2, r5
; P8BE-NEXT:    sldi r6, r6, 48
; P8BE-NEXT:    sub r7, r7, r10
; P8BE-NEXT:    mtvsrd v3, r6
; P8BE-NEXT:    sub r3, r4, r3
; P8BE-NEXT:    sldi r4, r7, 48
; P8BE-NEXT:    vmrghh v2, v3, v2
; P8BE-NEXT:    sldi r3, r3, 48
; P8BE-NEXT:    mtvsrd v4, r4
; P8BE-NEXT:    mtvsrd v5, r3
; P8BE-NEXT:    vmrghh v3, v5, v4
; P8BE-NEXT:    vmrghw v2, v3, v2
; P8BE-NEXT:    blr
  %1 = srem <4 x i16> %x, <i16 95, i16 95, i16 95, i16 95>
  ret <4 x i16> %1
}


; Don't fold if we can combine srem with sdiv.
define <4 x i16> @combine_srem_sdiv(<4 x i16> %x) {
; P9LE-LABEL: combine_srem_sdiv:
; P9LE:       # %bb.0:
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    lis r4, -21386
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    ori r4, r4, 37253
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r5, r3, r4
; P9LE-NEXT:    add r5, r5, r3
; P9LE-NEXT:    srwi r6, r5, 31
; P9LE-NEXT:    srawi r5, r5, 6
; P9LE-NEXT:    add r5, r5, r6
; P9LE-NEXT:    mulli r6, r5, 95
; P9LE-NEXT:    sub r3, r3, r6
; P9LE-NEXT:    mtvsrd v3, r3
; P9LE-NEXT:    li r3, 2
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r6, r3
; P9LE-NEXT:    mulhw r7, r6, r4
; P9LE-NEXT:    add r6, r7, r6
; P9LE-NEXT:    srwi r7, r6, 31
; P9LE-NEXT:    srawi r6, r6, 6
; P9LE-NEXT:    add r6, r6, r7
; P9LE-NEXT:    mulli r7, r6, 95
; P9LE-NEXT:    sub r3, r3, r7
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 4
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    vmrghh v3, v4, v3
; P9LE-NEXT:    extsh r7, r3
; P9LE-NEXT:    mulhw r8, r7, r4
; P9LE-NEXT:    add r7, r8, r7
; P9LE-NEXT:    srwi r8, r7, 31
; P9LE-NEXT:    srawi r7, r7, 6
; P9LE-NEXT:    add r7, r7, r8
; P9LE-NEXT:    mulli r8, r7, 95
; P9LE-NEXT:    sub r3, r3, r8
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 6
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r8, r3
; P9LE-NEXT:    mulhw r4, r8, r4
; P9LE-NEXT:    add r4, r4, r8
; P9LE-NEXT:    srwi r8, r4, 31
; P9LE-NEXT:    srawi r4, r4, 6
; P9LE-NEXT:    add r4, r4, r8
; P9LE-NEXT:    mulli r8, r4, 95
; P9LE-NEXT:    mtvsrd v5, r4
; P9LE-NEXT:    sub r3, r3, r8
; P9LE-NEXT:    mtvsrd v2, r3
; P9LE-NEXT:    vmrghh v2, v2, v4
; P9LE-NEXT:    mtvsrd v4, r6
; P9LE-NEXT:    vmrglw v2, v2, v3
; P9LE-NEXT:    mtvsrd v3, r5
; P9LE-NEXT:    vmrghh v3, v4, v3
; P9LE-NEXT:    mtvsrd v4, r7
; P9LE-NEXT:    vmrghh v4, v5, v4
; P9LE-NEXT:    vmrglw v3, v4, v3
; P9LE-NEXT:    vadduhm v2, v2, v3
; P9LE-NEXT:    blr
;
; P9BE-LABEL: combine_srem_sdiv:
; P9BE:       # %bb.0:
; P9BE-NEXT:    li r3, 6
; P9BE-NEXT:    lis r5, -21386
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    ori r5, r5, 37253
; P9BE-NEXT:    extsh r4, r3
; P9BE-NEXT:    mulhw r6, r4, r5
; P9BE-NEXT:    add r4, r6, r4
; P9BE-NEXT:    srwi r6, r4, 31
; P9BE-NEXT:    srawi r4, r4, 6
; P9BE-NEXT:    add r4, r4, r6
; P9BE-NEXT:    mulli r6, r4, 95
; P9BE-NEXT:    sub r3, r3, r6
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v3, r3
; P9BE-NEXT:    li r3, 4
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r6, r3
; P9BE-NEXT:    mulhw r7, r6, r5
; P9BE-NEXT:    add r6, r7, r6
; P9BE-NEXT:    srwi r7, r6, 31
; P9BE-NEXT:    srawi r6, r6, 6
; P9BE-NEXT:    add r6, r6, r7
; P9BE-NEXT:    mulli r7, r6, 95
; P9BE-NEXT:    sub r3, r3, r7
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 2
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    vmrghh v3, v4, v3
; P9BE-NEXT:    extsh r7, r3
; P9BE-NEXT:    mulhw r8, r7, r5
; P9BE-NEXT:    add r7, r8, r7
; P9BE-NEXT:    srwi r8, r7, 31
; P9BE-NEXT:    srawi r7, r7, 6
; P9BE-NEXT:    add r7, r7, r8
; P9BE-NEXT:    mulli r8, r7, 95
; P9BE-NEXT:    sub r3, r3, r8
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r5, r3, r5
; P9BE-NEXT:    add r5, r5, r3
; P9BE-NEXT:    srwi r8, r5, 31
; P9BE-NEXT:    srawi r5, r5, 6
; P9BE-NEXT:    add r5, r5, r8
; P9BE-NEXT:    mulli r8, r5, 95
; P9BE-NEXT:    sub r3, r3, r8
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v2, r3
; P9BE-NEXT:    sldi r3, r4, 48
; P9BE-NEXT:    vmrghh v2, v2, v4
; P9BE-NEXT:    vmrghw v2, v2, v3
; P9BE-NEXT:    mtvsrd v3, r3
; P9BE-NEXT:    sldi r3, r6, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    sldi r3, r7, 48
; P9BE-NEXT:    vmrghh v3, v4, v3
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    sldi r3, r5, 48
; P9BE-NEXT:    mtvsrd v5, r3
; P9BE-NEXT:    vmrghh v4, v5, v4
; P9BE-NEXT:    vmrghw v3, v4, v3
; P9BE-NEXT:    vadduhm v2, v2, v3
; P9BE-NEXT:    blr
;
; P8LE-LABEL: combine_srem_sdiv:
; P8LE:       # %bb.0:
; P8LE-NEXT:    xxswapd vs0, v2
; P8LE-NEXT:    lis r3, -21386
; P8LE-NEXT:    ori r3, r3, 37253
; P8LE-NEXT:    mffprd r4, f0
; P8LE-NEXT:    clrldi r5, r4, 48
; P8LE-NEXT:    rldicl r6, r4, 48, 48
; P8LE-NEXT:    rldicl r7, r4, 32, 48
; P8LE-NEXT:    extsh r5, r5
; P8LE-NEXT:    extsh r8, r6
; P8LE-NEXT:    extsh r9, r7
; P8LE-NEXT:    mulhw r10, r5, r3
; P8LE-NEXT:    mulhw r11, r8, r3
; P8LE-NEXT:    rldicl r4, r4, 16, 48
; P8LE-NEXT:    mulhw r12, r9, r3
; P8LE-NEXT:    extsh r0, r4
; P8LE-NEXT:    mulhw r3, r0, r3
; P8LE-NEXT:    add r10, r10, r5
; P8LE-NEXT:    add r8, r11, r8
; P8LE-NEXT:    srwi r11, r10, 31
; P8LE-NEXT:    add r9, r12, r9
; P8LE-NEXT:    srawi r10, r10, 6
; P8LE-NEXT:    srawi r12, r8, 6
; P8LE-NEXT:    srwi r8, r8, 31
; P8LE-NEXT:    add r10, r10, r11
; P8LE-NEXT:    add r3, r3, r0
; P8LE-NEXT:    srawi r11, r9, 6
; P8LE-NEXT:    srwi r9, r9, 31
; P8LE-NEXT:    add r8, r12, r8
; P8LE-NEXT:    mtvsrd v2, r10
; P8LE-NEXT:    mulli r12, r10, 95
; P8LE-NEXT:    add r9, r11, r9
; P8LE-NEXT:    srwi r11, r3, 31
; P8LE-NEXT:    mtvsrd v3, r8
; P8LE-NEXT:    srawi r3, r3, 6
; P8LE-NEXT:    mulli r10, r8, 95
; P8LE-NEXT:    mtvsrd v4, r9
; P8LE-NEXT:    add r3, r3, r11
; P8LE-NEXT:    mulli r8, r9, 95
; P8LE-NEXT:    vmrghh v2, v3, v2
; P8LE-NEXT:    mulli r9, r3, 95
; P8LE-NEXT:    sub r5, r5, r12
; P8LE-NEXT:    sub r6, r6, r10
; P8LE-NEXT:    mtvsrd v3, r5
; P8LE-NEXT:    mtvsrd v5, r6
; P8LE-NEXT:    sub r5, r7, r8
; P8LE-NEXT:    sub r4, r4, r9
; P8LE-NEXT:    mtvsrd v0, r5
; P8LE-NEXT:    mtvsrd v1, r4
; P8LE-NEXT:    vmrghh v3, v5, v3
; P8LE-NEXT:    mtvsrd v5, r3
; P8LE-NEXT:    vmrghh v0, v1, v0
; P8LE-NEXT:    vmrghh v4, v5, v4
; P8LE-NEXT:    vmrglw v3, v0, v3
; P8LE-NEXT:    vmrglw v2, v4, v2
; P8LE-NEXT:    vadduhm v2, v3, v2
; P8LE-NEXT:    blr
;
; P8BE-LABEL: combine_srem_sdiv:
; P8BE:       # %bb.0:
; P8BE-NEXT:    mfvsrd r5, v2
; P8BE-NEXT:    lis r4, -21386
; P8BE-NEXT:    ori r4, r4, 37253
; P8BE-NEXT:    clrldi r3, r5, 48
; P8BE-NEXT:    rldicl r6, r5, 48, 48
; P8BE-NEXT:    extsh r8, r3
; P8BE-NEXT:    rldicl r7, r5, 32, 48
; P8BE-NEXT:    extsh r9, r6
; P8BE-NEXT:    rldicl r5, r5, 16, 48
; P8BE-NEXT:    mulhw r11, r8, r4
; P8BE-NEXT:    extsh r10, r7
; P8BE-NEXT:    extsh r5, r5
; P8BE-NEXT:    mulhw r12, r9, r4
; P8BE-NEXT:    mulhw r0, r10, r4
; P8BE-NEXT:    mulhw r4, r5, r4
; P8BE-NEXT:    add r8, r11, r8
; P8BE-NEXT:    add r9, r12, r9
; P8BE-NEXT:    srawi r11, r8, 6
; P8BE-NEXT:    srwi r8, r8, 31
; P8BE-NEXT:    add r10, r0, r10
; P8BE-NEXT:    add r4, r4, r5
; P8BE-NEXT:    add r8, r11, r8
; P8BE-NEXT:    srawi r12, r9, 6
; P8BE-NEXT:    srwi r9, r9, 31
; P8BE-NEXT:    srawi r0, r10, 6
; P8BE-NEXT:    srawi r11, r4, 6
; P8BE-NEXT:    srwi r10, r10, 31
; P8BE-NEXT:    add r9, r12, r9
; P8BE-NEXT:    srwi r4, r4, 31
; P8BE-NEXT:    mulli r12, r8, 95
; P8BE-NEXT:    add r10, r0, r10
; P8BE-NEXT:    add r4, r11, r4
; P8BE-NEXT:    mulli r0, r9, 95
; P8BE-NEXT:    sldi r9, r9, 48
; P8BE-NEXT:    sldi r8, r8, 48
; P8BE-NEXT:    mtvsrd v3, r9
; P8BE-NEXT:    mulli r9, r4, 95
; P8BE-NEXT:    mtvsrd v2, r8
; P8BE-NEXT:    mulli r8, r10, 95
; P8BE-NEXT:    sldi r10, r10, 48
; P8BE-NEXT:    sub r3, r3, r12
; P8BE-NEXT:    mtvsrd v4, r10
; P8BE-NEXT:    sub r6, r6, r0
; P8BE-NEXT:    sldi r3, r3, 48
; P8BE-NEXT:    vmrghh v2, v3, v2
; P8BE-NEXT:    sldi r6, r6, 48
; P8BE-NEXT:    mtvsrd v3, r3
; P8BE-NEXT:    sub r3, r5, r9
; P8BE-NEXT:    sub r7, r7, r8
; P8BE-NEXT:    mtvsrd v5, r6
; P8BE-NEXT:    sldi r3, r3, 48
; P8BE-NEXT:    sldi r5, r7, 48
; P8BE-NEXT:    mtvsrd v1, r3
; P8BE-NEXT:    sldi r3, r4, 48
; P8BE-NEXT:    mtvsrd v0, r5
; P8BE-NEXT:    vmrghh v3, v5, v3
; P8BE-NEXT:    mtvsrd v5, r3
; P8BE-NEXT:    vmrghh v0, v1, v0
; P8BE-NEXT:    vmrghh v4, v5, v4
; P8BE-NEXT:    vmrghw v3, v0, v3
; P8BE-NEXT:    vmrghw v2, v4, v2
; P8BE-NEXT:    vadduhm v2, v3, v2
; P8BE-NEXT:    blr
  %1 = srem <4 x i16> %x, <i16 95, i16 95, i16 95, i16 95>
  %2 = sdiv <4 x i16> %x, <i16 95, i16 95, i16 95, i16 95>
  %3 = add <4 x i16> %1, %2
  ret <4 x i16> %3
}

; Don't fold for divisors that are a power of two.
define <4 x i16> @dont_fold_srem_power_of_two(<4 x i16> %x) {
; P9LE-LABEL: dont_fold_srem_power_of_two:
; P9LE:       # %bb.0:
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    srawi r4, r3, 6
; P9LE-NEXT:    addze r4, r4
; P9LE-NEXT:    slwi r4, r4, 6
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mtvsrd v3, r3
; P9LE-NEXT:    li r3, 2
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    srawi r4, r3, 5
; P9LE-NEXT:    addze r4, r4
; P9LE-NEXT:    slwi r4, r4, 5
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    lis r4, -21386
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 6
; P9LE-NEXT:    ori r4, r4, 37253
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    vmrghh v3, v4, v3
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    add r4, r4, r3
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 6
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 95
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 4
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    srawi r4, r3, 3
; P9LE-NEXT:    addze r4, r4
; P9LE-NEXT:    slwi r4, r4, 3
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mtvsrd v2, r3
; P9LE-NEXT:    vmrghh v2, v4, v2
; P9LE-NEXT:    vmrglw v2, v2, v3
; P9LE-NEXT:    blr
;
; P9BE-LABEL: dont_fold_srem_power_of_two:
; P9BE:       # %bb.0:
; P9BE-NEXT:    li r3, 2
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    srawi r4, r3, 5
; P9BE-NEXT:    addze r4, r4
; P9BE-NEXT:    slwi r4, r4, 5
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v3, r3
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    srawi r4, r3, 6
; P9BE-NEXT:    addze r4, r4
; P9BE-NEXT:    slwi r4, r4, 6
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    lis r4, -21386
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    ori r4, r4, 37253
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 6
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    vmrghh v3, v4, v3
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    add r4, r4, r3
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 6
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 95
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 4
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    srawi r4, r3, 3
; P9BE-NEXT:    addze r4, r4
; P9BE-NEXT:    slwi r4, r4, 3
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v2, r3
; P9BE-NEXT:    vmrghh v2, v2, v4
; P9BE-NEXT:    vmrghw v2, v3, v2
; P9BE-NEXT:    blr
;
; P8LE-LABEL: dont_fold_srem_power_of_two:
; P8LE:       # %bb.0:
; P8LE-NEXT:    xxswapd vs0, v2
; P8LE-NEXT:    lis r3, -21386
; P8LE-NEXT:    ori r3, r3, 37253
; P8LE-NEXT:    mffprd r4, f0
; P8LE-NEXT:    rldicl r5, r4, 16, 48
; P8LE-NEXT:    clrldi r6, r4, 48
; P8LE-NEXT:    extsh r5, r5
; P8LE-NEXT:    extsh r6, r6
; P8LE-NEXT:    mulhw r3, r5, r3
; P8LE-NEXT:    rldicl r7, r4, 48, 48
; P8LE-NEXT:    srawi r8, r6, 6
; P8LE-NEXT:    extsh r7, r7
; P8LE-NEXT:    addze r8, r8
; P8LE-NEXT:    rldicl r4, r4, 32, 48
; P8LE-NEXT:    srawi r9, r7, 5
; P8LE-NEXT:    extsh r4, r4
; P8LE-NEXT:    slwi r8, r8, 6
; P8LE-NEXT:    add r3, r3, r5
; P8LE-NEXT:    addze r9, r9
; P8LE-NEXT:    sub r6, r6, r8
; P8LE-NEXT:    srwi r10, r3, 31
; P8LE-NEXT:    srawi r3, r3, 6
; P8LE-NEXT:    slwi r8, r9, 5
; P8LE-NEXT:    mtvsrd v2, r6
; P8LE-NEXT:    add r3, r3, r10
; P8LE-NEXT:    srawi r9, r4, 3
; P8LE-NEXT:    sub r6, r7, r8
; P8LE-NEXT:    mulli r3, r3, 95
; P8LE-NEXT:    addze r7, r9
; P8LE-NEXT:    mtvsrd v3, r6
; P8LE-NEXT:    vmrghh v2, v3, v2
; P8LE-NEXT:    sub r3, r5, r3
; P8LE-NEXT:    slwi r5, r7, 3
; P8LE-NEXT:    sub r4, r4, r5
; P8LE-NEXT:    mtvsrd v4, r3
; P8LE-NEXT:    mtvsrd v5, r4
; P8LE-NEXT:    vmrghh v3, v4, v5
; P8LE-NEXT:    vmrglw v2, v3, v2
; P8LE-NEXT:    blr
;
; P8BE-LABEL: dont_fold_srem_power_of_two:
; P8BE:       # %bb.0:
; P8BE-NEXT:    mfvsrd r4, v2
; P8BE-NEXT:    lis r3, -21386
; P8BE-NEXT:    ori r3, r3, 37253
; P8BE-NEXT:    clrldi r5, r4, 48
; P8BE-NEXT:    rldicl r6, r4, 32, 48
; P8BE-NEXT:    extsh r5, r5
; P8BE-NEXT:    extsh r6, r6
; P8BE-NEXT:    mulhw r3, r5, r3
; P8BE-NEXT:    rldicl r7, r4, 16, 48
; P8BE-NEXT:    srawi r8, r6, 5
; P8BE-NEXT:    extsh r7, r7
; P8BE-NEXT:    addze r8, r8
; P8BE-NEXT:    rldicl r4, r4, 48, 48
; P8BE-NEXT:    srawi r9, r7, 6
; P8BE-NEXT:    extsh r4, r4
; P8BE-NEXT:    slwi r8, r8, 5
; P8BE-NEXT:    add r3, r3, r5
; P8BE-NEXT:    addze r9, r9
; P8BE-NEXT:    sub r6, r6, r8
; P8BE-NEXT:    srwi r10, r3, 31
; P8BE-NEXT:    srawi r3, r3, 6
; P8BE-NEXT:    slwi r8, r9, 6
; P8BE-NEXT:    add r3, r3, r10
; P8BE-NEXT:    srawi r9, r4, 3
; P8BE-NEXT:    sub r7, r7, r8
; P8BE-NEXT:    mulli r3, r3, 95
; P8BE-NEXT:    sldi r6, r6, 48
; P8BE-NEXT:    addze r8, r9
; P8BE-NEXT:    mtvsrd v2, r6
; P8BE-NEXT:    slwi r6, r8, 3
; P8BE-NEXT:    sub r4, r4, r6
; P8BE-NEXT:    sldi r4, r4, 48
; P8BE-NEXT:    sub r3, r5, r3
; P8BE-NEXT:    sldi r5, r7, 48
; P8BE-NEXT:    mtvsrd v5, r4
; P8BE-NEXT:    sldi r3, r3, 48
; P8BE-NEXT:    mtvsrd v3, r5
; P8BE-NEXT:    mtvsrd v4, r3
; P8BE-NEXT:    vmrghh v2, v3, v2
; P8BE-NEXT:    vmrghh v3, v5, v4
; P8BE-NEXT:    vmrghw v2, v2, v3
; P8BE-NEXT:    blr
  %1 = srem <4 x i16> %x, <i16 64, i16 32, i16 8, i16 95>
  ret <4 x i16> %1
}

; Don't fold if the divisor is one.
define <4 x i16> @dont_fold_srem_one(<4 x i16> %x) {
; P9LE-LABEL: dont_fold_srem_one:
; P9LE:       # %bb.0:
; P9LE-NEXT:    li r3, 2
; P9LE-NEXT:    lis r4, -14230
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    ori r4, r4, 30865
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    add r4, r4, r3
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 9
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 654
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    lis r4, -19946
; P9LE-NEXT:    mtvsrd v3, r3
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    ori r4, r4, 17097
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 4
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    vmrghh v3, v3, v4
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    add r4, r4, r3
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 4
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 23
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    lis r4, 24749
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 6
; P9LE-NEXT:    ori r4, r4, 47143
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 11
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 5423
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mtvsrd v2, r3
; P9LE-NEXT:    vmrghh v2, v2, v4
; P9LE-NEXT:    vmrglw v2, v2, v3
; P9LE-NEXT:    blr
;
; P9BE-LABEL: dont_fold_srem_one:
; P9BE:       # %bb.0:
; P9BE-NEXT:    li r3, 4
; P9BE-NEXT:    lis r4, -19946
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    ori r4, r4, 17097
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    add r4, r4, r3
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 4
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 23
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    lis r4, 24749
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    ori r4, r4, 47143
; P9BE-NEXT:    mtvsrd v3, r3
; P9BE-NEXT:    li r3, 6
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 11
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 5423
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    lis r4, -14230
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    ori r4, r4, 30865
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 2
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    vmrghh v3, v3, v4
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    add r4, r4, r3
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 9
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 654
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v2, r3
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    vmrghh v2, v4, v2
; P9BE-NEXT:    vmrghw v2, v2, v3
; P9BE-NEXT:    blr
;
; P8LE-LABEL: dont_fold_srem_one:
; P8LE:       # %bb.0:
; P8LE-NEXT:    xxswapd vs0, v2
; P8LE-NEXT:    lis r5, 24749
; P8LE-NEXT:    lis r6, -19946
; P8LE-NEXT:    lis r8, -14230
; P8LE-NEXT:    ori r5, r5, 47143
; P8LE-NEXT:    ori r6, r6, 17097
; P8LE-NEXT:    ori r8, r8, 30865
; P8LE-NEXT:    mffprd r3, f0
; P8LE-NEXT:    rldicl r4, r3, 16, 48
; P8LE-NEXT:    rldicl r7, r3, 32, 48
; P8LE-NEXT:    rldicl r3, r3, 48, 48
; P8LE-NEXT:    extsh r4, r4
; P8LE-NEXT:    extsh r7, r7
; P8LE-NEXT:    extsh r3, r3
; P8LE-NEXT:    mulhw r5, r4, r5
; P8LE-NEXT:    mulhw r6, r7, r6
; P8LE-NEXT:    mulhw r8, r3, r8
; P8LE-NEXT:    srwi r9, r5, 31
; P8LE-NEXT:    srawi r5, r5, 11
; P8LE-NEXT:    add r6, r6, r7
; P8LE-NEXT:    add r8, r8, r3
; P8LE-NEXT:    add r5, r5, r9
; P8LE-NEXT:    srwi r9, r6, 31
; P8LE-NEXT:    srawi r6, r6, 4
; P8LE-NEXT:    add r6, r6, r9
; P8LE-NEXT:    srwi r9, r8, 31
; P8LE-NEXT:    srawi r8, r8, 9
; P8LE-NEXT:    mulli r5, r5, 5423
; P8LE-NEXT:    add r8, r8, r9
; P8LE-NEXT:    mulli r6, r6, 23
; P8LE-NEXT:    li r9, 0
; P8LE-NEXT:    mulli r8, r8, 654
; P8LE-NEXT:    mtvsrd v2, r9
; P8LE-NEXT:    sub r4, r4, r5
; P8LE-NEXT:    sub r5, r7, r6
; P8LE-NEXT:    mtvsrd v3, r4
; P8LE-NEXT:    sub r3, r3, r8
; P8LE-NEXT:    mtvsrd v4, r5
; P8LE-NEXT:    mtvsrd v5, r3
; P8LE-NEXT:    vmrghh v3, v3, v4
; P8LE-NEXT:    vmrghh v2, v5, v2
; P8LE-NEXT:    vmrglw v2, v3, v2
; P8LE-NEXT:    blr
;
; P8BE-LABEL: dont_fold_srem_one:
; P8BE:       # %bb.0:
; P8BE-NEXT:    mfvsrd r3, v2
; P8BE-NEXT:    lis r5, 24749
; P8BE-NEXT:    lis r6, -19946
; P8BE-NEXT:    lis r8, -14230
; P8BE-NEXT:    ori r5, r5, 47143
; P8BE-NEXT:    ori r6, r6, 17097
; P8BE-NEXT:    ori r8, r8, 30865
; P8BE-NEXT:    clrldi r4, r3, 48
; P8BE-NEXT:    rldicl r7, r3, 48, 48
; P8BE-NEXT:    rldicl r3, r3, 32, 48
; P8BE-NEXT:    extsh r4, r4
; P8BE-NEXT:    extsh r7, r7
; P8BE-NEXT:    extsh r3, r3
; P8BE-NEXT:    mulhw r5, r4, r5
; P8BE-NEXT:    mulhw r6, r7, r6
; P8BE-NEXT:    mulhw r8, r3, r8
; P8BE-NEXT:    srwi r9, r5, 31
; P8BE-NEXT:    srawi r5, r5, 11
; P8BE-NEXT:    add r6, r6, r7
; P8BE-NEXT:    add r8, r8, r3
; P8BE-NEXT:    add r5, r5, r9
; P8BE-NEXT:    srwi r9, r6, 31
; P8BE-NEXT:    srawi r6, r6, 4
; P8BE-NEXT:    add r6, r6, r9
; P8BE-NEXT:    srwi r9, r8, 31
; P8BE-NEXT:    srawi r8, r8, 9
; P8BE-NEXT:    mulli r5, r5, 5423
; P8BE-NEXT:    add r8, r8, r9
; P8BE-NEXT:    mulli r6, r6, 23
; P8BE-NEXT:    li r9, 0
; P8BE-NEXT:    mulli r8, r8, 654
; P8BE-NEXT:    sub r4, r4, r5
; P8BE-NEXT:    sldi r5, r9, 48
; P8BE-NEXT:    mtvsrd v2, r5
; P8BE-NEXT:    sub r5, r7, r6
; P8BE-NEXT:    sldi r4, r4, 48
; P8BE-NEXT:    sub r3, r3, r8
; P8BE-NEXT:    mtvsrd v3, r4
; P8BE-NEXT:    sldi r4, r5, 48
; P8BE-NEXT:    sldi r3, r3, 48
; P8BE-NEXT:    mtvsrd v4, r4
; P8BE-NEXT:    mtvsrd v5, r3
; P8BE-NEXT:    vmrghh v3, v4, v3
; P8BE-NEXT:    vmrghh v2, v2, v5
; P8BE-NEXT:    vmrghw v2, v2, v3
; P8BE-NEXT:    blr
  %1 = srem <4 x i16> %x, <i16 1, i16 654, i16 23, i16 5423>
  ret <4 x i16> %1
}

; Don't fold if the divisor is 2^15.
define <4 x i16> @dont_fold_urem_i16_smax(<4 x i16> %x) {
; P9LE-LABEL: dont_fold_urem_i16_smax:
; P9LE:       # %bb.0:
; P9LE-NEXT:    li r3, 4
; P9LE-NEXT:    lis r4, -19946
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    ori r4, r4, 17097
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    add r4, r4, r3
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 4
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 23
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    lis r4, 24749
; P9LE-NEXT:    mtvsrd v3, r3
; P9LE-NEXT:    li r3, 6
; P9LE-NEXT:    ori r4, r4, 47143
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    mulhw r4, r3, r4
; P9LE-NEXT:    srwi r5, r4, 31
; P9LE-NEXT:    srawi r4, r4, 11
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 5423
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    li r3, 2
; P9LE-NEXT:    vextuhrx r3, r3, v2
; P9LE-NEXT:    vmrghh v3, v4, v3
; P9LE-NEXT:    extsh r3, r3
; P9LE-NEXT:    srawi r4, r3, 15
; P9LE-NEXT:    addze r4, r4
; P9LE-NEXT:    slwi r4, r4, 15
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mtvsrd v2, r3
; P9LE-NEXT:    li r3, 0
; P9LE-NEXT:    mtvsrd v4, r3
; P9LE-NEXT:    vmrghh v2, v2, v4
; P9LE-NEXT:    vmrglw v2, v3, v2
; P9LE-NEXT:    blr
;
; P9BE-LABEL: dont_fold_urem_i16_smax:
; P9BE:       # %bb.0:
; P9BE-NEXT:    li r3, 4
; P9BE-NEXT:    lis r4, -19946
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    ori r4, r4, 17097
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    add r4, r4, r3
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 4
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 23
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    lis r4, 24749
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    ori r4, r4, 47143
; P9BE-NEXT:    mtvsrd v3, r3
; P9BE-NEXT:    li r3, 6
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    mulhw r4, r3, r4
; P9BE-NEXT:    srwi r5, r4, 31
; P9BE-NEXT:    srawi r4, r4, 11
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 5423
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    li r3, 2
; P9BE-NEXT:    vextuhlx r3, r3, v2
; P9BE-NEXT:    vmrghh v3, v3, v4
; P9BE-NEXT:    extsh r3, r3
; P9BE-NEXT:    srawi r4, r3, 15
; P9BE-NEXT:    addze r4, r4
; P9BE-NEXT:    slwi r4, r4, 15
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v2, r3
; P9BE-NEXT:    li r3, 0
; P9BE-NEXT:    sldi r3, r3, 48
; P9BE-NEXT:    mtvsrd v4, r3
; P9BE-NEXT:    vmrghh v2, v4, v2
; P9BE-NEXT:    vmrghw v2, v2, v3
; P9BE-NEXT:    blr
;
; P8LE-LABEL: dont_fold_urem_i16_smax:
; P8LE:       # %bb.0:
; P8LE-NEXT:    xxswapd vs0, v2
; P8LE-NEXT:    lis r4, 24749
; P8LE-NEXT:    lis r5, -19946
; P8LE-NEXT:    ori r4, r4, 47143
; P8LE-NEXT:    ori r5, r5, 17097
; P8LE-NEXT:    mffprd r3, f0
; P8LE-NEXT:    rldicl r6, r3, 16, 48
; P8LE-NEXT:    rldicl r7, r3, 32, 48
; P8LE-NEXT:    extsh r6, r6
; P8LE-NEXT:    extsh r7, r7
; P8LE-NEXT:    mulhw r4, r6, r4
; P8LE-NEXT:    mulhw r5, r7, r5
; P8LE-NEXT:    rldicl r3, r3, 48, 48
; P8LE-NEXT:    extsh r3, r3
; P8LE-NEXT:    srwi r8, r4, 31
; P8LE-NEXT:    srawi r4, r4, 11
; P8LE-NEXT:    add r5, r5, r7
; P8LE-NEXT:    add r4, r4, r8
; P8LE-NEXT:    srwi r8, r5, 31
; P8LE-NEXT:    srawi r5, r5, 4
; P8LE-NEXT:    mulli r4, r4, 5423
; P8LE-NEXT:    add r5, r5, r8
; P8LE-NEXT:    srawi r9, r3, 15
; P8LE-NEXT:    li r8, 0
; P8LE-NEXT:    mulli r5, r5, 23
; P8LE-NEXT:    mtvsrd v2, r8
; P8LE-NEXT:    sub r4, r6, r4
; P8LE-NEXT:    addze r6, r9
; P8LE-NEXT:    slwi r6, r6, 15
; P8LE-NEXT:    mtvsrd v3, r4
; P8LE-NEXT:    sub r5, r7, r5
; P8LE-NEXT:    sub r3, r3, r6
; P8LE-NEXT:    mtvsrd v4, r5
; P8LE-NEXT:    mtvsrd v5, r3
; P8LE-NEXT:    vmrghh v3, v3, v4
; P8LE-NEXT:    vmrghh v2, v5, v2
; P8LE-NEXT:    vmrglw v2, v3, v2
; P8LE-NEXT:    blr
;
; P8BE-LABEL: dont_fold_urem_i16_smax:
; P8BE:       # %bb.0:
; P8BE-NEXT:    mfvsrd r3, v2
; P8BE-NEXT:    lis r4, 24749
; P8BE-NEXT:    lis r5, -19946
; P8BE-NEXT:    ori r4, r4, 47143
; P8BE-NEXT:    ori r5, r5, 17097
; P8BE-NEXT:    clrldi r6, r3, 48
; P8BE-NEXT:    rldicl r7, r3, 48, 48
; P8BE-NEXT:    extsh r6, r6
; P8BE-NEXT:    extsh r7, r7
; P8BE-NEXT:    mulhw r4, r6, r4
; P8BE-NEXT:    mulhw r5, r7, r5
; P8BE-NEXT:    rldicl r3, r3, 32, 48
; P8BE-NEXT:    extsh r3, r3
; P8BE-NEXT:    srwi r8, r4, 31
; P8BE-NEXT:    srawi r4, r4, 11
; P8BE-NEXT:    add r5, r5, r7
; P8BE-NEXT:    add r4, r4, r8
; P8BE-NEXT:    srwi r8, r5, 31
; P8BE-NEXT:    srawi r5, r5, 4
; P8BE-NEXT:    mulli r4, r4, 5423
; P8BE-NEXT:    add r5, r5, r8
; P8BE-NEXT:    li r8, 0
; P8BE-NEXT:    mulli r5, r5, 23
; P8BE-NEXT:    srawi r9, r3, 15
; P8BE-NEXT:    sub r4, r6, r4
; P8BE-NEXT:    sldi r6, r8, 48
; P8BE-NEXT:    addze r8, r9
; P8BE-NEXT:    mtvsrd v2, r6
; P8BE-NEXT:    slwi r6, r8, 15
; P8BE-NEXT:    sldi r4, r4, 48
; P8BE-NEXT:    sub r5, r7, r5
; P8BE-NEXT:    sub r3, r3, r6
; P8BE-NEXT:    mtvsrd v3, r4
; P8BE-NEXT:    sldi r4, r5, 48
; P8BE-NEXT:    sldi r3, r3, 48
; P8BE-NEXT:    mtvsrd v4, r4
; P8BE-NEXT:    mtvsrd v5, r3
; P8BE-NEXT:    vmrghh v3, v4, v3
; P8BE-NEXT:    vmrghh v2, v2, v5
; P8BE-NEXT:    vmrghw v2, v2, v3
; P8BE-NEXT:    blr
  %1 = srem <4 x i16> %x, <i16 1, i16 32768, i16 23, i16 5423>
  ret <4 x i16> %1
}

; Don't fold i64 srem.
define <4 x i64> @dont_fold_srem_i64(<4 x i64> %x) {
; P9LE-LABEL: dont_fold_srem_i64:
; P9LE:       # %bb.0:
; P9LE-NEXT:    lis r4, 24749
; P9LE-NEXT:    mfvsrd r3, v3
; P9LE-NEXT:    ori r4, r4, 47142
; P9LE-NEXT:    sldi r4, r4, 32
; P9LE-NEXT:    oris r4, r4, 58853
; P9LE-NEXT:    ori r4, r4, 6055
; P9LE-NEXT:    mulhd r4, r3, r4
; P9LE-NEXT:    rldicl r5, r4, 1, 63
; P9LE-NEXT:    sradi r4, r4, 11
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    lis r5, -19946
; P9LE-NEXT:    mulli r4, r4, 5423
; P9LE-NEXT:    ori r5, r5, 17096
; P9LE-NEXT:    sldi r5, r5, 32
; P9LE-NEXT:    oris r5, r5, 22795
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    mfvsrld r4, v3
; P9LE-NEXT:    ori r5, r5, 8549
; P9LE-NEXT:    mulhd r5, r4, r5
; P9LE-NEXT:    add r5, r5, r4
; P9LE-NEXT:    rldicl r6, r5, 1, 63
; P9LE-NEXT:    sradi r5, r5, 4
; P9LE-NEXT:    add r5, r5, r6
; P9LE-NEXT:    mulli r5, r5, 23
; P9LE-NEXT:    sub r4, r4, r5
; P9LE-NEXT:    mtvsrdd v3, r3, r4
; P9LE-NEXT:    lis r4, 25653
; P9LE-NEXT:    mfvsrd r3, v2
; P9LE-NEXT:    ori r4, r4, 15432
; P9LE-NEXT:    sldi r4, r4, 32
; P9LE-NEXT:    oris r4, r4, 1603
; P9LE-NEXT:    ori r4, r4, 21445
; P9LE-NEXT:    mulhd r4, r3, r4
; P9LE-NEXT:    rldicl r5, r4, 1, 63
; P9LE-NEXT:    sradi r4, r4, 8
; P9LE-NEXT:    add r4, r4, r5
; P9LE-NEXT:    mulli r4, r4, 654
; P9LE-NEXT:    sub r3, r3, r4
; P9LE-NEXT:    li r4, 0
; P9LE-NEXT:    mtvsrdd v2, r3, r4
; P9LE-NEXT:    blr
;
; P9BE-LABEL: dont_fold_srem_i64:
; P9BE:       # %bb.0:
; P9BE-NEXT:    lis r4, 24749
; P9BE-NEXT:    mfvsrld r3, v3
; P9BE-NEXT:    ori r4, r4, 47142
; P9BE-NEXT:    sldi r4, r4, 32
; P9BE-NEXT:    oris r4, r4, 58853
; P9BE-NEXT:    ori r4, r4, 6055
; P9BE-NEXT:    mulhd r4, r3, r4
; P9BE-NEXT:    rldicl r5, r4, 1, 63
; P9BE-NEXT:    sradi r4, r4, 11
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    lis r5, -19946
; P9BE-NEXT:    ori r5, r5, 17096
; P9BE-NEXT:    mulli r4, r4, 5423
; P9BE-NEXT:    sldi r5, r5, 32
; P9BE-NEXT:    oris r5, r5, 22795
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    mfvsrd r4, v3
; P9BE-NEXT:    ori r5, r5, 8549
; P9BE-NEXT:    mulhd r5, r4, r5
; P9BE-NEXT:    add r5, r5, r4
; P9BE-NEXT:    rldicl r6, r5, 1, 63
; P9BE-NEXT:    sradi r5, r5, 4
; P9BE-NEXT:    add r5, r5, r6
; P9BE-NEXT:    mulli r5, r5, 23
; P9BE-NEXT:    sub r4, r4, r5
; P9BE-NEXT:    mtvsrdd v3, r4, r3
; P9BE-NEXT:    lis r4, 25653
; P9BE-NEXT:    mfvsrld r3, v2
; P9BE-NEXT:    ori r4, r4, 15432
; P9BE-NEXT:    sldi r4, r4, 32
; P9BE-NEXT:    oris r4, r4, 1603
; P9BE-NEXT:    ori r4, r4, 21445
; P9BE-NEXT:    mulhd r4, r3, r4
; P9BE-NEXT:    rldicl r5, r4, 1, 63
; P9BE-NEXT:    sradi r4, r4, 8
; P9BE-NEXT:    add r4, r4, r5
; P9BE-NEXT:    mulli r4, r4, 654
; P9BE-NEXT:    sub r3, r3, r4
; P9BE-NEXT:    mtvsrdd v2, 0, r3
; P9BE-NEXT:    blr
;
; P8LE-LABEL: dont_fold_srem_i64:
; P8LE:       # %bb.0:
; P8LE-NEXT:    lis r3, 24749
; P8LE-NEXT:    lis r4, -19946
; P8LE-NEXT:    lis r5, 25653
; P8LE-NEXT:    xxswapd vs0, v3
; P8LE-NEXT:    mfvsrd r6, v3
; P8LE-NEXT:    ori r3, r3, 47142
; P8LE-NEXT:    ori r4, r4, 17096
; P8LE-NEXT:    ori r5, r5, 15432
; P8LE-NEXT:    mfvsrd r7, v2
; P8LE-NEXT:    sldi r3, r3, 32
; P8LE-NEXT:    sldi r4, r4, 32
; P8LE-NEXT:    sldi r5, r5, 32
; P8LE-NEXT:    oris r3, r3, 58853
; P8LE-NEXT:    oris r4, r4, 22795
; P8LE-NEXT:    mffprd r8, f0
; P8LE-NEXT:    oris r5, r5, 1603
; P8LE-NEXT:    ori r3, r3, 6055
; P8LE-NEXT:    ori r4, r4, 8549
; P8LE-NEXT:    ori r5, r5, 21445
; P8LE-NEXT:    mulhd r3, r6, r3
; P8LE-NEXT:    mulhd r5, r7, r5
; P8LE-NEXT:    mulhd r4, r8, r4
; P8LE-NEXT:    rldicl r9, r3, 1, 63
; P8LE-NEXT:    sradi r3, r3, 11
; P8LE-NEXT:    add r3, r3, r9
; P8LE-NEXT:    rldicl r9, r5, 1, 63
; P8LE-NEXT:    add r4, r4, r8
; P8LE-NEXT:    sradi r5, r5, 8
; P8LE-NEXT:    mulli r3, r3, 5423
; P8LE-NEXT:    add r5, r5, r9
; P8LE-NEXT:    rldicl r9, r4, 1, 63
; P8LE-NEXT:    sradi r4, r4, 4
; P8LE-NEXT:    mulli r5, r5, 654
; P8LE-NEXT:    add r4, r4, r9
; P8LE-NEXT:    mulli r4, r4, 23
; P8LE-NEXT:    sub r3, r6, r3
; P8LE-NEXT:    mtfprd f0, r3
; P8LE-NEXT:    sub r5, r7, r5
; P8LE-NEXT:    mtfprd f1, r5
; P8LE-NEXT:    sub r3, r8, r4
; P8LE-NEXT:    li r4, 0
; P8LE-NEXT:    mtfprd f2, r3
; P8LE-NEXT:    mtfprd f3, r4
; P8LE-NEXT:    xxmrghd v3, vs0, vs2
; P8LE-NEXT:    xxmrghd v2, vs1, vs3
; P8LE-NEXT:    blr
;
; P8BE-LABEL: dont_fold_srem_i64:
; P8BE:       # %bb.0:
; P8BE-NEXT:    lis r4, -19946
; P8BE-NEXT:    lis r3, 24749
; P8BE-NEXT:    xxswapd vs0, v3
; P8BE-NEXT:    lis r5, 25653
; P8BE-NEXT:    xxswapd vs1, v2
; P8BE-NEXT:    ori r4, r4, 17096
; P8BE-NEXT:    ori r3, r3, 47142
; P8BE-NEXT:    ori r5, r5, 15432
; P8BE-NEXT:    mfvsrd r6, v3
; P8BE-NEXT:    sldi r4, r4, 32
; P8BE-NEXT:    sldi r3, r3, 32
; P8BE-NEXT:    oris r4, r4, 22795
; P8BE-NEXT:    sldi r5, r5, 32
; P8BE-NEXT:    oris r3, r3, 58853
; P8BE-NEXT:    mffprd r7, f0
; P8BE-NEXT:    ori r4, r4, 8549
; P8BE-NEXT:    ori r3, r3, 6055
; P8BE-NEXT:    oris r5, r5, 1603
; P8BE-NEXT:    mffprd r8, f1
; P8BE-NEXT:    mulhd r4, r6, r4
; P8BE-NEXT:    mulhd r3, r7, r3
; P8BE-NEXT:    ori r5, r5, 21445
; P8BE-NEXT:    mulhd r5, r8, r5
; P8BE-NEXT:    add r4, r4, r6
; P8BE-NEXT:    rldicl r9, r3, 1, 63
; P8BE-NEXT:    sradi r3, r3, 11
; P8BE-NEXT:    rldicl r10, r4, 1, 63
; P8BE-NEXT:    sradi r4, r4, 4
; P8BE-NEXT:    add r3, r3, r9
; P8BE-NEXT:    rldicl r9, r5, 1, 63
; P8BE-NEXT:    add r4, r4, r10
; P8BE-NEXT:    sradi r5, r5, 8
; P8BE-NEXT:    mulli r3, r3, 5423
; P8BE-NEXT:    add r5, r5, r9
; P8BE-NEXT:    mulli r4, r4, 23
; P8BE-NEXT:    mulli r5, r5, 654
; P8BE-NEXT:    sub r3, r7, r3
; P8BE-NEXT:    sub r4, r6, r4
; P8BE-NEXT:    mtfprd f0, r3
; P8BE-NEXT:    sub r3, r8, r5
; P8BE-NEXT:    mtfprd f1, r4
; P8BE-NEXT:    li r4, 0
; P8BE-NEXT:    mtfprd f2, r3
; P8BE-NEXT:    mtfprd f3, r4
; P8BE-NEXT:    xxmrghd v3, vs1, vs0
; P8BE-NEXT:    xxmrghd v2, vs3, vs2
; P8BE-NEXT:    blr
  %1 = srem <4 x i64> %x, <i64 1, i64 654, i64 23, i64 5423>
  ret <4 x i64> %1
}
