// NOTE: Assertions have been autogenerated by utils/generate-test-checks.py
// RUN: mlir-opt %s -test-sparsification | FileCheck %s

#trait_dd = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // A
    affine_map<(i,j) -> (i,j)>,  // B
    affine_map<(i,j) -> (i,j)>   // X (out)
  ],
  sparse = [
    [ "D", "D" ],  // A
    [ "D", "D" ],  // B
    [ "D", "D" ]   // X
  ],
  iterator_types = ["parallel", "parallel"],
  doc = "X(i,j) = A(i,j) OP B(i,j)"
}

// CHECK-LABEL:   func @add_dd(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 32 : index
// CHECK:           %[[VAL_3:.*]] = constant 16 : index
// CHECK:           %[[VAL_4:.*]] = constant 0 : index
// CHECK:           %[[VAL_5:.*]] = constant 1 : index
// CHECK:           %[[VAL_6:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_7:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_8:.*]] = alloca() : memref<32x16xf32>
// CHECK:           scf.for %[[VAL_9:.*]] = %[[VAL_4]] to %[[VAL_2]] step %[[VAL_5]] {
// CHECK:             scf.for %[[VAL_10:.*]] = %[[VAL_4]] to %[[VAL_3]] step %[[VAL_5]] {
// CHECK:               %[[VAL_11:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_9]], %[[VAL_10]]] : memref<32x16xf32>
// CHECK:               %[[VAL_12:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_9]], %[[VAL_10]]] : memref<32x16xf32>
// CHECK:               %[[VAL_13:.*]] = addf %[[VAL_11]], %[[VAL_12]] : f32
// CHECK:               store %[[VAL_13]], %[[VAL_8]]{{\[}}%[[VAL_9]], %[[VAL_10]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_14:.*]] = tensor_load %[[VAL_8]] : memref<32x16xf32>
// CHECK:           return %[[VAL_14]] : tensor<32x16xf32>
// CHECK:         }
func @add_dd(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_dd
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = addf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

// CHECK-LABEL:   func @mul_dd(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 32 : index
// CHECK:           %[[VAL_3:.*]] = constant 16 : index
// CHECK:           %[[VAL_4:.*]] = constant 0 : index
// CHECK:           %[[VAL_5:.*]] = constant 1 : index
// CHECK:           %[[VAL_6:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_7:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_8:.*]] = alloca() : memref<32x16xf32>
// CHECK:           scf.for %[[VAL_9:.*]] = %[[VAL_4]] to %[[VAL_2]] step %[[VAL_5]] {
// CHECK:             scf.for %[[VAL_10:.*]] = %[[VAL_4]] to %[[VAL_3]] step %[[VAL_5]] {
// CHECK:               %[[VAL_11:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_9]], %[[VAL_10]]] : memref<32x16xf32>
// CHECK:               %[[VAL_12:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_9]], %[[VAL_10]]] : memref<32x16xf32>
// CHECK:               %[[VAL_13:.*]] = mulf %[[VAL_11]], %[[VAL_12]] : f32
// CHECK:               store %[[VAL_13]], %[[VAL_8]]{{\[}}%[[VAL_9]], %[[VAL_10]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_14:.*]] = tensor_load %[[VAL_8]] : memref<32x16xf32>
// CHECK:           return %[[VAL_14]] : tensor<32x16xf32>
// CHECK:         }
func @mul_dd(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_dd
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = mulf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

#trait_ds = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // A
    affine_map<(i,j) -> (i,j)>,  // B
    affine_map<(i,j) -> (i,j)>   // X (out)
  ],
  sparse = [
    [ "D", "S" ],  // A
    [ "D", "D" ],  // B
    [ "D", "D" ]   // X
  ],
  iterator_types = ["parallel", "parallel"],
  doc = "X(i,j) = A(i,j) OP B(i,j)"
}

// CHECK-LABEL:   func @add_ds(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 32 : index
// CHECK:           %[[VAL_4:.*]] = constant 16 : index
// CHECK:           %[[VAL_5:.*]] = constant 0 : index
// CHECK:           %[[VAL_6:.*]] = constant true
// CHECK:           %[[VAL_7:.*]] = constant 1 : index
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_10:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_11:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_12:.*]] = alloca() : memref<32x16xf32>
// CHECK:           scf.for %[[VAL_13:.*]] = %[[VAL_5]] to %[[VAL_3]] step %[[VAL_7]] {
// CHECK:             %[[VAL_14:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_13]]] : memref<?xindex>
// CHECK:             %[[VAL_15:.*]] = addi %[[VAL_13]], %[[VAL_7]] : index
// CHECK:             %[[VAL_16:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_15]]] : memref<?xindex>
// CHECK:             %[[VAL_17:.*]]:2 = scf.while (%[[VAL_18:.*]] = %[[VAL_14]], %[[VAL_19:.*]] = %[[VAL_5]]) : (index, index) -> (index, index) {
// CHECK:               %[[VAL_20:.*]] = cmpi "ult", %[[VAL_18]], %[[VAL_16]] : index
// CHECK:               scf.condition(%[[VAL_20]]) %[[VAL_18]], %[[VAL_19]] : index, index
// CHECK:             } do {
// CHECK:             ^bb0(%[[VAL_21:.*]]: index, %[[VAL_22:.*]]: index):
// CHECK:               %[[VAL_23:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_21]]] : memref<?xindex>
// CHECK:               %[[VAL_24:.*]] = cmpi "eq", %[[VAL_23]], %[[VAL_22]] : index
// CHECK:               scf.if %[[VAL_24]] {
// CHECK:                 %[[VAL_25:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_21]]] : memref<?xf32>
// CHECK:                 %[[VAL_26:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_13]], %[[VAL_22]]] : memref<32x16xf32>
// CHECK:                 %[[VAL_27:.*]] = addf %[[VAL_25]], %[[VAL_26]] : f32
// CHECK:                 store %[[VAL_27]], %[[VAL_12]]{{\[}}%[[VAL_13]], %[[VAL_22]]] : memref<32x16xf32>
// CHECK:               } else {
// CHECK:                 scf.if %[[VAL_6]] {
// CHECK:                   %[[VAL_28:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_13]], %[[VAL_22]]] : memref<32x16xf32>
// CHECK:                   store %[[VAL_28]], %[[VAL_12]]{{\[}}%[[VAL_13]], %[[VAL_22]]] : memref<32x16xf32>
// CHECK:                 } else {
// CHECK:                 }
// CHECK:               }
// CHECK:               %[[VAL_29:.*]] = cmpi "eq", %[[VAL_23]], %[[VAL_22]] : index
// CHECK:               %[[VAL_30:.*]] = addi %[[VAL_21]], %[[VAL_7]] : index
// CHECK:               %[[VAL_31:.*]] = select %[[VAL_29]], %[[VAL_30]], %[[VAL_21]] : index
// CHECK:               %[[VAL_32:.*]] = addi %[[VAL_22]], %[[VAL_7]] : index
// CHECK:               scf.yield %[[VAL_31]], %[[VAL_32]] : index, index
// CHECK:             }
// CHECK:             scf.for %[[VAL_33:.*]] = %[[VAL_34:.*]]#1 to %[[VAL_4]] step %[[VAL_7]] {
// CHECK:               %[[VAL_35:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_13]], %[[VAL_33]]] : memref<32x16xf32>
// CHECK:               store %[[VAL_35]], %[[VAL_12]]{{\[}}%[[VAL_13]], %[[VAL_33]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_36:.*]] = tensor_load %[[VAL_12]] : memref<32x16xf32>
// CHECK:           return %[[VAL_36]] : tensor<32x16xf32>
// CHECK:         }
func @add_ds(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_ds
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = addf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

// CHECK-LABEL:   func @mul_ds(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 32 : index
// CHECK:           %[[VAL_4:.*]] = constant 0 : index
// CHECK:           %[[VAL_5:.*]] = constant 1 : index
// CHECK:           %[[VAL_6:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_9:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_10:.*]] = alloca() : memref<32x16xf32>
// CHECK:           scf.for %[[VAL_11:.*]] = %[[VAL_4]] to %[[VAL_3]] step %[[VAL_5]] {
// CHECK:             %[[VAL_12:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_11]]] : memref<?xindex>
// CHECK:             %[[VAL_13:.*]] = addi %[[VAL_11]], %[[VAL_5]] : index
// CHECK:             %[[VAL_14:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_13]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_15:.*]] = %[[VAL_12]] to %[[VAL_14]] step %[[VAL_5]] {
// CHECK:               %[[VAL_16:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_15]]] : memref<?xindex>
// CHECK:               %[[VAL_17:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_15]]] : memref<?xf32>
// CHECK:               %[[VAL_18:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_11]], %[[VAL_16]]] : memref<32x16xf32>
// CHECK:               %[[VAL_19:.*]] = mulf %[[VAL_17]], %[[VAL_18]] : f32
// CHECK:               store %[[VAL_19]], %[[VAL_10]]{{\[}}%[[VAL_11]], %[[VAL_16]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_20:.*]] = tensor_load %[[VAL_10]] : memref<32x16xf32>
// CHECK:           return %[[VAL_20]] : tensor<32x16xf32>
// CHECK:         }
func @mul_ds(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_ds
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = mulf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

#trait_sd = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // A
    affine_map<(i,j) -> (i,j)>,  // B
    affine_map<(i,j) -> (i,j)>   // X (out)
  ],
  sparse = [
    [ "S", "D" ],  // A
    [ "D", "D" ],  // B
    [ "D", "D" ]   // X
  ],
  iterator_types = ["parallel", "parallel"],
  doc = "X(i,j) = A(i,j) OP B(i,j)"
}

// CHECK-LABEL:   func @add_sd(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 32 : index
// CHECK:           %[[VAL_4:.*]] = constant 16 : index
// CHECK:           %[[VAL_5:.*]] = constant true
// CHECK:           %[[VAL_6:.*]] = constant 0 : index
// CHECK:           %[[VAL_7:.*]] = constant 1 : index
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_10:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_11:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_12:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_13:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_6]]] : memref<?xindex>
// CHECK:           %[[VAL_14:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_7]]] : memref<?xindex>
// CHECK:           %[[VAL_15:.*]]:2 = scf.while (%[[VAL_16:.*]] = %[[VAL_13]], %[[VAL_17:.*]] = %[[VAL_6]]) : (index, index) -> (index, index) {
// CHECK:             %[[VAL_18:.*]] = cmpi "ult", %[[VAL_16]], %[[VAL_14]] : index
// CHECK:             scf.condition(%[[VAL_18]]) %[[VAL_16]], %[[VAL_17]] : index, index
// CHECK:           } do {
// CHECK:           ^bb0(%[[VAL_19:.*]]: index, %[[VAL_20:.*]]: index):
// CHECK:             %[[VAL_21:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_19]]] : memref<?xindex>
// CHECK:             %[[VAL_22:.*]] = cmpi "eq", %[[VAL_21]], %[[VAL_20]] : index
// CHECK:             scf.if %[[VAL_22]] {
// CHECK:               scf.for %[[VAL_23:.*]] = %[[VAL_6]] to %[[VAL_4]] step %[[VAL_7]] {
// CHECK:                 %[[VAL_24:.*]] = muli %[[VAL_19]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_25:.*]] = addi %[[VAL_24]], %[[VAL_23]] : index
// CHECK:                 %[[VAL_26:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_25]]] : memref<?xf32>
// CHECK:                 %[[VAL_27:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_20]], %[[VAL_23]]] : memref<32x16xf32>
// CHECK:                 %[[VAL_28:.*]] = addf %[[VAL_26]], %[[VAL_27]] : f32
// CHECK:                 store %[[VAL_28]], %[[VAL_12]]{{\[}}%[[VAL_20]], %[[VAL_23]]] : memref<32x16xf32>
// CHECK:               }
// CHECK:             } else {
// CHECK:               scf.if %[[VAL_5]] {
// CHECK:                 scf.for %[[VAL_29:.*]] = %[[VAL_6]] to %[[VAL_4]] step %[[VAL_7]] {
// CHECK:                   %[[VAL_30:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_20]], %[[VAL_29]]] : memref<32x16xf32>
// CHECK:                   store %[[VAL_30]], %[[VAL_12]]{{\[}}%[[VAL_20]], %[[VAL_29]]] : memref<32x16xf32>
// CHECK:                 }
// CHECK:               } else {
// CHECK:               }
// CHECK:             }
// CHECK:             %[[VAL_31:.*]] = cmpi "eq", %[[VAL_21]], %[[VAL_20]] : index
// CHECK:             %[[VAL_32:.*]] = addi %[[VAL_19]], %[[VAL_7]] : index
// CHECK:             %[[VAL_33:.*]] = select %[[VAL_31]], %[[VAL_32]], %[[VAL_19]] : index
// CHECK:             %[[VAL_34:.*]] = addi %[[VAL_20]], %[[VAL_7]] : index
// CHECK:             scf.yield %[[VAL_33]], %[[VAL_34]] : index, index
// CHECK:           }
// CHECK:           scf.for %[[VAL_35:.*]] = %[[VAL_36:.*]]#1 to %[[VAL_3]] step %[[VAL_7]] {
// CHECK:             scf.for %[[VAL_37:.*]] = %[[VAL_6]] to %[[VAL_4]] step %[[VAL_7]] {
// CHECK:               %[[VAL_38:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_35]], %[[VAL_37]]] : memref<32x16xf32>
// CHECK:               store %[[VAL_38]], %[[VAL_12]]{{\[}}%[[VAL_35]], %[[VAL_37]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_39:.*]] = tensor_load %[[VAL_12]] : memref<32x16xf32>
// CHECK:           return %[[VAL_39]] : tensor<32x16xf32>
// CHECK:         }
func @add_sd(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_sd
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = addf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

// CHECK-LABEL:   func @mul_sd(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 16 : index
// CHECK:           %[[VAL_4:.*]] = constant 0 : index
// CHECK:           %[[VAL_5:.*]] = constant 1 : index
// CHECK:           %[[VAL_6:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_9:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_10:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_11:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_12:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_5]]] : memref<?xindex>
// CHECK:           scf.for %[[VAL_13:.*]] = %[[VAL_11]] to %[[VAL_12]] step %[[VAL_5]] {
// CHECK:             %[[VAL_14:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_13]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_15:.*]] = %[[VAL_4]] to %[[VAL_3]] step %[[VAL_5]] {
// CHECK:               %[[VAL_16:.*]] = muli %[[VAL_13]], %[[VAL_3]] : index
// CHECK:               %[[VAL_17:.*]] = addi %[[VAL_16]], %[[VAL_15]] : index
// CHECK:               %[[VAL_18:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_17]]] : memref<?xf32>
// CHECK:               %[[VAL_19:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_14]], %[[VAL_15]]] : memref<32x16xf32>
// CHECK:               %[[VAL_20:.*]] = mulf %[[VAL_18]], %[[VAL_19]] : f32
// CHECK:               store %[[VAL_20]], %[[VAL_10]]{{\[}}%[[VAL_14]], %[[VAL_15]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_21:.*]] = tensor_load %[[VAL_10]] : memref<32x16xf32>
// CHECK:           return %[[VAL_21]] : tensor<32x16xf32>
// CHECK:         }
func @mul_sd(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_sd
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = mulf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

#trait_ss = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // A
    affine_map<(i,j) -> (i,j)>,  // B
    affine_map<(i,j) -> (i,j)>   // X (out)
  ],
  sparse = [
    [ "S", "S" ],  // A
    [ "D", "D" ],  // B
    [ "D", "D" ]   // X
  ],
  iterator_types = ["parallel", "parallel"],
  doc = "X(i,j) = A(i,j) OP B(i,j)"
}

// CHECK-LABEL:   func @add_ss(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 32 : index
// CHECK:           %[[VAL_4:.*]] = constant 16 : index
// CHECK:           %[[VAL_5:.*]] = constant true
// CHECK:           %[[VAL_6:.*]] = constant 0 : index
// CHECK:           %[[VAL_7:.*]] = constant 1 : index
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_10:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_11:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_12:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_13:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_14:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_15:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_6]]] : memref<?xindex>
// CHECK:           %[[VAL_16:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_7]]] : memref<?xindex>
// CHECK:           %[[VAL_17:.*]]:2 = scf.while (%[[VAL_18:.*]] = %[[VAL_15]], %[[VAL_19:.*]] = %[[VAL_6]]) : (index, index) -> (index, index) {
// CHECK:             %[[VAL_20:.*]] = cmpi "ult", %[[VAL_18]], %[[VAL_16]] : index
// CHECK:             scf.condition(%[[VAL_20]]) %[[VAL_18]], %[[VAL_19]] : index, index
// CHECK:           } do {
// CHECK:           ^bb0(%[[VAL_21:.*]]: index, %[[VAL_22:.*]]: index):
// CHECK:             %[[VAL_23:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_21]]] : memref<?xindex>
// CHECK:             %[[VAL_24:.*]] = cmpi "eq", %[[VAL_23]], %[[VAL_22]] : index
// CHECK:             scf.if %[[VAL_24]] {
// CHECK:               %[[VAL_25:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_21]]] : memref<?xindex>
// CHECK:               %[[VAL_26:.*]] = addi %[[VAL_21]], %[[VAL_7]] : index
// CHECK:               %[[VAL_27:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:               %[[VAL_28:.*]]:2 = scf.while (%[[VAL_29:.*]] = %[[VAL_25]], %[[VAL_30:.*]] = %[[VAL_6]]) : (index, index) -> (index, index) {
// CHECK:                 %[[VAL_31:.*]] = cmpi "ult", %[[VAL_29]], %[[VAL_27]] : index
// CHECK:                 scf.condition(%[[VAL_31]]) %[[VAL_29]], %[[VAL_30]] : index, index
// CHECK:               } do {
// CHECK:               ^bb0(%[[VAL_32:.*]]: index, %[[VAL_33:.*]]: index):
// CHECK:                 %[[VAL_34:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_32]]] : memref<?xindex>
// CHECK:                 %[[VAL_35:.*]] = cmpi "eq", %[[VAL_34]], %[[VAL_33]] : index
// CHECK:                 scf.if %[[VAL_35]] {
// CHECK:                   %[[VAL_36:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_32]]] : memref<?xf32>
// CHECK:                   %[[VAL_37:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_22]], %[[VAL_33]]] : memref<32x16xf32>
// CHECK:                   %[[VAL_38:.*]] = addf %[[VAL_36]], %[[VAL_37]] : f32
// CHECK:                   store %[[VAL_38]], %[[VAL_14]]{{\[}}%[[VAL_22]], %[[VAL_33]]] : memref<32x16xf32>
// CHECK:                 } else {
// CHECK:                   scf.if %[[VAL_5]] {
// CHECK:                     %[[VAL_39:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_22]], %[[VAL_33]]] : memref<32x16xf32>
// CHECK:                     store %[[VAL_39]], %[[VAL_14]]{{\[}}%[[VAL_22]], %[[VAL_33]]] : memref<32x16xf32>
// CHECK:                   } else {
// CHECK:                   }
// CHECK:                 }
// CHECK:                 %[[VAL_40:.*]] = cmpi "eq", %[[VAL_34]], %[[VAL_33]] : index
// CHECK:                 %[[VAL_41:.*]] = addi %[[VAL_32]], %[[VAL_7]] : index
// CHECK:                 %[[VAL_42:.*]] = select %[[VAL_40]], %[[VAL_41]], %[[VAL_32]] : index
// CHECK:                 %[[VAL_43:.*]] = addi %[[VAL_33]], %[[VAL_7]] : index
// CHECK:                 scf.yield %[[VAL_42]], %[[VAL_43]] : index, index
// CHECK:               }
// CHECK:               scf.for %[[VAL_44:.*]] = %[[VAL_45:.*]]#1 to %[[VAL_4]] step %[[VAL_7]] {
// CHECK:                 %[[VAL_46:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_22]], %[[VAL_44]]] : memref<32x16xf32>
// CHECK:                 store %[[VAL_46]], %[[VAL_14]]{{\[}}%[[VAL_22]], %[[VAL_44]]] : memref<32x16xf32>
// CHECK:               }
// CHECK:             } else {
// CHECK:               scf.if %[[VAL_5]] {
// CHECK:                 scf.for %[[VAL_47:.*]] = %[[VAL_6]] to %[[VAL_4]] step %[[VAL_7]] {
// CHECK:                   %[[VAL_48:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_22]], %[[VAL_47]]] : memref<32x16xf32>
// CHECK:                   store %[[VAL_48]], %[[VAL_14]]{{\[}}%[[VAL_22]], %[[VAL_47]]] : memref<32x16xf32>
// CHECK:                 }
// CHECK:               } else {
// CHECK:               }
// CHECK:             }
// CHECK:             %[[VAL_49:.*]] = cmpi "eq", %[[VAL_23]], %[[VAL_22]] : index
// CHECK:             %[[VAL_50:.*]] = addi %[[VAL_21]], %[[VAL_7]] : index
// CHECK:             %[[VAL_51:.*]] = select %[[VAL_49]], %[[VAL_50]], %[[VAL_21]] : index
// CHECK:             %[[VAL_52:.*]] = addi %[[VAL_22]], %[[VAL_7]] : index
// CHECK:             scf.yield %[[VAL_51]], %[[VAL_52]] : index, index
// CHECK:           }
// CHECK:           scf.for %[[VAL_53:.*]] = %[[VAL_54:.*]]#1 to %[[VAL_3]] step %[[VAL_7]] {
// CHECK:             scf.for %[[VAL_55:.*]] = %[[VAL_6]] to %[[VAL_4]] step %[[VAL_7]] {
// CHECK:               %[[VAL_56:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_53]], %[[VAL_55]]] : memref<32x16xf32>
// CHECK:               store %[[VAL_56]], %[[VAL_14]]{{\[}}%[[VAL_53]], %[[VAL_55]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_57:.*]] = tensor_load %[[VAL_14]] : memref<32x16xf32>
// CHECK:           return %[[VAL_57]] : tensor<32x16xf32>
// CHECK:         }
func @add_ss(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_ss
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = addf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

// CHECK-LABEL:   func @mul_ss(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 0 : index
// CHECK:           %[[VAL_4:.*]] = constant 1 : index
// CHECK:           %[[VAL_5:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_6:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_10:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_11:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_12:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_13:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           scf.for %[[VAL_14:.*]] = %[[VAL_12]] to %[[VAL_13]] step %[[VAL_4]] {
// CHECK:             %[[VAL_15:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_14]]] : memref<?xindex>
// CHECK:             %[[VAL_16:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_14]]] : memref<?xindex>
// CHECK:             %[[VAL_17:.*]] = addi %[[VAL_14]], %[[VAL_4]] : index
// CHECK:             %[[VAL_18:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_17]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_19:.*]] = %[[VAL_16]] to %[[VAL_18]] step %[[VAL_4]] {
// CHECK:               %[[VAL_20:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_19]]] : memref<?xindex>
// CHECK:               %[[VAL_21:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_19]]] : memref<?xf32>
// CHECK:               %[[VAL_22:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_15]], %[[VAL_20]]] : memref<32x16xf32>
// CHECK:               %[[VAL_23:.*]] = mulf %[[VAL_21]], %[[VAL_22]] : f32
// CHECK:               store %[[VAL_23]], %[[VAL_11]]{{\[}}%[[VAL_15]], %[[VAL_20]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_24:.*]] = tensor_load %[[VAL_11]] : memref<32x16xf32>
// CHECK:           return %[[VAL_24]] : tensor<32x16xf32>
// CHECK:         }
func @mul_ss(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_ss
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = mulf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

#trait_ss_ss = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // A
    affine_map<(i,j) -> (i,j)>,  // B
    affine_map<(i,j) -> (i,j)>   // X (out)
  ],
  sparse = [
    [ "S", "S" ],  // A
    [ "S", "S" ],  // B
    [ "D", "D" ]   // X
  ],
  iterator_types = ["parallel", "parallel"],
  doc = "X(i,j) = A(i,j) OP B(i,j)"
}

// CHECK-LABEL:   func @add_ss_ss(
// CHECK-SAME:                    %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                    %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 0 : index
// CHECK:           %[[VAL_4:.*]] = constant 1 : index
// CHECK:           %[[VAL_5:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_6:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_10:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_11:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_12:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_13:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_14:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_15:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_16:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_17:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_18:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_19:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_20:.*]]:2 = scf.while (%[[VAL_21:.*]] = %[[VAL_16]], %[[VAL_22:.*]] = %[[VAL_18]]) : (index, index) -> (index, index) {
// CHECK:             %[[VAL_23:.*]] = cmpi "ult", %[[VAL_21]], %[[VAL_17]] : index
// CHECK:             %[[VAL_24:.*]] = cmpi "ult", %[[VAL_22]], %[[VAL_19]] : index
// CHECK:             %[[VAL_25:.*]] = and %[[VAL_23]], %[[VAL_24]] : i1
// CHECK:             scf.condition(%[[VAL_25]]) %[[VAL_21]], %[[VAL_22]] : index, index
// CHECK:           } do {
// CHECK:           ^bb0(%[[VAL_26:.*]]: index, %[[VAL_27:.*]]: index):
// CHECK:             %[[VAL_28:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:             %[[VAL_29:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:             %[[VAL_30:.*]] = cmpi "ult", %[[VAL_29]], %[[VAL_28]] : index
// CHECK:             %[[VAL_31:.*]] = select %[[VAL_30]], %[[VAL_29]], %[[VAL_28]] : index
// CHECK:             %[[VAL_32:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:             %[[VAL_33:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:             %[[VAL_34:.*]] = and %[[VAL_32]], %[[VAL_33]] : i1
// CHECK:             scf.if %[[VAL_34]] {
// CHECK:               %[[VAL_35:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:               %[[VAL_36:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:               %[[VAL_37:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_36]]] : memref<?xindex>
// CHECK:               %[[VAL_38:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:               %[[VAL_39:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:               %[[VAL_40:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_39]]] : memref<?xindex>
// CHECK:               %[[VAL_41:.*]]:2 = scf.while (%[[VAL_42:.*]] = %[[VAL_35]], %[[VAL_43:.*]] = %[[VAL_38]]) : (index, index) -> (index, index) {
// CHECK:                 %[[VAL_44:.*]] = cmpi "ult", %[[VAL_42]], %[[VAL_37]] : index
// CHECK:                 %[[VAL_45:.*]] = cmpi "ult", %[[VAL_43]], %[[VAL_40]] : index
// CHECK:                 %[[VAL_46:.*]] = and %[[VAL_44]], %[[VAL_45]] : i1
// CHECK:                 scf.condition(%[[VAL_46]]) %[[VAL_42]], %[[VAL_43]] : index, index
// CHECK:               } do {
// CHECK:               ^bb0(%[[VAL_47:.*]]: index, %[[VAL_48:.*]]: index):
// CHECK:                 %[[VAL_49:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_47]]] : memref<?xindex>
// CHECK:                 %[[VAL_50:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_48]]] : memref<?xindex>
// CHECK:                 %[[VAL_51:.*]] = cmpi "ult", %[[VAL_50]], %[[VAL_49]] : index
// CHECK:                 %[[VAL_52:.*]] = select %[[VAL_51]], %[[VAL_50]], %[[VAL_49]] : index
// CHECK:                 %[[VAL_53:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_54:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_55:.*]] = and %[[VAL_53]], %[[VAL_54]] : i1
// CHECK:                 scf.if %[[VAL_55]] {
// CHECK:                   %[[VAL_56:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_47]]] : memref<?xf32>
// CHECK:                   %[[VAL_57:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_48]]] : memref<?xf32>
// CHECK:                   %[[VAL_58:.*]] = addf %[[VAL_56]], %[[VAL_57]] : f32
// CHECK:                   store %[[VAL_58]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_52]]] : memref<32x16xf32>
// CHECK:                 } else {
// CHECK:                   %[[VAL_59:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                   scf.if %[[VAL_59]] {
// CHECK:                     %[[VAL_60:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_47]]] : memref<?xf32>
// CHECK:                     store %[[VAL_60]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_52]]] : memref<32x16xf32>
// CHECK:                   } else {
// CHECK:                     %[[VAL_61:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                     scf.if %[[VAL_61]] {
// CHECK:                       %[[VAL_62:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_48]]] : memref<?xf32>
// CHECK:                       store %[[VAL_62]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_52]]] : memref<32x16xf32>
// CHECK:                     } else {
// CHECK:                     }
// CHECK:                   }
// CHECK:                 }
// CHECK:                 %[[VAL_63:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_64:.*]] = addi %[[VAL_47]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_65:.*]] = select %[[VAL_63]], %[[VAL_64]], %[[VAL_47]] : index
// CHECK:                 %[[VAL_66:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_67:.*]] = addi %[[VAL_48]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_68:.*]] = select %[[VAL_66]], %[[VAL_67]], %[[VAL_48]] : index
// CHECK:                 scf.yield %[[VAL_65]], %[[VAL_68]] : index, index
// CHECK:               }
// CHECK:               scf.for %[[VAL_69:.*]] = %[[VAL_70:.*]]#0 to %[[VAL_37]] step %[[VAL_4]] {
// CHECK:                 %[[VAL_71:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_69]]] : memref<?xindex>
// CHECK:                 %[[VAL_72:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_69]]] : memref<?xf32>
// CHECK:                 store %[[VAL_72]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_71]]] : memref<32x16xf32>
// CHECK:               }
// CHECK:               scf.for %[[VAL_73:.*]] = %[[VAL_74:.*]]#1 to %[[VAL_40]] step %[[VAL_4]] {
// CHECK:                 %[[VAL_75:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_73]]] : memref<?xindex>
// CHECK:                 %[[VAL_76:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_73]]] : memref<?xf32>
// CHECK:                 store %[[VAL_76]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_75]]] : memref<32x16xf32>
// CHECK:               }
// CHECK:             } else {
// CHECK:               %[[VAL_77:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:               scf.if %[[VAL_77]] {
// CHECK:                 %[[VAL_78:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:                 %[[VAL_79:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_80:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_79]]] : memref<?xindex>
// CHECK:                 scf.for %[[VAL_81:.*]] = %[[VAL_78]] to %[[VAL_80]] step %[[VAL_4]] {
// CHECK:                   %[[VAL_82:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_81]]] : memref<?xindex>
// CHECK:                   %[[VAL_83:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_81]]] : memref<?xf32>
// CHECK:                   store %[[VAL_83]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_82]]] : memref<32x16xf32>
// CHECK:                 }
// CHECK:               } else {
// CHECK:                 %[[VAL_84:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:                 scf.if %[[VAL_84]] {
// CHECK:                   %[[VAL_85:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:                   %[[VAL_86:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:                   %[[VAL_87:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_86]]] : memref<?xindex>
// CHECK:                   scf.for %[[VAL_88:.*]] = %[[VAL_85]] to %[[VAL_87]] step %[[VAL_4]] {
// CHECK:                     %[[VAL_89:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_88]]] : memref<?xindex>
// CHECK:                     %[[VAL_90:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_88]]] : memref<?xf32>
// CHECK:                     store %[[VAL_90]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_89]]] : memref<32x16xf32>
// CHECK:                   }
// CHECK:                 } else {
// CHECK:                 }
// CHECK:               }
// CHECK:             }
// CHECK:             %[[VAL_91:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:             %[[VAL_92:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:             %[[VAL_93:.*]] = select %[[VAL_91]], %[[VAL_92]], %[[VAL_26]] : index
// CHECK:             %[[VAL_94:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:             %[[VAL_95:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:             %[[VAL_96:.*]] = select %[[VAL_94]], %[[VAL_95]], %[[VAL_27]] : index
// CHECK:             scf.yield %[[VAL_93]], %[[VAL_96]] : index, index
// CHECK:           }
// CHECK:           scf.for %[[VAL_97:.*]] = %[[VAL_98:.*]]#0 to %[[VAL_17]] step %[[VAL_4]] {
// CHECK:             %[[VAL_99:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_97]]] : memref<?xindex>
// CHECK:             %[[VAL_100:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_97]]] : memref<?xindex>
// CHECK:             %[[VAL_101:.*]] = addi %[[VAL_97]], %[[VAL_4]] : index
// CHECK:             %[[VAL_102:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_101]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_103:.*]] = %[[VAL_100]] to %[[VAL_102]] step %[[VAL_4]] {
// CHECK:               %[[VAL_104:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_103]]] : memref<?xindex>
// CHECK:               %[[VAL_105:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_103]]] : memref<?xf32>
// CHECK:               store %[[VAL_105]], %[[VAL_15]]{{\[}}%[[VAL_99]], %[[VAL_104]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           scf.for %[[VAL_106:.*]] = %[[VAL_107:.*]]#1 to %[[VAL_19]] step %[[VAL_4]] {
// CHECK:             %[[VAL_108:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_106]]] : memref<?xindex>
// CHECK:             %[[VAL_109:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_106]]] : memref<?xindex>
// CHECK:             %[[VAL_110:.*]] = addi %[[VAL_106]], %[[VAL_4]] : index
// CHECK:             %[[VAL_111:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_110]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_112:.*]] = %[[VAL_109]] to %[[VAL_111]] step %[[VAL_4]] {
// CHECK:               %[[VAL_113:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_112]]] : memref<?xindex>
// CHECK:               %[[VAL_114:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_112]]] : memref<?xf32>
// CHECK:               store %[[VAL_114]], %[[VAL_15]]{{\[}}%[[VAL_108]], %[[VAL_113]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_115:.*]] = tensor_load %[[VAL_15]] : memref<32x16xf32>
// CHECK:           return %[[VAL_115]] : tensor<32x16xf32>
// CHECK:         }
func @add_ss_ss(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_ss_ss
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = addf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

// CHECK-LABEL:   func @mul_ss_ss(
// CHECK-SAME:                    %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                    %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 0 : index
// CHECK:           %[[VAL_4:.*]] = constant 1 : index
// CHECK:           %[[VAL_5:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_6:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_10:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_11:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_12:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_13:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_14:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_15:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_16:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_17:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_18:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_19:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_20:.*]]:2 = scf.while (%[[VAL_21:.*]] = %[[VAL_16]], %[[VAL_22:.*]] = %[[VAL_18]]) : (index, index) -> (index, index) {
// CHECK:             %[[VAL_23:.*]] = cmpi "ult", %[[VAL_21]], %[[VAL_17]] : index
// CHECK:             %[[VAL_24:.*]] = cmpi "ult", %[[VAL_22]], %[[VAL_19]] : index
// CHECK:             %[[VAL_25:.*]] = and %[[VAL_23]], %[[VAL_24]] : i1
// CHECK:             scf.condition(%[[VAL_25]]) %[[VAL_21]], %[[VAL_22]] : index, index
// CHECK:           } do {
// CHECK:           ^bb0(%[[VAL_26:.*]]: index, %[[VAL_27:.*]]: index):
// CHECK:             %[[VAL_28:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:             %[[VAL_29:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:             %[[VAL_30:.*]] = cmpi "ult", %[[VAL_29]], %[[VAL_28]] : index
// CHECK:             %[[VAL_31:.*]] = select %[[VAL_30]], %[[VAL_29]], %[[VAL_28]] : index
// CHECK:             %[[VAL_32:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:             %[[VAL_33:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:             %[[VAL_34:.*]] = and %[[VAL_32]], %[[VAL_33]] : i1
// CHECK:             scf.if %[[VAL_34]] {
// CHECK:               %[[VAL_35:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:               %[[VAL_36:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:               %[[VAL_37:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_36]]] : memref<?xindex>
// CHECK:               %[[VAL_38:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:               %[[VAL_39:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:               %[[VAL_40:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_39]]] : memref<?xindex>
// CHECK:               %[[VAL_41:.*]]:2 = scf.while (%[[VAL_42:.*]] = %[[VAL_35]], %[[VAL_43:.*]] = %[[VAL_38]]) : (index, index) -> (index, index) {
// CHECK:                 %[[VAL_44:.*]] = cmpi "ult", %[[VAL_42]], %[[VAL_37]] : index
// CHECK:                 %[[VAL_45:.*]] = cmpi "ult", %[[VAL_43]], %[[VAL_40]] : index
// CHECK:                 %[[VAL_46:.*]] = and %[[VAL_44]], %[[VAL_45]] : i1
// CHECK:                 scf.condition(%[[VAL_46]]) %[[VAL_42]], %[[VAL_43]] : index, index
// CHECK:               } do {
// CHECK:               ^bb0(%[[VAL_47:.*]]: index, %[[VAL_48:.*]]: index):
// CHECK:                 %[[VAL_49:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_47]]] : memref<?xindex>
// CHECK:                 %[[VAL_50:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_48]]] : memref<?xindex>
// CHECK:                 %[[VAL_51:.*]] = cmpi "ult", %[[VAL_50]], %[[VAL_49]] : index
// CHECK:                 %[[VAL_52:.*]] = select %[[VAL_51]], %[[VAL_50]], %[[VAL_49]] : index
// CHECK:                 %[[VAL_53:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_54:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_55:.*]] = and %[[VAL_53]], %[[VAL_54]] : i1
// CHECK:                 scf.if %[[VAL_55]] {
// CHECK:                   %[[VAL_56:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_47]]] : memref<?xf32>
// CHECK:                   %[[VAL_57:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_48]]] : memref<?xf32>
// CHECK:                   %[[VAL_58:.*]] = mulf %[[VAL_56]], %[[VAL_57]] : f32
// CHECK:                   store %[[VAL_58]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_52]]] : memref<32x16xf32>
// CHECK:                 } else {
// CHECK:                 }
// CHECK:                 %[[VAL_59:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_60:.*]] = addi %[[VAL_47]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_61:.*]] = select %[[VAL_59]], %[[VAL_60]], %[[VAL_47]] : index
// CHECK:                 %[[VAL_62:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_63:.*]] = addi %[[VAL_48]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_64:.*]] = select %[[VAL_62]], %[[VAL_63]], %[[VAL_48]] : index
// CHECK:                 scf.yield %[[VAL_61]], %[[VAL_64]] : index, index
// CHECK:               }
// CHECK:             } else {
// CHECK:             }
// CHECK:             %[[VAL_65:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:             %[[VAL_66:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:             %[[VAL_67:.*]] = select %[[VAL_65]], %[[VAL_66]], %[[VAL_26]] : index
// CHECK:             %[[VAL_68:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:             %[[VAL_69:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:             %[[VAL_70:.*]] = select %[[VAL_68]], %[[VAL_69]], %[[VAL_27]] : index
// CHECK:             scf.yield %[[VAL_67]], %[[VAL_70]] : index, index
// CHECK:           }
// CHECK:           %[[VAL_71:.*]] = tensor_load %[[VAL_15]] : memref<32x16xf32>
// CHECK:           return %[[VAL_71]] : tensor<32x16xf32>
// CHECK:         }
func @mul_ss_ss(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_ss_ss
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = mulf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

#trait_sd_ds = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // A
    affine_map<(i,j) -> (i,j)>,  // B
    affine_map<(i,j) -> (i,j)>   // X (out)
  ],
  sparse = [
    [ "S", "D" ],  // A
    [ "D", "S" ],  // B
    [ "D", "D" ]   // X
  ],
  iterator_types = ["parallel", "parallel"],
  doc = "X(i,j) = A(i,j) OP B(i,j)"
}

// CHECK-LABEL:   func @add_sd_ds(
// CHECK-SAME:                    %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                    %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 0 : index
// CHECK:           %[[VAL_4:.*]] = constant 1 : index
// CHECK:           %[[VAL_5:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_6:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_10:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_11:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_12:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_13:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_14:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_15:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_16:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_17:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_18:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_19:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_20:.*]]:2 = scf.while (%[[VAL_21:.*]] = %[[VAL_16]], %[[VAL_22:.*]] = %[[VAL_18]]) : (index, index) -> (index, index) {
// CHECK:             %[[VAL_23:.*]] = cmpi "ult", %[[VAL_21]], %[[VAL_17]] : index
// CHECK:             %[[VAL_24:.*]] = cmpi "ult", %[[VAL_22]], %[[VAL_19]] : index
// CHECK:             %[[VAL_25:.*]] = and %[[VAL_23]], %[[VAL_24]] : i1
// CHECK:             scf.condition(%[[VAL_25]]) %[[VAL_21]], %[[VAL_22]] : index, index
// CHECK:           } do {
// CHECK:           ^bb0(%[[VAL_26:.*]]: index, %[[VAL_27:.*]]: index):
// CHECK:             %[[VAL_28:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:             %[[VAL_29:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:             %[[VAL_30:.*]] = cmpi "ult", %[[VAL_29]], %[[VAL_28]] : index
// CHECK:             %[[VAL_31:.*]] = select %[[VAL_30]], %[[VAL_29]], %[[VAL_28]] : index
// CHECK:             %[[VAL_32:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:             %[[VAL_33:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:             %[[VAL_34:.*]] = and %[[VAL_32]], %[[VAL_33]] : i1
// CHECK:             scf.if %[[VAL_34]] {
// CHECK:               %[[VAL_35:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:               %[[VAL_36:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:               %[[VAL_37:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_36]]] : memref<?xindex>
// CHECK:               %[[VAL_38:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:               %[[VAL_39:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:               %[[VAL_40:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_39]]] : memref<?xindex>
// CHECK:               %[[VAL_41:.*]]:2 = scf.while (%[[VAL_42:.*]] = %[[VAL_35]], %[[VAL_43:.*]] = %[[VAL_38]]) : (index, index) -> (index, index) {
// CHECK:                 %[[VAL_44:.*]] = cmpi "ult", %[[VAL_42]], %[[VAL_37]] : index
// CHECK:                 %[[VAL_45:.*]] = cmpi "ult", %[[VAL_43]], %[[VAL_40]] : index
// CHECK:                 %[[VAL_46:.*]] = and %[[VAL_44]], %[[VAL_45]] : i1
// CHECK:                 scf.condition(%[[VAL_46]]) %[[VAL_42]], %[[VAL_43]] : index, index
// CHECK:               } do {
// CHECK:               ^bb0(%[[VAL_47:.*]]: index, %[[VAL_48:.*]]: index):
// CHECK:                 %[[VAL_49:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_47]]] : memref<?xindex>
// CHECK:                 %[[VAL_50:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_48]]] : memref<?xindex>
// CHECK:                 %[[VAL_51:.*]] = cmpi "ult", %[[VAL_50]], %[[VAL_49]] : index
// CHECK:                 %[[VAL_52:.*]] = select %[[VAL_51]], %[[VAL_50]], %[[VAL_49]] : index
// CHECK:                 %[[VAL_53:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_54:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_55:.*]] = and %[[VAL_53]], %[[VAL_54]] : i1
// CHECK:                 scf.if %[[VAL_55]] {
// CHECK:                   %[[VAL_56:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_47]]] : memref<?xf32>
// CHECK:                   %[[VAL_57:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_48]]] : memref<?xf32>
// CHECK:                   %[[VAL_58:.*]] = addf %[[VAL_56]], %[[VAL_57]] : f32
// CHECK:                   store %[[VAL_58]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_52]]] : memref<32x16xf32>
// CHECK:                 } else {
// CHECK:                   %[[VAL_59:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                   scf.if %[[VAL_59]] {
// CHECK:                     %[[VAL_60:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_47]]] : memref<?xf32>
// CHECK:                     store %[[VAL_60]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_52]]] : memref<32x16xf32>
// CHECK:                   } else {
// CHECK:                     %[[VAL_61:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                     scf.if %[[VAL_61]] {
// CHECK:                       %[[VAL_62:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_48]]] : memref<?xf32>
// CHECK:                       store %[[VAL_62]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_52]]] : memref<32x16xf32>
// CHECK:                     } else {
// CHECK:                     }
// CHECK:                   }
// CHECK:                 }
// CHECK:                 %[[VAL_63:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_64:.*]] = addi %[[VAL_47]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_65:.*]] = select %[[VAL_63]], %[[VAL_64]], %[[VAL_47]] : index
// CHECK:                 %[[VAL_66:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_67:.*]] = addi %[[VAL_48]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_68:.*]] = select %[[VAL_66]], %[[VAL_67]], %[[VAL_48]] : index
// CHECK:                 scf.yield %[[VAL_65]], %[[VAL_68]] : index, index
// CHECK:               }
// CHECK:               scf.for %[[VAL_69:.*]] = %[[VAL_70:.*]]#0 to %[[VAL_37]] step %[[VAL_4]] {
// CHECK:                 %[[VAL_71:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_69]]] : memref<?xindex>
// CHECK:                 %[[VAL_72:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_69]]] : memref<?xf32>
// CHECK:                 store %[[VAL_72]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_71]]] : memref<32x16xf32>
// CHECK:               }
// CHECK:               scf.for %[[VAL_73:.*]] = %[[VAL_74:.*]]#1 to %[[VAL_40]] step %[[VAL_4]] {
// CHECK:                 %[[VAL_75:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_73]]] : memref<?xindex>
// CHECK:                 %[[VAL_76:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_73]]] : memref<?xf32>
// CHECK:                 store %[[VAL_76]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_75]]] : memref<32x16xf32>
// CHECK:               }
// CHECK:             } else {
// CHECK:               %[[VAL_77:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:               scf.if %[[VAL_77]] {
// CHECK:                 %[[VAL_78:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:                 %[[VAL_79:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_80:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_79]]] : memref<?xindex>
// CHECK:                 scf.for %[[VAL_81:.*]] = %[[VAL_78]] to %[[VAL_80]] step %[[VAL_4]] {
// CHECK:                   %[[VAL_82:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_81]]] : memref<?xindex>
// CHECK:                   %[[VAL_83:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_81]]] : memref<?xf32>
// CHECK:                   store %[[VAL_83]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_82]]] : memref<32x16xf32>
// CHECK:                 }
// CHECK:               } else {
// CHECK:                 %[[VAL_84:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:                 scf.if %[[VAL_84]] {
// CHECK:                   %[[VAL_85:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:                   %[[VAL_86:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:                   %[[VAL_87:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_86]]] : memref<?xindex>
// CHECK:                   scf.for %[[VAL_88:.*]] = %[[VAL_85]] to %[[VAL_87]] step %[[VAL_4]] {
// CHECK:                     %[[VAL_89:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_88]]] : memref<?xindex>
// CHECK:                     %[[VAL_90:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_88]]] : memref<?xf32>
// CHECK:                     store %[[VAL_90]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_89]]] : memref<32x16xf32>
// CHECK:                   }
// CHECK:                 } else {
// CHECK:                 }
// CHECK:               }
// CHECK:             }
// CHECK:             %[[VAL_91:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:             %[[VAL_92:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:             %[[VAL_93:.*]] = select %[[VAL_91]], %[[VAL_92]], %[[VAL_26]] : index
// CHECK:             %[[VAL_94:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:             %[[VAL_95:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:             %[[VAL_96:.*]] = select %[[VAL_94]], %[[VAL_95]], %[[VAL_27]] : index
// CHECK:             scf.yield %[[VAL_93]], %[[VAL_96]] : index, index
// CHECK:           }
// CHECK:           scf.for %[[VAL_97:.*]] = %[[VAL_98:.*]]#0 to %[[VAL_17]] step %[[VAL_4]] {
// CHECK:             %[[VAL_99:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_97]]] : memref<?xindex>
// CHECK:             %[[VAL_100:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_97]]] : memref<?xindex>
// CHECK:             %[[VAL_101:.*]] = addi %[[VAL_97]], %[[VAL_4]] : index
// CHECK:             %[[VAL_102:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_101]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_103:.*]] = %[[VAL_100]] to %[[VAL_102]] step %[[VAL_4]] {
// CHECK:               %[[VAL_104:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_103]]] : memref<?xindex>
// CHECK:               %[[VAL_105:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_103]]] : memref<?xf32>
// CHECK:               store %[[VAL_105]], %[[VAL_15]]{{\[}}%[[VAL_99]], %[[VAL_104]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           scf.for %[[VAL_106:.*]] = %[[VAL_107:.*]]#1 to %[[VAL_19]] step %[[VAL_4]] {
// CHECK:             %[[VAL_108:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_106]]] : memref<?xindex>
// CHECK:             %[[VAL_109:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_106]]] : memref<?xindex>
// CHECK:             %[[VAL_110:.*]] = addi %[[VAL_106]], %[[VAL_4]] : index
// CHECK:             %[[VAL_111:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_110]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_112:.*]] = %[[VAL_109]] to %[[VAL_111]] step %[[VAL_4]] {
// CHECK:               %[[VAL_113:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_112]]] : memref<?xindex>
// CHECK:               %[[VAL_114:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_112]]] : memref<?xf32>
// CHECK:               store %[[VAL_114]], %[[VAL_15]]{{\[}}%[[VAL_108]], %[[VAL_113]]] : memref<32x16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_115:.*]] = tensor_load %[[VAL_15]] : memref<32x16xf32>
// CHECK:           return %[[VAL_115]] : tensor<32x16xf32>
// CHECK:         }
func @add_sd_ds(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_ss_ss
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = addf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

// CHECK-LABEL:   func @mul_sd_ds(
// CHECK-SAME:                    %[[VAL_0:.*]]: tensor<32x16xf32>,
// CHECK-SAME:                    %[[VAL_1:.*]]: tensor<32x16xf32>) -> tensor<32x16xf32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 0 : index
// CHECK:           %[[VAL_4:.*]] = constant 1 : index
// CHECK:           %[[VAL_5:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_6:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_10:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_11:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_12:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_13:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_14:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_15:.*]] = alloca() : memref<32x16xf32>
// CHECK:           %[[VAL_16:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_17:.*]] = load %[[VAL_5]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_18:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_3]]] : memref<?xindex>
// CHECK:           %[[VAL_19:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_4]]] : memref<?xindex>
// CHECK:           %[[VAL_20:.*]]:2 = scf.while (%[[VAL_21:.*]] = %[[VAL_16]], %[[VAL_22:.*]] = %[[VAL_18]]) : (index, index) -> (index, index) {
// CHECK:             %[[VAL_23:.*]] = cmpi "ult", %[[VAL_21]], %[[VAL_17]] : index
// CHECK:             %[[VAL_24:.*]] = cmpi "ult", %[[VAL_22]], %[[VAL_19]] : index
// CHECK:             %[[VAL_25:.*]] = and %[[VAL_23]], %[[VAL_24]] : i1
// CHECK:             scf.condition(%[[VAL_25]]) %[[VAL_21]], %[[VAL_22]] : index, index
// CHECK:           } do {
// CHECK:           ^bb0(%[[VAL_26:.*]]: index, %[[VAL_27:.*]]: index):
// CHECK:             %[[VAL_28:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:             %[[VAL_29:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:             %[[VAL_30:.*]] = cmpi "ult", %[[VAL_29]], %[[VAL_28]] : index
// CHECK:             %[[VAL_31:.*]] = select %[[VAL_30]], %[[VAL_29]], %[[VAL_28]] : index
// CHECK:             %[[VAL_32:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:             %[[VAL_33:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:             %[[VAL_34:.*]] = and %[[VAL_32]], %[[VAL_33]] : i1
// CHECK:             scf.if %[[VAL_34]] {
// CHECK:               %[[VAL_35:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_26]]] : memref<?xindex>
// CHECK:               %[[VAL_36:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:               %[[VAL_37:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_36]]] : memref<?xindex>
// CHECK:               %[[VAL_38:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:               %[[VAL_39:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:               %[[VAL_40:.*]] = load %[[VAL_12]]{{\[}}%[[VAL_39]]] : memref<?xindex>
// CHECK:               %[[VAL_41:.*]]:2 = scf.while (%[[VAL_42:.*]] = %[[VAL_35]], %[[VAL_43:.*]] = %[[VAL_38]]) : (index, index) -> (index, index) {
// CHECK:                 %[[VAL_44:.*]] = cmpi "ult", %[[VAL_42]], %[[VAL_37]] : index
// CHECK:                 %[[VAL_45:.*]] = cmpi "ult", %[[VAL_43]], %[[VAL_40]] : index
// CHECK:                 %[[VAL_46:.*]] = and %[[VAL_44]], %[[VAL_45]] : i1
// CHECK:                 scf.condition(%[[VAL_46]]) %[[VAL_42]], %[[VAL_43]] : index, index
// CHECK:               } do {
// CHECK:               ^bb0(%[[VAL_47:.*]]: index, %[[VAL_48:.*]]: index):
// CHECK:                 %[[VAL_49:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_47]]] : memref<?xindex>
// CHECK:                 %[[VAL_50:.*]] = load %[[VAL_13]]{{\[}}%[[VAL_48]]] : memref<?xindex>
// CHECK:                 %[[VAL_51:.*]] = cmpi "ult", %[[VAL_50]], %[[VAL_49]] : index
// CHECK:                 %[[VAL_52:.*]] = select %[[VAL_51]], %[[VAL_50]], %[[VAL_49]] : index
// CHECK:                 %[[VAL_53:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_54:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_55:.*]] = and %[[VAL_53]], %[[VAL_54]] : i1
// CHECK:                 scf.if %[[VAL_55]] {
// CHECK:                   %[[VAL_56:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_47]]] : memref<?xf32>
// CHECK:                   %[[VAL_57:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_48]]] : memref<?xf32>
// CHECK:                   %[[VAL_58:.*]] = mulf %[[VAL_56]], %[[VAL_57]] : f32
// CHECK:                   store %[[VAL_58]], %[[VAL_15]]{{\[}}%[[VAL_31]], %[[VAL_52]]] : memref<32x16xf32>
// CHECK:                 } else {
// CHECK:                 }
// CHECK:                 %[[VAL_59:.*]] = cmpi "eq", %[[VAL_49]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_60:.*]] = addi %[[VAL_47]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_61:.*]] = select %[[VAL_59]], %[[VAL_60]], %[[VAL_47]] : index
// CHECK:                 %[[VAL_62:.*]] = cmpi "eq", %[[VAL_50]], %[[VAL_52]] : index
// CHECK:                 %[[VAL_63:.*]] = addi %[[VAL_48]], %[[VAL_4]] : index
// CHECK:                 %[[VAL_64:.*]] = select %[[VAL_62]], %[[VAL_63]], %[[VAL_48]] : index
// CHECK:                 scf.yield %[[VAL_61]], %[[VAL_64]] : index, index
// CHECK:               }
// CHECK:             } else {
// CHECK:             }
// CHECK:             %[[VAL_65:.*]] = cmpi "eq", %[[VAL_28]], %[[VAL_31]] : index
// CHECK:             %[[VAL_66:.*]] = addi %[[VAL_26]], %[[VAL_4]] : index
// CHECK:             %[[VAL_67:.*]] = select %[[VAL_65]], %[[VAL_66]], %[[VAL_26]] : index
// CHECK:             %[[VAL_68:.*]] = cmpi "eq", %[[VAL_29]], %[[VAL_31]] : index
// CHECK:             %[[VAL_69:.*]] = addi %[[VAL_27]], %[[VAL_4]] : index
// CHECK:             %[[VAL_70:.*]] = select %[[VAL_68]], %[[VAL_69]], %[[VAL_27]] : index
// CHECK:             scf.yield %[[VAL_67]], %[[VAL_70]] : index, index
// CHECK:           }
// CHECK:           %[[VAL_71:.*]] = tensor_load %[[VAL_15]] : memref<32x16xf32>
// CHECK:           return %[[VAL_71]] : tensor<32x16xf32>
// CHECK:         }
func @mul_sd_ds(%arga: tensor<32x16xf32>, %argb: tensor<32x16xf32>) -> tensor<32x16xf32> {
  %0 = linalg.generic #trait_ss_ss
    ins(%arga, %argb: tensor<32x16xf32>, tensor<32x16xf32>) {
      ^bb(%a: f32, %b: f32):
        %0 = mulf %a, %b  : f32
        linalg.yield %0 : f32
  } -> tensor<32x16xf32>
  return %0 : tensor<32x16xf32>
}

#trait_matvec = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // A
    affine_map<(i,j) -> (j)>,    // b
    affine_map<(i,j) -> (i)>     // x (out)
  ],
  sparse = [
    [ "D", "S" ],  // A
    [ "D" ],       // b
    [ "D" ]        // x
  ],
  iterator_types = ["parallel", "reduction"],
  doc = "x(i) += A(i,j) * b(j)"
}

// CHECK-LABEL:   func @matvec(
// CHECK-SAME:                 %[[VAL_0:.*]]: tensor<16x32xf32>,
// CHECK-SAME:                 %[[VAL_1:.*]]: tensor<32xf32>,
// CHECK-SAME:                 %[[VAL_2:.*]]: tensor<16xf32>) -> tensor<16xf32> {
// CHECK:           %[[VAL_3:.*]] = constant 999 : index
// CHECK:           %[[VAL_4:.*]] = constant 16 : index
// CHECK:           %[[VAL_5:.*]] = constant 0 : index
// CHECK:           %[[VAL_6:.*]] = constant 1 : index
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_3]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_3]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_3]]) : memref<?xf32>
// CHECK:           %[[VAL_10:.*]] = alloca() : memref<32xf32>
// CHECK:           %[[VAL_11:.*]] = alloca() : memref<16xf32>
// CHECK:           scf.for %[[VAL_12:.*]] = %[[VAL_5]] to %[[VAL_4]] step %[[VAL_6]] {
// CHECK:             %[[VAL_13:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_12]]] : memref<?xindex>
// CHECK:             %[[VAL_14:.*]] = addi %[[VAL_12]], %[[VAL_6]] : index
// CHECK:             %[[VAL_15:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_14]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_16:.*]] = %[[VAL_13]] to %[[VAL_15]] step %[[VAL_6]] {
// CHECK:               %[[VAL_17:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_16]]] : memref<?xindex>
// CHECK:               %[[VAL_18:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_16]]] : memref<?xf32>
// CHECK:               %[[VAL_19:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_17]]] : memref<32xf32>
// CHECK:               %[[VAL_20:.*]] = mulf %[[VAL_18]], %[[VAL_19]] : f32
// CHECK:               %[[VAL_21:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_12]]] : memref<16xf32>
// CHECK:               %[[VAL_22:.*]] = addf %[[VAL_20]], %[[VAL_21]] : f32
// CHECK:               store %[[VAL_22]], %[[VAL_11]]{{\[}}%[[VAL_12]]] : memref<16xf32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_23:.*]] = tensor_load %[[VAL_11]] : memref<16xf32>
// CHECK:           return %[[VAL_23]] : tensor<16xf32>
// CHECK:         }
func @matvec(%argA: tensor<16x32xf32>, %argb: tensor<32xf32>, %argx: tensor<16xf32>) -> tensor<16xf32> {
  %0 = linalg.generic #trait_matvec
      ins(%argA, %argb : tensor<16x32xf32>, tensor<32xf32>)
      init(%argx : tensor<16xf32>) {
    ^bb(%A: f32, %b: f32, %x: f32):
      %0 = mulf %A, %b : f32
      %1 = addf %0, %x : f32
      linalg.yield %1 : f32
  } -> tensor<16xf32>
  return %0 : tensor<16xf32>
}

#trait_sum_reduction = {
  indexing_maps = [
    affine_map<(i,j) -> (i,j)>,  // a
    affine_map<(i,j) -> ()>      // x (scalar out)
  ],
  sparse = [
    [ "D","S" ],  // a
    [ ]           // x
  ],
  iterator_types = ["reduction", "reduction"],
  doc = "x = SUM_ij a(i,j)"
}

// CHECK-LABEL:   func @sum_reduction(
// CHECK-SAME:                %[[VAL_0:.*]]: tensor<10x20xf32>,
// CHECK-SAME:                %[[VAL_1:.*]]: tensor<f32>) -> tensor<f32> {
// CHECK:           %[[VAL_2:.*]] = constant 999 : index
// CHECK:           %[[VAL_3:.*]] = constant 10 : index
// CHECK:           %[[VAL_4:.*]] = constant 0 : index
// CHECK:           %[[VAL_5:.*]] = constant 1 : index
// CHECK:           %[[VAL_6:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_2]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_2]]) : memref<?xf32>
// CHECK:           %[[VAL_9:.*]] = alloca() : memref<f32>
// CHECK:           scf.for %[[VAL_10:.*]] = %[[VAL_4]] to %[[VAL_3]] step %[[VAL_5]] {
// CHECK:             %[[VAL_11:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_10]]] : memref<?xindex>
// CHECK:             %[[VAL_12:.*]] = addi %[[VAL_10]], %[[VAL_5]] : index
// CHECK:             %[[VAL_13:.*]] = load %[[VAL_6]]{{\[}}%[[VAL_12]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_14:.*]] = %[[VAL_11]] to %[[VAL_13]] step %[[VAL_5]] {
// CHECK:               %[[VAL_15:.*]] = load %[[VAL_9]][] : memref<f32>
// CHECK:               %[[VAL_16:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_14]]] : memref<?xf32>
// CHECK:               %[[VAL_17:.*]] = addf %[[VAL_15]], %[[VAL_16]] : f32
// CHECK:               store %[[VAL_17]], %[[VAL_9]][] : memref<f32>
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_18:.*]] = tensor_load %[[VAL_9]] : memref<f32>
// CHECK:           return %[[VAL_18]] : tensor<f32>
// CHECK:         }
func @sum_reduction(%arga: tensor<10x20xf32>, %argx: tensor<f32>) -> tensor<f32> {
  %0 = linalg.generic #trait_sum_reduction
    ins(%arga : tensor<10x20xf32>)
    init(%argx : tensor<f32>) {
      ^bb(%a : f32, %x : f32):
        %0 = addf %x, %a  : f32
        linalg.yield %0: f32
  } -> tensor<f32>
  return %0 : tensor<f32>
}

#trait_sampled_dense_dense = {
  indexing_maps = [
    affine_map<(i,j,k) -> (i,j)>,  // S
    affine_map<(i,j,k) -> (i,k)>,  // A
    affine_map<(i,j,k) -> (k,j)>,  // B
    affine_map<(i,j,k) -> (i,j)>   // X (out)
  ],
  sparse = [
    [ "S", "S" ],  // S
    [ "D", "D" ],  // A
    [ "D", "D" ],  // B
    [ "D", "D" ]   // X
  ],
  iterator_types = ["parallel", "parallel", "reduction"],
  doc = "X(i,j) = S(i,j) SUM_k A(i,k) B(k,j)"
}

// CHECK-LABEL:   func @sampled_dense_dense(
// CHECK-SAME:                              %[[VAL_0:.*0]]: tensor<?x?xf32>,
// CHECK-SAME:                              %[[VAL_1:.*1]]: tensor<?x?xf32>,
// CHECK-SAME:                              %[[VAL_2:.*2]]: tensor<?x?xf32>,
// CHECK-SAME:                              %[[VAL_3:.*3]]: tensor<?x?xf32>) -> tensor<?x?xf32> {
// CHECK:           %[[VAL_4:.*]] = constant 999 : index
// CHECK:           %[[VAL_5:.*]] = constant 0 : index
// CHECK:           %[[VAL_6:.*]] = constant 1 : index
// CHECK:           %[[VAL_7:.*]] = alloca(%[[VAL_4]]) : memref<?xindex>
// CHECK:           %[[VAL_8:.*]] = alloca(%[[VAL_4]]) : memref<?xindex>
// CHECK:           %[[VAL_9:.*]] = alloca(%[[VAL_4]]) : memref<?xindex>
// CHECK:           %[[VAL_10:.*]] = alloca(%[[VAL_4]]) : memref<?xindex>
// CHECK:           %[[VAL_11:.*]] = alloca(%[[VAL_4]]) : memref<?xf32>
// CHECK:           %[[VAL_12:.*]] = dim %[[VAL_1]], %[[VAL_5]] : tensor<?x?xf32>
// CHECK:           %[[VAL_13:.*]] = dim %[[VAL_1]], %[[VAL_6]] : tensor<?x?xf32>
// CHECK:           %[[VAL_14:.*]] = alloca(%[[VAL_12]], %[[VAL_13]]) : memref<?x?xf32>
// CHECK:           %[[VAL_15:.*]] = dim %[[VAL_2]], %[[VAL_5]] : tensor<?x?xf32>
// CHECK:           %[[VAL_16:.*]] = dim %[[VAL_2]], %[[VAL_6]] : tensor<?x?xf32>
// CHECK:           %[[VAL_17:.*]] = alloca(%[[VAL_15]], %[[VAL_16]]) : memref<?x?xf32>
// CHECK:           %[[VAL_18:.*]] = dim %[[VAL_3]], %[[VAL_5]] : tensor<?x?xf32>
// CHECK:           %[[VAL_19:.*]] = dim %[[VAL_3]], %[[VAL_6]] : tensor<?x?xf32>
// CHECK:           %[[VAL_20:.*]] = alloca(%[[VAL_18]], %[[VAL_19]]) : memref<?x?xf32>
// CHECK:           %[[VAL_21:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_5]]] : memref<?xindex>
// CHECK:           %[[VAL_22:.*]] = load %[[VAL_7]]{{\[}}%[[VAL_6]]] : memref<?xindex>
// CHECK:           scf.for %[[VAL_23:.*]] = %[[VAL_21]] to %[[VAL_22]] step %[[VAL_6]] {
// CHECK:             %[[VAL_24:.*]] = load %[[VAL_8]]{{\[}}%[[VAL_23]]] : memref<?xindex>
// CHECK:             scf.for %[[VAL_25:.*]] = %[[VAL_5]] to %[[VAL_15]] step %[[VAL_6]] {
// CHECK:               %[[VAL_26:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_23]]] : memref<?xindex>
// CHECK:               %[[VAL_27:.*]] = addi %[[VAL_23]], %[[VAL_6]] : index
// CHECK:               %[[VAL_28:.*]] = load %[[VAL_9]]{{\[}}%[[VAL_27]]] : memref<?xindex>
// CHECK:               scf.for %[[VAL_29:.*]] = %[[VAL_26]] to %[[VAL_28]] step %[[VAL_6]] {
// CHECK:                 %[[VAL_30:.*]] = load %[[VAL_10]]{{\[}}%[[VAL_29]]] : memref<?xindex>
// CHECK:                 %[[VAL_31:.*]] = load %[[VAL_20]]{{\[}}%[[VAL_24]], %[[VAL_30]]] : memref<?x?xf32>
// CHECK:                 %[[VAL_32:.*]] = load %[[VAL_11]]{{\[}}%[[VAL_29]]] : memref<?xf32>
// CHECK:                 %[[VAL_33:.*]] = load %[[VAL_14]]{{\[}}%[[VAL_24]], %[[VAL_25]]] : memref<?x?xf32>
// CHECK:                 %[[VAL_34:.*]] = load %[[VAL_17]]{{\[}}%[[VAL_25]], %[[VAL_30]]] : memref<?x?xf32>
// CHECK:                 %[[VAL_35:.*]] = mulf %[[VAL_33]], %[[VAL_34]] : f32
// CHECK:                 %[[VAL_36:.*]] = mulf %[[VAL_32]], %[[VAL_35]] : f32
// CHECK:                 %[[VAL_37:.*]] = addf %[[VAL_31]], %[[VAL_36]] : f32
// CHECK:                 store %[[VAL_37]], %[[VAL_20]]{{\[}}%[[VAL_24]], %[[VAL_30]]] : memref<?x?xf32>
// CHECK:               }
// CHECK:             }
// CHECK:           }
// CHECK:           %[[VAL_38:.*]] = tensor_load %[[VAL_20]] : memref<?x?xf32>
// CHECK:           return %[[VAL_38]] : tensor<?x?xf32>
// CHECK:         }
func @sampled_dense_dense(%args: tensor<?x?xf32>,
                          %arga: tensor<?x?xf32>,
                          %argb: tensor<?x?xf32>,
			  %argx: tensor<?x?xf32>) -> tensor<?x?xf32> {
  %0 = linalg.generic #trait_sampled_dense_dense
    ins(%args, %arga, %argb : tensor<?x?xf32>, tensor<?x?xf32>, tensor<?x?xf32>)
    init(%argx : tensor<?x?xf32>) {
      ^bb(%s : f32, %a : f32, %b : f32, %x : f32):
        %0 = mulf %a, %b  : f32
        %1 = mulf %s, %0  : f32
        %2 = addf %x, %1  : f32
        linalg.yield %2: f32
  } -> tensor<?x?xf32>
  return %0 : tensor<?x?xf32>
}
