; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-none-linux-gnu -mattr=+neon | FileCheck %s --check-prefix=CHECK

; Same as vecreduce-fmul-legalization.ll, but without fmf.

declare half @llvm.vector.reduce.fmul.f16.v1f16(half, <1 x half>)
declare float @llvm.vector.reduce.fmul.f32.v1f32(float, <1 x float>)
declare double @llvm.vector.reduce.fmul.f64.v1f64(double, <1 x double>)
declare fp128 @llvm.vector.reduce.fmul.f128.v1f128(fp128, <1 x fp128>)

declare float @llvm.vector.reduce.fmul.f32.v3f32(float, <3 x float>)
declare fp128 @llvm.vector.reduce.fmul.f128.v2f128(fp128, <2 x fp128>)
declare float @llvm.vector.reduce.fmul.f32.v16f32(float, <16 x float>)

define half @test_v1f16(<1 x half> %a) nounwind {
; CHECK-LABEL: test_v1f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %b = call half @llvm.vector.reduce.fmul.f16.v1f16(half 1.0, <1 x half> %a)
  ret half %b
}

define float @test_v1f32(<1 x float> %a) nounwind {
; CHECK-LABEL: test_v1f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    ret
  %b = call float @llvm.vector.reduce.fmul.f32.v1f32(float 1.0, <1 x float> %a)
  ret float %b
}

define double @test_v1f64(<1 x double> %a) nounwind {
; CHECK-LABEL: test_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %b = call double @llvm.vector.reduce.fmul.f64.v1f64(double 1.0, <1 x double> %a)
  ret double %b
}

define fp128 @test_v1f128(<1 x fp128> %a) nounwind {
; CHECK-LABEL: test_v1f128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %b = call fp128 @llvm.vector.reduce.fmul.f128.v1f128(fp128 0xL00000000000000003fff00000000000000, <1 x fp128> %a)
  ret fp128 %b
}

define float @test_v3f32(<3 x float> %a) nounwind {
; CHECK-LABEL: test_v3f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul s1, s0, v0.s[1]
; CHECK-NEXT:    fmul s0, s1, v0.s[2]
; CHECK-NEXT:    ret
  %b = call float @llvm.vector.reduce.fmul.f32.v3f32(float 1.0, <3 x float> %a)
  ret float %b
}

define fp128 @test_v2f128(<2 x fp128> %a) nounwind {
; CHECK-LABEL: test_v2f128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl __multf3
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %b = call fp128 @llvm.vector.reduce.fmul.f128.v2f128(fp128 0xL00000000000000003fff00000000000000, <2 x fp128> %a)
  ret fp128 %b
}

define float @test_v16f32(<16 x float> %a) nounwind {
; CHECK-LABEL: test_v16f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmul s4, s0, v0.s[1]
; CHECK-NEXT:    fmul s4, s4, v0.s[2]
; CHECK-NEXT:    fmul s0, s4, v0.s[3]
; CHECK-NEXT:    fmul s0, s0, v1.s[0]
; CHECK-NEXT:    fmul s0, s0, v1.s[1]
; CHECK-NEXT:    fmul s0, s0, v1.s[2]
; CHECK-NEXT:    fmul s0, s0, v1.s[3]
; CHECK-NEXT:    fmul s0, s0, v2.s[0]
; CHECK-NEXT:    fmul s0, s0, v2.s[1]
; CHECK-NEXT:    fmul s0, s0, v2.s[2]
; CHECK-NEXT:    fmul s0, s0, v2.s[3]
; CHECK-NEXT:    fmul s0, s0, v3.s[0]
; CHECK-NEXT:    fmul s0, s0, v3.s[1]
; CHECK-NEXT:    fmul s0, s0, v3.s[2]
; CHECK-NEXT:    fmul s0, s0, v3.s[3]
; CHECK-NEXT:    ret
  %b = call float @llvm.vector.reduce.fmul.f32.v16f32(float 1.0, <16 x float> %a)
  ret float %b
}
