; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:   FileCheck %s -check-prefixes=CHECK-LE,CHECK

; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:   FileCheck %s -check-prefixes=CHECK-BE,CHECK

; This test case aims to test the builtins for vector rotate instructions
; on Power10.


define <1 x i128> @test_vrlq(<1 x i128> %x, <1 x i128> %y) {
; CHECK-LABEL: test_vrlq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrlq v2, v3, v2
; CHECK-NEXT:    blr
  %shl.i = shl <1 x i128> %y, %x
  %sub.i = sub <1 x i128> <i128 128>, %x
  %lshr.i = lshr <1 x i128> %y, %sub.i
  %tmp = or <1 x i128> %shl.i, %lshr.i
  ret <1 x i128> %tmp
}

define <1 x i128> @test_vrlq_cost_mult8(<1 x i128> %x) {
; CHECK-LABEL: test_vrlq_cost_mult8:
; CHECK: # %bb.0:
; CHECK: vrlq v2, v3, v2
; CHECK-NEXT: blr
  %shl.i = shl <1 x i128> <i128 16>, %x
  %sub.i = sub <1 x i128> <i128 128>, %x
  %lshr.i = lshr <1 x i128> <i128 16>, %sub.i
  %tmp = or <1 x i128> %shl.i, %lshr.i
  ret <1 x i128> %tmp
}

define <1 x i128> @test_vrlq_cost_non_mult8(<1 x i128> %x) {
; CHECK-LABEL: test_vrlq_cost_non_mult8:
; CHECK: # %bb.0:
; CHECK: vrlq v2, v3, v2
; CHECK-NEXT: blr
  %shl.i = shl <1 x i128> <i128 4>, %x
  %sub.i = sub <1 x i128> <i128 128>, %x
  %lshr.i = lshr <1 x i128> <i128 4>, %sub.i
  %tmp = or <1 x i128> %shl.i, %lshr.i
  ret <1 x i128> %tmp
}

; Function Attrs: nounwind readnone
define <1 x i128> @test_vrlqmi(<1 x i128> %a, <1 x i128> %b, <1 x i128> %c) {
; CHECK-LABEL: test_vrlqmi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vrlqmi v3, v2, v4
; CHECK-NEXT:    vmr v2, v3
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <1 x i128> @llvm.ppc.altivec.vrlqmi(<1 x i128> %a, <1 x i128> %c, <1 x i128> %b)
  ret <1 x i128> %tmp
}

; Function Attrs: nounwind readnone
define <1 x i128> @test_vrlqnm(<1 x i128> %a, <1 x i128> %b, <1 x i128> %c) {
; CHECK-LABEL: test_vrlqnm:
; CHECK:            # %bb.0: # %entry
; CHECK-BE:         lxvx v5
; CHECK-BE-NEXT:    vperm v3, v3, v4, v5
; CHECK-LE-NEXT:    plxv v5
; CHECK-LE-NEXT:    vperm v3, v4, v3, v5
; CHECK-NEXT:       vrlqnm v2, v2, v3
; CHECK-NEXT:       blr
entry:
  %0 = bitcast <1 x i128> %b to <16 x i8>
  %1 = bitcast <1 x i128> %c to <16 x i8>
  %shuffle.i = shufflevector <16 x i8> %0, <16 x i8> %1, <16 x i32> <i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 16, i32 0, i32 1, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %d = bitcast <16 x i8> %shuffle.i to <1 x i128>
  %tmp = tail call <1 x i128> @llvm.ppc.altivec.vrlqnm(<1 x i128> %a, <1 x i128> %d)
  ret <1 x i128> %tmp
}

; Function Attrs: nounwind readnone
declare <1 x i128> @llvm.ppc.altivec.vrlqmi(<1 x i128>, <1 x i128>, <1 x i128>)

; Function Attrs: nounwind readnone
declare <1 x i128> @llvm.ppc.altivec.vrlqnm(<1 x i128>, <1 x i128>)
