; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc \
; RUN:     -mcpu=pwr9 < %s | FileCheck %s --check-prefix=32BIT

; RUN: llc -verify-machineinstrs -mtriple=powerpc64 \
; RUN:     -mcpu=pwr9 < %s | FileCheck %s --check-prefix=64BIT

define dso_local void @foo(i32 %inta, i64* %long_intb) {
  entry:
    %conv = sext i32 %inta to i64
    %shl = shl nsw i64 %conv, 8
    store i64 %shl, i64* %long_intb, align 8
    ret void
}

; CHECK-LABEL:   foo:

; 32BIT-DAG:     srawi [[REG1:[0-9]+]], [[REG2:[0-9]+]], 31
; 32BIT-DAG:     rotlwi [[REG3:[0-9]+]], [[REG2]], 8
; 32BIT-DAG:     slwi [[REG4:[0-9]+]], [[REG2]], 8
; 32BIT-DAG:     rlwimi [[REG5:[0-9]+]], [[REG1]], 8, 0, 23
; 32BIT-DAG:     stw [[REG4]], 4([[REG6:[0-9]+]])
; 32BIT-DAG:     stw [[REG5]], 0([[REG6]])
; 32BIT:         blr

; 64BIT:         extswsli [[REG1:[0-9]+]], [[REG2:[0-9]+]], 8
; 64BIT-NEXT:    std [[REG1]], 0([[REG3:[0-9]+]])
; 64BIT-NEXT:    blr
