; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; NOTE: Use the --no_x86_scrub_rip additional argument to keep the rip address math.

; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -relocation-model=static -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=LINUX-64-STATIC
; RUN: llc < %s -mtriple=i686-unknown-linux-gnu -relocation-model=static -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=LINUX-32-STATIC
; RUN: llc < %s -mtriple=i686-unknown-linux-gnu -relocation-model=pic -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=LINUX-32-PIC
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -relocation-model=pic -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=LINUX-64-PIC

; RUN: llc < %s -mtriple=i686-apple-darwin -relocation-model=static -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=DARWIN-32-STATIC
; RUN: llc < %s -mtriple=i686-apple-darwin9 -relocation-model=dynamic-no-pic -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=DARWIN-32-DYNAMIC
; RUN: llc < %s -mtriple=i686-apple-darwin9 -relocation-model=pic -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=DARWIN-32-PIC

; RUN: llc < %s -mtriple=x86_64-apple-darwin -relocation-model=static -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=DARWIN-64-STATIC
; RUN: llc < %s -mtriple=x86_64-apple-darwin -relocation-model=dynamic-no-pic -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=DARWIN-64-DYNAMIC
; RUN: llc < %s -mtriple=x86_64-apple-darwin -relocation-model=pic -code-model=small -pre-RA-sched=list-ilp | FileCheck %s -check-prefix=DARWIN-64-PIC

@src = external global [131072 x i32]
@dst = external global [131072 x i32]
@xsrc = external global [32 x i32]
@xdst = external global [32 x i32]
@ptr = external global i32*
@dsrc = global [131072 x i32] zeroinitializer, align 32
@ddst = global [131072 x i32] zeroinitializer, align 32
@dptr = global i32* null
@lsrc = internal global [131072 x i32] zeroinitializer
@ldst = internal global [131072 x i32] zeroinitializer
@lptr = internal global i32* null
@ifunc = external global void ()*
@difunc = global void ()* null
@lifunc = internal global void ()* null
@lxsrc = internal global [32 x i32] zeroinitializer, align 32
@lxdst = internal global [32 x i32] zeroinitializer, align 32
@dxsrc = global [32 x i32] zeroinitializer, align 32
@dxdst = global [32 x i32] zeroinitializer, align 32

define void @foo00() nounwind {
; LINUX-64-STATIC-LABEL: foo00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, dst(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl src, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, dst
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L0$pb
; LINUX-32-PIC-NEXT:  .L0$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp0:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp0-.L0$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl (%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax), %eax
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _src, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _dst
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl (%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L0$pb
; DARWIN-32-PIC-NEXT:  L0$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L0$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L0$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @src, i32 0, i64 0), align 4
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @dst, i32 0, i64 0), align 4
	ret void

}

define void @fxo00() nounwind {
; LINUX-64-STATIC-LABEL: fxo00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl xsrc(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, xdst(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: fxo00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl xsrc, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, xdst
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: fxo00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L1$pb
; LINUX-32-PIC-NEXT:  .L1$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp1:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp1-.L1$pb), %eax
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl (%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: fxo00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax), %eax
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: fxo00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _xsrc, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _xdst
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: fxo00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl (%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: fxo00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L1$pb
; DARWIN-32-PIC-NEXT:  L1$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L1$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L1$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: fxo00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: fxo00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: fxo00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([32 x i32], [32 x i32]* @xsrc, i32 0, i64 0), align 4
	store i32 %0, i32* getelementptr ([32 x i32], [32 x i32]* @xdst, i32 0, i64 0), align 4
	ret void

}

define void @foo01() nounwind {
; LINUX-64-STATIC-LABEL: foo01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $dst, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dst, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L2$pb
; LINUX-32-PIC-NEXT:  .L2$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp2:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp2-.L2$pb), %eax
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dst, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L2$pb
; DARWIN-32-PIC-NEXT:  L2$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L2$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L2$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @dst, i32 0, i32 0), i32** @ptr, align 8
	ret void
}

define void @fxo01() nounwind {
; LINUX-64-STATIC-LABEL: fxo01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $xdst, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: fxo01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xdst, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: fxo01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L3$pb
; LINUX-32-PIC-NEXT:  .L3$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp3:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp3-.L3$pb), %eax
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: fxo01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: fxo01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xdst, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: fxo01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: fxo01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L3$pb
; DARWIN-32-PIC-NEXT:  L3$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L3$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L3$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: fxo01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: fxo01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: fxo01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([32 x i32], [32 x i32]* @xdst, i32 0, i32 0), i32** @ptr, align 8
	ret void
}

define void @foo02() nounwind {
; LINUX-64-STATIC-LABEL: foo02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl src, %eax
; LINUX-32-STATIC-NEXT:    movl ptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, (%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L4$pb
; LINUX-32-PIC-NEXT:  .L4$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp4:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp4-.L4$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl (%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _src, %eax
; DARWIN-32-STATIC-NEXT:    movl _ptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl (%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L4$pb
; DARWIN-32-PIC-NEXT:  L4$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L4$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L4$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @src, i32 0, i64 0), align 4
	store i32 %1, i32* %0, align 4
	ret void
}

define void @fxo02() nounwind {
; LINUX-64-STATIC-LABEL: fxo02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl xsrc(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: fxo02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl xsrc, %eax
; LINUX-32-STATIC-NEXT:    movl ptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, (%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: fxo02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L5$pb
; LINUX-32-PIC-NEXT:  .L5$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp5:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp5-.L5$pb), %eax
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl (%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: fxo02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: fxo02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _xsrc, %eax
; DARWIN-32-STATIC-NEXT:    movl _ptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: fxo02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl (%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: fxo02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L5$pb
; DARWIN-32-PIC-NEXT:  L5$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L5$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L5$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: fxo02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: fxo02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: fxo02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = load i32, i32* getelementptr ([32 x i32], [32 x i32]* @xsrc, i32 0, i64 0), align 4
	store i32 %1, i32* %0, align 4
	ret void
}

define void @foo03() nounwind {
; LINUX-64-STATIC-LABEL: foo03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ddst(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl dsrc, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ddst
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L6$pb
; LINUX-32-PIC-NEXT:  .L6$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp6:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp6-.L6$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl (%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax), %eax
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _dsrc, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ddst
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _ddst
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L6$pb
; DARWIN-32-PIC-NEXT:  L6$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl _dsrc-L6$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _ddst-L6$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _dsrc(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movl %eax, _ddst(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _dsrc(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, _ddst(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _dsrc(%rip), %eax
; DARWIN-64-PIC-NEXT:    movl %eax, _ddst(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @dsrc, i32 0, i64 0), align 32
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @ddst, i32 0, i64 0), align 32
	ret void
}

define void @foo04() nounwind {
; LINUX-64-STATIC-LABEL: foo04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $ddst, dptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ddst, dptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L7$pb
; LINUX-32-PIC-NEXT:  .L7$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp7:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp7-.L7$pb), %eax
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ddst, _dptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ddst, _dptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L7$pb
; DARWIN-32-PIC-NEXT:  L7$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _ddst-L7$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _dptr-L7$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @ddst, i32 0, i32 0), i32** @dptr, align 8
	ret void
}

define void @foo05() nounwind {
; LINUX-64-STATIC-LABEL: foo05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl dsrc, %eax
; LINUX-32-STATIC-NEXT:    movl dptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, (%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L8$pb
; LINUX-32-PIC-NEXT:  .L8$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp8:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp8-.L8$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl (%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax), %eax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _dsrc, %eax
; DARWIN-32-STATIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L8$pb
; DARWIN-32-PIC-NEXT:  L8$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl _dsrc-L8$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl _dptr-L8$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _dsrc(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _dsrc(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _dsrc(%rip), %eax
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @dsrc, i32 0, i64 0), align 32
	store i32 %1, i32* %0, align 4
	ret void
}

define void @foo06() nounwind {
; LINUX-64-STATIC-LABEL: foo06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ldst(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl lsrc, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ldst
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L9$pb
; LINUX-32-PIC-NEXT:  .L9$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp9:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp9-.L9$pb), %eax
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, ldst@GOTOFF(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl lsrc(%rip), %eax
; LINUX-64-PIC-NEXT:    movl %eax, ldst(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _lsrc, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ldst
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _ldst
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L9$pb
; DARWIN-32-PIC-NEXT:  L9$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl _lsrc-L9$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _ldst-L9$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _lsrc(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movl %eax, _ldst(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _lsrc(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, _ldst(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _lsrc(%rip), %eax
; DARWIN-64-PIC-NEXT:    movl %eax, _ldst(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @lsrc, i32 0, i64 0), align 4
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @ldst, i32 0, i64 0), align 4
	ret void
}

define void @foo07() nounwind {
; LINUX-64-STATIC-LABEL: foo07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $ldst, lptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ldst, lptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L10$pb
; LINUX-32-PIC-NEXT:  .L10$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp10:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp10-.L10$pb), %eax
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, lptr@GOTOFF(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rax
; LINUX-64-PIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ldst, _lptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ldst, _lptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L10$pb
; DARWIN-32-PIC-NEXT:  L10$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _ldst-L10$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _lptr-L10$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @ldst, i32 0, i32 0), i32** @lptr, align 8
	ret void
}

define void @foo08() nounwind {
; LINUX-64-STATIC-LABEL: foo08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: foo08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl lsrc, %eax
; LINUX-32-STATIC-NEXT:    movl lptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, (%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: foo08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L11$pb
; LINUX-32-PIC-NEXT:  .L11$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp11:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp11-.L11$pb), %eax
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: foo08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl lsrc(%rip), %eax
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: foo08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _lsrc, %eax
; DARWIN-32-STATIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: foo08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: foo08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L11$pb
; DARWIN-32-PIC-NEXT:  L11$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl _lsrc-L11$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl _lptr-L11$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: foo08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _lsrc(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: foo08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _lsrc(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: foo08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _lsrc(%rip), %eax
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @lsrc, i32 0, i64 0), align 4
	store i32 %1, i32* %0, align 4
	ret void
}

define void @qux00() nounwind {
; LINUX-64-STATIC-LABEL: qux00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src+64(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, dst+64(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl src+64, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, dst+64
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L12$pb
; LINUX-32-PIC-NEXT:  .L12$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp12:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp12-.L12$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 64(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 64(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax), %eax
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _src+64, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _dst+64
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl 64(%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L12$pb
; DARWIN-32-PIC-NEXT:  L12$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L12$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl 64(%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L12$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 64(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @src, i32 0, i64 16), align 4
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @dst, i32 0, i64 16), align 4
	ret void
}

define void @qxx00() nounwind {
; LINUX-64-STATIC-LABEL: qxx00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl xsrc+64(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, xdst+64(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qxx00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl xsrc+64, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, xdst+64
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qxx00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L13$pb
; LINUX-32-PIC-NEXT:  .L13$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp13:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp13-.L13$pb), %eax
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 64(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 64(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qxx00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax), %eax
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qxx00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _xsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _xdst+64
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qxx00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl 64(%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qxx00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L13$pb
; DARWIN-32-PIC-NEXT:  L13$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L13$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl 64(%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L13$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 64(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qxx00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qxx00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qxx00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([32 x i32], [32 x i32]* @xsrc, i32 0, i64 16), align 4
	store i32 %0, i32* getelementptr ([32 x i32], [32 x i32]* @xdst, i32 0, i64 16), align 4
	ret void
}

define void @qux01() nounwind {
; LINUX-64-STATIC-LABEL: qux01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $dst+64, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dst+64, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L14$pb
; LINUX-32-PIC-NEXT:  .L14$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp14:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp14-.L14$pb), %eax
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    addl $64, %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dst+64, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L14$pb
; DARWIN-32-PIC-NEXT:  L14$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L14$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    addl $64, %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L14$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @dst, i32 0, i64 16), i32** @ptr, align 8
	ret void
}

define void @qxx01() nounwind {
; LINUX-64-STATIC-LABEL: qxx01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $xdst+64, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qxx01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xdst+64, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qxx01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L15$pb
; LINUX-32-PIC-NEXT:  .L15$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp15:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp15-.L15$pb), %eax
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    addl $64, %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qxx01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qxx01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xdst+64, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qxx01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qxx01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L15$pb
; DARWIN-32-PIC-NEXT:  L15$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L15$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    addl $64, %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L15$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qxx01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qxx01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qxx01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([32 x i32], [32 x i32]* @xdst, i32 0, i64 16), i32** @ptr, align 8
	ret void
}

define void @qux02() nounwind {
; LINUX-64-STATIC-LABEL: qux02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src+64(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl src+64, %eax
; LINUX-32-STATIC-NEXT:    movl ptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, 64(%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L16$pb
; LINUX-32-PIC-NEXT:  .L16$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp16:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp16-.L16$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 64(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 64(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _src+64, %eax
; DARWIN-32-STATIC-NEXT:    movl _ptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl 64(%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L16$pb
; DARWIN-32-PIC-NEXT:  L16$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L16$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl 64(%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L16$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 64(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @src, i32 0, i64 16), align 4
	%2 = getelementptr i32, i32* %0, i64 16
	store i32 %1, i32* %2, align 4
	ret void
}

define void @qxx02() nounwind {
; LINUX-64-STATIC-LABEL: qxx02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl xsrc+64(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qxx02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl xsrc+64, %eax
; LINUX-32-STATIC-NEXT:    movl ptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, 64(%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qxx02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L17$pb
; LINUX-32-PIC-NEXT:  .L17$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp17:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp17-.L17$pb), %eax
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 64(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 64(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qxx02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qxx02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _xsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    movl _ptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qxx02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl 64(%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qxx02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L17$pb
; DARWIN-32-PIC-NEXT:  L17$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L17$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl 64(%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L17$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 64(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qxx02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qxx02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qxx02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = load i32, i32* getelementptr ([32 x i32], [32 x i32]* @xsrc, i32 0, i64 16), align 4
	%2 = getelementptr i32, i32* %0, i64 16
	store i32 %1, i32* %2, align 4
	ret void
}

define void @qux03() nounwind {
; LINUX-64-STATIC-LABEL: qux03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc+64(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ddst+64(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl dsrc+64, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ddst+64
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L18$pb
; LINUX-32-PIC-NEXT:  .L18$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp18:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp18-.L18$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 64(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 64(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax), %eax
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _dsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ddst+64
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc+64, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _ddst+64
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L18$pb
; DARWIN-32-PIC-NEXT:  L18$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl (_dsrc-L18$pb)+64(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, (_ddst-L18$pb)+64(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _dsrc+64(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movl %eax, _ddst+64(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _dsrc+64(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, _ddst+64(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _dsrc+64(%rip), %eax
; DARWIN-64-PIC-NEXT:    movl %eax, _ddst+64(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @dsrc, i32 0, i64 16), align 32
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @ddst, i32 0, i64 16), align 32
	ret void
}

define void @qux04() nounwind {
; LINUX-64-STATIC-LABEL: qux04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $ddst+64, dptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ddst+64, dptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L19$pb
; LINUX-32-PIC-NEXT:  .L19$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp19:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp19-.L19$pb), %eax
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    addl $64, %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ddst+64, _dptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ddst+64, _dptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L19$pb
; DARWIN-32-PIC-NEXT:  L19$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_ddst-L19$pb)+64(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _dptr-L19$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst+64(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst+64(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst+64(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @ddst, i32 0, i64 16), i32** @dptr, align 8
	ret void
}

define void @qux05() nounwind {
; LINUX-64-STATIC-LABEL: qux05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc+64(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl dsrc+64, %eax
; LINUX-32-STATIC-NEXT:    movl dptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, 64(%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L20$pb
; LINUX-32-PIC-NEXT:  .L20$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp20:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp20-.L20$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 64(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 64(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax), %eax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _dsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc+64, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L20$pb
; DARWIN-32-PIC-NEXT:  L20$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl (_dsrc-L20$pb)+64(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl _dptr-L20$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 64(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _dsrc+64(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _dsrc+64(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _dsrc+64(%rip), %eax
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @dsrc, i32 0, i64 16), align 32
	%2 = getelementptr i32, i32* %0, i64 16
	store i32 %1, i32* %2, align 4
	ret void
}

define void @qux06() nounwind {
; LINUX-64-STATIC-LABEL: qux06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc+64(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ldst+64(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl lsrc+64, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ldst+64
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L21$pb
; LINUX-32-PIC-NEXT:  .L21$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp21:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp21-.L21$pb), %eax
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF+64(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, ldst@GOTOFF+64(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl lsrc+64(%rip), %eax
; LINUX-64-PIC-NEXT:    movl %eax, ldst+64(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _lsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ldst+64
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc+64, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _ldst+64
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L21$pb
; DARWIN-32-PIC-NEXT:  L21$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl (_lsrc-L21$pb)+64(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, (_ldst-L21$pb)+64(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _lsrc+64(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movl %eax, _ldst+64(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _lsrc+64(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, _ldst+64(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _lsrc+64(%rip), %eax
; DARWIN-64-PIC-NEXT:    movl %eax, _ldst+64(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @lsrc, i32 0, i64 16), align 4
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @ldst, i32 0, i64 16), align 4
	ret void
}

define void @qux07() nounwind {
; LINUX-64-STATIC-LABEL: qux07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $ldst+64, lptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ldst+64, lptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L22$pb
; LINUX-32-PIC-NEXT:  .L22$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp22:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp22-.L22$pb), %eax
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF+64(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, lptr@GOTOFF(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst+64(%rip), %rax
; LINUX-64-PIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ldst+64, _lptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ldst+64, _lptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L22$pb
; DARWIN-32-PIC-NEXT:  L22$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_ldst-L22$pb)+64(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _lptr-L22$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst+64(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst+64(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst+64(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @ldst, i32 0, i64 16), i32** @lptr, align 8
	ret void
}

define void @qux08() nounwind {
; LINUX-64-STATIC-LABEL: qux08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc+64(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: qux08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl lsrc+64, %eax
; LINUX-32-STATIC-NEXT:    movl lptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, 64(%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: qux08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L23$pb
; LINUX-32-PIC-NEXT:  .L23$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp23:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp23-.L23$pb), %eax
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF+64(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 64(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: qux08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl lsrc+64(%rip), %eax
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: qux08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _lsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: qux08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc+64, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 64(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: qux08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L23$pb
; DARWIN-32-PIC-NEXT:  L23$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl (_lsrc-L23$pb)+64(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl _lptr-L23$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 64(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: qux08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _lsrc+64(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: qux08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _lsrc+64(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: qux08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _lsrc+64(%rip), %eax
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @lsrc, i32 0, i64 16), align 4
	%2 = getelementptr i32, i32* %0, i64 16
	store i32 %1, i32* %2, align 4
	ret void
}

define void @ind00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, dst(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl src(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, dst(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L24$pb
; LINUX-32-PIC-NEXT:  .L24$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp24:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp24-.L24$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _src(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _dst(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L24$pb
; DARWIN-32-PIC-NEXT:  L24$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L24$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L24$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = getelementptr [131072 x i32], [131072 x i32]* @src, i64 0, i64 %i
	%1 = load i32, i32* %0, align 4
	%2 = getelementptr [131072 x i32], [131072 x i32]* @dst, i64 0, i64 %i
	store i32 %1, i32* %2, align 4
	ret void
}

define void @ixd00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ixd00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl xsrc(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, xdst(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ixd00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl xsrc(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, xdst(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ixd00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L25$pb
; LINUX-32-PIC-NEXT:  .L25$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp25:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp25-.L25$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ixd00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ixd00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _xsrc(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _xdst(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ixd00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ixd00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L25$pb
; DARWIN-32-PIC-NEXT:  L25$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L25$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L25$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ixd00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ixd00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ixd00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = getelementptr [32 x i32], [32 x i32]* @xsrc, i64 0, i64 %i
	%1 = load i32, i32* %0, align 4
	%2 = getelementptr [32 x i32], [32 x i32]* @xdst, i64 0, i64 %i
	store i32 %1, i32* %2, align 4
	ret void
}

define void @ind01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq dst(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal dst(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L26$pb
; LINUX-32-PIC-NEXT:  .L26$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp26:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp26-.L26$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    shll $2, %ecx
; LINUX-32-PIC-NEXT:    addl dst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    shlq $2, %rdi
; LINUX-64-PIC-NEXT:    addq dst@GOTPCREL(%rip), %rdi
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq %rdi, (%rax)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _dst(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    shll $2, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl L_dst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L26$pb
; DARWIN-32-PIC-NEXT:  L26$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    shll $2, %ecx
; DARWIN-32-PIC-NEXT:    addl L_dst$non_lazy_ptr-L26$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L26$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    shlq $2, %rdi
; DARWIN-64-STATIC-NEXT:    addq _dst@GOTPCREL(%rip), %rdi
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq %rdi, (%rax)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    shlq $2, %rdi
; DARWIN-64-DYNAMIC-NEXT:    addq _dst@GOTPCREL(%rip), %rdi
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rdi, (%rax)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    shlq $2, %rdi
; DARWIN-64-PIC-NEXT:    addq _dst@GOTPCREL(%rip), %rdi
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq %rdi, (%rax)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = getelementptr [131072 x i32], [131072 x i32]* @dst, i64 0, i64 %i
	store i32* %0, i32** @ptr, align 8
	ret void
}

define void @ixd01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ixd01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq xdst(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ixd01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal xdst(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ixd01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L27$pb
; LINUX-32-PIC-NEXT:  .L27$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp27:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp27-.L27$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    shll $2, %ecx
; LINUX-32-PIC-NEXT:    addl xdst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ixd01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    shlq $2, %rdi
; LINUX-64-PIC-NEXT:    addq xdst@GOTPCREL(%rip), %rdi
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq %rdi, (%rax)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ixd01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _xdst(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ixd01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    shll $2, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl L_xdst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ixd01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L27$pb
; DARWIN-32-PIC-NEXT:  L27$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    shll $2, %ecx
; DARWIN-32-PIC-NEXT:    addl L_xdst$non_lazy_ptr-L27$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L27$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ixd01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    shlq $2, %rdi
; DARWIN-64-STATIC-NEXT:    addq _xdst@GOTPCREL(%rip), %rdi
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq %rdi, (%rax)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ixd01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    shlq $2, %rdi
; DARWIN-64-DYNAMIC-NEXT:    addq _xdst@GOTPCREL(%rip), %rdi
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rdi, (%rax)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ixd01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    shlq $2, %rdi
; DARWIN-64-PIC-NEXT:    addq _xdst@GOTPCREL(%rip), %rdi
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq %rdi, (%rax)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = getelementptr [32 x i32], [32 x i32]* @xdst, i64 0, i64 %i
	store i32* %0, i32** @ptr, align 8
	ret void
}

define void @ind02(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl src(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl ptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, (%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L28$pb
; LINUX-32-PIC-NEXT:  .L28$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp28:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp28-.L28$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _src(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _ptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl (%edx), %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L28$pb
; DARWIN-32-PIC-NEXT:  L28$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L28$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L28$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = getelementptr [131072 x i32], [131072 x i32]* @src, i64 0, i64 %i
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr i32, i32* %0, i64 %i
	store i32 %2, i32* %3, align 4
	ret void
}

define void @ixd02(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ixd02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl xsrc(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ixd02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl xsrc(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl ptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, (%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ixd02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L29$pb
; LINUX-32-PIC-NEXT:  .L29$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp29:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp29-.L29$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ixd02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ixd02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _xsrc(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _ptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ixd02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl (%edx), %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ixd02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L29$pb
; DARWIN-32-PIC-NEXT:  L29$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L29$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L29$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ixd02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ixd02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ixd02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = getelementptr [32 x i32], [32 x i32]* @xsrc, i64 0, i64 %i
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr i32, i32* %0, i64 %i
	store i32 %2, i32* %3, align 4
	ret void
}

define void @ind03(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ddst(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl dsrc(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, ddst(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L30$pb
; LINUX-32-PIC-NEXT:  .L30$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp30:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp30-.L30$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _dsrc(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _ddst(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, _ddst(,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L30$pb
; DARWIN-32-PIC-NEXT:  L30$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl _dsrc-L30$pb(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl %edx, _ddst-L30$pb(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = getelementptr [131072 x i32], [131072 x i32]* @dsrc, i64 0, i64 %i
	%1 = load i32, i32* %0, align 4
	%2 = getelementptr [131072 x i32], [131072 x i32]* @ddst, i64 0, i64 %i
	store i32 %1, i32* %2, align 4
	ret void
}

define void @ind04(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ddst(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, dptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ddst(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, dptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L31$pb
; LINUX-32-PIC-NEXT:  .L31$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp31:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp31-.L31$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    shll $2, %ecx
; LINUX-32-PIC-NEXT:    addl ddst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    shlq $2, %rdi
; LINUX-64-PIC-NEXT:    addq ddst@GOTPCREL(%rip), %rdi
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq %rdi, (%rax)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ddst(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _dptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ddst(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _dptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L31$pb
; DARWIN-32-PIC-NEXT:  L31$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal _ddst-L31$pb(%eax,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _dptr-L31$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq (%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq (%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq (%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = getelementptr [131072 x i32], [131072 x i32]* @ddst, i64 0, i64 %i
	store i32* %0, i32** @dptr, align 8
	ret void
}

define void @ind05(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl dsrc(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl dptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, (%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L32$pb
; LINUX-32-PIC-NEXT:  .L32$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp32:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp32-.L32$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl (%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _dsrc(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _dptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L32$pb
; DARWIN-32-PIC-NEXT:  L32$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl _dsrc-L32$pb(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl _dptr-L32$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = getelementptr [131072 x i32], [131072 x i32]* @dsrc, i64 0, i64 %i
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr i32, i32* %0, i64 %i
	store i32 %2, i32* %3, align 4
	ret void
}

define void @ind06(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ldst(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl lsrc(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, ldst(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L33$pb
; LINUX-32-PIC-NEXT:  .L33$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp33:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp33-.L33$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF(%eax,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl %edx, ldst@GOTOFF(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _lsrc(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _ldst(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, _ldst(,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L33$pb
; DARWIN-32-PIC-NEXT:  L33$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl _lsrc-L33$pb(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl %edx, _ldst-L33$pb(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = getelementptr [131072 x i32], [131072 x i32]* @lsrc, i64 0, i64 %i
	%1 = load i32, i32* %0, align 4
	%2 = getelementptr [131072 x i32], [131072 x i32]* @ldst, i64 0, i64 %i
	store i32 %1, i32* %2, align 4
	ret void
}

define void @ind07(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ldst(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ldst(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, lptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L34$pb
; LINUX-32-PIC-NEXT:  .L34$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp34:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp34-.L34$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF(%eax,%ecx,4), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, lptr@GOTOFF(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq (%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ldst(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _lptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ldst(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _lptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L34$pb
; DARWIN-32-PIC-NEXT:  L34$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal _ldst-L34$pb(%eax,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _lptr-L34$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq (%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq (%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq (%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = getelementptr [131072 x i32], [131072 x i32]* @ldst, i64 0, i64 %i
	store i32* %0, i32** @lptr, align 8
	ret void
}

define void @ind08(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: ind08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ind08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl lsrc(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl lptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, (%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ind08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L35$pb
; LINUX-32-PIC-NEXT:  .L35$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp35:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp35-.L35$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF(%eax,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ind08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ind08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _lsrc(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _lptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ind08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, (%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ind08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L35$pb
; DARWIN-32-PIC-NEXT:  L35$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl _lsrc-L35$pb(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl _lptr-L35$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, (%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ind08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ind08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ind08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl (%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, (%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = getelementptr [131072 x i32], [131072 x i32]* @lsrc, i64 0, i64 %i
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr i32, i32* %0, i64 %i
	store i32 %2, i32* %3, align 4
	ret void
}

define void @off00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src+64(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, dst+64(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl src+64(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, dst+64(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L36$pb
; LINUX-32-PIC-NEXT:  .L36$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp36:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp36-.L36$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _src+64(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _dst+64(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl 64(%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L36$pb
; DARWIN-32-PIC-NEXT:  L36$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L36$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L36$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @src, i64 0, i64 %0
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr [131072 x i32], [131072 x i32]* @dst, i64 0, i64 %0
	store i32 %2, i32* %3, align 4
	ret void
}

define void @oxf00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: oxf00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl xsrc+64(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, xdst+64(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: oxf00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl xsrc+64(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, xdst+64(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: oxf00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L37$pb
; LINUX-32-PIC-NEXT:  .L37$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp37:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp37-.L37$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: oxf00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: oxf00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _xsrc+64(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _xdst+64(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: oxf00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl 64(%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: oxf00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L37$pb
; DARWIN-32-PIC-NEXT:  L37$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L37$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L37$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: oxf00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: oxf00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: oxf00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [32 x i32], [32 x i32]* @xsrc, i64 0, i64 %0
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr [32 x i32], [32 x i32]* @xdst, i64 0, i64 %0
	store i32 %2, i32* %3, align 4
	ret void
}

define void @off01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq dst+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal dst+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L38$pb
; LINUX-32-PIC-NEXT:  .L38$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp38:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp38-.L38$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    leal 64(%edx,%ecx,4), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _dst+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L38$pb
; DARWIN-32-PIC-NEXT:  L38$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L38$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    leal 64(%edx,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L38$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%.sum = add i64 %i, 16
	%0 = getelementptr [131072 x i32], [131072 x i32]* @dst, i64 0, i64 %.sum
	store i32* %0, i32** @ptr, align 8
	ret void
}

define void @oxf01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: oxf01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq xdst+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: oxf01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal xdst+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: oxf01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L39$pb
; LINUX-32-PIC-NEXT:  .L39$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp39:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp39-.L39$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    leal 64(%edx,%ecx,4), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: oxf01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: oxf01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _xdst+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: oxf01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: oxf01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L39$pb
; DARWIN-32-PIC-NEXT:  L39$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L39$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    leal 64(%edx,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L39$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: oxf01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: oxf01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: oxf01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%.sum = add i64 %i, 16
	%0 = getelementptr [32 x i32], [32 x i32]* @xdst, i64 0, i64 %.sum
	store i32* %0, i32** @ptr, align 8
	ret void
}

define void @off02(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src+64(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl src+64(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl ptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L40$pb
; LINUX-32-PIC-NEXT:  .L40$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp40:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp40-.L40$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _src+64(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _ptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl 64(%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl (%edx), %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L40$pb
; DARWIN-32-PIC-NEXT:  L40$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L40$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L40$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = add i64 %i, 16
	%2 = getelementptr [131072 x i32], [131072 x i32]* @src, i64 0, i64 %1
	%3 = load i32, i32* %2, align 4
	%4 = getelementptr i32, i32* %0, i64 %1
	store i32 %3, i32* %4, align 4
	ret void
}

define void @oxf02(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: oxf02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl xsrc+64(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: oxf02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl xsrc+64(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl ptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: oxf02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L41$pb
; LINUX-32-PIC-NEXT:  .L41$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp41:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp41-.L41$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: oxf02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: oxf02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _xsrc+64(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _ptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: oxf02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl 64(%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl (%edx), %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: oxf02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L41$pb
; DARWIN-32-PIC-NEXT:  L41$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L41$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L41$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: oxf02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: oxf02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: oxf02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = add i64 %i, 16
	%2 = getelementptr [32 x i32], [32 x i32]* @xsrc, i64 0, i64 %1
	%3 = load i32, i32* %2, align 4
	%4 = getelementptr i32, i32* %0, i64 %1
	store i32 %3, i32* %4, align 4
	ret void
}

define void @off03(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc+64(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ddst+64(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl dsrc+64(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, ddst+64(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L42$pb
; LINUX-32-PIC-NEXT:  .L42$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp42:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp42-.L42$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _dsrc+64(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _ddst+64(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc+64(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, _ddst+64(,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L42$pb
; DARWIN-32-PIC-NEXT:  L42$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl (_dsrc-L42$pb)+64(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl %edx, (_ddst-L42$pb)+64(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @dsrc, i64 0, i64 %0
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr [131072 x i32], [131072 x i32]* @ddst, i64 0, i64 %0
	store i32 %2, i32* %3, align 4
	ret void
}

define void @off04(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ddst+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, dptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ddst+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, dptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L43$pb
; LINUX-32-PIC-NEXT:  .L43$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp43:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp43-.L43$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    leal 64(%edx,%ecx,4), %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ddst+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _dptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ddst+64(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _dptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L43$pb
; DARWIN-32-PIC-NEXT:  L43$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_ddst-L43$pb)+64(%eax,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _dptr-L43$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%.sum = add i64 %i, 16
	%0 = getelementptr [131072 x i32], [131072 x i32]* @ddst, i64 0, i64 %.sum
	store i32* %0, i32** @dptr, align 8
	ret void
}

define void @off05(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc+64(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl dsrc+64(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl dptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L44$pb
; LINUX-32-PIC-NEXT:  .L44$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp44:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp44-.L44$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 64(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _dsrc+64(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _dptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc+64(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L44$pb
; DARWIN-32-PIC-NEXT:  L44$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl (_dsrc-L44$pb)+64(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl _dptr-L44$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = add i64 %i, 16
	%2 = getelementptr [131072 x i32], [131072 x i32]* @dsrc, i64 0, i64 %1
	%3 = load i32, i32* %2, align 4
	%4 = getelementptr i32, i32* %0, i64 %1
	store i32 %3, i32* %4, align 4
	ret void
}

define void @off06(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc+64(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ldst+64(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl lsrc+64(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, ldst+64(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L45$pb
; LINUX-32-PIC-NEXT:  .L45$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp45:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp45-.L45$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF+64(%eax,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl %edx, ldst@GOTOFF+64(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _lsrc+64(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _ldst+64(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc+64(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, _ldst+64(,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L45$pb
; DARWIN-32-PIC-NEXT:  L45$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl (_lsrc-L45$pb)+64(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl %edx, (_ldst-L45$pb)+64(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @lsrc, i64 0, i64 %0
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr [131072 x i32], [131072 x i32]* @ldst, i64 0, i64 %0
	store i32 %2, i32* %3, align 4
	ret void
}

define void @off07(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ldst+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ldst+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, lptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L46$pb
; LINUX-32-PIC-NEXT:  .L46$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp46:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp46-.L46$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF+64(%eax,%ecx,4), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, lptr@GOTOFF(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ldst+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _lptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ldst+64(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _lptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L46$pb
; DARWIN-32-PIC-NEXT:  L46$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_ldst-L46$pb)+64(%eax,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _lptr-L46$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%.sum = add i64 %i, 16
	%0 = getelementptr [131072 x i32], [131072 x i32]* @ldst, i64 0, i64 %.sum
	store i32* %0, i32** @lptr, align 8
	ret void
}

define void @off08(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: off08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc+64(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: off08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl lsrc+64(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl lptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: off08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L47$pb
; LINUX-32-PIC-NEXT:  .L47$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp47:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp47-.L47$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF+64(%eax,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: off08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: off08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _lsrc+64(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _lptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: off08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc+64(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 64(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: off08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L47$pb
; DARWIN-32-PIC-NEXT:  L47$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl (_lsrc-L47$pb)+64(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl _lptr-L47$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 64(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: off08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: off08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: off08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 64(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 64(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = add i64 %i, 16
	%2 = getelementptr [131072 x i32], [131072 x i32]* @lsrc, i64 0, i64 %1
	%3 = load i32, i32* %2, align 4
	%4 = getelementptr i32, i32* %0, i64 %1
	store i32 %3, i32* %4, align 4
	ret void
}

define void @moo00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src+262144(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, dst+262144(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl src+262144, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, dst+262144
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L48$pb
; LINUX-32-PIC-NEXT:  .L48$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp48:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp48-.L48$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 262144(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax), %eax
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _src+262144, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _dst+262144
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl 262144(%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 262144(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L48$pb
; DARWIN-32-PIC-NEXT:  L48$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L48$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl 262144(%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L48$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 262144(%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 262144(%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 262144(%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @src, i32 0, i64 65536), align 4
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @dst, i32 0, i64 65536), align 4
	ret void
}

define void @moo01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $dst+262144, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dst+262144, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L49$pb
; LINUX-32-PIC-NEXT:  .L49$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp49:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp49-.L49$pb), %eax
; LINUX-32-PIC-NEXT:    movl $262144, %ecx # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl dst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dst+262144, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-DYNAMIC-NEXT:    addl L_dst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L49$pb
; DARWIN-32-PIC-NEXT:  L49$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl $262144, %ecx ## imm = 0x40000
; DARWIN-32-PIC-NEXT:    addl L_dst$non_lazy_ptr-L49$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L49$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-STATIC-NEXT:    addq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-DYNAMIC-NEXT:    addq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-PIC-NEXT:    addq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @dst, i32 0, i64 65536), i32** @ptr, align 8
	ret void
}

define void @moo02(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src+262144(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 262144(%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl src+262144, %eax
; LINUX-32-STATIC-NEXT:    movl ptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, 262144(%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L50$pb
; LINUX-32-PIC-NEXT:  .L50$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp50:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp50-.L50$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 262144(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _src+262144, %eax
; DARWIN-32-STATIC-NEXT:    movl _ptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, 262144(%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl 262144(%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl (%ecx), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 262144(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L50$pb
; DARWIN-32-PIC-NEXT:  L50$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L50$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl 262144(%ecx), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L50$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 262144(%rax), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 262144(%rax), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 262144(%rax), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @src, i32 0, i64 65536), align 4
	%2 = getelementptr i32, i32* %0, i64 65536
	store i32 %1, i32* %2, align 4
	ret void
}

define void @moo03(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc+262144(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ddst+262144(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl dsrc+262144, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ddst+262144
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L51$pb
; LINUX-32-PIC-NEXT:  .L51$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp51:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp51-.L51$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 262144(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax), %eax
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _dsrc+262144, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ddst+262144
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc+262144, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _ddst+262144
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L51$pb
; DARWIN-32-PIC-NEXT:  L51$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl (_dsrc-L51$pb)+262144(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, (_ddst-L51$pb)+262144(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _dsrc+262144(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movl %eax, _ddst+262144(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _dsrc+262144(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, _ddst+262144(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _dsrc+262144(%rip), %eax
; DARWIN-64-PIC-NEXT:    movl %eax, _ddst+262144(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @dsrc, i32 0, i64 65536), align 32
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @ddst, i32 0, i64 65536), align 32
	ret void
}

define void @moo04(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $ddst+262144, dptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ddst+262144, dptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L52$pb
; LINUX-32-PIC-NEXT:  .L52$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp52:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp52-.L52$pb), %eax
; LINUX-32-PIC-NEXT:    movl $262144, %ecx # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl ddst@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ddst+262144, _dptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ddst+262144, _dptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L52$pb
; DARWIN-32-PIC-NEXT:  L52$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_ddst-L52$pb)+262144(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _dptr-L52$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst+262144(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst+262144(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst+262144(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @ddst, i32 0, i64 65536), i32** @dptr, align 8
	ret void
}

define void @moo05(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc+262144(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 262144(%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl dsrc+262144, %eax
; LINUX-32-STATIC-NEXT:    movl dptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, 262144(%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L53$pb
; LINUX-32-PIC-NEXT:  .L53$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp53:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp53-.L53$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl 262144(%ecx), %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax), %eax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _dsrc+262144, %eax
; DARWIN-32-STATIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, 262144(%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc+262144, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 262144(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L53$pb
; DARWIN-32-PIC-NEXT:  L53$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl (_dsrc-L53$pb)+262144(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl _dptr-L53$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _dsrc+262144(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _dsrc+262144(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _dsrc+262144(%rip), %eax
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @dsrc, i32 0, i64 65536), align 32
	%2 = getelementptr i32, i32* %0, i64 65536
	store i32 %1, i32* %2, align 4
	ret void
}

define void @moo06(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc+262144(%rip), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ldst+262144(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl lsrc+262144, %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ldst+262144
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L54$pb
; LINUX-32-PIC-NEXT:  .L54$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp54:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp54-.L54$pb), %eax
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF+262144(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, ldst@GOTOFF+262144(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl lsrc+262144(%rip), %eax
; LINUX-64-PIC-NEXT:    movl %eax, ldst+262144(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _lsrc+262144, %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ldst+262144
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc+262144, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _ldst+262144
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L54$pb
; DARWIN-32-PIC-NEXT:  L54$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl (_lsrc-L54$pb)+262144(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, (_ldst-L54$pb)+262144(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _lsrc+262144(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movl %eax, _ldst+262144(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _lsrc+262144(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, _ldst+262144(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _lsrc+262144(%rip), %eax
; DARWIN-64-PIC-NEXT:    movl %eax, _ldst+262144(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @lsrc, i32 0, i64 65536), align 4
	store i32 %0, i32* getelementptr ([131072 x i32], [131072 x i32]* @ldst, i32 0, i64 65536), align 4
	ret void
}

define void @moo07(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq $ldst+262144, lptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ldst+262144, lptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L55$pb
; LINUX-32-PIC-NEXT:  .L55$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp55:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp55-.L55$pb), %eax
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF+262144(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, lptr@GOTOFF(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst+262144(%rip), %rax
; LINUX-64-PIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ldst+262144, _lptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ldst+262144, _lptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L55$pb
; DARWIN-32-PIC-NEXT:  L55$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_ldst-L55$pb)+262144(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _lptr-L55$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst+262144(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst+262144(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst+262144(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	store i32* getelementptr ([131072 x i32], [131072 x i32]* @ldst, i32 0, i64 65536), i32** @lptr, align 8
	ret void
}

define void @moo08(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: moo08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc+262144(%rip), %eax
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 262144(%rcx)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: moo08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl lsrc+262144, %eax
; LINUX-32-STATIC-NEXT:    movl lptr, %ecx
; LINUX-32-STATIC-NEXT:    movl %eax, 262144(%ecx)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: moo08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L56$pb
; LINUX-32-PIC-NEXT:  .L56$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp56:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp56-.L56$pb), %eax
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF+262144(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: moo08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl lsrc+262144(%rip), %eax
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: moo08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _lsrc+262144, %eax
; DARWIN-32-STATIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-STATIC-NEXT:    movl %eax, 262144(%ecx)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: moo08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc+262144, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, 262144(%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: moo08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L56$pb
; DARWIN-32-PIC-NEXT:  L56$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl (_lsrc-L56$pb)+262144(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl _lptr-L56$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, 262144(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: moo08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl _lsrc+262144(%rip), %eax
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: moo08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl _lsrc+262144(%rip), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: moo08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl _lsrc+262144(%rip), %eax
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = load i32, i32* getelementptr ([131072 x i32], [131072 x i32]* @lsrc, i32 0, i64 65536), align 4
	%2 = getelementptr i32, i32* %0, i64 65536
	store i32 %1, i32* %2, align 4
	ret void
}

define void @big00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src+262144(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, dst+262144(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl src+262144(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, dst+262144(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L57$pb
; LINUX-32-PIC-NEXT:  .L57$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp57:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp57-.L57$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 262144(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _src+262144(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _dst+262144(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl 262144(%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L57$pb
; DARWIN-32-PIC-NEXT:  L57$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L57$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl 262144(%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L57$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @src, i64 0, i64 %0
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr [131072 x i32], [131072 x i32]* @dst, i64 0, i64 %0
	store i32 %2, i32* %3, align 4
	ret void
}

define void @big01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq dst+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, ptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal dst+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, ptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L58$pb
; LINUX-32-PIC-NEXT:  .L58$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp58:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp58-.L58$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    leal 262144(%edx,%ecx,4), %ecx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _dst+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _ptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, (%ecx)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L58$pb
; DARWIN-32-PIC-NEXT:  L58$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L58$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    leal 262144(%edx,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L58$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %ecx, (%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq %rax, (%rcx)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%.sum = add i64 %i, 65536
	%0 = getelementptr [131072 x i32], [131072 x i32]* @dst, i64 0, i64 %.sum
	store i32* %0, i32** @ptr, align 8
	ret void
}

define void @big02(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl src+262144(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl src+262144(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl ptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L59$pb
; LINUX-32-PIC-NEXT:  .L59$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp59:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp59-.L59$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 262144(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _src+262144(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _ptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl 262144(%ecx,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl (%edx), %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L59$pb
; DARWIN-32-PIC-NEXT:  L59$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L59$pb(%eax), %edx
; DARWIN-32-PIC-NEXT:    movl 262144(%edx,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L59$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movq (%rcx), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = add i64 %i, 65536
	%2 = getelementptr [131072 x i32], [131072 x i32]* @src, i64 0, i64 %1
	%3 = load i32, i32* %2, align 4
	%4 = getelementptr i32, i32* %0, i64 %1
	store i32 %3, i32* %4, align 4
	ret void
}

define void @big03(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc+262144(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ddst+262144(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl dsrc+262144(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, ddst+262144(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L60$pb
; LINUX-32-PIC-NEXT:  .L60$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp60:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp60-.L60$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 262144(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _dsrc+262144(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _ddst+262144(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc+262144(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, _ddst+262144(,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L60$pb
; DARWIN-32-PIC-NEXT:  L60$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl (_dsrc-L60$pb)+262144(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl %edx, (_ddst-L60$pb)+262144(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @dsrc, i64 0, i64 %0
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr [131072 x i32], [131072 x i32]* @ddst, i64 0, i64 %0
	store i32 %2, i32* %3, align 4
	ret void
}

define void @big04(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ddst+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, dptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ddst+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, dptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L61$pb
; LINUX-32-PIC-NEXT:  .L61$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp61:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp61-.L61$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    leal 262144(%edx,%ecx,4), %ecx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %ecx, (%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq %rax, (%rcx)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ddst+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _dptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ddst+262144(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _dptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L61$pb
; DARWIN-32-PIC-NEXT:  L61$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_ddst-L61$pb)+262144(%eax,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _dptr-L61$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _dptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%.sum = add i64 %i, 65536
	%0 = getelementptr [131072 x i32], [131072 x i32]* @ddst, i64 0, i64 %.sum
	store i32* %0, i32** @dptr, align 8
	ret void
}

define void @big05(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl dsrc+262144(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl dsrc+262144(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl dptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L62$pb
; LINUX-32-PIC-NEXT:  .L62$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp62:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp62-.L62$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %edx
; LINUX-32-PIC-NEXT:    movl 262144(%edx,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movq (%rcx), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _dsrc+262144(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _dptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dsrc+262144(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L62$pb
; DARWIN-32-PIC-NEXT:  L62$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl (_dsrc-L62$pb)+262144(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl _dptr-L62$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = add i64 %i, 65536
	%2 = getelementptr [131072 x i32], [131072 x i32]* @dsrc, i64 0, i64 %1
	%3 = load i32, i32* %2, align 4
	%4 = getelementptr i32, i32* %0, i64 %1
	store i32 %3, i32* %4, align 4
	ret void
}

define void @big06(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc+262144(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movl %eax, ldst+262144(,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl lsrc+262144(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl %ecx, ldst+262144(,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L63$pb
; LINUX-32-PIC-NEXT:  .L63$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp63:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp63-.L63$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF+262144(%eax,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl %edx, ldst@GOTOFF+262144(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _lsrc+262144(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl %ecx, _ldst+262144(,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc+262144(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, _ldst+262144(,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L63$pb
; DARWIN-32-PIC-NEXT:  L63$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl (_lsrc-L63$pb)+262144(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl %edx, (_ldst-L63$pb)+262144(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @lsrc, i64 0, i64 %0
	%2 = load i32, i32* %1, align 4
	%3 = getelementptr [131072 x i32], [131072 x i32]* @ldst, i64 0, i64 %0
	store i32 %2, i32* %3, align 4
	ret void
}

define void @big07(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ldst+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ldst+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    movl %eax, lptr
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L64$pb
; LINUX-32-PIC-NEXT:  .L64$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp64:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp64-.L64$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF+262144(%eax,%ecx,4), %ecx
; LINUX-32-PIC-NEXT:    movl %ecx, lptr@GOTOFF(%eax)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    movq %rax, lptr(%rip)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ldst+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    movl %eax, _lptr
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ldst+262144(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl %eax, _lptr
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L64$pb
; DARWIN-32-PIC-NEXT:  L64$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_ldst-L64$pb)+262144(%eax,%ecx,4), %ecx
; DARWIN-32-PIC-NEXT:    movl %ecx, _lptr-L64$pb(%eax)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    movq %rax, _lptr(%rip)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%.sum = add i64 %i, 65536
	%0 = getelementptr [131072 x i32], [131072 x i32]* @ldst, i64 0, i64 %.sum
	store i32* %0, i32** @lptr, align 8
	ret void
}

define void @big08(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: big08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl lsrc+262144(,%rdi,4), %eax
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: big08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl lsrc+262144(,%eax,4), %ecx
; LINUX-32-STATIC-NEXT:    movl lptr, %edx
; LINUX-32-STATIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: big08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L65$pb
; LINUX-32-PIC-NEXT:  .L65$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp65:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp65-.L65$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl lsrc@GOTOFF+262144(%eax,%ecx,4), %edx
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: big08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: big08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _lsrc+262144(,%eax,4), %ecx
; DARWIN-32-STATIC-NEXT:    movl _lptr, %edx
; DARWIN-32-STATIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: big08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lsrc+262144(,%eax,4), %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %edx
; DARWIN-32-DYNAMIC-NEXT:    movl %ecx, 262144(%edx,%eax,4)
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: big08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L65$pb
; DARWIN-32-PIC-NEXT:  L65$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl (_lsrc-L65$pb)+262144(%eax,%ecx,4), %edx
; DARWIN-32-PIC-NEXT:    movl _lptr-L65$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl %edx, 262144(%eax,%ecx,4)
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: big08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: big08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: big08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    movl 262144(%rax,%rdi,4), %eax
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl %eax, 262144(%rcx,%rdi,4)
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = add i64 %i, 65536
	%2 = getelementptr [131072 x i32], [131072 x i32]* @lsrc, i64 0, i64 %1
	%3 = load i32, i32* %2, align 4
	%4 = getelementptr i32, i32* %0, i64 %1
	store i32 %3, i32* %4, align 4
	ret void
}

define i8* @bar00() nounwind {
; LINUX-64-STATIC-LABEL: bar00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $src, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $src, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L66$pb
; LINUX-32-PIC-NEXT:  .L66$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp66:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp66-.L66$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_src, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L66$pb
; DARWIN-32-PIC-NEXT:  L66$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L66$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @src to i8*)
}

define i8* @bxr00() nounwind {
; LINUX-64-STATIC-LABEL: bxr00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $xsrc, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bxr00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xsrc, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bxr00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L67$pb
; LINUX-32-PIC-NEXT:  .L67$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp67:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp67-.L67$pb), %eax
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bxr00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bxr00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xsrc, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bxr00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bxr00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L67$pb
; DARWIN-32-PIC-NEXT:  L67$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L67$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bxr00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bxr00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bxr00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([32 x i32]* @xsrc to i8*)
}

define i8* @bar01() nounwind {
; LINUX-64-STATIC-LABEL: bar01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dst, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dst, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L68$pb
; LINUX-32-PIC-NEXT:  .L68$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp68:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp68-.L68$pb), %eax
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dst, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L68$pb
; DARWIN-32-PIC-NEXT:  L68$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L68$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @dst to i8*)
}

define i8* @bxr01() nounwind {
; LINUX-64-STATIC-LABEL: bxr01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $xdst, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bxr01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xdst, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bxr01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L69$pb
; LINUX-32-PIC-NEXT:  .L69$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp69:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp69-.L69$pb), %eax
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bxr01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bxr01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xdst, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bxr01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bxr01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L69$pb
; DARWIN-32-PIC-NEXT:  L69$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L69$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bxr01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bxr01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bxr01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([32 x i32]* @xdst to i8*)
}

define i8* @bar02() nounwind {
; LINUX-64-STATIC-LABEL: bar02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ptr, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L70$pb
; LINUX-32-PIC-NEXT:  .L70$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp70:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp70-.L70$pb), %eax
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L70$pb
; DARWIN-32-PIC-NEXT:  L70$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L70$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32** @ptr to i8*)
}

define i8* @bar03() nounwind {
; LINUX-64-STATIC-LABEL: bar03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dsrc, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dsrc, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L71$pb
; LINUX-32-PIC-NEXT:  .L71$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp71:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp71-.L71$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dsrc, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_dsrc, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L71$pb
; DARWIN-32-PIC-NEXT:  L71$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _dsrc-L71$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @dsrc to i8*)
}

define i8* @bar04() nounwind {
; LINUX-64-STATIC-LABEL: bar04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ddst, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ddst, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L72$pb
; LINUX-32-PIC-NEXT:  .L72$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp72:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp72-.L72$pb), %eax
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ddst, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ddst, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L72$pb
; DARWIN-32-PIC-NEXT:  L72$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _ddst-L72$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @ddst to i8*)
}

define i8* @bar05() nounwind {
; LINUX-64-STATIC-LABEL: bar05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dptr, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L73$pb
; LINUX-32-PIC-NEXT:  .L73$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp73:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp73-.L73$pb), %eax
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_dptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L73$pb
; DARWIN-32-PIC-NEXT:  L73$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _dptr-L73$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32** @dptr to i8*)
}

define i8* @bar06() nounwind {
; LINUX-64-STATIC-LABEL: bar06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $lsrc, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $lsrc, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L74$pb
; LINUX-32-PIC-NEXT:  .L74$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp74:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp74-.L74$pb), %eax
; LINUX-32-PIC-NEXT:    leal lsrc@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_lsrc, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_lsrc, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L74$pb
; DARWIN-32-PIC-NEXT:  L74$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _lsrc-L74$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @lsrc to i8*)
}

define i8* @bar07() nounwind {
; LINUX-64-STATIC-LABEL: bar07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ldst, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ldst, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L75$pb
; LINUX-32-PIC-NEXT:  .L75$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp75:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp75-.L75$pb), %eax
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ldst, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ldst, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L75$pb
; DARWIN-32-PIC-NEXT:  L75$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _ldst-L75$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @ldst to i8*)
}

define i8* @bar08() nounwind {
; LINUX-64-STATIC-LABEL: bar08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $lptr, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bar08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $lptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bar08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L76$pb
; LINUX-32-PIC-NEXT:  .L76$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp76:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp76-.L76$pb), %eax
; LINUX-32-PIC-NEXT:    leal lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bar08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lptr(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bar08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_lptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bar08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_lptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bar08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L76$pb
; DARWIN-32-PIC-NEXT:  L76$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _lptr-L76$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bar08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bar08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bar08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32** @lptr to i8*)
}

define i8* @har00() nounwind {
; LINUX-64-STATIC-LABEL: har00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $src, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $src, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L77$pb
; LINUX-32-PIC-NEXT:  .L77$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp77:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp77-.L77$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_src, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L77$pb
; DARWIN-32-PIC-NEXT:  L77$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L77$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @src to i8*)
}

define i8* @hxr00() nounwind {
; LINUX-64-STATIC-LABEL: hxr00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $xsrc, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: hxr00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xsrc, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: hxr00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L78$pb
; LINUX-32-PIC-NEXT:  .L78$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp78:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp78-.L78$pb), %eax
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: hxr00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: hxr00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xsrc, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: hxr00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: hxr00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L78$pb
; DARWIN-32-PIC-NEXT:  L78$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L78$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: hxr00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: hxr00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: hxr00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([32 x i32]* @xsrc to i8*)
}

define i8* @har01() nounwind {
; LINUX-64-STATIC-LABEL: har01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dst, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dst, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L79$pb
; LINUX-32-PIC-NEXT:  .L79$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp79:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp79-.L79$pb), %eax
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dst, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L79$pb
; DARWIN-32-PIC-NEXT:  L79$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L79$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @dst to i8*)
}

define i8* @hxr01() nounwind {
; LINUX-64-STATIC-LABEL: hxr01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $xdst, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: hxr01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xdst, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: hxr01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L80$pb
; LINUX-32-PIC-NEXT:  .L80$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp80:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp80-.L80$pb), %eax
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: hxr01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: hxr01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xdst, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: hxr01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: hxr01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L80$pb
; DARWIN-32-PIC-NEXT:  L80$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L80$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: hxr01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: hxr01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: hxr01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([32 x i32]* @xdst to i8*)
}

define i8* @har02() nounwind {
; LINUX-64-STATIC-LABEL: har02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl ptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L81$pb
; LINUX-32-PIC-NEXT:  .L81$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp81:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp81-.L81$pb), %eax
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq (%rax), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _ptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl (%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L81$pb
; DARWIN-32-PIC-NEXT:  L81$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L81$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq (%rax), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq (%rax), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq (%rax), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = bitcast i32* %0 to i8*
	ret i8* %1
}

define i8* @har03() nounwind {
; LINUX-64-STATIC-LABEL: har03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dsrc, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dsrc, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L82$pb
; LINUX-32-PIC-NEXT:  .L82$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp82:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp82-.L82$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dsrc, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_dsrc, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L82$pb
; DARWIN-32-PIC-NEXT:  L82$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _dsrc-L82$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @dsrc to i8*)
}

define i8* @har04() nounwind {
; LINUX-64-STATIC-LABEL: har04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ddst, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ddst, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L83$pb
; LINUX-32-PIC-NEXT:  .L83$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp83:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp83-.L83$pb), %eax
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ddst, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ddst, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L83$pb
; DARWIN-32-PIC-NEXT:  L83$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _ddst-L83$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @ddst to i8*)
}

define i8* @har05() nounwind {
; LINUX-64-STATIC-LABEL: har05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl dptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L84$pb
; LINUX-32-PIC-NEXT:  .L84$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp84:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp84-.L84$pb), %eax
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq (%rax), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _dptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L84$pb
; DARWIN-32-PIC-NEXT:  L84$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl _dptr-L84$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = bitcast i32* %0 to i8*
	ret i8* %1
}

define i8* @har06() nounwind {
; LINUX-64-STATIC-LABEL: har06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $lsrc, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $lsrc, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L85$pb
; LINUX-32-PIC-NEXT:  .L85$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp85:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp85-.L85$pb), %eax
; LINUX-32-PIC-NEXT:    leal lsrc@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_lsrc, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_lsrc, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L85$pb
; DARWIN-32-PIC-NEXT:  L85$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _lsrc-L85$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @lsrc to i8*)
}

define i8* @har07() nounwind {
; LINUX-64-STATIC-LABEL: har07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ldst, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ldst, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L86$pb
; LINUX-32-PIC-NEXT:  .L86$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp86:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp86-.L86$pb), %eax
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ldst, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ldst, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L86$pb
; DARWIN-32-PIC-NEXT:  L86$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _ldst-L86$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast ([131072 x i32]* @ldst to i8*)
}

define i8* @har08() nounwind {
; LINUX-64-STATIC-LABEL: har08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: har08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl lptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: har08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L87$pb
; LINUX-32-PIC-NEXT:  .L87$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp87:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp87-.L87$pb), %eax
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: har08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: har08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _lptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: har08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: har08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L87$pb
; DARWIN-32-PIC-NEXT:  L87$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl _lptr-L87$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: har08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: har08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: har08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = bitcast i32* %0 to i8*
	ret i8* %1
}

define i8* @bat00() nounwind {
; LINUX-64-STATIC-LABEL: bat00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $src+64, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $src+64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L88$pb
; LINUX-32-PIC-NEXT:  .L88$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp88:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp88-.L88$pb), %eax
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_src+64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L88$pb
; DARWIN-32-PIC-NEXT:  L88$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L88$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    addl $64, %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @src, i32 0, i64 16) to i8*)
}

define i8* @bxt00() nounwind {
; LINUX-64-STATIC-LABEL: bxt00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $xsrc+64, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bxt00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xsrc+64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bxt00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L89$pb
; LINUX-32-PIC-NEXT:  .L89$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp89:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp89-.L89$pb), %eax
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bxt00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bxt00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bxt00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bxt00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L89$pb
; DARWIN-32-PIC-NEXT:  L89$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L89$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    addl $64, %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bxt00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bxt00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bxt00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([32 x i32], [32 x i32]* @xsrc, i32 0, i64 16) to i8*)
}

define i8* @bat01() nounwind {
; LINUX-64-STATIC-LABEL: bat01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dst+64, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dst+64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L90$pb
; LINUX-32-PIC-NEXT:  .L90$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp90:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp90-.L90$pb), %eax
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dst+64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L90$pb
; DARWIN-32-PIC-NEXT:  L90$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L90$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    addl $64, %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @dst, i32 0, i64 16) to i8*)
}

define i8* @bxt01() nounwind {
; LINUX-64-STATIC-LABEL: bxt01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $xdst+64, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bxt01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xdst+64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bxt01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L91$pb
; LINUX-32-PIC-NEXT:  .L91$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp91:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp91-.L91$pb), %eax
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bxt01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bxt01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xdst+64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bxt01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bxt01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L91$pb
; DARWIN-32-PIC-NEXT:  L91$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L91$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    addl $64, %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bxt01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bxt01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bxt01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([32 x i32], [32 x i32]* @xdst, i32 0, i64 16) to i8*)
}

define i8* @bat02() nounwind {
; LINUX-64-STATIC-LABEL: bat02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    addq $64, %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl ptr, %eax
; LINUX-32-STATIC-NEXT:    addl $64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L92$pb
; LINUX-32-PIC-NEXT:  .L92$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp92:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp92-.L92$pb), %eax
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq (%rax), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _ptr, %eax
; DARWIN-32-STATIC-NEXT:    addl $64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl (%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L92$pb
; DARWIN-32-PIC-NEXT:  L92$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L92$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    addl $64, %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq (%rax), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq (%rax), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq (%rax), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = getelementptr i32, i32* %0, i64 16
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @bat03() nounwind {
; LINUX-64-STATIC-LABEL: bat03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dsrc+64, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dsrc+64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L93$pb
; LINUX-32-PIC-NEXT:  .L93$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp93:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp93-.L93$pb), %eax
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_dsrc+64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L93$pb
; DARWIN-32-PIC-NEXT:  L93$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_dsrc-L93$pb)+64(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc+64(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc+64(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc+64(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @dsrc, i32 0, i64 16) to i8*)
}

define i8* @bat04() nounwind {
; LINUX-64-STATIC-LABEL: bat04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ddst+64, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ddst+64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L94$pb
; LINUX-32-PIC-NEXT:  .L94$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp94:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp94-.L94$pb), %eax
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ddst+64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ddst+64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L94$pb
; DARWIN-32-PIC-NEXT:  L94$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_ddst-L94$pb)+64(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst+64(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst+64(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst+64(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @ddst, i32 0, i64 16) to i8*)
}

define i8* @bat05() nounwind {
; LINUX-64-STATIC-LABEL: bat05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    addq $64, %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl dptr, %eax
; LINUX-32-STATIC-NEXT:    addl $64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L95$pb
; LINUX-32-PIC-NEXT:  .L95$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp95:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp95-.L95$pb), %eax
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq (%rax), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _dptr, %eax
; DARWIN-32-STATIC-NEXT:    addl $64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L95$pb
; DARWIN-32-PIC-NEXT:  L95$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl _dptr-L95$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    addl $64, %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = getelementptr i32, i32* %0, i64 16
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @bat06() nounwind {
; LINUX-64-STATIC-LABEL: bat06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $lsrc+64, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $lsrc+64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L96$pb
; LINUX-32-PIC-NEXT:  .L96$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp96:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp96-.L96$pb), %eax
; LINUX-32-PIC-NEXT:    leal lsrc@GOTOFF+64(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc+64(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_lsrc+64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_lsrc+64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L96$pb
; DARWIN-32-PIC-NEXT:  L96$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_lsrc-L96$pb)+64(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc+64(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc+64(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc+64(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @lsrc, i32 0, i64 16) to i8*)
}

define i8* @bat07() nounwind {
; LINUX-64-STATIC-LABEL: bat07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ldst+64, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ldst+64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L97$pb
; LINUX-32-PIC-NEXT:  .L97$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp97:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp97-.L97$pb), %eax
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF+64(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst+64(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ldst+64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ldst+64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L97$pb
; DARWIN-32-PIC-NEXT:  L97$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_ldst-L97$pb)+64(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst+64(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst+64(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst+64(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @ldst, i32 0, i64 16) to i8*)
}

define i8* @bat08() nounwind {
; LINUX-64-STATIC-LABEL: bat08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    addq $64, %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bat08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl lptr, %eax
; LINUX-32-STATIC-NEXT:    addl $64, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bat08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L98$pb
; LINUX-32-PIC-NEXT:  .L98$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp98:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp98-.L98$pb), %eax
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    addl $64, %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bat08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rax
; LINUX-64-PIC-NEXT:    addq $64, %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bat08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl _lptr, %eax
; DARWIN-32-STATIC-NEXT:    addl $64, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bat08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    addl $64, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bat08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L98$pb
; DARWIN-32-PIC-NEXT:  L98$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl _lptr-L98$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    addl $64, %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bat08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    addq $64, %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bat08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    addq $64, %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bat08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    addq $64, %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = getelementptr i32, i32* %0, i64 16
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @bam00() nounwind {
; LINUX-64-STATIC-LABEL: bam00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $src+262144, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $src+262144, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L99$pb
; LINUX-32-PIC-NEXT:  .L99$pb:
; LINUX-32-PIC-NEXT:    popl %ecx
; LINUX-32-PIC-NEXT:  .Ltmp99:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp99-.L99$pb), %ecx
; LINUX-32-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl src@GOT(%ecx), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_src+262144, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-DYNAMIC-NEXT:    addl L_src$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L99$pb
; DARWIN-32-PIC-NEXT:  L99$pb:
; DARWIN-32-PIC-NEXT:    popl %ecx
; DARWIN-32-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-PIC-NEXT:    addl L_src$non_lazy_ptr-L99$pb(%ecx), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-STATIC-NEXT:    addq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-DYNAMIC-NEXT:    addq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-PIC-NEXT:    addq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @src, i32 0, i64 65536) to i8*)
}

define i8* @bam01() nounwind {
; LINUX-64-STATIC-LABEL: bam01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dst+262144, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dst+262144, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L100$pb
; LINUX-32-PIC-NEXT:  .L100$pb:
; LINUX-32-PIC-NEXT:    popl %ecx
; LINUX-32-PIC-NEXT:  .Ltmp100:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp100-.L100$pb), %ecx
; LINUX-32-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl dst@GOT(%ecx), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dst+262144, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-DYNAMIC-NEXT:    addl L_dst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L100$pb
; DARWIN-32-PIC-NEXT:  L100$pb:
; DARWIN-32-PIC-NEXT:    popl %ecx
; DARWIN-32-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-PIC-NEXT:    addl L_dst$non_lazy_ptr-L100$pb(%ecx), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-STATIC-NEXT:    addq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-DYNAMIC-NEXT:    addq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-PIC-NEXT:    addq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @dst, i32 0, i64 65536) to i8*)
}

define i8* @bxm01() nounwind {
; LINUX-64-STATIC-LABEL: bxm01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $xdst+262144, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bxm01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $xdst+262144, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bxm01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L101$pb
; LINUX-32-PIC-NEXT:  .L101$pb:
; LINUX-32-PIC-NEXT:    popl %ecx
; LINUX-32-PIC-NEXT:  .Ltmp101:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp101-.L101$pb), %ecx
; LINUX-32-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl xdst@GOT(%ecx), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bxm01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bxm01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_xdst+262144, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bxm01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-DYNAMIC-NEXT:    addl L_xdst$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bxm01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L101$pb
; DARWIN-32-PIC-NEXT:  L101$pb:
; DARWIN-32-PIC-NEXT:    popl %ecx
; DARWIN-32-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-PIC-NEXT:    addl L_xdst$non_lazy_ptr-L101$pb(%ecx), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bxm01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-STATIC-NEXT:    addq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bxm01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-DYNAMIC-NEXT:    addq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bxm01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-PIC-NEXT:    addq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([32 x i32], [32 x i32]* @xdst, i32 0, i64 65536) to i8*)
}

define i8* @bam02() nounwind {
; LINUX-64-STATIC-LABEL: bam02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-STATIC-NEXT:    addq ptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-STATIC-NEXT:    addl ptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L102$pb
; LINUX-32-PIC-NEXT:  .L102$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp102:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp102-.L102$pb), %eax
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl (%ecx), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq (%rcx), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-STATIC-NEXT:    addl _ptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-DYNAMIC-NEXT:    addl (%ecx), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L102$pb
; DARWIN-32-PIC-NEXT:  L102$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L102$pb(%eax), %ecx
; DARWIN-32-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-PIC-NEXT:    addl (%ecx), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-STATIC-NEXT:    addq (%rcx), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-DYNAMIC-NEXT:    addq (%rcx), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rcx
; DARWIN-64-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-PIC-NEXT:    addq (%rcx), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = getelementptr i32, i32* %0, i64 65536
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @bam03() nounwind {
; LINUX-64-STATIC-LABEL: bam03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dsrc+262144, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dsrc+262144, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L103$pb
; LINUX-32-PIC-NEXT:  .L103$pb:
; LINUX-32-PIC-NEXT:    popl %ecx
; LINUX-32-PIC-NEXT:  .Ltmp103:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp103-.L103$pb), %ecx
; LINUX-32-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl dsrc@GOT(%ecx), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dsrc+262144, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_dsrc+262144, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L103$pb
; DARWIN-32-PIC-NEXT:  L103$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_dsrc-L103$pb)+262144(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc+262144(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc+262144(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc+262144(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @dsrc, i32 0, i64 65536) to i8*)
}

define i8* @bam04() nounwind {
; LINUX-64-STATIC-LABEL: bam04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ddst+262144, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ddst+262144, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L104$pb
; LINUX-32-PIC-NEXT:  .L104$pb:
; LINUX-32-PIC-NEXT:    popl %ecx
; LINUX-32-PIC-NEXT:  .Ltmp104:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp104-.L104$pb), %ecx
; LINUX-32-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl ddst@GOT(%ecx), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ddst+262144, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ddst+262144, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L104$pb
; DARWIN-32-PIC-NEXT:  L104$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_ddst-L104$pb)+262144(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst+262144(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst+262144(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst+262144(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @ddst, i32 0, i64 65536) to i8*)
}

define i8* @bam05() nounwind {
; LINUX-64-STATIC-LABEL: bam05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-STATIC-NEXT:    addq dptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-STATIC-NEXT:    addl dptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L105$pb
; LINUX-32-PIC-NEXT:  .L105$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp105:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp105-.L105$pb), %eax
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %ecx
; LINUX-32-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl (%ecx), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rcx
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq (%rcx), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-STATIC-NEXT:    addl _dptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-DYNAMIC-NEXT:    addl _dptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L105$pb
; DARWIN-32-PIC-NEXT:  L105$pb:
; DARWIN-32-PIC-NEXT:    popl %ecx
; DARWIN-32-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-PIC-NEXT:    addl _dptr-L105$pb(%ecx), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-STATIC-NEXT:    addq _dptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-DYNAMIC-NEXT:    addq _dptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-PIC-NEXT:    addq _dptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = getelementptr i32, i32* %0, i64 65536
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @bam06() nounwind {
; LINUX-64-STATIC-LABEL: bam06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $lsrc+262144, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $lsrc+262144, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L106$pb
; LINUX-32-PIC-NEXT:  .L106$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp106:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp106-.L106$pb), %eax
; LINUX-32-PIC-NEXT:    leal lsrc@GOTOFF+262144(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc+262144(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_lsrc+262144, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_lsrc+262144, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L106$pb
; DARWIN-32-PIC-NEXT:  L106$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_lsrc-L106$pb)+262144(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc+262144(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc+262144(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc+262144(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @lsrc, i32 0, i64 65536) to i8*)
}

define i8* @bam07() nounwind {
; LINUX-64-STATIC-LABEL: bam07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $ldst+262144, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $ldst+262144, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L107$pb
; LINUX-32-PIC-NEXT:  .L107$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp107:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp107-.L107$pb), %eax
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF+262144(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst+262144(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_ldst+262144, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_ldst+262144, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L107$pb
; DARWIN-32-PIC-NEXT:  L107$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal (_ldst-L107$pb)+262144(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst+262144(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst+262144(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst+262144(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret i8* bitcast (i32* getelementptr ([131072 x i32], [131072 x i32]* @ldst, i32 0, i64 65536) to i8*)
}

define i8* @bam08() nounwind {
; LINUX-64-STATIC-LABEL: bam08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-STATIC-NEXT:    addq lptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: bam08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-STATIC-NEXT:    addl lptr, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: bam08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L108$pb
; LINUX-32-PIC-NEXT:  .L108$pb:
; LINUX-32-PIC-NEXT:    popl %ecx
; LINUX-32-PIC-NEXT:  .Ltmp108:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp108-.L108$pb), %ecx
; LINUX-32-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-32-PIC-NEXT:    addl lptr@GOTOFF(%ecx), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: bam08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movl $262144, %eax # imm = 0x40000
; LINUX-64-PIC-NEXT:    addq lptr(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: bam08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-STATIC-NEXT:    addl _lptr, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: bam08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-DYNAMIC-NEXT:    addl _lptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: bam08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L108$pb
; DARWIN-32-PIC-NEXT:  L108$pb:
; DARWIN-32-PIC-NEXT:    popl %ecx
; DARWIN-32-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-32-PIC-NEXT:    addl _lptr-L108$pb(%ecx), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: bam08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-STATIC-NEXT:    addq _lptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: bam08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-DYNAMIC-NEXT:    addq _lptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: bam08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movl $262144, %eax ## imm = 0x40000
; DARWIN-64-PIC-NEXT:    addq _lptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = getelementptr i32, i32* %0, i64 65536
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cat00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq src+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal src+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L109$pb
; LINUX-32-PIC-NEXT:  .L109$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp109:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp109-.L109$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _src+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L109$pb
; DARWIN-32-PIC-NEXT:  L109$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L109$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @src, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cxt00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cxt00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq xsrc+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cxt00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal xsrc+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cxt00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L110$pb
; LINUX-32-PIC-NEXT:  .L110$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp110:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp110-.L110$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cxt00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cxt00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _xsrc+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cxt00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cxt00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L110$pb
; DARWIN-32-PIC-NEXT:  L110$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L110$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cxt00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cxt00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cxt00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [32 x i32], [32 x i32]* @xsrc, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cat01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq dst+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal dst+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L111$pb
; LINUX-32-PIC-NEXT:  .L111$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp111:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp111-.L111$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _dst+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L111$pb
; DARWIN-32-PIC-NEXT:  L111$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L111$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @dst, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cxt01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cxt01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq xdst+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cxt01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal xdst+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cxt01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L112$pb
; LINUX-32-PIC-NEXT:  .L112$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp112:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp112-.L112$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cxt01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cxt01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _xdst+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cxt01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cxt01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L112$pb
; DARWIN-32-PIC-NEXT:  L112$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L112$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cxt01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cxt01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cxt01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [32 x i32], [32 x i32]* @xdst, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cat02(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl ptr, %ecx
; LINUX-32-STATIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L113$pb
; LINUX-32-PIC-NEXT:  .L113$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp113:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp113-.L113$pb), %eax
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq (%rax), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _ptr, %ecx
; DARWIN-32-STATIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl (%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L113$pb
; DARWIN-32-PIC-NEXT:  L113$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L113$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq (%rax), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq (%rax), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq (%rax), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = add i64 %i, 16
	%2 = getelementptr i32, i32* %0, i64 %1
	%3 = bitcast i32* %2 to i8*
	ret i8* %3
}

define i8* @cat03(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq dsrc+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal dsrc+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L114$pb
; LINUX-32-PIC-NEXT:  .L114$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp114:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp114-.L114$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _dsrc+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _dsrc+64(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L114$pb
; DARWIN-32-PIC-NEXT:  L114$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_dsrc-L114$pb)+64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @dsrc, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cat04(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ddst+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ddst+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L115$pb
; LINUX-32-PIC-NEXT:  .L115$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp115:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp115-.L115$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ddst+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ddst+64(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L115$pb
; DARWIN-32-PIC-NEXT:  L115$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_ddst-L115$pb)+64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @ddst, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cat05(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl dptr, %ecx
; LINUX-32-STATIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L116$pb
; LINUX-32-PIC-NEXT:  .L116$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp116:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp116-.L116$pb), %eax
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq (%rax), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-STATIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L116$pb
; DARWIN-32-PIC-NEXT:  L116$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl _dptr-L116$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = add i64 %i, 16
	%2 = getelementptr i32, i32* %0, i64 %1
	%3 = bitcast i32* %2 to i8*
	ret i8* %3
}

define i8* @cat06(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq lsrc+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal lsrc+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L117$pb
; LINUX-32-PIC-NEXT:  .L117$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp117:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp117-.L117$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal lsrc@GOTOFF+64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _lsrc+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _lsrc+64(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L117$pb
; DARWIN-32-PIC-NEXT:  L117$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_lsrc-L117$pb)+64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @lsrc, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cat07(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ldst+64(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ldst+64(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L118$pb
; LINUX-32-PIC-NEXT:  .L118$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp118:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp118-.L118$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF+64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ldst+64(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ldst+64(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L118$pb
; DARWIN-32-PIC-NEXT:  L118$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_ldst-L118$pb)+64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 16
	%1 = getelementptr [131072 x i32], [131072 x i32]* @ldst, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cat08(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cat08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cat08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl lptr, %ecx
; LINUX-32-STATIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cat08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L119$pb
; LINUX-32-PIC-NEXT:  .L119$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp119:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp119-.L119$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cat08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cat08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-STATIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cat08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 64(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cat08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L119$pb
; DARWIN-32-PIC-NEXT:  L119$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl _lptr-L119$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 64(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cat08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cat08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cat08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 64(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = add i64 %i, 16
	%2 = getelementptr i32, i32* %0, i64 %1
	%3 = bitcast i32* %2 to i8*
	ret i8* %3
}

define i8* @cam00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq src+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal src+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L120$pb
; LINUX-32-PIC-NEXT:  .L120$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp120:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp120-.L120$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl src@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq src@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _src+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_src$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L120$pb
; DARWIN-32-PIC-NEXT:  L120$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_src$non_lazy_ptr-L120$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _src@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @src, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cxm00(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cxm00:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq xsrc+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cxm00:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal xsrc+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cxm00:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L121$pb
; LINUX-32-PIC-NEXT:  .L121$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp121:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp121-.L121$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cxm00:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cxm00:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _xsrc+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cxm00:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xsrc$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cxm00:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L121$pb
; DARWIN-32-PIC-NEXT:  L121$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xsrc$non_lazy_ptr-L121$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cxm00:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cxm00:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cxm00:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xsrc@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [32 x i32], [32 x i32]* @xsrc, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cam01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq dst+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal dst+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L122$pb
; LINUX-32-PIC-NEXT:  .L122$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp122:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp122-.L122$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _dst+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_dst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L122$pb
; DARWIN-32-PIC-NEXT:  L122$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_dst$non_lazy_ptr-L122$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @dst, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cxm01(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cxm01:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq xdst+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cxm01:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal xdst+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cxm01:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L123$pb
; LINUX-32-PIC-NEXT:  .L123$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp123:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp123-.L123$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl xdst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cxm01:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq xdst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cxm01:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _xdst+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cxm01:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl L_xdst$non_lazy_ptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cxm01:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L123$pb
; DARWIN-32-PIC-NEXT:  L123$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl L_xdst$non_lazy_ptr-L123$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cxm01:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cxm01:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cxm01:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _xdst@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [32 x i32], [32 x i32]* @xdst, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cam02(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam02:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq ptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam02:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl ptr, %ecx
; LINUX-32-STATIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam02:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L124$pb
; LINUX-32-PIC-NEXT:  .L124$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp124:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp124-.L124$pb), %eax
; LINUX-32-PIC-NEXT:    movl ptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam02:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq (%rax), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam02:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _ptr, %ecx
; DARWIN-32-STATIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam02:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_ptr$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    movl (%eax), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam02:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L124$pb
; DARWIN-32-PIC-NEXT:  L124$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_ptr$non_lazy_ptr-L124$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    movl (%eax), %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam02:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    movq (%rax), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam02:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    movq (%rax), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam02:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _ptr@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    movq (%rax), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @ptr, align 8
	%1 = add i64 %i, 65536
	%2 = getelementptr i32, i32* %0, i64 %1
	%3 = bitcast i32* %2 to i8*
	ret i8* %3
}

define i8* @cam03(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam03:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq dsrc+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam03:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal dsrc+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam03:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L125$pb
; LINUX-32-PIC-NEXT:  .L125$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp125:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp125-.L125$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl dsrc@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam03:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dsrc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam03:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _dsrc+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam03:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _dsrc+262144(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam03:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L125$pb
; DARWIN-32-PIC-NEXT:  L125$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_dsrc-L125$pb)+262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam03:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam03:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam03:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @dsrc, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cam04(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam04:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ddst+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam04:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ddst+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam04:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L126$pb
; LINUX-32-PIC-NEXT:  .L126$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp126:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp126-.L126$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl ddst@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam04:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq ddst@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam04:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ddst+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam04:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ddst+262144(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam04:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L126$pb
; DARWIN-32-PIC-NEXT:  L126$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_ddst-L126$pb)+262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam04:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam04:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam04:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ddst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @ddst, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cam05(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam05:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq dptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam05:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl dptr, %ecx
; LINUX-32-STATIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam05:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L127$pb
; LINUX-32-PIC-NEXT:  .L127$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp127:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp127-.L127$pb), %eax
; LINUX-32-PIC-NEXT:    movl dptr@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    movl (%eax), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam05:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq dptr@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    movq (%rax), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam05:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-STATIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam05:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _dptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam05:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L127$pb
; DARWIN-32-PIC-NEXT:  L127$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl _dptr-L127$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam05:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam05:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam05:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _dptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @dptr, align 8
	%1 = add i64 %i, 65536
	%2 = getelementptr i32, i32* %0, i64 %1
	%3 = bitcast i32* %2 to i8*
	ret i8* %3
}

define i8* @cam06(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam06:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq lsrc+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam06:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal lsrc+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam06:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L128$pb
; LINUX-32-PIC-NEXT:  .L128$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp128:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp128-.L128$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal lsrc@GOTOFF+262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam06:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq lsrc(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam06:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _lsrc+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam06:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _lsrc+262144(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam06:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L128$pb
; DARWIN-32-PIC-NEXT:  L128$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_lsrc-L128$pb)+262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam06:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam06:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam06:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lsrc(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @lsrc, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cam07(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam07:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    leaq ldst+262144(,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam07:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    leal ldst+262144(,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam07:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L129$pb
; LINUX-32-PIC-NEXT:  .L129$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp129:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp129-.L129$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    leal ldst@GOTOFF+262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam07:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq ldst(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam07:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    leal _ldst+262144(,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam07:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    leal _ldst+262144(,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam07:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L129$pb
; DARWIN-32-PIC-NEXT:  L129$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    leal (_ldst-L129$pb)+262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam07:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam07:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam07:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _ldst(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = add i64 %i, 65536
	%1 = getelementptr [131072 x i32], [131072 x i32]* @ldst, i64 0, i64 %0
	%2 = bitcast i32* %1 to i8*
	ret i8* %2
}

define i8* @cam08(i64 %i) nounwind {
; LINUX-64-STATIC-LABEL: cam08:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movq lptr(%rip), %rax
; LINUX-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: cam08:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LINUX-32-STATIC-NEXT:    movl lptr, %ecx
; LINUX-32-STATIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: cam08:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L130$pb
; LINUX-32-PIC-NEXT:  .L130$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp130:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp130-.L130$pb), %eax
; LINUX-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LINUX-32-PIC-NEXT:    movl lptr@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: cam08:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq lptr(%rip), %rax
; LINUX-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: cam08:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-STATIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-STATIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: cam08:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl {{[0-9]+}}(%esp), %eax
; DARWIN-32-DYNAMIC-NEXT:    movl _lptr, %ecx
; DARWIN-32-DYNAMIC-NEXT:    leal 262144(%ecx,%eax,4), %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: cam08:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L130$pb
; DARWIN-32-PIC-NEXT:  L130$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; DARWIN-32-PIC-NEXT:    movl _lptr-L130$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    leal 262144(%eax,%ecx,4), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: cam08:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-STATIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: cam08:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: cam08:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _lptr(%rip), %rax
; DARWIN-64-PIC-NEXT:    leaq 262144(%rax,%rdi,4), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load i32*, i32** @lptr, align 8
	%1 = add i64 %i, 65536
	%2 = getelementptr i32, i32* %0, i64 %1
	%3 = bitcast i32* %2 to i8*
	ret i8* %3
}

define void @lcallee() nounwind {
; LINUX-64-STATIC-LABEL: lcallee:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq x
; LINUX-64-STATIC-NEXT:    callq x
; LINUX-64-STATIC-NEXT:    callq x
; LINUX-64-STATIC-NEXT:    callq x
; LINUX-64-STATIC-NEXT:    callq x
; LINUX-64-STATIC-NEXT:    callq x
; LINUX-64-STATIC-NEXT:    callq x
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: lcallee:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll x
; LINUX-32-STATIC-NEXT:    calll x
; LINUX-32-STATIC-NEXT:    calll x
; LINUX-32-STATIC-NEXT:    calll x
; LINUX-32-STATIC-NEXT:    calll x
; LINUX-32-STATIC-NEXT:    calll x
; LINUX-32-STATIC-NEXT:    calll x
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: lcallee:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L131$pb
; LINUX-32-PIC-NEXT:  .L131$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp131:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp131-.L131$pb), %ebx
; LINUX-32-PIC-NEXT:    calll x@PLT
; LINUX-32-PIC-NEXT:    calll x@PLT
; LINUX-32-PIC-NEXT:    calll x@PLT
; LINUX-32-PIC-NEXT:    calll x@PLT
; LINUX-32-PIC-NEXT:    calll x@PLT
; LINUX-32-PIC-NEXT:    calll x@PLT
; LINUX-32-PIC-NEXT:    calll x@PLT
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: lcallee:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq x@PLT
; LINUX-64-PIC-NEXT:    callq x@PLT
; LINUX-64-PIC-NEXT:    callq x@PLT
; LINUX-64-PIC-NEXT:    callq x@PLT
; LINUX-64-PIC-NEXT:    callq x@PLT
; LINUX-64-PIC-NEXT:    callq x@PLT
; LINUX-64-PIC-NEXT:    callq x@PLT
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: lcallee:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll _x
; DARWIN-32-STATIC-NEXT:    calll _x
; DARWIN-32-STATIC-NEXT:    calll _x
; DARWIN-32-STATIC-NEXT:    calll _x
; DARWIN-32-STATIC-NEXT:    calll _x
; DARWIN-32-STATIC-NEXT:    calll _x
; DARWIN-32-STATIC-NEXT:    calll _x
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: lcallee:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll _x
; DARWIN-32-DYNAMIC-NEXT:    calll _x
; DARWIN-32-DYNAMIC-NEXT:    calll _x
; DARWIN-32-DYNAMIC-NEXT:    calll _x
; DARWIN-32-DYNAMIC-NEXT:    calll _x
; DARWIN-32-DYNAMIC-NEXT:    calll _x
; DARWIN-32-DYNAMIC-NEXT:    calll _x
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: lcallee:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll _x
; DARWIN-32-PIC-NEXT:    calll _x
; DARWIN-32-PIC-NEXT:    calll _x
; DARWIN-32-PIC-NEXT:    calll _x
; DARWIN-32-PIC-NEXT:    calll _x
; DARWIN-32-PIC-NEXT:    calll _x
; DARWIN-32-PIC-NEXT:    calll _x
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: lcallee:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq _x
; DARWIN-64-STATIC-NEXT:    callq _x
; DARWIN-64-STATIC-NEXT:    callq _x
; DARWIN-64-STATIC-NEXT:    callq _x
; DARWIN-64-STATIC-NEXT:    callq _x
; DARWIN-64-STATIC-NEXT:    callq _x
; DARWIN-64-STATIC-NEXT:    callq _x
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: lcallee:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq _x
; DARWIN-64-DYNAMIC-NEXT:    callq _x
; DARWIN-64-DYNAMIC-NEXT:    callq _x
; DARWIN-64-DYNAMIC-NEXT:    callq _x
; DARWIN-64-DYNAMIC-NEXT:    callq _x
; DARWIN-64-DYNAMIC-NEXT:    callq _x
; DARWIN-64-DYNAMIC-NEXT:    callq _x
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: lcallee:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq _x
; DARWIN-64-PIC-NEXT:    callq _x
; DARWIN-64-PIC-NEXT:    callq _x
; DARWIN-64-PIC-NEXT:    callq _x
; DARWIN-64-PIC-NEXT:    callq _x
; DARWIN-64-PIC-NEXT:    callq _x
; DARWIN-64-PIC-NEXT:    callq _x
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	call void @x() nounwind
	call void @x() nounwind
	call void @x() nounwind
	call void @x() nounwind
	call void @x() nounwind
	call void @x() nounwind
	call void @x() nounwind
	ret void
}

declare void @x()

define internal void @dcallee() nounwind {
; LINUX-64-STATIC-LABEL: dcallee:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq y
; LINUX-64-STATIC-NEXT:    callq y
; LINUX-64-STATIC-NEXT:    callq y
; LINUX-64-STATIC-NEXT:    callq y
; LINUX-64-STATIC-NEXT:    callq y
; LINUX-64-STATIC-NEXT:    callq y
; LINUX-64-STATIC-NEXT:    callq y
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: dcallee:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll y
; LINUX-32-STATIC-NEXT:    calll y
; LINUX-32-STATIC-NEXT:    calll y
; LINUX-32-STATIC-NEXT:    calll y
; LINUX-32-STATIC-NEXT:    calll y
; LINUX-32-STATIC-NEXT:    calll y
; LINUX-32-STATIC-NEXT:    calll y
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: dcallee:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L132$pb
; LINUX-32-PIC-NEXT:  .L132$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp132:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp132-.L132$pb), %ebx
; LINUX-32-PIC-NEXT:    calll y@PLT
; LINUX-32-PIC-NEXT:    calll y@PLT
; LINUX-32-PIC-NEXT:    calll y@PLT
; LINUX-32-PIC-NEXT:    calll y@PLT
; LINUX-32-PIC-NEXT:    calll y@PLT
; LINUX-32-PIC-NEXT:    calll y@PLT
; LINUX-32-PIC-NEXT:    calll y@PLT
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: dcallee:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq y@PLT
; LINUX-64-PIC-NEXT:    callq y@PLT
; LINUX-64-PIC-NEXT:    callq y@PLT
; LINUX-64-PIC-NEXT:    callq y@PLT
; LINUX-64-PIC-NEXT:    callq y@PLT
; LINUX-64-PIC-NEXT:    callq y@PLT
; LINUX-64-PIC-NEXT:    callq y@PLT
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: dcallee:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll _y
; DARWIN-32-STATIC-NEXT:    calll _y
; DARWIN-32-STATIC-NEXT:    calll _y
; DARWIN-32-STATIC-NEXT:    calll _y
; DARWIN-32-STATIC-NEXT:    calll _y
; DARWIN-32-STATIC-NEXT:    calll _y
; DARWIN-32-STATIC-NEXT:    calll _y
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: dcallee:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll _y
; DARWIN-32-DYNAMIC-NEXT:    calll _y
; DARWIN-32-DYNAMIC-NEXT:    calll _y
; DARWIN-32-DYNAMIC-NEXT:    calll _y
; DARWIN-32-DYNAMIC-NEXT:    calll _y
; DARWIN-32-DYNAMIC-NEXT:    calll _y
; DARWIN-32-DYNAMIC-NEXT:    calll _y
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: dcallee:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll _y
; DARWIN-32-PIC-NEXT:    calll _y
; DARWIN-32-PIC-NEXT:    calll _y
; DARWIN-32-PIC-NEXT:    calll _y
; DARWIN-32-PIC-NEXT:    calll _y
; DARWIN-32-PIC-NEXT:    calll _y
; DARWIN-32-PIC-NEXT:    calll _y
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: dcallee:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq _y
; DARWIN-64-STATIC-NEXT:    callq _y
; DARWIN-64-STATIC-NEXT:    callq _y
; DARWIN-64-STATIC-NEXT:    callq _y
; DARWIN-64-STATIC-NEXT:    callq _y
; DARWIN-64-STATIC-NEXT:    callq _y
; DARWIN-64-STATIC-NEXT:    callq _y
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: dcallee:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq _y
; DARWIN-64-DYNAMIC-NEXT:    callq _y
; DARWIN-64-DYNAMIC-NEXT:    callq _y
; DARWIN-64-DYNAMIC-NEXT:    callq _y
; DARWIN-64-DYNAMIC-NEXT:    callq _y
; DARWIN-64-DYNAMIC-NEXT:    callq _y
; DARWIN-64-DYNAMIC-NEXT:    callq _y
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: dcallee:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq _y
; DARWIN-64-PIC-NEXT:    callq _y
; DARWIN-64-PIC-NEXT:    callq _y
; DARWIN-64-PIC-NEXT:    callq _y
; DARWIN-64-PIC-NEXT:    callq _y
; DARWIN-64-PIC-NEXT:    callq _y
; DARWIN-64-PIC-NEXT:    callq _y
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	call void @y() nounwind
	call void @y() nounwind
	call void @y() nounwind
	call void @y() nounwind
	call void @y() nounwind
	call void @y() nounwind
	call void @y() nounwind
	ret void
}

declare void @y()

define void ()* @address() nounwind {
; LINUX-64-STATIC-LABEL: address:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $callee, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: address:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $callee, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: address:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L133$pb
; LINUX-32-PIC-NEXT:  .L133$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp133:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp133-.L133$pb), %eax
; LINUX-32-PIC-NEXT:    movl callee@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: address:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq callee@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: address:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_callee, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: address:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl L_callee$non_lazy_ptr, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: address:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L133$pb
; DARWIN-32-PIC-NEXT:  L133$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_callee$non_lazy_ptr-L133$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: address:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    movq _callee@GOTPCREL(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: address:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    movq _callee@GOTPCREL(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: address:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    movq _callee@GOTPCREL(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret void ()* @callee
}

declare void @callee()

define void ()* @laddress() nounwind {
; LINUX-64-STATIC-LABEL: laddress:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $lcallee, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: laddress:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $lcallee, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: laddress:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L134$pb
; LINUX-32-PIC-NEXT:  .L134$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp134:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp134-.L134$pb), %eax
; LINUX-32-PIC-NEXT:    movl lcallee@GOT(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: laddress:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    movq lcallee@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: laddress:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_lcallee, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: laddress:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_lcallee, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: laddress:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L134$pb
; DARWIN-32-PIC-NEXT:  L134$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _lcallee-L134$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: laddress:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _lcallee(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: laddress:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _lcallee(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: laddress:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _lcallee(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret void ()* @lcallee
}

define void ()* @daddress() nounwind {
; LINUX-64-STATIC-LABEL: daddress:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    movl $dcallee, %eax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: daddress:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    movl $dcallee, %eax
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: daddress:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    calll .L135$pb
; LINUX-32-PIC-NEXT:  .L135$pb:
; LINUX-32-PIC-NEXT:    popl %eax
; LINUX-32-PIC-NEXT:  .Ltmp135:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp135-.L135$pb), %eax
; LINUX-32-PIC-NEXT:    leal dcallee@GOTOFF(%eax), %eax
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: daddress:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    leaq dcallee(%rip), %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: daddress:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    movl $_dcallee, %eax
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: daddress:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    movl $_dcallee, %eax
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: daddress:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    calll L135$pb
; DARWIN-32-PIC-NEXT:  L135$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    leal _dcallee-L135$pb(%eax), %eax
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: daddress:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    leaq _dcallee(%rip), %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: daddress:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    leaq _dcallee(%rip), %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: daddress:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    leaq _dcallee(%rip), %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	ret void ()* @dcallee
}

define void @caller() nounwind {
; LINUX-64-STATIC-LABEL: caller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq callee
; LINUX-64-STATIC-NEXT:    callq callee
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: caller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll callee
; LINUX-32-STATIC-NEXT:    calll callee
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: caller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L136$pb
; LINUX-32-PIC-NEXT:  .L136$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp136:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp136-.L136$pb), %ebx
; LINUX-32-PIC-NEXT:    calll callee@PLT
; LINUX-32-PIC-NEXT:    calll callee@PLT
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: caller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq callee@PLT
; LINUX-64-PIC-NEXT:    callq callee@PLT
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: caller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll _callee
; DARWIN-32-STATIC-NEXT:    calll _callee
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: caller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll _callee
; DARWIN-32-DYNAMIC-NEXT:    calll _callee
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: caller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll _callee
; DARWIN-32-PIC-NEXT:    calll _callee
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: caller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq _callee
; DARWIN-64-STATIC-NEXT:    callq _callee
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: caller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq _callee
; DARWIN-64-DYNAMIC-NEXT:    callq _callee
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: caller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq _callee
; DARWIN-64-PIC-NEXT:    callq _callee
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	call void @callee() nounwind
	call void @callee() nounwind
	ret void
}

define void @dcaller() nounwind {
; LINUX-64-STATIC-LABEL: dcaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq dcallee
; LINUX-64-STATIC-NEXT:    callq dcallee
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: dcaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll dcallee
; LINUX-32-STATIC-NEXT:    calll dcallee
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: dcaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L137$pb
; LINUX-32-PIC-NEXT:  .L137$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp137:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp137-.L137$pb), %ebx
; LINUX-32-PIC-NEXT:    calll dcallee
; LINUX-32-PIC-NEXT:    calll dcallee
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: dcaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq dcallee
; LINUX-64-PIC-NEXT:    callq dcallee
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: dcaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll _dcallee
; DARWIN-32-STATIC-NEXT:    calll _dcallee
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: dcaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll _dcallee
; DARWIN-32-DYNAMIC-NEXT:    calll _dcallee
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: dcaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll _dcallee
; DARWIN-32-PIC-NEXT:    calll _dcallee
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: dcaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq _dcallee
; DARWIN-64-STATIC-NEXT:    callq _dcallee
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: dcaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq _dcallee
; DARWIN-64-DYNAMIC-NEXT:    callq _dcallee
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: dcaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq _dcallee
; DARWIN-64-PIC-NEXT:    callq _dcallee
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	call void @dcallee() nounwind
	call void @dcallee() nounwind
	ret void
}

define void @lcaller() nounwind {
; LINUX-64-STATIC-LABEL: lcaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq lcallee
; LINUX-64-STATIC-NEXT:    callq lcallee
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: lcaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll lcallee
; LINUX-32-STATIC-NEXT:    calll lcallee
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: lcaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L138$pb
; LINUX-32-PIC-NEXT:  .L138$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp138:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp138-.L138$pb), %ebx
; LINUX-32-PIC-NEXT:    calll lcallee@PLT
; LINUX-32-PIC-NEXT:    calll lcallee@PLT
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: lcaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq lcallee@PLT
; LINUX-64-PIC-NEXT:    callq lcallee@PLT
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: lcaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll _lcallee
; DARWIN-32-STATIC-NEXT:    calll _lcallee
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: lcaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll _lcallee
; DARWIN-32-DYNAMIC-NEXT:    calll _lcallee
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: lcaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll _lcallee
; DARWIN-32-PIC-NEXT:    calll _lcallee
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: lcaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq _lcallee
; DARWIN-64-STATIC-NEXT:    callq _lcallee
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: lcaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq _lcallee
; DARWIN-64-DYNAMIC-NEXT:    callq _lcallee
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: lcaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq _lcallee
; DARWIN-64-PIC-NEXT:    callq _lcallee
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	call void @lcallee() nounwind
	call void @lcallee() nounwind
	ret void
}

define void @tailcaller() nounwind {
; LINUX-64-STATIC-LABEL: tailcaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq callee
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: tailcaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll callee
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: tailcaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L139$pb
; LINUX-32-PIC-NEXT:  .L139$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp139:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp139-.L139$pb), %ebx
; LINUX-32-PIC-NEXT:    calll callee@PLT
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: tailcaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq callee@PLT
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: tailcaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll _callee
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: tailcaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll _callee
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: tailcaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll _callee
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: tailcaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq _callee
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: tailcaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq _callee
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: tailcaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq _callee
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	call void @callee() nounwind
	ret void
}

define void @dtailcaller() nounwind {
; LINUX-64-STATIC-LABEL: dtailcaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq dcallee
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: dtailcaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll dcallee
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: dtailcaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L140$pb
; LINUX-32-PIC-NEXT:  .L140$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp140:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp140-.L140$pb), %ebx
; LINUX-32-PIC-NEXT:    calll dcallee
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: dtailcaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq dcallee
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: dtailcaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll _dcallee
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: dtailcaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll _dcallee
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: dtailcaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll _dcallee
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: dtailcaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq _dcallee
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: dtailcaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq _dcallee
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: dtailcaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq _dcallee
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	call void @dcallee() nounwind
	ret void
}

define void @ltailcaller() nounwind {
; LINUX-64-STATIC-LABEL: ltailcaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq lcallee
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ltailcaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll lcallee
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ltailcaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L141$pb
; LINUX-32-PIC-NEXT:  .L141$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp141:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp141-.L141$pb), %ebx
; LINUX-32-PIC-NEXT:    calll lcallee@PLT
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ltailcaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq lcallee@PLT
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ltailcaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll _lcallee
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ltailcaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll _lcallee
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ltailcaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll _lcallee
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ltailcaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq _lcallee
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ltailcaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq _lcallee
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ltailcaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq _lcallee
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	call void @lcallee() nounwind
	ret void
}

define void @icaller() nounwind {
; LINUX-64-STATIC-LABEL: icaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq *ifunc(%rip)
; LINUX-64-STATIC-NEXT:    callq *ifunc(%rip)
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: icaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll *ifunc
; LINUX-32-STATIC-NEXT:    calll *ifunc
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: icaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    pushl %esi
; LINUX-32-PIC-NEXT:    pushl %eax
; LINUX-32-PIC-NEXT:    calll .L142$pb
; LINUX-32-PIC-NEXT:  .L142$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp142:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp142-.L142$pb), %ebx
; LINUX-32-PIC-NEXT:    movl ifunc@GOT(%ebx), %esi
; LINUX-32-PIC-NEXT:    calll *(%esi)
; LINUX-32-PIC-NEXT:    calll *(%esi)
; LINUX-32-PIC-NEXT:    addl $4, %esp
; LINUX-32-PIC-NEXT:    popl %esi
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: icaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rbx
; LINUX-64-PIC-NEXT:    movq ifunc@GOTPCREL(%rip), %rbx
; LINUX-64-PIC-NEXT:    callq *(%rbx)
; LINUX-64-PIC-NEXT:    callq *(%rbx)
; LINUX-64-PIC-NEXT:    popq %rbx
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: icaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll *_ifunc
; DARWIN-32-STATIC-NEXT:    calll *_ifunc
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: icaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    pushl %esi
; DARWIN-32-DYNAMIC-NEXT:    subl $8, %esp
; DARWIN-32-DYNAMIC-NEXT:    movl L_ifunc$non_lazy_ptr, %esi
; DARWIN-32-DYNAMIC-NEXT:    calll *(%esi)
; DARWIN-32-DYNAMIC-NEXT:    calll *(%esi)
; DARWIN-32-DYNAMIC-NEXT:    addl $8, %esp
; DARWIN-32-DYNAMIC-NEXT:    popl %esi
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: icaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    pushl %esi
; DARWIN-32-PIC-NEXT:    subl $8, %esp
; DARWIN-32-PIC-NEXT:    calll L142$pb
; DARWIN-32-PIC-NEXT:  L142$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_ifunc$non_lazy_ptr-L142$pb(%eax), %esi
; DARWIN-32-PIC-NEXT:    calll *(%esi)
; DARWIN-32-PIC-NEXT:    calll *(%esi)
; DARWIN-32-PIC-NEXT:    addl $8, %esp
; DARWIN-32-PIC-NEXT:    popl %esi
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: icaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rbx
; DARWIN-64-STATIC-NEXT:    movq _ifunc@GOTPCREL(%rip), %rbx
; DARWIN-64-STATIC-NEXT:    callq *(%rbx)
; DARWIN-64-STATIC-NEXT:    callq *(%rbx)
; DARWIN-64-STATIC-NEXT:    popq %rbx
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: icaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rbx
; DARWIN-64-DYNAMIC-NEXT:    movq _ifunc@GOTPCREL(%rip), %rbx
; DARWIN-64-DYNAMIC-NEXT:    callq *(%rbx)
; DARWIN-64-DYNAMIC-NEXT:    callq *(%rbx)
; DARWIN-64-DYNAMIC-NEXT:    popq %rbx
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: icaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rbx
; DARWIN-64-PIC-NEXT:    movq _ifunc@GOTPCREL(%rip), %rbx
; DARWIN-64-PIC-NEXT:    callq *(%rbx)
; DARWIN-64-PIC-NEXT:    callq *(%rbx)
; DARWIN-64-PIC-NEXT:    popq %rbx
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load void ()*, void ()** @ifunc, align 8
	call void %0() nounwind
	%1 = load void ()*, void ()** @ifunc, align 8
	call void %1() nounwind
	ret void
}

define void @dicaller() nounwind {
; LINUX-64-STATIC-LABEL: dicaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq *difunc(%rip)
; LINUX-64-STATIC-NEXT:    callq *difunc(%rip)
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: dicaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll *difunc
; LINUX-32-STATIC-NEXT:    calll *difunc
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: dicaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    pushl %esi
; LINUX-32-PIC-NEXT:    pushl %eax
; LINUX-32-PIC-NEXT:    calll .L143$pb
; LINUX-32-PIC-NEXT:  .L143$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp143:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp143-.L143$pb), %ebx
; LINUX-32-PIC-NEXT:    movl difunc@GOT(%ebx), %esi
; LINUX-32-PIC-NEXT:    calll *(%esi)
; LINUX-32-PIC-NEXT:    calll *(%esi)
; LINUX-32-PIC-NEXT:    addl $4, %esp
; LINUX-32-PIC-NEXT:    popl %esi
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: dicaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rbx
; LINUX-64-PIC-NEXT:    movq difunc@GOTPCREL(%rip), %rbx
; LINUX-64-PIC-NEXT:    callq *(%rbx)
; LINUX-64-PIC-NEXT:    callq *(%rbx)
; LINUX-64-PIC-NEXT:    popq %rbx
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: dicaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll *_difunc
; DARWIN-32-STATIC-NEXT:    calll *_difunc
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: dicaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll *_difunc
; DARWIN-32-DYNAMIC-NEXT:    calll *_difunc
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: dicaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    pushl %esi
; DARWIN-32-PIC-NEXT:    subl $8, %esp
; DARWIN-32-PIC-NEXT:    calll L143$pb
; DARWIN-32-PIC-NEXT:  L143$pb:
; DARWIN-32-PIC-NEXT:    popl %esi
; DARWIN-32-PIC-NEXT:    calll *_difunc-L143$pb(%esi)
; DARWIN-32-PIC-NEXT:    calll *_difunc-L143$pb(%esi)
; DARWIN-32-PIC-NEXT:    addl $8, %esp
; DARWIN-32-PIC-NEXT:    popl %esi
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: dicaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-STATIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: dicaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-DYNAMIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: dicaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-PIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load void ()*, void ()** @difunc, align 8
	call void %0() nounwind
	%1 = load void ()*, void ()** @difunc, align 8
	call void %1() nounwind
	ret void
}

define void @licaller() nounwind {
; LINUX-64-STATIC-LABEL: licaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq *lifunc(%rip)
; LINUX-64-STATIC-NEXT:    callq *lifunc(%rip)
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: licaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll *lifunc
; LINUX-32-STATIC-NEXT:    calll *lifunc
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: licaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L144$pb
; LINUX-32-PIC-NEXT:  .L144$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp144:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp144-.L144$pb), %ebx
; LINUX-32-PIC-NEXT:    calll *lifunc@GOTOFF(%ebx)
; LINUX-32-PIC-NEXT:    calll *lifunc@GOTOFF(%ebx)
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: licaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq *lifunc(%rip)
; LINUX-64-PIC-NEXT:    callq *lifunc(%rip)
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: licaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll *_lifunc
; DARWIN-32-STATIC-NEXT:    calll *_lifunc
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: licaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll *_lifunc
; DARWIN-32-DYNAMIC-NEXT:    calll *_lifunc
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: licaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    pushl %esi
; DARWIN-32-PIC-NEXT:    subl $8, %esp
; DARWIN-32-PIC-NEXT:    calll L144$pb
; DARWIN-32-PIC-NEXT:  L144$pb:
; DARWIN-32-PIC-NEXT:    popl %esi
; DARWIN-32-PIC-NEXT:    calll *_lifunc-L144$pb(%esi)
; DARWIN-32-PIC-NEXT:    calll *_lifunc-L144$pb(%esi)
; DARWIN-32-PIC-NEXT:    addl $8, %esp
; DARWIN-32-PIC-NEXT:    popl %esi
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: licaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-STATIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: licaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-DYNAMIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: licaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-PIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load void ()*, void ()** @lifunc, align 8
	call void %0() nounwind
	%1 = load void ()*, void ()** @lifunc, align 8
	call void %1() nounwind
	ret void
}

define void @itailcaller() nounwind {
; LINUX-64-STATIC-LABEL: itailcaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq *ifunc(%rip)
; LINUX-64-STATIC-NEXT:    callq *ifunc(%rip)
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: itailcaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll *ifunc
; LINUX-32-STATIC-NEXT:    calll *ifunc
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: itailcaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    pushl %esi
; LINUX-32-PIC-NEXT:    pushl %eax
; LINUX-32-PIC-NEXT:    calll .L145$pb
; LINUX-32-PIC-NEXT:  .L145$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp145:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp145-.L145$pb), %ebx
; LINUX-32-PIC-NEXT:    movl ifunc@GOT(%ebx), %esi
; LINUX-32-PIC-NEXT:    calll *(%esi)
; LINUX-32-PIC-NEXT:    calll *(%esi)
; LINUX-32-PIC-NEXT:    addl $4, %esp
; LINUX-32-PIC-NEXT:    popl %esi
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: itailcaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rbx
; LINUX-64-PIC-NEXT:    movq ifunc@GOTPCREL(%rip), %rbx
; LINUX-64-PIC-NEXT:    callq *(%rbx)
; LINUX-64-PIC-NEXT:    callq *(%rbx)
; LINUX-64-PIC-NEXT:    popq %rbx
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: itailcaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll *_ifunc
; DARWIN-32-STATIC-NEXT:    calll *_ifunc
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: itailcaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    pushl %esi
; DARWIN-32-DYNAMIC-NEXT:    subl $8, %esp
; DARWIN-32-DYNAMIC-NEXT:    movl L_ifunc$non_lazy_ptr, %esi
; DARWIN-32-DYNAMIC-NEXT:    calll *(%esi)
; DARWIN-32-DYNAMIC-NEXT:    calll *(%esi)
; DARWIN-32-DYNAMIC-NEXT:    addl $8, %esp
; DARWIN-32-DYNAMIC-NEXT:    popl %esi
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: itailcaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    pushl %esi
; DARWIN-32-PIC-NEXT:    subl $8, %esp
; DARWIN-32-PIC-NEXT:    calll L145$pb
; DARWIN-32-PIC-NEXT:  L145$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    movl L_ifunc$non_lazy_ptr-L145$pb(%eax), %esi
; DARWIN-32-PIC-NEXT:    calll *(%esi)
; DARWIN-32-PIC-NEXT:    calll *(%esi)
; DARWIN-32-PIC-NEXT:    addl $8, %esp
; DARWIN-32-PIC-NEXT:    popl %esi
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: itailcaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rbx
; DARWIN-64-STATIC-NEXT:    movq _ifunc@GOTPCREL(%rip), %rbx
; DARWIN-64-STATIC-NEXT:    callq *(%rbx)
; DARWIN-64-STATIC-NEXT:    callq *(%rbx)
; DARWIN-64-STATIC-NEXT:    popq %rbx
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: itailcaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rbx
; DARWIN-64-DYNAMIC-NEXT:    movq _ifunc@GOTPCREL(%rip), %rbx
; DARWIN-64-DYNAMIC-NEXT:    callq *(%rbx)
; DARWIN-64-DYNAMIC-NEXT:    callq *(%rbx)
; DARWIN-64-DYNAMIC-NEXT:    popq %rbx
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: itailcaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rbx
; DARWIN-64-PIC-NEXT:    movq _ifunc@GOTPCREL(%rip), %rbx
; DARWIN-64-PIC-NEXT:    callq *(%rbx)
; DARWIN-64-PIC-NEXT:    callq *(%rbx)
; DARWIN-64-PIC-NEXT:    popq %rbx
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load void ()*, void ()** @ifunc, align 8
	call void %0() nounwind
	%1 = load void ()*, void ()** @ifunc, align 8
	call void %1() nounwind
	ret void
}

define void @ditailcaller() nounwind {
; LINUX-64-STATIC-LABEL: ditailcaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq *difunc(%rip)
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: ditailcaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll *difunc
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: ditailcaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L146$pb
; LINUX-32-PIC-NEXT:  .L146$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp146:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp146-.L146$pb), %ebx
; LINUX-32-PIC-NEXT:    movl difunc@GOT(%ebx), %eax
; LINUX-32-PIC-NEXT:    calll *(%eax)
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: ditailcaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    movq difunc@GOTPCREL(%rip), %rax
; LINUX-64-PIC-NEXT:    callq *(%rax)
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: ditailcaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll *_difunc
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: ditailcaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll *_difunc
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: ditailcaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll L146$pb
; DARWIN-32-PIC-NEXT:  L146$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    calll *_difunc-L146$pb(%eax)
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: ditailcaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: ditailcaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: ditailcaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq *_difunc(%rip)
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load void ()*, void ()** @difunc, align 8
	call void %0() nounwind
	ret void
}

define void @litailcaller() nounwind {
; LINUX-64-STATIC-LABEL: litailcaller:
; LINUX-64-STATIC:       # %bb.0: # %entry
; LINUX-64-STATIC-NEXT:    pushq %rax
; LINUX-64-STATIC-NEXT:    callq *lifunc(%rip)
; LINUX-64-STATIC-NEXT:    popq %rax
; LINUX-64-STATIC-NEXT:    retq
;
; LINUX-32-STATIC-LABEL: litailcaller:
; LINUX-32-STATIC:       # %bb.0: # %entry
; LINUX-32-STATIC-NEXT:    subl $12, %esp
; LINUX-32-STATIC-NEXT:    calll *lifunc
; LINUX-32-STATIC-NEXT:    addl $12, %esp
; LINUX-32-STATIC-NEXT:    retl
;
; LINUX-32-PIC-LABEL: litailcaller:
; LINUX-32-PIC:       # %bb.0: # %entry
; LINUX-32-PIC-NEXT:    pushl %ebx
; LINUX-32-PIC-NEXT:    subl $8, %esp
; LINUX-32-PIC-NEXT:    calll .L147$pb
; LINUX-32-PIC-NEXT:  .L147$pb:
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:  .Ltmp147:
; LINUX-32-PIC-NEXT:    addl $_GLOBAL_OFFSET_TABLE_+(.Ltmp147-.L147$pb), %ebx
; LINUX-32-PIC-NEXT:    calll *lifunc@GOTOFF(%ebx)
; LINUX-32-PIC-NEXT:    addl $8, %esp
; LINUX-32-PIC-NEXT:    popl %ebx
; LINUX-32-PIC-NEXT:    retl
;
; LINUX-64-PIC-LABEL: litailcaller:
; LINUX-64-PIC:       # %bb.0: # %entry
; LINUX-64-PIC-NEXT:    pushq %rax
; LINUX-64-PIC-NEXT:    callq *lifunc(%rip)
; LINUX-64-PIC-NEXT:    popq %rax
; LINUX-64-PIC-NEXT:    retq
;
; DARWIN-32-STATIC-LABEL: litailcaller:
; DARWIN-32-STATIC:       ## %bb.0: ## %entry
; DARWIN-32-STATIC-NEXT:    subl $12, %esp
; DARWIN-32-STATIC-NEXT:    calll *_lifunc
; DARWIN-32-STATIC-NEXT:    addl $12, %esp
; DARWIN-32-STATIC-NEXT:    retl
;
; DARWIN-32-DYNAMIC-LABEL: litailcaller:
; DARWIN-32-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-32-DYNAMIC-NEXT:    subl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    calll *_lifunc
; DARWIN-32-DYNAMIC-NEXT:    addl $12, %esp
; DARWIN-32-DYNAMIC-NEXT:    retl
;
; DARWIN-32-PIC-LABEL: litailcaller:
; DARWIN-32-PIC:       ## %bb.0: ## %entry
; DARWIN-32-PIC-NEXT:    subl $12, %esp
; DARWIN-32-PIC-NEXT:    calll L147$pb
; DARWIN-32-PIC-NEXT:  L147$pb:
; DARWIN-32-PIC-NEXT:    popl %eax
; DARWIN-32-PIC-NEXT:    calll *_lifunc-L147$pb(%eax)
; DARWIN-32-PIC-NEXT:    addl $12, %esp
; DARWIN-32-PIC-NEXT:    retl
;
; DARWIN-64-STATIC-LABEL: litailcaller:
; DARWIN-64-STATIC:       ## %bb.0: ## %entry
; DARWIN-64-STATIC-NEXT:    pushq %rax
; DARWIN-64-STATIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-STATIC-NEXT:    popq %rax
; DARWIN-64-STATIC-NEXT:    retq
;
; DARWIN-64-DYNAMIC-LABEL: litailcaller:
; DARWIN-64-DYNAMIC:       ## %bb.0: ## %entry
; DARWIN-64-DYNAMIC-NEXT:    pushq %rax
; DARWIN-64-DYNAMIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-DYNAMIC-NEXT:    popq %rax
; DARWIN-64-DYNAMIC-NEXT:    retq
;
; DARWIN-64-PIC-LABEL: litailcaller:
; DARWIN-64-PIC:       ## %bb.0: ## %entry
; DARWIN-64-PIC-NEXT:    pushq %rax
; DARWIN-64-PIC-NEXT:    callq *_lifunc(%rip)
; DARWIN-64-PIC-NEXT:    popq %rax
; DARWIN-64-PIC-NEXT:    retq

entry:
	%0 = load void ()*, void ()** @lifunc, align 8
	call void %0() nounwind
	ret void
}
