; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa --amdhsa-code-object-version=2 -verify-machineinstrs < %s | FileCheck -check-prefix=GCN %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa --amdhsa-code-object-version=2 -verify-machineinstrs -global-isel < %s | FileCheck -check-prefix=GISEL %s

@gv.fptr0 = external hidden unnamed_addr addrspace(4) constant void()*, align 4
@gv.fptr1 = external hidden unnamed_addr addrspace(4) constant void(i32)*, align 4

define amdgpu_kernel void @test_indirect_call_sgpr_ptr(i8) {
; GCN-LABEL: test_indirect_call_sgpr_ptr:
; GCN:         .amd_kernel_code_t
; GCN-NEXT:     amd_code_version_major = 1
; GCN-NEXT:     amd_code_version_minor = 2
; GCN-NEXT:     amd_machine_kind = 1
; GCN-NEXT:     amd_machine_version_major = 7
; GCN-NEXT:     amd_machine_version_minor = 0
; GCN-NEXT:     amd_machine_version_stepping = 0
; GCN-NEXT:     kernel_code_entry_byte_offset = 256
; GCN-NEXT:     kernel_code_prefetch_byte_size = 0
; GCN-NEXT:     granulated_workitem_vgpr_count = 7
; GCN-NEXT:     granulated_wavefront_sgpr_count = 4
; GCN-NEXT:     priority = 0
; GCN-NEXT:     float_mode = 240
; GCN-NEXT:     priv = 0
; GCN-NEXT:     enable_dx10_clamp = 1
; GCN-NEXT:     debug_mode = 0
; GCN-NEXT:     enable_ieee_mode = 1
; GCN-NEXT:     enable_wgp_mode = 0
; GCN-NEXT:     enable_mem_ordered = 0
; GCN-NEXT:     enable_fwd_progress = 0
; GCN-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 1
; GCN-NEXT:     user_sgpr_count = 14
; GCN-NEXT:     enable_trap_handler = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_x = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_y = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_z = 1
; GCN-NEXT:     enable_sgpr_workgroup_info = 0
; GCN-NEXT:     enable_vgpr_workitem_id = 2
; GCN-NEXT:     enable_exception_msb = 0
; GCN-NEXT:     granulated_lds_size = 0
; GCN-NEXT:     enable_exception = 0
; GCN-NEXT:     enable_sgpr_private_segment_buffer = 1
; GCN-NEXT:     enable_sgpr_dispatch_ptr = 1
; GCN-NEXT:     enable_sgpr_queue_ptr = 1
; GCN-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GCN-NEXT:     enable_sgpr_dispatch_id = 1
; GCN-NEXT:     enable_sgpr_flat_scratch_init = 1
; GCN-NEXT:     enable_sgpr_private_segment_size = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GCN-NEXT:     enable_wavefront_size32 = 0
; GCN-NEXT:     enable_ordered_append_gds = 0
; GCN-NEXT:     private_element_size = 1
; GCN-NEXT:     is_ptr64 = 1
; GCN-NEXT:     is_dynamic_callstack = 1
; GCN-NEXT:     is_debug_enabled = 0
; GCN-NEXT:     is_xnack_enabled = 0
; GCN-NEXT:     workitem_private_segment_byte_size = 16384
; GCN-NEXT:     workgroup_group_segment_byte_size = 0
; GCN-NEXT:     gds_segment_byte_size = 0
; GCN-NEXT:     kernarg_segment_byte_size = 64
; GCN-NEXT:     workgroup_fbarrier_count = 0
; GCN-NEXT:     wavefront_sgpr_count = 37
; GCN-NEXT:     workitem_vgpr_count = 32
; GCN-NEXT:     reserved_vgpr_first = 0
; GCN-NEXT:     reserved_vgpr_count = 0
; GCN-NEXT:     reserved_sgpr_first = 0
; GCN-NEXT:     reserved_sgpr_count = 0
; GCN-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GCN-NEXT:     debug_private_segment_buffer_sgpr = 0
; GCN-NEXT:     kernarg_segment_alignment = 4
; GCN-NEXT:     group_segment_alignment = 4
; GCN-NEXT:     private_segment_alignment = 4
; GCN-NEXT:     wavefront_size = 6
; GCN-NEXT:     call_convention = -1
; GCN-NEXT:     runtime_loader_kernel_symbol = 0
; GCN-NEXT:    .end_amd_kernel_code_t
; GCN-NEXT:  ; %bb.0:
; GCN-NEXT:    s_mov_b32 s32, 0
; GCN-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-NEXT:    s_add_i32 s12, s12, s17
; GCN-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-NEXT:    s_add_u32 s0, s0, s17
; GCN-NEXT:    s_addc_u32 s1, s1, 0
; GCN-NEXT:    s_mov_b32 s13, s15
; GCN-NEXT:    s_mov_b32 s12, s14
; GCN-NEXT:    s_getpc_b64 s[14:15]
; GCN-NEXT:    s_add_u32 s14, s14, gv.fptr0@rel32@lo+4
; GCN-NEXT:    s_addc_u32 s15, s15, gv.fptr0@rel32@hi+12
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GCN-NEXT:    s_load_dwordx2 s[18:19], s[14:15], 0x0
; GCN-NEXT:    s_add_u32 s8, s8, 8
; GCN-NEXT:    s_addc_u32 s9, s9, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GCN-NEXT:    v_or_b32_e32 v0, v0, v1
; GCN-NEXT:    v_or_b32_e32 v31, v0, v2
; GCN-NEXT:    s_mov_b32 s14, s16
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_swappc_b64 s[30:31], s[18:19]
; GCN-NEXT:    s_endpgm
;
; GISEL-LABEL: test_indirect_call_sgpr_ptr:
; GISEL:         .amd_kernel_code_t
; GISEL-NEXT:     amd_code_version_major = 1
; GISEL-NEXT:     amd_code_version_minor = 2
; GISEL-NEXT:     amd_machine_kind = 1
; GISEL-NEXT:     amd_machine_version_major = 7
; GISEL-NEXT:     amd_machine_version_minor = 0
; GISEL-NEXT:     amd_machine_version_stepping = 0
; GISEL-NEXT:     kernel_code_entry_byte_offset = 256
; GISEL-NEXT:     kernel_code_prefetch_byte_size = 0
; GISEL-NEXT:     granulated_workitem_vgpr_count = 7
; GISEL-NEXT:     granulated_wavefront_sgpr_count = 4
; GISEL-NEXT:     priority = 0
; GISEL-NEXT:     float_mode = 240
; GISEL-NEXT:     priv = 0
; GISEL-NEXT:     enable_dx10_clamp = 1
; GISEL-NEXT:     debug_mode = 0
; GISEL-NEXT:     enable_ieee_mode = 1
; GISEL-NEXT:     enable_wgp_mode = 0
; GISEL-NEXT:     enable_mem_ordered = 0
; GISEL-NEXT:     enable_fwd_progress = 0
; GISEL-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 1
; GISEL-NEXT:     user_sgpr_count = 14
; GISEL-NEXT:     enable_trap_handler = 0
; GISEL-NEXT:     enable_sgpr_workgroup_id_x = 1
; GISEL-NEXT:     enable_sgpr_workgroup_id_y = 1
; GISEL-NEXT:     enable_sgpr_workgroup_id_z = 1
; GISEL-NEXT:     enable_sgpr_workgroup_info = 0
; GISEL-NEXT:     enable_vgpr_workitem_id = 2
; GISEL-NEXT:     enable_exception_msb = 0
; GISEL-NEXT:     granulated_lds_size = 0
; GISEL-NEXT:     enable_exception = 0
; GISEL-NEXT:     enable_sgpr_private_segment_buffer = 1
; GISEL-NEXT:     enable_sgpr_dispatch_ptr = 1
; GISEL-NEXT:     enable_sgpr_queue_ptr = 1
; GISEL-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GISEL-NEXT:     enable_sgpr_dispatch_id = 1
; GISEL-NEXT:     enable_sgpr_flat_scratch_init = 1
; GISEL-NEXT:     enable_sgpr_private_segment_size = 0
; GISEL-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GISEL-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GISEL-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GISEL-NEXT:     enable_wavefront_size32 = 0
; GISEL-NEXT:     enable_ordered_append_gds = 0
; GISEL-NEXT:     private_element_size = 1
; GISEL-NEXT:     is_ptr64 = 1
; GISEL-NEXT:     is_dynamic_callstack = 1
; GISEL-NEXT:     is_debug_enabled = 0
; GISEL-NEXT:     is_xnack_enabled = 0
; GISEL-NEXT:     workitem_private_segment_byte_size = 16384
; GISEL-NEXT:     workgroup_group_segment_byte_size = 0
; GISEL-NEXT:     gds_segment_byte_size = 0
; GISEL-NEXT:     kernarg_segment_byte_size = 64
; GISEL-NEXT:     workgroup_fbarrier_count = 0
; GISEL-NEXT:     wavefront_sgpr_count = 37
; GISEL-NEXT:     workitem_vgpr_count = 32
; GISEL-NEXT:     reserved_vgpr_first = 0
; GISEL-NEXT:     reserved_vgpr_count = 0
; GISEL-NEXT:     reserved_sgpr_first = 0
; GISEL-NEXT:     reserved_sgpr_count = 0
; GISEL-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GISEL-NEXT:     debug_private_segment_buffer_sgpr = 0
; GISEL-NEXT:     kernarg_segment_alignment = 4
; GISEL-NEXT:     group_segment_alignment = 4
; GISEL-NEXT:     private_segment_alignment = 4
; GISEL-NEXT:     wavefront_size = 6
; GISEL-NEXT:     call_convention = -1
; GISEL-NEXT:     runtime_loader_kernel_symbol = 0
; GISEL-NEXT:    .end_amd_kernel_code_t
; GISEL-NEXT:  ; %bb.0:
; GISEL-NEXT:    s_mov_b32 s32, 0
; GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GISEL-NEXT:    s_add_i32 s12, s12, s17
; GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GISEL-NEXT:    s_add_u32 s0, s0, s17
; GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GISEL-NEXT:    s_mov_b32 s13, s15
; GISEL-NEXT:    s_mov_b32 s12, s14
; GISEL-NEXT:    s_getpc_b64 s[14:15]
; GISEL-NEXT:    s_add_u32 s14, s14, gv.fptr0@rel32@lo+4
; GISEL-NEXT:    s_addc_u32 s15, s15, gv.fptr0@rel32@hi+12
; GISEL-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GISEL-NEXT:    s_load_dwordx2 s[18:19], s[14:15], 0x0
; GISEL-NEXT:    s_add_u32 s8, s8, 8
; GISEL-NEXT:    s_addc_u32 s9, s9, 0
; GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GISEL-NEXT:    v_lshlrev_b32_e32 v1, 20, v2
; GISEL-NEXT:    v_or_b32_e32 v31, v0, v1
; GISEL-NEXT:    s_mov_b32 s14, s16
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[18:19]
; GISEL-NEXT:    s_endpgm
  %fptr = load void()*, void()* addrspace(4)* @gv.fptr0
  call void %fptr()
  ret void
}

define amdgpu_kernel void @test_indirect_call_sgpr_ptr_arg(i8) {
; GCN-LABEL: test_indirect_call_sgpr_ptr_arg:
; GCN:         .amd_kernel_code_t
; GCN-NEXT:     amd_code_version_major = 1
; GCN-NEXT:     amd_code_version_minor = 2
; GCN-NEXT:     amd_machine_kind = 1
; GCN-NEXT:     amd_machine_version_major = 7
; GCN-NEXT:     amd_machine_version_minor = 0
; GCN-NEXT:     amd_machine_version_stepping = 0
; GCN-NEXT:     kernel_code_entry_byte_offset = 256
; GCN-NEXT:     kernel_code_prefetch_byte_size = 0
; GCN-NEXT:     granulated_workitem_vgpr_count = 7
; GCN-NEXT:     granulated_wavefront_sgpr_count = 4
; GCN-NEXT:     priority = 0
; GCN-NEXT:     float_mode = 240
; GCN-NEXT:     priv = 0
; GCN-NEXT:     enable_dx10_clamp = 1
; GCN-NEXT:     debug_mode = 0
; GCN-NEXT:     enable_ieee_mode = 1
; GCN-NEXT:     enable_wgp_mode = 0
; GCN-NEXT:     enable_mem_ordered = 0
; GCN-NEXT:     enable_fwd_progress = 0
; GCN-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 1
; GCN-NEXT:     user_sgpr_count = 14
; GCN-NEXT:     enable_trap_handler = 0
; GCN-NEXT:     enable_sgpr_workgroup_id_x = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_y = 1
; GCN-NEXT:     enable_sgpr_workgroup_id_z = 1
; GCN-NEXT:     enable_sgpr_workgroup_info = 0
; GCN-NEXT:     enable_vgpr_workitem_id = 2
; GCN-NEXT:     enable_exception_msb = 0
; GCN-NEXT:     granulated_lds_size = 0
; GCN-NEXT:     enable_exception = 0
; GCN-NEXT:     enable_sgpr_private_segment_buffer = 1
; GCN-NEXT:     enable_sgpr_dispatch_ptr = 1
; GCN-NEXT:     enable_sgpr_queue_ptr = 1
; GCN-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GCN-NEXT:     enable_sgpr_dispatch_id = 1
; GCN-NEXT:     enable_sgpr_flat_scratch_init = 1
; GCN-NEXT:     enable_sgpr_private_segment_size = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GCN-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GCN-NEXT:     enable_wavefront_size32 = 0
; GCN-NEXT:     enable_ordered_append_gds = 0
; GCN-NEXT:     private_element_size = 1
; GCN-NEXT:     is_ptr64 = 1
; GCN-NEXT:     is_dynamic_callstack = 1
; GCN-NEXT:     is_debug_enabled = 0
; GCN-NEXT:     is_xnack_enabled = 0
; GCN-NEXT:     workitem_private_segment_byte_size = 16384
; GCN-NEXT:     workgroup_group_segment_byte_size = 0
; GCN-NEXT:     gds_segment_byte_size = 0
; GCN-NEXT:     kernarg_segment_byte_size = 64
; GCN-NEXT:     workgroup_fbarrier_count = 0
; GCN-NEXT:     wavefront_sgpr_count = 37
; GCN-NEXT:     workitem_vgpr_count = 32
; GCN-NEXT:     reserved_vgpr_first = 0
; GCN-NEXT:     reserved_vgpr_count = 0
; GCN-NEXT:     reserved_sgpr_first = 0
; GCN-NEXT:     reserved_sgpr_count = 0
; GCN-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GCN-NEXT:     debug_private_segment_buffer_sgpr = 0
; GCN-NEXT:     kernarg_segment_alignment = 4
; GCN-NEXT:     group_segment_alignment = 4
; GCN-NEXT:     private_segment_alignment = 4
; GCN-NEXT:     wavefront_size = 6
; GCN-NEXT:     call_convention = -1
; GCN-NEXT:     runtime_loader_kernel_symbol = 0
; GCN-NEXT:    .end_amd_kernel_code_t
; GCN-NEXT:  ; %bb.0:
; GCN-NEXT:    s_mov_b32 s32, 0
; GCN-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-NEXT:    s_add_i32 s12, s12, s17
; GCN-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-NEXT:    s_add_u32 s0, s0, s17
; GCN-NEXT:    s_addc_u32 s1, s1, 0
; GCN-NEXT:    s_mov_b32 s13, s15
; GCN-NEXT:    s_mov_b32 s12, s14
; GCN-NEXT:    s_getpc_b64 s[14:15]
; GCN-NEXT:    s_add_u32 s14, s14, gv.fptr1@rel32@lo+4
; GCN-NEXT:    s_addc_u32 s15, s15, gv.fptr1@rel32@hi+12
; GCN-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GCN-NEXT:    s_load_dwordx2 s[18:19], s[14:15], 0x0
; GCN-NEXT:    s_add_u32 s8, s8, 8
; GCN-NEXT:    s_addc_u32 s9, s9, 0
; GCN-NEXT:    v_or_b32_e32 v0, v0, v1
; GCN-NEXT:    v_or_b32_e32 v31, v0, v2
; GCN-NEXT:    v_mov_b32_e32 v0, 0x7b
; GCN-NEXT:    s_mov_b32 s14, s16
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_swappc_b64 s[30:31], s[18:19]
; GCN-NEXT:    s_endpgm
;
; GISEL-LABEL: test_indirect_call_sgpr_ptr_arg:
; GISEL:         .amd_kernel_code_t
; GISEL-NEXT:     amd_code_version_major = 1
; GISEL-NEXT:     amd_code_version_minor = 2
; GISEL-NEXT:     amd_machine_kind = 1
; GISEL-NEXT:     amd_machine_version_major = 7
; GISEL-NEXT:     amd_machine_version_minor = 0
; GISEL-NEXT:     amd_machine_version_stepping = 0
; GISEL-NEXT:     kernel_code_entry_byte_offset = 256
; GISEL-NEXT:     kernel_code_prefetch_byte_size = 0
; GISEL-NEXT:     granulated_workitem_vgpr_count = 7
; GISEL-NEXT:     granulated_wavefront_sgpr_count = 4
; GISEL-NEXT:     priority = 0
; GISEL-NEXT:     float_mode = 240
; GISEL-NEXT:     priv = 0
; GISEL-NEXT:     enable_dx10_clamp = 1
; GISEL-NEXT:     debug_mode = 0
; GISEL-NEXT:     enable_ieee_mode = 1
; GISEL-NEXT:     enable_wgp_mode = 0
; GISEL-NEXT:     enable_mem_ordered = 0
; GISEL-NEXT:     enable_fwd_progress = 0
; GISEL-NEXT:     enable_sgpr_private_segment_wave_byte_offset = 1
; GISEL-NEXT:     user_sgpr_count = 14
; GISEL-NEXT:     enable_trap_handler = 0
; GISEL-NEXT:     enable_sgpr_workgroup_id_x = 1
; GISEL-NEXT:     enable_sgpr_workgroup_id_y = 1
; GISEL-NEXT:     enable_sgpr_workgroup_id_z = 1
; GISEL-NEXT:     enable_sgpr_workgroup_info = 0
; GISEL-NEXT:     enable_vgpr_workitem_id = 2
; GISEL-NEXT:     enable_exception_msb = 0
; GISEL-NEXT:     granulated_lds_size = 0
; GISEL-NEXT:     enable_exception = 0
; GISEL-NEXT:     enable_sgpr_private_segment_buffer = 1
; GISEL-NEXT:     enable_sgpr_dispatch_ptr = 1
; GISEL-NEXT:     enable_sgpr_queue_ptr = 1
; GISEL-NEXT:     enable_sgpr_kernarg_segment_ptr = 1
; GISEL-NEXT:     enable_sgpr_dispatch_id = 1
; GISEL-NEXT:     enable_sgpr_flat_scratch_init = 1
; GISEL-NEXT:     enable_sgpr_private_segment_size = 0
; GISEL-NEXT:     enable_sgpr_grid_workgroup_count_x = 0
; GISEL-NEXT:     enable_sgpr_grid_workgroup_count_y = 0
; GISEL-NEXT:     enable_sgpr_grid_workgroup_count_z = 0
; GISEL-NEXT:     enable_wavefront_size32 = 0
; GISEL-NEXT:     enable_ordered_append_gds = 0
; GISEL-NEXT:     private_element_size = 1
; GISEL-NEXT:     is_ptr64 = 1
; GISEL-NEXT:     is_dynamic_callstack = 1
; GISEL-NEXT:     is_debug_enabled = 0
; GISEL-NEXT:     is_xnack_enabled = 0
; GISEL-NEXT:     workitem_private_segment_byte_size = 16384
; GISEL-NEXT:     workgroup_group_segment_byte_size = 0
; GISEL-NEXT:     gds_segment_byte_size = 0
; GISEL-NEXT:     kernarg_segment_byte_size = 64
; GISEL-NEXT:     workgroup_fbarrier_count = 0
; GISEL-NEXT:     wavefront_sgpr_count = 37
; GISEL-NEXT:     workitem_vgpr_count = 32
; GISEL-NEXT:     reserved_vgpr_first = 0
; GISEL-NEXT:     reserved_vgpr_count = 0
; GISEL-NEXT:     reserved_sgpr_first = 0
; GISEL-NEXT:     reserved_sgpr_count = 0
; GISEL-NEXT:     debug_wavefront_private_segment_offset_sgpr = 0
; GISEL-NEXT:     debug_private_segment_buffer_sgpr = 0
; GISEL-NEXT:     kernarg_segment_alignment = 4
; GISEL-NEXT:     group_segment_alignment = 4
; GISEL-NEXT:     private_segment_alignment = 4
; GISEL-NEXT:     wavefront_size = 6
; GISEL-NEXT:     call_convention = -1
; GISEL-NEXT:     runtime_loader_kernel_symbol = 0
; GISEL-NEXT:    .end_amd_kernel_code_t
; GISEL-NEXT:  ; %bb.0:
; GISEL-NEXT:    s_mov_b32 s32, 0
; GISEL-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GISEL-NEXT:    s_add_i32 s12, s12, s17
; GISEL-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GISEL-NEXT:    s_add_u32 s0, s0, s17
; GISEL-NEXT:    s_addc_u32 s1, s1, 0
; GISEL-NEXT:    s_mov_b32 s13, s15
; GISEL-NEXT:    s_mov_b32 s12, s14
; GISEL-NEXT:    s_getpc_b64 s[14:15]
; GISEL-NEXT:    s_add_u32 s14, s14, gv.fptr1@rel32@lo+4
; GISEL-NEXT:    s_addc_u32 s15, s15, gv.fptr1@rel32@hi+12
; GISEL-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GISEL-NEXT:    s_load_dwordx2 s[18:19], s[14:15], 0x0
; GISEL-NEXT:    s_add_u32 s8, s8, 8
; GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; GISEL-NEXT:    s_addc_u32 s9, s9, 0
; GISEL-NEXT:    v_lshlrev_b32_e32 v1, 20, v2
; GISEL-NEXT:    v_or_b32_e32 v31, v0, v1
; GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GISEL-NEXT:    s_mov_b32 s14, s16
; GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[18:19]
; GISEL-NEXT:    s_endpgm
  %fptr = load void(i32)*, void(i32)* addrspace(4)* @gv.fptr1
  call void %fptr(i32 123)
  ret void
}

define void @test_indirect_call_vgpr_ptr(void()* %fptr) {
; GCN-LABEL: test_indirect_call_vgpr_ptr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[16:17]
; GCN-NEXT:    v_writelane_b32 v40, s33, 17
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_addk_i32 s32, 0x400
; GCN-NEXT:    v_writelane_b32 v40, s34, 0
; GCN-NEXT:    v_writelane_b32 v40, s35, 1
; GCN-NEXT:    v_writelane_b32 v40, s36, 2
; GCN-NEXT:    v_writelane_b32 v40, s37, 3
; GCN-NEXT:    v_writelane_b32 v40, s38, 4
; GCN-NEXT:    v_writelane_b32 v40, s39, 5
; GCN-NEXT:    v_writelane_b32 v40, s40, 6
; GCN-NEXT:    v_writelane_b32 v40, s41, 7
; GCN-NEXT:    v_writelane_b32 v40, s42, 8
; GCN-NEXT:    v_writelane_b32 v40, s43, 9
; GCN-NEXT:    v_writelane_b32 v40, s44, 10
; GCN-NEXT:    v_writelane_b32 v40, s46, 11
; GCN-NEXT:    v_writelane_b32 v40, s47, 12
; GCN-NEXT:    v_writelane_b32 v40, s48, 13
; GCN-NEXT:    v_writelane_b32 v40, s49, 14
; GCN-NEXT:    v_writelane_b32 v40, s30, 15
; GCN-NEXT:    v_writelane_b32 v40, s31, 16
; GCN-NEXT:    s_mov_b32 s42, s14
; GCN-NEXT:    s_mov_b32 s43, s13
; GCN-NEXT:    s_mov_b32 s44, s12
; GCN-NEXT:    s_mov_b64 s[34:35], s[10:11]
; GCN-NEXT:    s_mov_b64 s[36:37], s[8:9]
; GCN-NEXT:    s_mov_b64 s[38:39], s[6:7]
; GCN-NEXT:    s_mov_b64 s[40:41], s[4:5]
; GCN-NEXT:    s_mov_b64 s[46:47], exec
; GCN-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_readfirstlane_b32 s16, v0
; GCN-NEXT:    v_readfirstlane_b32 s17, v1
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, s[16:17], v[0:1]
; GCN-NEXT:    s_and_saveexec_b64 s[48:49], vcc
; GCN-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GCN-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GCN-NEXT:    s_mov_b64 s[8:9], s[36:37]
; GCN-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GCN-NEXT:    s_mov_b32 s12, s44
; GCN-NEXT:    s_mov_b32 s13, s43
; GCN-NEXT:    s_mov_b32 s14, s42
; GCN-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GCN-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GCN-NEXT:    ; implicit-def: $vgpr31
; GCN-NEXT:    s_xor_b64 exec, exec, s[48:49]
; GCN-NEXT:    s_cbranch_execnz .LBB2_1
; GCN-NEXT:  ; %bb.2:
; GCN-NEXT:    s_mov_b64 exec, s[46:47]
; GCN-NEXT:    v_readlane_b32 s4, v40, 15
; GCN-NEXT:    v_readlane_b32 s5, v40, 16
; GCN-NEXT:    v_readlane_b32 s49, v40, 14
; GCN-NEXT:    v_readlane_b32 s48, v40, 13
; GCN-NEXT:    v_readlane_b32 s47, v40, 12
; GCN-NEXT:    v_readlane_b32 s46, v40, 11
; GCN-NEXT:    v_readlane_b32 s44, v40, 10
; GCN-NEXT:    v_readlane_b32 s43, v40, 9
; GCN-NEXT:    v_readlane_b32 s42, v40, 8
; GCN-NEXT:    v_readlane_b32 s41, v40, 7
; GCN-NEXT:    v_readlane_b32 s40, v40, 6
; GCN-NEXT:    v_readlane_b32 s39, v40, 5
; GCN-NEXT:    v_readlane_b32 s38, v40, 4
; GCN-NEXT:    v_readlane_b32 s37, v40, 3
; GCN-NEXT:    v_readlane_b32 s36, v40, 2
; GCN-NEXT:    v_readlane_b32 s35, v40, 1
; GCN-NEXT:    v_readlane_b32 s34, v40, 0
; GCN-NEXT:    s_addk_i32 s32, 0xfc00
; GCN-NEXT:    v_readlane_b32 s33, v40, 17
; GCN-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[4:5]
;
; GISEL-LABEL: test_indirect_call_vgpr_ptr:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GISEL-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GISEL-NEXT:    s_mov_b64 exec, s[16:17]
; GISEL-NEXT:    v_writelane_b32 v40, s33, 17
; GISEL-NEXT:    s_mov_b32 s33, s32
; GISEL-NEXT:    s_addk_i32 s32, 0x400
; GISEL-NEXT:    v_writelane_b32 v40, s34, 0
; GISEL-NEXT:    v_writelane_b32 v40, s35, 1
; GISEL-NEXT:    v_writelane_b32 v40, s36, 2
; GISEL-NEXT:    v_writelane_b32 v40, s37, 3
; GISEL-NEXT:    v_writelane_b32 v40, s38, 4
; GISEL-NEXT:    v_writelane_b32 v40, s39, 5
; GISEL-NEXT:    v_writelane_b32 v40, s40, 6
; GISEL-NEXT:    v_writelane_b32 v40, s41, 7
; GISEL-NEXT:    v_writelane_b32 v40, s42, 8
; GISEL-NEXT:    v_writelane_b32 v40, s43, 9
; GISEL-NEXT:    v_writelane_b32 v40, s44, 10
; GISEL-NEXT:    v_writelane_b32 v40, s46, 11
; GISEL-NEXT:    v_writelane_b32 v40, s47, 12
; GISEL-NEXT:    v_writelane_b32 v40, s48, 13
; GISEL-NEXT:    v_writelane_b32 v40, s49, 14
; GISEL-NEXT:    s_mov_b32 s42, s14
; GISEL-NEXT:    s_mov_b32 s43, s13
; GISEL-NEXT:    s_mov_b32 s44, s12
; GISEL-NEXT:    s_mov_b64 s[34:35], s[10:11]
; GISEL-NEXT:    s_mov_b64 s[36:37], s[8:9]
; GISEL-NEXT:    s_mov_b64 s[38:39], s[6:7]
; GISEL-NEXT:    s_mov_b64 s[40:41], s[4:5]
; GISEL-NEXT:    v_writelane_b32 v40, s30, 15
; GISEL-NEXT:    v_writelane_b32 v40, s31, 16
; GISEL-NEXT:    s_mov_b64 s[46:47], exec
; GISEL-NEXT:  .LBB2_1: ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_readfirstlane_b32 s16, v0
; GISEL-NEXT:    v_readfirstlane_b32 s17, v1
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, s[16:17], v[0:1]
; GISEL-NEXT:    s_and_saveexec_b64 s[48:49], vcc
; GISEL-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GISEL-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GISEL-NEXT:    s_mov_b64 s[8:9], s[36:37]
; GISEL-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GISEL-NEXT:    s_mov_b32 s12, s44
; GISEL-NEXT:    s_mov_b32 s13, s43
; GISEL-NEXT:    s_mov_b32 s14, s42
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GISEL-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GISEL-NEXT:    ; implicit-def: $vgpr31
; GISEL-NEXT:    s_xor_b64 exec, exec, s[48:49]
; GISEL-NEXT:    s_cbranch_execnz .LBB2_1
; GISEL-NEXT:  ; %bb.2:
; GISEL-NEXT:    s_mov_b64 exec, s[46:47]
; GISEL-NEXT:    v_readlane_b32 s4, v40, 15
; GISEL-NEXT:    v_readlane_b32 s5, v40, 16
; GISEL-NEXT:    v_readlane_b32 s49, v40, 14
; GISEL-NEXT:    v_readlane_b32 s48, v40, 13
; GISEL-NEXT:    v_readlane_b32 s47, v40, 12
; GISEL-NEXT:    v_readlane_b32 s46, v40, 11
; GISEL-NEXT:    v_readlane_b32 s44, v40, 10
; GISEL-NEXT:    v_readlane_b32 s43, v40, 9
; GISEL-NEXT:    v_readlane_b32 s42, v40, 8
; GISEL-NEXT:    v_readlane_b32 s41, v40, 7
; GISEL-NEXT:    v_readlane_b32 s40, v40, 6
; GISEL-NEXT:    v_readlane_b32 s39, v40, 5
; GISEL-NEXT:    v_readlane_b32 s38, v40, 4
; GISEL-NEXT:    v_readlane_b32 s37, v40, 3
; GISEL-NEXT:    v_readlane_b32 s36, v40, 2
; GISEL-NEXT:    v_readlane_b32 s35, v40, 1
; GISEL-NEXT:    v_readlane_b32 s34, v40, 0
; GISEL-NEXT:    s_addk_i32 s32, 0xfc00
; GISEL-NEXT:    v_readlane_b32 s33, v40, 17
; GISEL-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GISEL-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[4:5]
  call void %fptr()
  ret void
}

define void @test_indirect_call_vgpr_ptr_arg(void(i32)* %fptr) {
; GCN-LABEL: test_indirect_call_vgpr_ptr_arg:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[16:17]
; GCN-NEXT:    v_writelane_b32 v40, s33, 17
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_addk_i32 s32, 0x400
; GCN-NEXT:    v_writelane_b32 v40, s34, 0
; GCN-NEXT:    v_writelane_b32 v40, s35, 1
; GCN-NEXT:    v_writelane_b32 v40, s36, 2
; GCN-NEXT:    v_writelane_b32 v40, s37, 3
; GCN-NEXT:    v_writelane_b32 v40, s38, 4
; GCN-NEXT:    v_writelane_b32 v40, s39, 5
; GCN-NEXT:    v_writelane_b32 v40, s40, 6
; GCN-NEXT:    v_writelane_b32 v40, s41, 7
; GCN-NEXT:    v_writelane_b32 v40, s42, 8
; GCN-NEXT:    v_writelane_b32 v40, s43, 9
; GCN-NEXT:    v_writelane_b32 v40, s44, 10
; GCN-NEXT:    v_writelane_b32 v40, s46, 11
; GCN-NEXT:    v_writelane_b32 v40, s47, 12
; GCN-NEXT:    v_writelane_b32 v40, s48, 13
; GCN-NEXT:    v_writelane_b32 v40, s49, 14
; GCN-NEXT:    v_writelane_b32 v40, s30, 15
; GCN-NEXT:    v_writelane_b32 v40, s31, 16
; GCN-NEXT:    s_mov_b32 s42, s14
; GCN-NEXT:    s_mov_b32 s43, s13
; GCN-NEXT:    s_mov_b32 s44, s12
; GCN-NEXT:    s_mov_b64 s[34:35], s[10:11]
; GCN-NEXT:    s_mov_b64 s[36:37], s[8:9]
; GCN-NEXT:    s_mov_b64 s[38:39], s[6:7]
; GCN-NEXT:    s_mov_b64 s[40:41], s[4:5]
; GCN-NEXT:    s_mov_b64 s[46:47], exec
; GCN-NEXT:    v_mov_b32_e32 v2, 0x7b
; GCN-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_readfirstlane_b32 s16, v0
; GCN-NEXT:    v_readfirstlane_b32 s17, v1
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, s[16:17], v[0:1]
; GCN-NEXT:    s_and_saveexec_b64 s[48:49], vcc
; GCN-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GCN-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GCN-NEXT:    s_mov_b64 s[8:9], s[36:37]
; GCN-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GCN-NEXT:    s_mov_b32 s12, s44
; GCN-NEXT:    s_mov_b32 s13, s43
; GCN-NEXT:    s_mov_b32 s14, s42
; GCN-NEXT:    v_mov_b32_e32 v0, v2
; GCN-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GCN-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GCN-NEXT:    ; implicit-def: $vgpr31
; GCN-NEXT:    ; implicit-def: $vgpr2
; GCN-NEXT:    s_xor_b64 exec, exec, s[48:49]
; GCN-NEXT:    s_cbranch_execnz .LBB3_1
; GCN-NEXT:  ; %bb.2:
; GCN-NEXT:    s_mov_b64 exec, s[46:47]
; GCN-NEXT:    v_readlane_b32 s4, v40, 15
; GCN-NEXT:    v_readlane_b32 s5, v40, 16
; GCN-NEXT:    v_readlane_b32 s49, v40, 14
; GCN-NEXT:    v_readlane_b32 s48, v40, 13
; GCN-NEXT:    v_readlane_b32 s47, v40, 12
; GCN-NEXT:    v_readlane_b32 s46, v40, 11
; GCN-NEXT:    v_readlane_b32 s44, v40, 10
; GCN-NEXT:    v_readlane_b32 s43, v40, 9
; GCN-NEXT:    v_readlane_b32 s42, v40, 8
; GCN-NEXT:    v_readlane_b32 s41, v40, 7
; GCN-NEXT:    v_readlane_b32 s40, v40, 6
; GCN-NEXT:    v_readlane_b32 s39, v40, 5
; GCN-NEXT:    v_readlane_b32 s38, v40, 4
; GCN-NEXT:    v_readlane_b32 s37, v40, 3
; GCN-NEXT:    v_readlane_b32 s36, v40, 2
; GCN-NEXT:    v_readlane_b32 s35, v40, 1
; GCN-NEXT:    v_readlane_b32 s34, v40, 0
; GCN-NEXT:    s_addk_i32 s32, 0xfc00
; GCN-NEXT:    v_readlane_b32 s33, v40, 17
; GCN-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[4:5]
;
; GISEL-LABEL: test_indirect_call_vgpr_ptr_arg:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GISEL-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GISEL-NEXT:    s_mov_b64 exec, s[16:17]
; GISEL-NEXT:    v_writelane_b32 v40, s33, 17
; GISEL-NEXT:    s_mov_b32 s33, s32
; GISEL-NEXT:    s_addk_i32 s32, 0x400
; GISEL-NEXT:    v_writelane_b32 v40, s34, 0
; GISEL-NEXT:    v_writelane_b32 v40, s35, 1
; GISEL-NEXT:    v_writelane_b32 v40, s36, 2
; GISEL-NEXT:    v_writelane_b32 v40, s37, 3
; GISEL-NEXT:    v_writelane_b32 v40, s38, 4
; GISEL-NEXT:    v_writelane_b32 v40, s39, 5
; GISEL-NEXT:    v_writelane_b32 v40, s40, 6
; GISEL-NEXT:    v_writelane_b32 v40, s41, 7
; GISEL-NEXT:    v_writelane_b32 v40, s42, 8
; GISEL-NEXT:    v_writelane_b32 v40, s43, 9
; GISEL-NEXT:    v_writelane_b32 v40, s44, 10
; GISEL-NEXT:    v_writelane_b32 v40, s46, 11
; GISEL-NEXT:    v_writelane_b32 v40, s47, 12
; GISEL-NEXT:    v_writelane_b32 v40, s48, 13
; GISEL-NEXT:    v_writelane_b32 v40, s49, 14
; GISEL-NEXT:    s_mov_b32 s42, s14
; GISEL-NEXT:    s_mov_b32 s43, s13
; GISEL-NEXT:    s_mov_b32 s44, s12
; GISEL-NEXT:    s_mov_b64 s[34:35], s[10:11]
; GISEL-NEXT:    s_mov_b64 s[36:37], s[8:9]
; GISEL-NEXT:    s_mov_b64 s[38:39], s[6:7]
; GISEL-NEXT:    s_mov_b64 s[40:41], s[4:5]
; GISEL-NEXT:    v_writelane_b32 v40, s30, 15
; GISEL-NEXT:    v_writelane_b32 v40, s31, 16
; GISEL-NEXT:    s_mov_b64 s[46:47], exec
; GISEL-NEXT:  .LBB3_1: ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_readfirstlane_b32 s16, v0
; GISEL-NEXT:    v_readfirstlane_b32 s17, v1
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, s[16:17], v[0:1]
; GISEL-NEXT:    s_and_saveexec_b64 s[48:49], vcc
; GISEL-NEXT:    v_mov_b32_e32 v0, 0x7b
; GISEL-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GISEL-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GISEL-NEXT:    s_mov_b64 s[8:9], s[36:37]
; GISEL-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GISEL-NEXT:    s_mov_b32 s12, s44
; GISEL-NEXT:    s_mov_b32 s13, s43
; GISEL-NEXT:    s_mov_b32 s14, s42
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GISEL-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GISEL-NEXT:    ; implicit-def: $vgpr31
; GISEL-NEXT:    s_xor_b64 exec, exec, s[48:49]
; GISEL-NEXT:    s_cbranch_execnz .LBB3_1
; GISEL-NEXT:  ; %bb.2:
; GISEL-NEXT:    s_mov_b64 exec, s[46:47]
; GISEL-NEXT:    v_readlane_b32 s4, v40, 15
; GISEL-NEXT:    v_readlane_b32 s5, v40, 16
; GISEL-NEXT:    v_readlane_b32 s49, v40, 14
; GISEL-NEXT:    v_readlane_b32 s48, v40, 13
; GISEL-NEXT:    v_readlane_b32 s47, v40, 12
; GISEL-NEXT:    v_readlane_b32 s46, v40, 11
; GISEL-NEXT:    v_readlane_b32 s44, v40, 10
; GISEL-NEXT:    v_readlane_b32 s43, v40, 9
; GISEL-NEXT:    v_readlane_b32 s42, v40, 8
; GISEL-NEXT:    v_readlane_b32 s41, v40, 7
; GISEL-NEXT:    v_readlane_b32 s40, v40, 6
; GISEL-NEXT:    v_readlane_b32 s39, v40, 5
; GISEL-NEXT:    v_readlane_b32 s38, v40, 4
; GISEL-NEXT:    v_readlane_b32 s37, v40, 3
; GISEL-NEXT:    v_readlane_b32 s36, v40, 2
; GISEL-NEXT:    v_readlane_b32 s35, v40, 1
; GISEL-NEXT:    v_readlane_b32 s34, v40, 0
; GISEL-NEXT:    s_addk_i32 s32, 0xfc00
; GISEL-NEXT:    v_readlane_b32 s33, v40, 17
; GISEL-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GISEL-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[4:5]
  call void %fptr(i32 123)
  ret void
}

define i32 @test_indirect_call_vgpr_ptr_ret(i32()* %fptr) {
; GCN-LABEL: test_indirect_call_vgpr_ptr_ret:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[16:17]
; GCN-NEXT:    v_writelane_b32 v40, s33, 17
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_addk_i32 s32, 0x400
; GCN-NEXT:    v_writelane_b32 v40, s34, 0
; GCN-NEXT:    v_writelane_b32 v40, s35, 1
; GCN-NEXT:    v_writelane_b32 v40, s36, 2
; GCN-NEXT:    v_writelane_b32 v40, s37, 3
; GCN-NEXT:    v_writelane_b32 v40, s38, 4
; GCN-NEXT:    v_writelane_b32 v40, s39, 5
; GCN-NEXT:    v_writelane_b32 v40, s40, 6
; GCN-NEXT:    v_writelane_b32 v40, s41, 7
; GCN-NEXT:    v_writelane_b32 v40, s42, 8
; GCN-NEXT:    v_writelane_b32 v40, s43, 9
; GCN-NEXT:    v_writelane_b32 v40, s44, 10
; GCN-NEXT:    v_writelane_b32 v40, s46, 11
; GCN-NEXT:    v_writelane_b32 v40, s47, 12
; GCN-NEXT:    v_writelane_b32 v40, s48, 13
; GCN-NEXT:    v_writelane_b32 v40, s49, 14
; GCN-NEXT:    v_writelane_b32 v40, s30, 15
; GCN-NEXT:    v_writelane_b32 v40, s31, 16
; GCN-NEXT:    s_mov_b32 s42, s14
; GCN-NEXT:    s_mov_b32 s43, s13
; GCN-NEXT:    s_mov_b32 s44, s12
; GCN-NEXT:    s_mov_b64 s[34:35], s[10:11]
; GCN-NEXT:    s_mov_b64 s[36:37], s[8:9]
; GCN-NEXT:    s_mov_b64 s[38:39], s[6:7]
; GCN-NEXT:    s_mov_b64 s[40:41], s[4:5]
; GCN-NEXT:    s_mov_b64 s[46:47], exec
; GCN-NEXT:  .LBB4_1: ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_readfirstlane_b32 s16, v0
; GCN-NEXT:    v_readfirstlane_b32 s17, v1
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, s[16:17], v[0:1]
; GCN-NEXT:    s_and_saveexec_b64 s[48:49], vcc
; GCN-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GCN-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GCN-NEXT:    s_mov_b64 s[8:9], s[36:37]
; GCN-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GCN-NEXT:    s_mov_b32 s12, s44
; GCN-NEXT:    s_mov_b32 s13, s43
; GCN-NEXT:    s_mov_b32 s14, s42
; GCN-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GCN-NEXT:    v_mov_b32_e32 v2, v0
; GCN-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GCN-NEXT:    ; implicit-def: $vgpr31
; GCN-NEXT:    s_xor_b64 exec, exec, s[48:49]
; GCN-NEXT:    s_cbranch_execnz .LBB4_1
; GCN-NEXT:  ; %bb.2:
; GCN-NEXT:    s_mov_b64 exec, s[46:47]
; GCN-NEXT:    v_add_i32_e32 v0, vcc, 1, v2
; GCN-NEXT:    v_readlane_b32 s4, v40, 15
; GCN-NEXT:    v_readlane_b32 s5, v40, 16
; GCN-NEXT:    v_readlane_b32 s49, v40, 14
; GCN-NEXT:    v_readlane_b32 s48, v40, 13
; GCN-NEXT:    v_readlane_b32 s47, v40, 12
; GCN-NEXT:    v_readlane_b32 s46, v40, 11
; GCN-NEXT:    v_readlane_b32 s44, v40, 10
; GCN-NEXT:    v_readlane_b32 s43, v40, 9
; GCN-NEXT:    v_readlane_b32 s42, v40, 8
; GCN-NEXT:    v_readlane_b32 s41, v40, 7
; GCN-NEXT:    v_readlane_b32 s40, v40, 6
; GCN-NEXT:    v_readlane_b32 s39, v40, 5
; GCN-NEXT:    v_readlane_b32 s38, v40, 4
; GCN-NEXT:    v_readlane_b32 s37, v40, 3
; GCN-NEXT:    v_readlane_b32 s36, v40, 2
; GCN-NEXT:    v_readlane_b32 s35, v40, 1
; GCN-NEXT:    v_readlane_b32 s34, v40, 0
; GCN-NEXT:    s_addk_i32 s32, 0xfc00
; GCN-NEXT:    v_readlane_b32 s33, v40, 17
; GCN-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[4:5]
;
; GISEL-LABEL: test_indirect_call_vgpr_ptr_ret:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GISEL-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GISEL-NEXT:    s_mov_b64 exec, s[16:17]
; GISEL-NEXT:    v_writelane_b32 v40, s33, 17
; GISEL-NEXT:    s_mov_b32 s33, s32
; GISEL-NEXT:    s_addk_i32 s32, 0x400
; GISEL-NEXT:    v_writelane_b32 v40, s34, 0
; GISEL-NEXT:    v_writelane_b32 v40, s35, 1
; GISEL-NEXT:    v_writelane_b32 v40, s36, 2
; GISEL-NEXT:    v_writelane_b32 v40, s37, 3
; GISEL-NEXT:    v_writelane_b32 v40, s38, 4
; GISEL-NEXT:    v_writelane_b32 v40, s39, 5
; GISEL-NEXT:    v_writelane_b32 v40, s40, 6
; GISEL-NEXT:    v_writelane_b32 v40, s41, 7
; GISEL-NEXT:    v_writelane_b32 v40, s42, 8
; GISEL-NEXT:    v_writelane_b32 v40, s43, 9
; GISEL-NEXT:    v_writelane_b32 v40, s44, 10
; GISEL-NEXT:    v_writelane_b32 v40, s46, 11
; GISEL-NEXT:    v_writelane_b32 v40, s47, 12
; GISEL-NEXT:    v_writelane_b32 v40, s48, 13
; GISEL-NEXT:    v_writelane_b32 v40, s49, 14
; GISEL-NEXT:    s_mov_b32 s42, s14
; GISEL-NEXT:    s_mov_b32 s43, s13
; GISEL-NEXT:    s_mov_b32 s44, s12
; GISEL-NEXT:    s_mov_b64 s[34:35], s[10:11]
; GISEL-NEXT:    s_mov_b64 s[36:37], s[8:9]
; GISEL-NEXT:    s_mov_b64 s[38:39], s[6:7]
; GISEL-NEXT:    s_mov_b64 s[40:41], s[4:5]
; GISEL-NEXT:    v_writelane_b32 v40, s30, 15
; GISEL-NEXT:    v_writelane_b32 v40, s31, 16
; GISEL-NEXT:    s_mov_b64 s[46:47], exec
; GISEL-NEXT:  .LBB4_1: ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_readfirstlane_b32 s16, v0
; GISEL-NEXT:    v_readfirstlane_b32 s17, v1
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, s[16:17], v[0:1]
; GISEL-NEXT:    s_and_saveexec_b64 s[48:49], vcc
; GISEL-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GISEL-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GISEL-NEXT:    s_mov_b64 s[8:9], s[36:37]
; GISEL-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GISEL-NEXT:    s_mov_b32 s12, s44
; GISEL-NEXT:    s_mov_b32 s13, s43
; GISEL-NEXT:    s_mov_b32 s14, s42
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GISEL-NEXT:    v_mov_b32_e32 v2, v0
; GISEL-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GISEL-NEXT:    ; implicit-def: $vgpr31
; GISEL-NEXT:    s_xor_b64 exec, exec, s[48:49]
; GISEL-NEXT:    s_cbranch_execnz .LBB4_1
; GISEL-NEXT:  ; %bb.2:
; GISEL-NEXT:    s_mov_b64 exec, s[46:47]
; GISEL-NEXT:    v_add_i32_e32 v0, vcc, 1, v2
; GISEL-NEXT:    v_readlane_b32 s4, v40, 15
; GISEL-NEXT:    v_readlane_b32 s5, v40, 16
; GISEL-NEXT:    v_readlane_b32 s49, v40, 14
; GISEL-NEXT:    v_readlane_b32 s48, v40, 13
; GISEL-NEXT:    v_readlane_b32 s47, v40, 12
; GISEL-NEXT:    v_readlane_b32 s46, v40, 11
; GISEL-NEXT:    v_readlane_b32 s44, v40, 10
; GISEL-NEXT:    v_readlane_b32 s43, v40, 9
; GISEL-NEXT:    v_readlane_b32 s42, v40, 8
; GISEL-NEXT:    v_readlane_b32 s41, v40, 7
; GISEL-NEXT:    v_readlane_b32 s40, v40, 6
; GISEL-NEXT:    v_readlane_b32 s39, v40, 5
; GISEL-NEXT:    v_readlane_b32 s38, v40, 4
; GISEL-NEXT:    v_readlane_b32 s37, v40, 3
; GISEL-NEXT:    v_readlane_b32 s36, v40, 2
; GISEL-NEXT:    v_readlane_b32 s35, v40, 1
; GISEL-NEXT:    v_readlane_b32 s34, v40, 0
; GISEL-NEXT:    s_addk_i32 s32, 0xfc00
; GISEL-NEXT:    v_readlane_b32 s33, v40, 17
; GISEL-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GISEL-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[4:5]
  %a = call i32 %fptr()
  %b = add i32 %a, 1
  ret i32 %b
}

define void @test_indirect_call_vgpr_ptr_in_branch(void()* %fptr, i1 %cond) {
; GCN-LABEL: test_indirect_call_vgpr_ptr_in_branch:
; GCN:       ; %bb.0: ; %bb0
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[16:17]
; GCN-NEXT:    v_writelane_b32 v40, s33, 19
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_addk_i32 s32, 0x400
; GCN-NEXT:    v_writelane_b32 v40, s34, 0
; GCN-NEXT:    v_writelane_b32 v40, s35, 1
; GCN-NEXT:    v_writelane_b32 v40, s36, 2
; GCN-NEXT:    v_writelane_b32 v40, s37, 3
; GCN-NEXT:    v_writelane_b32 v40, s38, 4
; GCN-NEXT:    v_writelane_b32 v40, s39, 5
; GCN-NEXT:    v_writelane_b32 v40, s40, 6
; GCN-NEXT:    v_writelane_b32 v40, s41, 7
; GCN-NEXT:    v_writelane_b32 v40, s42, 8
; GCN-NEXT:    v_writelane_b32 v40, s43, 9
; GCN-NEXT:    v_writelane_b32 v40, s44, 10
; GCN-NEXT:    v_writelane_b32 v40, s46, 11
; GCN-NEXT:    v_writelane_b32 v40, s47, 12
; GCN-NEXT:    v_writelane_b32 v40, s48, 13
; GCN-NEXT:    v_writelane_b32 v40, s49, 14
; GCN-NEXT:    v_writelane_b32 v40, s50, 15
; GCN-NEXT:    v_writelane_b32 v40, s51, 16
; GCN-NEXT:    s_mov_b32 s42, s14
; GCN-NEXT:    s_mov_b32 s43, s13
; GCN-NEXT:    s_mov_b32 s44, s12
; GCN-NEXT:    s_mov_b64 s[34:35], s[10:11]
; GCN-NEXT:    s_mov_b64 s[36:37], s[8:9]
; GCN-NEXT:    s_mov_b64 s[38:39], s[6:7]
; GCN-NEXT:    s_mov_b64 s[40:41], s[4:5]
; GCN-NEXT:    v_and_b32_e32 v2, 1, v2
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GCN-NEXT:    s_and_saveexec_b64 s[46:47], vcc
; GCN-NEXT:    s_cbranch_execz .LBB5_4
; GCN-NEXT:  ; %bb.1: ; %bb1
; GCN-NEXT:    v_writelane_b32 v40, s30, 17
; GCN-NEXT:    v_writelane_b32 v40, s31, 18
; GCN-NEXT:    s_mov_b64 s[48:49], exec
; GCN-NEXT:  .LBB5_2: ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_readfirstlane_b32 s16, v0
; GCN-NEXT:    v_readfirstlane_b32 s17, v1
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, s[16:17], v[0:1]
; GCN-NEXT:    s_and_saveexec_b64 s[50:51], vcc
; GCN-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GCN-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GCN-NEXT:    s_mov_b64 s[8:9], s[36:37]
; GCN-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GCN-NEXT:    s_mov_b32 s12, s44
; GCN-NEXT:    s_mov_b32 s13, s43
; GCN-NEXT:    s_mov_b32 s14, s42
; GCN-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GCN-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GCN-NEXT:    ; implicit-def: $vgpr31
; GCN-NEXT:    s_xor_b64 exec, exec, s[50:51]
; GCN-NEXT:    s_cbranch_execnz .LBB5_2
; GCN-NEXT:  ; %bb.3:
; GCN-NEXT:    s_mov_b64 exec, s[48:49]
; GCN-NEXT:    v_readlane_b32 s30, v40, 17
; GCN-NEXT:    v_readlane_b32 s31, v40, 18
; GCN-NEXT:  .LBB5_4: ; %bb2
; GCN-NEXT:    s_or_b64 exec, exec, s[46:47]
; GCN-NEXT:    v_readlane_b32 s51, v40, 16
; GCN-NEXT:    v_readlane_b32 s50, v40, 15
; GCN-NEXT:    v_readlane_b32 s49, v40, 14
; GCN-NEXT:    v_readlane_b32 s48, v40, 13
; GCN-NEXT:    v_readlane_b32 s47, v40, 12
; GCN-NEXT:    v_readlane_b32 s46, v40, 11
; GCN-NEXT:    v_readlane_b32 s44, v40, 10
; GCN-NEXT:    v_readlane_b32 s43, v40, 9
; GCN-NEXT:    v_readlane_b32 s42, v40, 8
; GCN-NEXT:    v_readlane_b32 s41, v40, 7
; GCN-NEXT:    v_readlane_b32 s40, v40, 6
; GCN-NEXT:    v_readlane_b32 s39, v40, 5
; GCN-NEXT:    v_readlane_b32 s38, v40, 4
; GCN-NEXT:    v_readlane_b32 s37, v40, 3
; GCN-NEXT:    v_readlane_b32 s36, v40, 2
; GCN-NEXT:    v_readlane_b32 s35, v40, 1
; GCN-NEXT:    v_readlane_b32 s34, v40, 0
; GCN-NEXT:    s_addk_i32 s32, 0xfc00
; GCN-NEXT:    v_readlane_b32 s33, v40, 19
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-LABEL: test_indirect_call_vgpr_ptr_in_branch:
; GISEL:       ; %bb.0: ; %bb0
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_or_saveexec_b64 s[16:17], -1
; GISEL-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GISEL-NEXT:    s_mov_b64 exec, s[16:17]
; GISEL-NEXT:    v_writelane_b32 v40, s33, 19
; GISEL-NEXT:    s_mov_b32 s33, s32
; GISEL-NEXT:    s_addk_i32 s32, 0x400
; GISEL-NEXT:    v_writelane_b32 v40, s34, 0
; GISEL-NEXT:    v_writelane_b32 v40, s35, 1
; GISEL-NEXT:    v_writelane_b32 v40, s36, 2
; GISEL-NEXT:    v_writelane_b32 v40, s37, 3
; GISEL-NEXT:    v_writelane_b32 v40, s38, 4
; GISEL-NEXT:    v_writelane_b32 v40, s39, 5
; GISEL-NEXT:    v_writelane_b32 v40, s40, 6
; GISEL-NEXT:    v_writelane_b32 v40, s41, 7
; GISEL-NEXT:    v_writelane_b32 v40, s42, 8
; GISEL-NEXT:    v_writelane_b32 v40, s43, 9
; GISEL-NEXT:    v_writelane_b32 v40, s44, 10
; GISEL-NEXT:    v_writelane_b32 v40, s46, 11
; GISEL-NEXT:    v_writelane_b32 v40, s47, 12
; GISEL-NEXT:    v_writelane_b32 v40, s48, 13
; GISEL-NEXT:    v_writelane_b32 v40, s49, 14
; GISEL-NEXT:    v_writelane_b32 v40, s50, 15
; GISEL-NEXT:    v_writelane_b32 v40, s51, 16
; GISEL-NEXT:    s_mov_b32 s42, s14
; GISEL-NEXT:    s_mov_b32 s43, s13
; GISEL-NEXT:    s_mov_b32 s44, s12
; GISEL-NEXT:    s_mov_b64 s[34:35], s[10:11]
; GISEL-NEXT:    s_mov_b64 s[36:37], s[8:9]
; GISEL-NEXT:    s_mov_b64 s[38:39], s[6:7]
; GISEL-NEXT:    s_mov_b64 s[40:41], s[4:5]
; GISEL-NEXT:    v_and_b32_e32 v2, 1, v2
; GISEL-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; GISEL-NEXT:    s_and_saveexec_b64 s[46:47], vcc
; GISEL-NEXT:    s_cbranch_execz .LBB5_4
; GISEL-NEXT:  ; %bb.1: ; %bb1
; GISEL-NEXT:    v_writelane_b32 v40, s30, 17
; GISEL-NEXT:    v_writelane_b32 v40, s31, 18
; GISEL-NEXT:    s_mov_b64 s[48:49], exec
; GISEL-NEXT:  .LBB5_2: ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_readfirstlane_b32 s16, v0
; GISEL-NEXT:    v_readfirstlane_b32 s17, v1
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, s[16:17], v[0:1]
; GISEL-NEXT:    s_and_saveexec_b64 s[50:51], vcc
; GISEL-NEXT:    s_mov_b64 s[4:5], s[40:41]
; GISEL-NEXT:    s_mov_b64 s[6:7], s[38:39]
; GISEL-NEXT:    s_mov_b64 s[8:9], s[36:37]
; GISEL-NEXT:    s_mov_b64 s[10:11], s[34:35]
; GISEL-NEXT:    s_mov_b32 s12, s44
; GISEL-NEXT:    s_mov_b32 s13, s43
; GISEL-NEXT:    s_mov_b32 s14, s42
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GISEL-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GISEL-NEXT:    ; implicit-def: $vgpr31
; GISEL-NEXT:    s_xor_b64 exec, exec, s[50:51]
; GISEL-NEXT:    s_cbranch_execnz .LBB5_2
; GISEL-NEXT:  ; %bb.3:
; GISEL-NEXT:    s_mov_b64 exec, s[48:49]
; GISEL-NEXT:    v_readlane_b32 s30, v40, 17
; GISEL-NEXT:    v_readlane_b32 s31, v40, 18
; GISEL-NEXT:  .LBB5_4: ; %bb2
; GISEL-NEXT:    s_or_b64 exec, exec, s[46:47]
; GISEL-NEXT:    v_readlane_b32 s51, v40, 16
; GISEL-NEXT:    v_readlane_b32 s50, v40, 15
; GISEL-NEXT:    v_readlane_b32 s49, v40, 14
; GISEL-NEXT:    v_readlane_b32 s48, v40, 13
; GISEL-NEXT:    v_readlane_b32 s47, v40, 12
; GISEL-NEXT:    v_readlane_b32 s46, v40, 11
; GISEL-NEXT:    v_readlane_b32 s44, v40, 10
; GISEL-NEXT:    v_readlane_b32 s43, v40, 9
; GISEL-NEXT:    v_readlane_b32 s42, v40, 8
; GISEL-NEXT:    v_readlane_b32 s41, v40, 7
; GISEL-NEXT:    v_readlane_b32 s40, v40, 6
; GISEL-NEXT:    v_readlane_b32 s39, v40, 5
; GISEL-NEXT:    v_readlane_b32 s38, v40, 4
; GISEL-NEXT:    v_readlane_b32 s37, v40, 3
; GISEL-NEXT:    v_readlane_b32 s36, v40, 2
; GISEL-NEXT:    v_readlane_b32 s35, v40, 1
; GISEL-NEXT:    v_readlane_b32 s34, v40, 0
; GISEL-NEXT:    s_addk_i32 s32, 0xfc00
; GISEL-NEXT:    v_readlane_b32 s33, v40, 19
; GISEL-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GISEL-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GISEL-NEXT:    s_mov_b64 exec, s[4:5]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[30:31]
bb0:
  br i1 %cond, label %bb1, label %bb2

bb1:
  call void %fptr()
  br label %bb2

bb2:
  ret void
}

define void @test_indirect_call_vgpr_ptr_inreg_arg(void(i32)* %fptr) {
; GCN-LABEL: test_indirect_call_vgpr_ptr_inreg_arg:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    v_writelane_b32 v40, s33, 30
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_addk_i32 s32, 0x400
; GCN-NEXT:    v_writelane_b32 v40, s34, 0
; GCN-NEXT:    v_writelane_b32 v40, s35, 1
; GCN-NEXT:    v_writelane_b32 v40, s36, 2
; GCN-NEXT:    v_writelane_b32 v40, s37, 3
; GCN-NEXT:    v_writelane_b32 v40, s38, 4
; GCN-NEXT:    v_writelane_b32 v40, s39, 5
; GCN-NEXT:    v_writelane_b32 v40, s40, 6
; GCN-NEXT:    v_writelane_b32 v40, s41, 7
; GCN-NEXT:    v_writelane_b32 v40, s42, 8
; GCN-NEXT:    v_writelane_b32 v40, s43, 9
; GCN-NEXT:    v_writelane_b32 v40, s44, 10
; GCN-NEXT:    v_writelane_b32 v40, s45, 11
; GCN-NEXT:    v_writelane_b32 v40, s46, 12
; GCN-NEXT:    v_writelane_b32 v40, s47, 13
; GCN-NEXT:    v_writelane_b32 v40, s48, 14
; GCN-NEXT:    v_writelane_b32 v40, s49, 15
; GCN-NEXT:    v_writelane_b32 v40, s50, 16
; GCN-NEXT:    v_writelane_b32 v40, s51, 17
; GCN-NEXT:    v_writelane_b32 v40, s52, 18
; GCN-NEXT:    v_writelane_b32 v40, s53, 19
; GCN-NEXT:    v_writelane_b32 v40, s54, 20
; GCN-NEXT:    v_writelane_b32 v40, s55, 21
; GCN-NEXT:    v_writelane_b32 v40, s56, 22
; GCN-NEXT:    v_writelane_b32 v40, s57, 23
; GCN-NEXT:    v_writelane_b32 v40, s58, 24
; GCN-NEXT:    v_writelane_b32 v40, s59, 25
; GCN-NEXT:    v_writelane_b32 v40, s60, 26
; GCN-NEXT:    v_writelane_b32 v40, s61, 27
; GCN-NEXT:    v_writelane_b32 v40, s62, 28
; GCN-NEXT:    v_writelane_b32 v40, s63, 29
; GCN-NEXT:    s_mov_b64 s[6:7], s[30:31]
; GCN-NEXT:    s_mov_b64 s[8:9], exec
; GCN-NEXT:    s_movk_i32 s4, 0x7b
; GCN-NEXT:  .LBB6_1: ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_readfirstlane_b32 s12, v0
; GCN-NEXT:    v_readfirstlane_b32 s13, v1
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, s[12:13], v[0:1]
; GCN-NEXT:    s_and_saveexec_b64 s[10:11], vcc
; GCN-NEXT:    s_swappc_b64 s[30:31], s[12:13]
; GCN-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GCN-NEXT:    s_xor_b64 exec, exec, s[10:11]
; GCN-NEXT:    s_cbranch_execnz .LBB6_1
; GCN-NEXT:  ; %bb.2:
; GCN-NEXT:    s_mov_b64 exec, s[8:9]
; GCN-NEXT:    v_readlane_b32 s63, v40, 29
; GCN-NEXT:    v_readlane_b32 s62, v40, 28
; GCN-NEXT:    v_readlane_b32 s61, v40, 27
; GCN-NEXT:    v_readlane_b32 s60, v40, 26
; GCN-NEXT:    v_readlane_b32 s59, v40, 25
; GCN-NEXT:    v_readlane_b32 s58, v40, 24
; GCN-NEXT:    v_readlane_b32 s57, v40, 23
; GCN-NEXT:    v_readlane_b32 s56, v40, 22
; GCN-NEXT:    v_readlane_b32 s55, v40, 21
; GCN-NEXT:    v_readlane_b32 s54, v40, 20
; GCN-NEXT:    v_readlane_b32 s53, v40, 19
; GCN-NEXT:    v_readlane_b32 s52, v40, 18
; GCN-NEXT:    v_readlane_b32 s51, v40, 17
; GCN-NEXT:    v_readlane_b32 s50, v40, 16
; GCN-NEXT:    v_readlane_b32 s49, v40, 15
; GCN-NEXT:    v_readlane_b32 s48, v40, 14
; GCN-NEXT:    v_readlane_b32 s47, v40, 13
; GCN-NEXT:    v_readlane_b32 s46, v40, 12
; GCN-NEXT:    v_readlane_b32 s45, v40, 11
; GCN-NEXT:    v_readlane_b32 s44, v40, 10
; GCN-NEXT:    v_readlane_b32 s43, v40, 9
; GCN-NEXT:    v_readlane_b32 s42, v40, 8
; GCN-NEXT:    v_readlane_b32 s41, v40, 7
; GCN-NEXT:    v_readlane_b32 s40, v40, 6
; GCN-NEXT:    v_readlane_b32 s39, v40, 5
; GCN-NEXT:    v_readlane_b32 s38, v40, 4
; GCN-NEXT:    v_readlane_b32 s37, v40, 3
; GCN-NEXT:    v_readlane_b32 s36, v40, 2
; GCN-NEXT:    v_readlane_b32 s35, v40, 1
; GCN-NEXT:    v_readlane_b32 s34, v40, 0
; GCN-NEXT:    s_addk_i32 s32, 0xfc00
; GCN-NEXT:    v_readlane_b32 s33, v40, 30
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[6:7]
;
; GISEL-LABEL: test_indirect_call_vgpr_ptr_inreg_arg:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GISEL-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GISEL-NEXT:    s_mov_b64 exec, s[4:5]
; GISEL-NEXT:    v_writelane_b32 v40, s33, 30
; GISEL-NEXT:    s_mov_b32 s33, s32
; GISEL-NEXT:    s_addk_i32 s32, 0x400
; GISEL-NEXT:    v_writelane_b32 v40, s34, 0
; GISEL-NEXT:    v_writelane_b32 v40, s35, 1
; GISEL-NEXT:    v_writelane_b32 v40, s36, 2
; GISEL-NEXT:    v_writelane_b32 v40, s37, 3
; GISEL-NEXT:    v_writelane_b32 v40, s38, 4
; GISEL-NEXT:    v_writelane_b32 v40, s39, 5
; GISEL-NEXT:    v_writelane_b32 v40, s40, 6
; GISEL-NEXT:    v_writelane_b32 v40, s41, 7
; GISEL-NEXT:    v_writelane_b32 v40, s42, 8
; GISEL-NEXT:    v_writelane_b32 v40, s43, 9
; GISEL-NEXT:    v_writelane_b32 v40, s44, 10
; GISEL-NEXT:    v_writelane_b32 v40, s45, 11
; GISEL-NEXT:    v_writelane_b32 v40, s46, 12
; GISEL-NEXT:    v_writelane_b32 v40, s47, 13
; GISEL-NEXT:    v_writelane_b32 v40, s48, 14
; GISEL-NEXT:    v_writelane_b32 v40, s49, 15
; GISEL-NEXT:    v_writelane_b32 v40, s50, 16
; GISEL-NEXT:    v_writelane_b32 v40, s51, 17
; GISEL-NEXT:    v_writelane_b32 v40, s52, 18
; GISEL-NEXT:    v_writelane_b32 v40, s53, 19
; GISEL-NEXT:    v_writelane_b32 v40, s54, 20
; GISEL-NEXT:    v_writelane_b32 v40, s55, 21
; GISEL-NEXT:    v_writelane_b32 v40, s56, 22
; GISEL-NEXT:    v_writelane_b32 v40, s57, 23
; GISEL-NEXT:    v_writelane_b32 v40, s58, 24
; GISEL-NEXT:    v_writelane_b32 v40, s59, 25
; GISEL-NEXT:    v_writelane_b32 v40, s60, 26
; GISEL-NEXT:    v_writelane_b32 v40, s61, 27
; GISEL-NEXT:    v_writelane_b32 v40, s62, 28
; GISEL-NEXT:    v_writelane_b32 v40, s63, 29
; GISEL-NEXT:    s_mov_b64 s[6:7], s[30:31]
; GISEL-NEXT:    s_movk_i32 s4, 0x7b
; GISEL-NEXT:    s_mov_b64 s[8:9], exec
; GISEL-NEXT:  .LBB6_1: ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_readfirstlane_b32 s10, v0
; GISEL-NEXT:    v_readfirstlane_b32 s11, v1
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, s[10:11], v[0:1]
; GISEL-NEXT:    s_and_saveexec_b64 s[12:13], vcc
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[10:11]
; GISEL-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GISEL-NEXT:    s_xor_b64 exec, exec, s[12:13]
; GISEL-NEXT:    s_cbranch_execnz .LBB6_1
; GISEL-NEXT:  ; %bb.2:
; GISEL-NEXT:    s_mov_b64 exec, s[8:9]
; GISEL-NEXT:    v_readlane_b32 s63, v40, 29
; GISEL-NEXT:    v_readlane_b32 s62, v40, 28
; GISEL-NEXT:    v_readlane_b32 s61, v40, 27
; GISEL-NEXT:    v_readlane_b32 s60, v40, 26
; GISEL-NEXT:    v_readlane_b32 s59, v40, 25
; GISEL-NEXT:    v_readlane_b32 s58, v40, 24
; GISEL-NEXT:    v_readlane_b32 s57, v40, 23
; GISEL-NEXT:    v_readlane_b32 s56, v40, 22
; GISEL-NEXT:    v_readlane_b32 s55, v40, 21
; GISEL-NEXT:    v_readlane_b32 s54, v40, 20
; GISEL-NEXT:    v_readlane_b32 s53, v40, 19
; GISEL-NEXT:    v_readlane_b32 s52, v40, 18
; GISEL-NEXT:    v_readlane_b32 s51, v40, 17
; GISEL-NEXT:    v_readlane_b32 s50, v40, 16
; GISEL-NEXT:    v_readlane_b32 s49, v40, 15
; GISEL-NEXT:    v_readlane_b32 s48, v40, 14
; GISEL-NEXT:    v_readlane_b32 s47, v40, 13
; GISEL-NEXT:    v_readlane_b32 s46, v40, 12
; GISEL-NEXT:    v_readlane_b32 s45, v40, 11
; GISEL-NEXT:    v_readlane_b32 s44, v40, 10
; GISEL-NEXT:    v_readlane_b32 s43, v40, 9
; GISEL-NEXT:    v_readlane_b32 s42, v40, 8
; GISEL-NEXT:    v_readlane_b32 s41, v40, 7
; GISEL-NEXT:    v_readlane_b32 s40, v40, 6
; GISEL-NEXT:    v_readlane_b32 s39, v40, 5
; GISEL-NEXT:    v_readlane_b32 s38, v40, 4
; GISEL-NEXT:    v_readlane_b32 s37, v40, 3
; GISEL-NEXT:    v_readlane_b32 s36, v40, 2
; GISEL-NEXT:    v_readlane_b32 s35, v40, 1
; GISEL-NEXT:    v_readlane_b32 s34, v40, 0
; GISEL-NEXT:    s_addk_i32 s32, 0xfc00
; GISEL-NEXT:    v_readlane_b32 s33, v40, 30
; GISEL-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GISEL-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GISEL-NEXT:    s_mov_b64 exec, s[4:5]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[6:7]
  call amdgpu_gfx void %fptr(i32 inreg 123)
  ret void
}

define i32 @test_indirect_call_vgpr_ptr_arg_and_reuse(i32 %i, void(i32)* %fptr) {
; GCN-LABEL: test_indirect_call_vgpr_ptr_arg_and_reuse:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    v_writelane_b32 v40, s33, 30
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_addk_i32 s32, 0x400
; GCN-NEXT:    buffer_store_dword v41, off, s[0:3], s33 ; 4-byte Folded Spill
; GCN-NEXT:    v_writelane_b32 v40, s34, 0
; GCN-NEXT:    v_writelane_b32 v40, s35, 1
; GCN-NEXT:    v_writelane_b32 v40, s36, 2
; GCN-NEXT:    v_writelane_b32 v40, s37, 3
; GCN-NEXT:    v_writelane_b32 v40, s38, 4
; GCN-NEXT:    v_writelane_b32 v40, s39, 5
; GCN-NEXT:    v_writelane_b32 v40, s40, 6
; GCN-NEXT:    v_writelane_b32 v40, s41, 7
; GCN-NEXT:    v_writelane_b32 v40, s42, 8
; GCN-NEXT:    v_writelane_b32 v40, s43, 9
; GCN-NEXT:    v_writelane_b32 v40, s44, 10
; GCN-NEXT:    v_writelane_b32 v40, s45, 11
; GCN-NEXT:    v_writelane_b32 v40, s46, 12
; GCN-NEXT:    v_writelane_b32 v40, s47, 13
; GCN-NEXT:    v_writelane_b32 v40, s48, 14
; GCN-NEXT:    v_writelane_b32 v40, s49, 15
; GCN-NEXT:    v_writelane_b32 v40, s50, 16
; GCN-NEXT:    v_writelane_b32 v40, s51, 17
; GCN-NEXT:    v_writelane_b32 v40, s52, 18
; GCN-NEXT:    v_writelane_b32 v40, s53, 19
; GCN-NEXT:    v_writelane_b32 v40, s54, 20
; GCN-NEXT:    v_writelane_b32 v40, s55, 21
; GCN-NEXT:    v_writelane_b32 v40, s56, 22
; GCN-NEXT:    v_writelane_b32 v40, s57, 23
; GCN-NEXT:    v_writelane_b32 v40, s58, 24
; GCN-NEXT:    v_writelane_b32 v40, s59, 25
; GCN-NEXT:    v_writelane_b32 v40, s60, 26
; GCN-NEXT:    v_writelane_b32 v40, s61, 27
; GCN-NEXT:    v_writelane_b32 v40, s62, 28
; GCN-NEXT:    v_writelane_b32 v40, s63, 29
; GCN-NEXT:    s_mov_b64 s[4:5], s[30:31]
; GCN-NEXT:    v_mov_b32_e32 v41, v0
; GCN-NEXT:    s_mov_b64 s[6:7], exec
; GCN-NEXT:  .LBB7_1: ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_readfirstlane_b32 s10, v1
; GCN-NEXT:    v_readfirstlane_b32 s11, v2
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, s[10:11], v[1:2]
; GCN-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GCN-NEXT:    v_mov_b32_e32 v0, v41
; GCN-NEXT:    s_swappc_b64 s[30:31], s[10:11]
; GCN-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GCN-NEXT:    s_xor_b64 exec, exec, s[8:9]
; GCN-NEXT:    s_cbranch_execnz .LBB7_1
; GCN-NEXT:  ; %bb.2:
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v0, v41
; GCN-NEXT:    v_readlane_b32 s63, v40, 29
; GCN-NEXT:    v_readlane_b32 s62, v40, 28
; GCN-NEXT:    v_readlane_b32 s61, v40, 27
; GCN-NEXT:    v_readlane_b32 s60, v40, 26
; GCN-NEXT:    v_readlane_b32 s59, v40, 25
; GCN-NEXT:    v_readlane_b32 s58, v40, 24
; GCN-NEXT:    v_readlane_b32 s57, v40, 23
; GCN-NEXT:    v_readlane_b32 s56, v40, 22
; GCN-NEXT:    v_readlane_b32 s55, v40, 21
; GCN-NEXT:    v_readlane_b32 s54, v40, 20
; GCN-NEXT:    v_readlane_b32 s53, v40, 19
; GCN-NEXT:    v_readlane_b32 s52, v40, 18
; GCN-NEXT:    v_readlane_b32 s51, v40, 17
; GCN-NEXT:    v_readlane_b32 s50, v40, 16
; GCN-NEXT:    v_readlane_b32 s49, v40, 15
; GCN-NEXT:    v_readlane_b32 s48, v40, 14
; GCN-NEXT:    v_readlane_b32 s47, v40, 13
; GCN-NEXT:    v_readlane_b32 s46, v40, 12
; GCN-NEXT:    v_readlane_b32 s45, v40, 11
; GCN-NEXT:    v_readlane_b32 s44, v40, 10
; GCN-NEXT:    v_readlane_b32 s43, v40, 9
; GCN-NEXT:    v_readlane_b32 s42, v40, 8
; GCN-NEXT:    v_readlane_b32 s41, v40, 7
; GCN-NEXT:    v_readlane_b32 s40, v40, 6
; GCN-NEXT:    v_readlane_b32 s39, v40, 5
; GCN-NEXT:    v_readlane_b32 s38, v40, 4
; GCN-NEXT:    v_readlane_b32 s37, v40, 3
; GCN-NEXT:    v_readlane_b32 s36, v40, 2
; GCN-NEXT:    v_readlane_b32 s35, v40, 1
; GCN-NEXT:    v_readlane_b32 s34, v40, 0
; GCN-NEXT:    buffer_load_dword v41, off, s[0:3], s33 ; 4-byte Folded Reload
; GCN-NEXT:    s_addk_i32 s32, 0xfc00
; GCN-NEXT:    v_readlane_b32 s33, v40, 30
; GCN-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[4:5]
;
; GISEL-LABEL: test_indirect_call_vgpr_ptr_arg_and_reuse:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GISEL-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GISEL-NEXT:    s_mov_b64 exec, s[4:5]
; GISEL-NEXT:    v_writelane_b32 v40, s33, 30
; GISEL-NEXT:    s_mov_b32 s33, s32
; GISEL-NEXT:    s_addk_i32 s32, 0x400
; GISEL-NEXT:    buffer_store_dword v41, off, s[0:3], s33 ; 4-byte Folded Spill
; GISEL-NEXT:    v_writelane_b32 v40, s34, 0
; GISEL-NEXT:    v_writelane_b32 v40, s35, 1
; GISEL-NEXT:    v_writelane_b32 v40, s36, 2
; GISEL-NEXT:    v_writelane_b32 v40, s37, 3
; GISEL-NEXT:    v_writelane_b32 v40, s38, 4
; GISEL-NEXT:    v_writelane_b32 v40, s39, 5
; GISEL-NEXT:    v_writelane_b32 v40, s40, 6
; GISEL-NEXT:    v_writelane_b32 v40, s41, 7
; GISEL-NEXT:    v_writelane_b32 v40, s42, 8
; GISEL-NEXT:    v_writelane_b32 v40, s43, 9
; GISEL-NEXT:    v_writelane_b32 v40, s44, 10
; GISEL-NEXT:    v_writelane_b32 v40, s45, 11
; GISEL-NEXT:    v_writelane_b32 v40, s46, 12
; GISEL-NEXT:    v_writelane_b32 v40, s47, 13
; GISEL-NEXT:    v_writelane_b32 v40, s48, 14
; GISEL-NEXT:    v_writelane_b32 v40, s49, 15
; GISEL-NEXT:    v_writelane_b32 v40, s50, 16
; GISEL-NEXT:    v_writelane_b32 v40, s51, 17
; GISEL-NEXT:    v_writelane_b32 v40, s52, 18
; GISEL-NEXT:    v_writelane_b32 v40, s53, 19
; GISEL-NEXT:    v_writelane_b32 v40, s54, 20
; GISEL-NEXT:    v_writelane_b32 v40, s55, 21
; GISEL-NEXT:    v_writelane_b32 v40, s56, 22
; GISEL-NEXT:    v_writelane_b32 v40, s57, 23
; GISEL-NEXT:    v_writelane_b32 v40, s58, 24
; GISEL-NEXT:    v_writelane_b32 v40, s59, 25
; GISEL-NEXT:    v_writelane_b32 v40, s60, 26
; GISEL-NEXT:    v_writelane_b32 v40, s61, 27
; GISEL-NEXT:    v_writelane_b32 v40, s62, 28
; GISEL-NEXT:    v_writelane_b32 v40, s63, 29
; GISEL-NEXT:    v_mov_b32_e32 v41, v0
; GISEL-NEXT:    s_mov_b64 s[4:5], s[30:31]
; GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GISEL-NEXT:  .LBB7_1: ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_readfirstlane_b32 s8, v1
; GISEL-NEXT:    v_readfirstlane_b32 s9, v2
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[1:2]
; GISEL-NEXT:    s_and_saveexec_b64 s[10:11], vcc
; GISEL-NEXT:    v_mov_b32_e32 v0, v41
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[8:9]
; GISEL-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GISEL-NEXT:    s_xor_b64 exec, exec, s[10:11]
; GISEL-NEXT:    s_cbranch_execnz .LBB7_1
; GISEL-NEXT:  ; %bb.2:
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    v_mov_b32_e32 v0, v41
; GISEL-NEXT:    v_readlane_b32 s63, v40, 29
; GISEL-NEXT:    v_readlane_b32 s62, v40, 28
; GISEL-NEXT:    v_readlane_b32 s61, v40, 27
; GISEL-NEXT:    v_readlane_b32 s60, v40, 26
; GISEL-NEXT:    v_readlane_b32 s59, v40, 25
; GISEL-NEXT:    v_readlane_b32 s58, v40, 24
; GISEL-NEXT:    v_readlane_b32 s57, v40, 23
; GISEL-NEXT:    v_readlane_b32 s56, v40, 22
; GISEL-NEXT:    v_readlane_b32 s55, v40, 21
; GISEL-NEXT:    v_readlane_b32 s54, v40, 20
; GISEL-NEXT:    v_readlane_b32 s53, v40, 19
; GISEL-NEXT:    v_readlane_b32 s52, v40, 18
; GISEL-NEXT:    v_readlane_b32 s51, v40, 17
; GISEL-NEXT:    v_readlane_b32 s50, v40, 16
; GISEL-NEXT:    v_readlane_b32 s49, v40, 15
; GISEL-NEXT:    v_readlane_b32 s48, v40, 14
; GISEL-NEXT:    v_readlane_b32 s47, v40, 13
; GISEL-NEXT:    v_readlane_b32 s46, v40, 12
; GISEL-NEXT:    v_readlane_b32 s45, v40, 11
; GISEL-NEXT:    v_readlane_b32 s44, v40, 10
; GISEL-NEXT:    v_readlane_b32 s43, v40, 9
; GISEL-NEXT:    v_readlane_b32 s42, v40, 8
; GISEL-NEXT:    v_readlane_b32 s41, v40, 7
; GISEL-NEXT:    v_readlane_b32 s40, v40, 6
; GISEL-NEXT:    v_readlane_b32 s39, v40, 5
; GISEL-NEXT:    v_readlane_b32 s38, v40, 4
; GISEL-NEXT:    v_readlane_b32 s37, v40, 3
; GISEL-NEXT:    v_readlane_b32 s36, v40, 2
; GISEL-NEXT:    v_readlane_b32 s35, v40, 1
; GISEL-NEXT:    v_readlane_b32 s34, v40, 0
; GISEL-NEXT:    buffer_load_dword v41, off, s[0:3], s33 ; 4-byte Folded Reload
; GISEL-NEXT:    s_addk_i32 s32, 0xfc00
; GISEL-NEXT:    v_readlane_b32 s33, v40, 30
; GISEL-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GISEL-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[4:5]
  call amdgpu_gfx void %fptr(i32 %i)
  ret i32 %i
}

; Use a variable inside a waterfall loop and use the return variable after the loop.
; TODO The argument and return variable could be in the same physical register, but the register
; allocator is not able to do that because the return value clashes with the liverange of an
; IMPLICIT_DEF of the argument.
define i32 @test_indirect_call_vgpr_ptr_arg_and_return(i32 %i, i32(i32)* %fptr) {
; GCN-LABEL: test_indirect_call_vgpr_ptr_arg_and_return:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    v_writelane_b32 v40, s33, 30
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_addk_i32 s32, 0x400
; GCN-NEXT:    v_writelane_b32 v40, s34, 0
; GCN-NEXT:    v_writelane_b32 v40, s35, 1
; GCN-NEXT:    v_writelane_b32 v40, s36, 2
; GCN-NEXT:    v_writelane_b32 v40, s37, 3
; GCN-NEXT:    v_writelane_b32 v40, s38, 4
; GCN-NEXT:    v_writelane_b32 v40, s39, 5
; GCN-NEXT:    v_writelane_b32 v40, s40, 6
; GCN-NEXT:    v_writelane_b32 v40, s41, 7
; GCN-NEXT:    v_writelane_b32 v40, s42, 8
; GCN-NEXT:    v_writelane_b32 v40, s43, 9
; GCN-NEXT:    v_writelane_b32 v40, s44, 10
; GCN-NEXT:    v_writelane_b32 v40, s45, 11
; GCN-NEXT:    v_writelane_b32 v40, s46, 12
; GCN-NEXT:    v_writelane_b32 v40, s47, 13
; GCN-NEXT:    v_writelane_b32 v40, s48, 14
; GCN-NEXT:    v_writelane_b32 v40, s49, 15
; GCN-NEXT:    v_writelane_b32 v40, s50, 16
; GCN-NEXT:    v_writelane_b32 v40, s51, 17
; GCN-NEXT:    v_writelane_b32 v40, s52, 18
; GCN-NEXT:    v_writelane_b32 v40, s53, 19
; GCN-NEXT:    v_writelane_b32 v40, s54, 20
; GCN-NEXT:    v_writelane_b32 v40, s55, 21
; GCN-NEXT:    v_writelane_b32 v40, s56, 22
; GCN-NEXT:    v_writelane_b32 v40, s57, 23
; GCN-NEXT:    v_writelane_b32 v40, s58, 24
; GCN-NEXT:    v_writelane_b32 v40, s59, 25
; GCN-NEXT:    v_writelane_b32 v40, s60, 26
; GCN-NEXT:    v_writelane_b32 v40, s61, 27
; GCN-NEXT:    v_writelane_b32 v40, s62, 28
; GCN-NEXT:    v_writelane_b32 v40, s63, 29
; GCN-NEXT:    s_mov_b64 s[4:5], s[30:31]
; GCN-NEXT:    s_mov_b64 s[6:7], exec
; GCN-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_readfirstlane_b32 s10, v1
; GCN-NEXT:    v_readfirstlane_b32 s11, v2
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, s[10:11], v[1:2]
; GCN-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GCN-NEXT:    s_swappc_b64 s[30:31], s[10:11]
; GCN-NEXT:    v_mov_b32_e32 v3, v0
; GCN-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GCN-NEXT:    ; implicit-def: $vgpr0
; GCN-NEXT:    s_xor_b64 exec, exec, s[8:9]
; GCN-NEXT:    s_cbranch_execnz .LBB8_1
; GCN-NEXT:  ; %bb.2:
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    v_readlane_b32 s63, v40, 29
; GCN-NEXT:    v_readlane_b32 s62, v40, 28
; GCN-NEXT:    v_readlane_b32 s61, v40, 27
; GCN-NEXT:    v_readlane_b32 s60, v40, 26
; GCN-NEXT:    v_readlane_b32 s59, v40, 25
; GCN-NEXT:    v_readlane_b32 s58, v40, 24
; GCN-NEXT:    v_readlane_b32 s57, v40, 23
; GCN-NEXT:    v_readlane_b32 s56, v40, 22
; GCN-NEXT:    v_readlane_b32 s55, v40, 21
; GCN-NEXT:    v_readlane_b32 s54, v40, 20
; GCN-NEXT:    v_readlane_b32 s53, v40, 19
; GCN-NEXT:    v_readlane_b32 s52, v40, 18
; GCN-NEXT:    v_readlane_b32 s51, v40, 17
; GCN-NEXT:    v_readlane_b32 s50, v40, 16
; GCN-NEXT:    v_readlane_b32 s49, v40, 15
; GCN-NEXT:    v_readlane_b32 s48, v40, 14
; GCN-NEXT:    v_readlane_b32 s47, v40, 13
; GCN-NEXT:    v_readlane_b32 s46, v40, 12
; GCN-NEXT:    v_readlane_b32 s45, v40, 11
; GCN-NEXT:    v_readlane_b32 s44, v40, 10
; GCN-NEXT:    v_readlane_b32 s43, v40, 9
; GCN-NEXT:    v_readlane_b32 s42, v40, 8
; GCN-NEXT:    v_readlane_b32 s41, v40, 7
; GCN-NEXT:    v_readlane_b32 s40, v40, 6
; GCN-NEXT:    v_readlane_b32 s39, v40, 5
; GCN-NEXT:    v_readlane_b32 s38, v40, 4
; GCN-NEXT:    v_readlane_b32 s37, v40, 3
; GCN-NEXT:    v_readlane_b32 s36, v40, 2
; GCN-NEXT:    v_readlane_b32 s35, v40, 1
; GCN-NEXT:    v_readlane_b32 s34, v40, 0
; GCN-NEXT:    s_addk_i32 s32, 0xfc00
; GCN-NEXT:    v_readlane_b32 s33, v40, 30
; GCN-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[4:5]
;
; GISEL-LABEL: test_indirect_call_vgpr_ptr_arg_and_return:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GISEL-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GISEL-NEXT:    s_mov_b64 exec, s[4:5]
; GISEL-NEXT:    v_writelane_b32 v40, s33, 30
; GISEL-NEXT:    s_mov_b32 s33, s32
; GISEL-NEXT:    s_addk_i32 s32, 0x400
; GISEL-NEXT:    v_writelane_b32 v40, s34, 0
; GISEL-NEXT:    v_writelane_b32 v40, s35, 1
; GISEL-NEXT:    v_writelane_b32 v40, s36, 2
; GISEL-NEXT:    v_writelane_b32 v40, s37, 3
; GISEL-NEXT:    v_writelane_b32 v40, s38, 4
; GISEL-NEXT:    v_writelane_b32 v40, s39, 5
; GISEL-NEXT:    v_writelane_b32 v40, s40, 6
; GISEL-NEXT:    v_writelane_b32 v40, s41, 7
; GISEL-NEXT:    v_writelane_b32 v40, s42, 8
; GISEL-NEXT:    v_writelane_b32 v40, s43, 9
; GISEL-NEXT:    v_writelane_b32 v40, s44, 10
; GISEL-NEXT:    v_writelane_b32 v40, s45, 11
; GISEL-NEXT:    v_writelane_b32 v40, s46, 12
; GISEL-NEXT:    v_writelane_b32 v40, s47, 13
; GISEL-NEXT:    v_writelane_b32 v40, s48, 14
; GISEL-NEXT:    v_writelane_b32 v40, s49, 15
; GISEL-NEXT:    v_writelane_b32 v40, s50, 16
; GISEL-NEXT:    v_writelane_b32 v40, s51, 17
; GISEL-NEXT:    v_writelane_b32 v40, s52, 18
; GISEL-NEXT:    v_writelane_b32 v40, s53, 19
; GISEL-NEXT:    v_writelane_b32 v40, s54, 20
; GISEL-NEXT:    v_writelane_b32 v40, s55, 21
; GISEL-NEXT:    v_writelane_b32 v40, s56, 22
; GISEL-NEXT:    v_writelane_b32 v40, s57, 23
; GISEL-NEXT:    v_writelane_b32 v40, s58, 24
; GISEL-NEXT:    v_writelane_b32 v40, s59, 25
; GISEL-NEXT:    v_writelane_b32 v40, s60, 26
; GISEL-NEXT:    v_writelane_b32 v40, s61, 27
; GISEL-NEXT:    v_writelane_b32 v40, s62, 28
; GISEL-NEXT:    v_writelane_b32 v40, s63, 29
; GISEL-NEXT:    s_mov_b64 s[4:5], s[30:31]
; GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GISEL-NEXT:  .LBB8_1: ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_readfirstlane_b32 s8, v1
; GISEL-NEXT:    v_readfirstlane_b32 s9, v2
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[1:2]
; GISEL-NEXT:    s_and_saveexec_b64 s[10:11], vcc
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[8:9]
; GISEL-NEXT:    v_mov_b32_e32 v3, v0
; GISEL-NEXT:    ; implicit-def: $vgpr1_vgpr2
; GISEL-NEXT:    ; implicit-def: $vgpr0
; GISEL-NEXT:    s_xor_b64 exec, exec, s[10:11]
; GISEL-NEXT:    s_cbranch_execnz .LBB8_1
; GISEL-NEXT:  ; %bb.2:
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    v_mov_b32_e32 v0, v3
; GISEL-NEXT:    v_readlane_b32 s63, v40, 29
; GISEL-NEXT:    v_readlane_b32 s62, v40, 28
; GISEL-NEXT:    v_readlane_b32 s61, v40, 27
; GISEL-NEXT:    v_readlane_b32 s60, v40, 26
; GISEL-NEXT:    v_readlane_b32 s59, v40, 25
; GISEL-NEXT:    v_readlane_b32 s58, v40, 24
; GISEL-NEXT:    v_readlane_b32 s57, v40, 23
; GISEL-NEXT:    v_readlane_b32 s56, v40, 22
; GISEL-NEXT:    v_readlane_b32 s55, v40, 21
; GISEL-NEXT:    v_readlane_b32 s54, v40, 20
; GISEL-NEXT:    v_readlane_b32 s53, v40, 19
; GISEL-NEXT:    v_readlane_b32 s52, v40, 18
; GISEL-NEXT:    v_readlane_b32 s51, v40, 17
; GISEL-NEXT:    v_readlane_b32 s50, v40, 16
; GISEL-NEXT:    v_readlane_b32 s49, v40, 15
; GISEL-NEXT:    v_readlane_b32 s48, v40, 14
; GISEL-NEXT:    v_readlane_b32 s47, v40, 13
; GISEL-NEXT:    v_readlane_b32 s46, v40, 12
; GISEL-NEXT:    v_readlane_b32 s45, v40, 11
; GISEL-NEXT:    v_readlane_b32 s44, v40, 10
; GISEL-NEXT:    v_readlane_b32 s43, v40, 9
; GISEL-NEXT:    v_readlane_b32 s42, v40, 8
; GISEL-NEXT:    v_readlane_b32 s41, v40, 7
; GISEL-NEXT:    v_readlane_b32 s40, v40, 6
; GISEL-NEXT:    v_readlane_b32 s39, v40, 5
; GISEL-NEXT:    v_readlane_b32 s38, v40, 4
; GISEL-NEXT:    v_readlane_b32 s37, v40, 3
; GISEL-NEXT:    v_readlane_b32 s36, v40, 2
; GISEL-NEXT:    v_readlane_b32 s35, v40, 1
; GISEL-NEXT:    v_readlane_b32 s34, v40, 0
; GISEL-NEXT:    s_addk_i32 s32, 0xfc00
; GISEL-NEXT:    v_readlane_b32 s33, v40, 30
; GISEL-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GISEL-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[4:5]
  %ret = call amdgpu_gfx i32 %fptr(i32 %i)
  ret i32 %ret
}

; Calling a vgpr can never be a tail call.
define void @test_indirect_tail_call_vgpr_ptr(void()* %fptr) {
; GCN-LABEL: test_indirect_tail_call_vgpr_ptr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GCN-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GCN-NEXT:    s_mov_b64 exec, s[4:5]
; GCN-NEXT:    v_writelane_b32 v40, s33, 30
; GCN-NEXT:    s_mov_b32 s33, s32
; GCN-NEXT:    s_addk_i32 s32, 0x400
; GCN-NEXT:    v_writelane_b32 v40, s34, 0
; GCN-NEXT:    v_writelane_b32 v40, s35, 1
; GCN-NEXT:    v_writelane_b32 v40, s36, 2
; GCN-NEXT:    v_writelane_b32 v40, s37, 3
; GCN-NEXT:    v_writelane_b32 v40, s38, 4
; GCN-NEXT:    v_writelane_b32 v40, s39, 5
; GCN-NEXT:    v_writelane_b32 v40, s40, 6
; GCN-NEXT:    v_writelane_b32 v40, s41, 7
; GCN-NEXT:    v_writelane_b32 v40, s42, 8
; GCN-NEXT:    v_writelane_b32 v40, s43, 9
; GCN-NEXT:    v_writelane_b32 v40, s44, 10
; GCN-NEXT:    v_writelane_b32 v40, s45, 11
; GCN-NEXT:    v_writelane_b32 v40, s46, 12
; GCN-NEXT:    v_writelane_b32 v40, s47, 13
; GCN-NEXT:    v_writelane_b32 v40, s48, 14
; GCN-NEXT:    v_writelane_b32 v40, s49, 15
; GCN-NEXT:    v_writelane_b32 v40, s50, 16
; GCN-NEXT:    v_writelane_b32 v40, s51, 17
; GCN-NEXT:    v_writelane_b32 v40, s52, 18
; GCN-NEXT:    v_writelane_b32 v40, s53, 19
; GCN-NEXT:    v_writelane_b32 v40, s54, 20
; GCN-NEXT:    v_writelane_b32 v40, s55, 21
; GCN-NEXT:    v_writelane_b32 v40, s56, 22
; GCN-NEXT:    v_writelane_b32 v40, s57, 23
; GCN-NEXT:    v_writelane_b32 v40, s58, 24
; GCN-NEXT:    v_writelane_b32 v40, s59, 25
; GCN-NEXT:    v_writelane_b32 v40, s60, 26
; GCN-NEXT:    v_writelane_b32 v40, s61, 27
; GCN-NEXT:    v_writelane_b32 v40, s62, 28
; GCN-NEXT:    v_writelane_b32 v40, s63, 29
; GCN-NEXT:    s_mov_b64 s[4:5], s[30:31]
; GCN-NEXT:    s_mov_b64 s[6:7], exec
; GCN-NEXT:  .LBB9_1: ; =>This Inner Loop Header: Depth=1
; GCN-NEXT:    v_readfirstlane_b32 s10, v0
; GCN-NEXT:    v_readfirstlane_b32 s11, v1
; GCN-NEXT:    v_cmp_eq_u64_e32 vcc, s[10:11], v[0:1]
; GCN-NEXT:    s_and_saveexec_b64 s[8:9], vcc
; GCN-NEXT:    s_swappc_b64 s[30:31], s[10:11]
; GCN-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GCN-NEXT:    s_xor_b64 exec, exec, s[8:9]
; GCN-NEXT:    s_cbranch_execnz .LBB9_1
; GCN-NEXT:  ; %bb.2:
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    v_readlane_b32 s63, v40, 29
; GCN-NEXT:    v_readlane_b32 s62, v40, 28
; GCN-NEXT:    v_readlane_b32 s61, v40, 27
; GCN-NEXT:    v_readlane_b32 s60, v40, 26
; GCN-NEXT:    v_readlane_b32 s59, v40, 25
; GCN-NEXT:    v_readlane_b32 s58, v40, 24
; GCN-NEXT:    v_readlane_b32 s57, v40, 23
; GCN-NEXT:    v_readlane_b32 s56, v40, 22
; GCN-NEXT:    v_readlane_b32 s55, v40, 21
; GCN-NEXT:    v_readlane_b32 s54, v40, 20
; GCN-NEXT:    v_readlane_b32 s53, v40, 19
; GCN-NEXT:    v_readlane_b32 s52, v40, 18
; GCN-NEXT:    v_readlane_b32 s51, v40, 17
; GCN-NEXT:    v_readlane_b32 s50, v40, 16
; GCN-NEXT:    v_readlane_b32 s49, v40, 15
; GCN-NEXT:    v_readlane_b32 s48, v40, 14
; GCN-NEXT:    v_readlane_b32 s47, v40, 13
; GCN-NEXT:    v_readlane_b32 s46, v40, 12
; GCN-NEXT:    v_readlane_b32 s45, v40, 11
; GCN-NEXT:    v_readlane_b32 s44, v40, 10
; GCN-NEXT:    v_readlane_b32 s43, v40, 9
; GCN-NEXT:    v_readlane_b32 s42, v40, 8
; GCN-NEXT:    v_readlane_b32 s41, v40, 7
; GCN-NEXT:    v_readlane_b32 s40, v40, 6
; GCN-NEXT:    v_readlane_b32 s39, v40, 5
; GCN-NEXT:    v_readlane_b32 s38, v40, 4
; GCN-NEXT:    v_readlane_b32 s37, v40, 3
; GCN-NEXT:    v_readlane_b32 s36, v40, 2
; GCN-NEXT:    v_readlane_b32 s35, v40, 1
; GCN-NEXT:    v_readlane_b32 s34, v40, 0
; GCN-NEXT:    s_addk_i32 s32, 0xfc00
; GCN-NEXT:    v_readlane_b32 s33, v40, 30
; GCN-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GCN-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GCN-NEXT:    s_mov_b64 exec, s[6:7]
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[4:5]
;
; GISEL-LABEL: test_indirect_tail_call_vgpr_ptr:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_or_saveexec_b64 s[4:5], -1
; GISEL-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; GISEL-NEXT:    s_mov_b64 exec, s[4:5]
; GISEL-NEXT:    v_writelane_b32 v40, s33, 30
; GISEL-NEXT:    s_mov_b32 s33, s32
; GISEL-NEXT:    s_addk_i32 s32, 0x400
; GISEL-NEXT:    v_writelane_b32 v40, s34, 0
; GISEL-NEXT:    v_writelane_b32 v40, s35, 1
; GISEL-NEXT:    v_writelane_b32 v40, s36, 2
; GISEL-NEXT:    v_writelane_b32 v40, s37, 3
; GISEL-NEXT:    v_writelane_b32 v40, s38, 4
; GISEL-NEXT:    v_writelane_b32 v40, s39, 5
; GISEL-NEXT:    v_writelane_b32 v40, s40, 6
; GISEL-NEXT:    v_writelane_b32 v40, s41, 7
; GISEL-NEXT:    v_writelane_b32 v40, s42, 8
; GISEL-NEXT:    v_writelane_b32 v40, s43, 9
; GISEL-NEXT:    v_writelane_b32 v40, s44, 10
; GISEL-NEXT:    v_writelane_b32 v40, s45, 11
; GISEL-NEXT:    v_writelane_b32 v40, s46, 12
; GISEL-NEXT:    v_writelane_b32 v40, s47, 13
; GISEL-NEXT:    v_writelane_b32 v40, s48, 14
; GISEL-NEXT:    v_writelane_b32 v40, s49, 15
; GISEL-NEXT:    v_writelane_b32 v40, s50, 16
; GISEL-NEXT:    v_writelane_b32 v40, s51, 17
; GISEL-NEXT:    v_writelane_b32 v40, s52, 18
; GISEL-NEXT:    v_writelane_b32 v40, s53, 19
; GISEL-NEXT:    v_writelane_b32 v40, s54, 20
; GISEL-NEXT:    v_writelane_b32 v40, s55, 21
; GISEL-NEXT:    v_writelane_b32 v40, s56, 22
; GISEL-NEXT:    v_writelane_b32 v40, s57, 23
; GISEL-NEXT:    v_writelane_b32 v40, s58, 24
; GISEL-NEXT:    v_writelane_b32 v40, s59, 25
; GISEL-NEXT:    v_writelane_b32 v40, s60, 26
; GISEL-NEXT:    v_writelane_b32 v40, s61, 27
; GISEL-NEXT:    v_writelane_b32 v40, s62, 28
; GISEL-NEXT:    v_writelane_b32 v40, s63, 29
; GISEL-NEXT:    s_mov_b64 s[4:5], s[30:31]
; GISEL-NEXT:    s_mov_b64 s[6:7], exec
; GISEL-NEXT:  .LBB9_1: ; =>This Inner Loop Header: Depth=1
; GISEL-NEXT:    v_readfirstlane_b32 s8, v0
; GISEL-NEXT:    v_readfirstlane_b32 s9, v1
; GISEL-NEXT:    v_cmp_eq_u64_e32 vcc, s[8:9], v[0:1]
; GISEL-NEXT:    s_and_saveexec_b64 s[10:11], vcc
; GISEL-NEXT:    s_swappc_b64 s[30:31], s[8:9]
; GISEL-NEXT:    ; implicit-def: $vgpr0_vgpr1
; GISEL-NEXT:    s_xor_b64 exec, exec, s[10:11]
; GISEL-NEXT:    s_cbranch_execnz .LBB9_1
; GISEL-NEXT:  ; %bb.2:
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    v_readlane_b32 s63, v40, 29
; GISEL-NEXT:    v_readlane_b32 s62, v40, 28
; GISEL-NEXT:    v_readlane_b32 s61, v40, 27
; GISEL-NEXT:    v_readlane_b32 s60, v40, 26
; GISEL-NEXT:    v_readlane_b32 s59, v40, 25
; GISEL-NEXT:    v_readlane_b32 s58, v40, 24
; GISEL-NEXT:    v_readlane_b32 s57, v40, 23
; GISEL-NEXT:    v_readlane_b32 s56, v40, 22
; GISEL-NEXT:    v_readlane_b32 s55, v40, 21
; GISEL-NEXT:    v_readlane_b32 s54, v40, 20
; GISEL-NEXT:    v_readlane_b32 s53, v40, 19
; GISEL-NEXT:    v_readlane_b32 s52, v40, 18
; GISEL-NEXT:    v_readlane_b32 s51, v40, 17
; GISEL-NEXT:    v_readlane_b32 s50, v40, 16
; GISEL-NEXT:    v_readlane_b32 s49, v40, 15
; GISEL-NEXT:    v_readlane_b32 s48, v40, 14
; GISEL-NEXT:    v_readlane_b32 s47, v40, 13
; GISEL-NEXT:    v_readlane_b32 s46, v40, 12
; GISEL-NEXT:    v_readlane_b32 s45, v40, 11
; GISEL-NEXT:    v_readlane_b32 s44, v40, 10
; GISEL-NEXT:    v_readlane_b32 s43, v40, 9
; GISEL-NEXT:    v_readlane_b32 s42, v40, 8
; GISEL-NEXT:    v_readlane_b32 s41, v40, 7
; GISEL-NEXT:    v_readlane_b32 s40, v40, 6
; GISEL-NEXT:    v_readlane_b32 s39, v40, 5
; GISEL-NEXT:    v_readlane_b32 s38, v40, 4
; GISEL-NEXT:    v_readlane_b32 s37, v40, 3
; GISEL-NEXT:    v_readlane_b32 s36, v40, 2
; GISEL-NEXT:    v_readlane_b32 s35, v40, 1
; GISEL-NEXT:    v_readlane_b32 s34, v40, 0
; GISEL-NEXT:    s_addk_i32 s32, 0xfc00
; GISEL-NEXT:    v_readlane_b32 s33, v40, 30
; GISEL-NEXT:    s_or_saveexec_b64 s[6:7], -1
; GISEL-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; GISEL-NEXT:    s_mov_b64 exec, s[6:7]
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[4:5]
  tail call amdgpu_gfx void %fptr()
  ret void
}
