; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv6m-none-eabi -float-abi=soft %s -o - | FileCheck %s --check-prefixes=SOFT
; RUN: llc -mtriple=thumbv7m-none-eabihf -mattr=+vfp2sp %s -o - | FileCheck %s --check-prefixes=VFP,VFP2
; RUN: llc -mtriple=thumbv8.1m.main-none-eabihf -mattr=+fullfp16,+fp64 %s -o - | FileCheck %s --check-prefixes=VFP,FULL

; i32 saturate

define i32 @stest_f64i32(double %x) {
; SOFT-LABEL: stest_f64i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r7, lr}
; SOFT-NEXT:    push {r4, r5, r7, lr}
; SOFT-NEXT:    bl __aeabi_d2lz
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    movs r3, #0
; SOFT-NEXT:    ldr r4, .LCPI0_0
; SOFT-NEXT:    subs r5, r0, r4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    sbcs r5, r3
; SOFT-NEXT:    mov r5, r2
; SOFT-NEXT:    bge .LBB0_7
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB0_8
; SOFT-NEXT:  .LBB0_2: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB0_4
; SOFT-NEXT:  .LBB0_3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB0_4: @ %entry
; SOFT-NEXT:    mvns r3, r3
; SOFT-NEXT:    lsls r2, r2, #31
; SOFT-NEXT:    subs r4, r2, r0
; SOFT-NEXT:    sbcs r3, r1
; SOFT-NEXT:    blt .LBB0_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:  .LBB0_6: @ %entry
; SOFT-NEXT:    pop {r4, r5, r7, pc}
; SOFT-NEXT:  .LBB0_7: @ %entry
; SOFT-NEXT:    mov r5, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB0_2
; SOFT-NEXT:  .LBB0_8: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB0_3
; SOFT-NEXT:    b .LBB0_4
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI0_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f64i32:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2lz
; VFP2-NEXT:    mvn r12, #-2147483648
; VFP2-NEXT:    subs.w r3, r0, r12
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    sbcs r3, r1, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    ite ne
; VFP2-NEXT:    movne r2, r1
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    mov.w r1, #-1
; VFP2-NEXT:    rsbs.w r3, r0, #-2147483648
; VFP2-NEXT:    sbcs r1, r2
; VFP2-NEXT:    it ge
; VFP2-NEXT:    movge.w r0, #-2147483648
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f64i32:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f64 s0, d0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi double %x to i64
  %0 = icmp slt i64 %conv, 2147483647
  %spec.store.select = select i1 %0, i64 %conv, i64 2147483647
  %1 = icmp sgt i64 %spec.store.select, -2147483648
  %spec.store.select7 = select i1 %1, i64 %spec.store.select, i64 -2147483648
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @utest_f64i32(double %x) {
; SOFT-LABEL: utest_f64i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2ulz
; SOFT-NEXT:    movs r2, #0
; SOFT-NEXT:    adds r3, r0, #1
; SOFT-NEXT:    sbcs r1, r2
; SOFT-NEXT:    blo .LBB1_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mvns r0, r2
; SOFT-NEXT:  .LBB1_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
;
; VFP-LABEL: utest_f64i32:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    .save {r7, lr}
; VFP-NEXT:    push {r7, lr}
; VFP-NEXT:    vmov r0, r1, d0
; VFP-NEXT:    bl __aeabi_d2ulz
; VFP-NEXT:    subs.w r2, r0, #-1
; VFP-NEXT:    sbcs r1, r1, #0
; VFP-NEXT:    it hs
; VFP-NEXT:    movhs.w r0, #-1
; VFP-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui double %x to i64
  %0 = icmp ult i64 %conv, 4294967295
  %spec.store.select = select i1 %0, i64 %conv, i64 4294967295
  %conv6 = trunc i64 %spec.store.select to i32
  ret i32 %conv6
}

define i32 @ustest_f64i32(double %x) {
; SOFT-LABEL: ustest_f64i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    bl __aeabi_d2lz
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    movs r3, #0
; SOFT-NEXT:    adds r4, r0, #1
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    sbcs r4, r3
; SOFT-NEXT:    mov r4, r2
; SOFT-NEXT:    bge .LBB2_7
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB2_8
; SOFT-NEXT:  .LBB2_2: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB2_4
; SOFT-NEXT:  .LBB2_3: @ %entry
; SOFT-NEXT:    mvns r0, r3
; SOFT-NEXT:  .LBB2_4: @ %entry
; SOFT-NEXT:    rsbs r4, r0, #0
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    sbcs r4, r1
; SOFT-NEXT:    bge .LBB2_9
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB2_10
; SOFT-NEXT:  .LBB2_6: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:  .LBB2_7: @ %entry
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB2_2
; SOFT-NEXT:  .LBB2_8: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB2_3
; SOFT-NEXT:    b .LBB2_4
; SOFT-NEXT:  .LBB2_9: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB2_6
; SOFT-NEXT:  .LBB2_10: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    pop {r4, pc}
;
; VFP2-LABEL: ustest_f64i32:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2lz
; VFP2-NEXT:    subs.w r3, r0, #-1
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    sbcs r3, r1, #0
; VFP2-NEXT:    mov.w r3, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r3, #1
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    ite ne
; VFP2-NEXT:    movne r3, r1
; VFP2-NEXT:    moveq.w r0, #-1
; VFP2-NEXT:    rsbs r1, r0, #0
; VFP2-NEXT:    sbcs.w r1, r2, r3
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r2
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f64i32:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f64 s0, d0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi double %x to i64
  %0 = icmp slt i64 %conv, 4294967295
  %spec.store.select = select i1 %0, i64 %conv, i64 4294967295
  %1 = icmp sgt i64 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i64 %spec.store.select, i64 0
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @stest_f32i32(float %x) {
; SOFT-LABEL: stest_f32i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r7, lr}
; SOFT-NEXT:    push {r4, r5, r7, lr}
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    movs r3, #0
; SOFT-NEXT:    ldr r4, .LCPI3_0
; SOFT-NEXT:    subs r5, r0, r4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    sbcs r5, r3
; SOFT-NEXT:    mov r5, r2
; SOFT-NEXT:    bge .LBB3_7
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB3_8
; SOFT-NEXT:  .LBB3_2: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB3_4
; SOFT-NEXT:  .LBB3_3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB3_4: @ %entry
; SOFT-NEXT:    mvns r3, r3
; SOFT-NEXT:    lsls r2, r2, #31
; SOFT-NEXT:    subs r4, r2, r0
; SOFT-NEXT:    sbcs r3, r1
; SOFT-NEXT:    blt .LBB3_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:  .LBB3_6: @ %entry
; SOFT-NEXT:    pop {r4, r5, r7, pc}
; SOFT-NEXT:  .LBB3_7: @ %entry
; SOFT-NEXT:    mov r5, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB3_2
; SOFT-NEXT:  .LBB3_8: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB3_3
; SOFT-NEXT:    b .LBB3_4
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI3_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP-LABEL: stest_f32i32:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    vcvt.s32.f32 s0, s0
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    bx lr
entry:
  %conv = fptosi float %x to i64
  %0 = icmp slt i64 %conv, 2147483647
  %spec.store.select = select i1 %0, i64 %conv, i64 2147483647
  %1 = icmp sgt i64 %spec.store.select, -2147483648
  %spec.store.select7 = select i1 %1, i64 %spec.store.select, i64 -2147483648
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @utest_f32i32(float %x) {
; SOFT-LABEL: utest_f32i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2ulz
; SOFT-NEXT:    movs r2, #0
; SOFT-NEXT:    adds r3, r0, #1
; SOFT-NEXT:    sbcs r1, r2
; SOFT-NEXT:    blo .LBB4_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mvns r0, r2
; SOFT-NEXT:  .LBB4_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
;
; VFP-LABEL: utest_f32i32:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    .save {r7, lr}
; VFP-NEXT:    push {r7, lr}
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    bl __aeabi_f2ulz
; VFP-NEXT:    subs.w r2, r0, #-1
; VFP-NEXT:    sbcs r1, r1, #0
; VFP-NEXT:    it hs
; VFP-NEXT:    movhs.w r0, #-1
; VFP-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui float %x to i64
  %0 = icmp ult i64 %conv, 4294967295
  %spec.store.select = select i1 %0, i64 %conv, i64 4294967295
  %conv6 = trunc i64 %spec.store.select to i32
  ret i32 %conv6
}

define i32 @ustest_f32i32(float %x) {
; SOFT-LABEL: ustest_f32i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    movs r3, #0
; SOFT-NEXT:    adds r4, r0, #1
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    sbcs r4, r3
; SOFT-NEXT:    mov r4, r2
; SOFT-NEXT:    bge .LBB5_7
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB5_8
; SOFT-NEXT:  .LBB5_2: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB5_4
; SOFT-NEXT:  .LBB5_3: @ %entry
; SOFT-NEXT:    mvns r0, r3
; SOFT-NEXT:  .LBB5_4: @ %entry
; SOFT-NEXT:    rsbs r4, r0, #0
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    sbcs r4, r1
; SOFT-NEXT:    bge .LBB5_9
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB5_10
; SOFT-NEXT:  .LBB5_6: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:  .LBB5_7: @ %entry
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB5_2
; SOFT-NEXT:  .LBB5_8: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB5_3
; SOFT-NEXT:    b .LBB5_4
; SOFT-NEXT:  .LBB5_9: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB5_6
; SOFT-NEXT:  .LBB5_10: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    pop {r4, pc}
;
; VFP-LABEL: ustest_f32i32:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    vcvt.u32.f32 s0, s0
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    bx lr
entry:
  %conv = fptosi float %x to i64
  %0 = icmp slt i64 %conv, 4294967295
  %spec.store.select = select i1 %0, i64 %conv, i64 4294967295
  %1 = icmp sgt i64 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i64 %spec.store.select, i64 0
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @stest_f16i32(half %x) {
; SOFT-LABEL: stest_f16i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r7, lr}
; SOFT-NEXT:    push {r4, r5, r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    movs r3, #0
; SOFT-NEXT:    ldr r4, .LCPI6_0
; SOFT-NEXT:    subs r5, r0, r4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    sbcs r5, r3
; SOFT-NEXT:    mov r5, r2
; SOFT-NEXT:    bge .LBB6_7
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB6_8
; SOFT-NEXT:  .LBB6_2: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB6_4
; SOFT-NEXT:  .LBB6_3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB6_4: @ %entry
; SOFT-NEXT:    mvns r3, r3
; SOFT-NEXT:    lsls r2, r2, #31
; SOFT-NEXT:    subs r4, r2, r0
; SOFT-NEXT:    sbcs r3, r1
; SOFT-NEXT:    blt .LBB6_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:  .LBB6_6: @ %entry
; SOFT-NEXT:    pop {r4, r5, r7, pc}
; SOFT-NEXT:  .LBB6_7: @ %entry
; SOFT-NEXT:    mov r5, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB6_2
; SOFT-NEXT:  .LBB6_8: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB6_3
; SOFT-NEXT:    b .LBB6_4
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:  .LCPI6_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f16i32:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f16i32:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f16 s0, s0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi half %x to i64
  %0 = icmp slt i64 %conv, 2147483647
  %spec.store.select = select i1 %0, i64 %conv, i64 2147483647
  %1 = icmp sgt i64 %spec.store.select, -2147483648
  %spec.store.select7 = select i1 %1, i64 %spec.store.select, i64 -2147483648
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @utesth_f16i32(half %x) {
; SOFT-LABEL: utesth_f16i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2ulz
; SOFT-NEXT:    movs r2, #0
; SOFT-NEXT:    adds r3, r0, #1
; SOFT-NEXT:    sbcs r1, r2
; SOFT-NEXT:    blo .LBB7_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mvns r0, r2
; SOFT-NEXT:  .LBB7_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
;
; VFP2-LABEL: utesth_f16i32:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    bl __aeabi_f2ulz
; VFP2-NEXT:    subs.w r2, r0, #-1
; VFP2-NEXT:    sbcs r1, r1, #0
; VFP2-NEXT:    it hs
; VFP2-NEXT:    movhs.w r0, #-1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utesth_f16i32:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    vmov.f16 r0, s0
; FULL-NEXT:    vmov s0, r0
; FULL-NEXT:    bl __fixunshfdi
; FULL-NEXT:    subs.w r2, r0, #-1
; FULL-NEXT:    sbcs r1, r1, #0
; FULL-NEXT:    it hs
; FULL-NEXT:    movhs.w r0, #-1
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui half %x to i64
  %0 = icmp ult i64 %conv, 4294967295
  %spec.store.select = select i1 %0, i64 %conv, i64 4294967295
  %conv6 = trunc i64 %spec.store.select to i32
  ret i32 %conv6
}

define i32 @ustest_f16i32(half %x) {
; SOFT-LABEL: ustest_f16i32:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    movs r3, #0
; SOFT-NEXT:    adds r4, r0, #1
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    sbcs r4, r3
; SOFT-NEXT:    mov r4, r2
; SOFT-NEXT:    bge .LBB8_7
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB8_8
; SOFT-NEXT:  .LBB8_2: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB8_4
; SOFT-NEXT:  .LBB8_3: @ %entry
; SOFT-NEXT:    mvns r0, r3
; SOFT-NEXT:  .LBB8_4: @ %entry
; SOFT-NEXT:    rsbs r4, r0, #0
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    sbcs r4, r1
; SOFT-NEXT:    bge .LBB8_9
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB8_10
; SOFT-NEXT:  .LBB8_6: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:  .LBB8_7: @ %entry
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB8_2
; SOFT-NEXT:  .LBB8_8: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB8_3
; SOFT-NEXT:    b .LBB8_4
; SOFT-NEXT:  .LBB8_9: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB8_6
; SOFT-NEXT:  .LBB8_10: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    pop {r4, pc}
;
; VFP2-LABEL: ustest_f16i32:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vcvt.u32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f16i32:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f16 s0, s0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi half %x to i64
  %0 = icmp slt i64 %conv, 4294967295
  %spec.store.select = select i1 %0, i64 %conv, i64 4294967295
  %1 = icmp sgt i64 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i64 %spec.store.select, i64 0
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

; i16 saturate

define i16 @stest_f64i16(double %x) {
; SOFT-LABEL: stest_f64i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    ldr r1, .LCPI9_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB9_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB9_2: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI9_1
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    bgt .LBB9_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB9_4: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI9_0:
; SOFT-NEXT:    .long 32767 @ 0x7fff
; SOFT-NEXT:  .LCPI9_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
;
; VFP2-LABEL: stest_f64i16:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2iz
; VFP2-NEXT:    ssat r0, #16, r0
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f64i16:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f64 s0, d0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    ssat r0, #16, r0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi double %x to i32
  %0 = icmp slt i32 %conv, 32767
  %spec.store.select = select i1 %0, i32 %conv, i32 32767
  %1 = icmp sgt i32 %spec.store.select, -32768
  %spec.store.select7 = select i1 %1, i32 %spec.store.select, i32 -32768
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @utest_f64i16(double %x) {
; SOFT-LABEL: utest_f64i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2uiz
; SOFT-NEXT:    ldr r1, .LCPI10_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blo .LBB10_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB10_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI10_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: utest_f64i16:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2uiz
; VFP2-NEXT:    movw r1, #65535
; VFP2-NEXT:    cmp r0, r1
; VFP2-NEXT:    it hs
; VFP2-NEXT:    movhs r0, r1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utest_f64i16:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f64 s0, d0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lo
; FULL-NEXT:    bx lr
entry:
  %conv = fptoui double %x to i32
  %0 = icmp ult i32 %conv, 65535
  %spec.store.select = select i1 %0, i32 %conv, i32 65535
  %conv6 = trunc i32 %spec.store.select to i16
  ret i16 %conv6
}

define i16 @ustest_f64i16(double %x) {
; SOFT-LABEL: ustest_f64i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    ldr r1, .LCPI11_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB11_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB11_2: @ %entry
; SOFT-NEXT:    asrs r1, r0, #31
; SOFT-NEXT:    bics r0, r1
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI11_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: ustest_f64i16:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2iz
; VFP2-NEXT:    usat r0, #16, r0
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f64i16:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f64 s0, d0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    usat r0, #16, r0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi double %x to i32
  %0 = icmp slt i32 %conv, 65535
  %spec.store.select = select i1 %0, i32 %conv, i32 65535
  %1 = icmp sgt i32 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i32 %spec.store.select, i32 0
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @stest_f32i16(float %x) {
; SOFT-LABEL: stest_f32i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    ldr r1, .LCPI12_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB12_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB12_2: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI12_1
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    bgt .LBB12_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB12_4: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI12_0:
; SOFT-NEXT:    .long 32767 @ 0x7fff
; SOFT-NEXT:  .LCPI12_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
;
; VFP-LABEL: stest_f32i16:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    vcvt.s32.f32 s0, s0
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    ssat r0, #16, r0
; VFP-NEXT:    bx lr
entry:
  %conv = fptosi float %x to i32
  %0 = icmp slt i32 %conv, 32767
  %spec.store.select = select i1 %0, i32 %conv, i32 32767
  %1 = icmp sgt i32 %spec.store.select, -32768
  %spec.store.select7 = select i1 %1, i32 %spec.store.select, i32 -32768
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @utest_f32i16(float %x) {
; SOFT-LABEL: utest_f32i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    ldr r1, .LCPI13_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blo .LBB13_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB13_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI13_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: utest_f32i16:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    vcvt.u32.f32 s0, s0
; VFP2-NEXT:    movw r0, #65535
; VFP2-NEXT:    vmov r1, s0
; VFP2-NEXT:    cmp r1, r0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r0, r1
; VFP2-NEXT:    bx lr
;
; FULL-LABEL: utest_f32i16:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f32 s0, s0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lo
; FULL-NEXT:    bx lr
entry:
  %conv = fptoui float %x to i32
  %0 = icmp ult i32 %conv, 65535
  %spec.store.select = select i1 %0, i32 %conv, i32 65535
  %conv6 = trunc i32 %spec.store.select to i16
  ret i16 %conv6
}

define i16 @ustest_f32i16(float %x) {
; SOFT-LABEL: ustest_f32i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    ldr r1, .LCPI14_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB14_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB14_2: @ %entry
; SOFT-NEXT:    asrs r1, r0, #31
; SOFT-NEXT:    bics r0, r1
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI14_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP-LABEL: ustest_f32i16:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    vcvt.s32.f32 s0, s0
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    usat r0, #16, r0
; VFP-NEXT:    bx lr
entry:
  %conv = fptosi float %x to i32
  %0 = icmp slt i32 %conv, 65535
  %spec.store.select = select i1 %0, i32 %conv, i32 65535
  %1 = icmp sgt i32 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i32 %spec.store.select, i32 0
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @stest_f16i16(half %x) {
; SOFT-LABEL: stest_f16i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    ldr r1, .LCPI15_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB15_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB15_2: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI15_1
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    bgt .LBB15_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB15_4: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI15_0:
; SOFT-NEXT:    .long 32767 @ 0x7fff
; SOFT-NEXT:  .LCPI15_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
;
; VFP2-LABEL: stest_f16i16:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    ssat r0, #16, r0
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f16i16:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f16 s0, s0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    ssat r0, #16, r0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi half %x to i32
  %0 = icmp slt i32 %conv, 32767
  %spec.store.select = select i1 %0, i32 %conv, i32 32767
  %1 = icmp sgt i32 %spec.store.select, -32768
  %spec.store.select7 = select i1 %1, i32 %spec.store.select, i32 -32768
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @utesth_f16i16(half %x) {
; SOFT-LABEL: utesth_f16i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    ldr r1, .LCPI16_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blo .LBB16_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB16_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI16_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: utesth_f16i16:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    movw r0, #65535
; VFP2-NEXT:    vcvt.u32.f32 s0, s0
; VFP2-NEXT:    vmov r1, s0
; VFP2-NEXT:    cmp r1, r0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r0, r1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utesth_f16i16:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f16 s0, s0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lo
; FULL-NEXT:    bx lr
entry:
  %conv = fptoui half %x to i32
  %0 = icmp ult i32 %conv, 65535
  %spec.store.select = select i1 %0, i32 %conv, i32 65535
  %conv6 = trunc i32 %spec.store.select to i16
  ret i16 %conv6
}

define i16 @ustest_f16i16(half %x) {
; SOFT-LABEL: ustest_f16i16:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    ldr r1, .LCPI17_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB17_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB17_2: @ %entry
; SOFT-NEXT:    asrs r1, r0, #31
; SOFT-NEXT:    bics r0, r1
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI17_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: ustest_f16i16:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    usat r0, #16, r0
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f16i16:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f16 s0, s0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    usat r0, #16, r0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi half %x to i32
  %0 = icmp slt i32 %conv, 65535
  %spec.store.select = select i1 %0, i32 %conv, i32 65535
  %1 = icmp sgt i32 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i32 %spec.store.select, i32 0
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

; i64 saturate

define i64 @stest_f64i64(double %x) {
; SOFT-LABEL: stest_f64i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #12
; SOFT-NEXT:    sub sp, #12
; SOFT-NEXT:    bl __fixdfti
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #1
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:    ldr r0, .LCPI18_0
; SOFT-NEXT:    adds r7, r6, #1
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    sbcs r7, r0
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    sbcs r7, r5
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    sbcs r7, r5
; SOFT-NEXT:    mov r7, r4
; SOFT-NEXT:    bge .LBB18_13
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB18_14
; SOFT-NEXT:  .LBB18_2: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB18_4
; SOFT-NEXT:  .LBB18_3: @ %entry
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:  .LBB18_4: @ %entry
; SOFT-NEXT:    str r2, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB18_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:  .LBB18_6: @ %entry
; SOFT-NEXT:    str r3, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    mvns r0, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB18_8
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:  .LBB18_8: @ %entry
; SOFT-NEXT:    lsls r3, r4, #31
; SOFT-NEXT:    rsbs r7, r6, #0
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    sbcs r7, r1
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    sbcs r7, r2
; SOFT-NEXT:    ldr r2, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    sbcs r0, r2
; SOFT-NEXT:    bge .LBB18_15
; SOFT-NEXT:  @ %bb.9: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB18_16
; SOFT-NEXT:  .LBB18_10: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB18_12
; SOFT-NEXT:  .LBB18_11: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:  .LBB18_12: @ %entry
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    add sp, #12
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB18_13: @ %entry
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB18_2
; SOFT-NEXT:  .LBB18_14: @ %entry
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB18_3
; SOFT-NEXT:    b .LBB18_4
; SOFT-NEXT:  .LBB18_15: @ %entry
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB18_10
; SOFT-NEXT:  .LBB18_16: @ %entry
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB18_11
; SOFT-NEXT:    b .LBB18_12
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI18_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f64i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    bl __fixdfti
; VFP2-NEXT:    subs.w r4, r0, #-1
; VFP2-NEXT:    mvn lr, #-2147483648
; VFP2-NEXT:    sbcs.w r4, r1, lr
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs r4, r2, #0
; VFP2-NEXT:    sbcs r4, r3, #0
; VFP2-NEXT:    mov.w r4, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r4, #1
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    itet eq
; VFP2-NEXT:    moveq r3, r4
; VFP2-NEXT:    movne r4, r2
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    mov.w r2, #-1
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r2
; VFP2-NEXT:    rsbs r5, r0, #0
; VFP2-NEXT:    mov.w lr, #-2147483648
; VFP2-NEXT:    sbcs.w r5, lr, r1
; VFP2-NEXT:    sbcs.w r4, r2, r4
; VFP2-NEXT:    sbcs r2, r3
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    pop {r4, r5, r7, pc}
;
; FULL-LABEL: stest_f64i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, r5, r7, lr}
; FULL-NEXT:    push {r4, r5, r7, lr}
; FULL-NEXT:    bl __fixdfti
; FULL-NEXT:    subs.w lr, r0, #-1
; FULL-NEXT:    mvn r12, #-2147483648
; FULL-NEXT:    sbcs.w lr, r1, r12
; FULL-NEXT:    sbcs lr, r2, #0
; FULL-NEXT:    sbcs lr, r3, #0
; FULL-NEXT:    cset lr, lt
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r5, r3, lr, ne
; FULL-NEXT:    mov.w r3, #-1
; FULL-NEXT:    csel r0, r0, r3, ne
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    csel r2, r2, lr, ne
; FULL-NEXT:    rsbs r4, r0, #0
; FULL-NEXT:    mov.w r12, #-2147483648
; FULL-NEXT:    sbcs.w r4, r12, r1
; FULL-NEXT:    sbcs.w r2, r3, r2
; FULL-NEXT:    sbcs.w r2, r3, r5
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    it eq
; FULL-NEXT:    moveq r0, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    pop {r4, r5, r7, pc}
entry:
  %conv = fptosi double %x to i128
  %0 = icmp slt i128 %conv, 9223372036854775807
  %spec.store.select = select i1 %0, i128 %conv, i128 9223372036854775807
  %1 = icmp sgt i128 %spec.store.select, -9223372036854775808
  %spec.store.select7 = select i1 %1, i128 %spec.store.select, i128 -9223372036854775808
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @utest_f64i64(double %x) {
; SOFT-LABEL: utest_f64i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    bl __fixunsdfti
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    subs r2, r2, #1
; SOFT-NEXT:    sbcs r3, r4
; SOFT-NEXT:    blo .LBB19_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB19_3
; SOFT-NEXT:    b .LBB19_4
; SOFT-NEXT:  .LBB19_2:
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB19_4
; SOFT-NEXT:  .LBB19_3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB19_4: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB19_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:  .LBB19_6: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    pop {r4, pc}
;
; VFP2-LABEL: utest_f64i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __fixunsdfti
; VFP2-NEXT:    subs r2, #1
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs r2, r3, #0
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r2, #1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utest_f64i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    bl __fixunsdfti
; FULL-NEXT:    subs r2, #1
; FULL-NEXT:    sbcs r2, r3, #0
; FULL-NEXT:    mov.w r3, #0
; FULL-NEXT:    cset r2, lo
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r3, ne
; FULL-NEXT:    csel r1, r1, r3, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui double %x to i128
  %0 = icmp ult i128 %conv, 18446744073709551616
  %spec.store.select = select i1 %0, i128 %conv, i128 18446744073709551616
  %conv6 = trunc i128 %spec.store.select to i64
  ret i64 %conv6
}

define i64 @ustest_f64i64(double %x) {
; SOFT-LABEL: ustest_f64i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    bl __fixdfti
; SOFT-NEXT:    movs r4, #1
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:    subs r6, r2, #1
; SOFT-NEXT:    mov r6, r3
; SOFT-NEXT:    sbcs r6, r5
; SOFT-NEXT:    mov r6, r4
; SOFT-NEXT:    bge .LBB20_10
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB20_11
; SOFT-NEXT:  .LBB20_2: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB20_12
; SOFT-NEXT:  .LBB20_3: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB20_13
; SOFT-NEXT:  .LBB20_4: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB20_6
; SOFT-NEXT:  .LBB20_5: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB20_6: @ %entry
; SOFT-NEXT:    rsbs r6, r0, #0
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    sbcs r6, r1
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    sbcs r6, r2
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    sbcs r2, r3
; SOFT-NEXT:    bge .LBB20_14
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB20_15
; SOFT-NEXT:  .LBB20_8: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB20_16
; SOFT-NEXT:  .LBB20_9: @ %entry
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB20_10: @ %entry
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB20_2
; SOFT-NEXT:  .LBB20_11: @ %entry
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB20_3
; SOFT-NEXT:  .LBB20_12: @ %entry
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB20_4
; SOFT-NEXT:  .LBB20_13: @ %entry
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB20_5
; SOFT-NEXT:    b .LBB20_6
; SOFT-NEXT:  .LBB20_14: @ %entry
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB20_8
; SOFT-NEXT:  .LBB20_15: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB20_9
; SOFT-NEXT:  .LBB20_16: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    pop {r4, r5, r6, pc}
;
; VFP2-LABEL: ustest_f64i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __fixdfti
; VFP2-NEXT:    subs.w lr, r2, #1
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs lr, r3, #0
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w lr, #1
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    itttt eq
; VFP2-NEXT:    moveq r3, r12
; VFP2-NEXT:    moveq r2, #1
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    rsbs.w lr, r0, #0
; VFP2-NEXT:    sbcs.w lr, r12, r1
; VFP2-NEXT:    sbcs.w r2, r12, r2
; VFP2-NEXT:    sbcs.w r2, r12, r3
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r12, #1
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f64i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    bl __fixdfti
; FULL-NEXT:    subs.w r12, r2, #1
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    sbcs r12, r3, #0
; FULL-NEXT:    cset r12, lt
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    it eq
; FULL-NEXT:    moveq r2, #1
; FULL-NEXT:    csel r0, r0, lr, ne
; FULL-NEXT:    csel r12, r3, lr, ne
; FULL-NEXT:    csel r1, r1, lr, ne
; FULL-NEXT:    rsbs r3, r0, #0
; FULL-NEXT:    sbcs.w r3, lr, r1
; FULL-NEXT:    sbcs.w r2, lr, r2
; FULL-NEXT:    sbcs.w r2, lr, r12
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r2, ne
; FULL-NEXT:    csel r1, r1, r2, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptosi double %x to i128
  %0 = icmp slt i128 %conv, 18446744073709551616
  %spec.store.select = select i1 %0, i128 %conv, i128 18446744073709551616
  %1 = icmp sgt i128 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i128 %spec.store.select, i128 0
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @stest_f32i64(float %x) {
; SOFT-LABEL: stest_f32i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #12
; SOFT-NEXT:    sub sp, #12
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #1
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:    ldr r0, .LCPI21_0
; SOFT-NEXT:    adds r7, r6, #1
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    sbcs r7, r0
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    sbcs r7, r5
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    sbcs r7, r5
; SOFT-NEXT:    mov r7, r4
; SOFT-NEXT:    bge .LBB21_13
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB21_14
; SOFT-NEXT:  .LBB21_2: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB21_4
; SOFT-NEXT:  .LBB21_3: @ %entry
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:  .LBB21_4: @ %entry
; SOFT-NEXT:    str r2, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB21_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:  .LBB21_6: @ %entry
; SOFT-NEXT:    str r3, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    mvns r0, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB21_8
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:  .LBB21_8: @ %entry
; SOFT-NEXT:    lsls r3, r4, #31
; SOFT-NEXT:    rsbs r7, r6, #0
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    sbcs r7, r1
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    sbcs r7, r2
; SOFT-NEXT:    ldr r2, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    sbcs r0, r2
; SOFT-NEXT:    bge .LBB21_15
; SOFT-NEXT:  @ %bb.9: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB21_16
; SOFT-NEXT:  .LBB21_10: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB21_12
; SOFT-NEXT:  .LBB21_11: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:  .LBB21_12: @ %entry
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    add sp, #12
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB21_13: @ %entry
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB21_2
; SOFT-NEXT:  .LBB21_14: @ %entry
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB21_3
; SOFT-NEXT:    b .LBB21_4
; SOFT-NEXT:  .LBB21_15: @ %entry
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB21_10
; SOFT-NEXT:  .LBB21_16: @ %entry
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB21_11
; SOFT-NEXT:    b .LBB21_12
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI21_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f32i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    subs.w r4, r0, #-1
; VFP2-NEXT:    mvn lr, #-2147483648
; VFP2-NEXT:    sbcs.w r4, r1, lr
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs r4, r2, #0
; VFP2-NEXT:    sbcs r4, r3, #0
; VFP2-NEXT:    mov.w r4, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r4, #1
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    itet eq
; VFP2-NEXT:    moveq r3, r4
; VFP2-NEXT:    movne r4, r2
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    mov.w r2, #-1
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r2
; VFP2-NEXT:    rsbs r5, r0, #0
; VFP2-NEXT:    mov.w lr, #-2147483648
; VFP2-NEXT:    sbcs.w r5, lr, r1
; VFP2-NEXT:    sbcs.w r4, r2, r4
; VFP2-NEXT:    sbcs r2, r3
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    pop {r4, r5, r7, pc}
;
; FULL-LABEL: stest_f32i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, r5, r7, lr}
; FULL-NEXT:    push {r4, r5, r7, lr}
; FULL-NEXT:    bl __fixsfti
; FULL-NEXT:    subs.w lr, r0, #-1
; FULL-NEXT:    mvn r12, #-2147483648
; FULL-NEXT:    sbcs.w lr, r1, r12
; FULL-NEXT:    sbcs lr, r2, #0
; FULL-NEXT:    sbcs lr, r3, #0
; FULL-NEXT:    cset lr, lt
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r5, r3, lr, ne
; FULL-NEXT:    mov.w r3, #-1
; FULL-NEXT:    csel r0, r0, r3, ne
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    csel r2, r2, lr, ne
; FULL-NEXT:    rsbs r4, r0, #0
; FULL-NEXT:    mov.w r12, #-2147483648
; FULL-NEXT:    sbcs.w r4, r12, r1
; FULL-NEXT:    sbcs.w r2, r3, r2
; FULL-NEXT:    sbcs.w r2, r3, r5
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    it eq
; FULL-NEXT:    moveq r0, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    pop {r4, r5, r7, pc}
entry:
  %conv = fptosi float %x to i128
  %0 = icmp slt i128 %conv, 9223372036854775807
  %spec.store.select = select i1 %0, i128 %conv, i128 9223372036854775807
  %1 = icmp sgt i128 %spec.store.select, -9223372036854775808
  %spec.store.select7 = select i1 %1, i128 %spec.store.select, i128 -9223372036854775808
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @utest_f32i64(float %x) {
; SOFT-LABEL: utest_f32i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    bl __fixunssfti
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    subs r2, r2, #1
; SOFT-NEXT:    sbcs r3, r4
; SOFT-NEXT:    blo .LBB22_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB22_3
; SOFT-NEXT:    b .LBB22_4
; SOFT-NEXT:  .LBB22_2:
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB22_4
; SOFT-NEXT:  .LBB22_3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB22_4: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB22_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:  .LBB22_6: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    pop {r4, pc}
;
; VFP2-LABEL: utest_f32i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __fixunssfti
; VFP2-NEXT:    subs r2, #1
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs r2, r3, #0
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r2, #1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utest_f32i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    bl __fixunssfti
; FULL-NEXT:    subs r2, #1
; FULL-NEXT:    sbcs r2, r3, #0
; FULL-NEXT:    mov.w r3, #0
; FULL-NEXT:    cset r2, lo
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r3, ne
; FULL-NEXT:    csel r1, r1, r3, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui float %x to i128
  %0 = icmp ult i128 %conv, 18446744073709551616
  %spec.store.select = select i1 %0, i128 %conv, i128 18446744073709551616
  %conv6 = trunc i128 %spec.store.select to i64
  ret i64 %conv6
}

define i64 @ustest_f32i64(float %x) {
; SOFT-LABEL: ustest_f32i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    movs r4, #1
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:    subs r6, r2, #1
; SOFT-NEXT:    mov r6, r3
; SOFT-NEXT:    sbcs r6, r5
; SOFT-NEXT:    mov r6, r4
; SOFT-NEXT:    bge .LBB23_10
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB23_11
; SOFT-NEXT:  .LBB23_2: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB23_12
; SOFT-NEXT:  .LBB23_3: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB23_13
; SOFT-NEXT:  .LBB23_4: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB23_6
; SOFT-NEXT:  .LBB23_5: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB23_6: @ %entry
; SOFT-NEXT:    rsbs r6, r0, #0
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    sbcs r6, r1
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    sbcs r6, r2
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    sbcs r2, r3
; SOFT-NEXT:    bge .LBB23_14
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB23_15
; SOFT-NEXT:  .LBB23_8: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB23_16
; SOFT-NEXT:  .LBB23_9: @ %entry
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB23_10: @ %entry
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB23_2
; SOFT-NEXT:  .LBB23_11: @ %entry
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB23_3
; SOFT-NEXT:  .LBB23_12: @ %entry
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB23_4
; SOFT-NEXT:  .LBB23_13: @ %entry
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB23_5
; SOFT-NEXT:    b .LBB23_6
; SOFT-NEXT:  .LBB23_14: @ %entry
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB23_8
; SOFT-NEXT:  .LBB23_15: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB23_9
; SOFT-NEXT:  .LBB23_16: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    pop {r4, r5, r6, pc}
;
; VFP2-LABEL: ustest_f32i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    subs.w lr, r2, #1
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs lr, r3, #0
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w lr, #1
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    itttt eq
; VFP2-NEXT:    moveq r3, r12
; VFP2-NEXT:    moveq r2, #1
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    rsbs.w lr, r0, #0
; VFP2-NEXT:    sbcs.w lr, r12, r1
; VFP2-NEXT:    sbcs.w r2, r12, r2
; VFP2-NEXT:    sbcs.w r2, r12, r3
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r12, #1
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f32i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    bl __fixsfti
; FULL-NEXT:    subs.w r12, r2, #1
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    sbcs r12, r3, #0
; FULL-NEXT:    cset r12, lt
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    it eq
; FULL-NEXT:    moveq r2, #1
; FULL-NEXT:    csel r0, r0, lr, ne
; FULL-NEXT:    csel r12, r3, lr, ne
; FULL-NEXT:    csel r1, r1, lr, ne
; FULL-NEXT:    rsbs r3, r0, #0
; FULL-NEXT:    sbcs.w r3, lr, r1
; FULL-NEXT:    sbcs.w r2, lr, r2
; FULL-NEXT:    sbcs.w r2, lr, r12
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r2, ne
; FULL-NEXT:    csel r1, r1, r2, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptosi float %x to i128
  %0 = icmp slt i128 %conv, 18446744073709551616
  %spec.store.select = select i1 %0, i128 %conv, i128 18446744073709551616
  %1 = icmp sgt i128 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i128 %spec.store.select, i128 0
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @stest_f16i64(half %x) {
; SOFT-LABEL: stest_f16i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #12
; SOFT-NEXT:    sub sp, #12
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #1
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:    ldr r0, .LCPI24_0
; SOFT-NEXT:    adds r7, r6, #1
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    sbcs r7, r0
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    sbcs r7, r5
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    sbcs r7, r5
; SOFT-NEXT:    mov r7, r4
; SOFT-NEXT:    bge .LBB24_13
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB24_14
; SOFT-NEXT:  .LBB24_2: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB24_4
; SOFT-NEXT:  .LBB24_3: @ %entry
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:  .LBB24_4: @ %entry
; SOFT-NEXT:    str r2, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB24_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:  .LBB24_6: @ %entry
; SOFT-NEXT:    str r3, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    mvns r0, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB24_8
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:  .LBB24_8: @ %entry
; SOFT-NEXT:    lsls r3, r4, #31
; SOFT-NEXT:    rsbs r7, r6, #0
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    sbcs r7, r1
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    sbcs r7, r2
; SOFT-NEXT:    ldr r2, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    sbcs r0, r2
; SOFT-NEXT:    bge .LBB24_15
; SOFT-NEXT:  @ %bb.9: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB24_16
; SOFT-NEXT:  .LBB24_10: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB24_12
; SOFT-NEXT:  .LBB24_11: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:  .LBB24_12: @ %entry
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    add sp, #12
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB24_13: @ %entry
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB24_2
; SOFT-NEXT:  .LBB24_14: @ %entry
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB24_3
; SOFT-NEXT:    b .LBB24_4
; SOFT-NEXT:  .LBB24_15: @ %entry
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB24_10
; SOFT-NEXT:  .LBB24_16: @ %entry
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB24_11
; SOFT-NEXT:    b .LBB24_12
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.17:
; SOFT-NEXT:  .LCPI24_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f16i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    subs.w r4, r0, #-1
; VFP2-NEXT:    mvn lr, #-2147483648
; VFP2-NEXT:    sbcs.w r4, r1, lr
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs r4, r2, #0
; VFP2-NEXT:    sbcs r4, r3, #0
; VFP2-NEXT:    mov.w r4, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r4, #1
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    itet eq
; VFP2-NEXT:    moveq r3, r4
; VFP2-NEXT:    movne r4, r2
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    mov.w r2, #-1
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r2
; VFP2-NEXT:    rsbs r5, r0, #0
; VFP2-NEXT:    mov.w lr, #-2147483648
; VFP2-NEXT:    sbcs.w r5, lr, r1
; VFP2-NEXT:    sbcs.w r4, r2, r4
; VFP2-NEXT:    sbcs r2, r3
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r2, #1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    pop {r4, r5, r7, pc}
;
; FULL-LABEL: stest_f16i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, r5, r7, lr}
; FULL-NEXT:    push {r4, r5, r7, lr}
; FULL-NEXT:    vmov.f16 r0, s0
; FULL-NEXT:    vmov s0, r0
; FULL-NEXT:    bl __fixhfti
; FULL-NEXT:    subs.w lr, r0, #-1
; FULL-NEXT:    mvn r12, #-2147483648
; FULL-NEXT:    sbcs.w lr, r1, r12
; FULL-NEXT:    sbcs lr, r2, #0
; FULL-NEXT:    sbcs lr, r3, #0
; FULL-NEXT:    cset lr, lt
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r5, r3, lr, ne
; FULL-NEXT:    mov.w r3, #-1
; FULL-NEXT:    csel r0, r0, r3, ne
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    csel r2, r2, lr, ne
; FULL-NEXT:    rsbs r4, r0, #0
; FULL-NEXT:    mov.w r12, #-2147483648
; FULL-NEXT:    sbcs.w r4, r12, r1
; FULL-NEXT:    sbcs.w r2, r3, r2
; FULL-NEXT:    sbcs.w r2, r3, r5
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    it eq
; FULL-NEXT:    moveq r0, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    pop {r4, r5, r7, pc}
entry:
  %conv = fptosi half %x to i128
  %0 = icmp slt i128 %conv, 9223372036854775807
  %spec.store.select = select i1 %0, i128 %conv, i128 9223372036854775807
  %1 = icmp sgt i128 %spec.store.select, -9223372036854775808
  %spec.store.select7 = select i1 %1, i128 %spec.store.select, i128 -9223372036854775808
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @utesth_f16i64(half %x) {
; SOFT-LABEL: utesth_f16i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __fixunssfti
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    subs r2, r2, #1
; SOFT-NEXT:    sbcs r3, r4
; SOFT-NEXT:    blo .LBB25_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB25_3
; SOFT-NEXT:    b .LBB25_4
; SOFT-NEXT:  .LBB25_2:
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB25_4
; SOFT-NEXT:  .LBB25_3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB25_4: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB25_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:  .LBB25_6: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    pop {r4, pc}
;
; VFP2-LABEL: utesth_f16i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    bl __fixunssfti
; VFP2-NEXT:    subs r2, #1
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs r2, r3, #0
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r2, #1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utesth_f16i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    vmov.f16 r0, s0
; FULL-NEXT:    vmov s0, r0
; FULL-NEXT:    bl __fixunshfti
; FULL-NEXT:    subs r2, #1
; FULL-NEXT:    sbcs r2, r3, #0
; FULL-NEXT:    mov.w r3, #0
; FULL-NEXT:    cset r2, lo
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r3, ne
; FULL-NEXT:    csel r1, r1, r3, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui half %x to i128
  %0 = icmp ult i128 %conv, 18446744073709551616
  %spec.store.select = select i1 %0, i128 %conv, i128 18446744073709551616
  %conv6 = trunc i128 %spec.store.select to i64
  ret i64 %conv6
}

define i64 @ustest_f16i64(half %x) {
; SOFT-LABEL: ustest_f16i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    movs r4, #1
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:    subs r6, r2, #1
; SOFT-NEXT:    mov r6, r3
; SOFT-NEXT:    sbcs r6, r5
; SOFT-NEXT:    mov r6, r4
; SOFT-NEXT:    bge .LBB26_10
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB26_11
; SOFT-NEXT:  .LBB26_2: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB26_12
; SOFT-NEXT:  .LBB26_3: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB26_13
; SOFT-NEXT:  .LBB26_4: @ %entry
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB26_6
; SOFT-NEXT:  .LBB26_5: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB26_6: @ %entry
; SOFT-NEXT:    rsbs r6, r0, #0
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    sbcs r6, r1
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    sbcs r6, r2
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    sbcs r2, r3
; SOFT-NEXT:    bge .LBB26_14
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB26_15
; SOFT-NEXT:  .LBB26_8: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB26_16
; SOFT-NEXT:  .LBB26_9: @ %entry
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB26_10: @ %entry
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB26_2
; SOFT-NEXT:  .LBB26_11: @ %entry
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB26_3
; SOFT-NEXT:  .LBB26_12: @ %entry
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB26_4
; SOFT-NEXT:  .LBB26_13: @ %entry
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB26_5
; SOFT-NEXT:    b .LBB26_6
; SOFT-NEXT:  .LBB26_14: @ %entry
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB26_8
; SOFT-NEXT:  .LBB26_15: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB26_9
; SOFT-NEXT:  .LBB26_16: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    pop {r4, r5, r6, pc}
;
; VFP2-LABEL: ustest_f16i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    subs.w lr, r2, #1
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    sbcs lr, r3, #0
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w lr, #1
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    itttt eq
; VFP2-NEXT:    moveq r3, r12
; VFP2-NEXT:    moveq r2, #1
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    rsbs.w lr, r0, #0
; VFP2-NEXT:    sbcs.w lr, r12, r1
; VFP2-NEXT:    sbcs.w r2, r12, r2
; VFP2-NEXT:    sbcs.w r2, r12, r3
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r12, #1
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    itt eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f16i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    vmov.f16 r0, s0
; FULL-NEXT:    vmov s0, r0
; FULL-NEXT:    bl __fixhfti
; FULL-NEXT:    subs.w r12, r2, #1
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    sbcs r12, r3, #0
; FULL-NEXT:    cset r12, lt
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    it eq
; FULL-NEXT:    moveq r2, #1
; FULL-NEXT:    csel r0, r0, lr, ne
; FULL-NEXT:    csel r12, r3, lr, ne
; FULL-NEXT:    csel r1, r1, lr, ne
; FULL-NEXT:    rsbs r3, r0, #0
; FULL-NEXT:    sbcs.w r3, lr, r1
; FULL-NEXT:    sbcs.w r2, lr, r2
; FULL-NEXT:    sbcs.w r2, lr, r12
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r2, ne
; FULL-NEXT:    csel r1, r1, r2, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptosi half %x to i128
  %0 = icmp slt i128 %conv, 18446744073709551616
  %spec.store.select = select i1 %0, i128 %conv, i128 18446744073709551616
  %1 = icmp sgt i128 %spec.store.select, 0
  %spec.store.select7 = select i1 %1, i128 %spec.store.select, i128 0
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}




; i32 saturate

define i32 @stest_f64i32_mm(double %x) {
; SOFT-LABEL: stest_f64i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2lz
; SOFT-NEXT:    mov r2, r0
; SOFT-NEXT:    ldr r3, .LCPI27_0
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bhs .LBB27_9
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bpl .LBB27_10
; SOFT-NEXT:  .LBB27_2: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bne .LBB27_11
; SOFT-NEXT:  .LBB27_3: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bmi .LBB27_5
; SOFT-NEXT:  .LBB27_4: @ %entry
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:  .LBB27_5: @ %entry
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    lsls r3, r2, #31
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r2, r0
; SOFT-NEXT:    blt .LBB27_12
; SOFT-NEXT:  @ %bb.6: @ %entry
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bls .LBB27_13
; SOFT-NEXT:  .LBB27_7: @ %entry
; SOFT-NEXT:    adds r1, r1, #1
; SOFT-NEXT:    bne .LBB27_14
; SOFT-NEXT:  .LBB27_8: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:  .LBB27_9: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bmi .LBB27_2
; SOFT-NEXT:  .LBB27_10: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB27_3
; SOFT-NEXT:  .LBB27_11: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bpl .LBB27_4
; SOFT-NEXT:    b .LBB27_5
; SOFT-NEXT:  .LBB27_12: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bhi .LBB27_7
; SOFT-NEXT:  .LBB27_13: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    adds r1, r1, #1
; SOFT-NEXT:    beq .LBB27_8
; SOFT-NEXT:  .LBB27_14: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.15:
; SOFT-NEXT:  .LCPI27_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f64i32_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2lz
; VFP2-NEXT:    mvn r2, #-2147483648
; VFP2-NEXT:    cmp r0, r2
; VFP2-NEXT:    mvn r3, #-2147483648
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r3, r0
; VFP2-NEXT:    cmp r1, #0
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r0, r2
; VFP2-NEXT:    mov.w r2, #-2147483648
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r3
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r1, #0
; VFP2-NEXT:    cmp.w r1, #-1
; VFP2-NEXT:    mov.w r3, #-2147483648
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r3, r0
; VFP2-NEXT:    cmp.w r0, #-2147483648
; VFP2-NEXT:    it ls
; VFP2-NEXT:    movls r0, r2
; VFP2-NEXT:    adds r1, #1
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r0, r3
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f64i32_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f64 s0, d0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi double %x to i64
  %spec.store.select = call i64 @llvm.smin.i64(i64 %conv, i64 2147483647)
  %spec.store.select7 = call i64 @llvm.smax.i64(i64 %spec.store.select, i64 -2147483648)
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @utest_f64i32_mm(double %x) {
; SOFT-LABEL: utest_f64i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2ulz
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB28_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    movs r0, #0
; SOFT-NEXT:    mvns r0, r0
; SOFT-NEXT:  .LBB28_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
;
; VFP-LABEL: utest_f64i32_mm:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    .save {r7, lr}
; VFP-NEXT:    push {r7, lr}
; VFP-NEXT:    vmov r0, r1, d0
; VFP-NEXT:    bl __aeabi_d2ulz
; VFP-NEXT:    cmp r1, #0
; VFP-NEXT:    it ne
; VFP-NEXT:    movne.w r0, #-1
; VFP-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui double %x to i64
  %spec.store.select = call i64 @llvm.umin.i64(i64 %conv, i64 4294967295)
  %conv6 = trunc i64 %spec.store.select to i32
  ret i32 %conv6
}

define i32 @ustest_f64i32_mm(double %x) {
; SOFT-LABEL: ustest_f64i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2lz
; SOFT-NEXT:    movs r2, #0
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r3, r0
; SOFT-NEXT:    bpl .LBB29_7
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bne .LBB29_8
; SOFT-NEXT:  .LBB29_2: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bmi .LBB29_4
; SOFT-NEXT:  .LBB29_3: @ %entry
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:  .LBB29_4: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r3, r0
; SOFT-NEXT:    ble .LBB29_9
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bne .LBB29_10
; SOFT-NEXT:  .LBB29_6: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:  .LBB29_7: @ %entry
; SOFT-NEXT:    mvns r3, r2
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB29_2
; SOFT-NEXT:  .LBB29_8: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bpl .LBB29_3
; SOFT-NEXT:    b .LBB29_4
; SOFT-NEXT:  .LBB29_9: @ %entry
; SOFT-NEXT:    mov r3, r2
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB29_6
; SOFT-NEXT:  .LBB29_10: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    pop {r7, pc}
;
; VFP2-LABEL: ustest_f64i32_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2lz
; VFP2-NEXT:    mov r2, r0
; VFP2-NEXT:    cmp r1, #0
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl.w r2, #-1
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r0, r2
; VFP2-NEXT:    mov.w r2, #0
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r1, r2
; VFP2-NEXT:    cmp r1, #0
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r2, r0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r0, r2
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f64i32_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f64 s0, d0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi double %x to i64
  %spec.store.select = call i64 @llvm.smin.i64(i64 %conv, i64 4294967295)
  %spec.store.select7 = call i64 @llvm.smax.i64(i64 %spec.store.select, i64 0)
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @stest_f32i32_mm(float %x) {
; SOFT-LABEL: stest_f32i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    mov r2, r0
; SOFT-NEXT:    ldr r3, .LCPI30_0
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bhs .LBB30_9
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bpl .LBB30_10
; SOFT-NEXT:  .LBB30_2: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bne .LBB30_11
; SOFT-NEXT:  .LBB30_3: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bmi .LBB30_5
; SOFT-NEXT:  .LBB30_4: @ %entry
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:  .LBB30_5: @ %entry
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    lsls r3, r2, #31
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r2, r0
; SOFT-NEXT:    blt .LBB30_12
; SOFT-NEXT:  @ %bb.6: @ %entry
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bls .LBB30_13
; SOFT-NEXT:  .LBB30_7: @ %entry
; SOFT-NEXT:    adds r1, r1, #1
; SOFT-NEXT:    bne .LBB30_14
; SOFT-NEXT:  .LBB30_8: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:  .LBB30_9: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bmi .LBB30_2
; SOFT-NEXT:  .LBB30_10: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB30_3
; SOFT-NEXT:  .LBB30_11: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bpl .LBB30_4
; SOFT-NEXT:    b .LBB30_5
; SOFT-NEXT:  .LBB30_12: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bhi .LBB30_7
; SOFT-NEXT:  .LBB30_13: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    adds r1, r1, #1
; SOFT-NEXT:    beq .LBB30_8
; SOFT-NEXT:  .LBB30_14: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.15:
; SOFT-NEXT:  .LCPI30_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP-LABEL: stest_f32i32_mm:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    vcvt.s32.f32 s0, s0
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    bx lr
entry:
  %conv = fptosi float %x to i64
  %spec.store.select = call i64 @llvm.smin.i64(i64 %conv, i64 2147483647)
  %spec.store.select7 = call i64 @llvm.smax.i64(i64 %spec.store.select, i64 -2147483648)
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @utest_f32i32_mm(float %x) {
; SOFT-LABEL: utest_f32i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2ulz
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB31_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    movs r0, #0
; SOFT-NEXT:    mvns r0, r0
; SOFT-NEXT:  .LBB31_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
;
; VFP-LABEL: utest_f32i32_mm:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    .save {r7, lr}
; VFP-NEXT:    push {r7, lr}
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    bl __aeabi_f2ulz
; VFP-NEXT:    cmp r1, #0
; VFP-NEXT:    it ne
; VFP-NEXT:    movne.w r0, #-1
; VFP-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui float %x to i64
  %spec.store.select = call i64 @llvm.umin.i64(i64 %conv, i64 4294967295)
  %conv6 = trunc i64 %spec.store.select to i32
  ret i32 %conv6
}

define i32 @ustest_f32i32_mm(float %x) {
; SOFT-LABEL: ustest_f32i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r2, #0
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r3, r1
; SOFT-NEXT:    bmi .LBB32_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r3, r2
; SOFT-NEXT:  .LBB32_2: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bmi .LBB32_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mvns r4, r2
; SOFT-NEXT:  .LBB32_4: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB32_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB32_6: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:    ble .LBB32_9
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bne .LBB32_10
; SOFT-NEXT:  .LBB32_8: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:  .LBB32_9: @ %entry
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    beq .LBB32_8
; SOFT-NEXT:  .LBB32_10: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:    pop {r4, pc}
;
; VFP-LABEL: ustest_f32i32_mm:
; VFP:       @ %bb.0: @ %entry
; VFP-NEXT:    vcvt.u32.f32 s0, s0
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    bx lr
entry:
  %conv = fptosi float %x to i64
  %spec.store.select = call i64 @llvm.smin.i64(i64 %conv, i64 4294967295)
  %spec.store.select7 = call i64 @llvm.smax.i64(i64 %spec.store.select, i64 0)
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @stest_f16i32_mm(half %x) {
; SOFT-LABEL: stest_f16i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    mov r2, r0
; SOFT-NEXT:    ldr r3, .LCPI33_0
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bhs .LBB33_9
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bpl .LBB33_10
; SOFT-NEXT:  .LBB33_2: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bne .LBB33_11
; SOFT-NEXT:  .LBB33_3: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bmi .LBB33_5
; SOFT-NEXT:  .LBB33_4: @ %entry
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:  .LBB33_5: @ %entry
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    lsls r3, r2, #31
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r2, r0
; SOFT-NEXT:    blt .LBB33_12
; SOFT-NEXT:  @ %bb.6: @ %entry
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bls .LBB33_13
; SOFT-NEXT:  .LBB33_7: @ %entry
; SOFT-NEXT:    adds r1, r1, #1
; SOFT-NEXT:    bne .LBB33_14
; SOFT-NEXT:  .LBB33_8: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:  .LBB33_9: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bmi .LBB33_2
; SOFT-NEXT:  .LBB33_10: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB33_3
; SOFT-NEXT:  .LBB33_11: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    bpl .LBB33_4
; SOFT-NEXT:    b .LBB33_5
; SOFT-NEXT:  .LBB33_12: @ %entry
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    cmp r0, r3
; SOFT-NEXT:    bhi .LBB33_7
; SOFT-NEXT:  .LBB33_13: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:    adds r1, r1, #1
; SOFT-NEXT:    beq .LBB33_8
; SOFT-NEXT:  .LBB33_14: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.15:
; SOFT-NEXT:  .LCPI33_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f16i32_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f16i32_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f16 s0, s0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi half %x to i64
  %spec.store.select = call i64 @llvm.smin.i64(i64 %conv, i64 2147483647)
  %spec.store.select7 = call i64 @llvm.smax.i64(i64 %spec.store.select, i64 -2147483648)
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

define i32 @utesth_f16i32_mm(half %x) {
; SOFT-LABEL: utesth_f16i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2ulz
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB34_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    movs r0, #0
; SOFT-NEXT:    mvns r0, r0
; SOFT-NEXT:  .LBB34_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
;
; VFP2-LABEL: utesth_f16i32_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    bl __aeabi_f2ulz
; VFP2-NEXT:    cmp r1, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne.w r0, #-1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utesth_f16i32_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    vmov.f16 r0, s0
; FULL-NEXT:    vmov s0, r0
; FULL-NEXT:    bl __fixunshfdi
; FULL-NEXT:    cmp r1, #0
; FULL-NEXT:    it ne
; FULL-NEXT:    movne.w r0, #-1
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui half %x to i64
  %spec.store.select = call i64 @llvm.umin.i64(i64 %conv, i64 4294967295)
  %conv6 = trunc i64 %spec.store.select to i32
  ret i32 %conv6
}

define i32 @ustest_f16i32_mm(half %x) {
; SOFT-LABEL: ustest_f16i32_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r2, #0
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r3, r1
; SOFT-NEXT:    bmi .LBB35_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r3, r2
; SOFT-NEXT:  .LBB35_2: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    bmi .LBB35_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mvns r4, r2
; SOFT-NEXT:  .LBB35_4: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    beq .LBB35_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB35_6: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:    ble .LBB35_9
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bne .LBB35_10
; SOFT-NEXT:  .LBB35_8: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:  .LBB35_9: @ %entry
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    beq .LBB35_8
; SOFT-NEXT:  .LBB35_10: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:    pop {r4, pc}
;
; VFP2-LABEL: ustest_f16i32_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vcvt.u32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f16i32_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f16 s0, s0
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi half %x to i64
  %spec.store.select = call i64 @llvm.smin.i64(i64 %conv, i64 4294967295)
  %spec.store.select7 = call i64 @llvm.smax.i64(i64 %spec.store.select, i64 0)
  %conv6 = trunc i64 %spec.store.select7 to i32
  ret i32 %conv6
}

; i16 saturate

define i16 @stest_f64i16_mm(double %x) {
; SOFT-LABEL: stest_f64i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    ldr r1, .LCPI36_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB36_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB36_2: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI36_1
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    bgt .LBB36_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB36_4: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI36_0:
; SOFT-NEXT:    .long 32767 @ 0x7fff
; SOFT-NEXT:  .LCPI36_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
;
; VFP2-LABEL: stest_f64i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2iz
; VFP2-NEXT:    movw r1, #32767
; VFP2-NEXT:    cmp r0, r1
; VFP2-NEXT:    it ge
; VFP2-NEXT:    movge r0, r1
; VFP2-NEXT:    movw r1, #32768
; VFP2-NEXT:    movt r1, #65535
; VFP2-NEXT:    cmn.w r0, #32768
; VFP2-NEXT:    it le
; VFP2-NEXT:    movle r0, r1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f64i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f64 s0, d0
; FULL-NEXT:    movw r1, #32767
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lt
; FULL-NEXT:    movw r1, #32768
; FULL-NEXT:    movt r1, #65535
; FULL-NEXT:    cmn.w r0, #32768
; FULL-NEXT:    csel r0, r0, r1, gt
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi double %x to i32
  %spec.store.select = call i32 @llvm.smin.i32(i32 %conv, i32 32767)
  %spec.store.select7 = call i32 @llvm.smax.i32(i32 %spec.store.select, i32 -32768)
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @utest_f64i16_mm(double %x) {
; SOFT-LABEL: utest_f64i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2uiz
; SOFT-NEXT:    ldr r1, .LCPI37_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blo .LBB37_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB37_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI37_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: utest_f64i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2uiz
; VFP2-NEXT:    movw r1, #65535
; VFP2-NEXT:    cmp r0, r1
; VFP2-NEXT:    it hs
; VFP2-NEXT:    movhs r0, r1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utest_f64i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f64 s0, d0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lo
; FULL-NEXT:    bx lr
entry:
  %conv = fptoui double %x to i32
  %spec.store.select = call i32 @llvm.umin.i32(i32 %conv, i32 65535)
  %conv6 = trunc i32 %spec.store.select to i16
  ret i16 %conv6
}

define i16 @ustest_f64i16_mm(double %x) {
; SOFT-LABEL: ustest_f64i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    ldr r1, .LCPI38_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB38_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB38_2: @ %entry
; SOFT-NEXT:    asrs r1, r0, #31
; SOFT-NEXT:    bics r0, r1
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI38_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: ustest_f64i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, r1, d0
; VFP2-NEXT:    bl __aeabi_d2iz
; VFP2-NEXT:    movw r1, #65535
; VFP2-NEXT:    cmp r0, r1
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    bic.w r0, r1, r1, asr #31
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f64i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f64 s0, d0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lt
; FULL-NEXT:    bic.w r0, r0, r0, asr #31
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi double %x to i32
  %spec.store.select = call i32 @llvm.smin.i32(i32 %conv, i32 65535)
  %spec.store.select7 = call i32 @llvm.smax.i32(i32 %spec.store.select, i32 0)
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @stest_f32i16_mm(float %x) {
; SOFT-LABEL: stest_f32i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    ldr r1, .LCPI39_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB39_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB39_2: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI39_1
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    bgt .LBB39_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB39_4: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI39_0:
; SOFT-NEXT:    .long 32767 @ 0x7fff
; SOFT-NEXT:  .LCPI39_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
;
; VFP2-LABEL: stest_f32i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    movw r1, #32767
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    cmp r0, r1
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    movw r0, #32768
; VFP2-NEXT:    cmn.w r1, #32768
; VFP2-NEXT:    movt r0, #65535
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, r1
; VFP2-NEXT:    bx lr
;
; FULL-LABEL: stest_f32i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f32 s0, s0
; FULL-NEXT:    movw r1, #32767
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lt
; FULL-NEXT:    movw r1, #32768
; FULL-NEXT:    movt r1, #65535
; FULL-NEXT:    cmn.w r0, #32768
; FULL-NEXT:    csel r0, r0, r1, gt
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi float %x to i32
  %spec.store.select = call i32 @llvm.smin.i32(i32 %conv, i32 32767)
  %spec.store.select7 = call i32 @llvm.smax.i32(i32 %spec.store.select, i32 -32768)
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @utest_f32i16_mm(float %x) {
; SOFT-LABEL: utest_f32i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    ldr r1, .LCPI40_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blo .LBB40_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB40_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI40_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: utest_f32i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    vcvt.u32.f32 s0, s0
; VFP2-NEXT:    movw r0, #65535
; VFP2-NEXT:    vmov r1, s0
; VFP2-NEXT:    cmp r1, r0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r0, r1
; VFP2-NEXT:    bx lr
;
; FULL-LABEL: utest_f32i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f32 s0, s0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lo
; FULL-NEXT:    bx lr
entry:
  %conv = fptoui float %x to i32
  %spec.store.select = call i32 @llvm.umin.i32(i32 %conv, i32 65535)
  %conv6 = trunc i32 %spec.store.select to i16
  ret i16 %conv6
}

define i16 @ustest_f32i16_mm(float %x) {
; SOFT-LABEL: ustest_f32i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    ldr r1, .LCPI41_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB41_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB41_2: @ %entry
; SOFT-NEXT:    asrs r1, r0, #31
; SOFT-NEXT:    bics r0, r1
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI41_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: ustest_f32i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    movw r1, #65535
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    cmp r0, r1
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    bic.w r0, r1, r1, asr #31
; VFP2-NEXT:    bx lr
;
; FULL-LABEL: ustest_f32i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f32 s0, s0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lt
; FULL-NEXT:    bic.w r0, r0, r0, asr #31
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi float %x to i32
  %spec.store.select = call i32 @llvm.smin.i32(i32 %conv, i32 65535)
  %spec.store.select7 = call i32 @llvm.smax.i32(i32 %spec.store.select, i32 0)
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @stest_f16i16_mm(half %x) {
; SOFT-LABEL: stest_f16i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    ldr r1, .LCPI42_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB42_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB42_2: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI42_1
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    bgt .LBB42_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB42_4: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI42_0:
; SOFT-NEXT:    .long 32767 @ 0x7fff
; SOFT-NEXT:  .LCPI42_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
;
; VFP2-LABEL: stest_f16i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    movw r1, #32767
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    cmp r0, r1
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    movw r0, #32768
; VFP2-NEXT:    cmn.w r1, #32768
; VFP2-NEXT:    movt r0, #65535
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, r1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f16i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f16 s0, s0
; FULL-NEXT:    movw r1, #32767
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lt
; FULL-NEXT:    movw r1, #32768
; FULL-NEXT:    movt r1, #65535
; FULL-NEXT:    cmn.w r0, #32768
; FULL-NEXT:    csel r0, r0, r1, gt
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi half %x to i32
  %spec.store.select = call i32 @llvm.smin.i32(i32 %conv, i32 32767)
  %spec.store.select7 = call i32 @llvm.smax.i32(i32 %spec.store.select, i32 -32768)
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

define i16 @utesth_f16i16_mm(half %x) {
; SOFT-LABEL: utesth_f16i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2uiz
; SOFT-NEXT:    ldr r1, .LCPI43_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blo .LBB43_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB43_2: @ %entry
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI43_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: utesth_f16i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    movw r0, #65535
; VFP2-NEXT:    vcvt.u32.f32 s0, s0
; VFP2-NEXT:    vmov r1, s0
; VFP2-NEXT:    cmp r1, r0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r0, r1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utesth_f16i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.u32.f16 s0, s0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lo
; FULL-NEXT:    bx lr
entry:
  %conv = fptoui half %x to i32
  %spec.store.select = call i32 @llvm.umin.i32(i32 %conv, i32 65535)
  %conv6 = trunc i32 %spec.store.select to i16
  ret i16 %conv6
}

define i16 @ustest_f16i16_mm(half %x) {
; SOFT-LABEL: ustest_f16i16_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r7, lr}
; SOFT-NEXT:    push {r7, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    ldr r1, .LCPI44_0
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    blt .LBB44_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB44_2: @ %entry
; SOFT-NEXT:    asrs r1, r0, #31
; SOFT-NEXT:    bics r0, r1
; SOFT-NEXT:    pop {r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:  .LCPI44_0:
; SOFT-NEXT:    .long 65535 @ 0xffff
;
; VFP2-LABEL: ustest_f16i16_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    movw r1, #65535
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    cmp r0, r1
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r1, r0
; VFP2-NEXT:    bic.w r0, r1, r1, asr #31
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: ustest_f16i16_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    vcvt.s32.f16 s0, s0
; FULL-NEXT:    movw r1, #65535
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    cmp r0, r1
; FULL-NEXT:    csel r0, r0, r1, lt
; FULL-NEXT:    bic.w r0, r0, r0, asr #31
; FULL-NEXT:    bx lr
entry:
  %conv = fptosi half %x to i32
  %spec.store.select = call i32 @llvm.smin.i32(i32 %conv, i32 65535)
  %spec.store.select7 = call i32 @llvm.smax.i32(i32 %spec.store.select, i32 0)
  %conv6 = trunc i32 %spec.store.select7 to i16
  ret i16 %conv6
}

; i64 saturate

define i64 @stest_f64i64_mm(double %x) {
; SOFT-LABEL: stest_f64i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #12
; SOFT-NEXT:    sub sp, #12
; SOFT-NEXT:    bl __fixdfti
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    ldr r5, .LCPI45_0
; SOFT-NEXT:    cmp r1, r5
; SOFT-NEXT:    blo .LBB45_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:  .LBB45_2: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bmi .LBB45_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB45_4: @ %entry
; SOFT-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    beq .LBB45_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:  .LBB45_6: @ %entry
; SOFT-NEXT:    movs r0, #0
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    mvns r2, r0
; SOFT-NEXT:    cmp r4, r5
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    blo .LBB45_8
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:  .LBB45_8: @ %entry
; SOFT-NEXT:    cmp r4, r5
; SOFT-NEXT:    mov r4, r6
; SOFT-NEXT:    bne .LBB45_26
; SOFT-NEXT:  @ %bb.9: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bpl .LBB45_27
; SOFT-NEXT:  .LBB45_10: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB45_12
; SOFT-NEXT:  .LBB45_11: @ %entry
; SOFT-NEXT:    mov r4, r6
; SOFT-NEXT:  .LBB45_12: @ %entry
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    lsls r5, r0, #31
; SOFT-NEXT:    cmp r1, r5
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    ldr r6, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    bhi .LBB45_14
; SOFT-NEXT:  @ %bb.13: @ %entry
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:  .LBB45_14: @ %entry
; SOFT-NEXT:    cmp r1, r5
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    beq .LBB45_16
; SOFT-NEXT:  @ %bb.15: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:  .LBB45_16: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    bpl .LBB45_28
; SOFT-NEXT:  @ %bb.17: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    blt .LBB45_29
; SOFT-NEXT:  .LBB45_18: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    beq .LBB45_20
; SOFT-NEXT:  .LBB45_19:
; SOFT-NEXT:    asrs r3, r3, #31
; SOFT-NEXT:    ldr r2, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    ands r3, r2
; SOFT-NEXT:  .LBB45_20: @ %entry
; SOFT-NEXT:    ands r3, r7
; SOFT-NEXT:    adds r2, r3, #1
; SOFT-NEXT:    beq .LBB45_22
; SOFT-NEXT:  @ %bb.21: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB45_22: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r3, r1
; SOFT-NEXT:    blt .LBB45_30
; SOFT-NEXT:  @ %bb.23: @ %entry
; SOFT-NEXT:    cmp r1, r5
; SOFT-NEXT:    bls .LBB45_31
; SOFT-NEXT:  .LBB45_24: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB45_32
; SOFT-NEXT:  .LBB45_25: @ %entry
; SOFT-NEXT:    add sp, #12
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB45_26: @ %entry
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bmi .LBB45_10
; SOFT-NEXT:  .LBB45_27: @ %entry
; SOFT-NEXT:    mov r6, r2
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB45_11
; SOFT-NEXT:    b .LBB45_12
; SOFT-NEXT:  .LBB45_28: @ %entry
; SOFT-NEXT:    mov r7, r6
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bge .LBB45_18
; SOFT-NEXT:  .LBB45_29: @ %entry
; SOFT-NEXT:    mov r4, r6
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bne .LBB45_19
; SOFT-NEXT:    b .LBB45_20
; SOFT-NEXT:  .LBB45_30: @ %entry
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    cmp r1, r5
; SOFT-NEXT:    bhi .LBB45_24
; SOFT-NEXT:  .LBB45_31: @ %entry
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB45_25
; SOFT-NEXT:  .LBB45_32: @ %entry
; SOFT-NEXT:    mov r1, r3
; SOFT-NEXT:    add sp, #12
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.33:
; SOFT-NEXT:  .LCPI45_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f64i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r6, r7, r8, r9, lr}
; VFP2-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; VFP2-NEXT:    .pad #4
; VFP2-NEXT:    sub sp, #4
; VFP2-NEXT:    bl __fixdfti
; VFP2-NEXT:    mvn r8, #-2147483648
; VFP2-NEXT:    mov r12, r1
; VFP2-NEXT:    cmp r1, r8
; VFP2-NEXT:    mvn r1, #-2147483648
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r1, r12
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    mvn r4, #-2147483648
; VFP2-NEXT:    mov.w r5, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r4, r12
; VFP2-NEXT:    orrs.w r9, r2, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r4, r1
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r5, r3
; VFP2-NEXT:    cmp.w r5, #-1
; VFP2-NEXT:    mov.w r7, #-2147483648
; VFP2-NEXT:    mov.w r1, #-2147483648
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r7, r4
; VFP2-NEXT:    cmp.w r4, #-2147483648
; VFP2-NEXT:    mov r6, r3
; VFP2-NEXT:    it hi
; VFP2-NEXT:    movhi r1, r4
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    andne.w r6, r2, r6, asr #31
; VFP2-NEXT:    and.w r2, r6, r5
; VFP2-NEXT:    mov.w r6, #-1
; VFP2-NEXT:    adds r2, #1
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r1, r7
; VFP2-NEXT:    mov.w r7, #-1
; VFP2-NEXT:    cmp r12, r8
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r7, r0
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r7, r0
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r0, r6
; VFP2-NEXT:    cmp.w r9, #0
; VFP2-NEXT:    mov.w r3, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r7
; VFP2-NEXT:    cmp.w r4, #-2147483648
; VFP2-NEXT:    it hi
; VFP2-NEXT:    movhi r3, r0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r3, r0
; VFP2-NEXT:    cmp.w r5, #-1
; VFP2-NEXT:    it le
; VFP2-NEXT:    movle r0, lr
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r3
; VFP2-NEXT:    add sp, #4
; VFP2-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, pc}
;
; FULL-LABEL: stest_f64i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, r5, r6, r7, r8, r9, lr}
; FULL-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; FULL-NEXT:    .pad #4
; FULL-NEXT:    sub sp, #4
; FULL-NEXT:    bl __fixdfti
; FULL-NEXT:    mvn r12, #-2147483648
; FULL-NEXT:    cmp r1, r12
; FULL-NEXT:    csel lr, r1, r12, lo
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r4, r1, r12, mi
; FULL-NEXT:    orrs.w r8, r2, r3
; FULL-NEXT:    csel r4, lr, r4, eq
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    mov.w r7, #-2147483648
; FULL-NEXT:    csel r6, r3, lr, mi
; FULL-NEXT:    mov r5, r3
; FULL-NEXT:    cmp.w r6, #-1
; FULL-NEXT:    csel r9, r4, r7, gt
; FULL-NEXT:    cmp.w r4, #-2147483648
; FULL-NEXT:    csel r7, r4, r7, hi
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    it ne
; FULL-NEXT:    andne.w r5, r2, r5, asr #31
; FULL-NEXT:    and.w r2, r5, r6
; FULL-NEXT:    adds r5, r2, #1
; FULL-NEXT:    csel r2, r7, r9, eq
; FULL-NEXT:    mov.w r7, #-1
; FULL-NEXT:    cmp r1, r12
; FULL-NEXT:    csel r1, r0, r7, lo
; FULL-NEXT:    csel r1, r0, r1, eq
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r0, r0, r7, mi
; FULL-NEXT:    cmp.w r8, #0
; FULL-NEXT:    csel r0, r1, r0, eq
; FULL-NEXT:    cmp.w r4, #-2147483648
; FULL-NEXT:    csel r1, r0, lr, hi
; FULL-NEXT:    csel r1, r0, r1, eq
; FULL-NEXT:    cmp.w r6, #-1
; FULL-NEXT:    csel r0, r0, lr, gt
; FULL-NEXT:    cmp r5, #0
; FULL-NEXT:    csel r0, r1, r0, eq
; FULL-NEXT:    mov r1, r2
; FULL-NEXT:    add sp, #4
; FULL-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, pc}
entry:
  %conv = fptosi double %x to i128
  %spec.store.select = call i128 @llvm.smin.i128(i128 %conv, i128 9223372036854775807)
  %spec.store.select7 = call i128 @llvm.smax.i128(i128 %spec.store.select, i128 -9223372036854775808)
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @utest_f64i64_mm(double %x) {
; SOFT-LABEL: utest_f64i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    bl __fixunsdfti
; SOFT-NEXT:    movs r5, #1
; SOFT-NEXT:    mov r4, r2
; SOFT-NEXT:    eors r4, r5
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    subs r2, r2, #1
; SOFT-NEXT:    mov r2, r3
; SOFT-NEXT:    sbcs r2, r6
; SOFT-NEXT:    blo .LBB46_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r5, r6
; SOFT-NEXT:  .LBB46_2: @ %entry
; SOFT-NEXT:    orrs r4, r3
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB46_7
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB46_8
; SOFT-NEXT:  .LBB46_4: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB46_9
; SOFT-NEXT:  .LBB46_5: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB46_10
; SOFT-NEXT:  .LBB46_6: @ %entry
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB46_7: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB46_4
; SOFT-NEXT:  .LBB46_8: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB46_5
; SOFT-NEXT:  .LBB46_9: @ %entry
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB46_6
; SOFT-NEXT:  .LBB46_10: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    pop {r4, r5, r6, pc}
;
; VFP2-LABEL: utest_f64i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __fixunsdfti
; VFP2-NEXT:    eor r12, r2, #1
; VFP2-NEXT:    subs r2, #1
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    sbcs r2, r3, #0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo.w lr, #1
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    orr.w r12, r12, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utest_f64i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    bl __fixunsdfti
; FULL-NEXT:    eor r12, r2, #1
; FULL-NEXT:    subs r2, #1
; FULL-NEXT:    sbcs r2, r3, #0
; FULL-NEXT:    orr.w r12, r12, r3
; FULL-NEXT:    cset r2, lo
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r2, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r0, r0, r12, ne
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r1, r1, r2, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui double %x to i128
  %spec.store.select = call i128 @llvm.umin.i128(i128 %conv, i128 18446744073709551616)
  %conv6 = trunc i128 %spec.store.select to i64
  ret i64 %conv6
}

define i64 @ustest_f64i64_mm(double %x) {
; SOFT-LABEL: ustest_f64i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    bl __fixdfti
; SOFT-NEXT:    movs r5, #1
; SOFT-NEXT:    mov r4, r2
; SOFT-NEXT:    eors r4, r5
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    subs r7, r2, #1
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    sbcs r7, r6
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    blt .LBB47_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r7, r6
; SOFT-NEXT:  .LBB47_2: @ %entry
; SOFT-NEXT:    orrs r4, r3
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB47_25
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB47_26
; SOFT-NEXT:  .LBB47_4: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB47_27
; SOFT-NEXT:  .LBB47_5: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB47_7
; SOFT-NEXT:  .LBB47_6: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:  .LBB47_7: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    bne .LBB47_9
; SOFT-NEXT:  @ %bb.8: @ %entry
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:  .LBB47_9: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    beq .LBB47_11
; SOFT-NEXT:  @ %bb.10: @ %entry
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB47_11: @ %entry
; SOFT-NEXT:    cmp r2, #1
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    bhs .LBB47_28
; SOFT-NEXT:  @ %bb.12: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bpl .LBB47_29
; SOFT-NEXT:  .LBB47_13: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bne .LBB47_30
; SOFT-NEXT:  .LBB47_14: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bmi .LBB47_16
; SOFT-NEXT:  .LBB47_15: @ %entry
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:  .LBB47_16: @ %entry
; SOFT-NEXT:    rsbs r2, r7, #0
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    sbcs r2, r3
; SOFT-NEXT:    bge .LBB47_31
; SOFT-NEXT:  @ %bb.17: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB47_32
; SOFT-NEXT:  .LBB47_18: @ %entry
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    beq .LBB47_20
; SOFT-NEXT:  .LBB47_19: @ %entry
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:  .LBB47_20: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:    bne .LBB47_22
; SOFT-NEXT:  @ %bb.21: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB47_22: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB47_24
; SOFT-NEXT:  @ %bb.23: @ %entry
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:  .LBB47_24: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB47_25: @ %entry
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB47_4
; SOFT-NEXT:  .LBB47_26: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB47_5
; SOFT-NEXT:  .LBB47_27: @ %entry
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB47_6
; SOFT-NEXT:    b .LBB47_7
; SOFT-NEXT:  .LBB47_28: @ %entry
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bmi .LBB47_13
; SOFT-NEXT:  .LBB47_29: @ %entry
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    beq .LBB47_14
; SOFT-NEXT:  .LBB47_30: @ %entry
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bpl .LBB47_15
; SOFT-NEXT:    b .LBB47_16
; SOFT-NEXT:  .LBB47_31: @ %entry
; SOFT-NEXT:    mov r5, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB47_18
; SOFT-NEXT:  .LBB47_32: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    bne .LBB47_19
; SOFT-NEXT:    b .LBB47_20
;
; VFP2-LABEL: ustest_f64i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    bl __fixdfti
; VFP2-NEXT:    subs r4, r2, #1
; VFP2-NEXT:    eor r12, r2, #1
; VFP2-NEXT:    sbcs r4, r3, #0
; VFP2-NEXT:    orr.w lr, r12, r3
; VFP2-NEXT:    mov.w r4, #0
; VFP2-NEXT:    mov.w r5, #1
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r4, #1
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r4
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, r4
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    cmp r1, #0
; VFP2-NEXT:    mov lr, r1
; VFP2-NEXT:    mov.w r4, #1
; VFP2-NEXT:    ite ne
; VFP2-NEXT:    movne lr, r0
; VFP2-NEXT:    moveq lr, r0
; VFP2-NEXT:    cmp r2, #1
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r5, r2
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r4, r2
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r4, r5
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r3, r12
; VFP2-NEXT:    rsbs r2, r4, #0
; VFP2-NEXT:    sbcs.w r2, r12, r3
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r12, #1
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    orrs.w r2, r4, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r12, r1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r1, r12
; VFP2-NEXT:    pop {r4, r5, r7, pc}
;
; FULL-LABEL: ustest_f64i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, lr}
; FULL-NEXT:    push {r4, lr}
; FULL-NEXT:    bl __fixdfti
; FULL-NEXT:    subs.w lr, r2, #1
; FULL-NEXT:    eor r12, r2, #1
; FULL-NEXT:    sbcs lr, r3, #0
; FULL-NEXT:    orr.w r12, r12, r3
; FULL-NEXT:    cset lr, lt
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r0, r0, lr, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r4, r0, r12, ne
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r1, r1, lr, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    mov.w lr, #1
; FULL-NEXT:    cmp r1, #0
; FULL-NEXT:    csel r0, r4, r1, ne
; FULL-NEXT:    csel r12, r4, r0, eq
; FULL-NEXT:    cmp r2, #1
; FULL-NEXT:    csel r0, r2, lr, lo
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r2, r2, lr, mi
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    csel r0, r0, r2, eq
; FULL-NEXT:    csel r3, r3, lr, mi
; FULL-NEXT:    rsbs r2, r0, #0
; FULL-NEXT:    sbcs.w r2, lr, r3
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r4, r4, r2, ne
; FULL-NEXT:    orrs r3, r0
; FULL-NEXT:    csel r0, r12, r4, eq
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r2, r1, r2, ne
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r1, r1, r2, eq
; FULL-NEXT:    pop {r4, pc}
entry:
  %conv = fptosi double %x to i128
  %spec.store.select = call i128 @llvm.smin.i128(i128 %conv, i128 18446744073709551616)
  %spec.store.select7 = call i128 @llvm.smax.i128(i128 %spec.store.select, i128 0)
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @stest_f32i64_mm(float %x) {
; SOFT-LABEL: stest_f32i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    ldr r0, .LCPI48_0
; SOFT-NEXT:    cmp r1, r0
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    blo .LBB48_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    ldr r5, .LCPI48_0
; SOFT-NEXT:  .LBB48_2: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bmi .LBB48_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI48_0
; SOFT-NEXT:  .LBB48_4: @ %entry
; SOFT-NEXT:    str r2, [sp] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    orrs r0, r7
; SOFT-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB48_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:  .LBB48_6: @ %entry
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    str r1, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bmi .LBB48_8
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB48_8: @ %entry
; SOFT-NEXT:    movs r1, #1
; SOFT-NEXT:    lsls r1, r1, #31
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    bge .LBB48_10
; SOFT-NEXT:  @ %bb.9: @ %entry
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:  .LBB48_10: @ %entry
; SOFT-NEXT:    cmp r5, r1
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bhi .LBB48_12
; SOFT-NEXT:  @ %bb.11: @ %entry
; SOFT-NEXT:    mov r3, r1
; SOFT-NEXT:  .LBB48_12: @ %entry
; SOFT-NEXT:    str r3, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB48_14
; SOFT-NEXT:  @ %bb.13: @ %entry
; SOFT-NEXT:    mov r3, r7
; SOFT-NEXT:    b .LBB48_15
; SOFT-NEXT:  .LBB48_14:
; SOFT-NEXT:    asrs r3, r7, #31
; SOFT-NEXT:    ldr r0, [sp] @ 4-byte Reload
; SOFT-NEXT:    ands r3, r0
; SOFT-NEXT:  .LBB48_15: @ %entry
; SOFT-NEXT:    ands r3, r2
; SOFT-NEXT:    adds r0, r3, #1
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB48_17
; SOFT-NEXT:  @ %bb.16: @ %entry
; SOFT-NEXT:    str r6, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:  .LBB48_17: @ %entry
; SOFT-NEXT:    ldr r3, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    mvns r6, r3
; SOFT-NEXT:    ldr r0, .LCPI48_0
; SOFT-NEXT:    cmp r4, r0
; SOFT-NEXT:    ldr r3, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    blo .LBB48_19
; SOFT-NEXT:  @ %bb.18: @ %entry
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:  .LBB48_19: @ %entry
; SOFT-NEXT:    ldr r0, .LCPI48_0
; SOFT-NEXT:    cmp r4, r0
; SOFT-NEXT:    ldr r4, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB48_21
; SOFT-NEXT:  @ %bb.20: @ %entry
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:  .LBB48_21: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bmi .LBB48_23
; SOFT-NEXT:  @ %bb.22: @ %entry
; SOFT-NEXT:    str r6, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:  .LBB48_23: @ %entry
; SOFT-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB48_25
; SOFT-NEXT:  @ %bb.24: @ %entry
; SOFT-NEXT:    ldr r4, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:  .LBB48_25: @ %entry
; SOFT-NEXT:    cmp r5, r1
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    bhi .LBB48_27
; SOFT-NEXT:  @ %bb.26: @ %entry
; SOFT-NEXT:    ldr r3, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB48_27: @ %entry
; SOFT-NEXT:    cmp r5, r1
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    beq .LBB48_29
; SOFT-NEXT:  @ %bb.28: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:  .LBB48_29: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bge .LBB48_31
; SOFT-NEXT:  @ %bb.30: @ %entry
; SOFT-NEXT:    ldr r4, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB48_31: @ %entry
; SOFT-NEXT:    ldr r1, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB48_33
; SOFT-NEXT:  @ %bb.32: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB48_33: @ %entry
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.34:
; SOFT-NEXT:  .LCPI48_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f32i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r6, r7, r8, r9, lr}
; VFP2-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; VFP2-NEXT:    .pad #4
; VFP2-NEXT:    sub sp, #4
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    mvn r8, #-2147483648
; VFP2-NEXT:    mov r12, r1
; VFP2-NEXT:    cmp r1, r8
; VFP2-NEXT:    mvn r1, #-2147483648
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r1, r12
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    mvn r4, #-2147483648
; VFP2-NEXT:    mov.w r5, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r4, r12
; VFP2-NEXT:    orrs.w r9, r2, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r4, r1
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r5, r3
; VFP2-NEXT:    cmp.w r5, #-1
; VFP2-NEXT:    mov.w r7, #-2147483648
; VFP2-NEXT:    mov.w r1, #-2147483648
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r7, r4
; VFP2-NEXT:    cmp.w r4, #-2147483648
; VFP2-NEXT:    mov r6, r3
; VFP2-NEXT:    it hi
; VFP2-NEXT:    movhi r1, r4
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    andne.w r6, r2, r6, asr #31
; VFP2-NEXT:    and.w r2, r6, r5
; VFP2-NEXT:    mov.w r6, #-1
; VFP2-NEXT:    adds r2, #1
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r1, r7
; VFP2-NEXT:    mov.w r7, #-1
; VFP2-NEXT:    cmp r12, r8
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r7, r0
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r7, r0
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r0, r6
; VFP2-NEXT:    cmp.w r9, #0
; VFP2-NEXT:    mov.w r3, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r7
; VFP2-NEXT:    cmp.w r4, #-2147483648
; VFP2-NEXT:    it hi
; VFP2-NEXT:    movhi r3, r0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r3, r0
; VFP2-NEXT:    cmp.w r5, #-1
; VFP2-NEXT:    it le
; VFP2-NEXT:    movle r0, lr
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r3
; VFP2-NEXT:    add sp, #4
; VFP2-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, pc}
;
; FULL-LABEL: stest_f32i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, r5, r6, r7, r8, r9, lr}
; FULL-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; FULL-NEXT:    .pad #4
; FULL-NEXT:    sub sp, #4
; FULL-NEXT:    bl __fixsfti
; FULL-NEXT:    mvn r12, #-2147483648
; FULL-NEXT:    cmp r1, r12
; FULL-NEXT:    csel lr, r1, r12, lo
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r4, r1, r12, mi
; FULL-NEXT:    orrs.w r8, r2, r3
; FULL-NEXT:    csel r4, lr, r4, eq
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    mov.w r7, #-2147483648
; FULL-NEXT:    csel r6, r3, lr, mi
; FULL-NEXT:    mov r5, r3
; FULL-NEXT:    cmp.w r6, #-1
; FULL-NEXT:    csel r9, r4, r7, gt
; FULL-NEXT:    cmp.w r4, #-2147483648
; FULL-NEXT:    csel r7, r4, r7, hi
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    it ne
; FULL-NEXT:    andne.w r5, r2, r5, asr #31
; FULL-NEXT:    and.w r2, r5, r6
; FULL-NEXT:    adds r5, r2, #1
; FULL-NEXT:    csel r2, r7, r9, eq
; FULL-NEXT:    mov.w r7, #-1
; FULL-NEXT:    cmp r1, r12
; FULL-NEXT:    csel r1, r0, r7, lo
; FULL-NEXT:    csel r1, r0, r1, eq
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r0, r0, r7, mi
; FULL-NEXT:    cmp.w r8, #0
; FULL-NEXT:    csel r0, r1, r0, eq
; FULL-NEXT:    cmp.w r4, #-2147483648
; FULL-NEXT:    csel r1, r0, lr, hi
; FULL-NEXT:    csel r1, r0, r1, eq
; FULL-NEXT:    cmp.w r6, #-1
; FULL-NEXT:    csel r0, r0, lr, gt
; FULL-NEXT:    cmp r5, #0
; FULL-NEXT:    csel r0, r1, r0, eq
; FULL-NEXT:    mov r1, r2
; FULL-NEXT:    add sp, #4
; FULL-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, pc}
entry:
  %conv = fptosi float %x to i128
  %spec.store.select = call i128 @llvm.smin.i128(i128 %conv, i128 9223372036854775807)
  %spec.store.select7 = call i128 @llvm.smax.i128(i128 %spec.store.select, i128 -9223372036854775808)
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @utest_f32i64_mm(float %x) {
; SOFT-LABEL: utest_f32i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    bl __fixunssfti
; SOFT-NEXT:    movs r5, #1
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    subs r4, r2, #1
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    sbcs r4, r6
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    blo .LBB49_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r4, r6
; SOFT-NEXT:  .LBB49_2: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB49_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB49_4: @ %entry
; SOFT-NEXT:    eors r2, r5
; SOFT-NEXT:    orrs r2, r3
; SOFT-NEXT:    beq .LBB49_8
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB49_9
; SOFT-NEXT:  .LBB49_6: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB49_10
; SOFT-NEXT:  .LBB49_7: @ %entry
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB49_8: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB49_6
; SOFT-NEXT:  .LBB49_9: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB49_7
; SOFT-NEXT:  .LBB49_10: @ %entry
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    pop {r4, r5, r6, pc}
;
; VFP2-LABEL: utest_f32i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __fixunssfti
; VFP2-NEXT:    eor r12, r2, #1
; VFP2-NEXT:    subs r2, #1
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    sbcs r2, r3, #0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo.w lr, #1
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    orr.w r12, r12, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utest_f32i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    bl __fixunssfti
; FULL-NEXT:    eor r12, r2, #1
; FULL-NEXT:    subs r2, #1
; FULL-NEXT:    sbcs r2, r3, #0
; FULL-NEXT:    orr.w r12, r12, r3
; FULL-NEXT:    cset r2, lo
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r2, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r0, r0, r12, ne
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r1, r1, r2, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui float %x to i128
  %spec.store.select = call i128 @llvm.umin.i128(i128 %conv, i128 18446744073709551616)
  %conv6 = trunc i128 %spec.store.select to i64
  ret i64 %conv6
}

define i64 @ustest_f32i64_mm(float %x) {
; SOFT-LABEL: ustest_f32i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    movs r5, #1
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    subs r4, r2, #1
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    sbcs r4, r6
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    blt .LBB50_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r4, r6
; SOFT-NEXT:  .LBB50_2: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB50_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB50_4: @ %entry
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    eors r7, r5
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    beq .LBB50_26
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB50_27
; SOFT-NEXT:  .LBB50_6: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB50_8
; SOFT-NEXT:  .LBB50_7: @ %entry
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:  .LBB50_8: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    bne .LBB50_10
; SOFT-NEXT:  @ %bb.9: @ %entry
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:  .LBB50_10: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    beq .LBB50_12
; SOFT-NEXT:  @ %bb.11: @ %entry
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB50_12: @ %entry
; SOFT-NEXT:    cmp r2, #1
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    bhs .LBB50_28
; SOFT-NEXT:  @ %bb.13: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bpl .LBB50_29
; SOFT-NEXT:  .LBB50_14: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bne .LBB50_30
; SOFT-NEXT:  .LBB50_15: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bmi .LBB50_17
; SOFT-NEXT:  .LBB50_16: @ %entry
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:  .LBB50_17: @ %entry
; SOFT-NEXT:    rsbs r2, r7, #0
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    sbcs r2, r3
; SOFT-NEXT:    bge .LBB50_31
; SOFT-NEXT:  @ %bb.18: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB50_32
; SOFT-NEXT:  .LBB50_19: @ %entry
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    beq .LBB50_21
; SOFT-NEXT:  .LBB50_20: @ %entry
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:  .LBB50_21: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:    bne .LBB50_23
; SOFT-NEXT:  @ %bb.22: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB50_23: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB50_25
; SOFT-NEXT:  @ %bb.24: @ %entry
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:  .LBB50_25: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB50_26: @ %entry
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB50_6
; SOFT-NEXT:  .LBB50_27: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB50_7
; SOFT-NEXT:    b .LBB50_8
; SOFT-NEXT:  .LBB50_28: @ %entry
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bmi .LBB50_14
; SOFT-NEXT:  .LBB50_29: @ %entry
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    beq .LBB50_15
; SOFT-NEXT:  .LBB50_30: @ %entry
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bpl .LBB50_16
; SOFT-NEXT:    b .LBB50_17
; SOFT-NEXT:  .LBB50_31: @ %entry
; SOFT-NEXT:    mov r5, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB50_19
; SOFT-NEXT:  .LBB50_32: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    bne .LBB50_20
; SOFT-NEXT:    b .LBB50_21
;
; VFP2-LABEL: ustest_f32i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    subs r4, r2, #1
; VFP2-NEXT:    eor r12, r2, #1
; VFP2-NEXT:    sbcs r4, r3, #0
; VFP2-NEXT:    orr.w lr, r12, r3
; VFP2-NEXT:    mov.w r4, #0
; VFP2-NEXT:    mov.w r5, #1
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r4, #1
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r4
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, r4
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    cmp r1, #0
; VFP2-NEXT:    mov lr, r1
; VFP2-NEXT:    mov.w r4, #1
; VFP2-NEXT:    ite ne
; VFP2-NEXT:    movne lr, r0
; VFP2-NEXT:    moveq lr, r0
; VFP2-NEXT:    cmp r2, #1
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r5, r2
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r4, r2
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r4, r5
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r3, r12
; VFP2-NEXT:    rsbs r2, r4, #0
; VFP2-NEXT:    sbcs.w r2, r12, r3
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r12, #1
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    orrs.w r2, r4, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r12, r1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r1, r12
; VFP2-NEXT:    pop {r4, r5, r7, pc}
;
; FULL-LABEL: ustest_f32i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, lr}
; FULL-NEXT:    push {r4, lr}
; FULL-NEXT:    bl __fixsfti
; FULL-NEXT:    subs.w lr, r2, #1
; FULL-NEXT:    eor r12, r2, #1
; FULL-NEXT:    sbcs lr, r3, #0
; FULL-NEXT:    orr.w r12, r12, r3
; FULL-NEXT:    cset lr, lt
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r0, r0, lr, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r4, r0, r12, ne
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r1, r1, lr, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    mov.w lr, #1
; FULL-NEXT:    cmp r1, #0
; FULL-NEXT:    csel r0, r4, r1, ne
; FULL-NEXT:    csel r12, r4, r0, eq
; FULL-NEXT:    cmp r2, #1
; FULL-NEXT:    csel r0, r2, lr, lo
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r2, r2, lr, mi
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    csel r0, r0, r2, eq
; FULL-NEXT:    csel r3, r3, lr, mi
; FULL-NEXT:    rsbs r2, r0, #0
; FULL-NEXT:    sbcs.w r2, lr, r3
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r4, r4, r2, ne
; FULL-NEXT:    orrs r3, r0
; FULL-NEXT:    csel r0, r12, r4, eq
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r2, r1, r2, ne
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r1, r1, r2, eq
; FULL-NEXT:    pop {r4, pc}
entry:
  %conv = fptosi float %x to i128
  %spec.store.select = call i128 @llvm.smin.i128(i128 %conv, i128 18446744073709551616)
  %spec.store.select7 = call i128 @llvm.smax.i128(i128 %spec.store.select, i128 0)
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @stest_f16i64_mm(half %x) {
; SOFT-LABEL: stest_f16i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:    ldr r0, .LCPI51_0
; SOFT-NEXT:    cmp r1, r0
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    blo .LBB51_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    ldr r5, .LCPI51_0
; SOFT-NEXT:  .LBB51_2: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bmi .LBB51_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI51_0
; SOFT-NEXT:  .LBB51_4: @ %entry
; SOFT-NEXT:    str r2, [sp] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    orrs r0, r7
; SOFT-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB51_6
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:  .LBB51_6: @ %entry
; SOFT-NEXT:    movs r1, #0
; SOFT-NEXT:    str r1, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bmi .LBB51_8
; SOFT-NEXT:  @ %bb.7: @ %entry
; SOFT-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB51_8: @ %entry
; SOFT-NEXT:    movs r1, #1
; SOFT-NEXT:    lsls r1, r1, #31
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:    bge .LBB51_10
; SOFT-NEXT:  @ %bb.9: @ %entry
; SOFT-NEXT:    mov r6, r1
; SOFT-NEXT:  .LBB51_10: @ %entry
; SOFT-NEXT:    cmp r5, r1
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bhi .LBB51_12
; SOFT-NEXT:  @ %bb.11: @ %entry
; SOFT-NEXT:    mov r3, r1
; SOFT-NEXT:  .LBB51_12: @ %entry
; SOFT-NEXT:    str r3, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB51_14
; SOFT-NEXT:  @ %bb.13: @ %entry
; SOFT-NEXT:    mov r3, r7
; SOFT-NEXT:    b .LBB51_15
; SOFT-NEXT:  .LBB51_14:
; SOFT-NEXT:    asrs r3, r7, #31
; SOFT-NEXT:    ldr r0, [sp] @ 4-byte Reload
; SOFT-NEXT:    ands r3, r0
; SOFT-NEXT:  .LBB51_15: @ %entry
; SOFT-NEXT:    ands r3, r2
; SOFT-NEXT:    adds r0, r3, #1
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB51_17
; SOFT-NEXT:  @ %bb.16: @ %entry
; SOFT-NEXT:    str r6, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:  .LBB51_17: @ %entry
; SOFT-NEXT:    ldr r3, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    mvns r6, r3
; SOFT-NEXT:    ldr r0, .LCPI51_0
; SOFT-NEXT:    cmp r4, r0
; SOFT-NEXT:    ldr r3, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    blo .LBB51_19
; SOFT-NEXT:  @ %bb.18: @ %entry
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:  .LBB51_19: @ %entry
; SOFT-NEXT:    ldr r0, .LCPI51_0
; SOFT-NEXT:    cmp r4, r0
; SOFT-NEXT:    ldr r4, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB51_21
; SOFT-NEXT:  @ %bb.20: @ %entry
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:  .LBB51_21: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bmi .LBB51_23
; SOFT-NEXT:  @ %bb.22: @ %entry
; SOFT-NEXT:    str r6, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:  .LBB51_23: @ %entry
; SOFT-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB51_25
; SOFT-NEXT:  @ %bb.24: @ %entry
; SOFT-NEXT:    ldr r4, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:  .LBB51_25: @ %entry
; SOFT-NEXT:    cmp r5, r1
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    bhi .LBB51_27
; SOFT-NEXT:  @ %bb.26: @ %entry
; SOFT-NEXT:    ldr r3, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB51_27: @ %entry
; SOFT-NEXT:    cmp r5, r1
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    beq .LBB51_29
; SOFT-NEXT:  @ %bb.28: @ %entry
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:  .LBB51_29: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bge .LBB51_31
; SOFT-NEXT:  @ %bb.30: @ %entry
; SOFT-NEXT:    ldr r4, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB51_31: @ %entry
; SOFT-NEXT:    ldr r1, [sp] @ 4-byte Reload
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB51_33
; SOFT-NEXT:  @ %bb.32: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB51_33: @ %entry
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.34:
; SOFT-NEXT:  .LCPI51_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: stest_f16i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r6, r7, r8, r9, lr}
; VFP2-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; VFP2-NEXT:    .pad #4
; VFP2-NEXT:    sub sp, #4
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    mvn r8, #-2147483648
; VFP2-NEXT:    mov r12, r1
; VFP2-NEXT:    cmp r1, r8
; VFP2-NEXT:    mvn r1, #-2147483648
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r1, r12
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    mvn r4, #-2147483648
; VFP2-NEXT:    mov.w r5, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r4, r12
; VFP2-NEXT:    orrs.w r9, r2, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r4, r1
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r5, r3
; VFP2-NEXT:    cmp.w r5, #-1
; VFP2-NEXT:    mov.w r7, #-2147483648
; VFP2-NEXT:    mov.w r1, #-2147483648
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r7, r4
; VFP2-NEXT:    cmp.w r4, #-2147483648
; VFP2-NEXT:    mov r6, r3
; VFP2-NEXT:    it hi
; VFP2-NEXT:    movhi r1, r4
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    andne.w r6, r2, r6, asr #31
; VFP2-NEXT:    and.w r2, r6, r5
; VFP2-NEXT:    mov.w r6, #-1
; VFP2-NEXT:    adds r2, #1
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r1, r7
; VFP2-NEXT:    mov.w r7, #-1
; VFP2-NEXT:    cmp r12, r8
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r7, r0
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r7, r0
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r0, r6
; VFP2-NEXT:    cmp.w r9, #0
; VFP2-NEXT:    mov.w r3, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r7
; VFP2-NEXT:    cmp.w r4, #-2147483648
; VFP2-NEXT:    it hi
; VFP2-NEXT:    movhi r3, r0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r3, r0
; VFP2-NEXT:    cmp.w r5, #-1
; VFP2-NEXT:    it le
; VFP2-NEXT:    movle r0, lr
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r3
; VFP2-NEXT:    add sp, #4
; VFP2-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, pc}
;
; FULL-LABEL: stest_f16i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, r5, r6, r7, r8, r9, lr}
; FULL-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; FULL-NEXT:    .pad #4
; FULL-NEXT:    sub sp, #4
; FULL-NEXT:    vmov.f16 r0, s0
; FULL-NEXT:    vmov s0, r0
; FULL-NEXT:    bl __fixhfti
; FULL-NEXT:    mvn r12, #-2147483648
; FULL-NEXT:    cmp r1, r12
; FULL-NEXT:    csel lr, r1, r12, lo
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r4, r1, r12, mi
; FULL-NEXT:    orrs.w r8, r2, r3
; FULL-NEXT:    csel r4, lr, r4, eq
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    mov.w r7, #-2147483648
; FULL-NEXT:    csel r6, r3, lr, mi
; FULL-NEXT:    mov r5, r3
; FULL-NEXT:    cmp.w r6, #-1
; FULL-NEXT:    csel r9, r4, r7, gt
; FULL-NEXT:    cmp.w r4, #-2147483648
; FULL-NEXT:    csel r7, r4, r7, hi
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    it ne
; FULL-NEXT:    andne.w r5, r2, r5, asr #31
; FULL-NEXT:    and.w r2, r5, r6
; FULL-NEXT:    adds r5, r2, #1
; FULL-NEXT:    csel r2, r7, r9, eq
; FULL-NEXT:    mov.w r7, #-1
; FULL-NEXT:    cmp r1, r12
; FULL-NEXT:    csel r1, r0, r7, lo
; FULL-NEXT:    csel r1, r0, r1, eq
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r0, r0, r7, mi
; FULL-NEXT:    cmp.w r8, #0
; FULL-NEXT:    csel r0, r1, r0, eq
; FULL-NEXT:    cmp.w r4, #-2147483648
; FULL-NEXT:    csel r1, r0, lr, hi
; FULL-NEXT:    csel r1, r0, r1, eq
; FULL-NEXT:    cmp.w r6, #-1
; FULL-NEXT:    csel r0, r0, lr, gt
; FULL-NEXT:    cmp r5, #0
; FULL-NEXT:    csel r0, r1, r0, eq
; FULL-NEXT:    mov r1, r2
; FULL-NEXT:    add sp, #4
; FULL-NEXT:    pop.w {r4, r5, r6, r7, r8, r9, pc}
entry:
  %conv = fptosi half %x to i128
  %spec.store.select = call i128 @llvm.smin.i128(i128 %conv, i128 9223372036854775807)
  %spec.store.select7 = call i128 @llvm.smax.i128(i128 %spec.store.select, i128 -9223372036854775808)
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}

define i64 @utesth_f16i64_mm(half %x) {
; SOFT-LABEL: utesth_f16i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __fixunssfti
; SOFT-NEXT:    movs r5, #1
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    subs r4, r2, #1
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    sbcs r4, r6
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    blo .LBB52_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r4, r6
; SOFT-NEXT:  .LBB52_2: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB52_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB52_4: @ %entry
; SOFT-NEXT:    eors r2, r5
; SOFT-NEXT:    orrs r2, r3
; SOFT-NEXT:    beq .LBB52_8
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB52_9
; SOFT-NEXT:  .LBB52_6: @ %entry
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB52_10
; SOFT-NEXT:  .LBB52_7: @ %entry
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:  .LBB52_8: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB52_6
; SOFT-NEXT:  .LBB52_9: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB52_7
; SOFT-NEXT:  .LBB52_10: @ %entry
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    pop {r4, r5, r6, pc}
;
; VFP2-LABEL: utesth_f16i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    bl __fixunssfti
; VFP2-NEXT:    eor r12, r2, #1
; VFP2-NEXT:    subs r2, #1
; VFP2-NEXT:    mov.w lr, #0
; VFP2-NEXT:    sbcs r2, r3, #0
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo.w lr, #1
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    orr.w r12, r12, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, r12
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: utesth_f16i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    vmov.f16 r0, s0
; FULL-NEXT:    vmov s0, r0
; FULL-NEXT:    bl __fixunshfti
; FULL-NEXT:    eor r12, r2, #1
; FULL-NEXT:    subs r2, #1
; FULL-NEXT:    sbcs r2, r3, #0
; FULL-NEXT:    orr.w r12, r12, r3
; FULL-NEXT:    cset r2, lo
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r0, r0, r2, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r0, r0, r12, ne
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r1, r1, r2, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptoui half %x to i128
  %spec.store.select = call i128 @llvm.umin.i128(i128 %conv, i128 18446744073709551616)
  %conv6 = trunc i128 %spec.store.select to i64
  ret i64 %conv6
}

define i64 @ustest_f16i64_mm(half %x) {
; SOFT-LABEL: ustest_f16i64_mm:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    movs r5, #1
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    subs r4, r2, #1
; SOFT-NEXT:    mov r4, r3
; SOFT-NEXT:    sbcs r4, r6
; SOFT-NEXT:    mov r4, r5
; SOFT-NEXT:    blt .LBB53_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r4, r6
; SOFT-NEXT:  .LBB53_2: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB53_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:  .LBB53_4: @ %entry
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    eors r7, r5
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    beq .LBB53_26
; SOFT-NEXT:  @ %bb.5: @ %entry
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    beq .LBB53_27
; SOFT-NEXT:  .LBB53_6: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB53_8
; SOFT-NEXT:  .LBB53_7: @ %entry
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:  .LBB53_8: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    bne .LBB53_10
; SOFT-NEXT:  @ %bb.9: @ %entry
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:  .LBB53_10: @ %entry
; SOFT-NEXT:    cmp r1, #0
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    beq .LBB53_12
; SOFT-NEXT:  @ %bb.11: @ %entry
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB53_12: @ %entry
; SOFT-NEXT:    cmp r2, #1
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    bhs .LBB53_28
; SOFT-NEXT:  @ %bb.13: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bpl .LBB53_29
; SOFT-NEXT:  .LBB53_14: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bne .LBB53_30
; SOFT-NEXT:  .LBB53_15: @ %entry
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bmi .LBB53_17
; SOFT-NEXT:  .LBB53_16: @ %entry
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:  .LBB53_17: @ %entry
; SOFT-NEXT:    rsbs r2, r7, #0
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    sbcs r2, r3
; SOFT-NEXT:    bge .LBB53_31
; SOFT-NEXT:  @ %bb.18: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    beq .LBB53_32
; SOFT-NEXT:  .LBB53_19: @ %entry
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    beq .LBB53_21
; SOFT-NEXT:  .LBB53_20: @ %entry
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:  .LBB53_21: @ %entry
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:    bne .LBB53_23
; SOFT-NEXT:  @ %bb.22: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB53_23: @ %entry
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB53_25
; SOFT-NEXT:  @ %bb.24: @ %entry
; SOFT-NEXT:    mov r1, r0
; SOFT-NEXT:  .LBB53_25: @ %entry
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB53_26: @ %entry
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    cmp r4, #0
; SOFT-NEXT:    bne .LBB53_6
; SOFT-NEXT:  .LBB53_27: @ %entry
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB53_7
; SOFT-NEXT:    b .LBB53_8
; SOFT-NEXT:  .LBB53_28: @ %entry
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bmi .LBB53_14
; SOFT-NEXT:  .LBB53_29: @ %entry
; SOFT-NEXT:    mov r2, r5
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    beq .LBB53_15
; SOFT-NEXT:  .LBB53_30: @ %entry
; SOFT-NEXT:    mov r7, r2
; SOFT-NEXT:    cmp r3, #0
; SOFT-NEXT:    bpl .LBB53_16
; SOFT-NEXT:    b .LBB53_17
; SOFT-NEXT:  .LBB53_31: @ %entry
; SOFT-NEXT:    mov r5, r6
; SOFT-NEXT:    cmp r5, #0
; SOFT-NEXT:    bne .LBB53_19
; SOFT-NEXT:  .LBB53_32: @ %entry
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    orrs r7, r3
; SOFT-NEXT:    bne .LBB53_20
; SOFT-NEXT:    b .LBB53_21
;
; VFP2-LABEL: ustest_f16i64_mm:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    subs r4, r2, #1
; VFP2-NEXT:    eor r12, r2, #1
; VFP2-NEXT:    sbcs r4, r3, #0
; VFP2-NEXT:    orr.w lr, r12, r3
; VFP2-NEXT:    mov.w r4, #0
; VFP2-NEXT:    mov.w r5, #1
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt r4, #1
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r4
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp r4, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, r4
; VFP2-NEXT:    cmp.w lr, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r1, lr
; VFP2-NEXT:    cmp r1, #0
; VFP2-NEXT:    mov lr, r1
; VFP2-NEXT:    mov.w r4, #1
; VFP2-NEXT:    ite ne
; VFP2-NEXT:    movne lr, r0
; VFP2-NEXT:    moveq lr, r0
; VFP2-NEXT:    cmp r2, #1
; VFP2-NEXT:    it lo
; VFP2-NEXT:    movlo r5, r2
; VFP2-NEXT:    cmp r3, #0
; VFP2-NEXT:    it mi
; VFP2-NEXT:    movmi r4, r2
; VFP2-NEXT:    mov.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r4, r5
; VFP2-NEXT:    it pl
; VFP2-NEXT:    movpl r3, r12
; VFP2-NEXT:    rsbs r2, r4, #0
; VFP2-NEXT:    sbcs.w r2, r12, r3
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r12, #1
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, r12
; VFP2-NEXT:    orrs.w r2, r4, r3
; VFP2-NEXT:    it eq
; VFP2-NEXT:    moveq r0, lr
; VFP2-NEXT:    cmp.w r12, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r12, r1
; VFP2-NEXT:    cmp r2, #0
; VFP2-NEXT:    it ne
; VFP2-NEXT:    movne r1, r12
; VFP2-NEXT:    pop {r4, r5, r7, pc}
;
; FULL-LABEL: ustest_f16i64_mm:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r4, lr}
; FULL-NEXT:    push {r4, lr}
; FULL-NEXT:    vmov.f16 r0, s0
; FULL-NEXT:    vmov s0, r0
; FULL-NEXT:    bl __fixhfti
; FULL-NEXT:    subs.w lr, r2, #1
; FULL-NEXT:    eor r12, r2, #1
; FULL-NEXT:    sbcs lr, r3, #0
; FULL-NEXT:    orr.w r12, r12, r3
; FULL-NEXT:    cset lr, lt
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r0, r0, lr, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r4, r0, r12, ne
; FULL-NEXT:    cmp.w lr, #0
; FULL-NEXT:    csel r1, r1, lr, ne
; FULL-NEXT:    cmp.w r12, #0
; FULL-NEXT:    csel r1, r1, r12, ne
; FULL-NEXT:    mov.w lr, #1
; FULL-NEXT:    cmp r1, #0
; FULL-NEXT:    csel r0, r4, r1, ne
; FULL-NEXT:    csel r12, r4, r0, eq
; FULL-NEXT:    cmp r2, #1
; FULL-NEXT:    csel r0, r2, lr, lo
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r2, r2, lr, mi
; FULL-NEXT:    mov.w lr, #0
; FULL-NEXT:    csel r0, r0, r2, eq
; FULL-NEXT:    csel r3, r3, lr, mi
; FULL-NEXT:    rsbs r2, r0, #0
; FULL-NEXT:    sbcs.w r2, lr, r3
; FULL-NEXT:    cset r2, lt
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r4, r4, r2, ne
; FULL-NEXT:    orrs r3, r0
; FULL-NEXT:    csel r0, r12, r4, eq
; FULL-NEXT:    cmp r2, #0
; FULL-NEXT:    csel r2, r1, r2, ne
; FULL-NEXT:    cmp r3, #0
; FULL-NEXT:    csel r1, r1, r2, eq
; FULL-NEXT:    pop {r4, pc}
entry:
  %conv = fptosi half %x to i128
  %spec.store.select = call i128 @llvm.smin.i128(i128 %conv, i128 18446744073709551616)
  %spec.store.select7 = call i128 @llvm.smax.i128(i128 %spec.store.select, i128 0)
  %conv6 = trunc i128 %spec.store.select7 to i64
  ret i64 %conv6
}


define void @unroll_maxmin(i32* nocapture %0, float* nocapture readonly %1, i32 %2) {
; SOFT-LABEL: unroll_maxmin:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    movs r0, #0
; SOFT-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mvns r0, r0
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    lsls r1, r0, #31
; SOFT-NEXT:    str r1, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    lsls r7, r0, #10
; SOFT-NEXT:    b .LBB54_2
; SOFT-NEXT:  .LBB54_1: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    str r0, [r5, #4]
; SOFT-NEXT:    adds r4, #8
; SOFT-NEXT:    adds r5, #8
; SOFT-NEXT:    subs r7, r7, #2
; SOFT-NEXT:    beq .LBB54_18
; SOFT-NEXT:  .LBB54_2: @ =>This Inner Loop Header: Depth=1
; SOFT-NEXT:    ldr r0, [r4]
; SOFT-NEXT:    movs r1, #79
; SOFT-NEXT:    lsls r6, r1, #24
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fmul
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    ldr r2, .LCPI54_0
; SOFT-NEXT:    subs r2, r0, r2
; SOFT-NEXT:    mov r2, r1
; SOFT-NEXT:    ldr r3, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    sbcs r2, r3
; SOFT-NEXT:    ldr r2, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    bge .LBB54_14
; SOFT-NEXT:  @ %bb.3: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB54_15
; SOFT-NEXT:  .LBB54_4: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB54_6
; SOFT-NEXT:  .LBB54_5: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    ldr r0, .LCPI54_0
; SOFT-NEXT:  .LBB54_6: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    subs r2, r2, r0
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    sbcs r2, r1
; SOFT-NEXT:    blt .LBB54_8
; SOFT-NEXT:  @ %bb.7: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    ldr r0, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB54_8: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    str r0, [r5]
; SOFT-NEXT:    ldr r0, [r4, #4]
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fmul
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    ldr r2, .LCPI54_0
; SOFT-NEXT:    subs r2, r0, r2
; SOFT-NEXT:    mov r2, r1
; SOFT-NEXT:    ldr r3, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    sbcs r2, r3
; SOFT-NEXT:    ldr r2, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    bge .LBB54_16
; SOFT-NEXT:  @ %bb.9: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB54_17
; SOFT-NEXT:  .LBB54_10: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB54_12
; SOFT-NEXT:  .LBB54_11: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    ldr r0, .LCPI54_0
; SOFT-NEXT:  .LBB54_12: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    subs r2, r2, r0
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    sbcs r2, r1
; SOFT-NEXT:    blt .LBB54_1
; SOFT-NEXT:  @ %bb.13: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    ldr r0, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    b .LBB54_1
; SOFT-NEXT:  .LBB54_14: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB54_4
; SOFT-NEXT:  .LBB54_15: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB54_5
; SOFT-NEXT:    b .LBB54_6
; SOFT-NEXT:  .LBB54_16: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB54_10
; SOFT-NEXT:  .LBB54_17: @ in Loop: Header=BB54_2 Depth=1
; SOFT-NEXT:    mov r1, r2
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB54_11
; SOFT-NEXT:    b .LBB54_12
; SOFT-NEXT:  .LBB54_18:
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.19:
; SOFT-NEXT:  .LCPI54_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: unroll_maxmin:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    subs r1, #8
; VFP2-NEXT:    subs r0, #8
; VFP2-NEXT:    vldr s0, .LCPI54_0
; VFP2-NEXT:    mov.w r2, #1024
; VFP2-NEXT:  .LBB54_1: @ =>This Inner Loop Header: Depth=1
; VFP2-NEXT:    vldr s2, [r1, #8]
; VFP2-NEXT:    subs r2, #2
; VFP2-NEXT:    vmul.f32 s2, s2, s0
; VFP2-NEXT:    vcvt.s32.f32 s2, s2
; VFP2-NEXT:    vmov r3, s2
; VFP2-NEXT:    str r3, [r0, #8]!
; VFP2-NEXT:    vldr s2, [r1, #12]
; VFP2-NEXT:    add.w r1, r1, #8
; VFP2-NEXT:    vmul.f32 s2, s2, s0
; VFP2-NEXT:    vcvt.s32.f32 s2, s2
; VFP2-NEXT:    vstr s2, [r0, #4]
; VFP2-NEXT:    bne .LBB54_1
; VFP2-NEXT:  @ %bb.2:
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.3:
; VFP2-NEXT:  .LCPI54_0:
; VFP2-NEXT:    .long 0x4f000000 @ float 2.14748365E+9
;
; FULL-LABEL: unroll_maxmin:
; FULL:       @ %bb.0:
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    mov.w lr, #512
; FULL-NEXT:    subs r1, #8
; FULL-NEXT:    subs r0, #8
; FULL-NEXT:    vldr s0, .LCPI54_0
; FULL-NEXT:  .LBB54_1: @ =>This Inner Loop Header: Depth=1
; FULL-NEXT:    vldr s2, [r1, #8]
; FULL-NEXT:    vmul.f32 s2, s2, s0
; FULL-NEXT:    vcvt.s32.f32 s2, s2
; FULL-NEXT:    vmov r2, s2
; FULL-NEXT:    str r2, [r0, #8]!
; FULL-NEXT:    vldr s2, [r1, #12]
; FULL-NEXT:    adds r1, #8
; FULL-NEXT:    vmul.f32 s2, s2, s0
; FULL-NEXT:    vcvt.s32.f32 s2, s2
; FULL-NEXT:    vstr s2, [r0, #4]
; FULL-NEXT:    le lr, .LBB54_1
; FULL-NEXT:  @ %bb.2:
; FULL-NEXT:    pop {r7, pc}
; FULL-NEXT:    .p2align 2
; FULL-NEXT:  @ %bb.3:
; FULL-NEXT:  .LCPI54_0:
; FULL-NEXT:    .long 0x4f000000 @ float 2.14748365E+9
  br label %5

4:                                                ; preds = %5
  ret void

5:                                                ; preds = %5, %3
  %6 = phi i32 [ 0, %3 ], [ %28, %5 ]
  %7 = getelementptr inbounds float, float* %1, i32 %6
  %8 = load float, float* %7, align 4
  %9 = fmul float %8, 0x41E0000000000000
  %10 = fptosi float %9 to i64
  %11 = icmp slt i64 %10, 2147483647
  %12 = select i1 %11, i64 %10, i64 2147483647
  %13 = icmp sgt i64 %12, -2147483648
  %14 = select i1 %13, i64 %12, i64 -2147483648
  %15 = trunc i64 %14 to i32
  %16 = getelementptr inbounds i32, i32* %0, i32 %6
  store i32 %15, i32* %16, align 4
  %17 = or i32 %6, 1
  %18 = getelementptr inbounds float, float* %1, i32 %17
  %19 = load float, float* %18, align 4
  %20 = fmul float %19, 0x41E0000000000000
  %21 = fptosi float %20 to i64
  %22 = icmp slt i64 %21, 2147483647
  %23 = select i1 %22, i64 %21, i64 2147483647
  %24 = icmp sgt i64 %23, -2147483648
  %25 = select i1 %24, i64 %23, i64 -2147483648
  %26 = trunc i64 %25 to i32
  %27 = getelementptr inbounds i32, i32* %0, i32 %17
  store i32 %26, i32* %27, align 4
  %28 = add nuw nsw i32 %6, 2
  %29 = icmp eq i32 %28, 1024
  br i1 %29, label %4, label %5
}

define void @unroll_minmax(i32* nocapture %0, float* nocapture readonly %1, i32 %2) {
; SOFT-LABEL: unroll_minmax:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    mov r4, r1
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    movs r0, #0
; SOFT-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mvns r0, r0
; SOFT-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    lsls r1, r0, #31
; SOFT-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    lsls r7, r0, #10
; SOFT-NEXT:    b .LBB55_2
; SOFT-NEXT:  .LBB55_1: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    str r0, [r5, #4]
; SOFT-NEXT:    adds r4, #8
; SOFT-NEXT:    adds r5, #8
; SOFT-NEXT:    subs r7, r7, #2
; SOFT-NEXT:    beq .LBB55_18
; SOFT-NEXT:  .LBB55_2: @ =>This Inner Loop Header: Depth=1
; SOFT-NEXT:    ldr r0, [r4]
; SOFT-NEXT:    movs r1, #79
; SOFT-NEXT:    lsls r6, r1, #24
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fmul
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    subs r2, r2, r0
; SOFT-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    sbcs r2, r1
; SOFT-NEXT:    ldr r2, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    bge .LBB55_14
; SOFT-NEXT:  @ %bb.3: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB55_15
; SOFT-NEXT:  .LBB55_4: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB55_6
; SOFT-NEXT:  .LBB55_5: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r0, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:  .LBB55_6: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r2, .LCPI55_0
; SOFT-NEXT:    subs r2, r0, r2
; SOFT-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    sbcs r1, r2
; SOFT-NEXT:    blt .LBB55_8
; SOFT-NEXT:  @ %bb.7: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r0, .LCPI55_0
; SOFT-NEXT:  .LBB55_8: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    str r0, [r5]
; SOFT-NEXT:    ldr r0, [r4, #4]
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bl __aeabi_fmul
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    subs r2, r2, r0
; SOFT-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    sbcs r2, r1
; SOFT-NEXT:    ldr r2, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    bge .LBB55_16
; SOFT-NEXT:  @ %bb.9: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB55_17
; SOFT-NEXT:  .LBB55_10: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB55_12
; SOFT-NEXT:  .LBB55_11: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r0, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:  .LBB55_12: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r2, .LCPI55_0
; SOFT-NEXT:    subs r2, r0, r2
; SOFT-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    sbcs r1, r2
; SOFT-NEXT:    blt .LBB55_1
; SOFT-NEXT:  @ %bb.13: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r0, .LCPI55_0
; SOFT-NEXT:    b .LBB55_1
; SOFT-NEXT:  .LBB55_14: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB55_4
; SOFT-NEXT:  .LBB55_15: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r1, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB55_5
; SOFT-NEXT:    b .LBB55_6
; SOFT-NEXT:  .LBB55_16: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    bne .LBB55_10
; SOFT-NEXT:  .LBB55_17: @ in Loop: Header=BB55_2 Depth=1
; SOFT-NEXT:    ldr r1, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:    cmp r2, #0
; SOFT-NEXT:    beq .LBB55_11
; SOFT-NEXT:    b .LBB55_12
; SOFT-NEXT:  .LBB55_18:
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.19:
; SOFT-NEXT:  .LCPI55_0:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: unroll_minmax:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    subs r1, #8
; VFP2-NEXT:    subs r0, #8
; VFP2-NEXT:    vldr s0, .LCPI55_0
; VFP2-NEXT:    mov.w r2, #1024
; VFP2-NEXT:  .LBB55_1: @ =>This Inner Loop Header: Depth=1
; VFP2-NEXT:    vldr s2, [r1, #8]
; VFP2-NEXT:    subs r2, #2
; VFP2-NEXT:    vmul.f32 s2, s2, s0
; VFP2-NEXT:    vcvt.s32.f32 s2, s2
; VFP2-NEXT:    vmov r3, s2
; VFP2-NEXT:    str r3, [r0, #8]!
; VFP2-NEXT:    vldr s2, [r1, #12]
; VFP2-NEXT:    add.w r1, r1, #8
; VFP2-NEXT:    vmul.f32 s2, s2, s0
; VFP2-NEXT:    vcvt.s32.f32 s2, s2
; VFP2-NEXT:    vstr s2, [r0, #4]
; VFP2-NEXT:    bne .LBB55_1
; VFP2-NEXT:  @ %bb.2:
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.3:
; VFP2-NEXT:  .LCPI55_0:
; VFP2-NEXT:    .long 0x4f000000 @ float 2.14748365E+9
;
; FULL-LABEL: unroll_minmax:
; FULL:       @ %bb.0:
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    mov.w lr, #512
; FULL-NEXT:    subs r1, #8
; FULL-NEXT:    subs r0, #8
; FULL-NEXT:    vldr s0, .LCPI55_0
; FULL-NEXT:  .LBB55_1: @ =>This Inner Loop Header: Depth=1
; FULL-NEXT:    vldr s2, [r1, #8]
; FULL-NEXT:    vmul.f32 s2, s2, s0
; FULL-NEXT:    vcvt.s32.f32 s2, s2
; FULL-NEXT:    vmov r2, s2
; FULL-NEXT:    str r2, [r0, #8]!
; FULL-NEXT:    vldr s2, [r1, #12]
; FULL-NEXT:    adds r1, #8
; FULL-NEXT:    vmul.f32 s2, s2, s0
; FULL-NEXT:    vcvt.s32.f32 s2, s2
; FULL-NEXT:    vstr s2, [r0, #4]
; FULL-NEXT:    le lr, .LBB55_1
; FULL-NEXT:  @ %bb.2:
; FULL-NEXT:    pop {r7, pc}
; FULL-NEXT:    .p2align 2
; FULL-NEXT:  @ %bb.3:
; FULL-NEXT:  .LCPI55_0:
; FULL-NEXT:    .long 0x4f000000 @ float 2.14748365E+9
  br label %5

4:                                                ; preds = %5
  ret void

5:                                                ; preds = %5, %3
  %6 = phi i32 [ 0, %3 ], [ %28, %5 ]
  %7 = getelementptr inbounds float, float* %1, i32 %6
  %8 = load float, float* %7, align 4
  %9 = fmul float %8, 0x41E0000000000000
  %10 = fptosi float %9 to i64
  %11 = icmp sgt i64 %10, -2147483648
  %12 = select i1 %11, i64 %10, i64 -2147483648
  %13 = icmp slt i64 %12, 2147483647
  %14 = select i1 %13, i64 %12, i64 2147483647
  %15 = trunc i64 %14 to i32
  %16 = getelementptr inbounds i32, i32* %0, i32 %6
  store i32 %15, i32* %16, align 4
  %17 = or i32 %6, 1
  %18 = getelementptr inbounds float, float* %1, i32 %17
  %19 = load float, float* %18, align 4
  %20 = fmul float %19, 0x41E0000000000000
  %21 = fptosi float %20 to i64
  %22 = icmp sgt i64 %21, -2147483648
  %23 = select i1 %22, i64 %21, i64 -2147483648
  %24 = icmp slt i64 %23, 2147483647
  %25 = select i1 %24, i64 %23, i64 2147483647
  %26 = trunc i64 %25 to i32
  %27 = getelementptr inbounds i32, i32* %0, i32 %17
  store i32 %26, i32* %27, align 4
  %28 = add nuw nsw i32 %6, 2
  %29 = icmp eq i32 %28, 1024
  br i1 %29, label %4, label %5
}

define i32 @stest_f32i32i64(float %x) {
; SOFT-LABEL: stest_f32i32i64:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    .save {r4, lr}
; SOFT-NEXT:    push {r4, lr}
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r3, #0
; SOFT-NEXT:    ldr r2, .LCPI56_0
; SOFT-NEXT:    subs r4, r0, r2
; SOFT-NEXT:    sbcs r1, r3
; SOFT-NEXT:    blt .LBB56_2
; SOFT-NEXT:  @ %bb.1: @ %entry
; SOFT-NEXT:    mov r0, r2
; SOFT-NEXT:  .LBB56_2: @ %entry
; SOFT-NEXT:    ldr r1, .LCPI56_1
; SOFT-NEXT:    cmp r0, r1
; SOFT-NEXT:    bgt .LBB56_4
; SOFT-NEXT:  @ %bb.3: @ %entry
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB56_4: @ %entry
; SOFT-NEXT:    pop {r4, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:  .LCPI56_0:
; SOFT-NEXT:    .long 32767 @ 0x7fff
; SOFT-NEXT:  .LCPI56_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
;
; VFP2-LABEL: stest_f32i32i64:
; VFP2:       @ %bb.0: @ %entry
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bl __aeabi_f2lz
; VFP2-NEXT:    movw r2, #32767
; VFP2-NEXT:    subs r3, r0, r2
; VFP2-NEXT:    sbcs r1, r1, #0
; VFP2-NEXT:    it ge
; VFP2-NEXT:    movge r0, r2
; VFP2-NEXT:    movw r1, #32768
; VFP2-NEXT:    cmn.w r0, #32768
; VFP2-NEXT:    movt r1, #65535
; VFP2-NEXT:    it le
; VFP2-NEXT:    movle r0, r1
; VFP2-NEXT:    pop {r7, pc}
;
; FULL-LABEL: stest_f32i32i64:
; FULL:       @ %bb.0: @ %entry
; FULL-NEXT:    .save {r7, lr}
; FULL-NEXT:    push {r7, lr}
; FULL-NEXT:    vmov r0, s0
; FULL-NEXT:    bl __aeabi_f2lz
; FULL-NEXT:    movw r2, #32767
; FULL-NEXT:    subs r3, r0, r2
; FULL-NEXT:    sbcs r1, r1, #0
; FULL-NEXT:    csel r0, r0, r2, lt
; FULL-NEXT:    movw r1, #32768
; FULL-NEXT:    movt r1, #65535
; FULL-NEXT:    cmn.w r0, #32768
; FULL-NEXT:    csel r0, r0, r1, gt
; FULL-NEXT:    pop {r7, pc}
entry:
  %conv = fptosi float %x to i64
  %convt = trunc i64 %conv to i32
  %0 = icmp slt i64 %conv, 32767
  %spec.store.select = select i1 %0, i32 %convt, i32 32767
  %1 = icmp sgt i32 %spec.store.select, -32768
  %spec.store.select7 = select i1 %1, i32 %spec.store.select, i32 -32768
  ret i32 %spec.store.select7
}



declare i32 @llvm.smin.i32(i32, i32)
declare i32 @llvm.smax.i32(i32, i32)
declare i32 @llvm.umin.i32(i32, i32)
declare i64 @llvm.smin.i64(i64, i64)
declare i64 @llvm.smax.i64(i64, i64)
declare i64 @llvm.umin.i64(i64, i64)
declare i128 @llvm.smin.i128(i128, i128)
declare i128 @llvm.smax.i128(i128, i128)
declare i128 @llvm.umin.i128(i128, i128)
