; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbp -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32ZBP

declare i32 @llvm.riscv.grev.i32(i32 %a, i32 %b)

define i32 @grev32(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: grev32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    grev a0, a0, a1
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.grev.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

define i32 @grev32_demandedbits(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: grev32_demandedbits:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    grev a0, a0, a1
; RV32ZBP-NEXT:    ret
  %c = and i32 %b, 31
  %tmp = call i32 @llvm.riscv.grev.i32(i32 %a, i32 %b)
  ret i32 %tmp
}

define i32 @grevi32(i32 %a) nounwind {
; RV32ZBP-LABEL: grevi32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    grevi a0, a0, 13
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.grev.i32(i32 %a, i32 13)
 ret i32 %tmp
}

declare i32 @llvm.riscv.gorc.i32(i32 %a, i32 %b)

define i32 @gorc32(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: gorc32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    gorc a0, a0, a1
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.gorc.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

define i32 @gorc32_demandedbits(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: gorc32_demandedbits:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    gorc a0, a0, a1
; RV32ZBP-NEXT:    ret
  %c = and i32 %b, 31
  %tmp = call i32 @llvm.riscv.gorc.i32(i32 %a, i32 %b)
  ret i32 %tmp
}

define i32 @gorci32(i32 %a) nounwind {
; RV32ZBP-LABEL: gorci32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    gorci a0, a0, 13
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.gorc.i32(i32 %a, i32 13)
 ret i32 %tmp
}

declare i32 @llvm.riscv.shfl.i32(i32 %a, i32 %b)

define i32 @shfl32(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: shfl32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    shfl a0, a0, a1
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.shfl.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

define i32 @shfl32_demandedbits(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: shfl32_demandedbits:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    shfl a0, a0, a1
; RV32ZBP-NEXT:    ret
  %c = and i32 %b, 15
  %tmp = call i32 @llvm.riscv.shfl.i32(i32 %a, i32 %c)
  ret i32 %tmp
}

define i32 @shfli32(i32 %a) nounwind {
; RV32ZBP-LABEL: shfli32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    shfli a0, a0, 13
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.shfl.i32(i32 %a, i32 13)
 ret i32 %tmp
}

declare i32 @llvm.riscv.unshfl.i32(i32 %a, i32 %b)

define i32 @unshfl32(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: unshfl32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    unshfl a0, a0, a1
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.unshfl.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

define i32 @unshfl32_demandedbits(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: unshfl32_demandedbits:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    unshfl a0, a0, a1
; RV32ZBP-NEXT:    ret
  %c = and i32 %b, 15
  %tmp = call i32 @llvm.riscv.unshfl.i32(i32 %a, i32 %c)
  ret i32 %tmp
}

define i32 @unshfli32(i32 %a) nounwind {
; RV32ZBP-LABEL: unshfli32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    unshfli a0, a0, 13
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.unshfl.i32(i32 %a, i32 13)
 ret i32 %tmp
}

declare i32 @llvm.riscv.xperm.n.i32(i32 %a, i32 %b)

define i32 @xpermn32(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: xpermn32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    xperm.n a0, a0, a1
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.xperm.n.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

declare i32 @llvm.riscv.xperm.b.i32(i32 %a, i32 %b)

define i32 @xpermb32(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: xpermb32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    xperm.b a0, a0, a1
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.xperm.b.i32(i32 %a, i32 %b)
 ret i32 %tmp
}

declare i32 @llvm.riscv.xperm.h.i32(i32 %a, i32 %b)

define i32 @xpermh32(i32 %a, i32 %b) nounwind {
; RV32ZBP-LABEL: xpermh32:
; RV32ZBP:       # %bb.0:
; RV32ZBP-NEXT:    xperm.h a0, a0, a1
; RV32ZBP-NEXT:    ret
  %tmp = call i32 @llvm.riscv.xperm.h.i32(i32 %a, i32 %b)
 ret i32 %tmp
}
