; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+experimental-v,+experimental-zfh,+f,+d -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+experimental-v,+experimental-zfh,+f,+d -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s

define void @fcmp_oeq_vv_v8f16(<8 x half>* %x, <8 x half>* %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oeq_vv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vmfeq.vv v8, v8, v9
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = fcmp oeq <8 x half> %a, %b
  store <8 x i1> %c, <8 x i1>* %z
  ret void
}

define void @fcmp_oeq_vv_v8f16_nonans(<8 x half>* %x, <8 x half>* %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oeq_vv_v8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v9, (a1)
; CHECK-NEXT:    vmfeq.vv v8, v8, v9
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = load <8 x half>, <8 x half>* %y
  %c = fcmp nnan oeq <8 x half> %a, %b
  store <8 x i1> %c, <8 x i1>* %z
  ret void
}

define void @fcmp_une_vv_v4f32(<4 x float>* %x, <4 x float>* %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_une_vv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = fcmp une <4 x float> %a, %b
  store <4 x i1> %c, <4 x i1>* %z
  ret void
}

define void @fcmp_une_vv_v4f32_nonans(<4 x float>* %x, <4 x float>* %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_une_vv_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v9, (a1)
; CHECK-NEXT:    vmfne.vv v0, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = load <4 x float>, <4 x float>* %y
  %c = fcmp nnan une <4 x float> %a, %b
  store <4 x i1> %c, <4 x i1>* %z
  ret void
}

define void @fcmp_ogt_vv_v2f64(<2 x double>* %x, <2 x double>* %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_ogt_vv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = fcmp ogt <2 x double> %a, %b
  store <2 x i1> %c, <2 x i1>* %z
  ret void
}

define void @fcmp_ogt_vv_v2f64_nonans(<2 x double>* %x, <2 x double>* %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_ogt_vv_v2f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v9, (a1)
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = load <2 x double>, <2 x double>* %y
  %c = fcmp nnan ogt <2 x double> %a, %b
  store <2 x i1> %c, <2 x i1>* %z
  ret void
}

define void @fcmp_olt_vv_v16f16(<16 x half>* %x, <16 x half>* %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_olt_vv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vsm.v v12, (a2)
; CHECK-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = load <16 x half>, <16 x half>* %y
  %c = fcmp olt <16 x half> %a, %b
  store <16 x i1> %c, <16 x i1>* %z
  ret void
}

define void @fcmp_olt_vv_v16f16_nonans(<16 x half>* %x, <16 x half>* %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_olt_vv_v16f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vsm.v v12, (a2)
; CHECK-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = load <16 x half>, <16 x half>* %y
  %c = fcmp nnan olt <16 x half> %a, %b
  store <16 x i1> %c, <16 x i1>* %z
  ret void
}

define void @fcmp_oge_vv_v8f32(<8 x float>* %x, <8 x float>* %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oge_vv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v10, (a1)
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vsm.v v12, (a2)
; CHECK-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = load <8 x float>, <8 x float>* %y
  %c = fcmp oge <8 x float> %a, %b
  store <8 x i1> %c, <8 x i1>* %z
  ret void
}

define void @fcmp_oge_vv_v8f32_nonans(<8 x float>* %x, <8 x float>* %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oge_vv_v8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v10, (a1)
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vsm.v v12, (a2)
; CHECK-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = load <8 x float>, <8 x float>* %y
  %c = fcmp nnan oge <8 x float> %a, %b
  store <8 x i1> %c, <8 x i1>* %z
  ret void
}

define void @fcmp_ole_vv_v4f64(<4 x double>* %x, <4 x double>* %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ole_vv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v10, (a1)
; CHECK-NEXT:    vmfle.vv v0, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = load <4 x double>, <4 x double>* %y
  %c = fcmp ole <4 x double> %a, %b
  store <4 x i1> %c, <4 x i1>* %z
  ret void
}

define void @fcmp_ole_vv_v4f64_nonans(<4 x double>* %x, <4 x double>* %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ole_vv_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v10, (a1)
; CHECK-NEXT:    vmfle.vv v0, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = load <4 x double>, <4 x double>* %y
  %c = fcmp nnan ole <4 x double> %a, %b
  store <4 x i1> %c, <4 x i1>* %z
  ret void
}

define void @fcmp_ule_vv_v32f16(<32 x half>* %x, <32 x half>* %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ule_vv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a3, 32
; CHECK-NEXT:    vsetvli zero, a3, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v12, (a1)
; CHECK-NEXT:    vmflt.vv v16, v12, v8
; CHECK-NEXT:    vmnand.mm v8, v16, v16
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <32 x half>, <32 x half>* %x
  %b = load <32 x half>, <32 x half>* %y
  %c = fcmp ule <32 x half> %a, %b
  store <32 x i1> %c, <32 x i1>* %z
  ret void
}

define void @fcmp_ule_vv_v32f16_nonans(<32 x half>* %x, <32 x half>* %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ule_vv_v32f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a3, 32
; CHECK-NEXT:    vsetvli zero, a3, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v12, (a1)
; CHECK-NEXT:    vmfle.vv v16, v8, v12
; CHECK-NEXT:    vsm.v v16, (a2)
; CHECK-NEXT:    ret
  %a = load <32 x half>, <32 x half>* %x
  %b = load <32 x half>, <32 x half>* %y
  %c = fcmp nnan ule <32 x half> %a, %b
  store <32 x i1> %c, <32 x i1>* %z
  ret void
}

define void @fcmp_uge_vv_v16f32(<16 x float>* %x, <16 x float>* %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_uge_vv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v12, (a1)
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmnand.mm v8, v16, v16
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <16 x float>, <16 x float>* %x
  %b = load <16 x float>, <16 x float>* %y
  %c = fcmp uge <16 x float> %a, %b
  store <16 x i1> %c, <16 x i1>* %z
  ret void
}

define void @fcmp_uge_vv_v16f32_nonans(<16 x float>* %x, <16 x float>* %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_uge_vv_v16f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v12, (a1)
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vsm.v v16, (a2)
; CHECK-NEXT:    ret
  %a = load <16 x float>, <16 x float>* %x
  %b = load <16 x float>, <16 x float>* %y
  %c = fcmp nnan uge <16 x float> %a, %b
  store <16 x i1> %c, <16 x i1>* %z
  ret void
}

define void @fcmp_ult_vv_v8f64(<8 x double>* %x, <8 x double>* %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_ult_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v12, (a1)
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmnand.mm v8, v16, v16
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <8 x double>, <8 x double>* %x
  %b = load <8 x double>, <8 x double>* %y
  %c = fcmp ult <8 x double> %a, %b
  store <8 x i1> %c, <8 x i1>* %z
  ret void
}

define void @fcmp_ult_vv_v8f64_nonans(<8 x double>* %x, <8 x double>* %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_ult_vv_v8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v12, (a1)
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vsm.v v16, (a2)
; CHECK-NEXT:    ret
  %a = load <8 x double>, <8 x double>* %x
  %b = load <8 x double>, <8 x double>* %y
  %c = fcmp nnan ult <8 x double> %a, %b
  store <8 x i1> %c, <8 x i1>* %z
  ret void
}

define void @fcmp_ugt_vv_v64f16(<64 x half>* %x, <64 x half>* %y, <64 x i1>* %z) {
; CHECK-LABEL: fcmp_ugt_vv_v64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a3, 64
; CHECK-NEXT:    vsetvli zero, a3, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v16, (a1)
; CHECK-NEXT:    vmfle.vv v24, v8, v16
; CHECK-NEXT:    vmnand.mm v8, v24, v24
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <64 x half>, <64 x half>* %x
  %b = load <64 x half>, <64 x half>* %y
  %c = fcmp ugt <64 x half> %a, %b
  store <64 x i1> %c, <64 x i1>* %z
  ret void
}

define void @fcmp_ugt_vv_v64f16_nonans(<64 x half>* %x, <64 x half>* %y, <64 x i1>* %z) {
; CHECK-LABEL: fcmp_ugt_vv_v64f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a3, 64
; CHECK-NEXT:    vsetvli zero, a3, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v16, (a1)
; CHECK-NEXT:    vmflt.vv v24, v16, v8
; CHECK-NEXT:    vsm.v v24, (a2)
; CHECK-NEXT:    ret
  %a = load <64 x half>, <64 x half>* %x
  %b = load <64 x half>, <64 x half>* %y
  %c = fcmp nnan ugt <64 x half> %a, %b
  store <64 x i1> %c, <64 x i1>* %z
  ret void
}

define void @fcmp_ueq_vv_v32f32(<32 x float>* %x, <32 x float>* %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ueq_vv_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a3, 32
; CHECK-NEXT:    vsetvli zero, a3, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v16, (a1)
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmnor.mm v8, v25, v24
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <32 x float>, <32 x float>* %x
  %b = load <32 x float>, <32 x float>* %y
  %c = fcmp ueq <32 x float> %a, %b
  store <32 x i1> %c, <32 x i1>* %z
  ret void
}

define void @fcmp_ueq_vv_v32f32_nonans(<32 x float>* %x, <32 x float>* %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ueq_vv_v32f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a3, 32
; CHECK-NEXT:    vsetvli zero, a3, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v16, (a1)
; CHECK-NEXT:    vmfeq.vv v24, v8, v16
; CHECK-NEXT:    vsm.v v24, (a2)
; CHECK-NEXT:    ret
  %a = load <32 x float>, <32 x float>* %x
  %b = load <32 x float>, <32 x float>* %y
  %c = fcmp nnan ueq <32 x float> %a, %b
  store <32 x i1> %c, <32 x i1>* %z
  ret void
}

define void @fcmp_one_vv_v8f64(<16 x double>* %x, <16 x double>* %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_one_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v16, (a1)
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmor.mm v8, v25, v24
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <16 x double>, <16 x double>* %x
  %b = load <16 x double>, <16 x double>* %y
  %c = fcmp one <16 x double> %a, %b
  store <16 x i1> %c, <16 x i1>* %z
  ret void
}

define void @fcmp_one_vv_v8f64_nonans(<16 x double>* %x, <16 x double>* %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_one_vv_v8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v16, (a1)
; CHECK-NEXT:    vmfne.vv v24, v8, v16
; CHECK-NEXT:    vsm.v v24, (a2)
; CHECK-NEXT:    ret
  %a = load <16 x double>, <16 x double>* %x
  %b = load <16 x double>, <16 x double>* %y
  %c = fcmp nnan one <16 x double> %a, %b
  store <16 x i1> %c, <16 x i1>* %z
  ret void
}

define void @fcmp_ord_vv_v4f16(<4 x half>* %x, <4 x half>* %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ord_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmfeq.vv v9, v9, v9
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <4 x half>, <4 x half>* %x
  %b = load <4 x half>, <4 x half>* %y
  %c = fcmp ord <4 x half> %a, %b
  store <4 x i1> %c, <4 x i1>* %z
  ret void
}

define void @fcmp_uno_vv_v4f16(<2 x half>* %x, <2 x half>* %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_uno_vv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a1)
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmfne.vv v9, v9, v9
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a2)
; CHECK-NEXT:    ret
  %a = load <2 x half>, <2 x half>* %x
  %b = load <2 x half>, <2 x half>* %y
  %c = fcmp uno <2 x half> %a, %b
  store <2 x i1> %c, <2 x i1>* %z
  ret void
}

define void @fcmp_oeq_vf_v8f16(<8 x half>* %x, half %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oeq_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfeq.vf v8, v8, fa0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> undef, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> undef, <8 x i32> zeroinitializer
  %d = fcmp oeq <8 x half> %a, %c
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_oeq_vf_v8f16_nonans(<8 x half>* %x, half %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oeq_vf_v8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfeq.vf v8, v8, fa0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> undef, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> undef, <8 x i32> zeroinitializer
  %d = fcmp nnan oeq <8 x half> %a, %c
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_une_vf_v4f32(<4 x float>* %x, float %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_une_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> undef, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> undef, <4 x i32> zeroinitializer
  %d = fcmp une <4 x float> %a, %c
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_une_vf_v4f32_nonans(<4 x float>* %x, float %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_une_vf_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> undef, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> undef, <4 x i32> zeroinitializer
  %d = fcmp nnan une <4 x float> %a, %c
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_ogt_vf_v2f64(<2 x double>* %x, double %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_ogt_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> undef, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> undef, <2 x i32> zeroinitializer
  %d = fcmp ogt <2 x double> %a, %c
  store <2 x i1> %d, <2 x i1>* %z
  ret void
}

define void @fcmp_ogt_vf_v2f64_nonans(<2 x double>* %x, double %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_ogt_vf_v2f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> undef, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> undef, <2 x i32> zeroinitializer
  %d = fcmp nnan ogt <2 x double> %a, %c
  store <2 x i1> %d, <2 x i1>* %z
  ret void
}

define void @fcmp_olt_vf_v16f16(<16 x half>* %x, half %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_olt_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vsm.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = insertelement <16 x half> undef, half %y, i32 0
  %c = shufflevector <16 x half> %b, <16 x half> undef, <16 x i32> zeroinitializer
  %d = fcmp olt <16 x half> %a, %c
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_olt_vf_v16f16_nonans(<16 x half>* %x, half %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_olt_vf_v16f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vsm.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = insertelement <16 x half> undef, half %y, i32 0
  %c = shufflevector <16 x half> %b, <16 x half> undef, <16 x i32> zeroinitializer
  %d = fcmp nnan olt <16 x half> %a, %c
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_oge_vf_v8f32(<8 x float>* %x, float %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oge_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vsm.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = insertelement <8 x float> undef, float %y, i32 0
  %c = shufflevector <8 x float> %b, <8 x float> undef, <8 x i32> zeroinitializer
  %d = fcmp oge <8 x float> %a, %c
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_oge_vf_v8f32_nonans(<8 x float>* %x, float %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oge_vf_v8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vsm.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = insertelement <8 x float> undef, float %y, i32 0
  %c = shufflevector <8 x float> %b, <8 x float> undef, <8 x i32> zeroinitializer
  %d = fcmp nnan oge <8 x float> %a, %c
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_ole_vf_v4f64(<4 x double>* %x, double %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ole_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = insertelement <4 x double> undef, double %y, i32 0
  %c = shufflevector <4 x double> %b, <4 x double> undef, <4 x i32> zeroinitializer
  %d = fcmp ole <4 x double> %a, %c
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_ole_vf_v4f64_nonans(<4 x double>* %x, double %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ole_vf_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = insertelement <4 x double> undef, double %y, i32 0
  %c = shufflevector <4 x double> %b, <4 x double> undef, <4 x i32> zeroinitializer
  %d = fcmp nnan ole <4 x double> %a, %c
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_ule_vf_v32f16(<32 x half>* %x, half %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ule_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnand.mm v8, v12, v12
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <32 x half>, <32 x half>* %x
  %b = insertelement <32 x half> undef, half %y, i32 0
  %c = shufflevector <32 x half> %b, <32 x half> undef, <32 x i32> zeroinitializer
  %d = fcmp ule <32 x half> %a, %c
  store <32 x i1> %d, <32 x i1>* %z
  ret void
}

define void @fcmp_ule_vf_v32f16_nonans(<32 x half>* %x, half %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ule_vf_v32f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vsm.v v12, (a1)
; CHECK-NEXT:    ret
  %a = load <32 x half>, <32 x half>* %x
  %b = insertelement <32 x half> undef, half %y, i32 0
  %c = shufflevector <32 x half> %b, <32 x half> undef, <32 x i32> zeroinitializer
  %d = fcmp nnan ule <32 x half> %a, %c
  store <32 x i1> %d, <32 x i1>* %z
  ret void
}

define void @fcmp_uge_vf_v16f32(<16 x float>* %x, float %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_uge_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnand.mm v8, v12, v12
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x float>, <16 x float>* %x
  %b = insertelement <16 x float> undef, float %y, i32 0
  %c = shufflevector <16 x float> %b, <16 x float> undef, <16 x i32> zeroinitializer
  %d = fcmp uge <16 x float> %a, %c
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_uge_vf_v16f32_nonans(<16 x float>* %x, float %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_uge_vf_v16f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vsm.v v12, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x float>, <16 x float>* %x
  %b = insertelement <16 x float> undef, float %y, i32 0
  %c = shufflevector <16 x float> %b, <16 x float> undef, <16 x i32> zeroinitializer
  %d = fcmp nnan uge <16 x float> %a, %c
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_ult_vf_v8f64(<8 x double>* %x, double %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_ult_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnand.mm v8, v12, v12
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x double>, <8 x double>* %x
  %b = insertelement <8 x double> undef, double %y, i32 0
  %c = shufflevector <8 x double> %b, <8 x double> undef, <8 x i32> zeroinitializer
  %d = fcmp ult <8 x double> %a, %c
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_ult_vf_v8f64_nonans(<8 x double>* %x, double %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_ult_vf_v8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vsm.v v12, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x double>, <8 x double>* %x
  %b = insertelement <8 x double> undef, double %y, i32 0
  %c = shufflevector <8 x double> %b, <8 x double> undef, <8 x i32> zeroinitializer
  %d = fcmp nnan ult <8 x double> %a, %c
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_ugt_vf_v64f16(<64 x half>* %x, half %y, <64 x i1>* %z) {
; CHECK-LABEL: fcmp_ugt_vf_v64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnand.mm v8, v16, v16
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <64 x half>, <64 x half>* %x
  %b = insertelement <64 x half> undef, half %y, i32 0
  %c = shufflevector <64 x half> %b, <64 x half> undef, <64 x i32> zeroinitializer
  %d = fcmp ugt <64 x half> %a, %c
  store <64 x i1> %d, <64 x i1>* %z
  ret void
}

define void @fcmp_ugt_vf_v64f16_nonans(<64 x half>* %x, half %y, <64 x i1>* %z) {
; CHECK-LABEL: fcmp_ugt_vf_v64f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vsm.v v16, (a1)
; CHECK-NEXT:    ret
  %a = load <64 x half>, <64 x half>* %x
  %b = insertelement <64 x half> undef, half %y, i32 0
  %c = shufflevector <64 x half> %b, <64 x half> undef, <64 x i32> zeroinitializer
  %d = fcmp nnan ugt <64 x half> %a, %c
  store <64 x i1> %d, <64 x i1>* %z
  ret void
}

define void @fcmp_ueq_vf_v32f32(<32 x float>* %x, float %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ueq_vf_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v8, v17, v16
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <32 x float>, <32 x float>* %x
  %b = insertelement <32 x float> undef, float %y, i32 0
  %c = shufflevector <32 x float> %b, <32 x float> undef, <32 x i32> zeroinitializer
  %d = fcmp ueq <32 x float> %a, %c
  store <32 x i1> %d, <32 x i1>* %z
  ret void
}

define void @fcmp_ueq_vf_v32f32_nonans(<32 x float>* %x, float %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ueq_vf_v32f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfeq.vf v16, v8, fa0
; CHECK-NEXT:    vsm.v v16, (a1)
; CHECK-NEXT:    ret
  %a = load <32 x float>, <32 x float>* %x
  %b = insertelement <32 x float> undef, float %y, i32 0
  %c = shufflevector <32 x float> %b, <32 x float> undef, <32 x i32> zeroinitializer
  %d = fcmp nnan ueq <32 x float> %a, %c
  store <32 x i1> %d, <32 x i1>* %z
  ret void
}

define void @fcmp_one_vf_v8f64(<16 x double>* %x, double %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_one_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v8, v17, v16
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x double>, <16 x double>* %x
  %b = insertelement <16 x double> undef, double %y, i32 0
  %c = shufflevector <16 x double> %b, <16 x double> undef, <16 x i32> zeroinitializer
  %d = fcmp one <16 x double> %a, %c
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_one_vf_v8f64_nonans(<16 x double>* %x, double %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_one_vf_v8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vf v16, v8, fa0
; CHECK-NEXT:    vsm.v v16, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x double>, <16 x double>* %x
  %b = insertelement <16 x double> undef, double %y, i32 0
  %c = shufflevector <16 x double> %b, <16 x double> undef, <16 x i32> zeroinitializer
  %d = fcmp nnan one <16 x double> %a, %c
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_ord_vf_v4f16(<4 x half>* %x, half %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ord_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x half>, <4 x half>* %x
  %b = insertelement <4 x half> undef, half %y, i32 0
  %c = shufflevector <4 x half> %b, <4 x half> undef, <4 x i32> zeroinitializer
  %d = fcmp ord <4 x half> %a, %c
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_uno_vf_v4f16(<2 x half>* %x, half %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_uno_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x half>, <2 x half>* %x
  %b = insertelement <2 x half> undef, half %y, i32 0
  %c = shufflevector <2 x half> %b, <2 x half> undef, <2 x i32> zeroinitializer
  %d = fcmp uno <2 x half> %a, %c
  store <2 x i1> %d, <2 x i1>* %z
  ret void
}

define void @fcmp_oeq_fv_v8f16(<8 x half>* %x, half %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oeq_fv_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfeq.vf v8, v8, fa0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> undef, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> undef, <8 x i32> zeroinitializer
  %d = fcmp oeq <8 x half> %c, %a
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_oeq_fv_v8f16_nonans(<8 x half>* %x, half %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oeq_fv_v8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfeq.vf v8, v8, fa0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x half>, <8 x half>* %x
  %b = insertelement <8 x half> undef, half %y, i32 0
  %c = shufflevector <8 x half> %b, <8 x half> undef, <8 x i32> zeroinitializer
  %d = fcmp nnan oeq <8 x half> %c, %a
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_une_fv_v4f32(<4 x float>* %x, float %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_une_fv_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> undef, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> undef, <4 x i32> zeroinitializer
  %d = fcmp une <4 x float> %c, %a
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_une_fv_v4f32_nonans(<4 x float>* %x, float %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_une_fv_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x float>, <4 x float>* %x
  %b = insertelement <4 x float> undef, float %y, i32 0
  %c = shufflevector <4 x float> %b, <4 x float> undef, <4 x i32> zeroinitializer
  %d = fcmp nnan une <4 x float> %c, %a
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_ogt_fv_v2f64(<2 x double>* %x, double %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_ogt_fv_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> undef, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> undef, <2 x i32> zeroinitializer
  %d = fcmp ogt <2 x double> %c, %a
  store <2 x i1> %d, <2 x i1>* %z
  ret void
}

define void @fcmp_ogt_fv_v2f64_nonans(<2 x double>* %x, double %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_ogt_fv_v2f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x double>, <2 x double>* %x
  %b = insertelement <2 x double> undef, double %y, i32 0
  %c = shufflevector <2 x double> %b, <2 x double> undef, <2 x i32> zeroinitializer
  %d = fcmp nnan ogt <2 x double> %c, %a
  store <2 x i1> %d, <2 x i1>* %z
  ret void
}

define void @fcmp_olt_fv_v16f16(<16 x half>* %x, half %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_olt_fv_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vsm.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = insertelement <16 x half> undef, half %y, i32 0
  %c = shufflevector <16 x half> %b, <16 x half> undef, <16 x i32> zeroinitializer
  %d = fcmp olt <16 x half> %c, %a
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_olt_fv_v16f16_nonans(<16 x half>* %x, half %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_olt_fv_v16f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vsm.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x half>, <16 x half>* %x
  %b = insertelement <16 x half> undef, half %y, i32 0
  %c = shufflevector <16 x half> %b, <16 x half> undef, <16 x i32> zeroinitializer
  %d = fcmp nnan olt <16 x half> %c, %a
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_oge_fv_v8f32(<8 x float>* %x, float %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oge_fv_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vsm.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = insertelement <8 x float> undef, float %y, i32 0
  %c = shufflevector <8 x float> %b, <8 x float> undef, <8 x i32> zeroinitializer
  %d = fcmp oge <8 x float> %c, %a
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_oge_fv_v8f32_nonans(<8 x float>* %x, float %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_oge_fv_v8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vsm.v v10, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x float>, <8 x float>* %x
  %b = insertelement <8 x float> undef, float %y, i32 0
  %c = shufflevector <8 x float> %b, <8 x float> undef, <8 x i32> zeroinitializer
  %d = fcmp nnan oge <8 x float> %c, %a
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_ole_fv_v4f64(<4 x double>* %x, double %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ole_fv_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = insertelement <4 x double> undef, double %y, i32 0
  %c = shufflevector <4 x double> %b, <4 x double> undef, <4 x i32> zeroinitializer
  %d = fcmp ole <4 x double> %c, %a
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_ole_fv_v4f64_nonans(<4 x double>* %x, double %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ole_fv_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x double>, <4 x double>* %x
  %b = insertelement <4 x double> undef, double %y, i32 0
  %c = shufflevector <4 x double> %b, <4 x double> undef, <4 x i32> zeroinitializer
  %d = fcmp nnan ole <4 x double> %c, %a
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_ule_fv_v32f16(<32 x half>* %x, half %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ule_fv_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnand.mm v8, v12, v12
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <32 x half>, <32 x half>* %x
  %b = insertelement <32 x half> undef, half %y, i32 0
  %c = shufflevector <32 x half> %b, <32 x half> undef, <32 x i32> zeroinitializer
  %d = fcmp ule <32 x half> %c, %a
  store <32 x i1> %d, <32 x i1>* %z
  ret void
}

define void @fcmp_ule_fv_v32f16_nonans(<32 x half>* %x, half %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ule_fv_v32f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vsm.v v12, (a1)
; CHECK-NEXT:    ret
  %a = load <32 x half>, <32 x half>* %x
  %b = insertelement <32 x half> undef, half %y, i32 0
  %c = shufflevector <32 x half> %b, <32 x half> undef, <32 x i32> zeroinitializer
  %d = fcmp nnan ule <32 x half> %c, %a
  store <32 x i1> %d, <32 x i1>* %z
  ret void
}

define void @fcmp_uge_fv_v16f32(<16 x float>* %x, float %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_uge_fv_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnand.mm v8, v12, v12
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x float>, <16 x float>* %x
  %b = insertelement <16 x float> undef, float %y, i32 0
  %c = shufflevector <16 x float> %b, <16 x float> undef, <16 x i32> zeroinitializer
  %d = fcmp uge <16 x float> %c, %a
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_uge_fv_v16f32_nonans(<16 x float>* %x, float %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_uge_fv_v16f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vsm.v v12, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x float>, <16 x float>* %x
  %b = insertelement <16 x float> undef, float %y, i32 0
  %c = shufflevector <16 x float> %b, <16 x float> undef, <16 x i32> zeroinitializer
  %d = fcmp nnan uge <16 x float> %c, %a
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_ult_fv_v8f64(<8 x double>* %x, double %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_ult_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnand.mm v8, v12, v12
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x double>, <8 x double>* %x
  %b = insertelement <8 x double> undef, double %y, i32 0
  %c = shufflevector <8 x double> %b, <8 x double> undef, <8 x i32> zeroinitializer
  %d = fcmp ult <8 x double> %c, %a
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_ult_fv_v8f64_nonans(<8 x double>* %x, double %y, <8 x i1>* %z) {
; CHECK-LABEL: fcmp_ult_fv_v8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vsm.v v12, (a1)
; CHECK-NEXT:    ret
  %a = load <8 x double>, <8 x double>* %x
  %b = insertelement <8 x double> undef, double %y, i32 0
  %c = shufflevector <8 x double> %b, <8 x double> undef, <8 x i32> zeroinitializer
  %d = fcmp nnan ult <8 x double> %c, %a
  store <8 x i1> %d, <8 x i1>* %z
  ret void
}

define void @fcmp_ugt_fv_v64f16(<64 x half>* %x, half %y, <64 x i1>* %z) {
; CHECK-LABEL: fcmp_ugt_fv_v64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnand.mm v8, v16, v16
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <64 x half>, <64 x half>* %x
  %b = insertelement <64 x half> undef, half %y, i32 0
  %c = shufflevector <64 x half> %b, <64 x half> undef, <64 x i32> zeroinitializer
  %d = fcmp ugt <64 x half> %c, %a
  store <64 x i1> %d, <64 x i1>* %z
  ret void
}

define void @fcmp_ugt_fv_v64f16_nonans(<64 x half>* %x, half %y, <64 x i1>* %z) {
; CHECK-LABEL: fcmp_ugt_fv_v64f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vsm.v v16, (a1)
; CHECK-NEXT:    ret
  %a = load <64 x half>, <64 x half>* %x
  %b = insertelement <64 x half> undef, half %y, i32 0
  %c = shufflevector <64 x half> %b, <64 x half> undef, <64 x i32> zeroinitializer
  %d = fcmp nnan ugt <64 x half> %c, %a
  store <64 x i1> %d, <64 x i1>* %z
  ret void
}

define void @fcmp_ueq_fv_v32f32(<32 x float>* %x, float %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ueq_fv_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v8, v17, v16
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <32 x float>, <32 x float>* %x
  %b = insertelement <32 x float> undef, float %y, i32 0
  %c = shufflevector <32 x float> %b, <32 x float> undef, <32 x i32> zeroinitializer
  %d = fcmp ueq <32 x float> %c, %a
  store <32 x i1> %d, <32 x i1>* %z
  ret void
}

define void @fcmp_ueq_fv_v32f32_nonans(<32 x float>* %x, float %y, <32 x i1>* %z) {
; CHECK-LABEL: fcmp_ueq_fv_v32f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfeq.vf v16, v8, fa0
; CHECK-NEXT:    vsm.v v16, (a1)
; CHECK-NEXT:    ret
  %a = load <32 x float>, <32 x float>* %x
  %b = insertelement <32 x float> undef, float %y, i32 0
  %c = shufflevector <32 x float> %b, <32 x float> undef, <32 x i32> zeroinitializer
  %d = fcmp nnan ueq <32 x float> %c, %a
  store <32 x i1> %d, <32 x i1>* %z
  ret void
}

define void @fcmp_one_fv_v8f64(<16 x double>* %x, double %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_one_fv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v8, v17, v16
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x double>, <16 x double>* %x
  %b = insertelement <16 x double> undef, double %y, i32 0
  %c = shufflevector <16 x double> %b, <16 x double> undef, <16 x i32> zeroinitializer
  %d = fcmp one <16 x double> %c, %a
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_one_fv_v8f64_nonans(<16 x double>* %x, double %y, <16 x i1>* %z) {
; CHECK-LABEL: fcmp_one_fv_v8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vf v16, v8, fa0
; CHECK-NEXT:    vsm.v v16, (a1)
; CHECK-NEXT:    ret
  %a = load <16 x double>, <16 x double>* %x
  %b = insertelement <16 x double> undef, double %y, i32 0
  %c = shufflevector <16 x double> %b, <16 x double> undef, <16 x i32> zeroinitializer
  %d = fcmp nnan one <16 x double> %c, %a
  store <16 x i1> %d, <16 x i1>* %z
  ret void
}

define void @fcmp_ord_fv_v4f16(<4 x half>* %x, half %y, <4 x i1>* %z) {
; CHECK-LABEL: fcmp_ord_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfeq.vf v9, v9, fa0
; CHECK-NEXT:    vmfeq.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <4 x half>, <4 x half>* %x
  %b = insertelement <4 x half> undef, half %y, i32 0
  %c = shufflevector <4 x half> %b, <4 x half> undef, <4 x i32> zeroinitializer
  %d = fcmp ord <4 x half> %c, %a
  store <4 x i1> %d, <4 x i1>* %z
  ret void
}

define void @fcmp_uno_fv_v4f16(<2 x half>* %x, half %y, <2 x i1>* %z) {
; CHECK-LABEL: fcmp_uno_fv_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfne.vf v9, v9, fa0
; CHECK-NEXT:    vmfne.vv v8, v8, v8
; CHECK-NEXT:    vmor.mm v0, v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.v.i v9, 0
; CHECK-NEXT:    vsetivli zero, 2, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v9, v8, 0
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vmsne.vi v8, v9, 0
; CHECK-NEXT:    vsm.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <2 x half>, <2 x half>* %x
  %b = insertelement <2 x half> undef, half %y, i32 0
  %c = shufflevector <2 x half> %b, <2 x half> undef, <2 x i32> zeroinitializer
  %d = fcmp uno <2 x half> %c, %a
  store <2 x i1> %d, <2 x i1>* %z
  ret void
}
