; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+experimental-zfh,+experimental-v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+experimental-zfh,+experimental-v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half>, <vscale x 1 x half>)

define <vscale x 1 x half> @vfcopysign_vv_nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %vs)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_vf_nxv1f16(<vscale x 1 x half> %vm, half %s) {
; CHECK-LABEL: vfcopysign_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> undef, <vscale x 1 x i32> zeroinitializer
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %splat)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_vv_nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x half> %vs
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %n)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_vf_nxv1f16(<vscale x 1 x half> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x half> %splat
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %n)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_exttrunc_vv_nxv1f16_nxv1f32(<vscale x 1 x half> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fptrunc <vscale x 1 x float> %vs to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %e)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_exttrunc_vf_nxv1f16_nxv1f32(<vscale x 1 x half> %vm, float %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> undef, <vscale x 1 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 1 x float> %splat to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %esplat)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_exttrunc_vv_nxv1f16_nxv1f32(<vscale x 1 x half> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x float> %vs
  %eneg = fptrunc <vscale x 1 x float> %n to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %eneg)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_exttrunc_vf_nxv1f16_nxv1f32(<vscale x 1 x half> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x float> %splat
  %eneg = fptrunc <vscale x 1 x float> %n to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %eneg)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_exttrunc_vv_nxv1f16_nxv1f64(<vscale x 1 x half> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfncvt.rod.f.f.w v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v9, v10
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %e = fptrunc <vscale x 1 x double> %vs to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %e)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopysign_exttrunc_vf_nxv1f16_nxv1f64(<vscale x 1 x half> %vm, double %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfncvt.rod.f.f.w v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v9, v10
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> undef, <vscale x 1 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 1 x double> %splat to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %esplat)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_exttrunc_vv_nxv1f16_nxv1f64(<vscale x 1 x half> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfncvt.rod.f.f.w v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v9, v10
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x double> %vs
  %eneg = fptrunc <vscale x 1 x double> %n to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %eneg)
  ret <vscale x 1 x half> %r
}

define <vscale x 1 x half> @vfcopynsign_exttrunc_vf_nxv1f16_nxv1f64(<vscale x 1 x half> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfncvt.rod.f.f.w v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v9, v10
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x double> %splat
  %eneg = fptrunc <vscale x 1 x double> %n to <vscale x 1 x half>
  %r = call <vscale x 1 x half> @llvm.copysign.nxv1f16(<vscale x 1 x half> %vm, <vscale x 1 x half> %eneg)
  ret <vscale x 1 x half> %r
}

declare <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half>, <vscale x 2 x half>)

define <vscale x 2 x half> @vfcopysign_vv_nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %vs)
  ret <vscale x 2 x half> %r
}

define <vscale x 2 x half> @vfcopysign_vf_nxv2f16(<vscale x 2 x half> %vm, half %s) {
; CHECK-LABEL: vfcopysign_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> undef, <vscale x 2 x i32> zeroinitializer
  %r = call <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %splat)
  ret <vscale x 2 x half> %r
}

define <vscale x 2 x half> @vfcopynsign_vv_nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 2 x half> %vs
  %r = call <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %n)
  ret <vscale x 2 x half> %r
}

define <vscale x 2 x half> @vfcopynsign_vf_nxv2f16(<vscale x 2 x half> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> undef, <vscale x 2 x i32> zeroinitializer
  %n = fneg <vscale x 2 x half> %splat
  %r = call <vscale x 2 x half> @llvm.copysign.nxv2f16(<vscale x 2 x half> %vm, <vscale x 2 x half> %n)
  ret <vscale x 2 x half> %r
}

declare <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>)

define <vscale x 4 x half> @vfcopysign_vv_nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %vs)
  ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @vfcopysign_vf_nxv4f16(<vscale x 4 x half> %vm, half %s) {
; CHECK-LABEL: vfcopysign_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> undef, <vscale x 4 x i32> zeroinitializer
  %r = call <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %splat)
  ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @vfcopynsign_vv_nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 4 x half> %vs
  %r = call <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %n)
  ret <vscale x 4 x half> %r
}

define <vscale x 4 x half> @vfcopynsign_vf_nxv4f16(<vscale x 4 x half> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> undef, <vscale x 4 x i32> zeroinitializer
  %n = fneg <vscale x 4 x half> %splat
  %r = call <vscale x 4 x half> @llvm.copysign.nxv4f16(<vscale x 4 x half> %vm, <vscale x 4 x half> %n)
  ret <vscale x 4 x half> %r
}

declare <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>)

define <vscale x 8 x half> @vfcopysign_vv_nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %vs)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_vf_nxv8f16(<vscale x 8 x half> %vm, half %s) {
; CHECK-LABEL: vfcopysign_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %splat)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_vv_nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x half> %vs
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %n)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_vf_nxv8f16(<vscale x 8 x half> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x half> %splat
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %n)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_exttrunc_vv_nxv8f16_nxv8f32(<vscale x 8 x half> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v12
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fptrunc <vscale x 8 x float> %vs to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %e)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_exttrunc_vf_nxv8f16_nxv8f32(<vscale x 8 x half> %vm, float %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v12
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 8 x float> %splat to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %esplat)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_exttrunc_vv_nxv8f16_nxv8f32(<vscale x 8 x half> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v12
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x float> %vs
  %eneg = fptrunc <vscale x 8 x float> %n to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %eneg)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_exttrunc_vf_nxv8f16_nxv8f32(<vscale x 8 x half> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v12
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x float> %splat
  %eneg = fptrunc <vscale x 8 x float> %n to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %eneg)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_exttrunc_vv_nxv8f16_nxv8f64(<vscale x 8 x half> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfncvt.rod.f.f.w v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v12
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fptrunc <vscale x 8 x double> %vs to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %e)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopysign_exttrunc_vf_nxv8f16_nxv8f64(<vscale x 8 x half> %vm, double %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfncvt.rod.f.f.w v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v12
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 8 x double> %splat to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %esplat)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_exttrunc_vv_nxv8f16_nxv8f64(<vscale x 8 x half> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfncvt.rod.f.f.w v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v12
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x double> %vs
  %eneg = fptrunc <vscale x 8 x double> %n to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %eneg)
  ret <vscale x 8 x half> %r
}

define <vscale x 8 x half> @vfcopynsign_exttrunc_vf_nxv8f16_nxv8f64(<vscale x 8 x half> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfncvt.rod.f.f.w v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v12
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x double> %splat
  %eneg = fptrunc <vscale x 8 x double> %n to <vscale x 8 x half>
  %r = call <vscale x 8 x half> @llvm.copysign.nxv8f16(<vscale x 8 x half> %vm, <vscale x 8 x half> %eneg)
  ret <vscale x 8 x half> %r
}

declare <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half>, <vscale x 16 x half>)

define <vscale x 16 x half> @vfcopysign_vv_nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %r = call <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %vs)
  ret <vscale x 16 x half> %r
}

define <vscale x 16 x half> @vfcopysign_vf_nxv16f16(<vscale x 16 x half> %vm, half %s) {
; CHECK-LABEL: vfcopysign_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> undef, <vscale x 16 x i32> zeroinitializer
  %r = call <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %splat)
  ret <vscale x 16 x half> %r
}

define <vscale x 16 x half> @vfcopynsign_vv_nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %n = fneg <vscale x 16 x half> %vs
  %r = call <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %n)
  ret <vscale x 16 x half> %r
}

define <vscale x 16 x half> @vfcopynsign_vf_nxv16f16(<vscale x 16 x half> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> undef, <vscale x 16 x i32> zeroinitializer
  %n = fneg <vscale x 16 x half> %splat
  %r = call <vscale x 16 x half> @llvm.copysign.nxv16f16(<vscale x 16 x half> %vm, <vscale x 16 x half> %n)
  ret <vscale x 16 x half> %r
}

declare <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half>, <vscale x 32 x half>)

define <vscale x 32 x half> @vfcopysign_vv_nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %vs)
  ret <vscale x 32 x half> %r
}

define <vscale x 32 x half> @vfcopysign_vf_nxv32f16(<vscale x 32 x half> %vm, half %s) {
; CHECK-LABEL: vfcopysign_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> undef, <vscale x 32 x i32> zeroinitializer
  %r = call <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %splat)
  ret <vscale x 32 x half> %r
}

define <vscale x 32 x half> @vfcopynsign_vv_nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v16
; CHECK-NEXT:    ret
  %n = fneg <vscale x 32 x half> %vs
  %r = call <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %n)
  ret <vscale x 32 x half> %r
}

define <vscale x 32 x half> @vfcopynsign_vf_nxv32f16(<vscale x 32 x half> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> undef, <vscale x 32 x i32> zeroinitializer
  %n = fneg <vscale x 32 x half> %splat
  %r = call <vscale x 32 x half> @llvm.copysign.nxv32f16(<vscale x 32 x half> %vm, <vscale x 32 x half> %n)
  ret <vscale x 32 x half> %r
}

declare <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float>, <vscale x 1 x float>)

define <vscale x 1 x float> @vfcopysign_vv_nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %vs)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_vf_nxv1f32(<vscale x 1 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> undef, <vscale x 1 x i32> zeroinitializer
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %splat)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_vv_nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x float> %vs
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %n)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_vf_nxv1f32(<vscale x 1 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x float> %splat
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %n)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_exttrunc_vv_nxv1f32_nxv1f16(<vscale x 1 x float> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fpext <vscale x 1 x half> %vs to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %e)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_exttrunc_vf_nxv1f32_nxv1f16(<vscale x 1 x float> %vm, half %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> undef, <vscale x 1 x i32> zeroinitializer
  %esplat = fpext <vscale x 1 x half> %splat to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %esplat)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_exttrunc_vv_nxv1f32_nxv1f16(<vscale x 1 x float> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x half> %vs
  %eneg = fpext <vscale x 1 x half> %n to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %eneg)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_exttrunc_vf_nxv1f32_nxv1f16(<vscale x 1 x float> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x half> %splat
  %eneg = fpext <vscale x 1 x half> %n to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %eneg)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_exttrunc_vv_nxv1f32_nxv1f64(<vscale x 1 x float> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fptrunc <vscale x 1 x double> %vs to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %e)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopysign_exttrunc_vf_nxv1f32_nxv1f64(<vscale x 1 x float> %vm, double %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> undef, <vscale x 1 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 1 x double> %splat to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %esplat)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_exttrunc_vv_nxv1f32_nxv1f64(<vscale x 1 x float> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x double> %vs
  %eneg = fptrunc <vscale x 1 x double> %n to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %eneg)
  ret <vscale x 1 x float> %r
}

define <vscale x 1 x float> @vfcopynsign_exttrunc_vf_nxv1f32_nxv1f64(<vscale x 1 x float> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v10, v9
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x double> %splat
  %eneg = fptrunc <vscale x 1 x double> %n to <vscale x 1 x float>
  %r = call <vscale x 1 x float> @llvm.copysign.nxv1f32(<vscale x 1 x float> %vm, <vscale x 1 x float> %eneg)
  ret <vscale x 1 x float> %r
}

declare <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float>, <vscale x 2 x float>)

define <vscale x 2 x float> @vfcopysign_vv_nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %vs)
  ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @vfcopysign_vf_nxv2f32(<vscale x 2 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> undef, <vscale x 2 x i32> zeroinitializer
  %r = call <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %splat)
  ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @vfcopynsign_vv_nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 2 x float> %vs
  %r = call <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %n)
  ret <vscale x 2 x float> %r
}

define <vscale x 2 x float> @vfcopynsign_vf_nxv2f32(<vscale x 2 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> undef, <vscale x 2 x i32> zeroinitializer
  %n = fneg <vscale x 2 x float> %splat
  %r = call <vscale x 2 x float> @llvm.copysign.nxv2f32(<vscale x 2 x float> %vm, <vscale x 2 x float> %n)
  ret <vscale x 2 x float> %r
}

declare <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>)

define <vscale x 4 x float> @vfcopysign_vv_nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %vs)
  ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @vfcopysign_vf_nxv4f32(<vscale x 4 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %r = call <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %splat)
  ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @vfcopynsign_vv_nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 4 x float> %vs
  %r = call <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %n)
  ret <vscale x 4 x float> %r
}

define <vscale x 4 x float> @vfcopynsign_vf_nxv4f32(<vscale x 4 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> undef, <vscale x 4 x i32> zeroinitializer
  %n = fneg <vscale x 4 x float> %splat
  %r = call <vscale x 4 x float> @llvm.copysign.nxv4f32(<vscale x 4 x float> %vm, <vscale x 4 x float> %n)
  ret <vscale x 4 x float> %r
}

declare <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float>, <vscale x 8 x float>)

define <vscale x 8 x float> @vfcopysign_vv_nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %vs)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_vf_nxv8f32(<vscale x 8 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %splat)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_vv_nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x float> %vs
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %n)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_vf_nxv8f32(<vscale x 8 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x float> %splat
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %n)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_exttrunc_vv_nxv8f32_nxv8f16(<vscale x 8 x float> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v16, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v16
; CHECK-NEXT:    ret
  %e = fpext <vscale x 8 x half> %vs to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %e)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_exttrunc_vf_nxv8f32_nxv8f16(<vscale x 8 x float> %vm, half %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v16, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %esplat = fpext <vscale x 8 x half> %splat to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %esplat)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_exttrunc_vv_nxv8f32_nxv8f16(<vscale x 8 x float> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v16, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v16
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x half> %vs
  %eneg = fpext <vscale x 8 x half> %n to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %eneg)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_exttrunc_vf_nxv8f32_nxv8f16(<vscale x 8 x float> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v16, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x half> %splat
  %eneg = fpext <vscale x 8 x half> %n to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %eneg)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_exttrunc_vv_nxv8f32_nxv8f64(<vscale x 8 x float> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v12, v16
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %e = fptrunc <vscale x 8 x double> %vs to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %e)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopysign_exttrunc_vf_nxv8f32_nxv8f64(<vscale x 8 x float> %vm, double %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v12, v16
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %esplat = fptrunc <vscale x 8 x double> %splat to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %esplat)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_exttrunc_vv_nxv8f32_nxv8f64(<vscale x 8 x float> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v12, v16
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x double> %vs
  %eneg = fptrunc <vscale x 8 x double> %n to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %eneg)
  ret <vscale x 8 x float> %r
}

define <vscale x 8 x float> @vfcopynsign_exttrunc_vf_nxv8f32_nxv8f64(<vscale x 8 x float> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfncvt.f.f.w v12, v16
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x double> %splat
  %eneg = fptrunc <vscale x 8 x double> %n to <vscale x 8 x float>
  %r = call <vscale x 8 x float> @llvm.copysign.nxv8f32(<vscale x 8 x float> %vm, <vscale x 8 x float> %eneg)
  ret <vscale x 8 x float> %r
}

declare <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float>, <vscale x 16 x float>)

define <vscale x 16 x float> @vfcopysign_vv_nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %vs)
  ret <vscale x 16 x float> %r
}

define <vscale x 16 x float> @vfcopysign_vf_nxv16f32(<vscale x 16 x float> %vm, float %s) {
; CHECK-LABEL: vfcopysign_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> undef, <vscale x 16 x i32> zeroinitializer
  %r = call <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %splat)
  ret <vscale x 16 x float> %r
}

define <vscale x 16 x float> @vfcopynsign_vv_nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v16
; CHECK-NEXT:    ret
  %n = fneg <vscale x 16 x float> %vs
  %r = call <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %n)
  ret <vscale x 16 x float> %r
}

define <vscale x 16 x float> @vfcopynsign_vf_nxv16f32(<vscale x 16 x float> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> undef, <vscale x 16 x i32> zeroinitializer
  %n = fneg <vscale x 16 x float> %splat
  %r = call <vscale x 16 x float> @llvm.copysign.nxv16f32(<vscale x 16 x float> %vm, <vscale x 16 x float> %n)
  ret <vscale x 16 x float> %r
}

declare <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double>, <vscale x 1 x double>)

define <vscale x 1 x double> @vfcopysign_vv_nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %vs)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_vf_nxv1f64(<vscale x 1 x double> %vm, double %s) {
; CHECK-LABEL: vfcopysign_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> undef, <vscale x 1 x i32> zeroinitializer
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %splat)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_vv_nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x double> %vs
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %n)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_vf_nxv1f64(<vscale x 1 x double> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x double> %splat
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %n)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_exttrunc_vv_nxv1f64_nxv1f16(<vscale x 1 x double> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %e = fpext <vscale x 1 x half> %vs to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %e)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_exttrunc_vf_nxv1f64_nxv1f16(<vscale x 1 x double> %vm, half %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> undef, <vscale x 1 x i32> zeroinitializer
  %esplat = fpext <vscale x 1 x half> %splat to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %esplat)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_exttrunc_vv_nxv1f64_nxv1f16(<vscale x 1 x double> %vm, <vscale x 1 x half> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x half> %vs
  %eneg = fpext <vscale x 1 x half> %n to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %eneg)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_exttrunc_vf_nxv1f64_nxv1f16(<vscale x 1 x double> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v9, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x half> %splat
  %eneg = fpext <vscale x 1 x half> %n to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %eneg)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_exttrunc_vv_nxv1f64_nxv1f32(<vscale x 1 x double> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %e = fpext <vscale x 1 x float> %vs to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %e)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopysign_exttrunc_vf_nxv1f64_nxv1f32(<vscale x 1 x double> %vm, float %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> undef, <vscale x 1 x i32> zeroinitializer
  %esplat = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %esplat)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_exttrunc_vv_nxv1f64_nxv1f32(<vscale x 1 x double> %vm, <vscale x 1 x float> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 1 x float> %vs
  %eneg = fpext <vscale x 1 x float> %n to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %eneg)
  ret <vscale x 1 x double> %r
}

define <vscale x 1 x double> @vfcopynsign_exttrunc_vf_nxv1f64_nxv1f32(<vscale x 1 x double> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v10, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> undef, <vscale x 1 x i32> zeroinitializer
  %n = fneg <vscale x 1 x float> %splat
  %eneg = fpext <vscale x 1 x float> %n to <vscale x 1 x double>
  %r = call <vscale x 1 x double> @llvm.copysign.nxv1f64(<vscale x 1 x double> %vm, <vscale x 1 x double> %eneg)
  ret <vscale x 1 x double> %r
}

declare <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>)

define <vscale x 2 x double> @vfcopysign_vv_nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v10
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %vs)
  ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @vfcopysign_vf_nxv2f64(<vscale x 2 x double> %vm, double %s) {
; CHECK-LABEL: vfcopysign_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %r = call <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %splat)
  ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @vfcopynsign_vv_nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v10
; CHECK-NEXT:    ret
  %n = fneg <vscale x 2 x double> %vs
  %r = call <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %n)
  ret <vscale x 2 x double> %r
}

define <vscale x 2 x double> @vfcopynsign_vf_nxv2f64(<vscale x 2 x double> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> undef, <vscale x 2 x i32> zeroinitializer
  %n = fneg <vscale x 2 x double> %splat
  %r = call <vscale x 2 x double> @llvm.copysign.nxv2f64(<vscale x 2 x double> %vm, <vscale x 2 x double> %n)
  ret <vscale x 2 x double> %r
}

declare <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double>, <vscale x 4 x double>)

define <vscale x 4 x double> @vfcopysign_vv_nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v12
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %vs)
  ret <vscale x 4 x double> %r
}

define <vscale x 4 x double> @vfcopysign_vf_nxv4f64(<vscale x 4 x double> %vm, double %s) {
; CHECK-LABEL: vfcopysign_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> undef, <vscale x 4 x i32> zeroinitializer
  %r = call <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %splat)
  ret <vscale x 4 x double> %r
}

define <vscale x 4 x double> @vfcopynsign_vv_nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v12
; CHECK-NEXT:    ret
  %n = fneg <vscale x 4 x double> %vs
  %r = call <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %n)
  ret <vscale x 4 x double> %r
}

define <vscale x 4 x double> @vfcopynsign_vf_nxv4f64(<vscale x 4 x double> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> undef, <vscale x 4 x i32> zeroinitializer
  %n = fneg <vscale x 4 x double> %splat
  %r = call <vscale x 4 x double> @llvm.copysign.nxv4f64(<vscale x 4 x double> %vm, <vscale x 4 x double> %n)
  ret <vscale x 4 x double> %r
}

declare <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double>, <vscale x 8 x double>)

define <vscale x 8 x double> @vfcopysign_vv_nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopysign_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %vs)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_vf_nxv8f64(<vscale x 8 x double> %vm, double %s) {
; CHECK-LABEL: vfcopysign_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %splat)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_vv_nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %vs) {
; CHECK-LABEL: vfcopynsign_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v16
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x double> %vs
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %n)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_vf_nxv8f64(<vscale x 8 x double> %vm, double %s) {
; CHECK-LABEL: vfcopynsign_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %s, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x double> %splat
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %n)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_exttrunc_vv_nxv8f64_nxv8f16(<vscale x 8 x double> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v20, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v24, v20
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v24
; CHECK-NEXT:    ret
  %e = fpext <vscale x 8 x half> %vs to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %e)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_exttrunc_vf_nxv8f64_nxv8f16(<vscale x 8 x double> %vm, half %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v20, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v24, v20
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %esplat = fpext <vscale x 8 x half> %splat to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %esplat)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_exttrunc_vv_nxv8f64_nxv8f16(<vscale x 8 x double> %vm, <vscale x 8 x half> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v20, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v24, v20
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v24
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x half> %vs
  %eneg = fpext <vscale x 8 x half> %n to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %eneg)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_exttrunc_vf_nxv8f64_nxv8f16(<vscale x 8 x double> %vm, half %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v20, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v24, v20
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %s, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x half> %splat
  %eneg = fpext <vscale x 8 x half> %n to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %eneg)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_exttrunc_vv_nxv8f64_nxv8f32(<vscale x 8 x double> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopysign_exttrunc_vv_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v24, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v24
; CHECK-NEXT:    ret
  %e = fpext <vscale x 8 x float> %vs to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %e)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopysign_exttrunc_vf_nxv8f64_nxv8f32(<vscale x 8 x double> %vm, float %s) {
; CHECK-LABEL: vfcopysign_exttrunc_vf_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v24, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnj.vv v8, v8, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %esplat = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %esplat)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_exttrunc_vv_nxv8f64_nxv8f32(<vscale x 8 x double> %vm, <vscale x 8 x float> %vs) {
; CHECK-LABEL: vfcopynsign_exttrunc_vv_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfwcvt.f.f.v v24, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v24
; CHECK-NEXT:    ret
  %n = fneg <vscale x 8 x float> %vs
  %eneg = fpext <vscale x 8 x float> %n to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %eneg)
  ret <vscale x 8 x double> %r
}

define <vscale x 8 x double> @vfcopynsign_exttrunc_vf_nxv8f64_nxv8f32(<vscale x 8 x double> %vm, float %s) {
; CHECK-LABEL: vfcopynsign_exttrunc_vf_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vfwcvt.f.f.v v24, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; CHECK-NEXT:    vfsgnjn.vv v8, v8, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %s, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %n = fneg <vscale x 8 x float> %splat
  %eneg = fpext <vscale x 8 x float> %n to <vscale x 8 x double>
  %r = call <vscale x 8 x double> @llvm.copysign.nxv8f64(<vscale x 8 x double> %vm, <vscale x 8 x double> %eneg)
  ret <vscale x 8 x double> %r
}
