; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+experimental-zfh,+experimental-v \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+experimental-zfh,+experimental-v \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64

declare void @llvm.vp.scatter.nxv1i8.nxv1p0i8(<vscale x 1 x i8>, <vscale x 1 x i8*>, <vscale x 1 x i1>, i32)

define void @vpscatter_nxv1i8(<vscale x 1 x i8> %val, <vscale x 1 x i8*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv1i8.nxv1p0i8(<vscale x 1 x i8> %val, <vscale x 1 x i8*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv2i8.nxv2p0i8(<vscale x 2 x i8>, <vscale x 2 x i8*>, <vscale x 2 x i1>, i32)

define void @vpscatter_nxv2i8(<vscale x 2 x i8> %val, <vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv2i8.nxv2p0i8(<vscale x 2 x i8> %val, <vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_nxv2i16_truncstore_nxv2i8(<vscale x 2 x i16> %val, <vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i16_truncstore_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a1, zero, e8, mf4, ta, mu
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i16_truncstore_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e8, mf4, ta, mu
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  %tval = trunc <vscale x 2 x i16> %val to <vscale x 2 x i8>
  call void @llvm.vp.scatter.nxv2i8.nxv2p0i8(<vscale x 2 x i8> %tval, <vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_nxv2i32_truncstore_nxv2i8(<vscale x 2 x i32> %val, <vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i32_truncstore_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a1, zero, e16, mf2, ta, mu
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i32_truncstore_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e16, mf2, ta, mu
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  %tval = trunc <vscale x 2 x i32> %val to <vscale x 2 x i8>
  call void @llvm.vp.scatter.nxv2i8.nxv2p0i8(<vscale x 2 x i8> %tval, <vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_nxv2i64_truncstore_nxv2i8(<vscale x 2 x i64> %val, <vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i64_truncstore_nxv2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; RV32-NEXT:    vnsrl.wi v11, v8, 0
; RV32-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV32-NEXT:    vnsrl.wi v8, v11, 0
; RV32-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i64_truncstore_nxv2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; RV64-NEXT:    vnsrl.wi v12, v8, 0
; RV64-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV64-NEXT:    vnsrl.wi v8, v12, 0
; RV64-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  %tval = trunc <vscale x 2 x i64> %val to <vscale x 2 x i8>
  call void @llvm.vp.scatter.nxv2i8.nxv2p0i8(<vscale x 2 x i8> %tval, <vscale x 2 x i8*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv4i8.nxv4p0i8(<vscale x 4 x i8>, <vscale x 4 x i8*>, <vscale x 4 x i1>, i32)

define void @vpscatter_nxv4i8(<vscale x 4 x i8> %val, <vscale x 4 x i8*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv4i8.nxv4p0i8(<vscale x 4 x i8> %val, <vscale x 4 x i8*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_nxv4i8(<vscale x 4 x i8> %val, <vscale x 4 x i8*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_nxv4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_nxv4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> undef, <vscale x 4 x i32> zeroinitializer
  call void @llvm.vp.scatter.nxv4i8.nxv4p0i8(<vscale x 4 x i8> %val, <vscale x 4 x i8*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv8i8.nxv8p0i8(<vscale x 8 x i8>, <vscale x 8 x i8*>, <vscale x 8 x i1>, i32)

define void @vpscatter_nxv8i8(<vscale x 8 x i8> %val, <vscale x 8 x i8*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e8, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v16, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv8i8.nxv8p0i8(<vscale x 8 x i8> %val, <vscale x 8 x i8*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i8(<vscale x 8 x i8> %val, i8* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v9
; RV32-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v9
; RV64-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <vscale x 8 x i8> %idxs
  call void @llvm.vp.scatter.nxv8i8.nxv8p0i8(<vscale x 8 x i8> %val, <vscale x 8 x i8*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv1i16.nxv1p0i16(<vscale x 1 x i16>, <vscale x 1 x i16*>, <vscale x 1 x i1>, i32)

define void @vpscatter_nxv1i16(<vscale x 1 x i16> %val, <vscale x 1 x i16*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv1i16.nxv1p0i16(<vscale x 1 x i16> %val, <vscale x 1 x i16*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv2i16.nxv2p0i16(<vscale x 2 x i16>, <vscale x 2 x i16*>, <vscale x 2 x i1>, i32)

define void @vpscatter_nxv2i16(<vscale x 2 x i16> %val, <vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv2i16.nxv2p0i16(<vscale x 2 x i16> %val, <vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_nxv2i32_truncstore_nxv2i16(<vscale x 2 x i32> %val, <vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i32_truncstore_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a1, zero, e16, mf2, ta, mu
; RV32-NEXT:    vnsrl.wi v8, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i32_truncstore_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e16, mf2, ta, mu
; RV64-NEXT:    vnsrl.wi v8, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  %tval = trunc <vscale x 2 x i32> %val to <vscale x 2 x i16>
  call void @llvm.vp.scatter.nxv2i16.nxv2p0i16(<vscale x 2 x i16> %tval, <vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_nxv2i64_truncstore_nxv2i16(<vscale x 2 x i64> %val, <vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i64_truncstore_nxv2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; RV32-NEXT:    vnsrl.wi v11, v8, 0
; RV32-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV32-NEXT:    vnsrl.wi v8, v11, 0
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i64_truncstore_nxv2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; RV64-NEXT:    vnsrl.wi v12, v8, 0
; RV64-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV64-NEXT:    vnsrl.wi v8, v12, 0
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  %tval = trunc <vscale x 2 x i64> %val to <vscale x 2 x i16>
  call void @llvm.vp.scatter.nxv2i16.nxv2p0i16(<vscale x 2 x i16> %tval, <vscale x 2 x i16*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv4i16.nxv4p0i16(<vscale x 4 x i16>, <vscale x 4 x i16*>, <vscale x 4 x i1>, i32)

define void @vpscatter_nxv4i16(<vscale x 4 x i16> %val, <vscale x 4 x i16*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv4i16.nxv4p0i16(<vscale x 4 x i16> %val, <vscale x 4 x i16*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_nxv4i16(<vscale x 4 x i16> %val, <vscale x 4 x i16*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_nxv4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_nxv4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> undef, <vscale x 4 x i32> zeroinitializer
  call void @llvm.vp.scatter.nxv4i16.nxv4p0i16(<vscale x 4 x i16> %val, <vscale x 4 x i16*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv8i16.nxv8p0i16(<vscale x 8 x i16>, <vscale x 8 x i16*>, <vscale x 8 x i1>, i32)

define void @vpscatter_nxv8i16(<vscale x 8 x i16> %val, <vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v16, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv8i16.nxv8p0i16(<vscale x 8 x i16> %val, <vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i8_nxv8i16(<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i8_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i8_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v10
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, i16* %base, <vscale x 8 x i8> %idxs
  call void @llvm.vp.scatter.nxv8i16.nxv8p0i16(<vscale x 8 x i16> %val, <vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i8_nxv8i16(<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v10
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i16>
  %ptrs = getelementptr inbounds i16, i16* %base, <vscale x 8 x i16> %eidxs
  call void @llvm.vp.scatter.nxv8i16.nxv8p0i16(<vscale x 8 x i16> %val, <vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i8_nxv8i16(<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v12, v10
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v10
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i16>
  %ptrs = getelementptr inbounds i16, i16* %base, <vscale x 8 x i16> %eidxs
  call void @llvm.vp.scatter.nxv8i16.nxv8p0i16(<vscale x 8 x i16> %val, <vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i16(<vscale x 8 x i16> %val, i16* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v10
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, i16* %base, <vscale x 8 x i16> %idxs
  call void @llvm.vp.scatter.nxv8i16.nxv8p0i16(<vscale x 8 x i16> %val, <vscale x 8 x i16*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv1i32.nxv1p0i32(<vscale x 1 x i32>, <vscale x 1 x i32*>, <vscale x 1 x i1>, i32)

define void @vpscatter_nxv1i32(<vscale x 1 x i32> %val, <vscale x 1 x i32*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv1i32.nxv1p0i32(<vscale x 1 x i32> %val, <vscale x 1 x i32*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv2i32.nxv2p0i32(<vscale x 2 x i32>, <vscale x 2 x i32*>, <vscale x 2 x i1>, i32)

define void @vpscatter_nxv2i32(<vscale x 2 x i32> %val, <vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv2i32.nxv2p0i32(<vscale x 2 x i32> %val, <vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_nxv2i64_truncstore_nxv2i32(<vscale x 2 x i64> %val, <vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i64_truncstore_nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; RV32-NEXT:    vnsrl.wi v11, v8, 0
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v11, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i64_truncstore_nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; RV64-NEXT:    vnsrl.wi v12, v8, 0
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v12, (zero), v10, v0.t
; RV64-NEXT:    ret
  %tval = trunc <vscale x 2 x i64> %val to <vscale x 2 x i32>
  call void @llvm.vp.scatter.nxv2i32.nxv2p0i32(<vscale x 2 x i32> %tval, <vscale x 2 x i32*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv4i32.nxv4p0i32(<vscale x 4 x i32>, <vscale x 4 x i32*>, <vscale x 4 x i1>, i32)

define void @vpscatter_nxv4i32(<vscale x 4 x i32> %val, <vscale x 4 x i32*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv4i32.nxv4p0i32(<vscale x 4 x i32> %val, <vscale x 4 x i32*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_nxv4i32(<vscale x 4 x i32> %val, <vscale x 4 x i32*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_nxv4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_nxv4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> undef, <vscale x 4 x i32> zeroinitializer
  call void @llvm.vp.scatter.nxv4i32.nxv4p0i32(<vscale x 4 x i32> %val, <vscale x 4 x i32*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32>, <vscale x 8 x i32*>, <vscale x 8 x i1>, i32)

define void @vpscatter_nxv8i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v16, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i8_nxv8i32(<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i8_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i8_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i8> %idxs
  call void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i8_nxv8i32(<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %eidxs
  call void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i8_nxv8i32(<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %eidxs
  call void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i16_nxv8i32(<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i16_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i16_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i16> %idxs
  call void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i16_nxv8i32(<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_nxv8i16_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_nxv8i16_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i16> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %eidxs
  call void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i16_nxv8i32(<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_nxv8i16_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_nxv8i16_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i16> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %eidxs
  call void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i32(<vscale x 8 x i32> %val, i32* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v12, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <vscale x 8 x i32> %idxs
  call void @llvm.vp.scatter.nxv8i32.nxv8p0i32(<vscale x 8 x i32> %val, <vscale x 8 x i32*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv1i64.nxv1p0i64(<vscale x 1 x i64>, <vscale x 1 x i64*>, <vscale x 1 x i1>, i32)

define void @vpscatter_nxv1i64(<vscale x 1 x i64> %val, <vscale x 1 x i64*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv1i64.nxv1p0i64(<vscale x 1 x i64> %val, <vscale x 1 x i64*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv2i64.nxv2p0i64(<vscale x 2 x i64>, <vscale x 2 x i64*>, <vscale x 2 x i1>, i32)

define void @vpscatter_nxv2i64(<vscale x 2 x i64> %val, <vscale x 2 x i64*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv2i64.nxv2p0i64(<vscale x 2 x i64> %val, <vscale x 2 x i64*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv4i64.nxv4p0i64(<vscale x 4 x i64>, <vscale x 4 x i64*>, <vscale x 4 x i1>, i32)

define void @vpscatter_nxv4i64(<vscale x 4 x i64> %val, <vscale x 4 x i64*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv4i64.nxv4p0i64(<vscale x 4 x i64> %val, <vscale x 4 x i64*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_nxv4i64(<vscale x 4 x i64> %val, <vscale x 4 x i64*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> undef, <vscale x 4 x i32> zeroinitializer
  call void @llvm.vp.scatter.nxv4i64.nxv4p0i64(<vscale x 4 x i64> %val, <vscale x 4 x i64*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64>, <vscale x 8 x i64*>, <vscale x 8 x i1>, i32)

define void @vpscatter_nxv8i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v16, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i8_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i8_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v20, v16
; RV32-NEXT:    vsll.vi v16, v20, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i8_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v24, v16
; RV64-NEXT:    vsll.vi v16, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i8> %idxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i8_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vsext.vf8 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i8_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vzext.vf8 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i16_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i16_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v20, v16
; RV32-NEXT:    vsll.vi v16, v20, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i16_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v24, v16
; RV64-NEXT:    vsll.vi v16, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i16> %idxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i16_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_sext_nxv8i16_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vsext.vf4 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = sext <vscale x 8 x i16> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i16_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_zext_nxv8i16_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vzext.vf4 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = zext <vscale x 8 x i16> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i32_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i32_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v16, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i32_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v24, v16
; RV64-NEXT:    vsll.vi v16, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i32> %idxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i32_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_sext_nxv8i32_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vsext.vf2 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = sext <vscale x 8 x i32> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i32_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_zext_nxv8i32_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vzext.vf2 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = zext <vscale x 8 x i32> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i64(<vscale x 8 x i64> %val, i64* %base, <vscale x 8 x i64> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vsll.vi v16, v16, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <vscale x 8 x i64> %idxs
  call void @llvm.vp.scatter.nxv8i64.nxv8p0i64(<vscale x 8 x i64> %val, <vscale x 8 x i64*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv1f16.nxv1p0f16(<vscale x 1 x half>, <vscale x 1 x half*>, <vscale x 1 x i1>, i32)

define void @vpscatter_nxv1f16(<vscale x 1 x half> %val, <vscale x 1 x half*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv1f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv1f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv1f16.nxv1p0f16(<vscale x 1 x half> %val, <vscale x 1 x half*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv2f16.nxv2p0f16(<vscale x 2 x half>, <vscale x 2 x half*>, <vscale x 2 x i1>, i32)

define void @vpscatter_nxv2f16(<vscale x 2 x half> %val, <vscale x 2 x half*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv2f16.nxv2p0f16(<vscale x 2 x half> %val, <vscale x 2 x half*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv4f16.nxv4p0f16(<vscale x 4 x half>, <vscale x 4 x half*>, <vscale x 4 x i1>, i32)

define void @vpscatter_nxv4f16(<vscale x 4 x half> %val, <vscale x 4 x half*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv4f16.nxv4p0f16(<vscale x 4 x half> %val, <vscale x 4 x half*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_nxv4f16(<vscale x 4 x half> %val, <vscale x 4 x half*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_nxv4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_nxv4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> undef, <vscale x 4 x i32> zeroinitializer
  call void @llvm.vp.scatter.nxv4f16.nxv4p0f16(<vscale x 4 x half> %val, <vscale x 4 x half*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv8f16.nxv8p0f16(<vscale x 8 x half>, <vscale x 8 x half*>, <vscale x 8 x i1>, i32)

define void @vpscatter_nxv8f16(<vscale x 8 x half> %val, <vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v16, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv8f16.nxv8p0f16(<vscale x 8 x half> %val, <vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i8_nxv8f16(<vscale x 8 x half> %val, half* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i8_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i8_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v10
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, half* %base, <vscale x 8 x i8> %idxs
  call void @llvm.vp.scatter.nxv8f16.nxv8p0f16(<vscale x 8 x half> %val, <vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i8_nxv8f16(<vscale x 8 x half> %val, half* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v10
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i16>
  %ptrs = getelementptr inbounds half, half* %base, <vscale x 8 x i16> %eidxs
  call void @llvm.vp.scatter.nxv8f16.nxv8p0f16(<vscale x 8 x half> %val, <vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i8_nxv8f16(<vscale x 8 x half> %val, half* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v12, v10
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v10
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i16>
  %ptrs = getelementptr inbounds half, half* %base, <vscale x 8 x i16> %eidxs
  call void @llvm.vp.scatter.nxv8f16.nxv8p0f16(<vscale x 8 x half> %val, <vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8f16(<vscale x 8 x half> %val, half* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vadd.vv v12, v12, v12
; RV32-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v10
; RV64-NEXT:    vadd.vv v16, v16, v16
; RV64-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, half* %base, <vscale x 8 x i16> %idxs
  call void @llvm.vp.scatter.nxv8f16.nxv8p0f16(<vscale x 8 x half> %val, <vscale x 8 x half*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv1f32.nxv1p0f32(<vscale x 1 x float>, <vscale x 1 x float*>, <vscale x 1 x i1>, i32)

define void @vpscatter_nxv1f32(<vscale x 1 x float> %val, <vscale x 1 x float*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv1f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv1f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv1f32.nxv1p0f32(<vscale x 1 x float> %val, <vscale x 1 x float*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv2f32.nxv2p0f32(<vscale x 2 x float>, <vscale x 2 x float*>, <vscale x 2 x i1>, i32)

define void @vpscatter_nxv2f32(<vscale x 2 x float> %val, <vscale x 2 x float*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv2f32.nxv2p0f32(<vscale x 2 x float> %val, <vscale x 2 x float*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv4f32.nxv4p0f32(<vscale x 4 x float>, <vscale x 4 x float*>, <vscale x 4 x i1>, i32)

define void @vpscatter_nxv4f32(<vscale x 4 x float> %val, <vscale x 4 x float*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv4f32.nxv4p0f32(<vscale x 4 x float> %val, <vscale x 4 x float*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_nxv4f32(<vscale x 4 x float> %val, <vscale x 4 x float*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_nxv4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_nxv4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> undef, <vscale x 4 x i32> zeroinitializer
  call void @llvm.vp.scatter.nxv4f32.nxv4p0f32(<vscale x 4 x float> %val, <vscale x 4 x float*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float>, <vscale x 8 x float*>, <vscale x 8 x i1>, i32)

define void @vpscatter_nxv8f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v16, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i8_nxv8f32(<vscale x 8 x float> %val, float* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i8_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i8_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i8> %idxs
  call void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i8_nxv8f32(<vscale x 8 x float> %val, float* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %eidxs
  call void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i8_nxv8f32(<vscale x 8 x float> %val, float* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %eidxs
  call void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i16_nxv8f32(<vscale x 8 x float> %val, float* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i16_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i16_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i16> %idxs
  call void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i16_nxv8f32(<vscale x 8 x float> %val, float* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_sext_nxv8i16_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_sext_nxv8i16_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <vscale x 8 x i16> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %eidxs
  call void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i16_nxv8f32(<vscale x 8 x float> %val, float* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_zext_nxv8i16_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vzext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_zext_nxv8i16_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <vscale x 8 x i16> %idxs to <vscale x 8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %eidxs
  call void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8f32(<vscale x 8 x float> %val, float* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v12, v12, 2
; RV32-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v16, v16, 2
; RV64-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <vscale x 8 x i32> %idxs
  call void @llvm.vp.scatter.nxv8f32.nxv8p0f32(<vscale x 8 x float> %val, <vscale x 8 x float*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv1f64.nxv1p0f64(<vscale x 1 x double>, <vscale x 1 x double*>, <vscale x 1 x i1>, i32)

define void @vpscatter_nxv1f64(<vscale x 1 x double> %val, <vscale x 1 x double*> %ptrs, <vscale x 1 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv1f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv1f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv1f64.nxv1p0f64(<vscale x 1 x double> %val, <vscale x 1 x double*> %ptrs, <vscale x 1 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv2f64.nxv2p0f64(<vscale x 2 x double>, <vscale x 2 x double*>, <vscale x 2 x i1>, i32)

define void @vpscatter_nxv2f64(<vscale x 2 x double> %val, <vscale x 2 x double*> %ptrs, <vscale x 2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv2f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv2f64.nxv2p0f64(<vscale x 2 x double> %val, <vscale x 2 x double*> %ptrs, <vscale x 2 x i1> %m, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv4f64.nxv4p0f64(<vscale x 4 x double>, <vscale x 4 x double*>, <vscale x 4 x i1>, i32)

define void @vpscatter_nxv4f64(<vscale x 4 x double> %val, <vscale x 4 x double*> %ptrs, <vscale x 4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv4f64.nxv4p0f64(<vscale x 4 x double> %val, <vscale x 4 x double*> %ptrs, <vscale x 4 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_truemask_nxv4f64(<vscale x 4 x double> %val, <vscale x 4 x double*> %ptrs, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_truemask_nxv4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_truemask_nxv4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12
; RV64-NEXT:    ret
  %mhead = insertelement <vscale x 4 x i1> undef, i1 1, i32 0
  %mtrue = shufflevector <vscale x 4 x i1> %mhead, <vscale x 4 x i1> undef, <vscale x 4 x i32> zeroinitializer
  call void @llvm.vp.scatter.nxv4f64.nxv4p0f64(<vscale x 4 x double> %val, <vscale x 4 x double*> %ptrs, <vscale x 4 x i1> %mtrue, i32 %evl)
  ret void
}

declare void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double>, <vscale x 8 x double*>, <vscale x 8 x i1>, i32)

define void @vpscatter_nxv8f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v16, v0.t
; RV64-NEXT:    ret
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i8_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i8_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v20, v16
; RV32-NEXT:    vsll.vi v16, v20, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i8_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v24, v16
; RV64-NEXT:    vsll.vi v16, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i8> %idxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i8_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_sext_nxv8i8_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vsext.vf8 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = sext <vscale x 8 x i8> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i8_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i8> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_zext_nxv8i8_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vzext.vf8 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = zext <vscale x 8 x i8> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i16_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i16_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v20, v16
; RV32-NEXT:    vsll.vi v16, v20, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i16_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf4 v24, v16
; RV64-NEXT:    vsll.vi v16, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i16> %idxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i16_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_sext_nxv8i16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vsext.vf4 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = sext <vscale x 8 x i16> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i16_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i16> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_zext_nxv8i16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vzext.vf4 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = zext <vscale x 8 x i16> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8i32_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vpscatter_baseidx_nxv8i32_nxv8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a2, zero, e32, m4, ta, mu
; RV32-NEXT:    vsll.vi v16, v16, 3
; RV32-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: vpscatter_baseidx_nxv8i32_nxv8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf2 v24, v16
; RV64-NEXT:    vsll.vi v16, v24, 3
; RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i32> %idxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_sext_nxv8i32_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_sext_nxv8i32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vsext.vf2 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = sext <vscale x 8 x i32> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_zext_nxv8i32_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i32> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_zext_nxv8i32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vzext.vf2 v24, v16
; CHECK-NEXT:    vsll.vi v16, v24, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %eidxs = zext <vscale x 8 x i32> %idxs to <vscale x 8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %eidxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}

define void @vpscatter_baseidx_nxv8f64(<vscale x 8 x double> %val, double* %base, <vscale x 8 x i64> %idxs, <vscale x 8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vpscatter_baseidx_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e64, m8, ta, mu
; CHECK-NEXT:    vsll.vi v16, v16, 3
; CHECK-NEXT:    vsetvli zero, a1, e64, m8, ta, mu
; CHECK-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; CHECK-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <vscale x 8 x i64> %idxs
  call void @llvm.vp.scatter.nxv8f64.nxv8p0f64(<vscale x 8 x double> %val, <vscale x 8 x double*> %ptrs, <vscale x 8 x i1> %m, i32 %evl)
  ret void
}
