; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-arm-none-eabi %s -o - -mattr=+mve.fp | FileCheck %s

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_1(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #1
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.000000e+00, float 2.000000e+00, float 2.000000e+00, float 2.000000e+00>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_2(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #2
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 4.000000e+00, float 4.000000e+00, float 4.000000e+00, float 4.000000e+00>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_3(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_3:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #3
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 8.000000e+00, float 8.000000e+00, float 8.000000e+00, float 8.000000e+00>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_4(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_4:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #4
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.600000e+01, float 1.600000e+01, float 1.600000e+01, float 1.600000e+01>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_5(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_5:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #5
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 3.200000e+01, float 3.200000e+01, float 3.200000e+01, float 3.200000e+01>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_6(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_6:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #6
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 6.400000e+01, float 6.400000e+01, float 6.400000e+01, float 6.400000e+01>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_7(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_7:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #7
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.280000e+02, float 1.280000e+02, float 1.280000e+02, float 1.280000e+02>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_8(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #8
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.560000e+02, float 2.560000e+02, float 2.560000e+02, float 2.560000e+02>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_9(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_9:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #9
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 5.120000e+02, float 5.120000e+02, float 5.120000e+02, float 5.120000e+02>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_10(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_10:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #10
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.024000e+03, float 1.024000e+03, float 1.024000e+03, float 1.024000e+03>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_11(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_11:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #11
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.048000e+03, float 2.048000e+03, float 2.048000e+03, float 2.048000e+03>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_12(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_12:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #12
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 4.096000e+03, float 4.096000e+03, float 4.096000e+03, float 4.096000e+03>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_13(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_13:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #13
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 8.192000e+03, float 8.192000e+03, float 8.192000e+03, float 8.192000e+03>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_14(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_14:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #14
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.638400e+04, float 1.638400e+04, float 1.638400e+04, float 1.638400e+04>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_15(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_15:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #15
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 3.276800e+04, float 3.276800e+04, float 3.276800e+04, float 3.276800e+04>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_16(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #16
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 6.553600e+04, float 6.553600e+04, float 6.553600e+04, float 6.553600e+04>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_17(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_17:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #17
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.310720e+05, float 1.310720e+05, float 1.310720e+05, float 1.310720e+05>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_18(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_18:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #18
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.621440e+05, float 2.621440e+05, float 2.621440e+05, float 2.621440e+05>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_19(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_19:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #19
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 5.242880e+05, float 5.242880e+05, float 5.242880e+05, float 5.242880e+05>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_20(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_20:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #20
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4130000000000000, float 0x4130000000000000, float 0x4130000000000000, float 0x4130000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_21(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_21:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #21
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4140000000000000, float 0x4140000000000000, float 0x4140000000000000, float 0x4140000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_22(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_22:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #22
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4150000000000000, float 0x4150000000000000, float 0x4150000000000000, float 0x4150000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_23(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_23:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #23
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4160000000000000, float 0x4160000000000000, float 0x4160000000000000, float 0x4160000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_24(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_24:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #24
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4170000000000000, float 0x4170000000000000, float 0x4170000000000000, float 0x4170000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_25(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_25:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #25
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4180000000000000, float 0x4180000000000000, float 0x4180000000000000, float 0x4180000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_26(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_26:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #26
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4190000000000000, float 0x4190000000000000, float 0x4190000000000000, float 0x4190000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_27(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_27:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #27
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41A0000000000000, float 0x41A0000000000000, float 0x41A0000000000000, float 0x41A0000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_28(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_28:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #28
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41B0000000000000, float 0x41B0000000000000, float 0x41B0000000000000, float 0x41B0000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_29(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_29:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #29
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41C0000000000000, float 0x41C0000000000000, float 0x41C0000000000000, float 0x41C0000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_30(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_30:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #30
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41D0000000000000, float 0x41D0000000000000, float 0x41D0000000000000, float 0x41D0000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_31(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_31:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #31
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41E0000000000000, float 0x41E0000000000000, float 0x41E0000000000000, float 0x41E0000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_32(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #32
; CHECK-NEXT:    bx lr
  %2 = fmul <4 x float> %0, <float 0x41F0000000000000, float 0x41F0000000000000, float 0x41F0000000000000, float 0x41F0000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_i32_33(<4 x float> %0) {
; CHECK-LABEL: vcvt_i32_33:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 q1, #0x50000000
; CHECK-NEXT:    vmul.f32 q0, q0, q1
; CHECK-NEXT:    vcvt.s32.f32 q0, q0
; CHECK-NEXT:    bx lr
  %2 = fmul <4 x float> %0, <float 0x4200000000000000, float 0x4200000000000000, float 0x4200000000000000, float 0x4200000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_1(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #1
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_2(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #2
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_3(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_3:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #3
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_4(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_4:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #4
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_5(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_5:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #5
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_6(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_6:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #6
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_7(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_7:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #7
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_8(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #8
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_9(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_9:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #9
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_10(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_10:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #10
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_11(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_11:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #11
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_12(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_12:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #12
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_13(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_13:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #13
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_14(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_14:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #14
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_i16_15(<8 x half> %0) {
; CHECK-LABEL: vcvt_i16_15:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #15
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_1(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #1
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.000000e+00, float 2.000000e+00, float 2.000000e+00, float 2.000000e+00>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_2(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #2
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 4.000000e+00, float 4.000000e+00, float 4.000000e+00, float 4.000000e+00>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_3(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_3:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #3
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 8.000000e+00, float 8.000000e+00, float 8.000000e+00, float 8.000000e+00>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_4(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_4:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #4
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.600000e+01, float 1.600000e+01, float 1.600000e+01, float 1.600000e+01>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_5(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_5:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #5
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 3.200000e+01, float 3.200000e+01, float 3.200000e+01, float 3.200000e+01>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_6(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_6:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #6
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 6.400000e+01, float 6.400000e+01, float 6.400000e+01, float 6.400000e+01>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_7(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_7:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #7
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.280000e+02, float 1.280000e+02, float 1.280000e+02, float 1.280000e+02>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_8(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #8
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.560000e+02, float 2.560000e+02, float 2.560000e+02, float 2.560000e+02>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_9(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_9:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #9
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 5.120000e+02, float 5.120000e+02, float 5.120000e+02, float 5.120000e+02>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_10(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_10:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #10
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.024000e+03, float 1.024000e+03, float 1.024000e+03, float 1.024000e+03>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_11(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_11:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #11
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.048000e+03, float 2.048000e+03, float 2.048000e+03, float 2.048000e+03>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_12(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_12:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #12
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 4.096000e+03, float 4.096000e+03, float 4.096000e+03, float 4.096000e+03>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_13(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_13:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #13
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 8.192000e+03, float 8.192000e+03, float 8.192000e+03, float 8.192000e+03>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_14(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_14:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #14
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.638400e+04, float 1.638400e+04, float 1.638400e+04, float 1.638400e+04>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_15(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_15:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #15
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 3.276800e+04, float 3.276800e+04, float 3.276800e+04, float 3.276800e+04>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_16(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #16
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 6.553600e+04, float 6.553600e+04, float 6.553600e+04, float 6.553600e+04>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_17(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_17:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #17
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 1.310720e+05, float 1.310720e+05, float 1.310720e+05, float 1.310720e+05>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_18(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_18:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #18
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.621440e+05, float 2.621440e+05, float 2.621440e+05, float 2.621440e+05>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_19(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_19:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #19
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 5.242880e+05, float 5.242880e+05, float 5.242880e+05, float 5.242880e+05>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_20(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_20:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #20
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4130000000000000, float 0x4130000000000000, float 0x4130000000000000, float 0x4130000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_21(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_21:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #21
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4140000000000000, float 0x4140000000000000, float 0x4140000000000000, float 0x4140000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_22(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_22:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #22
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4150000000000000, float 0x4150000000000000, float 0x4150000000000000, float 0x4150000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_23(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_23:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #23
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4160000000000000, float 0x4160000000000000, float 0x4160000000000000, float 0x4160000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_24(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_24:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #24
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4170000000000000, float 0x4170000000000000, float 0x4170000000000000, float 0x4170000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_25(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_25:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #25
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4180000000000000, float 0x4180000000000000, float 0x4180000000000000, float 0x4180000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_26(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_26:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #26
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4190000000000000, float 0x4190000000000000, float 0x4190000000000000, float 0x4190000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_27(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_27:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #27
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41A0000000000000, float 0x41A0000000000000, float 0x41A0000000000000, float 0x41A0000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_28(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_28:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #28
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41B0000000000000, float 0x41B0000000000000, float 0x41B0000000000000, float 0x41B0000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_29(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_29:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #29
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41C0000000000000, float 0x41C0000000000000, float 0x41C0000000000000, float 0x41C0000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_30(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_30:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #30
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41D0000000000000, float 0x41D0000000000000, float 0x41D0000000000000, float 0x41D0000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_31(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_31:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #31
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x41E0000000000000, float 0x41E0000000000000, float 0x41E0000000000000, float 0x41E0000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_32(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #32
; CHECK-NEXT:    bx lr
  %2 = fmul <4 x float> %0, <float 0x41F0000000000000, float 0x41F0000000000000, float 0x41F0000000000000, float 0x41F0000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_u32_33(<4 x float> %0) {
; CHECK-LABEL: vcvt_u32_33:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 q1, #0x50000000
; CHECK-NEXT:    vmul.f32 q0, q0, q1
; CHECK-NEXT:    vcvt.u32.f32 q0, q0
; CHECK-NEXT:    bx lr
  %2 = fmul <4 x float> %0, <float 0x4200000000000000, float 0x4200000000000000, float 0x4200000000000000, float 0x4200000000000000>
  %3 = fptoui <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_1(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #1
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_2(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #2
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400, half 0xH4400>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_3(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_3:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #3
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800, half 0xH4800>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_4(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_4:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #4
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00, half 0xH4C00>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_5(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_5:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #5
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000, half 0xH5000>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_6(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_6:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #6
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_7(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_7:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #7
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_8(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #8
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00, half 0xH5C00>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_9(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_9:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #9
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000, half 0xH6000>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_10(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_10:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #10
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400, half 0xH6400>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_11(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_11:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #11
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800, half 0xH6800>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_12(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_12:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #12
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00, half 0xH6C00>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_13(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_13:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #13
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000, half 0xH7000>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_14(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_14:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #14
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400, half 0xH7400>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_15(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_15:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #15
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_u16_inf(<8 x half> %0) {
; CHECK-LABEL: vcvt_u16_inf:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i16 q1, #0x7800
; CHECK-NEXT:    vmul.f16 q0, q0, q1
; CHECK-NEXT:    vcvt.u16.f16 q0, q0
; CHECK-NEXT:    bx lr
  %2 = fmul <8 x half> %0, <half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800>
  %3 = fptoui <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_s16_inf(<8 x half> %0) {
; CHECK-LABEL: vcvt_s16_inf:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #15
; CHECK-NEXT:    bx lr
  %2 = fmul <8 x half> %0, <half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800, half 0xH7800>
  %3 = fptosi <8 x half> %2 to <8 x i16>
  ret <8 x i16> %3
}


define arm_aapcs_vfpcc <4 x i32> @vcvt_bad_imm(<4 x float> %0) {
; CHECK-LABEL: vcvt_bad_imm:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    movw r0, #2048
; CHECK-NEXT:    movt r0, #15104
; CHECK-NEXT:    vmul.f32 q0, q0, r0
; CHECK-NEXT:    vcvt.s32.f32 q0, q0
; CHECK-NEXT:    bx lr
  %2 = fmul <4 x float> %0, <float 0x3F60010000000000, float 0x3F60010000000000, float 0x3F60010000000000, float 0x3F60010000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_negative(<4 x float> %0) {
; CHECK-LABEL: vcvt_negative:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 q1, #0xb8000000
; CHECK-NEXT:    vmul.f32 q0, q0, q1
; CHECK-NEXT:    vcvt.s32.f32 q0, q0
; CHECK-NEXT:    bx lr
  %2 = fmul <4 x float> %0, <float 0xBF00000000000000, float 0xBF00000000000000, float 0xBF00000000000000, float 0xBF00000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_negative2(<4 x float> %0) {
; CHECK-LABEL: vcvt_negative2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 q1, #0xb0000000
; CHECK-NEXT:    vmul.f32 q0, q0, q1
; CHECK-NEXT:    vcvt.s32.f32 q0, q0
; CHECK-NEXT:    bx lr
  %2 = fmul <4 x float> %0, <float 0xBE00000000000000, float 0xBE00000000000000, float 0xBE00000000000000, float 0xBE00000000000000>
  %3 = fptosi <4 x float> %2 to <4 x i32>
  ret <4 x i32> %3
}



define arm_aapcs_vfpcc <8 x i16> @vcvt_sat_s16_1(<8 x half> %0) {
; CHECK-LABEL: vcvt_sat_s16_1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #1
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000>
  %3 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> %2)
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_sat_u16_1(<8 x half> %0) {
; CHECK-LABEL: vcvt_sat_u16_1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #1
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000, half 0xH4000>
  %3 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> %2)
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_sat_s16_6(<8 x half> %0) {
; CHECK-LABEL: vcvt_sat_s16_6:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s16.f16 q0, q0, #6
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400, half 0xH5400>
  %3 = call <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half> %2)
  ret <8 x i16> %3
}

define arm_aapcs_vfpcc <8 x i16> @vcvt_sat_u16_7(<8 x half> %0) {
; CHECK-LABEL: vcvt_sat_u16_7:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u16.f16 q0, q0, #7
; CHECK-NEXT:    bx lr
  %2 = fmul fast <8 x half> %0, <half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800, half 0xH5800>
  %3 = call <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half> %2)
  ret <8 x i16> %3
}


define arm_aapcs_vfpcc <4 x i32> @vcvt_sat_s32_1(<4 x float> %0) {
; CHECK-LABEL: vcvt_sat_s32_1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #1
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.000000e+00, float 2.000000e+00, float 2.000000e+00, float 2.000000e+00>
  %3 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> %2)
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_sat_u32_1(<4 x float> %0) {
; CHECK-LABEL: vcvt_sat_u32_1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #1
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.000000e+00, float 2.000000e+00, float 2.000000e+00, float 2.000000e+00>
  %3 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> %2)
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_sat_u32_11(<4 x float> %0) {
; CHECK-LABEL: vcvt_sat_u32_11:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.s32.f32 q0, q0, #11
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 2.048000e+03, float 2.048000e+03, float 2.048000e+03, float 2.048000e+03>
  %3 = call <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float> %2)
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_sat_u32_7(<4 x float> %0) {
; CHECK-LABEL: vcvt_sat_u32_7:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #23
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4160000000000000, float 0x4160000000000000, float 0x4160000000000000, float 0x4160000000000000>
  %3 = call <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float> %2)
  ret <4 x i32> %3
}

define arm_aapcs_vfpcc <4 x i32> @vcvt_sat_u32_7_24(<4 x float> %0) {
; CHECK-LABEL: vcvt_sat_u32_7_24:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i32 q1, #0xffffff
; CHECK-NEXT:    vcvt.u32.f32 q0, q0, #23
; CHECK-NEXT:    vmin.u32 q0, q0, q1
; CHECK-NEXT:    vbic.i32 q0, #0xff000000
; CHECK-NEXT:    bx lr
  %2 = fmul fast <4 x float> %0, <float 0x4160000000000000, float 0x4160000000000000, float 0x4160000000000000, float 0x4160000000000000>
  %3 = call <4 x i24> @llvm.fptoui.sat.v4i24.v4f32(<4 x float> %2)
  %4 = zext <4 x i24> %3 to <4 x i32>
  ret <4 x i32> %4
}

declare <4 x i32> @llvm.fptosi.sat.v4i32.v4f32(<4 x float>)
declare <4 x i32> @llvm.fptoui.sat.v4i32.v4f32(<4 x float>)
declare <4 x i24> @llvm.fptoui.sat.v4i24.v4f32(<4 x float>)
declare <8 x i16> @llvm.fptosi.sat.v8i16.v8f16(<8 x half>)
declare <8 x i16> @llvm.fptoui.sat.v8i16.v8f16(<8 x half>)
