; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mcpu=generic -mtriple=i386-apple-darwin -verify-machineinstrs -no-integrated-as | FileCheck %s

; There should be no stack manipulations between the inline asm and ret.
define x86_fp80 @test1() nounwind {
; CHECK-LABEL: test1:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fld0
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    retl
  %tmp85 = call x86_fp80 asm sideeffect "fld0", "={st(0)}"()
  ret x86_fp80 %tmp85
}

define double @test2() nounwind {
; CHECK-LABEL: test2:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fld0
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    retl
  %tmp85 = call double asm sideeffect "fld0", "={st(0)}"()
  ret double %tmp85
}

; Setting up argument in st(0) should be a single fld.
; Asm consumes stack, nothing should be popped.
define void @test3(x86_fp80 %X) nounwind {
; CHECK-LABEL: test3:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    subl $12, %esp
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    frob
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    addl $12, %esp
; CHECK-NEXT:    retl
  call void asm sideeffect "frob ", "{st(0)},~{st},~{dirflag},~{fpsr},~{flags}"( x86_fp80 %X)
  ret void
}

define void @test4(double %X) nounwind {
; CHECK-LABEL: test4:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    fldl {{[0-9]+}}(%esp)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    frob
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    retl
  call void asm sideeffect "frob ", "{st(0)},~{st},~{dirflag},~{fpsr},~{flags}"( double %X)
  ret void
}

; Same as test3/4, but using value from fadd.
; The fadd can be done in xmm or x87 regs - we don't test that.
define void @test5(double %X) nounwind {
; CHECK-LABEL: test5:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    fldl {{[0-9]+}}(%esp)
; CHECK-NEXT:    fadds {{\.?LCPI[0-9]+_[0-9]+}}
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    frob
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    retl
  %Y = fadd double %X, 123.0
  call void asm sideeffect "frob ", "{st(0)},~{st},~{dirflag},~{fpsr},~{flags}"( double %Y)
  ret void
}

define void @test6(double %A, double %B, double %C, double %D, double %E) nounwind {
; CHECK-LABEL: test6:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    fldl {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldl {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldl {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldl {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldl {{[0-9]+}}(%esp)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    foo %st %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    bar %st(1) %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(1)
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    baz %st(1) %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    baz %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    retl
entry:
; Uses the same value twice, should have one fstp after the asm.
  tail call void asm sideeffect "foo $0 $1", "f,f,~{dirflag},~{fpsr},~{flags}"( double %A, double %A ) nounwind
; Uses two different values, should be in st(0)/st(1) and both be popped.
  tail call void asm sideeffect "bar $0 $1", "f,f,~{dirflag},~{fpsr},~{flags}"( double %B, double %C ) nounwind
; Uses two different values, one of which isn't killed in this asm, it should not be popped after the asm.
  tail call void asm sideeffect "baz $0 $1", "f,f,~{dirflag},~{fpsr},~{flags}"( double %D, double %E ) nounwind
; This is the last use of %D, so it should be popped after.
  tail call void asm sideeffect "baz $0", "f,~{dirflag},~{fpsr},~{flags}"( double %D ) nounwind
  ret void
}

; PR4185
; Passing a non-killed value to asm in {st}.
; Make sure it is duped before.
; asm kills st(0), so we shouldn't pop anything
; A valid alternative would be to remat the constant pool load before each
; inline asm.
define void @testPR4185() nounwind {
; CHECK-LABEL: testPR4185:
; CHECK:       ## %bb.0: ## %return
; CHECK-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; CHECK-NEXT:    fld %st(0)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistpl %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistpl %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    retl
return:
  call void asm sideeffect "fistpl $0", "{st},~{st}"(double 1.000000e+06)
  call void asm sideeffect "fistpl $0", "{st},~{st}"(double 1.000000e+06)
  ret void
}

; Passing a non-killed value through asm in {st}.
; Make sure it is not duped before.
; Second asm kills st(0), so we shouldn't pop anything
; A valid alternative would be to remat the constant pool load before each inline asm.
define void @testPR4185b() nounwind {
; CHECK-LABEL: testPR4185b:
; CHECK:       ## %bb.0: ## %return
; CHECK-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistl %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistpl %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    retl
return:
	call void asm sideeffect "fistl $0", "{st}"(double 1.000000e+06)
	call void asm sideeffect "fistpl $0", "{st},~{st}"(double 1.000000e+06)
	ret void
}

; PR4459
; The return value from ceil must be duped before being consumed by asm.
define void @testPR4459(x86_fp80 %a) nounwind {
; CHECK-LABEL: testPR4459:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subl $28, %esp
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    fstpt (%esp)
; CHECK-NEXT:    calll _ceil
; CHECK-NEXT:    fld %st(0)
; CHECK-NEXT:    fxch %st(1)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistpl %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstpt (%esp)
; CHECK-NEXT:    calll _test3
; CHECK-NEXT:    addl $28, %esp
; CHECK-NEXT:    retl
entry:
  %0 = call x86_fp80 @ceil(x86_fp80 %a)
  call void asm sideeffect "fistpl $0", "{st},~{st}"( x86_fp80 %0)
  call void @test3(x86_fp80 %0 )
  ret void
}
declare x86_fp80 @ceil(x86_fp80)

; PR4484
; test1 leaves a value on the stack that is needed after the asm.
; Load %a from stack after ceil
; Set up call to test.
define void @testPR4484(x86_fp80 %a) nounwind {
; CHECK-LABEL: testPR4484:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subl $28, %esp
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    fstpt {{[-0-9]+}}(%e{{[sb]}}p) ## 10-byte Folded Spill
; CHECK-NEXT:    calll _test1
; CHECK-NEXT:    fldt {{[-0-9]+}}(%e{{[sb]}}p) ## 10-byte Folded Reload
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistpl %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstpt (%esp)
; CHECK-NEXT:    calll _test3
; CHECK-NEXT:    addl $28, %esp
; CHECK-NEXT:    retl
entry:
  %0 = call x86_fp80 @test1()
  call void asm sideeffect "fistpl $0", "{st},~{st}"(x86_fp80 %a)
  call void @test3(x86_fp80 %0)
  ret void
}

; PR4485
define void @testPR4485(x86_fp80* %a) nounwind {
; CHECK-LABEL: testPR4485:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    fldt (%eax)
; CHECK-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; CHECK-NEXT:    fmul %st, %st(1)
; CHECK-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; CHECK-NEXT:    fmul %st, %st(2)
; CHECK-NEXT:    fxch %st(2)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistpl %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fldt (%eax)
; CHECK-NEXT:    fmulp %st, %st(1)
; CHECK-NEXT:    fmulp %st, %st(1)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistpl %st
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    retl
entry:
  %0 = load x86_fp80, x86_fp80* %a, align 16
  %1 = fmul x86_fp80 %0, 0xK4006B400000000000000
  %2 = fmul x86_fp80 %1, 0xK4012F424000000000000
  tail call void asm sideeffect "fistpl $0", "{st},~{st}"(x86_fp80 %2)
  %3 = load x86_fp80, x86_fp80* %a, align 16
  %4 = fmul x86_fp80 %3, 0xK4006B400000000000000
  %5 = fmul x86_fp80 %4, 0xK4012F424000000000000
  tail call void asm sideeffect "fistpl $0", "{st},~{st}"(x86_fp80 %5)
  ret void
}

; An input argument in a fixed position is implicitly popped by the asm only if
; the input argument is tied to an output register, or it is in the clobber list.
; The clobber list case is tested above.
;
; This doesn't implicitly pop the stack:
;
;   void fist1(long double x, int *p) {
;     asm volatile ("fistl %1" : : "t"(x), "m"(*p));
;   }
define void @fist1(x86_fp80 %x, i32* %p) nounwind ssp {
; CHECK-LABEL: fist1:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subl $12, %esp
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistl (%eax)
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    addl $12, %esp
; CHECK-NEXT:    retl
entry:
  tail call void asm sideeffect "fistl $1", "{st},*m,~{memory},~{dirflag},~{fpsr},~{flags}"(x86_fp80 %x, i32* %p) nounwind
  ret void
}

; Here, the input operand is tied to an output which means that is is
; implicitly popped (and then the output is implicitly pushed).
;
;   long double fist2(long double x, int *p) {
;     long double y;
;     asm ("fistl %1" : "=&t"(y) : "0"(x), "m"(*p) : "memory");
;     return y;
;   }
define x86_fp80 @fist2(x86_fp80 %x, i32* %p) nounwind ssp {
; CHECK-LABEL: fist2:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subl $12, %esp
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fistl (%eax)
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    addl $12, %esp
; CHECK-NEXT:    retl
entry:
  %0 = tail call x86_fp80 asm "fistl $2", "=&{st},0,*m,~{memory},~{dirflag},~{fpsr},~{flags}"(x86_fp80 %x, i32* %p) nounwind
  ret x86_fp80 %0
}

; An 'f' constraint is never implicitly popped:
;
;   void fucomp1(long double x, long double y) {
;     asm volatile ("fucomp %1" : : "t"(x), "f"(y) : "st");
;   }
define void @fucomp1(x86_fp80 %x, x86_fp80 %y) nounwind ssp {
; CHECK-LABEL: fucomp1:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subl $12, %esp
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    fxch %st(1)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fucomp %st(1)
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    addl $12, %esp
; CHECK-NEXT:    retl
entry:
  tail call void asm sideeffect "fucomp $1", "{st},f,~{st},~{dirflag},~{fpsr},~{flags}"(x86_fp80 %x, x86_fp80 %y) nounwind
  ret void
}

; The 'u' constraint is only popped implicitly when clobbered:
;
;   void fucomp2(long double x, long double y) {
;     asm volatile ("fucomp %1" : : "t"(x), "u"(y) : "st");
;   }
;
;   void fucomp3(long double x, long double y) {
;     asm volatile ("fucompp %1" : : "t"(x), "u"(y) : "st", "st(1)");
;   }
;
define void @fucomp2(x86_fp80 %x, x86_fp80 %y) nounwind ssp {
; CHECK-LABEL: fucomp2:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subl $12, %esp
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    fxch %st(1)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fucomp %st(1)
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    addl $12, %esp
; CHECK-NEXT:    retl
entry:
  tail call void asm sideeffect "fucomp $1", "{st},{st(1)},~{st},~{dirflag},~{fpsr},~{flags}"(x86_fp80 %x, x86_fp80 %y) nounwind
  ret void
}

define void @fucomp3(x86_fp80 %x, x86_fp80 %y) nounwind ssp {
; CHECK-LABEL: fucomp3:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subl $12, %esp
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-NEXT:    fxch %st(1)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fucompp %st(1)
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    addl $12, %esp
; CHECK-NEXT:    retl
entry:
  tail call void asm sideeffect "fucompp $1", "{st},{st(1)},~{st},~{st(1)},~{dirflag},~{fpsr},~{flags}"(x86_fp80 %x, x86_fp80 %y) nounwind
  ret void
}

; One input, two outputs, one dead output.
%complex = type { float, float }
define float @sincos1(float %x) nounwind ssp {
; CHECK-LABEL: sincos1:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    flds {{[0-9]+}}(%esp)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    sincos
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(1)
; CHECK-NEXT:    retl
entry:
  %0 = tail call %complex asm "sincos", "={st},={st(1)},0,~{dirflag},~{fpsr},~{flags}"(float %x) nounwind
  %asmresult = extractvalue %complex %0, 0
  ret float %asmresult
}

; Same thing, swapped output operands.
define float @sincos2(float %x) nounwind ssp {
; CHECK-LABEL: sincos2:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    flds {{[0-9]+}}(%esp)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    sincos
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(1)
; CHECK-NEXT:    retl
entry:
  %0 = tail call %complex asm "sincos", "={st(1)},={st},1,~{dirflag},~{fpsr},~{flags}"(float %x) nounwind
  %asmresult = extractvalue %complex %0, 1
  ret float %asmresult
}

; Clobber st(0) after it was live-out/dead from the previous asm.
; Load x, make a copy for the second asm.
; Discard dead result in st(0), bring x to the top.
; x is now in st(0) for the second asm
; Discard both results.
define float @sincos3(float %x) nounwind ssp {
; CHECK-LABEL: sincos3:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    flds {{[0-9]+}}(%esp)
; CHECK-NEXT:    fld %st(0)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    sincos
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    fxch %st(1)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    sincos
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(1)
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    retl
entry:
  %0 = tail call %complex asm sideeffect "sincos", "={st(1)},={st},1,~{dirflag},~{fpsr},~{flags}"(float %x) nounwind
  %1 = tail call %complex asm sideeffect "sincos", "={st(1)},={st},1,~{dirflag},~{fpsr},~{flags}"(float %x) nounwind
  %asmresult = extractvalue %complex %0, 0
  ret float %asmresult
}

; Pass the same value in two fixed stack slots.
define i32 @PR10602() nounwind ssp {
; CHECK-LABEL: PR10602:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    flds {{\.?LCPI[0-9]+_[0-9]+}}
; CHECK-NEXT:    fld %st(0)
; CHECK-NEXT:    fxch %st(1)
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fcomi %st(1), %st; pushf; pop %eax
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    fstp %st(0)
; CHECK-NEXT:    retl
entry:
  %0 = tail call i32 asm "fcomi $2, $1; pushf; pop $0", "=r,{st},{st(1)},~{dirflag},~{fpsr},~{flags}"(double 2.000000e+00, double 2.000000e+00) nounwind
  ret i32 %0
}

; <rdar://problem/16952634>
; X87 stackifier asserted when there was an ST register defined by an
; inline-asm instruction and the ST register was live across another
; inline-asm instruction.
;
; INLINEASM $frndint [sideeffect] [attdialect], $0:[regdef], %st0<imp-def,tied5>, $1:[reguse tiedto:$0], %st0<tied3>, $2:[clobber], early-clobber implicit dead %eflags
; INLINEASM $fldcw $0 [sideeffect] [mayload] [attdialect], $0:[mem], undef %eax, 1, %noreg, 0, %noreg, $1:[clobber], early-clobber implicit dead %eflags
; %fp0 = COPY %st0

%struct.fpu_t = type { [8 x x86_fp80], x86_fp80, %struct.anon1, %struct.anon2, i32, i8, [15 x i8] }
%struct.anon1 = type { i32, i32, i32 }
%struct.anon2 = type { i32, i32, i32, i32 }

@fpu = external global %struct.fpu_t, align 16

; Function Attrs: ssp
define void @test_live_st(i32 %a1) nounwind {
; CHECK-LABEL: test_live_st:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subl $12, %esp
; CHECK-NEXT:    fldt (%eax)
; CHECK-NEXT:    cmpl $1, {{[0-9]+}}(%esp)
; CHECK-NEXT:    jne LBB20_2
; CHECK-NEXT:  ## %bb.1: ## %sw.bb4.i
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    frndint
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    fldcw (%eax)
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:  LBB20_2: ## %_Z5tointRKe.exit
; CHECK-NEXT:    fnstcw (%esp)
; CHECK-NEXT:    movzwl (%esp), %eax
; CHECK-NEXT:    orl $3072, %eax ## imm = 0xC00
; CHECK-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldcw {{[0-9]+}}(%esp)
; CHECK-NEXT:    fistpl {{[0-9]+}}(%esp)
; CHECK-NEXT:    fldcw (%esp)
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    fildl {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl L_fpu$non_lazy_ptr, %eax
; CHECK-NEXT:    fstpt 128(%eax)
; CHECK-NEXT:    addl $12, %esp
; CHECK-NEXT:    retl
entry:
  %0 = load x86_fp80, x86_fp80* undef, align 16
  %cond = icmp eq i32 %a1, 1
  br i1 %cond, label %sw.bb4.i, label %_Z5tointRKe.exit

sw.bb4.i:
  %1 = call x86_fp80 asm sideeffect "frndint", "={st},0,~{dirflag},~{fpsr},~{flags}"(x86_fp80 %0)
  call void asm sideeffect "fldcw $0", "*m,~{dirflag},~{fpsr},~{flags}"(i32* undef)
  br label %_Z5tointRKe.exit

_Z5tointRKe.exit:
  %result.0.i = phi x86_fp80 [ %1, %sw.bb4.i ], [ %0, %entry ]
  %conv.i1814 = fptosi x86_fp80 %result.0.i to i32
  %conv626 = sitofp i32 %conv.i1814 to x86_fp80
  store x86_fp80 %conv626, x86_fp80* getelementptr inbounds (%struct.fpu_t, %struct.fpu_t* @fpu, i32 0, i32 1)
  br label %return

return:
  ret void
}

; Check that x87 stackifier is correctly rewriting FP registers to ST registers.
define double @test_operand_rewrite() nounwind {
; CHECK-LABEL: test_operand_rewrite:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    ## InlineAsm Start
; CHECK-NEXT:    foo %st, %st(1)
; CHECK-NEXT:    ## InlineAsm End
; CHECK-NEXT:    fsubp %st, %st(1)
; CHECK-NEXT:    retl
entry:
  %0 = tail call { double, double } asm sideeffect "foo $0, $1", "={st},={st(1)},~{dirflag},~{fpsr},~{flags}"()
  %asmresult = extractvalue { double, double } %0, 0
  %asmresult1 = extractvalue { double, double } %0, 1
  %sub = fsub double %asmresult, %asmresult1
  ret double %sub
}
