; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2OR3,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSE2OR3,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-FAST-ALL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX2-FAST-PERLANE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX512
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX512

declare <4 x i32> @llvm.usub.sat.v4i32(<4 x i32>, <4 x i32>)

define <8 x i16> @test1(<8 x i16> %x) nounwind {
; SSE-LABEL: test1:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test1:
; AVX:       # %bb.0: # %vector.ph
; AVX-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %0 = icmp slt <8 x i16> %x, zeroinitializer
  %1 = xor <8 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %res = select <8 x i1> %0, <8 x i16> %1, <8 x i16> zeroinitializer
  ret <8 x i16> %res
}

; This is logically equivalent to the above.
; usubsat X, (1 << (BW-1)) <--> (X ^ (1 << (BW-1))) & (ashr X, (BW-1))

define <8 x i16> @ashr_xor_and(<8 x i16> %x) nounwind {
; SSE-LABEL: ashr_xor_and:
; SSE:       # %bb.0:
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: ashr_xor_and:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %signsplat = ashr <8 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %flipsign = xor <8 x i16> %x, <i16 undef, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768>
  %res = and <8 x i16> %signsplat, %flipsign
  ret <8 x i16> %res
}

define <8 x i16> @ashr_add_and(<8 x i16> %x) nounwind {
; SSE-LABEL: ashr_add_and:
; SSE:       # %bb.0:
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: ashr_add_and:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %signsplat = ashr <8 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %flipsign = add <8 x i16> %x, <i16 undef, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768>
  %res = and <8 x i16> %signsplat, %flipsign
  ret <8 x i16> %res
}

; negative test - extra uses may lead to extra instructions when custom-lowered

define <16 x i8> @ashr_xor_and_commute_uses(<16 x i8> %x, <16 x i8>* %p1, <16 x i8>* %p2) nounwind {
; SSE-LABEL: ashr_xor_and_commute_uses:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, (%rdi)
; SSE-NEXT:    pxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    movdqa %xmm0, (%rsi)
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: ashr_xor_and_commute_uses:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa %xmm1, (%rdi)
; AVX-NEXT:    vpxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %signsplat = ashr <16 x i8> %x, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  store <16 x i8> %signsplat, <16 x i8>* %p1
  %flipsign = xor <16 x i8> %x, <i8 undef, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128, i8 128>
  store <16 x i8> %flipsign, <16 x i8>* %p2
  %res = and <16 x i8> %flipsign, %signsplat
  ret <16 x i8> %res
}

define <4 x i32> @ashr_xor_and_custom(<4 x i32> %x) nounwind {
; SSE2OR3-LABEL: ashr_xor_and_custom:
; SSE2OR3:       # %bb.0:
; SSE2OR3-NEXT:    movdqa %xmm0, %xmm1
; SSE2OR3-NEXT:    psrad $31, %xmm1
; SSE2OR3-NEXT:    pxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2OR3-NEXT:    pand %xmm1, %xmm0
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: ashr_xor_and_custom:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    pmaxud %xmm1, %xmm0
; SSE41-NEXT:    psubd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: ashr_xor_and_custom:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ashr_xor_and_custom:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_xor_and_custom:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX512-NEXT:    vpternlogd $72, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm0
; AVX512-NEXT:    retq
  %signsplat = ashr <4 x i32> %x, <i32 undef, i32 31, i32 31, i32 31>
  %flipsign = xor <4 x i32> %x, <i32 2147483648, i32 2147483648, i32 2147483648, i32 2147483648>
  %res = and <4 x i32> %flipsign, %signsplat
  ret <4 x i32> %res
}

define <4 x i32> @ashr_add_and_custom(<4 x i32> %x) nounwind {
; SSE2OR3-LABEL: ashr_add_and_custom:
; SSE2OR3:       # %bb.0:
; SSE2OR3-NEXT:    movdqa %xmm0, %xmm1
; SSE2OR3-NEXT:    psrad $31, %xmm1
; SSE2OR3-NEXT:    pxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2OR3-NEXT:    pand %xmm1, %xmm0
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: ashr_add_and_custom:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE41-NEXT:    pmaxud %xmm1, %xmm0
; SSE41-NEXT:    psubd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: ashr_add_and_custom:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ashr_add_and_custom:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_add_and_custom:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX512-NEXT:    vpternlogd $72, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm0
; AVX512-NEXT:    retq
  %signsplat = ashr <4 x i32> %x, <i32 undef, i32 31, i32 31, i32 31>
  %flipsign = add <4 x i32> %x, <i32 2147483648, i32 2147483648, i32 2147483648, i32 2147483648>
  %res = and <4 x i32> %flipsign, %signsplat
  ret <4 x i32> %res
}

; usubsat X, (1 << (BW-1)) <--> (X ^ (1 << (BW-1))) & (ashr X, (BW-1))

define <4 x i32> @usubsat_custom(<4 x i32> %x) nounwind {
; SSE2OR3-LABEL: usubsat_custom:
; SSE2OR3:       # %bb.0:
; SSE2OR3-NEXT:    movdqa %xmm0, %xmm1
; SSE2OR3-NEXT:    psrad $31, %xmm1
; SSE2OR3-NEXT:    pxor {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2OR3-NEXT:    pand %xmm1, %xmm0
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: usubsat_custom:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm1 = <2147483648,2147483648,2147483648,u>
; SSE41-NEXT:    pmaxud %xmm1, %xmm0
; SSE41-NEXT:    psubd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: usubsat_custom:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = <2147483648,2147483648,2147483648,u>
; AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: usubsat_custom:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; AVX2-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: usubsat_custom:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrad $31, %xmm0, %xmm1
; AVX512-NEXT:    vpternlogd $72, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm0
; AVX512-NEXT:    retq
  %res = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> %x, <4 x i32> <i32 2147483648, i32 2147483648, i32 2147483648, i32 undef>)
  ret <4 x i32> %res
}

define <8 x i16> @test2(<8 x i16> %x) nounwind {
; SSE-LABEL: test2:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2:
; AVX:       # %bb.0: # %vector.ph
; AVX-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %0 = icmp ugt <8 x i16> %x, <i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766>
  %1 = add <8 x i16> %x, <i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767>
  %res = select <8 x i1> %0, <8 x i16> %1, <8 x i16> zeroinitializer
  ret <8 x i16> %res
}

define <8 x i16> @test3(<8 x i16> %x, i16 zeroext %w) nounwind {
; SSE-LABEL: test3:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    movd %edi, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE-NEXT:    psubusw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test3:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vmovd %edi, %xmm1
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm1 = xmm1[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test3:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm1
; AVX2-NEXT:    vpbroadcastw %xmm1, %xmm1
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test3:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpbroadcastw %edi, %xmm1
; AVX512-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = insertelement <8 x i16> undef, i16 %w, i32 0
  %broadcast15 = shufflevector <8 x i16> %0, <8 x i16> undef, <8 x i32> zeroinitializer
  %1 = icmp ult <8 x i16> %x, %broadcast15
  %2 = sub <8 x i16> %x, %broadcast15
  %res = select <8 x i1> %1, <8 x i16> zeroinitializer, <8 x i16> %2
  ret <8 x i16> %res
}

define <16 x i8> @test4(<16 x i8> %x) nounwind {
; SSE-LABEL: test4:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test4:
; AVX:       # %bb.0: # %vector.ph
; AVX-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %0 = icmp slt <16 x i8> %x, zeroinitializer
  %1 = xor <16 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %res = select <16 x i1> %0, <16 x i8> %1, <16 x i8> zeroinitializer
  ret <16 x i8> %res
}

define <16 x i8> @test5(<16 x i8> %x) nounwind {
; SSE-LABEL: test5:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test5:
; AVX:       # %bb.0: # %vector.ph
; AVX-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %0 = icmp ugt <16 x i8> %x, <i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126>
  %1 = add <16 x i8> %x, <i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127>
  %res = select <16 x i1> %0, <16 x i8> %1, <16 x i8> zeroinitializer
  ret <16 x i8> %res
}

define <16 x i8> @test6(<16 x i8> %x, i8 zeroext %w) nounwind {
; SSE2-LABEL: test6:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    movd %edi, %xmm1
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,0,0,0]
; SSE2-NEXT:    psubusb %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test6:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    movd %edi, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm2
; SSSE3-NEXT:    pshufb %xmm2, %xmm1
; SSSE3-NEXT:    psubusb %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test6:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movd %edi, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pshufb %xmm2, %xmm1
; SSE41-NEXT:    psubusb %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test6:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vmovd %edi, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test6:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm1
; AVX2-NEXT:    vpbroadcastb %xmm1, %xmm1
; AVX2-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test6:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpbroadcastb %edi, %xmm1
; AVX512-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = insertelement <16 x i8> undef, i8 %w, i32 0
  %broadcast15 = shufflevector <16 x i8> %0, <16 x i8> undef, <16 x i32> zeroinitializer
  %1 = icmp ult <16 x i8> %x, %broadcast15
  %2 = sub <16 x i8> %x, %broadcast15
  %res = select <16 x i1> %1, <16 x i8> zeroinitializer, <16 x i8> %2
  ret <16 x i8> %res
}

define <16 x i16> @test7(<16 x i16> %x) nounwind {
; SSE-LABEL: test7:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test7:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; AVX1-NEXT:    vpsubusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test7:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test7:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = icmp slt <16 x i16> %x, zeroinitializer
  %1 = xor <16 x i16> %x, <i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768, i16 -32768>
  %res = select <16 x i1> %0, <16 x i16> %1, <16 x i16> zeroinitializer
  ret <16 x i16> %res
}

define <16 x i16> @ashr_xor_and_v16i16(<16 x i16> %x) nounwind {
; SSE-LABEL: ashr_xor_and_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: ashr_xor_and_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; AVX1-NEXT:    vpsubusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ashr_xor_and_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_xor_and_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %signsplat = ashr <16 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %flipsign = xor <16 x i16> %x, <i16 undef, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768>
  %res = and <16 x i16> %signsplat, %flipsign
  ret <16 x i16> %res
}

define <16 x i16> @ashr_add_and_v16i16(<16 x i16> %x) nounwind {
; SSE-LABEL: ashr_add_and_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: ashr_add_and_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; AVX1-NEXT:    vpsubusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: ashr_add_and_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_add_and_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %signsplat = ashr <16 x i16> %x, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %flipsign = add <16 x i16> %x, <i16 undef, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768, i16 32768>
  %res = and <16 x i16> %signsplat, %flipsign
  ret <16 x i16> %res
}

define <16 x i16> @test8(<16 x i16> %x) nounwind {
; SSE-LABEL: test8:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32767,32767,32767,32767,32767,32767,32767,32767]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test8:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [32767,32767,32767,32767,32767,32767,32767,32767]
; AVX1-NEXT:    vpsubusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test8:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test8:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = icmp ugt <16 x i16> %x, <i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766, i16 32766>
  %1 = add <16 x i16> %x, <i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767, i16 -32767>
  %res = select <16 x i1> %0, <16 x i16> %1, <16 x i16> zeroinitializer
  ret <16 x i16> %res
}

define <16 x i16> @test8a(<16 x i16> %x) nounwind {
; SSE-LABEL: test8a:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test8a:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test8a:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test8a:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = icmp ugt <16 x i16> %x, <i16 32766, i16 32765, i16 32764, i16 32763, i16 32762, i16 32761, i16 32760, i16 32759, i16 32758, i16 32757, i16 32756, i16 32755, i16 32754, i16 32753, i16 32752, i16 32751>
  %1 = add <16 x i16> %x, <i16 -32767, i16 -32766, i16 -32765, i16 -32764, i16 -32763, i16 -32762, i16 -32761, i16 -32760, i16 -32759, i16 -32758, i16 -32757, i16 -32756, i16 -32755, i16 -32754, i16 -32753, i16 -32752>
  %res = select <16 x i1> %0, <16 x i16> %1, <16 x i16> zeroinitializer
  ret <16 x i16> %res
}

define <16 x i16> @test9(<16 x i16> %x, i16 zeroext %w) nounwind {
; SSE-LABEL: test9:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    movd %edi, %xmm2
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test9:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovd %edi, %xmm2
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; AVX1-NEXT:    vpsubusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test9:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm1
; AVX2-NEXT:    vpbroadcastw %xmm1, %ymm1
; AVX2-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test9:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpbroadcastw %edi, %ymm1
; AVX512-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = insertelement <16 x i16> undef, i16 %w, i32 0
  %broadcast15 = shufflevector <16 x i16> %0, <16 x i16> undef, <16 x i32> zeroinitializer
  %1 = icmp ult <16 x i16> %x, %broadcast15
  %2 = sub <16 x i16> %x, %broadcast15
  %res = select <16 x i1> %1, <16 x i16> zeroinitializer, <16 x i16> %2
  ret <16 x i16> %res
}

define <32 x i8> @test10(<32 x i8> %x) nounwind {
; SSE-LABEL: test10:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    psubusb %xmm2, %xmm0
; SSE-NEXT:    psubusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test10:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX1-NEXT:    vpsubusb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test10:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test10:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = icmp slt <32 x i8> %x, zeroinitializer
  %1 = xor <32 x i8> %x, <i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128, i8 -128>
  %res = select <32 x i1> %0, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %res
}

define <32 x i8> @test11(<32 x i8> %x) nounwind {
; SSE-LABEL: test11:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE-NEXT:    psubusb %xmm2, %xmm0
; SSE-NEXT:    psubusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test11:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpsubusb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test11:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = icmp ugt <32 x i8> %x, <i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126, i8 126>
  %1 = add <32 x i8> %x, <i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127, i8 -127>
  %res = select <32 x i1> %0, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %res
}

define <32 x i8> @test11a(<32 x i8> %x) nounwind {
; SSE-LABEL: test11a:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test11a:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test11a:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test11a:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = icmp ugt <32 x i8> %x, <i8 126, i8 125, i8 124, i8 123, i8 122, i8 121, i8 120, i8 119, i8 118, i8 117, i8 116, i8 115, i8 114, i8 113, i8 112, i8 111, i8 110, i8 109, i8 108, i8 107, i8 106, i8 105, i8 104, i8 103, i8 102, i8 101, i8 100, i8 99, i8 98, i8 97, i8 96, i8 95>
  %1 = add <32 x i8> %x, <i8 -127, i8 -126, i8 -125, i8 -124, i8 -123, i8 -122, i8 -121, i8 -120, i8 -119, i8 -118, i8 -117, i8 -116, i8 -115, i8 -114, i8 -113, i8 -112, i8 -111, i8 -110, i8 -109, i8 -108, i8 -107, i8 -106, i8 -105, i8 -104, i8 -103, i8 -102, i8 -101, i8 -100, i8 -99, i8 -98, i8 -97, i8 -96>
  %res = select <32 x i1> %0, <32 x i8> %1, <32 x i8> zeroinitializer
  ret <32 x i8> %res
}

define <32 x i8> @test12(<32 x i8> %x, i8 zeroext %w) nounwind {
; SSE2-LABEL: test12:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    movd %edi, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE2-NEXT:    psubusb %xmm2, %xmm0
; SSE2-NEXT:    psubusb %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test12:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    movd %edi, %xmm2
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    pshufb %xmm3, %xmm2
; SSSE3-NEXT:    psubusb %xmm2, %xmm0
; SSSE3-NEXT:    psubusb %xmm2, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test12:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movd %edi, %xmm2
; SSE41-NEXT:    pxor %xmm3, %xmm3
; SSE41-NEXT:    pshufb %xmm3, %xmm2
; SSE41-NEXT:    psubusb %xmm2, %xmm0
; SSE41-NEXT:    psubusb %xmm2, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test12:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vmovd %edi, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsubusb %xmm1, %xmm2, %xmm2
; AVX1-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test12:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm1
; AVX2-NEXT:    vpbroadcastb %xmm1, %ymm1
; AVX2-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test12:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpbroadcastb %edi, %ymm1
; AVX512-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = insertelement <32 x i8> undef, i8 %w, i32 0
  %broadcast15 = shufflevector <32 x i8> %0, <32 x i8> undef, <32 x i32> zeroinitializer
  %1 = icmp ult <32 x i8> %x, %broadcast15
  %2 = sub <32 x i8> %x, %broadcast15
  %res = select <32 x i1> %1, <32 x i8> zeroinitializer, <32 x i8> %2
  ret <32 x i8> %res
}

define <8 x i16> @test13(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: test13:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    por %xmm2, %xmm6
; SSE2-NEXT:    pslld $16, %xmm6
; SSE2-NEXT:    psrad $16, %xmm6
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pslld $16, %xmm5
; SSE2-NEXT:    psrad $16, %xmm5
; SSE2-NEXT:    packssdw %xmm6, %xmm5
; SSE2-NEXT:    psubusw %xmm5, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test13:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535]
; SSSE3-NEXT:    pand %xmm6, %xmm2
; SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSSE3-NEXT:    por %xmm2, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSSE3-NEXT:    por %xmm1, %xmm5
; SSSE3-NEXT:    pshufb %xmm2, %xmm5
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; SSSE3-NEXT:    psubusw %xmm5, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test13:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; SSE41-NEXT:    pminud %xmm3, %xmm2
; SSE41-NEXT:    pminud %xmm3, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    psubusw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test13:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpminud %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test13:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test13:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovusdw %ymm1, %xmm1
; AVX512-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ult <8 x i32> %lhs, %y
  %sub = sub <8 x i32> %lhs, %y
  %trunc = trunc <8 x i32> %sub to <8 x i16>
  %res = select <8 x i1> %cond, <8 x i16> zeroinitializer, <8 x i16> %trunc
  ret <8 x i16> %res
}

; FIXME: match this to UMIN+TRUNC+PSUBUS
define <16 x i8> @test14(<16 x i8> %x, <16 x i32> %y) nounwind {
; SSE2OR3-LABEL: test14:
; SSE2OR3:       # %bb.0: # %vector.ph
; SSE2OR3-NEXT:    pxor %xmm8, %xmm8
; SSE2OR3-NEXT:    movdqa %xmm0, %xmm6
; SSE2OR3-NEXT:    movdqa %xmm4, %xmm9
; SSE2OR3-NEXT:    movdqa %xmm3, %xmm10
; SSE2OR3-NEXT:    movdqa %xmm2, %xmm7
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm5 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE2OR3-NEXT:    pand %xmm5, %xmm4
; SSE2OR3-NEXT:    pand %xmm5, %xmm3
; SSE2OR3-NEXT:    packuswb %xmm4, %xmm3
; SSE2OR3-NEXT:    movdqa %xmm1, %xmm4
; SSE2OR3-NEXT:    pand %xmm5, %xmm2
; SSE2OR3-NEXT:    pand %xmm5, %xmm1
; SSE2OR3-NEXT:    packuswb %xmm2, %xmm1
; SSE2OR3-NEXT:    packuswb %xmm3, %xmm1
; SSE2OR3-NEXT:    psubb %xmm0, %xmm1
; SSE2OR3-NEXT:    movdqa %xmm0, %xmm2
; SSE2OR3-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm8[0],xmm2[1],xmm8[1],xmm2[2],xmm8[2],xmm2[3],xmm8[3],xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE2OR3-NEXT:    movdqa %xmm2, %xmm0
; SSE2OR3-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0],xmm8[0],xmm0[1],xmm8[1],xmm0[2],xmm8[2],xmm0[3],xmm8[3]
; SSE2OR3-NEXT:    punpckhwd {{.*#+}} xmm2 = xmm2[4],xmm8[4],xmm2[5],xmm8[5],xmm2[6],xmm8[6],xmm2[7],xmm8[7]
; SSE2OR3-NEXT:    punpckhbw {{.*#+}} xmm6 = xmm6[8],xmm8[8],xmm6[9],xmm8[9],xmm6[10],xmm8[10],xmm6[11],xmm8[11],xmm6[12],xmm8[12],xmm6[13],xmm8[13],xmm6[14],xmm8[14],xmm6[15],xmm8[15]
; SSE2OR3-NEXT:    movdqa %xmm6, %xmm3
; SSE2OR3-NEXT:    punpcklwd {{.*#+}} xmm3 = xmm3[0],xmm8[0],xmm3[1],xmm8[1],xmm3[2],xmm8[2],xmm3[3],xmm8[3]
; SSE2OR3-NEXT:    punpckhwd {{.*#+}} xmm6 = xmm6[4],xmm8[4],xmm6[5],xmm8[5],xmm6[6],xmm8[6],xmm6[7],xmm8[7]
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm5 = [2147483648,2147483648,2147483648,2147483648]
; SSE2OR3-NEXT:    pxor %xmm5, %xmm9
; SSE2OR3-NEXT:    por %xmm5, %xmm6
; SSE2OR3-NEXT:    pcmpgtd %xmm9, %xmm6
; SSE2OR3-NEXT:    pxor %xmm5, %xmm10
; SSE2OR3-NEXT:    por %xmm5, %xmm3
; SSE2OR3-NEXT:    pcmpgtd %xmm10, %xmm3
; SSE2OR3-NEXT:    packssdw %xmm6, %xmm3
; SSE2OR3-NEXT:    pxor %xmm5, %xmm7
; SSE2OR3-NEXT:    por %xmm5, %xmm2
; SSE2OR3-NEXT:    pcmpgtd %xmm7, %xmm2
; SSE2OR3-NEXT:    pxor %xmm5, %xmm4
; SSE2OR3-NEXT:    por %xmm5, %xmm0
; SSE2OR3-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE2OR3-NEXT:    packssdw %xmm2, %xmm0
; SSE2OR3-NEXT:    packsswb %xmm3, %xmm0
; SSE2OR3-NEXT:    pandn %xmm1, %xmm0
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: test14:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,1,1]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm8 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[2,3,2,3]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE41-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[3,3,3,3]
; SSE41-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero,xmm6[2],zero,zero,zero,xmm6[3],zero,zero,zero
; SSE41-NEXT:    pmaxud %xmm4, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm9
; SSE41-NEXT:    pxor %xmm9, %xmm6
; SSE41-NEXT:    pmaxud %xmm3, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm7
; SSE41-NEXT:    pxor %xmm9, %xmm7
; SSE41-NEXT:    packssdw %xmm6, %xmm7
; SSE41-NEXT:    pmaxud %xmm1, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm5
; SSE41-NEXT:    pxor %xmm9, %xmm5
; SSE41-NEXT:    pmaxud %xmm2, %xmm8
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm8
; SSE41-NEXT:    pxor %xmm9, %xmm8
; SSE41-NEXT:    packssdw %xmm8, %xmm5
; SSE41-NEXT:    packsswb %xmm7, %xmm5
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE41-NEXT:    pand %xmm6, %xmm4
; SSE41-NEXT:    pand %xmm6, %xmm3
; SSE41-NEXT:    packusdw %xmm4, %xmm3
; SSE41-NEXT:    pand %xmm6, %xmm2
; SSE41-NEXT:    pand %xmm6, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    packuswb %xmm3, %xmm1
; SSE41-NEXT:    psubb %xmm0, %xmm1
; SSE41-NEXT:    pandn %xmm1, %xmm5
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test14:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm4 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm5 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero,xmm5[2],zero,zero,zero,xmm5[3],zero,zero,zero
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovzxbd {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero,xmm6[2],zero,zero,zero,xmm6[3],zero,zero,zero
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm7
; AVX1-NEXT:    vpmaxud %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vpxor %xmm7, %xmm6, %xmm6
; AVX1-NEXT:    vpmaxud %xmm5, %xmm2, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm2, %xmm5
; AVX1-NEXT:    vpxor %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpackssdw %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpmaxud %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpxor %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; AVX1-NEXT:    vpmaxud %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpxor %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpackssdw %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpacksswb %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpandn %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test14:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero,xmm3[4],zero,zero,zero,xmm3[5],zero,zero,zero,xmm3[6],zero,zero,zero,xmm3[7],zero,zero,zero
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm4 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpmaxud %ymm4, %ymm1, %ymm4
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm1, %ymm4
; AVX2-NEXT:    vpcmpeqd %ymm5, %ymm5, %ymm5
; AVX2-NEXT:    vpxor %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vextracti128 $1, %ymm4, %xmm6
; AVX2-NEXT:    vpackssdw %xmm6, %xmm4, %xmm4
; AVX2-NEXT:    vpmaxud %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpxor %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vextracti128 $1, %ymm3, %xmm5
; AVX2-NEXT:    vpackssdw %xmm5, %xmm3, %xmm3
; AVX2-NEXT:    vpacksswb %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpackusdw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; AVX2-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpandn %xmm0, %xmm3, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test14:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512-NEXT:    vpcmpnltud %zmm2, %zmm1, %k1
; AVX512-NEXT:    vpmovdb %zmm1, %xmm1
; AVX512-NEXT:    vpsubb %xmm0, %xmm1, %xmm0 {%k1} {z}
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
vector.ph:
  %rhs = zext <16 x i8> %x to <16 x i32>
  %cond = icmp ult <16 x i32> %y, %rhs
  %sub = sub <16 x i32> %y, %rhs
  %truncsub = trunc <16 x i32> %sub to <16 x i8>
  %res = select <16 x i1> %cond, <16 x i8> zeroinitializer, <16 x i8> %truncsub
  ret <16 x i8> %res
}

define <8 x i16> @test15(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: test15:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    por %xmm2, %xmm6
; SSE2-NEXT:    pslld $16, %xmm6
; SSE2-NEXT:    psrad $16, %xmm6
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pslld $16, %xmm5
; SSE2-NEXT:    psrad $16, %xmm5
; SSE2-NEXT:    packssdw %xmm6, %xmm5
; SSE2-NEXT:    psubusw %xmm5, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test15:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535]
; SSSE3-NEXT:    pand %xmm6, %xmm2
; SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSSE3-NEXT:    por %xmm2, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSSE3-NEXT:    por %xmm1, %xmm5
; SSSE3-NEXT:    pshufb %xmm2, %xmm5
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; SSSE3-NEXT:    psubusw %xmm5, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test15:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; SSE41-NEXT:    pminud %xmm3, %xmm2
; SSE41-NEXT:    pminud %xmm3, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    psubusw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test15:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpminud %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test15:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test15:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovusdw %ymm1, %xmm1
; AVX512-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ugt <8 x i32> %lhs, %y
  %sub = sub <8 x i32> %lhs, %y
  %truncsub = trunc <8 x i32> %sub to <8 x i16>
  %res = select <8 x i1> %cond, <8 x i16> %truncsub, <8 x i16> zeroinitializer
  ret <8 x i16> %res
}

; FIXME: match this to UMIN+TRUNC+PSUBUS
define <8 x i16> @test16(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: test16:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    pxor %xmm3, %xmm6
; SSE2-NEXT:    por %xmm3, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm5
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    pxor %xmm3, %xmm6
; SSE2-NEXT:    por %xmm3, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE2-NEXT:    packssdw %xmm5, %xmm4
; SSE2-NEXT:    pslld $16, %xmm2
; SSE2-NEXT:    psrad $16, %xmm2
; SSE2-NEXT:    pslld $16, %xmm1
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    packssdw %xmm2, %xmm1
; SSE2-NEXT:    psubw %xmm1, %xmm0
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test16:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    pxor %xmm3, %xmm3
; SSSE3-NEXT:    movdqa %xmm0, %xmm4
; SSSE3-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm3[0],xmm4[1],xmm3[1],xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; SSSE3-NEXT:    movdqa %xmm0, %xmm5
; SSSE3-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm3[4],xmm5[5],xmm3[5],xmm5[6],xmm3[6],xmm5[7],xmm3[7]
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm3, %xmm6
; SSSE3-NEXT:    por %xmm3, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm5
; SSSE3-NEXT:    movdqa %xmm1, %xmm6
; SSSE3-NEXT:    pxor %xmm3, %xmm6
; SSSE3-NEXT:    por %xmm3, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm6, %xmm4
; SSSE3-NEXT:    packssdw %xmm5, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm3, %xmm2
; SSSE3-NEXT:    pshufb %xmm3, %xmm1
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSSE3-NEXT:    psubw %xmm1, %xmm0
; SSSE3-NEXT:    pand %xmm4, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test16:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    pxor %xmm3, %xmm3
; SSE41-NEXT:    movdqa %xmm0, %xmm4
; SSE41-NEXT:    punpckhwd {{.*#+}} xmm4 = xmm4[4],xmm3[4],xmm4[5],xmm3[5],xmm4[6],xmm3[6],xmm4[7],xmm3[7]
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE41-NEXT:    pmaxud %xmm2, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE41-NEXT:    pxor %xmm6, %xmm4
; SSE41-NEXT:    pmaxud %xmm1, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm5
; SSE41-NEXT:    pxor %xmm6, %xmm5
; SSE41-NEXT:    packssdw %xmm4, %xmm5
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2],xmm3[3],xmm2[4],xmm3[5],xmm2[6],xmm3[7]
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0],xmm3[1],xmm1[2],xmm3[3],xmm1[4],xmm3[5],xmm1[6],xmm3[7]
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    psubw %xmm1, %xmm0
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test16:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm2 = xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpmaxud %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpmaxud %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpackssdw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = <0,1,4,5,8,9,12,13,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm3, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; AVX1-NEXT:    vpsubw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test16:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm2 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpmaxud %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpxor %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpackssdw %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,4,5,8,9,12,13,u,u,u,u,u,u,u,u,16,17,20,21,24,25,28,29,u,u,u,u,u,u,u,u]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vpsubw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test16:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovzxwd {{.*#+}} ymm2 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vpcmpltud %ymm2, %ymm1, %k1
; AVX512-NEXT:    vpmovdw %ymm1, %xmm1
; AVX512-NEXT:    vpsubw %xmm1, %xmm0, %xmm0 {%k1} {z}
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ult <8 x i32> %y, %lhs
  %sub = sub <8 x i32> %lhs, %y
  %truncsub = trunc <8 x i32> %sub to <8 x i16>
  %res = select <8 x i1> %cond, <8 x i16> %truncsub, <8 x i16> zeroinitializer
  ret <8 x i16> %res
}

define <64 x i8> @test17(<64 x i8> %x, i8 zeroext %w) nounwind {
; SSE2-LABEL: test17:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,0,0,0,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE2-NEXT:    psubusb %xmm4, %xmm0
; SSE2-NEXT:    psubusb %xmm4, %xmm1
; SSE2-NEXT:    psubusb %xmm4, %xmm2
; SSE2-NEXT:    psubusb %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test17:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    movd %edi, %xmm4
; SSSE3-NEXT:    pxor %xmm5, %xmm5
; SSSE3-NEXT:    pshufb %xmm5, %xmm4
; SSSE3-NEXT:    psubusb %xmm4, %xmm0
; SSSE3-NEXT:    psubusb %xmm4, %xmm1
; SSSE3-NEXT:    psubusb %xmm4, %xmm2
; SSSE3-NEXT:    psubusb %xmm4, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test17:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movd %edi, %xmm4
; SSE41-NEXT:    pxor %xmm5, %xmm5
; SSE41-NEXT:    pshufb %xmm5, %xmm4
; SSE41-NEXT:    psubusb %xmm4, %xmm0
; SSE41-NEXT:    psubusb %xmm4, %xmm1
; SSE41-NEXT:    psubusb %xmm4, %xmm2
; SSE41-NEXT:    psubusb %xmm4, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test17:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vmovd %edi, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubusb %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpsubusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpsubusb %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpsubusb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test17:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vpsubusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubusb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test17:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpbroadcastb %edi, %zmm1
; AVX512-NEXT:    vpsubusb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = insertelement <64 x i8> undef, i8 %w, i32 0
  %broadcast15 = shufflevector <64 x i8> %0, <64 x i8> undef, <64 x i32> zeroinitializer
  %1 = icmp ult <64 x i8> %x, %broadcast15
  %2 = sub <64 x i8> %x, %broadcast15
  %res = select <64 x i1> %1, <64 x i8> zeroinitializer, <64 x i8> %2
  ret <64 x i8> %res
}

define <32 x i16> @test18(<32 x i16> %x, i16 zeroext %w) nounwind {
; SSE-LABEL: test18:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    movd %edi, %xmm4
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,0,0,0,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE-NEXT:    psubusw %xmm4, %xmm0
; SSE-NEXT:    psubusw %xmm4, %xmm1
; SSE-NEXT:    psubusw %xmm4, %xmm2
; SSE-NEXT:    psubusw %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test18:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovd %edi, %xmm3
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm3 = xmm3[0,0,0,0,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm3[0,0,0,0]
; AVX1-NEXT:    vpsubusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsubusw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsubusw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsubusw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test18:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastw %xmm2, %ymm2
; AVX2-NEXT:    vpsubusw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubusw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test18:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpbroadcastw %edi, %zmm1
; AVX512-NEXT:    vpsubusw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
vector.ph:
  %0 = insertelement <32 x i16> undef, i16 %w, i32 0
  %broadcast15 = shufflevector <32 x i16> %0, <32 x i16> undef, <32 x i32> zeroinitializer
  %1 = icmp ult <32 x i16> %x, %broadcast15
  %2 = sub <32 x i16> %x, %broadcast15
  %res = select <32 x i1> %1, <32 x i16> zeroinitializer, <32 x i16> %2
  ret <32 x i16> %res
}

define <8 x i16> @psubus_8i16_max(<8 x i16> %x, <8 x i16> %y) nounwind {
; SSE-LABEL: psubus_8i16_max:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: psubus_8i16_max:
; AVX:       # %bb.0: # %vector.ph
; AVX-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %cmp = icmp ult <8 x i16> %x, %y
  %max = select <8 x i1> %cmp, <8 x i16> %y, <8 x i16> %x
  %res = sub <8 x i16> %max, %y
  ret <8 x i16> %res
}

define <16 x i8> @psubus_16i8_max(<16 x i8> %x, <16 x i8> %y) nounwind {
; SSE-LABEL: psubus_16i8_max:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: psubus_16i8_max:
; AVX:       # %bb.0: # %vector.ph
; AVX-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
vector.ph:
  %cmp = icmp ult <16 x i8> %x, %y
  %max = select <16 x i1> %cmp, <16 x i8> %y, <16 x i8> %x
  %res = sub <16 x i8> %max, %y
  ret <16 x i8> %res
}

define <16 x i16> @psubus_16i16_max(<16 x i16> %x, <16 x i16> %y) nounwind {
; SSE-LABEL: psubus_16i16_max:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: psubus_16i16_max:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubusw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_16i16_max:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_16i16_max:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %cmp = icmp ult <16 x i16> %x, %y
  %max = select <16 x i1> %cmp, <16 x i16> %y, <16 x i16> %x
  %res = sub <16 x i16> %max, %y
  ret <16 x i16> %res
}

define <32 x i16> @psubus_32i16_max(<32 x i16> %x, <32 x i16> %y) nounwind {
; SSE-LABEL: psubus_32i16_max:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusw %xmm4, %xmm0
; SSE-NEXT:    psubusw %xmm5, %xmm1
; SSE-NEXT:    psubusw %xmm6, %xmm2
; SSE-NEXT:    psubusw %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: psubus_32i16_max:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpsubusw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpsubusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpsubusw %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsubusw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_32i16_max:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubusw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_32i16_max:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
vector.ph:
  %cmp = icmp ult <32 x i16> %x, %y
  %max = select <32 x i1> %cmp, <32 x i16> %y, <32 x i16> %x
  %res = sub <32 x i16> %max, %y
  ret <32 x i16> %res
}

define <64 x i8> @psubus_64i8_max(<64 x i8> %x, <64 x i8> %y) nounwind {
; SSE-LABEL: psubus_64i8_max:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusb %xmm4, %xmm0
; SSE-NEXT:    psubusb %xmm5, %xmm1
; SSE-NEXT:    psubusb %xmm6, %xmm2
; SSE-NEXT:    psubusb %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: psubus_64i8_max:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpsubusb %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpsubusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpsubusb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpsubusb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_64i8_max:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubusb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_64i8_max:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
vector.ph:
  %cmp = icmp ult <64 x i8> %x, %y
  %max = select <64 x i1> %cmp, <64 x i8> %y, <64 x i8> %x
  %res = sub <64 x i8> %max, %y
  ret <64 x i8> %res
}

define <32 x i8> @psubus_32i8_max(<32 x i8> %x, <32 x i8> %y) nounwind {
; SSE-LABEL: psubus_32i8_max:
; SSE:       # %bb.0: # %vector.ph
; SSE-NEXT:    psubusb %xmm2, %xmm0
; SSE-NEXT:    psubusb %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: psubus_32i8_max:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubusb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_32i8_max:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_32i8_max:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %cmp = icmp ult <32 x i8> %x, %y
  %max = select <32 x i1> %cmp, <32 x i8> %y, <32 x i8> %x
  %res = sub <32 x i8> %max, %y
  ret <32 x i8> %res
}

define <8 x i16> @psubus_8i32_max(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: psubus_8i32_max:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    por %xmm2, %xmm6
; SSE2-NEXT:    pslld $16, %xmm6
; SSE2-NEXT:    psrad $16, %xmm6
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pslld $16, %xmm5
; SSE2-NEXT:    psrad $16, %xmm5
; SSE2-NEXT:    packssdw %xmm6, %xmm5
; SSE2-NEXT:    psubusw %xmm5, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: psubus_8i32_max:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535]
; SSSE3-NEXT:    pand %xmm6, %xmm2
; SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSSE3-NEXT:    por %xmm2, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSSE3-NEXT:    por %xmm1, %xmm5
; SSSE3-NEXT:    pshufb %xmm2, %xmm5
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; SSSE3-NEXT:    psubusw %xmm5, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: psubus_8i32_max:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; SSE41-NEXT:    pminud %xmm3, %xmm2
; SSE41-NEXT:    pminud %xmm3, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    psubusw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: psubus_8i32_max:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpminud %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_8i32_max:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_8i32_max:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovusdw %ymm1, %xmm1
; AVX512-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ult <8 x i32> %lhs, %y
  %max = select <8 x i1> %cond, <8 x i32> %y, <8 x i32> %lhs
  %sub = sub <8 x i32> %max, %y
  %res = trunc <8 x i32> %sub to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i16> @psubus_8i64_max(<8 x i16> %x, <8 x i64> %y) nounwind {
; SSE2OR3-LABEL: psubus_8i64_max:
; SSE2OR3:       # %bb.0: # %vector.ph
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm5 = [9223372039002259456,9223372039002259456]
; SSE2OR3-NEXT:    movdqa %xmm2, %xmm7
; SSE2OR3-NEXT:    pxor %xmm5, %xmm7
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm8 = [9223372039002324991,9223372039002324991]
; SSE2OR3-NEXT:    movdqa %xmm8, %xmm6
; SSE2OR3-NEXT:    pcmpgtd %xmm7, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm9 = xmm6[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm8, %xmm7
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm9, %xmm7
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm7, %xmm6
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535]
; SSE2OR3-NEXT:    pand %xmm6, %xmm2
; SSE2OR3-NEXT:    pandn %xmm9, %xmm6
; SSE2OR3-NEXT:    por %xmm2, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[0,2,2,3]
; SSE2OR3-NEXT:    pshuflw {{.*#+}} xmm10 = xmm2[0,2,2,3,4,5,6,7]
; SSE2OR3-NEXT:    movdqa %xmm1, %xmm6
; SSE2OR3-NEXT:    pxor %xmm5, %xmm6
; SSE2OR3-NEXT:    movdqa %xmm8, %xmm7
; SSE2OR3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm8, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm2, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm7[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm6, %xmm2
; SSE2OR3-NEXT:    pand %xmm2, %xmm1
; SSE2OR3-NEXT:    pandn %xmm9, %xmm2
; SSE2OR3-NEXT:    por %xmm1, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,2,2,3]
; SSE2OR3-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE2OR3-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm10[0],xmm1[1],xmm10[1]
; SSE2OR3-NEXT:    movdqa %xmm4, %xmm2
; SSE2OR3-NEXT:    pxor %xmm5, %xmm2
; SSE2OR3-NEXT:    movdqa %xmm8, %xmm6
; SSE2OR3-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm8, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm7, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm2, %xmm6
; SSE2OR3-NEXT:    pand %xmm6, %xmm4
; SSE2OR3-NEXT:    pandn %xmm9, %xmm6
; SSE2OR3-NEXT:    por %xmm4, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[0,2,2,3]
; SSE2OR3-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,0,2,4,5,6,7]
; SSE2OR3-NEXT:    pxor %xmm3, %xmm5
; SSE2OR3-NEXT:    movdqa %xmm8, %xmm4
; SSE2OR3-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm8, %xmm5
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm6, %xmm5
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm5, %xmm4
; SSE2OR3-NEXT:    pand %xmm4, %xmm3
; SSE2OR3-NEXT:    pandn %xmm9, %xmm4
; SSE2OR3-NEXT:    por %xmm3, %xmm4
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,2,2,3]
; SSE2OR3-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,0,2,4,5,6,7]
; SSE2OR3-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE2OR3-NEXT:    movsd {{.*#+}} xmm3 = xmm1[0],xmm3[1]
; SSE2OR3-NEXT:    psubusw %xmm3, %xmm0
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: psubus_8i64_max:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movdqa %xmm0, %xmm8
; SSE41-NEXT:    movdqa {{.*#+}} xmm9 = [9223372039002259456,9223372039002259456]
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = [9223372039002324991,9223372039002324991]
; SSE41-NEXT:    movdqa %xmm5, %xmm7
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm7
; SSE41-NEXT:    movdqa %xmm5, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    movapd {{.*#+}} xmm6 = [65535,65535]
; SSE41-NEXT:    movapd %xmm6, %xmm10
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm10
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa %xmm5, %xmm4
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE41-NEXT:    movdqa %xmm5, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm6, %xmm4
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm4
; SSE41-NEXT:    packusdw %xmm10, %xmm4
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa %xmm5, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm5, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd %xmm6, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm3
; SSE41-NEXT:    pxor %xmm1, %xmm9
; SSE41-NEXT:    movdqa %xmm5, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm2
; SSE41-NEXT:    pcmpgtd %xmm9, %xmm5
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm6
; SSE41-NEXT:    packusdw %xmm3, %xmm6
; SSE41-NEXT:    packusdw %xmm4, %xmm6
; SSE41-NEXT:    psubusw %xmm6, %xmm8
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: psubus_8i64_max:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [9223372036854841343,9223372036854841343]
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vmovapd {{.*#+}} xmm7 = [65535,65535]
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm7, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vblendvpd %xmm4, %xmm1, %xmm7, %xmm1
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_8i64_max:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372036854841343,9223372036854841343,9223372036854841343,9223372036854841343]
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [65535,65535,65535,65535]
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm1, %ymm6, %ymm1
; AVX2-NEXT:    vpackusdw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_8i64_max:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovusqw %zmm1, %xmm1
; AVX512-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i64>
  %cond = icmp ult <8 x i64> %lhs, %y
  %max = select <8 x i1> %cond, <8 x i64> %y, <8 x i64> %lhs
  %sub = sub <8 x i64> %max, %y
  %res = trunc <8 x i64> %sub to <8 x i16>
  ret <8 x i16> %res
}

define <16 x i16> @psubus_16i32_max(<16 x i16> %x, <16 x i32> %y) nounwind {
; SSE2OR3-LABEL: psubus_16i32_max:
; SSE2OR3:       # %bb.0: # %vector.ph
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm9 = [2147483648,2147483648,2147483648,2147483648]
; SSE2OR3-NEXT:    movdqa %xmm3, %xmm8
; SSE2OR3-NEXT:    pxor %xmm9, %xmm8
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm10 = [2147549183,2147549183,2147549183,2147549183]
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm6
; SSE2OR3-NEXT:    pcmpgtd %xmm8, %xmm6
; SSE2OR3-NEXT:    pcmpeqd %xmm8, %xmm8
; SSE2OR3-NEXT:    pand %xmm6, %xmm3
; SSE2OR3-NEXT:    pxor %xmm8, %xmm6
; SSE2OR3-NEXT:    por %xmm3, %xmm6
; SSE2OR3-NEXT:    pslld $16, %xmm6
; SSE2OR3-NEXT:    psrad $16, %xmm6
; SSE2OR3-NEXT:    movdqa %xmm2, %xmm3
; SSE2OR3-NEXT:    pxor %xmm9, %xmm3
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm7
; SSE2OR3-NEXT:    pcmpgtd %xmm3, %xmm7
; SSE2OR3-NEXT:    pand %xmm7, %xmm2
; SSE2OR3-NEXT:    pxor %xmm8, %xmm7
; SSE2OR3-NEXT:    por %xmm2, %xmm7
; SSE2OR3-NEXT:    pslld $16, %xmm7
; SSE2OR3-NEXT:    psrad $16, %xmm7
; SSE2OR3-NEXT:    packssdw %xmm6, %xmm7
; SSE2OR3-NEXT:    psubusw %xmm7, %xmm0
; SSE2OR3-NEXT:    movdqa %xmm5, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm2
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm3
; SSE2OR3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2OR3-NEXT:    pand %xmm3, %xmm5
; SSE2OR3-NEXT:    pxor %xmm8, %xmm3
; SSE2OR3-NEXT:    por %xmm5, %xmm3
; SSE2OR3-NEXT:    pslld $16, %xmm3
; SSE2OR3-NEXT:    psrad $16, %xmm3
; SSE2OR3-NEXT:    pxor %xmm4, %xmm9
; SSE2OR3-NEXT:    pcmpgtd %xmm9, %xmm10
; SSE2OR3-NEXT:    pxor %xmm10, %xmm8
; SSE2OR3-NEXT:    pand %xmm4, %xmm10
; SSE2OR3-NEXT:    por %xmm8, %xmm10
; SSE2OR3-NEXT:    pslld $16, %xmm10
; SSE2OR3-NEXT:    psrad $16, %xmm10
; SSE2OR3-NEXT:    packssdw %xmm3, %xmm10
; SSE2OR3-NEXT:    psubusw %xmm10, %xmm1
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: psubus_16i32_max:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,65535,65535]
; SSE41-NEXT:    pminud %xmm6, %xmm3
; SSE41-NEXT:    pminud %xmm6, %xmm2
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    psubusw %xmm2, %xmm0
; SSE41-NEXT:    pminud %xmm6, %xmm5
; SSE41-NEXT:    pminud %xmm6, %xmm4
; SSE41-NEXT:    packusdw %xmm5, %xmm4
; SSE41-NEXT:    psubusw %xmm4, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: psubus_16i32_max:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpminud %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubusw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpminud %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpminud %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_16i32_max:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpminud %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpackusdw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_16i32_max:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovusdw %zmm1, %ymm1
; AVX512-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
vector.ph:
  %lhs = zext <16 x i16> %x to <16 x i32>
  %cond = icmp ult <16 x i32> %lhs, %y
  %max = select <16 x i1> %cond, <16 x i32> %y, <16 x i32> %lhs
  %sub = sub <16 x i32> %max, %y
  %res = trunc <16 x i32> %sub to <16 x i16>
  ret <16 x i16> %res
}

define <8 x i16> @psubus_i16_i32_max_swapped(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: psubus_i16_i32_max_swapped:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    por %xmm2, %xmm6
; SSE2-NEXT:    pslld $16, %xmm6
; SSE2-NEXT:    psrad $16, %xmm6
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pslld $16, %xmm5
; SSE2-NEXT:    psrad $16, %xmm5
; SSE2-NEXT:    packssdw %xmm6, %xmm5
; SSE2-NEXT:    psubusw %xmm5, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: psubus_i16_i32_max_swapped:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535]
; SSSE3-NEXT:    pand %xmm6, %xmm2
; SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSSE3-NEXT:    por %xmm2, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSSE3-NEXT:    por %xmm1, %xmm5
; SSSE3-NEXT:    pshufb %xmm2, %xmm5
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; SSSE3-NEXT:    psubusw %xmm5, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: psubus_i16_i32_max_swapped:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; SSE41-NEXT:    pminud %xmm3, %xmm2
; SSE41-NEXT:    pminud %xmm3, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    psubusw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: psubus_i16_i32_max_swapped:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpminud %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_i16_i32_max_swapped:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_i16_i32_max_swapped:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovusdw %ymm1, %xmm1
; AVX512-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ult <8 x i32> %y, %lhs
  %max = select <8 x i1> %cond, <8 x i32> %lhs, <8 x i32> %y
  %sub = sub <8 x i32> %max, %y
  %res = trunc <8 x i32> %sub to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i16> @psubus_i16_i32_min(<8 x i16> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: psubus_i16_i32_min:
; SSE2:       # %bb.0: # %vector.ph
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    por %xmm2, %xmm6
; SSE2-NEXT:    pslld $16, %xmm6
; SSE2-NEXT:    psrad $16, %xmm6
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pslld $16, %xmm5
; SSE2-NEXT:    psrad $16, %xmm5
; SSE2-NEXT:    packssdw %xmm6, %xmm5
; SSE2-NEXT:    psubusw %xmm5, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: psubus_i16_i32_min:
; SSSE3:       # %bb.0: # %vector.ph
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535]
; SSSE3-NEXT:    pand %xmm6, %xmm2
; SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSSE3-NEXT:    por %xmm2, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSSE3-NEXT:    por %xmm1, %xmm5
; SSSE3-NEXT:    pshufb %xmm2, %xmm5
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; SSSE3-NEXT:    psubusw %xmm5, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: psubus_i16_i32_min:
; SSE41:       # %bb.0: # %vector.ph
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; SSE41-NEXT:    pminud %xmm3, %xmm2
; SSE41-NEXT:    pminud %xmm3, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    psubusw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: psubus_i16_i32_min:
; AVX1:       # %bb.0: # %vector.ph
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpminud %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: psubus_i16_i32_min:
; AVX2:       # %bb.0: # %vector.ph
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: psubus_i16_i32_min:
; AVX512:       # %bb.0: # %vector.ph
; AVX512-NEXT:    vpmovusdw %ymm1, %xmm1
; AVX512-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
vector.ph:
  %lhs = zext <8 x i16> %x to <8 x i32>
  %cond = icmp ult <8 x i32> %lhs, %y
  %min = select <8 x i1> %cond, <8 x i32> %lhs, <8 x i32> %y
  %sub = sub <8 x i32> %lhs, %min
  %res = trunc <8 x i32> %sub to <8 x i16>
  ret <8 x i16> %res
}

define void @subus_v8i8(<8 x i8>* %p1, <8 x i8>* %p2) {
; SSE-LABEL: subus_v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    psubusb %xmm1, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: subus_v8i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
  %ld1 = load <8 x i8>, <8 x i8>* %p1, align 8
  %ld2 = load <8 x i8>, <8 x i8>* %p2, align 8
  %1 = sub <8 x i8> %ld1, %ld2
  %2 = icmp ugt <8 x i8> %ld1, %ld2
  %sh3 = select <8 x i1> %2, <8 x i8> %1, <8 x i8> zeroinitializer
  store <8 x i8> %sh3, <8 x i8>* %p1, align 8
  ret void
}

define void @subus_v4i8(<4 x i8>* %p1, <4 x i8>* %p2) {
; SSE-LABEL: subus_v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    psubusb %xmm1, %xmm0
; SSE-NEXT:    movd %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: subus_v4i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, (%rdi)
; AVX-NEXT:    retq
  %ld1 = load <4 x i8>, <4 x i8>* %p1, align 8
  %ld2 = load <4 x i8>, <4 x i8>* %p2, align 8
  %1 = sub <4 x i8> %ld1, %ld2
  %2 = icmp ugt <4 x i8> %ld1, %ld2
  %sh3 = select <4 x i1> %2, <4 x i8> %1, <4 x i8> zeroinitializer
  store <4 x i8> %sh3, <4 x i8>* %p1, align 8
  ret void
}

define void @subus_v2i8(<2 x i8>* %p1, <2 x i8>* %p2) {
; SSE2OR3-LABEL: subus_v2i8:
; SSE2OR3:       # %bb.0:
; SSE2OR3-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2OR3-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE2OR3-NEXT:    psubusb %xmm1, %xmm0
; SSE2OR3-NEXT:    movd %xmm0, %eax
; SSE2OR3-NEXT:    movw %ax, (%rdi)
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: subus_v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE41-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE41-NEXT:    psubusb %xmm1, %xmm0
; SSE41-NEXT:    pextrw $0, %xmm0, (%rdi)
; SSE41-NEXT:    retq
;
; AVX-LABEL: subus_v2i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX-NEXT:    retq
  %ld1 = load <2 x i8>, <2 x i8>* %p1, align 8
  %ld2 = load <2 x i8>, <2 x i8>* %p2, align 8
  %1 = sub <2 x i8> %ld1, %ld2
  %2 = icmp ugt <2 x i8> %ld1, %ld2
  %sh3 = select <2 x i1> %2, <2 x i8> %1, <2 x i8> zeroinitializer
  store <2 x i8> %sh3, <2 x i8>* %p1, align 8
  ret void
}

define void @subus_v4i16(<4 x i16>* %p1, <4 x i16>* %p2) {
; SSE-LABEL: subus_v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    psubusw %xmm1, %xmm0
; SSE-NEXT:    movq %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: subus_v4i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, (%rdi)
; AVX-NEXT:    retq
  %ld1 = load <4 x i16>, <4 x i16>* %p1, align 8
  %ld2 = load <4 x i16>, <4 x i16>* %p2, align 8
  %1 = sub <4 x i16> %ld1, %ld2
  %2 = icmp ugt <4 x i16> %ld1, %ld2
  %sh3 = select <4 x i1> %2, <4 x i16> %1, <4 x i16> zeroinitializer
  store <4 x i16> %sh3, <4 x i16>* %p1, align 8
  ret void
}

define void @subus_v2i16(<2 x i16>* %p1, <2 x i16>* %p2) {
; SSE-LABEL: subus_v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    psubusw %xmm1, %xmm0
; SSE-NEXT:    movd %xmm0, (%rdi)
; SSE-NEXT:    retq
;
; AVX-LABEL: subus_v2i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovd %xmm0, (%rdi)
; AVX-NEXT:    retq
  %ld1 = load <2 x i16>, <2 x i16>* %p1, align 8
  %ld2 = load <2 x i16>, <2 x i16>* %p2, align 8
  %1 = sub <2 x i16> %ld1, %ld2
  %2 = icmp ugt <2 x i16> %ld1, %ld2
  %sh3 = select <2 x i1> %2, <2 x i16> %1, <2 x i16> zeroinitializer
  store <2 x i16> %sh3, <2 x i16>* %p1, align 8
  ret void
}

define <16 x i8> @test19(<16 x i8> %x) {
; SSE-LABEL: test19:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test19:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %0 = icmp ugt <16 x i8> %x, <i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70>
  %1 = select <16 x i1> %0, <16 x i8> %x, <16 x i8> <i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70>
  %2 = add <16 x i8> %1, <i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70>
  ret <16 x i8> %2
}

define <16 x i8> @test20(<16 x i8> %x) {
; SSE-LABEL: test20:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test20:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %0 = icmp ugt <16 x i8> %x, <i8 1, i8 -22, i8 -50, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 100, i8 25, i8 34, i8 55, i8 70>
  %1 = select <16 x i1> %0, <16 x i8> %x, <16 x i8> <i8 1, i8 -22, i8 -50, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 100, i8 25, i8 34, i8 55, i8 70>
  %2 = add <16 x i8> %1, <i8 -1, i8 22, i8 50, i8 114, i8 77, i8 70, i8 -123, i8 -98, i8 -63, i8 -19, i8 22, i8 -100, i8 -25, i8 -34, i8 -55, i8 -70>
  ret <16 x i8> %2
}

define <8 x i16> @test21(<8 x i16> %x) {
; SSE-LABEL: test21:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test21:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %0 = icmp ugt <8 x i16> %x, <i16 700, i16 700, i16 700, i16 700, i16 700, i16 700, i16 700, i16 700>
  %1 = select <8 x i1> %0, <8 x i16> %x, <8 x i16> <i16 700, i16 700, i16 700, i16 700, i16 700, i16 700, i16 700, i16 700>
  %2 = add <8 x i16> %1, <i16 -700, i16 -700, i16 -700, i16 -700, i16 -700, i16 -700, i16 -700, i16 -700>
  ret <8 x i16> %2
}

define <8 x i16> @test22(<8 x i16> %x) {
; SSE-LABEL: test22:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test22:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
entry:
  %0 = icmp ugt <8 x i16> %x, <i16 1, i16 -22000, i16 -770, i16 98, i16 19, i16 1000, i16 3456, i16 70>
  %1 = select <8 x i1> %0, <8 x i16> %x, <8 x i16> <i16 1, i16 -22000, i16 -770, i16 98, i16 19, i16 1000, i16 3456, i16 70>
  %2 = add <8 x i16> %1, <i16 -1, i16 22000, i16 770, i16 -98, i16 -19, i16 -1000, i16 -3456, i16 -70>
  ret <8 x i16> %2
}

define <32 x i8> @test23(<32 x i8> %x) {
; SSE-LABEL: test23:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70]
; SSE-NEXT:    psubusb %xmm2, %xmm0
; SSE-NEXT:    psubusb %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test23:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70]
; AVX1-NEXT:    vpsubusb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test23:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test23:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
entry:
  %0 = icmp ugt <32 x i8> %x, <i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70>
  %1 = select <32 x i1> %0, <32 x i8> %x, <32 x i8> <i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70>
  %2 = add <32 x i8> %1, <i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70, i8 -70>
  ret <32 x i8> %2
}

define <32 x i8> @test24(<32 x i8> %x) {
; SSE-LABEL: test24:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test24:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test24:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test24:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
entry:
  %0 = icmp ugt <32 x i8> %x, <i8 1, i8 -22, i8 -50, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 100, i8 25, i8 34, i8 55, i8 70, i8 2, i8 -23, i8 -49, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 110, i8 25, i8 34, i8 55, i8 70>
  %1 = select <32 x i1> %0, <32 x i8> %x, <32 x i8> <i8 1, i8 -22, i8 -50, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 100, i8 25, i8 34, i8 55, i8 70, i8 2, i8 -23, i8 -49, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 110, i8 25, i8 34, i8 55, i8 70>
  %2 = add <32 x i8> %1, <i8 -1, i8 22, i8 50, i8 114, i8 77, i8 70, i8 -123, i8 -98, i8 -63, i8 -19, i8 22, i8 -100, i8 -25, i8 -34, i8 -55, i8 -70, i8 -2, i8 23, i8 49, i8 114, i8 77, i8 70, i8 -123, i8 -98, i8 -63, i8 -19, i8 22, i8 -110, i8 -25, i8 -34, i8 -55, i8 -70>
  ret <32 x i8> %2
}

define <16 x i16> @test25(<16 x i16> %x) {
; SSE-LABEL: test25:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [5000,5000,5000,5000,5000,5000,5000,5000]
; SSE-NEXT:    psubusw %xmm2, %xmm0
; SSE-NEXT:    psubusw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test25:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [5000,5000,5000,5000,5000,5000,5000,5000]
; AVX1-NEXT:    vpsubusw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test25:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test25:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
entry:
  %0 = icmp ugt <16 x i16> %x, <i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000>
  %1 = select <16 x i1> %0, <16 x i16> %x, <16 x i16> <i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000, i16 5000>
  %2 = add <16 x i16> %1, <i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000, i16 -5000>
  ret <16 x i16> %2
}

define <16 x i16> @test26(<16 x i16> %x) {
; SSE-LABEL: test26:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test26:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test26:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test26:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX512-NEXT:    retq
entry:
  %0 = icmp ugt <16 x i16> %x, <i16 1, i16 -2200, i16 -50, i16 -114, i16 -77, i16 -70, i16 123, i16 9800, i16 635, i16 19567, i16 -22, i16 100, i16 2534, i16 34, i16 55, i16 70>
  %1 = select <16 x i1> %0, <16 x i16> %x, <16 x i16> <i16 1, i16 -2200, i16 -50, i16 -114, i16 -77, i16 -70, i16 123, i16 9800, i16 635, i16 19567, i16 -22, i16 100, i16 2534, i16 34, i16 55, i16 70>
  %2 = add <16 x i16> %1, <i16 -1, i16 2200, i16 50, i16 114, i16 77, i16 70, i16 -123, i16 -9800, i16 -635, i16 -19567, i16 22, i16 -100, i16 -2534, i16 -34, i16 -55, i16 -70>
  ret <16 x i16> %2
}

define <64 x i8> @test27(<64 x i8> %x) {
; SSE-LABEL: test27:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154]
; SSE-NEXT:    psubusb %xmm4, %xmm0
; SSE-NEXT:    psubusb %xmm4, %xmm1
; SSE-NEXT:    psubusb %xmm4, %xmm2
; SSE-NEXT:    psubusb %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test27:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154]
; AVX1-NEXT:    vpsubusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsubusb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpsubusb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsubusb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test27:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154,154]
; AVX2-NEXT:    vpsubusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubusb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test27:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
entry:
  %0 = icmp ugt <64 x i8> %x, <i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154>
  %1 = select <64 x i1> %0, <64 x i8> %x, <64 x i8> <i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154, i8 154>
  %2 = add <64 x i8> %1, <i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154, i8 -154>
  ret <64 x i8> %2
}

define <64 x i8> @test28(<64 x i8> %x) {
; SSE-LABEL: test28:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [1,234,206,142,179,186,123,98,63,19,234,100,25,34,55,70]
; SSE-NEXT:    psubusb %xmm4, %xmm0
; SSE-NEXT:    psubusb %xmm4, %xmm2
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test28:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [1,234,206,142,179,186,123,98,63,19,234,100,25,34,55,70]
; AVX1-NEXT:    vpsubusb %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-NEXT:    vpsubusb %xmm2, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test28:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test28:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
entry:
  %0 = icmp ugt <64 x i8> %x, <i8 1, i8 -22, i8 -50, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 100, i8 25, i8 34, i8 55, i8 70, i8 2, i8 -23, i8 -49, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 110, i8 25, i8 34, i8 55, i8 70, i8 1, i8 -22, i8 -50, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 100, i8 25, i8 34, i8 55, i8 70, i8 2, i8 -23, i8 -49, i8 -116, i8 -77, i8 -70, i8 123, i8 98, i8 67, i8 19, i8 -22, i8 110, i8 25, i8 34, i8 55, i8 70>
  %1 = select <64 x i1> %0, <64 x i8> %x, <64 x i8> <i8 1, i8 -22, i8 -50, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 100, i8 25, i8 34, i8 55, i8 70, i8 2, i8 -23, i8 -49, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 110, i8 25, i8 34, i8 55, i8 70, i8 1, i8 -22, i8 -50, i8 -114, i8 -77, i8 -70, i8 123, i8 98, i8 63, i8 19, i8 -22, i8 100, i8 25, i8 34, i8 55, i8 70, i8 2, i8 -23, i8 -49, i8 -116, i8 -77, i8 -70, i8 123, i8 98, i8 67, i8 19, i8 -22, i8 110, i8 25, i8 34, i8 55, i8 70>
  %2 = add <64 x i8> %1, <i8 -1, i8 22, i8 50, i8 114, i8 77, i8 70, i8 -123, i8 -98, i8 -63, i8 -19, i8 22, i8 -100, i8 -25, i8 -34, i8 -55, i8 -70, i8 -2, i8 23, i8 49, i8 114, i8 77, i8 70, i8 -123, i8 -98, i8 -63, i8 -19, i8 22, i8 -110, i8 -25, i8 -34, i8 -55, i8 -70, i8 -1, i8 22, i8 50, i8 114, i8 77, i8 70, i8 -123, i8 -98, i8 -63, i8 -19, i8 22, i8 -100, i8 -25, i8 -34, i8 -55, i8 -70, i8 -2, i8 23, i8 49, i8 116, i8 77, i8 70, i8 -123, i8 -98, i8 -67, i8 -19, i8 22, i8 -110, i8 -25, i8 -34, i8 -55, i8 -70>
  ret <64 x i8> %2
}

define <32 x i16> @test29(<32 x i16> %x) {
; SSE-LABEL: test29:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm2
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test29:
; AVX1:       # %bb.0: # %entry
; AVX1-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test29:
; AVX2:       # %bb.0: # %entry
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test29:
; AVX512:       # %bb.0: # %entry
; AVX512-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
entry:
  %0 = icmp ugt <32 x i16> %x, <i16 1, i16 -2200, i16 -50, i16 -114, i16 -77, i16 -70, i16 123, i16 9800, i16 635, i16 19567, i16 -22, i16 100, i16 2534, i16 34, i16 55, i16 70, i16 1, i16 -2200, i16 -50, i16 -114, i16 -77, i16 -70, i16 123, i16 9805, i16 635, i16 19567, i16 -22, i16 100, i16 2534, i16 346, i16 55, i16 70>
  %1 = select <32 x i1> %0, <32 x i16> %x, <32 x i16> <i16 1, i16 -2200, i16 -50, i16 -114, i16 -77, i16 -70, i16 123, i16 9800, i16 635, i16 19567, i16 -22, i16 100, i16 2534, i16 34, i16 55, i16 70, i16 1, i16 -2200, i16 -50, i16 -114, i16 -77, i16 -70, i16 123, i16 9805, i16 635, i16 19567, i16 -22, i16 100, i16 2534, i16 346, i16 55, i16 70>
  %2 = add <32 x i16> %1, <i16 -1, i16 2200, i16 50, i16 114, i16 77, i16 70, i16 -123, i16 -9800, i16 -635, i16 -19567, i16 22, i16 -100, i16 -2534, i16 -34, i16 -55, i16 -70, i16 -1, i16 2200, i16 50, i16 114, i16 77, i16 70, i16 -123, i16 -9805, i16 -635, i16 -19567, i16 22, i16 -100, i16 -2534, i16 -346, i16 -55, i16 -70>
  ret <32 x i16> %2
}

; PR40083
define i64 @test30(<8 x i16> %x) {
; SSE-LABEL: test30:
; SSE:       # %bb.0: # %entry
; SSE-NEXT:    psubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    retq
;
; AVX-LABEL: test30:
; AVX:       # %bb.0: # %entry
; AVX-NEXT:    vpsubusw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, %rax
; AVX-NEXT:    retq
entry:
  %0 = icmp ugt <8 x i16> %x, <i16 1, i16 -2200, i16 -50, i16 -114, i16 undef, i16 undef, i16 undef, i16 undef>
  %1 = select <8 x i1> %0, <8 x i16> %x, <8 x i16> <i16 1, i16 -2200, i16 -50, i16 -114, i16 undef, i16 undef, i16 undef, i16 undef>
  %2 = add <8 x i16> %1, <i16 -1, i16 2200, i16 50, i16 114, i16 undef, i16 undef, i16 undef, i16 undef>
  %3 = bitcast <8 x i16> %2 to <2 x i64>
  %4 = extractelement <2 x i64> %3, i32 0
  ret i64 %4
}

; PR40083
define i64 @test31(<2 x i64> %x) {
; SSE-LABEL: test31:
; SSE:       # %bb.0:
; SSE-NEXT:    psubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    movq %xmm0, %rax
; SSE-NEXT:    retq
;
; AVX-LABEL: test31:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubusb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm0, %rax
; AVX-NEXT:    retq
  %t0 = bitcast <2 x i64> %x to <16 x i8>
  %cmp = icmp ugt <16 x i8> %t0, <i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 70, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef>
  %bop = add <16 x i8> %t0, <i8 -71, i8 -71, i8 -71, i8 -71, i8 -71, i8 -71, i8 -71, i8 -71, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef, i8 undef>
  %sel = select <16 x i1> %cmp, <16 x i8> %bop, <16 x i8> zeroinitializer
  %bc = bitcast <16 x i8> %sel to <2 x i64>
  %ext = extractelement <2 x i64> %bc, i32 0
  ret i64 %ext
}

; v8i16/v8i32 - sub(x,trunc(umin(zext(x),y)))
define <8 x i16> @test32(<8 x i16> %a0, <8 x i32> %a1) {
; SSE2-LABEL: test32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm6
; SSE2-NEXT:    por %xmm2, %xmm6
; SSE2-NEXT:    pslld $16, %xmm6
; SSE2-NEXT:    psrad $16, %xmm6
; SSE2-NEXT:    pxor %xmm1, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm1, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    pslld $16, %xmm5
; SSE2-NEXT:    psrad $16, %xmm5
; SSE2-NEXT:    packssdw %xmm6, %xmm5
; SSE2-NEXT:    psubusw %xmm5, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: test32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    movdqa %xmm2, %xmm4
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    movdqa {{.*#+}} xmm5 = [2147549183,2147549183,2147549183,2147549183]
; SSSE3-NEXT:    movdqa %xmm5, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535]
; SSSE3-NEXT:    pand %xmm6, %xmm2
; SSSE3-NEXT:    pandn %xmm4, %xmm6
; SSSE3-NEXT:    por %xmm2, %xmm6
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; SSSE3-NEXT:    pshufb %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm1, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm3, %xmm5
; SSSE3-NEXT:    pand %xmm5, %xmm1
; SSSE3-NEXT:    pandn %xmm4, %xmm5
; SSSE3-NEXT:    por %xmm1, %xmm5
; SSSE3-NEXT:    pshufb %xmm2, %xmm5
; SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; SSSE3-NEXT:    psubusw %xmm5, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: test32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; SSE41-NEXT:    pminud %xmm3, %xmm2
; SSE41-NEXT:    pminud %xmm3, %xmm1
; SSE41-NEXT:    packusdw %xmm2, %xmm1
; SSE41-NEXT:    psubusw %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpminud %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovusdw %ymm1, %xmm1
; AVX512-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %zext = zext <8 x i16> %a0 to <8 x i32>
  %icmp = icmp ult <8 x i32> %zext, %a1
  %umin = select <8 x i1> %icmp, <8 x i32> %zext, <8 x i32> %a1
  %trunc = trunc <8 x i32> %umin to <8 x i16>
  %sub = sub <8 x i16> %a0, %trunc
  ret <8 x i16> %sub
}

; v8i32/v8i64 - sub(x,trunc(umin(y,zext(x))))
define <8 x i32> @test33(<8 x i32> %a0, <8 x i64> %a1) {
; SSE2OR3-LABEL: test33:
; SSE2OR3:       # %bb.0:
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm9 = [9223372039002259456,9223372039002259456]
; SSE2OR3-NEXT:    movdqa %xmm3, %xmm6
; SSE2OR3-NEXT:    pxor %xmm9, %xmm6
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm10 = [9223372039002259455,9223372039002259455]
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm7
; SSE2OR3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm10, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm8, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm6, %xmm7
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm8 = [4294967295,4294967295]
; SSE2OR3-NEXT:    pand %xmm7, %xmm3
; SSE2OR3-NEXT:    pandn %xmm8, %xmm7
; SSE2OR3-NEXT:    por %xmm3, %xmm7
; SSE2OR3-NEXT:    movdqa %xmm2, %xmm3
; SSE2OR3-NEXT:    pxor %xmm9, %xmm3
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm6
; SSE2OR3-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm11 = xmm6[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm10, %xmm3
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm11, %xmm3
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm3, %xmm6
; SSE2OR3-NEXT:    pand %xmm6, %xmm2
; SSE2OR3-NEXT:    pandn %xmm8, %xmm6
; SSE2OR3-NEXT:    por %xmm2, %xmm6
; SSE2OR3-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,2],xmm7[0,2]
; SSE2OR3-NEXT:    movdqa %xmm0, %xmm2
; SSE2OR3-NEXT:    psubd %xmm6, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm6
; SSE2OR3-NEXT:    pxor %xmm9, %xmm0
; SSE2OR3-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE2OR3-NEXT:    pand %xmm2, %xmm0
; SSE2OR3-NEXT:    movdqa %xmm5, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm2
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm3
; SSE2OR3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm6, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm2, %xmm3
; SSE2OR3-NEXT:    pand %xmm3, %xmm5
; SSE2OR3-NEXT:    pandn %xmm8, %xmm3
; SSE2OR3-NEXT:    por %xmm5, %xmm3
; SSE2OR3-NEXT:    movdqa %xmm4, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm2
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm5
; SSE2OR3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm6, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm2, %xmm5
; SSE2OR3-NEXT:    pand %xmm5, %xmm4
; SSE2OR3-NEXT:    pandn %xmm8, %xmm5
; SSE2OR3-NEXT:    por %xmm4, %xmm5
; SSE2OR3-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm3[0,2]
; SSE2OR3-NEXT:    movdqa %xmm1, %xmm2
; SSE2OR3-NEXT:    psubd %xmm5, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm5
; SSE2OR3-NEXT:    pxor %xmm9, %xmm1
; SSE2OR3-NEXT:    pcmpgtd %xmm5, %xmm1
; SSE2OR3-NEXT:    pand %xmm2, %xmm1
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: test33:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm8
; SSE41-NEXT:    movdqa {{.*#+}} xmm9 = [9223372039002259456,9223372039002259456]
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm11 = [9223372039002259455,9223372039002259455]
; SSE41-NEXT:    movdqa %xmm11, %xmm10
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm10
; SSE41-NEXT:    movdqa %xmm11, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm10, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd {{.*#+}} xmm7 = [4294967295,4294967295]
; SSE41-NEXT:    movapd %xmm7, %xmm10
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm10
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa %xmm11, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm11, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm3
; SSE41-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm10[0,2]
; SSE41-NEXT:    pmaxud %xmm3, %xmm8
; SSE41-NEXT:    psubd %xmm3, %xmm8
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa %xmm11, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE41-NEXT:    movdqa %xmm11, %xmm3
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm9
; SSE41-NEXT:    movdqa %xmm11, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm3
; SSE41-NEXT:    pcmpgtd %xmm9, %xmm11
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm11, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm7
; SSE41-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm2[0,2]
; SSE41-NEXT:    pmaxud %xmm7, %xmm1
; SSE41-NEXT:    psubd %xmm7, %xmm1
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test33:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [9223372041149743103,9223372041149743103]
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vmovapd {{.*#+}} xmm7 = [4294967295,4294967295]
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm7, %xmm2
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpmaxud %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpsubd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vblendvpd %xmm4, %xmm1, %xmm7, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm3[0,2]
; AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: test33:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-SLOW-NEXT:    vpxor %ymm3, %ymm2, %ymm4
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372041149743103,9223372041149743103,9223372041149743103,9223372041149743103]
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-SLOW-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-SLOW-NEXT:    vpxor %ymm3, %ymm1, %ymm3
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm3, %ymm5, %ymm3
; AVX2-SLOW-NEXT:    vblendvpd %ymm3, %ymm1, %ymm6, %ymm1
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm1[2,3],ymm2[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2],ymm3[0,2],ymm1[4,6],ymm3[4,6]
; AVX2-SLOW-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: test33:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-FAST-ALL-NEXT:    vpxor %ymm3, %ymm1, %ymm4
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372041149743103,9223372041149743103,9223372041149743103,9223372041149743103]
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-FAST-ALL-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm4, %ymm1, %ymm6, %ymm1
; AVX2-FAST-ALL-NEXT:    vmovapd {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm4, %ymm1
; AVX2-FAST-ALL-NEXT:    vpxor %ymm3, %ymm2, %ymm3
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm3, %ymm5, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm3, %ymm2, %ymm6, %ymm2
; AVX2-FAST-ALL-NEXT:    vpermps %ymm2, %ymm4, %ymm2
; AVX2-FAST-ALL-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-FAST-ALL-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX2-FAST-ALL-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: test33:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-FAST-PERLANE-NEXT:    vpxor %ymm3, %ymm2, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372041149743103,9223372041149743103,9223372041149743103,9223372041149743103]
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpxor %ymm3, %ymm1, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm3, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm3, %ymm1, %ymm6, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm1[2,3],ymm2[2,3]
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2],ymm3[0,2],ymm1[4,6],ymm3[4,6]
; AVX2-FAST-PERLANE-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: test33:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovusqd %zmm1, %ymm1
; AVX512-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %zext = zext <8 x i32> %a0 to <8 x i64>
  %icmp = icmp ult <8 x i64> %a1, %zext
  %umin = select <8 x i1> %icmp, <8 x i64> %a1, <8 x i64> %zext
  %trunc = trunc <8 x i64> %umin to <8 x i32>
  %sub = sub <8 x i32> %a0, %trunc
  ret <8 x i32> %sub
}

; v8i32/v8i64 - sub(x,trunc(umin(zext(and(x,1)),y)))
define <8 x i32> @test34(<8 x i32> %a0, <8 x i64> %a1) {
; SSE2OR3-LABEL: test34:
; SSE2OR3:       # %bb.0:
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm6 = [1,1,1,1]
; SSE2OR3-NEXT:    pand %xmm6, %xmm1
; SSE2OR3-NEXT:    pand %xmm6, %xmm0
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm9 = [9223372039002259456,9223372039002259456]
; SSE2OR3-NEXT:    movdqa %xmm3, %xmm6
; SSE2OR3-NEXT:    pxor %xmm9, %xmm6
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm10 = [9223372039002259455,9223372039002259455]
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm7
; SSE2OR3-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm10, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm8, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm6, %xmm7
; SSE2OR3-NEXT:    movdqa {{.*#+}} xmm8 = [4294967295,4294967295]
; SSE2OR3-NEXT:    pand %xmm7, %xmm3
; SSE2OR3-NEXT:    pandn %xmm8, %xmm7
; SSE2OR3-NEXT:    por %xmm3, %xmm7
; SSE2OR3-NEXT:    movdqa %xmm2, %xmm3
; SSE2OR3-NEXT:    pxor %xmm9, %xmm3
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm6
; SSE2OR3-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm11 = xmm6[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm10, %xmm3
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm11, %xmm3
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm3, %xmm6
; SSE2OR3-NEXT:    pand %xmm6, %xmm2
; SSE2OR3-NEXT:    pandn %xmm8, %xmm6
; SSE2OR3-NEXT:    por %xmm2, %xmm6
; SSE2OR3-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,2],xmm7[0,2]
; SSE2OR3-NEXT:    movdqa %xmm0, %xmm2
; SSE2OR3-NEXT:    psubd %xmm6, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm6
; SSE2OR3-NEXT:    por %xmm9, %xmm0
; SSE2OR3-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE2OR3-NEXT:    pand %xmm2, %xmm0
; SSE2OR3-NEXT:    movdqa %xmm5, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm2
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm3
; SSE2OR3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm3[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm6, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm2, %xmm3
; SSE2OR3-NEXT:    pand %xmm3, %xmm5
; SSE2OR3-NEXT:    pandn %xmm8, %xmm3
; SSE2OR3-NEXT:    por %xmm5, %xmm3
; SSE2OR3-NEXT:    movdqa %xmm4, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm2
; SSE2OR3-NEXT:    movdqa %xmm10, %xmm5
; SSE2OR3-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2OR3-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2OR3-NEXT:    pand %xmm6, %xmm2
; SSE2OR3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2OR3-NEXT:    por %xmm2, %xmm5
; SSE2OR3-NEXT:    pand %xmm5, %xmm4
; SSE2OR3-NEXT:    pandn %xmm8, %xmm5
; SSE2OR3-NEXT:    por %xmm4, %xmm5
; SSE2OR3-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm3[0,2]
; SSE2OR3-NEXT:    movdqa %xmm1, %xmm2
; SSE2OR3-NEXT:    psubd %xmm5, %xmm2
; SSE2OR3-NEXT:    pxor %xmm9, %xmm5
; SSE2OR3-NEXT:    por %xmm9, %xmm1
; SSE2OR3-NEXT:    pcmpgtd %xmm5, %xmm1
; SSE2OR3-NEXT:    pand %xmm2, %xmm1
; SSE2OR3-NEXT:    retq
;
; SSE41-LABEL: test34:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm8
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [1,1,1,1]
; SSE41-NEXT:    pand %xmm0, %xmm1
; SSE41-NEXT:    pand %xmm0, %xmm8
; SSE41-NEXT:    movdqa {{.*#+}} xmm9 = [9223372039002259456,9223372039002259456]
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm11 = [9223372039002259455,9223372039002259455]
; SSE41-NEXT:    movdqa %xmm11, %xmm10
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm10
; SSE41-NEXT:    movdqa %xmm11, %xmm7
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[0,0,2,2]
; SSE41-NEXT:    pand %xmm10, %xmm0
; SSE41-NEXT:    por %xmm7, %xmm0
; SSE41-NEXT:    movapd {{.*#+}} xmm7 = [4294967295,4294967295]
; SSE41-NEXT:    movapd %xmm7, %xmm10
; SSE41-NEXT:    blendvpd %xmm0, %xmm3, %xmm10
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa %xmm11, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE41-NEXT:    movdqa %xmm11, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm3
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm3
; SSE41-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm10[0,2]
; SSE41-NEXT:    pmaxud %xmm3, %xmm8
; SSE41-NEXT:    psubd %xmm3, %xmm8
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pxor %xmm9, %xmm0
; SSE41-NEXT:    movdqa %xmm11, %xmm2
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE41-NEXT:    movdqa %xmm11, %xmm3
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,0,2,2]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    movapd %xmm7, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm9
; SSE41-NEXT:    movdqa %xmm11, %xmm3
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm3
; SSE41-NEXT:    pcmpgtd %xmm9, %xmm11
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[0,0,2,2]
; SSE41-NEXT:    pand %xmm3, %xmm0
; SSE41-NEXT:    por %xmm11, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm4, %xmm7
; SSE41-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm2[0,2]
; SSE41-NEXT:    pmaxud %xmm7, %xmm1
; SSE41-NEXT:    psubd %xmm7, %xmm1
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test34:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [9223372041149743103,9223372041149743103]
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vmovapd {{.*#+}} xmm7 = [4294967295,4294967295]
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm2, %xmm7, %xmm2
; AVX1-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpmaxud %xmm2, %xmm3, %xmm3
; AVX1-NEXT:    vpsubd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm3, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vblendvpd %xmm5, %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vblendvpd %xmm4, %xmm1, %xmm7, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm3[0,2]
; AVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: test34:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1]
; AVX2-SLOW-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-SLOW-NEXT:    vpxor %ymm3, %ymm2, %ymm4
; AVX2-SLOW-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372041149743103,9223372041149743103,9223372041149743103,9223372041149743103]
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-SLOW-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-SLOW-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-SLOW-NEXT:    vpxor %ymm3, %ymm1, %ymm3
; AVX2-SLOW-NEXT:    vpcmpgtq %ymm3, %ymm5, %ymm3
; AVX2-SLOW-NEXT:    vblendvpd %ymm3, %ymm1, %ymm6, %ymm1
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm1[2,3],ymm2[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2],ymm3[0,2],ymm1[4,6],ymm3[4,6]
; AVX2-SLOW-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-ALL-LABEL: test34:
; AVX2-FAST-ALL:       # %bb.0:
; AVX2-FAST-ALL-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1]
; AVX2-FAST-ALL-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-FAST-ALL-NEXT:    vpxor %ymm3, %ymm1, %ymm4
; AVX2-FAST-ALL-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372041149743103,9223372041149743103,9223372041149743103,9223372041149743103]
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-FAST-ALL-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm4, %ymm1, %ymm6, %ymm1
; AVX2-FAST-ALL-NEXT:    vmovapd {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-ALL-NEXT:    vpermps %ymm1, %ymm4, %ymm1
; AVX2-FAST-ALL-NEXT:    vpxor %ymm3, %ymm2, %ymm3
; AVX2-FAST-ALL-NEXT:    vpcmpgtq %ymm3, %ymm5, %ymm3
; AVX2-FAST-ALL-NEXT:    vblendvpd %ymm3, %ymm2, %ymm6, %ymm2
; AVX2-FAST-ALL-NEXT:    vpermps %ymm2, %ymm4, %ymm2
; AVX2-FAST-ALL-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-FAST-ALL-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX2-FAST-ALL-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-FAST-ALL-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: test34:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1]
; AVX2-FAST-PERLANE-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-FAST-PERLANE-NEXT:    vpxor %ymm3, %ymm2, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372041149743103,9223372041149743103,9223372041149743103,9223372041149743103]
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpxor %ymm3, %ymm1, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpcmpgtq %ymm3, %ymm5, %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendvpd %ymm3, %ymm1, %ymm6, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm1[2,3],ymm2[2,3]
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX2-FAST-PERLANE-NEXT:    vshufps {{.*#+}} ymm1 = ymm1[0,2],ymm3[0,2],ymm1[4,6],ymm3[4,6]
; AVX2-FAST-PERLANE-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: test34:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; AVX512-NEXT:    vpmovusqd %zmm1, %ymm1
; AVX512-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %mask = and <8 x i32> %a0, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %zext = zext <8 x i32> %mask to <8 x i64>
  %icmp = icmp ult <8 x i64> %zext, %a1
  %umin = select <8 x i1> %icmp, <8 x i64> %zext, <8 x i64> %a1
  %trunc = trunc <8 x i64> %umin to <8 x i32>
  %sub = sub <8 x i32> %mask, %trunc
  ret <8 x i32> %sub
}
