; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr8 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefix=P8
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-unknown-unknown \
; RUN:   -verify-machineinstrs -ppc-asm-full-reg-names < %s | FileCheck %s
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-unknown-unknown -mattr=-hard-float \
; RUN:   -verify-machineinstrs -ppc-asm-full-reg-names < %s | FileCheck %s \
; RUN:   --check-prefix=SOFT

define dso_local double @loadd(i16* nocapture readonly %a) local_unnamed_addr #0 {
; P8-LABEL: loadd:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr r0
; P8-NEXT:    std r0, 16(r1)
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    lhz r3, 2(r3)
; P8-NEXT:    bl __gnu_h2f_ieee
; P8-NEXT:    nop
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; CHECK-LABEL: loadd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 2
; CHECK-NEXT:    lxsihzx f0, 0, r3
; CHECK-NEXT:    xscvhpdp f1, f0
; CHECK-NEXT:    blr
;
; SOFT-LABEL: loadd:
; SOFT:       # %bb.0: # %entry
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r0, 16(r1)
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    lhz r3, 2(r3)
; SOFT-NEXT:    bl __gnu_h2f_ieee
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __extendsfdf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i16, i16* %a, i64 1
  %0 = load i16, i16* %arrayidx, align 2
  %1 = tail call double @llvm.convert.from.fp16.f64(i16 %0)
  ret double %1
}

declare double @llvm.convert.from.fp16.f64(i16)

define dso_local float @loadf(i16* nocapture readonly %a) local_unnamed_addr #0 {
; P8-LABEL: loadf:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr r0
; P8-NEXT:    std r0, 16(r1)
; P8-NEXT:    stdu r1, -32(r1)
; P8-NEXT:    lhz r3, 2(r3)
; P8-NEXT:    bl __gnu_h2f_ieee
; P8-NEXT:    nop
; P8-NEXT:    addi r1, r1, 32
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; CHECK-LABEL: loadf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi r3, r3, 2
; CHECK-NEXT:    lxsihzx f0, 0, r3
; CHECK-NEXT:    xscvhpdp f1, f0
; CHECK-NEXT:    blr
;
; SOFT-LABEL: loadf:
; SOFT:       # %bb.0: # %entry
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r0, 16(r1)
; SOFT-NEXT:    stdu r1, -32(r1)
; SOFT-NEXT:    lhz r3, 2(r3)
; SOFT-NEXT:    bl __gnu_h2f_ieee
; SOFT-NEXT:    nop
; SOFT-NEXT:    addi r1, r1, 32
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds i16, i16* %a, i64 1
  %0 = load i16, i16* %arrayidx, align 2
  %1 = tail call float @llvm.convert.from.fp16.f32(i16 %0)
  ret float %1
}

declare float @llvm.convert.from.fp16.f32(i16)

define dso_local void @stored(i16* nocapture %a, double %b) local_unnamed_addr #0 {
; P8-LABEL: stored:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; P8-NEXT:    std r0, 16(r1)
; P8-NEXT:    stdu r1, -48(r1)
; P8-NEXT:    mr r30, r3
; P8-NEXT:    bl __truncdfhf2
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 0(r30)
; P8-NEXT:    addi r1, r1, 48
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; CHECK-LABEL: stored:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdphp f0, f1
; CHECK-NEXT:    stxsihx f0, 0, r3
; CHECK-NEXT:    blr
;
; SOFT-LABEL: stored:
; SOFT:       # %bb.0: # %entry
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r0, 16(r1)
; SOFT-NEXT:    stdu r1, -48(r1)
; SOFT-NEXT:    mr r30, r3
; SOFT-NEXT:    mr r3, r4
; SOFT-NEXT:    bl __truncdfhf2
; SOFT-NEXT:    nop
; SOFT-NEXT:    clrldi r3, r3, 48
; SOFT-NEXT:    bl __gnu_h2f_ieee
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __gnu_f2h_ieee
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 0(r30)
; SOFT-NEXT:    addi r1, r1, 48
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
entry:
  %0 = tail call i16 @llvm.convert.to.fp16.f64(double %b)
  store i16 %0, i16* %a, align 2
  ret void
}

declare i16 @llvm.convert.to.fp16.f64(double)

define dso_local void @storef(i16* nocapture %a, float %b) local_unnamed_addr #0 {
; P8-LABEL: storef:
; P8:       # %bb.0: # %entry
; P8-NEXT:    mflr r0
; P8-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; P8-NEXT:    std r0, 16(r1)
; P8-NEXT:    stdu r1, -48(r1)
; P8-NEXT:    mr r30, r3
; P8-NEXT:    bl __gnu_f2h_ieee
; P8-NEXT:    nop
; P8-NEXT:    sth r3, 0(r30)
; P8-NEXT:    addi r1, r1, 48
; P8-NEXT:    ld r0, 16(r1)
; P8-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; P8-NEXT:    mtlr r0
; P8-NEXT:    blr
;
; CHECK-LABEL: storef:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscvdphp f0, f1
; CHECK-NEXT:    stxsihx f0, 0, r3
; CHECK-NEXT:    blr
;
; SOFT-LABEL: storef:
; SOFT:       # %bb.0: # %entry
; SOFT-NEXT:    mflr r0
; SOFT-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; SOFT-NEXT:    std r0, 16(r1)
; SOFT-NEXT:    stdu r1, -48(r1)
; SOFT-NEXT:    mr r30, r3
; SOFT-NEXT:    clrldi r3, r4, 32
; SOFT-NEXT:    bl __gnu_f2h_ieee
; SOFT-NEXT:    nop
; SOFT-NEXT:    clrldi r3, r3, 48
; SOFT-NEXT:    bl __gnu_h2f_ieee
; SOFT-NEXT:    nop
; SOFT-NEXT:    bl __gnu_f2h_ieee
; SOFT-NEXT:    nop
; SOFT-NEXT:    sth r3, 0(r30)
; SOFT-NEXT:    addi r1, r1, 48
; SOFT-NEXT:    ld r0, 16(r1)
; SOFT-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; SOFT-NEXT:    mtlr r0
; SOFT-NEXT:    blr
entry:
  %0 = tail call i16 @llvm.convert.to.fp16.f32(float %b)
  store i16 %0, i16* %a, align 2
  ret void
}

declare i16 @llvm.convert.to.fp16.f32(float)
attributes #0 = { nounwind }
