; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s -mtriple=powerpc64le-unknown-linux -mcpu=pwr9 -enable-ppc-quad-precision=true | FileCheck %s

declare fp128 @llvm.experimental.constrained.fadd.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fsub.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fmul.f128(fp128, fp128, metadata, metadata)
declare fp128 @llvm.experimental.constrained.fdiv.f128(fp128, fp128, metadata, metadata)

define fp128 @fadd_f128(fp128 %f1, fp128 %f2) {
; CHECK-LABEL: fadd_f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xsaddqp v2, v2, v3
; CHECK-NEXT:    blr
  %res = call fp128 @llvm.experimental.constrained.fadd.f128(
                        fp128 %f1, fp128 %f2,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict")
  ret fp128 %res
}

define fp128 @fsub_f128(fp128 %f1, fp128 %f2) {
; CHECK-LABEL: fsub_f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xssubqp v2, v2, v3
; CHECK-NEXT:    blr
  %res = call fp128 @llvm.experimental.constrained.fsub.f128(
                        fp128 %f1, fp128 %f2,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict")
  ret fp128 %res
}

define fp128 @fmul_f128(fp128 %f1, fp128 %f2) {
; CHECK-LABEL: fmul_f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xsmulqp v2, v2, v3
; CHECK-NEXT:    blr
  %res = call fp128 @llvm.experimental.constrained.fmul.f128(
                        fp128 %f1, fp128 %f2,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict")
  ret fp128 %res
}

define fp128 @fdiv_f128(fp128 %f1, fp128 %f2) {
; CHECK-LABEL: fdiv_f128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xsdivqp v2, v2, v3
; CHECK-NEXT:    blr
  %res = call fp128 @llvm.experimental.constrained.fdiv.f128(
                        fp128 %f1, fp128 %f2,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict")
  ret fp128 %res
}
