; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi2 | FileCheck %s --check-prefixes=AVX512,AVX512VBMI2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VLBW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi2,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VLVBMI2

declare <8 x i64> @llvm.fshl.v8i64(<8 x i64>, <8 x i64>, <8 x i64>)
declare <16 x i32> @llvm.fshl.v16i32(<16 x i32>, <16 x i32>, <16 x i32>)
declare <32 x i16> @llvm.fshl.v32i16(<32 x i16>, <32 x i16>, <32 x i16>)
declare <64 x i8> @llvm.fshl.v64i8(<64 x i8>, <64 x i8>, <64 x i8>)

;
; Variable Shifts
;

define <8 x i64> @var_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512F-NEXT:    vpsllvq %zmm2, %zmm0, %zmm3
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} zmm4 = [64,64,64,64,64,64,64,64]
; AVX512F-NEXT:    vpsubq %zmm2, %zmm4, %zmm4
; AVX512F-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsllvq %zmm2, %zmm0, %zmm3
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} zmm4 = [64,64,64,64,64,64,64,64]
; AVX512VL-NEXT:    vpsubq %zmm2, %zmm4, %zmm4
; AVX512VL-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvq %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} zmm4 = [64,64,64,64,64,64,64,64]
; AVX512BW-NEXT:    vpsubq %zmm2, %zmm4, %zmm4
; AVX512BW-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvq %zmm2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpbroadcastq {{.*#+}} zmm4 = [64,64,64,64,64,64,64,64]
; AVX512VLBW-NEXT:    vpsubq %zmm2, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt)
  ret <8 x i64> %res
}

define <16 x i32> @var_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512F-NEXT:    vpsllvd %zmm2, %zmm0, %zmm3
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} zmm4 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX512F-NEXT:    vpsubd %zmm2, %zmm4, %zmm4
; AVX512F-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsllvd %zmm2, %zmm0, %zmm3
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} zmm4 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX512VL-NEXT:    vpsubd %zmm2, %zmm4, %zmm4
; AVX512VL-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvd %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} zmm4 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX512BW-NEXT:    vpsubd %zmm2, %zmm4, %zmm4
; AVX512BW-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvd %zmm2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} zmm4 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX512VLBW-NEXT:    vpsubd %zmm2, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt)
  ret <16 x i32> %res
}

define <32 x i16> @var_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm3 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512F-NEXT:    vpsllvd %zmm4, %zmm3, %zmm3
; AVX512F-NEXT:    vpmovdw %zmm3, %ymm3
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm5
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm6 = ymm5[0],zero,ymm5[1],zero,ymm5[2],zero,ymm5[3],zero,ymm5[4],zero,ymm5[5],zero,ymm5[6],zero,ymm5[7],zero,ymm5[8],zero,ymm5[9],zero,ymm5[10],zero,ymm5[11],zero,ymm5[12],zero,ymm5[13],zero,ymm5[14],zero,ymm5[15],zero
; AVX512F-NEXT:    vpsllvd %zmm6, %zmm4, %zmm4
; AVX512F-NEXT:    vpmovdw %zmm4, %ymm4
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512F-NEXT:    vpsubw %ymm2, %ymm4, %ymm6
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm6 = ymm6[0],zero,ymm6[1],zero,ymm6[2],zero,ymm6[3],zero,ymm6[4],zero,ymm6[5],zero,ymm6[6],zero,ymm6[7],zero,ymm6[8],zero,ymm6[9],zero,ymm6[10],zero,ymm6[11],zero,ymm6[12],zero,ymm6[13],zero,ymm6[14],zero,ymm6[15],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm7 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm6, %zmm7, %zmm6
; AVX512F-NEXT:    vpmovdw %zmm6, %ymm6
; AVX512F-NEXT:    vpsubw %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm6, %zmm1
; AVX512F-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqw %ymm3, %ymm5, %ymm4
; AVX512F-NEXT:    vpcmpeqw %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512F-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm3 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm4, %zmm3, %zmm3
; AVX512VL-NEXT:    vpmovdw %zmm3, %ymm3
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm5
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm6 = ymm5[0],zero,ymm5[1],zero,ymm5[2],zero,ymm5[3],zero,ymm5[4],zero,ymm5[5],zero,ymm5[6],zero,ymm5[7],zero,ymm5[8],zero,ymm5[9],zero,ymm5[10],zero,ymm5[11],zero,ymm5[12],zero,ymm5[13],zero,ymm5[14],zero,ymm5[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm6, %zmm4, %zmm4
; AVX512VL-NEXT:    vpmovdw %zmm4, %ymm4
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512VL-NEXT:    vpsubw %ymm2, %ymm4, %ymm6
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm6 = ymm6[0],zero,ymm6[1],zero,ymm6[2],zero,ymm6[3],zero,ymm6[4],zero,ymm6[5],zero,ymm6[6],zero,ymm6[7],zero,ymm6[8],zero,ymm6[9],zero,ymm6[10],zero,ymm6[11],zero,ymm6[12],zero,ymm6[13],zero,ymm6[14],zero,ymm6[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm7 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm6, %zmm7, %zmm6
; AVX512VL-NEXT:    vpmovdw %zmm6, %ymm6
; AVX512VL-NEXT:    vpsubw %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm6, %zmm1
; AVX512VL-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqw %ymm3, %ymm5, %ymm4
; AVX512VL-NEXT:    vpcmpeqw %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512VL-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvw %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512BW-NEXT:    vpsubw %zmm2, %zmm4, %zmm4
; AVX512BW-NEXT:    vpsrlvw %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvw %zmm2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512VLBW-NEXT:    vpsubw %zmm2, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpsrlvw %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt)
  ret <32 x i16> %res
}

define <64 x i8> @var_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512F-NEXT:    vpsrlw $4, %ymm4, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm5, %ymm3, %ymm6
; AVX512F-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm7 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512F-NEXT:    vpsubb %ymm3, %ymm7, %ymm8
; AVX512F-NEXT:    vpsllw $5, %ymm8, %ymm8
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $2, %ymm4, %ymm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512F-NEXT:    vpand %ymm6, %ymm9, %ymm6
; AVX512F-NEXT:    vpaddb %ymm8, %ymm8, %ymm8
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $1, %ymm4, %ymm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm10 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm6, %ymm10, %ymm6
; AVX512F-NEXT:    vpaddb %ymm8, %ymm8, %ymm8
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm6
; AVX512F-NEXT:    vpand %ymm5, %ymm6, %ymm5
; AVX512F-NEXT:    vpsubb %ymm2, %ymm7, %ymm6
; AVX512F-NEXT:    vpsllw $5, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $2, %ymm1, %ymm5
; AVX512F-NEXT:    vpand %ymm5, %ymm9, %ymm5
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm5
; AVX512F-NEXT:    vpand %ymm5, %ymm10, %ymm5
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-NEXT:    vpsllw $4, %ymm4, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512F-NEXT:    vpsllw $5, %ymm3, %ymm7
; AVX512F-NEXT:    vpblendvb %ymm7, %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpsllw $2, %ymm4, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm8 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512F-NEXT:    vpand %ymm5, %ymm8, %ymm5
; AVX512F-NEXT:    vpaddb %ymm7, %ymm7, %ymm7
; AVX512F-NEXT:    vpblendvb %ymm7, %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm4, %ymm4, %ymm5
; AVX512F-NEXT:    vpaddb %ymm7, %ymm7, %ymm7
; AVX512F-NEXT:    vpblendvb %ymm7, %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm5
; AVX512F-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512F-NEXT:    vpsllw $5, %ymm2, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm0, %ymm5
; AVX512F-NEXT:    vpsllw $2, %ymm5, %ymm7
; AVX512F-NEXT:    vpand %ymm7, %ymm8, %ymm7
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm7, %ymm5, %ymm5
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm7
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm7, %ymm5, %ymm5
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm5, %zmm4
; AVX512F-NEXT:    vporq %zmm1, %zmm4, %zmm1
; AVX512F-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512F-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpcmpeqb %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512VL-NEXT:    vpsrlw $4, %ymm4, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm5 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm5, %ymm3, %ymm6
; AVX512VL-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm7 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VL-NEXT:    vpsubb %ymm3, %ymm7, %ymm8
; AVX512VL-NEXT:    vpsllw $5, %ymm8, %ymm8
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $2, %ymm4, %ymm6
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm9 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512VL-NEXT:    vpand %ymm6, %ymm9, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm8, %ymm8, %ymm8
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $1, %ymm4, %ymm6
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm10 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VL-NEXT:    vpand %ymm6, %ymm10, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm8, %ymm8, %ymm8
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm6
; AVX512VL-NEXT:    vpand %ymm5, %ymm6, %ymm5
; AVX512VL-NEXT:    vpsubb %ymm2, %ymm7, %ymm6
; AVX512VL-NEXT:    vpsllw $5, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $2, %ymm1, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm9, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm10, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512VL-NEXT:    vpsllw $4, %ymm4, %ymm5
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm6 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsllw $5, %ymm3, %ymm7
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsllw $2, %ymm4, %ymm5
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm8 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512VL-NEXT:    vpand %ymm5, %ymm8, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm7
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm4, %ymm4, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm7
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm5
; AVX512VL-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm5, %ymm0, %ymm5
; AVX512VL-NEXT:    vpsllw $2, %ymm5, %ymm7
; AVX512VL-NEXT:    vpand %ymm7, %ymm8, %ymm7
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm7, %ymm5, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm7
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm7, %ymm5, %ymm5
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm5, %zmm4
; AVX512VL-NEXT:    vporq %zmm1, %zmm4, %zmm1
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpcmpeqb %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512VL-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512BW-NEXT:    vpsubb %zmm2, %zmm3, %zmm3
; AVX512BW-NEXT:    vpsllw $5, %zmm3, %zmm3
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm3, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vpmovb2m %zmm3, %k2
; AVX512BW-NEXT:    vpsrlw $4, %zmm1, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k2}
; AVX512BW-NEXT:    vpsrlw $2, %zmm1, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpsllw $5, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vpsllw $2, %zmm3, %zmm5
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm5, %zmm3 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VBMI2-NEXT:    vpsubb %zmm2, %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpsllw $5, %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vpmovb2m %zmm3, %k2
; AVX512VBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k2}
; AVX512VBMI2-NEXT:    vpsrlw $2, %zmm1, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpsllw $5, %zmm2, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpsllw $2, %zmm3, %zmm5
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512VBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm5, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLBW-NEXT:    vpsubb %zmm2, %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpsllw $5, %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpaddb %zmm3, %zmm3, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vpmovb2m %zmm3, %k2
; AVX512VLBW-NEXT:    vpsrlw $4, %zmm1, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k2}
; AVX512VLBW-NEXT:    vpsrlw $2, %zmm1, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpsllw $5, %zmm2, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpsllw $2, %zmm3, %zmm5
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm5, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLVBMI2-NEXT:    vpsubb %zmm2, %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpsllw $5, %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm3, %k2
; AVX512VLVBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k2}
; AVX512VLVBMI2-NEXT:    vpsrlw $2, %zmm1, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpsllw $5, %zmm2, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpsllw $2, %zmm3, %zmm5
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512VLVBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm5, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLVBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt)
  ret <64 x i8> %res
}

;
; Uniform Variable Shifts
;

define <8 x i64> @splatvar_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512F-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512F-NEXT:    vpsllq %xmm2, %zmm0, %zmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512F-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VL-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsllq %xmm2, %zmm0, %zmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VL-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllq %xmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512BW-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllq %xmm2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VLBW-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <8 x i64> %amt, <8 x i64> undef, <8 x i32> zeroinitializer
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %splat)
  ret <8 x i64> %res
}

define <16 x i32> @splatvar_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512F-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512F-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512F-NEXT:    vpslld %xmm3, %zmm0, %zmm3
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512F-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512F-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VL-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512VL-NEXT:    vpslld %xmm3, %zmm0, %zmm3
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VL-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VL-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512BW-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512BW-NEXT:    vpslld %xmm3, %zmm0, %zmm3
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512BW-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512BW-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VLBW-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512VLBW-NEXT:    vpslld %xmm3, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VLBW-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VLBW-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <16 x i32> %amt, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %splat)
  ret <16 x i32> %res
}

define <32 x i16> @splatvar_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastw %xmm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm2
; AVX512F-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-NEXT:    vpsllw %xmm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpsllw %xmm3, %ymm0, %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm5 = [16,16,16,16,16,16,16,16]
; AVX512F-NEXT:    vpsubw %xmm4, %xmm5, %xmm6
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm7
; AVX512F-NEXT:    vpsrlw %xmm6, %ymm7, %ymm6
; AVX512F-NEXT:    vpsubw %xmm2, %xmm5, %xmm5
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm5 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero
; AVX512F-NEXT:    vpsrlw %xmm5, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm6, %zmm1, %zmm1
; AVX512F-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqw %ymm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpcmpeqw %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512F-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastw %xmm2, %ymm2
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm2
; AVX512VL-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512VL-NEXT:    vpsllw %xmm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsllw %xmm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm4
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm5 = [16,16,16,16,16,16,16,16]
; AVX512VL-NEXT:    vpsubw %xmm4, %xmm5, %xmm6
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,xmm6[1],zero,zero,zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm7
; AVX512VL-NEXT:    vpsrlw %xmm6, %ymm7, %ymm6
; AVX512VL-NEXT:    vpsubw %xmm2, %xmm5, %xmm5
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm5 = xmm5[0],zero,zero,zero,xmm5[1],zero,zero,zero
; AVX512VL-NEXT:    vpsrlw %xmm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm6, %zmm1, %zmm1
; AVX512VL-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqw %ymm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpcmpeqw %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512VL-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm3, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512BW-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512BW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm3, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512VLBW-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <32 x i16> %amt, <32 x i16> undef, <32 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %splat)
  ret <32 x i16> %res
}

define <64 x i8> @splatvar_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm2
; AVX512F-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512F-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-NEXT:    vpsllw %xmm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512F-NEXT:    vpsllw %xmm3, %xmm5, %xmm6
; AVX512F-NEXT:    vpbroadcastb %xmm6, %ymm6
; AVX512F-NEXT:    vpand %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpsllw %xmm3, %ymm0, %ymm3
; AVX512F-NEXT:    vpand %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm6 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512F-NEXT:    vpsubb %xmm4, %xmm6, %xmm7
; AVX512F-NEXT:    vpmovzxbq {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,zero,zero,zero,zero,xmm7[1],zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm8
; AVX512F-NEXT:    vpsrlw %xmm7, %ymm8, %ymm8
; AVX512F-NEXT:    vpsrlw %xmm7, %xmm5, %xmm7
; AVX512F-NEXT:    vpsrlw $8, %xmm7, %xmm7
; AVX512F-NEXT:    vpbroadcastb %xmm7, %ymm7
; AVX512F-NEXT:    vpand %ymm7, %ymm8, %ymm7
; AVX512F-NEXT:    vpsubb %xmm2, %xmm6, %xmm6
; AVX512F-NEXT:    vpmovzxbq {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,zero,zero,zero,zero,xmm6[1],zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vpsrlw %xmm6, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw %xmm6, %xmm5, %xmm5
; AVX512F-NEXT:    vpsrlw $8, %xmm5, %xmm5
; AVX512F-NEXT:    vpbroadcastb %xmm5, %ymm5
; AVX512F-NEXT:    vpand %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm7, %zmm1, %zmm1
; AVX512F-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqb %ymm3, %ymm4, %ymm4
; AVX512F-NEXT:    vpcmpeqb %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512F-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm2
; AVX512VL-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512VL-NEXT:    vpsllw %xmm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VL-NEXT:    vpsllw %xmm3, %xmm5, %xmm6
; AVX512VL-NEXT:    vpbroadcastb %xmm6, %ymm6
; AVX512VL-NEXT:    vpand %ymm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsllw %xmm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vpand %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm4
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm6 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VL-NEXT:    vpsubb %xmm4, %xmm6, %xmm7
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,zero,zero,zero,zero,xmm7[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm8
; AVX512VL-NEXT:    vpsrlw %xmm7, %ymm8, %ymm8
; AVX512VL-NEXT:    vpsrlw %xmm7, %xmm5, %xmm7
; AVX512VL-NEXT:    vpsrlw $8, %xmm7, %xmm7
; AVX512VL-NEXT:    vpbroadcastb %xmm7, %ymm7
; AVX512VL-NEXT:    vpand %ymm7, %ymm8, %ymm7
; AVX512VL-NEXT:    vpsubb %xmm2, %xmm6, %xmm6
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,zero,zero,zero,zero,xmm6[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vpsrlw %xmm6, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw %xmm6, %xmm5, %xmm5
; AVX512VL-NEXT:    vpsrlw $8, %xmm5, %xmm5
; AVX512VL-NEXT:    vpbroadcastb %xmm5, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm7, %zmm1, %zmm1
; AVX512VL-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqb %ymm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpcmpeqb %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm2, %zmm2
; AVX512VL-NEXT:    vpternlogq $226, %zmm1, %zmm2, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %xmm2, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512BW-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512BW-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512BW-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512BW-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512BW-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw %xmm4, %xmm5, %xmm4
; AVX512BW-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX512BW-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512BW-NEXT:    vpandq %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VBMI2-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512VBMI2-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VBMI2-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512VBMI2-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VBMI2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VBMI2-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsrlw %xmm4, %xmm5, %xmm4
; AVX512VBMI2-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VBMI2-NEXT:    vpandq %zmm4, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastb %xmm2, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512VLBW-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VLBW-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512VLBW-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512VLBW-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLBW-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw %xmm4, %xmm5, %xmm4
; AVX512VLBW-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VLBW-NEXT:    vpandq %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLVBMI2-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512VLVBMI2-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VLVBMI2-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512VLVBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLVBMI2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VLVBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLVBMI2-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsrlw %xmm4, %xmm5, %xmm4
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpandq %zmm4, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLVBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <64 x i8> %amt, <64 x i8> undef, <64 x i32> zeroinitializer
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %splat)
  ret <64 x i8> %res
}

;
; Constant Shifts
;

define <8 x i64> @constant_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512F-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvq {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvq {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> <i64 4, i64 14, i64 50, i64 60, i64 4, i64 14, i64 50, i64 60>)
  ret <8 x i64> %res
}

define <16 x i32> @constant_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512F-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvd {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvd {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>)
  ret <16 x i32> %res
}

define <32 x i16> @constant_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768>
; AVX512F-NEXT:    vpmulhuw %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-NEXT:    vpmullw %ymm3, %ymm4, %ymm5
; AVX512F-NEXT:    vpor %ymm2, %ymm5, %ymm2
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm2[1,2,3,4,5,6,7]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vpmulhuw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm3, %ymm0, %ymm3
; AVX512F-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768>
; AVX512VL-NEXT:    vpmulhuw %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512VL-NEXT:    vpmullw %ymm3, %ymm4, %ymm5
; AVX512VL-NEXT:    vpor %ymm2, %ymm5, %ymm2
; AVX512VL-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0],xmm2[1,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX512VL-NEXT:    vpmulhuw %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpmullw %ymm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512VL-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm2
; AVX512BW-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512BW-NEXT:    movl $65537, %eax # imm = 0x10001
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvw {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm2
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512VLBW-NEXT:    movl $65537, %eax # imm = 0x10001
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvw {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15, i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>)
  ret <32 x i16> %res
}

define <64 x i8> @constant_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm2, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512F-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm3, %ymm2, %ymm3
; AVX512F-NEXT:    vpsllw $2, %ymm3, %ymm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm7 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512F-NEXT:    vpand %ymm7, %ymm6, %ymm6
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm8
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddb %ymm3, %ymm3, %ymm6
; AVX512F-NEXT:    vpaddb %ymm8, %ymm8, %ymm9
; AVX512F-NEXT:    vpblendvb %ymm9, %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm6
; AVX512F-NEXT:    vpxor %xmm10, %xmm10, %xmm10
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm11 = ymm6[8],ymm10[8],ymm6[9],ymm10[9],ymm6[10],ymm10[10],ymm6[11],ymm10[11],ymm6[12],ymm10[12],ymm6[13],ymm10[13],ymm6[14],ymm10[14],ymm6[15],ymm10[15],ymm6[24],ymm10[24],ymm6[25],ymm10[25],ymm6[26],ymm10[26],ymm6[27],ymm10[27],ymm6[28],ymm10[28],ymm6[29],ymm10[29],ymm6[30],ymm10[30],ymm6[31],ymm10[31]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; AVX512F-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX512F-NEXT:    vpmullw %ymm12, %ymm11, %ymm11
; AVX512F-NEXT:    vpsrlw $8, %ymm11, %ymm11
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm6 = ymm6[0],ymm10[0],ymm6[1],ymm10[1],ymm6[2],ymm10[2],ymm6[3],ymm10[3],ymm6[4],ymm10[4],ymm6[5],ymm10[5],ymm6[6],ymm10[6],ymm6[7],ymm10[7],ymm6[16],ymm10[16],ymm6[17],ymm10[17],ymm6[18],ymm10[18],ymm6[19],ymm10[19],ymm6[20],ymm10[20],ymm6[21],ymm10[21],ymm6[22],ymm10[22],ymm6[23],ymm10[23]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [256,2,4,8,16,32,64,128,256,2,4,8,16,32,64,128]
; AVX512F-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX512F-NEXT:    vpmullw %ymm6, %ymm13, %ymm6
; AVX512F-NEXT:    vpsrlw $8, %ymm6, %ymm6
; AVX512F-NEXT:    vpackuswb %ymm11, %ymm6, %ymm6
; AVX512F-NEXT:    vpor %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [18446744073709551360,18446744073709551360,18446744073709551360,18446744073709551360]
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm3
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm3, %ymm0, %ymm3
; AVX512F-NEXT:    vpsllw $2, %ymm3, %ymm4
; AVX512F-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddb %ymm3, %ymm3, %ymm4
; AVX512F-NEXT:    vpblendvb %ymm9, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm10[8],ymm1[9],ymm10[9],ymm1[10],ymm10[10],ymm1[11],ymm10[11],ymm1[12],ymm10[12],ymm1[13],ymm10[13],ymm1[14],ymm10[14],ymm1[15],ymm10[15],ymm1[24],ymm10[24],ymm1[25],ymm10[25],ymm1[26],ymm10[26],ymm1[27],ymm10[27],ymm1[28],ymm10[28],ymm1[29],ymm10[29],ymm1[30],ymm10[30],ymm1[31],ymm10[31]
; AVX512F-NEXT:    vpmullw %ymm4, %ymm12, %ymm4
; AVX512F-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm10[0],ymm1[1],ymm10[1],ymm1[2],ymm10[2],ymm1[3],ymm10[3],ymm1[4],ymm10[4],ymm1[5],ymm10[5],ymm1[6],ymm10[6],ymm1[7],ymm10[7],ymm1[16],ymm10[16],ymm1[17],ymm10[17],ymm1[18],ymm10[18],ymm1[19],ymm10[19],ymm1[20],ymm10[20],ymm1[21],ymm10[21],ymm1[22],ymm10[22],ymm1[23],ymm10[23]
; AVX512F-NEXT:    vpmullw %ymm1, %ymm13, %ymm1
; AVX512F-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm2, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm3, %ymm2, %ymm3
; AVX512VL-NEXT:    vpsllw $2, %ymm3, %ymm6
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm7 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512VL-NEXT:    vpand %ymm7, %ymm6, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm8
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm8, %ymm8, %ymm9
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm6
; AVX512VL-NEXT:    vpxor %xmm10, %xmm10, %xmm10
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm11 = ymm6[8],ymm10[8],ymm6[9],ymm10[9],ymm6[10],ymm10[10],ymm6[11],ymm10[11],ymm6[12],ymm10[12],ymm6[13],ymm10[13],ymm6[14],ymm10[14],ymm6[15],ymm10[15],ymm6[24],ymm10[24],ymm6[25],ymm10[25],ymm6[26],ymm10[26],ymm6[27],ymm10[27],ymm6[28],ymm10[28],ymm6[29],ymm10[29],ymm6[30],ymm10[30],ymm6[31],ymm10[31]
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; AVX512VL-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpmullw %ymm12, %ymm11, %ymm11
; AVX512VL-NEXT:    vpsrlw $8, %ymm11, %ymm11
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm6 = ymm6[0],ymm10[0],ymm6[1],ymm10[1],ymm6[2],ymm10[2],ymm6[3],ymm10[3],ymm6[4],ymm10[4],ymm6[5],ymm10[5],ymm6[6],ymm10[6],ymm6[7],ymm10[7],ymm6[16],ymm10[16],ymm6[17],ymm10[17],ymm6[18],ymm10[18],ymm6[19],ymm10[19],ymm6[20],ymm10[20],ymm6[21],ymm10[21],ymm6[22],ymm10[22],ymm6[23],ymm10[23]
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [256,2,4,8,16,32,64,128,256,2,4,8,16,32,64,128]
; AVX512VL-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpmullw %ymm6, %ymm13, %ymm6
; AVX512VL-NEXT:    vpsrlw $8, %ymm6, %ymm6
; AVX512VL-NEXT:    vpackuswb %ymm11, %ymm6, %ymm6
; AVX512VL-NEXT:    vpor %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [18446744073709551360,18446744073709551360,18446744073709551360,18446744073709551360]
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vpsllw $2, %ymm3, %ymm4
; AVX512VL-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm4
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm10[8],ymm1[9],ymm10[9],ymm1[10],ymm10[10],ymm1[11],ymm10[11],ymm1[12],ymm10[12],ymm1[13],ymm10[13],ymm1[14],ymm10[14],ymm1[15],ymm10[15],ymm1[24],ymm10[24],ymm1[25],ymm10[25],ymm1[26],ymm10[26],ymm1[27],ymm10[27],ymm1[28],ymm10[28],ymm1[29],ymm10[29],ymm1[30],ymm10[30],ymm1[31],ymm10[31]
; AVX512VL-NEXT:    vpmullw %ymm4, %ymm12, %ymm4
; AVX512VL-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm10[0],ymm1[1],ymm10[1],ymm1[2],ymm10[2],ymm1[3],ymm10[3],ymm1[4],ymm10[4],ymm1[5],ymm10[5],ymm1[6],ymm10[6],ymm1[7],ymm10[7],ymm1[16],ymm10[16],ymm1[17],ymm10[17],ymm1[18],ymm10[18],ymm1[19],ymm10[19],ymm1[20],ymm10[20],ymm1[21],ymm10[21],ymm1[22],ymm10[22],ymm1[23],ymm10[23]
; AVX512VL-NEXT:    vpmullw %ymm1, %ymm13, %ymm1
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpackuswb %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vpsllw $2, %zmm3, %zmm4
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm4, %zmm4
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm4, %zmm3 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm4 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm4, %zmm4
; AVX512BW-NEXT:    vpsrlw $8, %zmm4, %zmm4
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512BW-NEXT:    vpackuswb %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VBMI2-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpsllw $2, %zmm3, %zmm4
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm4, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpunpckhbw {{.*#+}} zmm4 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; AVX512VBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpsrlw $8, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; AVX512VBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpackuswb %zmm4, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VBMI2-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; AVX512VBMI2-NEXT:    kmovq %rax, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VLBW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpsllw $2, %zmm3, %zmm4
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm4, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpunpckhbw {{.*#+}} zmm4 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpackuswb %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; AVX512VLBW-NEXT:    kmovq %rax, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VLVBMI2-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpsllw $2, %zmm3, %zmm4
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm4, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpunpckhbw {{.*#+}} zmm4 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; AVX512VLVBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; AVX512VLVBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpackuswb %zmm4, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLVBMI2-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; AVX512VLVBMI2-NEXT:    kmovq %rax, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <64 x i8> %res
}

;
; Uniform Constant Shifts
;

define <8 x i64> @splatconstant_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512F-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldq $14, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldq $14, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> <i64 14, i64 14, i64 14, i64 14, i64 14, i64 14, i64 14, i64 14>)
  ret <8 x i64> %res
}

define <16 x i32> @splatconstant_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512F-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512VL-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512BW-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldd $4, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldd $4, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>)
  ret <16 x i32> %res
}

define <32 x i16> @splatconstant_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlw $9, %ymm1, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512F-NEXT:    vpsrlw $9, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vpsllw $7, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512F-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlw $9, %ymm1, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $9, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512VL-NEXT:    vpsllw $7, %ymm0, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512VL-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlw $9, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldw $7, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlw $9, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldw $7, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>)
  ret <32 x i16> %res
}

define <64 x i8> @splatconstant_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vpsrlw $4, %ymm2, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm2, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX512F-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512BW-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512BW-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLBW-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VLBW-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLVBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>)
  ret <64 x i8> %res
}
