// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -verify -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK2
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -verify -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK4

// RUN: %clang_cc1 -no-opaque-pointers  -verify -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK5
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK6
// RUN: %clang_cc1 -no-opaque-pointers  -verify -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK7
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK8

// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -verify -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK9
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK10
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -verify -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK11
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers -DLAMBDA -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK12

// RUN: %clang_cc1 -no-opaque-pointers  -verify -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK13
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK14
// RUN: %clang_cc1 -no-opaque-pointers  -verify -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK15
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -no-opaque-pointers  -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK16

// expected-no-diagnostics
#ifndef HEADER
#define HEADER

template <class T>
struct S {
  T f;
  S(T a) : f(a) {}
  S() : f() {}
  operator T() { return T(); }
  ~S() {}
};

template <typename T>
T tmain() {
  S<T> test;
  T t_var = T();
  T vec[] = {1, 2};
  S<T> s_arr[] = {1, 2};
  S<T> &var = test;
  #pragma omp target teams distribute parallel for simd lastprivate(t_var, vec, s_arr, s_arr, var, var)
  for (int i = 0; i < 2; ++i) {
    vec[i] = t_var;
    s_arr[i] = var;
  }
  return T();
}

int main() {
  static int svar;
  volatile double g;
  volatile double &g1 = g;

  #ifdef LAMBDA
  [&]() {
    static float sfvar;

    #pragma omp target teams distribute parallel for simd lastprivate(g, g1, svar, sfvar)
    for (int i = 0; i < 2; ++i) {
      // skip gbl and bound tid
      // loop variables



      g1 = 1;
      svar = 3;
      sfvar = 4.0;



      // skip tid and prev variables
      // loop variables







      [&]() {
        g = 2;
        g1 = 2;
        svar = 4;
        sfvar = 8.0;

      }();
    }
  }();
  return 0;
  #else
  S<float> test;
  int t_var = 0;
  int vec[] = {1, 2};
  S<float> s_arr[] = {1, 2};
  S<float> &var = test;

  #pragma omp target teams distribute parallel for simd lastprivate(t_var, vec, s_arr, s_arr, var, var, svar)
  for (int i = 0; i < 2; ++i) {
    vec[i] = t_var;
    s_arr[i] = var;
  }
  int i;

  return tmain<int>();
  #endif
}


// skip loop variables

// copy from parameters to local address variables

// prepare lastprivate targets

// the distribute loop

// lastprivates



// gbl and bound tid vars, prev lb and ub vars

// skip loop variables

// copy from parameters to local address variables

// prepare lastprivate targets

// the distribute loop
// skip body: code generation routine is same as distribute parallel for lastprivate

// lastprivates


// template tmain


// skip alloca of global_tid and bound_tid
// skip loop variables

// copy from parameters to local address variables

// prepare lastprivate targets


// lastprivates


// skip alloca of global_tid and bound_tid, and prev lb and ub vars

// skip loop variables

// copy from parameters to local address variables

// prepare lastprivate targets

// skip body: code generation routine is same as distribute parallel for lastprivate

// lastprivates


#endif
// CHECK1-LABEL: define {{[^@]+}}@main
// CHECK1-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK1-NEXT:    [[G1:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK1-NEXT:    store double* [[G]], double** [[G1]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double* [[G]], double** [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP2:%.*]] = load double*, double** [[G1]], align 8
// CHECK1-NEXT:    store double* [[TMP2]], double** [[TMP1]], align 8
// CHECK1-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l67
// CHECK1-SAME: (i64 noundef [[G1:%.*]], i64 noundef [[SVAR:%.*]], i64 noundef [[SFVAR:%.*]], i64 noundef [[G:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[G1_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[G1_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[G1]], i64* [[G1_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SFVAR]], i64* [[SFVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[G]], i64* [[G_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[G1_ADDR]] to double*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[SFVAR_ADDR]] to float*
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[G_ADDR]] to double*
// CHECK1-NEXT:    store double* [[CONV]], double** [[TMP]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load double*, double** [[TMP]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load volatile double, double* [[TMP0]], align 8
// CHECK1-NEXT:    [[CONV4:%.*]] = bitcast i64* [[G1_CASTED]] to double*
// CHECK1-NEXT:    store double [[TMP1]], double* [[CONV4]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[G1_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[CONV5:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP3]], i32* [[CONV5]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load float, float* [[CONV2]], align 4
// CHECK1-NEXT:    [[CONV6:%.*]] = bitcast i64* [[SFVAR_CASTED]] to float*
// CHECK1-NEXT:    store float [[TMP5]], float* [[CONV6]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[SFVAR_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load double, double* [[CONV3]], align 8
// CHECK1-NEXT:    [[CONV7:%.*]] = bitcast i64* [[G_CASTED]] to double*
// CHECK1-NEXT:    store double [[TMP7]], double* [[CONV7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[G_CASTED]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP8]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[G1:%.*]], i64 noundef [[SVAR:%.*]], i64 noundef [[SFVAR:%.*]], i64 noundef [[G:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[G1_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[G5:%.*]] = alloca double, align 8
// CHECK1-NEXT:    [[G16:%.*]] = alloca double, align 8
// CHECK1-NEXT:    [[_TMP7:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[SVAR8:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[SFVAR9:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[G1_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[G1]], i64* [[G1_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SFVAR]], i64* [[SFVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[G]], i64* [[G_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[G1_ADDR]] to double*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[SFVAR_ADDR]] to float*
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[G_ADDR]] to double*
// CHECK1-NEXT:    store double* [[CONV]], double** [[TMP]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load double*, double** [[TMP]], align 8
// CHECK1-NEXT:    store double* [[G16]], double** [[_TMP7]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 1
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK1-NEXT:    br i1 [[CMP10]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP9:%.*]] = zext i32 [[TMP8]] to i64
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP10]] to i64
// CHECK1-NEXT:    [[TMP12:%.*]] = load double*, double** [[_TMP7]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP13:%.*]] = load volatile double, double* [[TMP12]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    [[CONV11:%.*]] = bitcast i64* [[G1_CASTED]] to double*
// CHECK1-NEXT:    store double [[TMP13]], double* [[CONV11]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, i64* [[G1_CASTED]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[SVAR8]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[CONV12:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP15]], i32* [[CONV12]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP17:%.*]] = load float, float* [[SFVAR9]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[CONV13:%.*]] = bitcast i64* [[SFVAR_CASTED]] to float*
// CHECK1-NEXT:    store float [[TMP17]], float* [[CONV13]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i64, i64* [[SFVAR_CASTED]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP19:%.*]] = load double, double* [[G5]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    [[CONV14:%.*]] = bitcast i64* [[G_CASTED]] to double*
// CHECK1-NEXT:    store double [[TMP19]], double* [[CONV14]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i64, i64* [[G_CASTED]], align 8, !llvm.access.group !4
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, i64, i64, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP9]], i64 [[TMP11]], i64 [[TMP14]], i64 [[TMP16]], i64 [[TMP18]], i64 [[TMP20]]), !llvm.access.group !4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK1-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK1-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK1:       .omp.lastprivate.then:
// CHECK1-NEXT:    [[TMP27:%.*]] = load double, double* [[G5]], align 8
// CHECK1-NEXT:    store volatile double [[TMP27]], double* [[CONV3]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = load double*, double** [[_TMP7]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = load double, double* [[TMP28]], align 8
// CHECK1-NEXT:    store volatile double [[TMP29]], double* [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, i32* [[SVAR8]], align 4
// CHECK1-NEXT:    store i32 [[TMP30]], i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load float, float* [[SFVAR9]], align 4
// CHECK1-NEXT:    store float [[TMP31]], float* [[CONV2]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK1:       .omp.lastprivate.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[G1:%.*]], i64 noundef [[SVAR:%.*]], i64 noundef [[SFVAR:%.*]], i64 noundef [[G:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G1_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[G7:%.*]] = alloca double, align 8
// CHECK1-NEXT:    [[G18:%.*]] = alloca double, align 8
// CHECK1-NEXT:    [[_TMP9:%.*]] = alloca double*, align 8
// CHECK1-NEXT:    [[SVAR10:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[SFVAR11:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[G1]], i64* [[G1_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SFVAR]], i64* [[SFVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[G]], i64* [[G_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[G1_ADDR]] to double*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[SFVAR_ADDR]] to float*
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[G_ADDR]] to double*
// CHECK1-NEXT:    store double* [[CONV]], double** [[TMP]], align 8
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP0]] to i32
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV6:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK1-NEXT:    store i32 [[CONV5]], i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV6]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load double*, double** [[TMP]], align 8
// CHECK1-NEXT:    store double* [[G18]], double** [[_TMP9]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP4]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 1
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK1-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP11:%.*]] = load double*, double** [[_TMP9]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    store volatile double 1.000000e+00, double* [[TMP11]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    store i32 3, i32* [[SVAR10]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    store float 4.000000e+00, float* [[SFVAR11]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store double* [[G7]], double** [[TMP12]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP14:%.*]] = load double*, double** [[_TMP9]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    store double* [[TMP14]], double** [[TMP13]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store i32* [[SVAR10]], i32** [[TMP15]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store float* [[SFVAR11]], float** [[TMP16]], align 8, !llvm.access.group !8
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(%class.anon.0* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]]), !llvm.access.group !8
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK1-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = icmp ne i32 [[TMP18]], 0
// CHECK1-NEXT:    br i1 [[TMP19]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK1-NEXT:    br i1 [[TMP21]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK1:       .omp.lastprivate.then:
// CHECK1-NEXT:    [[TMP22:%.*]] = load double, double* [[G7]], align 8
// CHECK1-NEXT:    store volatile double [[TMP22]], double* [[CONV3]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load double*, double** [[_TMP9]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = load double, double* [[TMP23]], align 8
// CHECK1-NEXT:    store volatile double [[TMP24]], double* [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, i32* [[SVAR10]], align 4
// CHECK1-NEXT:    store i32 [[TMP25]], i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = load float, float* [[SFVAR11]], align 4
// CHECK1-NEXT:    store float [[TMP26]], float* [[CONV2]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK1:       .omp.lastprivate.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@main
// CHECK2-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK2-NEXT:    [[G1:%.*]] = alloca double*, align 8
// CHECK2-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK2-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK2-NEXT:    store double* [[G]], double** [[G1]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK2-NEXT:    store double* [[G]], double** [[TMP0]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP2:%.*]] = load double*, double** [[G1]], align 8
// CHECK2-NEXT:    store double* [[TMP2]], double** [[TMP1]], align 8
// CHECK2-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK2-NEXT:    ret i32 0
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l67
// CHECK2-SAME: (i64 noundef [[G1:%.*]], i64 noundef [[SVAR:%.*]], i64 noundef [[SFVAR:%.*]], i64 noundef [[G:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[G1_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[G_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca double*, align 8
// CHECK2-NEXT:    [[G1_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[G_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store i64 [[G1]], i64* [[G1_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[SFVAR]], i64* [[SFVAR_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[G]], i64* [[G_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[G1_ADDR]] to double*
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK2-NEXT:    [[CONV2:%.*]] = bitcast i64* [[SFVAR_ADDR]] to float*
// CHECK2-NEXT:    [[CONV3:%.*]] = bitcast i64* [[G_ADDR]] to double*
// CHECK2-NEXT:    store double* [[CONV]], double** [[TMP]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load double*, double** [[TMP]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load volatile double, double* [[TMP0]], align 8
// CHECK2-NEXT:    [[CONV4:%.*]] = bitcast i64* [[G1_CASTED]] to double*
// CHECK2-NEXT:    store double [[TMP1]], double* [[CONV4]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i64, i64* [[G1_CASTED]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK2-NEXT:    [[CONV5:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP3]], i32* [[CONV5]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load float, float* [[CONV2]], align 4
// CHECK2-NEXT:    [[CONV6:%.*]] = bitcast i64* [[SFVAR_CASTED]] to float*
// CHECK2-NEXT:    store float [[TMP5]], float* [[CONV6]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i64, i64* [[SFVAR_CASTED]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load double, double* [[CONV3]], align 8
// CHECK2-NEXT:    [[CONV7:%.*]] = bitcast i64* [[G_CASTED]] to double*
// CHECK2-NEXT:    store double [[TMP7]], double* [[CONV7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i64, i64* [[G_CASTED]], align 8
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), i64 [[TMP2]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP8]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK2-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[G1:%.*]], i64 noundef [[SVAR:%.*]], i64 noundef [[SFVAR:%.*]], i64 noundef [[G:%.*]]) #[[ATTR2]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[G1_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[G_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca double*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[G5:%.*]] = alloca double, align 8
// CHECK2-NEXT:    [[G16:%.*]] = alloca double, align 8
// CHECK2-NEXT:    [[_TMP7:%.*]] = alloca double*, align 8
// CHECK2-NEXT:    [[SVAR8:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[SFVAR9:%.*]] = alloca float, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[G1_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[G_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[G1]], i64* [[G1_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[SFVAR]], i64* [[SFVAR_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[G]], i64* [[G_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[G1_ADDR]] to double*
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK2-NEXT:    [[CONV2:%.*]] = bitcast i64* [[SFVAR_ADDR]] to float*
// CHECK2-NEXT:    [[CONV3:%.*]] = bitcast i64* [[G_ADDR]] to double*
// CHECK2-NEXT:    store double* [[CONV]], double** [[TMP]], align 8
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load double*, double** [[TMP]], align 8
// CHECK2-NEXT:    store double* [[G16]], double** [[_TMP7]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 1
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK2-NEXT:    br i1 [[CMP10]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP9:%.*]] = zext i32 [[TMP8]] to i64
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP10]] to i64
// CHECK2-NEXT:    [[TMP12:%.*]] = load double*, double** [[_TMP7]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP13:%.*]] = load volatile double, double* [[TMP12]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    [[CONV11:%.*]] = bitcast i64* [[G1_CASTED]] to double*
// CHECK2-NEXT:    store double [[TMP13]], double* [[CONV11]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i64, i64* [[G1_CASTED]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[SVAR8]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[CONV12:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP15]], i32* [[CONV12]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP16:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP17:%.*]] = load float, float* [[SFVAR9]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[CONV13:%.*]] = bitcast i64* [[SFVAR_CASTED]] to float*
// CHECK2-NEXT:    store float [[TMP17]], float* [[CONV13]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i64, i64* [[SFVAR_CASTED]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP19:%.*]] = load double, double* [[G5]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    [[CONV14:%.*]] = bitcast i64* [[G_CASTED]] to double*
// CHECK2-NEXT:    store double [[TMP19]], double* [[CONV14]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i64, i64* [[G_CASTED]], align 8, !llvm.access.group !4
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, i64, i64, i64, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP9]], i64 [[TMP11]], i64 [[TMP14]], i64 [[TMP16]], i64 [[TMP18]], i64 [[TMP20]]), !llvm.access.group !4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK2-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK2-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK2:       .omp.lastprivate.then:
// CHECK2-NEXT:    [[TMP27:%.*]] = load double, double* [[G5]], align 8
// CHECK2-NEXT:    store volatile double [[TMP27]], double* [[CONV3]], align 8
// CHECK2-NEXT:    [[TMP28:%.*]] = load double*, double** [[_TMP7]], align 8
// CHECK2-NEXT:    [[TMP29:%.*]] = load double, double* [[TMP28]], align 8
// CHECK2-NEXT:    store volatile double [[TMP29]], double* [[TMP0]], align 8
// CHECK2-NEXT:    [[TMP30:%.*]] = load i32, i32* [[SVAR8]], align 4
// CHECK2-NEXT:    store i32 [[TMP30]], i32* [[CONV1]], align 4
// CHECK2-NEXT:    [[TMP31:%.*]] = load float, float* [[SFVAR9]], align 4
// CHECK2-NEXT:    store float [[TMP31]], float* [[CONV2]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK2:       .omp.lastprivate.done:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK2-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[G1:%.*]], i64 noundef [[SVAR:%.*]], i64 noundef [[SFVAR:%.*]], i64 noundef [[G:%.*]]) #[[ATTR2]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[G1_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[G_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca double*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[G7:%.*]] = alloca double, align 8
// CHECK2-NEXT:    [[G18:%.*]] = alloca double, align 8
// CHECK2-NEXT:    [[_TMP9:%.*]] = alloca double*, align 8
// CHECK2-NEXT:    [[SVAR10:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[SFVAR11:%.*]] = alloca float, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[G1]], i64* [[G1_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[SFVAR]], i64* [[SFVAR_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[G]], i64* [[G_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[G1_ADDR]] to double*
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK2-NEXT:    [[CONV2:%.*]] = bitcast i64* [[SFVAR_ADDR]] to float*
// CHECK2-NEXT:    [[CONV3:%.*]] = bitcast i64* [[G_ADDR]] to double*
// CHECK2-NEXT:    store double* [[CONV]], double** [[TMP]], align 8
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK2-NEXT:    [[CONV5:%.*]] = trunc i64 [[TMP0]] to i32
// CHECK2-NEXT:    [[TMP1:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK2-NEXT:    [[CONV6:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK2-NEXT:    store i32 [[CONV5]], i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[CONV6]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load double*, double** [[TMP]], align 8
// CHECK2-NEXT:    store double* [[G18]], double** [[_TMP9]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP4]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 1
// CHECK2-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[CMP12:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK2-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP11:%.*]] = load double*, double** [[_TMP9]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    store volatile double 1.000000e+00, double* [[TMP11]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    store i32 3, i32* [[SVAR10]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    store float 4.000000e+00, float* [[SFVAR11]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 0
// CHECK2-NEXT:    store double* [[G7]], double** [[TMP12]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP14:%.*]] = load double*, double** [[_TMP9]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    store double* [[TMP14]], double** [[TMP13]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 2
// CHECK2-NEXT:    store i32* [[SVAR10]], i32** [[TMP15]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 3
// CHECK2-NEXT:    store float* [[SFVAR11]], float** [[TMP16]], align 8, !llvm.access.group !8
// CHECK2-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(%class.anon.0* noundef nonnull align 8 dereferenceable(32) [[REF_TMP]]), !llvm.access.group !8
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    [[ADD13:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK2-NEXT:    store i32 [[ADD13]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP19:%.*]] = icmp ne i32 [[TMP18]], 0
// CHECK2-NEXT:    br i1 [[TMP19]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK2-NEXT:    br i1 [[TMP21]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK2:       .omp.lastprivate.then:
// CHECK2-NEXT:    [[TMP22:%.*]] = load double, double* [[G7]], align 8
// CHECK2-NEXT:    store volatile double [[TMP22]], double* [[CONV3]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = load double*, double** [[_TMP9]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = load double, double* [[TMP23]], align 8
// CHECK2-NEXT:    store volatile double [[TMP24]], double* [[TMP2]], align 8
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, i32* [[SVAR10]], align 4
// CHECK2-NEXT:    store i32 [[TMP25]], i32* [[CONV1]], align 4
// CHECK2-NEXT:    [[TMP26:%.*]] = load float, float* [[SFVAR11]], align 4
// CHECK2-NEXT:    store float [[TMP26]], float* [[CONV2]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK2:       .omp.lastprivate.done:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK2-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK2-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@main
// CHECK3-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[G1:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK3-NEXT:    store double* [[G]], double** [[G1]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double* [[G]], double** [[TMP0]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP2:%.*]] = load double*, double** [[G1]], align 4
// CHECK3-NEXT:    store double* [[TMP2]], double** [[TMP1]], align 4
// CHECK3-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 4 dereferenceable(8) [[REF_TMP]])
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l67
// CHECK3-SAME: (double* noundef nonnull align 4 dereferenceable(8) [[G1:%.*]], i32 noundef [[SVAR:%.*]], i32 noundef [[SFVAR:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[G1_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store double* [[G1]], double** [[G1_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SFVAR]], i32* [[SFVAR_ADDR]], align 4
// CHECK3-NEXT:    store double* [[G]], double** [[G_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load double*, double** [[G1_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[SFVAR_ADDR]] to float*
// CHECK3-NEXT:    [[TMP1:%.*]] = load double*, double** [[G_ADDR]], align 4
// CHECK3-NEXT:    store double* [[TMP0]], double** [[TMP]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double*, double** [[TMP]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[SVAR_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load float, float* [[CONV]], align 4
// CHECK3-NEXT:    [[CONV1:%.*]] = bitcast i32* [[SFVAR_CASTED]] to float*
// CHECK3-NEXT:    store float [[TMP5]], float* [[CONV1]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[SFVAR_CASTED]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, double*, i32, i32, double*)* @.omp_outlined. to void (i32*, i32*, ...)*), double* [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], double* [[TMP1]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G1:%.*]], i32 noundef [[SVAR:%.*]], i32 noundef [[SFVAR:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[G1_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G2:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[G13:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[_TMP4:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[SVAR5:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR6:%.*]] = alloca float, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store double* [[G1]], double** [[G1_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SFVAR]], i32* [[SFVAR_ADDR]], align 4
// CHECK3-NEXT:    store double* [[G]], double** [[G_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load double*, double** [[G1_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[SFVAR_ADDR]] to float*
// CHECK3-NEXT:    [[TMP1:%.*]] = load double*, double** [[G_ADDR]], align 4
// CHECK3-NEXT:    store double* [[TMP0]], double** [[TMP]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double*, double** [[TMP]], align 4
// CHECK3-NEXT:    store double* [[G13]], double** [[_TMP4]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP4]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 1
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK3-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[TMP12:%.*]] = load double*, double** [[_TMP4]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[SVAR5]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    store i32 [[TMP13]], i32* [[SVAR_CASTED]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[TMP15:%.*]] = load float, float* [[SFVAR6]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[CONV8:%.*]] = bitcast i32* [[SFVAR_CASTED]] to float*
// CHECK3-NEXT:    store float [[TMP15]], float* [[CONV8]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[SFVAR_CASTED]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, double*, i32, i32, double*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP10]], i32 [[TMP11]], double* [[TMP12]], i32 [[TMP14]], i32 [[TMP16]], double* [[G2]]), !llvm.access.group !5
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = icmp ne i32 [[TMP19]], 0
// CHECK3-NEXT:    br i1 [[TMP20]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK3-NEXT:    br i1 [[TMP22]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK3:       .omp.lastprivate.then:
// CHECK3-NEXT:    [[TMP23:%.*]] = load double, double* [[G2]], align 8
// CHECK3-NEXT:    store volatile double [[TMP23]], double* [[TMP1]], align 8
// CHECK3-NEXT:    [[TMP24:%.*]] = load double*, double** [[_TMP4]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = load double, double* [[TMP24]], align 4
// CHECK3-NEXT:    store volatile double [[TMP25]], double* [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, i32* [[SVAR5]], align 4
// CHECK3-NEXT:    store i32 [[TMP26]], i32* [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load float, float* [[SFVAR6]], align 4
// CHECK3-NEXT:    store float [[TMP27]], float* [[CONV]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK3:       .omp.lastprivate.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G1:%.*]], i32 noundef [[SVAR:%.*]], i32 noundef [[SFVAR:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G1_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G_ADDR:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G2:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[G13:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[_TMP4:%.*]] = alloca double*, align 4
// CHECK3-NEXT:    [[SVAR5:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR6:%.*]] = alloca float, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store double* [[G1]], double** [[G1_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SFVAR]], i32* [[SFVAR_ADDR]], align 4
// CHECK3-NEXT:    store double* [[G]], double** [[G_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load double*, double** [[G1_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = bitcast i32* [[SFVAR_ADDR]] to float*
// CHECK3-NEXT:    [[TMP1:%.*]] = load double*, double** [[G_ADDR]], align 4
// CHECK3-NEXT:    store double* [[TMP0]], double** [[TMP]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load double*, double** [[TMP]], align 4
// CHECK3-NEXT:    store double* [[G13]], double** [[_TMP4]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP6]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 1
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP13:%.*]] = load double*, double** [[_TMP4]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    store volatile double 1.000000e+00, double* [[TMP13]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    store i32 3, i32* [[SVAR5]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    store float 4.000000e+00, float* [[SFVAR6]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store double* [[G2]], double** [[TMP14]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP16:%.*]] = load double*, double** [[_TMP4]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    store double* [[TMP16]], double** [[TMP15]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store i32* [[SVAR5]], i32** [[TMP17]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store float* [[SFVAR6]], float** [[TMP18]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(%class.anon.0* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]]), !llvm.access.group !9
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK3-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK3-NEXT:    br i1 [[TMP21]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK3-NEXT:    br i1 [[TMP23]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK3:       .omp.lastprivate.then:
// CHECK3-NEXT:    [[TMP24:%.*]] = load double, double* [[G2]], align 8
// CHECK3-NEXT:    store volatile double [[TMP24]], double* [[TMP1]], align 8
// CHECK3-NEXT:    [[TMP25:%.*]] = load double*, double** [[_TMP4]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = load double, double* [[TMP25]], align 4
// CHECK3-NEXT:    store volatile double [[TMP26]], double* [[TMP4]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, i32* [[SVAR5]], align 4
// CHECK3-NEXT:    store i32 [[TMP27]], i32* [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = load float, float* [[SFVAR6]], align 4
// CHECK3-NEXT:    store float [[TMP28]], float* [[CONV]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK3:       .omp.lastprivate.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@main
// CHECK4-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK4-NEXT:    [[G1:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK4-NEXT:    store double* [[G]], double** [[G1]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK4-NEXT:    store double* [[G]], double** [[TMP0]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP2:%.*]] = load double*, double** [[G1]], align 4
// CHECK4-NEXT:    store double* [[TMP2]], double** [[TMP1]], align 4
// CHECK4-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 4 dereferenceable(8) [[REF_TMP]])
// CHECK4-NEXT:    ret i32 0
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l67
// CHECK4-SAME: (double* noundef nonnull align 4 dereferenceable(8) [[G1:%.*]], i32 noundef [[SVAR:%.*]], i32 noundef [[SFVAR:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[G1_ADDR:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G_ADDR:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store double* [[G1]], double** [[G1_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[SFVAR]], i32* [[SFVAR_ADDR]], align 4
// CHECK4-NEXT:    store double* [[G]], double** [[G_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load double*, double** [[G1_ADDR]], align 4
// CHECK4-NEXT:    [[CONV:%.*]] = bitcast i32* [[SFVAR_ADDR]] to float*
// CHECK4-NEXT:    [[TMP1:%.*]] = load double*, double** [[G_ADDR]], align 4
// CHECK4-NEXT:    store double* [[TMP0]], double** [[TMP]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load double*, double** [[TMP]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[SVAR_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[SVAR_CASTED]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load float, float* [[CONV]], align 4
// CHECK4-NEXT:    [[CONV1:%.*]] = bitcast i32* [[SFVAR_CASTED]] to float*
// CHECK4-NEXT:    store float [[TMP5]], float* [[CONV1]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[SFVAR_CASTED]], align 4
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3:[0-9]+]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, double*, i32, i32, double*)* @.omp_outlined. to void (i32*, i32*, ...)*), double* [[TMP2]], i32 [[TMP4]], i32 [[TMP6]], double* [[TMP1]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK4-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G1:%.*]], i32 noundef [[SVAR:%.*]], i32 noundef [[SFVAR:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G:%.*]]) #[[ATTR2]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[G1_ADDR:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G_ADDR:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G2:%.*]] = alloca double, align 8
// CHECK4-NEXT:    [[G13:%.*]] = alloca double, align 8
// CHECK4-NEXT:    [[_TMP4:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[SVAR5:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SFVAR6:%.*]] = alloca float, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store double* [[G1]], double** [[G1_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[SFVAR]], i32* [[SFVAR_ADDR]], align 4
// CHECK4-NEXT:    store double* [[G]], double** [[G_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load double*, double** [[G1_ADDR]], align 4
// CHECK4-NEXT:    [[CONV:%.*]] = bitcast i32* [[SFVAR_ADDR]] to float*
// CHECK4-NEXT:    [[TMP1:%.*]] = load double*, double** [[G_ADDR]], align 4
// CHECK4-NEXT:    store double* [[TMP0]], double** [[TMP]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load double*, double** [[TMP]], align 4
// CHECK4-NEXT:    store double* [[G13]], double** [[_TMP4]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TMP3]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP4]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP5]], 1
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP6]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK4-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[TMP12:%.*]] = load double*, double** [[_TMP4]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[SVAR5]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    store i32 [[TMP13]], i32* [[SVAR_CASTED]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[TMP15:%.*]] = load float, float* [[SFVAR6]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[CONV8:%.*]] = bitcast i32* [[SFVAR_CASTED]] to float*
// CHECK4-NEXT:    store float [[TMP15]], float* [[CONV8]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[SFVAR_CASTED]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, double*, i32, i32, double*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP10]], i32 [[TMP11]], double* [[TMP12]], i32 [[TMP14]], i32 [[TMP16]], double* [[G2]]), !llvm.access.group !5
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP17]], [[TMP18]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP4]])
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = icmp ne i32 [[TMP19]], 0
// CHECK4-NEXT:    br i1 [[TMP20]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK4-NEXT:    br i1 [[TMP22]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK4:       .omp.lastprivate.then:
// CHECK4-NEXT:    [[TMP23:%.*]] = load double, double* [[G2]], align 8
// CHECK4-NEXT:    store volatile double [[TMP23]], double* [[TMP1]], align 8
// CHECK4-NEXT:    [[TMP24:%.*]] = load double*, double** [[_TMP4]], align 4
// CHECK4-NEXT:    [[TMP25:%.*]] = load double, double* [[TMP24]], align 4
// CHECK4-NEXT:    store volatile double [[TMP25]], double* [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP26:%.*]] = load i32, i32* [[SVAR5]], align 4
// CHECK4-NEXT:    store i32 [[TMP26]], i32* [[SVAR_ADDR]], align 4
// CHECK4-NEXT:    [[TMP27:%.*]] = load float, float* [[SFVAR6]], align 4
// CHECK4-NEXT:    store float [[TMP27]], float* [[CONV]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK4:       .omp.lastprivate.done:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK4-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G1:%.*]], i32 noundef [[SVAR:%.*]], i32 noundef [[SFVAR:%.*]], double* noundef nonnull align 4 dereferenceable(8) [[G:%.*]]) #[[ATTR2]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G1_ADDR:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G_ADDR:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[G2:%.*]] = alloca double, align 8
// CHECK4-NEXT:    [[G13:%.*]] = alloca double, align 8
// CHECK4-NEXT:    [[_TMP4:%.*]] = alloca double*, align 4
// CHECK4-NEXT:    [[SVAR5:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SFVAR6:%.*]] = alloca float, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK4-NEXT:    store double* [[G1]], double** [[G1_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[SFVAR]], i32* [[SFVAR_ADDR]], align 4
// CHECK4-NEXT:    store double* [[G]], double** [[G_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load double*, double** [[G1_ADDR]], align 4
// CHECK4-NEXT:    [[CONV:%.*]] = bitcast i32* [[SFVAR_ADDR]] to float*
// CHECK4-NEXT:    [[TMP1:%.*]] = load double*, double** [[G_ADDR]], align 4
// CHECK4-NEXT:    store double* [[TMP0]], double** [[TMP]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load double*, double** [[TMP]], align 4
// CHECK4-NEXT:    store double* [[G13]], double** [[_TMP4]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[TMP5]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP6]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP7]], 1
// CHECK4-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP8]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP9]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK4-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP13:%.*]] = load double*, double** [[_TMP4]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    store volatile double 1.000000e+00, double* [[TMP13]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    store i32 3, i32* [[SVAR5]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    store float 4.000000e+00, float* [[SFVAR6]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 0
// CHECK4-NEXT:    store double* [[G2]], double** [[TMP14]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP16:%.*]] = load double*, double** [[_TMP4]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    store double* [[TMP16]], double** [[TMP15]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 2
// CHECK4-NEXT:    store i32* [[SVAR5]], i32** [[TMP17]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], %class.anon.0* [[REF_TMP]], i32 0, i32 3
// CHECK4-NEXT:    store float* [[SFVAR6]], float** [[TMP18]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(%class.anon.0* noundef nonnull align 4 dereferenceable(16) [[REF_TMP]]), !llvm.access.group !9
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK4-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP6]])
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK4-NEXT:    br i1 [[TMP21]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK4-NEXT:    br i1 [[TMP23]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK4:       .omp.lastprivate.then:
// CHECK4-NEXT:    [[TMP24:%.*]] = load double, double* [[G2]], align 8
// CHECK4-NEXT:    store volatile double [[TMP24]], double* [[TMP1]], align 8
// CHECK4-NEXT:    [[TMP25:%.*]] = load double*, double** [[_TMP4]], align 4
// CHECK4-NEXT:    [[TMP26:%.*]] = load double, double* [[TMP25]], align 4
// CHECK4-NEXT:    store volatile double [[TMP26]], double* [[TMP4]], align 4
// CHECK4-NEXT:    [[TMP27:%.*]] = load i32, i32* [[SVAR5]], align 4
// CHECK4-NEXT:    store i32 [[TMP27]], i32* [[SVAR_ADDR]], align 4
// CHECK4-NEXT:    [[TMP28:%.*]] = load float, float* [[SFVAR6]], align 4
// CHECK4-NEXT:    store float [[TMP28]], float* [[CONV]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK4:       .omp.lastprivate.done:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK4-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK4-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@main
// CHECK5-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK5-NEXT:    [[G1:%.*]] = alloca double*, align 8
// CHECK5-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK5-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK5-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK5-NEXT:    [[VAR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK5-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK5-NEXT:    store double* [[G]], double** [[G1]], align 8
// CHECK5-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK5-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const.main.vec to i8*), i64 8, i1 false)
// CHECK5-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i64 0, i64 0
// CHECK5-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK5-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYINIT_BEGIN]], i64 1
// CHECK5-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK5-NEXT:    store %struct.S* [[TEST]], %struct.S** [[VAR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK5-NEXT:    store %struct.S* [[TMP1]], %struct.S** [[TMP]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[T_VAR]], align 4
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP2]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* @_ZZ4mainE4svar, align 4
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP5]], i32* [[CONV1]], align 4
// CHECK5-NEXT:    [[TMP6:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to [2 x i32]**
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP8]], align 8
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [2 x i32]**
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP10]], align 8
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK5-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP15]], align 8
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP16]], align 8
// CHECK5-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [2 x %struct.S]**
// CHECK5-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to [2 x %struct.S]**
// CHECK5-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[TMP20]], align 8
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP21]], align 8
// CHECK5-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to %struct.S**
// CHECK5-NEXT:    store %struct.S* [[TMP4]], %struct.S** [[TMP23]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to %struct.S**
// CHECK5-NEXT:    store %struct.S* [[TMP4]], %struct.S** [[TMP25]], align 8
// CHECK5-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK5-NEXT:    store i8* null, i8** [[TMP26]], align 8
// CHECK5-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK5-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to i64*
// CHECK5-NEXT:    store i64 [[TMP6]], i64* [[TMP28]], align 8
// CHECK5-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK5-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i64*
// CHECK5-NEXT:    store i64 [[TMP6]], i64* [[TMP30]], align 8
// CHECK5-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK5-NEXT:    store i8* null, i8** [[TMP31]], align 8
// CHECK5-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 2)
// CHECK5-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106.region_id, i32 5, i8** [[TMP32]], i8** [[TMP33]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK5-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK5-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106([2 x i32]* [[VEC]], i64 [[TMP3]], [2 x %struct.S]* [[S_ARR]], %struct.S* [[TMP4]], i64 [[TMP6]]) #[[ATTR4:[0-9]+]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z5tmainIiET_v()
// CHECK5-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK5-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i64 2
// CHECK5-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP36]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK5-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE3:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK5:       arraydestroy.done3:
// CHECK5-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK5-NEXT:    [[TMP37:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK5-NEXT:    ret i32 [[TMP37]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK5-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK5-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK5-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK5-NEXT:    call void @_ZN1SIfEC2Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106
// CHECK5-SAME: ([2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i64 noundef [[SVAR:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK5-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 8
// CHECK5-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK5-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK5-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV2:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP3]], i32* [[CONV2]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK5-NEXT:    [[CONV3:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP6]], i32* [[CONV3]], align 4
// CHECK5-NEXT:    [[TMP7:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [2 x i32]*, i64, [2 x %struct.S]*, %struct.S*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), [2 x i32]* [[TMP0]], i64 [[TMP4]], [2 x %struct.S]* [[TMP1]], %struct.S* [[TMP5]], i64 [[TMP7]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i64 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK5-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 8
// CHECK5-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[T_VAR3:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[VEC4:%.*]] = alloca [2 x i32], align 4
// CHECK5-NEXT:    [[S_ARR5:%.*]] = alloca [2 x %struct.S], align 4
// CHECK5-NEXT:    [[VAR6:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK5-NEXT:    [[_TMP7:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[SVAR8:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK5-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK5-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 8
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR5]], i32 0, i32 0
// CHECK5-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i64 2
// CHECK5-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK5:       arrayctor.loop:
// CHECK5-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK5-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK5-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i64 1
// CHECK5-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK5-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK5:       arrayctor.cont:
// CHECK5-NEXT:    [[TMP3:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK5-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR6]])
// CHECK5-NEXT:    store %struct.S* [[VAR6]], %struct.S** [[_TMP7]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK5-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK5:       omp.inner.for.cond.cleanup:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP11]] to i64
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP13]] to i64
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[T_VAR3]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[CONV10:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP15]], i32* [[CONV10]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[TMP16:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8, !llvm.access.group !5
// CHECK5-NEXT:    [[TMP17:%.*]] = load %struct.S*, %struct.S** [[_TMP7]], align 8, !llvm.access.group !5
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[SVAR8]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[CONV11:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP18]], i32* [[CONV11]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[TMP19:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8, !llvm.access.group !5
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [2 x i32]*, i64, [2 x %struct.S]*, %struct.S*, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP12]], i64 [[TMP14]], [2 x i32]* [[VEC4]], i64 [[TMP16]], [2 x %struct.S]* [[S_ARR5]], %struct.S* [[TMP17]], i64 [[TMP19]]), !llvm.access.group !5
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    [[TMP22:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[TMP22]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP23]])
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK5-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK5-NEXT:    br i1 [[TMP27]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK5:       .omp.lastprivate.then:
// CHECK5-NEXT:    [[TMP28:%.*]] = load i32, i32* [[T_VAR3]], align 4
// CHECK5-NEXT:    store i32 [[TMP28]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK5-NEXT:    [[TMP30:%.*]] = bitcast [2 x i32]* [[VEC4]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP29]], i8* align 4 [[TMP30]], i64 8, i1 false)
// CHECK5-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[TMP1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP31:%.*]] = bitcast [2 x %struct.S]* [[S_ARR5]] to %struct.S*
// CHECK5-NEXT:    [[TMP32:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN12]], i64 2
// CHECK5-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN12]], [[TMP32]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE13:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK5:       omp.arraycpy.body:
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP31]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN12]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK5-NEXT:    [[TMP33:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK5-NEXT:    [[TMP34:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP33]], i8* align 4 [[TMP34]], i64 4, i1 false)
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP32]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE13]], label [[OMP_ARRAYCPY_BODY]]
// CHECK5:       omp.arraycpy.done13:
// CHECK5-NEXT:    [[TMP35:%.*]] = load %struct.S*, %struct.S** [[_TMP7]], align 8
// CHECK5-NEXT:    [[TMP36:%.*]] = bitcast %struct.S* [[TMP3]] to i8*
// CHECK5-NEXT:    [[TMP37:%.*]] = bitcast %struct.S* [[TMP35]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP36]], i8* align 4 [[TMP37]], i64 4, i1 false)
// CHECK5-NEXT:    [[TMP38:%.*]] = load i32, i32* [[SVAR8]], align 4
// CHECK5-NEXT:    store i32 [[TMP38]], i32* [[CONV1]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK5:       .omp.lastprivate.done:
// CHECK5-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR6]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAY_BEGIN14:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR5]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN14]], i64 2
// CHECK5-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP39]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK5-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN14]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK5:       arraydestroy.done15:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i64 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK5-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 8
// CHECK5-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[T_VAR5:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[VEC6:%.*]] = alloca [2 x i32], align 4
// CHECK5-NEXT:    [[S_ARR7:%.*]] = alloca [2 x %struct.S], align 4
// CHECK5-NEXT:    [[VAR8:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK5-NEXT:    [[_TMP9:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[SVAR10:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK5-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK5-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 8
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK5-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP3]] to i32
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK5-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP4]] to i32
// CHECK5-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR7]], i32 0, i32 0
// CHECK5-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i64 2
// CHECK5-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK5:       arrayctor.loop:
// CHECK5-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK5-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK5-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i64 1
// CHECK5-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK5-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK5:       arrayctor.cont:
// CHECK5-NEXT:    [[TMP5:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK5-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR8]])
// CHECK5-NEXT:    store %struct.S* [[VAR8]], %struct.S** [[_TMP9]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK5-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK5:       omp.inner.for.cond.cleanup:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR5]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP15]] to i64
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC6]], i64 0, i64 [[IDXPROM]]
// CHECK5-NEXT:    store i32 [[TMP14]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[TMP16:%.*]] = load %struct.S*, %struct.S** [[_TMP9]], align 8, !llvm.access.group !9
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP17]] to i64
// CHECK5-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR7]], i64 0, i64 [[IDXPROM12]]
// CHECK5-NEXT:    [[TMP18:%.*]] = bitcast %struct.S* [[ARRAYIDX13]] to i8*
// CHECK5-NEXT:    [[TMP19:%.*]] = bitcast %struct.S* [[TMP16]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i64 4, i1 false), !llvm.access.group !9
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK5-NEXT:    store i32 [[ADD14]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK5-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK5-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK5:       .omp.lastprivate.then:
// CHECK5-NEXT:    [[TMP27:%.*]] = load i32, i32* [[T_VAR5]], align 4
// CHECK5-NEXT:    store i32 [[TMP27]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK5-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[VEC6]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP28]], i8* align 4 [[TMP29]], i64 8, i1 false)
// CHECK5-NEXT:    [[ARRAY_BEGIN15:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[TMP1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP30:%.*]] = bitcast [2 x %struct.S]* [[S_ARR7]] to %struct.S*
// CHECK5-NEXT:    [[TMP31:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN15]], i64 2
// CHECK5-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN15]], [[TMP31]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE16:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK5:       omp.arraycpy.body:
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP30]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN15]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK5-NEXT:    [[TMP32:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK5-NEXT:    [[TMP33:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i64 4, i1 false)
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP31]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE16]], label [[OMP_ARRAYCPY_BODY]]
// CHECK5:       omp.arraycpy.done16:
// CHECK5-NEXT:    [[TMP34:%.*]] = load %struct.S*, %struct.S** [[_TMP9]], align 8
// CHECK5-NEXT:    [[TMP35:%.*]] = bitcast %struct.S* [[TMP5]] to i8*
// CHECK5-NEXT:    [[TMP36:%.*]] = bitcast %struct.S* [[TMP34]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP35]], i8* align 4 [[TMP36]], i64 4, i1 false)
// CHECK5-NEXT:    [[TMP37:%.*]] = load i32, i32* [[SVAR10]], align 4
// CHECK5-NEXT:    store i32 [[TMP37]], i32* [[CONV1]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK5:       .omp.lastprivate.done:
// CHECK5-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR8]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAY_BEGIN17:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR7]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN17]], i64 2
// CHECK5-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP38]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK5-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN17]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE18:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK5:       arraydestroy.done18:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK5-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK5-SAME: () #[[ATTR5:[0-9]+]] comdat {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK5-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK5-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK5-NEXT:    [[VAR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK5-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK5-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const._Z5tmainIiET_v.vec to i8*), i64 8, i1 false)
// CHECK5-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i64 0, i64 0
// CHECK5-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef signext 1)
// CHECK5-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYINIT_BEGIN]], i64 1
// CHECK5-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef signext 2)
// CHECK5-NEXT:    store %struct.S.0* [[TEST]], %struct.S.0** [[VAR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK5-NEXT:    store %struct.S.0* [[TMP1]], %struct.S.0** [[TMP]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[T_VAR]], align 4
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP2]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to [2 x i32]**
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP6]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to [2 x i32]**
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP8]], align 8
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK5-NEXT:    store i8* null, i8** [[TMP9]], align 8
// CHECK5-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP11]], align 8
// CHECK5-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK5-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK5-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK5-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [2 x %struct.S.0]**
// CHECK5-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[TMP16]], align 8
// CHECK5-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK5-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [2 x %struct.S.0]**
// CHECK5-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[TMP18]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK5-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK5-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to %struct.S.0**
// CHECK5-NEXT:    store %struct.S.0* [[TMP4]], %struct.S.0** [[TMP21]], align 8
// CHECK5-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK5-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to %struct.S.0**
// CHECK5-NEXT:    store %struct.S.0* [[TMP4]], %struct.S.0** [[TMP23]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK5-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK5-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK5-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 2)
// CHECK5-NEXT:    [[TMP27:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50.region_id, i32 4, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK5-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK5-NEXT:    br i1 [[TMP28]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK5:       omp_offload.failed:
// CHECK5-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50([2 x i32]* [[VEC]], i64 [[TMP3]], [2 x %struct.S.0]* [[S_ARR]], %struct.S.0* [[TMP4]]) #[[ATTR4]]
// CHECK5-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK5:       omp_offload.cont:
// CHECK5-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK5-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i64 2
// CHECK5-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP29]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK5-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK5:       arraydestroy.done2:
// CHECK5-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK5-NEXT:    [[TMP30:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK5-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK5-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK5-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK5-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK5-NEXT:    store float [[TMP0]], float* [[F]], align 4
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK5-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK5-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK5-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK5-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK5-NEXT:    call void @_ZN1SIiEC2Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef signext [[TMP0]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50
// CHECK5-SAME: ([2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK5-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 8
// CHECK5-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK5-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK5-NEXT:    [[CONV1:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP3]], i32* [[CONV1]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [2 x i32]*, i64, [2 x %struct.S.0]*, %struct.S.0*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), [2 x i32]* [[TMP0]], i64 [[TMP4]], [2 x %struct.S.0]* [[TMP1]], %struct.S.0* [[TMP5]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK5-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 8
// CHECK5-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK5-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK5-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK5-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK5-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 8
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK5-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i64 2
// CHECK5-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK5:       arrayctor.loop:
// CHECK5-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK5-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK5-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i64 1
// CHECK5-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK5-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK5:       arrayctor.cont:
// CHECK5-NEXT:    [[TMP3:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK5-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK5-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK5-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK5:       omp.inner.for.cond.cleanup:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP11]] to i64
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP13]] to i64
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    [[CONV8:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK5-NEXT:    store i32 [[TMP15]], i32* [[CONV8]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    [[TMP16:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8, !llvm.access.group !14
// CHECK5-NEXT:    [[TMP17:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 8, !llvm.access.group !14
// CHECK5-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [2 x i32]*, i64, [2 x %struct.S.0]*, %struct.S.0*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP12]], i64 [[TMP14]], [2 x i32]* [[VEC3]], i64 [[TMP16]], [2 x %struct.S.0]* [[S_ARR4]], %struct.S.0* [[TMP17]]), !llvm.access.group !14
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK5-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK5-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK5-NEXT:    br i1 [[TMP25]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK5:       .omp.lastprivate.then:
// CHECK5-NEXT:    [[TMP26:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK5-NEXT:    store i32 [[TMP26]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP27:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK5-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP27]], i8* align 4 [[TMP28]], i64 8, i1 false)
// CHECK5-NEXT:    [[ARRAY_BEGIN9:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[TMP1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP29:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK5-NEXT:    [[TMP30:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN9]], i64 2
// CHECK5-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN9]], [[TMP30]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE10:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK5:       omp.arraycpy.body:
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP29]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN9]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK5-NEXT:    [[TMP31:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK5-NEXT:    [[TMP32:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP31]], i8* align 4 [[TMP32]], i64 4, i1 false)
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP30]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE10]], label [[OMP_ARRAYCPY_BODY]]
// CHECK5:       omp.arraycpy.done10:
// CHECK5-NEXT:    [[TMP33:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 8
// CHECK5-NEXT:    [[TMP34:%.*]] = bitcast %struct.S.0* [[TMP3]] to i8*
// CHECK5-NEXT:    [[TMP35:%.*]] = bitcast %struct.S.0* [[TMP33]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP34]], i8* align 4 [[TMP35]], i64 4, i1 false)
// CHECK5-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK5:       .omp.lastprivate.done:
// CHECK5-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN11]], i64 2
// CHECK5-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP36]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK5-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK5:       arraydestroy.done12:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK5-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK5-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK5-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 8
// CHECK5-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[T_VAR4:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[VEC5:%.*]] = alloca [2 x i32], align 4
// CHECK5-NEXT:    [[S_ARR6:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK5-NEXT:    [[VAR7:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK5-NEXT:    [[_TMP8:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK5-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK5-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK5-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK5-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 8
// CHECK5-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 8
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK5-NEXT:    [[CONV2:%.*]] = trunc i64 [[TMP3]] to i32
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK5-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP4]] to i32
// CHECK5-NEXT:    store i32 [[CONV2]], i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR6]], i32 0, i32 0
// CHECK5-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i64 2
// CHECK5-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK5:       arrayctor.loop:
// CHECK5-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK5-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK5-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i64 1
// CHECK5-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK5-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK5:       arrayctor.cont:
// CHECK5-NEXT:    [[TMP5:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK5-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR7]])
// CHECK5-NEXT:    store %struct.S.0* [[VAR7]], %struct.S.0** [[_TMP8]], align 8
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK5-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK5:       cond.true:
// CHECK5-NEXT:    br label [[COND_END:%.*]]
// CHECK5:       cond.false:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    br label [[COND_END]]
// CHECK5:       cond.end:
// CHECK5-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK5-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK5-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK5:       omp.inner.for.cond.cleanup:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR4]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP15]] to i64
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC5]], i64 0, i64 [[IDXPROM]]
// CHECK5-NEXT:    store i32 [[TMP14]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[TMP16:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP8]], align 8, !llvm.access.group !17
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP17]] to i64
// CHECK5-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR6]], i64 0, i64 [[IDXPROM10]]
// CHECK5-NEXT:    [[TMP18:%.*]] = bitcast %struct.S.0* [[ARRAYIDX11]] to i8*
// CHECK5-NEXT:    [[TMP19:%.*]] = bitcast %struct.S.0* [[TMP16]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i64 4, i1 false), !llvm.access.group !17
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK5-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP18:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK5:       omp.loop.exit:
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK5-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK5-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK5:       .omp.final.then:
// CHECK5-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK5-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK5:       .omp.final.done:
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK5-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK5-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK5:       .omp.lastprivate.then:
// CHECK5-NEXT:    [[TMP27:%.*]] = load i32, i32* [[T_VAR4]], align 4
// CHECK5-NEXT:    store i32 [[TMP27]], i32* [[CONV]], align 4
// CHECK5-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK5-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[VEC5]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP28]], i8* align 4 [[TMP29]], i64 8, i1 false)
// CHECK5-NEXT:    [[ARRAY_BEGIN13:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[TMP1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP30:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR6]] to %struct.S.0*
// CHECK5-NEXT:    [[TMP31:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN13]], i64 2
// CHECK5-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN13]], [[TMP31]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE14:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK5:       omp.arraycpy.body:
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP30]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN13]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK5-NEXT:    [[TMP32:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK5-NEXT:    [[TMP33:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i64 4, i1 false)
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP31]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE14]], label [[OMP_ARRAYCPY_BODY]]
// CHECK5:       omp.arraycpy.done14:
// CHECK5-NEXT:    [[TMP34:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP8]], align 8
// CHECK5-NEXT:    [[TMP35:%.*]] = bitcast %struct.S.0* [[TMP5]] to i8*
// CHECK5-NEXT:    [[TMP36:%.*]] = bitcast %struct.S.0* [[TMP34]] to i8*
// CHECK5-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP35]], i8* align 4 [[TMP36]], i64 4, i1 false)
// CHECK5-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK5:       .omp.lastprivate.done:
// CHECK5-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR7]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAY_BEGIN15:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR6]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN15]], i64 2
// CHECK5-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP37]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK5-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN15]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE16:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK5:       arraydestroy.done16:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK5-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK5-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK5-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP0]], i32* [[F]], align 4
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK5-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK5-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK5-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK5-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@main
// CHECK6-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK6-NEXT:    [[G1:%.*]] = alloca double*, align 8
// CHECK6-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK6-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK6-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK6-NEXT:    [[VAR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK6-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK6-NEXT:    store double* [[G]], double** [[G1]], align 8
// CHECK6-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK6-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK6-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const.main.vec to i8*), i64 8, i1 false)
// CHECK6-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i64 0, i64 0
// CHECK6-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK6-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYINIT_BEGIN]], i64 1
// CHECK6-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK6-NEXT:    store %struct.S* [[TEST]], %struct.S** [[VAR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK6-NEXT:    store %struct.S* [[TMP1]], %struct.S** [[TMP]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load i32, i32* [[T_VAR]], align 4
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP2]], i32* [[CONV]], align 4
// CHECK6-NEXT:    [[TMP3:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, i32* @_ZZ4mainE4svar, align 4
// CHECK6-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP5]], i32* [[CONV1]], align 4
// CHECK6-NEXT:    [[TMP6:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8
// CHECK6-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to [2 x i32]**
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP8]], align 8
// CHECK6-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [2 x i32]**
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP10]], align 8
// CHECK6-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK6-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK6-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK6-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK6-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK6-NEXT:    store i64 [[TMP3]], i64* [[TMP15]], align 8
// CHECK6-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK6-NEXT:    store i8* null, i8** [[TMP16]], align 8
// CHECK6-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [2 x %struct.S]**
// CHECK6-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[TMP18]], align 8
// CHECK6-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to [2 x %struct.S]**
// CHECK6-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[TMP20]], align 8
// CHECK6-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK6-NEXT:    store i8* null, i8** [[TMP21]], align 8
// CHECK6-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to %struct.S**
// CHECK6-NEXT:    store %struct.S* [[TMP4]], %struct.S** [[TMP23]], align 8
// CHECK6-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to %struct.S**
// CHECK6-NEXT:    store %struct.S* [[TMP4]], %struct.S** [[TMP25]], align 8
// CHECK6-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK6-NEXT:    store i8* null, i8** [[TMP26]], align 8
// CHECK6-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK6-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to i64*
// CHECK6-NEXT:    store i64 [[TMP6]], i64* [[TMP28]], align 8
// CHECK6-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK6-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i64*
// CHECK6-NEXT:    store i64 [[TMP6]], i64* [[TMP30]], align 8
// CHECK6-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK6-NEXT:    store i8* null, i8** [[TMP31]], align 8
// CHECK6-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 2)
// CHECK6-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106.region_id, i32 5, i8** [[TMP32]], i8** [[TMP33]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK6-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK6-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK6:       omp_offload.failed:
// CHECK6-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106([2 x i32]* [[VEC]], i64 [[TMP3]], [2 x %struct.S]* [[S_ARR]], %struct.S* [[TMP4]], i64 [[TMP6]]) #[[ATTR4:[0-9]+]]
// CHECK6-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK6:       omp_offload.cont:
// CHECK6-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z5tmainIiET_v()
// CHECK6-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK6-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i64 2
// CHECK6-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK6:       arraydestroy.body:
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP36]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK6-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK6-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE3:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK6:       arraydestroy.done3:
// CHECK6-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK6-NEXT:    [[TMP37:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK6-NEXT:    ret i32 [[TMP37]]
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK6-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK6-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK6-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK6-NEXT:    call void @_ZN1SIfEC2Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106
// CHECK6-SAME: ([2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i64 noundef [[SVAR:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK6-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 8
// CHECK6-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK6-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK6-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK6-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK6-NEXT:    [[CONV2:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP3]], i32* [[CONV2]], align 4
// CHECK6-NEXT:    [[TMP4:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8
// CHECK6-NEXT:    [[TMP5:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK6-NEXT:    [[CONV3:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP6]], i32* [[CONV3]], align 4
// CHECK6-NEXT:    [[TMP7:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [2 x i32]*, i64, [2 x %struct.S]*, %struct.S*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), [2 x i32]* [[TMP0]], i64 [[TMP4]], [2 x %struct.S]* [[TMP1]], %struct.S* [[TMP5]], i64 [[TMP7]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK6-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i64 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK6-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 8
// CHECK6-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[T_VAR3:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[VEC4:%.*]] = alloca [2 x i32], align 4
// CHECK6-NEXT:    [[S_ARR5:%.*]] = alloca [2 x %struct.S], align 4
// CHECK6-NEXT:    [[VAR6:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK6-NEXT:    [[_TMP7:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[SVAR8:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK6-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK6-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK6-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 8
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR5]], i32 0, i32 0
// CHECK6-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i64 2
// CHECK6-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK6:       arrayctor.loop:
// CHECK6-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK6-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK6-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i64 1
// CHECK6-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK6-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK6:       arrayctor.cont:
// CHECK6-NEXT:    [[TMP3:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK6-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR6]])
// CHECK6-NEXT:    store %struct.S* [[VAR6]], %struct.S** [[_TMP7]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK6-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK6-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK6:       omp.inner.for.cond.cleanup:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP11]] to i64
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP13]] to i64
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[T_VAR3]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[CONV10:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP15]], i32* [[CONV10]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[TMP16:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8, !llvm.access.group !5
// CHECK6-NEXT:    [[TMP17:%.*]] = load %struct.S*, %struct.S** [[_TMP7]], align 8, !llvm.access.group !5
// CHECK6-NEXT:    [[TMP18:%.*]] = load i32, i32* [[SVAR8]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[CONV11:%.*]] = bitcast i64* [[SVAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP18]], i32* [[CONV11]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[TMP19:%.*]] = load i64, i64* [[SVAR_CASTED]], align 8, !llvm.access.group !5
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [2 x i32]*, i64, [2 x %struct.S]*, %struct.S*, i64)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i64 [[TMP12]], i64 [[TMP14]], [2 x i32]* [[VEC4]], i64 [[TMP16]], [2 x %struct.S]* [[S_ARR5]], %struct.S* [[TMP17]], i64 [[TMP19]]), !llvm.access.group !5
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK6:       omp.loop.exit:
// CHECK6-NEXT:    [[TMP22:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, i32* [[TMP22]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP23]])
// CHECK6-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK6-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    [[TMP26:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK6-NEXT:    br i1 [[TMP27]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK6:       .omp.lastprivate.then:
// CHECK6-NEXT:    [[TMP28:%.*]] = load i32, i32* [[T_VAR3]], align 4
// CHECK6-NEXT:    store i32 [[TMP28]], i32* [[CONV]], align 4
// CHECK6-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK6-NEXT:    [[TMP30:%.*]] = bitcast [2 x i32]* [[VEC4]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP29]], i8* align 4 [[TMP30]], i64 8, i1 false)
// CHECK6-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[TMP1]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP31:%.*]] = bitcast [2 x %struct.S]* [[S_ARR5]] to %struct.S*
// CHECK6-NEXT:    [[TMP32:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN12]], i64 2
// CHECK6-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN12]], [[TMP32]]
// CHECK6-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE13:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK6:       omp.arraycpy.body:
// CHECK6-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP31]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN12]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK6-NEXT:    [[TMP33:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK6-NEXT:    [[TMP34:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP33]], i8* align 4 [[TMP34]], i64 4, i1 false)
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK6-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP32]]
// CHECK6-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE13]], label [[OMP_ARRAYCPY_BODY]]
// CHECK6:       omp.arraycpy.done13:
// CHECK6-NEXT:    [[TMP35:%.*]] = load %struct.S*, %struct.S** [[_TMP7]], align 8
// CHECK6-NEXT:    [[TMP36:%.*]] = bitcast %struct.S* [[TMP3]] to i8*
// CHECK6-NEXT:    [[TMP37:%.*]] = bitcast %struct.S* [[TMP35]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP36]], i8* align 4 [[TMP37]], i64 4, i1 false)
// CHECK6-NEXT:    [[TMP38:%.*]] = load i32, i32* [[SVAR8]], align 4
// CHECK6-NEXT:    store i32 [[TMP38]], i32* [[CONV1]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK6:       .omp.lastprivate.done:
// CHECK6-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR6]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAY_BEGIN14:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR5]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN14]], i64 2
// CHECK6-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK6:       arraydestroy.body:
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP39]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK6-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN14]]
// CHECK6-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE15:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK6:       arraydestroy.done15:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK6-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i64 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK6-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 8
// CHECK6-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[T_VAR5:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[VEC6:%.*]] = alloca [2 x i32], align 4
// CHECK6-NEXT:    [[S_ARR7:%.*]] = alloca [2 x %struct.S], align 4
// CHECK6-NEXT:    [[VAR8:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK6-NEXT:    [[_TMP9:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[SVAR10:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK6-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK6-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[SVAR]], i64* [[SVAR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK6-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    [[CONV1:%.*]] = bitcast i64* [[SVAR_ADDR]] to i32*
// CHECK6-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 8
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK6-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP3]] to i32
// CHECK6-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK6-NEXT:    [[CONV4:%.*]] = trunc i64 [[TMP4]] to i32
// CHECK6-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[CONV4]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR7]], i32 0, i32 0
// CHECK6-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i64 2
// CHECK6-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK6:       arrayctor.loop:
// CHECK6-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK6-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK6-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i64 1
// CHECK6-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK6-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK6:       arrayctor.cont:
// CHECK6-NEXT:    [[TMP5:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK6-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR8]])
// CHECK6-NEXT:    store %struct.S* [[VAR8]], %struct.S** [[_TMP9]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK6-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[CMP11:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK6-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK6:       omp.inner.for.cond.cleanup:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR5]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP15]] to i64
// CHECK6-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC6]], i64 0, i64 [[IDXPROM]]
// CHECK6-NEXT:    store i32 [[TMP14]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[TMP16:%.*]] = load %struct.S*, %struct.S** [[_TMP9]], align 8, !llvm.access.group !9
// CHECK6-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP17]] to i64
// CHECK6-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR7]], i64 0, i64 [[IDXPROM12]]
// CHECK6-NEXT:    [[TMP18:%.*]] = bitcast %struct.S* [[ARRAYIDX13]] to i8*
// CHECK6-NEXT:    [[TMP19:%.*]] = bitcast %struct.S* [[TMP16]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i64 4, i1 false), !llvm.access.group !9
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK6-NEXT:    store i32 [[ADD14]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK6:       omp.loop.exit:
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK6-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK6-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK6:       .omp.lastprivate.then:
// CHECK6-NEXT:    [[TMP27:%.*]] = load i32, i32* [[T_VAR5]], align 4
// CHECK6-NEXT:    store i32 [[TMP27]], i32* [[CONV]], align 4
// CHECK6-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK6-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[VEC6]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP28]], i8* align 4 [[TMP29]], i64 8, i1 false)
// CHECK6-NEXT:    [[ARRAY_BEGIN15:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[TMP1]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP30:%.*]] = bitcast [2 x %struct.S]* [[S_ARR7]] to %struct.S*
// CHECK6-NEXT:    [[TMP31:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN15]], i64 2
// CHECK6-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN15]], [[TMP31]]
// CHECK6-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE16:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK6:       omp.arraycpy.body:
// CHECK6-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP30]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN15]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK6-NEXT:    [[TMP32:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK6-NEXT:    [[TMP33:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i64 4, i1 false)
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK6-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP31]]
// CHECK6-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE16]], label [[OMP_ARRAYCPY_BODY]]
// CHECK6:       omp.arraycpy.done16:
// CHECK6-NEXT:    [[TMP34:%.*]] = load %struct.S*, %struct.S** [[_TMP9]], align 8
// CHECK6-NEXT:    [[TMP35:%.*]] = bitcast %struct.S* [[TMP5]] to i8*
// CHECK6-NEXT:    [[TMP36:%.*]] = bitcast %struct.S* [[TMP34]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP35]], i8* align 4 [[TMP36]], i64 4, i1 false)
// CHECK6-NEXT:    [[TMP37:%.*]] = load i32, i32* [[SVAR10]], align 4
// CHECK6-NEXT:    store i32 [[TMP37]], i32* [[CONV1]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK6:       .omp.lastprivate.done:
// CHECK6-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR8]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAY_BEGIN17:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR7]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN17]], i64 2
// CHECK6-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK6:       arraydestroy.body:
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP38]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK6-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN17]]
// CHECK6-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE18:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK6:       arraydestroy.done18:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK6-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK6-SAME: () #[[ATTR5:[0-9]+]] comdat {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK6-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK6-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK6-NEXT:    [[VAR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK6-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK6-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK6-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const._Z5tmainIiET_v.vec to i8*), i64 8, i1 false)
// CHECK6-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i64 0, i64 0
// CHECK6-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef signext 1)
// CHECK6-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYINIT_BEGIN]], i64 1
// CHECK6-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef signext 2)
// CHECK6-NEXT:    store %struct.S.0* [[TEST]], %struct.S.0** [[VAR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK6-NEXT:    store %struct.S.0* [[TMP1]], %struct.S.0** [[TMP]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load i32, i32* [[T_VAR]], align 4
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP2]], i32* [[CONV]], align 4
// CHECK6-NEXT:    [[TMP3:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK6-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to [2 x i32]**
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP6]], align 8
// CHECK6-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to [2 x i32]**
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP8]], align 8
// CHECK6-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK6-NEXT:    store i8* null, i8** [[TMP9]], align 8
// CHECK6-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK6-NEXT:    store i64 [[TMP3]], i64* [[TMP11]], align 8
// CHECK6-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK6-NEXT:    store i64 [[TMP3]], i64* [[TMP13]], align 8
// CHECK6-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK6-NEXT:    store i8* null, i8** [[TMP14]], align 8
// CHECK6-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [2 x %struct.S.0]**
// CHECK6-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[TMP16]], align 8
// CHECK6-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK6-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [2 x %struct.S.0]**
// CHECK6-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[TMP18]], align 8
// CHECK6-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK6-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK6-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to %struct.S.0**
// CHECK6-NEXT:    store %struct.S.0* [[TMP4]], %struct.S.0** [[TMP21]], align 8
// CHECK6-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK6-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to %struct.S.0**
// CHECK6-NEXT:    store %struct.S.0* [[TMP4]], %struct.S.0** [[TMP23]], align 8
// CHECK6-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK6-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK6-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK6-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 2)
// CHECK6-NEXT:    [[TMP27:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50.region_id, i32 4, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK6-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK6-NEXT:    br i1 [[TMP28]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK6:       omp_offload.failed:
// CHECK6-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50([2 x i32]* [[VEC]], i64 [[TMP3]], [2 x %struct.S.0]* [[S_ARR]], %struct.S.0* [[TMP4]]) #[[ATTR4]]
// CHECK6-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK6:       omp_offload.cont:
// CHECK6-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK6-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i64 2
// CHECK6-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK6:       arraydestroy.body:
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP29]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK6-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK6-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK6:       arraydestroy.done2:
// CHECK6-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK6-NEXT:    [[TMP30:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK6-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK6-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK6-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK6-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK6-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK6-NEXT:    store float [[TMP0]], float* [[F]], align 4
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK6-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK6-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK6-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK6-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK6-NEXT:    call void @_ZN1SIiEC2Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef signext [[TMP0]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50
// CHECK6-SAME: ([2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK6-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 8
// CHECK6-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK6-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK6-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK6-NEXT:    [[CONV1:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP3]], i32* [[CONV1]], align 4
// CHECK6-NEXT:    [[TMP4:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8
// CHECK6-NEXT:    [[TMP5:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [2 x i32]*, i64, [2 x %struct.S.0]*, %struct.S.0*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), [2 x i32]* [[TMP0]], i64 [[TMP4]], [2 x %struct.S.0]* [[TMP1]], %struct.S.0* [[TMP5]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK6-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK6-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 8
// CHECK6-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK6-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK6-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK6-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK6-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK6-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 8
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK6-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i64 2
// CHECK6-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK6:       arrayctor.loop:
// CHECK6-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK6-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK6-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i64 1
// CHECK6-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK6-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK6:       arrayctor.cont:
// CHECK6-NEXT:    [[TMP3:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK6-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK6-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK6-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK6-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK6:       omp.inner.for.cond.cleanup:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP11]] to i64
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP13]] to i64
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    [[CONV8:%.*]] = bitcast i64* [[T_VAR_CASTED]] to i32*
// CHECK6-NEXT:    store i32 [[TMP15]], i32* [[CONV8]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    [[TMP16:%.*]] = load i64, i64* [[T_VAR_CASTED]], align 8, !llvm.access.group !14
// CHECK6-NEXT:    [[TMP17:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 8, !llvm.access.group !14
// CHECK6-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i64, i64, [2 x i32]*, i64, [2 x %struct.S.0]*, %struct.S.0*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i64 [[TMP12]], i64 [[TMP14]], [2 x i32]* [[VEC3]], i64 [[TMP16]], [2 x %struct.S.0]* [[S_ARR4]], %struct.S.0* [[TMP17]]), !llvm.access.group !14
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK6:       omp.loop.exit:
// CHECK6-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK6-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK6-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK6-NEXT:    br i1 [[TMP25]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK6:       .omp.lastprivate.then:
// CHECK6-NEXT:    [[TMP26:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK6-NEXT:    store i32 [[TMP26]], i32* [[CONV]], align 4
// CHECK6-NEXT:    [[TMP27:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK6-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP27]], i8* align 4 [[TMP28]], i64 8, i1 false)
// CHECK6-NEXT:    [[ARRAY_BEGIN9:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[TMP1]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP29:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK6-NEXT:    [[TMP30:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN9]], i64 2
// CHECK6-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN9]], [[TMP30]]
// CHECK6-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE10:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK6:       omp.arraycpy.body:
// CHECK6-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP29]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN9]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK6-NEXT:    [[TMP31:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK6-NEXT:    [[TMP32:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP31]], i8* align 4 [[TMP32]], i64 4, i1 false)
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK6-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP30]]
// CHECK6-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE10]], label [[OMP_ARRAYCPY_BODY]]
// CHECK6:       omp.arraycpy.done10:
// CHECK6-NEXT:    [[TMP33:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 8
// CHECK6-NEXT:    [[TMP34:%.*]] = bitcast %struct.S.0* [[TMP3]] to i8*
// CHECK6-NEXT:    [[TMP35:%.*]] = bitcast %struct.S.0* [[TMP33]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP34]], i8* align 4 [[TMP35]], i64 4, i1 false)
// CHECK6-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK6:       .omp.lastprivate.done:
// CHECK6-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN11]], i64 2
// CHECK6-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK6:       arraydestroy.body:
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP36]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK6-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK6-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK6:       arraydestroy.done12:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK6-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK6-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 8
// CHECK6-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 8
// CHECK6-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[T_VAR4:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[VEC5:%.*]] = alloca [2 x i32], align 4
// CHECK6-NEXT:    [[S_ARR6:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK6-NEXT:    [[VAR7:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK6-NEXT:    [[_TMP8:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK6-NEXT:    store i64 [[DOTPREVIOUS_LB_]], i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK6-NEXT:    store i64 [[DOTPREVIOUS_UB_]], i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK6-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    store i64 [[T_VAR]], i64* [[T_VAR_ADDR]], align 8
// CHECK6-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = bitcast i64* [[T_VAR_ADDR]] to i32*
// CHECK6-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 8
// CHECK6-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 8
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK6-NEXT:    [[CONV2:%.*]] = trunc i64 [[TMP3]] to i32
// CHECK6-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK6-NEXT:    [[CONV3:%.*]] = trunc i64 [[TMP4]] to i32
// CHECK6-NEXT:    store i32 [[CONV2]], i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[CONV3]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR6]], i32 0, i32 0
// CHECK6-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i64 2
// CHECK6-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK6:       arrayctor.loop:
// CHECK6-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK6-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK6-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i64 1
// CHECK6-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK6-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK6:       arrayctor.cont:
// CHECK6-NEXT:    [[TMP5:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK6-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR7]])
// CHECK6-NEXT:    store %struct.S.0* [[VAR7]], %struct.S.0** [[_TMP8]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK6-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK6:       cond.true:
// CHECK6-NEXT:    br label [[COND_END:%.*]]
// CHECK6:       cond.false:
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    br label [[COND_END]]
// CHECK6:       cond.end:
// CHECK6-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK6-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK6-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK6:       omp.inner.for.cond.cleanup:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR4]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP15]] to i64
// CHECK6-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC5]], i64 0, i64 [[IDXPROM]]
// CHECK6-NEXT:    store i32 [[TMP14]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[TMP16:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP8]], align 8, !llvm.access.group !17
// CHECK6-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP17]] to i64
// CHECK6-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR6]], i64 0, i64 [[IDXPROM10]]
// CHECK6-NEXT:    [[TMP18:%.*]] = bitcast %struct.S.0* [[ARRAYIDX11]] to i8*
// CHECK6-NEXT:    [[TMP19:%.*]] = bitcast %struct.S.0* [[TMP16]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i64 4, i1 false), !llvm.access.group !17
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK6-NEXT:    store i32 [[ADD12]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !17
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP18:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK6:       omp.loop.exit:
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK6-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK6-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK6-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK6:       .omp.final.then:
// CHECK6-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK6-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK6:       .omp.final.done:
// CHECK6-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK6-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK6-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK6:       .omp.lastprivate.then:
// CHECK6-NEXT:    [[TMP27:%.*]] = load i32, i32* [[T_VAR4]], align 4
// CHECK6-NEXT:    store i32 [[TMP27]], i32* [[CONV]], align 4
// CHECK6-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK6-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[VEC5]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP28]], i8* align 4 [[TMP29]], i64 8, i1 false)
// CHECK6-NEXT:    [[ARRAY_BEGIN13:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[TMP1]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP30:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR6]] to %struct.S.0*
// CHECK6-NEXT:    [[TMP31:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN13]], i64 2
// CHECK6-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN13]], [[TMP31]]
// CHECK6-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE14:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK6:       omp.arraycpy.body:
// CHECK6-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP30]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN13]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK6-NEXT:    [[TMP32:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK6-NEXT:    [[TMP33:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i64 4, i1 false)
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK6-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK6-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP31]]
// CHECK6-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE14]], label [[OMP_ARRAYCPY_BODY]]
// CHECK6:       omp.arraycpy.done14:
// CHECK6-NEXT:    [[TMP34:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP8]], align 8
// CHECK6-NEXT:    [[TMP35:%.*]] = bitcast %struct.S.0* [[TMP5]] to i8*
// CHECK6-NEXT:    [[TMP36:%.*]] = bitcast %struct.S.0* [[TMP34]] to i8*
// CHECK6-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP35]], i8* align 4 [[TMP36]], i64 4, i1 false)
// CHECK6-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK6:       .omp.lastprivate.done:
// CHECK6-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR7]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAY_BEGIN15:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR6]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN15]], i64 2
// CHECK6-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK6:       arraydestroy.body:
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP37]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK6-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK6-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK6-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN15]]
// CHECK6-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE16:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK6:       arraydestroy.done16:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK6-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK6-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK6-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK6-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK6-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP0]], i32* [[F]], align 4
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK6-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK6-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK6-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK6-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@main
// CHECK7-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK7-NEXT:    [[G1:%.*]] = alloca double*, align 4
// CHECK7-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK7-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK7-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK7-NEXT:    [[VAR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK7-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK7-NEXT:    store double* [[G]], double** [[G1]], align 4
// CHECK7-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK7-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const.main.vec to i8*), i32 8, i1 false)
// CHECK7-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK7-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK7-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYINIT_BEGIN]], i32 1
// CHECK7-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK7-NEXT:    store %struct.S* [[TEST]], %struct.S** [[VAR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK7-NEXT:    store %struct.S* [[TMP1]], %struct.S** [[TMP]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[T_VAR]], align 4
// CHECK7-NEXT:    store i32 [[TMP2]], i32* [[T_VAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* @_ZZ4mainE4svar, align 4
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[SVAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to [2 x i32]**
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP8]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [2 x i32]**
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP10]], align 4
// CHECK7-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP15]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP16]], align 4
// CHECK7-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [2 x %struct.S]**
// CHECK7-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[TMP18]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to [2 x %struct.S]**
// CHECK7-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[TMP20]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP21]], align 4
// CHECK7-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to %struct.S**
// CHECK7-NEXT:    store %struct.S* [[TMP4]], %struct.S** [[TMP23]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to %struct.S**
// CHECK7-NEXT:    store %struct.S* [[TMP4]], %struct.S** [[TMP25]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK7-NEXT:    store i8* null, i8** [[TMP26]], align 4
// CHECK7-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK7-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to i32*
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[TMP28]], align 4
// CHECK7-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK7-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32*
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[TMP30]], align 4
// CHECK7-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK7-NEXT:    store i8* null, i8** [[TMP31]], align 4
// CHECK7-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 2)
// CHECK7-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106.region_id, i32 5, i8** [[TMP32]], i8** [[TMP33]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK7-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK7-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106([2 x i32]* [[VEC]], i32 [[TMP3]], [2 x %struct.S]* [[S_ARR]], %struct.S* [[TMP4]], i32 [[TMP6]]) #[[ATTR4:[0-9]+]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK7-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK7-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i32 2
// CHECK7-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK7:       arraydestroy.body:
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP36]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK7-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK7-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK7:       arraydestroy.done2:
// CHECK7-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK7-NEXT:    [[TMP37:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK7-NEXT:    ret i32 [[TMP37]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK7-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK7-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK7-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK7-NEXT:    call void @_ZN1SIfEC2Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106
// CHECK7-SAME: ([2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i32 noundef [[SVAR:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK7-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 4
// CHECK7-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[T_VAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[SVAR_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[SVAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [2 x i32]*, i32, [2 x %struct.S]*, %struct.S*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), [2 x i32]* [[TMP0]], i32 [[TMP4]], [2 x %struct.S]* [[TMP1]], %struct.S* [[TMP5]], i32 [[TMP7]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i32 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK7-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 4
// CHECK7-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK7-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK7-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK7-NEXT:    [[_TMP6:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[SVAR7:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK7-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i32 2
// CHECK7-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK7:       arrayctor.loop:
// CHECK7-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK7-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK7-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i32 1
// CHECK7-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK7-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK7:       arrayctor.cont:
// CHECK7-NEXT:    [[TMP3:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK7-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK7-NEXT:    store %struct.S* [[VAR5]], %struct.S** [[_TMP6]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK7-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK7:       omp.inner.for.cond.cleanup:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    store i32 [[TMP13]], i32* [[T_VAR_CASTED]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[TMP15:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[SVAR7]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    store i32 [[TMP16]], i32* [[SVAR_CASTED]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [2 x i32]*, i32, [2 x %struct.S]*, %struct.S*, i32)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP11]], i32 [[TMP12]], [2 x i32]* [[VEC3]], i32 [[TMP14]], [2 x %struct.S]* [[S_ARR4]], %struct.S* [[TMP15]], i32 [[TMP17]]), !llvm.access.group !6
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK7-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK7-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK7-NEXT:    br i1 [[TMP25]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK7:       .omp.lastprivate.then:
// CHECK7-NEXT:    [[TMP26:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK7-NEXT:    store i32 [[TMP26]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP27:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK7-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP27]], i8* align 4 [[TMP28]], i32 8, i1 false)
// CHECK7-NEXT:    [[ARRAY_BEGIN9:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[TMP1]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP29:%.*]] = bitcast [2 x %struct.S]* [[S_ARR4]] to %struct.S*
// CHECK7-NEXT:    [[TMP30:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN9]], i32 2
// CHECK7-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN9]], [[TMP30]]
// CHECK7-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE10:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK7:       omp.arraycpy.body:
// CHECK7-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP29]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN9]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK7-NEXT:    [[TMP31:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK7-NEXT:    [[TMP32:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP31]], i8* align 4 [[TMP32]], i32 4, i1 false)
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK7-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP30]]
// CHECK7-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE10]], label [[OMP_ARRAYCPY_BODY]]
// CHECK7:       omp.arraycpy.done10:
// CHECK7-NEXT:    [[TMP33:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4
// CHECK7-NEXT:    [[TMP34:%.*]] = bitcast %struct.S* [[TMP3]] to i8*
// CHECK7-NEXT:    [[TMP35:%.*]] = bitcast %struct.S* [[TMP33]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP34]], i8* align 4 [[TMP35]], i32 4, i1 false)
// CHECK7-NEXT:    [[TMP36:%.*]] = load i32, i32* [[SVAR7]], align 4
// CHECK7-NEXT:    store i32 [[TMP36]], i32* [[SVAR_ADDR]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK7:       .omp.lastprivate.done:
// CHECK7-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN11]], i32 2
// CHECK7-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK7:       arraydestroy.body:
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP37]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK7-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK7-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK7:       arraydestroy.done12:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i32 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK7-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 4
// CHECK7-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK7-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK7-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK7-NEXT:    [[_TMP6:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[SVAR7:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK7-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i32 2
// CHECK7-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK7:       arrayctor.loop:
// CHECK7-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK7-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK7-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i32 1
// CHECK7-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK7-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK7:       arrayctor.cont:
// CHECK7-NEXT:    [[TMP5:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK7-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK7-NEXT:    store %struct.S* [[VAR5]], %struct.S** [[_TMP6]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK7-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK7:       omp.inner.for.cond.cleanup:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i32 0, i32 [[TMP15]]
// CHECK7-NEXT:    store i32 [[TMP14]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[TMP16:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 [[TMP17]]
// CHECK7-NEXT:    [[TMP18:%.*]] = bitcast %struct.S* [[ARRAYIDX9]] to i8*
// CHECK7-NEXT:    [[TMP19:%.*]] = bitcast %struct.S* [[TMP16]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i32 4, i1 false), !llvm.access.group !10
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK7-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK7-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK7-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK7:       .omp.lastprivate.then:
// CHECK7-NEXT:    [[TMP27:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK7-NEXT:    store i32 [[TMP27]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK7-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP28]], i8* align 4 [[TMP29]], i32 8, i1 false)
// CHECK7-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[TMP1]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP30:%.*]] = bitcast [2 x %struct.S]* [[S_ARR4]] to %struct.S*
// CHECK7-NEXT:    [[TMP31:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN11]], i32 2
// CHECK7-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN11]], [[TMP31]]
// CHECK7-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE12:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK7:       omp.arraycpy.body:
// CHECK7-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP30]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN11]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK7-NEXT:    [[TMP32:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK7-NEXT:    [[TMP33:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i32 4, i1 false)
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK7-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP31]]
// CHECK7-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE12]], label [[OMP_ARRAYCPY_BODY]]
// CHECK7:       omp.arraycpy.done12:
// CHECK7-NEXT:    [[TMP34:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4
// CHECK7-NEXT:    [[TMP35:%.*]] = bitcast %struct.S* [[TMP5]] to i8*
// CHECK7-NEXT:    [[TMP36:%.*]] = bitcast %struct.S* [[TMP34]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP35]], i8* align 4 [[TMP36]], i32 4, i1 false)
// CHECK7-NEXT:    [[TMP37:%.*]] = load i32, i32* [[SVAR7]], align 4
// CHECK7-NEXT:    store i32 [[TMP37]], i32* [[SVAR_ADDR]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK7:       .omp.lastprivate.done:
// CHECK7-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAY_BEGIN13:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN13]], i32 2
// CHECK7-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK7:       arraydestroy.body:
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP38]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK7-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN13]]
// CHECK7-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE14:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK7:       arraydestroy.done14:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK7-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK7-SAME: () #[[ATTR5:[0-9]+]] comdat {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK7-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK7-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK7-NEXT:    [[VAR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK7-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK7-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const._Z5tmainIiET_v.vec to i8*), i32 8, i1 false)
// CHECK7-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK7-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// CHECK7-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYINIT_BEGIN]], i32 1
// CHECK7-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK7-NEXT:    store %struct.S.0* [[TEST]], %struct.S.0** [[VAR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK7-NEXT:    store %struct.S.0* [[TMP1]], %struct.S.0** [[TMP]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[T_VAR]], align 4
// CHECK7-NEXT:    store i32 [[TMP2]], i32* [[T_VAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to [2 x i32]**
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP6]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to [2 x i32]**
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP8]], align 4
// CHECK7-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK7-NEXT:    store i8* null, i8** [[TMP9]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP11]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK7-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK7-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [2 x %struct.S.0]**
// CHECK7-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[TMP16]], align 4
// CHECK7-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK7-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [2 x %struct.S.0]**
// CHECK7-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[TMP18]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK7-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK7-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to %struct.S.0**
// CHECK7-NEXT:    store %struct.S.0* [[TMP4]], %struct.S.0** [[TMP21]], align 4
// CHECK7-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK7-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to %struct.S.0**
// CHECK7-NEXT:    store %struct.S.0* [[TMP4]], %struct.S.0** [[TMP23]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK7-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK7-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK7-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 2)
// CHECK7-NEXT:    [[TMP27:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50.region_id, i32 4, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK7-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK7-NEXT:    br i1 [[TMP28]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK7:       omp_offload.failed:
// CHECK7-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50([2 x i32]* [[VEC]], i32 [[TMP3]], [2 x %struct.S.0]* [[S_ARR]], %struct.S.0* [[TMP4]]) #[[ATTR4]]
// CHECK7-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK7:       omp_offload.cont:
// CHECK7-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK7-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i32 2
// CHECK7-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK7:       arraydestroy.body:
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP29]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK7-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK7-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK7:       arraydestroy.done2:
// CHECK7-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK7-NEXT:    [[TMP30:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK7-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK7-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK7-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK7-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK7-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK7-NEXT:    store float [[TMP0]], float* [[F]], align 4
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK7-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK7-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK7-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK7-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    call void @_ZN1SIiEC2Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50
// CHECK7-SAME: ([2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK7-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 4
// CHECK7-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[T_VAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [2 x i32]*, i32, [2 x %struct.S.0]*, %struct.S.0*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), [2 x i32]* [[TMP0]], i32 [[TMP4]], [2 x %struct.S.0]* [[TMP1]], %struct.S.0* [[TMP5]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK7-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 4
// CHECK7-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK7-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK7-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK7-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK7-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i32 2
// CHECK7-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK7:       arrayctor.loop:
// CHECK7-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK7-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK7-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i32 1
// CHECK7-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK7-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK7:       arrayctor.cont:
// CHECK7-NEXT:    [[TMP3:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK7-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK7-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK7-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK7:       omp.inner.for.cond.cleanup:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    store i32 [[TMP13]], i32* [[T_VAR_CASTED]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    [[TMP15:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [2 x i32]*, i32, [2 x %struct.S.0]*, %struct.S.0*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP11]], i32 [[TMP12]], [2 x i32]* [[VEC3]], i32 [[TMP14]], [2 x %struct.S.0]* [[S_ARR4]], %struct.S.0* [[TMP15]]), !llvm.access.group !15
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP16]], [[TMP17]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, i32* [[TMP18]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP19]])
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK7-NEXT:    br i1 [[TMP21]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK7-NEXT:    br i1 [[TMP23]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK7:       .omp.lastprivate.then:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK7-NEXT:    store i32 [[TMP24]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP25:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK7-NEXT:    [[TMP26:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i32 8, i1 false)
// CHECK7-NEXT:    [[ARRAY_BEGIN8:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[TMP1]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP27:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK7-NEXT:    [[TMP28:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN8]], i32 2
// CHECK7-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN8]], [[TMP28]]
// CHECK7-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE9:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK7:       omp.arraycpy.body:
// CHECK7-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP27]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN8]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK7-NEXT:    [[TMP29:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK7-NEXT:    [[TMP30:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP29]], i8* align 4 [[TMP30]], i32 4, i1 false)
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK7-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP28]]
// CHECK7-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE9]], label [[OMP_ARRAYCPY_BODY]]
// CHECK7:       omp.arraycpy.done9:
// CHECK7-NEXT:    [[TMP31:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4
// CHECK7-NEXT:    [[TMP32:%.*]] = bitcast %struct.S.0* [[TMP3]] to i8*
// CHECK7-NEXT:    [[TMP33:%.*]] = bitcast %struct.S.0* [[TMP31]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i32 4, i1 false)
// CHECK7-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK7:       .omp.lastprivate.done:
// CHECK7-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN10]], i32 2
// CHECK7-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK7:       arraydestroy.body:
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP34]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK7-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN10]]
// CHECK7-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE11:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK7:       arraydestroy.done11:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK7-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK7-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK7-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 4
// CHECK7-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK7-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK7-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK7-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK7-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 4
// CHECK7-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK7-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i32 2
// CHECK7-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK7:       arrayctor.loop:
// CHECK7-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK7-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK7-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i32 1
// CHECK7-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK7-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK7:       arrayctor.cont:
// CHECK7-NEXT:    [[TMP5:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK7-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK7-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK7-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK7:       cond.true:
// CHECK7-NEXT:    br label [[COND_END:%.*]]
// CHECK7:       cond.false:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    br label [[COND_END]]
// CHECK7:       cond.end:
// CHECK7-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK7-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK7-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK7:       omp.inner.for.cond.cleanup:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i32 0, i32 [[TMP15]]
// CHECK7-NEXT:    store i32 [[TMP14]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[TMP16:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 [[TMP17]]
// CHECK7-NEXT:    [[TMP18:%.*]] = bitcast %struct.S.0* [[ARRAYIDX8]] to i8*
// CHECK7-NEXT:    [[TMP19:%.*]] = bitcast %struct.S.0* [[TMP16]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i32 4, i1 false), !llvm.access.group !18
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK7-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK7:       omp.loop.exit:
// CHECK7-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK7-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK7-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK7-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK7:       .omp.final.then:
// CHECK7-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK7-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK7:       .omp.final.done:
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK7-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK7:       .omp.lastprivate.then:
// CHECK7-NEXT:    [[TMP27:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK7-NEXT:    store i32 [[TMP27]], i32* [[T_VAR_ADDR]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK7-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP28]], i8* align 4 [[TMP29]], i32 8, i1 false)
// CHECK7-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[TMP1]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP30:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK7-NEXT:    [[TMP31:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN10]], i32 2
// CHECK7-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN10]], [[TMP31]]
// CHECK7-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE11:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK7:       omp.arraycpy.body:
// CHECK7-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP30]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN10]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK7-NEXT:    [[TMP32:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK7-NEXT:    [[TMP33:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i32 4, i1 false)
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK7-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK7-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP31]]
// CHECK7-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE11]], label [[OMP_ARRAYCPY_BODY]]
// CHECK7:       omp.arraycpy.done11:
// CHECK7-NEXT:    [[TMP34:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4
// CHECK7-NEXT:    [[TMP35:%.*]] = bitcast %struct.S.0* [[TMP5]] to i8*
// CHECK7-NEXT:    [[TMP36:%.*]] = bitcast %struct.S.0* [[TMP34]] to i8*
// CHECK7-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP35]], i8* align 4 [[TMP36]], i32 4, i1 false)
// CHECK7-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK7:       .omp.lastprivate.done:
// CHECK7-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN12]], i32 2
// CHECK7-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK7:       arraydestroy.body:
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP37]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK7-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK7-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK7-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN12]]
// CHECK7-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE13:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK7:       arraydestroy.done13:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK7-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK7-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK7-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK7-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP0]], i32* [[F]], align 4
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK7-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK7-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK7-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK7-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@main
// CHECK8-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK8-NEXT:    [[G1:%.*]] = alloca double*, align 4
// CHECK8-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK8-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK8-NEXT:    [[VAR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK8-NEXT:    store double* [[G]], double** [[G1]], align 4
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK8-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const.main.vec to i8*), i32 8, i1 false)
// CHECK8-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK8-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYINIT_BEGIN]], i32 1
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK8-NEXT:    store %struct.S* [[TEST]], %struct.S** [[VAR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK8-NEXT:    store %struct.S* [[TMP1]], %struct.S** [[TMP]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i32, i32* [[T_VAR]], align 4
// CHECK8-NEXT:    store i32 [[TMP2]], i32* [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, i32* @_ZZ4mainE4svar, align 4
// CHECK8-NEXT:    store i32 [[TMP5]], i32* [[SVAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to [2 x i32]**
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP8]], align 4
// CHECK8-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [2 x i32]**
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP10]], align 4
// CHECK8-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK8-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK8-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[TMP15]], align 4
// CHECK8-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK8-NEXT:    store i8* null, i8** [[TMP16]], align 4
// CHECK8-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [2 x %struct.S]**
// CHECK8-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[TMP18]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to [2 x %struct.S]**
// CHECK8-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[TMP20]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK8-NEXT:    store i8* null, i8** [[TMP21]], align 4
// CHECK8-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to %struct.S**
// CHECK8-NEXT:    store %struct.S* [[TMP4]], %struct.S** [[TMP23]], align 4
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to %struct.S**
// CHECK8-NEXT:    store %struct.S* [[TMP4]], %struct.S** [[TMP25]], align 4
// CHECK8-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK8-NEXT:    store i8* null, i8** [[TMP26]], align 4
// CHECK8-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK8-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to i32*
// CHECK8-NEXT:    store i32 [[TMP6]], i32* [[TMP28]], align 4
// CHECK8-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK8-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32*
// CHECK8-NEXT:    store i32 [[TMP6]], i32* [[TMP30]], align 4
// CHECK8-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK8-NEXT:    store i8* null, i8** [[TMP31]], align 4
// CHECK8-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3:[0-9]+]], i64 -1, i64 2)
// CHECK8-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106.region_id, i32 5, i8** [[TMP32]], i8** [[TMP33]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK8-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK8-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106([2 x i32]* [[VEC]], i32 [[TMP3]], [2 x %struct.S]* [[S_ARR]], %struct.S* [[TMP4]], i32 [[TMP6]]) #[[ATTR4:[0-9]+]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK8-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i32 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP36]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done2:
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK8-NEXT:    [[TMP37:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK8-NEXT:    ret i32 [[TMP37]]
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK8-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK8-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK8-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SIfEC2Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l106
// CHECK8-SAME: ([2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i32 noundef [[SVAR:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 4
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[SVAR_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP6]], i32* [[SVAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 5, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [2 x i32]*, i32, [2 x %struct.S]*, %struct.S*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), [2 x i32]* [[TMP0]], i32 [[TMP4]], [2 x %struct.S]* [[TMP1]], %struct.S* [[TMP5]], i32 [[TMP7]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK8-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i32 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 4
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK8-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK8-NEXT:    [[_TMP6:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[SVAR7:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i32 2
// CHECK8-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK8:       arrayctor.loop:
// CHECK8-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK8-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i32 1
// CHECK8-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK8-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK8:       arrayctor.cont:
// CHECK8-NEXT:    [[TMP3:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK8-NEXT:    store %struct.S* [[VAR5]], %struct.S** [[_TMP6]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK8-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK8:       omp.inner.for.cond.cleanup:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    store i32 [[TMP13]], i32* [[T_VAR_CASTED]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[TMP15:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, i32* [[SVAR7]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    store i32 [[TMP16]], i32* [[SVAR_CASTED]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, i32* [[SVAR_CASTED]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 7, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [2 x i32]*, i32, [2 x %struct.S]*, %struct.S*, i32)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32 [[TMP11]], i32 [[TMP12]], [2 x i32]* [[VEC3]], i32 [[TMP14]], [2 x %struct.S]* [[S_ARR4]], %struct.S* [[TMP15]], i32 [[TMP17]]), !llvm.access.group !6
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP20:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TMP20]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP21]])
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK8-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK8-NEXT:    br i1 [[TMP25]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK8:       .omp.lastprivate.then:
// CHECK8-NEXT:    [[TMP26:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK8-NEXT:    store i32 [[TMP26]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP27:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK8-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP27]], i8* align 4 [[TMP28]], i32 8, i1 false)
// CHECK8-NEXT:    [[ARRAY_BEGIN9:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[TMP1]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP29:%.*]] = bitcast [2 x %struct.S]* [[S_ARR4]] to %struct.S*
// CHECK8-NEXT:    [[TMP30:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN9]], i32 2
// CHECK8-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN9]], [[TMP30]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE10:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK8:       omp.arraycpy.body:
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP29]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN9]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[TMP31:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK8-NEXT:    [[TMP32:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP31]], i8* align 4 [[TMP32]], i32 4, i1 false)
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP30]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE10]], label [[OMP_ARRAYCPY_BODY]]
// CHECK8:       omp.arraycpy.done10:
// CHECK8-NEXT:    [[TMP33:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4
// CHECK8-NEXT:    [[TMP34:%.*]] = bitcast %struct.S* [[TMP3]] to i8*
// CHECK8-NEXT:    [[TMP35:%.*]] = bitcast %struct.S* [[TMP33]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP34]], i8* align 4 [[TMP35]], i32 4, i1 false)
// CHECK8-NEXT:    [[TMP36:%.*]] = load i32, i32* [[SVAR7]], align 4
// CHECK8-NEXT:    store i32 [[TMP36]], i32* [[SVAR_ADDR]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK8:       .omp.lastprivate.done:
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN11]], i32 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP37]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done12:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK8-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i32 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S]*, align 4
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK8-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK8-NEXT:    [[_TMP6:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[SVAR7:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK8-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    store [2 x %struct.S]* [[S_ARR]], [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S* [[VAR]], %struct.S** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[SVAR]], i32* [[SVAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S]*, [2 x %struct.S]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S* [[TMP2]], %struct.S** [[TMP]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i32 2
// CHECK8-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK8:       arrayctor.loop:
// CHECK8-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK8-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i32 1
// CHECK8-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK8-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK8:       arrayctor.cont:
// CHECK8-NEXT:    [[TMP5:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK8-NEXT:    store %struct.S* [[VAR5]], %struct.S** [[_TMP6]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2:[0-9]+]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK8-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK8:       omp.inner.for.cond.cleanup:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i32 0, i32 [[TMP15]]
// CHECK8-NEXT:    store i32 [[TMP14]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[TMP16:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 [[TMP17]]
// CHECK8-NEXT:    [[TMP18:%.*]] = bitcast %struct.S* [[ARRAYIDX9]] to i8*
// CHECK8-NEXT:    [[TMP19:%.*]] = bitcast %struct.S* [[TMP16]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i32 4, i1 false), !llvm.access.group !10
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK8-NEXT:    store i32 [[ADD10]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !10
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK8-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK8-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK8:       .omp.lastprivate.then:
// CHECK8-NEXT:    [[TMP27:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK8-NEXT:    store i32 [[TMP27]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK8-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP28]], i8* align 4 [[TMP29]], i32 8, i1 false)
// CHECK8-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[TMP1]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP30:%.*]] = bitcast [2 x %struct.S]* [[S_ARR4]] to %struct.S*
// CHECK8-NEXT:    [[TMP31:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN11]], i32 2
// CHECK8-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN11]], [[TMP31]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE12:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK8:       omp.arraycpy.body:
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP30]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN11]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[TMP32:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK8-NEXT:    [[TMP33:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i32 4, i1 false)
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP31]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE12]], label [[OMP_ARRAYCPY_BODY]]
// CHECK8:       omp.arraycpy.done12:
// CHECK8-NEXT:    [[TMP34:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4
// CHECK8-NEXT:    [[TMP35:%.*]] = bitcast %struct.S* [[TMP5]] to i8*
// CHECK8-NEXT:    [[TMP36:%.*]] = bitcast %struct.S* [[TMP34]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP35]], i8* align 4 [[TMP36]], i32 4, i1 false)
// CHECK8-NEXT:    [[TMP37:%.*]] = load i32, i32* [[SVAR7]], align 4
// CHECK8-NEXT:    store i32 [[TMP37]], i32* [[SVAR_ADDR]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK8:       .omp.lastprivate.done:
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAY_BEGIN13:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN13]], i32 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP38]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN13]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE14:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done14:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK8-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK8-SAME: () #[[ATTR5:[0-9]+]] comdat {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK8-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK8-NEXT:    [[VAR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK8-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const._Z5tmainIiET_v.vec to i8*), i32 8, i1 false)
// CHECK8-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// CHECK8-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYINIT_BEGIN]], i32 1
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK8-NEXT:    store %struct.S.0* [[TEST]], %struct.S.0** [[VAR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK8-NEXT:    store %struct.S.0* [[TMP1]], %struct.S.0** [[TMP]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i32, i32* [[T_VAR]], align 4
// CHECK8-NEXT:    store i32 [[TMP2]], i32* [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP6:%.*]] = bitcast i8** [[TMP5]] to [2 x i32]**
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP6]], align 4
// CHECK8-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to [2 x i32]**
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[TMP8]], align 4
// CHECK8-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK8-NEXT:    store i8* null, i8** [[TMP9]], align 4
// CHECK8-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[TMP11]], align 4
// CHECK8-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK8-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[TMP13]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK8-NEXT:    store i8* null, i8** [[TMP14]], align 4
// CHECK8-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to [2 x %struct.S.0]**
// CHECK8-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[TMP16]], align 4
// CHECK8-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK8-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to [2 x %struct.S.0]**
// CHECK8-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[TMP18]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK8-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK8-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to %struct.S.0**
// CHECK8-NEXT:    store %struct.S.0* [[TMP4]], %struct.S.0** [[TMP21]], align 4
// CHECK8-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK8-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to %struct.S.0**
// CHECK8-NEXT:    store %struct.S.0* [[TMP4]], %struct.S.0** [[TMP23]], align 4
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK8-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK8-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i64 2)
// CHECK8-NEXT:    [[TMP27:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB3]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50.region_id, i32 4, i8** [[TMP25]], i8** [[TMP26]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_sizes.4, i32 0, i32 0), i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes.5, i32 0, i32 0), i8** null, i8** null, i32 0, i32 0)
// CHECK8-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK8-NEXT:    br i1 [[TMP28]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50([2 x i32]* [[VEC]], i32 [[TMP3]], [2 x %struct.S.0]* [[S_ARR]], %struct.S.0* [[TMP4]]) #[[ATTR4]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i32 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP29]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done2:
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK8-NEXT:    [[TMP30:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK8-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK8-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK8-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK8-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK8-NEXT:    store float [[TMP0]], float* [[F]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK8-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK8-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK8-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK8-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SIiEC2Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l50
// CHECK8-SAME: ([2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 4
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB3]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [2 x i32]*, i32, [2 x %struct.S.0]*, %struct.S.0*)* @.omp_outlined..2 to void (i32*, i32*, ...)*), [2 x i32]* [[TMP0]], i32 [[TMP4]], [2 x %struct.S.0]* [[TMP1]], %struct.S.0* [[TMP5]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK8-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 4
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK8-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK8-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i32 2
// CHECK8-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK8:       arrayctor.loop:
// CHECK8-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK8-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i32 1
// CHECK8-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK8-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK8:       arrayctor.cont:
// CHECK8-NEXT:    [[TMP3:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK8-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, i32* [[TMP4]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP5]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_COMB_LB]], i32* [[DOTOMP_COMB_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK8-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK8:       omp.inner.for.cond.cleanup:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_COMB_LB]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_COMB_UB]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    store i32 [[TMP13]], i32* [[T_VAR_CASTED]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR_CASTED]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    [[TMP15:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_call(%struct.ident_t* @[[GLOB3]], i32 6, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32, i32, [2 x i32]*, i32, [2 x %struct.S.0]*, %struct.S.0*)* @.omp_outlined..3 to void (i32*, i32*, ...)*), i32 [[TMP11]], i32 [[TMP12]], [2 x i32]* [[VEC3]], i32 [[TMP14]], [2 x %struct.S.0]* [[S_ARR4]], %struct.S.0* [[TMP15]]), !llvm.access.group !15
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_STRIDE]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP16]], [[TMP17]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !15
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, i32* [[TMP18]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP19]])
// CHECK8-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK8-NEXT:    br i1 [[TMP21]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK8-NEXT:    br i1 [[TMP23]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK8:       .omp.lastprivate.then:
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK8-NEXT:    store i32 [[TMP24]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP25:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK8-NEXT:    [[TMP26:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i32 8, i1 false)
// CHECK8-NEXT:    [[ARRAY_BEGIN8:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[TMP1]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP27:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK8-NEXT:    [[TMP28:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN8]], i32 2
// CHECK8-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN8]], [[TMP28]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE9:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK8:       omp.arraycpy.body:
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP27]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN8]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[TMP29:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK8-NEXT:    [[TMP30:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP29]], i8* align 4 [[TMP30]], i32 4, i1 false)
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP28]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE9]], label [[OMP_ARRAYCPY_BODY]]
// CHECK8:       omp.arraycpy.done9:
// CHECK8-NEXT:    [[TMP31:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4
// CHECK8-NEXT:    [[TMP32:%.*]] = bitcast %struct.S.0* [[TMP3]] to i8*
// CHECK8-NEXT:    [[TMP33:%.*]] = bitcast %struct.S.0* [[TMP31]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i32 4, i1 false)
// CHECK8-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK8:       .omp.lastprivate.done:
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN10]], i32 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP34]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN10]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE11:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done11:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK8-SAME: (i32* noalias noundef [[DOTGLOBAL_TID_:%.*]], i32* noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], [2 x i32]* noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], [2 x %struct.S.0]* noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], %struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK8-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca [2 x i32]*, align 4
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca [2 x %struct.S.0]*, align 4
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK8-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK8-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK8-NEXT:    store i32 [[DOTPREVIOUS_LB_]], i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK8-NEXT:    store i32 [[DOTPREVIOUS_UB_]], i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK8-NEXT:    store [2 x i32]* [[VEC]], [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[T_VAR]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    store [2 x %struct.S.0]* [[S_ARR]], [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S.0* [[VAR]], %struct.S.0** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load [2 x i32]*, [2 x i32]** [[VEC_ADDR]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load [2 x %struct.S.0]*, [2 x %struct.S.0]** [[S_ARR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR_ADDR]], align 4
// CHECK8-NEXT:    store %struct.S.0* [[TMP2]], %struct.S.0** [[TMP]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i32 2
// CHECK8-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK8:       arrayctor.loop:
// CHECK8-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK8-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i32 1
// CHECK8-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK8-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK8:       arrayctor.cont:
// CHECK8-NEXT:    [[TMP5:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK8-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB2]], i32 [[TMP7]], i32 34, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP8]], 1
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP9]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP10]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP11]], [[TMP12]]
// CHECK8-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK8:       omp.inner.for.cond.cleanup:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP13]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i32 0, i32 [[TMP15]]
// CHECK8-NEXT:    store i32 [[TMP14]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[TMP16:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 [[TMP17]]
// CHECK8-NEXT:    [[TMP18:%.*]] = bitcast %struct.S.0* [[ARRAYIDX8]] to i8*
// CHECK8-NEXT:    [[TMP19:%.*]] = bitcast %struct.S.0* [[TMP16]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i32 4, i1 false), !llvm.access.group !18
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP20]], 1
// CHECK8-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !18
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, i32* [[TMP21]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP22]])
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP24:%.*]] = icmp ne i32 [[TMP23]], 0
// CHECK8-NEXT:    br i1 [[TMP24]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    [[TMP25:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK8-NEXT:    br i1 [[TMP26]], label [[DOTOMP_LASTPRIVATE_THEN:%.*]], label [[DOTOMP_LASTPRIVATE_DONE:%.*]]
// CHECK8:       .omp.lastprivate.then:
// CHECK8-NEXT:    [[TMP27:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK8-NEXT:    store i32 [[TMP27]], i32* [[T_VAR_ADDR]], align 4
// CHECK8-NEXT:    [[TMP28:%.*]] = bitcast [2 x i32]* [[TMP0]] to i8*
// CHECK8-NEXT:    [[TMP29:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP28]], i8* align 4 [[TMP29]], i32 8, i1 false)
// CHECK8-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[TMP1]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP30:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK8-NEXT:    [[TMP31:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN10]], i32 2
// CHECK8-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN10]], [[TMP31]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE11:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK8:       omp.arraycpy.body:
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP30]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN10]], [[DOTOMP_LASTPRIVATE_THEN]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[TMP32:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK8-NEXT:    [[TMP33:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP32]], i8* align 4 [[TMP33]], i32 4, i1 false)
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP31]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE11]], label [[OMP_ARRAYCPY_BODY]]
// CHECK8:       omp.arraycpy.done11:
// CHECK8-NEXT:    [[TMP34:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4
// CHECK8-NEXT:    [[TMP35:%.*]] = bitcast %struct.S.0* [[TMP5]] to i8*
// CHECK8-NEXT:    [[TMP36:%.*]] = bitcast %struct.S.0* [[TMP34]] to i8*
// CHECK8-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP35]], i8* align 4 [[TMP36]], i32 4, i1 false)
// CHECK8-NEXT:    br label [[DOTOMP_LASTPRIVATE_DONE]]
// CHECK8:       .omp.lastprivate.done:
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN12]], i32 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP37]], [[DOTOMP_LASTPRIVATE_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN12]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE13:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done13:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK8-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK8-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK8-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP0]], i32* [[F]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK8-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK8-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK8-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK8-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@main
// CHECK9-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK9-NEXT:    [[G1:%.*]] = alloca double*, align 8
// CHECK9-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK9-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK9-NEXT:    store double* [[G]], double** [[G1]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK9-NEXT:    store double* [[G]], double** [[TMP0]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP2:%.*]] = load double*, double** [[G1]], align 8
// CHECK9-NEXT:    store double* [[TMP2]], double** [[TMP1]], align 8
// CHECK9-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK9-NEXT:    ret i32 0
//
//
// CHECK10-LABEL: define {{[^@]+}}@main
// CHECK10-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK10-NEXT:    [[G1:%.*]] = alloca double*, align 8
// CHECK10-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK10-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK10-NEXT:    store double* [[G]], double** [[G1]], align 8
// CHECK10-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK10-NEXT:    store double* [[G]], double** [[TMP0]], align 8
// CHECK10-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK10-NEXT:    [[TMP2:%.*]] = load double*, double** [[G1]], align 8
// CHECK10-NEXT:    store double* [[TMP2]], double** [[TMP1]], align 8
// CHECK10-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK10-NEXT:    ret i32 0
//
//
// CHECK11-LABEL: define {{[^@]+}}@main
// CHECK11-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK11-NEXT:    [[G1:%.*]] = alloca double*, align 4
// CHECK11-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK11-NEXT:    store double* [[G]], double** [[G1]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK11-NEXT:    store double* [[G]], double** [[TMP0]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP2:%.*]] = load double*, double** [[G1]], align 4
// CHECK11-NEXT:    store double* [[TMP2]], double** [[TMP1]], align 4
// CHECK11-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 4 dereferenceable(8) [[REF_TMP]])
// CHECK11-NEXT:    ret i32 0
//
//
// CHECK12-LABEL: define {{[^@]+}}@main
// CHECK12-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK12-NEXT:    [[G1:%.*]] = alloca double*, align 4
// CHECK12-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK12-NEXT:    store double* [[G]], double** [[G1]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 0
// CHECK12-NEXT:    store double* [[G]], double** [[TMP0]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], %class.anon* [[REF_TMP]], i32 0, i32 1
// CHECK12-NEXT:    [[TMP2:%.*]] = load double*, double** [[G1]], align 4
// CHECK12-NEXT:    store double* [[TMP2]], double** [[TMP1]], align 4
// CHECK12-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(%class.anon* noundef nonnull align 4 dereferenceable(8) [[REF_TMP]])
// CHECK12-NEXT:    ret i32 0
//
//
// CHECK13-LABEL: define {{[^@]+}}@main
// CHECK13-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK13-NEXT:    [[G1:%.*]] = alloca double*, align 8
// CHECK13-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK13-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK13-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK13-NEXT:    [[VAR:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK13-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK13-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK13-NEXT:    [[_TMP6:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    [[SVAR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I14:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK13-NEXT:    store double* [[G]], double** [[G1]], align 8
// CHECK13-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK13-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const.main.vec to i8*), i64 8, i1 false)
// CHECK13-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i64 0, i64 0
// CHECK13-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK13-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYINIT_BEGIN]], i64 1
// CHECK13-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK13-NEXT:    store %struct.S* [[TEST]], %struct.S** [[VAR]], align 8
// CHECK13-NEXT:    [[TMP1:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK13-NEXT:    store %struct.S* [[TMP1]], %struct.S** [[TMP]], align 8
// CHECK13-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK13-NEXT:    [[TMP3:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK13-NEXT:    [[TMP4:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK13-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i64 2
// CHECK13-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK13:       arrayctor.loop:
// CHECK13-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK13-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK13-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i64 1
// CHECK13-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK13-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK13:       arrayctor.cont:
// CHECK13-NEXT:    [[TMP6:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK13-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK13-NEXT:    store %struct.S* [[VAR5]], %struct.S** [[_TMP6]], align 8
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK13:       omp.inner.for.cond.cleanup:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP10:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i64 0, i64 [[IDXPROM]]
// CHECK13-NEXT:    store i32 [[TMP10]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP12:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 8, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP13]] to i64
// CHECK13-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i64 0, i64 [[IDXPROM7]]
// CHECK13-NEXT:    [[TMP14:%.*]] = bitcast %struct.S* [[ARRAYIDX8]] to i8*
// CHECK13-NEXT:    [[TMP15:%.*]] = bitcast %struct.S* [[TMP12]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP14]], i8* align 4 [[TMP15]], i64 4, i1 false), !llvm.access.group !2
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK13-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK13-NEXT:    [[TMP17:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK13-NEXT:    store i32 [[TMP17]], i32* [[T_VAR]], align 4
// CHECK13-NEXT:    [[TMP18:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK13-NEXT:    [[TMP19:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i64 8, i1 false)
// CHECK13-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP20:%.*]] = bitcast [2 x %struct.S]* [[S_ARR4]] to %struct.S*
// CHECK13-NEXT:    [[TMP21:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN10]], i64 2
// CHECK13-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN10]], [[TMP21]]
// CHECK13-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE11:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK13:       omp.arraycpy.body:
// CHECK13-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP20]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK13-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN10]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK13-NEXT:    [[TMP22:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK13-NEXT:    [[TMP23:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP22]], i8* align 4 [[TMP23]], i64 4, i1 false)
// CHECK13-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK13-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK13-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP21]]
// CHECK13-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE11]], label [[OMP_ARRAYCPY_BODY]]
// CHECK13:       omp.arraycpy.done11:
// CHECK13-NEXT:    [[TMP24:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 8
// CHECK13-NEXT:    [[TMP25:%.*]] = bitcast %struct.S* [[TMP6]] to i8*
// CHECK13-NEXT:    [[TMP26:%.*]] = bitcast %struct.S* [[TMP24]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i64 4, i1 false)
// CHECK13-NEXT:    [[TMP27:%.*]] = load i32, i32* [[SVAR]], align 4
// CHECK13-NEXT:    store i32 [[TMP27]], i32* @_ZZ4mainE4svar, align 4
// CHECK13-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4:[0-9]+]]
// CHECK13-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN12]], i64 2
// CHECK13-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK13:       arraydestroy.body:
// CHECK13-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP28]], [[OMP_ARRAYCPY_DONE11]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK13-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK13-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK13-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN12]]
// CHECK13-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE13:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK13:       arraydestroy.done13:
// CHECK13-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z5tmainIiET_v()
// CHECK13-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK13-NEXT:    [[ARRAY_BEGIN15:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN15]], i64 2
// CHECK13-NEXT:    br label [[ARRAYDESTROY_BODY16:%.*]]
// CHECK13:       arraydestroy.body16:
// CHECK13-NEXT:    [[ARRAYDESTROY_ELEMENTPAST17:%.*]] = phi %struct.S* [ [[TMP29]], [[ARRAYDESTROY_DONE13]] ], [ [[ARRAYDESTROY_ELEMENT18:%.*]], [[ARRAYDESTROY_BODY16]] ]
// CHECK13-NEXT:    [[ARRAYDESTROY_ELEMENT18]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST17]], i64 -1
// CHECK13-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT18]]) #[[ATTR4]]
// CHECK13-NEXT:    [[ARRAYDESTROY_DONE19:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT18]], [[ARRAY_BEGIN15]]
// CHECK13-NEXT:    br i1 [[ARRAYDESTROY_DONE19]], label [[ARRAYDESTROY_DONE20:%.*]], label [[ARRAYDESTROY_BODY16]]
// CHECK13:       arraydestroy.done20:
// CHECK13-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK13-NEXT:    [[TMP30:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK13-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK13-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK13-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK13-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK13-NEXT:    call void @_ZN1SIfEC2Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK13-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK13-SAME: () #[[ATTR3:[0-9]+]] comdat {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK13-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK13-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK13-NEXT:    [[VAR:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK13-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK13-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0]], align 4
// CHECK13-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK13-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const._Z5tmainIiET_v.vec to i8*), i64 8, i1 false)
// CHECK13-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i64 0, i64 0
// CHECK13-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef signext 1)
// CHECK13-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYINIT_BEGIN]], i64 1
// CHECK13-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef signext 2)
// CHECK13-NEXT:    store %struct.S.0* [[TEST]], %struct.S.0** [[VAR]], align 8
// CHECK13-NEXT:    [[TMP1:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK13-NEXT:    store %struct.S.0* [[TMP1]], %struct.S.0** [[TMP]], align 8
// CHECK13-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK13-NEXT:    [[TMP3:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK13-NEXT:    [[TMP4:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK13-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i64 2
// CHECK13-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK13:       arrayctor.loop:
// CHECK13-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK13-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK13-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i64 1
// CHECK13-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK13-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK13:       arrayctor.cont:
// CHECK13-NEXT:    [[TMP6:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK13-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK13-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 8
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK13:       omp.inner.for.cond.cleanup:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[TMP10:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i64 0, i64 [[IDXPROM]]
// CHECK13-NEXT:    store i32 [[TMP10]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[TMP12:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 8, !llvm.access.group !6
// CHECK13-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP13]] to i64
// CHECK13-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i64 0, i64 [[IDXPROM7]]
// CHECK13-NEXT:    [[TMP14:%.*]] = bitcast %struct.S.0* [[ARRAYIDX8]] to i8*
// CHECK13-NEXT:    [[TMP15:%.*]] = bitcast %struct.S.0* [[TMP12]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP14]], i8* align 4 [[TMP15]], i64 4, i1 false), !llvm.access.group !6
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK13-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK13-NEXT:    [[TMP17:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK13-NEXT:    store i32 [[TMP17]], i32* [[T_VAR]], align 4
// CHECK13-NEXT:    [[TMP18:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK13-NEXT:    [[TMP19:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i64 8, i1 false)
// CHECK13-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP20:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK13-NEXT:    [[TMP21:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN10]], i64 2
// CHECK13-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN10]], [[TMP21]]
// CHECK13-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE11:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK13:       omp.arraycpy.body:
// CHECK13-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP20]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK13-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN10]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK13-NEXT:    [[TMP22:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK13-NEXT:    [[TMP23:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP22]], i8* align 4 [[TMP23]], i64 4, i1 false)
// CHECK13-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK13-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK13-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP21]]
// CHECK13-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE11]], label [[OMP_ARRAYCPY_BODY]]
// CHECK13:       omp.arraycpy.done11:
// CHECK13-NEXT:    [[TMP24:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 8
// CHECK13-NEXT:    [[TMP25:%.*]] = bitcast %struct.S.0* [[TMP6]] to i8*
// CHECK13-NEXT:    [[TMP26:%.*]] = bitcast %struct.S.0* [[TMP24]] to i8*
// CHECK13-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i64 4, i1 false)
// CHECK13-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK13-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN12]], i64 2
// CHECK13-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK13:       arraydestroy.body:
// CHECK13-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP27]], [[OMP_ARRAYCPY_DONE11]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK13-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK13-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK13-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN12]]
// CHECK13-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE13:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK13:       arraydestroy.done13:
// CHECK13-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK13-NEXT:    [[ARRAY_BEGIN14:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN14]], i64 2
// CHECK13-NEXT:    br label [[ARRAYDESTROY_BODY15:%.*]]
// CHECK13:       arraydestroy.body15:
// CHECK13-NEXT:    [[ARRAYDESTROY_ELEMENTPAST16:%.*]] = phi %struct.S.0* [ [[TMP28]], [[ARRAYDESTROY_DONE13]] ], [ [[ARRAYDESTROY_ELEMENT17:%.*]], [[ARRAYDESTROY_BODY15]] ]
// CHECK13-NEXT:    [[ARRAYDESTROY_ELEMENT17]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST16]], i64 -1
// CHECK13-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT17]]) #[[ATTR4]]
// CHECK13-NEXT:    [[ARRAYDESTROY_DONE18:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT17]], [[ARRAY_BEGIN14]]
// CHECK13-NEXT:    br i1 [[ARRAYDESTROY_DONE18]], label [[ARRAYDESTROY_DONE19:%.*]], label [[ARRAYDESTROY_BODY15]]
// CHECK13:       arraydestroy.done19:
// CHECK13-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK13-NEXT:    [[TMP29:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK13-NEXT:    ret i32 [[TMP29]]
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK13-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK13-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK13-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK13-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK13-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK13-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK13-NEXT:    store float [[TMP0]], float* [[F]], align 4
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK13-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK13-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK13-NEXT:    call void @_ZN1SIiEC2Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef signext [[TMP0]])
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK13-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK13-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK13-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK13-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK13-NEXT:    store i32 [[TMP0]], i32* [[F]], align 4
// CHECK13-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK13-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK13-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK13-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@main
// CHECK14-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK14-NEXT:    [[G1:%.*]] = alloca double*, align 8
// CHECK14-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK14-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK14-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK14-NEXT:    [[VAR:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK14-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK14-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK14-NEXT:    [[_TMP6:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    [[SVAR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I14:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK14-NEXT:    store double* [[G]], double** [[G1]], align 8
// CHECK14-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK14-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const.main.vec to i8*), i64 8, i1 false)
// CHECK14-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i64 0, i64 0
// CHECK14-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK14-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYINIT_BEGIN]], i64 1
// CHECK14-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK14-NEXT:    store %struct.S* [[TEST]], %struct.S** [[VAR]], align 8
// CHECK14-NEXT:    [[TMP1:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK14-NEXT:    store %struct.S* [[TMP1]], %struct.S** [[TMP]], align 8
// CHECK14-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK14-NEXT:    [[TMP3:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK14-NEXT:    [[TMP4:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 8
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK14-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i64 2
// CHECK14-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK14:       arrayctor.loop:
// CHECK14-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK14-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK14-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i64 1
// CHECK14-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK14-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK14:       arrayctor.cont:
// CHECK14-NEXT:    [[TMP6:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 8
// CHECK14-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK14-NEXT:    store %struct.S* [[VAR5]], %struct.S** [[_TMP6]], align 8
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK14:       omp.inner.for.cond.cleanup:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP10:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i64 0, i64 [[IDXPROM]]
// CHECK14-NEXT:    store i32 [[TMP10]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP12:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 8, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP13]] to i64
// CHECK14-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i64 0, i64 [[IDXPROM7]]
// CHECK14-NEXT:    [[TMP14:%.*]] = bitcast %struct.S* [[ARRAYIDX8]] to i8*
// CHECK14-NEXT:    [[TMP15:%.*]] = bitcast %struct.S* [[TMP12]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP14]], i8* align 4 [[TMP15]], i64 4, i1 false), !llvm.access.group !2
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK14-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK14-NEXT:    [[TMP17:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK14-NEXT:    store i32 [[TMP17]], i32* [[T_VAR]], align 4
// CHECK14-NEXT:    [[TMP18:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK14-NEXT:    [[TMP19:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i64 8, i1 false)
// CHECK14-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP20:%.*]] = bitcast [2 x %struct.S]* [[S_ARR4]] to %struct.S*
// CHECK14-NEXT:    [[TMP21:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN10]], i64 2
// CHECK14-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN10]], [[TMP21]]
// CHECK14-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE11:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK14:       omp.arraycpy.body:
// CHECK14-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP20]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK14-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN10]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK14-NEXT:    [[TMP22:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK14-NEXT:    [[TMP23:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP22]], i8* align 4 [[TMP23]], i64 4, i1 false)
// CHECK14-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK14-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK14-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP21]]
// CHECK14-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE11]], label [[OMP_ARRAYCPY_BODY]]
// CHECK14:       omp.arraycpy.done11:
// CHECK14-NEXT:    [[TMP24:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 8
// CHECK14-NEXT:    [[TMP25:%.*]] = bitcast %struct.S* [[TMP6]] to i8*
// CHECK14-NEXT:    [[TMP26:%.*]] = bitcast %struct.S* [[TMP24]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i64 4, i1 false)
// CHECK14-NEXT:    [[TMP27:%.*]] = load i32, i32* [[SVAR]], align 4
// CHECK14-NEXT:    store i32 [[TMP27]], i32* @_ZZ4mainE4svar, align 4
// CHECK14-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4:[0-9]+]]
// CHECK14-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN12]], i64 2
// CHECK14-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK14:       arraydestroy.body:
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP28]], [[OMP_ARRAYCPY_DONE11]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK14-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK14-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN12]]
// CHECK14-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE13:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK14:       arraydestroy.done13:
// CHECK14-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z5tmainIiET_v()
// CHECK14-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK14-NEXT:    [[ARRAY_BEGIN15:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN15]], i64 2
// CHECK14-NEXT:    br label [[ARRAYDESTROY_BODY16:%.*]]
// CHECK14:       arraydestroy.body16:
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENTPAST17:%.*]] = phi %struct.S* [ [[TMP29]], [[ARRAYDESTROY_DONE13]] ], [ [[ARRAYDESTROY_ELEMENT18:%.*]], [[ARRAYDESTROY_BODY16]] ]
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENT18]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST17]], i64 -1
// CHECK14-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT18]]) #[[ATTR4]]
// CHECK14-NEXT:    [[ARRAYDESTROY_DONE19:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT18]], [[ARRAY_BEGIN15]]
// CHECK14-NEXT:    br i1 [[ARRAYDESTROY_DONE19]], label [[ARRAYDESTROY_DONE20:%.*]], label [[ARRAYDESTROY_BODY16]]
// CHECK14:       arraydestroy.done20:
// CHECK14-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK14-NEXT:    [[TMP30:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK14-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK14-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK14-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK14-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK14-NEXT:    call void @_ZN1SIfEC2Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK14-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK14-SAME: () #[[ATTR3:[0-9]+]] comdat {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK14-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK14-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK14-NEXT:    [[VAR:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK14-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK14-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0]], align 4
// CHECK14-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK14-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const._Z5tmainIiET_v.vec to i8*), i64 8, i1 false)
// CHECK14-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i64 0, i64 0
// CHECK14-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef signext 1)
// CHECK14-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYINIT_BEGIN]], i64 1
// CHECK14-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef signext 2)
// CHECK14-NEXT:    store %struct.S.0* [[TEST]], %struct.S.0** [[VAR]], align 8
// CHECK14-NEXT:    [[TMP1:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK14-NEXT:    store %struct.S.0* [[TMP1]], %struct.S.0** [[TMP]], align 8
// CHECK14-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK14-NEXT:    [[TMP3:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK14-NEXT:    [[TMP4:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 8
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK14-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i64 2
// CHECK14-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK14:       arrayctor.loop:
// CHECK14-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK14-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK14-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i64 1
// CHECK14-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK14-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK14:       arrayctor.cont:
// CHECK14-NEXT:    [[TMP6:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 8
// CHECK14-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK14-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 8
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK14:       omp.inner.for.cond.cleanup:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[TMP10:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i64 0, i64 [[IDXPROM]]
// CHECK14-NEXT:    store i32 [[TMP10]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[TMP12:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 8, !llvm.access.group !6
// CHECK14-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP13]] to i64
// CHECK14-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i64 0, i64 [[IDXPROM7]]
// CHECK14-NEXT:    [[TMP14:%.*]] = bitcast %struct.S.0* [[ARRAYIDX8]] to i8*
// CHECK14-NEXT:    [[TMP15:%.*]] = bitcast %struct.S.0* [[TMP12]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP14]], i8* align 4 [[TMP15]], i64 4, i1 false), !llvm.access.group !6
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK14-NEXT:    store i32 [[ADD9]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK14-NEXT:    [[TMP17:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK14-NEXT:    store i32 [[TMP17]], i32* [[T_VAR]], align 4
// CHECK14-NEXT:    [[TMP18:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK14-NEXT:    [[TMP19:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i64 8, i1 false)
// CHECK14-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP20:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK14-NEXT:    [[TMP21:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN10]], i64 2
// CHECK14-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN10]], [[TMP21]]
// CHECK14-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE11:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK14:       omp.arraycpy.body:
// CHECK14-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP20]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK14-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN10]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK14-NEXT:    [[TMP22:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK14-NEXT:    [[TMP23:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP22]], i8* align 4 [[TMP23]], i64 4, i1 false)
// CHECK14-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK14-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK14-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP21]]
// CHECK14-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE11]], label [[OMP_ARRAYCPY_BODY]]
// CHECK14:       omp.arraycpy.done11:
// CHECK14-NEXT:    [[TMP24:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 8
// CHECK14-NEXT:    [[TMP25:%.*]] = bitcast %struct.S.0* [[TMP6]] to i8*
// CHECK14-NEXT:    [[TMP26:%.*]] = bitcast %struct.S.0* [[TMP24]] to i8*
// CHECK14-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i64 4, i1 false)
// CHECK14-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK14-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN12]], i64 2
// CHECK14-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK14:       arraydestroy.body:
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP27]], [[OMP_ARRAYCPY_DONE11]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK14-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK14-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN12]]
// CHECK14-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE13:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK14:       arraydestroy.done13:
// CHECK14-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK14-NEXT:    [[ARRAY_BEGIN14:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN14]], i64 2
// CHECK14-NEXT:    br label [[ARRAYDESTROY_BODY15:%.*]]
// CHECK14:       arraydestroy.body15:
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENTPAST16:%.*]] = phi %struct.S.0* [ [[TMP28]], [[ARRAYDESTROY_DONE13]] ], [ [[ARRAYDESTROY_ELEMENT17:%.*]], [[ARRAYDESTROY_BODY15]] ]
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENT17]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST16]], i64 -1
// CHECK14-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT17]]) #[[ATTR4]]
// CHECK14-NEXT:    [[ARRAYDESTROY_DONE18:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT17]], [[ARRAY_BEGIN14]]
// CHECK14-NEXT:    br i1 [[ARRAYDESTROY_DONE18]], label [[ARRAYDESTROY_DONE19:%.*]], label [[ARRAYDESTROY_BODY15]]
// CHECK14:       arraydestroy.done19:
// CHECK14-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK14-NEXT:    [[TMP29:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK14-NEXT:    ret i32 [[TMP29]]
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK14-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK14-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK14-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK14-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 8
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK14-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK14-NEXT:    store float [[TMP0]], float* [[F]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK14-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK14-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK14-NEXT:    call void @_ZN1SIiEC2Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef signext [[TMP0]])
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK14-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK14-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK14-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK14-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK14-NEXT:    store i32 [[TMP0]], i32* [[F]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK14-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 8
// CHECK14-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 8
// CHECK14-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@main
// CHECK15-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK15-NEXT:    [[G1:%.*]] = alloca double*, align 4
// CHECK15-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK15-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK15-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK15-NEXT:    [[VAR:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK15-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK15-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK15-NEXT:    [[_TMP6:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    [[SVAR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I13:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK15-NEXT:    store double* [[G]], double** [[G1]], align 4
// CHECK15-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK15-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const.main.vec to i8*), i32 8, i1 false)
// CHECK15-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK15-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK15-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYINIT_BEGIN]], i32 1
// CHECK15-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK15-NEXT:    store %struct.S* [[TEST]], %struct.S** [[VAR]], align 4
// CHECK15-NEXT:    [[TMP1:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK15-NEXT:    store %struct.S* [[TMP1]], %struct.S** [[TMP]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK15-NEXT:    [[TMP3:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK15-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i32 2
// CHECK15-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK15:       arrayctor.loop:
// CHECK15-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK15-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK15-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i32 1
// CHECK15-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK15-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK15:       arrayctor.cont:
// CHECK15-NEXT:    [[TMP6:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK15-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK15-NEXT:    store %struct.S* [[VAR5]], %struct.S** [[_TMP6]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK15:       omp.inner.for.cond.cleanup:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP10:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i32 0, i32 [[TMP11]]
// CHECK15-NEXT:    store i32 [[TMP10]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP12:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 [[TMP13]]
// CHECK15-NEXT:    [[TMP14:%.*]] = bitcast %struct.S* [[ARRAYIDX7]] to i8*
// CHECK15-NEXT:    [[TMP15:%.*]] = bitcast %struct.S* [[TMP12]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP14]], i8* align 4 [[TMP15]], i32 4, i1 false), !llvm.access.group !3
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK15-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK15-NEXT:    [[TMP17:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK15-NEXT:    store i32 [[TMP17]], i32* [[T_VAR]], align 4
// CHECK15-NEXT:    [[TMP18:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK15-NEXT:    [[TMP19:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i32 8, i1 false)
// CHECK15-NEXT:    [[ARRAY_BEGIN9:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP20:%.*]] = bitcast [2 x %struct.S]* [[S_ARR4]] to %struct.S*
// CHECK15-NEXT:    [[TMP21:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN9]], i32 2
// CHECK15-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN9]], [[TMP21]]
// CHECK15-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE10:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK15:       omp.arraycpy.body:
// CHECK15-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP20]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK15-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN9]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK15-NEXT:    [[TMP22:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK15-NEXT:    [[TMP23:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP22]], i8* align 4 [[TMP23]], i32 4, i1 false)
// CHECK15-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK15-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK15-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP21]]
// CHECK15-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE10]], label [[OMP_ARRAYCPY_BODY]]
// CHECK15:       omp.arraycpy.done10:
// CHECK15-NEXT:    [[TMP24:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4
// CHECK15-NEXT:    [[TMP25:%.*]] = bitcast %struct.S* [[TMP6]] to i8*
// CHECK15-NEXT:    [[TMP26:%.*]] = bitcast %struct.S* [[TMP24]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i32 4, i1 false)
// CHECK15-NEXT:    [[TMP27:%.*]] = load i32, i32* [[SVAR]], align 4
// CHECK15-NEXT:    store i32 [[TMP27]], i32* @_ZZ4mainE4svar, align 4
// CHECK15-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4:[0-9]+]]
// CHECK15-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN11]], i32 2
// CHECK15-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK15:       arraydestroy.body:
// CHECK15-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP28]], [[OMP_ARRAYCPY_DONE10]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK15-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK15-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK15-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK15-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK15:       arraydestroy.done12:
// CHECK15-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK15-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK15-NEXT:    [[ARRAY_BEGIN14:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN14]], i32 2
// CHECK15-NEXT:    br label [[ARRAYDESTROY_BODY15:%.*]]
// CHECK15:       arraydestroy.body15:
// CHECK15-NEXT:    [[ARRAYDESTROY_ELEMENTPAST16:%.*]] = phi %struct.S* [ [[TMP29]], [[ARRAYDESTROY_DONE12]] ], [ [[ARRAYDESTROY_ELEMENT17:%.*]], [[ARRAYDESTROY_BODY15]] ]
// CHECK15-NEXT:    [[ARRAYDESTROY_ELEMENT17]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST16]], i32 -1
// CHECK15-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT17]]) #[[ATTR4]]
// CHECK15-NEXT:    [[ARRAYDESTROY_DONE18:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT17]], [[ARRAY_BEGIN14]]
// CHECK15-NEXT:    br i1 [[ARRAYDESTROY_DONE18]], label [[ARRAYDESTROY_DONE19:%.*]], label [[ARRAYDESTROY_BODY15]]
// CHECK15:       arraydestroy.done19:
// CHECK15-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK15-NEXT:    [[TMP30:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK15-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK15-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK15-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK15-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK15-NEXT:    call void @_ZN1SIfEC2Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK15-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK15-SAME: () #[[ATTR3:[0-9]+]] comdat {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK15-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK15-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK15-NEXT:    [[VAR:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK15-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK15-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0]], align 4
// CHECK15-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK15-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const._Z5tmainIiET_v.vec to i8*), i32 8, i1 false)
// CHECK15-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK15-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// CHECK15-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYINIT_BEGIN]], i32 1
// CHECK15-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK15-NEXT:    store %struct.S.0* [[TEST]], %struct.S.0** [[VAR]], align 4
// CHECK15-NEXT:    [[TMP1:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK15-NEXT:    store %struct.S.0* [[TMP1]], %struct.S.0** [[TMP]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK15-NEXT:    [[TMP3:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK15-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i32 2
// CHECK15-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK15:       arrayctor.loop:
// CHECK15-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK15-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK15-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i32 1
// CHECK15-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK15-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK15:       arrayctor.cont:
// CHECK15-NEXT:    [[TMP6:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK15-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK15-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK15:       omp.inner.for.cond.cleanup:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[TMP10:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i32 0, i32 [[TMP11]]
// CHECK15-NEXT:    store i32 [[TMP10]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[TMP12:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 [[TMP13]]
// CHECK15-NEXT:    [[TMP14:%.*]] = bitcast %struct.S.0* [[ARRAYIDX7]] to i8*
// CHECK15-NEXT:    [[TMP15:%.*]] = bitcast %struct.S.0* [[TMP12]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP14]], i8* align 4 [[TMP15]], i32 4, i1 false), !llvm.access.group !7
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK15-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK15-NEXT:    [[TMP17:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK15-NEXT:    store i32 [[TMP17]], i32* [[T_VAR]], align 4
// CHECK15-NEXT:    [[TMP18:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK15-NEXT:    [[TMP19:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i32 8, i1 false)
// CHECK15-NEXT:    [[ARRAY_BEGIN9:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP20:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK15-NEXT:    [[TMP21:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN9]], i32 2
// CHECK15-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN9]], [[TMP21]]
// CHECK15-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE10:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK15:       omp.arraycpy.body:
// CHECK15-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP20]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK15-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN9]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK15-NEXT:    [[TMP22:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK15-NEXT:    [[TMP23:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP22]], i8* align 4 [[TMP23]], i32 4, i1 false)
// CHECK15-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK15-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK15-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP21]]
// CHECK15-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE10]], label [[OMP_ARRAYCPY_BODY]]
// CHECK15:       omp.arraycpy.done10:
// CHECK15-NEXT:    [[TMP24:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4
// CHECK15-NEXT:    [[TMP25:%.*]] = bitcast %struct.S.0* [[TMP6]] to i8*
// CHECK15-NEXT:    [[TMP26:%.*]] = bitcast %struct.S.0* [[TMP24]] to i8*
// CHECK15-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i32 4, i1 false)
// CHECK15-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK15-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN11]], i32 2
// CHECK15-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK15:       arraydestroy.body:
// CHECK15-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP27]], [[OMP_ARRAYCPY_DONE10]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK15-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK15-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK15-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK15-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK15:       arraydestroy.done12:
// CHECK15-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK15-NEXT:    [[ARRAY_BEGIN13:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN13]], i32 2
// CHECK15-NEXT:    br label [[ARRAYDESTROY_BODY14:%.*]]
// CHECK15:       arraydestroy.body14:
// CHECK15-NEXT:    [[ARRAYDESTROY_ELEMENTPAST15:%.*]] = phi %struct.S.0* [ [[TMP28]], [[ARRAYDESTROY_DONE12]] ], [ [[ARRAYDESTROY_ELEMENT16:%.*]], [[ARRAYDESTROY_BODY14]] ]
// CHECK15-NEXT:    [[ARRAYDESTROY_ELEMENT16]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST15]], i32 -1
// CHECK15-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT16]]) #[[ATTR4]]
// CHECK15-NEXT:    [[ARRAYDESTROY_DONE17:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT16]], [[ARRAY_BEGIN13]]
// CHECK15-NEXT:    br i1 [[ARRAYDESTROY_DONE17]], label [[ARRAYDESTROY_DONE18:%.*]], label [[ARRAYDESTROY_BODY14]]
// CHECK15:       arraydestroy.done18:
// CHECK15-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK15-NEXT:    [[TMP29:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK15-NEXT:    ret i32 [[TMP29]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK15-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK15-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK15-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK15-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK15-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK15-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK15-NEXT:    store float [[TMP0]], float* [[F]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK15-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK15-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK15-NEXT:    call void @_ZN1SIiEC2Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK15-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK15-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK15-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK15-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[F]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK15-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK15-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK15-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK15-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@main
// CHECK16-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK16-NEXT:    [[G1:%.*]] = alloca double*, align 4
// CHECK16-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK16-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK16-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK16-NEXT:    [[VAR:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    [[TMP:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK16-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK16-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK16-NEXT:    [[_TMP6:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    [[SVAR:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I13:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK16-NEXT:    store double* [[G]], double** [[G1]], align 4
// CHECK16-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK16-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const.main.vec to i8*), i32 8, i1 false)
// CHECK16-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK16-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK16-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYINIT_BEGIN]], i32 1
// CHECK16-NEXT:    call void @_ZN1SIfEC1Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK16-NEXT:    store %struct.S* [[TEST]], %struct.S** [[VAR]], align 4
// CHECK16-NEXT:    [[TMP1:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK16-NEXT:    store %struct.S* [[TMP1]], %struct.S** [[TMP]], align 4
// CHECK16-NEXT:    [[TMP2:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK16-NEXT:    [[TMP3:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK16-NEXT:    [[TMP4:%.*]] = load %struct.S*, %struct.S** [[VAR]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK16-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN]], i32 2
// CHECK16-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK16:       arrayctor.loop:
// CHECK16-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK16-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK16-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYCTOR_CUR]], i32 1
// CHECK16-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK16-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK16:       arrayctor.cont:
// CHECK16-NEXT:    [[TMP6:%.*]] = load %struct.S*, %struct.S** [[TMP]], align 4
// CHECK16-NEXT:    call void @_ZN1SIfEC1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK16-NEXT:    store %struct.S* [[VAR5]], %struct.S** [[_TMP6]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK16-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK16:       omp.inner.for.cond.cleanup:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK16-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK16-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP10:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i32 0, i32 [[TMP11]]
// CHECK16-NEXT:    store i32 [[TMP10]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP12:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 [[TMP13]]
// CHECK16-NEXT:    [[TMP14:%.*]] = bitcast %struct.S* [[ARRAYIDX7]] to i8*
// CHECK16-NEXT:    [[TMP15:%.*]] = bitcast %struct.S* [[TMP12]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP14]], i8* align 4 [[TMP15]], i32 4, i1 false), !llvm.access.group !3
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK16-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK16-NEXT:    [[TMP17:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK16-NEXT:    store i32 [[TMP17]], i32* [[T_VAR]], align 4
// CHECK16-NEXT:    [[TMP18:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK16-NEXT:    [[TMP19:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i32 8, i1 false)
// CHECK16-NEXT:    [[ARRAY_BEGIN9:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK16-NEXT:    [[TMP20:%.*]] = bitcast [2 x %struct.S]* [[S_ARR4]] to %struct.S*
// CHECK16-NEXT:    [[TMP21:%.*]] = getelementptr [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN9]], i32 2
// CHECK16-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S* [[ARRAY_BEGIN9]], [[TMP21]]
// CHECK16-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE10:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK16:       omp.arraycpy.body:
// CHECK16-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP20]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK16-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S* [ [[ARRAY_BEGIN9]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK16-NEXT:    [[TMP22:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK16-NEXT:    [[TMP23:%.*]] = bitcast %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP22]], i8* align 4 [[TMP23]], i32 4, i1 false)
// CHECK16-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK16-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], %struct.S* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK16-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP21]]
// CHECK16-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE10]], label [[OMP_ARRAYCPY_BODY]]
// CHECK16:       omp.arraycpy.done10:
// CHECK16-NEXT:    [[TMP24:%.*]] = load %struct.S*, %struct.S** [[_TMP6]], align 4
// CHECK16-NEXT:    [[TMP25:%.*]] = bitcast %struct.S* [[TMP6]] to i8*
// CHECK16-NEXT:    [[TMP26:%.*]] = bitcast %struct.S* [[TMP24]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i32 4, i1 false)
// CHECK16-NEXT:    [[TMP27:%.*]] = load i32, i32* [[SVAR]], align 4
// CHECK16-NEXT:    store i32 [[TMP27]], i32* @_ZZ4mainE4svar, align 4
// CHECK16-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4:[0-9]+]]
// CHECK16-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR4]], i32 0, i32 0
// CHECK16-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN11]], i32 2
// CHECK16-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK16:       arraydestroy.body:
// CHECK16-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S* [ [[TMP28]], [[OMP_ARRAYCPY_DONE10]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK16-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK16-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK16-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK16-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK16:       arraydestroy.done12:
// CHECK16-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK16-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK16-NEXT:    [[ARRAY_BEGIN14:%.*]] = getelementptr inbounds [2 x %struct.S], [2 x %struct.S]* [[S_ARR]], i32 0, i32 0
// CHECK16-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAY_BEGIN14]], i32 2
// CHECK16-NEXT:    br label [[ARRAYDESTROY_BODY15:%.*]]
// CHECK16:       arraydestroy.body15:
// CHECK16-NEXT:    [[ARRAYDESTROY_ELEMENTPAST16:%.*]] = phi %struct.S* [ [[TMP29]], [[ARRAYDESTROY_DONE12]] ], [ [[ARRAYDESTROY_ELEMENT17:%.*]], [[ARRAYDESTROY_BODY15]] ]
// CHECK16-NEXT:    [[ARRAYDESTROY_ELEMENT17]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[ARRAYDESTROY_ELEMENTPAST16]], i32 -1
// CHECK16-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT17]]) #[[ATTR4]]
// CHECK16-NEXT:    [[ARRAYDESTROY_DONE18:%.*]] = icmp eq %struct.S* [[ARRAYDESTROY_ELEMENT17]], [[ARRAY_BEGIN14]]
// CHECK16-NEXT:    br i1 [[ARRAYDESTROY_DONE18]], label [[ARRAYDESTROY_DONE19:%.*]], label [[ARRAYDESTROY_BODY15]]
// CHECK16:       arraydestroy.done19:
// CHECK16-NEXT:    call void @_ZN1SIfED1Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK16-NEXT:    [[TMP30:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK16-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK16-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    call void @_ZN1SIfEC2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK16-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK16-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK16-NEXT:    call void @_ZN1SIfEC2Ef(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK16-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    call void @_ZN1SIfED2Ev(%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK16-SAME: () #[[ATTR3:[0-9]+]] comdat {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK16-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK16-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK16-NEXT:    [[VAR:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    [[TMP:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK16-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK16-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0]], align 4
// CHECK16-NEXT:    [[_TMP6:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK16-NEXT:    store i32 0, i32* [[T_VAR]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP0]], i8* align 4 bitcast ([2 x i32]* @__const._Z5tmainIiET_v.vec to i8*), i32 8, i1 false)
// CHECK16-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK16-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// CHECK16-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYINIT_BEGIN]], i32 1
// CHECK16-NEXT:    call void @_ZN1SIiEC1Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK16-NEXT:    store %struct.S.0* [[TEST]], %struct.S.0** [[VAR]], align 4
// CHECK16-NEXT:    [[TMP1:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK16-NEXT:    store %struct.S.0* [[TMP1]], %struct.S.0** [[TMP]], align 4
// CHECK16-NEXT:    [[TMP2:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK16-NEXT:    [[TMP3:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK16-NEXT:    [[TMP4:%.*]] = load %struct.S.0*, %struct.S.0** [[VAR]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 1, i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK16-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN]], i32 2
// CHECK16-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK16:       arrayctor.loop:
// CHECK16-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[ARRAYCTOR_LOOP]] ]
// CHECK16-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK16-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYCTOR_CUR]], i32 1
// CHECK16-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK16-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK16:       arrayctor.cont:
// CHECK16-NEXT:    [[TMP6:%.*]] = load %struct.S.0*, %struct.S.0** [[TMP]], align 4
// CHECK16-NEXT:    call void @_ZN1SIiEC1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]])
// CHECK16-NEXT:    store %struct.S.0* [[VAR5]], %struct.S.0** [[_TMP6]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK16-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK16:       omp.inner.for.cond.cleanup:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK16-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK16-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[TMP10:%.*]] = load i32, i32* [[T_VAR2]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], [2 x i32]* [[VEC3]], i32 0, i32 [[TMP11]]
// CHECK16-NEXT:    store i32 [[TMP10]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[TMP12:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 [[TMP13]]
// CHECK16-NEXT:    [[TMP14:%.*]] = bitcast %struct.S.0* [[ARRAYIDX7]] to i8*
// CHECK16-NEXT:    [[TMP15:%.*]] = bitcast %struct.S.0* [[TMP12]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP14]], i8* align 4 [[TMP15]], i32 4, i1 false), !llvm.access.group !7
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK16-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    store i32 2, i32* [[I]], align 4
// CHECK16-NEXT:    [[TMP17:%.*]] = load i32, i32* [[T_VAR2]], align 4
// CHECK16-NEXT:    store i32 [[TMP17]], i32* [[T_VAR]], align 4
// CHECK16-NEXT:    [[TMP18:%.*]] = bitcast [2 x i32]* [[VEC]] to i8*
// CHECK16-NEXT:    [[TMP19:%.*]] = bitcast [2 x i32]* [[VEC3]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP18]], i8* align 4 [[TMP19]], i32 8, i1 false)
// CHECK16-NEXT:    [[ARRAY_BEGIN9:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK16-NEXT:    [[TMP20:%.*]] = bitcast [2 x %struct.S.0]* [[S_ARR4]] to %struct.S.0*
// CHECK16-NEXT:    [[TMP21:%.*]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN9]], i32 2
// CHECK16-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq %struct.S.0* [[ARRAY_BEGIN9]], [[TMP21]]
// CHECK16-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE10:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK16:       omp.arraycpy.body:
// CHECK16-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP20]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK16-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi %struct.S.0* [ [[ARRAY_BEGIN9]], [[OMP_INNER_FOR_END]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK16-NEXT:    [[TMP22:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]] to i8*
// CHECK16-NEXT:    [[TMP23:%.*]] = bitcast %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP22]], i8* align 4 [[TMP23]], i32 4, i1 false)
// CHECK16-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK16-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], %struct.S.0* [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK16-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq %struct.S.0* [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP21]]
// CHECK16-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE10]], label [[OMP_ARRAYCPY_BODY]]
// CHECK16:       omp.arraycpy.done10:
// CHECK16-NEXT:    [[TMP24:%.*]] = load %struct.S.0*, %struct.S.0** [[_TMP6]], align 4
// CHECK16-NEXT:    [[TMP25:%.*]] = bitcast %struct.S.0* [[TMP6]] to i8*
// CHECK16-NEXT:    [[TMP26:%.*]] = bitcast %struct.S.0* [[TMP24]] to i8*
// CHECK16-NEXT:    call void @llvm.memcpy.p0i8.p0i8.i32(i8* align 4 [[TMP25]], i8* align 4 [[TMP26]], i32 4, i1 false)
// CHECK16-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK16-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR4]], i32 0, i32 0
// CHECK16-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN11]], i32 2
// CHECK16-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK16:       arraydestroy.body:
// CHECK16-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi %struct.S.0* [ [[TMP27]], [[OMP_ARRAYCPY_DONE10]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK16-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK16-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK16-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK16-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK16:       arraydestroy.done12:
// CHECK16-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK16-NEXT:    [[ARRAY_BEGIN13:%.*]] = getelementptr inbounds [2 x %struct.S.0], [2 x %struct.S.0]* [[S_ARR]], i32 0, i32 0
// CHECK16-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAY_BEGIN13]], i32 2
// CHECK16-NEXT:    br label [[ARRAYDESTROY_BODY14:%.*]]
// CHECK16:       arraydestroy.body14:
// CHECK16-NEXT:    [[ARRAYDESTROY_ELEMENTPAST15:%.*]] = phi %struct.S.0* [ [[TMP28]], [[ARRAYDESTROY_DONE12]] ], [ [[ARRAYDESTROY_ELEMENT16:%.*]], [[ARRAYDESTROY_BODY14]] ]
// CHECK16-NEXT:    [[ARRAYDESTROY_ELEMENT16]] = getelementptr inbounds [[STRUCT_S_0]], %struct.S.0* [[ARRAYDESTROY_ELEMENTPAST15]], i32 -1
// CHECK16-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT16]]) #[[ATTR4]]
// CHECK16-NEXT:    [[ARRAYDESTROY_DONE17:%.*]] = icmp eq %struct.S.0* [[ARRAYDESTROY_ELEMENT16]], [[ARRAY_BEGIN13]]
// CHECK16-NEXT:    br i1 [[ARRAYDESTROY_DONE17]], label [[ARRAYDESTROY_DONE18:%.*]], label [[ARRAYDESTROY_BODY14]]
// CHECK16:       arraydestroy.done18:
// CHECK16-NEXT:    call void @_ZN1SIiED1Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK16-NEXT:    [[TMP29:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK16-NEXT:    ret i32 [[TMP29]]
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK16-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK16-NEXT:    store float 0.000000e+00, float* [[F]], align 4
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK16-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK16-SAME: (%struct.S* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S*, align 4
// CHECK16-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK16-NEXT:    store %struct.S* [[THIS]], %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    store float [[A]], float* [[A_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S*, %struct.S** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], %struct.S* [[THIS1]], i32 0, i32 0
// CHECK16-NEXT:    [[TMP0:%.*]] = load float, float* [[A_ADDR]], align 4
// CHECK16-NEXT:    store float [[TMP0]], float* [[F]], align 4
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK16-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    call void @_ZN1SIiEC2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK16-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK16-NEXT:    call void @_ZN1SIiEC2Ei(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK16-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    call void @_ZN1SIiED2Ev(%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK16-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK16-NEXT:    store i32 0, i32* [[F]], align 4
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK16-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    store i32 [[A]], i32* [[A_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], %struct.S.0* [[THIS1]], i32 0, i32 0
// CHECK16-NEXT:    [[TMP0:%.*]] = load i32, i32* [[A_ADDR]], align 4
// CHECK16-NEXT:    store i32 [[TMP0]], i32* [[F]], align 4
// CHECK16-NEXT:    ret void
//
//
// CHECK16-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK16-SAME: (%struct.S.0* noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.S.0*, align 4
// CHECK16-NEXT:    store %struct.S.0* [[THIS]], %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    [[THIS1:%.*]] = load %struct.S.0*, %struct.S.0** [[THIS_ADDR]], align 4
// CHECK16-NEXT:    ret void
//
