; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64--linux-gnu -mattr=+sve < %s | FileCheck %s

; Ensure we use the CC result of SVE compare instructions when branching.
define void @sve_cmplt_setcc(<vscale x 8 x i16>* %out, <vscale x 8 x i16> %in, <vscale x 8 x i1> %pg) {
; CHECK-LABEL: sve_cmplt_setcc:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmplt p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    b.eq .LBB0_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:  .LBB0_2: // %if.end
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i1> @llvm.aarch64.sve.cmplt.wide.nxv8i16(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %in, <vscale x 2 x i64> zeroinitializer)
  %1 = tail call i1 @llvm.aarch64.sve.ptest.any.nxv8i1(<vscale x 8 x i1> %pg, <vscale x 8 x i1> %0)
  br i1 %1, label %if.then, label %if.end

if.then:
  tail call void @llvm.masked.store.nxv8i16.p0nxv8i16(<vscale x 8 x i16> %in, <vscale x 8 x i16>* %out, i32 2, <vscale x 8 x i1> %pg)
  br label %if.end

if.end:
  ret void
}

; Ensure we use the inverted CC result of SVE compare instructions when branching.
define void @sve_cmplt_setcc_inverted(<vscale x 8 x i16>* %out, <vscale x 8 x i16> %in, <vscale x 8 x i1> %pg) {
; CHECK-LABEL: sve_cmplt_setcc_inverted:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmplt p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    b.ne .LBB1_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:  .LBB1_2: // %if.end
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i1> @llvm.aarch64.sve.cmplt.wide.nxv8i16(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %in, <vscale x 2 x i64> zeroinitializer)
  %1 = tail call i1 @llvm.aarch64.sve.ptest.any.nxv8i1(<vscale x 8 x i1> %pg, <vscale x 8 x i1> %0)
  br i1 %1, label %if.end, label %if.then

if.then:
  tail call void @llvm.masked.store.nxv8i16.p0nxv8i16(<vscale x 8 x i16> %in, <vscale x 8 x i16>* %out, i32 2, <vscale x 8 x i1> %pg)
  br label %if.end

if.end:
  ret void
}

; Ensure we combine setcc and csel so as to not end up with an extra compare
define void @sve_cmplt_setcc_hslo(<vscale x 8 x i16>* %out, <vscale x 8 x i16> %in, <vscale x 8 x i1> %pg) {
; CHECK-LABEL: sve_cmplt_setcc_hslo:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmplt p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    b.hs .LBB2_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:  .LBB2_2: // %if.end
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i1> @llvm.aarch64.sve.cmplt.wide.nxv8i16(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %in, <vscale x 2 x i64> zeroinitializer)
  %1 = tail call i1 @llvm.aarch64.sve.ptest.last.nxv8i1(<vscale x 8 x i1> %pg, <vscale x 8 x i1> %0)
  br i1 %1, label %if.then, label %if.end

if.then:
  tail call void @llvm.masked.store.nxv8i16.p0nxv8i16(<vscale x 8 x i16> %in, <vscale x 8 x i16>* %out, i32 2, <vscale x 8 x i1> %pg)
  br label %if.end

if.end:
  ret void
}

; Fold away the redundant setcc::
;    setcc(ne, <all ones>, sext(nxvNi1 ...), splat(0))
; -> nxvNi1 ...
define <vscale x 16 x i1> @sve_cmpne_setcc_all_true_sext(<vscale x 16 x i8> %vec, <vscale x 16 x i1> %pg) {
; CHECK-LABEL: sve_cmpne_setcc_all_true_sext:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %alltrue.ins = insertelement <vscale x 16 x i1> poison, i1 true, i32 0
  %alltrue = shufflevector <vscale x 16 x i1> %alltrue.ins, <vscale x 16 x i1> poison, <vscale x 16 x i32> zeroinitializer
  %pg.sext = sext <vscale x 16 x i1> %pg to <vscale x 16 x i8>
  %cmp2 = call <vscale x 16 x i1> @llvm.aarch64.sve.cmpne.nxv16i8(<vscale x 16 x i1> %alltrue, <vscale x 16 x i8> %pg.sext, <vscale x 16 x i8> zeroinitializer)
  ret <vscale x 16 x i1> %cmp2
}

; Fold away the redundant setcc::
;    setcc(ne, pred, sext(setcc(ne, pred, ..., splat(0))), splat(0))
; -> setcc(ne, pred, ..., splat(0))
define <vscale x 16 x i1> @sve_cmpne_setcc_equal_pred(<vscale x 16 x i8> %vec, <vscale x 16 x i1> %pg) {
; CHECK-LABEL: sve_cmpne_setcc_equal_pred:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmpne p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    ret
  %cmp1 = call <vscale x 16 x i1> @llvm.aarch64.sve.cmpne.nxv16i8(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %vec, <vscale x 16 x i8> zeroinitializer)
  %cmp1.sext = sext <vscale x 16 x i1> %cmp1 to <vscale x 16 x i8>
  %cmp2 = call <vscale x 16 x i1> @llvm.aarch64.sve.cmpne.nxv16i8(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %cmp1.sext, <vscale x 16 x i8> zeroinitializer)
  ret <vscale x 16 x i1> %cmp2
}

; Combine:
;    setcc(ne, pred1, sext(setcc(ne, pred2, ..., splat(0))), splat(0))
; -> setcc(ne, and(pred1, pred2), ..., splat(0))
define <vscale x 16 x i1> @sve_cmpne_setcc_different_pred(<vscale x 16 x i8> %vec, <vscale x 16 x i1> %pg1, <vscale x 16 x i1> %pg2) {
; CHECK-LABEL: sve_cmpne_setcc_different_pred:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmpne p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    and p0.b, p0/z, p0.b, p1.b
; CHECK-NEXT:    ret
  %cmp1 = call <vscale x 16 x i1> @llvm.aarch64.sve.cmpne.nxv16i8(<vscale x 16 x i1> %pg1, <vscale x 16 x i8> %vec, <vscale x 16 x i8> zeroinitializer)
  %cmp1.sext = sext <vscale x 16 x i1> %cmp1 to <vscale x 16 x i8>
  %cmp2 = call <vscale x 16 x i1> @llvm.aarch64.sve.cmpne.nxv16i8(<vscale x 16 x i1> %pg2, <vscale x 16 x i8> %cmp1.sext, <vscale x 16 x i8> zeroinitializer)
  ret <vscale x 16 x i1> %cmp2
}

declare <vscale x 16 x i1> @llvm.aarch64.sve.cmpne.nxv16i8(<vscale x 16 x i1>, <vscale x 16 x i8>, <vscale x 16 x i8>)

declare i1 @llvm.aarch64.sve.ptest.any.nxv8i1(<vscale x 8 x i1>, <vscale x 8 x i1>)
declare i1 @llvm.aarch64.sve.ptest.last.nxv8i1(<vscale x 8 x i1>, <vscale x 8 x i1>)

declare <vscale x 8 x i1> @llvm.aarch64.sve.cmplt.wide.nxv8i16(<vscale x 8 x i1>, <vscale x 8 x i16>, <vscale x 2 x i64>)

declare void @llvm.masked.store.nxv8i16.p0nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i16>*, i32, <vscale x 8 x i1>)
