// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK3

// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// expected-no-diagnostics
#ifndef HEADER
#define HEADER



double Ga = 1.0;
double Gb = 2.0;
double Gc = 3.0;
double Gd = 4.0;

int foo(short a, short b, short c, short d){
  static float Sa = 5.0;
  static float Sb = 6.0;
  static float Sc = 7.0;
  static float Sd = 8.0;


  // 3 local vars being captured.




  // 3 static vars being captured.




  // 3 static global vars being captured.




  // Capture b, Gb, Sb, Gc, c, Sc, d, Gd, Sd
  #pragma omp target if(Ga>0.0 && a>0 && Sa>0.0)
  {
    b += 1;
    Gb += 1.0;
    Sb += 1.0;

    // The parallel region only uses 3 captures.
    // Capture d, Gd, Sd,

    #pragma omp parallel if(Gc>0.0 && c>0 && Sc>0.0)
    {
      d += 1;
      Gd += 1.0;
      Sd += 1.0;
    }
  }
  return a + b + c + d + (int)Sa + (int)Sb + (int)Sc + (int)Sd;
}

int bar(short a, short b, short c, short d){
  static float Sa = 9.0;
  static float Sb = 10.0;
  static float Sc = 11.0;
  static float Sd = 12.0;

  // Capture a, b, c, d
  #pragma omp parallel
  {

    // 3 local vars being captured.




    // 3 static vars being captured.




    // 3 static global vars being captured.




    // Capture b, Gb, Sb, Gc, c, Sc, d, Gd, Sd
    #pragma omp target if(Ga>0.0 && a>0 && Sa>0.0)
    {
      b += 1;
      Gb += 1.0;
      Sb += 1.0;


      // Capture d, Gd, Sd
      #pragma omp parallel if(Gc>0.0 && c>0 && Sc>0.0)
      {
        d += 1;
        Gd += 1.0;
        Sd += 1.0;
      }
    }
  }
  return a + b + c + d + (int)Sa + (int)Sb + (int)Sc + (int)Sd;
}

///
/// Tests with template functions.
///


template<typename T>
int tbar(T a, T b, T c, T d){
  static float Sa = 17.0;
  static float Sb = 18.0;
  static float Sc = 19.0;
  static float Sd = 20.0;

  // Capture a, b, c, d
  #pragma omp parallel
  {

    // 3 local vars being captured.




    // 3 static vars being captured.




    // 3 static global vars being captured.




    // Capture b, Gb, Sb, Gc, c, Sc, d, Gd, Sd
    #pragma omp target if(Ga>0.0 && a>0 && Sa>0.0)
    {
      b += 1;
      Gb += 1.0;
      Sb += 1.0;


      // Capture d, Gd, Sd
      #pragma omp parallel if(Gc>0.0 && c>0 && Sc>0.0)
      {
        d += 1;
        Gd += 1.0;
        Sd += 1.0;
      }
    }
  }
  return a + b + c + d + (int)Sa + (int)Sb + (int)Sc + (int)Sd;
}

int tbar2(short a, short b, short c, short d){
  return tbar(a, b, c, d);
}

#endif
// CHECK1-LABEL: define {{[^@]+}}@_Z3foossss
// CHECK1-SAME: (i16 noundef signext [[A:%.*]], i16 noundef signext [[B:%.*]], i16 noundef signext [[C:%.*]], i16 noundef signext [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GB_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SB_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GC_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SC_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[D_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GD_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SD_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    store i16 [[A]], ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[B]], ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[C]], ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[D]], ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    [[TMP0:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[TMP0]], ptr [[B_CASTED]], align 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load double, ptr @Gb, align 8
// CHECK1-NEXT:    store double [[TMP2]], ptr [[GB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, ptr [[GB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load float, ptr @_ZZ3foossssE2Sb, align 4
// CHECK1-NEXT:    store float [[TMP4]], ptr [[SB_CASTED]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, ptr [[SB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load double, ptr @Gc, align 8
// CHECK1-NEXT:    store double [[TMP6]], ptr [[GC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, ptr [[GC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[TMP8]], ptr [[C_CASTED]], align 2
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load float, ptr @_ZZ3foossssE2Sc, align 4
// CHECK1-NEXT:    store float [[TMP10]], ptr [[SC_CASTED]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[SC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[TMP12]], ptr [[D_CASTED]], align 2
// CHECK1-NEXT:    [[TMP13:%.*]] = load i64, ptr [[D_CASTED]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load double, ptr @Gd, align 8
// CHECK1-NEXT:    store double [[TMP14]], ptr [[GD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i64, ptr [[GD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load float, ptr @_ZZ3foossssE2Sd, align 4
// CHECK1-NEXT:    store float [[TMP16]], ptr [[SD_CASTED]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i64, ptr [[SD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = load double, ptr @Ga, align 8
// CHECK1-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP18]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       land.lhs.true:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP19]] to i32
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sgt i32 [[CONV]], 0
// CHECK1-NEXT:    br i1 [[CMP1]], label [[LAND_LHS_TRUE2:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       land.lhs.true2:
// CHECK1-NEXT:    [[TMP20:%.*]] = load float, ptr @_ZZ3foossssE2Sa, align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP20]] to double
// CHECK1-NEXT:    [[CMP4:%.*]] = fcmp ogt double [[CONV3]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP1]], ptr [[TMP21]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP1]], ptr [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP3]], ptr [[TMP24]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP3]], ptr [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store ptr null, ptr [[TMP26]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    store i64 [[TMP5]], ptr [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    store i64 [[TMP5]], ptr [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store ptr null, ptr [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP7]], ptr [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP7]], ptr [[TMP31]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store ptr null, ptr [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[TMP34]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK1-NEXT:    store ptr null, ptr [[TMP35]], align 8
// CHECK1-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[TMP36]], align 8
// CHECK1-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[TMP37]], align 8
// CHECK1-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK1-NEXT:    store ptr null, ptr [[TMP38]], align 8
// CHECK1-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[TMP39]], align 8
// CHECK1-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[TMP40]], align 8
// CHECK1-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP41]], align 8
// CHECK1-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// CHECK1-NEXT:    store i64 [[TMP15]], ptr [[TMP42]], align 8
// CHECK1-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// CHECK1-NEXT:    store i64 [[TMP15]], ptr [[TMP43]], align 8
// CHECK1-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP44]], align 8
// CHECK1-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 [[TMP17]], ptr [[TMP45]], align 8
// CHECK1-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 [[TMP17]], ptr [[TMP46]], align 8
// CHECK1-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 8
// CHECK1-NEXT:    store ptr null, ptr [[TMP47]], align 8
// CHECK1-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK1-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK1-NEXT:    store i32 1, ptr [[TMP50]], align 4
// CHECK1-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK1-NEXT:    store i32 9, ptr [[TMP51]], align 4
// CHECK1-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP48]], ptr [[TMP52]], align 8
// CHECK1-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP49]], ptr [[TMP53]], align 8
// CHECK1-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes, ptr [[TMP54]], align 8
// CHECK1-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes, ptr [[TMP55]], align 8
// CHECK1-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP56]], align 8
// CHECK1-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP57]], align 8
// CHECK1-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP58]], align 8
// CHECK1-NEXT:    [[TMP59:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 -1, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3foossss_l49.region_id, ptr [[KERNEL_ARGS]])
// CHECK1-NEXT:    [[TMP60:%.*]] = icmp ne i32 [[TMP59]], 0
// CHECK1-NEXT:    br i1 [[TMP60]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3foossss_l49(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], i64 [[TMP7]], i64 [[TMP9]], i64 [[TMP11]], i64 [[TMP13]], i64 [[TMP15]], i64 [[TMP17]]) #[[ATTR2:[0-9]+]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3foossss_l49(i64 [[TMP1]], i64 [[TMP3]], i64 [[TMP5]], i64 [[TMP7]], i64 [[TMP9]], i64 [[TMP11]], i64 [[TMP13]], i64 [[TMP15]], i64 [[TMP17]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP61:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    [[CONV5:%.*]] = sext i16 [[TMP61]] to i32
// CHECK1-NEXT:    [[TMP62:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP62]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV5]], [[CONV6]]
// CHECK1-NEXT:    [[TMP63:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    [[CONV7:%.*]] = sext i16 [[TMP63]] to i32
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[ADD]], [[CONV7]]
// CHECK1-NEXT:    [[TMP64:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    [[CONV9:%.*]] = sext i16 [[TMP64]] to i32
// CHECK1-NEXT:    [[ADD10:%.*]] = add nsw i32 [[ADD8]], [[CONV9]]
// CHECK1-NEXT:    [[TMP65:%.*]] = load float, ptr @_ZZ3foossssE2Sa, align 4
// CHECK1-NEXT:    [[CONV11:%.*]] = fptosi float [[TMP65]] to i32
// CHECK1-NEXT:    [[ADD12:%.*]] = add nsw i32 [[ADD10]], [[CONV11]]
// CHECK1-NEXT:    [[TMP66:%.*]] = load float, ptr @_ZZ3foossssE2Sb, align 4
// CHECK1-NEXT:    [[CONV13:%.*]] = fptosi float [[TMP66]] to i32
// CHECK1-NEXT:    [[ADD14:%.*]] = add nsw i32 [[ADD12]], [[CONV13]]
// CHECK1-NEXT:    [[TMP67:%.*]] = load float, ptr @_ZZ3foossssE2Sc, align 4
// CHECK1-NEXT:    [[CONV15:%.*]] = fptosi float [[TMP67]] to i32
// CHECK1-NEXT:    [[ADD16:%.*]] = add nsw i32 [[ADD14]], [[CONV15]]
// CHECK1-NEXT:    [[TMP68:%.*]] = load float, ptr @_ZZ3foossssE2Sd, align 4
// CHECK1-NEXT:    [[CONV17:%.*]] = fptosi float [[TMP68]] to i32
// CHECK1-NEXT:    [[ADD18:%.*]] = add nsw i32 [[ADD16]], [[CONV17]]
// CHECK1-NEXT:    ret i32 [[ADD18]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3foossss_l49
// CHECK1-SAME: (i64 noundef [[B:%.*]], i64 noundef [[GB:%.*]], i64 noundef [[SB:%.*]], i64 noundef [[GC:%.*]], i64 noundef [[C:%.*]], i64 noundef [[SC:%.*]], i64 noundef [[D:%.*]], i64 noundef [[GD:%.*]], i64 noundef [[SD:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GB_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SB_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GC_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SC_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GD_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SD_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GB]], ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SB]], ptr [[SB_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GC]], ptr [[GC_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SC]], ptr [[SC_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GD]], ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SD]], ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK1-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV1]], ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[TMP2:%.*]] = load double, ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    [[ADD2:%.*]] = fadd double [[TMP2]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD2]], ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float, ptr [[SB_ADDR]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP3]] to double
// CHECK1-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK1-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK1-NEXT:    store float [[CONV5]], ptr [[SB_ADDR]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load double, ptr [[GC_ADDR]], align 8
// CHECK1-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP4]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       land.lhs.true:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP5]] to i32
// CHECK1-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[CONV6]], 0
// CHECK1-NEXT:    br i1 [[CMP7]], label [[LAND_LHS_TRUE8:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       land.lhs.true8:
// CHECK1-NEXT:    [[TMP6:%.*]] = load float, ptr [[SC_ADDR]], align 4
// CHECK1-NEXT:    [[CONV9:%.*]] = fpext float [[TMP6]] to double
// CHECK1-NEXT:    [[CMP10:%.*]] = fcmp ogt double [[CONV9]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP10]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @.omp_outlined., ptr [[D_ADDR]], ptr [[GD_ADDR]], ptr [[SD_ADDR]])
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK1-NEXT:    call void @.omp_outlined.(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[D_ADDR]], ptr [[GD_ADDR]], ptr [[SD_ADDR]]) #[[ATTR2]]
// CHECK1-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[GD:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SD:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[SD_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[SD]], ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK1-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV1]], ptr [[TMP0]], align 2
// CHECK1-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK1-NEXT:    [[ADD2:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD2]], ptr [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load float, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP5]] to double
// CHECK1-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK1-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK1-NEXT:    store float [[CONV5]], ptr [[TMP2]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z3barssss
// CHECK1-SAME: (i16 noundef signext [[A:%.*]], i16 noundef signext [[B:%.*]], i16 noundef signext [[C:%.*]], i16 noundef signext [[D:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    store i16 [[A]], ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[B]], ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[C]], ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[D]], ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @.omp_outlined..1, ptr [[A_ADDR]], ptr [[B_ADDR]], ptr [[C_ADDR]], ptr [[D_ADDR]])
// CHECK1-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK1-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[CONV1:%.*]] = sext i16 [[TMP1]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV1]]
// CHECK1-NEXT:    [[TMP2:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP2]] to i32
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[ADD]], [[CONV2]]
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP3]] to i32
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[ADD3]], [[CONV4]]
// CHECK1-NEXT:    [[TMP4:%.*]] = load float, ptr @_ZZ3barssssE2Sa, align 4
// CHECK1-NEXT:    [[CONV6:%.*]] = fptosi float [[TMP4]] to i32
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[ADD5]], [[CONV6]]
// CHECK1-NEXT:    [[TMP5:%.*]] = load float, ptr @_ZZ3barssssE2Sb, align 4
// CHECK1-NEXT:    [[CONV8:%.*]] = fptosi float [[TMP5]] to i32
// CHECK1-NEXT:    [[ADD9:%.*]] = add nsw i32 [[ADD7]], [[CONV8]]
// CHECK1-NEXT:    [[TMP6:%.*]] = load float, ptr @_ZZ3barssssE2Sc, align 4
// CHECK1-NEXT:    [[CONV10:%.*]] = fptosi float [[TMP6]] to i32
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[ADD9]], [[CONV10]]
// CHECK1-NEXT:    [[TMP7:%.*]] = load float, ptr @_ZZ3barssssE2Sd, align 4
// CHECK1-NEXT:    [[CONV12:%.*]] = fptosi float [[TMP7]] to i32
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i32 [[ADD11]], [[CONV12]]
// CHECK1-NEXT:    ret i32 [[ADD13]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[A:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[B:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[C:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GB_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SB_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GC_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SC_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[D_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GD_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SD_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i16, ptr [[TMP1]], align 2
// CHECK1-NEXT:    store i16 [[TMP4]], ptr [[B_CASTED]], align 2
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load double, ptr @Gb, align 8
// CHECK1-NEXT:    store double [[TMP6]], ptr [[GB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, ptr [[GB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load float, ptr @_ZZ3barssssE2Sb, align 4
// CHECK1-NEXT:    store float [[TMP8]], ptr [[SB_CASTED]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[SB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load double, ptr @Gc, align 8
// CHECK1-NEXT:    store double [[TMP10]], ptr [[GC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[GC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i16, ptr [[TMP2]], align 2
// CHECK1-NEXT:    store i16 [[TMP12]], ptr [[C_CASTED]], align 2
// CHECK1-NEXT:    [[TMP13:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load float, ptr @_ZZ3barssssE2Sc, align 4
// CHECK1-NEXT:    store float [[TMP14]], ptr [[SC_CASTED]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i64, ptr [[SC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i16, ptr [[TMP3]], align 2
// CHECK1-NEXT:    store i16 [[TMP16]], ptr [[D_CASTED]], align 2
// CHECK1-NEXT:    [[TMP17:%.*]] = load i64, ptr [[D_CASTED]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = load double, ptr @Gd, align 8
// CHECK1-NEXT:    store double [[TMP18]], ptr [[GD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = load i64, ptr [[GD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load float, ptr @_ZZ3barssssE2Sd, align 4
// CHECK1-NEXT:    store float [[TMP20]], ptr [[SD_CASTED]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i64, ptr [[SD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = load double, ptr @Ga, align 8
// CHECK1-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP22]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       land.lhs.true:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP23]] to i32
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sgt i32 [[CONV]], 0
// CHECK1-NEXT:    br i1 [[CMP1]], label [[LAND_LHS_TRUE2:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       land.lhs.true2:
// CHECK1-NEXT:    [[TMP24:%.*]] = load float, ptr @_ZZ3barssssE2Sa, align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP24]] to double
// CHECK1-NEXT:    [[CMP4:%.*]] = fcmp ogt double [[CONV3]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP5]], ptr [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP5]], ptr [[TMP26]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP7]], ptr [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP7]], ptr [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store ptr null, ptr [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[TMP31]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store ptr null, ptr [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[TMP34]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[TMP35]], align 8
// CHECK1-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store ptr null, ptr [[TMP36]], align 8
// CHECK1-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[TMP37]], align 8
// CHECK1-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[TMP38]], align 8
// CHECK1-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK1-NEXT:    store ptr null, ptr [[TMP39]], align 8
// CHECK1-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK1-NEXT:    store i64 [[TMP15]], ptr [[TMP40]], align 8
// CHECK1-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK1-NEXT:    store i64 [[TMP15]], ptr [[TMP41]], align 8
// CHECK1-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK1-NEXT:    store ptr null, ptr [[TMP42]], align 8
// CHECK1-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK1-NEXT:    store i64 [[TMP17]], ptr [[TMP43]], align 8
// CHECK1-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK1-NEXT:    store i64 [[TMP17]], ptr [[TMP44]], align 8
// CHECK1-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP45]], align 8
// CHECK1-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// CHECK1-NEXT:    store i64 [[TMP19]], ptr [[TMP46]], align 8
// CHECK1-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// CHECK1-NEXT:    store i64 [[TMP19]], ptr [[TMP47]], align 8
// CHECK1-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP48]], align 8
// CHECK1-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 [[TMP21]], ptr [[TMP49]], align 8
// CHECK1-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 [[TMP21]], ptr [[TMP50]], align 8
// CHECK1-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 8
// CHECK1-NEXT:    store ptr null, ptr [[TMP51]], align 8
// CHECK1-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK1-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK1-NEXT:    store i32 1, ptr [[TMP54]], align 4
// CHECK1-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK1-NEXT:    store i32 9, ptr [[TMP55]], align 4
// CHECK1-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP52]], ptr [[TMP56]], align 8
// CHECK1-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP53]], ptr [[TMP57]], align 8
// CHECK1-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes.3, ptr [[TMP58]], align 8
// CHECK1-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes.4, ptr [[TMP59]], align 8
// CHECK1-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP60]], align 8
// CHECK1-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP61]], align 8
// CHECK1-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP62]], align 8
// CHECK1-NEXT:    [[TMP63:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 -1, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3barssss_l94.region_id, ptr [[KERNEL_ARGS]])
// CHECK1-NEXT:    [[TMP64:%.*]] = icmp ne i32 [[TMP63]], 0
// CHECK1-NEXT:    br i1 [[TMP64]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3barssss_l94(i64 [[TMP5]], i64 [[TMP7]], i64 [[TMP9]], i64 [[TMP11]], i64 [[TMP13]], i64 [[TMP15]], i64 [[TMP17]], i64 [[TMP19]], i64 [[TMP21]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3barssss_l94(i64 [[TMP5]], i64 [[TMP7]], i64 [[TMP9]], i64 [[TMP11]], i64 [[TMP13]], i64 [[TMP15]], i64 [[TMP17]], i64 [[TMP19]], i64 [[TMP21]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3barssss_l94
// CHECK1-SAME: (i64 noundef [[B:%.*]], i64 noundef [[GB:%.*]], i64 noundef [[SB:%.*]], i64 noundef [[GC:%.*]], i64 noundef [[C:%.*]], i64 noundef [[SC:%.*]], i64 noundef [[D:%.*]], i64 noundef [[GD:%.*]], i64 noundef [[SD:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GB_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SB_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GC_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SC_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GD_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SD_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GB]], ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SB]], ptr [[SB_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GC]], ptr [[GC_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SC]], ptr [[SC_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GD]], ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SD]], ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK1-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV1]], ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[TMP2:%.*]] = load double, ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    [[ADD2:%.*]] = fadd double [[TMP2]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD2]], ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float, ptr [[SB_ADDR]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP3]] to double
// CHECK1-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK1-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK1-NEXT:    store float [[CONV5]], ptr [[SB_ADDR]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load double, ptr [[GC_ADDR]], align 8
// CHECK1-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP4]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       land.lhs.true:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP5]] to i32
// CHECK1-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[CONV6]], 0
// CHECK1-NEXT:    br i1 [[CMP7]], label [[LAND_LHS_TRUE8:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       land.lhs.true8:
// CHECK1-NEXT:    [[TMP6:%.*]] = load float, ptr [[SC_ADDR]], align 4
// CHECK1-NEXT:    [[CONV9:%.*]] = fpext float [[TMP6]] to double
// CHECK1-NEXT:    [[CMP10:%.*]] = fcmp ogt double [[CONV9]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP10]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @.omp_outlined..2, ptr [[D_ADDR]], ptr [[GD_ADDR]], ptr [[SD_ADDR]])
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK1-NEXT:    call void @.omp_outlined..2(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[D_ADDR]], ptr [[GD_ADDR]], ptr [[SD_ADDR]]) #[[ATTR2]]
// CHECK1-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[GD:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SD:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[SD_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[SD]], ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK1-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV1]], ptr [[TMP0]], align 2
// CHECK1-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK1-NEXT:    [[ADD2:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD2]], ptr [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load float, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP5]] to double
// CHECK1-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK1-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK1-NEXT:    store float [[CONV5]], ptr [[TMP2]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z5tbar2ssss
// CHECK1-SAME: (i16 noundef signext [[A:%.*]], i16 noundef signext [[B:%.*]], i16 noundef signext [[C:%.*]], i16 noundef signext [[D:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    store i16 [[A]], ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[B]], ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[C]], ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[D]], ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[TMP2:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z4tbarIsEiT_S0_S0_S0_(i16 noundef signext [[TMP0]], i16 noundef signext [[TMP1]], i16 noundef signext [[TMP2]], i16 noundef signext [[TMP3]])
// CHECK1-NEXT:    ret i32 [[CALL]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z4tbarIsEiT_S0_S0_S0_
// CHECK1-SAME: (i16 noundef signext [[A:%.*]], i16 noundef signext [[B:%.*]], i16 noundef signext [[C:%.*]], i16 noundef signext [[D:%.*]]) #[[ATTR0]] comdat {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    store i16 [[A]], ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[B]], ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[C]], ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    store i16 [[D]], ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @.omp_outlined..5, ptr [[A_ADDR]], ptr [[B_ADDR]], ptr [[C_ADDR]], ptr [[D_ADDR]])
// CHECK1-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK1-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[CONV1:%.*]] = sext i16 [[TMP1]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV1]]
// CHECK1-NEXT:    [[TMP2:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP2]] to i32
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[ADD]], [[CONV2]]
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK1-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP3]] to i32
// CHECK1-NEXT:    [[ADD5:%.*]] = add nsw i32 [[ADD3]], [[CONV4]]
// CHECK1-NEXT:    [[TMP4:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sa, align 4
// CHECK1-NEXT:    [[CONV6:%.*]] = fptosi float [[TMP4]] to i32
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[ADD5]], [[CONV6]]
// CHECK1-NEXT:    [[TMP5:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sb, align 4
// CHECK1-NEXT:    [[CONV8:%.*]] = fptosi float [[TMP5]] to i32
// CHECK1-NEXT:    [[ADD9:%.*]] = add nsw i32 [[ADD7]], [[CONV8]]
// CHECK1-NEXT:    [[TMP6:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sc, align 4
// CHECK1-NEXT:    [[CONV10:%.*]] = fptosi float [[TMP6]] to i32
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 [[ADD9]], [[CONV10]]
// CHECK1-NEXT:    [[TMP7:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sd, align 4
// CHECK1-NEXT:    [[CONV12:%.*]] = fptosi float [[TMP7]] to i32
// CHECK1-NEXT:    [[ADD13:%.*]] = add nsw i32 [[ADD11]], [[CONV12]]
// CHECK1-NEXT:    ret i32 [[ADD13]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..5
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[A:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[B:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[C:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GB_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SB_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GC_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SC_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[D_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GD_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SD_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [9 x ptr], align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i16, ptr [[TMP1]], align 2
// CHECK1-NEXT:    store i16 [[TMP4]], ptr [[B_CASTED]], align 2
// CHECK1-NEXT:    [[TMP5:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load double, ptr @Gb, align 8
// CHECK1-NEXT:    store double [[TMP6]], ptr [[GB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i64, ptr [[GB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sb, align 4
// CHECK1-NEXT:    store float [[TMP8]], ptr [[SB_CASTED]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[SB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load double, ptr @Gc, align 8
// CHECK1-NEXT:    store double [[TMP10]], ptr [[GC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[GC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i16, ptr [[TMP2]], align 2
// CHECK1-NEXT:    store i16 [[TMP12]], ptr [[C_CASTED]], align 2
// CHECK1-NEXT:    [[TMP13:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sc, align 4
// CHECK1-NEXT:    store float [[TMP14]], ptr [[SC_CASTED]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i64, ptr [[SC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i16, ptr [[TMP3]], align 2
// CHECK1-NEXT:    store i16 [[TMP16]], ptr [[D_CASTED]], align 2
// CHECK1-NEXT:    [[TMP17:%.*]] = load i64, ptr [[D_CASTED]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = load double, ptr @Gd, align 8
// CHECK1-NEXT:    store double [[TMP18]], ptr [[GD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = load i64, ptr [[GD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sd, align 4
// CHECK1-NEXT:    store float [[TMP20]], ptr [[SD_CASTED]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i64, ptr [[SD_CASTED]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = load double, ptr @Ga, align 8
// CHECK1-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP22]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       land.lhs.true:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP23]] to i32
// CHECK1-NEXT:    [[CMP1:%.*]] = icmp sgt i32 [[CONV]], 0
// CHECK1-NEXT:    br i1 [[CMP1]], label [[LAND_LHS_TRUE2:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       land.lhs.true2:
// CHECK1-NEXT:    [[TMP24:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sa, align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP24]] to double
// CHECK1-NEXT:    [[CMP4:%.*]] = fcmp ogt double [[CONV3]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP5]], ptr [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP5]], ptr [[TMP26]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP7]], ptr [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP7]], ptr [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store ptr null, ptr [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[TMP31]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store ptr null, ptr [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[TMP34]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[TMP35]], align 8
// CHECK1-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store ptr null, ptr [[TMP36]], align 8
// CHECK1-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[TMP37]], align 8
// CHECK1-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[TMP38]], align 8
// CHECK1-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK1-NEXT:    store ptr null, ptr [[TMP39]], align 8
// CHECK1-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK1-NEXT:    store i64 [[TMP15]], ptr [[TMP40]], align 8
// CHECK1-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK1-NEXT:    store i64 [[TMP15]], ptr [[TMP41]], align 8
// CHECK1-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK1-NEXT:    store ptr null, ptr [[TMP42]], align 8
// CHECK1-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK1-NEXT:    store i64 [[TMP17]], ptr [[TMP43]], align 8
// CHECK1-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK1-NEXT:    store i64 [[TMP17]], ptr [[TMP44]], align 8
// CHECK1-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP45]], align 8
// CHECK1-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// CHECK1-NEXT:    store i64 [[TMP19]], ptr [[TMP46]], align 8
// CHECK1-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// CHECK1-NEXT:    store i64 [[TMP19]], ptr [[TMP47]], align 8
// CHECK1-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP48]], align 8
// CHECK1-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 [[TMP21]], ptr [[TMP49]], align 8
// CHECK1-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 [[TMP21]], ptr [[TMP50]], align 8
// CHECK1-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 8
// CHECK1-NEXT:    store ptr null, ptr [[TMP51]], align 8
// CHECK1-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK1-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK1-NEXT:    store i32 1, ptr [[TMP54]], align 4
// CHECK1-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK1-NEXT:    store i32 9, ptr [[TMP55]], align 4
// CHECK1-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP52]], ptr [[TMP56]], align 8
// CHECK1-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP53]], ptr [[TMP57]], align 8
// CHECK1-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes.7, ptr [[TMP58]], align 8
// CHECK1-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes.8, ptr [[TMP59]], align 8
// CHECK1-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP60]], align 8
// CHECK1-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP61]], align 8
// CHECK1-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP62]], align 8
// CHECK1-NEXT:    [[TMP63:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 -1, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z4tbarIsEiT_S0_S0_S0__l145.region_id, ptr [[KERNEL_ARGS]])
// CHECK1-NEXT:    [[TMP64:%.*]] = icmp ne i32 [[TMP63]], 0
// CHECK1-NEXT:    br i1 [[TMP64]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z4tbarIsEiT_S0_S0_S0__l145(i64 [[TMP5]], i64 [[TMP7]], i64 [[TMP9]], i64 [[TMP11]], i64 [[TMP13]], i64 [[TMP15]], i64 [[TMP17]], i64 [[TMP19]], i64 [[TMP21]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z4tbarIsEiT_S0_S0_S0__l145(i64 [[TMP5]], i64 [[TMP7]], i64 [[TMP9]], i64 [[TMP11]], i64 [[TMP13]], i64 [[TMP15]], i64 [[TMP17]], i64 [[TMP19]], i64 [[TMP21]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z4tbarIsEiT_S0_S0_S0__l145
// CHECK1-SAME: (i64 noundef [[B:%.*]], i64 noundef [[GB:%.*]], i64 noundef [[SB:%.*]], i64 noundef [[GC:%.*]], i64 noundef [[C:%.*]], i64 noundef [[SC:%.*]], i64 noundef [[D:%.*]], i64 noundef [[GD:%.*]], i64 noundef [[SD:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GB_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SB_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GC_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SC_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GD_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SD_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GB]], ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SB]], ptr [[SB_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GC]], ptr [[GC_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SC]], ptr [[SC_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GD]], ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SD]], ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK1-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV1]], ptr [[B_ADDR]], align 2
// CHECK1-NEXT:    [[TMP2:%.*]] = load double, ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    [[ADD2:%.*]] = fadd double [[TMP2]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD2]], ptr [[GB_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load float, ptr [[SB_ADDR]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP3]] to double
// CHECK1-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK1-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK1-NEXT:    store float [[CONV5]], ptr [[SB_ADDR]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load double, ptr [[GC_ADDR]], align 8
// CHECK1-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP4]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       land.lhs.true:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK1-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP5]] to i32
// CHECK1-NEXT:    [[CMP7:%.*]] = icmp sgt i32 [[CONV6]], 0
// CHECK1-NEXT:    br i1 [[CMP7]], label [[LAND_LHS_TRUE8:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       land.lhs.true8:
// CHECK1-NEXT:    [[TMP6:%.*]] = load float, ptr [[SC_ADDR]], align 4
// CHECK1-NEXT:    [[CONV9:%.*]] = fpext float [[TMP6]] to double
// CHECK1-NEXT:    [[CMP10:%.*]] = fcmp ogt double [[CONV9]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[CMP10]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @.omp_outlined..6, ptr [[D_ADDR]], ptr [[GD_ADDR]], ptr [[SD_ADDR]])
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK1-NEXT:    call void @.omp_outlined..6(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[D_ADDR]], ptr [[GD_ADDR]], ptr [[SD_ADDR]]) #[[ATTR2]]
// CHECK1-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[GD:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SD:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[SD_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[SD]], ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[SD_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK1-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV1]], ptr [[TMP0]], align 2
// CHECK1-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK1-NEXT:    [[ADD2:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK1-NEXT:    store double [[ADD2]], ptr [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load float, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = fpext float [[TMP5]] to double
// CHECK1-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK1-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK1-NEXT:    store float [[CONV5]], ptr [[TMP2]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z3foossss
// CHECK3-SAME: (i16 noundef signext [[A:%.*]], i16 noundef signext [[B:%.*]], i16 noundef signext [[C:%.*]], i16 noundef signext [[D:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SB_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SC_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[D_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SD_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    store i16 [[A]], ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[B]], ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[C]], ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[D]], ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    [[TMP0:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[TMP0]], ptr [[B_CASTED]], align 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load float, ptr @_ZZ3foossssE2Sb, align 4
// CHECK3-NEXT:    store float [[TMP2]], ptr [[SB_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, ptr [[SB_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[TMP4]], ptr [[C_CASTED]], align 2
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, ptr [[C_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load float, ptr @_ZZ3foossssE2Sc, align 4
// CHECK3-NEXT:    store float [[TMP6]], ptr [[SC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, ptr [[SC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[TMP8]], ptr [[D_CASTED]], align 2
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, ptr [[D_CASTED]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load float, ptr @_ZZ3foossssE2Sd, align 4
// CHECK3-NEXT:    store float [[TMP10]], ptr [[SD_CASTED]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, ptr [[SD_CASTED]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load double, ptr @Ga, align 8
// CHECK3-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP12]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       land.lhs.true:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP13]] to i32
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sgt i32 [[CONV]], 0
// CHECK3-NEXT:    br i1 [[CMP1]], label [[LAND_LHS_TRUE2:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       land.lhs.true2:
// CHECK3-NEXT:    [[TMP14:%.*]] = load float, ptr @_ZZ3foossssE2Sa, align 4
// CHECK3-NEXT:    [[CONV3:%.*]] = fpext float [[TMP14]] to double
// CHECK3-NEXT:    [[CMP4:%.*]] = fcmp ogt double [[CONV3]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP1]], ptr [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP1]], ptr [[TMP16]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr @Gb, ptr [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr @Gb, ptr [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr null, ptr [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    store i32 [[TMP3]], ptr [[TMP21]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    store i32 [[TMP3]], ptr [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store ptr null, ptr [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr @Gc, ptr [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr @Gc, ptr [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr null, ptr [[TMP26]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP5]], ptr [[TMP27]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP5]], ptr [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK3-NEXT:    store ptr null, ptr [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK3-NEXT:    store i32 [[TMP7]], ptr [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK3-NEXT:    store i32 [[TMP7]], ptr [[TMP31]], align 4
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 5
// CHECK3-NEXT:    store ptr null, ptr [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK3-NEXT:    store i32 [[TMP9]], ptr [[TMP33]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK3-NEXT:    store i32 [[TMP9]], ptr [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP35]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr @Gd, ptr [[TMP36]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr @Gd, ptr [[TMP37]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP38]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 8
// CHECK3-NEXT:    store i32 [[TMP11]], ptr [[TMP39]], align 4
// CHECK3-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 8
// CHECK3-NEXT:    store i32 [[TMP11]], ptr [[TMP40]], align 4
// CHECK3-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 8
// CHECK3-NEXT:    store ptr null, ptr [[TMP41]], align 4
// CHECK3-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK3-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 1, ptr [[TMP44]], align 4
// CHECK3-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK3-NEXT:    store i32 9, ptr [[TMP45]], align 4
// CHECK3-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP42]], ptr [[TMP46]], align 4
// CHECK3-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP43]], ptr [[TMP47]], align 4
// CHECK3-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes, ptr [[TMP48]], align 4
// CHECK3-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes, ptr [[TMP49]], align 4
// CHECK3-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP50]], align 4
// CHECK3-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP51]], align 4
// CHECK3-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP52]], align 8
// CHECK3-NEXT:    [[TMP53:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 -1, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3foossss_l49.region_id, ptr [[KERNEL_ARGS]])
// CHECK3-NEXT:    [[TMP54:%.*]] = icmp ne i32 [[TMP53]], 0
// CHECK3-NEXT:    br i1 [[TMP54]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3foossss_l49(i32 [[TMP1]], ptr @Gb, i32 [[TMP3]], ptr @Gc, i32 [[TMP5]], i32 [[TMP7]], i32 [[TMP9]], ptr @Gd, i32 [[TMP11]]) #[[ATTR2:[0-9]+]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3foossss_l49(i32 [[TMP1]], ptr @Gb, i32 [[TMP3]], ptr @Gc, i32 [[TMP5]], i32 [[TMP7]], i32 [[TMP9]], ptr @Gd, i32 [[TMP11]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP55:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    [[CONV5:%.*]] = sext i16 [[TMP55]] to i32
// CHECK3-NEXT:    [[TMP56:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[CONV6:%.*]] = sext i16 [[TMP56]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV5]], [[CONV6]]
// CHECK3-NEXT:    [[TMP57:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    [[CONV7:%.*]] = sext i16 [[TMP57]] to i32
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[ADD]], [[CONV7]]
// CHECK3-NEXT:    [[TMP58:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    [[CONV9:%.*]] = sext i16 [[TMP58]] to i32
// CHECK3-NEXT:    [[ADD10:%.*]] = add nsw i32 [[ADD8]], [[CONV9]]
// CHECK3-NEXT:    [[TMP59:%.*]] = load float, ptr @_ZZ3foossssE2Sa, align 4
// CHECK3-NEXT:    [[CONV11:%.*]] = fptosi float [[TMP59]] to i32
// CHECK3-NEXT:    [[ADD12:%.*]] = add nsw i32 [[ADD10]], [[CONV11]]
// CHECK3-NEXT:    [[TMP60:%.*]] = load float, ptr @_ZZ3foossssE2Sb, align 4
// CHECK3-NEXT:    [[CONV13:%.*]] = fptosi float [[TMP60]] to i32
// CHECK3-NEXT:    [[ADD14:%.*]] = add nsw i32 [[ADD12]], [[CONV13]]
// CHECK3-NEXT:    [[TMP61:%.*]] = load float, ptr @_ZZ3foossssE2Sc, align 4
// CHECK3-NEXT:    [[CONV15:%.*]] = fptosi float [[TMP61]] to i32
// CHECK3-NEXT:    [[ADD16:%.*]] = add nsw i32 [[ADD14]], [[CONV15]]
// CHECK3-NEXT:    [[TMP62:%.*]] = load float, ptr @_ZZ3foossssE2Sd, align 4
// CHECK3-NEXT:    [[CONV17:%.*]] = fptosi float [[TMP62]] to i32
// CHECK3-NEXT:    [[ADD18:%.*]] = add nsw i32 [[ADD16]], [[CONV17]]
// CHECK3-NEXT:    ret i32 [[ADD18]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3foossss_l49
// CHECK3-SAME: (i32 noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GB:%.*]], i32 noundef [[SB:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GC:%.*]], i32 noundef [[C:%.*]], i32 noundef [[SC:%.*]], i32 noundef [[D:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GD:%.*]], i32 noundef [[SD:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GB_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SB_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GC_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SC_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SD_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GB1:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[GC2:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[GD3:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK3-NEXT:    store i32 [[B]], ptr [[B_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GB]], ptr [[GB_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SB]], ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GC]], ptr [[GC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SC]], ptr [[SC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[D]], ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SD]], ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GB_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[GC_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK3-NEXT:    store double [[TMP4]], ptr [[GB1]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load double, ptr [[TMP2]], align 8
// CHECK3-NEXT:    store double [[TMP5]], ptr [[GC2]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load double, ptr [[TMP3]], align 8
// CHECK3-NEXT:    store double [[TMP6]], ptr [[GD3]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP7]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK3-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV4]], ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[TMP8:%.*]] = load double, ptr [[GB1]], align 8
// CHECK3-NEXT:    [[ADD5:%.*]] = fadd double [[TMP8]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD5]], ptr [[GB1]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = load float, ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    [[CONV6:%.*]] = fpext float [[TMP9]] to double
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[CONV6]], 1.000000e+00
// CHECK3-NEXT:    [[CONV8:%.*]] = fptrunc double [[ADD7]] to float
// CHECK3-NEXT:    store float [[CONV8]], ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load double, ptr [[GC2]], align 8
// CHECK3-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP10]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       land.lhs.true:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    [[CONV9:%.*]] = sext i16 [[TMP11]] to i32
// CHECK3-NEXT:    [[CMP10:%.*]] = icmp sgt i32 [[CONV9]], 0
// CHECK3-NEXT:    br i1 [[CMP10]], label [[LAND_LHS_TRUE11:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       land.lhs.true11:
// CHECK3-NEXT:    [[TMP12:%.*]] = load float, ptr [[SC_ADDR]], align 4
// CHECK3-NEXT:    [[CONV12:%.*]] = fpext float [[TMP12]] to double
// CHECK3-NEXT:    [[CMP13:%.*]] = fcmp ogt double [[CONV12]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP13]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @.omp_outlined., ptr [[D_ADDR]], ptr [[GD3]], ptr [[SD_ADDR]])
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK3-NEXT:    call void @.omp_outlined.(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[D_ADDR]], ptr [[GD3]], ptr [[SD_ADDR]]) #[[ATTR2]]
// CHECK3-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GD:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SD:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[SD]], ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK3-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV1]], ptr [[TMP0]], align 2
// CHECK3-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK3-NEXT:    [[ADD2:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD2]], ptr [[TMP1]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load float, ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[CONV3:%.*]] = fpext float [[TMP5]] to double
// CHECK3-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK3-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK3-NEXT:    store float [[CONV5]], ptr [[TMP2]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z3barssss
// CHECK3-SAME: (i16 noundef signext [[A:%.*]], i16 noundef signext [[B:%.*]], i16 noundef signext [[C:%.*]], i16 noundef signext [[D:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    store i16 [[A]], ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[B]], ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[C]], ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[D]], ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @.omp_outlined..1, ptr [[A_ADDR]], ptr [[B_ADDR]], ptr [[C_ADDR]], ptr [[D_ADDR]])
// CHECK3-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK3-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[CONV1:%.*]] = sext i16 [[TMP1]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV1]]
// CHECK3-NEXT:    [[TMP2:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP2]] to i32
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[ADD]], [[CONV2]]
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP3]] to i32
// CHECK3-NEXT:    [[ADD5:%.*]] = add nsw i32 [[ADD3]], [[CONV4]]
// CHECK3-NEXT:    [[TMP4:%.*]] = load float, ptr @_ZZ3barssssE2Sa, align 4
// CHECK3-NEXT:    [[CONV6:%.*]] = fptosi float [[TMP4]] to i32
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[ADD5]], [[CONV6]]
// CHECK3-NEXT:    [[TMP5:%.*]] = load float, ptr @_ZZ3barssssE2Sb, align 4
// CHECK3-NEXT:    [[CONV8:%.*]] = fptosi float [[TMP5]] to i32
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[ADD7]], [[CONV8]]
// CHECK3-NEXT:    [[TMP6:%.*]] = load float, ptr @_ZZ3barssssE2Sc, align 4
// CHECK3-NEXT:    [[CONV10:%.*]] = fptosi float [[TMP6]] to i32
// CHECK3-NEXT:    [[ADD11:%.*]] = add nsw i32 [[ADD9]], [[CONV10]]
// CHECK3-NEXT:    [[TMP7:%.*]] = load float, ptr @_ZZ3barssssE2Sd, align 4
// CHECK3-NEXT:    [[CONV12:%.*]] = fptosi float [[TMP7]] to i32
// CHECK3-NEXT:    [[ADD13:%.*]] = add nsw i32 [[ADD11]], [[CONV12]]
// CHECK3-NEXT:    ret i32 [[ADD13]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[A:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[B:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[C:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SB_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SC_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[D_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SD_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i16, ptr [[TMP1]], align 2
// CHECK3-NEXT:    store i16 [[TMP4]], ptr [[B_CASTED]], align 2
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, ptr [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load float, ptr @_ZZ3barssssE2Sb, align 4
// CHECK3-NEXT:    store float [[TMP6]], ptr [[SB_CASTED]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, ptr [[SB_CASTED]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i16, ptr [[TMP2]], align 2
// CHECK3-NEXT:    store i16 [[TMP8]], ptr [[C_CASTED]], align 2
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, ptr [[C_CASTED]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load float, ptr @_ZZ3barssssE2Sc, align 4
// CHECK3-NEXT:    store float [[TMP10]], ptr [[SC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, ptr [[SC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i16, ptr [[TMP3]], align 2
// CHECK3-NEXT:    store i16 [[TMP12]], ptr [[D_CASTED]], align 2
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, ptr [[D_CASTED]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load float, ptr @_ZZ3barssssE2Sd, align 4
// CHECK3-NEXT:    store float [[TMP14]], ptr [[SD_CASTED]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[SD_CASTED]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load double, ptr @Ga, align 8
// CHECK3-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP16]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       land.lhs.true:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP17]] to i32
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sgt i32 [[CONV]], 0
// CHECK3-NEXT:    br i1 [[CMP1]], label [[LAND_LHS_TRUE2:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       land.lhs.true2:
// CHECK3-NEXT:    [[TMP18:%.*]] = load float, ptr @_ZZ3barssssE2Sa, align 4
// CHECK3-NEXT:    [[CONV3:%.*]] = fpext float [[TMP18]] to double
// CHECK3-NEXT:    [[CMP4:%.*]] = fcmp ogt double [[CONV3]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP5]], ptr [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP5]], ptr [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP21]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr @Gb, ptr [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr @Gb, ptr [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr null, ptr [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    store i32 [[TMP7]], ptr [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    store i32 [[TMP7]], ptr [[TMP26]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store ptr null, ptr [[TMP27]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr @Gc, ptr [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr @Gc, ptr [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr null, ptr [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP9]], ptr [[TMP31]], align 4
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP9]], ptr [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK3-NEXT:    store ptr null, ptr [[TMP33]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK3-NEXT:    store i32 [[TMP11]], ptr [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK3-NEXT:    store i32 [[TMP11]], ptr [[TMP35]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 5
// CHECK3-NEXT:    store ptr null, ptr [[TMP36]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK3-NEXT:    store i32 [[TMP13]], ptr [[TMP37]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK3-NEXT:    store i32 [[TMP13]], ptr [[TMP38]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP39]], align 4
// CHECK3-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr @Gd, ptr [[TMP40]], align 4
// CHECK3-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr @Gd, ptr [[TMP41]], align 4
// CHECK3-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP42]], align 4
// CHECK3-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 8
// CHECK3-NEXT:    store i32 [[TMP15]], ptr [[TMP43]], align 4
// CHECK3-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 8
// CHECK3-NEXT:    store i32 [[TMP15]], ptr [[TMP44]], align 4
// CHECK3-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 8
// CHECK3-NEXT:    store ptr null, ptr [[TMP45]], align 4
// CHECK3-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK3-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 1, ptr [[TMP48]], align 4
// CHECK3-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK3-NEXT:    store i32 9, ptr [[TMP49]], align 4
// CHECK3-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP46]], ptr [[TMP50]], align 4
// CHECK3-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP47]], ptr [[TMP51]], align 4
// CHECK3-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes.3, ptr [[TMP52]], align 4
// CHECK3-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes.4, ptr [[TMP53]], align 4
// CHECK3-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP54]], align 4
// CHECK3-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP55]], align 4
// CHECK3-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP56]], align 8
// CHECK3-NEXT:    [[TMP57:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 -1, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3barssss_l94.region_id, ptr [[KERNEL_ARGS]])
// CHECK3-NEXT:    [[TMP58:%.*]] = icmp ne i32 [[TMP57]], 0
// CHECK3-NEXT:    br i1 [[TMP58]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3barssss_l94(i32 [[TMP5]], ptr @Gb, i32 [[TMP7]], ptr @Gc, i32 [[TMP9]], i32 [[TMP11]], i32 [[TMP13]], ptr @Gd, i32 [[TMP15]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3barssss_l94(i32 [[TMP5]], ptr @Gb, i32 [[TMP7]], ptr @Gc, i32 [[TMP9]], i32 [[TMP11]], i32 [[TMP13]], ptr @Gd, i32 [[TMP15]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z3barssss_l94
// CHECK3-SAME: (i32 noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GB:%.*]], i32 noundef [[SB:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GC:%.*]], i32 noundef [[C:%.*]], i32 noundef [[SC:%.*]], i32 noundef [[D:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GD:%.*]], i32 noundef [[SD:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GB_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SB_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GC_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SC_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SD_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GB1:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[GC2:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[GD3:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK3-NEXT:    store i32 [[B]], ptr [[B_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GB]], ptr [[GB_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SB]], ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GC]], ptr [[GC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SC]], ptr [[SC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[D]], ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SD]], ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GB_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[GC_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK3-NEXT:    store double [[TMP4]], ptr [[GB1]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load double, ptr [[TMP2]], align 8
// CHECK3-NEXT:    store double [[TMP5]], ptr [[GC2]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load double, ptr [[TMP3]], align 8
// CHECK3-NEXT:    store double [[TMP6]], ptr [[GD3]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP7]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK3-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV4]], ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[TMP8:%.*]] = load double, ptr [[GB1]], align 8
// CHECK3-NEXT:    [[ADD5:%.*]] = fadd double [[TMP8]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD5]], ptr [[GB1]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = load float, ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    [[CONV6:%.*]] = fpext float [[TMP9]] to double
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[CONV6]], 1.000000e+00
// CHECK3-NEXT:    [[CONV8:%.*]] = fptrunc double [[ADD7]] to float
// CHECK3-NEXT:    store float [[CONV8]], ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load double, ptr [[GC2]], align 8
// CHECK3-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP10]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       land.lhs.true:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    [[CONV9:%.*]] = sext i16 [[TMP11]] to i32
// CHECK3-NEXT:    [[CMP10:%.*]] = icmp sgt i32 [[CONV9]], 0
// CHECK3-NEXT:    br i1 [[CMP10]], label [[LAND_LHS_TRUE11:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       land.lhs.true11:
// CHECK3-NEXT:    [[TMP12:%.*]] = load float, ptr [[SC_ADDR]], align 4
// CHECK3-NEXT:    [[CONV12:%.*]] = fpext float [[TMP12]] to double
// CHECK3-NEXT:    [[CMP13:%.*]] = fcmp ogt double [[CONV12]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP13]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @.omp_outlined..2, ptr [[D_ADDR]], ptr [[GD3]], ptr [[SD_ADDR]])
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK3-NEXT:    call void @.omp_outlined..2(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[D_ADDR]], ptr [[GD3]], ptr [[SD_ADDR]]) #[[ATTR2]]
// CHECK3-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GD:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SD:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[SD]], ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK3-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV1]], ptr [[TMP0]], align 2
// CHECK3-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK3-NEXT:    [[ADD2:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD2]], ptr [[TMP1]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load float, ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[CONV3:%.*]] = fpext float [[TMP5]] to double
// CHECK3-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK3-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK3-NEXT:    store float [[CONV5]], ptr [[TMP2]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z5tbar2ssss
// CHECK3-SAME: (i16 noundef signext [[A:%.*]], i16 noundef signext [[B:%.*]], i16 noundef signext [[C:%.*]], i16 noundef signext [[D:%.*]]) #[[ATTR0]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    store i16 [[A]], ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[B]], ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[C]], ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[D]], ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[TMP2:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z4tbarIsEiT_S0_S0_S0_(i16 noundef signext [[TMP0]], i16 noundef signext [[TMP1]], i16 noundef signext [[TMP2]], i16 noundef signext [[TMP3]])
// CHECK3-NEXT:    ret i32 [[CALL]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z4tbarIsEiT_S0_S0_S0_
// CHECK3-SAME: (i16 noundef signext [[A:%.*]], i16 noundef signext [[B:%.*]], i16 noundef signext [[C:%.*]], i16 noundef signext [[D:%.*]]) #[[ATTR0]] comdat {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    store i16 [[A]], ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[B]], ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[C]], ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    store i16 [[D]], ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @.omp_outlined..5, ptr [[A_ADDR]], ptr [[B_ADDR]], ptr [[C_ADDR]], ptr [[D_ADDR]])
// CHECK3-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A_ADDR]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP0]] to i32
// CHECK3-NEXT:    [[TMP1:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[CONV1:%.*]] = sext i16 [[TMP1]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV1]]
// CHECK3-NEXT:    [[TMP2:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP2]] to i32
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[ADD]], [[CONV2]]
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, ptr [[D_ADDR]], align 2
// CHECK3-NEXT:    [[CONV4:%.*]] = sext i16 [[TMP3]] to i32
// CHECK3-NEXT:    [[ADD5:%.*]] = add nsw i32 [[ADD3]], [[CONV4]]
// CHECK3-NEXT:    [[TMP4:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sa, align 4
// CHECK3-NEXT:    [[CONV6:%.*]] = fptosi float [[TMP4]] to i32
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[ADD5]], [[CONV6]]
// CHECK3-NEXT:    [[TMP5:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sb, align 4
// CHECK3-NEXT:    [[CONV8:%.*]] = fptosi float [[TMP5]] to i32
// CHECK3-NEXT:    [[ADD9:%.*]] = add nsw i32 [[ADD7]], [[CONV8]]
// CHECK3-NEXT:    [[TMP6:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sc, align 4
// CHECK3-NEXT:    [[CONV10:%.*]] = fptosi float [[TMP6]] to i32
// CHECK3-NEXT:    [[ADD11:%.*]] = add nsw i32 [[ADD9]], [[CONV10]]
// CHECK3-NEXT:    [[TMP7:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sd, align 4
// CHECK3-NEXT:    [[CONV12:%.*]] = fptosi float [[TMP7]] to i32
// CHECK3-NEXT:    [[ADD13:%.*]] = add nsw i32 [[ADD11]], [[CONV12]]
// CHECK3-NEXT:    ret i32 [[ADD13]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..5
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[A:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[B:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[C:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[B_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SB_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SC_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[D_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SD_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [9 x ptr], align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[B_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i16, ptr [[TMP1]], align 2
// CHECK3-NEXT:    store i16 [[TMP4]], ptr [[B_CASTED]], align 2
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, ptr [[B_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sb, align 4
// CHECK3-NEXT:    store float [[TMP6]], ptr [[SB_CASTED]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, ptr [[SB_CASTED]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i16, ptr [[TMP2]], align 2
// CHECK3-NEXT:    store i16 [[TMP8]], ptr [[C_CASTED]], align 2
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, ptr [[C_CASTED]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sc, align 4
// CHECK3-NEXT:    store float [[TMP10]], ptr [[SC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, ptr [[SC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i16, ptr [[TMP3]], align 2
// CHECK3-NEXT:    store i16 [[TMP12]], ptr [[D_CASTED]], align 2
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, ptr [[D_CASTED]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sd, align 4
// CHECK3-NEXT:    store float [[TMP14]], ptr [[SD_CASTED]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[SD_CASTED]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load double, ptr @Ga, align 8
// CHECK3-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP16]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       land.lhs.true:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP17]] to i32
// CHECK3-NEXT:    [[CMP1:%.*]] = icmp sgt i32 [[CONV]], 0
// CHECK3-NEXT:    br i1 [[CMP1]], label [[LAND_LHS_TRUE2:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       land.lhs.true2:
// CHECK3-NEXT:    [[TMP18:%.*]] = load float, ptr @_ZZ4tbarIsEiT_S0_S0_S0_E2Sa, align 4
// CHECK3-NEXT:    [[CONV3:%.*]] = fpext float [[TMP18]] to double
// CHECK3-NEXT:    [[CMP4:%.*]] = fcmp ogt double [[CONV3]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP5]], ptr [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP5]], ptr [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP21]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr @Gb, ptr [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr @Gb, ptr [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store ptr null, ptr [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    store i32 [[TMP7]], ptr [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    store i32 [[TMP7]], ptr [[TMP26]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store ptr null, ptr [[TMP27]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr @Gc, ptr [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr @Gc, ptr [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr null, ptr [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP9]], ptr [[TMP31]], align 4
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP9]], ptr [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK3-NEXT:    store ptr null, ptr [[TMP33]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK3-NEXT:    store i32 [[TMP11]], ptr [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK3-NEXT:    store i32 [[TMP11]], ptr [[TMP35]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 5
// CHECK3-NEXT:    store ptr null, ptr [[TMP36]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK3-NEXT:    store i32 [[TMP13]], ptr [[TMP37]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK3-NEXT:    store i32 [[TMP13]], ptr [[TMP38]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP39]], align 4
// CHECK3-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr @Gd, ptr [[TMP40]], align 4
// CHECK3-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr @Gd, ptr [[TMP41]], align 4
// CHECK3-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP42]], align 4
// CHECK3-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 8
// CHECK3-NEXT:    store i32 [[TMP15]], ptr [[TMP43]], align 4
// CHECK3-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 8
// CHECK3-NEXT:    store i32 [[TMP15]], ptr [[TMP44]], align 4
// CHECK3-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 8
// CHECK3-NEXT:    store ptr null, ptr [[TMP45]], align 4
// CHECK3-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [9 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK3-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 1, ptr [[TMP48]], align 4
// CHECK3-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK3-NEXT:    store i32 9, ptr [[TMP49]], align 4
// CHECK3-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP46]], ptr [[TMP50]], align 4
// CHECK3-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP47]], ptr [[TMP51]], align 4
// CHECK3-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes.7, ptr [[TMP52]], align 4
// CHECK3-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes.8, ptr [[TMP53]], align 4
// CHECK3-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP54]], align 4
// CHECK3-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP55]], align 4
// CHECK3-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP56]], align 8
// CHECK3-NEXT:    [[TMP57:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 -1, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z4tbarIsEiT_S0_S0_S0__l145.region_id, ptr [[KERNEL_ARGS]])
// CHECK3-NEXT:    [[TMP58:%.*]] = icmp ne i32 [[TMP57]], 0
// CHECK3-NEXT:    br i1 [[TMP58]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z4tbarIsEiT_S0_S0_S0__l145(i32 [[TMP5]], ptr @Gb, i32 [[TMP7]], ptr @Gc, i32 [[TMP9]], i32 [[TMP11]], i32 [[TMP13]], ptr @Gd, i32 [[TMP15]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z4tbarIsEiT_S0_S0_S0__l145(i32 [[TMP5]], ptr @Gb, i32 [[TMP7]], ptr @Gc, i32 [[TMP9]], i32 [[TMP11]], i32 [[TMP13]], ptr @Gd, i32 [[TMP15]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z4tbarIsEiT_S0_S0_S0__l145
// CHECK3-SAME: (i32 noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GB:%.*]], i32 noundef [[SB:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GC:%.*]], i32 noundef [[C:%.*]], i32 noundef [[SC:%.*]], i32 noundef [[D:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GD:%.*]], i32 noundef [[SD:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GB_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SB_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GC_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SC_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SD_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GB1:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[GC2:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[GD3:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK3-NEXT:    store i32 [[B]], ptr [[B_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GB]], ptr [[GB_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SB]], ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GC]], ptr [[GC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SC]], ptr [[SC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[D]], ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SD]], ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GB_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[GC_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK3-NEXT:    store double [[TMP4]], ptr [[GB1]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load double, ptr [[TMP2]], align 8
// CHECK3-NEXT:    store double [[TMP5]], ptr [[GC2]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load double, ptr [[TMP3]], align 8
// CHECK3-NEXT:    store double [[TMP6]], ptr [[GD3]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i16, ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP7]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK3-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV4]], ptr [[B_ADDR]], align 2
// CHECK3-NEXT:    [[TMP8:%.*]] = load double, ptr [[GB1]], align 8
// CHECK3-NEXT:    [[ADD5:%.*]] = fadd double [[TMP8]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD5]], ptr [[GB1]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = load float, ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    [[CONV6:%.*]] = fpext float [[TMP9]] to double
// CHECK3-NEXT:    [[ADD7:%.*]] = fadd double [[CONV6]], 1.000000e+00
// CHECK3-NEXT:    [[CONV8:%.*]] = fptrunc double [[ADD7]] to float
// CHECK3-NEXT:    store float [[CONV8]], ptr [[SB_ADDR]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load double, ptr [[GC2]], align 8
// CHECK3-NEXT:    [[CMP:%.*]] = fcmp ogt double [[TMP10]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP]], label [[LAND_LHS_TRUE:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       land.lhs.true:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i16, ptr [[C_ADDR]], align 2
// CHECK3-NEXT:    [[CONV9:%.*]] = sext i16 [[TMP11]] to i32
// CHECK3-NEXT:    [[CMP10:%.*]] = icmp sgt i32 [[CONV9]], 0
// CHECK3-NEXT:    br i1 [[CMP10]], label [[LAND_LHS_TRUE11:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       land.lhs.true11:
// CHECK3-NEXT:    [[TMP12:%.*]] = load float, ptr [[SC_ADDR]], align 4
// CHECK3-NEXT:    [[CONV12:%.*]] = fpext float [[TMP12]] to double
// CHECK3-NEXT:    [[CMP13:%.*]] = fcmp ogt double [[CONV12]], 0.000000e+00
// CHECK3-NEXT:    br i1 [[CMP13]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @.omp_outlined..6, ptr [[D_ADDR]], ptr [[GD3]], ptr [[SD_ADDR]])
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK3-NEXT:    call void @.omp_outlined..6(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[D_ADDR]], ptr [[GD3]], ptr [[SD_ADDR]]) #[[ATTR2]]
// CHECK3-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..6
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 2 dereferenceable(2) [[D:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GD:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SD:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[GD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SD_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GD]], ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[SD]], ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[SD_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i16, ptr [[TMP0]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP3]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 1
// CHECK3-NEXT:    [[CONV1:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV1]], ptr [[TMP0]], align 2
// CHECK3-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 8
// CHECK3-NEXT:    [[ADD2:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK3-NEXT:    store double [[ADD2]], ptr [[TMP1]], align 8
// CHECK3-NEXT:    [[TMP5:%.*]] = load float, ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[CONV3:%.*]] = fpext float [[TMP5]] to double
// CHECK3-NEXT:    [[ADD4:%.*]] = fadd double [[CONV3]], 1.000000e+00
// CHECK3-NEXT:    [[CONV5:%.*]] = fptrunc double [[ADD4]] to float
// CHECK3-NEXT:    store float [[CONV5]], ptr [[TMP2]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
