; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; Note update_mir_test_checks does not support generating checks for
; the frame info, so some functions have manually added stack object
; checks.
; RUN: llc -march=amdgcn -mcpu=fiji -O0 -stop-after=irtranslator -global-isel -verify-machineinstrs -o - %s | FileCheck %s
; FIXME: pre-VI should have same ABI without legal i16 operations.

define void @void_func_empty_arg({} %arg0, i32 %arg1) #0 {
  ; CHECK-LABEL: name: void_func_empty_arg
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i32 %arg1, i32 addrspace(1)* undef
  ret void
}

define void @void_func_empty_array([0 x i8] %arg0, i32 %arg1) #0 {
  ; CHECK-LABEL: name: void_func_empty_array
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i32 %arg1, i32 addrspace(1)* undef
  ret void
}

define void @void_func_i1(i1 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i1
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s1) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](s1), [[DEF]](p1) :: (store 1 into `i1 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i1 %arg0, i1 addrspace(1)* undef
  ret void
}

define void @void_func_i1_zeroext(i1 zeroext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i1_zeroext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[ASSERT_ZEXT:%[0-9]+]]:_(s32) = G_ASSERT_ZEXT [[COPY]], 1
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s1) = G_TRUNC [[ASSERT_ZEXT]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s1)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[ZEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  %ext = zext i1 %arg0 to i32
  %add = add i32 %ext, 12
  store i32 %add, i32 addrspace(1)* undef
  ret void
}

define void @void_func_i1_signext(i1 signext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i1_signext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[ASSERT_SEXT:%[0-9]+]]:_(s32) = G_ASSERT_SEXT [[COPY]], 1
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s1) = G_TRUNC [[ASSERT_SEXT]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC]](s1)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[SEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  %ext = sext i1 %arg0 to i32
  %add = add i32 %ext, 12
  store i32 %add, i32 addrspace(1)* undef
  ret void
}

define void @i1_arg_i1_use(i1 %arg) #0 {
  ; CHECK-LABEL: name: i1_arg_i1_use
  ; CHECK: bb.1.bb:
  ; CHECK:   successors: %bb.2(0x40000000), %bb.3(0x40000000)
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s1) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s1) = G_CONSTANT i1 true
  ; CHECK:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[XOR:%[0-9]+]]:_(s1) = G_XOR [[TRUNC]], [[C]]
  ; CHECK:   [[INT:%[0-9]+]]:_(s1), [[INT1:%[0-9]+]]:_(s64) = G_INTRINSIC_W_SIDE_EFFECTS intrinsic(@llvm.amdgcn.if), [[XOR]](s1)
  ; CHECK:   G_BRCOND [[INT]](s1), %bb.2
  ; CHECK:   G_BR %bb.3
  ; CHECK: bb.2.bb1:
  ; CHECK:   successors: %bb.3(0x80000000)
  ; CHECK:   G_STORE [[C1]](s32), [[DEF]](p1) :: (volatile store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK: bb.3.bb2:
  ; CHECK:   G_INTRINSIC_W_SIDE_EFFECTS intrinsic(@llvm.amdgcn.end.cf), [[INT1]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
bb:
  br i1 %arg, label %bb2, label %bb1

bb1:
  store volatile i32 0, i32 addrspace(1)* undef
  br label %bb2

bb2:
  ret void
}

define void @void_func_i8(i8 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[TRUNC1:%[0-9]+]]:_(s8) = G_TRUNC [[TRUNC]](s16)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC1]](s8), [[DEF]](p1) :: (store 1 into `i8 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i8 %arg0, i8 addrspace(1)* undef
  ret void
}

define void @void_func_i8_zeroext(i8 zeroext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i8_zeroext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[ASSERT_ZEXT:%[0-9]+]]:_(s32) = G_ASSERT_ZEXT [[COPY]], 8
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[ASSERT_ZEXT]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s8)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[ZEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  %ext = zext i8 %arg0 to i32
  %add = add i32 %ext, 12
  store i32 %add, i32 addrspace(1)* undef
  ret void
}

define void @void_func_i8_signext(i8 signext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i8_signext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[ASSERT_SEXT:%[0-9]+]]:_(s32) = G_ASSERT_SEXT [[COPY]], 8
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[ASSERT_SEXT]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC]](s8)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[SEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  %ext = sext i8 %arg0 to i32
  %add = add i32 %ext, 12
  store i32 %add, i32 addrspace(1)* undef
  ret void
}

define void @void_func_i16(i16 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](s16), [[DEF]](p1) :: (store 2 into `i16 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i16 %arg0, i16 addrspace(1)* undef
  ret void
}

define void @void_func_i16_zeroext(i16 zeroext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i16_zeroext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[ASSERT_ZEXT:%[0-9]+]]:_(s32) = G_ASSERT_ZEXT [[COPY]], 16
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[ASSERT_ZEXT]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[ZEXT:%[0-9]+]]:_(s32) = G_ZEXT [[TRUNC]](s16)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[ZEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  %ext = zext i16 %arg0 to i32
  %add = add i32 %ext, 12
  store i32 %add, i32 addrspace(1)* undef
  ret void
}

define void @void_func_i16_signext(i16 signext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i16_signext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[ASSERT_SEXT:%[0-9]+]]:_(s32) = G_ASSERT_SEXT [[COPY]], 16
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[ASSERT_SEXT]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[SEXT:%[0-9]+]]:_(s32) = G_SEXT [[TRUNC]](s16)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[SEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  %ext = sext i16 %arg0 to i32
  %add = add i32 %ext, 12
  store i32 %add, i32 addrspace(1)* undef
  ret void
}

define void @void_func_i24(i24 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i24
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s24) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](s24), [[DEF]](p1) :: (store 3 into `i24 addrspace(1)* undef`, align 4, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i24 %arg0, i24 addrspace(1)* undef
  ret void
}

define void @void_func_i24_zeroext(i24 zeroext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i24_zeroext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s24) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](s24), [[DEF]](p1) :: (store 3 into `i24 addrspace(1)* undef`, align 4, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i24 %arg0, i24 addrspace(1)* undef
  ret void
}

define void @void_func_i24_signext(i24 signext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i24_signext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s24) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](s24), [[DEF]](p1) :: (store 3 into `i24 addrspace(1)* undef`, align 4, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i24 %arg0, i24 addrspace(1)* undef
  ret void
}

define void @void_func_i32(i32 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i32 %arg0, i32 addrspace(1)* undef
  ret void
}

; The signext is an no-op
define void @void_func_i32_signext(i32 signext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i32_signext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i32 %arg0, i32 addrspace(1)* undef
  ret void
}

; The zeroext is an no-op
define void @void_func_i32_zeroext(i32 zeroext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i32_zeroext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i32 %arg0, i32 addrspace(1)* undef
  ret void
}

define void @void_func_p3i8(i8 addrspace(3)* %arg0) #0 {
  ; CHECK-LABEL: name: void_func_p3i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(p3) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](p3), [[DEF]](p1) :: (store 4 into `i8 addrspace(3)* addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store i8 addrspace(3)* %arg0, i8 addrspace(3)* addrspace(1)* undef
  ret void
}

define void @void_func_i48(i48 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i48
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s48) = G_TRUNC [[MV]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](s48), [[DEF]](p1) :: (store 6 into `i48 addrspace(1)* undef`, align 8, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store i48 %arg0, i48 addrspace(1)* undef
  ret void
}

define void @void_func_i48_zeroext(i48 zeroext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i48_zeroext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s48) = G_TRUNC [[MV]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[ZEXT:%[0-9]+]]:_(s64) = G_ZEXT [[TRUNC]](s48)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s64) = G_ADD [[ZEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s64), [[DEF]](p1) :: (store 8 into `i64 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  %ext = zext i48 %arg0 to i64
  %add = add i64 %ext, 12
  store i64 %add, i64 addrspace(1)* undef
  ret void
}

define void @void_func_i48_signext(i48 signext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i48_signext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s48) = G_TRUNC [[MV]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[SEXT:%[0-9]+]]:_(s64) = G_SEXT [[TRUNC]](s48)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s64) = G_ADD [[SEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s64), [[DEF]](p1) :: (store 8 into `i64 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  %ext = sext i48 %arg0 to i64
  %add = add i64 %ext, 12
  store i64 %add, i64 addrspace(1)* undef
  ret void
}

define void @void_func_i64(i64 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[MV]](s64), [[DEF]](p1) :: (store 8 into `i64 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store i64 %arg0, i64 addrspace(1)* undef
  ret void
}

define void @void_func_i95(i95 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i95
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[MV:%[0-9]+]]:_(s96) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s95) = G_TRUNC [[MV]](s96)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](s95), [[DEF]](p1) :: (store 12 into `i95 addrspace(1)* undef`, align 8, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  store i95 %arg0, i95 addrspace(1)* undef
  ret void
}

define void @void_func_i95_zeroext(i95 zeroext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i95_zeroext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[MV:%[0-9]+]]:_(s96) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s95) = G_TRUNC [[MV]](s96)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s96) = G_CONSTANT i96 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[ZEXT:%[0-9]+]]:_(s96) = G_ZEXT [[TRUNC]](s95)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s96) = G_ADD [[ZEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s96), [[DEF]](p1) :: (store 12 into `i96 addrspace(1)* undef`, align 8, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  %ext = zext i95 %arg0 to i96
  %add = add i96 %ext, 12
  store i96 %add, i96 addrspace(1)* undef
  ret void
}

define void @void_func_i95_signext(i95 signext %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i95_signext
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[MV:%[0-9]+]]:_(s96) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s95) = G_TRUNC [[MV]](s96)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s96) = G_CONSTANT i96 12
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[SEXT:%[0-9]+]]:_(s96) = G_SEXT [[TRUNC]](s95)
  ; CHECK:   [[ADD:%[0-9]+]]:_(s96) = G_ADD [[SEXT]], [[C]]
  ; CHECK:   G_STORE [[ADD]](s96), [[DEF]](p1) :: (store 12 into `i96 addrspace(1)* undef`, align 8, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  %ext = sext i95 %arg0 to i96
  %add = add i96 %ext, 12
  store i96 %add, i96 addrspace(1)* undef
  ret void
}

define void @void_func_i96(i96 %arg0) #0 {
  ; CHECK-LABEL: name: void_func_i96
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[MV:%[0-9]+]]:_(s96) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[MV]](s96), [[DEF]](p1) :: (store 12 into `i96 addrspace(1)* undef`, align 8, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  store i96 %arg0, i96 addrspace(1)* undef
  ret void
}

define void @void_func_p0i8(i8* %arg0) #0 {
  ; CHECK-LABEL: name: void_func_p0i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[MV:%[0-9]+]]:_(p0) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[MV]](p0), [[DEF]](p1) :: (store 8 into `i8* addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store i8* %arg0, i8* addrspace(1)* undef
  ret void
}

define void @void_func_p1i8(i8 addrspace(1)* %arg0) #0 {
  ; CHECK-LABEL: name: void_func_p1i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[MV:%[0-9]+]]:_(p1) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[MV]](p1), [[DEF]](p1) :: (store 8 into `i8 addrspace(1)* addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store i8 addrspace(1)* %arg0, i8 addrspace(1)* addrspace(1)* undef
  ret void
}

define void @void_func_f16(half %arg0) #0 {
  ; CHECK-LABEL: name: void_func_f16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](s16), [[DEF]](p1) :: (store 2 into `half addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store half %arg0, half addrspace(1)* undef
  ret void
}

define void @void_func_f32(float %arg0) #0 {
  ; CHECK-LABEL: name: void_func_f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](s32), [[DEF]](p1) :: (store 4 into `float addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store float %arg0, float addrspace(1)* undef
  ret void
}

define void @void_func_f64(double %arg0) #0 {
  ; CHECK-LABEL: name: void_func_f64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[MV]](s64), [[DEF]](p1) :: (store 8 into `double addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store double %arg0, double addrspace(1)* undef
  ret void
}

define void @void_func_v2i32(<2 x i32> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<2 x s32>), [[DEF]](p1) :: (store 8 into `<2 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <2 x i32> %arg0, <2 x i32> addrspace(1)* undef
  ret void
}

define void @void_func_v2i24(<2 x i24> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2i24
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(<2 x s24>) = G_TRUNC [[BUILD_VECTOR]](<2 x s32>)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](<2 x s24>), [[DEF]](p1) :: (store 6 into `<2 x i24> addrspace(1)* undef`, align 8, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <2 x i24> %arg0, <2 x i24> addrspace(1)* undef
  ret void
}

define void @void_func_v3i24(<3 x i24> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v3i24
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(<3 x s24>) = G_TRUNC [[BUILD_VECTOR]](<3 x s32>)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC]](<3 x s24>), [[DEF]](p1) :: (store 9 into `<3 x i24> addrspace(1)* undef`, align 16, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  store <3 x i24> %arg0, <3 x i24> addrspace(1)* undef
  ret void
}

define void @void_func_v2i8(<2 x i8> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[TRUNC1:%[0-9]+]]:_(s16) = G_TRUNC [[COPY1]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s16>) = G_BUILD_VECTOR [[TRUNC]](s16), [[TRUNC1]](s16)
  ; CHECK:   [[TRUNC2:%[0-9]+]]:_(<2 x s8>) = G_TRUNC [[BUILD_VECTOR]](<2 x s16>)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC2]](<2 x s8>), [[DEF]](p1) :: (store 2 into `<2 x i8> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <2 x i8> %arg0, <2 x i8> addrspace(1)* undef
  ret void
}

define void @void_func_v3i8(<3 x i8> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v3i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[TRUNC1:%[0-9]+]]:_(s16) = G_TRUNC [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[TRUNC2:%[0-9]+]]:_(s16) = G_TRUNC [[COPY2]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s16>) = G_BUILD_VECTOR [[TRUNC]](s16), [[TRUNC1]](s16), [[TRUNC2]](s16)
  ; CHECK:   [[TRUNC3:%[0-9]+]]:_(<3 x s8>) = G_TRUNC [[BUILD_VECTOR]](<3 x s16>)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC3]](<3 x s8>), [[DEF]](p1) :: (store 3 into `<3 x i8> addrspace(1)* undef`, align 4, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  store <3 x i8> %arg0, <3 x i8> addrspace(1)* undef
  ret void
}

define void @void_func_v4i8(<4 x i8> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v4i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[TRUNC1:%[0-9]+]]:_(s16) = G_TRUNC [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[TRUNC2:%[0-9]+]]:_(s16) = G_TRUNC [[COPY2]](s32)
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[TRUNC3:%[0-9]+]]:_(s16) = G_TRUNC [[COPY3]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<4 x s16>) = G_BUILD_VECTOR [[TRUNC]](s16), [[TRUNC1]](s16), [[TRUNC2]](s16), [[TRUNC3]](s16)
  ; CHECK:   [[TRUNC4:%[0-9]+]]:_(<4 x s8>) = G_TRUNC [[BUILD_VECTOR]](<4 x s16>)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC4]](<4 x s8>), [[DEF]](p1) :: (store 4 into `<4 x i8> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <4 x i8> %arg0, <4 x i8> addrspace(1)* undef
  ret void
}

define void @void_func_v2p3i8(<2 x i8 addrspace(3)*> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2p3i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(p3) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p3) = COPY $vgpr1
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x p3>) = G_BUILD_VECTOR [[COPY]](p3), [[COPY1]](p3)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<2 x p3>), [[DEF]](p1) :: (store 8 into `<2 x i8 addrspace(3)*> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <2 x i8 addrspace(3)*> %arg0, <2 x i8 addrspace(3)*> addrspace(1)* undef
  ret void
}

define void @void_func_v3i32(<3 x i32> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v3i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<3 x s32>), [[DEF]](p1) :: (store 12 into `<3 x i32> addrspace(1)* undef`, align 16, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  store <3 x i32> %arg0, <3 x i32> addrspace(1)* undef
  ret void
}

define void @void_func_v4i32(<4 x i32> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v4i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<4 x s32>), [[DEF]](p1) :: (store 16 into `<4 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <4 x i32> %arg0, <4 x i32> addrspace(1)* undef
  ret void
}

define void @void_func_v5i32(<5 x i32> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v5i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<5 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32)
  ; CHECK:   [[COPY5:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<5 x s32>), [[DEF]](p1) :: (store 20 into `<5 x i32> addrspace(1)* undef`, align 32, addrspace 1)
  ; CHECK:   [[COPY6:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY5]]
  ; CHECK:   S_SETPC_B64_return [[COPY6]]
  store <5 x i32> %arg0, <5 x i32> addrspace(1)* undef
  ret void
}

define void @void_func_v8i32(<8 x i32> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v8i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[COPY8:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<8 x s32>), [[DEF]](p1) :: (store 32 into `<8 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY9:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY8]]
  ; CHECK:   S_SETPC_B64_return [[COPY9]]
  store <8 x i32> %arg0, <8 x i32> addrspace(1)* undef
  ret void
}

define void @void_func_v16i32(<16 x i32> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v16i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<16 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32)
  ; CHECK:   [[COPY16:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<16 x s32>), [[DEF]](p1) :: (store 64 into `<16 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY17:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY16]]
  ; CHECK:   S_SETPC_B64_return [[COPY17]]
  store <16 x i32> %arg0, <16 x i32> addrspace(1)* undef
  ret void
}

define void @void_func_v32i32(<32 x i32> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v32i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY33:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY33]]
  store <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  ret void
}

; 1 over register limit
define void @void_func_v33i32(<33 x i32> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v33i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.0, align 16, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<33 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32), [[LOAD]](s32)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<33 x s32>), [[DEF]](p1) :: (store 132 into `<33 x i32> addrspace(1)* undef`, align 256, addrspace 1)
  ; CHECK:   [[COPY33:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY33]]
  store <33 x i32> %arg0, <33 x i32> addrspace(1)* undef
  ret void
}

define void @void_func_v2i64(<2 x i64> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<2 x s64>), [[DEF]](p1) :: (store 16 into `<2 x i64> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <2 x i64> %arg0, <2 x i64> addrspace(1)* undef
  ret void
}

define void @void_func_v2p0i8(<2 x i8*> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2p0i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[MV:%[0-9]+]]:_(p0) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(p0) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x p0>) = G_BUILD_VECTOR [[MV]](p0), [[MV1]](p0)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<2 x p0>), [[DEF]](p1) :: (store 16 into `<2 x i8*> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <2 x i8*> %arg0, <2 x i8*> addrspace(1)* undef
  ret void
}

define void @void_func_v2p1i8(<2 x i8 addrspace(1)*> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2p1i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[MV:%[0-9]+]]:_(p1) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(p1) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x p1>) = G_BUILD_VECTOR [[MV]](p1), [[MV1]](p1)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<2 x p1>), [[DEF]](p1) :: (store 16 into `<2 x i8 addrspace(1)*> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <2 x i8 addrspace(1)*> %arg0, <2 x i8 addrspace(1)*> addrspace(1)* undef
  ret void
}

define void @void_func_v3i64(<3 x i64> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v3i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64)
  ; CHECK:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<3 x s64>), [[DEF]](p1) :: (store 24 into `<3 x i64> addrspace(1)* undef`, align 32, addrspace 1)
  ; CHECK:   [[COPY7:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY6]]
  ; CHECK:   S_SETPC_B64_return [[COPY7]]
  store <3 x i64> %arg0, <3 x i64> addrspace(1)* undef
  ret void
}

define void @void_func_v4i64(<4 x i64> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v4i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<4 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64), [[MV3]](s64)
  ; CHECK:   [[COPY8:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<4 x s64>), [[DEF]](p1) :: (store 32 into `<4 x i64> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY9:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY8]]
  ; CHECK:   S_SETPC_B64_return [[COPY9]]
  store <4 x i64> %arg0, <4 x i64> addrspace(1)* undef
  ret void
}

define void @void_func_v5i64(<5 x i64> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v5i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[MV4:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<5 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64), [[MV3]](s64), [[MV4]](s64)
  ; CHECK:   [[COPY10:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<5 x s64>), [[DEF]](p1) :: (store 40 into `<5 x i64> addrspace(1)* undef`, align 64, addrspace 1)
  ; CHECK:   [[COPY11:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY10]]
  ; CHECK:   S_SETPC_B64_return [[COPY11]]
  store <5 x i64> %arg0, <5 x i64> addrspace(1)* undef
  ret void
}

define void @void_func_v8i64(<8 x i64> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v8i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[MV4:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; CHECK:   [[MV5:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY10]](s32), [[COPY11]](s32)
  ; CHECK:   [[MV6:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY12]](s32), [[COPY13]](s32)
  ; CHECK:   [[MV7:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY14]](s32), [[COPY15]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64), [[MV3]](s64), [[MV4]](s64), [[MV5]](s64), [[MV6]](s64), [[MV7]](s64)
  ; CHECK:   [[COPY16:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<8 x s64>), [[DEF]](p1) :: (store 64 into `<8 x i64> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY17:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY16]]
  ; CHECK:   S_SETPC_B64_return [[COPY17]]
  store <8 x i64> %arg0, <8 x i64> addrspace(1)* undef
  ret void
}

define void @void_func_v16i64(<16 x i64> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v16i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[MV4:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; CHECK:   [[MV5:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY10]](s32), [[COPY11]](s32)
  ; CHECK:   [[MV6:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY12]](s32), [[COPY13]](s32)
  ; CHECK:   [[MV7:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY14]](s32), [[COPY15]](s32)
  ; CHECK:   [[MV8:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY16]](s32), [[COPY17]](s32)
  ; CHECK:   [[MV9:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY18]](s32), [[COPY19]](s32)
  ; CHECK:   [[MV10:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY20]](s32), [[COPY21]](s32)
  ; CHECK:   [[MV11:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY22]](s32), [[COPY23]](s32)
  ; CHECK:   [[MV12:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY24]](s32), [[COPY25]](s32)
  ; CHECK:   [[MV13:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY26]](s32), [[COPY27]](s32)
  ; CHECK:   [[MV14:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY28]](s32), [[COPY29]](s32)
  ; CHECK:   [[MV15:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<16 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64), [[MV3]](s64), [[MV4]](s64), [[MV5]](s64), [[MV6]](s64), [[MV7]](s64), [[MV8]](s64), [[MV9]](s64), [[MV10]](s64), [[MV11]](s64), [[MV12]](s64), [[MV13]](s64), [[MV14]](s64), [[MV15]](s64)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<16 x s64>), [[DEF]](p1) :: (store 128 into `<16 x i64> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY33:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY33]]
  store <16 x i64> %arg0, <16 x i64> addrspace(1)* undef
  ret void
}

define void @void_func_v2i16(<2 x i16> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](<2 x s16>), [[DEF]](p1) :: (store 4 into `<2 x i16> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store <2 x i16> %arg0, <2 x i16> addrspace(1)* undef
  ret void
}

define void @void_func_v3i16(<3 x i16> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v3i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<6 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>), [[DEF]](<2 x s16>)
  ; CHECK:   [[UV:%[0-9]+]]:_(<3 x s16>), [[UV1:%[0-9]+]]:_(<3 x s16>) = G_UNMERGE_VALUES [[CONCAT_VECTORS]](<6 x s16>)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF1:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[UV]](<3 x s16>), [[DEF1]](p1) :: (store 6 into `<3 x i16> addrspace(1)* undef`, align 8, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <3 x i16> %arg0, <3 x i16> addrspace(1)* undef
  ret void
}

define void @void_func_v4i16(<4 x i16> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v4i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[CONCAT_VECTORS]](<4 x s16>), [[DEF]](p1) :: (store 8 into `<4 x i16> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <4 x i16> %arg0, <4 x i16> addrspace(1)* undef
  ret void
}

define void @void_func_v5i16(<5 x i16> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v5i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr2
  ; CHECK:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<10 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>), [[COPY2]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>)
  ; CHECK:   [[UV:%[0-9]+]]:_(<5 x s16>), [[UV1:%[0-9]+]]:_(<5 x s16>) = G_UNMERGE_VALUES [[CONCAT_VECTORS]](<10 x s16>)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF1:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[UV]](<5 x s16>), [[DEF1]](p1) :: (store 10 into `<5 x i16> addrspace(1)* undef`, align 16, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  store <5 x i16> %arg0, <5 x i16> addrspace(1)* undef
  ret void
}

define void @void_func_v8i16(<8 x i16> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v8i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr3
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<8 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>), [[COPY2]](<2 x s16>), [[COPY3]](<2 x s16>)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[CONCAT_VECTORS]](<8 x s16>), [[DEF]](p1) :: (store 16 into `<8 x i16> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <8 x i16> %arg0, <8 x i16> addrspace(1)* undef
  ret void
}

define void @void_func_v16i16(<16 x i16> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v16i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr7
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<16 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>), [[COPY2]](<2 x s16>), [[COPY3]](<2 x s16>), [[COPY4]](<2 x s16>), [[COPY5]](<2 x s16>), [[COPY6]](<2 x s16>), [[COPY7]](<2 x s16>)
  ; CHECK:   [[COPY8:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[CONCAT_VECTORS]](<16 x s16>), [[DEF]](p1) :: (store 32 into `<16 x i16> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY9:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY8]]
  ; CHECK:   S_SETPC_B64_return [[COPY9]]
  store <16 x i16> %arg0, <16 x i16> addrspace(1)* undef
  ret void
}

; <2 x i16> pieces that start spilling to the stack.
; FIXME: load of 2 would be sufficient for last piece
define void @void_func_v65i16(<65 x i16> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v65i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr31
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD:%[0-9]+]]:_(<2 x s16>) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.0, align 16, addrspace 5)
  ; CHECK:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<130 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>), [[COPY2]](<2 x s16>), [[COPY3]](<2 x s16>), [[COPY4]](<2 x s16>), [[COPY5]](<2 x s16>), [[COPY6]](<2 x s16>), [[COPY7]](<2 x s16>), [[COPY8]](<2 x s16>), [[COPY9]](<2 x s16>), [[COPY10]](<2 x s16>), [[COPY11]](<2 x s16>), [[COPY12]](<2 x s16>), [[COPY13]](<2 x s16>), [[COPY14]](<2 x s16>), [[COPY15]](<2 x s16>), [[COPY16]](<2 x s16>), [[COPY17]](<2 x s16>), [[COPY18]](<2 x s16>), [[COPY19]](<2 x s16>), [[COPY20]](<2 x s16>), [[COPY21]](<2 x s16>), [[COPY22]](<2 x s16>), [[COPY23]](<2 x s16>), [[COPY24]](<2 x s16>), [[COPY25]](<2 x s16>), [[COPY26]](<2 x s16>), [[COPY27]](<2 x s16>), [[COPY28]](<2 x s16>), [[COPY29]](<2 x s16>), [[COPY30]](<2 x s16>), [[COPY31]](<2 x s16>), [[LOAD]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>), [[DEF]](<2 x s16>)
  ; CHECK:   [[UV:%[0-9]+]]:_(<65 x s16>), [[UV1:%[0-9]+]]:_(<65 x s16>) = G_UNMERGE_VALUES [[CONCAT_VECTORS]](<130 x s16>)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF1:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[UV]](<65 x s16>), [[DEF1]](p1) :: (store 130 into `<65 x i16> addrspace(1)* undef`, align 256, addrspace 1)
  ; CHECK:   [[COPY33:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY33]]
  store <65 x i16> %arg0, <65 x i16> addrspace(1)* undef
  ret void
}

define void @void_func_v2f32(<2 x float> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<2 x s32>), [[DEF]](p1) :: (store 8 into `<2 x float> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <2 x float> %arg0, <2 x float> addrspace(1)* undef
  ret void
}

define void @void_func_v3f32(<3 x float> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v3f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<3 x s32>), [[DEF]](p1) :: (store 12 into `<3 x float> addrspace(1)* undef`, align 16, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  store <3 x float> %arg0, <3 x float> addrspace(1)* undef
  ret void
}

define void @void_func_v4f32(<4 x float> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v4f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<4 x s32>), [[DEF]](p1) :: (store 16 into `<4 x float> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <4 x float> %arg0, <4 x float> addrspace(1)* undef
  ret void
}

define void @void_func_v8f32(<8 x float> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v8f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[COPY8:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<8 x s32>), [[DEF]](p1) :: (store 32 into `<8 x float> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY9:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY8]]
  ; CHECK:   S_SETPC_B64_return [[COPY9]]
  store <8 x float> %arg0, <8 x float> addrspace(1)* undef
  ret void
}

define void @void_func_v16f32(<16 x float> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v16f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<16 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32)
  ; CHECK:   [[COPY16:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<16 x s32>), [[DEF]](p1) :: (store 64 into `<16 x float> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY17:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY16]]
  ; CHECK:   S_SETPC_B64_return [[COPY17]]
  store <16 x float> %arg0, <16 x float> addrspace(1)* undef
  ret void
}

define void @void_func_v2f64(<2 x double> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2f64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<2 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<2 x s64>), [[DEF]](p1) :: (store 16 into `<2 x double> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <2 x double> %arg0, <2 x double> addrspace(1)* undef
  ret void
}

define void @void_func_v3f64(<3 x double> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v3f64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64)
  ; CHECK:   [[COPY6:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<3 x s64>), [[DEF]](p1) :: (store 24 into `<3 x double> addrspace(1)* undef`, align 32, addrspace 1)
  ; CHECK:   [[COPY7:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY6]]
  ; CHECK:   S_SETPC_B64_return [[COPY7]]
  store <3 x double> %arg0, <3 x double> addrspace(1)* undef
  ret void
}

define void @void_func_v4f64(<4 x double> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v4f64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<4 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64), [[MV3]](s64)
  ; CHECK:   [[COPY8:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<4 x s64>), [[DEF]](p1) :: (store 32 into `<4 x double> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY9:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY8]]
  ; CHECK:   S_SETPC_B64_return [[COPY9]]
  store <4 x double> %arg0, <4 x double> addrspace(1)* undef
  ret void
}

define void @void_func_v8f64(<8 x double> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v8f64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[MV4:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; CHECK:   [[MV5:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY10]](s32), [[COPY11]](s32)
  ; CHECK:   [[MV6:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY12]](s32), [[COPY13]](s32)
  ; CHECK:   [[MV7:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY14]](s32), [[COPY15]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<8 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64), [[MV3]](s64), [[MV4]](s64), [[MV5]](s64), [[MV6]](s64), [[MV7]](s64)
  ; CHECK:   [[COPY16:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<8 x s64>), [[DEF]](p1) :: (store 64 into `<8 x double> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY17:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY16]]
  ; CHECK:   S_SETPC_B64_return [[COPY17]]
  store <8 x double> %arg0, <8 x double> addrspace(1)* undef
  ret void
}

define void @void_func_v16f64(<16 x double> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v16f64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; CHECK:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; CHECK:   [[MV4:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY8]](s32), [[COPY9]](s32)
  ; CHECK:   [[MV5:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY10]](s32), [[COPY11]](s32)
  ; CHECK:   [[MV6:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY12]](s32), [[COPY13]](s32)
  ; CHECK:   [[MV7:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY14]](s32), [[COPY15]](s32)
  ; CHECK:   [[MV8:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY16]](s32), [[COPY17]](s32)
  ; CHECK:   [[MV9:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY18]](s32), [[COPY19]](s32)
  ; CHECK:   [[MV10:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY20]](s32), [[COPY21]](s32)
  ; CHECK:   [[MV11:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY22]](s32), [[COPY23]](s32)
  ; CHECK:   [[MV12:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY24]](s32), [[COPY25]](s32)
  ; CHECK:   [[MV13:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY26]](s32), [[COPY27]](s32)
  ; CHECK:   [[MV14:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY28]](s32), [[COPY29]](s32)
  ; CHECK:   [[MV15:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<16 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64), [[MV2]](s64), [[MV3]](s64), [[MV4]](s64), [[MV5]](s64), [[MV6]](s64), [[MV7]](s64), [[MV8]](s64), [[MV9]](s64), [[MV10]](s64), [[MV11]](s64), [[MV12]](s64), [[MV13]](s64), [[MV14]](s64), [[MV15]](s64)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<16 x s64>), [[DEF]](p1) :: (store 128 into `<16 x double> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY33:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY33]]
  store <16 x double> %arg0, <16 x double> addrspace(1)* undef
  ret void
}

define void @void_func_v2f16(<2 x half> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v2f16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](<2 x s16>), [[DEF]](p1) :: (store 4 into `<2 x half> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store <2 x half> %arg0, <2 x half> addrspace(1)* undef
  ret void
}

define void @void_func_v3f16(<3 x half> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v3f16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[DEF:%[0-9]+]]:_(<2 x s16>) = G_IMPLICIT_DEF
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<6 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>), [[DEF]](<2 x s16>)
  ; CHECK:   [[UV:%[0-9]+]]:_(<3 x s16>), [[UV1:%[0-9]+]]:_(<3 x s16>) = G_UNMERGE_VALUES [[CONCAT_VECTORS]](<6 x s16>)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF1:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[UV]](<3 x s16>), [[DEF1]](p1) :: (store 6 into `<3 x half> addrspace(1)* undef`, align 8, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <3 x half> %arg0, <3 x half> addrspace(1)* undef
  ret void
}

define void @void_func_v4f16(<4 x half> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v4f16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<4 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[CONCAT_VECTORS]](<4 x s16>), [[DEF]](p1) :: (store 8 into `<4 x half> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store <4 x half> %arg0, <4 x half> addrspace(1)* undef
  ret void
}

define void @void_func_v8f16(<8 x half> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v8f16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr3
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<8 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>), [[COPY2]](<2 x s16>), [[COPY3]](<2 x s16>)
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[CONCAT_VECTORS]](<8 x s16>), [[DEF]](p1) :: (store 16 into `<8 x half> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  store <8 x half> %arg0, <8 x half> addrspace(1)* undef
  ret void
}

define void @void_func_v16f16(<16 x half> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v16f16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(<2 x s16>) = COPY $vgpr7
  ; CHECK:   [[CONCAT_VECTORS:%[0-9]+]]:_(<16 x s16>) = G_CONCAT_VECTORS [[COPY]](<2 x s16>), [[COPY1]](<2 x s16>), [[COPY2]](<2 x s16>), [[COPY3]](<2 x s16>), [[COPY4]](<2 x s16>), [[COPY5]](<2 x s16>), [[COPY6]](<2 x s16>), [[COPY7]](<2 x s16>)
  ; CHECK:   [[COPY8:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[CONCAT_VECTORS]](<16 x s16>), [[DEF]](p1) :: (store 32 into `<16 x half> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY9:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY8]]
  ; CHECK:   S_SETPC_B64_return [[COPY9]]
  store <16 x half> %arg0, <16 x half> addrspace(1)* undef
  ret void
}

; Make sure there is no alignment requirement for passed vgprs.
define void @void_func_i32_i64_i32(i32 %arg0, i64 %arg1, i32 %arg2) #0 {
  ; CHECK-LABEL: name: void_func_i32_i64_i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY5:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[COPY]](s32), [[DEF]](p1) :: (volatile store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[MV]](s64), [[COPY5]](p1) :: (volatile store 8 into `i64 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[COPY3]](s32), [[DEF]](p1) :: (volatile store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY6:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY6]]
  store volatile i32 %arg0, i32 addrspace(1)* undef
  store volatile i64 %arg1, i64 addrspace(1)* undef
  store volatile i32 %arg2, i32 addrspace(1)* undef
  ret void
}

define void @void_func_struct_i32({ i32 } %arg0) #0 {
  ; CHECK-LABEL: name: void_func_struct_i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[COPY]](s32), [[DEF]](p1) :: (store 4 into `{ i32 } addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  store { i32 } %arg0, { i32 } addrspace(1)* undef
  ret void
}

define void @void_func_struct_i8_i32({ i8, i32 } %arg0) #0 {
  ; CHECK-LABEL: name: void_func_struct_i8_i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[TRUNC1:%[0-9]+]]:_(s8) = G_TRUNC [[TRUNC]](s16)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC1]](s8), [[DEF]](p1) :: (store 1 into `{ i8, i32 } addrspace(1)* undef`, align 4, addrspace 1)
  ; CHECK:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p1) = G_PTR_ADD [[DEF]], [[C]](s64)
  ; CHECK:   G_STORE [[COPY1]](s32), [[PTR_ADD]](p1) :: (store 4 into `{ i8, i32 } addrspace(1)* undef` + 4, addrspace 1)
  ; CHECK:   [[COPY3:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY3]]
  store { i8, i32 } %arg0, { i8, i32 } addrspace(1)* undef
  ret void
}

define void @void_func_byval_struct_i8_i32({ i8, i32 } addrspace(5)* byval({ i8, i32 }) %arg0) #0 {
  ; CHECK-LABEL: name: void_func_byval_struct_i8_i32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $sgpr30_sgpr31
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX]](p5)
  ; CHECK:   [[COPY1:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s8) = G_LOAD [[COPY]](p5) :: (dereferenceable load 1 from %ir.arg0, align 4, addrspace 5)
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY]], [[C]](s32)
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[PTR_ADD]](p5) :: (dereferenceable load 4 from %ir.arg0 + 4, addrspace 5)
  ; CHECK:   G_STORE [[LOAD]](s8), [[DEF]](p1) :: (store 1 into `{ i8, i32 } addrspace(1)* undef`, align 4, addrspace 1)
  ; CHECK:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK:   [[PTR_ADD1:%[0-9]+]]:_(p1) = G_PTR_ADD [[DEF]], [[C1]](s64)
  ; CHECK:   G_STORE [[LOAD1]](s32), [[PTR_ADD1]](p1) :: (store 4 into `{ i8, i32 } addrspace(1)* undef` + 4, addrspace 1)
  ; CHECK:   [[COPY2:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY1]]
  ; CHECK:   S_SETPC_B64_return [[COPY2]]
  %arg0.load = load { i8, i32 }, { i8, i32 } addrspace(5)* %arg0
  store { i8, i32 } %arg0.load, { i8, i32 } addrspace(1)* undef
  ret void
}

define void @void_func_byval_struct_i8_i32_x2({ i8, i32 } addrspace(5)* byval({ i8, i32 }) %arg0, { i8, i32 } addrspace(5)* byval({ i8, i32 }) %arg1, i32 %arg2) #0 {
  ; CHECK-LABEL: name: void_func_byval_struct_i8_i32_x2
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $sgpr30_sgpr31
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[COPY:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX]](p5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX1]](p5)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY3:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[DEF1:%[0-9]+]]:_(p3) = G_IMPLICIT_DEF
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s8) = G_LOAD [[COPY]](p5) :: (volatile dereferenceable load 1 from %ir.arg0, align 4, addrspace 5)
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY]], [[C]](s32)
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[PTR_ADD]](p5) :: (volatile dereferenceable load 4 from %ir.arg0 + 4, addrspace 5)
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s8) = G_LOAD [[COPY1]](p5) :: (volatile dereferenceable load 1 from %ir.arg1, align 4, addrspace 5)
  ; CHECK:   [[PTR_ADD1:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY1]], [[C]](s32)
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[PTR_ADD1]](p5) :: (volatile dereferenceable load 4 from %ir.arg1 + 4, addrspace 5)
  ; CHECK:   G_STORE [[LOAD]](s8), [[DEF]](p1) :: (volatile store 1 into `{ i8, i32 } addrspace(1)* undef`, align 4, addrspace 1)
  ; CHECK:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK:   [[PTR_ADD2:%[0-9]+]]:_(p1) = G_PTR_ADD [[DEF]], [[C1]](s64)
  ; CHECK:   G_STORE [[LOAD1]](s32), [[PTR_ADD2]](p1) :: (volatile store 4 into `{ i8, i32 } addrspace(1)* undef` + 4, addrspace 1)
  ; CHECK:   G_STORE [[LOAD2]](s8), [[DEF]](p1) :: (volatile store 1 into `{ i8, i32 } addrspace(1)* undef`, align 4, addrspace 1)
  ; CHECK:   [[PTR_ADD3:%[0-9]+]]:_(p1) = G_PTR_ADD [[DEF]], [[C1]](s64)
  ; CHECK:   G_STORE [[LOAD3]](s32), [[PTR_ADD3]](p1) :: (volatile store 4 into `{ i8, i32 } addrspace(1)* undef` + 4, addrspace 1)
  ; CHECK:   G_STORE [[COPY2]](s32), [[DEF1]](p3) :: (volatile store 4 into `i32 addrspace(3)* undef`, addrspace 3)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY3]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  %arg0.load = load volatile { i8, i32 }, { i8, i32 } addrspace(5)* %arg0
  %arg1.load = load volatile { i8, i32 }, { i8, i32 } addrspace(5)* %arg1
  store volatile { i8, i32 } %arg0.load, { i8, i32 } addrspace(1)* undef
  store volatile { i8, i32 } %arg1.load, { i8, i32 } addrspace(1)* undef
  store volatile i32 %arg2, i32 addrspace(3)* undef
  ret void
}

define void @void_func_byval_i32_byval_i64(i32 addrspace(5)* byval(i32) %arg0, i64 addrspace(5)* byval(i64) %arg1) #0 {
  ; CHECK-LABEL: name: void_func_byval_i32_byval_i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $sgpr30_sgpr31
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[COPY:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX]](p5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX1]](p5)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY3:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[COPY]](p5) :: (dereferenceable load 4 from %ir.arg0, addrspace 5)
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s64) = G_LOAD [[COPY1]](p5) :: (dereferenceable load 8 from %ir.arg1, addrspace 5)
  ; CHECK:   G_STORE [[LOAD]](s32), [[DEF]](p1) :: (store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD1]](s64), [[COPY3]](p1) :: (store 8 into `i64 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  %arg0.load = load i32, i32 addrspace(5)* %arg0
  %arg1.load = load i64, i64 addrspace(5)* %arg1
  store i32 %arg0.load, i32 addrspace(1)* undef
  store i64 %arg1.load, i64 addrspace(1)* undef
  ret void
}

define void @void_func_byval_i8_align32_i16_align64(i8 addrspace(5)* byval(i8) %arg0, i16 addrspace(5)* byval(i16) align 64 %arg1) #0 {
  ; CHECK-LABEL: name: void_func_byval_i8_align32_i16_align64
  ; CHECK: frameInfo:
  ; CHECK: maxAlignment:    64
  ; CHECK: fixedStack:
  ; CHECK: - { id: 0, type: default, offset: 64, size: 2, alignment: 16, stack-id: default,
  ; CHECK-NEXT:    isImmutable: false, isAliased: false, callee-saved-register: '',
  ; CHECK: - { id: 1, type: default, offset: 0, size: 1, alignment: 16, stack-id: default,
  ; CHECK-NEXT:  isImmutable: false, isAliased: false, callee-saved-register: '',
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $sgpr30_sgpr31
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[COPY:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX]](p5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX1]](p5)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(p1) = G_CONSTANT i64 0
  ; CHECK:   [[COPY3:%[0-9]+]]:_(p1) = COPY [[C]](p1)
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s8) = G_LOAD [[COPY]](p5) :: (dereferenceable load 1 from %ir.arg0, addrspace 5)
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s16) = G_LOAD [[COPY1]](p5) :: (dereferenceable load 2 from %ir.arg1, addrspace 5)
  ; CHECK:   G_STORE [[LOAD]](s8), [[C]](p1) :: (store 1 into `i8 addrspace(1)* null`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD1]](s16), [[COPY3]](p1) :: (store 2 into `i16 addrspace(1)* null`, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  %arg0.load = load i8, i8 addrspace(5)* %arg0
  %arg1.load = load i16, i16 addrspace(5)* %arg1
  store i8 %arg0.load, i8 addrspace(1)* null
  store i16 %arg1.load, i16 addrspace(1)* null
  ret void
}

; Make sure the alignment is taken from the correct parameter.
define void @byval_a3i32_align128_byval_i16_align64([3 x i32] addrspace(5)* byval([3 x i32]) align 128 %arg0, i16 addrspace(5)* byval(i16) align 64 %arg1) #0 {
  ; CHECK-LABEL: name: byval_a3i32_align128_byval_i16_align64
  ; CHECK: frameInfo:
  ; CHECK: maxAlignment:    128
  ; CHECK: fixedStack:
  ; CHECK-NEXT: - { id: 0, type: default, offset: 64, size: 2, alignment: 16, stack-id: default,
  ; CHECK-NEXT:  isImmutable: false, isAliased: false, callee-saved-register: '',
  ; CHECK: - { id: 1, type: default, offset: 0, size: 12, alignment: 16, stack-id: default,
  ; CHECK-NEXT: isImmutable: false, isAliased: false, callee-saved-register: '',
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $sgpr30_sgpr31
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[COPY:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX]](p5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX1]](p5)
  ; CHECK:   [[COPY2:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(p1) = G_CONSTANT i64 0
  ; CHECK:   [[COPY3:%[0-9]+]]:_(p1) = COPY [[C]](p1)
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[COPY]](p5) :: (dereferenceable load 4 from %ir.arg0, addrspace 5)
  ; CHECK:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 4
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY]], [[C1]](s32)
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[PTR_ADD]](p5) :: (dereferenceable load 4 from %ir.arg0 + 4, addrspace 5)
  ; CHECK:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 8
  ; CHECK:   [[PTR_ADD1:%[0-9]+]]:_(p5) = G_PTR_ADD [[COPY]], [[C2]](s32)
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[PTR_ADD1]](p5) :: (dereferenceable load 4 from %ir.arg0 + 8, addrspace 5)
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s16) = G_LOAD [[COPY1]](p5) :: (dereferenceable load 2 from %ir.arg1, addrspace 5)
  ; CHECK:   G_STORE [[LOAD]](s32), [[C]](p1) :: (store 4 into `[3 x i32] addrspace(1)* null`, addrspace 1)
  ; CHECK:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; CHECK:   [[PTR_ADD2:%[0-9]+]]:_(p1) = G_PTR_ADD [[C]], [[C3]](s64)
  ; CHECK:   G_STORE [[LOAD1]](s32), [[PTR_ADD2]](p1) :: (store 4 into `[3 x i32] addrspace(1)* null` + 4, addrspace 1)
  ; CHECK:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 8
  ; CHECK:   [[PTR_ADD3:%[0-9]+]]:_(p1) = G_PTR_ADD [[C]], [[C4]](s64)
  ; CHECK:   G_STORE [[LOAD2]](s32), [[PTR_ADD3]](p1) :: (store 4 into `[3 x i32] addrspace(1)* null` + 8, addrspace 1)
  ; CHECK:   G_STORE [[LOAD3]](s16), [[COPY3]](p1) :: (store 2 into `i16 addrspace(1)* null`, addrspace 1)
  ; CHECK:   [[COPY4:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY2]]
  ; CHECK:   S_SETPC_B64_return [[COPY4]]
  %arg0.load = load [3 x i32], [3 x i32] addrspace(5)* %arg0
  %arg1.load = load i16, i16 addrspace(5)* %arg1
  store [3 x i32] %arg0.load, [3 x i32] addrspace(1)* null
  store i16 %arg1.load, i16 addrspace(1)* null
  ret void
}

; byval argument after non-byval stack passed argument
define void @void_func_v32i32_i32_byval_i8(<32 x i32> %arg0, i32 %arg1, i8 addrspace(5)* byval(i8) align 8 %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_i32_byval_i8
  ; CHECK: frameInfo:
  ; CHECK: maxAlignment:    8
  ; CHECK: fixedStack:
  ; CHECK:     - { id: 0, type: default, offset: 8, size: 1, alignment: 8, stack-id: default,
  ; CHECK-NEXT:  isImmutable: false, isAliased: false, callee-saved-register: '',
  ; CHECK: - { id: 1, type: default, offset: 0, size: 4, alignment: 16, stack-id: default,
  ; CHECK-NEXT:  isImmutable: true, isAliased: false, callee-saved-register: '',
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.1, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[COPY32:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX1]](p5)
  ; CHECK:   [[COPY33:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(p1) = G_CONSTANT i64 0
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[C]](p1)
  ; CHECK:   G_STORE [[LOAD]](s32), [[C]](p1) :: (store 4 into `i32 addrspace(1)* null`, addrspace 1)
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s8) = G_LOAD [[COPY32]](p5) :: (dereferenceable load 1 from %ir.arg2, addrspace 5)
  ; CHECK:   G_STORE [[LOAD1]](s8), [[COPY34]](p1) :: (store 1 into `i8 addrspace(1)* null`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY33]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store i32 %arg1, i32 addrspace(1)* null
  %arg2.load = load i8, i8 addrspace(5)* %arg2
  store i8 %arg2.load, i8 addrspace(1)* null
  ret void
}

; byval argument before non-byval stack passed argument
define void @void_func_v32i32_byval_i8_i32(<32 x i32> %arg0, i8 addrspace(5)* byval(i8) %arg1, i32 %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_byval_i8_i32
  ; CHECK: frameInfo:
  ; CHECK: maxAlignment:    4
  ; CHECK: fixedStack:
  ; CHECK-NEXT: - { id: 0, type: default, offset: 4, size: 4, alignment: 4, stack-id: default,
  ; CHECK-NEXT:  isImmutable: true, isAliased: false, callee-saved-register: '',
  ; CHECK: - { id: 1, type: default, offset: 0, size: 1, alignment: 16, stack-id: default,
  ; CHECK-NEXT: isImmutable: false, isAliased: false, callee-saved-register: '',
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[COPY32:%[0-9]+]]:_(p5) = COPY [[FRAME_INDEX]](p5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.0, addrspace 5)
  ; CHECK:   [[COPY33:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(p1) = G_CONSTANT i64 0
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[C]](p1)
  ; CHECK:   G_STORE [[LOAD]](s32), [[C]](p1) :: (store 4 into `i32 addrspace(1)* null`, addrspace 1)
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s8) = G_LOAD [[COPY32]](p5) :: (dereferenceable load 1 from %ir.arg1, addrspace 5)
  ; CHECK:   G_STORE [[LOAD1]](s8), [[COPY34]](p1) :: (store 1 into `i8 addrspace(1)* null`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY33]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store i32 %arg2, i32 addrspace(1)* null
  %arg1.load = load i8, i8 addrspace(5)* %arg1
  store i8 %arg1.load, i8 addrspace(1)* null
  ret void
}

define void @void_func_v32i32_i32_i64(<32 x i32> %arg0, i32 %arg1, i64 %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_i32_i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.2, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.1, addrspace 5)
  ; CHECK:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load 4 from %fixed-stack.0, align 8, addrspace 5)
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[LOAD1]](s32), [[LOAD2]](s32)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD]](s32), [[COPY33]](p1) :: (volatile store 4 into `i32 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[MV]](s64), [[COPY34]](p1) :: (volatile store 8 into `i64 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile i32 %arg1, i32 addrspace(1)* undef
  store volatile i64 %arg2, i64 addrspace(1)* undef
  ret void
}

; FIXME: Different ext load types on CI vs. VI
define void @void_func_v32i32_i1_i8_i16(<32 x i32> %arg0, i1 %arg1, i8 %arg2, i16 %arg3, half %arg4) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_i1_i8_i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s1) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 1 from %fixed-stack.3, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 2 from %fixed-stack.2, align 4, addrspace 5)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s8) = G_TRUNC [[LOAD1]](s16)
  ; CHECK:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load 2 from %fixed-stack.1, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load 2 from %fixed-stack.0, align 4, addrspace 5)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY35:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY36:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD]](s1), [[COPY33]](p1) :: (volatile store 1 into `i1 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[TRUNC]](s8), [[COPY34]](p1) :: (volatile store 1 into `i8 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD2]](s16), [[COPY35]](p1) :: (volatile store 2 into `i16 addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD3]](s16), [[COPY36]](p1) :: (volatile store 2 into `half addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY37:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY37]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile i1 %arg1, i1 addrspace(1)* undef
  store volatile i8 %arg2, i8 addrspace(1)* undef
  store volatile i16 %arg3, i16 addrspace(1)* undef
  store volatile half %arg4, half addrspace(1)* undef
  ret void
}

define void @void_func_v32i32_p3_p5_i16(<32 x i32> %arg0, i8 addrspace(3)* %arg1, i8 addrspace(5)* %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_p3_p5_i16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD:%[0-9]+]]:_(p3) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.1, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(p5) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.0, addrspace 5)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD]](p3), [[COPY33]](p1) :: (volatile store 4 into `i8 addrspace(3)* addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD1]](p5), [[COPY34]](p1) :: (volatile store 4 into `i8 addrspace(5)* addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile i8 addrspace(3)* %arg1, i8 addrspace(3)* addrspace(1)* undef
  store volatile i8 addrspace(5)* %arg2, i8 addrspace(5)* addrspace(1)* undef
  ret void
}

define void @void_func_v32i32_v2i32_v2f32(<32 x i32> %arg0, <2 x i32> %arg1, <2 x float> %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_v2i32_v2f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.3, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.2, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[LOAD]](s32), [[LOAD1]](s32)
  ; CHECK:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load 4 from %fixed-stack.1, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load 4 from %fixed-stack.0, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR2:%[0-9]+]]:_(<2 x s32>) = G_BUILD_VECTOR [[LOAD2]](s32), [[LOAD3]](s32)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR1]](<2 x s32>), [[COPY33]](p1) :: (volatile store 8 into `<2 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR2]](<2 x s32>), [[COPY34]](p1) :: (volatile store 8 into `<2 x float> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile <2 x i32> %arg1, <2 x i32> addrspace(1)* undef
  store volatile <2 x float> %arg2, <2 x float> addrspace(1)* undef
  ret void
}

define void @void_func_v32i32_v2i16_v2f16(<32 x i32> %arg0, <2 x i16> %arg1, <2 x half> %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_v2i16_v2f16
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD:%[0-9]+]]:_(<2 x s16>) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.1, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(<2 x s16>) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.0, addrspace 5)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD]](<2 x s16>), [[COPY33]](p1) :: (volatile store 4 into `<2 x i16> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[LOAD1]](<2 x s16>), [[COPY34]](p1) :: (volatile store 4 into `<2 x half> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile <2 x i16> %arg1, <2 x i16> addrspace(1)* undef
  store volatile <2 x half> %arg2, <2 x half> addrspace(1)* undef
  ret void
}

define void @void_func_v32i32_v2i64_v2f64(<32 x i32> %arg0, <2 x i64> %arg1, <2 x double> %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_v2i64_v2f64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.7
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.7, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.6
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.6, addrspace 5)
  ; CHECK:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load 4 from %fixed-stack.5, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load 4 from %fixed-stack.4, addrspace 5)
  ; CHECK:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[LOAD]](s32), [[LOAD1]](s32)
  ; CHECK:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[LOAD2]](s32), [[LOAD3]](s32)
  ; CHECK:   [[BUILD_VECTOR1:%[0-9]+]]:_(<2 x s64>) = G_BUILD_VECTOR [[MV]](s64), [[MV1]](s64)
  ; CHECK:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK:   [[LOAD4:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX4]](p5) :: (invariant load 4 from %fixed-stack.3, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK:   [[LOAD5:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX5]](p5) :: (invariant load 4 from %fixed-stack.2, addrspace 5)
  ; CHECK:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD6:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX6]](p5) :: (invariant load 4 from %fixed-stack.1, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX7:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD7:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX7]](p5) :: (invariant load 4 from %fixed-stack.0, addrspace 5)
  ; CHECK:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[LOAD4]](s32), [[LOAD5]](s32)
  ; CHECK:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[LOAD6]](s32), [[LOAD7]](s32)
  ; CHECK:   [[BUILD_VECTOR2:%[0-9]+]]:_(<2 x s64>) = G_BUILD_VECTOR [[MV2]](s64), [[MV3]](s64)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR1]](<2 x s64>), [[COPY33]](p1) :: (volatile store 16 into `<2 x i64> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR2]](<2 x s64>), [[COPY34]](p1) :: (volatile store 16 into `<2 x double> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile <2 x i64> %arg1, <2 x i64> addrspace(1)* undef
  store volatile <2 x double> %arg2, <2 x double> addrspace(1)* undef
  ret void
}

define void @void_func_v32i32_v4i32_v4f32(<32 x i32> %arg0, <4 x i32> %arg1, <4 x float> %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_v4i32_v4f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.7
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.7, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.6
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.6, addrspace 5)
  ; CHECK:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load 4 from %fixed-stack.5, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load 4 from %fixed-stack.4, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR1:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[LOAD]](s32), [[LOAD1]](s32), [[LOAD2]](s32), [[LOAD3]](s32)
  ; CHECK:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK:   [[LOAD4:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX4]](p5) :: (invariant load 4 from %fixed-stack.3, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK:   [[LOAD5:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX5]](p5) :: (invariant load 4 from %fixed-stack.2, addrspace 5)
  ; CHECK:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD6:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX6]](p5) :: (invariant load 4 from %fixed-stack.1, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX7:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD7:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX7]](p5) :: (invariant load 4 from %fixed-stack.0, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR2:%[0-9]+]]:_(<4 x s32>) = G_BUILD_VECTOR [[LOAD4]](s32), [[LOAD5]](s32), [[LOAD6]](s32), [[LOAD7]](s32)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR1]](<4 x s32>), [[COPY33]](p1) :: (volatile store 16 into `<4 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR2]](<4 x s32>), [[COPY34]](p1) :: (volatile store 16 into `<4 x float> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile <4 x i32> %arg1, <4 x i32> addrspace(1)* undef
  store volatile <4 x float> %arg2, <4 x float> addrspace(1)* undef
  ret void
}

define void @void_func_v32i32_v8i32_v8f32(<32 x i32> %arg0, <8 x i32> %arg1, <8 x float> %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_v8i32_v8f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.15
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.15, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.14
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.14, addrspace 5)
  ; CHECK:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.13
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load 4 from %fixed-stack.13, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.12
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load 4 from %fixed-stack.12, addrspace 5)
  ; CHECK:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.11
  ; CHECK:   [[LOAD4:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX4]](p5) :: (invariant load 4 from %fixed-stack.11, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.10
  ; CHECK:   [[LOAD5:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX5]](p5) :: (invariant load 4 from %fixed-stack.10, addrspace 5)
  ; CHECK:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.9
  ; CHECK:   [[LOAD6:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX6]](p5) :: (invariant load 4 from %fixed-stack.9, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX7:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.8
  ; CHECK:   [[LOAD7:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX7]](p5) :: (invariant load 4 from %fixed-stack.8, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR1:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[LOAD]](s32), [[LOAD1]](s32), [[LOAD2]](s32), [[LOAD3]](s32), [[LOAD4]](s32), [[LOAD5]](s32), [[LOAD6]](s32), [[LOAD7]](s32)
  ; CHECK:   [[FRAME_INDEX8:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.7
  ; CHECK:   [[LOAD8:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX8]](p5) :: (invariant load 4 from %fixed-stack.7, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX9:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.6
  ; CHECK:   [[LOAD9:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX9]](p5) :: (invariant load 4 from %fixed-stack.6, addrspace 5)
  ; CHECK:   [[FRAME_INDEX10:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; CHECK:   [[LOAD10:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX10]](p5) :: (invariant load 4 from %fixed-stack.5, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX11:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; CHECK:   [[LOAD11:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX11]](p5) :: (invariant load 4 from %fixed-stack.4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX12:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK:   [[LOAD12:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX12]](p5) :: (invariant load 4 from %fixed-stack.3, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX13:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK:   [[LOAD13:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX13]](p5) :: (invariant load 4 from %fixed-stack.2, addrspace 5)
  ; CHECK:   [[FRAME_INDEX14:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD14:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX14]](p5) :: (invariant load 4 from %fixed-stack.1, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX15:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD15:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX15]](p5) :: (invariant load 4 from %fixed-stack.0, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR2:%[0-9]+]]:_(<8 x s32>) = G_BUILD_VECTOR [[LOAD8]](s32), [[LOAD9]](s32), [[LOAD10]](s32), [[LOAD11]](s32), [[LOAD12]](s32), [[LOAD13]](s32), [[LOAD14]](s32), [[LOAD15]](s32)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR1]](<8 x s32>), [[COPY33]](p1) :: (volatile store 32 into `<8 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR2]](<8 x s32>), [[COPY34]](p1) :: (volatile store 32 into `<8 x float> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile <8 x i32> %arg1, <8 x i32> addrspace(1)* undef
  store volatile <8 x float> %arg2, <8 x float> addrspace(1)* undef
  ret void
}

define void @void_func_v32i32_v16i32_v16f32(<32 x i32> %arg0, <16 x i32> %arg1, <16 x float> %arg2) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_v16i32_v16f32
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.31
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 4 from %fixed-stack.31, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.30
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 4 from %fixed-stack.30, addrspace 5)
  ; CHECK:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.29
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load 4 from %fixed-stack.29, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.28
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load 4 from %fixed-stack.28, addrspace 5)
  ; CHECK:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.27
  ; CHECK:   [[LOAD4:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX4]](p5) :: (invariant load 4 from %fixed-stack.27, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.26
  ; CHECK:   [[LOAD5:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX5]](p5) :: (invariant load 4 from %fixed-stack.26, addrspace 5)
  ; CHECK:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.25
  ; CHECK:   [[LOAD6:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX6]](p5) :: (invariant load 4 from %fixed-stack.25, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX7:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.24
  ; CHECK:   [[LOAD7:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX7]](p5) :: (invariant load 4 from %fixed-stack.24, addrspace 5)
  ; CHECK:   [[FRAME_INDEX8:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.23
  ; CHECK:   [[LOAD8:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX8]](p5) :: (invariant load 4 from %fixed-stack.23, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX9:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.22
  ; CHECK:   [[LOAD9:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX9]](p5) :: (invariant load 4 from %fixed-stack.22, addrspace 5)
  ; CHECK:   [[FRAME_INDEX10:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.21
  ; CHECK:   [[LOAD10:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX10]](p5) :: (invariant load 4 from %fixed-stack.21, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX11:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.20
  ; CHECK:   [[LOAD11:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX11]](p5) :: (invariant load 4 from %fixed-stack.20, addrspace 5)
  ; CHECK:   [[FRAME_INDEX12:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.19
  ; CHECK:   [[LOAD12:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX12]](p5) :: (invariant load 4 from %fixed-stack.19, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX13:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.18
  ; CHECK:   [[LOAD13:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX13]](p5) :: (invariant load 4 from %fixed-stack.18, addrspace 5)
  ; CHECK:   [[FRAME_INDEX14:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.17
  ; CHECK:   [[LOAD14:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX14]](p5) :: (invariant load 4 from %fixed-stack.17, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX15:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.16
  ; CHECK:   [[LOAD15:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX15]](p5) :: (invariant load 4 from %fixed-stack.16, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR1:%[0-9]+]]:_(<16 x s32>) = G_BUILD_VECTOR [[LOAD]](s32), [[LOAD1]](s32), [[LOAD2]](s32), [[LOAD3]](s32), [[LOAD4]](s32), [[LOAD5]](s32), [[LOAD6]](s32), [[LOAD7]](s32), [[LOAD8]](s32), [[LOAD9]](s32), [[LOAD10]](s32), [[LOAD11]](s32), [[LOAD12]](s32), [[LOAD13]](s32), [[LOAD14]](s32), [[LOAD15]](s32)
  ; CHECK:   [[FRAME_INDEX16:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.15
  ; CHECK:   [[LOAD16:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX16]](p5) :: (invariant load 4 from %fixed-stack.15, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX17:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.14
  ; CHECK:   [[LOAD17:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX17]](p5) :: (invariant load 4 from %fixed-stack.14, addrspace 5)
  ; CHECK:   [[FRAME_INDEX18:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.13
  ; CHECK:   [[LOAD18:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX18]](p5) :: (invariant load 4 from %fixed-stack.13, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX19:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.12
  ; CHECK:   [[LOAD19:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX19]](p5) :: (invariant load 4 from %fixed-stack.12, addrspace 5)
  ; CHECK:   [[FRAME_INDEX20:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.11
  ; CHECK:   [[LOAD20:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX20]](p5) :: (invariant load 4 from %fixed-stack.11, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX21:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.10
  ; CHECK:   [[LOAD21:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX21]](p5) :: (invariant load 4 from %fixed-stack.10, addrspace 5)
  ; CHECK:   [[FRAME_INDEX22:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.9
  ; CHECK:   [[LOAD22:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX22]](p5) :: (invariant load 4 from %fixed-stack.9, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX23:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.8
  ; CHECK:   [[LOAD23:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX23]](p5) :: (invariant load 4 from %fixed-stack.8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX24:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.7
  ; CHECK:   [[LOAD24:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX24]](p5) :: (invariant load 4 from %fixed-stack.7, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX25:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.6
  ; CHECK:   [[LOAD25:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX25]](p5) :: (invariant load 4 from %fixed-stack.6, addrspace 5)
  ; CHECK:   [[FRAME_INDEX26:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; CHECK:   [[LOAD26:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX26]](p5) :: (invariant load 4 from %fixed-stack.5, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX27:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; CHECK:   [[LOAD27:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX27]](p5) :: (invariant load 4 from %fixed-stack.4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX28:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK:   [[LOAD28:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX28]](p5) :: (invariant load 4 from %fixed-stack.3, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX29:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK:   [[LOAD29:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX29]](p5) :: (invariant load 4 from %fixed-stack.2, addrspace 5)
  ; CHECK:   [[FRAME_INDEX30:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD30:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX30]](p5) :: (invariant load 4 from %fixed-stack.1, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX31:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD31:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX31]](p5) :: (invariant load 4 from %fixed-stack.0, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR2:%[0-9]+]]:_(<16 x s32>) = G_BUILD_VECTOR [[LOAD16]](s32), [[LOAD17]](s32), [[LOAD18]](s32), [[LOAD19]](s32), [[LOAD20]](s32), [[LOAD21]](s32), [[LOAD22]](s32), [[LOAD23]](s32), [[LOAD24]](s32), [[LOAD25]](s32), [[LOAD26]](s32), [[LOAD27]](s32), [[LOAD28]](s32), [[LOAD29]](s32), [[LOAD30]](s32), [[LOAD31]](s32)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   [[COPY34:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR1]](<16 x s32>), [[COPY33]](p1) :: (volatile store 64 into `<16 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[BUILD_VECTOR2]](<16 x s32>), [[COPY34]](p1) :: (volatile store 64 into `<16 x float> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY35:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY35]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile <16 x i32> %arg1, <16 x i32> addrspace(1)* undef
  store volatile <16 x float> %arg2, <16 x float> addrspace(1)* undef
  ret void
}

; Make sure v3 isn't a wasted register because of v3 types being promoted to v4
define void @void_func_v3f32_wasted_reg(<3 x float> %arg0, i32 %arg1) #0 {
  ; CHECK-LABEL: name: void_func_v3f32_wasted_reg
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; CHECK:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 2
  ; CHECK:   [[DEF:%[0-9]+]]:_(p3) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY5:%[0-9]+]]:_(p3) = COPY [[DEF]](p3)
  ; CHECK:   [[EVEC:%[0-9]+]]:_(s32) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<3 x s32>), [[C]](s32)
  ; CHECK:   [[EVEC1:%[0-9]+]]:_(s32) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<3 x s32>), [[C1]](s32)
  ; CHECK:   [[EVEC2:%[0-9]+]]:_(s32) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<3 x s32>), [[C2]](s32)
  ; CHECK:   G_STORE [[EVEC]](s32), [[DEF]](p3) :: (volatile store 4 into `float addrspace(3)* undef`, addrspace 3)
  ; CHECK:   G_STORE [[EVEC1]](s32), [[DEF]](p3) :: (volatile store 4 into `float addrspace(3)* undef`, addrspace 3)
  ; CHECK:   G_STORE [[EVEC2]](s32), [[DEF]](p3) :: (volatile store 4 into `float addrspace(3)* undef`, addrspace 3)
  ; CHECK:   G_STORE [[COPY3]](s32), [[COPY5]](p3) :: (volatile store 4 into `i32 addrspace(3)* undef`, addrspace 3)
  ; CHECK:   [[COPY6:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY6]]
  %arg0.0 = extractelement <3 x float> %arg0, i32 0
  %arg0.1 = extractelement <3 x float> %arg0, i32 1
  %arg0.2 = extractelement <3 x float> %arg0, i32 2
  store volatile float %arg0.0, float addrspace(3)* undef
  store volatile float %arg0.1, float addrspace(3)* undef
  store volatile float %arg0.2, float addrspace(3)* undef
  store volatile i32 %arg1, i32 addrspace(3)* undef
  ret void
}

define void @void_func_v3i32_wasted_reg(<3 x i32> %arg0, i32 %arg1) #0 {
  ; CHECK-LABEL: name: void_func_v3i32_wasted_reg
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<3 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32)
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; CHECK:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; CHECK:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 2
  ; CHECK:   [[DEF:%[0-9]+]]:_(p3) = G_IMPLICIT_DEF
  ; CHECK:   [[EVEC:%[0-9]+]]:_(s32) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<3 x s32>), [[C]](s32)
  ; CHECK:   [[EVEC1:%[0-9]+]]:_(s32) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<3 x s32>), [[C1]](s32)
  ; CHECK:   [[EVEC2:%[0-9]+]]:_(s32) = G_EXTRACT_VECTOR_ELT [[BUILD_VECTOR]](<3 x s32>), [[C2]](s32)
  ; CHECK:   G_STORE [[EVEC]](s32), [[DEF]](p3) :: (volatile store 4 into `i32 addrspace(3)* undef`, addrspace 3)
  ; CHECK:   G_STORE [[EVEC1]](s32), [[DEF]](p3) :: (volatile store 4 into `i32 addrspace(3)* undef`, addrspace 3)
  ; CHECK:   G_STORE [[EVEC2]](s32), [[DEF]](p3) :: (volatile store 4 into `i32 addrspace(3)* undef`, addrspace 3)
  ; CHECK:   G_STORE [[COPY3]](s32), [[DEF]](p3) :: (volatile store 4 into `i32 addrspace(3)* undef`, addrspace 3)
  ; CHECK:   [[COPY5:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY4]]
  ; CHECK:   S_SETPC_B64_return [[COPY5]]
  %arg0.0 = extractelement <3 x i32> %arg0, i32 0
  %arg0.1 = extractelement <3 x i32> %arg0, i32 1
  %arg0.2 = extractelement <3 x i32> %arg0, i32 2
  store volatile i32 %arg0.0, i32 addrspace(3)* undef
  store volatile i32 %arg0.1, i32 addrspace(3)* undef
  store volatile i32 %arg0.2, i32 addrspace(3)* undef
  store volatile i32 %arg1, i32 addrspace(3)* undef
  ret void
}

; Check there is no crash.
define void @void_func_v16i8(<16 x i8> %arg0) #0 {
  ; CHECK-LABEL: name: void_func_v16i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(s16) = G_TRUNC [[COPY]](s32)
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[TRUNC1:%[0-9]+]]:_(s16) = G_TRUNC [[COPY1]](s32)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[TRUNC2:%[0-9]+]]:_(s16) = G_TRUNC [[COPY2]](s32)
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[TRUNC3:%[0-9]+]]:_(s16) = G_TRUNC [[COPY3]](s32)
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[TRUNC4:%[0-9]+]]:_(s16) = G_TRUNC [[COPY4]](s32)
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[TRUNC5:%[0-9]+]]:_(s16) = G_TRUNC [[COPY5]](s32)
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[TRUNC6:%[0-9]+]]:_(s16) = G_TRUNC [[COPY6]](s32)
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[TRUNC7:%[0-9]+]]:_(s16) = G_TRUNC [[COPY7]](s32)
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[TRUNC8:%[0-9]+]]:_(s16) = G_TRUNC [[COPY8]](s32)
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[TRUNC9:%[0-9]+]]:_(s16) = G_TRUNC [[COPY9]](s32)
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[TRUNC10:%[0-9]+]]:_(s16) = G_TRUNC [[COPY10]](s32)
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[TRUNC11:%[0-9]+]]:_(s16) = G_TRUNC [[COPY11]](s32)
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[TRUNC12:%[0-9]+]]:_(s16) = G_TRUNC [[COPY12]](s32)
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[TRUNC13:%[0-9]+]]:_(s16) = G_TRUNC [[COPY13]](s32)
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[TRUNC14:%[0-9]+]]:_(s16) = G_TRUNC [[COPY14]](s32)
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[TRUNC15:%[0-9]+]]:_(s16) = G_TRUNC [[COPY15]](s32)
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<16 x s16>) = G_BUILD_VECTOR [[TRUNC]](s16), [[TRUNC1]](s16), [[TRUNC2]](s16), [[TRUNC3]](s16), [[TRUNC4]](s16), [[TRUNC5]](s16), [[TRUNC6]](s16), [[TRUNC7]](s16), [[TRUNC8]](s16), [[TRUNC9]](s16), [[TRUNC10]](s16), [[TRUNC11]](s16), [[TRUNC12]](s16), [[TRUNC13]](s16), [[TRUNC14]](s16), [[TRUNC15]](s16)
  ; CHECK:   [[TRUNC16:%[0-9]+]]:_(<16 x s8>) = G_TRUNC [[BUILD_VECTOR]](<16 x s16>)
  ; CHECK:   [[COPY16:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   G_STORE [[TRUNC16]](<16 x s8>), [[DEF]](p1) :: (volatile store 16 into `<16 x i8> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY17:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY16]]
  ; CHECK:   S_SETPC_B64_return [[COPY17]]
  store volatile <16 x i8> %arg0, <16 x i8> addrspace(1)* undef
  ret void
}

; Check there is no crash.
define void @void_func_v32i32_v16i8(<32 x i32> %arg0, <16 x i8> %arg1) #0 {
  ; CHECK-LABEL: name: void_func_v32i32_v16i8
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4, $vgpr5, $vgpr6, $vgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $sgpr30_sgpr31
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $vgpr0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY $vgpr1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(s32) = COPY $vgpr2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $vgpr3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(s32) = COPY $vgpr4
  ; CHECK:   [[COPY5:%[0-9]+]]:_(s32) = COPY $vgpr5
  ; CHECK:   [[COPY6:%[0-9]+]]:_(s32) = COPY $vgpr6
  ; CHECK:   [[COPY7:%[0-9]+]]:_(s32) = COPY $vgpr7
  ; CHECK:   [[COPY8:%[0-9]+]]:_(s32) = COPY $vgpr8
  ; CHECK:   [[COPY9:%[0-9]+]]:_(s32) = COPY $vgpr9
  ; CHECK:   [[COPY10:%[0-9]+]]:_(s32) = COPY $vgpr10
  ; CHECK:   [[COPY11:%[0-9]+]]:_(s32) = COPY $vgpr11
  ; CHECK:   [[COPY12:%[0-9]+]]:_(s32) = COPY $vgpr12
  ; CHECK:   [[COPY13:%[0-9]+]]:_(s32) = COPY $vgpr13
  ; CHECK:   [[COPY14:%[0-9]+]]:_(s32) = COPY $vgpr14
  ; CHECK:   [[COPY15:%[0-9]+]]:_(s32) = COPY $vgpr15
  ; CHECK:   [[COPY16:%[0-9]+]]:_(s32) = COPY $vgpr16
  ; CHECK:   [[COPY17:%[0-9]+]]:_(s32) = COPY $vgpr17
  ; CHECK:   [[COPY18:%[0-9]+]]:_(s32) = COPY $vgpr18
  ; CHECK:   [[COPY19:%[0-9]+]]:_(s32) = COPY $vgpr19
  ; CHECK:   [[COPY20:%[0-9]+]]:_(s32) = COPY $vgpr20
  ; CHECK:   [[COPY21:%[0-9]+]]:_(s32) = COPY $vgpr21
  ; CHECK:   [[COPY22:%[0-9]+]]:_(s32) = COPY $vgpr22
  ; CHECK:   [[COPY23:%[0-9]+]]:_(s32) = COPY $vgpr23
  ; CHECK:   [[COPY24:%[0-9]+]]:_(s32) = COPY $vgpr24
  ; CHECK:   [[COPY25:%[0-9]+]]:_(s32) = COPY $vgpr25
  ; CHECK:   [[COPY26:%[0-9]+]]:_(s32) = COPY $vgpr26
  ; CHECK:   [[COPY27:%[0-9]+]]:_(s32) = COPY $vgpr27
  ; CHECK:   [[COPY28:%[0-9]+]]:_(s32) = COPY $vgpr28
  ; CHECK:   [[COPY29:%[0-9]+]]:_(s32) = COPY $vgpr29
  ; CHECK:   [[COPY30:%[0-9]+]]:_(s32) = COPY $vgpr30
  ; CHECK:   [[COPY31:%[0-9]+]]:_(s32) = COPY $vgpr31
  ; CHECK:   [[BUILD_VECTOR:%[0-9]+]]:_(<32 x s32>) = G_BUILD_VECTOR [[COPY]](s32), [[COPY1]](s32), [[COPY2]](s32), [[COPY3]](s32), [[COPY4]](s32), [[COPY5]](s32), [[COPY6]](s32), [[COPY7]](s32), [[COPY8]](s32), [[COPY9]](s32), [[COPY10]](s32), [[COPY11]](s32), [[COPY12]](s32), [[COPY13]](s32), [[COPY14]](s32), [[COPY15]](s32), [[COPY16]](s32), [[COPY17]](s32), [[COPY18]](s32), [[COPY19]](s32), [[COPY20]](s32), [[COPY21]](s32), [[COPY22]](s32), [[COPY23]](s32), [[COPY24]](s32), [[COPY25]](s32), [[COPY26]](s32), [[COPY27]](s32), [[COPY28]](s32), [[COPY29]](s32), [[COPY30]](s32), [[COPY31]](s32)
  ; CHECK:   [[FRAME_INDEX:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.15
  ; CHECK:   [[LOAD:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX]](p5) :: (invariant load 2 from %fixed-stack.15, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX1:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.14
  ; CHECK:   [[LOAD1:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX1]](p5) :: (invariant load 2 from %fixed-stack.14, align 4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX2:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.13
  ; CHECK:   [[LOAD2:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX2]](p5) :: (invariant load 2 from %fixed-stack.13, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX3:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.12
  ; CHECK:   [[LOAD3:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX3]](p5) :: (invariant load 2 from %fixed-stack.12, align 4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX4:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.11
  ; CHECK:   [[LOAD4:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX4]](p5) :: (invariant load 2 from %fixed-stack.11, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX5:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.10
  ; CHECK:   [[LOAD5:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX5]](p5) :: (invariant load 2 from %fixed-stack.10, align 4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX6:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.9
  ; CHECK:   [[LOAD6:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX6]](p5) :: (invariant load 2 from %fixed-stack.9, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX7:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.8
  ; CHECK:   [[LOAD7:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX7]](p5) :: (invariant load 2 from %fixed-stack.8, align 4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX8:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.7
  ; CHECK:   [[LOAD8:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX8]](p5) :: (invariant load 2 from %fixed-stack.7, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX9:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.6
  ; CHECK:   [[LOAD9:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX9]](p5) :: (invariant load 2 from %fixed-stack.6, align 4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX10:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.5
  ; CHECK:   [[LOAD10:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX10]](p5) :: (invariant load 2 from %fixed-stack.5, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX11:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.4
  ; CHECK:   [[LOAD11:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX11]](p5) :: (invariant load 2 from %fixed-stack.4, align 4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX12:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.3
  ; CHECK:   [[LOAD12:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX12]](p5) :: (invariant load 2 from %fixed-stack.3, align 16, addrspace 5)
  ; CHECK:   [[FRAME_INDEX13:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.2
  ; CHECK:   [[LOAD13:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX13]](p5) :: (invariant load 2 from %fixed-stack.2, align 4, addrspace 5)
  ; CHECK:   [[FRAME_INDEX14:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.1
  ; CHECK:   [[LOAD14:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX14]](p5) :: (invariant load 2 from %fixed-stack.1, align 8, addrspace 5)
  ; CHECK:   [[FRAME_INDEX15:%[0-9]+]]:_(p5) = G_FRAME_INDEX %fixed-stack.0
  ; CHECK:   [[LOAD15:%[0-9]+]]:_(s16) = G_LOAD [[FRAME_INDEX15]](p5) :: (invariant load 2 from %fixed-stack.0, align 4, addrspace 5)
  ; CHECK:   [[BUILD_VECTOR1:%[0-9]+]]:_(<16 x s16>) = G_BUILD_VECTOR [[LOAD]](s16), [[LOAD1]](s16), [[LOAD2]](s16), [[LOAD3]](s16), [[LOAD4]](s16), [[LOAD5]](s16), [[LOAD6]](s16), [[LOAD7]](s16), [[LOAD8]](s16), [[LOAD9]](s16), [[LOAD10]](s16), [[LOAD11]](s16), [[LOAD12]](s16), [[LOAD13]](s16), [[LOAD14]](s16), [[LOAD15]](s16)
  ; CHECK:   [[TRUNC:%[0-9]+]]:_(<16 x s8>) = G_TRUNC [[BUILD_VECTOR1]](<16 x s16>)
  ; CHECK:   [[COPY32:%[0-9]+]]:sgpr_64 = COPY $sgpr30_sgpr31
  ; CHECK:   [[DEF:%[0-9]+]]:_(p1) = G_IMPLICIT_DEF
  ; CHECK:   [[COPY33:%[0-9]+]]:_(p1) = COPY [[DEF]](p1)
  ; CHECK:   G_STORE [[BUILD_VECTOR]](<32 x s32>), [[DEF]](p1) :: (volatile store 128 into `<32 x i32> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   G_STORE [[TRUNC]](<16 x s8>), [[COPY33]](p1) :: (volatile store 16 into `<16 x i8> addrspace(1)* undef`, addrspace 1)
  ; CHECK:   [[COPY34:%[0-9]+]]:ccr_sgpr_64 = COPY [[COPY32]]
  ; CHECK:   S_SETPC_B64_return [[COPY34]]
  store volatile <32 x i32> %arg0, <32 x i32> addrspace(1)* undef
  store volatile <16 x i8> %arg1, <16 x i8> addrspace(1)* undef
  ret void
}

attributes #0 = { nounwind }
